﻿function displayDataInTableAndBox(data, colorScheme) {
    $("#noOfStoreExtendedHour").html("");
    $("#noOfStoreReducedHour").html("");
    $("#expectedIncreaseInFootfall").html("");
    $("#expectedSavedLaborHour").html("");
    $("#branchesTableContent").empty();
    $("#branchesTable").show();
    $("#tableNotice").show();
    var branch = data.series[0].data;

    for (var i = 0; i < branch.length ; i++) {
        var brachname = branch[i].branchName;
        var extendedHour = branch[i].extendedHour != 0 ? branch[i].extendedHour < 0 ? "<font style='color: " + colorScheme.chart.arrow.down + ";'>" + branch[i].extendedHour.toFixed(2) + "h</font>" : "<font style='color: " + colorScheme.chart.arrow.up + ";'>+" + branch[i].extendedHour.toFixed(2) + "h</font>" : "-";
        var expectedFF = branch[i].expectedIncreaseInFF.toFixed(2) != 0 ? "<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i> " + branch[i].expectedIncreaseInFF.toFixed(2) + "%" : "-";;
        var expectedSavedLabour = branch[i].expectedSavedLabourHour.toFixed(2) != 0 ? "<font style='color: " + colorScheme.chart.arrow.up + ";'>+" + branch[i].expectedSavedLabourHour.toFixed(2) + "h</font>" : "N/A";

        var missingOppBox = "";
        var missingOpp = branch[i].missingOpportunity;
        for (var j = 0; j < missingOpp.length; j++) {
            if (missingOpp[j] == "Blank") {
                missingOppBox = missingOppBox + '<i class="fa fa-stop blank-hour-box" aria-hidden="true"></i>';
            }
            else if (missingOpp[j] == "Remain") {
                missingOppBox = missingOppBox + '<i class="fa fa-stop current-operating-hour-box" aria-hidden="true"></i>';
            }
            else if (missingOpp[j] == "Extended") {
                missingOppBox = missingOppBox + '<i class="fa fa-stop extended-hour-box" aria-hidden="true"></i>';
            }
            else if (missingOpp[j] == "Reduced") {
                missingOppBox = missingOppBox + '<i class="fa fa-stop reduced-hour-box" aria-hidden="true"></i>';
            }
        }

        $("#branchesTable").append("<tr><td>" + (i + 1) + "</td><td class='text-left'>" + brachname + "</td><td>" +
            extendedHour + "</td><td>" + expectedFF + "</td><td>" + expectedSavedLabour + "</td><td><div class='missing-opportunity-column'>" + missingOppBox + "</div></td></tr>");
    }

    var noOfStoreExtended = data.series[1].noOfStoreExtendedHour;
    noOfStoreExtended = noOfStoreExtended != 0 ? noOfStoreExtended > 1 ? noOfStoreExtended + " " + LanguageStores + "" : noOfStoreExtended + " " + LanguageStore + "" : "-";
    var noOfStoreReduced = data.series[1].noOfStoreReducedHour;
    noOfStoreReduced = noOfStoreReduced != 0 ? noOfStoreReduced > 1 ? noOfStoreReduced + " " + LanguageStores + "" : noOfStoreReduced + " " + LanguageStore + "" : "-";
    var averageIncreaseFF = data.series[1].expectedIncreaseInFF;
    averageIncreaseFF = averageIncreaseFF != 0 ? "<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i> " + averageIncreaseFF.toFixed(2) + "%" : "-";
    var totalSavedLabour = data.series[1].expectedSavedLabourHour;
    totalSavedLabour = totalSavedLabour != 0 ? totalSavedLabour > 1 ? totalSavedLabour + " " + Languagehours + "" : totalSavedLabour + " " + Languagehour1 + "" : "-";

    $("#noOfStoreExtendedHour").append(noOfStoreExtended);
    $("#noOfStoreReducedHour").append(noOfStoreReduced);
    $("#expectedIncreaseInFootfall").append(averageIncreaseFF);
    $("#expectedSavedLaborHour").append(totalSavedLabour);
}
