function returnWeek(d, financialWeekDate, dateFormat) {
    // Create a copy of this date object
    var splitDate;
    var fdate;
    var fmonth;
    var fyear;
    var target = new Date(d.split("/")[2], d.split("/")[1] - 1, d.split("/")[0]);
    d = new Date(d.split("/")[2], d.split("/")[1] - 1, d.split("/")[0]);
    // ISO week date weeks start on monday
    // so correct the day number
    var tmpGetDay = d.getDay();
    //console.log(tmpGetDay);
    var dayNr;
    if (d.getDay() == 6) {
        dayNr = (d.getDay() + 1) % 7;
        //console.log(dayNr);
        target.setDate(target.getDate() - dayNr);
        //console.log(target);
    } else if (d.getDay() == 0) {
        dayNr = (d.getDay() + 7) % 7;
        target.setDate(target.getDate() - dayNr);
    } else if (d.getDay() == 5) {
        dayNr = (d.getDay() + 2) % 7;
        target.setDate(target.getDate() - dayNr);
    }
    else {
        dayNr = (d.getDay() + 6) % 7;
        target.setDate(target.getDate() - dayNr);
    }
    //set firstdayofweek
    if (firstDayOfWeek == "Sunday") {
        fdayofweek = 3;
    }
    else if (firstDayOfWeek == "Saturday") {
        fdayofweek = 2;
    }
    else if (firstDayOfWeek == "Monday") {
        fdayofweek = 4;
    } else {
        fdayofweek = 1;
    }
    // Set the target to the thursday of this week so the
    // target date is in the right year
    // ISO 8601 states that week 1 is the week
    // with january 4th in it
    // if financialweekdate is default, skip
    splitDate = financialWeekDate.split("/");
    //set month or date first
    if (dateFormat == "monthFirst") {
        fdate = splitDate[1];
        fmonth = splitDate[0] - 1;
    }
    else {
        fdate = splitDate[0];
        fmonth = splitDate[1] - 1;
    }
    var jan4 = new Date(target.getFullYear(), fmonth, fdate);
    //compare the year when change the financialweek dynamically
    fyear = jan4 > target ? target.getFullYear() - 1 : target.getFullYear();
    var newjan4 = new Date(fyear, fmonth, fdate);
    var intdate = parseInt(fdate);
    //console.log(newjan4.getDay());
    var newjan5 = newjan4.setMonth(fmonth, intdate + ((fdayofweek - newjan4.getDay()) + 7) % 7);
    //console.log(newjan4);
    // Number of days between target date and january 4th
    var dayDiff = (target - newjan5) / 86400000;
    // Calculate week number: Week 1 (january 4th) plus the
    // number of weeks between target date and january 4th
    var weekNr = 1 + Math.ceil(dayDiff / 7);
    //find the date that + 7 days
    target.setDate(target.getDate() + 7);
    var jan41 = new Date(target.getFullYear(), fmonth, fdate);
    fyear = jan41 > target ? target.getFullYear() - 1 : target.getFullYear();
    var newjan41 = new Date(fyear, fmonth, fdate);
    var intdate = parseInt(fdate);
    var jan5 = newjan41.setMonth(fmonth, intdate + ((fdayofweek - newjan41.getDay()) + 7) % 7);
    var dayDiff1 = (target - jan5) / 86400000;
    var weekNr1 = 1 + Math.ceil(dayDiff1 / 7);
    //to change the week into 1
    if (weekNr == 53) {
        if (weekNr1 == 2 || weekNr1 == 54) {
            weekNr = 1;
        }
    }
    var dayDiff1 = (target - jan5) / 86400000;
    var weekNr1 = 1 + Math.ceil(dayDiff1 / 7);
    return weekNr;
}

function returnWeekNew(d, financialWeekDate, dateFormat) {
    // Create a copy of this date object
    var splitDate = new moment(financialWeekDate, dateFormat);
    var fdate = splitDate.date();
    var fmonth = splitDate.month();
    var fyear;
    var target;
    // ISO week date weeks start on monday
    // so correct the day number
    var tmpGetDay = d.day();
    //console.log(tmpGetDay);
    var dayNr;
    if (d.day() == 6) {
        dayNr = (d.day() + 1) % 7;
    } else if (d.day() == 0) {
        dayNr = (d.day() + 7) % 7;
    } else if (d.day() == 5) {
        dayNr = (d.day() + 2) % 7;
    } else {
        dayNr = (d.day() + 6) % 7;
    }

    target = d.subtract(dayNr, 'd');
    //set firstdayofweek
    if (firstDayOfWeek == "Sunday") {
        fdayofweek = 3;
    }
    else if (firstDayOfWeek == "Saturday") {
        fdayofweek = 2;
    }
    else if (firstDayOfWeek == "Monday") {
        fdayofweek = 4;
    } else {
        fdayofweek = 1;
    }

    var jan4 = new moment(new Date(target.year(), fmonth, fdate));
    //compare the year when change the financialweek dynamically
    fyear = jan4 > target ? target.year() - 1 : target.year();
    var newjan4 = new moment(new Date(fyear, fmonth, fdate));
    var intdate = parseInt(fdate);
    //console.log(newjan4.getDay());

    var daytoAdd = intdate + ((fdayofweek - newjan4.day()) + 7) % 7;

    var newjan5 = newjan4.month(fmonth).date(daytoAdd);
    //console.log(newjan4);
    // Number of days between target date and january 4th
    var dayDiff = target.diff(newjan5) / 86400000;
    // Calculate week number: Week 1 (january 4th) plus the
    // number of weeks between target date and january 4th
    var weekNr = 1 + Math.ceil(dayDiff / 7);
    //find the date that + 7 days
    target.add(7, 'd');
    var jan41 = new moment(new Date(target.year(), fmonth, fdate));
    fyear = jan41 > target ? target.year() - 1 : target.year();
    var newjan41 = new moment(new Date(fyear, fmonth, fdate));
    var intdate = parseInt(fdate);
    var jan5 = newjan41.month(fmonth).date(intdate + ((fdayofweek - newjan41.day()) + 7) % 7);
    var dayDiff1 = target.diff(jan5) / 86400000;
    var weekNr1 = 1 + Math.ceil(dayDiff1 / 7);
    //to change the week into 1
    if (weekNr == 53) {
        if (weekNr1 == 2 || weekNr1 == 54) {
            weekNr = 1;
        }
    }
    return weekNr;
}

//original copy
//function returnWeek(d) {

//    // Create a copy of this date object
//    var target = new Date(d.split("/")[2], d.split("/")[1] - 1, d.split("/")[0]);
//    d = new Date(d.split("/")[2], d.split("/")[1] - 1, d.split("/")[0]);

//    // ISO week date weeks start on monday
//    // so correct the day number
//    var dayNr = (d.getDay() + 6) % 7;

//    // Set the target to the thursday of this week so the
//    // target date is in the right year
//    target.setDate(target.getDate() - dayNr + 3);

//    // ISO 8601 states that week 1 is the week
//    // with january 4th in it
//    var jan4 = new Date(target.getFullYear(), 0, 4);

//    // Number of days between target date and january 4th
//    var dayDiff = (target - jan4) / 86400000;

//    // Calculate week number: Week 1 (january 4th) plus the
//    // number of weeks between target date and january 4th
//    var weekNr = 1 + Math.ceil(dayDiff / 7);

//    return weekNr;

//}
//togfgle datepicker on and off in analytic page
function toggleDatePicker(dateRangeType) {
    if (dateRangeType == "today" || dateRangeType == "yesterday" || dateRangeType == "last7Days" || dateRangeType == "last30Days" || dateRangeType == "allTime" || dateRangeType == "thisMonth" || dateRangeType == "lastMonth" || dateRangeType == "thisWeek" || dateRangeType == "lastWeek") {
        $("#startDate").attr('disabled', true);
        $("#endDate").attr('disabled', true);
        $("#startDate").css('background-color', '#DEDEDE');
        $("#endDate").css('background-color', '#DEDEDE');
    } else {
        $("#startDate").attr('disabled', false);
        $("#endDate").attr('disabled', false);
        $("#startDate").css('background-color', '#ffffff');
        $("#endDate").css('background-color', '#ffffff');
    }
}

//return today date in javascript format
function returnTodayDate() {
    var todayDate = new Date();
    var dd = todayDate.getDate();
    var mm = todayDate.getMonth() + 1;
    var yyyy = todayDate.getFullYear();

    if (dd < 10) {
        dd = '0' + dd
    }

    if (mm < 10) {
        mm = '0' + mm
    }

    todayDate = dd + "/" + mm + "/" + yyyy;
    //console.log(todayDate);

    return todayDate;
}

function returnTodayDateNew() {
    return new moment().startOf('day');
}

//return UK date format date
function returnSpecificDate(date) {
    var date = date;
    var dd = date.getDate();
    var mm = date.getMonth() + 1;
    var year = date.getFullYear();

    if (dd < 10) {
        dd = '0' + dd
    }

    if (mm < 10) {
        mm = '0' + mm
    }

    var formattedDate = dd + "/" + mm + "/" + year;

    //console.log(day, monthNames[monthIndex], year);
    return formattedDate;
}

//return javascript date format
function convertToDateFormat(date) {
    var tempD = date.split("/");
    var tempDate = new Date(tempD[2], (tempD[1] - 1), tempD[0]);

    return tempDate;
}

function minus1DayDate(date) {
    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 1);
    pld = returnSpecificDate(pld);
    return pld;
}

function minusNDayDate(date, dayToMinus) {
    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - dayToMinus);
    pld = returnSpecificDate(pld);
    return pld;
}

function minus7DaysDate(date) {
    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 7);
    pld = returnSpecificDate(pld);
    return pld;
}

function minus7DaysDateNew(date) {
    return date.subtract(7, 'd');
}

function minus7DaysDateWDateFormat(date, dateFormat) {
    var passLastDate = date.split("/");
    if (dateFormat == 'monthFirst') {
        var pld = new Date(parseInt((passLastDate[1] - 1)), parseInt(passLastDate[2]), parseInt(passLastDate[0]));
    }
    else {
        var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    }
    pld.setDate(pld.getDate() - 7);
    pld = returnSpecificDate(pld);
    return pld;
}

function add7DaysDate(date) {
    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 7);

    return pld;
}

function add6DaysDate(date) {
    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 6);
    pld = returnSpecificDate(pld);
    return pld;
}

function minus30DaysDate() {
    var getLastDate = $('#datePickerDateRange').val().split(" - ")[1] == undefined ? $('#datePickerDateRange').val().split(" - ")[0] : $('#datePickerDateRange').val().split(" - ")[1];
    var passLastDate = getLastDate.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 30);

    return pld;
}

function add30DaysDate(date) {
    //var getLastDate = $('#datePickerDateRange').val().split(" - ")[1] == undefined ? $('#datePickerDateRange').val().split(" - ")[0] : $('#datePickerDateRange').val().split(" - ")[1];
    //var passLastDate = getLastDate.split("/");
    //var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    //pld.setDate(pld.getDate() + 30);

    //return pld;

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 30);
    pld = returnSpecificDate(pld);
    return pld;
}

function minus30Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 30);
    pld = returnSpecificDate(pld);
    return pld;
}

function add29Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 29);
    pld = returnSpecificDate(pld);
    return pld;
}

function minus2Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 2);
    pld = returnSpecificDate(pld);
    return pld;
}

function add2Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 2);
    pld = returnSpecificDate(pld);
    return pld;
}

function addNDays(date, day) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + day);
    pld = returnSpecificDate(pld);
    return pld;
}


function minus7Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() - 7);
    pld = returnSpecificDate(pld);
    return pld;
}

function add7Days(date) {

    var passLastDate = date.split("/");
    var pld = new Date(parseInt(passLastDate[2]), parseInt((passLastDate[1] - 1)), parseInt(passLastDate[0]));
    pld.setDate(pld.getDate() + 7);
    pld = returnSpecificDate(pld);
    return pld;
}

function convertDate(inputFormat) {
  function pad(s) { return (s < 10) ? '0' + s : s; }
  var d = new Date(inputFormat);
  return [pad(d.getDate()), pad(d.getMonth()+1), d.getFullYear()].join('/');
}

function convertDateToMonth(d) {
    var getD = d.split("/");
    getD = getD[1] + "/" + getD[0] + "/" + getD[2];
    return getD;

}

function convertMonthToDate(d) {
    var getD = d.split("/");
    getD = getD[1] + "/" + getD[0] + "/" + getD[2];
    return getD;
}

function getWeekRange(d, financialWeekDate, dateFormat) {
    var firstWeekDay = d;
    var lastWeekDay = add6DaysDate(firstWeekDay);
    var weekNumber = returnWeek(firstWeekDay, financialWeekDate, dateFormat);
    return [firstWeekDay, lastWeekDay, weekNumber];
}

function getWeekRangeNew(d, financialWeekDate, dateFormat) {
    var firstWeekDay = new moment(d);
    var lastWeekDay = new moment(moment(d).add(6, 'd'));
    var weekNumber = returnWeekNew(d, financialWeekDate, dateFormat);
    return [firstWeekDay, lastWeekDay, weekNumber];
}

function getMonthRange(d) {
    var firstMonthDay = d;
    var lastMonthDay = add29Days(firstMonthDay);
    var weekNumber = returnWeek(firstMonthDay, financialWeekDate, dateFormat);
    return [firstMonthDay, lastMonthDay, weekNumber];
}

function getMondayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -6 : 1); // adjust when day is sunday
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getTuesdayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -5 : day == 1 ? -5 : 2);
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getWednesdayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -4 : day == 1 ? -4 : day == 2 ? -4 : 3);

    //console.log("d.getDate() - day: " + (d.getDate() - day));
    //console.log("d.getDate(): " + d.getDate());
    //console.log("day: " + day);
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getThursdayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -3 : day == 1 ? -3 : day == 2 ? -3 : day == 3 ? -3 : 4);
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getFridayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -2 : day == 1 ? -2 : day == 2 ? -2 : day == 3 ? -2 : day == 4 ? -2 : 5);
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getSaturdayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 0 ? -1 : day == 1 ? -1 : day == 2 ? -1 : day == 3 ? -1 : day == 4 ? -1 : day == 5 ? -1 : 6);
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));

    return result;
}

function getSundayJDate(d) {
    d = convertToDateFormat(d);
    if (d == null) {
        d = new Date();
    } else {
        d = d;
    }
    var day = d.getDay(),
        diff = d.getDate() - day + (day == 1 ? -0 : 0);
    //console.log(new Date(d.setDate(diff)));
    var result = returnSpecificDate(new Date(d.setDate(diff)));
    return result;
}

//company wide and store wide week picker
function declareWeekPicker(companyCode) {




}


//analytic page datepicker
//declare datepicker after it has been removed
function reCreateDatePicker(fd, td, passFirstDayOfWeek, passDateFormat, passFinancialWeek) {
    var firstDayOfWeek = passFirstDayOfWeek;
    //var dateFormat = passDateFormat;
    //var financialWeekDate = passFinancialWeek;
    //console.log(fd);
    //console.log(td);
    var r;
    var firstDaySetting = firstDayOfWeek; //this will be depend on the first day of the week setting from company setting page (dynamic instead of hardcode)
    if (firstDaySetting == "Monday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log();
    } else if (firstDaySetting == "Tuesday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Wednesday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Thursday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Friday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Saturday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    }
    else {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    }
    //if (dateFormat == "monthFirst") {
    //    $('#datePickerDateRange').val(convertDateToMonth(r[0]) + " - " + convertDateToMonth(r[1]));
    //} else {
    //    $('#datePickerDateRange').val(r[0] + " - " + r[1]);
    //}

    var tempWeekStart = firstDaySetting == "Monday" ? 1 : firstDaySetting == "Tuesday" ? 2 : firstDaySetting == "Wednesday" ? 3 : firstDaySetting == "Thursday" ? 4 : firstDaySetting == "Friday" ? 5 : firstDaySetting == "Saturday" ? 6 : 0;
    var tempDF = dateFormat == "dateFirst" ? "dd/mm/yyyy" : dateFormat == "monthFirst" ? "mm/dd/yyyy" : dateFormat == null ? "dd/mm/yyyy" : "dd/mm/yyyy";

    var tempEndDate;
    //if (dateFormat == "monthFirst") {
    //    var ted = r[1].split("/");
    //    tempEndDate = new Date(ted[2], ted[0] - 1, ted[1]);
    //    tempEndDate = returnSpecificDate(tempEndDate);
    //} else {
    //    var ted = r[1].split("/");
    //    tempEndDate = new Date(ted[2], ted[1] - 1, ted[0]);
    //    tempEndDate = returnSpecificDate(tempEndDate);
    //}
    var ted = r[1].split("/");
    tempEndDate = new Date(ted[2], ted[0] - 1, ted[1]);
    tempEndDate = returnSpecificDate(tempEndDate);
    $("#datePicker").datepicker('remove');
    $('#datePicker').datepicker({
        format: tempDF,
        endDate: tempEndDate,
        //todayHighlight: true,
        weekStart: tempWeekStart,
        todayBtn: "linked",
        multidate: 2,
        multidateSeparator: " - ",
        calendarWeeks: true
    })

    .on('changeDate', function () {
        var tempSelectedDate = $('#datePickerDateRange').val();
        var selectedDate;
        selectedDate = tempSelectedDate;
        //console.log(tempSelectedDate);


        if (selectedDate.length > 10) {
            //if (dateFormat == "monthFirst") {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(convertDateToMonth(tempSelectedDate1) + " - " + convertDateToMonth(tempSelectedDate2));


            //} else {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    //console.log(tempSelectedDate1 + " - " + tempSelectedDate2);
            //    $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);

            //}

            var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            var tsd1 = getDatepickerVal[0].split("/");
            var tsd2 = getDatepickerVal[1].split("/");
            tempSelectedDate1 = new Date(tsd1[2], tsd1[0] - 1, tsd1[1]);
            tempSelectedDate2 = new Date(tsd2[2], tsd2[0] - 1, tsd2[1]);
            tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //console.log(tempSelectedDate1 + " - " + tempSelectedDate2);
            if (dateFormat == "monthFirst") {
                tempSelectedDate1 = convertDateToMonth(tempSelectedDate1);
                tempSelectedDate2 = convertDateToMonth(tempSelectedDate2);
            }
            //$('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);
        }
        if (fd != null && td != null) {
            if (dateFormat == "monthFirst") {
                fromDate = convertDateToMonth(fd);
                toDate = convertDateToMonth(td);
                weekNumber = returnWeek(convertDateToMonth(td), financialWeekDate, dateFormat);
            } else {
                fromDate = fd;
                toDate = td;
                weekNumber = returnWeek(td, financialWeekDate, dateFormat);
            }

        } else {
            fromDate = r[0];
            toDate = r[1];
            weekNumber = r[2];
        }

    })

    .on('hide', function () {
        if ($("#datePickerDateRange").val() != "" && $("#datePickerDateRange").val().length > 10) {
            //if (dateFormat == "monthFirst") {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(convertDateToMonth(tempSelectedDate1) + " - " + convertDateToMonth(tempSelectedDate2));


            //} else {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);

            //}
            var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            var tsd1 = getDatepickerVal[0].split("/");
            var tsd2 = getDatepickerVal[1].split("/");
            tempSelectedDate1 = new Date(tsd1[2], tsd1[0] - 1, tsd1[1]);
            tempSelectedDate2 = new Date(tsd2[2], tsd2[0] - 1, tsd2[1]);
            tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            if (dateFormat == "monthFirst") {
                tempSelectedDate1 = convertDateToMonth(tempSelectedDate1);
                tempSelectedDate2 = convertDateToMonth(tempSelectedDate2);
            }
            $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);
        }
        else if ($("#datePickerDateRange").val() == "") {
            $('#datePickerDateRange').val(fromDate + " - " + toDate);
        }
        if (fd != null && td != null) {
            if (dateFormat == "monthFirst") {
                fromDate = convertDateToMonth(fd);
                toDate = convertDateToMonth(td);
                weekNumber = returnWeek(convertDateToMonth(td), financialWeekDate, dateForamt);
            } else {
                fromDate = fd;
                toDate = td;
                weekNumber = returnWeek(td, financialWeekDate, dateFormat);
            }
        } else {
            fromDate = r[0];
            toDate = r[1];
            weekNumber = r[2];
        }

    });


    //set selected startDate
    if (dateFormat == "monthFirst") {
        $("#datePicker").datepicker("setStartDate", new Date(convertDateToMonth(fd)));
        $("#datePicker").datepicker("setEndDate", new Date(convertDateToMonth(td)));
    } else {
        $("#datePicker").datepicker("setStartDate", new Date(fd));
        $("#datePicker").datepicker("setEndDate", new Date(td));
    }
    if (dateFormat == "monthFirst") {
        fromDate = convertDateToMonth(fd);
        toDate = convertDateToMonth(td);
    } else {
        fromDate = fd;
        toDate = td;
    }

    $("#datePickerDateRange").val(fromDate + " - " + toDate);
}

function reCreateDatePickerWithoutMultiDate(fd, passFirstDayOfWeek, passDateFormat, passFinancialWeek) {
    //var dateRangeType = document.getElementById("dateSelector");
    //var dateRangeTypeValue = dateRangeType.options[dateRangeType.selectedIndex].value;

    var firstDayOfWeek = passFirstDayOfWeek;
    var dateFormat = passDateFormat;
    var financialWeekDate = passFinancialWeek;

    var r;
    var firstDaySetting = firstDayOfWeek; //this will be depend on the first day of the week setting from company setting page (dynamic instead of hardcode)
    if (firstDaySetting == "Monday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log();
    } else if (firstDaySetting == "Tuesday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Wednesday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Thursday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Friday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    } else if (firstDaySetting == "Saturday") {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    }
    else {
        r = getWeekRange(minus7DaysDate(returnTodayDate()));
        //console.log(r);
    }
    //if (dateFormat == "monthFirst") {
    //    $('#datePickerDateRange').val(convertDateToMonth(r[0]) + " - " + convertDateToMonth(r[1]));
    //} else {
    //    $('#datePickerDateRange').val(r[0] + " - " + r[1]);
    //}

    var tempWeekStart = firstDaySetting == "Monday" ? 1 : firstDaySetting == "Tuesday" ? 2 : firstDaySetting == "Wednesday" ? 3 : firstDaySetting == "Thursday" ? 4 : firstDaySetting == "Friday" ? 5 : firstDaySetting == "Saturday" ? 6 : 0;
    var tempDF = dateFormat == "dateFirst" ? "dd/mm/yyyy" : dateFormat == "monthFirst" ? "mm/dd/yyyy" : dateFormat == null ? "dd/mm/yyyy" : "dd/mm/yyyy";

    var tempEndDate;
    if (dateFormat == "monthFirst") {
        var ted = r[1].split("/");
        tempEndDate = new Date(ted[2], ted[0] - 1, ted[1]);
        tempEndDate = returnSpecificDate(tempEndDate);
    } else {
        var ted = r[1].split("/");
        tempEndDate = new Date(ted[2], ted[1] - 1, ted[0]);
        tempEndDate = returnSpecificDate(tempEndDate);
    }
    $("#datePicker").datepicker('remove');
    $('#datePicker').datepicker({
        format: tempDF,
        endDate: tempEndDate,
        //todayHighlight: true,
        autoclose: true,
        weekStart: tempWeekStart,
        todayBtn: "linked",
        multidate: 1,
        multidateSeparator: " - ",
        calendarWeeks: true
    })

    .on('changeDate', function () {
        var tempSelectedDate = $('#datePickerDateRange').val();
        var selectedDate;
        selectedDate = tempSelectedDate;
        //console.log(tempSelectedDate);


        if (selectedDate.length > 10) {
            //if (dateFormat == "monthFirst") {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(convertDateToMonth(tempSelectedDate1) + " - " + convertDateToMonth(tempSelectedDate2));


            //} else {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    //console.log(tempSelectedDate1 + " - " + tempSelectedDate2);
            //    $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);

            //}
            var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            var tsd1 = getDatepickerVal[0].split("/");
            var tsd2 = getDatepickerVal[1].split("/");
            tempSelectedDate1 = new Date(tsd1[2], tsd1[0] - 1, tsd1[1]);
            tempSelectedDate2 = new Date(tsd2[2], tsd2[0] - 1, tsd2[1]);
            tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //console.log(tempSelectedDate1 + " - " + tempSelectedDate2);
            if (dateFormat == "monthFirst") {
                tempSelectedDate1 = convertDateToMonth(tempSelectedDate1);
                tempSelectedDate2 = convertDateToMonth(tempSelectedDate2);
            }
            $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);
        }

        fromDate = r[0];
        toDate = r[1];
        weekNumber = r[2];
    })

    .on('hide', function () {
        if ($("#datePickerDateRange").val() != "" && $("#datePickerDateRange").val().length > 10) {
            //if (dateFormat == "monthFirst") {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(convertDateToMonth(tempSelectedDate1) + " - " + convertDateToMonth(tempSelectedDate2));


            //} else {
            //    var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            //    var tsd1 = getDatepickerVal[0].split("/");
            //    var tsd2 = getDatepickerVal[1].split("/");
            //    tempSelectedDate1 = new Date(tsd1[2], tsd1[1] - 1, tsd1[0]);
            //    tempSelectedDate2 = new Date(tsd2[2], tsd2[1] - 1, tsd2[0]);
            //    tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            //    tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            //    $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);

            //}
            var getDatepickerVal = $("#datePickerDateRange").val().split(" - ");
            var tsd1 = getDatepickerVal[0].split("/");
            var tsd2 = getDatepickerVal[1].split("/");
            tempSelectedDate1 = new Date(tsd1[2], tsd1[0] - 1, tsd1[1]);
            tempSelectedDate2 = new Date(tsd2[2], tsd2[0] - 1, tsd2[1]);
            tempSelectedDate1 = returnSpecificDate(tempSelectedDate1);
            tempSelectedDate2 = returnSpecificDate(tempSelectedDate2);
            if (dateFormat == "monthFirst") {
                tempSelectedDate1 = convertDateToMonth(tempSelectedDate1);
                tempSelectedDate2 = convertDateToMonth(tempSelectedDate2);
            }
            $('#datePickerDateRange').val(tempSelectedDate1 + " - " + tempSelectedDate2);
        }
        else if ($("#datePickerDateRange").val() == "") {
            $('#datePickerDateRange').val(fromDate + " - " + toDate);
        }

        fromDate = r[0];
        toDate = r[1];
        weekNumber = r[2];
    });



    //var dates = getDates(dateRangeTypeValue);

    //$('#datePicker').datepicker({
    //    format: "dd/mm/yyyy",
    //    endDate: '-0d',
    //    todayHighlight: true,
    //    format: "dd/mm/yyyy",
    //    weekStart: 1,
    //    autoclose: true,
    //    todayBtn: "linked",
    //    multidate: 1,
    //    multidateSeparator: " - ",
    //    daysOfWeekHighlighted: "0,6",
    //    calendarWeeks: true
    //})

    //.on('hide', function () {

    //    if ($('#datePickerDateRange').val() == "") {
    //        $('#datePickerDateRange').val(fromDate + " - " + fromDate);
    //    } else {
    //        //$('#datePickerDateRange').val(fromDate + " - " + fromDate);

    //    }
    //});


}

//company setting financial week datepicker [Updated by Kelvin 31/1/19]
function declareFinancialWeekDatepicker(fd, df, fnw) {

    var tempFirstDayOfTheWeek = fd;
    var dateFormat = df == "dateFirst" ? "dd/mm/yyyy" : df == "monthFirst" ? "mm/dd/yyyy" : "dd/mm/yyyy";
    var financialWeekDate = fnw == null ? "29/12/2014" : fnw;


    $('#datepicker').datepicker({
        format: dateFormat,
        //maxViewMode: 1,
        weekStart: tempFirstDayOfTheWeek == "Monday" ? 1 : tempFirstDayOfTheWeek == "Tuesday" ? 2 : tempFirstDayOfTheWeek == "Wednesday" ? 3 : tempFirstDayOfTheWeek == "Thursday" ? 4 : tempFirstDayOfTheWeek == "Friday" ? 5 : tempFirstDayOfTheWeek == "Saturday" ? 6 : tempFirstDayOfTheWeek == "Sunday" ? 0 : 1,
        multidate: false,
        multidateSeparator: " - ",
        calendarWeeks: false,
        autoclose: true,
        //todayHighlight: true
        //startDate: new Date(new Date().getFullYear(), 0, 1),
        //endDate: new Date(new Date().getFullYear(), 11, 31)
    });

    $('#datepicker').datepicker('update', financialWeekDate);


    if ($('#selectDateFormat option:selected').val() == "dateFirst") {
        $("#datepicker").attr("placeholder", "dd/mm/yyyy");
    } else {
        $("#datepicker").attr("placeholder", "mm/dd/yyyy");
    }

    $('#selectFirstDay').on('change', function () {
        tempFirstDayOfTheWeek = $("#selectFirstDay").val();
        valueFirstDayOfWeek_Integer = tempFirstDayOfTheWeek == "Monday" ? 1 : tempFirstDayOfTheWeek == "Tuesday" ? 2 : tempFirstDayOfTheWeek == "Wednesday" ? 3 : tempFirstDayOfTheWeek == "Thursday" ? 4 : tempFirstDayOfTheWeek == "Friday" ? 5 : tempFirstDayOfTheWeek == "Saturday" ? 6 : tempFirstDayOfTheWeek == "Sunday" ? 0 : 1;
        $("#datepicker").datepicker('remove');
        $("#datepicker").datepicker({
            format: dateFormat,
            //maxViewMode: 1,
            weekStart: valueFirstDayOfWeek_Integer,
            multidate: false,
            multidateSeparator: "-",
            calendarWeeks: false,
            autoclose: true,
            //todayHighlight: true
            //startDate: new Date(new Date().getFullYear(), 0, 1),
            //endDate: new Date(new Date().getFullYear(), 11, 31)

        });
        //var dayToDisable = [0, 1, 2, 3, 4, 5, 6];
        //dayToDisable.splice(dayToDisable.indexOf(valueFirstDayOfWeek_Integer), 1);
        //$('#datepicker').datepicker('setDaysOfWeekDisabled', dayToDisable);
        //if ($('#datepicker').val() != null && $('#datepicker').val() != "") {
        //    if ($('#datepicker').datepicker('getDate').getDay() != valueFirstDayOfWeek_Integer) {
        //        $('#datepicker').val("");
        //    }
        //}
        $('#datepicker').datepicker('update');
    });



    //change datepicker format if user change the date format
    $("#datePickerContainer").datepicker();
    $("#selectDateFormat").on("change", function () {
        if ($('#datepicker').val() != null && $('#datepicker').val() != "")
            $("#datepicker").val($("#datepicker").val().substring(3, 5) + '/' + $("#datepicker").val().substring(0, 2) + '/' + $("#datepicker").val().substring(6, 10));
        $("#datepicker").datepicker('remove');
        if ($("#selectDateFormat").val() == "dateFirst") {
            valueDateFormat_datepicker = "dd/mm/yyyy";
            $("#datepicker").attr("placeholder", valueDateFormat_datepicker);
        }
        else {
            valueDateFormat_datepicker = "mm/dd/yyyy";
            $("#datepicker").attr("placeholder", valueDateFormat_datepicker);
        }
        $("#datepicker").datepicker({ autoclose: true, format: valueDateFormat_datepicker, todayHighlight: true, weekStart: valueFirstDayOfWeek_Integer });

        //var dayToDisable = [0, 1, 2, 3, 4, 5, 6];
        //dayToDisable.splice(dayToDisable.indexOf(valueFirstDayOfWeek_Integer), 1);
        //$('#datepicker').datepicker('setDaysOfWeekDisabled', dayToDisable);
    });

    //$('#selectDateFormat').on('change', function () {
    //    var currentFinancialWeekDate = $('#datepicker').val();
    //    if (currentFinancialWeekDate != '') {
    //        var d = $('#selectDateFormat option:selected').val();
    //        if (d == "dateFirst") {
    //            $("#datePickerContainer").datepicker('remove');
    //            $("#datePickerContainer").datepicker({
    //                format: "dd/mm/yyyy",
    //                //maxViewMode: 1,
    //                //todayBtn: "linked",
    //                weekStart: tempFirstDayOfTheWeek_Integer,
    //                multidate: false,
    //                multidateSeparator: "-",
    //                calendarWeeks: false,
    //                autoclose: true,
    //                //todayHighlight: true,
    //                //startDate: new Date(new Date().getFullYear(), 0, 1),
    //                //endDate: new Date(new Date().getFullYear(), 11, 31)
    //            })
    //            var splitCurrentFinancialWeekDate = currentFinancialWeekDate.split("/");
    //            //console.log(splitCurrentFinancialWeekDate);
    //            $("#datepicker").attr("placeholder", "dd/mm/yyyy");
    //            $("#datePickerContainer").datepicker("update", new Date(splitCurrentFinancialWeekDate[0] + "/" + splitCurrentFinancialWeekDate[1] + "/" + splitCurrentFinancialWeekDate[2]));
    //        }
    //        else {
    //            $("#datePickerContainer").datepicker('remove');
    //            $("#datePickerContainer").datepicker({
    //                format: "mm/dd/yyyy",
    //                //maxViewMode: 1,
    //                //todayBtn: "linked",
    //                weekStart: tempFirstDayOfTheWeek_Integer,
    //                multidate: false,
    //                multidateSeparator: "-",
    //                calendarWeeks: false,
    //                autoclose: true,
    //                //todayHighlight: true,
    //                //startDate: new Date(new Date().getFullYear(), 0, 1),
    //                //endDate: new Date(new Date().getFullYear(), 11, 31)
    //            })
    //            var splitCurrentFinancialWeekDate = currentFinancialWeekDate.split("/");
    //            //console.log(splitCurrentFinancialWeekDate);
    //            $("#datepicker").attr("placeholder", "mm/dd/yyyy");
    //            $("#datePickerContainer").datepicker("update", new Date(splitCurrentFinancialWeekDate[1] + "/" + splitCurrentFinancialWeekDate[0] + "/" + splitCurrentFinancialWeekDate[2]));
    //        }
    //    } else if ($('#selectDateFormat option:selected').val() == "dateFirst") {
    //        $("#datePickerContainer").datepicker('remove');

    //        $("#datepicker").attr("placeholder", "dd/mm/yyyy");
    //        $("#datePickerContainer").datepicker({
    //            format: "dd/mm/yyyy",
    //            //maxViewMode: 1,
    //            //todayBtn: "linked",
    //            weekStart: tempFirstDayOfTheWeek_Integer,
    //            multidate: false,
    //            multidateSeparator: "-",
    //            calendarWeeks: false,
    //            autoclose: true,
    //            //todayHighlight: true,
    //            //startDate: new Date(new Date().getFullYear(), 0, 1),
    //            //endDate: new Date(new Date().getFullYear(), 11, 31)
    //        })
    //    } else if ($('#selectDateFormat option:selected').val() == "monthFirst") {
    //        $("#datePickerContainer").datepicker('remove');

    //        $("#datepicker").attr("placeholder", "mm/dd/yyyy");
    //        $("#datePickerContainer").datepicker({
    //            format: "mm/dd/yyyy",
    //            //maxViewMode: 1,
    //            //todayBtn: "linked",
    //            weekStart: tempFirstDayOfTheWeek_Integer,
    //            multidate: false,
    //            multidateSeparator: "-",
    //            calendarWeeks: true,
    //            autoclose: true,
    //            //todayHighlight: true,
    //            //startDate: new Date(new Date().getFullYear(), 0, 1),
    //            //endDate: new Date(new Date().getFullYear(), 11, 31)
    //        })
    //    }
    //});
}

//daily datepicker
function declareDailyDatepicker(fd, df, fnw, passTodayDate) {

    var tempFirstDayOfTheWeek = fd;
    var dateFormat = df == "dateFirst" ? "dd/mm/yyyy" : df == "monthFirst" ? "mm/dd/yyyy" : "dd/mm/yyyy";
    var financialWeekDate = fnw == null ? "01/01/2015" : fnw;
    var todayDate = dateFormat == "dd/mm/yyyy" ? passTodayDate : convertDateToMonth(passTodayDate);
    $('#datePickerContainer input').datepicker({
        format: dateFormat,
        weekStart: tempFirstDayOfTheWeek == "Monday" ? 1 : tempFirstDayOfTheWeek == "Tuesday" ? 2 : tempFirstDayOfTheWeek == "Wednesday" ? 3 : tempFirstDayOfTheWeek == "Thursday" ? 4 : tempFirstDayOfTheWeek == "Friday" ? 5 : tempFirstDayOfTheWeek == "Saturday" ? 6 : tempFirstDayOfTheWeek == "Sunday" ? 0 : 1,
        calendarWeeks: true,
        autoclose: true,
        //todayHighlight: true,
        orientation: "bottom auto",
        //startDate: new Date(new Date().getFullYear(), 0, 1),
        endDate: todayDate
    })

    .on('hide', function () {
        //alert($('#datepicker').val());
        var selectedDate = $('#datepicker').val();
        //alert(selectedDate);
        //console.log(weekday[convertToDateFormat(selectedDate).getDay()] + " " + selectedDate);

        var tmpSelectedDate;
        df == "monthFirst" ? tmpSelectedDate = convertDateToMonth(selectedDate) : tmpSelectedDate = selectedDate;

        $('#datepicker').val(weekday[convertToDateFormat(tmpSelectedDate).getDay()] + " " + selectedDate);


    })
    ;
}

//store time comparison report datepicker(multidates picker)
function declareMultiDatesPicker(fd, df, fnw, passEndDate) {
    var tempFirstDayOfTheWeek = fd;
    var dateFormat = df == "dateFirst" ? "dd/mm/yyyy" : df == "monthFirst" ? "mm/dd/yyyy" : "dd/mm/yyyy";
    var financialWeekDate = fnw == null ? "01/01/2015" : fnw;
    var pickerEndDate = dateFormat == "dd/mm/yyyy" ? passEndDate : convertDateToMonth(passEndDate);

    $('#datePickerContainerOne input').datepicker({
        format: dateFormat,
        weekStart: tempFirstDayOfTheWeek == "Monday" ? 1 : tempFirstDayOfTheWeek == "Tuesday" ? 2 : tempFirstDayOfTheWeek == "Wednesday" ? 3 : tempFirstDayOfTheWeek == "Thursday" ? 4 : tempFirstDayOfTheWeek == "Friday" ? 5 : tempFirstDayOfTheWeek == "Saturday" ? 6 : tempFirstDayOfTheWeek == "Sunday" ? 0 : 1,
        calendarWeeks: true,
        autoclose: false,
        orientation: "bottom auto",
        endDate: pickerEndDate,
        multidate: true,
    })

    .on('hide', function () {
        if ($('#datePickerOne').val() == "") {
            $('#datePickerOne').attr('placeholder', "Please select date(s)");
        }
    });

    $('#datePickerContainerTwo input').datepicker({
        format: dateFormat,
        weekStart: tempFirstDayOfTheWeek == "Monday" ? 1 : tempFirstDayOfTheWeek == "Tuesday" ? 2 : tempFirstDayOfTheWeek == "Wednesday" ? 3 : tempFirstDayOfTheWeek == "Thursday" ? 4 : tempFirstDayOfTheWeek == "Friday" ? 5 : tempFirstDayOfTheWeek == "Saturday" ? 6 : tempFirstDayOfTheWeek == "Sunday" ? 0 : 1,
        calendarWeeks: true,
        autoclose: false,
        orientation: "bottom auto",
        endDate: pickerEndDate,
        multidate: true,
    })

    .on('hide', function () {
        if ($('#datePickerTwo').val() == "") {
            $('#datePickerTwo').attr('placeholder', "Please select date(s)");
        }
    });


}

//store weekly standard report datepicker

function getSingleDayText() {
    var urlParams;
    (window.onpopstate = function () {
        var match,
            pl = /\+/g,  // Regex for replacing addition symbol with a space
            search = /([^&=]+)=?([^&]*)/g,
            decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
            query = window.location.search.substring(1);

        urlParams = {};
        while (match = search.exec(query))
            urlParams[decode(match[1])] = decode(match[2]);
    })();
    if (urlParams.d != "" && urlParams.d != undefined && useParameterDate == 0) {
        $("#datepicker").datepicker("update", urlParams.d);
        $("#datepicker").val($("#datepicker").data('datepicker').getFormattedDate('DD dd/mm/yyyy'));
        useParameterDate++;
    }

    var fd = $('#datepicker').val().split(" ")[0];

    if (dateFormat == "monthFirst")
        fd = convertDateToMonth(fd);
    return fd;
}



var useParameterDate = 0;
function getSingleDate() {
    var urlParams;
    (window.onpopstate = function () {
        var match,
            pl = /\+/g,  // Regex for replacing addition symbol with a space
            search = /([^&=]+)=?([^&]*)/g,
            decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
            query = window.location.search.substring(1);

        urlParams = {};
        while (match = search.exec(query))
            urlParams[decode(match[1])] = decode(match[2]);
    })();
    if (urlParams.d != "" && urlParams.d != undefined && useParameterDate == 0) {
        $("#datepicker").datepicker("update", urlParams.d);
        $("#datepicker").val($("#datepicker").data('datepicker').getFormattedDate('DD dd/mm/yyyy'));
        useParameterDate++;
    }

    var fd = $('#datepicker').val().split(" ")[1];

    if (dateFormat == "monthFirst")
        fd = convertDateToMonth(fd);
    return fd;
}

function getWeekRangeDate() {
    
    var weekRange = {};
    var fd = "", td = "";

    weekRange.startDate = fromDate;
    weekRange.endDate = toDate;
    return weekRange;
}
