﻿//--------------General Function--------------//
var thisyearRCValue = 0;

function chartLoading() {
    //loadingChart("countryMap");
    //$("#countryMap").addClass("chartLoading");

    loadingChart("companyMonthlyTrend");
    $("#companyMonthlyTrend").addClass("chartLoading");

    loadingChart("companyWeeklyTrend");
    $("#companyWeeklyTrend").addClass("chartLoading");

    loadingChart("companyDailyTrend");
    $("#companyDailyTrend").addClass("chartLoading");

    loadingChart("companyLastWeekVisitorCountTrend");
    $("#companyLastWeekVisitorCountTrend").addClass("chartLoading");

    loadingChart("companyWeekdaysTrafficProfile");
    $("#companyWeekdaysTrafficProfile").addClass("chartLoading");

    loadingChart("companyWeekendsTrafficProfile");
    $("#companyWeekendsTrafficProfile").addClass("chartLoading");

    loadingChart("companyTurnInRateMonthlyTrend");
    $("#companyTurnInRateMonthlyTrend").addClass("chartLoading");

    loadingChart("companyWeekdaysTurnInRate");
    $("#companyWeekdaysTurnInRate").addClass("chartLoading");

    loadingChart("companyWeekendsTurnInRate");
    $("#companyWeekendsTurnInRate").addClass("chartLoading");

    loadingChart("companyOutsideTraffic");
    $("#companyOutsideTraffic").addClass("chartLoading");

    loadingChart("companyWeekdaysOutsideTraffic");
    $("#companyWeekdaysOutsideTraffic").addClass("chartLoading");

    loadingChart("companyVisitDurationMonthlyTrend");
    $("#companyVisitDurationMonthlyTrend").addClass("chartLoading");

    loadingChart("companyVisitDurationHourlyTrend");
    $("#companyVisitDurationHourlyTrend").addClass("chartLoading");

    loadingChart("companyWeekdaysVisitDuration");
    $("#companyWeekdaysVisitDuration").addClass("chartLoading");

    loadingChart("companyWeekendsVisitDuration");
    $("#companyWeekendsVisitDuration").addClass("chartLoading");

    loadingChart("companyReturningCustomerMonthlyTrend");
    $("#companyReturningCustomerMonthlyTrend").addClass("chartLoading");

    loadingChart("companyReturningCustomer");
    $("#companyReturningCustomer").addClass("chartLoading");

    loadingChart("companyReturningCustomerWeeklyTrend");
    $("#companyReturningCustomerWeeklyTrend").addClass("chartLoading");


    loadingChart("companyWeekendsOutsideTraffic");
    $("#companyWeekendsOutsideTraffic").addClass("chartLoading");

    loadingChart("companyVisitDurationDailyTrend");
    $("#companyVisitDurationDailyTrend").addClass("chartLoading");

    loadingChart("companyThisWeekAverageDurationDonutChart");
    $("#companyThisWeekAverageDurationDonutChart").addClass("chartLoading");
    $('#companyThisWeekAverageDurationDonutChart').css("display", "none");



    loadingChart("companyReturningCustomer");
    $("#newReturningCustomer").addClass("chartLoading");

    loadingChart("companyReturningCustomerDailyTrend");
    $("#companyReturningCustomerDailyTrend").addClass("chartLoading");

    loadingChart("companyThisWeekAverageReturningCustomerDonutChart");
    $("#companyThisWeekAverageReturningCustomerDonutChart").addClass("chartLoading");

    $('#companyVisitDurationDonutChartCenterText').text('');
    $('#companyReturningCustomerDonutChartCenterText').text('');

    loadingChart("companyMonthlySCTrend");
    $("#companyMonthlySCTrend").addClass("chartLoading");

    loadingChart("companyWeeklySCTrend");
    $("#companyWeeklySCTrend").addClass("chartLoading");

    loadingChart("companyDailySCTrend");
    $("#companyDailySCTrend").addClass("chartLoading");

    loadingChart("company7DaysSCTrend");
    $("#company7DaysSCTrend").addClass("chartLoading");

    loadingChart("companyWeekdaysSCTrend");
    $("#companyWeekdaysSCTrend").addClass("chartLoading");

    loadingChart("companyWeekendsSCtrend");
    $("#companyWeekendsSCtrend").addClass("chartLoading");
}

function drawLine(ctx, week, highest) {
    var dataRange = highest;
    var height = 30;
    var x = 0,
        y = (dataRange - week[0]) / dataRange * height; // y = weekdata divide 100 times height * ratio of 4
    for (var i = 1; i < week.length; i++) {
        ctx.beginPath();
        ctx.lineWidth = "1";
        ctx.strokeStyle = "#2182c2";
        ctx.moveTo(x, y);
        x = x + 30;
        y = (dataRange - week[i]) / dataRange * height;
        ctx.lineTo(x, y);
        ctx.stroke();
    }
}

//convert percentage to xxk if more than 999
function kFormatter(num) {
    if (num > 999) {
        return num > 999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    } else if (num < -999) {
        return num < -999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    } else {
        return num > 999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    }
}

function numberWithCommas(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

var weekDay //share to all table
function showDayAndDate(startDate) {
    if (startDate != null) {
        var tempDate = startDate.split("/");
        //console.log(tempDate[2], tempDate[1], tempDate[0]);
        startDate = new Date(tempDate[2], tempDate[1] - 1, tempDate[0] - 1);
        var date = new Array();
        for (var i = 0; i < 7; i++)
            date.push(new Date(startDate.setDate(startDate.getDate() + 1)));
        //console.log(day);
        var day = new Array(7);
        weekDay = new Array(7);
        day[0] = LanguageSun;
        day[1] = LanguageMon;
        day[2] = LanguageTue;
        day[3] = LanguageWed;
        day[4] = LanguageThu;
        day[5] = LanguageFri;
        day[6] = LanguageSat;
        for (var i = 0; i < 7; i++) {
            weekDay[i] = day[date[i].getDay()] + " " + date[i].getDate() + "/" + (date[i].getMonth() + 1);
        }
        return weekDay;
    } else
        return new Array(7);

}



//--------------Report Section--------------//

function bindData(data, colorScheme) {
    //bindtopMatric
    bindTopMatric(data[0].series[0], colorScheme);

    //bind all monthlyTrend Matric
    bindMonthlyTrends(data[1], colorScheme);

    //bind all table Content
    bindTableContent(data[2]);

    //bind all weeklyTrend Matric
    bindWeeklyTrends(data[3], colorScheme);

    //bind all dailyTrend Matric
    bindDailyTrends(data[4], colorScheme);

    bindDoughNutReturningCustomer(data[0].series[0], colorScheme);

    //bind branch details table
    bindBranchStatistics(data[5].series[0]);

    //bind 10 best and worst table
    bindBestWorstStore(data[5]);
}

function drawTopMatricGraph(topMatricGraphId, data, colorScheme) {
    $(function() {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: topMatricGraphId,
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                },
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });

}

function drawTableContents(tableContentIds, data) {
    HasLastYearDataForVisitorCount = data.series[1].HasValueBool;
    var thisYear = data.series[0];
    var lastYear = data.series[1];

    for (index = 0; index < tableContentIds.length; index++) {
        var html = "";
        var symbol = index != 0 ? (index == 2 ? " " + Languagemin : " %") : "";
        var FooterTitle = (index == 0 ? LanguageTotal : LanguageAverage);
        $('#' + tableContentIds[index][0] + 'Head').empty();
        $('#' + tableContentIds[index][0] + 'Content').empty();
        $('#' + tableContentIds[index][0] + 'Foot').empty();

        if (HasLastYearDataForVisitorCount) {
            $('#' + tableContentIds[index][0] + 'Head').append("<tr><th>" + LanguageWeek + " " + weekNumber + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");
            for (dataIndex = 0; dataIndex < thisYear.ValueInInt.length; dataIndex++) {
                html += "<tr><td>" + data.categories[dataIndex] + "</td><td>" + numberWithCommas(thisYear[tableContentIds[index][1]][dataIndex]) + symbol + "</td><td>" + numberWithCommas(lastYear[tableContentIds[index][1]][dataIndex]) + symbol + "</td>";
                if (lastYear[tableContentIds[index][2]][dataIndex] > 0) {
                    html += "<td class='rise'><i class='fa fa-caret-up'></i> " + lastYear[tableContentIds[index][2]][dataIndex] + "%</td><tr>";
                } else if (lastYear[tableContentIds[index][2]][dataIndex] < 0) {
                    html += "<td class='drop'><i class='fa fa-caret-down'></i> " + lastYear[tableContentIds[index][2]][dataIndex] + "%</td><tr>";
                } else {
                    html += "<td> - </td><tr>";
                }

            }

            $('#' + tableContentIds[index][0] + 'Content').append(html);
            var thisYearTotal = thisYear[tableContentIds[index][3]];
            var lastYearTotal = lastYear[tableContentIds[index][3]];
            var diffTotal = lastYear[tableContentIds[index][4]];

            var footerHtml = "<tr><td>" + FooterTitle + "</td><td>" + numberWithCommas(thisYearTotal) + symbol + "</td><td>" + numberWithCommas(lastYearTotal) + symbol + "</td>";
            if (diffTotal > 0) {
                footerHtml += "<td class='rise'><i class='fa fa-caret-up'></i> " + diffTotal + "%</td><tr>";
            } else if (diffTotal < 0) {
                footerHtml += "<td class='drop'><i class='fa fa-caret-down'></i> " + diffTotal + "%</td><tr>";

            } else {
                footerHtml += "<td> - </td><tr>";

            }
            $('#' + tableContentIds[index][0] + 'Foot').append(footerHtml);
        } else {
            $('#' + tableContentIds[index][0] + 'Head').append("<tr><th>" + LanguageWeek + " " + weekNumber + "</th><th>" + LanguageThisYear + "</th>");
            for (dataIndex = 0; dataIndex < thisYear.ValueInInt.length; dataIndex++) {
                html += "<tr><td>" + data.categories[dataIndex] + "</td><td>" + numberWithCommas(thisYear[tableContentIds[index][1]][dataIndex]) + symbol + "</td></tr>";
            }
            $('#' + tableContentIds[index][0] + 'Content').append(html);
            var thisYearTotal = thisYear[tableContentIds[index][3]];
            var footerHtml = "<tr><td>" + FooterTitle + "</td><td>" + numberWithCommas(thisYearTotal) + symbol +  "</td></tr>";
            $('#' + tableContentIds[index][0] + 'Foot').append(footerHtml);
        }


    }

}

function hideSalesConversionMatrices() {
    document.getElementById("salesConversionSection").style.display = 'none';
    document.getElementById("salesConversionMiniGraph").style.display = 'none';
}

//to draw monthly, weekly, daily trend chart
function drawHighCharts(highchartIds, data, colorScheme, trend) {
	HasLastYearDataForVisitorCount = data.series[1].HasValueBool;
	var thisYear = data.series[0];
	var lastYear = data.series[1];

	for (index = 0; index < highchartIds.length; index++) {
		var keyWord = highchartIds[index][1];
		var highChartId = highchartIds[index][0];

		// Uncomment code below to find out which graph allow y Axis label to be decimal
		//console.log(highchartIds[index][2] + ": " + highchartIds[index][3]);

		$(function () {
			var chart = new Highcharts.Chart({
				chart: {
					renderTo: highChartId,
					events: {
						load: function () {
							chartEvent[3] = this;
						}
					}
				},
				series: [{
					type: 'column',
                    name: trend === 'monthly' ? LanguageLast12Months: LanguageThisYear,
					data: thisYear[keyWord],
					color: colorScheme.time.year.thisYear,
					pointWidth: trend === 'monthly' ? 17 : 10,
					borderWidth: 0
				}, {
					type: 'line',
                    name: trend === 'monthly' ? LanguageLastYearSameMonth : LanguageLastYear,
					dashStyle: 'dash',
					data: lastYear[keyWord],
					color: colorScheme.time.year.lastYear,
					lineWidth: 1
				}],
				credits: {
					enabled: false
				},
				title: {
					text: ''
					//text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachmonthoftheyear + "'></i>",
					//align: 'left',
					//style: {
					//    color: colorScheme.chart.title.color.visitorCount,
					//    "font-family": colorScheme.chart.title.fontFamily,
					//    fontSize: colorScheme.chart.title.fontSize,
					//    textDecoration: colorScheme.chart.title.textDecoration,
					//    "font-weight": colorScheme.chart.title.fontWeight
					//}
				},
				plotOptions: {
					column: {
						stacking: 'normal'
					},
					series: {
						marker: {
							enabled: false
						},
						point: {
							events: {
								click: function () {
									location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
								}
							}
						},

						cursor: 'pointer'
					}
				},
				yAxis: {
					allowDecimals: highchartIds[index][3],
					lineWidth: 0,
					min: 0,
					gridLineWidth: 1,
					tickWidth: 1,
					//tickInterval: dynamicTickInterval,
					tickPixelInterval: 15,
					tickPosition: 'inside',
					title: {
						text: highchartIds[index][2],
						style: {
							color: colorScheme.chart.axisLabel.y.title.color,
							fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
							"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
						}
					},
					labels: {
						style: {
							"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
							color: colorScheme.chart.axisLabel.y.label.color,
							fontSize: colorScheme.chart.axisLabel.y.label.fontSize
						}
					}
				},
				xAxis: {
					categories: data.categories,
					tickWidth: 0,
					title: {
						text: "",
						align: 'high',
						y: -20,
						style: {
							color: colorScheme.chart.axisLabel.x.title.color,
							fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
							"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
						}
					},
					labels: {
						rotation: -90,
						x: 3,
						style: {
							color: colorScheme.chart.axisLabel.x.label.color,
							"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
							fontSize: colorScheme.chart.axisLabel.x.label.fontSize
						}
					}
				},
				legend: {
					itemStyle: {
						color: colorScheme.chart.legend.text.color,
						"font-family": colorScheme.chart.legend.text.fontFamily,
						fontSize: colorScheme.chart.legend.text.fontSize,
						"font-weight": colorScheme.chart.legend.text.fontWeight
					},
					enabled: true,
                    x: trend === 'monthly' ? 100 : 250,
                    y: -15, 
                    verticalAlign: 'top',
				},
				exporting: {
					enabled: false,
				},
				tooltip: {
					useHTML: true,
					shared: true,
				}
			},
				function (chart) {
					if (!HasLastYearDataForVisitorCount) {
						chart.series[1].remove(true);
					}
				});
		});

	}
}

//binding top matric
function bindTopMatric(data, colorScheme) {

    bindFootfallTopMatric(data, colorScheme);
    bindTurnInRateTopMatric(data, colorScheme);
    bindVisitdurationTopMatric(data, colorScheme);
    bindReturningRateTopMatric(data, colorScheme);
    bindNewVisitorTopMatric(data, colorScheme);
    bindHighestTurnInRateTopMatric(data, colorScheme);
    bindLowestTurnInRateTopMatric(data, colorScheme);
    bindHighestRiseAndDropTopMatric(data, colorScheme);
    if (data.TotalNumberOfStore >= 5){
        $('#HighestTurnInRateModule').removeClass('hide');
        $('#LowestTurnInRateModule').removeClass('hide');
        $('#HighestRiseModule').removeClass('hide');
        $('#HighestDropModule').removeClass('hide');
    }
    else {
        $('#HighestTurnInRateModule').addClass('hide');
        $('#LowestTurnInRateModule').addClass('hide');
        $('#HighestRiseModule').addClass('hide');
        $('#HighestDropModule').addClass('hide');
    }

    //if (data.hasSalesData) {
    //bindSalesConversionTopMatric(data, colorScheme);
    //} else {
    //hideSalesConversionMatrices();
    //}

}

function bindFootfallTopMatric(data, colorScheme) {


    $('#companyTotalVisitorThisWeek').empty();
    $('#companyTotalVisitorUpDownPercent').removeClass('rise');
    $('#companyTotalVisitorUpDownPercent').removeClass('drop');
    $('#companyTotalVisitorUpDownPercent').empty();
    $('#company7daysVisitorGraph').empty();


    footfall = data.visitorTotal;
    foofallGraphTrend = data.ValueInInt;
    footfalldiff = data.DifferencesInFF;

    $('#companyTotalVisitorThisWeek').append(numberWithCommas(footfall));

    var html = '';
    if (footfalldiff === 0.0) {
        html = LanguageNoChanges;
    } else if (footfalldiff > 0) {
        $('#companyTotalVisitorUpDownPercent').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + footfalldiff + ' %';
    } else if (footfalldiff < 0) {
        $('#companyTotalVisitorUpDownPercent').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + footfalldiff + ' %';
    }
    $('#companyTotalVisitorUpDownPercent').append(html);
    drawTopMatricGraph('company7daysVisitorGraph', foofallGraphTrend, colorScheme);

}

function bindTurnInRateTopMatric(data, colorScheme) {

    $('#companyTurnInRateThisWeek').empty();
    $('#companyDifferenceTurnInRateInPercentage').removeClass('rise');
    $('#companyDifferenceTurnInRateInPercentage').removeClass('drop');
    $('#companyDifferenceTurnInRateInPercentage').empty();
    $('#company7daysTurnInRate').empty();

    turnInRate = data.TurnInRateTotal;
    turnInRateGraphTrend = data.TIR;
    turnInRateDiff = data.DifferencesInTIR;

    $('#companyTurnInRateThisWeek').append(turnInRate);

    var html = '';
    if (turnInRateDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (turnInRateDiff > 0) {
        $('#companyDifferenceTurnInRateInPercentage').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + turnInRateDiff + ' %';
    } else if (turnInRateDiff < 0) {
        $('#companyDifferenceTurnInRateInPercentage').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + turnInRateDiff + ' %';
    }
    $('#companyDifferenceTurnInRateInPercentage').append(html);
    drawTopMatricGraph('company7daysTurnInRate', turnInRateGraphTrend, colorScheme);
}

function bindVisitdurationTopMatric(data, colorScheme) {


    $('#companyVisitDurationThisWeek').empty();
    $('#companyDifferenceVisitDurationInPercentage').removeClass('rise');
    $('#companyDifferenceVisitDurationInPercentage').removeClass('drop');
    $('#companyDifferenceVisitDurationInPercentage').empty();
    $('#company7daysVisitDuration').empty();


    visitDuration = data.VisitDurationTotal;
    visitDurationGraphTrend = data.VisitDuration;
    visitDurationDiff = data.DifferencesInVisitDuration;

    $('#companyVisitDurationThisWeek').append(visitDuration + ' min');

    var html = '';
    if (visitDurationDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (visitDurationDiff > 0) {
        $('#companyDifferenceVisitDurationInPercentage').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + visitDurationDiff + ' %';
    } else if (visitDurationDiff < 0) {
        $('#companyDifferenceVisitDurationInPercentage').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + visitDurationDiff + ' %';
    }
    $('#companyDifferenceVisitDurationInPercentage').append(html);
    drawTopMatricGraph('company7daysVisitDuration', visitDurationGraphTrend, colorScheme);
}

function bindReturningRateTopMatric(data, colorScheme) {

    $('#companyReturningCustomerThisWeek').empty();
    $('#companyDifferenceReturningCustomerInPercentage').removeClass('rise');
    $('#companyDifferenceReturningCustomerInPercentage').removeClass('drop');
    $('#companyDifferenceReturningCustomerInPercentage').empty();
    $('#company7daysReturningCustomer').empty();

    returningRate = data.ReturnCustomerRate;
    returningRateGraphTrend = data.ReturningRate;
    returningRateDiff = data.DifferencesInReturingCustomerRate;

    $('#companyReturningCustomerThisWeek').append(returningRate + " %");

    var html = '';
    if (returningRateDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (returningRateDiff > 0) {
        $('#companyDifferenceReturningCustomerInPercentage').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + returningRateDiff + ' %';
    } else if (returningRateDiff < 0) {
        $('#companyDifferenceReturningCustomerInPercentage').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + returningRateDiff + ' %';
    }
    $('#companyDifferenceReturningCustomerInPercentage').append(html);
    drawTopMatricGraph('company7daysReturningCustomer', returningRateGraphTrend, colorScheme);
}

function bindNewVisitorTopMatric(data, colorScheme) {

    $('#companyNewVisitorThisWeek').empty();
    $('#companyDifferenceNewCustomerInPercentage').removeClass('rise');
    $('#companyDifferenceNewCustomerInPercentage').removeClass('drop');
    $('#companyDifferenceNewCustomerInPercentage').empty();
    $('#company7daysNewVisitorGraph').empty();

    newVisitor = data.NewCustomerRate;
    newVisitorGraphTrend = data.NewCust;
    newVisitorDiff = data.DiffInNewCustomerRate;

    $('#companyNewVisitorThisWeek').append(newVisitor + '%');

    var html = '';
    if (newVisitorDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (newVisitorDiff > 0) {
        $('#companyDifferenceNewCustomerInPercentage').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + newVisitorDiff + ' %';
    } else if (newVisitorDiff < 0) {
        $('#companyDifferenceNewCustomerInPercentage').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + newVisitorDiff + ' %';
    }
    $('#companyDifferenceNewCustomerInPercentage').append(html);
    drawTopMatricGraph('company7daysNewVisitorGraph', newVisitorGraphTrend, colorScheme);
}

function bindHighestTurnInRateTopMatric(data, colorScheme) {

    $('#companyHighestTurnRateThisWeek').empty();
    $('#companyHighestTurnRateUpDownPercent').removeClass('rise');
    $('#companyHighestTurnRateUpDownPercent').removeClass('drop');
    $('#companyHighestTurnRateUpDownPercent').empty();


    highestTurnInRate = data.highestTurnInRate;
    highestTurnInRateStore = data.highestTurnInRateStore;

    $('#companyHighestTurnRateThisWeek').append(highestTurnInRateStore);
    $('#companyHighestTurnRateUpDownPercent').append(highestTurnInRate + ' %');
}

function bindLowestTurnInRateTopMatric(data, colorScheme) {

    $('#companyLowestTurnInRateThisWeek').empty();
    $('#companyDifferenceLowestTurnInRateInPercentage').removeClass('rise');
    $('#companyDifferenceLowestTurnInRateInPercentage').removeClass('drop');
    $('#companyDifferenceLowestTurnInRateInPercentage').empty();

    lowestTurnInRate = data.lowestTurnInRate;
    lowestTurnInRateStore = data.lowestTurnInRateStore;

    $('#companyLowestTurnInRateThisWeek').append(lowestTurnInRateStore);
    $('#companyDifferenceLowestTurnInRateInPercentage').append(lowestTurnInRate + ' %');
}

function bindHighestRiseAndDropTopMatric(data, colorScheme) {

    $('#companyHighestRiseThisWeek').empty();
    $('#companyHighestRiseInPercentage').removeClass('rise');
    $('#companyHighestRiseInPercentage').removeClass('drop');
    $('#companyHighestRiseInPercentage').empty();


    $('#companyHighestDropThisWeek').empty();
    $('#companyHighestDropInPercentage').removeClass('rise');
    $('#companyHighestDropInPercentage').removeClass('drop');
    $('#companyHighestDropInPercentage').empty();


    highestRise = data.HighestRise;
    highestRiseStore = data.HighestRiseStore;
    highestDrop = data.HighestDrop;
    highestDropStore = data.HighestDropStore;



    $('#companyHighestRiseThisWeek').append(highestRiseStore);
    $('#companyHighestRiseInPercentage').append(highestRise + ' %');


    $('#companyHighestDropThisWeek').append(highestDropStore);
    $('#companyHighestDropInPercentage').append(highestDrop + ' %');
}

function bindSalesConversionTopMatric(data, colorScheme) {

    $('#companySaleConversionThisWeek').empty();
    $('#companyDifferenceSaleConversionInPercentage').removeClass('rise');
    $('#companyDifferenceSaleConversionInPercentage').removeClass('drop');
    $('#companyDifferenceSaleConversionInPercentage').empty();
    $('#company7daysSaleConversion').empty();


    salesConversion = data.SalesConversionTotal;
    salesConversionGraphTrend = data.SalesConversion;
    salesConversionDiff = data.DiffInSC;

    $('#companySaleConversionThisWeek').append(salesConversion);

    var html = '';
    if (salesConversionDiff === 0.0) {
        html = LanguageNoChanges;
    } else if (salesConversionDiff > 0) {
        $('#companyDifferenceSaleConversionInPercentage').addClass('rise');
        html = '<i class="fa fa-caret-up"></i>' + salesConversionDiff + ' %';
    } else if (salesConversionDiff < 0) {
        $('#companyDifferenceSaleConversionInPercentage').addClass('drop');
        html = '<i class="fa fa-caret-down"></i>' + salesConversionDiff + ' %';
    }
    $('#companyDifferenceSaleConversionInPercentage').append(html);
    drawTopMatricGraph('company7daysSaleConversion', salesConversionGraphTrend, colorScheme);
}

//end of binding top matric


//bind monthly trend
function bindMonthlyTrends(data, colorSceme) {
	var monthlyTrendIds = [
		['companyMonthlyTrend', 'ValueInInt', LanguageNoofVisitor, false],
		['companyTurnInRateMonthlyTrend', 'TIR', LanguageTurnInRate + ' (%)', true],
		['companyVisitDurationMonthlyTrend', 'VisitDuration', LanguageAverageVisitDurationmins, true],
		['companyReturningCustomerMonthlyTrend', 'ReturningRate', LanguageReturningRateprecent, true]
	];
	if ($('#salesConversionSection').is(':visible')) {
		monthlyTrendIds.push(['companyMonthlySCTrend', 'SalesConversion', LanguageSalesConversion + "(%)", true]);
	}
	drawHighCharts(monthlyTrendIds, data, colorSceme, 'monthly');
}

//bind weekly trend
function bindWeeklyTrends(data, colorScheme) {
	var weeklyTrendIds = [
		['companyWeeklyTrend', 'ValueInInt', LanguageNoofVisitor, false],
		['companyReturningCustomerWeeklyTrend', 'ReturningRate', LanguageReturningRateprecent, true]
	];
	if ($('#salesConversionSection').is(':visible')) {
		weeklyTrendIds.push(['companyWeeklySCTrend', 'SalesConversion', LanguageSalesConversion + "(%)", true]);
	}

	drawHighCharts(weeklyTrendIds, data, colorScheme, 'weekly');
}

//bind daily trend
function bindDailyTrends(data, colorScheme) {
    var dailyTrendIds = [
		['companyDailyTrend', 'ValueInInt', LanguageNoofVisitor, false],
		['companyVisitDurationDailyTrend', 'VisitDuration', LanguageAverageVisitDurationmins, true],
		['companyReturningCustomerDailyTrend', 'ReturnCust', LanguageReturningRateprecent, true]
    ];
	if ($('#salesConversionSection').is(':visible')) {
		dailyTrendIds.push(['companyDailySCTrend', 'SalesConversion', LanguageSalesConversion + "(%)", true]);
    }
    drawHighCharts(dailyTrendIds, data, colorScheme, 'daily');
}

//bind doughnut
function bindDoughNutReturningCustomer(data, colorScheme) {

    var averageThisWeekNewPercentage = data.NewCustomerRate;
    var aveThisWeekRR = data.ReturnCustomerRate
    var donutChartColors = $.map(colorScheme.chart.donut, function(value, index) {
        return [value];
    });

    $(function() {
        chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'companyThisWeekAverageReturningCustomerDonutChart',
                    type: 'pie'
                },
                colors: donutChartColors,
                title: {
                    text: ''
                },
                yAxis: {
                    title: {
                        text: ''
                    }
                },
                plotOptions: {
                    pie: {
                        shadow: false,
                        dataLabels: {
                            enabled: true,
                            distance: -30,
                            style: {
                                fontFamily: colorScheme.chart.dataLabel.fontFamily,
                                color: colorScheme.chart.dataLabel.color,
                                fontSize: colorScheme.chart.dataLabel.fontSize,
                                fontWeight: colorScheme.chart.dataLabel.fontWeight
                            },
                            formatter: function() {
                                return "<b>" + this.y + '%</b>';
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function() {
                        return '<b>' + this.point.name + '</b>: ' + this.y + ' %';
                    }
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        fontFamily: colorScheme.chart.legend.text.fontFamily,
                        //fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    margin: 0
                },
                series: [{
                    name: LanguageThisWeekAverage,
                    data: [
                        [LanguageNewCustomer, parseFloat(averageThisWeekNewPercentage)],
                        [LanguageReturningCustomer, parseFloat(aveThisWeekRR)]
                    ],
                    size: '100%',
                    innerSize: '60%',
                    showInLegend: true,
                }]
            },

            function(chart) { // on complete
                var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                var textY = chart.plotTop + (chart.plotHeight * 0.5);

                var span = '<span id="RRpieChartInfoText" style="position:absolute; text-align:center;">';
                span += '<span class="pieChartInfoTextTitle">' + aveThisWeekRR + '</span><br>';
                span += '<span class="pieChartInfoTextSubtitle">';
                span += '<span>' + LanguageThisWeek + '</span><br />';
                span += '<span>' + LanguageAverage + '</span>';
                span += '</span></span>';

                $("#companyReturningCustomerDonutChartCenterText").empty();
                $("#companyReturningCustomerDonutChartCenterText").append(span);
                span = $('#RRpieChartInfoText');
                span.css('left', textX + (span.width() * -0.43));
                span.css('top', textY + (span.height() * -0.5));

                $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
            });
    });
}

//bind tableContent
function bindTableContent(data) {

    var tableContentIds = [
        ['companyLastTwoWeeksComparisonTable', 'ValueInInt', 'DifferencesInFFList', 'visitorTotal', 'DifferencesInFF'],
        ['companyLastTwoWeeksTurnInRateComparisonTable', 'TIR', 'DiffInTIRList', 'TurnInRateTotal', 'DifferencesInTIR'],
        ['companyLastTwoWeeksVisitDurationComparisonTable', 'VisitDuration', 'DiffInVisitDurationList', 'VisitDurationTotal', 'DifferencesInVisitDuration'],
        ['companyLastTwoWeeksReturningCustomerComparisonTable', 'ReturnCust', 'DiffInReturningCustomerList', 'ReturnCustomerRate', 'DifferencesInReturingCustomerRate'],
    ];
    if ($('#salesConversionSection').is(':visible')) {
        tableContentIds.push(['companyLastTwoWeeksSCtable', 'SalesConversion', 'DiffInScList', 'SalesConversionTotal', 'DiffInSC']);
    }
    drawTableContents(tableContentIds, data);

}

//bind branch details table
function bindBranchStatistics(data) {
    var html = "";
    $('#companyBranchesStatistic').empty();
    for (index = 0; index < data.branchName.length; index++) {
        //Value in
        html += "<tr><td>" + data.branchName[index] + "</td><td>" + data.Rank[index] + "</td><td>" + numberify(data.ValueInInt[index]) + "</td>";
        if (data.DifferencesInFFList[index] > 0) {
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DifferencesInFFList[index] + "</td>";
        } else if (data.DifferencesInFFList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DifferencesInFFList[index] + "</td>";
        } else {
            html += "<td> - </td>";
        }

        //turn in rate
        html += "<td>" + (data.TIR[index] != 0 ? data.TIR[index] : " - ") + "</td>";
        if (data.DiffInTIRList[index] > 0) {
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DiffInTIRList[index] + "</td>";
        } else if (data.DiffInTIRList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DiffInTIRList[index] + "</td>";
        } else {
            html += "<td> - </td>";
        }

        //visit duration

        html += "<td>" + data.VisitDuration[index] + "</td>";
        if (data.DiffInVisitDurationList[index] > 0) {
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DiffInVisitDurationList[index] + "</td>";
        } else if (data.DiffInVisitDurationList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DiffInVisitDurationList[index] + "</td>";
        } else {
            html += "<td> - </td>";
        }

        //returningRate
        html += "<td>" + data.ReturningRate[index] + "</td>";
        if (data.DiffInReturningCustomerList[index] > 0) {
            html += "<td class='rise'><i class='fa fa-caret-up'></i> " + data.DiffInReturningCustomerList[index] + "</td>";
        } else if (data.DiffInReturningCustomerList[index] < 0) {
            html += "<td class='drop'><i class='fa fa-caret-down'></i> " + data.DiffInReturningCustomerList[index] + "</td>";
        } else {
            html += "<td> - </td>";
        }
    }
    $('#companyBranchesStatistic').append(html);

}

function bindBestWorstStore(data, inverseData) {
    bestData = data.series[2];
    worstData = data.series[1];
    $("#company5BestBranchesStatistic").empty();
    $("#company5WorstBranchesStatistic").empty();
    totalBranch = data.series[0].branchId.length
    if (totalBranch >= 20) {
        document.getElementById("bestAndWorstStores").style.display = "inherit";

        //10 best
        ranking = 0;
        for (var i = 0; i < 10; i++) {
            ranking = ranking + 1;

            $("#company5BestBranchesStatistic").append("<tr><td><div style='cursor:pointer;' data-branchID=" + bestData.branchId[i] + ">" +
                bestData.branchName[i] + "</div></td><td>" + bestData.Rank[i] + "</td><td>" +
                numberify(bestData.ValueInInt[i]) + "</td><td>" + bestData.DifferencesInFFList[i] + "</td><td>" +
                bestData.TIR[i] + "</td><td>" + bestData.DiffInTIRList[i] + "</td><td>" +
                bestData.VisitDuration[i] + "</td><td>" + bestData.DiffInVisitDurationList[i] + "</td><td>" +
                bestData.ReturningRate[i] + "</td><td>" + bestData.DiffInReturningCustomerList[i] + "</td></tr>");
        }
        //company5WorstBranchesStatistic
        //10 worst
        for (var i = 0; i < 10; i++) {
            ranking = ranking + 1;

            $("#company5WorstBranchesStatistic").append("<tr><td><div style='cursor:pointer;' data-branchID=" + worstData.branchId[i] + ">" +
                worstData.branchName[i] + "</div></td><td>" + worstData.Rank[i] + "</td><td>" +
                numberify(worstData.ValueInInt[i]) + "</td><td>" + worstData.DifferencesInFFList[i] + "</td><td>" +
                worstData.TIR[i] + "</td><td>" + worstData.DiffInTIRList[i] + "</td><td>" +
                worstData.VisitDuration[i] + "</td><td>" + worstData.DiffInVisitDurationList[i] + "</td><td>" +
                worstData.ReturningRate[i] + "</td><td>" + worstData.DiffInReturningCustomerList[i] + "</td></tr>");
        }
    }

}








//--------------Visitor Counts--------------//
var noLastYearDataForVisitorCount = true;
/*
//Visitor Counts Monthly Trend
function bindCompanyVisitorCountsMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i];
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyMonthlyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 17,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachmonthoftheyear + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.visitorCount,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
                                }
                            }
                        },

                        cursor: 'pointer'
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageMonth,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 96,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                }
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}
*/

//Visitor Counts Weekly Trend
function bindCompanyVisitorCountsWeeklyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyWeeklyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachweekoftheyear + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.visitorCount,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: [{
                        categories: datas.categories
                    }],
                    tickWidth: 0,
                    title: {
                        text: LanguageWeek,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 260,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                }
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Visitor Counts Daily Trend
function bindCompanyVisitorCountsDailyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;


        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyDailyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachday + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.visitorCount,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=1&branchId=-1&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }

                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 260,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                }
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Visitor Counts Last Week Hourly Trend
function bindCompanyVisitorCountsHourlyTrend(datas, colorScheme) {
    $(function() {
        //console.log(datas)
        var thisYear = datas.series[0].ValueInInt;
        var lastYear = datas.series[0].LastValueInList;

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyLastWeekVisitorCountTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.chart.line.color.thisYear,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageLastWeek,
                dashStyle: 'dash',
                data: lastYear,
                color: colorScheme.chart.line.color.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //text: LanguageHourlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsofthehoursforeachdayoftheselectedweek + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.visitorCount,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
			yAxis: {
				allowDecimals: false,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: [{
                        name: ifmonday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }, {
                        name: iftuesday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }, {
                        name: ifwednesday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifthursday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: iffriday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifsaturday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifsunday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }
                ],
                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: "", //LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}



//global variable
//to be used in other function
var branchIdWithHighestRise = 0;
var branchIdWithHighestDrop = 0;
var companyHighestRiseFFBranch7DaysData = []
var companyHighestDropFFBranch7DaysData = []
var totalFF = 0;
var visitorCountsSparkline = [];

/*S
//Visitor Counts Sparkline Graph
function bindCompanyLastTwoWeekVisitorCountsDataIntoTable(data, colorScheme) {

    visitorCountsSparkline = data.series[1].data;
    companyHighestRiseFFBranch7DaysData = data.series[3].data;
    companyHighestDropFFBranch7DaysData = data.series[4].data;

    $('#companyHighestRiseInPercentage').empty();
    $('#companyHighestRiseThisWeek').empty();
    $('#companyHighestDropInPercentage').empty();
    $('#companyHighestDropThisWeek').empty();

    var companyHighestRiseFFBranchName = data.series[3].branchName[0];
    var companyHighestDropFFBranchName = data.series[4].branchName[0];

    var highestRiseFootfall = data.series[3].highestValue;
    var highestDropFootfall = data.series[4].highestValue;

    highestDropFootfall = highestDropFootfall == 0 ? " - " : kFormatter(highestDropFootfall) + "%";
    highestRiseFootfall = highestRiseFootfall == 0 ? " - " : kFormatter(highestRiseFootfall) + "%";

    $('#companyHighestRiseInPercentage').append(highestRiseFootfall);
    $('#companyHighestRiseThisWeek').append(companyHighestRiseFFBranchName);

    $('#companyHighestDropInPercentage').append(highestDropFootfall);
    $('#companyHighestDropThisWeek').append(companyHighestDropFFBranchName);

    var companyTotalVisitorThisWeek = data.series[1].total;
    var companyTotalVisitorLastWeek = data.series[0].total;
    $('#companyTotalVisitorUpDownPercent').empty();
    $("#companyTotalVisitorThisWeek").html("");

    var changesTotalVisitorInTwoWeeks = data.series[2].total;
    $('#companyTotalVisitorUpDownPercent').removeClass("rise");
    $('#companyTotalVisitorUpDownPercent').removeClass("drop");

    if (companyTotalVisitorLastWeek == 0 || companyTotalVisitorThisWeek == 0 || companyTotalVisitorThisWeek == companyTotalVisitorLastWeek || changesTotalVisitorInTwoWeeks == 0) {
        $('#companyTotalVisitorUpDownPercent').append(LanguageNoChanges);
        //$("#companyTotalVisitorUpDownIcon").html("");
    } else if (companyTotalVisitorThisWeek > companyTotalVisitorLastWeek) { //if increased
        $('#companyTotalVisitorUpDownPercent').addClass("rise");
        //$("#companyTotalVisitorUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#companyTotalVisitorUpDownPercent').append("<i class='fa fa-caret-up'></i> " + kFormatter(changesTotalVisitorInTwoWeeks) + "%");
    } else if (companyTotalVisitorThisWeek < companyTotalVisitorLastWeek) { //if decreased
        $('#companyTotalVisitorUpDownPercent').addClass("drop");
        //$("#companyTotalVisitorUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#companyTotalVisitorUpDownPercent').append("<i class='fa fa-caret-down'></i> " + kFormatter(changesTotalVisitorInTwoWeeks) + "%");
    }

    companyTotalVisitorThisWeek = companyTotalVisitorThisWeek == 0 ? " - " : numberWithCommas(companyTotalVisitorThisWeek);
    //companyTotalVisitorLastWeek = companyTotalVisitorLastWeek == 0 ? " - " : companyTotalVisitorLastWeek;
    $('#companyTotalVisitorThisWeek').append(companyTotalVisitorThisWeek);
    //$('#companyTotalVisitorLastWeek').text('( ' + LanguageLastWeek + ': ' + companyTotalVisitorLastWeek + ')');

}
*/

//Visitor Counts Weekdays/Weekends Comparison Graph
function bindCompanyWeekdayVisitorCountsTrend(datas, colorScheme) {
    $(function() {
        var thisYear = datas.series[0].ValueInInt;

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var showMarker = true;
        var showPopUp = true;
        if (datas.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekdaysTrafficProfile",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
			yAxis: {
				allowDecimals: false,
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: "", //LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });

        if (datas.series[0].isDayOff) {
            $("#companyWeekdaysTrafficProfile").append("<div class='weekday-notice'>" + LanguageCloseonWeekdays + "</div>");
        }

    });
}

function bindCompanyWeekendVisitorCountsTrend(datas, colorScheme) {
    $(function() {
        var thisYear = datas.series[1].ValueInInt;

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var showMarker = true;
        var showPopUp = true;
        //if (datas.series[0].isDayOff) {
        //    showMarker = false;
        //    showPopUp = false;
        //}

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekendsTrafficProfile",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            title: {
                text: LanguageWeekends, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
			yAxis: {
				allowDecimals: false,
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: "", //LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });

        if (datas.series[0].isDayOff) {
            $("#companyWeekendsTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }

    });
}





//--------------Turn In Rate--------------//
//Turn In Rate Monthly Trend
function bindCompanyTurnInRateMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }

        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyTurnInRateMonthlyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 17,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalpercentageofvisitorscominginfromoutsideinthemonth + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.turnInRate,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        }
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageTurnInRatepercent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageMonth,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 96,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//global variable
//to be used in other function
var theLowestBranchId = 0;
var theHighestBranchId = 0;
var highestTurnInRateSparkLineValue = [];
var lowestTurnInRateSparkLineValue = [];
var turnInRateSparkLineValue = []

//Turn In Rate Sparkline Graph
function bindCompanyLastTwoWeekTurnInRateDataIntoTable(data, colorScheme) {
    //for mini graph
    turnInRateSparkLineValue = data.series[1].data
    lowestTurnInRateSparkLineValue = data.series[3].data;
    highestTurnInRateSparkLineValue = data.series[4].data;

    var highestBranchName = data.series[4].branchName[0];
    var lowestBranchName = data.series[3].branchName[0];

    $('#companyHighestTurnRateUpDownPercent').empty();
    $('#companyHighestTurnRateThisWeek').empty();
    $('#companyDifferenceLowestTurnInRateInPercentage').empty();
    $('#companyLowestTurnInRateThisWeek').empty();
    var totalLowest = data.series[3].highestValue;
    var totalHighest = data.series[4].highestValue;

    $('#companyHighestTurnRateUpDownPercent').append(kFormatter(totalHighest) == 0.00 ? " - " : kFormatter(totalHighest) + "%");
    $('#companyHighestTurnRateThisWeek').append(highestBranchName);

    $('#companyDifferenceLowestTurnInRateInPercentage').text(kFormatter(totalLowest) == 100.00 ? " - " : kFormatter(totalLowest) + "%");
    $('#companyLowestTurnInRateThisWeek').append(lowestBranchName);

    $('#companyDifferenceTurnInRateInPercentage').empty();
    $("#companyTurnInRateThisWeek").html("");
    var aveThisWeekTIR = data.series[1].total;
    var aveLastWeekTIR = data.series[0].total;
    var aveTIRDifference = data.series[2].total;
    $('#companyDifferenceTurnInRateInPercentage').removeClass("rise");
    $('#companyDifferenceTurnInRateInPercentage').removeClass("drop");

    if (aveLastWeekTIR == 0 || aveThisWeekTIR == 0 || aveTIRDifference == 0) {
        $('#companyDifferenceTurnInRateInPercentage').append(LanguageNoChanges);
        //$("#companyTurnInRateUpDownIcon").html("");
    } else if (aveThisWeekTIR > aveLastWeekTIR) {
        $('#companyDifferenceTurnInRateInPercentage').addClass("rise");
        //$("#companyTurnInRateUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#companyDifferenceTurnInRateInPercentage').append("<i class='fa fa-caret-up'></i> " + kFormatter(aveTIRDifference) + "%");
    } else if (aveThisWeekTIR < aveLastWeekTIR) {
        $('#companyDifferenceTurnInRateInPercentage').addClass("drop");
        //$("#companyTurnInRateUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#companyDifferenceTurnInRateInPercentage').append("<i class='fa fa-caret-down'></i> " + kFormatter(aveTIRDifference * -1) + "%");
    }

    aveThisWeekTIR = aveThisWeekTIR == 0 ? " - " : aveThisWeekTIR + "%";
    //aveLastWeekTIR = aveLastWeekTIR == 0 ? " - " : aveLastWeekTIR + "%";
    $('#companyTurnInRateThisWeek').append(aveThisWeekTIR);
    //$('#companyTurnInRateLastWeek').text("( " + LanguageLastWeek + ": " + aveLastWeekTIR + ")");

}

//Turn In Rate Weekdays Comparison Graph
function bindCompanyWeekdayTIRTrend(datas, colorScheme) {
    $(function() {
        var thisYear = datas.series[0].TIR;

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var showMarker = true;
        var showPopUp = true;
        if (datas.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekdaysTurnInRate",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragepercentofvisitorsMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickPixelInterval: 50,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageAverageTurnInRate + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0,
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    },
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: "", //LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        if (datas.series[0].isDayOff) {
            $("#companyWeekdaysTurnInRate").append("<div class='weekday-notice'>" + LanguageCloseonWeekdays + "</div>");
        }
    });
}

//Turn In Rate Weekends Comparison Graph
function bindCompanyWeekendTIRTrend(datas, colorScheme) {
    $(function() {
        var thisYear = datas.series[1].TIR;

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var showMarker = true;
        var showPopUp = true;
        if (datas.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekendsTurnInRate",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragepercentofvisitorsSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageAverageTurnInRate + " (%)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0,

                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: "", //LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        if (datas.series[0].isDayOff) {
            $("#companyWeekendsTurnInRate").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}





//--------------Outside Traffic--------------//
//Outside Traffic last week Trend
function bindCompanyOutsideTrafficHourlyTrend(datas, colorScheme) {
	$(function () {
		var lastYear = datas.series[0].ValueInInt;
		var thisYear = datas.series[0].OutsideTrafficInt;

		//identify largest value of yaxis data
		var outsideTrafficLargestValue = 0;

		for (var i = 0; i < thisYear.length; i++) {
			if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > outsideTrafficLargestValue)
				outsideTrafficLargestValue = thisYear[i]
		}

		var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1 :
			outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10 :
				outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100 :
					outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000 :
						outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000 :
							outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000 :
								1000000;

		var visitorLargestValue = 0;

		for (var i = 0; i < lastYear.length; i++) {
			if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > visitorLargestValue)
				visitorLargestValue = lastYear[i]
		}
		var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1 :
			visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10 :
				visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100 :
					visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000 :
						visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000 :
							visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000 :
								1000000;


		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "companyOutsideTraffic",
				height: 250,
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false
			},
			series: [{
				type: 'areaspline',
				name: LanguageOutsideTraffic,
				data: thisYear,
				color: colorScheme.chart.matrices.outsideTraffic,
				fillOpacity: 0.15,
				lineWidth: 1.25,
				yAxis: 1
			}, {
				type: 'column',
				name: LanguageVisitor,
				data: lastYear,
				color: colorScheme.chart.matrices.noOfVisitor,
				borderWidth: 0
			}],
			credits: {
				enabled: false
			},
			title: {
				text: ''
				//text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + LanguageNumberofpeoplepassingbyhourlyofeachdayforthepreviousweek + "'></i>",
				//align: 'left',
				//style: {
				//    color: colorScheme.chart.title.color.outsideTraffic,
				//    "font-family": colorScheme.chart.title.fontFamily,
				//    fontSize: colorScheme.chart.title.fontSize,
				//    textDecoration: colorScheme.chart.title.textDecoration,
				//    "font-weight": colorScheme.chart.title.fontWeight
				//}
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				},
				series: {
					marker: {
						enabled: false
					}
				}
			},
			yAxis: [{
				allowDecimals: false,
				lineWidth: 0,
				gridLineWidth: 0,
				tickWidth: 0,
				//tickInterval: visitorCountDynamicTickInterval,
				tickPixelInterval: 15,
				tickPosition: 'inside',
				title: {
					text: LanguageNoofVisitor,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				labels: {
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				min: 0
			},
			{
				allowDecimals: false,
				opposite: true,
				tickWidth: 1,
				gridLineWidth: 1,
				//tickInterval: outsideTrafficDynamicTickInterval,
				tickPixelInterval: 15,
				lineWidth: 0,
				labels: {
					align: 'right',
					x: 25,
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				title: {
					text: LanguageOutsideTraffic,
					margin: 30,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				min: 0
			}
			],
			xAxis: {
				categories: [{
					name: ifmonday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				}, {
					name: iftuesday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				}, {
					name: ifwednesday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				},
				{
					name: ifthursday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				},
				{
					name: iffriday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				},
				{
					name: ifsaturday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				},
				{
					name: ifsunday,
					categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
				}
				],
				tickWidth: 0,
				tickInterval: 4,
				title: {
					text: "", //LanguageHour,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},

			legend: {
				itemStyle: {
					color: colorScheme.chart.legend.text.color,
					"font-family": colorScheme.chart.legend.text.fontFamily,
					fontSize: colorScheme.chart.legend.text.fontSize,
					"font-weight": colorScheme.chart.legend.text.fontWeight
				},
				enabled: true,
				x: 260,
				y: -15,
				verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});
}

//Outside Traffic and Visitor Counts Weekdays/Weekends Comparison Graph
function bindCompanyWeekdayTFAndOTTrend(datas, colorScheme) {
	$(function () {
		var lastYear = datas.series[0].ValueInInt;
		var thisYear = datas.series[0].OutsideTrafficInt;

		//identify largest value of yaxis data
		var outsideTrafficLargestValue = 0;

		for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > outsideTrafficLargestValue) {
                outsideTrafficLargestValue = thisYear[i];
            }
            thisYear[i] = thisYear[i] != null && thisYear[i] != undefined ? Math.round(thisYear[i] / 5) : 0;
		}

		var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1 :
			outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10 :
				outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100 :
					outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000 :
						outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000 :
							outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000 :
								1000000;

		var visitorLargestValue = 0;

		for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > visitorLargestValue) {
                visitorLargestValue = lastYear[i];
            }
            lastYear[i] = lastYear[i] != null && lastYear[i] != undefined ? Math.round(lastYear[i] / 5) : 0;
		}
		var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1 :
			visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10 :
				visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100 :
					visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000 :
						visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000 :
							visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000 :
								1000000;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "companyWeekdaysOutsideTraffic",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false
			},
			series: [{
				type: 'areaspline',
				name: LanguageOutsideTraffic,
				data: thisYear,
				color: colorScheme.chart.matrices.outsideTraffic,
				fillOpacity: 0.15,
				lineWidth: 1.25,
				yAxis: 1
			}, {
				type: 'column',
				name: LanguageVisitor,
				data: lastYear,
				color: colorScheme.chart.matrices.noOfVisitor,
				borderWidth: 0
			}],
			credits: {
				enabled: false
			},
			title: {
				text: ''
			},
			subtitle: {
				text: LanguageWeekdays, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingMondaytoFriday + "'></i>",
				align: 'center',
				style: {
					color: colorScheme.chart.subtitle.color,
					fontSize: colorScheme.chart.subtitle.fontSize,
					"font-family": colorScheme.chart.subtitle.fontFamily
				},
				margin: 0,
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				},
				series: {
					marker: {
						enabled: false
					}
				}
			},
			yAxis: [{
				allowDecimals: false,
				lineWidth: 0,
				gridLineWidth: 0,
				tickWidth: 0,
				//tickInterval: visitorCountDynamicTickInterval,
				tickPixelInterval: 15,
				tickPosition: 'inside',
				title: {
					text: LanguageAverageNoofVisitor,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				labels: {
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					},
				},
				min: 0,
			},
			{
				allowDecimals: false,
				opposite: true,
				gridLineWidth: 1,
				tickWidth: 1,
				//tickInterval: outsideTrafficDynamicTickInterval,
				tickPixelInterval: 15,
				lineWidth: 0,
				labels: {
					align: 'right',
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				title: {
					text: LanguageAverageOutsideTraffic,
					margin: 30,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				min: 0
			}
			],
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				title: {
					text: "", //LanguageHour,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},

			legend: {
				//itemStyle: {
				//    color: colorScheme.chart.legend.text.color,
				//    "font-family": colorScheme.chart.legend.text.fontFamily,
				//    fontSize: colorScheme.chart.legend.text.fontSize,
				//    "font-weight": colorScheme.chart.legend.text.fontWeight
				//},
				enabled: false,
				//x: 60,
				//y: 15,
				//verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});
}

function bindCompanyWeekendTFAndOTTrend(datas, colorScheme) {
	$(function () {
		var lastYear = datas.series[1].ValueInInt;
		var thisYear = datas.series[1].OutsideTrafficInt;

		//identify largest value of yaxis data
		var outsideTrafficLargestValue = 0;

		for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > outsideTrafficLargestValue) {
                outsideTrafficLargestValue = thisYear[i];
            }
            thisYear[i] = thisYear[i] != null && thisYear[i] != undefined? Math.round(thisYear[i] / 2): 0;
		}

		var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1 :
			outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10 :
				outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100 :
					outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000 :
						outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000 :
							outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000 :
								1000000;

		var visitorLargestValue = 0;

        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > visitorLargestValue) {
                visitorLargestValue = lastYear[i];
            }
            lastYear[i] = lastYear[i] != null && lastYear[i] != undefined ? Math.round(lastYear[i] / 2) : 0;
        }
		var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1 :
			visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10 :
				visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100 :
					visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000 :
						visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000 :
							visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000 :
								1000000;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "companyWeekendsOutsideTraffic",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false
			},
			series: [{
				type: 'areaspline',
				name: LanguageOutsideTraffic,
				data: thisYear,
				color: colorScheme.chart.matrices.outsideTraffic,
				fillOpacity: 0.15,
				lineWidth: 1.25,
				yAxis: 1
			}, {
				type: 'column',
				name: LanguageVisitor,
				data: lastYear,
				color: colorScheme.chart.matrices.noOfVisitor,
				borderWidth: 0
			}],
			credits: {
				enabled: false
			},
			title: {
				text: ''
			},
			subtitle: {
				text: LanguageWeekends, // + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingMondaytoFriday + "'></i>",
				align: 'center',
				style: {
					color: colorScheme.chart.subtitle.color,
					fontSize: colorScheme.chart.subtitle.fontSize,
					"font-family": colorScheme.chart.subtitle.fontFamily
				},
				margin: 0,
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				},
				series: {
					marker: {
						enabled: false
					}
				}
			},
			yAxis: [{
				allowDecimals: false,
				lineWidth: 0,
				gridLineWidth: 0,
				tickWidth: 0,
				//tickInterval: visitorCountDynamicTickInterval,
				tickPixelInterval: 15,
				tickPosition: 'inside',
				title: {
					text: LanguageAverageNoofVisitor,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				labels: {
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					},
				},
				min: 0,
			},
			{
				allowDecimals: false,
				opposite: true,
				gridLineWidth: 1,
				tickWidth: 1,
				//tickInterval: outsideTrafficDynamicTickInterval,
				tickPixelInterval: 15,
				lineWidth: 0,
				labels: {
					align: 'right',
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				title: {
					text: LanguageAverageOutsideTraffic,
					margin: 30,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				min: 0
			}
			],
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				title: {
					text: "", //LanguageHour,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},

			legend: {
				//itemStyle: {
				//    color: colorScheme.chart.legend.text.color,
				//    "font-family": colorScheme.chart.legend.text.fontFamily,
				//    fontSize: colorScheme.chart.legend.text.fontSize,
				//    "font-weight": colorScheme.chart.legend.text.fontWeight
				//},
				enabled: false,
				//x: 60,
				//y: 15,
				//verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});
}


//--------------Visit Duration--------------//
//Visit Duration Monthly Trend
function bindCompanyVisitDurationMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[4];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyVisitDurationMonthlyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 17,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //useHTML: true,
                        //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragevisittimeinmins + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.visitDuration,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=23&branchId=-1&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageAverageVisitDurationmins,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageMonth,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 96,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true)
                }
            });
    });
}

//Visit Duration Daily Trend
function bindCompanyVisitDurationDailyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[0];
        var thisYear = datas.series[4];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyVisitDurationDailyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    marker: {
                        enabled: false
                    },
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    marker: {
                        enabled: false
                    },
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //useHTML: true,
                        //text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragetimeofvisitinminutes + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.visitDuration,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    marker: {
                        enabled: false
                    },
                    series: {
                        marker: {
                            enabled: false
                        }
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageAverageVisitDuration,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    tickInterval: 1,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }

                    }
                },

                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 260,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true)
                }
            });
    });
}

//Visit Duration This Weeks Three Categories Donut Chart
function bindCompanyThisWeekAverageVisitDuration(threeCategoryDatas, lastTwoWeeksDatas, colorScheme) {
    var thisYearFirstCat = threeCategoryDatas.series[9].data;
    var thisYearSecondCat = threeCategoryDatas.series[10].data;
    var thisYearThirdCat = threeCategoryDatas.series[11].data;

    var firstCatAveragePercentage = threeCategoryDatas.series[9].total;
    var secondCatAveragePercentage = threeCategoryDatas.series[10].total;
    var thirdCatAveragePercentage = threeCategoryDatas.series[11].total;

    var thisWeekAverage = lastTwoWeeksDatas.series[1].total;

    var donutChartColors = $.map(colorScheme.chart.donut, function(value, index) {
        return [value];
    });

    $(function() {
        chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'companyThisWeekAverageDurationDonutChart',
                    type: 'pie'
                },
                colors: donutChartColors,
                title: {
                    text: ''
                },
                yAxis: {
                    title: {
                        text: ''
                    }
                },
                plotOptions: {
                    pie: {
                        dataLabels: {
                            enabled: true,
                            distance: -30,
                            style: {
                                fontFamily: colorScheme.chart.dataLabel.fontFamily,
                                color: colorScheme.chart.dataLabel.color,
                                fontSize: colorScheme.chart.dataLabel.fontSize,
                                fontWeight: colorScheme.chart.dataLabel.fontWeight
                            },
                            formatter: function() {
                                return "<b>" + this.y + '%</b>';
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function() {
                        return "<b>" + this.y + '%</b>';
                    }
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        fontFamily: colorScheme.chart.legend.text.fontFamily,
                        //fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    margin: 0
                },
                series: [{
                    name: LanguageThisWeekAverage,
                    data: [
                        [threeCategoryDatas.series[9].name, firstCatAveragePercentage],
                        [threeCategoryDatas.series[10].name, secondCatAveragePercentage],
                        [threeCategoryDatas.series[11].name, thirdCatAveragePercentage]
                    ],
                    size: '100%',
                    innerSize: '60%',
                    showInLegend: true,
                }]
            },

            function(chart) {
                var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                var textY = chart.plotTop + (chart.plotHeight * 0.5);

                var span = '<span id="VDpieChartInfoText" style="position:absolute; text-align:center;">';
                span += "<span class='pieChartInfoTextTitle'>" + kFormatter(thisWeekAverage) + Languagemin + '</span><br>';
                span += '<span class="pieChartInfoTextSubtitle">';
                span += '<span>' + LanguageThisWeek + '</span><br />';
                span += '<span>' + LanguageAverage + '</span>';
                span += '</span></span>';

                $("#companyVisitDurationDonutChartCenterText").empty();
                $("#companyVisitDurationDonutChartCenterText").append(span);
                span = $('#VDpieChartInfoText');
                span.css('left', textX + (span.width() * -0.5));
                span.css('top', textY + (span.height() * -0.5));

                $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
                $('#VDpieChartInfoText').css("display", "none");
            });
    });
}

var visitDurationSparkLineValue = [];
//Visit Duration Sparline Graph
function bindCompanyLastTwoWeekVisitDurationDataIntoTable(data, colorScheme) {
    visitDurationSparkLineValue = data.series[1].data;
    $('#companyDifferenceVisitDurationInPercentage').empty();
    //$("#companyVisitDurationUpDownIcon").empty();
    $('#companyVisitDurationThisWeek').empty();
    //$('#companyVisitDurationLastWeek').empty();
    var aveThisWeekVD = data.series[1].total;
    var aveLastWeekVD = data.series[0].total;
    var aveVDDifferenceInPercentage = data.series[2].total;

    $('#companyDifferenceVisitDurationInPercentage').removeClass("rise");
    $('#companyDifferenceVisitDurationInPercentage').removeClass("drop");

    if (aveLastWeekVD == 0 || aveThisWeekVD == 0 || aveThisWeekVD == aveLastWeekVD || aveVDDifferenceInPercentage == 0) {
        $('#companyDifferenceVisitDurationInPercentage').append(LanguageNoChanges);
        //$("#companyVisitDurationUpDownIcon").empty();
    } else if (aveThisWeekVD > aveLastWeekVD) {
        $('#companyDifferenceVisitDurationInPercentage').addClass("rise");
        //$("#companyVisitDurationUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#companyDifferenceVisitDurationInPercentage').append("<i class='fa fa-caret-up'></i> " + kFormatter(aveVDDifferenceInPercentage) + "%");
    } else if (aveThisWeekVD < aveLastWeekVD) {
        $('#companyDifferenceVisitDurationInPercentage').addClass("drop");
        //$("#companyVisitDurationUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#companyDifferenceVisitDurationInPercentage').append("<i class='fa fa-caret-down'></i> " + kFormatter(aveVDDifferenceInPercentage * -1) + "%");
    }

    aveThisWeekVD = aveThisWeekVD == 0 ? " - " : aveThisWeekVD.toFixed(2) + "m";
    //aveLastWeekVD = aveLastWeekVD == 0 ? " - " : aveLastWeekVD + Languageminutes;

    $('#companyVisitDurationThisWeek').append(aveThisWeekVD);
    //$('#companyVisitDurationLastWeek').text("( " + LanguageLastWeek + ": " + aveLastWeekVD + ")");
}



//--------------Returning Customer--------------//
//Returning Customer Monthly Trend
function bindCompanyReturningCustomerMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYearReturningRate = datas.series[0];
        var thisYearReturningRate = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYearReturningRate.data.length; i++) {
            if (lastYearReturningRate.data[i] != null &&
                lastYearReturningRate.data[i] != undefined &&
                lastYearReturningRate.data[i] > largestValue) {
                largestValue = lastYearReturningRate.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYearReturningRate.data.length; i++) {
            if (thisYearReturningRate.data[i] != null && thisYearReturningRate.data[i] != undefined && thisYearReturningRate.data[i] > largestValue)
                largestValue = thisYearReturningRate.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyReturningCustomerMonthlyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear, //thisYearReturningRate.name,
                    data: thisYearReturningRate.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 17,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear, //lastYearReturningRate.name,
                    dashStyle: 'dash',
                    data: lastYearReturningRate.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //useHTML: true,
                        //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagereturningcustomerwithinlast7days + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.returningCust,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=22&branchId=-1&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageReturningRateprecent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: datas.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageMonth,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 96,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true)
                }
            });
    });
}

//Returning Customer Weekly Trend
function bindCompanyReturningRateWeeklyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function() {
        var lastYear = datas.series[1];
        var thisYear = datas.series[0];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "companyReturningCustomerWeeklyTrend",
                    events: {
                        load: function() {
                            chartEvent[3] = this;
                        }
                    }
                },
                series: [{
                    type: 'column',
                    name: LanguageThisYear, //LanguageThisYearReturningRate,
                    data: thisYear.data,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageLastYear, //LanguageLastYearReturningRate,
                    dashStyle: 'dash',
                    data: lastYear.data,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                        //useHTML: true,
                        //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagecustomerreturninginthepast7days + "'></i>",
                        //align: 'left',
                        //style: {
                        //    color: colorScheme.chart.title.color.returningCust,
                        //    "font-family": colorScheme.chart.title.fontFamily,
                        //    fontSize: colorScheme.chart.title.fontSize,
                        //    textDecoration: colorScheme.chart.title.textDecoration,
                        //    "font-weight": colorScheme.chart.title.fontWeight
                        //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function() {
                                    location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=22&branchId=-1&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageReturningRateprecent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                xAxis: {
                    categories: [{
                        categories: datas.categories
                    }],
                    tickWidth: 0,
                    title: {
                        text: LanguageWeek,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 260,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            },
            function(chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true)
                }
            });
    });
}

//Returning Customer Daily Trend
function bindCompanyReturningCustomerDailyTrend(datas, colorScheme) {
    $(function() {
        var thisWeekRCReturningRate = datas.series[4];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < thisWeekRCReturningRate.data.length; i++) {
            if (thisWeekRCReturningRate.data[i] != null && thisWeekRCReturningRate.data[i] != undefined && thisWeekRCReturningRate.data[i] > largestValue)
                largestValue = thisWeekRCReturningRate.data[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
            largestValue >= 100 && largestValue < 1000 ? 100 :
            largestValue >= 1000 && largestValue < 10000 ? 1000 :
            largestValue >= 10000 && largestValue < 100000 ? 10000 :
            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
            1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyReturningCustomerDailyTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisWeek, //thisWeekRCReturningRate.name,
                data: thisWeekRCReturningRate.data,
                color: colorScheme.time.year.thisYear,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //useHTML: true,
                    //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentageofreturningcustomerforthisweek + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.returningCust,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageReturningRateprecent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: 0,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

var sparkLineValueReturnCust = [];
var sparkLineValueNewCust = [];
var sparkLineValueHighestRise = [];
var sparklineValueHighestDrop = [];

function drawSparkLine(data, colorScheme) {
    if (turnInRateSparkLineValue[5] == 0 && turnInRateSparkLineValue[6] == 0) {
        turnInRateSparkLineValue[6] = null;
        turnInRateSparkLineValue[5] = null;
    } else if (turnInRateSparkLineValue[6] == 0) {
        turnInRateSparkLineValue[6] = null;
    }
    if (turnInRateSparkLineValue[0] == 0 && turnInRateSparkLineValue[1] == 0 && turnInRateSparkLineValue[2] == 0 && turnInRateSparkLineValue[3] == 0 && turnInRateSparkLineValue[4] == 0 && turnInRateSparkLineValue[5] == null && turnInRateSparkLineValue[6] == null) {
        turnInRateSparkLineValue[5] = 0;
        turnInRateSparkLineValue[6] = 0;
    }
    if (turnInRateSparkLineValue[0] == 0 && turnInRateSparkLineValue[1] == 0 && turnInRateSparkLineValue[2] == 0 && turnInRateSparkLineValue[3] == 0 && turnInRateSparkLineValue[4] == 0 && turnInRateSparkLineValue[5] == 0 && turnInRateSparkLineValue[6] == null) {
        turnInRateSparkLineValue[6] = 0;
    }
    if (visitDurationSparkLineValue[5] == 0 && visitDurationSparkLineValue[6] == 0) {
        visitDurationSparkLineValue[6] = null;
        visitDurationSparkLineValue[5] = null;
    } else if (visitDurationSparkLineValue[6] == 0) {
        visitDurationSparkLineValue[6] = null;
    }
    if (visitDurationSparkLineValue[0] == 0 && visitDurationSparkLineValue[1] == 0 && visitDurationSparkLineValue[2] == 0 && visitDurationSparkLineValue[3] == 0 && visitDurationSparkLineValue[4] == 0 && visitDurationSparkLineValue[5] == null && visitDurationSparkLineValue[6] == null) {
        visitDurationSparkLineValue[5] = 0;
        visitDurationSparkLineValue[6] = 0;
    }
    if (visitDurationSparkLineValue[0] == 0 && visitDurationSparkLineValue[1] == 0 && visitDurationSparkLineValue[2] == 0 && visitDurationSparkLineValue[3] == 0 && visitDurationSparkLineValue[4] == 0 && visitDurationSparkLineValue[5] == 0 && visitDurationSparkLineValue[6] == null) {
        visitDurationSparkLineValue[6] = 0;
    }
    var miniChartId = ['company7daysVisitorGraph', 'company7daysTurnInRate', 'company7daysVisitDuration', 'company7daysReturningCustomer', 'company7daysNewVisitorGraph', 'company7daysHighestTurnRate', 'company7daysLowestTurnInRate', 'company7daysHighestRise', 'company7daysHighestDrop'];
    var miniChartData = [visitorCountsSparkline, turnInRateSparkLineValue, visitDurationSparkLineValue, sparkLineValueReturnCust, sparkLineValueNewCust, highestTurnInRateSparkLineValue, lowestTurnInRateSparkLineValue, companyHighestRiseFFBranch7DaysData, companyHighestDropFFBranch7DaysData];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function() {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });

            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    },
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
    sparkLineValueReturnCust = [];
    sparkLineValueNewCust = [];

}

//Returning Customer Sparkline and Donut Chart
function bindCompanyLastTwoWeeksReturningCustomerDataIntoTable(newReturnCustData, colorScheme) {
    sparkLineValueReturnCust = newReturnCustData.series[3].data;
    sparkLineValueNewCust = newReturnCustData.series[1].data;

    $('#companyDifferenceReturningCustomerInPercentage').empty();
    //$('#companyReturningCustomerUpDownIcon').empty();
    $('#companyReturningCustomerThisWeek').empty();
    //$('#companyReturningCustomerLastWeek').empty();

    var aveThisWeekRR = newReturnCustData.series[3].total;
    var aveLastWeekRR = newReturnCustData.series[2].total;
    var averageChangesInPercentage = newReturnCustData.series[5].total;
    $('#companyDifferenceReturningCustomerInPercentage').removeClass("drop");
    $('#companyDifferenceReturningCustomerInPercentage').removeClass("rise");

    if (aveLastWeekRR == 0 || aveThisWeekRR == 0 || averageChangesInPercentage == 0) {
        $('#companyDifferenceReturningCustomerInPercentage').append(LanguageNoChanges);
        //$("#companyReturningCustomerUpDownIcon").html("");
    } else if (aveLastWeekRR > aveThisWeekRR) {
        $('#companyDifferenceReturningCustomerInPercentage').addClass("drop");
        //$("#companyReturningCustomerUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#companyDifferenceReturningCustomerInPercentage').append("<i class='fa fa-caret-down'></i> " + kFormatter(averageChangesInPercentage) + "%");
    } else if (aveLastWeekRR < aveThisWeekRR) {
        $('#companyDifferenceReturningCustomerInPercentage').addClass("rise");
        //$("#companyReturningCustomerUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#companyDifferenceReturningCustomerInPercentage').append("<i class='fa fa-caret-up'></i> " + kFormatter(averageChangesInPercentage) + "%");
    }

    aveThisWeekRR = aveThisWeekRR == 0 ? " - " : aveThisWeekRR + "%";
    //aveLastWeekRR = aveLastWeekRR == 0 ? " - " : aveLastWeekRR + "%";
    $('#companyReturningCustomerThisWeek').append(aveThisWeekRR);
    //$('#companyReturningCustomerLastWeek').text("( " + LanguageLastWeek + ": " + aveLastWeekRR + ")");


    $('#companyDifferenceNewCustomerInPercentage').empty();
    //$('#companyNewVisitorUpDownIcon').empty();
    $('#companyNewVisitorThisWeek').empty();
    //$('#companyNewVisitorLastWeek').empty();
    var averageLastWeekNewPercentage = newReturnCustData.series[0].total;
    var averageThisWeekNewPercentage = newReturnCustData.series[1].total;
    var averageChangesInNewPercentage = newReturnCustData.series[4].total;
    $('#companyDifferenceNewCustomerInPercentage').removeClass("drop");
    $('#companyDifferenceNewCustomerInPercentage').removeClass("rise");

    if (averageLastWeekNewPercentage == 0 || averageThisWeekNewPercentage == 0 || averageChangesInNewPercentage == 0 || averageLastWeekNewPercentage == averageThisWeekNewPercentage) {
        $('#companyDifferenceNewCustomerInPercentage').append(LanguageNoChanges);
        //$("#companyNewVisitorUpDownIcon").html("");
    } else if (averageLastWeekNewPercentage > averageThisWeekNewPercentage) {
        $('#companyDifferenceNewCustomerInPercentage').addClass("drop");
        //$("#companyNewVisitorUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#companyDifferenceNewCustomerInPercentage').append("<i class='fa fa-caret-down'></i> " + kFormatter(averageChangesInNewPercentage) + "%");
    } else if (averageLastWeekNewPercentage < averageThisWeekNewPercentage) {
        $('#companyDifferenceNewCustomerInPercentage').addClass("rise");
        //$("#companyNewVisitorUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#companyDifferenceNewCustomerInPercentage').append("<i class='fa fa-caret-up'></i> " + kFormatter(averageChangesInNewPercentage) + "%");
    }

    averageThisWeekNewPercentage = averageThisWeekNewPercentage == 0 ? " - " : kFormatter(averageThisWeekNewPercentage) + "%";
    //averageLastWeekNewPercentage = averageLastWeekNewPercentage == 0 ? " - " : kFormatter(averageLastWeekNewPercentage) + "%";
    $('#companyNewVisitorThisWeek').append(averageThisWeekNewPercentage);
    //$('#companyNewVisitorLastWeek').text("( " + LanguageLastWeek + ": " + averageLastWeekNewPercentage + ")");

    var donutChartColors = $.map(colorScheme.chart.donut, function(value, index) {
        return [value];
    });

    $(function() {
        chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'companyThisWeekAverageReturningCustomerDonutChart',
                    type: 'pie'
                },
                colors: donutChartColors,
                title: {
                    text: ''
                },
                yAxis: {
                    title: {
                        text: ''
                    }
                },
                plotOptions: {
                    pie: {
                        shadow: false,
                        dataLabels: {
                            enabled: true,
                            distance: -30,
                            style: {
                                fontFamily: colorScheme.chart.dataLabel.fontFamily,
                                color: colorScheme.chart.dataLabel.color,
                                fontSize: colorScheme.chart.dataLabel.fontSize,
                                fontWeight: colorScheme.chart.dataLabel.fontWeight
                            },
                            formatter: function() {
                                return "<b>" + this.y + '%</b>';
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function() {
                        return '<b>' + this.point.name + '</b>: ' + this.y + ' %';
                    }
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        fontFamily: colorScheme.chart.legend.text.fontFamily,
                        //fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    margin: 0
                },
                series: [{
                    name: LanguageThisWeekAverage,
                    data: [
                        [LanguageNewCustomer, parseFloat(averageThisWeekNewPercentage)],
                        [LanguageReturningCustomer, parseFloat(aveThisWeekRR)]
                    ],
                    size: '100%',
                    innerSize: '60%',
                    showInLegend: true,
                }]
            },

            function(chart) { // on complete
                var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                var textY = chart.plotTop + (chart.plotHeight * 0.5);

                var span = '<span id="RRpieChartInfoText" style="position:absolute; text-align:center;">';
                span += '<span class="pieChartInfoTextTitle">' + aveThisWeekRR + '</span><br>';
                span += '<span class="pieChartInfoTextSubtitle">';
                span += '<span>' + LanguageThisWeek + '</span><br />';
                span += '<span>' + LanguageAverage + '</span>';
                span += '</span></span>';

                $("#companyReturningCustomerDonutChartCenterText").empty();
                $("#companyReturningCustomerDonutChartCenterText").append(span);
                span = $('#RRpieChartInfoText');
                span.css('left', textX + (span.width() * -0.43));
                span.css('top', textY + (span.height() * -0.5));

                $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
            });
    });
}





////--------------Sale Conversions--------------//
////Sale Conversions Monthly Trend
function bindCompanyMonthlySCtrend(data, colorScheme) {
    $(function() {
        var footfall = data.series[0];
        var transactionCount = data.series[1];

        //identify largest value of yaxis data
        var footfallLargestValue = 0;
        for (var i = 0; i < footfall.data.length; i++) {
            if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
                footfallLargestValue = footfall.data[i]
        }
        var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1 :
            footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10 :
            footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100 :
            footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000 :
            footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000 :
            footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000 :
            1000000;

        var transactionLargestValue = 0;
        for (var i = 0; i < transactionCount.data.length; i++) {
            if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
                transactionLargestValue = transactionCount.data[i]
        }
        var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1 :
            transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10 :
            transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100 :
            transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000 :
            transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000 :
            transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000 :
            1000000;
        if (transactionDynamicTickInterval == 1) {
            transactionDynamicTickInterval = footfallDynamicTickInterval;
        }
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyMonthlySCTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0,
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //useHTML: true,
                    //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageMonthlypercentofspendingvisitors + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0
            }, {
                opposite: true,
                lineWidth: 0,
                tickWidth: 0,
                min: 0,
                gridLineWidth: 0,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 18,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Table
function bindCompanyLastTwoWeekSCInTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = weekNumber;

    var weekDay = new Array(7);
    if (firstDayOfWeek == "Sunday") {
        weekDay[0] = LanguageSunday;
        weekDay[1] = LanguageMonday;
        weekDay[2] = LanguageTuesday;
        weekDay[3] = LanguageWednesday;
        weekDay[4] = LanguageThursday;
        weekDay[5] = LanguageFriday;
        weekDay[6] = LanguageSaturday;
    } else if (firstDayOfWeek == "Saturday") {
        weekDay[0] = LanguageSaturday;
        weekDay[1] = LanguageSunday;
        weekDay[2] = LanguageMonday;
        weekDay[3] = LanguageTuesday;
        weekDay[4] = LanguageWednesday;
        weekDay[5] = LanguageThursday;
        weekDay[6] = LanguageFriday;
    } else if (firstDayOfWeek == "Friday") {
        weekDay[0] = LanguageFriday;
        weekDay[1] = LanguageSaturday;
        weekDay[2] = LanguageSunday;
        weekDay[3] = LanguageMonday;
        weekDay[4] = LanguageTuesday;
        weekDay[5] = LanguageWednesday;
        weekDay[6] = LanguageThursday;
    } else {
        weekDay[0] = LanguageMonday;
        weekDay[1] = LanguageTuesday;
        weekDay[2] = LanguageWednesday;
        weekDay[3] = LanguageThursday;
        weekDay[4] = LanguageFriday;
        weekDay[5] = LanguageSaturday;
        weekDay[6] = LanguageSunday;
    }

    $("#companyLastTwoWeeksSCtableHead").html("");
    $("#companyLastTwoWeeksSCtableContent").html("");
    $("#companyLastTwoWeeksSCtableFoot").html("");
    $("#companyLastTwoWeeksSCtableHead").append("<tr><th>" + LanguageWeek + " " + weekNumber + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageSalesVolume + "</th><th>" + LanguageConversion + "</th></tr>");

    var visitor = 0;
    var sales = 0;
    var salesConversion = 0;
    var reportSalesData = [data.series[1].data];
    var hasData = checkHasData(reportSalesData);
    if (hasData) {
        $('#salesConversionSection').css('display', 'block');
        $('#salesConversionMiniGraph').css('display', 'block');

        for (var i = 0; i < 7; i++) {
            visitor = data.series[0].data[i];
            sales = data.series[1].data[i];
            salesConversion = data.series[2].data[i];

            if (visitor == 0 || sales == 0 || salesConversion == 0) {
                salesConversion = " - ";
            } else {
                salesConversion = kFormatter(salesConversion) + "%";
            }

            visitor = visitor == 0 ? " - " : visitor;
            sales = sales == 0 ? " - " : sales;
            $("#companyLastTwoWeeksSCtableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + visitor + "</td><td>" + sales + "</td><td>" + salesConversion + "</td></tr>");
        }
        var totalVisitors = data.series[0].total;
        var totalSales = data.series[1].total;
        var totalSalesConversion = data.series[2].total;

        if (totalVisitors == 0 || totalSales == 0 || totalSalesConversion == 0) {
            totalSalesConversion = " - ";
        } else {
            totalSalesConversion = kFormatter(totalSalesConversion) + "%";
        }

        totalVisitors = totalVisitors == 0 ? " - " : totalVisitors;
        totalSales = totalSales == 0 ? " - " : totalSales;

        $("#companyLastTwoWeeksSCtableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalVisitors + "</td><td>" + totalSales + "</td><td>" + totalSalesConversion + "</td></tr>");
    } else {
        $('#salesConversionSection').css('display', 'none');
        $('#salesConversionMiniGraph').css('display', 'none');

    }
}

//Sale Conversions Weekly Trend
function bindCompanyWeeklySCtrend(data, colorScheme) {
    var tempWeek = [];
    for (var i = 1; i <= data.categories.length; i++) {
        tempWeek.push(i);
    }

    var footfall = data.series[0];
    var transactionCount = data.series[1];

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > largestValue)
            largestValue = footfall.data[i]
    }

    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > largestValue)
            largestValue = transactionCount.data[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
        largestValue >= 10 && largestValue < 100 ? 10 :
        largestValue >= 100 && largestValue < 1000 ? 100 :
        largestValue >= 1000 && largestValue < 10000 ? 1000 :
        largestValue >= 10000 && largestValue < 100000 ? 10000 :
        largestValue >= 100000 && largestValue < 1000000 ? 100000 :
        1000000;

    $(function() {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeeklySCTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //useHTML: true,
                    //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagespendingvisitorsforeachweek + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0
                },
                {
                    opposite: true,
                    lineWidth: 0,
                    tickWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0
                }
            ],
            xAxis: {
                min: 0,
                categories: tempWeek,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Sale Conversions Daily Trend
function bindCompanyDailySCtrend(data, colorScheme) {

    var footfall = data.series[0];
    var transactionCount = data.series[1];

    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1 :
        footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10 :
        footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100 :
        footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000 :
        footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000 :
        footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000 :
        1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1 :
        transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10 :
        transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100 :
        transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000 :
        transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000 :
        transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000 :
        1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }
    $(function() {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyDailySCTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //useHTML: true,
                    //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentofspendingvisitors + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                    lineWidth: 0,
                    tickWidth: 1,
                    min: 0,
                    gridLineWidth: 1,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    lineWidth: 0,
                    tickWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageSalesVolume,
                        margin: 25,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                }
            ],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Sales Conversions Last 7 Days Trend
function bindCompanyLastSevenDaysSCTrend(data, colorScheme) {

    var footfall = data.series[0];
    var transactionCount = data.series[1];

    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1 :
        footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10 :
        footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100 :
        footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000 :
        footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000 :
        footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000 :
        1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1 :
        transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10 :
        transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100 :
        transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000 :
        transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000 :
        transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000 :
        1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }
    $(function() {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "company7DaysSCTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'areaspline',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                    //useHTML: true,
                    //text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + Languagespendingvisitorsforeachhour + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    tickWidth: 0,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                }
            ],
            xAxis: {
                categories: [{
                        name: ifmonday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }, {
                        name: iftuesday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }, {
                        name: ifwednesday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifthursday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: iffriday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifsaturday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    },
                    {
                        name: ifsunday,
                        categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                    }
                ],
                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//Weekdays and Weekends Trend
function bindCompanyWeekdaysWeekendsTrend(data, data1, colorScheme) {
    var weekdaysnoofvisitor = data.series[0];
    var weekdayssalesvolume = data.series[1];
    var weekendsnoofvisitor = data1.series[0];
    var weekendssalesvolume = data1.series[1];
    //identify largest value of yaxis data
    var largestValue = 0;

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekdaysnoofvisitor.data.length; i++) {
        if (weekdaysnoofvisitor.data[i] != null && weekdaysnoofvisitor.data[i] != undefined && weekdaysnoofvisitor.data[i] > largestValue)
            largestValue = weekdaysnoofvisitor.data[i]
    }
    for (var i = 0; i < weekdayssalesvolume.data.length; i++) {
        if (weekdayssalesvolume.data[i] != null && weekdayssalesvolume.data[i] != undefined && weekdayssalesvolume.data[i] > largestValue)
            largestValue = weekdayssalesvolume.data[i]
    }
    for (var i = 0; i < weekendsnoofvisitor.data.length; i++) {
        if (weekendsnoofvisitor.data[i] != null && weekendsnoofvisitor.data[i] != undefined && weekendsnoofvisitor.data[i] > largestValue)
            largestValue = weekendsnoofvisitor.data[i]
    }
    for (var i = 0; i < weekendssalesvolume.data.length; i++) {
        if (weekendssalesvolume.data[i] != null && weekendssalesvolume.data[i] != undefined && weekendssalesvolume.data[i] > largestValue)
            largestValue = weekendssalesvolume.data[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
        largestValue >= 10 && largestValue < 100 ? 10 :
        largestValue >= 100 && largestValue < 1000 ? 100 :
        largestValue >= 1000 && largestValue < 10000 ? 1000 :
        largestValue >= 10000 && largestValue < 100000 ? 10000 :
        largestValue >= 100000 && largestValue < 1000000 ? 100000 :
        1000000;

    //weekdays trend
    $(function() {

        var showMarker = true;
        var showPopUp = true;
        if (data.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekdaysSCTrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdaysnoofvisitor.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekdayssalesvolume.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekdays, // + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsfromMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                },
                {
                    opposite: true,
                    lineWidth: 0,
                    tickWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                }
            ],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        if (data.series[0].isDayOff) {
            $("#companyWeekdaysSCTrend").append("<div class='weekday-notice'>" + LanguageCloseonWeekdays + "</div>");
        }
    });


    //weekends trend
    $(function() {
        var showMarker = true;
        var showPopUp = true;
        if (data1.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "companyWeekendsSCtrend",
                events: {
                    load: function() {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendsnoofvisitor.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekendssalesvolume.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekends, // + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    tickWidth: 0,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    }
                }
            ],
            xAxis: {
                categories: data1.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 60,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
        if (data1.series[0].isDayOff) {
            $("#companyWeekendsSCtrend").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });

}

//Sales Conversion This Week and Last Week Highchart
function bindCompanyLastTwoWeekSalesConversion(data, colorScheme) {
    $("#companySaleConversionUpDownIcon").empty();
    var SCSparkLineValue = [];

    //$('#companySaleConversionUpDownIcon').empty();
    $("#companyDifferenceSaleConversionInPercentage").empty();
    $("#companySaleConversionThisWeek").empty();
    //$("#companySaleConversionLastWeek").empty();

    var lastWeekTotal = data.series[0].total;
    var thisWeekTotal = data.series[1].total;
    var changesInTwoWeeks = kFormatter(data.series[2].total);
    $('#companyDifferenceSaleConversionInPercentage').removeClass("rise");
    $('#companyDifferenceSaleConversionInPercentage').removeClass("drop");

    if (thisWeekTotal == 0 || lastWeekTotal == 0) {
        //$('#companySaleConversionUpDownIcon').html("");
        $("#companyDifferenceSaleConversionInPercentage").append(LanguageNoChanges);
    } else if (thisWeekTotal > lastWeekTotal) {
        $('#companyDifferenceSaleConversionInPercentage').addClass("rise");
        //$('#companySaleConversionUpDownIcon').append("<i class=\"fa fa-caret-up\" style=\"color: " + colorScheme.chart.arrow.up + "\">");
        $("#companyDifferenceSaleConversionInPercentage").append("<i class='fa fa-caret-up'></i> " + changesInTwoWeeks + "%");
    } else if (thisWeekTotal < lastWeekTotal) {
        $('#companyDifferenceSaleConversionInPercentage').addClass("drop");
        //$('#companySaleConversionUpDownIcon').append("<i class=\"fa fa-caret-down\" style=\"color: " + colorScheme.chart.arrow.down + "\">");
        $("#companyDifferenceSaleConversionInPercentage").append("<i class='fa fa-caret-down'></i> " + changesInTwoWeeks * -1 + "%");
    }

    lastWeekTotal = lastWeekTotal == 0 ? " - " : lastWeekTotal + "%";
    //thisWeekTotal = thisWeekTotal == 0 ? " - " : thisWeekTotal + "%";
    $("#companySaleConversionThisWeek").append(kFormatter(thisWeekTotal) + "%");
    //$("#companySaleConversionLastWeek").text("( " + LanguageLastWeek + ": " + thisWeekTotal + ")");

    SCSparkLineValue = data.series[1].data;

    $(function() {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({

            chart: {
                renderTo: 'company7daysSaleConversion',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 1,
                endOnTick: false,
                labels: {
                    enabled: false
                },
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: SCSparkLineValue,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });

}




//Region statistic
function getRegionStatisticData(data, colorScheme) {
    $("#companyBranchesStatistic").empty();
    $("#company5BestBranchesStatistic").empty();
    $("#company5WorstBranchesStatistic").empty();



    var branchId = data.series[2].branchId;
    var branchName = data.series[2].branchName;
    var tableData = data.series[2].data;

    var ranking = 0;

    for (var i = branchId.length - 1; i >= 0; i--) {
        tableData[i][0] = tableData[i][0] > 0 ? tableData[i][0].toFixed(0) : "-"; //Visitor Count This Week
        tableData[i][2] = tableData[i][2] > 0 ? tableData[i][2].toFixed(2) : "-"; //Turn In Rate This Week
        tableData[i][4] = tableData[i][4] > 0 ? tableData[i][4].toFixed(2) : "-"; //Visit Duration This Week
        tableData[i][6] = tableData[i][6] > 0 ? tableData[i][6].toFixed(0) : "-"; //Returning Customer This Week

        //tableData[i][1]-Visitor Count Changes
        //tableData[i][3]-Turn In Rate Changes
        //tableData[i][5]-Visit Duration Changes
        //tableData[i][7]-Returning Customer Changes
        tableData[i][1] = tableData[i][1].toFixed(2) == 0 ? "-" : tableData[i][1].toFixed(2) < 0 ? "<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i> " + tableData[i][1].toFixed(2) * -1 : "<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i> " + tableData[i][1].toFixed(2);
        tableData[i][3] = tableData[i][3].toFixed(2) == 0 ? "-" : tableData[i][3].toFixed(2) < 0 ? "<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i> " + tableData[i][3].toFixed(2) * -1 : "<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i> " + tableData[i][3].toFixed(2);
        tableData[i][5] = tableData[i][5].toFixed(2) == 0 ? "-" : tableData[i][5].toFixed(2) < 0 ? "<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i> " + tableData[i][5].toFixed(2) * -1 : "<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i> " + tableData[i][5].toFixed(2);
        tableData[i][7] = tableData[i][7].toFixed(2) == 0 ? "-" : tableData[i][7].toFixed(2) < 0 ? "<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i> " + tableData[i][7].toFixed(2) * -1 : "<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i> " + tableData[i][7].toFixed(2);

        //ranking = tableData[i][3] != "-" ? ranking + 1 : "-";
        ranking = tableData[i][0] != "-" ? ranking + 1 : "-";
        $("#companyBranchesStatistic").append("<tr data-branchID=" + branchId[i] + " onclick='ViewSiteWeeklyReport(" + branchId[i] + ")'><td>" +
            branchName[i] + "</div></td><td>" + ranking + "</td><td>" + tableData[i][0] + "</td><td>" +
            tableData[i][1] + "</td><td>" + tableData[i][2] + "</td><td>" +
            tableData[i][3] + "</td><td>" + tableData[i][4] + "</td><td>" +
            tableData[i][5] + "</td><td>" + tableData[i][6] + "</td><td>" +
            tableData[i][7] + "</td></tr>");
    }

    if (data.series[1].ValueIn.length >= 20) {
        document.getElementById("bestAndWorstStores").style.display = "inherit";

        //10 best
        ranking = 0;
        for (var i = data.series[1].ValueIn.length + 1; i >= data.series[1].ValueIn.length - 9; i--) {
            ranking = ranking + 1;

            $("#company5BestBranchesStatistic").append("<tr><td><div style='cursor:pointer;' data-branchID=" + branchId[i] + ">" +
                branchName[i] + "</div></td><td>" + ranking + "</td><td>" + tableData[i][0] + "</td><td>" +
                tableData[i][1] + "</td><td>" + tableData[i][2] + "</td><td>" +
                tableData[i][3] + "</td><td>" + tableData[i][4] + "</td><td>" +
                tableData[i][5] + "</td><td>" + tableData[i][6] + "</td><td>" +
                tableData[i][7] + "</td></tr>");
        }

        //10 worst
        ranking = branchId.length;
        var track = 0;

       // console.log(data.series[2].data[track][0]);
        while (data.series[2].data[track][0] == "-" && track < data.series[2].data.length) {
            track = track + 1;
           // console.log("track = " + track);
        }
        ranking = ranking - track;

        for (var i = track; i < track + 10; i++) {
            $("#company5WorstBranchesStatistic").append("<tr><td><div style='cursor:pointer;' data-branchID=" + branchId[i] + ">" +
                branchName[i] + "</div></td><td>" + ranking + "</td><td>" + tableData[i][0] + "</td><td>" +
                tableData[i][1] + "</td><td>" + tableData[i][2] + "</td><td>" +
                tableData[i][3] + "</td><td>" + tableData[i][4] + "</td><td>" +
                tableData[i][5] + "</td><td>" + tableData[i][6] + "</td><td>" +
                tableData[i][7] + "</td></tr>");
            ranking = ranking - 1;
        }
    }

}


//This Year This Week and Last Year This Year Comparison Tables
function footFallTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = weekNumber;
    $("#companyLastTwoWeeksComparisonTableHead").html("");
    $("#companyLastTwoWeeksComparisonTableContent").html("");
    $("#companyLastTwoWeeksComparisonTableFoot").html("");

    var thisYearFootFall = 0;
    var lastYearFootFall = 0;
    var changesFFInPercent = 0;

    var thisYearFootFallTotal = data.series[1].total;
    var lastYearFootFallTotal = data.series[0].total;
    var changesFFInTwoYears = data.series[2].total;
    thisYearFootFallTotal = thisYearFootFallTotal == 0 ? " - " : thisYearFootFallTotal;
    lastYearFootFallTotal = lastYearFootFallTotal == 0 ? " - " : lastYearFootFallTotal;

    if (lastYearFootFallTotal == " - ") {
        $("#companyLastTwoWeeksComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNumber + "</th><th>" + LanguageThisYear + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearFootFall = data.series[1].data[i];
            thisYearFootFall = thisYearFootFall == 0 ? " - " : thisYearFootFall;
            $("#companyLastTwoWeeksComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearFootFall + "</td></tr>");
        }

        $("#companyLastTwoWeeksComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearFootFallTotal + "</td></tr>");

    } else {
        $("#companyLastTwoWeeksComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNumber + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearFootFall = data.series[1].data[i];
            lastYearFootFall = data.series[0].data[i];
            changesFFInPercent = data.series[2].data[i];

            if (thisYearFootFall == 0 || lastYearFootFall == 0 || changesFFInPercent == 0) {
                changesFFInPercent = " - ";
            } else if (thisYearFootFall > lastYearFootFall) {
                changesFFInPercent = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesFFInPercent) + "%";
            } else if (thisYearFootFall < lastYearFootFall) {
                changesFFInPercent = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesFFInPercent) + "%";
            }

            thisYearFootFall = thisYearFootFall == 0 ? " - " : thisYearFootFall;
            lastYearFootFall = lastYearFootFall == 0 ? " - " : lastYearFootFall;

            $("#companyLastTwoWeeksComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearFootFall + "</td><td>" + lastYearFootFall + "</td><td>" + changesFFInPercent + "</td></tr>");
        }

        if (thisYearFootFallTotal == 0 || lastYearFootFallTotal == 0 || changesFFInTwoYears == 0) {
            changesFFInTwoYears = " - ";
        } else if (thisYearFootFallTotal > lastYearFootFallTotal) {
            changesFFInTwoYears = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesFFInTwoYears) + "%";
        } else if (thisYearFootFallTotal < lastYearFootFallTotal) {
            changesFFInTwoYears = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesFFInTwoYears) + "%";
        }

        $("#companyLastTwoWeeksComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearFootFallTotal + "</td><td>" + lastYearFootFallTotal + "</td><td>" + changesFFInTwoYears + "</td></tr>");
    }
}

function visitDurationTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = weekNumber;
    $("#companyLastTwoWeeksVisitDurationComparisonTableHead").html("");
    $("#companyLastTwoWeeksVisitDurationComparisonTableContent").html("");
    $("#companyLastTwoWeeksVisitDurationComparisonTableFoot").html("");

    var thisYearVD = 0;
    var lastYearVD = 0;
    var changesVDInPercent = 0;

    var thisYearVDTotal = data.series[1].total.toFixed(2);
    var lastYearVDTotal = data.series[0].total.toFixed(2);
    var changesVDInTwoYears = data.series[2].total;

    thisYearVDTotal = thisYearVDTotal == 0 ? " - " : thisYearVDTotal + Languagemin;
    lastYearVDTotal = lastYearVDTotal == 0 ? " - " : lastYearVDTotal + Languagemin;

	if (lastYearVDTotal == " - ") {
		$("#companyLastTwoWeeksVisitDurationComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th title='" + LanguageAverage + "'>" + LanguageThisYear + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearVD = kFormatter(data.series[1].data[i]);
            thisYearVD = thisYearVD == 0 ? " - " : thisYearVD + Languagemin;
            $("#companyLastTwoWeeksVisitDurationComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearVD + "</td></tr>");
        }

        $("#companyLastTwoWeeksVisitDurationComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearVDTotal + "</td></tr>");

	} else {
		$("#companyLastTwoWeeksVisitDurationComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th title='" + LanguageAverage + "'>" + LanguageThisYear + "</th><th title='" + LanguageAverage + "'>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearVD = kFormatter(data.series[1].data[i]);
            lastYearVD = kFormatter(data.series[0].data[i]);
            changesVDInPercent = data.series[2].data[i];

            if (thisYearVD == 0 || lastYearVD == 0 || changesVDInPercent == 0) {
                changesVDInPercent = " - ";
            } else if (thisYearVD > lastYearVD) {
                changesVDInPercent = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesVDInPercent) + "%";
            } else if (thisYearVD < lastYearVD) {
                changesVDInPercent = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesVDInPercent) + "%";
            }

            thisYearVD = thisYearVD == 0 ? " - " : thisYearVD + Languagemin;
            lastYearVD = lastYearVD == 0 ? " - " : lastYearVD + Languagemin;
            $("#companyLastTwoWeeksVisitDurationComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearVD + "</td><td>" + lastYearVD + "</td><td>" + changesVDInPercent + "</td></tr>");
        }

        if (thisYearVDTotal == 0 || lastYearVDTotal == 0 || changesVDInTwoYears == 0) {
            changesVDInTwoYears = " - ";
        } else if (thisYearVDTotal > lastYearVDTotal) {
            changesVDInTwoYears = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesVDInTwoYears) + "%";
        } else if (thisYearVDTotal < lastYearVDTotal) {
            changesVDInTwoYears = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesVDInTwoYears) + "%";
        }

        $("#companyLastTwoWeeksVisitDurationComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearVDTotal + "</td><td>" + lastYearVDTotal + "</td><td>" + changesVDInTwoYears + "</td></tr>");
    }
}

function returningRateTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = weekNumber;
    $("#companyLastTwoWeeksReturningCustomerComparisonTableHead").html("");
    $("#companyLastTwoWeeksReturningCustomerComparisonTableContent").html("");
    $("#companyLastTwoWeeksReturningCustomerComparisonTableFoot").html("");

    var thisYearRR = 0;
    var lastYearRR = 0;
    var changesRRInPercent = 0;

    var thisYearRRTotal = data.series[1].total;
    var lastYearRRTotal = data.series[0].total;
    var changesRRInTwoYears = data.series[2].total;

    thisYearRRTotal = thisYearRRTotal == 0 ? " - " : kFormatter(thisYearRRTotal) + "%";
    lastYearRRTotal = lastYearRRTotal == 0 ? " - " : kFormatter(lastYearRRTotal) + "%";

    if (lastYearRRTotal == " - ") {
        $("#companyLastTwoWeeksReturningCustomerComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th title='Returning Customer (%)'>" + LanguageThisYear + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearRR = kFormatter(data.series[1].data[i]);
            thisYearRR = thisYearRR == 0 ? " - " : thisYearRR + "%";
            $("#companyLastTwoWeeksReturningCustomerComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearRR + "</td></tr>");
        }

        $("#companyLastTwoWeeksReturningCustomerComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearRRTotal + "</td></tr>");

	} else {
		$("#companyLastTwoWeeksReturningCustomerComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th title='" + LanguageReturningCustomer + " (%)'>" + LanguageThisYear + "</th><th title='" + LanguageReturningCustomer + " (%)'>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearRR = kFormatter(data.series[1].data[i]);
            lastYearRR = kFormatter(data.series[0].data[i]);
            changesRRInPercent = data.series[2].data[i];

            if (thisYearRR == 0 || lastYearRR == 0 || changesRRInPercent == 0) {
                changesRRInPercent = " - ";
            } else if (thisYearRR > lastYearRR) {
                changesRRInPercent = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesRRInPercent) + "%";
            } else if (thisYearRR < lastYearRR) {
                changesRRInPercent = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesRRInPercent) + "%";
            }

            thisYearRR = thisYearRR == 0 ? " - " : thisYearRR + "%";
            lastYearRR = lastYearRR == 0 ? " - " : lastYearRR + "%";
            $("#companyLastTwoWeeksReturningCustomerComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearRR + "</td><td>" + lastYearRR + "</td><td>" + changesRRInPercent + "</td></tr>");
        }

        if (thisYearRRTotal == 0 || lastYearRRTotal == 0 || changesRRInTwoYears == 0) {
            changesRRInTwoYears = " - ";
        } else if (thisYearRRTotal > lastYearRRTotal) {
            changesRRInTwoYears = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesRRInTwoYears) + "%";
        } else if (thisYearRRTotal < lastYearRRTotal) {
            changesRRInTwoYears = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesRRInTwoYears) + "%";
        }

        $("#companyLastTwoWeeksReturningCustomerComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearRRTotal + "</td><td>" + lastYearRRTotal + "</td><td>" + changesRRInTwoYears + "</td></tr>");
    }
}

function tirTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = weekNumber;
    $("#companyLastTwoWeeksTurnInRateComparisonTableHead").html("");
    $("#companyLastTwoWeeksTurnInRateComparisonTableContent").html("");
    $("#companyLastTwoWeeksTurnInRateComparisonTableFoot").html("");

    var thisYearTIR = 0;
    var lastYearTIR = 0;
    var changesTIRInPercent = 0;

    var thisYearTIRTotal = data.series[1].total;
    var lastYearTIRTotal = data.series[0].total;
    var changesTIRInTwoYears = data.series[2].total;

    thisYearTIRTotal = thisYearTIRTotal == 0 ? " - " : kFormatter(thisYearTIRTotal) + "%";
    lastYearTIRTotal = lastYearTIRTotal == 0 ? " - " : kFormatter(lastYearTIRTotal) + "%";

    if (lastYearTIRTotal == " - ") {
        $("#companyLastTwoWeeksTurnInRateComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearTIR = kFormatter(data.series[1].data[i]);
            thisYearTIR = thisYearTIR == 0 ? " - " : thisYearTIR + "%";
            $("#companyLastTwoWeeksTurnInRateComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearTIR + "</td></tr>");
        }

        $("#companyLastTwoWeeksTurnInRateComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearTIRTotal + "</td></tr>");
    } else {
        $("#companyLastTwoWeeksTurnInRateComparisonTableHead").append("<tr><th>" + LanguageWeek + " " + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            thisYearTIR = kFormatter(data.series[1].data[i]);
            lastYearTIR = kFormatter(data.series[0].data[i]);
            changesTIRInPercent = data.series[2].data[i];

            if (thisYearTIR == 0 || lastYearTIR == 0 || changesTIRInPercent == 0) {
                changesTIRInPercent = " - ";
            } else if (thisYearTIR > lastYearTIR) {
                changesTIRInPercent = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesTIRInPercent) + "%";
            } else if (thisYearTIR < lastYearTIR) {
                changesTIRInPercent = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesTIRInPercent) + "%";
            }

            thisYearTIR = thisYearTIR == 0 ? " - " : thisYearTIR + "%";
            lastYearTIR = lastYearTIR == 0 ? " - " : lastYearTIR + "%";
            $("#companyLastTwoWeeksTurnInRateComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + thisYearTIR + "</td><td>" + lastYearTIR + "</td><td>" + changesTIRInPercent + "</td></tr>");

        }

        if (thisYearTIRTotal == 0 || lastYearTIRTotal == 0 || changesTIRInTwoYears == 0) {
            changesTIRInTwoYears = " - ";
        } else if (thisYearTIRTotal > lastYearTIRTotal) {
            changesTIRInTwoYears = "<i class='fa fa-caret-up rise'></i> " + kFormatter(changesTIRInTwoYears) + "%";
        } else if (thisYearTIRTotal < lastYearTIRTotal) {
            changesTIRInTwoYears = "<i class='fa fa-caret-down drop'></i> " + kFormatter(changesTIRInTwoYears) + "%";
        }

        $("#companyLastTwoWeeksTurnInRateComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearTIRTotal + "</td><td>" + lastYearTIRTotal + "</td><td>" + changesTIRInTwoYears + "</td></tr>");
    }
}


function ViewSiteWeeklyReport(branchID) {
    var companyCode = $("#companyCode").val();
    var datePickerValue = $('#datePickerDateRange').val();
    datePickerValue = datePickerValue.split('(');
    var weekNumber = datePickerValue[0].trim();
    weekNumber = weekNumber.split('Week ');
    weekNumber = weekNumber[1];
    datePickerValue = datePickerValue[1].split(')');
    datePickerValue = datePickerValue[0].split(" to ");

    var startDate = datePickerValue[0];
    var endDate = datePickerValue[1];

    if (dateFormat == "monthFirst") {
        var tempStart = datePickerValue[0].split("/");
        startDate = tempStart[1] + "/" + tempStart[0] + "/" + tempStart[2];
        var tempEnd = datePickerValue[1].split("/");
        endDate = tempEnd[1] + "/" + tempEnd[0] + "/" + tempEnd[2];
    }

    $.cookie("storeWeeklyReportCookie", [startDate, endDate, weekNumber, branchID, companyCode], { expires: 1 });

    //pass to store weekly url as parameter, open new tab
    window.open('/FootfallCam/NewWeeklyStandardReport', '_blank');
}