//--------------General Function--------------//
function chartLoading() {
    loadingChart("newMonthlyTrend");
    $("#newMonthlyTrend").addClass("chartLoading");

    loadingChart("newWeeklyTrend");
    $("#newWeeklyTrend").addClass("chartLoading");

    loadingChart("newDailyTrend");
    $("#newDailyTrend").addClass("chartLoading");

    loadingChart("lastWeekVisitorCountTrend");
    $("#lastWeekVisitorCountTrend").addClass("chartLoading");

    loadingChart("weekdaysTrafficProfile");
    $("#weekdaysTrafficProfile").addClass("chartLoading");

    loadingChart("weekendsTrafficProfile");
    $("#weekendsTrafficProfile").addClass("chartLoading");

    loadingChart("newTurnInRateMonthlyTrend");
    $("#newTurnInRateMonthlyTrend").addClass("chartLoading");

    loadingChart("weekdaysTurnInRate");
    $("#weekdaysTurnInRate").addClass("chartLoading");

    loadingChart("weekendsTurnInRate");
    $("#weekendsTurnInRate").addClass("chartLoading");

    loadingChart("newOutsideTraffic");
    $("#newOutsideTraffic").addClass("chartLoading");

    loadingChart("weekdaysOutsideTraffic");
    $("#weekdaysOutsideTraffic").addClass("chartLoading");

    loadingChart("newVisitDurationMonthlyTrend");
    $("#newVisitDurationMonthlyTrend").addClass("chartLoading");

    loadingChart("newVisitDurationHourlyTrend");
    $("#newVisitDurationHourlyTrend").addClass("chartLoading");

    loadingChart("weekdaysVisitDuration");
    $("#weekdaysVisitDuration").addClass("chartLoading");

    loadingChart("weekendsVisitDuration");
    $("#weekendsVisitDuration").addClass("chartLoading");

    loadingChart("newReturningCustomerMonthlyTrend");
    $("#newReturningCustomerMonthlyTrend").addClass("chartLoading");

    loadingChart("newReturningCustomer");
    $("#newReturningCustomer").addClass("chartLoading");

    loadingChart("weekendsOutsideTraffic");
    $("#weekendsOutsideTraffic").addClass("chartLoading");

    loadingChart("weekendsOutsideTraffic");
    $("#weekendsOutsideTraffic").addClass("chartLoading");

    loadingChart("newVisitDurationDailyTrend");
    $("#newVisitDurationDailyTrend").addClass("chartLoading");

    loadingChart("thisWeekAverageDurationDonutChart");
    $("#thisWeekAverageDurationDonutChart").addClass("chartLoading");
    $('#thisWeekAverageDurationDonutChart').css("display", "none");



    loadingChart("newReturningCustomer");
    $("#newReturningCustomer").addClass("chartLoading");

    loadingChart("newReturningCustomerDailyTrend");
    $("#newReturningCustomerDailyTrend").addClass("chartLoading");

    loadingChart("thisWeekAverageReturningCustomerDonutChart");
    $("#thisWeekAverageReturningCustomerDonutChart").addClass("chartLoading");

    loadingChart("newSalesConversionMonthlyTrend");
    $("#newSalesConversionMonthlyTrend").addClass("chartLoading");

    loadingChart("salesConversionWeeklyTrend");
    $("#newsalesConversionWeeklyTrend").addClass("chartLoading");

    loadingChart("salesConversionDailyTrend");
    $("#newsalesConversionDailyTrend").addClass("chartLoading");

    loadingChart("weekdaysSalesConversion");
    $("#weekdaysSalesConversion").addClass("chartLoading");

    loadingChart("weekendsSalesConversion");
    $("#weekendsSalesConversion").addClass("chartLoading");

    $('#visitDurationDonutChartCenterText').text('');
    $('#ReturningCustomerDonutChartCenterText').text('');

    loadingChart("revenuePerVisitorMonthlyTrend");
    $("#revenuePerVisitorMonthlyTrend").addClass("chartLoading");

    loadingChart("revenuePerVisitorWeeklyTrend");
    $("#revenuePerVisitorWeeklyTrend").addClass("chartLoading");
}

function drawLine(ctx, week, highest) {
    var dataRange = highest;
    var height = 30;
    var x = 0, y = (dataRange - week[0]) / dataRange * height;   // y = weekdata divide 100 times height * ratio of 4
    for (var i = 1; i < week.length; i++) {
        ctx.beginPath();
        ctx.lineWidth = "1";
        ctx.strokeStyle = "#2182c2";
        ctx.moveTo(x, y);
        x = x + 30;
        y = (dataRange - week[i]) / dataRange * height;
        ctx.lineTo(x, y);
        ctx.stroke();
    }
}

//convert percentage to xxk if more than 999
function kFormatter(num) {
    if (num > 999) {
        return num > 999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    } else if (num < -999) {
        return num < -999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    } else {
        return num > 999 ? (num / 1000).toFixed(2) + 'k' : num.toFixed(2);
    }
}

function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}

var weekDay//share to all table
function showDayAndDate(startDate) {
    if (startDate != null) {
        var tempDate = startDate.split("/");
        //console.log(tempDate[2], tempDate[1], tempDate[0]);
        startDate = new Date(tempDate[2], tempDate[1] - 1, tempDate[0] - 1);
        var date = new Array();
        for (var i = 0; i < 7; i++)
            date.push(new Date(startDate.setDate(startDate.getDate() + 1)));
        //console.log(day);
        var day = new Array(7);
        weekDay = new Array(7);
        day[0] = LanguageSun;
        day[1] = LanguageMon;
        day[2] = LanguageTue;
        day[3] = LanguageWed;
        day[4] = LanguageThu;
        day[5] = LanguageFri;
        day[6] = LanguageSat;
        for (var i = 0; i < 7; i++) {
            weekDay[i] = day[date[i].getDay()] + " " + date[i].getDate() + "/" + (date[i].getMonth() + 1);
        }
        return weekDay;
    }
    else
        return new Array(7);

}


/*
//--------------Report Section--------------//
//--------------Visitor Counts--------------//
var noLastYearDataForVisitorCount = true;

//Visitor Counts Monthly Trend
function bindVisitorCountsMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i];
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                dashStyle: 'dash',
                name: LanguageLastYear,
                data: lastYear.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachmonthoftheyear + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight,
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=1&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickPixelInterval: 15,
                //tickInterval: dynamicTickInterval,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    },
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    },
                },
                labels: {
                    rotation: -90,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                x: 96,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Visitor Counts Weekly Trend
function bindVisitorCountsWeeklyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachweekoftheyear + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//get weather
function getWeather(datas, colorScheme) {
    var key = "3fabe6428ef3439e90414214171707"; //key for get the free weather of 60 days before today
    var latitude = datas.series[2].data[0];
    var longitude = datas.series[2].data[1];
    var startDate = datas.series[2].dateInFormat[0];
    var endDate = datas.series[2].dateInFormat[1];
    var weatherList = [];
    var weatherNameList = [];
    var tempCount = 0;
    var temp = [];
    var temp2 = [];
    //if ((latitude != 0 || longitude != 0) && !isMoreThan50days) {
    if ((latitude >= -90 || branchLatitude <= 90 && longitude >= -180 || longitude < 180) && !isMoreThan50days) {
        //get the weather by key in (start date, end date, city, key and country)
        $.post("//api.worldweatheronline.com/premium/v1/past-weather.ashx?key=" + key + "&q=" + latitude + "," + longitude + "&date=" + startDate + "&enddate=" + endDate + "&format=json", function (data) {
            var symbol = [];
            console.log(data.data.weather);
            if (data.data.weather != undefined) {
                $.each(data.data.weather, function () {
                    var totalTempC = 0;
                    var i = 0;
                    var weatherCode = 0;
                    var url = "//footfallcounter.com/Content/themes/base/images/";
                    var weather = "sunny.png";

                    $.each(this.hourly, function () {
                        totalTempC = totalTempC + parseInt(this.tempC);
                        i++;

                        $.each(this.weatherDesc, function () {
                            var weathers = 0;
                            var level = 0;
                            if (this.value.toLowerCase().indexOf("sunny") > -1) {
                                level = 1;
                            } else if (this.value.toLowerCase().indexOf("cloud") > -1) {
                                level = 2;
                            }
                            else if (this.value.toLowerCase().indexOf("rain") > -1) {
                                level = 4;
                            } else if (this.value.toLowerCase().indexOf("thundery") > -1) {
                                level = 5;
                            } else if (this.value.toLowerCase().indexOf("snow") > -1) {
                                level = 6;
                            } else {
                                level = 0;
                            }
                            if (weathers < level) {
                                weathers = level;
                                if (level == 1)
                                    weather = "sunny.png";
                                else if (level == 2)
                                    weather = "cloudy.png";
                                else if (level == 4)
                                    weather = "rainy.png";
                                else if (level == 5)
                                    weather = "thundery.png";
                                else if (level == 6)
                                    weather = "snowy.png";
                                else if (level == 0)
                                    weather = "sunny.png";
                            }
                        });
                    });
                    url = url + weather;
                    temp.push(this.maxtempC);
                    temp2.push(this.maxtempF);
                    //combine symbol and average temparature
                    var json = jQuery.parseJSON('{"y":' + (totalTempC / i) + ', "marker":{ "symbol": "url(' + url + ')"}}');

                    //var averageTemperature = totalTempC / i;
                    if (tempCount <= 30) {
                        //data.averageTemp.push(parseFloat(averageTemperature.toFixed(1)));
                        symbol.push(url);
                    }
                    tempCount++;
                });

                for (var x = 0; x < tempCount && x < 31; x++) {
                    var jsonSymbol = jQuery.parseJSON('{"y":' + 0 + ', "marker":{ "symbol": "url(' + symbol[x] + ')"}}');
                    weatherList.push(jsonSymbol);

                    var weather = (weatherList[x].marker.symbol).split("/")[7].split(".")[0] + " day";
                    weatherNameList.push(weather);
                }
                bindVisitorCountsDailyTrend(datas, weatherList, weatherNameList, colorScheme, temp, temp2);
            } else {
                bindVisitorCountsDailyTrend(datas, weatherList, weatherNameList, colorScheme, temp, temp2);
            }
        }).fail(function () {
            bindVisitorCountsDailyTrend(datas, weatherList, weatherNameList, colorScheme, temp, temp2);
        });
    }
    else {
        bindVisitorCountsDailyTrend(datas, weatherList, weatherNameList, colorScheme);
    }
}

//Visitor Counts Daily Trend
function bindVisitorCountsDailyTrend(datas, weatherList, weatherNameList, colorScheme, temp, temp2) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[0].data;
        var thisYear = datas.series[1].data;
        $("#newDailyTrend").html("");

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newDailyTrend",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
			},
			credits: {
				enabled: false
			},
			title: {
				text: ''
				//useHTML: true,
				//text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachday + "'></i>",
				//align: 'left',
				//style: {
				//    color: colorScheme.chart.title.color.visitorCount,
				//    "font-family": colorScheme.chart.title.fontFamily,
				//    fontSize: colorScheme.chart.title.fontSize,
				//    textDecoration: colorScheme.chart.title.textDecoration,
				//    "font-weight": colorScheme.chart.title.fontWeight
				//},
				//y:6
			},
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				title: {
					text: LanguageDay,
					align: 'high',
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},
			yAxis: [{
				opposite: false,
				lineWidth: 0,
				gridLineWidth: 1,
				tickWidth: 1,
				//tickInterval: dynamicTickInterval,
				tickPixelInterval: 15,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: LanguageNoofVisitor,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				labels: {
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				min: 0,
			}, {
				min: 0,
				max: 0,
				gridLineWidth: 0,
				lineWidth: 0,
				title: {
					text: null
				},
				labels: {
					enabled: false
				},
				height: '10%'
			}],
			legend: {
				itemStyle: {
					color: colorScheme.chart.legend.text.color,
					"font-family": colorScheme.chart.legend.text.fontFamily,
					fontSize: colorScheme.chart.legend.text.fontSize,
					"font-weight": colorScheme.chart.legend.text.fontWeight
				},
				enabled: true,
				x: 250,
				y: -15,
				verticalAlign: 'top',
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				},
				line: {
					marker: {
						enabled: false
					}
				}
			},
			tooltip: {
				useHTML: true,
				shared: true,
				formatter: function () {
					//var i = datas.categories.indexOf(this.x.name);
					var i = datas.categories.indexOf(this.x);
					if (weatherList.length != 0) {
						var weather = weatherNameList[i];

						var tempe = temp[i];
						var tempe2 = temp2[i];

						return datas.categories[i] + "<br /><span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + LanguageThisYear + " : <b>" + thisYear[i] +
							"</b><br /><span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + LanguageLastYear + " : <b>" + lastYear[i] +
							"</b><br /><span style='color:" + this.points[2].series.color + "'>\u25CF</span> " + LanguageWeather + " : <b>" + weather + "</b>" +
							"</b><br /><span style='color:" + this.points[3].series.color + "'>\u25CF</span> " + LanguageTemperature + " : <b>" + tempe + "&#x2103</b>" +
							"</b><br /><span style='color:" + this.points[3].series.color + "'>\u25CF</span> " + LanguageTemperature + " : <b>" + tempe2 + "&#x2109</b>";
					}
					else {
						return datas.categories[i] + "<br /><span style='color:" + this.points[0].series.color + "'>\u25CF</span> " + LanguageThisYear + " : <b>" + thisYear[i] +
							"</b><br /><span style='color:" + this.points[1].series.color + "'>\u25CF</span> " + LanguageLastYear + " : <b>" + lastYear[i] + "</b>";
					}

				}

			},
			series: [{
				type: 'column',
				name: LanguageThisYear,
				data: thisYear,
				color: colorScheme.time.year.thisYear,
				pointWidth: 10,
				borderWidth: 0
			}, {
				type: 'line',
				dashStyle: 'dash',
				name: LanguageLastYear,
				data: lastYear,
				color: colorScheme.time.year.lastYear,
				lineWidth: 1
			}, {
				type: 'line',
				lineWidth: 0,
				name: LanguageWeather,
				data: weatherList,
				//color: colorScheme.time.year.thisYear,
				//showInLegend: false,
				marker: {
					enabled: true
				},
				yAxis: 1
			}, {
				type: 'line',
				lineWidth: 0,
				name: LanguageTemperature,
				data: temp,
				//color: colorScheme.time.year.thisYear,
				//showInLegend: false,
				marker: {
					enabled: true
				},
				yAxis: 1
			}],
			exporting: {
				enabled: false,
			}
		},
			function (chart) {
				if (noLastYearDataForVisitorCount) {
					chart.series[1].remove(true);
				}
			});
    });

}

//Visitor Counts Last Week Hourly Trend
function bindVisitorCountsHourlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];


        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "lastWeekVisitorCountTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.chart.line.color.thisYear,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear.data,
                color: colorScheme.chart.line.color.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageHourlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsofthehoursforeachdayoftheselectedweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                //categories: {
                //    name: ifmonday,
                //    cagetories: datas.categories
                //},

                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 264,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Visitor Counts Last Two Weeks Comparison Table
function bindLastTwoWeekVisitorCountsDataIntoTable(data, colorScheme) {
    console.log(data);
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;
    $("#lastTwoWeeksComparisonTableHead").html("");
    $("#lastTwoWeeksComparisonTableContent").html("");
    $("#lastTwoWeeksComparisonTableFoot").html("");

    var tempThisWeekVisitorCount = 0;
    var tempLastYearVisitorCount = 0;
    var tempChangesOfVisitorCount = 0;

    var lastYearFootfallTotal = data.series[3].total == 0 ? lastYearFootfallTotal = "-" : lastYearFootfallTotal = data.series[3].total;//for table
    var thisYearFootfallTotal = data.series[1].total == 0 ? thisYearFootfallTotal = "-" : thisYearFootfallTotal = data.series[1].total;//for table
    var totalChanges = data.series[4].total.toFixed(2);

    //append visitor counts table
    if (lastYearFootfallTotal == "-") {
        $("#lastTwoWeeksComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            tempThisWeekVisitorCount = data.series[1].data[i] > 0 ? data.series[1].data[i] : " - ";
            $("#lastTwoWeeksComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekVisitorCount + "</td></tr>");
        }

        $("#lastTwoWeeksComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearFootfallTotal + "</td></tr>");
    } else {
        $("#lastTwoWeeksComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            tempThisWeekVisitorCount = data.series[1].data[i] > 0 ? data.series[1].data[i] : " - ";
            tempLastYearVisitorCount = data.series[3].data[i] > 0 ? data.series[3].data[i] : " - ";
            tempChangesOfVisitorCount =
                data.series[4].data[i].charAt(0) == "+" ? "<i class='fa fa-caret-up rise'></i> " + parseFloat(data.series[4].data[i].substring(1)).toFixed(2) + "%" :
                    data.series[4].data[i].charAt(0) == "-" ? "<i class='fa fa-caret-down drop'></i> " + parseFloat(data.series[4].data[i].substring(1)).toFixed(2) + "%" :
                        data.series[4].data[i].charAt(0) == "0" ? " - " : " - ";
            $("#lastTwoWeeksComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekVisitorCount + "</td><td>" + tempLastYearVisitorCount + "</td><td>" + tempChangesOfVisitorCount + "</td></tr>");
        }

        if (totalChanges > 0)
            totalChanges = "<i class='fa fa-caret-up rise'></i> " + totalChanges + "%";
        else if (totalChanges < 0)
            totalChanges = "<i class='fa fa-caret-down drop'></i> " + totalChanges * -1 + "%";
        else
            totalChanges = " - "
        $("#lastTwoWeeksComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisYearFootfallTotal + "</td><td>" + lastYearFootfallTotal + "</td><td>" + totalChanges + "</td></tr>");
    }

    var sparkLineValue = data.series[1].data;
    var lastWeekFootfallTotal = data.series[0].total == 0 ? lastWeekFootfallTotal = "-" : lastWeekFootfallTotal = data.series[0].total;//for mini graph
    var totalChangesInTwoWeek = data.series[2].total;

    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == null && sparkLineValue[6] == null) {
        sparkLineValue[5] = 0;
        sparkLineValue[6] = 0;
    }
    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == 0 && sparkLineValue[6] == null) {
        sparkLineValue[6] = 0;
    }

    //mini-graph total visitor
    $('#totalVisitorThisWeek').empty();
    //$('#totalVisitorLastWeek').empty();
    $('#totalVisitorUpDownPercent').empty();
    //$("#totalVisitorUpDownIcon").empty();

    $("#vbdVisitorCount").removeClass("shown");

    if (thisYearFootfallTotal != 0 && $.isNumeric(thisYearFootfallTotal)) {
        $('#totalVisitorThisWeek').append(numberWithCommas(thisYearFootfallTotal));

        $("#vbdVisitorCount .svgTextValue").html(numberWithCommas(thisYearFootfallTotal));
    }
    else {
        $('#totalVisitorThisWeek').append(' - ');
    }

    //if (lastWeekFootfallTotal != 0)
    //    $('#totalVisitorLastWeek').text('(' + LanguageLastWeek + ': ' + lastWeekFootfallTotal + ')');
    //else
    //    $('#totalVisitorLastWeek').text('(' + LanguageLastWeek + ': - )');
    $('#totalVisitorUpDownPercent').removeClass("rise");
    $('#totalVisitorUpDownPercent').removeClass("drop");

    $("#vbdVisitorCount .svgTextChanges").removeClass("rise").removeClass("drop");

    if (totalChangesInTwoWeek > 0) {
        $('#totalVisitorUpDownPercent').addClass("rise");
        $('#totalVisitorUpDownPercent').append("<i class='fa fa-caret-up'></i> " + totalChangesInTwoWeek.toFixed(2) + "%");

        $("#vbdVisitorCount .svgTextChanges").addClass("rise");
        $("#vbdVisitorCount .svgTextChanges").html("+" + totalChangesInTwoWeek + "% <i class='fa fa-caret-up'></i>");

        //$("#totalVisitorUpDownIcon").html("<i class='fa fa-caret-up'></i> ");
    }
    else if (totalChangesInTwoWeek < 0) {
        totalChangesInTwoWeek *= -1;
        $('#totalVisitorUpDownPercent').addClass("drop");
        $('#totalVisitorUpDownPercent').append("<i class='fa fa-caret-down'></i> " + totalChangesInTwoWeek.toFixed(2) + "%");

        $("#vbdVisitorCount .svgTextChanges").addClass("drop");
        $("#vbdVisitorCount .svgTextChanges").html(totalChangesInTwoWeek + "% <i class='fa fa-caret-down'></i>");
        //$("#totalVisitorUpDownIcon").html("<i class='fa fa-caret-down'></i> ");
    }
    else {
        $('#totalVisitorUpDownPercent').append(LanguageNoChanges);
        //$("#totalVisitorUpDownIcon").html("");
    }

    $("#vbdVisitorCount").addClass("shown");
    console.log(sparkLineValue);
    //draw graph under each box, footfallcount
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: '7daysVisitorGraph',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                tickWidth: 1,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: sparkLineValue,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}

//Visitor Counts Weekdays/Weekends Comparison Graph
function bindWeekdayVisitorCountsTrend(datas, colorScheme) {
    $(function () {
        var thisYear = datas.series[0];
        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }
        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear.data,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //    text: LanguageTrafficProfile,
                //    align: 'left',
                //    style: {
                //        color: colorScheme.chart.title.color.visitorCount,
                //        "font-family": colorScheme.chart.title.fontFamily,
                //        fontSize: colorScheme.chart.title.fontSize,
                //        textDecoration: colorScheme.chart.title.textDecoration,
                //        "font-weight": colorScheme.chart.title.fontWeight,
                //    },
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                //enabled: true,
                //x: 108,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });

        if (datas.series[0].isDayOff) {
            $("#weekdaysTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}

function bindWeekendVisitorCountsTrend(datas, colorScheme) {
    $(function () {
        var thisYear = datas.series[0];

        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsTrafficProfile",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear.data,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 5,
                x: 20
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false,
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                //enabled: true,
                //x: 108,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
                useHTML: true,
                enabled: showtooltip,
            },
        });

        if (datas.series[0].isDayOff) {
            $("#weekendsTrafficProfile").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}




//--------------Turn In Rate--------------//
//Turn In Rate Monthly Trend
function bindTurnInRateMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newTurnInRateMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalpercentageofvisitorscominginfromoutsideinthemonth + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.turnInRate,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageTurnInRatepercent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                x: 96,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Turn In Rate Last Two Weeks Comparison Table
function bindLastTwoWeekTurnInRateDataIntoTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;
    $("#lastTwoWeeksTurnInRateComparisonTableHead").html("");
    $("#lastTwoWeeksTurnInRateComparisonTableContent").html("");
    $("#lastTwoWeeksTurnInRateComparisonTableFoot").html("");

    var tempLastWeekTurnInRate = 0;
    var tempThisWeekTurnInRate = 0;
    var tempChangesOfTurnInRate = 0;

    var totalTurnInRateChanges = data.series[4].total.toFixed(2);
    var totalTurnInRateThisWeek = data.series[1].total == 0 ? totalTurnInRateThisWeek = "-" : totalTurnInRateThisWeek = data.series[1].total.toFixed(2) + "%";
    var totalTurnInRateLastYearThisWeek = data.series[3].total == 0 ? totalTurnInRateLastYearThisWeek = "-" : totalTurnInRateLastYearThisWeek = data.series[3].total.toFixed(2) + "%";

    if (totalTurnInRateLastYearThisWeek == "-") {
        $("#lastTwoWeeksTurnInRateComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");
        for (var i = 0; i < 7; i++) {
            tempThisWeekTurnInRate = data.series[1].data[i] > 0 ? data.series[1].data[i] + "%" : " - ";
            $("#lastTwoWeeksTurnInRateComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekTurnInRate + "</td></tr>");
        }
        $("#lastTwoWeeksTurnInRateComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalTurnInRateThisWeek + "</td></tr>");
    } else {
        $("#lastTwoWeeksTurnInRateComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            tempLastWeekTurnInRate = data.series[3].data[i] > 0 ? data.series[3].data[i] + "%" : " - ";
            tempThisWeekTurnInRate = data.series[1].data[i] > 0 ? data.series[1].data[i] + "%" : " - ";
            tempChangesOfTurnInRate =
                data.series[4].data[i].charAt(0) == "+" ? "<i class='fa fa-caret-up rise'></i> " + data.series[4].data[i].substring(1) :
                    data.series[4].data[i].charAt(0) == "-" ? "<i class='fa fa-caret-down drop'></i> " + data.series[4].data[i].substring(1) :
                        data.series[4].data[i].charAt(0) == "0" ? " - " : " - ";
            $("#lastTwoWeeksTurnInRateComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekTurnInRate + "</td><td>" + tempLastWeekTurnInRate + "</td><td>" + tempChangesOfTurnInRate + "</td></tr>");
        }

        if (totalTurnInRateChanges == 0)
            totalTurnInRateChanges = " - ";
        else if (totalTurnInRateChanges > 0)
            totalTurnInRateChanges = "<i class='fa fa-caret-up rise'></i>" + totalTurnInRateChanges + "%";
        else
            totalTurnInRateChanges = "<i class='fa fa-caret-down drop'></i> " + totalTurnInRateChanges * -1 + "%";
        //table total
        $("#lastTwoWeeksTurnInRateComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalTurnInRateThisWeek + "</td><td>" + totalTurnInRateLastYearThisWeek + "</td><td>" + totalTurnInRateChanges + "</td></tr>");
    }

    var sparkLineValue = data.series[1].data;
    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == null && sparkLineValue[6] == null) {
        sparkLineValue[5] = 0;
        sparkLineValue[6] = 0;
    }
    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == 0 && sparkLineValue[6] == null) {
        sparkLineValue[6] = 0;
    }

    //for turn in rate mini graph
    var totalTurnInRateChangesInTwoWeek = data.series[2].total;//for mini graph
    //var totalTurnInRateLastWeek = data.series[0].total == 0 ? totalTurnInRateLastWeek = "-" : totalTurnInRateLastWeek = data.series[0].total.toFixed(2) + "%";//for mini graph
    $('#turnInRateThisWeek').empty();
    //$('#turnInRateLastWeek').empty();
    //$("#returningCustomerUpDownIcon").empty();
    $('#differenceTurnInRateInPercentage').empty();

    $("#vbdTurnInRate").removeClass("shown");

    if (data.series[1].total != 0 && $.isNumeric(data.series[1].total)) {
        $('#turnInRateThisWeek').text(totalTurnInRateThisWeek);

        $("#vbdTurnInRate .svgTextValue").html(totalTurnInRateThisWeek);

    } else {
        $('#turnInRateThisWeek').text(" - ");
    }

    //if (totalTurnInRateLastWeek != 0) {
    //    $('#turnInRateLastWeek').text("(" + LanguageThisWeek + ": " + totalTurnInRateLastWeek + ")");
    //} else {
    //    $('#turnInRateLastWeek').text("" + LanguageThisWeek + ":  - ");

    //}
    $('#differenceTurnInRateInPercentage').removeClass("rise");
    $('#differenceTurnInRateInPercentage').removeClass("drop");

    $("#vbdTurnInRate .svgTextChanges").removeClass("rise").removeClass("drop");

    if (totalTurnInRateChangesInTwoWeek > 0) {
        //$("#turnInRateUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
        $('#differenceTurnInRateInPercentage').addClass("rise");
        $('#differenceTurnInRateInPercentage').append("<i class='fa fa-caret-up'></i> " + totalTurnInRateChangesInTwoWeek.toFixed(2) + "%");

        $("#vbdTurnInRate .svgTextChanges").addClass("rise");
        $("#vbdTurnInRate .svgTextChanges").html("+" + totalTurnInRateChangesInTwoWeek.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (totalTurnInRateChangesInTwoWeek < 0) {
        //$("#turnInRateUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>");
        $('#differenceTurnInRateInPercentage').addClass("drop");
        $('#differenceTurnInRateInPercentage').append("<i class='fa fa-caret-down'></i> " + (totalTurnInRateChangesInTwoWeek * -1).toFixed(2) + "%");

        $("#vbdTurnInRate .svgTextChanges").addClass("drop");
        $("#vbdTurnInRate .svgTextChanges").html(totalTurnInRateChangesInTwoWeek.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }
    else {
        $('#differenceTurnInRateInPercentage').append(LanguageNoChanges);
        $("#vbdTurnInRate .svgTextChanges").html(LanguageNoChanges);

        //$("#returningCustomerUpDownIcon").html("")
    }

    $("#vbdTurnInRate").addClass("shown");

    //draw graph under each box, turn in rate
    $(function () {

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < sparkLineValue.length; i++) {
            if (sparkLineValue[i] != null && sparkLineValue[i][i] != undefined && sparkLineValue[i][i] > largestValue)
                largestValue = sparkLineValue[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({

            chart: {
                renderTo: '7daysTurnInRate',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                tickWidth: 1,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        //enabled:false,
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: sparkLineValue,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}

//Turn In Rate Weekdays Comparison Graph
function bindWeekdayTIRTrend(datas, colorScheme) {
    $(function () {
        var thisYear = datas.series[0];

        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }
        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysTurnInRate",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear.data,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageTrafficProfile,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.turnInRate,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight,
                //},
            },
            subtitle: {
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragepercentofvisitorsMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageTurnInRatepercent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 96,
                //y: -15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });

        if (datas.series[0].isDayOff) {
            $("#weekdaysTurnInRate").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}

//Turn In Rate Weekends Comparison Graph
function bindWeekendTIRTrend(datas, colorScheme) {
    $(function () {
        var thisYear = datas.series[0];

        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsTurnInRate",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear.data,
                color: colorScheme.time.week.thisWeek,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragepercentofvisitorsSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
                x: 20,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        radius: 2,
                        enabled: true,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageTurnInRatepercent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 96,
                //y: -15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });

        if (datas.series[0].isDayOff) {
            $("#weekendsTurnInRate").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}





//--------------Outside Traffic--------------//
//Outside Traffic Hourly Trend
function bindOutsideTrafficHourlyTrend(datas, colorScheme) {


    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];
        var daily = [];

        //identify largest value of yaxis data
        var outsideTrafficLargestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > outsideTrafficLargestValue)
                outsideTrafficLargestValue = thisYear.data[i]
        }

        for (var i = 0; i < thisYear.data.length; i = i + 24) {
            var temp = 0;
            for (var ii = 0; ii < 24; ii++) {
                if (thisYear.data[i + ii] != undefined) {
                    temp = temp + thisYear.data[i + ii];
                }
            }
            daily.push(temp);
        }

        var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
            : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
                : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                    : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                        : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                            : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                                : 1000000;

        var visitorLargestValue = 0;

        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > visitorLargestValue)
                visitorLargestValue = lastYear.data[i]
        }
        var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
            : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
                : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                    : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                        : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                            : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newOutsideTraffic",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: thisYear.data,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: lastYear.data,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + LanguageNumberofpeoplepassingbyhourlyofeachdayforthepreviousweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.outsideTraffic,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                //tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                lineWidth: 0,
                tickWidth: 1,
                tickPosition: 'inside',
                labels: {
                    align: 'right',
                    x: 25,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: datas.categories,
                //categories: [{
                //    name: ifmonday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //}, {
                //    name: iftuesday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //}, {
                //    name: ifwednesday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //},
                //{
                //    name: ifthursday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //},
                //{
                //    name: iffriday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //},
                //{
                //    name: ifsaturday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //},
                //{
                //    name: ifsunday,
                //    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                //}],
                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 228,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });

        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: '7daysOutsideTraffic',
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    tickWidth: 1,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: daily,
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    });
}

//Outside Traffic and Visitor Counts Weekdays/Weekends Comparison Graph
function bindWeekdayTFAndOTTrend(datas, colorScheme) {
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data

        var outsideTrafficLargestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > outsideTrafficLargestValue)
                outsideTrafficLargestValue = thisYear.data[i]
        }

        var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
            : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
                : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                    : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                        : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                            : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                                : 1000000;

        var visitorLargestValue = 0;

        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > visitorLargestValue)
                visitorLargestValue = lastYear.data[i]
        }
        var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
            : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
                : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                    : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                        : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                            : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysOutsideTraffic",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: thisYear.data,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: lastYear.data,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageTrafficProfile,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.outsideTraffic,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight,
                //},
            },
            subtitle: {
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                tickWidth: 1,
                lineWidth: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                //tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 15,
                labels: {
                    //align: 'right',
                    x: 10,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    //margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 36,
                //y: -15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip
            },
        });
    });
}

function bindWeekendTFAndOTTrend(datas, colorScheme) {
    $(function () {
        var lastYear = datas.series[0];
        var thisYear = datas.series[1];

        if (datas.series[0].isDayOff) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data

        var outsideTrafficLargestValue = 0;

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > outsideTrafficLargestValue)
                outsideTrafficLargestValue = thisYear.data[i]
        }

        var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
            : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
                : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                    : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                        : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                            : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                                : 1000000;

        var visitorLargestValue = 0;

        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > visitorLargestValue)
                visitorLargestValue = lastYear.data[i]
        }
        var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
            : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
                : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                    : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                        : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                            : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsOutsideTraffic",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: thisYear.data,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: lastYear.data,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                tickPosition: 'inside',
                tickWidth: 1,
                lineWidth: 0,
                gridLineWidth: 1,
                //tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 15,
                labels: {
                    align: 'right',
                    x: 25,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 36,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });
}





//--------------Visit Duration--------------//
//Visit Duration Monthly Trend
function bindVisitDurationMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[6];
        var thisYear = datas.series[7];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newVisitDurationMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.time.year.thisYear,
                borderWidth: 0,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragevisittimeinmins + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitDuration,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=23&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: {
                lineWidth: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageAverageVisitDurationmins,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 96,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Visit Duration Daily Trend
function bindVisitDurationDailyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = datas.series[6];
        var thisYear = datas.series[7];
        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.data.length; i++) {
            if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > largestValue) {
                largestValue = lastYear.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.data.length; i++) {
            if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > largestValue)
                largestValue = thisYear.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newVisitDurationDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear.data,
                color: colorScheme.time.year.thisYear,
                marker: {
                    enabled: false
                },
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1,
                marker: {
                    enabled: false
                }
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragetimeofvisitinminutes + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitDuration,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                marker: {
                    enabled: false
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=hour&parameter=23&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: {
                lineWidth: 0,
                tickWidth: 1,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageAverageVisitDuration,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0,
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }

                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 264,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });

}

//Visit Duration Donut Chart
function bindThisWeekAverageVisitDuration(threeCatDatas, lastTwoWeeksDatas, colorScheme) {
    var thisYearFirstCat = threeCatDatas.series[8].total;
    var thisYearSecondCat = threeCatDatas.series[9].total;
    var thisYearThirdCat = threeCatDatas.series[10].total;
    var thisWeekAverage = lastTwoWeeksDatas.series[1].total;

    var donutChartColors = $.map(colorScheme.chart.donut, function (value, index) {
        return [value];
    });

    $(function () {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'thisWeekAverageDurationDonutChart',
                type: 'pie',
            },
            colors: donutChartColors,
            title: {
                text: ''
            },
            yAxis: {
                title: {
                    text: ''
                }
            },
            plotOptions: {
                series: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + $("#datePickerDateRange").val().substr(5, 2) + "&range=day&parameter=6&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    }
                }
            },
            tooltip: {
                useHTML: true,
                formatter: function () {
                    return "<b>" + this.y + '%</b>';
                }
            },
            exporting: {
                enabled: false
            },
            credits: {
                enabled: false
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    fontFamily: colorScheme.chart.legend.text.fontFamily,
                    //fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                margin: 0
            },
            series: [{
                name: LanguageThisWeekAverage,
                data: [
                    [threeCatDatas.series[8].name, thisYearFirstCat],
                    [threeCatDatas.series[9].name, thisYearSecondCat],
                    [threeCatDatas.series[10].name, thisYearThirdCat]],
                size: '100%',
                innerSize: '60%',
                showInLegend: true,
                dataLabels: {
                    enabled: true,
                    distance: -30,
                    style: {
                        fontFamily: colorScheme.chart.dataLabel.fontFamily,
                        color: colorScheme.chart.dataLabel.color,
                        fontSize: colorScheme.chart.dataLabel.fontSize,
                        fontWeight: colorScheme.chart.dataLabel.fontWeight
                    },
                    formatter: function () {
                        return "<b>" + this.y + '%</b>';
                    }
                }
            }]
        },

            function (chart) {
                var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                var textY = chart.plotTop + (chart.plotHeight * 0.5);

				var span = '<span id="VDpieChartInfoText" style="position:absolute; text-align:center;">';
				span += '<span class="pieChartInfoTextTitle">' + thisWeekAverage.toFixed(2) + ' ' + LanguageMin + '</span><br>';
                span += '<span class="pieChartInfoTextSubtitle">';
                span += '<span>' + LanguageThisWeek + '</span><br />';
                span += '<span>' + LanguageAverage + '</span>';
                span += '</span></span>';

                $("#visitDurationDonutChartCenterText").empty();
                $("#visitDurationDonutChartCenterText").append(span);
                span = $('#VDpieChartInfoText');
                span.css('left', textX + (span.width() * -0.5));
                span.css('top', textY + (span.height() * -0.5));

                $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
                $('#VDpieChartInfoText').css("display", "none");
            });
    });
}

//Visit Duration Last Two Weeks Comparison Table
function bindLastTwoWeekVisitDurationDataIntoTable(data, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;
    $("#lastTwoWeeksVisitDurationComparisonTableHead").html("");
    $("#lastTwoWeeksVisitDurationComparisonTableContent").html("");
    $("#lastTwoWeeksVisitDurationComparisonTableFoot").html("");

    var tempThisWeekVisitDuration = 0;
    var tempLastYearThisWeekVisitDuration = 0;
    var tempChangesOfVisitDuration = 0;

    //table total
    var thisyeartotalVD = data.series[1].total == 0 ? thisyeartotalVD = "-" : thisyeartotalVD = data.series[1].total.toFixed(2) + " " + LanguageReportmin;
    var lastyeartotalVD = data.series[3].total == 0 ? lastyeartotalVD = "-" : lastyeartotalVD = data.series[3].total.toFixed(2) + " " + LanguageReportmin;
    var totalVDChanges = data.series[4].total.toFixed(2);

    var sparkLineValue = [];

    if (lastyeartotalVD == "-") {
        $("#lastTwoWeeksVisitDurationComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");

        //append in visit duration table
        for (var i = 0; i < 7; i++) {
            tempThisWeekVisitDuration = data.series[1].data[i] > 0 ? data.series[1].data[i].toFixed(2) + " " + LanguageReportmin : " - ";
            $("#lastTwoWeeksVisitDurationComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekVisitDuration + "</td></tr>");

            if (i == 6) {
                if (sparkLineValue[5] == 0 && data.series[1].data[i] == 0) {
                    data.series[1].data[i] = null;
                    sparkLineValue[5] = null;
                    sparkLineValue.push(data.series[1].data[i]);
                } else if (data.series[1].data[i] == 0) {
                    data.series[1].data[i] = null;
                    sparkLineValue.push(data.series[1].data[i]);
                }
                else {
                    sparkLineValue.push(data.series[1].data[i]);
                }
            } else {
                sparkLineValue.push(data.series[1].data[i]);
            }
        }

        $("#lastTwoWeeksVisitDurationComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisyeartotalVD + "</td></tr>");

    } else {
        $("#lastTwoWeeksVisitDurationComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        //append in visit duration table
        for (var i = 0; i < 7; i++) {
            tempThisWeekVisitDuration = data.series[1].data[i] > 0 ? data.series[1].data[i].toFixed(2) + " " + LanguageReportmin : " - ";
            tempLastYearThisWeekVisitDuration = data.series[3].data[i] > 0 ? data.series[0].data[i].toFixed(2) + " " + LanguageReportmin : " - ";
            tempChangesOfVisitDuration =
                data.series[4].data[i].charAt(0) == "+" ? "<i class='fa fa-caret-up rise'></i> " + data.series[4].data[i].substring(1) + "" :
                    data.series[4].data[i].charAt(0) == "-" ? "<i class='fa fa-caret-down drop'></i> " + data.series[4].data[i].substring(1) + "" :
                        data.series[4].data[i].charAt(0) == "0" ? " - " : " - ";
            $("#lastTwoWeeksVisitDurationComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekVisitDuration + "</td><td>" + tempLastYearThisWeekVisitDuration + "</td><td>" + tempChangesOfVisitDuration + "</td></tr>");

            if (i == 6) {
                if (sparkLineValue[5] == 0 && data.series[1].data[i] == 0) {
                    data.series[1].data[i] = null;
                    sparkLineValue[5] = null;
                    sparkLineValue.push(data.series[1].data[i]);
                } else if (data.series[1].data[i] == 0) {
                    data.series[1].data[i] = null;
                    sparkLineValue.push(data.series[1].data[i]);
                }
                else {
                    sparkLineValue.push(data.series[1].data[i]);
                }
            } else {
                sparkLineValue.push(data.series[1].data[i]);
            }
        }

        if (totalVDChanges > 0)
            totalVDChanges = "<i class='fa fa-caret-up rise'></i> " + totalVDChanges + "%";
        else if (totalVDChanges < 0)
            totalVDChanges = "<i class='fa fa-caret-down drop'></i> " + totalVDChanges * -1 + "%";
        else
            totalVDChanges = "-"
        $("#lastTwoWeeksVisitDurationComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + thisyeartotalVD + "</td><td>" + lastyeartotalVD + "</td><td>" + totalVDChanges + "</td></tr>");
    }

    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == null && sparkLineValue[6] == null) {
        sparkLineValue[5] = 0;
        sparkLineValue[6] = 0;
    }
    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == 0 && sparkLineValue[6] == null) {
        sparkLineValue[6] = 0;
    }
    //$('#visitDurationLastWeek').empty();
    $('#visitDurationThisWeek').empty();
    $('#differenceVisitDurationInPercentage').empty();
    //$("#visitDurationUpDownIcon").empty();

    $("#vbdVisitDuration").removeClass("shown");

    var lastWeektotalVD = data.series[0].total.toFixed(2);
    var totalVDChangesInTwoWeeks = data.series[2].total;
    var thisweektotalVD = data.series[1].total == 0 ? thisweektotalVD = "-" : thisweektotalVD = data.series[1].total.toFixed(2) + "m";
    $('#visitDurationThisWeek').append(thisweektotalVD);

    if ($.isNumeric(data.series[1].total) && data.series[1].total != 0)
        $("#vbdVisitDuration .svgTextValue").html(thisweektotalVD + "in");
    else
        $("#vbdVisitDuration .svgTextValue").html("");

    //$('#visitDurationLastWeek').text("(" + LanguageThisWeek + ": " + lastWeektotalVD + " " + Languageminutes + ")");
    $('#differenceVisitDurationInPercentage').removeClass("rise");
    $('#differenceVisitDurationInPercentage').removeClass("drop");

    $("#vbdVisitDuration .svgTextChanges").removeClass("rise").removeClass("drop");

    if (totalVDChangesInTwoWeeks > 0) {
        $('#differenceVisitDurationInPercentage').addClass("rise");
        $('#differenceVisitDurationInPercentage').append("<i class='fa fa-caret-up'></i> " + totalVDChangesInTwoWeeks.toFixed(2) + "%");

        $("#vbdVisitDuration .svgTextChanges").addClass("rise");
        $("#vbdVisitDuration .svgTextChanges").html("+" + totalVDChangesInTwoWeeks.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
        //$("#visitDurationUpDownIcon").html("<i class='fa fa-caret-up' style='color: " + colorScheme.chart.arrow.up + ";'></i>");
    }
    else if (totalVDChangesInTwoWeeks < 0) {
        totalVDChangesInTwoWeeks *= -1;
        $('#differenceVisitDurationInPercentage').addClass("drop");
        $('#differenceVisitDurationInPercentage').append("<i class='fa fa-caret-down'></i> " + totalVDChangesInTwoWeeks.toFixed(2) + "%");

        $("#vbdVisitDuration .svgTextChanges").addClass("drop");
        $("#vbdVisitDuration .svgTextChanges").html("-" + totalVDChangesInTwoWeeks.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
        //$("#visitDurationUpDownIcon").html("<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i>");
    }
    else {
        $('#differenceVisitDurationInPercentage').append(LanguageNoChanges);
        $("#vbdVisitDuration .svgTextChanges").html(LanguageNoChanges);

        //$("#visitDurationUpDownIcon").html("");
    }

    $("#vbdVisitDuration").addClass("shown");

    //identify largest value of yaxis data
    var largestValue = 0;

    for (var i = 0; i < sparkLineValue.length; i++) {
        if (sparkLineValue[i] != null && sparkLineValue[i] != undefined && sparkLineValue[i] > largestValue)
            largestValue = sparkLineValue[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;
    //draw graph under each box, turn in rate
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: '7daysVisitDuration',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                gridLineWidth: 0,
                tickWidth: 1,
                tickInterval: dynamicTickInterval,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: sparkLineValue,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}






//--------------Returning Customer--------------//
//Returning Customer Monthly Trend
function bindReturningCustomerMonthlyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        //console.log(datas);
        var lastYearReturningRate = datas.series[0];
        var thisYearReturningRate = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYearReturningRate.data.length; i++) {
            if (lastYearReturningRate.data[i] != null &&
                lastYearReturningRate.data[i] != undefined &&
                lastYearReturningRate.data[i] > largestValue) {
                largestValue = lastYearReturningRate.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYearReturningRate.data.length; i++) {
            if (thisYearReturningRate.data[i] != null && thisYearReturningRate.data[i] != undefined && thisYearReturningRate.data[i] > largestValue)
                largestValue = thisYearReturningRate.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newReturningCustomerMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,//thisYearReturningRate.name,
                data: thisYearReturningRate.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,//lastYearReturningRate.name,
                dashStyle: 'dash',
                data: lastYearReturningRate.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagereturningcustomerwithinlast7days + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.returningCust,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=22&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageReturningRateprecent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 96,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });

}

//Returning Customer Daily Trend
function bindReturningCustomerDailyTrend(datas, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYearReturningRate = datas.series[0];
        var thisYearReturningRate = datas.series[1];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYearReturningRate.data.length; i++) {
            if (lastYearReturningRate.data[i] != null &&
                lastYearReturningRate.data[i] != undefined &&
                lastYearReturningRate.data[i] > largestValue) {
                largestValue = lastYearReturningRate.data[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYearReturningRate.data.length; i++) {
            if (thisYearReturningRate.data[i] != null && thisYearReturningRate.data[i] != undefined && thisYearReturningRate.data[i] > largestValue)
                largestValue = thisYearReturningRate.data[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newReturningCustomerDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,//thisYearReturningRate.name,
                data: thisYearReturningRate.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,//lastYearReturningRate.name,
                dashStyle: 'dash',
                data: lastYearReturningRate.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentageofreturningcustomerforthisweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.returningCust,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageReturningRateprecent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 180,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

//Returning Customer Last Two Weeks Comparison Table, Donut Chart
function bindLastTwoWeeksReturningCustomerDataIntoTable(ReturningCustDatas, colorScheme) {
    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;
    $("#lastTwoWeeksReturningCustomerComparisonTableHead").html("");
    $("#lastTwoWeeksReturningCustomerComparisonTableContent").html("");
    $("#lastTwoWeeksReturningCustomerComparisonTableFoot").html("");

    var tempLastWeekReturningRate = 0;
    var tempThisWeekReturningRate = 0;
    var tempChangesOfReturningRate = 0;

    //for total
    var totalLastWeekReturningCust = ReturningCustDatas.series[7].total == 0 ? "-" : ReturningCustDatas.series[7].total.toFixed(2) + "%";
    var totalThisWeekReturningCust = ReturningCustDatas.series[1].total == 0 ? "-" : ReturningCustDatas.series[1].total.toFixed(2) + "%";
    var totalChanges = ReturningCustDatas.series[2].total.toFixed(2);

    if (totalLastWeekReturningCust == "-") {
        $("#lastTwoWeeksReturningCustomerComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");

        //changes in percentage
        for (var i = 0; i < 7; i++) {
            tempThisWeekReturningRate = ReturningCustDatas.series[1].data[i] > 0 ? ReturningCustDatas.series[1].data[i].toFixed(2) + "%" : " - ";
            $("#lastTwoWeeksReturningCustomerComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekReturningRate + "</td></tr>");
        }

        $("#lastTwoWeeksReturningCustomerComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalThisWeekReturningCust + "</td></tr>");

    } else {
        $("#lastTwoWeeksReturningCustomerComparisonTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

        //changes in percentage
        for (var i = 0; i < 7; i++) {
            tempLastWeekReturningRate = ReturningCustDatas.series[7].data[i] > 0 ? ReturningCustDatas.series[7].data[i].toFixed(2) + "%" : " - ";
            tempThisWeekReturningRate = ReturningCustDatas.series[1].data[i] > 0 ? ReturningCustDatas.series[1].data[i].toFixed(2) + "%" : " - ";
            tempChangesOfReturningRate =
                ReturningCustDatas.series[2].data[i].charAt(0) == "+" ? "<i class='fa fa-caret-up rise'></i> " + ReturningCustDatas.series[2].data[i].substring(1) :
                    ReturningCustDatas.series[2].data[i].charAt(0) == "-" ? "<i class='fa fa-caret-down drop'></i> " + ReturningCustDatas.series[2].data[i].substring(1) :
                        ReturningCustDatas.series[2].data[i].charAt(0) == "0" ? " - " : " - ";
            $("#lastTwoWeeksReturningCustomerComparisonTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + tempThisWeekReturningRate + "</td><td>" + tempLastWeekReturningRate + "</td><td>" + tempChangesOfReturningRate + "</td></tr>");
        }

        if (totalChanges == 0)
            totalChanges = "-";
        else {
            if (totalChanges > 0)
                totalChanges = "<i class='fa fa-caret-up rise'></i> " + totalChanges + "%";
            else
                totalChanges = "<i class='fa fa-caret-down drop'></i> " + totalChanges * -1 + "%";
        }

        $("#lastTwoWeeksReturningCustomerComparisonTableFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalThisWeekReturningCust + "</td><td>" + totalLastWeekReturningCust + "</td><td>" + totalChanges + "</td></tr>");
    }

    var sparkLineValue = ReturningCustDatas.series[1].data;
    //mini graph
    //totalLastWeekReturningCust = ReturningCustDatas.series[3].total == 0 ? "-" : ReturningCustDatas.series[3].total.toFixed(2) + "%";
    $('#returningCustomerThisWeek').empty();
    //$('#returningCustomerLastWeek').empty();
    $('#differenceReturningCustomerInPercentage').empty();
    //$("#returningCustomerUpDownIcon").empty();

    $("#vbdReturningCustomer").removeClass("shown");

    $('#returningCustomerThisWeek').text(totalThisWeekReturningCust);

    if ($.isNumeric(ReturningCustDatas.series[1].total) && ReturningCustDatas.series[1].total != 0)
        $("#vbdReturningCustomer .svgTextValue").html(totalThisWeekReturningCust);
    else
        $("#vbdReturningCustomer .svgTextValue").html("");

    //$('#returningCustomerLastWeek').text("(" + LanguageThisWeek + ": " + totalLastWeekReturningCust + ")");
    totalChanges = ReturningCustDatas.series[4].total;
    $('#differenceReturningCustomerInPercentage').removeClass("rise");
    $('#differenceReturningCustomerInPercentage').removeClass("drop");

    $("#vbdReturningCustomer .svgTextChanges").removeClass("rise").removeClass("drop");

    if (totalChanges > 0) {
        $('#differenceReturningCustomerInPercentage').addClass("rise");
        $('#differenceReturningCustomerInPercentage').append("<i class='fa fa-caret-up'></i> " + kFormatter(totalChanges) + "% ");

        $("#vbdReturningCustomer .svgTextChanges").addClass("rise");
        $("#vbdReturningCustomer .svgTextChanges").html("+" + kFormatter(totalChanges) + "% <i class='fa fa-caret-up'></i>");
        //$("#returningCustomerUpDownIcon").html("<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i>")
    }
    else if (totalChanges < 0) {
        totalChanges *= -1;
        $('#differenceReturningCustomerInPercentage').addClass("drop");
        $('#differenceReturningCustomerInPercentage').append("<i class='fa fa-caret-down'></i> " + kFormatter(totalChanges) + "% ");

        $("#vbdReturningCustomer .svgTextChanges").addClass("drop");
        $("#vbdReturningCustomer .svgTextChanges").html("-" + kFormatter(totalChanges) + "% <i class='fa fa-caret-down'></i>");
        //$("#returningCustomerUpDownIcon").html("<i class='fa fa-caret-down' style='color: " + colorScheme.chart.arrow.down + ";'></i>")
    }
    else {
        $('#differenceReturningCustomerInPercentage').append(LanguageNoChanges);
        $("#vbdReturningCustomer .svgTextChanges").html(LanguageNoChanges);

        //$("#returningCustomerUpDownIcon").html("")
    }

    $("#vbdReturningCustomer").addClass("shown");

    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == null && sparkLineValue[6] == null) {
        sparkLineValue[5] = 0;
        sparkLineValue[6] = 0;
    }
    if (sparkLineValue[0] == 0 && sparkLineValue[1] == 0 && sparkLineValue[2] == 0 && sparkLineValue[3] == 0 && sparkLineValue[4] == 0 && sparkLineValue[5] == 0 && sparkLineValue[6] == null) {
        sparkLineValue[6] = 0;
    }

    //draw 7 days graph
    $(function () {
        var chart = new Highcharts.Chart({

            chart: {
                renderTo: '7daysReturningCustomer',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                useHTML: true,
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: sparkLineValue,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });


    //donut chart
    newCustomer = ReturningCustDatas.series[6].total;
    returningCustomer = ReturningCustDatas.series[5].total;
    var centerText = ReturningCustDatas.series[5].total.toFixed(2);

    var donutChartColors = $.map(colorScheme.chart.donut, function (value, index) {
        return [value];
    });

    $(function () {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'thisWeekAverageReturningCustomerDonutChart',
                type: 'pie'
            },
            colors: donutChartColors,
            title: {
                text: ''
            },
            yAxis: {
                title: {
                    text: ''
                }
            },
            plotOptions: {
                series: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + $("#datePickerDateRange").val().substr(5, 2) + "&range=day&parameter=22&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    }
                }
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.point.name + '</b>: ' + this.y + ' %';
                }
            },
            exporting: {
                enabled: false
            },
            credits: {
                enabled: false
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    fontFamily: colorScheme.chart.legend.text.fontFamily,
                    //fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                margin: 0
            },
            series: [{
                name: LanguageThisWeekAverage,
                data: [
                    [LanguageNewCustomer, newCustomer],
                    [LanguageReturningCustomer, returningCustomer]
                ],
                size: '100%',
                innerSize: '60%',
                showInLegend: true,
                dataLabels: {
                    enabled: true,
                    distance: -30,
                    style: {
                        fontFamily: colorScheme.chart.dataLabel.fontFamily,
                        color: colorScheme.chart.dataLabel.color,
                        fontSize: colorScheme.chart.dataLabel.fontSize,
                        fontWeight: colorScheme.chart.dataLabel.fontWeight
                    },
                    formatter: function () {
                        return "<b>" + this.y + '%</b>';
                    }
                }
            }]
        },

            function (chart) { // on complete
                var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                var textY = chart.plotTop + (chart.plotHeight * 0.5);

                var span = '<span id="RRpieChartInfoText" style="position:absolute; text-align:center;">';
                span += '<span class="pieChartInfoTextTitle">' + centerText + '%</span><br>';
                span += '<span class="pieChartInfoTextSubtitle">';
                span += '<span>' + LanguageThisWeek + '</span><br />';
                span += '<span>' + LanguageAverage + '</span>';
                span += '</span></span>';

                $("#ReturningCustomerDonutChartCenterText").empty();
                $("#ReturningCustomerDonutChartCenterText").append(span);
                span = $('#RRpieChartInfoText');
                span.css('left', textX + (span.width() * -0.43));
                span.css('top', textY + (span.height() * -0.5));

                $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
            });
    });

}





//--------------Sales Conversion--------------//
//monthly trend
function bindSalesConversionMonthlyTrend(data, colorScheme) {

    for (i = 0; i < data.series[1].data.length; i++) {
        if (data.series[1].data[i] != 0) {
            $('#salesConversionSection').show();
            $('#noData').hide();
        }
    }
    var footfall = data.series[0];
    var transactionCount = data.series[1];

    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
        : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
            : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                    : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                        : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                            : 1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
        : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
            : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                    : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                        : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                            : 1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newSalesConversionMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageMonthlypercentofspendingvisitors + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                tickWidth: 0,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                min: 0,
                gridLineWidth: 0,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 18,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//weekly trend
function bindSalesConversionWeeklyTrend(data, colorScheme) {
    var tempWeek = [];
    for (var i = 1; i <= data.categories.length; i++) {
        tempWeek.push(i);
    }

    var footfall = data.series[0];
    var transactionCount = data.series[1];
    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
        : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
            : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                    : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                        : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                            : 1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
        : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
            : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                    : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                        : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                            : 1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newSalesConversionWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagespendingvisitorsforeachweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                tickWidth: 0,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });



}

//daily trend
function bindSalesConversionDailyTrend(data, colorScheme, data1) {
    var footfall = data.series[0];
    var transactionCount = data.series[1];
    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
        : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
            : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                    : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                        : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                            : 1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
        : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
            : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                    : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                        : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                            : 1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newSalesConversionDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentofspendingvisitors + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.salesConversion,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                tickWidth: 0,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickPixelInterval: 40,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesVolume,
                    margin: 25,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        color: colorScheme.chart.axisLabel.y.label.color,
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });

    var lastWeekSales = 0;
    var lastWeekVisitor = 0;
    for (var x = data.series[0].data.length - 14; x < data.series[0].data.length - 7; x++) {
        lastWeekVisitor = lastWeekVisitor + data.series[0].data[x];
    }
    for (var x = data.series[1].data.length - 14; x < data.series[1].data.length - 7; x++) {
        lastWeekSales = lastWeekSales + data.series[1].data[x];
    }


    var thisWeekSales = 0;
    var thisWeekVisitor = 0;
    for (var x = data.series[0].data.length - 7; x < data.series[0].data.length; x++) {
        thisWeekVisitor = thisWeekVisitor + data.series[0].data[x];
    }
    for (var x = data.series[1].data.length - 7; x < data.series[1].data.length; x++) {
        thisWeekSales = thisWeekSales + data.series[1].data[x];
    }

    var lastWeekConv = lastWeekSales / (lastWeekVisitor * 1.0) * 100;
    //var thisWeekConv = thisWeekSales / (thisWeekVisitor * 1.0) * 100;
    var thisWeekConv = data1.series[2].total > 0 ? data1.series[2].total : "-";

    var variances = (thisWeekConv - lastWeekConv);
    var variances2 = (thisWeekSales - lastWeekSales) / (lastWeekSales * 1.0) * 100;

    variances = variances.toFixed(2);
    variances2 = variances2.toFixed(2);
    //console.log("new " + thisWeekVisitor + " " + thisWeekConv + " " + conversion);
    console.log(thisWeekConv + " " + lastWeekConv + " " + (lastWeekConv));
    console.log((thisWeekSales + " " + lastWeekSales) + " " + (lastWeekSales));
    if (variances > 0) {

        $("#differenceSalesConvInPercentage").html("<i class='fa fa-caret-up'></i> " + variances + "%");
        $("#differenceSalesConvInPercentage").removeClass("drop");
        $("#differenceSalesConvInPercentage").addClass("rise");
    } else if (variances < 0) {

        $("#differenceSalesConvInPercentage").html("<i class='fa fa-caret-down'></i> " + variances * -1 + "%");
        $("#differenceSalesConvInPercentage").removeClass("rise");
        $("#differenceSalesConvInPercentage").addClass("drop");
    }

    if (variances2 > 0) {

        $("#differenceTransaction").html("<i class='fa fa-caret-up'></i> " + variances2 + "%");
        $("#differenceTransaction").removeClass("drop");
        $("#differenceTransaction").addClass("rise");
    } else if (variances2 < 0) {

        $("#differenceTransaction").html("<i class='fa fa-caret-down'></i> " + variances2 * -1 + "%");
        $("#differenceTransaction").removeClass("rise");
        $("#differenceTransaction").addClass("drop");
    }
}

//weekdays trend
function bindWeekdaysSCTrend(data, colorScheme) {
    var weekdaysnoofvisitor = data.series[0].data;
    var weekdayssalesvolume = data.series[1].data;
    var largestValue = 0;

    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }

    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekdaysnoofvisitor.length; i++) {
        if (weekdaysnoofvisitor[i] != null && weekdaysnoofvisitor[i] != undefined && weekdaysnoofvisitor[i] > largestValue)
            largestValue = weekdaysnoofvisitor[i]
    }
    for (var i = 0; i < weekdayssalesvolume.length; i++) {
        if (weekdayssalesvolume[i] != null && weekdayssalesvolume[i] != undefined && weekdayssalesvolume[i] > largestValue)
            largestValue = weekdayssalesvolume[i]
    }
    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;

    //weekdays trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysSalesConversion",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekdaysnoofvisitor,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekdayssalesvolume,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsfromMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {

                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: '12px',
                        "font-family": "Arial"
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });

    if (data.series[0].isDayOff) {
        $("#weekdaysSalesConversion").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
    }
}
//weekends trend
function bindWeekendsSCTrend(data, colorScheme) {

    var weekendsnoofvisitor = data.series[0];
    var weekendssalesvolume = data.series[1];
    //identify largest value of yaxis data

    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }
    var largestValue = 0;
    for (var i = 0; i < weekendsnoofvisitor.data.length; i++) {
        if (weekendsnoofvisitor.data[i] != null && weekendsnoofvisitor.data[i] != undefined && weekendsnoofvisitor.data[i] > largestValue)
            largestValue = weekendsnoofvisitor.data[i]
    }
    for (var i = 0; i < weekendssalesvolume.data.length; i++) {
        if (weekendssalesvolume.data[i] != null && weekendssalesvolume.data[i] != undefined && weekendssalesvolume.data[i] > largestValue)
            largestValue = weekendssalesvolume.data[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;

    //weekends trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsSalesConversion",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageNoofVisitor,
                data: weekendsnoofvisitor.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageSalesVolume,
                dashStyle: 'dash',
                data: weekendssalesvolume.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickInterval: dynamicTickInterval,
                tickWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickInterval: dynamicTickInterval,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });
    if (data.series[0].isDayOff) {
        $("#weekendsSalesConversion").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
    }
}

function bindThisWeekSCInTable(data, colorScheme) {

    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    $("#tableSalesConversionHead").html("");
    $("#tableSalesConversionContent").html("");
    $("#tableSalesConversionFoot").html("");
    $("#tableSalesConversionHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageSalesVolume + "</th><th>" + LanguageConversion + "</th></tr>");

    for (var i = 0; i < 7; i++) {
        var saleConversion = data.series[2].data[i] > 0 ? data.series[2].data[i] + "%" : "-";
        var valueIn = data.series[0].data[i] > 0 ? data.series[0].data[i] : "-";
        var salesVolume = data.series[1].data[i] > 0 ? data.series[1].data[i] : "-";

        $("#tableSalesConversionContent").append("<tr><td>" + weekDay[i] + "</td><td>" + valueIn + "</td><td>" + salesVolume + "</td><td>" + saleConversion + "</td></tr>");

    }

    conversion = data.series[2].total > 0 ? data.series[2].total + "%" : "-";
    totalvisitors = data.series[0].total > 0 ? data.series[0].total : "-";
    totalsales = data.series[1].total > 0 ? data.series[1].total : "-";

    $("#tableSalesConversionFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalvisitors + "</td><td>" + totalsales + "</td><td>" + conversion + "</td></tr>");

    $("#SalesConvThisWeek").html(conversion);

    $("#transactionThisWeek").html(totalsales);

    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: '7daysSalesConv',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                tickWidth: 1,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data.series[2].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });

    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: '7daysTransaction',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                tickWidth: 1,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: data.series[1].data,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}




//--------------Revenue per Visitor--------------//
//monthly trend
function bindRevenuePerVisitorMonthlyTrend(data, colorScheme) {
    var lastYear = data.series[0];
    var thisYear = data.series[1];

    //identify largest value of yaxis data
    var lastYearLargestValue = 0;
    for (var i = 0; i < lastYear.data.length; i++) {
        if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > lastYearLargestValue)
            lastYearLargestValue = lastYear.data[i]
    }
    var lastYearDynamicTickInterval = lastYearLargestValue >= 0 && lastYearLargestValue < 10 ? 1
        : lastYearLargestValue >= 10 && lastYearLargestValue < 100 ? 10
            : lastYearLargestValue >= 100 && lastYearLargestValue < 1000 ? 100
                : lastYearLargestValue >= 1000 && lastYearLargestValue < 10000 ? 1000
                    : lastYearLargestValue >= 10000 && lastYearLargestValue < 100000 ? 10000
                        : lastYearLargestValue >= 100000 && lastYearLargestValue < 1000000 ? 100000
                            : 1000000;

    var thisYearLargestValue = 0;
    for (var i = 0; i < thisYear.data.length; i++) {
        if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > thisYearLargestValue)
            thisYearLargestValue = thisYear.data[i]
    }
    var thisYearDynamicTickInterval = thisYearLargestValue >= 0 && thisYearLargestValue < 10 ? 1
        : thisYearLargestValue >= 10 && thisYearLargestValue < 100 ? 10
            : thisYearLargestValue >= 100 && thisYearLargestValue < 1000 ? 100
                : thisYearLargestValue >= 1000 && thisYearLargestValue < 10000 ? 1000
                    : thisYearLargestValue >= 10000 && thisYearLargestValue < 100000 ? 10000
                        : thisYearLargestValue >= 100000 && thisYearLargestValue < 1000000 ? 100000
                            : 1000000;
    if (thisYearDynamicTickInterval == 1) {
        thisYearDynamicTickInterval = lastYearDynamicTickInterval;
    }
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "revenuePerVisitorMonthlyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: data.series[1].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: data.series[0].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageMonthlyofrevenuepervisitor + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                //tickInterval: lastYearDynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 1,
                min: 0,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageRevenuePerVisitor + "($)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 6,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 36,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//weekly trend
function bindRevenuePerVisitorWeeklyTrend(data, colorScheme) {

    var lastYear = data.series[0];
    var thisYear = data.series[1];
    //identify largest value of yaxis data
    var lastYearLargestValue = 0;
    for (var i = 0; i < lastYear.data.length; i++) {
        if (lastYear.data[i] != null && lastYear.data[i] != undefined && lastYear.data[i] > lastYearLargestValue)
            lastYearLargestValue = lastYear.data[i]
    }
    var lastYearDynamicTickInterval = lastYearLargestValue >= 0 && lastYearLargestValue < 10 ? 1
        : lastYearLargestValue >= 10 && lastYearLargestValue < 100 ? 10
            : lastYearLargestValue >= 100 && lastYearLargestValue < 1000 ? 100
                : lastYearLargestValue >= 1000 && lastYearLargestValue < 10000 ? 1000
                    : lastYearLargestValue >= 10000 && lastYearLargestValue < 100000 ? 10000
                        : lastYearLargestValue >= 100000 && lastYearLargestValue < 1000000 ? 100000
                            : 1000000;

    var thisYearLargestValue = 0;
    for (var i = 0; i < thisYear.data.length; i++) {
        if (thisYear.data[i] != null && thisYear.data[i] != undefined && thisYear.data[i] > thisYearLargestValue)
            thisYearLargestValue = thisYear.data[i]
    }
    var thisYearDynamicTickInterval = thisYearLargestValue >= 0 && thisYearLargestValue < 10 ? 1
        : thisYearLargestValue >= 10 && thisYearLargestValue < 100 ? 10
            : thisYearLargestValue >= 100 && thisYearLargestValue < 1000 ? 100
                : thisYearLargestValue >= 1000 && thisYearLargestValue < 10000 ? 1000
                    : thisYearLargestValue >= 10000 && thisYearLargestValue < 100000 ? 10000
                        : thisYearLargestValue >= 100000 && thisYearLargestValue < 1000000 ? 100000
                            : 1000000;
    if (thisYearDynamicTickInterval == 1) {
        thisYearDynamicTickInterval = lastYearDynamicTickInterval;
    }

    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "revenuePerVisitorWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: data.series[1].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: data.series[0].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagemoneyspendingvisitorsforeachweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: lastYearDynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageRevenuePerVisitor + "($)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//daily trend
function bindRevenuePerVisitorDailyTrend(data, colorScheme) {
    var footfall = data.series[0];
    var transactionCount = data.series[1];
    //identify largest value of yaxis data
    var footfallLargestValue = 0;
    for (var i = 0; i < footfall.data.length; i++) {
        if (footfall.data[i] != null && footfall.data[i] != undefined && footfall.data[i] > footfallLargestValue)
            footfallLargestValue = footfall.data[i]
    }
    var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
        : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
            : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                    : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                        : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                            : 1000000;

    var transactionLargestValue = 0;
    for (var i = 0; i < transactionCount.data.length; i++) {
        if (transactionCount.data[i] != null && transactionCount.data[i] != undefined && transactionCount.data[i] > transactionLargestValue)
            transactionLargestValue = transactionCount.data[i]
    }
    var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
        : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
            : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                    : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                        : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                            : 1000000;
    if (transactionDynamicTickInterval == 1) {
        transactionDynamicTickInterval = footfallDynamicTickInterval;
    }
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "revenuePerVisitorDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: data.series[0].data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: data.series[1].data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentofspendingvisitors + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: footfallDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageRevenuePerVisitor + "($)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                tickWidth: 1,
                tickInterval: footfallDynamicTickInterval,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickPixelInterval: 40,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesVolume,
                    margin: 25,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        color: colorScheme.chart.axisLabel.y.label.color,
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                tickInterval: 1,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 206,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

//weekday trend
function bindRevenuePerVisitorWeekdaysTrend(data, colorScheme) {
    var weekdaysnoofvisitor = data.series[0];
    var weekdayssalesvolume = data.series[1];

    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }
    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekdaysnoofvisitor.data.length; i++) {
        if (weekdaysnoofvisitor.data[i] != null && weekdaysnoofvisitor.data[i] != undefined && weekdaysnoofvisitor.data[i] > largestValue)
            largestValue = weekdaysnoofvisitor.data[i]
    }
    for (var i = 0; i < weekdayssalesvolume.data.length; i++) {
        if (weekdayssalesvolume.data[i] != null && weekdayssalesvolume.data[i] != undefined && weekdayssalesvolume.data[i] > largestValue)
            largestValue = weekdayssalesvolume.data[i]
    }

    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;
    //weekdays trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "revenuePerVisitorWeekdays",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: weekdaysnoofvisitor.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: weekdayssalesvolume.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsfromMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                gridLineWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageRevenuePerVisitor + "($)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });
    if (data.series[0].isDayOff) {
        $("#revenuePerVisitorWeekdays").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
    }

}

function bindRevenuePerVisitorWeekendsTrend(data, colorScheme) {

    var weekendsnoofvisitor = data.series[0];
    var weekendssalesvolume = data.series[1];

    if (data.series[0].isDayOff) {
        var showmarker = false;
        var showtooltip = false;
    }
    else {
        var showmarker = true;
        var showtooltip = true;
    }
    //identify largest value of yaxis data
    var largestValue = 0;
    for (var i = 0; i < weekendsnoofvisitor.data.length; i++) {
        if (weekendsnoofvisitor.data[i] != null && weekendsnoofvisitor.data[i] != undefined && weekendsnoofvisitor.data[i] > largestValue)
            largestValue = weekendsnoofvisitor.data[i]
    }
    for (var i = 0; i < weekendssalesvolume.data.length; i++) {
        if (weekendssalesvolume.data[i] != null && weekendssalesvolume.data[i] != undefined && weekendssalesvolume.data[i] > largestValue)
            largestValue = weekendssalesvolume.data[i]
    }


    var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
        : largestValue >= 10 && largestValue < 100 ? 10
            : largestValue >= 100 && largestValue < 1000 ? 100
                : largestValue >= 1000 && largestValue < 10000 ? 1000
                    : largestValue >= 10000 && largestValue < 100000 ? 10000
                        : largestValue >= 100000 && largestValue < 1000000 ? 100000
                            : 1000000;



    //weekends trend
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "revenuePerVisitorWeekends",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: weekendsnoofvisitor.data,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: weekendssalesvolume.data,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showmarker,
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickWidth: 1,
                tickPosition: 'inside',
                title: {
                    text: LanguageRevenuePerVisitor + "($)",
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageSalesVolume,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                }
            }],
            xAxis: {
                categories: data.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                //itemStyle: {
                //    color: colorScheme.chart.legend.text.color,
                //    "font-family": colorScheme.chart.legend.text.fontFamily,
                //    fontSize: colorScheme.chart.legend.text.fontSize,
                //    "font-weight": colorScheme.chart.legend.text.fontWeight
                //},
                enabled: false,
                //x: 12,
                //y: 15,
                //verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showtooltip,
            },
        });
    });
    if (data.series[0].isDayOff) {
        $("#revenuePerVisitorWeekends").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
    }
}

//Table
function bindRevenuePerVisitorTable(data, colorScheme) {

    var weekNo = $('#weekpicker').val();
    weekNo = LanguageWeek + " " + weekNumber;

    $("#revenuePerVisitorTableHead").html("");
    $("#revenuePerVisitorTableContent").html("");
    $("#revenuePerVisitorTableFoot").html("");
    $("#revenuePerVisitorTableHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");
    for (var i = 0; i < 7; i++) {
        var thisYear = data.series[1].data[i] > 0 ? "$" + data.series[1].data[i] : " - ";
        var lastYear = data.series[0].data[i] > 0 ? "$" + data.series[0].data[i] : " - ";
        var changes =
            data.series[2].data[i].charAt(0) == "+" ? "<i class='fa fa-caret-up'style='color: " + colorScheme.chart.arrow.up + ";'></i>" + data.series[2].data[i].substring(1) + "%" :
                data.series[2].data[i].charAt(0) == "-" ? "<i class='fa fa-caret-down'style='color: " + colorScheme.chart.arrow.down + ";'></i>" + data.series[2].data[i].substring(1) + "%" :
                    data.series[2].data[i].charAt(0) == "0" ? " - " : " - ";
        valueIn = data.series[0].data[i] == 0 ? "-" : data.series[0].data[i];
        salesVolume = data.series[1].data[i] == 0 ? "-" : data.series[1].data[i];
        $("#revenuePerVisitorTableContent").append("<tr><td>" + weekDay[i] + "</td><td>" + lastYear + "</td><td>" + thisYear + "</td><td>" + changes + "</td></tr>");
    }
}

function bindOutsideTraffic(data) {
    $("#vbdOutsideTraffic").removeClass("animated").removeClass("fadeIn");
    $("#vbdOutsideTraffic .svgTextChanges").removeClass("rise").removeClass("drop");

    if (data.series[1].total != null && data.series[1].total != 0) {
        $("#vbdOutsideTraffic .svgTextValue").html(numberWithCommas(data.series[1].total));

        $("#totalOutsideTrafficThisWeek").html(numberWithCommas(data.series[1].total));
    }


    if (data.series[2].total != null) {
        if (data.series[2].total > 0) {
            $("#vbdOutsideTraffic .svgTextChanges").addClass("rise");
            $("#vbdOutsideTraffic .svgTextChanges").html("+" + data.series[2].total + "% <i class='fa fa-caret-up'></i>");
            $("#totalOutsideTrafficUpDownPercent").html("<i class='fa fa-caret-up'></i>" + data.series[2].total + "%");
            $("#totalOutsideTrafficUpDownPercent").removeClass("drop");
            $("#totalOutsideTrafficUpDownPercent").addClass("rise");
        } else if (data.series[2].total < 0) {
            $("#vbdOutsideTraffic .svgTextChanges").addClass("drop");
            $("#vbdOutsideTraffic .svgTextChanges").html("-" + data.series[2].total * -1 + "% <i class='fa fa-caret-down'></i>");
            $("#totalOutsideTrafficUpDownPercent").html("<i class='fa fa-caret-down'></i> " + data.series[2].total * -1 + "%");
            $("#totalOutsideTrafficUpDownPercent").removeClass("rise");
            $("#totalOutsideTrafficUpDownPercent").addClass("drop");
        }
        else {
            //$("#vbdOutsideTraffic .svgTextChanges").addClass("drop");
            //$("#vbdOutsideTraffic .svgTextChanges").html("-" + data.series[2].total * -1 + "% <i class='fa fa-caret-down'></i>");
            $("#vbdOutsideTraffic .svgTextChanges").html(LanguageNoChanges);
        }

        $("#vbdOutsideTraffic").css("display", "block");
    }


}

function bindCrossShopper(data, colorScheme) {

    var totalThisWeek = data.series[0].data[0];
    var totalLastWeek = data.series[1].data[0];
    var ThisWeek = data.series[2].data;

    $("#CSthisweek").html(data.series[0].data[0] + "%");

    var variances = ((totalThisWeek - totalLastWeek) / (totalLastWeek * 1.0) * 100).toFixed(2);

    if (variances > 0) {

        $("#diffCS").html("<i class='fa fa-caret-up'></i> " + variances + "%");
        $("#diffCS").removeClass("drop");
        $("#diffCS").addClass("rise");
    } else if (variances < 0) {

        $("#diffCS").html("<i class='fa fa-caret-down'></i> " + variances * -1 + "%");
        $("#diffCS").removeClass("rise");
        $("#diffCS").addClass("drop");
    }

    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: false
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: '7daysCS',
                margin: [0, 0, 0, 0],
                backgroundColor: 'transparent'
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                }
            },
            yAxis: {
                maxPadding: 0,
                minPadding: 0,
                tickWidth: 1,
                gridLineWidth: 0,
                endOnTick: false,
                labels: {
                    enabled: false
                }
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                series: {
                    enableMouseTracking: false,
                    lineWidth: 1,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 1
                        }
                    },
                    marker: {
                        radius: 0,
                        states: {
                            hover: {
                                radius: 2
                            }
                        }
                    }
                }
            },
            exporting: {
                enabled: false,
            },
            series: [{
                type: 'areaspline',
                data: ThisWeek,
                color: colorScheme.chart.sparkLine.color,
                fillOpacity: 0.5
            }]
        });
    });
}
*/

//--------------Top Matric----------------------
function bindVisitDurationBox(data, colorScheme) {
    $("#visitDurationThisWeek").empty();
    //$("#visitDurationLastWeek").empty();
    $("#differenceVisitDurationInPercentage").empty();
    //$("#visitDurationUpDownIcon").html();

    var visitDurationTotal = data[0].series[0].VisitDurationTotal;
    var changes = data[0].series[0].DifferencesInVisitDuration;

    if (visitDurationTotal == 0)
        $("#visitDurationThisWeek").append("-");
    else
        $("#visitDurationThisWeek").append(visitDurationTotal.toFixed(2) + "m");

    $("#differenceVisitDurationInPercentage").removeClass("rise");
    $("#differenceVisitDurationInPercentage").removeClass("drop");


    if (changes == 0) {
        $("#differenceVisitDurationInPercentage").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#differenceVisitDurationInPercentage").addClass("rise");
        $("#differenceVisitDurationInPercentage").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#differenceVisitDurationInPercentage").addClass("drop");
        $("#differenceVisitDurationInPercentage").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindReturningRateBox(data, colorScheme) {
    $("#returningCustomerThisWeek").empty();
    //$("#returningRateLastWeek").empty();
    $("#differenceReturningCustomerInPercentage").empty();
    //$("#returningRateUpDownIcon").html();

    var returnCustomerRate = data[0].series[0].ReturnCustomerRate;
    var changes = data[0].series[0].DifferencesInReturingCustomerRate;

    if (returnCustomerRate == 0)
        $("#returningCustomerThisWeek").append("-");
    else
        $("#returningCustomerThisWeek").append(returnCustomerRate.toFixed(2) + "%");

    $("#differenceReturningCustomerInPercentage").removeClass("rise");
    $("#differenceReturningCustomerInPercentage").removeClass("drop");


    if (changes == 0) {
        $("#differenceReturningCustomerInPercentage").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#differenceReturningCustomerInPercentage").addClass("rise");
        $("#differenceReturningCustomerInPercentage").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#differenceReturningCustomerInPercentage").addClass("drop");
        $("#differenceReturningCustomerInPercentage").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindFootfallBox(data, colorScheme) {
    $("#totalVisitorThisWeek").empty();
    //$("#totalVisitorLastWeek").empty();
    $("#totalVisitorUpDownPercent").empty();
    //$("#totalVisitorUpDownIcon").html();

    var visitorTotal = data[0].series[0].visitorTotal;
    var changes = data[0].series[0].DifferencesInFF;

    if (visitorTotal == 0)
        $("#totalVisitorThisWeek").append("-");
    else
        $("#totalVisitorThisWeek").append(numberWithCommas(visitorTotal));

    $("#totalVisitorUpDownPercent").removeClass("rise");
    $("#totalVisitorUpDownPercent").removeClass("drop");

    if (changes == 0) {
        $("#totalVisitorUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#totalVisitorUpDownPercent").addClass("rise");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#totalVisitorUpDownPercent").addClass("drop");
        $("#totalVisitorUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }

}

function bindTurnInRateBox(data, colorScheme) {
    $("#turnInRateThisWeek").empty();
    //$("#turnInRateLastWeek").empty();
    $("#differenceTurnInRateInPercentage").empty();
    //$("#turnInRateUpDownIcon").html();

    var turnInRateTotal = data[0].series[0].TurnInRateTotal;
    var changes = data[0].series[0].DifferencesInTIR;

    if (turnInRateTotal == 0)
        $("#turnInRateThisWeek").append("-");
    else
        $("#turnInRateThisWeek").append(turnInRateTotal.toFixed(2) + "%");

    $("#differenceTurnInRateInPercentage").removeClass("rise");
    $("#differenceTurnInRateInPercentage").removeClass("drop");

    if (changes == 0) {
        $("#differenceTurnInRateInPercentage").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#differenceTurnInRateInPercentage").addClass("rise");
        $("#differenceTurnInRateInPercentage").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#differenceTurnInRateInPercentage").addClass("drop");
        $("#differenceTurnInRateInPercentage").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindOutsideTrafficBox(data, colorScheme) {
    $("#totalOutsideTrafficThisWeek").empty();
    //$("#turnInRateLastWeek").empty();
    $("#totalOutsideTrafficUpDownPercent").empty();
    //$("#turnInRateUpDownIcon").html();

    var outisdeTrafficTotal = data[0].series[0].OutsideTrafficTotal;
    var changes = data[0].series[0].DifferencesInOT;

    if (outisdeTrafficTotal == 0)
        $("#totalOutsideTrafficThisWeek").append("-");
    else
        $("#totalOutsideTrafficThisWeek").append(numberWithCommas(outisdeTrafficTotal));

    $("#totalOutsideTrafficUpDownPercent").removeClass("rise");
    $("#totalOutsideTrafficUpDownPercent").removeClass("drop");

    if (changes == 0) {
        $("#totalOutsideTrafficUpDownPercent").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#totalOutsideTrafficUpDownPercent").addClass("rise");
        $("#totalOutsideTrafficUpDownPercent").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#totalOutsideTrafficUpDownPercent").addClass("drop");
        $("#totalOutsideTrafficUpDownPercent").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindSalesConversionBox(data, colorScheme) {

    $('#salesConversionTopMatricBlock').show();
    $("#SalesConvThisWeek").empty();
    //$("#turnInRateLastWeek").empty();
    $("#differenceSalesConvInPercentage").empty();
    //$("#turnInRateUpDownIcon").html();

    var salesConversionTotal = data[0].series[0].SalesConversionTotal;
    var changes = data[0].series[0].DiffInSC;

    if (salesConversionTotal == 0) {
        $("#SalesConvThisWeek").append("-");
        $('#salesConversionTopMatricBlock').hide();
    }
    else
        $("#SalesConvThisWeek").append(salesConversionTotal.toFixed(2) + "%");

    $("#differenceSalesConvInPercentage").removeClass("rise");
    $("#differenceSalesConvInPercentage").removeClass("drop");

    if (changes == 0) {
        $("#differenceSalesConvInPercentage").append(LanguageNoChanges);
        $('#salesConversionRow').hide();
    } else if (changes > 0) {
        $("#differenceSalesConvInPercentage").addClass("rise");
        $("#differenceSalesConvInPercentage").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#differenceSalesConvInPercentage").addClass("drop");
        $("#differenceSalesConvInPercentage").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindTransactionBox(data, colorScheme) {
    $('#numberOfTransactionTopMatricBlock').show();
    $("#transactionThisWeek").empty();
    //$("#turnInRateLastWeek").empty();
    $("#differenceTransaction").empty();
    //$("#turnInRateUpDownIcon").html();

    var transactionTotal = data[0].series[0].transactionTotal;
    var changes = data[0].series[0].changesOfTransactionCountTotal;

    if (transactionTotal == 0) {
        $("#transactionThisWeek").append("-");
        $('#numberOfTransactionTopMatricBlock').hide();
    }
    else
        $("#transactionThisWeek").append(transactionTotal);

    $("#differenceTransaction").removeClass("rise");
    $("#differenceTransaction").removeClass("drop");

    if (changes == 0) {
        $("#differenceTransaction").append(LanguageNoChanges);
    } else if (changes > 0) {
        $("#differenceTransaction").addClass("rise");
        $("#differenceTransaction").append("<i class='fa fa-caret-up'></i> " + changes.toFixed(2) + "%");
    } else if (changes < 0) {
        changes *= -1;
        $("#differenceTransaction").addClass("drop");
        $("#differenceTransaction").append("<i class='fa fa-caret-down'></i> " + changes.toFixed(2) + "%");
    }
}

function bindHighchart(data, colorScheme) {
    var miniChartId = ['7daysVisitorGraph', '7daysTurnInRate', '7daysVisitDuration', '7daysReturningCustomer', '7daysOutsideTraffic', '7daysSalesConv', '7daysTransaction'];
    var miniChartData = [data[0].series[0].ValueInInt, data[0].series[0].TIR, data[0].series[0].VisitDuration, data[0].series[0].ReturningRate, data[0].series[0].OutsideTrafficInt, data[0].series[0].SalesConversion, data[0].series[0].TransactionCountInt];
    //draw graph under each box, footfallcount
    for (var i = 0; i < miniChartId.length; i++) {
        $(function () {
            Highcharts.setOptions({
                global: {
                    useUTC: false
                }
            });
            var chart = new Highcharts.Chart({

                chart: {
                    renderTo: miniChartId[i],
                    margin: [0, 0, 0, 0],
                    backgroundColor: 'transparent'
                },
                title: {
                    text: ''
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    labels: {
                        enabled: false
                    }
                },
                yAxis: {
                    maxPadding: 0,
                    minPadding: 0,
                    gridLineWidth: 0,
                    endOnTick: false,
                    labels: {
                        enabled: false
                    }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        enableMouseTracking: false,
                        lineWidth: 1,
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        marker: {
                            radius: 0,
                            states: {
                                hover: {
                                    radius: 2
                                }
                            }
                        }
                    }
                },
                exporting: {
                    enabled: false,
                },
                series: [{
                    type: 'areaspline',
                    data: miniChartData[i],
                    color: colorScheme.chart.sparkLine.color,
                    fillOpacity: 0.5
                }]
            });
        });
    }
}

//--------------Visitor Behavior Overview--------------------

function bindVisitorBehavior(data) {
    $("#vbdVisitorCount").removeClass("shown");
    $("#vbdTurnInRate").removeClass("shown");
    $("#vbdOutsideTraffic").removeClass("shown");
    $("#vbdVisitDuration").removeClass("shown");
    $("#vbdReturningCustomer").removeClass("shown");
    $("#vbdVisitorCount .svgTextChanges").removeClass("rise").removeClass("drop");
    $("#vbdTurnInRate .svgTextChanges").removeClass("rise").removeClass("drop");
    $("#vbdOutsideTraffic .svgTextChanges").removeClass("rise").removeClass("drop");
    $("#vbdVisitDuration .svgTextChanges").removeClass("rise").removeClass("drop");
    $("#vbdReturningCustomer .svgTextChanges").removeClass("rise").removeClass("drop");

    var visitorTotal = data[0].series[0].visitorTotal;
    var turnInRateTotal = data[0].series[0].TurnInRateTotal;
    var outisdeTrafficTotal = data[0].series[0].OutsideTrafficTotal;
    var visitDurationTotal = data[0].series[0].VisitDurationTotal;
    var returnCustomerRate = data[0].series[0].ReturnCustomerRate;
    var visitorTotalChanges = data[0].series[0].DifferencesInFF;
    var turnInRateChanges = data[0].series[0].DifferencesInTIR;
    var outisdeTrafficChanges = data[0].series[0].DifferencesInOT;
    var visitDurationChanges = data[0].series[0].DifferencesInVisitDuration;
    var returnCustomerRateChanges = data[0].series[0].DifferencesInReturingCustomerRate;



    if (visitorTotal != 0 && $.isNumeric(visitorTotal)) {
        $("#vbdVisitorCount .svgTextValue").html(numberWithCommas(visitorTotal));
    }
    if (turnInRateTotal != 0 && $.isNumeric(turnInRateTotal)) {
        $("#vbdTurnInRate .svgTextValue").html(turnInRateTotal.toFixed(2) + '%');
    }
    if (outisdeTrafficTotal != 0 && $.isNumeric(outisdeTrafficTotal)) {
        $("#vbdOutsideTraffic .svgTextValue").html(numberWithCommas(outisdeTrafficTotal));
    }
    if (visitDurationTotal != 0 && $.isNumeric(visitDurationTotal)) {
        $("#vbdVisitDuration .svgTextValue").html(visitDurationTotal.toFixed(2) + 'min');
    }
    if (returnCustomerRate != 0 && $.isNumeric(returnCustomerRate)) {
        $("#vbdReturningCustomer .svgTextValue").html(returnCustomerRate.toFixed(2) + '%');
    }
    if (visitorTotalChanges > 0) {

        $("#vbdVisitorCount .svgTextChanges").addClass("rise");
        $("#vbdVisitorCount .svgTextChanges").html("+" + visitorTotalChanges.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (visitorTotalChanges < 0) {
        $("#vbdVisitorCount .svgTextChanges").addClass("drop");
        $("#vbdVisitorCount .svgTextChanges").html(visitorTotalChanges.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }
    if (turnInRateChanges > 0) {

        $("#vbdTurnInRate .svgTextChanges").addClass("rise");
        $("#vbdTurnInRate .svgTextChanges").html("+" + turnInRateChanges.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (turnInRateChanges < 0) {
        $("#vbdTurnInRate .svgTextChanges").addClass("drop");
        $("#vbdTurnInRate .svgTextChanges").html(turnInRateChanges.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }
    if (outisdeTrafficChanges > 0) {

        $("#vbdOutsideTraffic .svgTextChanges").addClass("rise");
        $("#vbdOutsideTraffic .svgTextChanges").html("+" + outisdeTrafficChanges.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (outisdeTrafficChanges < 0) {
        $("#vbdOutsideTraffic .svgTextChanges").addClass("drop");
        $("#vbdOutsideTraffic .svgTextChanges").html(outisdeTrafficChanges.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }
    if (visitDurationChanges > 0) {

        $("#vbdVisitDuration .svgTextChanges").addClass("rise");
        $("#vbdVisitDuration .svgTextChanges").html("+" + visitDurationChanges.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (visitDurationChanges < 0) {
        $("#vbdVisitDuration .svgTextChanges").addClass("drop");
        $("#vbdVisitDuration .svgTextChanges").html(visitDurationChanges.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }
    if (returnCustomerRateChanges > 0) {

        $("#vbdReturningCustomer .svgTextChanges").addClass("rise");
        $("#vbdReturningCustomer .svgTextChanges").html("+" + returnCustomerRateChanges.toFixed(2) + "% <i class='fa fa-caret-up'></i>");
    }
    else if (returnCustomerRateChanges < 0) {
        $("#vbdReturningCustomer .svgTextChanges").addClass("drop");
        $("#vbdReturningCustomer .svgTextChanges").html(returnCustomerRateChanges.toFixed(2) + "% <i class='fa fa-caret-down'></i>");
    }

    $("#vbdVisitorCount").addClass("shown");
    $("#vbdTurnInRate").addClass("shown");
    $("#vbdOutsideTraffic").addClass("shown");
    $("#vbdVisitDuration").addClass("shown");
    $("#vbdReturningCustomer").addClass("shown");
}

//-------------Table and Graph----------------
function bindThisYearAndLastYearDataIntoTable(data, colorScheme) {
    bindThisYearAndLastYearDataIntoTableWhichType(data, colorScheme, 'VisitorCount');
    bindThisYearAndLastYearDataIntoTableWhichType(data, colorScheme, 'TurnInRate');
    bindThisYearAndLastYearDataIntoTableWhichType(data, colorScheme, 'VisitDuration');
    bindThisYearAndLastYearDataIntoTableWhichType(data, colorScheme, 'ReturningRate');
}

function bindThisYearAndLastYearDataIntoTableWhichType(data, colorScheme, type) {
    $(function () {
        var weekNo = $('#weekpicker').val();
        weekNo = LanguageWeek + " " + weekNumber;

        var tempThisYear = 0;
        var tempLastYear = 0;
        var tempChanges = 0;

        var lastYearTotal;
        var lastYearList;
        var thisYearTotal;
        var thisYearList;
        var totalChanges;
        var changesList;

        var tableHeadClass;
        var tableContentClass;
        var tableFootClass;

        var footerTitle;

        switch (type) {
            case 'VisitorCount':
                tableHeadClass = $("#lastTwoWeeksComparisonTableHead");
                tableContentClass = $("#lastTwoWeeksComparisonTableContent");
                tableFootClass = $("#lastTwoWeeksComparisonTableFoot");
                tableHeadClass.html("");
                tableContentClass.html("");
                tableFootClass.html("");


                lastYearTotal = data[1].series[0].LastYearVisitorTotal == 0 ? lastYearTotal = "-" : numberify(lastYearTotal = data[1].series[0].LastYearVisitorTotal);
                thisYearTotal = data[1].series[0].visitorTotal == 0 ? thisYearTotal = "-" : numberify(thisYearTotal = data[1].series[0].visitorTotal);
                totalChanges = data[1].series[0].valueInTotalChangesInTwoYears;
                lastYearList = data[1].series[0].LastYearValueInInt;
                thisYearList = data[1].series[0].ValueInInt;
                changesList = data[1].series[0].valueInChangesInTwoYears;
                footerTitle = LanguageTotal;
                break;
            case 'TurnInRate':
                tableHeadClass = $("#lastTwoWeeksTurnInRateComparisonTableHead");
                tableContentClass = $("#lastTwoWeeksTurnInRateComparisonTableContent");
                tableFootClass = $("#lastTwoWeeksTurnInRateComparisonTableFoot");
                tableHeadClass.html("");
                tableContentClass.html("");
                tableFootClass.html("");


                lastYearTotal = data[1].series[0].LastYearTurnInRateTotal == 0 ? lastYearTotal = "-" : lastYearTotal = data[1].series[0].LastYearTurnInRateTotal.toFixed(2) + " %";
                thisYearTotal = data[1].series[0].TurnInRateTotal == 0 ? thisYearTotal = "-" : thisYearTotal = data[1].series[0].TurnInRateTotal.toFixed(2) + " %";
                totalChanges = data[1].series[0].turnInRateTotalChangesInTwoYears;
                lastYearList = data[1].series[0].LastYearTIR;
                thisYearList = data[1].series[0].TIR;
                changesList = data[1].series[0].turnInRateChangesInTwoYears;
                footerTitle = LanguageAverage;
                break;
            case 'VisitDuration':
                tableHeadClass = $("#lastTwoWeeksVisitDurationComparisonTableHead");
                tableContentClass = $("#lastTwoWeeksVisitDurationComparisonTableContent");
                tableFootClass = $("#lastTwoWeeksVisitDurationComparisonTableFoot");
                tableHeadClass.html("");
                tableContentClass.html("");
                tableFootClass.html("");


                lastYearTotal = data[1].series[0].LastYearVisitDurationTotal == 0 ? lastYearTotal = "-" : lastYearTotal = data[1].series[0].LastYearVisitDurationTotal.toFixed(2) + " " + LanguageReportmin;
                thisYearTotal = data[1].series[0].VisitDurationTotal == 0 ? thisYearTotal = "-" : thisYearTotal = data[1].series[0].VisitDurationTotal.toFixed(2) + " " + LanguageReportmin;
                totalChanges = data[1].series[0].visitDurationTotalChangesInTwoYears;
                lastYearList = data[1].series[0].LastYearVisitDuration;
                thisYearList = data[1].series[0].VisitDuration;
                changesList = data[1].series[0].visitDurationChangesInTwoYears;
                footerTitle = LanguageAverage;
                break;
            case 'ReturningRate':
                tableHeadClass = $("#lastTwoWeeksReturningCustomerComparisonTableHead");
                tableContentClass = $("#lastTwoWeeksReturningCustomerComparisonTableContent");
                tableFootClass = $("#lastTwoWeeksReturningCustomerComparisonTableFoot");
                tableHeadClass.html("");
                tableContentClass.html("");
                tableFootClass.html("");


                lastYearTotal = data[1].series[0].LastYearReturnCustomerRate == 0 ? lastYearTotal = "-" : lastYearTotal = data[1].series[0].LastYearReturnCustomerRate.toFixed(2) + " %";
                thisYearTotal = data[1].series[0].ReturnCustomerRate == 0 ? thisYearTotal = "-" : thisYearTotal = data[1].series[0].ReturnCustomerRate.toFixed(2) + " %";
                totalChanges = data[1].series[0].returningRateTotalChangesInTwoYears;
                lastYearList = data[1].series[0].LastYearReturningRate;
                thisYearList = data[1].series[0].ReturningRate;
                changesList = data[1].series[0].returningRateChangesInTwoYears;
                footerTitle = LanguageAverage;
                break;
            default:
                return 0;
        }

        if (lastYearTotal == "-") {
            tableHeadClass.append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th></tr>");

            for (var i = 0; i < 7; i++) {
                tempThisYear = thisYearList[i] > 0 ? thisYearList[i] : " - ";
                switch (type) {
                    case 'TurnInRate':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + "%" : " - ";
                        break;
                    case 'VisitDuration':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + " " + LanguageReportmin : " - ";
                        break;
                    case 'ReturningRate':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + "%" : " - ";
                        break;
                    default:
                        tempThisYear = thisYearList[i] > 0 ? numberify(thisYearList[i]) : " - ";
                        break;
                }
                tableContentClass.append("<tr><td>" + data[1].series[0].ThisYearDate[i] + "</td><td>" + tempThisYear + "</td></tr>");
            }

            tableFootClass.append("<tr><td>" + LanguageAverage + "</td><td>" + thisYearTotal + "</td></tr>");
        }
        else {
            tableHeadClass.append("<tr><th>" + weekNo + "</th><th>" + LanguageThisYear + "</th><th>" + LanguageLastYear + "</th><th>" + LanguageChanges + "</th></tr>");

            for (var i = 0; i < 7; i++) {
                switch (type) {
                    case 'TurnInRate':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + "%" : " - ";
                        tempLastYear = lastYearList[i] > 0 ? lastYearList[i] + "%" : " - ";
                        break;
                    case 'VisitDuration':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + " " + LanguageReportmin : " - ";
                        tempLastYear = lastYearList[i] > 0 ? lastYearList[i] + " " + LanguageReportmin : " - ";
                        break;
                    case 'ReturningRate':
                        tempThisYear = thisYearList[i] > 0 ? thisYearList[i] + "%" : " - ";
                        tempLastYear = lastYearList[i] > 0 ? lastYearList[i] + "%" : " - ";
                        break;
                    default:
                        tempThisYear = thisYearList[i] > 0 ? numberify(thisYearList[i]) : " - ";
                        tempLastYear = lastYearList[i] > 0 ? numberify(lastYearList[i]) : " - ";
                        break;
                }

                tempChanges =
                    parseFloat(changesList[i]) > 0 ? "<i class='fa fa-caret-up rise'></i> " + changesList[i].toFixed(2) + '%' :
                        parseFloat(changesList[i]) < 0 ? "<i class='fa fa-caret-down drop'></i> " + changesList[i].toString().substring(1) + '%' :
                            parseFloat(changesList[i]) == 0 ? " - " : " - ";
                tableContentClass.append("<tr><td>" + data[1].series[0].ThisYearDate[i] + "</td><td>" + tempThisYear + "</td><td>" + tempLastYear + "</td><td>" + tempChanges + "</td></tr>");
            }

            if (totalChanges > 0)
                totalChanges = "<i class='fa fa-caret-up rise'></i> " + totalChanges.toFixed(2) + '%';
            else if (totalChanges < 0)
                totalChanges = "<i class='fa fa-caret-down drop'></i> " + totalChanges.toString().substring(1) + '%';
            else
                totalChanges = " - ";
            tableFootClass.append("<tr><td>" + footerTitle + "</td><td>" + thisYearTotal + "</td><td>" + lastYearTotal + "</td><td>" + totalChanges + "</td></tr>");
        }
    });
}

function bindMonthlyTrend(data, colorScheme) {
    bindMonthlyTrendWhichType(data, colorScheme, 'VisitorCount');
    bindMonthlyTrendWhichType(data, colorScheme, 'TurnInRate');
    bindMonthlyTrendWhichType(data, colorScheme, 'VisitDuration');
    bindMonthlyTrendWhichType(data, colorScheme, 'ReturnCustomer');
    bindMonthlyTrendWhichType(data, colorScheme, 'SalesConversion');
}

function bindMonthlyTrendWhichType(data, colorScheme, type) {
    
    $(function () {
        var noLastYearData = true;
        var lastYear = [];
        var thisYear = [];
        var renderToWhichChart = '';
        switch (type) {
            case 'VisitorCount':
                lastYear = data[1].series[0].LastYearMonthlyTrendVisitorTotal;
                thisYear = data[1].series[0].MonthlyTrendVisitorTotal;
                renderToWhichChart = 'newMonthlyTrend';
                yAxis = {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    tickPixelInterval: 15,
                    //tickInterval: dynamicTickInterval,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        },
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
					min: 0,
					allowDecimals: false,
                };
                break;
            case 'TurnInRate':
                lastYear = data[1].series[0].LastYearMonthlyTrendTIRTotal;
                thisYear = data[1].series[0].MonthlyTrendTIRTotal;
                renderToWhichChart = 'newTurnInRateMonthlyTrend';
                yAxis = {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageTurnInRatepercent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'VisitDuration':
                lastYear = data[1].series[0].LastYearMonthlyTrendVDTotal;
                thisYear = data[1].series[0].MonthlyTrendVDTotal;
                renderToWhichChart = 'newVisitDurationMonthlyTrend';
                yAxis = {
                    lineWidth: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageAverageVisitDurationmins,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'ReturnCustomer':
                lastYear = data[1].series[0].LastYearMonthlyTrendRRTotal;
                thisYear = data[1].series[0].MonthlyTrendRRTotal;
                renderToWhichChart = 'newReturningCustomerMonthlyTrend';
                yAxis = {
                    lineWidth: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageReturningCustomer,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'SalesConversion':
                lastYear = data[1].series[0].LastYearMonthlyTrendSCTotal;
                thisYear = data[1].series[0].MonthlyTrendSCTotal;
                renderToWhichChart = 'newSalesConversionMonthlyTrend';
                break;
            default:
                return 0;
        }

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            switch (type) {
                case 'VisitorCount': // does not need provide two decimal point
                    break;
                default:
                    lastYear[i] > 0 ? 0 : lastYear[i].toFixed(2);
                    break;
            }
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear[i];
                noLastYearData = false;

            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            switch (type) {
                case 'VisitorCount': // does not need provide two decimal point
                    break;
                default:
                    thisYear[i] > 0 ? 0 : thisYear[i].toFixed(2);
                    break;
            }
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: renderToWhichChart,
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: LanguageLast12Months,
                data: thisYear,
                color: colorScheme.time.year.thisYear,
                pointWidth: 17,
                borderWidth: 0
            }, {
                type: 'line',
                dashStyle: 'dash',
                name: LanguageLastYearSameMonth,
                data: lastYear,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachmonthoftheyear + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight,
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=1&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            yAxis: yAxis,
            xAxis: {
                categories: data[1].series[0].DisplayedMonth,
                tickWidth: 0,
                title: {
                    text: LanguageMonth,
                    align: 'high',
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    },
                },
                labels: {
                    rotation: -90,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                x: 96,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearData) {
                    chart.series[1].remove(true);
                }
            });
    });
}

function bindVisitorCountsWeeklyTrend2(data, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {

        var lastYear = data[1].series[0].LastYearWeeklyTrendVisitorTotal;
        var thisYear = data[1].series[0].WeeklyTrendVisitorTotal;

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear[i]
                noLastYearDataForVisitorCount = false
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newWeeklyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                name: LanguageLastYear,
                dashStyle: 'dash',
                data: lastYear,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachweekoftheyear + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                    point: {
                        events: {
                            click: function () {
                                location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=1&branchId=-1&compare=1";
                            }
                        }
                    },
                    cursor: 'pointer'
                }
            },
            xAxis: {
                categories: data[1].series[0].DisplayedWeek,
                tickWidth: 0,
                title: {
                    text: LanguageWeek,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
			yAxis: {
				allowDecimals: false,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

function bindDailyTrend(data, colorScheme) {
    bindDailyTrendWhichType(data, colorScheme, 'VisitorCount');
    bindDailyTrendWhichType(data, colorScheme, 'VisitDuration');
    bindDailyTrendWhichType(data, colorScheme, 'ReturningRate');
}

function bindDailyTrendWhichType(data, colorScheme, type) {
    noLastYearDataForVisitorCount = true;

    $(function () {
        switch (type) {
            case 'VisitorCount':
                var lastYear = data[1].series[0].LastYearDailyTrendVisitorTotal;
                var thisYear = data[1].series[0].DailyTrendVisitorTotal;
                graphClass = $("#newDailyTrend");
                renderChart = 'newDailyTrend';
                graphClass.html("");
				yAxis = [{
					opposite: false,
					lineWidth: 0,
					gridLineWidth: 1,
					tickWidth: 1,
					//tickInterval: dynamicTickInterval,
					tickPixelInterval: 15,
					tickLength: 5,
					tickPosition: 'inside',
					title: {
						text: LanguageNoofVisitor,
						style: {
							color: colorScheme.chart.axisLabel.y.title.color,
							fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
							"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
						}
					},
					labels: {
						style: {
							"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
							color: colorScheme.chart.axisLabel.y.label.color,
							fontSize: colorScheme.chart.axisLabel.y.label.fontSize
						}
					},
					min: 0,
					allowDecimals: false,
				}, {
					min: 0,
					max: 0,
					gridLineWidth: 0,
					lineWidth: 0,
					title: {
						text: null
					},
					labels: {
						enabled: false
					},
					height: '10%',
					allowDecimals: false,
				}];
                break;
            case 'VisitDuration':
                lastYear = data[1].series[0].LastYearDailyTrendVisitDuration;
                thisYear = data[1].series[0].DailyTrendVisitDuration;
                graphClass = $("#newVisitDurationDailyTrend");
                renderChart = 'newVisitDurationDailyTrend';
                graphClass.html("");
                yAxis = {
                    lineWidth: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageAverageVisitDuration,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    min: 0,
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'ReturningRate':
                lastYear = data[1].series[0].LastYearDailyTrendReturningRate;
                thisYear = data[1].series[0].DailyTrendReturningRate;
                graphClass = $("#newReturningCustomerDailyTrend");
                renderChart = 'newReturningCustomerDailyTrend';
                graphClass.html("");
                yAxis = {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageReturningRateprecent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            default:
                break;
        }

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: renderChart,
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachday + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            xAxis: {
                categories: data[1].series[0].DisplayedDay,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            yAxis: yAxis,
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 250,
                y: -15,
                verticalAlign: 'top',
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                line: {
                    marker: {
                        enabled: false
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                dashStyle: 'dash',
                name: LanguageLastYear,
                data: lastYear,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            exporting: {
                enabled: false,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

/*
function bindVisitorCountsDailyTrend2(data, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastYear = data[1].series[0].LastYearDailyTrendVisitorTotal;
        var thisYear = data[1].series[0].DailyTrendVisitorTotal;
        $("#newDailyTrend").html("");

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "newDailyTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsforeachday + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            xAxis: {
                categories: data[1].series[0].DisplayedDay,
                tickWidth: 0,
                title: {
                    text: LanguageDay,
                    align: 'high',
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },
            yAxis: [{
                opposite: false,
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            }, {
                min: 0,
                max: 0,
                gridLineWidth: 0,
                lineWidth: 0,
                title: {
                    text: null
                },
                labels: {
                    enabled: false
                },
                height: '10%'
            }],
            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 250,
                y: -15,
                verticalAlign: 'top',
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                line: {
                    marker: {
                        enabled: false
                    }
                }
            },
            series: [{
                type: 'column',
                name: LanguageThisYear,
                data: thisYear,
                color: colorScheme.time.year.thisYear,
                pointWidth: 10,
                borderWidth: 0
            }, {
                type: 'line',
                dashStyle: 'dash',
                name: LanguageLastYear,
                data: lastYear,
                color: colorScheme.time.year.lastYear,
                lineWidth: 1
            }],
            exporting: {
                enabled: false,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });

}
*/

function bindVisitorCountsHourlyTrend2(data, colorScheme) {
    noLastYearDataForVisitorCount = true;
    $(function () {
        var lastWeek = data[1].series[0].LastYearHourlyTrendVisitorTotal;  //Changed to this week last week data [Kelvin 28/3/2019]
        var thisWeek = data[1].series[0].HourlyTrendVisitorTotal;


        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastWeek.length; i++) {
            if (lastWeek[i] != null && lastWeek[i] != undefined && lastWeek[i] > largestValue) {
                largestValue = lastWeek[i]
                noLastYearDataForVisitorCount = false;
            }
        }

        for (var i = 0; i < thisWeek.length; i++) {
            if (thisWeek[i] != null && thisWeek[i] != undefined && thisWeek[i] > largestValue)
                largestValue = thisWeek[i]
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "lastWeekVisitorCountTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisWeek,
                color: colorScheme.chart.line.color.thisYear,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageLastWeek,
                dashStyle: 'dash',
                data: lastWeek,
                color: colorScheme.chart.line.color.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //useHTML: true,
                //text: LanguageHourlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsofthehoursforeachdayoftheselectedweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //},
                //y:6
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickLength: 5,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
				min: 0,
				allowDecimals: false,
            },
            xAxis: {
                categories: data[1].series[0].DisplayedHour,
                //categories: {
                //    name: ifmonday,
                //    cagetories: datas.categories
                //},

                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            }
        },
            function (chart) {
                if (noLastYearDataForVisitorCount) {
                    chart.series[1].remove(true);
                }
            });
    });
}

function bindWeekdayTrend(data, colorScheme) {
    bindWeekdayTrendWhichType(data, colorScheme, 'VisitorCount');
    bindWeekdayTrendWhichType(data, colorScheme, 'TurnInRate');
    bindWeekdayTrendWhichType(data, colorScheme, 'OutsideTraffic');
}

function bindWeekdayTrendWhichType(data, colorScheme, type) {
    $(function () {
        var thisYear = [];
        var lastYear = [];
        var renderToWhichChart = '';
        var chartClass;
        var yaxis;
        switch (type) {
            case 'VisitorCount':
                thisYear = data[1].series[0].trafficProfileVisitorInWeekday;
                renderToWhichChart = 'weekdaysTrafficProfile';
                chartClass = $("#weekdaysTrafficProfile");
				yAxis = {
					allowDecimals: false,
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'TurnInRate':
                thisYear = data[1].series[0].trafficProfileTIRWeekday;
                renderToWhichChart = 'weekdaysTurnInRate';
                chartClass = $("#weekdaysTurnInRate");
                yAxis = {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageTurnInRatepercent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
			case 'OutsideTraffic':
				thisYear = data[1].series[0].trafficProfileOTWeekday;
				lastYear = data[1].series[0].trafficProfileVisitorInWeekday; // not last year but provide visitor data
				renderToWhichChart = 'weekdaysOutsideTraffic';
				chartClass = $("#weekdaysOutsideTraffic");
				yAxis = [{
					allowDecimals: false,
					lineWidth: 0,
					gridLineWidth: 0,
					tickWidth: 0,
					//tickInterval: visitorCountDynamicTickInterval,
					tickPixelInterval: 15,
					tickPosition: 'inside',
					title: {
						text: LanguageNoofVisitor,
						style: {
							color: colorScheme.chart.axisLabel.y.title.color,
							fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
							"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
						}
					},
					labels: {
						style: {
							"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
							color: colorScheme.chart.axisLabel.y.label.color,
							fontSize: colorScheme.chart.axisLabel.y.label.fontSize
						}
					},
					min: 0,
				},
				{
					allowDecimals: false,
					opposite: true,
					tickWidth: 1,
					lineWidth: 0,
					gridLineWidth: 1,
					tickPosition: 'inside',
					//tickInterval: outsideTrafficDynamicTickInterval,
					tickPixelInterval: 15,
					labels: {
						//align: 'right',
						x: 10,
						style: {
							"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
							color: colorScheme.chart.axisLabel.y.label.color,
							fontSize: colorScheme.chart.axisLabel.y.label.fontSize
						}
					},
					title: {
						text: LanguageOutsideTraffic,
						//margin: 30,
						style: {
							color: colorScheme.chart.axisLabel.y.title.color,
							fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
							"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
						}
					},
					min: 0
				}];
				console.log(yAxis);
				break;
            default:
                return 0;
        }
        if (thisYear.length <= 0) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }
        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear != null && thisYear != undefined && thisYear > largestValue)
                largestValue = thisYear
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        if (type == 'VisitorCount' || type == 'TurnInRate') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: renderToWhichChart,
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'line',
                    name: LanguageThisWeek,
                    data: thisYear,
                    color: colorScheme.time.week.thisWeek,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                    //    text: LanguageTrafficProfile,
                    //    align: 'left',
                    //    style: {
                    //        color: colorScheme.chart.title.color.visitorCount,
                    //        "font-family": colorScheme.chart.title.fontFamily,
                    //        fontSize: colorScheme.chart.title.fontSize,
                    //        textDecoration: colorScheme.chart.title.textDecoration,
                    //        "font-weight": colorScheme.chart.title.fontWeight,
                    //    },
                },
                subtitle: {
                    //useHTML: true,
                    text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsMondaytoFriday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0,
                    x: 20,
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            radius: 2,
                            enabled: true,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: yAxis,
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekDayHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    enabled: false
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    //enabled: true,
                    //x: 108,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip,
                },
            });
        } else if (type == 'OutsideTraffic' || type == 'SalesConversion') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: renderToWhichChart,
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                    alignTicks: false
                },
                series: [{
                    type: 'areaspline',
                    name: LanguageOutsideTraffic,
                    data: thisYear,
                    color: colorScheme.chart.matrices.outsideTraffic,
                    fillOpacity: 0.15,
                    lineWidth: 1.25,
                    yAxis: 1
                }, {
                    type: 'column',
                    name: LanguageVisitor,
                    data: lastYear,
                    color: colorScheme.chart.matrices.noOfVisitor,
                    borderWidth: 0
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                    //text: LanguageTrafficProfile,
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.outsideTraffic,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight,
                    //},
                },
                subtitle: {
                    text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingMondaytoFriday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0,
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    gridLineWidth: 0,
                    tickWidth: 0,
                    //tickInterval: visitorCountDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
					min: 0,
					allowDecimals: false,
                },
                {
                    opposite: true,
                    tickWidth: 1,
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickPosition: 'inside',
                    //tickInterval: outsideTrafficDynamicTickInterval,
                    tickPixelInterval: 15,
                    labels: {
                        //align: 'right',
                        x: 10,
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageOutsideTraffic,
                        //margin: 30,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
					min: 0,
					allowDecimals: false,
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekDayHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    enabled: false,
                    //x: 36,
                    //y: -15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip
                },
            });
        }

        if (data[1].series[0].isWeekdayOff && type !== 'OutsideTraffic') {
            chartClass.append("<div class='weekend-notice'>" + LanguageCloseonWeekdays + "</div>");
        }
    });
}

function bindWeekendTrend(data, colorScheme) {
    bindWeekendTrendWhichType(data, colorScheme, 'VisitorCount');
    bindWeekendTrendWhichType(data, colorScheme, 'TurnInRate');
    bindWeekendTrendWhichType(data, colorScheme, 'OutsideTraffic');
}

function bindWeekendTrendWhichType(data, colorScheme, type) {
    $(function () {
        var thisYear = [];
        var lastYear = [];
        var renderToWhichChart = '';
        var chartClass;
        switch (type) {
			case 'VisitorCount':
                thisYear = data[1].series[0].trafficProfileVisitorInWeekend;
                renderToWhichChart = 'weekendsTrafficProfile';
                chartClass = $("#weekendsTrafficProfile");
				yAxis = {
					allowDecimals: false,
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'TurnInRate':
                thisYear = data[1].series[0].trafficProfileTIRWeekend;
                renderToWhichChart = 'weekendsTurnInRate';
                chartClass = $("#weekendsTurnInRate");
                yAxis = {
                    lineWidth: 0,
                    tickWidth: 1,
                    gridLineWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageTurnInRatepercent,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                };
                break;
            case 'OutsideTraffic':
                thisYear = data[1].series[0].trafficProfileOTWeekend;
                lastYear = data[1].series[0].trafficProfileVisitorInWeekend; // not last year but provide visitor data
                renderToWhichChart = 'weekendsOutsideTraffic';
                chartClass = $("#weekendsOutsideTraffic");
                yAxis = [{
                    lineWidth: 0,
                    tickWidth: 0,
                    gridLineWidth: 0,
                    //tickInterval: visitorCountDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
					min: 0,
					allowDecimals: false,
                },
                {
                    opposite: true,
                    tickPosition: 'inside',
                    tickWidth: 1,
                    lineWidth: 0,
                    gridLineWidth: 1,
                    //tickInterval: outsideTrafficDynamicTickInterval,
                    tickPixelInterval: 15,
                    labels: {
                        align: 'right',
                        x: 25,
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageOutsideTraffic,
                        margin: 30,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
					min: 0,
					allowDecimals: false,
                }];
                break;
            default:
                return 0;
        }

        if (thisYear.length <= 0) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data
        var largestValue = 0;

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear != null && thisYear != undefined && thisYear > largestValue)
                largestValue = thisYear
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

		if (type == 'VisitorCount') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'weekendsTrafficProfile',
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'line',
                    name: LanguageThisWeek,
                    data: thisYear,
                    color: colorScheme.time.week.thisWeek,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsSaturdayandSunday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 5,
                    x: 20
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            radius: 2,
                            enabled: true,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: yAxis,
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekendHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    enabled: false,
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    //enabled: true,
                    //x: 108,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                    useHTML: true,
                    enabled: showtooltip,
                },
            });
        } else if (type == 'TurnInRate') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'weekendsTurnInRate',
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'line',
                    name: LanguageThisWeek,
                    data: thisYear,
                    color: colorScheme.time.week.thisWeek,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragehourlyvisitorsSaturdayandSunday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 5,
                    x: 20
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            radius: 2,
                            enabled: true,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: {
                    lineWidth: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageTurnInRate,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    min: 0,
                },
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekendHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    enabled: false,
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    //enabled: true,
                    //x: 108,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    shared: true,
                    useHTML: true,
                    enabled: showtooltip,
                },
            });
        } else if (type == 'OutsideTraffic') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "weekendsOutsideTraffic",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                    alignTicks: false

                },
                series: [{
                    type: 'areaspline',
                    name: LanguageOutsideTraffic,
                    data: thisYear,
                    color: colorScheme.chart.matrices.outsideTraffic,
                    fillOpacity: 0.15,
                    lineWidth: 1.25,
                    yAxis: 1
                }, {
                    type: 'column',
                    name: LanguageVisitor,
                    data: lastYear,
                    color: colorScheme.chart.matrices.noOfVisitor,
                    borderWidth: 0
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingSaturdayandSunday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    tickWidth: 0,
                    gridLineWidth: 0,
                    //tickInterval: visitorCountDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
					min: 0,
					allowDecimals: false,
                },
                {
                    opposite: true,
                    tickPosition: 'inside',
                    tickWidth: 1,
                    lineWidth: 0,
                    gridLineWidth: 1,
                    //tickInterval: outsideTrafficDynamicTickInterval,
                    tickPixelInterval: 15,
                    labels: {
                        align: 'right',
                        x: 25,
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageOutsideTraffic,
                        margin: 30,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
					min: 0,
					allowDecimals: false,
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekendHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    enabled: false,
                    //x: 36,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip,
                },
            });
        } else if (type == 'SalesConversion') {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'weekendsSalesConversion',
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: lastYear,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: thisYear,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0,
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickInterval: dynamicTickInterval,
                    tickWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    tickInterval: dynamicTickInterval,
                    tickPosition: 'inside',
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    }
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekendHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    enabled: false,
                    //x: 12,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip,
                },
            })
        }

        if (data[1].series[0].isWeekendOff && type !== 'OutsideTraffic') {
            chartClass.append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
        }
    });
}

function bindOutsideTrafficHourlyTrend2(data, colorScheme) {
	$(function () {

		var lastYear = data[1].series[0].HourlyTrendVisitorTotal; // visitor count
		var thisYear = data[1].series[0].HourlyOutsideTrafficTotal; // outside traffic
		var daily = [];

		//identify largest value of yaxis data
		var outsideTrafficLargestValue = 0;
		for (var i = 0; i < thisYear.length; i++) {
			if (thisYear[i] != null && thisYear != undefined && thisYear > outsideTrafficLargestValue)
				outsideTrafficLargestValue = thisYear
		}

		for (var i = 0; i < thisYear.length; i = i + 24) {
			var temp = 0;
			for (var ii = 0; ii < 24; ii++) {
				if (thisYear[i + ii] != undefined) {
					temp = temp + thisYear[i + ii];
				}
			}
			daily.push(temp);
		}

		var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
			: outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
				: outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
					: outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
						: outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
							: outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
								: 1000000;

		var visitorLargestValue = 0;

		for (var i = 0; i < lastYear.length; i++) {
			if (lastYear != null && lastYear != undefined && lastYear > visitorLargestValue)
				visitorLargestValue = lastYear
		}
		var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
			: visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
				: visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
					: visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
						: visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
							: visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
								: 1000000;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newOutsideTraffic",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				},
				alignTicks: false
			},
			series: [{
				type: 'areaspline',
				name: LanguageOutsideTraffic,
				data: thisYear,
				color: colorScheme.chart.matrices.outsideTraffic,
				fillOpacity: 0.15,
				lineWidth: 1.25,
				yAxis: 1
			}, {
				type: 'column',
				name: LanguageVisitor,
				data: lastYear,
				color: colorScheme.chart.matrices.noOfVisitor,
				borderWidth: 0
			}],
			credits: {
				enabled: false
			},
			title: {
				text: ''
				//useHTML: true,
				//text: LanguageLastWeek + " " + "<i class='fa fa-question-circle' title='" + LanguageNumberofpeoplepassingbyhourlyofeachdayforthepreviousweek + "'></i>",
				//align: 'left',
				//style: {
				//    color: colorScheme.chart.title.color.outsideTraffic,
				//    "font-family": colorScheme.chart.title.fontFamily,
				//    fontSize: colorScheme.chart.title.fontSize,
				//    textDecoration: colorScheme.chart.title.textDecoration,
				//    "font-weight": colorScheme.chart.title.fontWeight
				//},
				//y:6
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				},
				series: {
					marker: {
						enabled: false
					}
				}
			},
			yAxis: [{
				allowDecimals: false,
				lineWidth: 0,
				tickWidth: 0,
				gridLineWidth: 0,
				//tickInterval: visitorCountDynamicTickInterval,
				tickPixelInterval: 15,
				tickPosition: 'inside',
				title: {
					text: LanguageNoofVisitor,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				labels: {
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				min: 0,
			},
			{
				allowDecimals: false,
				opposite: true,
				//tickInterval: outsideTrafficDynamicTickInterval,
				tickPixelInterval: 15,
				gridLineWidth: 1,
				lineWidth: 0,
				tickWidth: 1,
				tickPosition: 'inside',
				labels: {
					align: 'right',
					x: 25,
					style: {
						"font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
						color: colorScheme.chart.axisLabel.y.label.color,
						fontSize: colorScheme.chart.axisLabel.y.label.fontSize
					}
				},
				title: {
					text: LanguageOutsideTraffic,
					margin: 30,
					style: {
						color: colorScheme.chart.axisLabel.y.title.color,
						fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.y.title.fontFamily
					}
				},
				min: 0
			}],
			xAxis: {
				categories: data[1].series[0].DisplayedHour,
				tickWidth: 0,
				tickInterval: 4,
				title: {
					text: LanguageHour,
					align: 'high',
					y: -20,
					style: {
						color: colorScheme.chart.axisLabel.x.title.color,
						fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
						"font-family": colorScheme.chart.axisLabel.x.title.fontFamily
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						color: colorScheme.chart.axisLabel.x.label.color,
						"font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
						fontSize: colorScheme.chart.axisLabel.x.label.fontSize
					}
				}
			},

			legend: {
				itemStyle: {
					color: colorScheme.chart.legend.text.color,
					"font-family": colorScheme.chart.legend.text.fontFamily,
					fontSize: colorScheme.chart.legend.text.fontSize,
					"font-weight": colorScheme.chart.legend.text.fontWeight
				},
				enabled: true,
				x: 228,
				y: -15,
				verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
			},
			tooltip: {
				useHTML: true,
				shared: true,
			},
		});
	});
}

function bindNewAndReturningCustomer(data, colorScheme) {
    $(function () {
        //donut chart
        var newCustomer = data[1].series[0].NewCustomerRate;
        var returningCustomer = data[1].series[0].ReturnCustomerRate;
        var centerText = data[1].series[0].ReturnCustomerRate;

        var donutChartColors = $.map(colorScheme.chart.donut, function (value, index) {
            return [value];
        });

        $(function () {
            chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'thisWeekAverageReturningCustomerDonutChart',
                    type: 'pie'
                },
                colors: donutChartColors,
                title: {
                    text: ''
                },
                yAxis: {
                    title: {
                        text: ''
                    }
                },
                plotOptions: {
                    series: {
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    location.href = "Analytics?type=w" + $("#datePickerDateRange").val().substr(5, 2) + "&range=day&parameter=22&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                                }
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function () {
                        return '<b>' + this.point.name + '</b>: ' + this.y + ' %';
                    }
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        fontFamily: colorScheme.chart.legend.text.fontFamily,
                        //fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    margin: 0
                },
                series: [{
                    name: LanguageThisWeekAverage,
                    data: [
                        [LanguageNewCustomer, newCustomer],
                        [LanguageReturningCustomer, returningCustomer]
                    ],
                    size: '100%',
                    innerSize: '60%',
                    showInLegend: true,
                    dataLabels: {
                        enabled: true,
                        distance: -30,
                        style: {
                            fontFamily: colorScheme.chart.dataLabel.fontFamily,
                            color: colorScheme.chart.dataLabel.color,
                            fontSize: colorScheme.chart.dataLabel.fontSize,
                            fontWeight: colorScheme.chart.dataLabel.fontWeight
                        },
                        formatter: function () {
                            return "<b>" + this.y + '%</b>';
                        }
                    }
                }]
            },

                function (chart) { // on complete
                    var textX = chart.plotLeft + (chart.plotWidth * 0.5);
                    var textY = chart.plotTop + (chart.plotHeight * 0.5);

                    var span = '<span id="RRpieChartInfoText" style="position:absolute; text-align:center;">';
                    span += '<span class="pieChartInfoTextTitle">' + centerText + '%</span><br>';
                    span += '<span class="pieChartInfoTextSubtitle">';
                    span += '<span>' + LanguageThisWeek + '</span><br />';
                    span += '<span>' + LanguageAverage + '</span>';
                    span += '</span></span>';

                    $("#ReturningCustomerDonutChartCenterText").empty();
                    $("#ReturningCustomerDonutChartCenterText").append(span);
                    span = $('#RRpieChartInfoText');
                    span.css('left', textX + (span.width() * -0.43));
                    span.css('top', textY + (span.height() * -0.5));

                    $(".pieChartInfoTextTitle").css('font-family', colorScheme.chart.pieCenterText.title.fontFamily);
                    $(".pieChartInfoTextTitle").css('color', colorScheme.chart.pieCenterText.title.color);
                    $(".pieChartInfoTextTitle").css('font-size', colorScheme.chart.pieCenterText.title.fontSize);
                    $(".pieChartInfoTextTitle").css("font-weight", colorScheme.chart.pieCenterText.title.fontWeight);

                    $(".pieChartInfoTextSubtitle").css('font-family', colorScheme.chart.pieCenterText.subtitle.fontFamily);
                    $(".pieChartInfoTextSubtitle").css('color', colorScheme.chart.pieCenterText.subtitle.color);
                    $(".pieChartInfoTextSubtitle").css('font-size', colorScheme.chart.pieCenterText.subtitle.fontSize);
                    $(".pieChartInfoTextSubtitle").css('font-weight', colorScheme.chart.pieCenterText.subtitle.fontWeight);
                });
        });
    })
}

function bindSalesConversion(data, colorScheme) {
    $(function () {
        //monthly trend
        var sc = data[1].series[0].MonthlyTrendSCTotal;
        for (i = 0; i < sc.length; i++) {
            if (sc[i] != 0) {
                $('#salesConversionSection').show();
                $('#noData').hide();
            }
        }
        var visitorCount = data[1].series[0].MonthlyTrendVisitorTotal;
        var transactionCount = data[1].series[0].MonthlyTrendTransTotal;

        //identify largest value of yaxis data
        var footfallLargestValue = 0;
        for (var i = 0; i < visitorCount.length; i++) {
            if (visitorCount[i] != null && visitorCount[i] != undefined && visitorCount[i] > footfallLargestValue)
                footfallLargestValue = visitorCount[i];
        }
        var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
            : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
                : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                    : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                        : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                            : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                                : 1000000;

        var transactionLargestValue = 0;
        for (var i = 0; i < transactionCount.length; i++) {
            if (transactionCount[i] != null && transactionCount[i] != undefined && transactionCount[i] > transactionLargestValue)
                transactionLargestValue = transactionCount[i];
        }
        var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
            : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
                : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                    : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                        : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                            : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                                : 1000000;
        if (transactionDynamicTickInterval == 1) {
            transactionDynamicTickInterval = footfallDynamicTickInterval;
        }
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "newSalesConversionMonthlyTrend",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                    alignTicks: false
                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: visitorCount,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 17,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: transactionCount,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                    //text: LanguageMonthlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageMonthlypercentofspendingvisitors + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function () {
                                    location.href = "Analytics?type=" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickWidth: 1,
                    min: 0,
                    gridLineWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    lineWidth: 0,
                    tickWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    min: 0,
                    gridLineWidth: 0,
                    tickPosition: 'inside',
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                    }
                }],
                xAxis: {
                    categories: data.categories,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 6,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 18,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            });
        });
    });

    $(function () {
        //weekly trend
        var tempWeek = [];
        for (var i = 1; i <= data[1].series[0].DisplayedWeek.length; i++) {
            tempWeek.push(i);
        }

        var visitorCount = data[1].series[0].WeeklyTrendVisitorTotal;
        var transactionCount = data[1].series[0].WeeklyTrendTransTotal;
        //identify largest value of yaxis data
        var footfallLargestValue = 0;
        for (var i = 0; i < visitorCount.length; i++) {
            if (visitorCount[i] != null && visitorCount[i] != undefined && visitorCount[i] > footfallLargestValue)
                footfallLargestValue = visitorCount[i];
        }
        var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
            : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
                : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                    : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                        : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                            : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                                : 1000000;

        var transactionLargestValue = 0;
        for (var i = 0; i < transactionCount.length; i++) {
            if (transactionCount[i] != null && transactionCount[i] != undefined && transactionCount[i] > transactionLargestValue)
                transactionLargestValue = transactionCount[i];
        }
        var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
            : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
                : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                    : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                        : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                            : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                                : 1000000;
        if (transactionDynamicTickInterval == 1) {
            transactionDynamicTickInterval = footfallDynamicTickInterval;
        }

        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "newSalesConversionWeeklyTrend",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                    alignTicks: false

                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: visitorCount,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: transactionCount,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                    //text: LanguageWeeklyTrend + " " + "<i class='fa fa-question-circle' title='" + Languagespendingvisitorsforeachweek + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function () {
                                    location.href = "Analytics?type=w" + this.category.name + "&range=day&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    gridLineWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    tickWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeek,
                    tickWidth: 0,
                    title: {
                        text: LanguageWeek,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 206,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            });
        });




    });

    $(function () {
        //daily trend
        var visitorCount = data[1].series[0].DailyTrendVisitorTotal;
        var transactionCount = data[1].series[0].DailyTrendTransTotal;
        //identify largest value of yaxis data
        var footfallLargestValue = 0;
        for (var i = 0; i < visitorCount.length; i++) {
            if (visitorCount[i] != null && visitorCount[i] != undefined && visitorCount[i] > footfallLargestValue)
                footfallLargestValue = visitorCount[i];
        }
        var footfallDynamicTickInterval = footfallLargestValue >= 0 && footfallLargestValue < 10 ? 1
            : footfallLargestValue >= 10 && footfallLargestValue < 100 ? 10
                : footfallLargestValue >= 100 && footfallLargestValue < 1000 ? 100
                    : footfallLargestValue >= 1000 && footfallLargestValue < 10000 ? 1000
                        : footfallLargestValue >= 10000 && footfallLargestValue < 100000 ? 10000
                            : footfallLargestValue >= 100000 && footfallLargestValue < 1000000 ? 100000
                                : 1000000;

        var transactionLargestValue = 0;
        for (var i = 0; i < transactionCount.length; i++) {
            if (transactionCount[i] != null && transactionCount[i] != undefined && transactionCount[i] > transactionLargestValue)
                transactionLargestValue = transactionCount[i];
        }
        var transactionDynamicTickInterval = transactionLargestValue >= 0 && transactionLargestValue < 10 ? 1
            : transactionLargestValue >= 10 && transactionLargestValue < 100 ? 10
                : transactionLargestValue >= 100 && transactionLargestValue < 1000 ? 100
                    : transactionLargestValue >= 1000 && transactionLargestValue < 10000 ? 1000
                        : transactionLargestValue >= 10000 && transactionLargestValue < 100000 ? 10000
                            : transactionLargestValue >= 100000 && transactionLargestValue < 1000000 ? 100000
                                : 1000000;
        if (transactionDynamicTickInterval == 1) {
            transactionDynamicTickInterval = footfallDynamicTickInterval;
        }
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "newSalesConversionDailyTrend",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                    alignTicks: false

                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: visitorCount,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: transactionCount,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                    //text: LanguageDailyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageDailypercentofspendingvisitors + "'></i>",
                    //align: 'left',
                    //style: {
                    //    color: colorScheme.chart.title.color.salesConversion,
                    //    "font-family": colorScheme.chart.title.fontFamily,
                    //    fontSize: colorScheme.chart.title.fontSize,
                    //    textDecoration: colorScheme.chart.title.textDecoration,
                    //    "font-weight": colorScheme.chart.title.fontWeight
                    //}
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false
                        },
                        point: {
                            events: {
                                click: function () {
                                    location.href = "Analytics?type=d" + this.category.name + "&range=hour&parameter=19&branchId=" + $("#selectBoxBranch").val() + "&compare=1";
                                }
                            }
                        },
                        cursor: 'pointer'
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    tickWidth: 0,
                    //tickInterval: footfallDynamicTickInterval,
                    tickPixelInterval: 15,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    tickPixelInterval: 40,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageSalesVolume,
                        margin: 25,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            color: colorScheme.chart.axisLabel.y.label.color,
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedDay,
                    tickWidth: 0,
                    tickInterval: 1,
                    title: {
                        text: LanguageDay,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },
                legend: {
                    itemStyle: {
                        color: colorScheme.chart.legend.text.color,
                        "font-family": colorScheme.chart.legend.text.fontFamily,
                        fontSize: colorScheme.chart.legend.text.fontSize,
                        "font-weight": colorScheme.chart.legend.text.fontWeight
                    },
                    enabled: true,
                    x: 206,
                    y: -15,
                    verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                },
            });
        });

    });

    $(function () {
        //weekday traffic profile
        var weekdaysnoofvisitor = data[1].series[0].trafficProfileVisitorInWeekday;
        var weekdayssalesvolume = data[1].series[0].trafficProfileTransWeekday;
        var largestValue = 0;

        if (weekdayssalesvolume.length <= 0) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < weekdaysnoofvisitor.length; i++) {
            if (weekdaysnoofvisitor[i] != null && weekdaysnoofvisitor[i] != undefined && weekdaysnoofvisitor[i] > largestValue)
                largestValue = weekdaysnoofvisitor[i];
        }
        for (var i = 0; i < weekdayssalesvolume.length; i++) {
            if (weekdayssalesvolume[i] != null && weekdayssalesvolume[i] != undefined && weekdayssalesvolume[i] > largestValue)
                largestValue = weekdayssalesvolume[i];
        }
        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        //weekdays trend
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "weekdaysSalesConversion",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: weekdaysnoofvisitor,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: weekdayssalesvolume,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsfromMondaytoFriday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0,
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    tickWidth: 1,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    gridLineWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 0,
                    tickWidth: 0,
                    //tickInterval: dynamicTickInterval,
                    tickPixelInterval: 15,
                    tickPosition: 'inside',
                    labels: {
                        style: {

                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekDayHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            fontSize: '12px',
                            "font-family": "Arial"
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            fontSize: '10px',
                            "font-family": "Arial"
                        }
                    }
                },

                legend: {
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    enabled: false,
                    //x: 12,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip,
                },
            });


            if (data[1].series[0].isWeekdayOff) {
                $("#weekdaysSalesConversion").append("<div class='weekend-notice'>" + LanguageCloseonWeekdays + "</div>");
            }
        });
    });

    $(function () {
        //trafic profile weekend
        var weekendsnoofvisitor = data[1].series[0].trafficProfileVisitorInWeekend;
        var weekendssalesvolume = data[1].series[0].trafficProfileTransWeekend;
        //identify largest value of yaxis data

        if (weekendssalesvolume.length <= 0) {
            var showmarker = false;
            var showtooltip = false;
        }
        else {
            var showmarker = true;
            var showtooltip = true;
        }
        var largestValue = 0;
        for (var i = 0; i < weekendsnoofvisitor.length; i++) {
            if (weekendsnoofvisitor[i] != null && weekendsnoofvisitor[i] != undefined && weekendsnoofvisitor[i] > largestValue)
                largestValue = weekendsnoofvisitor[i];
        }
        for (var i = 0; i < weekendssalesvolume.length; i++) {
            if (weekendssalesvolume[i] != null && weekendssalesvolume[i] != undefined && weekendssalesvolume[i] > largestValue)
                largestValue = weekendssalesvolume[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
            : largestValue >= 10 && largestValue < 100 ? 10
                : largestValue >= 100 && largestValue < 1000 ? 100
                    : largestValue >= 1000 && largestValue < 10000 ? 1000
                        : largestValue >= 10000 && largestValue < 100000 ? 10000
                            : largestValue >= 100000 && largestValue < 1000000 ? 100000
                                : 1000000;

        //weekends trend
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: "weekendsSalesConversion",
                    events: {
                        load: function () {
                            chartEvent[3] = this;
                        }
                    },
                },
                series: [{
                    type: 'column',
                    name: LanguageNoofVisitor,
                    data: weekendsnoofvisitor,
                    color: colorScheme.time.year.thisYear,
                    pointWidth: 10,
                    borderWidth: 0
                }, {
                    type: 'line',
                    name: LanguageSalesVolume,
                    dashStyle: 'dash',
                    data: weekendssalesvolume,
                    color: colorScheme.time.year.lastYear,
                    lineWidth: 1
                }],
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                subtitle: {
                    text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageHourlyaveragepercentofspendingvisitorsforSaturdayandSunday + "'></i>",
                    align: 'center',
                    style: {
                        color: colorScheme.chart.subtitle.color,
                        fontSize: colorScheme.chart.subtitle.fontSize,
                        "font-family": colorScheme.chart.subtitle.fontFamily
                    },
                    margin: 0,
                },
                plotOptions: {
                    column: {
                        stacking: 'normal'
                    },
                    series: {
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: showmarker,
                                }
                            }
                        }
                    }
                },
                yAxis: [{
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickInterval: dynamicTickInterval,
                    tickWidth: 1,
                    tickPosition: 'inside',
                    title: {
                        text: LanguageNoofVisitor,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    },
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    }
                },
                {
                    opposite: true,
                    linkedTo: 0,
                    lineWidth: 0,
                    min: 0,
                    gridLineWidth: 1,
                    tickWidth: 1,
                    tickInterval: dynamicTickInterval,
                    tickPosition: 'inside',
                    labels: {
                        style: {
                            "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                            color: colorScheme.chart.axisLabel.y.label.color,
                            fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                        }
                    },
                    title: {
                        text: LanguageSalesVolume,
                        style: {
                            color: colorScheme.chart.axisLabel.y.title.color,
                            fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                        }
                    }
                }],
                xAxis: {
                    categories: data[1].series[0].DisplayedWeekendHours,
                    tickWidth: 0,
                    title: {
                        text: LanguageHour,
                        align: 'high',
                        y: -20,
                        style: {
                            color: colorScheme.chart.axisLabel.x.title.color,
                            fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                            "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                        }
                    },
                    labels: {
                        rotation: -90,
                        x: 3,
                        style: {
                            color: colorScheme.chart.axisLabel.x.label.color,
                            "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                            fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                        }
                    }
                },

                legend: {
                    //itemStyle: {
                    //    color: colorScheme.chart.legend.text.color,
                    //    "font-family": colorScheme.chart.legend.text.fontFamily,
                    //    fontSize: colorScheme.chart.legend.text.fontSize,
                    //    "font-weight": colorScheme.chart.legend.text.fontWeight
                    //},
                    enabled: false,
                    //x: 12,
                    //y: 15,
                    //verticalAlign: 'top',
                },
                exporting: {
                    enabled: false,
                },
                tooltip: {
                    useHTML: true,
                    shared: true,
                    enabled: showtooltip,
                },
            });
            if (data[1].series[0].isWeekendOff) {
                $("#weekendsSalesConversion").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
            }
        });

    });

    $(function () {
        //table content
        var weekNo = $('#weekpicker').val();
        weekNo = LanguageWeek + " " + weekNumber;

        $("#tableSalesConversionHead").html("");
        $("#tableSalesConversionContent").html("");
        $("#tableSalesConversionFoot").html("");
        $("#tableSalesConversionHead").append("<tr><th>" + weekNo + "</th><th>" + LanguageNoofVisitor + "</th><th>" + LanguageSalesVolume + "</th><th>" + LanguageConversion + "</th></tr>");

        for (var i = 0; i < 7; i++) {
            var saleConversion = data[1].series[0].SalesConversion[i] > 0 ? data[1].series[0].SalesConversion[i] + "%" : "-";
            var valueIn = data[1].series[0].ValueInInt[i] > 0 ? data[1].series[0].ValueInInt[i] : "-";
            var salesVolume = data[1].series[0].TransactionCountInt[i] > 0 ? data[1].series[0].TransactionCountInt[i] : "-";

            $("#tableSalesConversionContent").append("<tr><td>" + weekDay[i] + "</td><td>" + valueIn + "</td><td>" + salesVolume + "</td><td>" + saleConversion + "</td></tr>");

        }

        conversion = data[1].series[0].SalesConversionTotal > 0 ? data[1].series[0].SalesConversionTotal + "%" : "-";
        totalvisitors = data[1].series[0].visitorTotal > 0 ? data[1].series[0].visitorTotal : "-";
        totalsales = data[1].series[0].transactionTotal > 0 ? data[1].series[0].transactionTotal : "-";

        $("#tableSalesConversionFoot").append("<tr><td>" + LanguageTotal + "</td><td>" + totalvisitors + "</td><td>" + totalsales + "</td><td>" + conversion + "</td></tr>");

        $("#SalesConvThisWeek").html(conversion);

        $("#transactionThisWeek").html(totalsales);


    })
}

//NEW VISITOR COUNT HOURLY TREND GRAPH [KELVIN, 28/3/19]
function bindVisitorCountsHourlyTrend(data, colorScheme) {
    $(function () {
        //console.log(datas)
        var lastYear = data[1].series[0].LastYearHourlyTrendVisitorTotal;  //Changed to this week last week data [Kelvin 28/3/2019]
        var thisYear = data[1].series[0].HourlyTrendVisitorTotal;

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < lastYear.length; i++) {
            if (lastYear[i] != null && lastYear[i] != undefined && lastYear[i] > largestValue) {
                largestValue = lastYear
            }
        }

        for (var i = 0; i < thisYear.length; i++) {
            if (thisYear[i] != null && thisYear[i] != undefined && thisYear[i] > largestValue)
                largestValue = thisYear
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1 :
            largestValue >= 10 && largestValue < 100 ? 10 :
                largestValue >= 100 && largestValue < 1000 ? 100 :
                    largestValue >= 1000 && largestValue < 10000 ? 1000 :
                        largestValue >= 10000 && largestValue < 100000 ? 10000 :
                            largestValue >= 100000 && largestValue < 1000000 ? 100000 :
                                1000000;
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "lastWeekVisitorCountTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'line',
                name: LanguageThisWeek,
                data: thisYear,
                color: colorScheme.chart.line.color.thisYear,
                lineWidth: 1
            }, {
                type: 'line',
                name: LanguageLastWeek,
                dashStyle: 'dash',
                data: lastYear,
                color: colorScheme.chart.line.color.lastYear,
                lineWidth: 1
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageHourlyTrend + " " + "<i class='fa fa-question-circle' title='" + LanguageTotalvisitorsofthehoursforeachdayoftheselectedweek + "'></i>",
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.visitorCount,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                }
            },
            yAxis: {
                allowDecimals: false,
                lineWidth: 0,
                min: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                }
            },
            xAxis: {
                categories: [{
                    name: ifmonday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }, {
                    name: iftuesday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }, {
                    name: ifwednesday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifthursday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: iffriday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifsaturday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                },
                {
                    name: ifsunday,
                    categories: ["0.00", "1.00", "2.00", "3.00", "4.00", "5.00", "6.00", "7.00", "8.00", "9.00", "10.00", "11.00", "12.00", "13.00", "14.00", "15.00", "16.00", "17.00", "18.00", "19.00", "20.00", "21.00", "22.00", "23.00"]
                }
                ],
                tickWidth: 0,
                tickInterval: 4,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 260,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}