﻿//function callVisitorTrafficChart(datas, startDateLine, endDateLine) {
function callVisitorTrafficChart(data) {
    var VisitorCountLastYear = data.series[1].data;
    var VisitorCountThisYear = data.series[2].data;

    $(function () {
        var date = data.series[0].data;

        Highcharts.setOptions({
            global: {
                useUTC: true
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "visitorCountTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },

            series: [{
                type: 'column',
                name: 'This Year',
                data: [{ y: VisitorCountThisYear[0], color: "#85C1E9" },
                    { y: VisitorCountThisYear[1], color: "#85C1E9" },
                    { y: VisitorCountThisYear[2], color: "#85C1E9" },
                    { y: VisitorCountThisYear[3], color: "#85C1E9" },
                    { y: VisitorCountThisYear[4], color: "#85C1E9" },
                    { y: VisitorCountThisYear[5], color: "#85C1E9" },
                    { y: VisitorCountThisYear[6], color: "#85C1E9" },
                    { y: VisitorCountThisYear[7], color: "#FFF176" },
                    { y: VisitorCountThisYear[8], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[9], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[10], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[11], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[12], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[13], color: "#D6EAF8" },
                    { y: VisitorCountThisYear[14], color: "#D6EAF8" },
                ],
                //color: '#f49423',
                //pointWidth: 13
            }, {
                type: 'line',
                name: 'Last Year',
                data: VisitorCountLastYear,
                color: '#f49423'
            }],
            credits: {
                enabled: false
            },
            title: {
                text: 'Visitor Count',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                },
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPosition: 'inside',
                title: {
                    margin: 20,
                    text: 'No. of Visitor',
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#474b4b'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: date,
                lineWidth: 1,
                tickWidth: 0,
                title: {
                    text: null
                },
                plotLines: [{
                    value: 6.5,
                    color: '#000',
                    dashStyle: 'dot',
                    width: 1,
                    //label: {
                    //    text: 'Last quarter minimum'
                    //}
                }, {
                    value: 7.5,
                    color: '#000',
                    dashStyle: 'dot',
                    width: 1,
                    //label: {
                    //    text: 'Last quarter maximum'
                    //}
                }],
                plotBands: [{
                    zIndex: 5,
                    color: 'transparent',
                    from: 0,
                    to: 6.5,
                    label: {
                        text: "Last 7 days",
                        textAlign: 'center',
                    }
                }, {
                    zIndex: 5,
                    color: 'transparent',
                    from: 6.5,
                    to: 7.5,
                    label: {
                        text: "Today",
                        textAlign: 'center'
                    }
                }, {
                    zIndex: 5,
                    color: 'transparent',
                    from: 7.5,
                    to: 14,
                    zIndex: 5,
                    label: {
                        text: "Next 7 days",
                        textAlign: 'center',
                    }
                }],
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                borderColor: '#474b4b',
                x: 264,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    });
}

function bindVisitorCountTable(data) {
    $('#visitorCountTable').html('');
    var date = data.series[0].data;
    // bind pre-row
    var preRow = "<tr><td style=\"width: 61.6px;\">&nbsp;</td><td colspan='7'>Last 7 days</td><td class='todayData'>Today</td><<td colspan='7'>Next 7 days</td></tr>";
    //bind first row
    var firstRow = "<tr><td>Date</td>";
    for (var i = 0; i < date.length; i++) {
        if (i == 7)
            firstRow = firstRow + "<td class='todayData'>" + date[i] + '</td>';
        else
            firstRow = firstRow + "<td>" + date[i] + '</td>';

    }
    firstRow = firstRow + '</tr>';

    var lastYearSeries = data.series[1].data;
    var LastYearLast7Days = lastYearSeries.slice(0, 7);
    var lastYearToday = lastYearSeries[7];
    var LastYearNext7Days = lastYearSeries.slice(8, 15);
    //bind second row
    var secondRow = "<tr><td>Last Year</td>";
    for (var i = 0; i < LastYearLast7Days.length; i++) {
        secondRow = secondRow + "<td>" + LastYearLast7Days[i] + '</td>';
    }
    secondRow = secondRow + "<td class='todayData'>" + lastYearToday + '</td>';
    for (var i = 0; i < LastYearNext7Days.length; i++) {
        secondRow = secondRow + "<td>" + LastYearNext7Days[i] + '</td>';
    }
    secondRow = secondRow + '</tr>';

    var thisYearSeries = data.series[2].data;
    var ThisYear = thisYearSeries.slice(0, 7);
    var ThisYearToday = thisYearSeries[7];
    var ThisYear2 = thisYearSeries.slice(8, 15);
    //bind third row
    var thirdRow = "<tr><td>This Year</td>";
    for (var i = 0; i < ThisYear.length; i++) {
        thirdRow = thirdRow + "<td>" + ThisYear[i] + '</td>';
    }
    thirdRow = thirdRow + "<td class='todayData'>" + ThisYearToday + '</td>';
    for (var i = 0; i < ThisYear2.length; i++) {
        thirdRow = thirdRow + "<td class='tablePredictiveData'>" + ThisYear2[i] + '</td>';
    }
    thirdRow = thirdRow + '</tr>';

    var changesSeries = data.series[3].data;
    for (var i = 0; i < changesSeries.length; i++) {
        changesSeries[i] = changesSeries[i].toString().substring(0, changesSeries[i].toString().indexOf('.'));
    }

    var changesLast7Days = changesSeries.slice(0, 7);
    var changesToday = changesSeries[7];
    var changesNext7Days = changesSeries.slice(8, 15);
    var forthRow = "<tr><td>Changes (%)</td>";
    //bind forth row
    for (var i = 0; i < changesLast7Days.length; i++) {
        if (changesLast7Days[i] < 0)
            forthRow = forthRow + "<td><i class=\"red fa fa-caret-down\"></i> " + changesLast7Days[i].toString().substring(1) + '</td>';
        else if (changesLast7Days[i] > 0)
            forthRow = forthRow + "<td><i class=\"green fa fa-caret-up\"></i> " + changesLast7Days[i] + '</td>';
        else
            forthRow = forthRow + "<td> - </td>";
    }
    if (changesToday < 0)
        forthRow = forthRow + "<td class='todayData'><i class=\"red fa fa-caret-down\"></i> " + changesToday.toString().substring(1) + '</td>';
    else if (changesToday > 0)
        forthRow = forthRow + "<td class='todayData'><i class=\"green fa fa-caret-up\"></i> " + changesToday + '</td>';
    else
        forthRow = forthRow + "<td class='todayData'> - </td>";
    for (var i = 0; i < changesNext7Days.length; i++) {
        if (changesNext7Days[i] < 0)
            forthRow = forthRow + "<td class='tablePredictiveData'><i class=\"red fa fa-caret-down\"></i> " + changesNext7Days[i].toString().substring(1) + '</td>';
        else if (changesNext7Days[i] > 0)
            forthRow = forthRow + "<td class='tablePredictiveData'><i class=\"green fa fa-caret-up\"></i> " + changesNext7Days[i] + '</td>';
        else
            forthRow = forthRow + "<td class='tablePredictiveData'> - </td>";
    }
    // bind everything to the table
    $('#visitorCountTable').append(preRow + firstRow + secondRow + thirdRow + forthRow);

}









//function callVisitorTrafficChart(datas, startDateLine, endDateLine) {
function callSalesVolumeChart(data) {
    var SalesVolumeLastYear = data.series[1].data;
    var SalesVolumeThisYear = data.series[2].data;

    $(function () {
        var date = data.series[0].data;

        Highcharts.setOptions({
            global: {
                useUTC: true
            }
        });
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "salesVolumeTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                }
            },

            series: [{
                type: 'column',
                name: 'This Year',
                data: [{ y: SalesVolumeThisYear[0], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[1], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[2], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[3], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[4], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[5], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[6], color: "#85C1E9" },
                    { y: SalesVolumeThisYear[7], color: "#FFF176" },
                    { y: SalesVolumeThisYear[8], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[9], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[10], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[11], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[12], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[13], color: "#D6EAF8" },
                    { y: SalesVolumeThisYear[14], color: "#D6EAF8" },
                ],
                //color: '#f49423',
                //pointWidth: 13
            }, {
                type: 'line',
                name: 'Last Year',
                data: SalesVolumeLastYear,
                color: '#f49423'
            }],
            credits: {
                enabled: false
            },
            title: {
                text: 'Sales Volume',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    }
                },
            },
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                //tickInterval: dynamicTickInterval,
                tickPosition: 'inside',
                title: {
                    margin: 20,
                    text: 'No. of Sales',
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#474b4b'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: date,
                lineWidth: 1,
                tickWidth: 0,
                title: {
                    text: null
                },
                plotLines: [{
                    value: 6.5,
                    color: '#000',
                    dashStyle: 'dot',
                    width: 1,
                    //label: {
                    //    text: 'Last quarter minimum'
                    //}
                }, {
                    value: 7.5,
                    color: '#000',
                    dashStyle: 'dot',
                    width: 1,
                    //label: {
                    //    text: 'Last quarter maximum'
                    //}
                }],
                plotBands: [{
                    zIndex: 5,
                    color: 'transparent',
                    from: 0,
                    to: 6.5,
                    label: {
                        text: "Last 7 days",
                        textAlign: 'center',
                    }
                }, {
                    zIndex: 5,
                    color: 'transparent',
                    from: 6.5,
                    to: 7.5,
                    label: {
                        text: "Today",
                        textAlign: 'center'
                    }
                }, {
                    zIndex: 5,
                    color: 'transparent',
                    from: 7.5,
                    to: 14,
                    zIndex: 5,
                    label: {
                        text: "Next 7 days",
                        textAlign: 'center',
                    }
                }],
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                borderColor: '#474b4b',
                x: 264,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    });
}

function bindSalesVolumeTable(data) {
    $('#salesVolumeTable').html('');
    var date = data.series[0].data;
    // bind pre-row
    var preRow = "<tr><td style=\"width: 61.6px;\">&nbsp;</td><td colspan='7'>Last 7 days</td><td class='todayData'>Today</td><<td colspan='7'>Next 7 days</td></tr>";
    //bind first row
    var firstRow = "<tr><td>Date</td>";
    for (var i = 0; i < date.length; i++) {
        if (i == 7)
            firstRow = firstRow + "<td class='todayData'>" + date[i] + '</td>';
        else
            firstRow = firstRow + "<td>" + date[i] + '</td>';

    }
    firstRow = firstRow + '</tr>';

    var lastYearSeries = data.series[1].data;
    var LastYearLast7Days = lastYearSeries.slice(0, 7);
    var lastYearToday = lastYearSeries[7];
    var LastYearNext7Days = lastYearSeries.slice(8, 15);
    //bind second row
    var secondRow = "<tr><td>Last Year</td>";
    for (var i = 0; i < LastYearLast7Days.length; i++) {
        secondRow = secondRow + "<td>" + LastYearLast7Days[i] + '</td>';
    }
    secondRow = secondRow + "<td class='todayData'>" + lastYearToday + '</td>';
    for (var i = 0; i < LastYearNext7Days.length; i++) {
        secondRow = secondRow + "<td>" + LastYearNext7Days[i] + '</td>';
    }
    secondRow = secondRow + '</tr>';

    var thisYearSeries = data.series[2].data;
    var ThisYear = thisYearSeries.slice(0, 7);
    var ThisYearToday = thisYearSeries[7];
    var ThisYear2 = thisYearSeries.slice(8, 15);
    //bind third row
    var thirdRow = "<tr><td>This Year</td>";
    for (var i = 0; i < ThisYear.length; i++) {
        thirdRow = thirdRow + "<td>" + ThisYear[i] + '</td>';
    }
    thirdRow = thirdRow + "<td class='todayData'>" + ThisYearToday + '</td>';
    for (var i = 0; i < ThisYear2.length; i++) {
        thirdRow = thirdRow + "<td class='tablePredictiveData'>" + ThisYear2[i] + '</td>';
    }
    thirdRow = thirdRow + '</tr>';

    var changesSeries = data.series[3].data;
    for (var i = 0; i < changesSeries.length; i++) {
        changesSeries[i] = changesSeries[i].toString().substring(0, changesSeries[i].toString().indexOf('.'));
    }
    var changesLast7Days = changesSeries.slice(0, 7);
    var changesToday = changesSeries[7];
    var changesNext7Days = changesSeries.slice(8, 15);
    var forthRow = "<tr><td>Changes (%)</td>";
    //bind forth row
    for (var i = 0; i < changesLast7Days.length; i++) {
        if (changesLast7Days[i] < 0)
            forthRow = forthRow + "<td><i class=\"red fa fa-caret-down\"></i> " + changesLast7Days[i].toString().substring(1) + '</td>';
        else if (changesLast7Days[i] > 0)
            forthRow = forthRow + "<td><i class=\"green fa fa-caret-up\"></i> " + changesLast7Days[i] + '</td>';
        else
            forthRow = forthRow + "<td> - </td>";
    }
    if (changesToday < 0)
        forthRow = forthRow + "<td class='todayData'><i class=\"red fa fa-caret-down\"></i> " + changesToday.toString().substring(1) + '</td>';
    else if (changesToday > 0)
        forthRow = forthRow + "<td class='todayData'><i class=\"green fa fa-caret-up\"></i> " + changesToday + '</td>';
    else
        forthRow = forthRow + "<td class='todayData'> - </td>";
    for (var i = 0; i < changesNext7Days.length; i++) {
        if (changesNext7Days[i] < 0)
            forthRow = forthRow + "<td class='tablePredictiveData'><i class=\"red fa fa-caret-down\"></i> " + changesNext7Days[i].toString().substring(1) + '</td>';
        else if (changesNext7Days[i] > 0)
            forthRow = forthRow + "<td class='tablePredictiveData'><i class=\"green fa fa-caret-up\"></i> " + changesNext7Days[i] + '</td>';
        else
            forthRow = forthRow + "<td class='tablePredictiveData'> - </td>";
    }

    // bind everything to the table
    $('#salesVolumeTable').append(preRow + firstRow + secondRow + thirdRow + forthRow);

}