﻿function chartLoading() {
    loadingChart("weekdaysOutsideTraffic");
    $("#weekdaysOutsideTraffic").addClass("chartLoading");

    loadingChart("weekendsOutsideTraffic");
    $("#weekendsOutsideTraffic").addClass("chartLoading");

}

//Outside Traffic and Visitor Counts Weekdays/Weekends Comparison Graph
function bindWeekdayTFAndOTTrend(datas, colorScheme) {
    $(function () {
        var footfallCount = datas.series[0];
        var OTCount = datas.series[1];

        //identify largest value of yaxis data

        var outsideTrafficLargestValue = 0;

        for (var i = 0; i < OTCount.data.length; i++) {
            if (OTCount.data[i] != null && OTCount.data[i] != undefined && OTCount.data[i] > outsideTrafficLargestValue)
                outsideTrafficLargestValue = OTCount.data[i]
        }

        var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
                               : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
                               : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                               : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                               : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                               : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                               : 1000000;

        var visitorLargestValue = 0;

        for (var i = 0; i < footfallCount.data.length; i++) {
            if (footfallCount.data[i] != null && footfallCount.data[i] != undefined && footfallCount.data[i] > visitorLargestValue)
                visitorLargestValue = footfallCount.data[i]
        }
        var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
                               : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
                               : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                               : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                               : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                               : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                               : 1000000;

        var showMarker = true;
        var showPopUp = true;
        if (datas.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekdaysOutsideTraffic",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false,
            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: OTCount.data,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: footfallCount.data,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //    useHTML: true,
                text: LanguageWeekdays,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingMondaytoFriday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                gridLineWidth: 0,
                tickWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                tickPosition: 'inside',
                gridLineWidth: 1,
                // tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 15,
                lineWidth: 0,
                tickWidth: 1,
                labels: {
                    align: 'right',
                    x: 25,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 100,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
    });
    if (datas.series[0].isDayOff)
        $("#weekdaysOutsideTraffic").append("<div class='weekday-notice'>" + LanguageCloseonWeekdays + "</div>");
}

function bindWeekendTFAndOTTrend(datas, colorScheme) {
    $(function () {
        var footfallCount = datas.series[0];
        var OTCount = datas.series[1];

        //identify largest value of yaxis data

        var outsideTrafficLargestValue = 0;

        for (var i = 0; i < OTCount.data.length; i++) {
            if (OTCount.data[i] != null && OTCount.data[i] != undefined && OTCount.data[i] > outsideTrafficLargestValue)
                outsideTrafficLargestValue = OTCount.data[i]
        }

        var outsideTrafficDynamicTickInterval = outsideTrafficLargestValue >= 0 && outsideTrafficLargestValue < 10 ? 1
                               : outsideTrafficLargestValue >= 10 && outsideTrafficLargestValue < 100 ? 10
                               : outsideTrafficLargestValue >= 100 && outsideTrafficLargestValue < 1000 ? 100
                               : outsideTrafficLargestValue >= 1000 && outsideTrafficLargestValue < 10000 ? 1000
                               : outsideTrafficLargestValue >= 10000 && outsideTrafficLargestValue < 100000 ? 10000
                               : outsideTrafficLargestValue >= 100000 && outsideTrafficLargestValue < 1000000 ? 100000
                               : 1000000;

        var visitorLargestValue = 0;

        for (var i = 0; i < footfallCount.data.length; i++) {
            if (footfallCount.data[i] != null && footfallCount.data[i] != undefined && footfallCount.data[i] > visitorLargestValue)
                visitorLargestValue = footfallCount.data[i]
        }
        var visitorCountDynamicTickInterval = visitorLargestValue >= 0 && visitorLargestValue < 10 ? 1
                               : visitorLargestValue >= 10 && visitorLargestValue < 100 ? 10
                               : visitorLargestValue >= 100 && visitorLargestValue < 1000 ? 100
                               : visitorLargestValue >= 1000 && visitorLargestValue < 10000 ? 1000
                               : visitorLargestValue >= 10000 && visitorLargestValue < 100000 ? 10000
                               : visitorLargestValue >= 100000 && visitorLargestValue < 1000000 ? 100000
                               : 1000000;

        var showMarker = true;
        var showPopUp = true;
        if (datas.series[0].isDayOff) {
            showMarker = false;
            showPopUp = false;
        }

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "weekendsOutsideTraffic",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                type: 'areaspline',
                name: LanguageOutsideTraffic,
                data: OTCount.data,
                color: colorScheme.chart.matrices.outsideTraffic,
                fillOpacity: 0.15,
                lineWidth: 1.25,
                yAxis: 1
            }, {
                type: 'column',
                name: LanguageVisitor,
                data: footfallCount.data,
                color: colorScheme.chart.matrices.noOfVisitor,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
            },
            subtitle: {
                //useHTML: true,
                text: LanguageWeekends,// + " " + "<i class='fa fa-question-circle' title='" + LanguageAveragenumberofpeoplepassingSaturdayandSunday + "'></i>",
                align: 'center',
                style: {
                    color: colorScheme.chart.subtitle.color,
                    fontSize: colorScheme.chart.subtitle.fontSize,
                    "font-family": colorScheme.chart.subtitle.fontFamily
                },
                margin: 0,
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false,
                        states: {
                            hover: {
                                enabled: showMarker
                            }
                        }
                    }
                }
            },
            yAxis: [{
                lineWidth: 0,
                tickWidth: 0,
                gridLineWidth: 0,
                //tickInterval: visitorCountDynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            {
                opposite: true,
                gridLineWidth: 1,
                tickPosition: 'inside',
                tickWidth: 1,
                lineWidth: 0,
                //tickInterval: outsideTrafficDynamicTickInterval,
                tickPixelInterval: 15,
                labels: {
                    align: 'right',
                    x: 25,
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                title: {
                    text: LanguageOutsideTraffic,
                    margin: 30,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                min: 0
            }],
            xAxis: {
                categories: datas.categories,
                tickWidth: 0,
                title: {
                    text: LanguageHour,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    rotation: -90,
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 100,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
                enabled: showPopUp
            },
        });
    });

    if (datas.series[0].isDayOff) {
        $("#weekendsOutsideTraffic").append("<div class='weekend-notice'>" + LanguageCloseonWeekends + "</div>");
    }
}

//Suggested Opening and Closing Hour, Extended Hour, Expected Increase in Footfall, Expected Saved Label Hour
function bindOpeningClosingHourIntoTable(data, colorScheme) {
    $("#storeHourReportTableContent").empty();
    $("#storeHourReportTable").show();
    $("#tableNotice").show();
    
    var day = data.series[0].data;

    for (var i = 0; i < day.length; i++) {
        var dayOfWeek = day[i].reportDay;
        var currentOpen = day[i].currentOpening;
        var suggestedOpen = day[i].suggestedOpening == null ? "-" : day[i].suggestedOpening;
        var currentClose = day[i].currentClosing;
        var suggestedClose = day[i].suggestedClosing == null ? "-" : day[i].suggestedClosing;
        var extendedHour = day[i].extendedHour != 0 ? day[i].extendedHour < 0 ? "<font class='drop'>" + day[i].extendedHour.toFixed(2) + "h</font>" : "<font class='rise'>+" + day[i].extendedHour.toFixed(2) + "h</font>" : "-";
        var expectedIncreaseFF = day[i].expectedIncreaseInFF != 0 ? "<i class='fa fa-caret-up rise'></i> " + day[i].expectedIncreaseInFF.toFixed(2) + "%" : "-";
        var expectedSavedLabour = day[i].expectedSavedLabourHour != 0 ? "<font class='rise'>+" + day[i].expectedSavedLabourHour.toFixed(2) + "h</font>" : "N/A";

        $("#storeHourReportTable").append("<tr><td class='text-left'>" + dayOfWeek + "</td><td>" + currentOpen + "</td><td>" +
            suggestedOpen + "</td><td>" + currentClose + "</td><td>" + suggestedClose + "</td><td>" + extendedHour + "</td><td>" +
            expectedIncreaseFF + "</td><td>" + expectedSavedLabour + "</td></tr>");
    }
}
