﻿function chartLoading() {
    loadingChart("visitorCountGraph");
    $("#visitorCountGraph").addClass("chartLoading");

    loadingChart("outsideTrafficGraph");
    $("#outsideTrafficGraph").addClass("chartLoading");

    loadingChart("turnInRateGraph");
    $("#turnInRateGraph").addClass("chartLoading");

    loadingChart("visitDurationGraph");
    $("#visitDurationGraph").addClass("chartLoading");

    loadingChart("ReturningCustGraph");
    $("#ReturningCustGraph").addClass("chartLoading");

    loadingChart("salesConversionGraph");
    $("#salesConversionGraph").addClass("chartLoading");
}

function showVistorCountGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        var periodOneData = data.series[0].visitorTotal;
        var periodTwoData = data.series[1].visitorTotal;
        var periodData = [periodOneData, periodTwoData];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "visitorCountGraph",
                events: {
                    load: function () {
                        chartEvent[0] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageVisitorCount,
                data: periodData,
                color: colorScheme.chart.column.color
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageVisitorCount,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
				allowDecimals: false,
				
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: false,
            },
        });
    });
}

function showOutsideTrafficGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        var periodOneData = data.series[0].OutsideTrafficTotal;
        var periodTwoData = data.series[1].OutsideTrafficTotal;
        var periodData = [periodOneData, periodTwoData];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "outsideTrafficGraph",
                events: {
                    load: function () {
                        chartEvent[1] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageOutsideTraffic,
                data: [periodOneData, periodTwoData],
                color: colorScheme.chart.column.color,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageOutsideTraffic,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageOutsideTraffic,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
				allowDecimals: false,
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: false,
            },
        });
    });
}

function showTurnInRateGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        var periodOneData = data.series[0].TurnInRateTotal;
        var periodTwoData = data.series[1].TurnInRateTotal;
        var periodData = [periodOneData, periodTwoData];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "turnInRateGraph",
                events: {
                    load: function () {
                        chartEvent[2] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageTurnInRate,
                data: [periodOneData, periodTwoData],
                color: colorScheme.chart.column.color,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageTurnInRate,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageTurnInRatepercent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: false,
            },
        });
    });
}

function showVisitDurationGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        var periodOneData = data.series[0].VisitDurationTotal;
        var periodTwoData = data.series[1].VisitDurationTotal;
        var periodData = [periodOneData, periodTwoData];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "visitDurationGraph",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageVisitDuration,
                data: [periodOneData, periodTwoData],
                color: colorScheme.chart.column.color,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageVisitDuration,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageAverageVisitDurationmins,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: false,
            },
        });
    });
}

function showReturningCustomerGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        var newCustData = [data.series[0].NewCust[0], data.series[1].NewCust[0]];
        var returnCustData = [data.series[0].ReturnCust[0], data.series[1].ReturnCust[0]];
        var periodData = [data.series[0].NewCust[0], data.series[1].NewCust[0], data.series[0].ReturnCust[0], data.series[1].ReturnCust[0]];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "ReturningCustGraph",
                events: {
                    load: function () {
                        chartEvent[4] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageNewCustomer,
                data: newCustData,
                color: colorScheme.chart.stackColumn.general.category1,
                borderWidth: 0
            }, {
                name: LanguageReturningCustomer,
                data: returnCustData,
                color: colorScheme.chart.stackColumn.general.category2,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageReturningCustomer,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageNoofVisitor,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                itemStyle: {
                    color: colorScheme.chart.legend.text.color,
                    "font-family": colorScheme.chart.legend.text.fontFamily,
                    fontSize: colorScheme.chart.legend.text.fontSize,
                    "font-weight": colorScheme.chart.legend.text.fontWeight
                },
                enabled: true,
                x: 65,
                y: -15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: true,
            },
        });
    });
}

function showSalesConversionGraph(data, periodOneName, periodTwoName, colorScheme) {
    $(function () {
        $("#salesConversionGraphTitle").show();
        $("#salesConversionGraph").show();
        var periodOneData = data.series[0].SalesConversionTotal;
        var periodTwoData = data.series[1].SalesConversionTotal;
        var periodData = [periodOneData, periodTwoData];

        //identify largest value of yaxis data
        var largestValue = 0;
        for (var i = 0; i < periodData.length; i++) {
            if (periodData[i] != null && periodData[i] != undefined && periodData[i] > largestValue)
                largestValue = periodData[i];
        }

        var dynamicTickInterval = largestValue >= 0 && largestValue < 10 ? 1
                               : largestValue >= 10 && largestValue < 100 ? 10
                               : largestValue >= 100 && largestValue < 1000 ? 100
                               : largestValue >= 1000 && largestValue < 10000 ? 1000
                               : largestValue >= 10000 && largestValue < 100000 ? 10000
                               : largestValue >= 100000 && largestValue < 1000000 ? 100000
                               : 1000000;

        var chart = new Highcharts.Chart({
            chart: {
                type: 'column',
                renderTo: "salesConversionGraph",
                events: {
                    load: function () {
                        chartEvent[5] = this;
                    }
                },
                alignTicks: false

            },
            series: [{
                name: LanguageSalesConversion,
                data: [periodOneData, periodTwoData],
                color: colorScheme.chart.column.color,
                borderWidth: 0
            }],
            credits: {
                enabled: false
            },
            title: {
                text: ''
                //text: LanguageSalesConversion,
                //align: 'left',
                //style: {
                //    color: colorScheme.chart.title.color.general,
                //    "font-family": colorScheme.chart.title.fontFamily,
                //    fontSize: colorScheme.chart.title.fontSize,
                //    textDecoration: colorScheme.chart.title.textDecoration,
                //    "font-weight": colorScheme.chart.title.fontWeight
                //}
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            yAxis: {
                lineWidth: 0,
                gridLineWidth: 1,
                tickWidth: 1,
                tickLength: 5,
                //tickInterval: dynamicTickInterval,
                tickPixelInterval: 15,
                tickPosition: 'inside',
                title: {
                    text: LanguageSalesConversionpercent,
                    style: {
                        color: colorScheme.chart.axisLabel.y.title.color,
                        fontSize: colorScheme.chart.axisLabel.y.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.y.title.fontFamily
                    }
                },
                labels: {
                    style: {
                        "font-family": colorScheme.chart.axisLabel.y.label.fontFamily,
                        color: colorScheme.chart.axisLabel.y.label.color,
                        fontSize: colorScheme.chart.axisLabel.y.label.fontSize
                    }
                },
                min: 0,
            },
            xAxis: {
                categories: [periodOneName, periodTwoName],
                tickWidth: 0,
                title: {
                    text: LanguageGroup,
                    align: 'high',
                    y: -20,
                    style: {
                        color: colorScheme.chart.axisLabel.x.title.color,
                        fontSize: colorScheme.chart.axisLabel.x.title.fontSize,
                        "font-family": colorScheme.chart.axisLabel.x.title.fontFamily
                    }
                },
                labels: {
                    x: 3,
                    style: {
                        color: colorScheme.chart.axisLabel.x.label.color,
                        "font-family": colorScheme.chart.axisLabel.x.label.fontFamily,
                        fontSize: colorScheme.chart.axisLabel.x.label.fontSize
                    }
                }
            },

            legend: {
                enabled: false
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                useHTML: true,
                shared: false,
            },
        });
    });
}

function bindDataIntoTimeComparisonTable(data) {
    $("#comparisonTableContent").empty();
    $("#comparisonTable").show();

    var KPIRow = [LanguageVisitorCount, LanguageOutsideTraffic, LanguageTurnInRate, LanguageVisitDuration, LanguageReturningRate];

    var periodOneFF = data.series[0].visitorTotal.toFixed(0);
    var periodOneOT = data.series[0].OutsideTrafficTotal.toFixed(0);
    var periodOneTIR = data.series[0].TurnInRateTotal != 0 ? data.series[0].TurnInRateTotal.toFixed(2) + "%" : "-";
    var periodOneVD = data.series[0].VisitDurationTotal != 0 ? data.series[0].VisitDurationTotal.toFixed(2) + " " + LanguageMins : "-";
    var periodOneRR = data.series[0].ReturnCustomerRate != 0 ? data.series[0].ReturnCustomerRate.toFixed(2) + "%" : "-";
    var periodOneSC = data.series[0].SalesConversionTotal != 0 ? data.series[0].SalesConversionTotal.toFixed(2) + "%" : "-";
    var periodOneData = [periodOneFF, periodOneOT, periodOneTIR, periodOneVD, periodOneRR];

    var periodTwoFF = data.series[1].visitorTotal.toFixed(0);
    var periodTwoOT = data.series[1].OutsideTrafficTotal.toFixed(0);
    var periodTwoTIR = data.series[1].TurnInRateTotal != 0 ? data.series[1].TurnInRateTotal.toFixed(2) + "%" : "-";
    var periodTwoVD = data.series[1].VisitDurationTotal != 0 ? data.series[1].VisitDurationTotal.toFixed(2) + " " + LanguageMins : "-";
    var periodTwoRR = data.series[1].ReturnCustomerRate != 0 ? data.series[1].ReturnCustomerRate.toFixed(2) + "%" : "-";
    var periodTwoSC = data.series[1].SalesConversionTotal != 0 ? data.series[1].SalesConversionTotal.toFixed(2) + "%" : "-";
    var periodTwoData = [periodTwoFF, periodTwoOT, periodTwoTIR, periodTwoVD, periodTwoRR];

    var differencesFF =
        data.series[2].DifferencesInFF != 0 ?
        data.series[2].DifferencesInFF > 0 ? "+" + data.series[2].DifferencesInFF.toFixed(2) + "%" : data.series[2].DifferencesInFF.toFixed(2) + "%"
        : "-";
    var differencesOT =
        data.series[2].DifferencesInOT != 0 ?
        data.series[2].DifferencesInOT > 0 ? "+" + data.series[2].DifferencesInOT.toFixed(2) + "%" : data.series[2].DifferencesInOT.toFixed(2) + "%"
        : "-";
    var differencesTIR =
        data.series[2].TurnInRateTotal != 0 ?
        data.series[2].TurnInRateTotal > 0 ? "+" + data.series[2].TurnInRateTotal.toFixed(2) + "%" : data.series[2].TurnInRateTotal.toFixed(2) + "%"
        : "-";
    var differencesVD =
        data.series[2].VisitDurationTotal != 0 ?
        data.series[2].VisitDurationTotal > 0 ? "+" + data.series[2].VisitDurationTotal.toFixed(2) + "%" : data.series[2].VisitDurationTotal.toFixed(2) + "%"
        : "-";
    var differencesRR =
        data.series[2].ReturnCustomerRate != 0 ?
        data.series[2].ReturnCustomerRate > 0 ? "+" + data.series[2].ReturnCustomerRate.toFixed(2) + "%" : data.series[2].ReturnCustomerRate.toFixed(2) + "%"
        : "-";
    var differencesSC =
        data.series[2].SalesConversionTotal != 0 ?
        data.series[2].SalesConversionTotal > 0 ? "+" + data.series[2].SalesConversionTotal.toFixed(2) + "%" : data.series[2].SalesConversionTotal.toFixed(2) + "%"
        : "-";
    var differencesData = [differencesFF, differencesOT, differencesTIR, differencesVD, differencesRR];

    var KPIScrollToTarget = ['#VisitorCountsSection', '#OutsideTrafficSection', '#TurnInRateSection', '#VisitDurationSection', '#ReturningCustomerSection', '#SalesConversionSection'];

    for (var i = 0; i < KPIRow.length; i++)//for first 5 rows
    {
        if (i < 2)
            $("#comparisonTable").append("<tr><td class='text-left' onclick=\"scrollToTarget('" + KPIScrollToTarget[i] + "')\" style='cursor: pointer;'>" + KPIRow[i] + "</td><td>" +
            numberify(periodOneData[i]) + "</td><td>" + numberify(periodTwoData[i]) + "</td><td>" + differencesData[i] + "</td></tr>");
        else
            $("#comparisonTable").append("<tr><td class='text-left' onclick=\"scrollToTarget('" + KPIScrollToTarget[i] + "')\" style='cursor: pointer;'>" + KPIRow[i] + "</td><td>" +
            periodOneData[i] + "</td><td>" + periodTwoData[i] + "</td><td>" + differencesData[i] + "</td></tr>");
    }

    if (periodOneSC != "-" || periodTwoSC != "-")//for sales conversion row, show if only has sales conversion data
    {
        $("#comparisonTable").append("<tr><td class='text-left' onclick=\"scrollToTarget('#salesConversionGraphTitle')\" style='cursor: pointer;'>" + LanguageSalesConversion + "</td><td>" +
        periodOneSC + "</td><td>" + periodTwoSC + "</td><td>" + differencesSC + "</td></tr>");
    }
}

