﻿function bindHourlyTrendWeekdays() {

    var footfall = [50, 49, 60, 56, 34, 10, 8, 12, 38, 17, 16, 15, 20]; //footfall
    var salesvolume = [3, 7, 6, 10, 4, 8, 8, 2, 6, 7, 6, 5, 9];          //salesvolume
    var staff = [10, 18, 12, 8, 7, 5, 5, 13, 6, 7, 9, 5, 14];                 //staff
    var xAxisLabel = [9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9];
    //identify largest value of yaxis data
    var footfallLV = 0;
    var salesVolumeLV = 0;
    var staffLV = 0;

    for (var i = 0; i < footfall.length; i++) {
        if (footfall[i] != null && footfall[i] != undefined && footfall[i] > footfallLV)
            footfallLV = footfall[i]
    }

    for (var i = 0; i < salesvolume.length; i++) {
        if (salesvolume[i] != null && salesvolume[i] != undefined && salesvolume[i] > salesVolumeLV)
            salesVolumeLV = salesvolume[i]
    }

    for (var i = 0; i < staff.length; i++) {
        if (staff[i] != null && staff[i] != undefined && staff[i] > staffLV)
            staffLV = staff[i]
    }

    var visitorDynamicTickInterval = footfallLV >= 0 && footfallLV < 10 ? 1
                           : footfallLV >= 10 && footfallLV < 100 ? 10
                           : footfallLV >= 100 && footfallLV < 1000 ? 100
                           : footfallLV >= 1000 && footfallLV < 10000 ? 1000
                           : footfallLV >= 10000 && footfallLV < 100000 ? 10000
                           : footfallLV >= 100000 && footfallLV < 1000000 ? 100000
                           : 1000000;

    var salesVolumeDynamicTickInterval = salesVolumeLV >= 0 && salesVolumeLV < 10 ? 1
                           : salesVolumeLV >= 10 && salesVolumeLV < 100 ? 10
                           : salesVolumeLV >= 100 && salesVolumeLV < 1000 ? 100
                           : salesVolumeLV >= 1000 && salesVolumeLV < 10000 ? 1000
                           : salesVolumeLV >= 10000 && salesVolumeLV < 100000 ? 10000
                           : salesVolumeLV >= 100000 && salesVolumeLV < 1000000 ? 100000
                           : 1000000;

    var staffDynamicTickInterval = staffLV >= 0 && staffLV < 10 ? 1
                           : staffLV >= 10 && staffLV < 100 ? 10
                           : staffLV >= 100 && staffLV < 1000 ? 100
                           : staffLV >= 1000 && staffLV < 10000 ? 1000
                           : staffLV >= 10000 && staffLV < 100000 ? 10000
                           : staffLV >= 100000 && staffLV < 1000000 ? 100000
                           : 1000000;
    console.log(footfallLV +" "+ visitorDynamicTickInterval);
    console.log(salesVolumeLV +" " + salesVolumeDynamicTickInterval);
    console.log(staffLV +" "+ staffDynamicTickInterval);
    $(function () {
        var chart = new Highcharts.Chart({
            chart: {
                renderTo: "HourlyWeekdaysTrend",
                events: {
                    load: function () {
                        chartEvent[3] = this;
                    }
                },
            },
            series: [{
                type: 'column',
                name: 'No. of Visitor',
                data: footfall,
                color: '#97c5e9',
                //pointWidth: 10
            }, {
                type: 'line',
                name: 'Sales Volume',
                data: salesvolume,
                color: '#f49423',
                //pointWidth: 10
            }, {
                type: 'line',
                name: 'No. of staff',
                data: staff,
                color: '#28B463',
                //pointWidth: 10,
                step: 'left',
                
            }],
            credits: {
                enabled: false
            },
            title: {
                text: 'Hourly Trend (Weekdays)',
                align: 'left',
                style: {
                    "font-family": "Franklin Gothic Medium",
                    textDecoration: 'underline',
                    color: '#494b4b',
                    fontSize: '15px'
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal'
                },
                series: {
                    marker: {
                        enabled: false
                    },
                   
                }
            },
            yAxis: [{
                lineWidth: 1,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 1,
                tickInterval: visitorDynamicTickInterval,
                tickPosition: 'inside',
                title: {
                    text: 'No. of Visitor',
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#97c5e9'
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial",
                        color: '#97c5e9'
                    }
                }
            },
            {
                opposite: true,
                linkedTo: 0,
                lineWidth: 1,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 1,
                tickInterval: salesVolumeDynamicTickInterval,
                tickPosition: 'outside',
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial",
                        color: '#f49423',
                        margin: 30,
                    }
                },
                title: {
                    text: 'Sales Volume',                    
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#f49423',
                        margin: [0, 30, 0, 0]
                    }
                }
            }, {
                opposite: true,
                linkedTo: 0,
                lineWidth: 1,
                min: 0,
                gridLineWidth: 0,
                tickWidth: 1,
                tickInterval: staffDynamicTickInterval,
                tickPosition: 'outside',
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial",
                        color: '#8BC34A',
                    }
                },
                title: {
                    text: 'No. of staff',
                    style: {
                        fontSize: '11px',
                        "font-family": "Arial",
                        color: '#8BC34A'
                    }
                }
            }],
            xAxis: {
                categories: xAxisLabel,
                //categories: [{
                //    categories: datas.categories
                //}],
                tickWidth: 0,
                title: {
                    text: 'Hour',
                    align: 'high',
                    y: -20,
                    style: {
                        fontSize: '12px',
                        "font-family": "Arial"
                    }
                },
                labels: {
                    //rotation: -90,
                    x: 6,
                    style: {
                        fontSize: '10px',
                        "font-family": "Arial"
                    }
                },               
            },
            legend: {
                itemStyle: {
                    font: '8pt Arial'
                },
                enabled: true,
                borderWidth: 1,
                borderColor: '#474b4b',
                x: 156,
                y: 15,
                verticalAlign: 'top',
            },
            exporting: {
                enabled: false,
            },
            tooltip: {
                shared: true,
            },
        });
    });

}