/**
 * sourceWidth and sourceHeight is dpi
 * dpi to px will be double
 * 100dpi = 200px
**/
function callLastWeekTrend(datas) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "lastWeekTrend",
				type: "column",
				events: {
					load: function () {
						chartEvent[0] = this;
					}
				},
			},
			credits: {
				enabled: false
			},
			title: {
				text: null,
				align: 'left'
			},
			tooltip: {
				shared: true
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: [{
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					margin: 5,
					style: {
						fontSize: '12px',
						"font-family": "Franklin Gothic Medium"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Book"
					}
				}
			}, {
				opposite: true,
				gridLineWidth: 0,
				lineWidth: 1,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				max: datas.maxYValue,
				min: 0,
				labels: {
					align: 'left',
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Book"
					}
				},
				title: {
					text: 'Outside Traffic',
					style: {
				fontSize: '12px',
				"font-family": "Franklin Gothic Medium"
			}
				}
			}, {
				lineWidth: 0,
				gridLineWidth: 0,
				max: 100,
				min: 0,
				dataLabels: {
					enabled: true,
					format: '{y} %',
					rotation: -90,
					y: -25,
					x: 3
				},
				title: {
					text: null
				},
				labels: {
					enabled: false
				}
			}],
			xAxis: {
				categories: datas.date,
				tickWidth: 0,
				labels: {
					rotation: 0,
					style: {
						"font-family": "Franklin Gothic Book",
						fontSize: '10px'
					}
				}
			},
			series: [{
				name: 'Footfall',
				color: '#97c5e9',
				data: datas.valueIn,
				pointWidth: 20
			}, {
				yAxis: 1,
				name: 'Outside Traffic',
				type: 'area',
				fillColor: 'rgba(249, 189, 113, 0.1)',
				color: '#f9bd71',
				data: datas.outsideTraffic,
				marker: {
					enabled: false
				}
			}, {
				yAxis: 2,
				name: 'Turn In Rate',
				type: 'line',
				marker: {
					symbol: 'square'
				},
				dataLabels: {
					enabled: true
				},
				color: '#2482c4',
				lineWidth: 0,
				data: datas.turnInRate
			}

			//, {
			//   data: dataOut
			//}
				],
			legend: {
				enabled: true,
				align: 'center',
				layout: 'horizontal',
				verticalAlign: 'top',
				shadow: true,
				symbolHeight: 10,
				symbolWidth: 10,
				itemStyle: {
					color: '#787878',
					fontSize: '11px',		
					fontweight: 'normal',
					fontFamily: 'Franklin Gothic Book',
				}
			},
			exporting: {
				enabled: false,
				sourceWidth: 326,
				sourceHeight: 304       
			}
		});
	});
}

//calllast7days chart joseph
function callLast7Days(datas) {
	$(function () {
		var dataIn = datas.valueIn;
		var dataOut = datas.valueOut;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "last7days",
				event: {
					load: function () {
						chartEvent[3] = this;
					}
				}
			},
			series: [{
				type: 'line',
				name: 'This Year',
				data: dataIn,
				color: '#97c5e9',
			}, {
				type: 'line',
				name: 'Last Year',
				data: datas.valueLastYearIn,
				color: '#f49423'
			}],
			credits: {
				enabled: false
			},
			title: {
				text: 'Last 7 days',
				align: 'left',
				style: {
					"font-family": "Franklin Gothic Medium",
					textDecoration: 'underline',
					color: '#494b4b',
					fontSize: '15px'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				min: 0,
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: [{
					name: datas.categoryName[0],
					categories: datas.categories
				}, {
					name: datas.categoryName[1],
					categories: datas.categories
				}, {
					name: datas.categoryName[2],
					categories: datas.categories

				}, {
					name: datas.categoryName[3],
					categories: datas.categories

				}, {
					name: datas.categoryName[4],
					categories: datas.categories

				}, {
					name: datas.categoryName[5],
					categories: datas.categories

				}, {
					name: datas.categoryName[6],
					categories: datas.categories

				}],
				tickWidth: 0,
				tickInterval: 10,
				title: {
					text: 'Day',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '0px',
						"font-family": "Arial"
					},
					formatter: function () {
							var splitValue = this.value.toString().split("<br/>", 2);
							if(splitValue[1] == undefined)
								splitValue[1] = '';
							return '<label style="font-size:11px;">' + splitValue[0] + '<label><br/><label style="font-size:10px;">' + splitValue[1] + '</label>';
						}
				}
			},
			legend: {
				enabled: true,
				itemStyle: {
					font: '8pt Arial'
				},
				borderWidth: 1,
				borderColor: '#474b4b',
				verticalAlign: 'top',
				x: 280,
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 221
			}
		});
	});
}

//callweekendstrafficprofile chart (2 columned) joseph
function callWeekEndsTrafficProfile(weekendsAverageTrafficProfile) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "weekendsTrafficProfile",
				events: {
					load: function () {
						chartEvent[4] = this;
					}
				},
			},
			series: [{
				type: 'line',
				name: 'visitor',
				data: weekendsAverageTrafficProfile.weekendsTrafficProfileValueInt,
				color: '#97c5e9'
			}],
			credits: {
				enabled: false
			},
			title: {
				text: 'Weekends',
				align: 'left',
				x: 180,
				y: 30,
				style: {
					"font-family": "Arial",
					color: '#494b4b',
					fontSize: '15px'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				min: 0,
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: weekendsAverageTrafficProfile.weekendsHour,
				tickWidth: 0,
				tickInterval: 1,
				title: {
					text: 'Hourly',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '8px',
						"font-family": "Arial"
					},
				}
			},
			legend: {
				enabled: false
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 221
			}
		});
	});
}

//callweekdaystrafficprofile chart (2 columned) joseph
function callWeekDaysTrafficProfile(weekdaysAverageTrafficProfile) {
	$(function () {
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "weekdaysTrafficProfile",
				events: {
					load: function () {
						chartEvent[4] = this;
					}
				},
			},
			series: [{
				type: 'line',
				name: 'visitor',
				data: weekdaysAverageTrafficProfile.weekdaysTrafficProfileValueInt,
				color: '#97c5e9'
			}],
			credits: {
				enabled: false
			},
			title: {
				text: 'Weekdays',
				align: 'left',
				x: 180,
				y: 30,
				style: {
					"font-family": "Arial",
					color: '#494b4b',
					fontSize: '15px'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				min: 0,
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: weekdaysAverageTrafficProfile.weekdaysHour,
				tickWidth: 0,
				tickInterval: 1,
				title: {
					text: 'Hourly',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '8px',
						"font-family": "Arial"
					},                    
				}
			},
			legend: {
				enabled: false              
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 221
			}
		});
	});
}

//callturninratemonthlytrend chart (1 chart 1 table) joseph
function callTurnInRateMonthlyTrend(datas) {
	$(function () {      
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newTurnInRateMonthlyTrend",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				}
			},
			series: [{
				type: 'column',
				name: 'This Year',
				data: datas.turnInRate,
				color: '#97c5e9',
				pointWidth: 10
			}, {
				type: 'line',
				name: 'Last Year',
				data: datas.lastYearTurnInRate,
				color: '#f49423'
			}

			//, {
			//   data: dataOut
			//}
			],
			credits: {
				enabled: false
			},
			title: {
				text: 'Monthly Trend',
				align: 'left',
				style: {
					"font-family": "Franklin Gothic Medium",
					textDecoration: 'underline',
					color: '#494b4b',
					fontSize: '15px'
				}
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial",
						color: '#474b4b'
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: datas.month,
				tickWidth: 0,
				title: {
					text: 'Month',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			legend: {
				itemStyle: {
					font: '8pt Arial'
				},
				enabled: true,
				borderWidth: 1,
				borderColor: '#474b4b',
				x: 96,
				y: 15,
				verticalAlign: 'top',
			},
			exporting: {
				enabled: false,
				sourceWidth: 400,
				sourceHeight: 221
			}
		});
	});
}

function callThisWeek(datas) {
	$(function () {
		var dataIn = datas.valueIn;
		var dataOut = datas.valueOut;
		for (var i = dataIn.length; dataIn.length < 77; ) {
			dataIn.push(null);
			dataOut.push(null);
		}
		var tryChart = new Highcharts.Chart({
			chart: {
				renderTo: "thisWeek",
				type: "line",
				events: {
					load: function () {
						chartEvent[1] = this;
					}
				},
			},
			series: [{
				name: 'In',
				data: dataIn,
				pointWidth: 7
			}
			//, {
			//   data: dataOut
			//}
				],
			credits: {
				enabled: false
			},
			title: {
				text: null,
				align: 'left'
			},
			legend: {
				enabled: false
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: {
				gridLineWidth: 0,
				lineWidth: 1,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				startOnTick: false,
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '12px',
						"font-family": "Franklin Gothic Medium"
					}
				},
				labels: {
					style: {
						fontSize: '10px',
						"font-family": "Franklin Gothic Medium"
					}
				}
			},
			xAxis: {
				lineWidth: 1,
				categories: [{
					name: datas.categoryName[0],
					categories: datas.categories
				}, {
					name: datas.categoryName[1],
					categories: datas.categories
				}, {
					name: datas.categoryName[2],
					categories: datas.categories

				}, {
					name: datas.categoryName[3],
					categories: datas.categories

				}, {
					name: datas.categoryName[4],
					categories: datas.categories

				}, {
					name: datas.categoryName[5],
					categories: datas.categories

				}, {
					name: datas.categoryName[6],
					categories: datas.categories

				}],               

				labels: {
					//autoRotation: [-10, -20, -30, -40, -50, -60, -70, -80, -90],
					rotation: -90,
					x: 3,
					style: {
						"font-family": "Franklin Gothic Book",
						fontSize: '0px'
						
					},
					formatter: function () {
						var splitValue = this.value.toString().split("<br/>", 2);
						if(splitValue[1] == undefined)
							splitValue[1] = '';
						return '<label style="font-size:11px;">' + splitValue[0] + '<label><br/><label style="font-size:10px;">' + splitValue[1] + '</label>';
					}
				},

				minorGridLineWidth: 1,
				minorTickLength: 1
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 171
			}
		});
	});
}

function callDailyTrend(datas) {
    var date = datas.date.toString("ddd, d MMM");
    var chart = new Highcharts.Chart({
        chart: {
            renderTo: "dailyTrend",
            type: 'column',
            events: {
                load: function () {
                    chartEvent[2] = this;
                }
            },
            marginLeft: 45,
            marginRight: 40
        },
        credits: {
            enabled: false
        },
        title: {
            text: null,
            align: 'left'
        },
        xAxis: {
            categories: datas.date,
            tickWidth: 0,
            labels: {
                rotation: -90,
                format: '{value:%d/%m/%Y}',
                style: {
                    fontSize: '10px',
                    "font-family": "Franklin Gothic Book"
                }
            },            
        },
        yAxis: [{
            opposite: false,
            gridLineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPosition: 'inside',
            labels: {
                enabled: false,
                align: 'right'
            },
            lineWidth: 1,
            title: {
                text: 'No. of Visitor',
                style: {
                    fontSize: '12px',
                    "font-family": "Franklin Gothic Medium"
                }
            },
            min: 0,
            labels: {
                style: {
                    fontSize: '10px',
                    "font-family": "Franklin Gothic Book"
                }
            },
            top: '10%',
            height: '90%'
        }, {
            min: -20,
            max: 60,
            opposite: true,
            gridLineWidth: 0,
            tickWidth: 1,
            tickLength: 5,
            tickPosition: 'inside',
            lineWidth: 1,
            labels: {
                enabled: false,
                align: 'left',
                style: {
                    fontSize: '10px',
                    "font-family": "Franklin Gothic Book"
                }
            },
            title: {
                text: null
            },
            top: '10%',
            height: '90%'
        }, {
            min: 0,
            max: 0,
            gridLineWidth: 0,
            lineWidth:0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            },
            height: '10%'
        }],
        legend: {
            enabled: false
        },
        plotOptions: {
            column: {
                stacking: 'normal'
            }
        },
        tooltip: {            

            formatter: function () {
                if (this.series.name == 'In')
                    return '<b>' + this.x + '</b><br/>' +
			        this.series.name + ': ' + this.y + '<br/>';
                else
                    return '<b>' + this.x + '</b><br/>';
            },
            //shared: true,
        },
        series: [{
            name: 'In',
            data: datas.valueIn,
            stack: 0,
            yAxis: 0,
            pointWidth: 13
        },
		//            {
		//                name: 'Out',
		//                data: datas.valueOut,
		//                stack: 0
		//            }, 
//        {
//        type: 'line',
//        name: 'Temperature',
//        //lineWidth: 0,
//        data: datas.averageTemp,
//        color: '#F9BD71',
//        yAxis: 1,
//        marker: {
//            enabled: false
//        }
//    }, 
	{
		type: 'scatter',
		name: 'In ',
		lineWidth: 0,
		data: datas.symbol,
		color: '#F9BD71',
		yAxis: 2
	}],
	exporting: {
		enabled: false,
		sourceWidth: 740,
		sourceHeight: 217
	}
    });
    
}

function callMonthlyTrend(datas) {
	$(function () {
		var dataIn = datas.valueIn;
		var dataOut = datas.valueOut;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newMonthlyTrend",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				}
			},
			series: [{
				type: 'column',
				name: 'This Year',
				data: dataIn,
				color:'#97c5e9',
				pointWidth: 10
			}, {
				type: 'line',
				name: 'Last Year',
				data: datas.lastYearIn,
				color:'#f49423'
			}

			//, {
			//   data: dataOut
			//}
			],
			credits: {
				enabled: false
			},
			title: {
				text: 'Monthly Trend',
				align: 'left',
				style: {
					"font-family": "Franklin Gothic Medium",
					textDecoration: 'underline',
					color: '#494b4b',
					fontSize:'15px'
				}
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial",
						color: '#474b4b'
					}
				},
				labels: {
					style:{
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				title: {                    
					text: 'Month',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
						}
					},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			legend: {
				itemStyle: {
					font: '8pt Arial'
				},
				enabled: true,
				borderWidth: 1,
				borderColor: '#474b4b',
				x: 96,
				y: 15,
				verticalAlign: 'top',                
			},
			exporting: {
				enabled: false,
				sourceWidth: 400,
				sourceHeight: 221
			}
		});
	});
}

function callWeeklyTrend(datas) {
	$(function () {
		var dataIn = datas.valueIn;
		var dataOut = datas.valueOut;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newWeeklyTrend",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				}
			},
			series: [{
				type: 'column',
				name: 'This Year',
				data: dataIn,
				color:'#97c5e9',
				pointWidth: 10
			}, {
				type: 'line',
				name: 'Last Year',
				data: datas.lastYearIn,
				color:'#f49423'
			}

			//, {
			//   data: dataOut
			//}
			],
			credits: {
				enabled: false
			},
			title: {
				text: 'Weekly Trend',
				align: 'left',
				style: {
					"font-family": "Franklin Gothic Medium",
					textDecoration: 'underline',
					color: '#494b4b',
					fontSize:'15px'
				}
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial"
					}
				},
				labels: {
					style:{
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: datas.categories,
				tickWidth: 0,
				title: {
					text: 'Week',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			legend: {                
				enabled: true,
				itemStyle: {
				font: '8pt Arial'
				},
				borderWidth: 1,
				borderColor: '#474b4b',
				verticalAlign: 'top',
				x: 280,
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 221
			}
		});
	});
}

function callNewDailyTrend(datas) {
	$(function () {
		var dataIn = datas.valueIn;
		var dataOut = datas.valueOut;

		var chart = new Highcharts.Chart({
			chart: {
				renderTo: "newDailyTrend",
				events: {
					load: function () {
						chartEvent[3] = this;
					}
				}
			},
			series: [{
				type: 'column',
				name: 'This Year',
				data: dataIn,
				color:'#97c5e9',
				pointWidth: 10
			}, {
				type: 'line',
				name: 'Last Year',
				data: datas.lastYearIn,
				color:'#f49423'
			}

			//, {
			//   data: dataOut
			//}
			],
			credits: {
				enabled: false
			},
			title: {
				text: 'Daily Trend',
				align: 'left',
				style: {
					"font-family": 'Franklin Gothic Medium',
					textDecoration: 'underline',
					color: '#494b4b',
					fontSize:'15px'
				}
			},
			plotOptions: {
				column: {
					stacking: 'normal'
				}
			},
			yAxis: {
				lineWidth: 1,
				gridLineWidth: 0,
				tickWidth: 1,
				tickLength: 5,
				tickPosition: 'inside',
				title: {
					text: 'No. of Visitor',
					style: {
						fontSize: '11px',
						"font-family": "Arial"
					}
				},
				labels: {
					style:{
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			xAxis: {
				categories: datas.datetime,
				tickWidth: 0,
				title: {
					text: 'Day',
					align: 'high',
					y: -20,
					style: {
						fontSize: '12px',
						"font-family": "Arial"
					}
				},
				labels: {
					rotation: -90,
					x: 3,
					style: {
						fontSize: '10px',
						"font-family": "Arial"
					}
				}
			},
			legend:{
				enabled: true,
				itemStyle: {
					font: '8pt Arial'
				},
				borderWidth: 1,
				borderColor: '#474b4b',
				verticalAlign: 'top',
				x: 280,
			},
			exporting: {
				enabled: false,
				sourceWidth: 740,
				sourceHeight: 221
			}
		});
	});
}

function callDwellTimeChart(datas) {
	Highcharts.setOptions({
		global: {
			useUTC: true
		}
	});

	$('#dwellTime').highcharts({
		chart: {
			type: 'column',
			events: {
				load: function () {
					chartEvent[4] = this;
				}
			}
		},
		title: {
			text: null,
			align: 'left',
			style: {
				fontWeight: 'bold',
				color: '#494b4b'
			}
		},
		xAxis: {
		    categories: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
			//categories: datas.categories,
			//                    type: 'datetime',
			//                    dateTimeLabelFormats: { // don't display the dummy year
			//                        month: '%e. %b',
			//                        year: '%b'
			//                        day: '%e. %b'
			//                    },
			lineWidth: 1,
			tickWidth: 0,
			title: {
				text: null
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		yAxis: {
			lineWidth: 1,
			gridLineWidth: 0,
			tickWidth: 1,
			tickLength: 5,
			tickPosition: 'inside',
			min: 0,
			title: {
				text: 'No. of Visitor',
				style: {
					fontSize: '12px',
					"font-family": "Franklin Gothic Medium"
				}
			},
			stackLabels: {
				enabled: false,
				style: {
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		legend: {
			enabled: true,
			align: 'top',
			backgroundColor: '#FFFFFF',
			//borderColor: '#FFFFFF',
			//borderWidth: 1,
			layout: 'horizontal',
			verticalAlign: 'top',
			//width: 80,
			y: 20,
			x:75,
			symbolHeight: 10,
			symbolWidth: 10,
			itemStyle: {
				color: '#787878',
				fontSize: '10px',
				fontweight: 'light',
				"cursor": "default"
			},
			itemHoverStyle: {
				color: null
			}
		},
		tooltip: {
			formatter: function () {
				return '<b>' + this.x + '</b><br/>' +
				this.series.name + ': ' + this.y + '<br/>' +
				'Total: ' + this.point.stackTotal;
			}
		},
		plotOptions: {
			column: {
				stacking: 'normal',
				dataLabels: {
					enabled: false,
					//color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
					style: {
						textShadow: '0 0 3px black, 0 0 3px black'
					}
				}
			},
			series: {
				events: {
					legendItemClick: function () {
						return false; // <== returning false will cancel the default action
					}
				}
			}
		},

		credits: {
			enabled: false
		},
		//            scrollbar: {
		//                enabled: true
		//            },

		series: [datas.series[0],datas.series[1],datas.series[2]],
		exporting: {
			enabled: false,
			sourceWidth: 412,
			sourceHeight: 275
		}
	});
}

//function for returning customer
function callReturningCust(data) {
    $(function () {
        Highcharts.setOptions({
            global: {
                useUTC: true
            }
        });

        var returningCust = new Highcharts.Chart({
            chart: {
                renderTo: "returningCustomer",
                type: 'column',
                events: {
                    load: function (event) {
                        $("#returningCustomer").removeClass("chartLoading");
                    }
                }
            },
            title: {
                text: null,
                align: 'left',
                style: {
                    fontWeight: 'bold',
                    color: '#494b4b'
                }
            },
            xAxis: {
//                categories: data.categories,
			    categories: ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
			    tickWidth: 0,
			    lineWidth: 1,
			    tickWidth: 0,
			    title: {
				    text: null
			    },
			    labels: {
				    style:{
					    fontSize: '10px',
					    "font-family": "Franklin Gothic Book"
				    }
			    }
            },            
            yAxis: {
                lineWidth: 1,
                gridLineWidth: 0,
                tickWidth: 1,
                tickLength: 5,
                tickPosition: 'inside',
                min: 0,
                title: {
                    text: 'No. of Visitor',
                    style: {
                        fontSize: '12px',
                        "font-family": "Franklin Gothic Medium"
                    }
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontSize: '10px',
                        "font-family": "Franklin Gothic Book"
                    }
                },
                labels: {
                    style: {
                        fontSize: '10px',
                        "font-family": "Franklin Gothic Book"
                    }
                }
            },
            legend: {
                enabled: true,
                align: 'top',
                backgroundColor: '#FFFFFF',
                //borderColor: '#FFFFFF',
                //borderWidth: 1,
                layout: 'horizontal',
                verticalAlign: 'top',
                //width: 80,
                y: 20,
                x: 75,
                symbolHeight: 10,
                symbolWidth: 10,
                itemStyle: {
                    color: '#787878',
                    fontSize: '10px',
                    fontweight: 'light',
                    "cursor": "default"
                },
                itemHoverStyle: {
                    color: null
                }
            },
            tooltip: {
                formatter: function () {
                    return '<b>' + this.x + '</b><br/>' +
                    this.series.name + ': ' + this.y + '<br/>' +
                    'Total: ' + this.point.stackTotal;
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
                        style: {
                            textShadow: '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: data.series,
            exporting: {
                enabled: false,
            }
        });
    })
}


function callReturningCustomerChart(datas) {
	Highcharts.setOptions({
		global: {
			useUTC: true
		}
	});

	$('#returningCustomer').highcharts({
		chart: {
			type: 'column',
			backgroundColor: 'rgba(255, 255, 255, 0.0)',
			events: {
				load: function () {
					chartEvent[5] = this;
				}
			}
		},
		title: {
			text: null,
			align: 'left',
			x:110,
			style: {
				fontWeight: 'bold',
				color:'#494b4b'
			}
		},
		xAxis: {
			categories: datas.categories,
			//                    type: 'datetime',
			//                    dateTimeLabelFormats: { // don't display the dummy year
			//                        month: '%e. %b',
			//                        year: '%b'
			//                        day: '%e. %b'
			//                    },
			lineWidth: 1,
			tickWidth: 0,
			title: {
				text: null
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		yAxis: {
			lineWidth: 1,
			gridLineWidth: 0,
			min: 0,
			title: {
				text: 'No. of Visitor',
				style: {
					fontSize: '12px',
					"font-family": "Franklin Gothic Medium"
				}
			},
			tickWidth: 1,
			tickLength: 5,
			tickPosition: 'inside',
			stackLabels: {
				enabled: false,
				style: {
					fontWeight: 'bold',
					color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
				}
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		legend: {
			enabled: true,
			align: 'top',
			backgroundColor: '#FFFFFF',
			//borderColor: '#a6a3a3',
			layout: 'horizontal',
			verticalAlign: 'top',
			x: 160,
			y: 0,
			//width:80,
			//borderWidth: 1,
			symbolHeight:10,
			symbolWidth:10,
			itemStyle: {
				color: '#787878',
				fontSize:'10px',
				fontweight:'light',
				"cursor": "default"
			},
			itemHoverStyle: {
				color: null
			}
		},
		tooltip: {
			formatter: function () {
				return '<b>' + this.x + '</b><br/>' +
				this.series.name + ': ' + this.y + '<br/>' +
				'Total: ' + this.point.stackTotal;
			}
		},
		plotOptions: {
			column: {
				stacking: 'normal',
				dataLabels: {
					enabled: false,
					//color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
					style: {
						textShadow: '0 0 3px black, 0 0 3px black',
						"font-family": "Franklin Gothic Book"
					}
				}
			},
			series: {
				events: {
					legendItemClick: function () {
						return false; // <== returning false will cancel the default action
					}
				}
			}
		},

		credits: {
			enabled: false
		},
		//            scrollbar: {
		//                enabled: true
		//            },

		series: [{
			name: 'New',
			data: datas.newCust,
			color: '#82b4e0',
			pointWidth: 25
		}, {
			name: 'Visited last week',
			data: datas.vlwCust,
			color: '#f7a946',
			pointWidth: 25
		}, /*{
			name: 'Visited <br/>last month',
			data: datas.vlmCust,
			color: '#8dbc4b',
			pointWidth: 25
		}*/],
		exporting: {
			enabled: false,
			sourceWidth: 412,
			sourceHeight: 275
		}
	});
}

function callCrossShopping(datas) {
	$('#crossShopping').highcharts({
		chart: {
			type: 'column',
			events: {
				load: function () {
					chartEvent[6] = this;
				}
			}
		},
		title: {
			text: null,
			align: 'left',
			style: {
				fontWeight: 'bold',
				color: '#494b4b'
			}
		},
		exporting: {
			//                    buttons: {
			//                        'emailButton': {
			//                            _id: 'emailButton',
			//                            symbol: 'url(../../Content/themes/base/images/ico_email.png)',
			//                            symbolFill: 'blue',
			//                            x: -26,
			//                            onclick: function () {
			//                                alert('click!')
			//                            }
			//                        }
			//                    }
		},
		xAxis: {
			categories: ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
			tickWidth: 0,
			lineWidth: 1,
			tickWidth: 0,
			title: {
				text: null
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		yAxis: {
			min: 0,
			gridLineWidth: 0,
			lineWidth: 1,
			tickWidth: 1,
			tickLength: 5,
			tickPosition: 'inside',
			title: {
				text: 'No. of Visitor',
				style: {
					fontSize: '12px',
					"font-family": "Franklin Gothic Medium"
				}
			},
			stackLabels: {
				enabled: false
			},
			labels: {
				style:{
					fontSize: '10px',
					"font-family": "Franklin Gothic Book"
				}
			}
		},

		legend: {
			enabled: true,
			align: 'right',
			backgroundColor: '#FFFFFF',
			borderColor: '#a6a3a3',
			layout: 'vertical',
			verticalAlign: 'top',
			borderWidth: 1,
			y:40,
			x:-10,
			width: 80,
			symbolHeight: 10,
			symbolWidth: 10,
			itemStyle: {
				color: '#787878',
				fontSize: '10px',
				fontweight: 'light',
				"cursor": "default"
			},
			itemHoverStyle: {
				color: null
			}
		},
		tooltip: {
			formatter: function () {
				return '<b>' + this.x + '</b><br/>' +
					this.series.name + ': ' + this.y + '<br/>' +
					'Total: ' + this.point.stackTotal;
			}
		},
		plotOptions: {
			column: {
				stacking: 'normal',
				dataLabels: {
					enabled: true,
					color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white',
					style: {
						textShadow: '0 0 3px black, 0 0 3px black',
						"font-family": "Franklin Gothic Book"
					}
				}
			},
			series: {
				events: {
					legendItemClick: function () {
						return false; // <== returning false will cancel the default action
					}
				}
			}
		},

		credits: {
			enabled: false
		},
		series: [{
			name: 'This Store',
			color: '#864c9e',
			data: datas.stores,
			pointWidth: 25,
			dataLabels: {
				enabled: false
			},
			style: {
				fontSize: '10px',
				"font-family": "Franklin Gothic Book"
			}
		}, {
			name: '2 or more <br/>stores',
			color: '#98c93d',
			data: datas.twoOrMoreStore,
			pointWidth: 25,
			dataLabels: {
				enabled: false
			},
			style: {
				fontSize: '10px',
				"font-family": "Franklin Gothic Book"
			}
//        }, {
//            name: 'Visited <br/>Outlet & <br/>main stores',
//            color: '#2299cd',
//            data: datas.visitedOutlet,
//            pointWidth: 25,
//            dataLabels: {
//                enabled: false
//            },
//            style: {
//                fontSize: '10px',
//                "font-family": "Franklin Gothic Book"
//            }
		}],
		exporting: {
			enabled: false,
			sourceWidth: 412,
			sourceHeight: 275
		}
	});
}