/*
* slideControl - jQuery Plugin
* version: 1.2 October 2012
* @requires jQuery v1.6 or later
*
* Examples at http://nikorablin.com/slideControl
* Free to use and abuse under the MIT license.
* http://www.opensource.org/licenses/mit-license.php
*
*/
(function ($) {
    $.fn.slideControl = function (options) {

        var getTopVal = document.getElementById('zoomValue').value;
        var pushTopVal = document.getElementById('upDownValue');
        var pushBottomVal = document.getElementById('DownValue');
        var pushLeftVal = document.getElementById('leftRightValue');
        var pushRightVal = document.getElementById('RightValue');
        pushTopVal.value = getTopVal;
        pushBottomVal.value = getTopVal;
        pushLeftVal.value = getTopVal;
        pushRightVal.value = getTopVal;

        // defaults
        var defaults = {
            speed: 400,
            lowerBound: 1,
            upperBound: 10
        };

        var options = $.extend(defaults, options);

        return this.each(function () {

            // set vars
            var o = options;
            var controller = false;
            var position = 10;
            var obj = this;
            $(this).addClass('slideControlInput');
            var parent = $(this).parent();

            var label = $(parent).find('label');

            parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val() * 1 + "%\"><span class=\"slideControlHandle\" id=\"lineDragger1\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());


            var container = parent.find('.slideControlContainer');
            var fill = container.find('.slideControlFill');
            var handle = fill.find('.slideControlHandle');
            var input = parent.find('input');
            var containerWidth = container.outerWidth() + 1;
            var handleWidth = $(handle).outerWidth();
            var offset = $(container).offset();
            var animate = function (value) { $(fill).animate({ width: value + "%" }, o.speed); }

            $(window).resize(function () {
                offset = $(container).offset();
            })

            //adds shadow class to handle for IE <9
            if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
                handle.addClass('ieShadow');
            }

            // when user clicks anywhere on the slider
            $(container).click(function (e) {
                //document.getElementById('applyBtnBS').disabled = false;
                e.preventDefault();
                position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));

                $(input).val(position / 1);
                var outLineVal = parseInt(document.getElementById('outLineValue').value);
                var inLineVal = parseInt(document.getElementById('inLineValue').value);
                var maskTopValue = parseInt(document.getElementById('maskTopValue').value);
                //prevent line overlap each other
                if ((position - 1) > (outLineVal - 5)) {
                    document.getElementById('maskingLineIn').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                    //document.getElementById('liveViewMaskingLineIn').style.height = outLineVal - 5 + "%";
                    document.getElementById('maskingLineGreenBlink').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                    //document.getElementById('liveViewMaskingLineGreenBlink').style.height = outLineVal - 5 + "%";
                    var changeValue = document.getElementById('inLineValue');
                    changeValue.value = (outLineVal - 5);
                    animate(outLineVal - 5);

                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    //console.log(countingLineHeight);
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";


                } else if (inLineVal > maskTopValue && inLineVal < (outLineVal - 5)) {

                    document.getElementById('maskingLineIn').style.height = ((position - 1) / 100) * 240 + "px";
                    //document.getElementById('liveViewMaskingLineIn').style.height = ((position - 1) / 100) * 240 + "px";
                    document.getElementById('maskingLineGreenBlink').style.height = ((position - 1) / 100) * 240 + "px";
                    //document.getElementById('liveViewMaskingLineGreenBlink').style.height = p((position - 1) / 100) * 240 + "px";
                    animate(position);

                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    //console.log(countingLineHeight);
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";


                } else {
                    //console.log("over counting area top line");
                    var setLine1 = document.getElementById('maskTopValue').value;
                    document.getElementById('maskingLineIn').style.height = ((parseInt(setLine1) / 100) * 240) + 2 + "px";
                    document.getElementById('inLineValue').value = parseInt(document.getElementById('maskTopValue').value) + 1;
                    document.getElementById('maskingLineGreenBlink').style.height = ((parseInt(setLine1) / 100) * 240) + 2 + "px";
                    //document.getElementById('liveViewMaskingLineIn').style.height = maskTopValue + 2 + "%";
                    //document.getElementById('liveViewMaskingLineGreenBlink').style.height = maskTopValue + 2 + "%";
                    $(fill).width(setLine1 + "%");

                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                }
                // document.getElementById('applyBtnBS').className = "btn_black";
            });

            // when user clicks handle
            $(handle).mousedown(function (e) {

                //document.getElementById("applyBtnBS").disabled = false;
                e.preventDefault();
                controller = true;

                $(document).mousemove(function (e) {
                    e.preventDefault();
                    position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                   // console.log(position);
                    var getCurrentInVal = parseInt(document.getElementById('inLineValue').value);
                    //alert(getCurrentInVal);
                    if (controller) {
                        $(fill).width(position + "%");
                        //$(input).val(position);
                        document.getElementById('inLineValue').value = position;
                        var outLineVal = parseInt(document.getElementById('outLineValue').value);
                        var inLineVal = parseInt(document.getElementById('inLineValue').value);
                        var currentMaskTopValue = parseInt(document.getElementById('maskTopValue').value);
                        //prevent line overlap each other
                        if ((position - 1) > (outLineVal - 5)) {
                            document.getElementById('maskingLineIn').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineIn').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                            document.getElementById('maskingLineGreenBlink').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                            var changeValue = document.getElementById('inLineValue');
                            changeValue.value = outLineVal - 5;
                            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                            //console.log(countingLineHeight);
                            document.getElementById('countingLine').style.height = countingLineHeight + "px";
                            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";

                        } else if (getCurrentInVal > (currentMaskTopValue + 2)) {

                            //console.log("hit");
                            document.getElementById('maskingLineIn').style.height = (position / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineIn').style.height = (position / 100) * 240 + "px";
                            document.getElementById('maskingLineGreenBlink').style.height = (position / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineGreenBlink').style.height = (position / 100) * 240 + "px";
                            var changeValue = document.getElementById('inLineValue');
                            changeValue.value = position;

                            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                            //console.log(countingLineHeight);
                            document.getElementById('countingLine').style.height = countingLineHeight + "px";
                            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";



                        } else {
                            //console.log("smaller than counting area top");
                            //$(fill).width(currentMaskTopValue + "%");
                            //document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentMaskTopValue + "%";
                            document.getElementById('maskingLineIn').style.height = ((parseInt(currentMaskTopValue) / 100) * 240) + 2 + "px";
                            document.getElementById('inLineValue').value = parseInt(currentMaskTopValue) + 1;
                            document.getElementById('maskingLineGreenBlink').style.height = ((parseInt(currentMaskTopValue) / 100) * 240) + 2 + "px";

                        }


                    }
                    // document.getElementById('applyBtnBS').className = "btn_black";

                });

                $(document).mouseup(function () {
                    var outLineVal = parseInt(document.getElementById('outLineValue').value);
                    var inLineVal = parseInt(document.getElementById('inLineValue').value);
                    var maskTopValue = parseInt((document.getElementById('maskTopValue').value));
                    if (inLineVal >= (outLineVal - 5)) {
                        //alert("overlap");
                        e.preventDefault();

                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = outLineVal + "%";
                        document.getElementById('maskingLineIn').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('maskingLineGreenBlink').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = inLineVal + "%";

                        var countingLine = (document.getElementById('outLineValue').value) - (document.getElementById('inLineValue').value);

                        //alert(countingLine);
                    } else if (inLineVal > maskTopValue) {

                        //document.getElementById('inLineValue').value = position;
                        // document.getElementById('applyBtnBS').className = "btn_black";

                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        //document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = (position - 10) + "%";
                    } else {
                        //console.log("over top line");
                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = (maskTopValue + 1) + "%";
                        document.getElementById('inLineValue').value = maskTopValue + 1;
                        document.getElementById('countingLine').style.height = (maskTopValue + 1) + "%";
                        document.getElementById('countingLine').style.marginTop = ((maskTopValue / 100) * 240) + 2 + "px";
                        document.getElementById('liveViewCountingLine').style.height = (maskTopValue + 1) + "%";
                        document.getElementById('liveViewCountingLine').style.marginTop = (maskTopValue + 1) + "%";
                        document.getElementById('maskingLineIn').style.height = ((maskTopValue / 100) * 240) + 2 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = maskTopValue + 2 + "%";
                        document.getElementById('maskingLineGreenBlink').style.height = maskTopValue + 2 + "%";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = maskTopValue + 2 + "%";


                    }

                    controller = false;


                    //alert(countingLine);
                });
            });

            // when user changes value in input
            $(input).change(function () {
                //alert("hit");
                //document.getElementById('applyBtnBS').disabled = false;
                //document.getElementById('applyBtnBS').className = "btn_black";
                //modify IN Line value
                var inCurrentValue = parseInt(document.getElementById('inLineValue').value);
                var maskTopValue = parseInt(document.getElementById('maskTopValue').value);
                var newInValue = inCurrentValue;
                if (newInValue < 100 && newInValue >= 0) {
                    //alert("newInValue < 100 && newInValue >= 0");
                    var outLineVal = parseInt(document.getElementById('outLineValue').value);
                    var inLineVal = document.getElementById('inLineValue').value;

                    if (inLineVal >= (outLineVal - 5)) {
                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = outLineVal + "%";
                        document.getElementById('maskingLineIn').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                        document.getElementById('maskingLineGreenBlink').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((outLineVal - 5) / 100) * 240 + "px";
                        var changeValue = document.getElementById('inLineValue');
                        changeValue.value = outLineVal - 5;
                        //alert("IN Line value cannot be more than OUT Line value.");

                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    } else if (inCurrentValue > maskTopValue) {
                        //alert(inCurrentValue);

                        document.getElementById('maskingLineIn').style.height = ((newInValue - 1) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = ((newInValue - 1) / 100) * 240 + "px";
                        document.getElementById('maskingLineGreenBlink').style.height = ((newInValue - 1) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((newInValue - 1) / 100) * 240 + "px";
                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = newInValue + "%";


                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    } else if (inCurrentValue < maskTopValue) {
                        var currentMaskTopVal = parseInt(document.getElementById('maskTopValue').value);
                        //alert(currentMaskTopVal);
                        document.getElementById('inLineValue').value = currentMaskTopVal + 1;
                        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = (currentMaskTopVal + 1) + "%";
                        document.getElementById('maskingLineIn').style.height = ((currentMaskTopVal + 1) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = ((currentMaskTopVal + 2) / 100) * 240 + "px";
                        document.getElementById('maskingLineGreenBlink').style.height = ((currentMaskTopVal + 1) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((currentMaskTopVal + 2) / 100) * 240 + "px";

                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        //                        
                    }

                } else {
                    //alert("Out of range");

                }

                //modify OUT Line value
                var outCurrentValue = document.getElementById('outLineValue').value;
                var newOutValue = outCurrentValue;
                if (newOutValue <= 100 && newOutValue >= 0) {
                    document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue + "%";

                } else {
                    alert("Out of range");
                }

                //modify sensitivity value
                var sensitivityCurrentValue = document.getElementById('sensitivityValue').value;
                var newSensitivityValue = sensitivityCurrentValue;
                if (newSensitivityValue <= 100 && newSensitivityValue >= 0) {
                    document.getElementById('sensitivityCell').getElementsByClassName("slideControlFill")[0].style.width = newSensitivityValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify zoom value
                var zoomCurrentValue = document.getElementById('zoomValue').value;
                var newZoomValue = zoomCurrentValue;
                if (newZoomValue <= 100 && newZoomValue >= 0) {
                    document.getElementById('zoomCell').getElementsByClassName("slideControlFill")[0].style.width = newZoomValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify up/down value
                var upDownCurrentValue = document.getElementById('upDownValue').value;
                var newUpDownValue = upDownCurrentValue;
                if (newUpDownValue <= 100 && newUpDownValue >= 0) {
                    //document.getElementById('upDownCell').getElementsByClassName("slideControlFill")[0].style.width = newUpDownValue +"%";
                } else {
                    alert("Out of range");
                }

                //modify left/right value
                var leftRightCurrentValue = document.getElementById('leftRightValue').value;
                var newLeftRightValue = leftRightCurrentValue;
                if (newLeftRightValue <= 100 && newLeftRightValue >= 0) {
                    //document.getElementById('leftRightCell').getElementsByClassName("slideControlFill")[0].style.width = newLeftRightValue +"%";
                } else {
                    alert("Out of range");
                }

                //modify maskTop value
                var maskTopCurrentValue = document.getElementById('maskTopValue').value;
                var newmaskTopValue = maskTopCurrentValue;
                if (newmaskTopValue <= 100 && newmaskTopValue >= 0) {
                    document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = newmaskTopValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify maskBottom value
                var maskBottomCurrentValue = document.getElementById('maskBottomValue').value;
                var newmaskBottomValue = maskBottomCurrentValue;
                if (newmaskBottomValue <= 100 && newmaskBottomValue >= 0) {
                    document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = newmaskBottomValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify maskLeft value
                var maskLeftCurrentValue = document.getElementById('maskLeftValue').value;
                var newmaskLeftValue = maskLeftCurrentValue;
                if (newmaskLeftValue <= 100 && newmaskLeftValue >= 0) {
                    document.getElementById('maskLeftCell').getElementsByClassName("slideControlFill")[0].style.width = newmaskLeftValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify maskRight value
                var maskRightCurrentValue = document.getElementById('maskRightValue').value;
                var newmaskRightValue = maskRightCurrentValue;
                if (newmaskRightValue <= 100 && newmaskRightValue >= 0) {
                    document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = newmaskRightValue + "%";
                } else {
                    alert("Out of range");
                }

                //modify dissolve value
                var dissolveCurrentValue = document.getElementById('dissolveValue').value;
                var newDissolveValue = dissolveCurrentValue;
                if (newDissolveValue <= 100 && newDissolveValue >= 0) {
                    document.getElementById('objectDissolveCell').getElementsByClassName("slideControlFill")[0].style.width = newDissolveValue + "%";
                } else {
                    alert("Out of range");
                }


            });



        });





        // checks if value is within boundaries
        function checkBoundaries(value) {
            if (value < options.lowerBound * 0)
                return options.lowerBound * 0;
            else if (value > options.upperBound * 10)
                return options.upperBound * 10;
            else
                return value;
        }

        // checks ie version
        function getInternetExplorerVersion() {
            var rv = -1;
            if (navigator.appName == 'Microsoft Internet Explorer') {
                var ua = navigator.userAgent;
                var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                if (re.exec(ua) != null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
        }
        return this;
    }
})(jQuery);

//in line minus button
function inLineMinusBtn() {
    //document.getElementById('applyBtnBS').disabled = false;
    var currentInValue = parseInt(document.getElementById('inLineValue').value);
    var maskTopVal = parseInt(document.getElementById('maskTopValue').value);
    if (currentInValue > 0 && currentInValue > (maskTopVal + 1)) {

        currentInValue--;
        var value = currentInValue;
        changeValue = document.getElementById('inLineValue');
        changeValue.value = currentInValue;
        document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentInValue + "%";
        document.getElementById('maskingLineIn').style.height = ((currentInValue + 0) / 100) * 240 + "px";
        document.getElementById('liveViewMaskingLineIn').style.height = ((currentInValue + 0) / 100) * 240 + "px";
        document.getElementById('maskingLineGreenBlink').style.height = ((currentInValue + 0) / 100) * 240 + "px";
        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((currentInValue + 0) / 100) * 240 + "px";

        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
        //console.log(countingLineHeight);
        document.getElementById('countingLine').style.height = countingLineHeight + "px";
        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
    } else {
        //changeValue = document.getElementById('inLineValue');

    }
 //   document.getElementById('applyBtnBS').className = "btn_black";

}

//in line add button
function inLineAdd() {
    //document.getElementById('applyBtnBS').disabled = false;
    var currentValue = document.getElementById('inLineValue').value;
    if (currentValue < 100) {
        currentValue++;
        var outLineVal = parseInt(document.getElementById('outLineValue').value);
        var inLineVal = parseInt(document.getElementById('inLineValue').value);
        if (currentValue >= outLineVal) {
            //alert("IN Line value cannot be more than OUT Line value.");
        } else if (currentValue <= (outLineVal - 5)) {
            changeValue = document.getElementById('inLineValue');
            changeValue.value = currentValue;
            document.getElementById('inLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
            document.getElementById('maskingLineIn').style.height = ((currentValue - 1) / 100) * 240 + "px";
            document.getElementById('liveViewMaskingLineIn').style.height = ((currentValue - 1) / 100) * 240 + "px";
            document.getElementById('maskingLineGreenBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
            document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
            //alert(currentValue);

            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
            //console.log(countingLineHeight);
            document.getElementById('countingLine').style.height = countingLineHeight + "px";
            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
        }


    }
    //document.getElementById('applyBtnBS').className = "btn_black";
}

//out line minus button
function outLineMinus() {
    //document.getElementById('applyBtnBS').disabled = false;
    //document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = document.getElementById('outLineValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('outLineValue');
        changeValue.value = currentValue;
        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('maskingLineOut').style.height = currentValue - 1 + "%";


    }

}

//out line add button
function outLineAdd() {
    //document.getElementById('applyBtnBS').disabled = false;
    //document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = parseInt(document.getElementById('outLineValue').value);

    if (currentValue < 100) {
        currentValue++;
        changeValue = document.getElementById('outLineValue');
        changeValue.value = currentValue;
        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('maskingLineOut').style.height = currentValue - 1 + "%";

        var countingLineHeight = (document.getElementById('outLineValue').value) - (document.getElementById('inLineValue').value);


    }
}

//sensitivity minus button
function sensitivityMinus() {
   // document.getElementById('applyBtnBS').disabled = false;
   // document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = document.getElementById('sensitivityValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('sensitivityValue');
        changeValue.value = currentValue;
        document.getElementById('sensitivityCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }

}

//sensitivity add button
function sensitivityAdd() {
  //  document.getElementById('applyBtnBS').disabled = false;
   // document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = document.getElementById('sensitivityValue').value;
    if (currentValue < 100) {
        currentValue++;

        changeValue = document.getElementById('sensitivityValue');
        changeValue.value = currentValue;
        document.getElementById('sensitivityCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }
}

//cam height minus button
function camHeightMinus() {
    //document.getElementById('applyBtnBS').disabled = false;
    //document.getElementById('applyBtnBS').className = "btn_black";
    var camHeight = document.getElementById('camHeightValue').value;
    if (camHeight > 0) {
        var currentValue = parseFloat(camHeight);
        currentValue -= 1;
        var value = currentValue;
        changeValue = document.getElementById('camHeightValue');
        changeValue.value = parseFloat(currentValue).toFixed(1);
        document.getElementById('camHeightCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }

}

//cam height add button
function camHeightAdd() {
   // document.getElementById('applyBtnBS').disabled = false;
   // document.getElementById('applyBtnBS').className = "btn_black";
    var camHeight = document.getElementById('camHeightValue').value;
    //alert(camHeight);
    if (camHeight < 10) {
        var currentValue = parseFloat(camHeight);

        currentValue += 1;
        changeValue = document.getElementById('camHeightValue');
        changeValue.value = parseFloat(currentValue).toFixed(1);
        document.getElementById('camHeightCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }
}

//zoom minus button
function zoomMinus() {
   // document.getElementById('applyBtnVA').disabled = false;
   // document.getElementById('resetBtnVA').disabled = false;
   // document.getElementById('applyBtnVA').className = "btn_black";
   // document.getElementById('resetBtnVA').className = "btn_black";
    var currentValue = document.getElementById('zoomValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('zoomValue');
        changeValue.value = currentValue;
        document.getElementById('zoomCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('zoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomRight').style.borderRight = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";

        var changeValue = document.getElementById('upDownValue');
        var changeBottomValue = document.getElementById('DownValue');
        var changeLeftValue = document.getElementById('leftRightValue');
        var changeRightValue = document.getElementById('RightValue');
        changeValue.value = currentValue;
        changeBottomValue.value = currentValue;
        changeLeftValue.value = currentValue;
        changeRightValue.value = currentValue;
    }

}

//zoom add button
function zoomAdd() {
 //   document.getElementById('applyBtnVA').disabled = false;
 //   document.getElementById('resetBtnVA').disabled = false;
  //  document.getElementById('resetBtnVA').className = "btn_black";
  //  document.getElementById('applyBtnVA').className = "btn_black";
    var currentValue = document.getElementById('zoomValue').value;
    if (currentValue < 100) {
        currentValue++;
        changeValue = document.getElementById('zoomValue');
        changeValue.value = currentValue;
        document.getElementById('zoomCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('zoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomRight').style.borderRight = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        var changeValue = document.getElementById('upDownValue');
        var changeBottomValue = document.getElementById('DownValue');
        var changeLeftValue = document.getElementById('leftRightValue');
        var changeRightValue = document.getElementById('RightValue');
        changeValue.value = currentValue;
        changeBottomValue.value = currentValue;
        changeLeftValue.value = currentValue;
        changeRightValue.value = currentValue;
    }
}

//Up/Down minus button
function moveDown() {
   // document.getElementById('applyBtnVA').disabled = false;
  //  document.getElementById('resetBtnVA').disabled = false;
  //  document.getElementById('applyBtnVA').className = "btn_black";
  //  document.getElementById('resetBtnVA').className = "btn_black";
    var currentValue = parseInt(document.getElementById('upDownValue').value);
    var currentBottomValue = parseInt(document.getElementById('DownValue').value);
    if (currentBottomValue >= 3) {
        currentValue += 3;
        currentBottomValue -= 3;
        //alert(currentValue);
        changeValue = document.getElementById('upDownValue');
        changeValue.value = currentValue;
        changeValue = document.getElementById('DownValue');
        changeValue.value = currentBottomValue;
        document.getElementById('zoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomBottom').style.borderBottom = (((currentBottomValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomBottom').style.borderBottom = (((currentBottomValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
    } else {
        //alert("Reach bottom");
    }
}

//Up/Down add button

function moveUp() {
   // document.getElementById('applyBtnVA').disabled = false;
  //  document.getElementById('resetBtnVA').disabled = false;
  //  document.getElementById('applyBtnVA').className = "btn_black";
  //  document.getElementById('resetBtnVA').className = "btn_black";
    var currentValue = parseInt(document.getElementById('upDownValue').value);
    var currentBottomValue = parseInt(document.getElementById('DownValue').value);
    if (currentValue >= 3) {
        currentValue -= 3;
        currentBottomValue += 3;
        //alert(currentValue);
        changeValue = document.getElementById('upDownValue');
        changeValue.value = currentValue;
        changeValue = document.getElementById('DownValue');
        changeValue.value = currentBottomValue;
        document.getElementById('zoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomBottom').style.borderBottom = (((currentBottomValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomBottom').style.borderBottom = (((currentBottomValue / 240) * 100)) * 2.88 + "px solid rgba(255, 0, 0, 0.5)";
    } else {
        //alert("Reach top");
    }



}

//Left/Right minus button
function moveLeft() {
   // document.getElementById('applyBtnVA').disabled = false;
   // document.getElementById('resetBtnVA').disabled = false;
  //  document.getElementById('applyBtnVA').className = "btn_black";
  //  document.getElementById('resetBtnVA').className = "btn_black";
    var currentValue = parseInt(document.getElementById('leftRightValue').value);
    var currentRightValue = parseInt(document.getElementById('RightValue').value);
    if (currentValue >= 3) {
        currentValue -= 3;
        currentRightValue += 3;
        //alert(currentValue);
        changeValue = document.getElementById('leftRightValue');
        changeValue.value = currentValue;
        changeValue = document.getElementById('RightValue');
        changeValue.value = currentRightValue;
        document.getElementById('zoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomRight').style.borderRight = (((currentRightValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomRight').style.borderRight = (((currentRightValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
    }

    else {
        //alert("Reach left");
    }

}

//Left/Right add button
function moveRight() {
//    document.getElementById('applyBtnVA').disabled = false;
//    document.getElementById('resetBtnVA').disabled = false;
    // document.getElementById('applyBtnVA').className = "btn_black";
    // document.getElementById('resetBtnVA').className = "btn_black";
    var currentValue = parseInt(document.getElementById('leftRightValue').value);
    var currentRightValue = parseInt(document.getElementById('RightValue').value);
    if (currentRightValue >= 3) {
        currentValue += 3;
        currentRightValue -= 3;
        //alert(currentValue);
        changeValue = document.getElementById('leftRightValue');
        changeValue.value = currentValue;
        changeValue = document.getElementById('RightValue');
        changeValue.value = currentRightValue;
        document.getElementById('zoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('zoomRight').style.borderRight = (((currentRightValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";
        document.getElementById('liveViewZoomRight').style.borderRight = (((currentRightValue / 320) * 100)) * 5.12 + "px solid rgba(255, 0, 0, 0.5)";

    }
    else {
        //alert("Reach left");
    }
}

//maskTop minus button
function maskTopMinus() {
    // document.getElementById('applyBtnCA').disabled = false;
    //   document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskTopValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('maskTopValue');
        changeValue.value = currentValue;
        document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        //document.getElementById('maskZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 5.76 + "px solid rgba(37, 37, 37, 0.5)";
        //document.getElementById('liveViewMaskZoomTop').style.borderTop = (((currentValue / 240) * 100)) * 5.76 + "px solid rgba(37, 37, 37, 0.5)";
        var line1Val = document.getElementById('inLineValue').value;
        if (currentValue < line1Val) {
            document.getElementById('maskZoomTop').style.height = (currentValue/100)*240 + "px";
            document.getElementById('liveViewMaskZoomTop').style.height = (currentValue / 100) * 240 + "px";

            //set mask left and right height
            var leftRightMaskHeight = parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value);

            //set mask left and right position
            var line1pos = parseInt(document.getElementById('maskTopValue').value);
            var maskTopLinePos = (line1pos / 100) * 240;
            //console.log(line1pos);

            document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 3.2) + "px";
            document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('maskZoomLeft').style.height = (leftRightMaskHeight - 1) + "%";
            document.getElementById('liveViewMaskZoomLeft').style.height = (leftRightMaskHeight - 1) + "%";
            document.getElementById('maskZoomRight').style.height = (leftRightMaskHeight - 1) + "%";
            document.getElementById('liveViewMaskZoomRight').style.height = (leftRightMaskHeight - 1) + "%";



        } else {
            //alert("Over line 1");
            document.getElementById('maskTopValue').value = line1Val;
            document.getElementById('maskZoomTop').style.height = (line1Val/100)*240 + "px";
            document.getElementById('liveViewMaskZoomTop').style.height = (line1Val / 100) * 240 + "px";
        }
    }
}

//maskTop add button
function maskTopAdd() {
    //  document.getElementById('applyBtnCA').disabled = false;
    //document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskTopValue').value;
    currentValue++;
    changeValue = document.getElementById('maskTopValue');
    document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    var line1Val = document.getElementById('inLineValue').value;
    if (currentValue < (line1Val - 1)) {
        changeValue.value = currentValue;


        document.getElementById('maskZoomTop').style.height = (currentValue/100)*240 + "px";
        document.getElementById('liveViewMaskZoomTop').style.height = (currentValue / 100) * 240 + "px";

        //set mask left and right height
        var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

        //set mask left and right position
        var line1pos = parseInt(document.getElementById('maskTopValue').value);
        var maskTopLinePos = (line1pos / 100) * 240;
        //console.log(line1pos);

        document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

    } else {
        //alert("Over line 1");

        document.getElementById('maskTopValue').value = line1Val - 1;
        document.getElementById('maskZoomTop').style.height = ((line1Val - 2)/100)*240 + "px";
        document.getElementById('liveViewMaskZoomTop').style.height = ((line1Val - 2) / 100) * 240 + "px";
        document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = (line1Val - 2) + "%";
    }
    //}


    // }
}

//maskBottom minus button
function maskBottomMinus() {
    //document.getElementById('applyBtnCA').disabled = false;
    //document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskBottomValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('maskBottomValue');

        document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        //document.getElementById('maskZoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 5.76 + "px solid rgba(37, 37, 37, 0.5)";
        //document.getElementById('liveViewMaskZoomBottom').style.borderBottom = (((currentValue / 240) * 100)) * 5.76 + "px solid rgba(37, 37, 37, 0.5)";
        var outLineValue = parseInt(document.getElementById('outLineValue').value);
        if (currentValue > (outLineValue)) {
            document.getElementById('maskZoomBottom').style.height = ((currentValue + 1)/100)*240 + "px";
            document.getElementById('liveViewMaskZoomBottom').style.height = ((currentValue + 1) / 100) * 240 + "px";
            changeValue.value = currentValue;

            //set mask left and right height
            var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 2 + "px";

            //set mask left and right position
            var line1pos = parseInt(document.getElementById('maskTopValue').value);
            var maskTopLinePos = (line1pos / 100) * 240;
            //console.log(line1pos);

            document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
            document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
            document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
            document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
            document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;



        } else {
            //alert("Over line 1");
            document.getElementById('maskBottomValue').value = currentValue + 1;
            document.getElementById('maskZoomBottom').style.height = ((outLineValue + 2)/100)*240 + "px";
            document.getElementById('liveViewMaskZoomBottom').style.height = ((outLineValue + 2) / 100) * 240 + "px";
        }
    }
}

//maskBottom add button
function maskBottomAdd() {
    //document.getElementById('applyBtnCA').disabled = false;
    //document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskBottomValue').value;
    currentValue++;

    changeValue = document.getElementById('maskBottomValue');
    var outLineValue = parseInt(document.getElementById('outLineValue').value);
    //alert(outLineValue);
    if (currentValue > outLineValue && currentValue <= 100) {
        document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        //alert("in");
        document.getElementById('maskZoomBottom').style.height = (currentValue/100)*240 + "px";
        document.getElementById('liveViewMaskZoomBottom').style.height = (currentValue / 100) * 240 + "px";
        changeValue.value = currentValue;

        //set mask left and right height
        var leftRightMaskHeight = (parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) + 1;

        //set mask left and right position
        var line1pos = parseInt(document.getElementById('maskTopValue').value);
        var maskTopLinePos = (line1pos / 100) * 240;
        //console.log(line1pos);

        document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
        document.getElementById('maskZoomLeft').style.height = (leftRightMaskHeight - 2) + "%";
        document.getElementById('liveViewMaskZoomLeft').style.height = (leftRightMaskHeight - 2) + "%";
        document.getElementById('maskZoomRight').style.height = (leftRightMaskHeight - 2) + "%";
        document.getElementById('liveViewMaskZoomRight').style.height = (leftRightMaskHeight - 2) + "%";



    } else if (currentValue > outLineValue && currentValue > 100) {
        document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = 100 + "%";
        //alert("over");
        document.getElementById('maskBottomValue').value = 100;
        document.getElementById('maskZoomBottom').style.height = 100 + "%";
        document.getElementById('liveViewMaskZoomBottom').style.height = 100 + "%";
    }
}

//maskLeft minus button
function maskLeftMinus() {
   // document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskLeftValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('maskLeftValue');
        changeValue.value = currentValue;
        document.getElementById('maskLeftCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('maskZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
        document.getElementById('liveViewMaskZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
    }
}

//maskLeft add button
function maskLeftAdd() {
   // document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskLeftValue').value;
    var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);
    if (currentValue < 100) {
        if (overlapVal >= 100) {
            //alert("Overlap");
        } else {
            currentValue++;

            changeValue = document.getElementById('maskLeftValue');
            changeValue.value = currentValue;
            document.getElementById('maskLeftCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
            document.getElementById('maskZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
            document.getElementById('liveViewMaskZoomLeft').style.borderLeft = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
        }
    }
}

//maskRight minus button
function maskRightMinus() {
   // document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskRightValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('maskRightValue');
        changeValue.value = currentValue;
        document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('maskZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
        document.getElementById('liveViewMaskZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
    }
}

//maskRight add button
function maskRightAdd() {
    //document.getElementById('applyBtnCA').className = "btn_black";
    var currentValue = document.getElementById('maskRightValue').value;
    var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);

    if (currentValue < 100) {
        if (overlapVal >= 100) {
            //alert("Overlap");
        } else {
            currentValue++;

            changeValue = document.getElementById('maskRightValue');
            changeValue.value = currentValue;
            document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
            document.getElementById('maskZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
            document.getElementById('liveViewMaskZoomRight').style.borderRight = (((currentValue / 320) * 100)) * 10.24 + "px solid rgba(0, 0, 0, 0.67)";
        }
    }
}

//dissolve minus button
function dissolveMinus() {
    //document.getElementById("applyBtnWB").disabled = false;
    //document.getElementById('applyBtnWB').className = "btn_black";
    var currentValue = document.getElementById('dissolveValue').value;
    if (currentValue > 0) {
        currentValue--;
        var value = currentValue;
        changeValue = document.getElementById('dissolveValue');
        changeValue.value = currentValue;
        document.getElementById('objectDissolveCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }
}

//dissolve add button
function dissolveAdd() {
    //document.getElementById("applyBtnWB").disabled = false;
    //document.getElementById('applyBtnWB').className = "btn_black";
    var currentValue = document.getElementById('dissolveValue').value;
    if (currentValue < 100) {
        currentValue++;

        changeValue = document.getElementById('dissolveValue');
        changeValue.value = currentValue;
        document.getElementById('objectDissolveCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }
}




