/*
* slideControl2 - jQuery Plugin
* version: 1.2 October 2012
* @requires jQuery v1.6 or later
*
* Examples at http://nikorablin.com/slideControl2
* Free to use and abuse under the MIT license.
* http://www.opensource.org/licenses/mit-license.php
*
*/
(function ($) {
    $.fn.slideControl2 = function (options) {

        // defaults
        var defaults = {
            speed: 400,
            lowerBound: 1,
            upperBound: 10
        };

        var options = $.extend(defaults, options);

        return this.each(function () {

            // set vars
            var o = options;
            var controller = false;
            var position = 10;
            var obj = this;
            $(this).addClass('slideControlInput');
            var parent = $(this).parent();

            var label = $(parent).find('label');

            parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill2\" style=\"width:" + $(obj).val() * 1 + "%\"><span class=\"slideControlHandle\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());


            var container = parent.find('.slideControlContainer');
            var fill = container.find('.slideControlFill2');
            var handle = fill.find('.slideControlHandle');
            var input = parent.find('input');
            var containerWidth = container.outerWidth() + 1;
            var handleWidth = $(handle).outerWidth();
            var offset = $(container).offset();
            var animate = function (value) { $(fill).animate({ width: value + "%" }, o.speed); }

            $(window).resize(function () {
                offset = $(container).offset();
            })

            //adds shadow class to handle for IE <9
            if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
                handle.addClass('ieShadow');
            }

            // when user clicks anywhere on the slider
            $(container).click(function (e) {
				//document.getElementById('applyBtnBS').disabled = false; 
                //document.getElementById('applyBtnBS').className = "btn_black";
                e.preventDefault();
                position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                animate(position);
                $(input).val(position / 1);
                //get preset shoulder width
                var getDefaultPercentage = parseFloat(($("#shoulderWidthImg").width() / 282) * 100).toFixed(0);
                var shoulderWidth = parseFloat(document.getElementById('hiddenShoulderWidth').value);
                document.getElementById('hiddenShoulderWidth').value = position;
                document.getElementById('shoulderWidthDiv').style.display = "block";
                //document.getElementById('liveViewShoulderWidthDiv').style.display = "block";
                document.getElementById('shoulderWidthImg').style.width = ((position * 0.66667)) + 30 + "%";
                //document.getElementById('liveViewShoulderWidthImg').style.width = ((position * 0.66667)) + 30 + "%";
            });

            // when user clicks handle
            $(handle).mousedown(function (e) {
                //document.getElementById('applyBtnBS').disabled = false; 
                //     document.getElementById('applyBtnBS').className = "btn_black";
                e.preventDefault();
                controller = true;
                $(document).mousemove(function (e) {
                    e.preventDefault();
                    position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100)); //change this to 10
                    if (controller) {
                        $(fill).width(position + "%");
                        $(input).val(position / 1);

                        //get preset shoulder width
                        var getDefaultPercentage = parseFloat(($("#shoulderWidthImg").width() / 282) * 100).toFixed(0);
                        var shoulderWidth = parseFloat(document.getElementById('hiddenShoulderWidth').value);
                        document.getElementById('hiddenShoulderWidth').value = position;
                        document.getElementById('shoulderWidthDiv').style.display = "block";
                        //document.getElementById('liveViewShoulderWidthDiv').style.display = "block";
                        document.getElementById('shoulderWidthImg').style.width = ((position * 0.66667)) + 30 + "%";
                        //document.getElementById('liveViewShoulderWidthImg').style.width = ((position * 0.66667)) + 30 + "%";



                    }
                });
                $(document).mouseup(function () {
                    e.preventDefault();
                    controller = false;
                    setTimeout(function () {
                        $('#shoulderWidthDiv').fadeOut('fast');
                        //$('#liveViewShoulderWidthDiv').fadeOut('fast');
                    }, 1000);

                });
            });

            // when user changes value in input
            $(input).change(function () {
                //document.getElementById('applyBtnBS').disabled = false; 
                //document.getElementById('applyBtnBS').className = "btn_black";
                //modify cam height value
                var camHeightCurrentValue = document.getElementById('camHeightValue').value;
                var newCamHeightValue = camHeightCurrentValue;
                if (newCamHeightValue <= 100 && newCamHeightValue >= 0) {
                    document.getElementById('camHeightCell').getElementsByClassName("slideControlFill2")[0].style.width = (newCamHeightValue * 1) + "%";
                    var camHeightValue = document.getElementById('camHeightValue').value;
                    //get preset shoulder width
                    var getDefaultPercentage = parseFloat(($("#shoulderWidthImg").width() / 282) * 100).toFixed(0);
                    var shoulderWidth = parseFloat(document.getElementById('hiddenShoulderWidth').value);
                    //document.getElementById('hiddenShoulderWidth').value = position;
                    document.getElementById('shoulderWidthDiv').style.display = "block";
                    //document.getElementById('liveViewShoulderWidthDiv').style.display = "block";
                    document.getElementById('shoulderWidthImg').style.width = ((camHeightValue * 0.66667)) + 30 + "%";
                    //document.getElementById('liveViewShoulderWidthImg').style.width = ((camHeightValue * 0.66667)) + 30 + "%";

                    setTimeout(function () {
                        $('#shoulderWidthDiv').fadeOut('fast');
                        //$('#liveViewShoulderWidthDiv').fadeOut('fast');
                    }, 1000);
                } else {
                    //alert("Out of range");
                }
            });



        });

        // checks if value is within boundaries
        function checkBoundaries(value) {
            if (value < options.lowerBound * 0)
                return options.lowerBound * 0;
            else if (value > options.upperBound * 10)
                return options.upperBound * 10;
            else
                return value;
        }

        // checks ie version
        function getInternetExplorerVersion() {
            var rv = -1;
            if (navigator.appName == 'Microsoft Internet Explorer') {
                var ua = navigator.userAgent;
                var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                if (re.exec(ua) != null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
        }
        return this;
    }


})(jQuery);


//cam height add button
function camHeightAdd() {
    //document.getElementById('applyBtnBS').disabled = false; 
    //get preset shoulder width
    var getDefaultPercentage = parseFloat(($("#shoulderWidthImg").width() / 282) * 100).toFixed(0);
    var shoulderWidth = parseFloat(document.getElementById('hiddenShoulderWidth').value);
    //document.getElementById('applyBtnBS').className = "btn_black";
    var camHeight = document.getElementById('camHeightValue').value;
    if (camHeight < 100) {
        var currentValue = parseFloat(camHeight);
        currentValue += 1;
        changeValue = document.getElementById('camHeightValue');
        changeValue.value = parseFloat(currentValue);
        document.getElementById('camHeightCell').getElementsByClassName("slideControlFill2")[0].style.width = (currentValue * 1) + "%";
        shoulderWidth += 0.6667;
        document.getElementById('shoulderWidthDiv').style.display = "block";
        //document.getElementById('liveViewShoulderWidthDiv').style.display = "block";
        document.getElementById('hiddenShoulderWidth').value = shoulderWidth;
        document.getElementById('shoulderWidthImg').style.width = ((camHeight * 0.66667)) + 30 + "%";
        //document.getElementById('liveViewShoulderWidthImg').style.width = ((camHeight * 0.66667)) + 30 + "%";

        setTimeout(function () {
            $('#shoulderWidthDiv').fadeOut('fast');
            //$('#liveViewShoulderWidthDiv').fadeOut('fast');
        }, 5000);
    }
    if (shoulderWidth < 100) {
        //alert(getDefaultPercentage);

    }
    //document.getElementById('shoulderWidthImg').style.width = existingWidth++;
}


//cam height minus button
function camHeightMinus() {
    //document.getElementById('applyBtnBS').disabled = false; 
    //get preset shoulder width
    var getDefaultPercentage = parseFloat(($("#shoulderWidthImg").width() / 282) * 100).toFixed(0);
    var shoulderWidth = parseFloat(document.getElementById('hiddenShoulderWidth').value);
    //    document.getElementById('applyBtnBS').className = "btn_black";
    var camHeight = document.getElementById('camHeightValue').value;
    if (camHeight > 0) {
        var currentValue = parseFloat(camHeight);
        currentValue -= 1;
        var value = currentValue;
        changeValue = document.getElementById('camHeightValue');
        changeValue.value = parseFloat(currentValue);
        document.getElementById('camHeightCell').getElementsByClassName("slideControlFill2")[0].style.width = (currentValue * 1) + "%";
        shoulderWidth -= 0.6667;
        document.getElementById('shoulderWidthDiv').style.display = "block";
        //document.getElementById('liveViewShoulderWidthDiv').style.display = "block";
        document.getElementById('hiddenShoulderWidth').value = shoulderWidth;
        document.getElementById('shoulderWidthImg').style.width = ((camHeight * 0.66667)) + 30 + "%";
        //document.getElementById('liveViewShoulderWidthImg').style.width = ((camHeight * 0.66667)) + 30 + "%";
        setTimeout(function () {
            $('#shoulderWidthDiv').fadeOut('fast');
           // $('#liveViewShoulderWidthDiv').fadeOut('fast');
        }, 5000);
    }

}






