/*
 * slideControl - jQuery Plugin
 * version: 1.2 October 2012
 * @requires jQuery v1.6 or later
 *
 * Examples at http://nikorablin.com/slideControl
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 */
(function ($) {
    $.fn.slideControlMaskBottom = function (options) {

        // defaults
        var defaults = {
            speed: 400,
            lowerBound: 1,
            upperBound: 10
        };

        var options = $.extend(defaults, options);

        return this.each(function () {

            // set vars
            var o = options;
            var controller = true;
            var position = 10;
            var obj = this;
            $(this).addClass('slideControlInput');
            var parent = $(this).parent();

            var label = $(parent).find('label');

            parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val() * 1 + "%\"><span class=\"slideControlHandleMaskBottom\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());
            var container = parent.find('.slideControlContainer');
            var fill = container.find('.slideControlFill');
            var handle = fill.find('.slideControlHandleMaskBottom');
            var input = parent.find('input');
            var containerWidth = container.outerWidth() + 1;
            var handleWidth = $(handle).outerWidth();
            var offset = $(container).offset();
            var animate = function (value) { $(fill).animate({ width: value + "%" }, o.speed); }

            $(window).resize(function () {
                offset = $(container).offset();
            })

            //adds shadow class to handle for IE <9
            if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
                handle.addClass('ieShadow');
            }

            // when user clicks anywhere on the slider
            $(container).click(function (e) {
                e.preventDefault();
                position = checkBoundaries(Math.round(((e.pageX - 13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                animate(position);
                $(input).val(position / 1);
                var overlapVal = parseInt(document.getElementById('maskTopValue').value) + parseInt(document.getElementById('maskBottomValue').value);
                var line2Val = parseInt(document.getElementById('outLineValue').value);
                if (position > line2Val) {
                    document.getElementById('maskZoomBottom').style.height = (position/100)*240 + "px";
                    document.getElementById('liveViewMaskZoomBottom').style.height = (position / 100) * 240 + "px";
                    $(fill).width(position + "%");
                    $(input).val(position / 1);
                    animate(position);

                    //set mask left and right height
                    var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                    //set mask left and right position
                    var line1pos = parseInt(document.getElementById('maskTopValue').value);
                    var maskTopLinePos = (line1pos / 100) * 240;
                    //console.log(line1pos);

                    document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                } else {
                    //alert("Over line 1");

                    document.getElementById('maskZoomBottom').style.height = ((parseInt(line2Val) + 2)/100)*240 + "px";
                    document.getElementById('liveViewMaskZoomBottom').style.height = ((parseInt(line2Val) + 2) / 100) * 240 + "px";
                    $(fill).width((parseInt(line2Val) + 1) + "%");
                    $(input).val((parseInt(line2Val) + 1) / 1);
                    //alert((parseInt(line2Val) + 2));
                    animate((parseInt(line2Val) + 1));

                    //set mask left and right height
                    var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                    //set mask left and right position
                    var line1pos = parseInt(document.getElementById('maskTopValue').value);
                    var maskTopLinePos = (line1pos / 100) * 240;
                    //console.log(line1pos);

                    document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                }


            });

            // when user clicks handle
            $(handle).mousedown(function (e) {
                //             document.getElementById('applyBtnCA').disabled = false;
                //document.getElementById('applyBtnCA').className = "btn_black";
                e.preventDefault();
                controller = true;
                $(document).mousemove(function (e) {
                    e.preventDefault();
                    position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                    if (controller) {
                        $(fill).width(position + "%");
                        $(input).val(position / 1);
                        var line2Val = parseInt(document.getElementById('outLineValue').value);
                        if (position > (line2Val + 2)) {
                            document.getElementById('maskZoomBottom').style.height = (position/100)*240 + "px";
                            document.getElementById('liveViewMaskZoomBottom').style.height = (position / 100) * 240 + "px";

                            //set mask left and right height
                            var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                            //set mask left and right position
                            var line1pos = parseInt(document.getElementById('maskTopValue').value);
                            var maskTopLinePos = (line1pos / 100) * 240;
                            //console.log(line1pos);

                            document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                            document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                            document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                            document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                        } else {
                            //alert("Over line 2");
                            $(fill).width((parseInt(line2Val) + 1) + "%");
                            $(input).val((parseInt(line2Val) + 1) / 1);
                            document.getElementById('maskZoomBottom').style.height = ((parseInt(line2Val) + 2)/100)*240 + "px";
                            document.getElementById('liveViewMaskZoomBottom').style.height = ((parseInt(line2Val) + 2) / 100) * 240 + "px";


                        }
                        //}

                    }
                });

                $(document).mouseup(function () {
                    //document.getElementById('applyBtnCA').className = "btn_black";
                    e.preventDefault();
                    var line2Val = parseInt(document.getElementById('outLineValue').value);
                    var outCurrentValue = parseInt(document.getElementById('maskBottomValue').value);
                    var newOutCurrentValue = outCurrentValue;

                    document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = (newOutCurrentValue - 1) + "%";
                    document.getElementById('maskBottomValue').value = newOutCurrentValue;
                    document.getElementById('maskZoomBottom').style.height = ((newOutCurrentValue)/100)*240 + "px";
                    document.getElementById('liveViewMaskZoomBottom').style.height = ((newOutCurrentValue) / 100) * 240 + "px";
                    if (position <= line2Val) {
                        //alert("hit");
                        document.getElementById('maskZoomBottom').style.height = ((newOutCurrentValue + 1)/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomBottom').style.height = ((newOutCurrentValue + 1) / 100) * 240 + "px";
                        var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";
                        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;
                    }

                    controller = false;

                });
            });

            // when user changes value in input
            $(input).change(function () {
                //modify OUT Line value
                var outCurrentValue = parseInt(document.getElementById('maskBottomValue').value);
                var newOutValue = outCurrentValue;
                if (newOutValue <= 100 && newOutValue >= 0) {

                    document.getElementById('maskBottomCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue + "%";
                    var line2Val = parseInt(document.getElementById('outLineValue').value);
                    if (newOutValue > line2Val) {
                        document.getElementById('maskZoomBottom').style.height = (newOutValue/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomBottom').style.height = (newOutValue / 100) * 240 + "px";

                        //set mask left and right height
                        var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                        //set mask left and right position
                        var line1pos = parseInt(document.getElementById('maskTopValue').value);
                        var maskTopLinePos = (line1pos / 100) * 240;
                        //console.log(line1pos);

                        document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                    } else {
                        //alert("Over line 1");
                        var leftRightMaskHeight = ((((line2Val + 1) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 1 + "px";
                        //console.log(line2Val);
                        //console.log(parseInt(document.getElementById('maskTopValue').value));
                        $(fill).width((line2Val + 1) + "%");
                        $(input).val((line2Val + 1) / 1);
                        document.getElementById('maskZoomBottom').style.height = ((line2Val + 2)/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomBottom').style.height = ((line2Val + 2) / 100) * 240 + "px";
                        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;
                    }

                } else {
                    //alert("Out of range");
                }
            });
        });

        // checks if value is within boundaries
        function checkBoundaries(value) {
            if (value < options.lowerBound * 0)
                return options.lowerBound * 0;
            else if (value > options.upperBound * 10)
                return options.upperBound * 10;
            else
                return value;
        }

        // checks ie version
        function getInternetExplorerVersion() {
            var rv = -1;
            if (navigator.appName == 'Microsoft Internet Explorer') {
                var ua = navigator.userAgent;
                var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                if (re.exec(ua) != null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
        }
        return this;
    }
})(jQuery);







