/*
 * slideControl - jQuery Plugin
 * version: 1.2 October 2012
 * @requires jQuery v1.6 or later
 *
 * Examples at http://nikorablin.com/slideControl
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 */
(function($){
	 $.fn.slideControlMaskRight = function(options) {
		
		// defaults
		var defaults = {
			speed: 400,
			lowerBound: 1,
			upperBound: 10
		};

		var options = $.extend(defaults, options);
		
		return this.each(function() {
			
			// set vars
			var o = options;
			var controller = true;
			var position = 10;
			var obj = this;
			$(this).addClass('slideControlInput');
			var parent = $(this).parent();
			
			var label = $(parent).find('label');
			
			parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val()*1 + "%\"><span class=\"slideControlHandleMaskRight\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());
			var container = parent.find('.slideControlContainer');
			var fill = container.find('.slideControlFill');
			var handle = fill.find('.slideControlHandleMaskRight');
			var input = parent.find('input');
			var containerWidth = container.outerWidth() + 1;
			var handleWidth = $(handle).outerWidth();
			var offset = $(container).offset();
			var animate = function(value){$(fill).animate({ width: value + "%"}, o.speed);}
			
			$(window).resize(function() {
				offset = $(container).offset();
			})
			
			//adds shadow class to handle for IE <9
			if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
				handle.addClass('ieShadow');
			}
			
			// when user clicks anywhere on the slider
			$(container).click(function(e) {
			   // document.getElementById('applyBtnCA').disabled = false;
			    //document.getElementById('applyBtnCA').className = "btn_black";
				e.preventDefault();
				position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth/2)/containerWidth)*100));
				animate(position);
				$(input).val(position/1);
				var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);
				if (overlapVal>=100){
					var maxHorizontal = 100 - (document.getElementById('maskLeftValue').value);
					changeValue = document.getElementById('maskRightValue');
					changeValue.value = maxHorizontal;
					document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = maxHorizontal +"%";	
					document.getElementById('maskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					document.getElementById('liveViewMaskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
				} else {
					animate(position);
					document.getElementById('maskZoomRight').style.borderRight = (((position/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					document.getElementById('liveViewMaskZoomRight').style.borderRight = (((position/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
				}
				
			});
			
			// when user clicks handle
			$(handle).mousedown(function(e) {
			    //document.getElementById('applyBtnCA').disabled = false;
			    //document.getElementById('applyBtnCA').className = "btn_black";
				e.preventDefault();
				controller = true;
				$(document).mousemove(function(e) {
					e.preventDefault();
					position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth/2)/containerWidth)*100));
					if (controller) {	
						$(fill).width(position + "%");
						$(input).val(position/1);
						var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);	
						if (overlapVal>100){
							var maxHorizontal = 100 - (document.getElementById('maskLeftValue').value);
							changeValue = document.getElementById('maskRightValue');
							changeValue.value = maxHorizontal;
							document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = maxHorizontal +"%";	
						} else {
							document.getElementById('maskZoomRight').style.borderRight = (((position/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
						document.getElementById('liveViewMaskZoomRight').style.borderRight = (((position/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
						}
						
					}
				});
				
				$(document).mouseup(function() {
				    //document.getElementById('applyBtnCA').className = "btn_black";
					var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);	
					if (overlapVal>100){
					e.preventDefault();
					var maxHorizontal = 100 - (document.getElementById('maskLeftValue').value);
					changeValue = document.getElementById('maskRightValue');
					changeValue.value = maxHorizontal;
					document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = maxHorizontal +"%";	
					document.getElementById('maskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					document.getElementById('liveViewMaskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					}
					
					controller = false;
				});
			});
			
			// when user changes value in input
			$(input).change(function() {
			    //document.getElementById('applyBtnCA').disabled = false;
			    //document.getElementById('applyBtnCA').className = "btn_black";
				//modify OUT Line value
				var outCurrentValue = document.getElementById('maskRightValue').value;
				var newOutValue = outCurrentValue;	
				var overlapVal = parseInt(document.getElementById('maskLeftValue').value) + parseInt(document.getElementById('maskRightValue').value);	
				
				if (newOutValue <=100 && newOutValue >= 0) {
				if (overlapVal>100){
					var maxHorizontal = 100 - (document.getElementById('maskLeftValue').value);
					changeValue = document.getElementById('maskRightValue');
					changeValue.value = maxHorizontal;
					document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = maxHorizontal +"%";	
					document.getElementById('maskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					document.getElementById('liveViewMaskZoomRight').style.borderRight = (((maxHorizontal/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
				} else {
						document.getElementById('maskRightCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue +"%";
					document.getElementById('maskZoomRight').style.borderRight = (((newOutValue/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
					document.getElementById('liveViewMaskZoomRight').style.borderRight = (((newOutValue/320)*100))*10.24+ "px solid rgba(0, 0, 0, 0.67)";
				}
				
				} else {
					alert("Out of range");
				}
			});
		});
		
		// checks if value is within boundaries
		function checkBoundaries(value) {
			if (value < options.lowerBound*0)
				return options.lowerBound*0;
			else if (value > options.upperBound*10)
				return options.upperBound*10;
			else
				return value;
		}
		
		// checks ie version
		function getInternetExplorerVersion(){
		   var rv = -1;
		   if (navigator.appName == 'Microsoft Internet Explorer') {
			  var ua = navigator.userAgent;
			  var re  = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
			  if (re.exec(ua) != null)
				 rv = parseFloat( RegExp.$1 );
		   }
		   return rv;
		}
		return this;
	 }
})(jQuery);







