/*
 * slideControl - jQuery Plugin
 * version: 1.2 October 2012
 * @requires jQuery v1.6 or later
 *
 * Examples at http://nikorablin.com/slideControl
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 */
(function ($) {
    $.fn.slideControlMaskingTop = function (options) {

        // defaults
        var defaults = {
            speed: 400,
            lowerBound: 1,
            upperBound: 10
        };

        var options = $.extend(defaults, options);

        return this.each(function () {

            // set vars
            var o = options;
            var controller = true;
            var position = 10;
            var obj = this;
            $(this).addClass('slideControlInput');
            var parent = $(this).parent();

            var label = $(parent).find('label');

            parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val() * 1 + "%\"><span class=\"slideControlHandleMaskingTop\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());
            var container = parent.find('.slideControlContainer');
            var fill = container.find('.slideControlFill');
            var handle = fill.find('.slideControlHandleMaskingTop');
            var input = parent.find('input');
            var containerWidth = container.outerWidth() + 1;
            var handleWidth = $(handle).outerWidth();
            var offset = $(container).offset();
            var animate = function (value) { $(fill).animate({ width: value + "%" }, o.speed); }

            $(window).resize(function () {
                offset = $(container).offset();
            })

            //adds shadow class to handle for IE <9
            if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
                handle.addClass('ieShadow');
            }

            // when user clicks anywhere on the slider
            $(container).click(function (e) {
                e.preventDefault();
                position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                animate(position);
                $(input).val(position / 1);
                var overlapVal = parseInt(document.getElementById('maskTopValue').value) + parseInt(document.getElementById('maskBottomValue').value);
                var line1Val = parseInt(document.getElementById('inLineValue').value);
                if (position < line1Val) {

                    document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = position + "%";
                    document.getElementById('maskZoomTop').style.height = (position/100)*240 + "px";
                    document.getElementById('liveViewMaskZoomTop').style.height = (position / 100) * 240 + "px";

                    //set mask left and right height
                    //var leftRightMaskHeight = parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value);
                    var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                    //set mask left and right position
                    var line1pos = parseInt(document.getElementById('maskTopValue').value);
                    var maskTopLinePos = (line1pos / 100) * 240;
                    //console.log(line1pos);

                    document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;



                } else {
                    //alert("over");
                    document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = (line1Val - 1) + "%";
                    document.getElementById('maskZoomTop').style.height = ((line1Val - 1)/100)*240 + "px";
                    //document.getElementById('liveViewMaskZoomTop').style.height = (line1Val - 1) + "%";
                    //$(fill).width(line1Val + "%");
                    $(input).val((line1Val / 1) - 1);


                    //set mask left and right height
                    var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";
                    //set mask left and right position
                    var line1pos = parseInt(document.getElementById('maskTopValue').value);
                    var maskTopLinePos = (line1pos / 100) * 240;
                    //console.log(line1pos);

                    document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                }
            });

            // when user clicks handle
            $(handle).mousedown(function (e) {
                e.preventDefault();
                controller = true;
                $(document).mousemove(function (e) {
                    e.preventDefault();
                    position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                    if (controller) {
                        $(fill).width(position + "%");
                        $(input).val(position / 1);
                        //alert("moving");
                        var line1Val = document.getElementById('inLineValue').value;
                        if (position < line1Val) {
                            //less than line 1
                            document.getElementById('maskZoomTop').style.height = (position/100)*240 + "px";
                            document.getElementById('liveViewMaskZoomTop').style.height = (position / 100) * 240 + "px";

                            //set mask left and right height
                            var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                            //set mask left and right position
                            var line1pos = parseInt(document.getElementById('maskTopValue').value);
                            var maskTopLinePos = (line1pos / 100) * 240;
                            //console.log(line1pos);

                            document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                            document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                            document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                            document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                            document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;

                        } else {
                            //alert("Over line 1");
                            $(fill).width(line1Val + "%");
                            $(input).val(line1Val / 1);
                        }

                        //}

                    }
                });

                $(document).mouseup(function () {

                    var line1Val = parseInt(document.getElementById('inLineValue').value);
                    var outCurrentValue = parseInt(document.getElementById('maskTopValue').value);
                    var newOutCurrentValue = outCurrentValue;
                    //alert(newOutCurrentValue);

                    if (newOutCurrentValue >= line1Val) {
                        document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = (newOutCurrentValue - 1) + "%";
                        document.getElementById('maskTopValue').value = newOutCurrentValue - 1;
                        document.getElementById('maskZoomTop').style.height = ((newOutCurrentValue - 1)/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomTop').style.height = ((newOutCurrentValue - 1) / 100) * 240 + "px";
                    }

                    //set mask left and right height
                    var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                    //set mask left and right position
                    var line1pos = parseInt(document.getElementById('maskTopValue').value);
                    var maskTopLinePos = (line1pos / 100) * 240;
                    //console.log(line1pos);

                    document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                    document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                    document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                    document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;


                    controller = false;


                });
            });

            // when user changes value in input
            $(input).change(function () {
                //modify OUT Line value
                var outCurrentValue = document.getElementById('maskTopValue').value;
                var newOutValue = outCurrentValue;
                var overlapVal = parseInt(document.getElementById('maskTopValue').value) + parseInt(document.getElementById('maskBottomValue').value);
                if (newOutValue <= 100 && newOutValue >= 0) {
                    document.getElementById('maskTopCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue + "%";
                    var line1Val = parseInt(document.getElementById('inLineValue').value);
                    if (newOutValue < line1Val) {
                        document.getElementById('maskZoomTop').style.height = (newOutValue/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomTop').style.height = (newOutValue / 100) * 240 + "px";

                        //set mask left and right height
                        var leftRightMaskHeight = (((parseInt(document.getElementById('maskBottomValue').value) - parseInt(document.getElementById('maskTopValue').value)) / 100) * 240) - 4 + "px";

                        //set mask left and right position
                        var line1pos = parseInt(document.getElementById('maskTopValue').value);
                        var maskTopLinePos = (line1pos / 100) * 240;
                        //console.log(line1pos);

                        document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos + 2.2) + "px";
                        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;


                    } else {
                        //alert("Over line 1");
                        var bottomValue = parseInt(document.getElementById('maskBottomValue').value);
                        var leftRightMaskHeight = (((bottomValue - line1Val)/100)*240)-1 + "px";
                        
                        $(fill).width(line1Val - 1 + "%");
                        $(input).val((line1Val / 1) - 1);
                        document.getElementById('maskZoomTop').style.height = ((line1Val - 1)/100)*240 + "px";
                        document.getElementById('liveViewMaskZoomTop').style.height = ((line1Val - 1) / 100) * 240 + "px";
                        var maskTopLinePos = (line1Val / 100) * 240;
                        console.log(maskTopLinePos);

                        document.getElementById('maskZoomLeft').style.marginTop = (maskTopLinePos) + "px";
                        document.getElementById('liveViewMaskZoomLeft').style.marginTop = (maskTopLinePos) + "px";
                        document.getElementById('maskZoomRight').style.marginTop = (maskTopLinePos) + "px";
                        document.getElementById('liveViewMaskZoomRight').style.marginTop = (maskTopLinePos) + "px";
                        document.getElementById('maskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomLeft').style.height = leftRightMaskHeight;
                        document.getElementById('maskZoomRight').style.height = leftRightMaskHeight;
                        document.getElementById('liveViewMaskZoomRight').style.height = leftRightMaskHeight;


                    }
                    //}

                } else {
                    alert("Out of range");
                }
            });
        });

        // checks if value is within boundaries
        function checkBoundaries(value) {
            if (value < options.lowerBound * 0)
                return options.lowerBound * 0;
            else if (value > options.upperBound * 10)
                return options.upperBound * 10;
            else
                return value;
        }

        // checks ie version
        function getInternetExplorerVersion() {
            var rv = -1;
            if (navigator.appName == 'Microsoft Internet Explorer') {
                var ua = navigator.userAgent;
                var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                if (re.exec(ua) != null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
        }
        return this;
    }
})(jQuery);







