/*
* slideControl - jQuery Plugin
* version: 1.2 October 2012
* @requires jQuery v1.6 or later
*
* Examples at http://nikorablin.com/slideControl
* Free to use and abuse under the MIT license.
* http://www.opensource.org/licenses/mit-license.php
*
*/
(function ($) {
    $.fn.slideControlOutLine = function (options) {

        // defaults
        var defaults = {
            speed: 400,
            lowerBound: 1,
            upperBound: 10
        };

        var options = $.extend(defaults, options);

        return this.each(function () {

            // set vars
            var o = options;
            var controller = true;
            var position = 10;
            var obj = this;
            $(this).addClass('slideControlInput');
            var parent = $(this).parent();

            var label = $(parent).find('label');

            parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val() * 1 + "%\"><span class=\"slideControlHandleOutLine\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());
            var container = parent.find('.slideControlContainer');
            var fill = container.find('.slideControlFill');
            var handle = fill.find('.slideControlHandleOutLine');
            var input = parent.find('input');
            var containerWidth = container.outerWidth() + 1;
            var handleWidth = $(handle).outerWidth();
            var offset = $(container).offset();
            var animate = function (value) { $(fill).animate({ width: value + "%" }, o.speed); }

            $(window).resize(function () {
                offset = $(container).offset();
            })

            //adds shadow class to handle for IE <9
            if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
                handle.addClass('ieShadow');
            }

            // when user clicks anywhere on the slider
            $(container).click(function (e) {
                // document.getElementById('applyBtnBS').disabled = false;
                //document.getElementById('applyBtnBS').className = "btn_black";
                e.preventDefault();
                position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));

                $(input).val(position / 1);
                var outLineVal = parseInt(document.getElementById('outLineValue').value);
                var inLineVal = parseInt(document.getElementById('inLineValue').value);
                var maskBottomValue = parseInt(document.getElementById('maskBottomValue').value);
                //prevent line overlap each other
                if ((position - 1) < inLineVal) {

                    document.getElementById('maskingLineOut').style.height = ((inLineVal - 1)/100)*240 + "px";
                    document.getElementById('liveViewMaskingLineOut').style.height = ((inLineVal - 1) / 100) * 240 + "px";
                    document.getElementById('maskingLineBlueBlink').style.height = ((inLineVal - 1) / 100) * 240 + "px";
                    document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((inLineVal - 1) / 100) * 240 + "px";
                    var changeValue = document.getElementById('outLineValue');
                    //alert(inLineVal);
                    //changeValue.value = (inLineVal + 5);
                    document.getElementById('outLineValue').value = inLineVal + 5;
                    animate(inLineVal + 5);
                    //alert("OUT Line value is not cannot be less than IN Line value.");
                    document.getElementById('maskingLineOut').style.height = ((inLineVal + 5)/100)*240 + "px";
                    document.getElementById('liveViewMaskingLineOut').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                    document.getElementById('maskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                    document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";

                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    //console.log(countingLineHeight);
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";


                } else if ((position - 1) > inLineVal && (position - 1) < maskBottomValue) {
                    document.getElementById('maskingLineOut').style.height = ((position - 1)/100)*240 + "px";
                    document.getElementById('liveViewMaskingLineOut').style.height = ((position - 1) / 100) * 240 + "px";
                    document.getElementById('maskingLineBlueBlink').style.height = ((position - 1) / 100) * 240 + "px";
                    document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((position - 1) / 100) * 240 + "px";
                    animate(position);
                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    //console.log(countingLineHeight);
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";

                } else if ((position - 1) > maskBottomValue) {
                    var getCurrentMaskBottomValue = parseInt(document.getElementById('maskBottomValue').value);

                    document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = (getCurrentMaskBottomValue) + "%";
                    document.getElementById('outLineValue').value = (getCurrentMaskBottomValue - 1);
                    document.getElementById('maskingLineOut').style.height = ((getCurrentMaskBottomValue - 3)/100)*240 + "px";
                    document.getElementById('liveViewMaskingLineOut').style.height = ((getCurrentMaskBottomValue - 3) / 100) * 240 + "px";
                    document.getElementById('maskingLineBlueBlink').style.height = ((getCurrentMaskBottomValue - 3) / 100) * 240 + "px";
                    document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((getCurrentMaskBottomValue - 3) / 100) * 240 + "px";
                    var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                    //console.log(countingLineHeight);
                    document.getElementById('countingLine').style.height = countingLineHeight + "px";
                    document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                    document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                }
            });

            // when user clicks handle
            $(handle).mousedown(function (e) {
                //document.getElementById('applyBtnBS').disabled = false;
                //document.getElementById('applyBtnBS').className = "btn_black";
                e.preventDefault();
                controller = true;
                $(document).mousemove(function (e) {
                    e.preventDefault();
                    position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth / 2) / containerWidth) * 100));
                    if (controller) {
                        $(fill).width(position + "%");
                        $(input).val(position / 1);
                        var outLineVal = parseInt(document.getElementById('outLineValue').value);
                        var inLineVal = parseInt(document.getElementById('inLineValue').value);
                        var maskBottomValue = parseInt(document.getElementById('maskBottomValue').value);
                        //prevent line overlap each other
                        if ((position - 1) < (inLineVal + 5)) {
                            //alert(inLineVal + 5);
                            document.getElementById('maskingLineOut').style.height = ((inLineVal + 5)/100)*240 + "px";
                            document.getElementById('liveViewMaskingLineOut').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                            document.getElementById('maskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                            var changeValue = document.getElementById('outLineValue');
                            changeValue.value = inLineVal + 5;
                            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                            //console.log(countingLineHeight);
                            document.getElementById('countingLine').style.height = countingLineHeight + "px";
                            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        } else if ((position - 1) > inLineVal && outLineVal < maskBottomValue) {
                            document.getElementById('maskingLineOut').style.height = ((position - 1)/100)*240 + "px";
                            document.getElementById('liveViewMaskingLineOut').style.height = ((position - 1) / 100) * 240 + "px";
                            document.getElementById('maskingLineBlueBlink').style.height = ((position - 1) / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((position - 1) / 100) * 240 + "px";
                            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                            //console.log(countingLineHeight);
                            document.getElementById('countingLine').style.height = countingLineHeight + "px";
                            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        } else if (outLineVal > maskBottomValue) {
                            var forceOutVal = parseInt(document.getElementById('maskBottomValue').value) - 1;
                            document.getElementById('outLineValue').value = forceOutVal;
                            document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = forceOutVal + "%";
                            document.getElementById('maskingLineOut').style.height = ((forceOutVal - 1)/100)*240 + "px";
                            document.getElementById('liveViewMaskingLineOut').style.height = ((forceOutVal - 1) / 100) * 240 + "px";
                            document.getElementById('maskingLineBlueBlink').style.height = ((forceOutVal - 1) / 100) * 240 + "px";
                            document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((forceOutVal - 1) / 100) * 240 + "px";
                            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                            //console.log(countingLineHeight);
                            document.getElementById('countingLine').style.height = countingLineHeight + "px";
                            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        }
                    }
                });

                $(document).mouseup(function () {

                    //document.getElementById('applyBtnBS').className = "btn_black";
                    var outLineVal = parseInt(document.getElementById('outLineValue').value);
                    var inLineVal = parseInt(document.getElementById('inLineValue').value);
                    var maskBottomValue = parseInt(document.getElementById('maskBottomValue').value);
                    var maskTopValue = parseInt(document.getElementById('maskTopValue').value);
                    if (outLineVal == 100) {
                        //alert("100");
                        document.getElementById('outLineValue').value = 99;
                    }

                    else if (outLineVal >= (inLineVal + 5) && outLineVal == (maskTopValue + 6)) {

                        document.getElementById('maskingLineIn').style.height = ((inLineVal)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineIn').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('maskingLineGreenBlink').style.height = ((inLineVal) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineGreenBlink').style.height = ((inLineVal) / 100) * 240 + "px";

                        document.getElementById('maskingLineOut').style.height = ((outLineVal)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineOut').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('maskingLineBlueBlink').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = outLineVal - 1 + "%";

                    } else if (outLineVal >= (inLineVal + 5) && outLineVal != (maskBottomValue - 1)) {
                        //alert("hit");
                        document.getElementById('maskingLineOut').style.height = ((outLineVal)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineOut').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('maskingLineBlueBlink').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((outLineVal) / 100) * 240 + "px";
                        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = outLineVal - 1 + "%";
                    } 

                    controller = false;
                });
            });

            // when user changes value in input
            $(input).change(function () {
                //document.getElementById('applyBtnBS').disabled = false;
                //document.getElementById('applyBtnBS').className = "btn_black";
                //modify OUT Line value
                var inLineVal = parseInt(document.getElementById('inLineValue').value);
                var outCurrentValue = parseInt(document.getElementById('outLineValue').value);
                var maskBottomValue = parseInt(document.getElementById('maskBottomValue').value);
                var newOutValue = outCurrentValue;
                if (newOutValue << 100 && newOutValue >= 0) {
                    var outLineVal = parseInt(document.getElementById('outLineValue').value);

                    if (outLineVal <= inLineVal) {
                        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = (inLineVal + 5) + "%";
                        document.getElementById('maskingLineOut').style.height = ((inLineVal + 5)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineOut').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                        document.getElementById('maskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((inLineVal + 5) / 100) * 240 + "px";
                        var changeValue = document.getElementById('outLineValue');
                        changeValue.value = parseInt(inLineVal + 5);
                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    } else if (newOutValue <= 100 && newOutValue < maskBottomValue) {
                        //alert("in");
                        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue + "%";
                        document.getElementById('maskingLineOut').style.height = ((newOutValue - 1)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineOut').style.height = ((newOutValue - 1) / 100) * 240 + "px";
                        document.getElementById('maskingLineBlueBlink').style.height = ((newOutValue - 1) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((newOutValue - 1) / 100) * 240 + "px";
                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    } else if (newOutValue > maskBottomValue) {
                        var forceOutVal = parseInt(document.getElementById('maskBottomValue').value) - 1;
                        document.getElementById('outLineValue').value = forceOutVal;
                        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = forceOutVal + "%";
                        document.getElementById('maskingLineOut').style.height = ((forceOutVal - 2)/100)*240 + "px";
                        document.getElementById('liveViewMaskingLineOut').style.height = ((forceOutVal - 2) / 100) * 240 + "px";
                        document.getElementById('maskingLineBlueBlink').style.height = ((forceOutVal - 2) / 100) * 240 + "px";
                        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((forceOutVal - 2) / 100) * 240 + "px";
                        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
                        //console.log(countingLineHeight);
                        document.getElementById('countingLine').style.height = countingLineHeight + "px";
                        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
                        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
                    }


                } else {
                    //alert("Out of range");
                }
            });
        });

        // checks if value is within boundaries
        function checkBoundaries(value) {
            if (value < options.lowerBound * 0)
                return options.lowerBound * 0;
            else if (value > options.upperBound * 10)
                return options.upperBound * 10;
            else
                return value;
        }

        // checks ie version
        function getInternetExplorerVersion() {
            var rv = -1;
            if (navigator.appName == 'Microsoft Internet Explorer') {
                var ua = navigator.userAgent;
                var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
                if (re.exec(ua) != null)
                    rv = parseFloat(RegExp.$1);
            }
            return rv;
        }
        return this;
    }
})(jQuery);


//out line minus button
function outLineMinus() {
    //document.getElementById('applyBtnBS').disabled = false;
    //document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = document.getElementById('outLineValue').value;
    if (currentValue > 0) {
        currentValue--;
        var outLineVal = parseInt(document.getElementById('outLineValue').value);
        var inLineVal = parseInt(document.getElementById('inLineValue').value);
        if ((inLineVal + 5) >= currentValue) {
            //alert("IN Line value is not cannot be more than OUT Line value.");
        } else {
            changeValue = document.getElementById('outLineValue');
            changeValue.value = currentValue;
            document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
            document.getElementById('maskingLineOut').style.height = ((currentValue - 1)/100)*240 + "px";
            document.getElementById('liveViewMaskingLineOut').style.height = ((currentValue - 1) / 100) * 240 + "px";
            document.getElementById('maskingLineBlueBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
            document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
            var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
            //console.log(countingLineHeight);
            document.getElementById('countingLine').style.height = countingLineHeight + "px";
            document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
            document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
            document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
        }
    }

}

//out line add button
function outLineAdd() {
    //document.getElementById('applyBtnBS').disabled = false;
    //document.getElementById('applyBtnBS').className = "btn_black";
    var currentValue = parseInt(document.getElementById('outLineValue').value);
    var maskBottomValue = parseInt(document.getElementById('maskBottomValue').value);
    //alert(maskBottomValue);
    if (currentValue < 100 && currentValue < (maskBottomValue - 1)) {
        currentValue++;
        changeValue = document.getElementById('outLineValue');
        changeValue.value = currentValue;
        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
        document.getElementById('maskingLineOut').style.height = ((currentValue - 1)/100)*240 + "px";
        document.getElementById('liveViewMaskingLineOut').style.height = ((currentValue - 1) / 100) * 240 + "px";
        document.getElementById('maskingLineBlueBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((currentValue - 1) / 100) * 240 + "px";
        var countingLineHeight = ((parseInt(document.getElementById('outLineValue').value) - parseInt(document.getElementById('inLineValue').value)) / 100) * 240;
        //console.log(countingLineHeight);
        document.getElementById('countingLine').style.height = countingLineHeight + "px";
        document.getElementById('countingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
        document.getElementById('liveViewCountingLine').style.height = countingLineHeight + "px";
        document.getElementById('liveViewCountingLine').style.marginTop = ((document.getElementById('inLineValue').value) / 100) * 240 + "px";
    } else {
        document.getElementById('maskingLineOut').style.height = ((currentValue - 2)/100)*240 + "px";
        document.getElementById('liveViewMaskingLineOut').style.height = ((currentValue - 2) / 100) * 240 + "px";
        document.getElementById('maskingLineBlueBlink').style.height = ((currentValue - 2) / 100) * 240 + "px";
        document.getElementById('liveViewMaskingLineBlueBlink').style.height = ((currentValue - 2) / 100) * 240 + "px";
        document.getElementById('outLineCell').getElementsByClassName("slideControlFill")[0].style.width = currentValue + "%";
    }
}





