/*
 * slideControl - jQuery Plugin
 * version: 1.2 October 2012
 * @requires jQuery v1.6 or later
 *
 * Examples at http://nikorablin.com/slideControl
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 */
(function($){
	 $.fn.slideControlZoom = function(options) {
		
		// defaults
		var defaults = {
			speed: 400,
			lowerBound: 1,
			upperBound: 10
		};

		var options = $.extend(defaults, options);
		
		return this.each(function() {
			
			// set vars
			var o = options;
			var controller = true;
			var position = 10;
			var obj = this;
			$(this).addClass('slideControlInput');
			var parent = $(this).parent();
			
			var label = $(parent).find('label');
			
			parent.html("<label>" + $(label).html() + "</label><span class=\"slideControlContainer\"><span class=\"slideControlFill\" style=\"width:" + $(obj).val()*1 + "%\"><span class=\"slideControlHandleZoom\"></span></span></span>" + $(obj).wrap("<span></span>").parent().html());
			var container = parent.find('.slideControlContainer');
			var fill = container.find('.slideControlFill');
			var handle = fill.find('.slideControlHandleZoom');
			var input = parent.find('input');
			var containerWidth = container.outerWidth() + 1;
			var handleWidth = $(handle).outerWidth();
			var offset = $(container).offset();
			var animate = function(value){$(fill).animate({ width: value + "%"}, o.speed);}
			
			$(window).resize(function() {
				offset = $(container).offset();
			})
			
			//adds shadow class to handle for IE <9
			if (getInternetExplorerVersion() < 9 && getInternetExplorerVersion() > -1) {
				handle.addClass('ieShadow');
			}
			
			// when user clicks anywhere on the slider
			$(container).click(function(e) {
				e.preventDefault();
				position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth/2)/containerWidth)*100));
				animate(position);
				$(input).val(position/1);
				document.getElementById('zoomTop').style.borderTop = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('zoomBottom').style.borderBottom = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('zoomLeft').style.borderLeft = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('zoomRight').style.borderRight = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('liveViewZoomTop').style.borderTop = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('liveViewZoomBottom').style.borderBottom = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('liveViewZoomLeft').style.borderLeft = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
				document.getElementById('liveViewZoomRight').style.borderRight = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
				var changeValue = document.getElementById('upDownValue');
				var changeBottomValue = document.getElementById('DownValue');
				var changeLeftValue = document.getElementById('leftRightValue');
				var changeRightValue = document.getElementById('RightValue');
				changeValue.value = position;
				changeBottomValue.value = position;
				changeLeftValue.value = position;
				changeRightValue.value = position;
				
			});
			
			// when user clicks handle
			$(handle).mousedown(function(e) {
				e.preventDefault();
				controller = true;
				$(document).mousemove(function(e) {
					e.preventDefault();
					position = checkBoundaries(Math.round(((e.pageX-13 - offset.left + handleWidth/2)/containerWidth)*100));
					if (controller) {	
						$(fill).width(position + "%");
						$(input).val(position/1);
						var upDownOverlapVal = parseInt(document.getElementById('zoomValue').value);
												
						
							document.getElementById('zoomTop').style.borderTop = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('zoomBottom').style.borderBottom = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('zoomLeft').style.borderLeft = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('zoomRight').style.borderRight = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('liveViewZoomTop').style.borderTop = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('liveViewZoomBottom').style.borderBottom = (((position/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('liveViewZoomLeft').style.borderLeft = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
							document.getElementById('liveViewZoomRight').style.borderRight = (((position/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
							var changeValue = document.getElementById('upDownValue');
							var changeBottomValue = document.getElementById('DownValue');
							var changeLeftValue = document.getElementById('leftRightValue');
							var changeRightValue = document.getElementById('RightValue');
							changeValue.value = position;
							changeBottomValue.value = position;
							changeLeftValue.value = position;
							changeRightValue.value = position;
						
					}
				});
				
				$(document).mouseup(function() {
					e.preventDefault();
					controller = false;
				});
			});
			
			// when user changes value in input
			$(input).change(function() {
				//modify OUT Line value
				var outCurrentValue = document.getElementById('zoomValue').value;
				var newOutValue = outCurrentValue;		
				if (newOutValue <=100 && newOutValue >= 0) {
					document.getElementById('zoomCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue +"%";
					document.getElementById('zoomTop').style.borderTop = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('zoomBottom').style.borderBottom = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('zoomLeft').style.borderLeft = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('zoomRight').style.borderRight = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('liveViewZoomTop').style.borderTop = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('liveViewZoomBottom').style.borderBottom = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('liveViewZoomLeft').style.borderLeft = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
					document.getElementById('liveViewZoomRight').style.borderRight = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
					
					var changeValue = document.getElementById('upDownValue');
					var changeBottomValue = document.getElementById('DownValue');
					var changeLeftValue = document.getElementById('leftRightValue');
					var changeRightValue = document.getElementById('RightValue');
					changeValue.value = newOutValue;
					changeBottomValue.value = newOutValue;
					changeLeftValue.value = newOutValue;
					changeRightValue.value = newOutValue;
				} else {
					alert("Out of range");
				}
			});
		});
		
		// checks if value is within boundaries
		function checkBoundaries(value) {
			if (value < options.lowerBound*0)
				return options.lowerBound*0;
			else if (value > options.upperBound*10)
				return options.upperBound*10;
			else
				return value;
		}
		
		// checks ie version
		function getInternetExplorerVersion(){
		   var rv = -1;
		   if (navigator.appName == 'Microsoft Internet Explorer') {
			  var ua = navigator.userAgent;
			  var re  = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
			  if (re.exec(ua) != null)
				 rv = parseFloat( RegExp.$1 );
		   }
		   return rv;
		}
		return this;
	 }
	 
	 
})(jQuery);

function resetZoom(){
		
		var outCurrentValue = 0;
		var newOutValue = outCurrentValue;	
		document.getElementById('zoomCell').getElementsByClassName("slideControlFill")[0].style.width = newOutValue +"%";
		document.getElementById('zoomTop').style.borderTop = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('zoomBottom').style.borderBottom = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('zoomLeft').style.borderLeft = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('zoomRight').style.borderRight = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('liveViewZoomTop').style.borderTop = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('liveViewZoomBottom').style.borderBottom = (((newOutValue/240)*100))*2.88+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('liveViewZoomLeft').style.borderLeft = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
		document.getElementById('liveViewZoomRight').style.borderRight = (((newOutValue/320)*100))*5.12+ "px solid rgba(255, 0, 0, 0.5)";
			
		var changeZoomValue = document.getElementById('zoomValue');
		var changeValue = document.getElementById('upDownValue');
		var changeBottomValue = document.getElementById('DownValue');
		var changeLeftValue = document.getElementById('leftRightValue');
		var changeRightValue = document.getElementById('RightValue');
		changeValue.value = 0;
		changeBottomValue.value = 1;
		changeLeftValue.value = 0;
		changeRightValue.value = 1;
		changeZoomValue.value = 0;
		document.getElementById('roiX').value = 0;
		document.getElementById('roiY').value = 0;
		document.getElementById('roiW').value = 1;
		document.getElementById('roiH').value = 1;
		document.getElementById('prevZoomX').value = 0;
		document.getElementById('prevZoomY').value = 0;
		document.getElementById('prevZoomW').value = 0;
		document.getElementById('prevZoomH').value = 0;

		document.getElementById('notice8').innerHTML = "Please wait ...";
		var roiX = "0";
		var roiY = "0";
		var roiW = "1";
		var roiH = "1";
		var newZoomX = "0";
		var newZoomY = "0";

		var prevZoomW = "0";
		
		var prevZoomH = "0";
		
		
		//pass flag, if any any conditions fail then it will become 0
		var pass = "1";
		
		//ROIX
		if (roiX == "" || roiX == " " || roiX == "  " || roiX == "   ") {
		    pass = "0";
		    //alert(pass);
		}
		else if (!isNaN(roiX)) {
			if (roiX > 100 || roiX < 0) {
			    pass = "0";
			}
		}

		else {
			pass = "0";
		}

		//ROIY
		if (roiY == "" || roiY == " " || roiY == "  " || roiY == "   ") {
			pass = "0";
		}
		else if (!isNaN(roiY)) {
			if (roiY > 100 || roiY < 0) {
			    pass = "0";
			}
		}

		else {
			pass = "0";
		}

		//ROIW
		if (roiW == "" || roiW == " " || roiW == "  " || roiW == "   ") {
			pass = "0";
		}
		else if (!isNaN(roiW)) {
			if (roiW > 100 || roiW < 0) {
			    pass = "0";
			}
		}

		else {
			pass = "0";
		}

		//ROIH
		if (roiH == "" || roiH == " " || roiH == "  " || roiH == "   ") {
			pass = "0";
		}
		else if (!isNaN(roiH)) {
			if (roiH > 100 || roiH < 0) {
			    pass = "0";
			}
		}

		else {
			pass = "0";
		}


        //PREVZOOMX
        if (newZoomX == "" || newZoomX == " " || newZoomX == "  " || newZoomX == "   ") {
            pass = "0";
            console.log("newZoomX empty");
        }
        else if (!isNaN(newZoomX)) {
            if (newZoomX > 100 || newZoomX < 0) {
                pass = "0";
                console.log("newZoomX over");
            }
        }

        else {
            pass = "0";
            console.log("newZoomX error");
        }

        //PREVZOOMY
        if (newZoomY == "" || newZoomY == " " || newZoomY == "  " || newZoomY == "   ") {
            pass = "0";
            console.log("newZoomY empty");
        }
        else if (!isNaN(newZoomY)) {
            if (newZoomY > 100 || newZoomY < 0) {
                pass = "0";
                console.log("newZoomY over");
            }
        }

        else {
            pass = "0";
            console.log("newZoomY error");
        }

        //prevZoomW
        if (prevZoomW == "" || prevZoomW == " " || prevZoomW == "  " || prevZoomW == "   ") {
            pass = "0";
            console.log("prevZoomW empty");
        }
        else if (!isNaN(prevZoomW)) {
            if (prevZoomW > 100 || prevZoomW < 0) {
                pass = "0";
                console.log("prevZoomW over");
            }
        }

        else {
            pass = "0";
            console.log("prevZoomW error");
        }

        //prevZoomH
        if (prevZoomH == "" || prevZoomH == " " || prevZoomH == "  " || prevZoomH == "   ") {
            pass = "0";
            console.log("prevZoomH empty");
        }
        else if (!isNaN(prevZoomH)) {
            if (prevZoomH > 100 || prevZoomH < 0) {
                pass = "0";
                console.log("prevZoomH over");
            }
        }

        else {
            pass = "0";
            console.log("prevZoomH error");
        }

		if (pass == "1") {
			//alert("hit");
			var xmlhttp;
			document.getElementById('notice8').innerHTML = "Updating settings. Please wait..."
			if (window.XMLHttpRequest) {
			    xmlhttp = new XMLHttpRequest();
			}
			xmlhttp.onreadystatechange = function () {
			    if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
			        var dummy = xmlhttp.responseText;
			        if (dummy == 1) {
			            document.getElementById('notice8').innerHTML = "Viewing area have been reset!"
			        }
			        else {
			            document.getElementById('notice8').innerHTML = "Parameters not updated! Please retry."
			            console.log(roiX);
			            console.log(roiY);
			            console.log(roiW);
			            console.log(roiH);
			        }

			    }
			}
			xmlhttp.open("POST", "/cgi-bin/setZoomParameter.cgi", true);
			xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xmlhttp.send("roiX=" + roiX + "&roiY=" + roiY + "&roiW=" + roiW + "&roiH=" + roiH + "&newZoomX=" + newZoomX + "&newZoomY=" + newZoomY + "&prevZoomW=" + prevZoomW + "&prevZoomH=" + prevZoomH);
			;


			//setTimeout(function () { window.location.reload() }, 3000);
			//console.log("left= " + ignoreLeft + ", right= " + ignoreRight);
		}


			return false;


	 }







