﻿var HtmlTableUtility = {
    GetTableContentHTML: function (data) {
        var dataTableHtmlContent = "";
        $.each(data.ObjectList, function (objectListIndex, object) {
            $.each(data.DateTimeList, function (dateTimeListIndex, dateValue) {
                var dynamicColumn = "";
                $.each(data.MetricList, function (metricListIndex, metricName) {
                    dynamicColumn += `<td>${data.DataObject[metricName][object.ID][dateTimeListIndex]}</td>`;
                });
                dataTableHtmlContent += `
                                <tr>
                                    <td>${object.Name}</td>
                                    <td>${dateValue}</td>
                                    ${dynamicColumn}
                                </tr>`;
            });
        });
        return dataTableHtmlContent;
    },
    GetTableHeaderHTML: function (headerList) {
        var
            dynamicColumn = "",
            dataTableHtmlHeader = "";
        $.each(headerList, function (index, header) {
            dynamicColumn += `<th>${header}</th>`;
        });
        dataTableHtmlHeader += `
                <tr>
                    ${dynamicColumn}
                </tr>
            `;
        return dataTableHtmlHeader;
    },
    RenderToTBody: function (renderElement, dataTableHtmlContent) {
        $(renderElement).find("tbody").empty().html(dataTableHtmlContent);
    },
    RenderToTHead: function (renderElement, dataTableHtmlHeader) {
        $(renderElement).find("thead").empty().html(dataTableHtmlHeader);
    },
    InitializeSparkLine: function (tableSelector) {
        Highcharts.SparkLine = function (a, b, c) {
            var hasRenderToArg = typeof a === 'string' || a.nodeName,
                options = arguments[hasRenderToArg ? 1 : 0],
                defaultOptions = {
                    chart: {
                        renderTo: (options.chart && options.chart.renderTo) || this,
                        backgroundColor: null,
                        borderWidth: 0,
                        type: 'area',
                        margin: [2, 0, 2, 0],
                        width: 120,
                        height: 20,
                        style: {
                            overflow: 'visible'
                        },

                        // small optimalization, saves 1-2 ms each sparkline
                        skipClone: true
                    },
                    title: {
                        text: ''
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        labels: {
                            enabled: false
                        },
                        title: {
                            text: null
                        },
                        startOnTick: false,
                        endOnTick: false,
                        tickPositions: []
                    },
                    yAxis: {
                        endOnTick: false,
                        startOnTick: false,
                        labels: {
                            enabled: false
                        },
                        title: {
                            text: null
                        },
                        tickPositions: [0]
                    },
                    legend: {
                        enabled: false
                    },
                    tooltip: {
                        hideDelay: 0,
                        outside: true,
                        shared: true
                    },
                    plotOptions: {
                        series: {
                            animation: false,
                            lineWidth: 1,
                            shadow: false,
                            states: {
                                hover: {
                                    lineWidth: 1
                                }
                            },
                            marker: {
                                radius: 1,
                                states: {
                                    hover: {
                                        radius: 2
                                    }
                                }
                            },
                            fillOpacity: 0.25
                        },
                        column: {
                            negativeColor: '#910000',
                            borderColor: 'silver'
                        }
                    }
                };

            options = Highcharts.merge(defaultOptions, options);

            return hasRenderToArg ?
                new Highcharts.Chart(a, options, c) :
                new Highcharts.Chart(options, b);
        };

        var start = +new Date(),
            $tds = $(tableSelector + ' td[data-sparkline]'),
            fullLen = $tds.length,
            n = 0;
        //console.log($tds);

        function doChunk() {
            var time = +new Date(),
                i,
                len = $tds.length,
                $td,
                stringdata,
                dataUnit,
                chartType = "",
                arr,
                data,
                chart;

            for (i = 0; i < len; i += 1) {
                $td = $($tds[i]);
                stringdata = $td.data('sparkline');
                dataUnit = !$td.data('sparkline-unit') || $td.data('sparkline-unit') == "undefined" ?
                    "" :
                    $td.data('sparkline-unit');
                chartType = !$td.data('sparkline-chart-type') || $td.data('sparkline-chart-type') ==
                    "undefined" ?
                    "" :
                    $td.data('sparkline-chart-type');
                arr = stringdata.split('; ');
                data = $.map(arr[0].split(', '), parseFloat);
                chart = {};

                if (chartType) {
                    chart.type = chartType;
                }
                $td.highcharts('SparkLine', {
                    series: [{
                        data: data,
                        pointStart: 1
                    }],
                    tooltip: {
                        headerFormat: '',
                        pointFormat: '<b>{point.y}</b> ' + dataUnit
                    },
                    chart: chart
                });

                n += 1;

                // If the process takes too much time, run a timeout to allow interaction with the browser
                if (new Date() - time > 500) {
                    $tds.splice(0, i + 1);
                    setTimeout(doChunk, 0);
                    break;
                }

                // Print a feedback on the performance
                if (n === fullLen) {
                    $('#result').html('Generated ' + fullLen + ' sparklines in ' + (new Date() -
                        start) + ' ms');
                }
            }
        }
        doChunk();
    },
    RenderData: function (obj, formatData) {

        var dynamicTableContent = {
            header: "",
            body: ""
        };

        $.each(obj.tableData.TableHeaderList, function (headerIndex, headerRow) {
            dynamicTableContent.header += "<tr>";
            $.each(headerRow, function (headerNameIndex, headerValue) {
                dynamicTableContent.header += headerValue;
            });
            dynamicTableContent.header += "</tr>";
        });

        $.each(obj.tableData.DateTimeList, function (dateTimeListIndex, dateValue) {
            $.each(obj.tableData.ObjectList, function (counterListIndex, counter) {
                var dynamicColumn = "";
                $.each(obj.tableData.MetricList, function (metricListIndex, metricName) {
                    $.each(obj.tableData.DataObject[metricName][counter.ID][dateTimeListIndex], function (valueIndex, value) {
                        if (obj.tableData.DataObject[metricName].RenderToChart) {
                            dynamicColumn +=
                                `<td 
                                data-sparkline='${(formatData != null && formatData != false) ? Page.formatDataAccordingToDataType(value, metricName) : value}' 
                                data-sparkline-unit='${obj.tableData.DataObject[metricName].Unit}'
                                data-sparkline-chart-type='${obj.tableData.DataObject[metricName].ChartType}'>
                            </td>`;
                        } else {
                            dynamicColumn +=
                                `<td>${(formatData != null && formatData != false) ? Page.formatDataAccordingToDataType(value, metricName) : value}</td>`;
                        }
                    });
                });
                dynamicTableContent.body += `
                <tr>
                    <td>${counter.Name}</td>
                    <td>${dateValue}</td>
                    ${dynamicColumn}
                </tr>`;
            });
        });
        $(obj.tableSelector).html(`
            <thead>${dynamicTableContent.header}</thead>
            <tbody>${dynamicTableContent.body}</tbody>
        `);
    }
}