function nFormatter(num, digits) {
    var units = ['k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'],
        decimal;


    for (var i = units.length - 1; i >= 0; i--) {
        decimal = Math.pow(1000, i + 1);
        if (num <= -decimal || num >= decimal) {
            return +(num / decimal).toFixed(digits) + units[i];
        }
    }

    return num;
}

function zeroChecker(val) {
    if (val == 0) {
        return "-";
    }
    else {
        return val;
    }
}

function HideGeneralDialog() {
    $('#generalDialog').modal("hide");
}

function WindowOpen(url, mode) {
    var windowOpenAction = window.open(url, mode);
    if (!windowOpenAction || windowOpenAction.closed || typeof windowOpenAction.closed == 'undefined') {
        toastr.info("Pop-ups were blocked on this page, please allow pop-ups on this page", "Information");
    }
}

function ShowLoadingPrompt(loadingMessage) {
    if (loadingMessage != undefined && loadingMessage != "") {
        $('#LoadingDialog').find('.modal-title').html("Please wait");
        $('#LoadingDialog').find('.modal-body').html("<p>" + loadingMessage + "...<span class='loadingSpinner'><i class='fa fa-circle-o-notch fa-spin fa-3x fa-fw'></i></span></p>");
        $('#LoadingDialog').find('.modal-footer').html("");
        $('#LoadingDialog').modal({
            show: true,
            backdrop: 'static',
            keyboard: false
        });
        $('#LoadingDialog').on('hidden.bs.modal', function () {
            $('#page-svg-loading').fadeOut();
        })
    }
}

function HideLoadingPrompt() {
    $('#LoadingDialog').modal("hide");
}

function ShowModal(header, content) {
    prompt(header, content, "<button class='btn btn-primary' id='btnMyModal' data-dismiss='modal'>OK</button>");
}

function Alert(MessageObject) {
    prompt(MessageObject.Header, MessageObject.Body, MessageObject.Footer);
    return false;
}

function prompt(header, bodyContent, footerContent) {
    $('#generalDialog').find('.modal-title').html(header);
    $('#generalDialog').find('.modal-body').html(bodyContent);
    footerContent = footerContent ? footerContent : '<button class="btn btn-default" data-dismiss="modal">Close</button>';
    $('#generalDialog').find('.modal-footer').html(footerContent);
    $('#generalDialog').modal({
        show: true,
        backdrop: 'static',
        keyboard: false
    });

    //$('#generalDialog').on('click', '[data-dismiss="modal"]', function (e) { e.stopPropagation(); });

    $('#generalDialog').on('hidden.bs.modal', function () {
        $('#page-svg-loading').fadeOut();
        $('.modal-backdrop').fadeOut();
    })
    InitializeBootstrapTooltip();
}


function promptStartEndDateErrorDialog(header, bodyContent, footerContent) {
    $('#startEndDateErrorDialog').find('.modal-title').html(header);
    $('#startEndDateErrorDialog').find('.modal-body').html(bodyContent);
    footerContent = footerContent ? footerContent : '<button class="btn btn-default" data-dismiss="modal">Close</button>';
    $('#startEndDateErrorDialog').find('.modal-footer').html(footerContent);
    $('#startEndDateErrorDialog').modal({
        show: true,
        backdrop: 'static',
        keyboard: false
    });

    $('#startEndDateErrorDialog').on('hidden.bs.modal', function () {
        $('#page-svg-loading').fadeOut();
        $('.modal-backdrop').fadeOut();
    })
    InitializeBootstrapTooltip();
}


function InitializeBootstrapTooltip() {
    $('[data-toggle="tooltip"]').tooltip({ html: true });
}

function ClearLeftoverTooltip() {
    $("div.tooltip-inner").remove();
    $(".tooltip.fade.top.in").remove();
}

function InitializeSalesConversionRangeThreshold() {
    $("#inputSalesConversionRangeThreshold").slider({
        range: true,
        min: 0,
        max: 100,
        values: [10, 70],
        slide: function (event, ui) {
            $("#inputSalesConversionThresholdMin").data("value", ui.values[0]).text(ui.values[0] + "%");
            $("#inputSalesConversionThresholdMax").data("value", ui.values[1]).text(ui.values[1] + "%");
        }
    });
    var inputSalesConversionMinThreshold = $("#inputSalesConversionRangeThreshold").slider("values", 0);
    var inputSalesConversionMaxThreshold = $("#inputSalesConversionRangeThreshold").slider("values", 1);
    $("#inputSalesConversionThresholdMin").data("value", inputSalesConversionMinThreshold).text(inputSalesConversionMinThreshold + "%");
    $("#inputSalesConversionThresholdMax").data("value", inputSalesConversionMaxThreshold).text(inputSalesConversionMaxThreshold + "%");
}

function promptStatic(header, bodyContent) {
    $('#generalDialog').find('.modal-title').html(header);
    $('#generalDialog').find('.modal-body').html(bodyContent);
    $('#generalDialog').find('.modal-footer').html("");
    $('#generalDialog').modal({
        show: true,
        backdrop: 'static',
        keyboard: false
    });

    $('#generalDialog').on('hidden.bs.modal', function () {
        $('#page-svg-loading').fadeOut();
    })

}

function doneTyping(element, checking) {
    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 1000;  //time in ms, 1 second for example
    var $input = element;

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(doneTyping, doneTypingInterval);
    });

    //on keydown, clear the countdown 
    $input.on('keydown', function () {
        clearTimeout(typingTimer);
    });

    //user is "finished typing," do something
    function doneTyping() {


    }
}

function splitAppendIP(IP, innerInput, cCount) {
    if (IP != undefined && IP != "") {
        var innerIP = IP.split('.');
        if (innerInput == "counter-ip") {
            for (var i = 0; i < 4; i++) {
                var x = ".input-" + innerInput + "-" + cCount + "-";
                x = x + i;
                $(x).val(innerIP[i]);
            }
        } else {
            for (var i = 0; i < 4; i++) {
                var x = ".input-" + innerInput + "-";
                x = x + i;
                $(x).val(innerIP[i]);
            }
        }
    }
}

function appendIP(IPAddress, input, counterCount) {
    switch (input) {
        case "counter-ip":
            splitAppendIP(IPAddress, "counter-ip", counterCount)
            break;
        case "subnet":
            splitAppendIP(IPAddress, "subnet");
            break;
        case "gateway":
            splitAppendIP(IPAddress, "gateway");
            break;
        case "proxy":
            splitAppendIP(IPAddress, "proxy");
            break;
        case "primary-dns":
            splitAppendIP(IPAddress, "primary-dns");
            break;
        case "secondary-dns":
            splitAppendIP(IPAddress, "secondary-dns");
            break;
    }
}

function IsFunction(functionToCheck) {
    return functionToCheck && {}.toString.call(functionToCheck) === '[object Function]';
}

function CustomConfirm(message, yesCallback, noCallback) {
    $('#generalDialog').find('.modal-title').html("Confirmation");
    $('#generalDialog').find('.modal-body').html(message);
    var footerContent = '<button class="btn btn-default" data-dismiss="modal" id="CustomDialogNo">Cancel</button>' + '<button id="CustomDialogYes" class="btn btn-primary" data-dismiss="modal">Confirm</button>'
    $('#generalDialog').find('.modal-footer').html(footerContent);
    $('#generalDialog').modal({
        show: true,
        backdrop: 'static',
        keyboard: false
    });

    $("#CustomDialogNo").unbind().click(function () {
        $('#CustomDialog').modal("hide");
        if (IsFunction(noCallback)) {
            noCallback();
        }
    })

    $("#CustomDialogYes").unbind().click(function () {
        $('#CustomDialog').modal("hide");
        if (IsFunction(yesCallback)) {
            yesCallback();
        }
    })
}

function greetUser(user) {

    var d = new Date(),
        h = d.getHours(),
        greet = "";
    var a;
    greet = h < 12 ? "Good morning" :
        h == 12 ? "Have a good noon" :
            h >= 13 && h <= 17 ? "Good evening" :
                h > 17 && h <= 20 ? "Good late evening" :
                    "Good night";
    a = user === "" ? "user" : user;

    var greetPhrase = [
        "Hi, " + a + ".",
        "Nice to meet you, " + a + ".",
        greet + ", " + a + ".",
        "It's been long time, " + a + ".",
        "Welcome to portal, " + a + ".",
        "Hey, " + a + ", " + greet.toLowerCase() + "!",
        "Good day, " + a + ", what would you be up to?",
        "Hello, hope you're fine," + a + ".",
        "Do have a great job today, " + a + ", wish you a " + greet.toLowerCase() + ".",
        "Hey! " + a + ".",
        greet + ".",
    ];
    greetPhrase = greetPhrase[Math.floor(Math.random() * greetPhrase.length)];
    return greetPhrase;
}

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}

function noSpecialCharacter(elementArray) {
    "use strict";
    $.each(elementArray, function (i, elem) {
        elem
            .bind('keypress', function (e) {
                switch ($(this).attr('id')) {
                    case "branchCode": //ConfigureSite
                        if (e.which < 48 || (e.which > 57 && e.which < 65) || (e.which > 90 && e.which < 97) || e.which > 122) {
                            e.preventDefault();
                            return false;
                        }
                        break;
                    case "counterName": //CounterManagement
                        if (e.which < 48 || (e.which > 57 && e.which < 65) || (e.which > 90 && e.which < 97) || e.which > 122) {
                            e.preventDefault();
                            return false;
                        }
                        break;
                    case "ServerIP": //ConfigureSite
                        var blockedKey = [32];
                        if ($.inArray(e.which, blockedKey) > -1) {
                            e.preventDefault();
                            return false;
                        }
                        break;
                    default:
                        if (e.which < 48 || (e.which > 57 && e.which < 65) || (e.which > 90 && e.which < 97) || e.which > 122) {
                            if (e.which == 32) {
                                return true;
                            } else {
                                e.preventDefault();
                                return false;
                            }
                        }
                        break;
                }

            });
    })

}

function getClientTimeZone() //get client computer timezone
{
    var rightNow = new Date();
    var jan1 = new Date(rightNow.getFullYear(), 0, 1, 0, 0, 0, 0);
    var temp = jan1.toGMTString();
    var jan2 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
    var std_time_offset = (jan1 - jan2) / (1000 * 60 * 60);
    var june1 = new Date(rightNow.getFullYear(), 6, 1, 0, 0, 0, 0);
    temp = june1.toGMTString();
    var june2 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
    var daylight_time_offset = (june1 - june2) / (1000 * 60 * 60);
    return daylight_time_offset;
}

function preventUnsaved(saved) {
    var unsaved = false;
    $(":input").change(function () { //trigers change in all input fields including text type
        //  console.log($(this));
        unsaved = true;
    });

    function unloadPage() {
        if (saved) {

        } else {
            if (unsaved) {
                return "You have unsaved changes on this page. Do you want to leave this page and discard your changes or stay on this page?";
            }
        }
    }

    window.onbeforeunload = unloadPage;
}

var removeByAttr = function (arr, attr, value) {
    var i = arr.length;
    while (i--) {
        if (arr[i]
            && arr[i].hasOwnProperty(attr)
            && (arguments.length > 2 && arr[i][attr] === value)) {

            arr.splice(i, 1);

        }
    }
    return arr;
}

function DateTimeSingleOrPlural(v, t) {
    r = v == 0 ? "" : v > 1 ? v + " " + t + "s " : v + " " + t + " ";
    return r;
}

function ConvertHumanReadableMinute(minutes) {
    MINS_PER_YEAR = 24 * 365 * 60;
    MINS_PER_MONTH = 24 * 30 * 60;
    MINS_PER_WEEK = 24 * 7 * 60;
    MINS_PER_DAY = 24 * 60;
    MINS_PER_HOUR = 60;
    years = Math.floor(minutes / MINS_PER_YEAR)
    minutes = minutes - years * MINS_PER_YEAR
    months = Math.floor(minutes / MINS_PER_MONTH)
    minutes = minutes - months * MINS_PER_MONTH
    weeks = Math.floor(minutes / MINS_PER_WEEK)
    minutes = minutes - weeks * MINS_PER_WEEK
    days = Math.floor(minutes / MINS_PER_DAY)
    minutes = minutes - days * MINS_PER_DAY
    hours = Math.floor(minutes / MINS_PER_HOUR)
    minutes = parseInt(minutes - hours * MINS_PER_HOUR)
    //years = years == 0 ? "" : years > 1 ? years + " years " : years + " year";
    //months = months == 0 ? "" : months > 1 ? months + " months " : months + " month";
    //days = days == 0 ? "" : days > 1 ? days + " days " : days + " day";
    //hours = hours == 0 ? "" : hours > 1 ? hours + " hours " : hours + " hour";
    //minutes = minutes == 0 ? "" : minutes > 1 ? minutes + " minutes " : minutes + " minute";
    years = DateTimeSingleOrPlural(years, "year");
    months = DateTimeSingleOrPlural(months, "month");
    weeks = DateTimeSingleOrPlural(weeks, "week");
    days = DateTimeSingleOrPlural(days, "day");
    hours = DateTimeSingleOrPlural(hours, "hour");
    minutes = DateTimeSingleOrPlural(minutes, "minute");
    return years + months + weeks + days + hours + minutes;
    //return hrData; // 1 year, 2 months, 2 week, 2 days, 12 minutes
}

function GetURLParam() {
    var urlParams;
    (window.onpopstate = function () {
        var match,
            pl = /\+/g,  // Regex for replacing addition symbol with a space
            search = /([^&=]+)=?([^&]*)/g,
            decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
            query = window.location.search.substring(1);

        urlParams = {};
        while (match = search.exec(query))
            urlParams[decode(match[1])] = decode(match[2]);
    })();
    return urlParams;
}

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function GetSelectedValueToString(elementSelector) {
    var selectorString = elementSelector + ":checkbox:checked";
    var selectedValueString = $(selectorString).map(function () { return this.value; }).get().join(',');
    return selectedValueString;
}

function clearTimePickerRange(o, elem) {
    var startElement = "." + o + "-start-time";
    var endElement = "." + o + "-end-time";
    var thisTimeRangeContainer = elem.parents(".container-time-range");
    thisTimeRangeContainer.find(startElement).click();
    var thisElementList = $(".ui-timepicker-list:visible");
    thisElementList.find("li").removeClass("ui-timepicker-disabled");
    thisTimeRangeContainer.find(endElement).click();
    var thisElementList = $(".ui-timepicker-list:visible");
    thisElementList.find("li").removeClass("ui-timepicker-disabled");
    thisElementList.parent().hide();
}

function urlExists(testUrl) {
    var http = jQuery.ajax({
        type: "HEAD",
        url: testUrl,
        async: false
    })
    return http.status;
    // this will return 200 on success, and 0 or negative value on error
}

function resetToastOption(t) {
    setTimeout(function () {
        t.options = {
            "closeButton": true,
            "debug": false,
            "progressBar": true,
            "preventDuplicates": false,
            "positionClass": "toast-top-right",
            "onclick": null,
            "showDuration": "400",
            "hideDuration": "1000",
            "timeOut": "7000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    }, 1500);
}

function getCaretPosition(editableDiv) {
    var caretPos = 0,
        sel, range;

    if (window.getSelection) {
        if ($(editableDiv).prop("tagName") == "INPUT") {
            caretPos = $(editableDiv).val().slice(0, $(editableDiv)[0].selectionStart).length;
        } else {
            sel = window.getSelection();
            if (sel.rangeCount) {
                range = sel.getRangeAt(0);
                if (range.commonAncestorContainer.parentNode == $(editableDiv)[0]) {
                    caretPos = range.endOffset;
                }
            }
        }

    } else if (document.selection && document.selection.createRange) {
        range = document.selection.createRange();
        if (range.parentElement() == $(editableDiv)[0]) {
            var tempEl = document.createElement("span");
            $(editableDiv)[0].insertBefore(tempEl, $(editableDiv)[0].firstChild);
            var tempRange = range.duplicate();
            tempRange.moveToElementText(tempEl);
            tempRange.setEndPoint("EndToEnd", range);
            caretPos = tempRange.text.length;
        }
    }

    return caretPos;
}

function insertAtCursor(myField, myValue, currentPos) {
    //IE support
    if (document.selection) {
        myField.focus();
        sel = document.selection.createRange();
        sel.text = myValue;
    }
    //MOZILLA and others
    else {
        var finalOutput = "";
        if ($(myField).prop("tagName") == "INPUT") {
            finalOutput += $(myField).val().substring(0, currentPos);
            finalOutput += myValue;
            finalOutput += $(myField).val().substring(currentPos, $(myField).val().length);
            $(myField).val(finalOutput);
        } else {
            finalOutput += $(myField).text().substring(0, currentPos);
            finalOutput += myValue;
            finalOutput += $(myField).text().substring(currentPos, $(myField).text().length);
            $(myField).text(finalOutput);
        }
    }
}

function PasteHtmlAtCaret(html, $selector) {
    var sel, range;
    if (window.getSelection) {
        // IE9 and non-IE
        sel = window.getSelection();
        if (sel.getRangeAt && sel.rangeCount) {
            range = sel.getRangeAt(0);
            range.deleteContents();

            // Range.createContextualFragment() would be useful here but is
            // non-standard and not supported in all browsers (IE9, for one)
            var el = $selector[0];
            el.innerHTML = html + el.innerHTML;
            var frag = document.createDocumentFragment(), node, lastNode;
            while ((node = el.firstChild)) {
                lastNode = frag.appendChild(node);
            }
            range.insertNode(frag);

            // Preserve the selection
            if (lastNode) {
                range = range.cloneRange();
                range.setStartAfter(lastNode);
                range.collapse(true);
                sel.removeAllRanges();
                sel.addRange(range);
            }
        }
    }
    //else if (document.selection && document.selection.type != "Control") {
    //    // IE < 9
    //    document.selection.createRange().pasteHTML(html);
    //}
}

function SetCaretAtEnd(elem) {
    elem = elem[0];
    var elemLen = elem.innerHTML.length;
    // For IE Only
    if (document.selection) {
        // Set focus
        elem.focus();
        // Use IE Ranges
        var oSel = document.selection.createRange();
        // Reset position to 0 & then set at end
        oSel.moveStart('character', -elemLen);
        oSel.moveStart('character', elemLen);
        oSel.moveEnd('character', 0);
        oSel.select();
    }
    else if (elem.selectionStart || elem.selectionStart == '0') {
        // Firefox/Chrome
        elem.selectionStart = elemLen;
        elem.selectionEnd = elemLen;
        elem.focus();
    } // if
}

function DateNow() {
    var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sept", "Oct", "Nov", "Dec"];
    var d = new Date();
    var curr_year = d.getFullYear().toString().substr(2, 2);
    var curr_month = monthNames[d.getMonth()];
    var curr_date = ('0' + (d.getDate())).slice(-2);
    //var curr_hour = ('0' + (d.getHours())).slice(-2);
    //var curr_minute = ('0' + (d.getMinutes())).slice(-2);
    //var curr_second = ('0' + (d.getSeconds())).slice(-2);
    var currentDate = curr_date + " " + curr_month + " " + curr_year;
    return currentDate;
}

function DateTimeNow_Local() {
    var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sept", "Oct", "Nov", "Dec"];
    var d = new Date();
    var curr_year = d.getFullYear().toString().substr(2, 2);
    var curr_month = monthNames[d.getMonth()];
    var curr_date = ('0' + (d.getDate())).slice(-2);
    var curr_hour = ('0' + (d.getHours())).slice(-2);
    var curr_minute = ('0' + (d.getMinutes())).slice(-2);
    var currentDateTime = curr_date + " " + curr_month + " " + curr_year + " " + curr_hour + ":" + curr_minute;
    return currentDateTime;
}

function GetNavHighlight(urlParam) {
    var navHighlight = "";
    if (urlParam.MenuId != undefined && urlParam.indexlist != undefined) {
        navHighlight = "&MenuId=" + urlParam.MenuId + "&indexlist=" + urlParam.indexlist;
    }
    return navHighlight;
}

function IsThisServer(counterServerAddress, thisBrowserURLHost) {
    counterServerAddress = counterServerAddress.replace("http://", "").replace("https://", "").replace("/", "")
    thisBrowserURLHost = thisBrowserURLHost.replace("www.", "");

    var isThisServer = false;
    if
    (
        counterServerAddress == thisBrowserURLHost ||
        counterServerAddress == "footfallcounter.com" && thisBrowserURLHost == "portal.footfallcam.com" ||
        counterServerAddress == "portal.footfallcam.com" && thisBrowserURLHost == "footfallcounter.com"
    )
    {
        isThisServer = true;
    }
    return isThisServer;
}

function DoneTypingTrigger(elementToMonitored, actionToRun, intervalToWait) {
    //setup before functions
    var typingTimer;                //timer identifier
    var $input = elementToMonitored;

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(actionToRun, intervalToWait);
    });

    //on keydown, clear the countdown 
    $input.on('keydown', function () {
        clearTimeout(typingTimer);
    });
}

(function ($) {
    $.fn.DoneTyping = function (callback) {
        var _this = $(this);
        var x_timer;
        _this.keyup(function () {
            clearTimeout(x_timer);
            x_timer = setTimeout(clear_timer, 1000);
        });

        function clear_timer() {
            clearTimeout(x_timer);
            callback.call(_this);
        }
    }
    $.fn.IsNullOrEmpty = function () {
        if ($(this) == undefined || $(this).val() == null || $(this).val() == "")
            return true;
        else
            return false;
    }
    $(".containerSectionHeader").unbind("click").click(function () {
        var thisSectionContainer = $(this).parents("section");
        var thisSectionBody = thisSectionContainer.find(".containerSectionBody");
        if (thisSectionBody.data("is-collapsed") == false) {
            thisSectionBody.data("is-collapsed", true);
        } else {
            thisSectionBody.data("is-collapsed", false);
        }
        CollapseSectionBody(thisSectionContainer, thisSectionBody.data("is-collapsed"));
    })
})(jQuery);

//Populate a collection of company list into select element with id="selectorCompany" [KelvinYap]
function populateCompanySelector($elem, companyList) {
    $elem.children().remove(); //Clear options to repopulate
    $elem.append("<option value='' class='opt-company'>- All Companies - </option>");
    //Append Company
    var fragment = document.createDocumentFragment();
    for (var i = 0; i < companyList.length; i++) {
        $elem.append("<option value='" + companyList[i].CompanyID + "' class='opt-company'>" + companyList[i].CompanyName + "</option>");
    }
    InitSelect2($elem, "", 0, 0);
}

//Populate a collection of region and sites list into select element [KelvinYap]
function populateSiteSelector($elem, storesList, regionList) {
    $elem.children().remove();
    $elem.append("<option class='opt-company' value=''>- " + LanguageAllSites + " - </option>");                              //Clear options
    if (regionList.length != 0) {
        $elem.children("option[value='']").html("- " + LanguageAllSites + " - ");
        //Append Region
        $elem.append("<option class='RegionTitle' disabled='disabled'>" + LanguageRegion + "</option>");
        for (var i = 0; i < regionList.length; i++) {
            $elem.append("<option class='opt-region' value='" + regionList[i] + "'>" + regionList[i] + "</option>");
        }
    }

    if (storesList.length != 0) {
        //Append Sites
        if (regionList.length != 0)
            $elem.append("<option class='SiteTitle' disabled='disabled'>" + LanguageSite + "</option>");
        for (var i = 0; i < storesList.length; i++) {
            $elem.append("<option class='opt-branch' value='" + storesList[i].BranchID + "'>" + storesList[i].BranchName + "</option>");
        }
        $elem.prop("disabled", false);
    }
    $elem.prop('selectedIndex', 0); //Reset the selection
    InitSelect2($elem, "", 0, 0);
}

function populateSiteSelectorWithoutAll($elem, storesList, regionList) {
    $elem.children().remove();
    if (regionList.length != 0) {
        $elem.children("option[value='']").html("- " + LanguageAllSites + " - ");
        //Append Region
        $elem.append("<option class='RegionTitle' disabled='disabled'>" + LanguageRegion + "</option>");
        for (var i = 0; i < regionList.length; i++) {
            $elem.append("<option class='opt-region' value='" + regionList[i] + "'>" + regionList[i] + "</option>");
        }
    }

    if (storesList.length != 0) {
        //Append Sites
        if (regionList.length != 0)
            $elem.append("<option class='SiteTitle' disabled='disabled'>" + LanguageSite + "</option>");
        for (var i = 0; i < storesList.length; i++) {
            $elem.append("<option class='opt-branch' value='" + storesList[i].BranchID + "'>" + storesList[i].BranchName + "</option>");
        }
        $elem.prop("disabled", false);
    }

    //For Analytics
    if (storesList.length == 1)
        $elem.not('select[id^=compareSiteSelect]').find('option:last').attr('selected', 'selected');
    else
        $elem.not('select[id^=compareSiteSelect]').prop('selectedIndex', 0);

    $elem.not('#selectorSite').prop('selectedIndex', -1);
    InitSelect2($elem, "", 0, 0);
}

function populateSiteSelectorWithoutRegion($elem, storesList) {
    $elem.children().remove();
    $elem.append("<option class='opt-company' value='0'>- All Sites - </option>");                              //Clear options

    if (storesList.length !== 0) {
        //Append Sites
        for (var i = 0; i < storesList.length; i++) {
            $elem.append("<option class='opt-branch' value='" + storesList[i].BranchID + "'>" + storesList[i].BranchName + "</option>");
        }
        $elem.prop("disabled", false);
    }
    $elem.prop('selectedIndex', 0); //Reset the selection
    InitSelect2($elem, "", 0, 0);
}

//Populate a collection of company list into select element with id="selectorCamera" [KelvinYap]
function populateCounterSelector($elem, cameraList, val) {         //val == 0 (No Counter), val == 1 (All Counter)
    $elem.children().remove();
    $elem.append("<option class='opt-company' value=''>- " + allCounters + " - </option>");
    if (val == 0) {
        $elem.children("option[class='opt-company']").html("- " + LanguageNoCounterFound + " - ");
    }
    if (cameraList != null && cameraList.length != 0) {
        for (var i = 0; i < cameraList.length; i++) {
            $elem.append("<option class='opt-cam' value='" + cameraList[i].ID + "'>" + cameraList[i].CameraName + "</option>");
        }
        $elem.prop("disabled", false);
    }
    InitSelect2($elem, "", 0, 0);
}

function populateCounterSelectorWithoutAll($elem, cameraList, val) {         //val == 0 (No Counter), val == 1 (All Counter)
    $elem.children().remove();
    if (val == 0) {
        $elem.children("option[class='opt-company']").html("- " + LanguageNoCounterFound + " - ");
    }
    if (cameraList != null && cameraList.length != 0) {
        for (var i = 0; i < cameraList.length; i++) {
            $elem.append("<option class='opt-cam' value='" + cameraList[i].Serial + "'>" + cameraList[i].CameraName + "</option>");
        }
        $elem.prop("disabled", false);
    }
    InitSelect2($elem, "", 0, 0);
}

//Populate a collection of area list into select element with id="selectorArea" [YuHao]
function populateAreaSelector($elem, areaList, val) {         //val == 0 (No Area), val == 1 (All Area)
    $elem.children().remove();

    if (val == 0) {
        $elem.append("<option class='opt-company' value=''>- " + LanguageNoAreaFound + " - </option>");
    }

    if (areaList != null && areaList.length != 0) {
        for (var i = 0; i < areaList.length; i++) {
            $elem.append("<option class='opt-area' value='" + areaList[i].ID + "'>" + areaList[i].Name + "</option>");
        }

        $elem.prop("disabled", false);
    }

    InitSelect2($elem, "", 0, 0);
}

//Initialize Select2 based on the entered arguments [Kelvin Yap]
function InitSelect2($elem, placeHolder, listLength, maxLength) {
    if (listLength != 0 && maxLength != 0) {    //listLength & maxLength must be > 0
        if (placeHolder != "") {
            if (listLength > maxLength) {
                $elem.select2({
                    placeholder: decodeHtml(placeHolder),
                    templateResult: customSelect2Template,
                    minimumInputLength: 3
                });
            }
            else {
                $elem.select2({
                    placeholder: decodeHtml(placeHolder),
                    templateResult: customSelect2Template
                });
            }
        }
        else {
            if (listLength > maxLength) {
                $elem.select2({
                    templateResult: customSelect2Template,
                    minimumInputLength: 3
                });
            }
            else {
                $elem.select2({
                    templateResult: customSelect2Template
                });
            }
        }
    }
    else {
        if (placeHolder != "") {
            $elem.select2({
                placeholder: decodeHtml(placeHolder),
                templateResult: customSelect2Template
            });
        }
        else {
            $elem.select2({
                templateResult: customSelect2Template
            });
        }
    }
}

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}

//Format numbers with thousands separator and decimal to 2 points [Kelvin Yap]
function numberify(value) {
    //console.log(value);
    if (value == null || typeof value === 'string') {
        return value;
    }
    if (value % 1 != 0) {
        value = value.toFixed(2);
    }
    value += '';        //Change into string
    var x = value.split('.');
    var x1 = x[0];
    var x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}

function timify(value) {
    if (value == null || typeof value === 'string') {
        return value;
    }
    var time = '';
    if (value > 60) {

        var hour = (value / 60);
        var passing = value % 60;
        if (passing != 0) {
            hour = (hour + '').split('.'); //spliting values out to retrieve the whole number of 'hours'
            var hoursValue = hour[0] + " Hours "; //setting hours value with it's unit
            value = passing; // remaining to be passed for min and sec calc in following lines
        }
        else {
            hour += " Hours"; //if it is a whole number with clean 60's multiplying factors, shows only Hours and return the value
            return hour;
        }
    }
    if (value % 1 != 0 && value > 1) // if seconds present with minutes
    { 
        value = value.toFixed(2);
        value += '';   
        var x = value.split('.'); 
        var minutesValue = x[0];
        var secondsValue = Math.round((numberify(x[1]) * 0.60).toFixed(2)); //round off seconds to maximum 2 digits while below 60 as multiplied by 0.6
        value = minutesValue + ' Minutes ' + secondsValue + ' Seconds'
    }
    else {
        value = Math.round((value * 60).toFixed(0)) + ' Seconds'; //in case if the number had decimals but is less than 1, e.g. '0.156', round it and become a whole number: Minutes
    }

    value = !hoursValue ? value : hoursValue + value; //check if all time units presents or just minutes and seconds

    return value;

}

function suffixify(value) {
   // console.log(value);
    if (value == null || typeof value === 'string') {
        return value;
    }
    var suffixVal = "";
    if (value >= 1000000000) {
        suffixVal = "B";
        value = value / 1000000000;
    } else if (value >= 1000000) {
        suffixVal = "M";
        value = value / 1000000;
    } else if (value >= 1000) {
        suffixVal = "k";
        value = value / 1000;
    } else {
        suffixVal = "";
    }
    return numberify(value) + suffixVal;
}

function bytesuffixify(value, truncate) {
    if (value == null || typeof value === 'string') {
        return value;
    }
    var suffixVal = "";
    if (value >= 1000000000000) {
        suffixVal = "T";
        value = value / 1000000000000;
    } else if (value >= 1000000000) {
        suffixVal = "G";
        value = value / 1000000000;
    } else if (value >= 1000000) {
        suffixVal = "M";
        value = value / 1000000;
    } else if (value >= 1000) {
        suffixVal = "K";
        value = value / 1000;
    } else {
        suffixVal = "";
    }
    if (truncate) {
        value = value.toFixed(0);
    }
    return numberify(value) + suffixVal;
}

//detect url from string and make them URL
function urlify(text) { //Jack
    var exp = /(\b(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/ig;
    var text1 = text.replace(exp, "<a href='$1' target='_blank' class='spanLink'>$1</a>");
    var exp2 = /(^|[^\/])(www\.[\S]+(\b|$))/gim;
    var output = text1.replace(exp2, '$1<a target="_blank" href="http://$2">$2</a>');
    return (output);
}

function shareLink(url) {
    $.ajax({
        url: "/FootfallCam/getShareReportToken",
        success: function (data) {
            data = JSON.parse(data);
            var thisReportQS = data.url + url + "&token=" + data.token;
            //reportLink = btoa(encodeURIComponent(url));
            ShowModal("<div> Shared Link </div>", "<div id='copyLink' class='col-xs-12 one-row'><input id='myVal' type='text' disabled value='" + thisReportQS + "' style='width:80%; height:150%;'>&nbsp;&nbsp;<button id='copyButton' class='btn btn-primary' type='button'><i class='fa fa-paste'></i></button></div>");

            $("#copyButton").on("click", function () {
                copyLink("myVal");
            });
            $(".modal-body").attr("style", "padding-bottom:60px;");
        }
    });
}

function copyLink(id) {
    window.getSelection().removeAllRanges();
    var range = document.createRange();
    range.selectNode(document.getElementById(id));
    window.getSelection().addRange(range);
    document.execCommand("copy");
}

function NoSpecialCharacterInput(arrayOfElement) {
    $.each(arrayOfElement, function (i, el) {
        $(el).on('keypress', function (event) {
            var regex = new RegExp("^[a-zA-Z0-9-_]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
    })
}

function blobDownload(filePath) {
    $(".containerBlobDownloadCompleted").hide();
    $(".buttonCloseBlobFileDownloadDialog").click(function () {
        $(".containerBlobDownloadProgressBar").show();
        $(".containerBlobDownloadCompleted").hide();
    });
    $('#BlobFileDownloadDialog').on('hidden.bs.modal', function () {
        $(".buttonCloseBlobFileDownloadDialog").click();
    });
    try {
        var serverUrl = "";
        var filePathString = filePath.split("\\");
        var FileName = filePathString[filePathString.length - 1];

        if (filePathString.length > 2) {
            serverUrl = filePathString[0];
            filePathString[0] = "";
        }
        var fileName = filePathString.join("\\");
        var url = filePath;

        var xhr = new XMLHttpRequest();
        $("#BlobFileDownloadDialog").modal("show");
        xhr.onprogress = updateProgress;
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function () {
            if (this.status == 200) {
                var filename = "";
                var disposition = xhr.getResponseHeader('Content-Disposition');
                if (disposition && disposition.indexOf('attachment') !== -1) {
                    var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                    var matches = filenameRegex.exec(disposition);
                    if (matches != null && matches[1]) filename = matches[1].replace(/['"]/g, '');
                }
                var type = xhr.getResponseHeader('Content-Type');
                var blob = typeof File === 'function'
                    ? new File([this.response], FileName, { type: type })
                    : new Blob([this.response], { type: type });
                if (typeof window.navigator.msSaveBlob !== 'undefined') {
                    window.navigator.msSaveBlob(blob, FileName);
                    cleanUpServerFile(fileName, serverUrl);
                    $(".containerBlobDownloadProgressBar").hide();
                    $(".containerBlobDownloadCompleted").show();
                    $(".buttonCloseBlobFileDownloadDialog").prop("disabled", false);
                } else {
                    var URL = window.URL || window.webkitURL;
                    var downloadUrl = URL.createObjectURL(blob);
                    if (FileName) {
                        var a = document.createElement("a");
                        if (typeof a.download === 'undefined') {
                            window.location = downloadUrl;
                        } else {
                            a.href = downloadUrl;
                            a.download = FileName;
                            document.body.appendChild(a);
                            a.click();
                        }
                    } else {
                        window.location = downloadUrl;
                    }
                    setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
                    cleanUpServerFile(fileName, serverUrl);
                    $('#BlobFileDownloadDialog .progress-bar').css({ "width": 0 + "%" });
                    $(".containerBlobDownloadProgressBar").hide();
                    $(".containerBlobDownloadCompleted").show();
                    $(".buttonCloseBlobFileDownloadDialog").prop("disabled", false);
                    $(".buttonCloseBlobFileDownloadDialog").click();
                    $(window).unbind("beforeunload");
                }
            }
            else {
              //  console.log("whet");
            }
        };
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.send();
    } catch (ex) { console.log(ex); }

    function cleanUpServerFile(url, serverUrl) {
        var requestURL = serverUrl + "/Download/DeleteTmpFile?f=" + url;
        var ajaxMethod = "GET"; //or POST etc
        $.ajax({
            type: ajaxMethod,
            url: requestURL,
            success: function (response) {

            },
            error: function (request, status, error) {
                console.log(request);
                console.log(status);
                console.log(error);
            }
        });
    }
    function updateProgress(evt) {
        if (evt.lengthComputable) {
            var percentComplete = (evt.loaded / evt.total) * 100;
            $('#BlobFileDownloadDialog .progress-bar').css({ "width": percentComplete + "%" });
        }
    }
}

function Strip(html) {
    var tmp = document.createElement("DIV");
    tmp.innerHTML = html;
    return tmp.textContent || tmp.innerText || "";
}


function CollapseSectionBody(containerDOM, isCollapsed) {
    if (isCollapsed) {
        containerDOM.find(".containerSectionBody")
            .slideUp()
            .data("is-collapsed", true)
            ;
        containerDOM.find(".containerSectionHeader .fa").removeClass("fa-angle-down").addClass("arrow");
    }
    else {
        containerDOM.find(".containerSectionBody")
            .slideDown()
            .data("is-collapsed", false)
            ;
        containerDOM.find(".containerSectionHeader .fa").removeClass("arrow").addClass("fa-angle-down");
    }
}

//Custom Panel Functions[Kelvin Yap]
function promptInfoPanel(panelBody, enableClose, promptMode, yesCallback, customFooter) {
    $('div[id^=infoPanelFooter]:not(.hide)').addClass('hide');
    var bodyString = panelBody;
    $('#infoPanelBody').html(panelBody);
    if (enableClose) {
        $('#infoPanelCloseSection.hide').removeClass('hide');
    }
    else {
        $('#infoPanelCloseSection:not(.hide)').addClass('hide');
    }

    //OKAY MODE
    if (promptMode == 1) {
        $('#infoPanelFooter_OK').removeClass('hide');
    }
    //YES NO MODE
    else if (promptMode == 2) {
        $('#infoPanelYesBtn').unbind('click').on('click', function () {
            yesCallback();
        });
        $('#infoPanelFooter_YesNo').removeClass('hide');
    }
    //CUSTOM MODE
    else if (promptMode == 3) {
        $('#infoPanelFooter_Custom').html(customFooter);
        $('#infoPanelFooter_Custom').removeClass('hide');
    }
    $('#infoPanel').collapse('show');
}

function hideInfoPanel() {
    if ($('#infoPanel').hasClass('in'))
        $('#infoPanel').collapse('hide');
}

function promptWarningPanel(panelBody, enableClose, promptMode, yesCallback, customFooter) {
    $('div[id^=warningPanelFooter]:not(.hide)').addClass('hide');
    var bodyString = panelBody;
    $('#warningPanelBody').html(panelBody);
    if (enableClose) {
        $('#warningPanelCloseSection.hide').removeClass('hide');
    }
    else {
        $('#warningPanelCloseSection:not(.hide)').addClass('hide');
    }

    //OKAY MODE
    if (promptMode == 1) {
        $('#warningPanelFooter_OK').removeClass('hide');
    }
    //YES NO MODE
    else if (promptMode == 2) {
        $('#warningPanelYesBtn').unbind('click').on('click', function () {
            yesCallback();
        });
        $('#warningPanelFooter_YesNo').removeClass('hide');
    }
    //CUSTOM MODE
    else if (promptMode == 3) {
        $('#warningPanelFooter_Custom').html(customFooter);
        $('#warningPanelFooter_Custom').removeClass('hide');
    }
    $('#warningPanel').collapse('show');
}

function hideWarningPanel() {
    if ($('#warningPanel').hasClass('in'))
        $('#warningPanel').collapse('hide');
}

function scrollToTarget(target) {
    $('html, body').animate({
        scrollTop: ($(target).offset().top)
    }, 500);
}

var customSelect2Template = function (data) {
    // We only really care if there is an element to pull classes from
    if (!data.element) {
        return data.text;
    }

    var $element = $(data.element);

    var $wrapper = $('<div></div>');
    $wrapper.addClass($element[0].className);

    if ($element[0].className == "opt-company") {
        $wrapper.html("<i class='fa fa-globe'></i>" + data.text);
    }
    else if ($element[0].className == "opt-branch") {
        $wrapper.html("<i class='fa fa-home'></i>" + data.text);
    } else {
        $wrapper.html("<i class='fa fa-camera'></i>" + data.text);
    }

    return $wrapper;
};

// Calculation for Weekly-Based Report to get from date, to date, and week number
// Parameters: firstDaySetting(String), selectedDate(String), financialWeekDate(String), dateFormat(String)
// Return: result(Object): firstDateOfWeek, lastDateOfWeek, weekNumber
// Note: This method required customBootstrapDatePicker.js
function getWeekRangeWeekNumber(firstDaySetting, selectedDate, financialWeekDate, dateFormat) {
    var tempResult;
    var result = new Object();

    switch (firstDaySetting) {
        case "Monday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 1) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(6, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(1, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Tuesday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 2) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(5, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(2, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Wednesday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 3) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(4, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(3, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Thursday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 4) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(3, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(4, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Friday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 5) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(2, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(5, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Saturday":
            if (moment(selectedDate, 'DD/MM/YYYY').day() == 6) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(6, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(1, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
        case "Sunday":
            tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            break;
        default:
            // If no firstDaySetting, default to be Monday
            if (moment(selectedDate, 'DD/MM/YYYY').day() < 1) {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').subtract(6, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            } else {
                tempResult = getWeekRange(moment(selectedDate, 'DD/MM/YYYY').startOf('week').add(1, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
            }
            break;
    }

    result.firstDateOfWeek = tempResult[0];
    result.lastDateOfWeek = tempResult[1];
    result.weekNumber = tempResult[2];

    return result;
}

// Calculation for Weekly-Based Report to get from date, to date, and week number for last week
// Parameters: firstDaySetting(String), financialWeekDate(String), dateFormat(String)
// Return: result(Object): firstDateOfWeek, lastDateOfWeek, weekNumber
// Note: This method required customBootstrapDatePicker.js
function getWeekRangeWeekNumber_LastWeek(firstDaySetting, financialWeekDate, dateFormat) {
    var tempResult;
    var result = new Object();

    if (firstDaySetting == "Monday") {
        tempResult = getWeekRange(moment().startOf('week').add(1, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else if (firstDaySetting == "Tuesday") {
        tempResult = getWeekRange(moment().startOf('week').add(2, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else if (firstDaySetting == "Wednesday") {
        tempResult = getWeekRange(moment().startOf('week').add(3, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else if (firstDaySetting == "Thursday") {
        tempResult = getWeekRange(moment().startOf('week').add(4, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else if (firstDaySetting == "Friday") {
        tempResult = getWeekRange(moment().startOf('week').add(5, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else if (firstDaySetting == "Saturday") {
        tempResult = getWeekRange(moment().startOf('week').subtract(1, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    }
    else if (firstDaySetting == "Sunday") {
        tempResult = getWeekRange(moment().startOf('week').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    } else {
        tempResult = getWeekRange(moment().startOf('week').add(1, 'days').subtract(7, 'days').format('DD/MM/YYYY'), financialWeekDate, dateFormat);
    }

    result.firstDateOfWeek = tempResult[0];
    result.lastDateOfWeek = tempResult[1];
    result.weekNumber = tempResult[2];

    return result;
}


function errorMessage($reportElement) {

    //reportError

    //ERR101 - NoDataDueToDayOff
    //ERR102 - Nodataduetocounteroffline
    //ERR103 - ErrorReasonSalesConversion
    //ERR104 - Noinformationisavailable
    //ERR105 - NoDataYet
    //ERR106 - MallMonthlyDataErrorText

    //ERR201 - link to SetOperatingHour

    var errorMsg = "";
    if (typeof $reportElement.find('.errorBox').html() != "undefined") {    //Check if there is errorBox element or not

        errorMsg = $reportElement.find('.errorBox').text();

        switch (errorMsg) {

            case "ERR101":
                errorMsg = languageNoDataDueToDayOff;
                break;
            case "ERR102":
                errorMsg = languageNoDataDueToCounterOffline;
                break;
            case "ERR103":
                errorMsg = languageErrorReasonSalesConversion;
                break;
            case "ERR104":
                errorMsg = languageNoinformationisavailable;
                break;
            case "ERR105":
                errorMsg = languageNoDataYet;
                break;
            case "ERR106":
                errorMsg = languageMallMonthlyDataErrorText;
                break;
            case "ERR107":
                errorMsg = languageERR107 + $reportElement.find('.valueErrorBox').text();
                break;
            case "ERR108":
                errorMsg = languageERR108 + $reportElement.find('.valueErrorBox').text();
                break;
            case "ERR201":
                errorMsg = languageErrorMsg1 + ":<br>-"
                    + languageErrorMsg2 + "<br>-"
                    + languageErrorMsg3 + "<br>-"
                    + languageErrorMsg4 + "<br>"
                    + languageErrorMsg5 + " "
                    + "<a href='https://portal.footfallcam.com/FootfallCam/CounterManagement?MenuId=0&indexlist=21'>"
                    + languageErrorMsg6 + "</a> "
                    + languageErrorMsg7;
                break;
        }

        console.log(errorMsg);

        while (errorMsg.includes("  (")) {

            errorMsg = errorMsg.replace("  (", "<br>(");
        }

        while (errorMsg.includes("&lt;br&gt;")) {

            errorMsg = errorMsg.replace("&lt;br&gt;", "<br>");
        }

    }
    return errorMsg;
}

var loadingAnimation = "";
loadingAnimation += "<div class='loadingAnimationContainer'>";
loadingAnimation += "<div class='sk-spinner sk-spinner-pulse'></div>";
loadingAnimation += "</div>";

var loadingRightPanelDOM = "";
loadingRightPanelDOM += "<div class='loadingRightPanelContainer'>";
loadingRightPanelDOM += "<div class='sk-spinner sk-spinner-pulse'></div>";
loadingRightPanelDOM += "</div>";
function ShowRightPanel(Controller, Action, Parameters) {

    var rightPanelURL = "";
    if (Parameters != undefined && Parameters != "") {
        rightPanelURL = "/" + Controller + "/" + Action + "?" + Parameters;
    } else {
        rightPanelURL = "/" + Controller + "/" + Action;
    }

    $("#rightPanelContentContainer, #rightPanelContainer").css({ "max-width": "80%" });

    var windowWidth = $(window).width();
    if (windowWidth < 800) {
        $("#rightPanelContentContainer, #rightPanelContainer, #rightPanelContent").css({ "max-width": windowWidth + "px" });
        $("#wrapper").addClass("unscrollable");
        $("#closeRightPanelButtonContainer").addClass("mobileResponsive");
    } else {
        $("#rightPanelContent").css({ "max-width": "80%" });
        if ($("#wrapper").hasClass("unscrollable") && $("#closeRightPanelButtonContainer").hasClass("mobileResponsive")) {
            $("#wrapper").removeClass("unscrollable");
            $("#closeRightPaneButtonContainer").removeClass("mobileResponsive");
        }
    }
    $("#rightPanelContent").html(loadingRightPanelDOM).load(rightPanelURL);
    wrapperHeight = $("#wrapper").height();
    var effect = 'slide';
    var options = { direction: "right" };
    var duration = 150;
    $("#rightPanelContainer, #rightPanelContentContainer").css({ "display": "flex" });
    $(".rightPanelBackground").fadeIn();
}

function HideRightPanel() {
    $("#wrapper").removeClass("unscrollable");
    $("#rightPanelContentContainer, #rightPanelContainer").hide();
    $("#rightPanelContainer").css({});
    $(".rightPanelBackground").fadeOut();

    $("#rightPanelContent").html(loadingRightPanelDOM);
}

/**
 * To load available sites list according to the available
 * @param {number} companyid - Company ID
 * @param {string} guid - Server GUID to get correct Site List
 * @returns {object} Ajax Call to get site list
 */
function loadSiteAjax(companyid, guid) {
    return $.ajax({
        type: "GET",
        url: "/FootfallCam/GetCompanySite?c=" + companyid + "&g=" + guid,
        success: function (response) {
            if (response.IsSuccessful) {
                sites = response.SiteList;
            }
            else {
                console.log(response);
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function loadRegionAjax(param_companycode) {
    return $.ajax({
        type: "GET",
        url: "/FootfallCam/GetCompanyRegion?c=" + encodeURIComponent(param_companycode),
        success: function (response) {
            if (response.IsSuccessful) {
                regionList = response.RegionList;
            }
            else {
                console.log(response);
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

function loadAreaSettingAjax(branchId) {
    return $.ajax({
        type: "GET",
        url: "/Report/GetAreaSettings?branchId=" + branchId,
        success: function (response) {
            if (response.IsSuccessful) {
                areaList = response.Result;
            }
            else {
                console.log(response);
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
        }
    });
}

// Call Ajax to get list of child areas with their settings
function loadAreaAjax(branchID, completeFunction, beforeSendFunction) {
    return CallAPI("/FootfallCam/GetAreaByBranchID", "POST", { branchID: branchID }, function (response) {
        if (response.statusCode = 200) {
            areaList = response.Data;
        } else {
            console.log(response);
        }
    }, function (request, status, error) {
        console.log(request);
        console.log(status);
        console.log(error);
    },
        completeFunction,
        beforeSendFunction);
}

function stringGenerator(length) {
    var result = '';
    var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for (var i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

function CallAPI(url, type, dataObject, successCallBack, errorCallBack, completeCallBack, beforeSendCallBack, ajaxTimeoutInSeconds) {
    var contentType;
    if (dataObject instanceof FormData) {
        contentType = false;
    } else {
        contentType = "application/json; charset=utf-8";
        dataObject = JSON.stringify(dataObject);
    }
    var ajaxTimeoutInMilliseconds = 0;
    if (ajaxTimeoutInSeconds) {
        // make sure timeout at least 30 seconds and not more than 60 seconds
        if (ajaxTimeoutInSeconds > 30 && ajaxTimeoutInSeconds < 60) {
            ajaxTimeoutInMilliseconds = ajaxTimeoutInSeconds * 1000;
        } else {
            ajaxTimeoutInMilliseconds = 60 * 1000;
        }
    } else {
        ajaxTimeoutInMilliseconds = 60 * 1000;
    }
    $.ajax({
        type: type,
        url: url,
        contentType: contentType,
        data: dataObject,
        processData: false,
        timeout: ajaxTimeoutInMilliseconds,
        beforeSend: function () {
            typeof beforeSendCallBack === 'function' && beforeSendCallBack();
        },
        success: function (response) {
            if (typeof successCallBack === 'function' && successCallBack(response)) {
                console.log("No Success Callback");
                console.log(response);
            }
        },
        error: function (request, status, error) {
            console.log(request);
            console.log(status);
            console.log(error);
            typeof errorCallBack === 'function' && errorCallBack();
        },
        complete: function () {
            typeof completeCallBack === 'function' && completeCallBack();
            HideLoadingPrompt();
        }
    });
}

function GeneratePagingDOM(pagingDetails, filterDetails, tablePagingContainerSelector) {
    if (pagingDetails.TotalResult > 0) {
        //console.log(pagingDetails);
        //console.log(filterDetails);
        //console.log(tablePagingContainerSelector);
        var foundResult = "Found result: " + pagingDetails.TotalResult;
        $(".listResult").text(foundResult);
        var paging = pagingDetails;
        var pagingDOM = {
            pageCount: Math.ceil(paging.TotalResult / filterDetails.ItemPerPage),
            currentPage: filterDetails.PageNumber,
            HTML: "<div class='page-number-container'><span class='page-number' page-number=0>First</span>"
        };
        for (var i = 0; i < pagingDOM.pageCount; i++) {
            var thisPageNumber = (i + 1);
            var isPageSelectedClass = filterDetails.PageNumber == thisPageNumber ? "page-selected" : "";
            pagingDOM.HTML += "<span class='page-number " + isPageSelectedClass + "' page-number=" + thisPageNumber + ">" + thisPageNumber + "</span>";
        }
        pagingDOM.HTML += "<span class='page-number' page-number=-1>Last</span></div>";
        $(tablePagingContainerSelector).html(pagingDOM.HTML);
    }
}

//function GeneratePagingDOMJackVersion(pagingDetails, filterDetails, tablePagingContainerSelector) {
//    if (pagingDetails.TotalResult > 0) {
//        console.log(pagingDetails);
//        console.log(filterDetails);
//        //console.log(tablePagingContainerSelector);
//        var foundResult = "Found result: " + pagingDetails.TotalResult;
//        var paging = pagingDetails;
//        var pagingDOM = {
//            pageCount: Math.ceil(paging.TotalResult / filterDetails.ItemPerPage),
//            currentPage: filterDetails.PageNumber,
//            HTML: "<div class='page-number-container'><span class='page-number' page-number=0>First</span>",
//            NewHtml: "",
//            pageFirstItemIndex: ((filterDetails.PageNumber - 1) * filterDetails.ItemPerPage) + 1,
//            pageLastItemIndex: filterDetails.PageNumber == Math.ceil(paging.TotalResult / filterDetails.ItemPerPage) ? pagingDetails.TotalResult : filterDetails.PageNumber * filterDetails.ItemPerPage
//        };
//        pagingDOM.NewHtml = '<div id="tableInfoContainer">\
//                                <div id="tableInfo">\
//                                    <div class="info"><span class="rowStart">' + pagingDOM.pageFirstItemIndex + ' - <span class="rowEnd">' + pagingDOM.pageLastItemIndex + ' of <span class="rowTotal">' + pagingDetails.TotalResult + '</span></div>\
//                                    </div>\
//                                    <div id="pagination">\
//                                        <div class="paginate_button previous"><span><i class="fa fa-chevron-left" aria-hidden="true"></i></span></div>\
//                                        <div class="paginate_button next"><span><i class="fa fa-chevron-right" aria-hidden="true"></i></span></div>\
//                                    </div>\
//                                </div>';
//        console.log(pagingDOM);
//        for (var i = 0; i < pagingDOM.pageCount; i++) {
//            var thisPageNumber = (i + 1);
//            var isPageSelectedClass = filterDetails.PageNumber == thisPageNumber ? "page-selected" : "";
//            pagingDOM.HTML += "<span class='page-number " + isPageSelectedClass + "' page-number=" + thisPageNumber + ">" + thisPageNumber + "</span>";
//        }
//        pagingDOM.HTML += "<span class='page-number' page-number=-1>Last</span></div>";
//        $(tablePagingContainerSelector).html(pagingDOM.NewHtml);
//    }
//}

function UpdateSearchPage(SearchFilter, clickedPageNumber, paging) {
    if (parseInt($(clickedPageNumber).attr("page-number")) == 0) { // jump to first page
        SearchFilter.PageNumber = 1;
    } else if (parseInt($(clickedPageNumber).attr("page-number")) == -1) { // jump to last page
        SearchFilter.PageNumber = Math.ceil(paging.TotalResult / SearchFilter.ItemPerPage);
    } else {
        SearchFilter.PageNumber = parseInt($(clickedPageNumber).attr("page-number"));
    }
    return SearchFilter;
}

function UpdateSearchPageJackVersion(SearchFilter, isNextPage, paging) {
    //console.log(SearchFilter);
    //console.log(paging);
    var totalPage = Math.ceil(paging.TotalResult / SearchFilter.ItemPerPage);
    //console.log("total page: " + totalPage);
    if (isNextPage) {
        SearchFilter.PageNumber += 1;
        if (SearchFilter.PageNumber >= totalPage) {
            SearchFilter.PageNumber = totalPage;
        }
    } else {
        SearchFilter.PageNumber -= 1;
        if (SearchFilter.PageNumber <= 1) {
            SearchFilter.PageNumber = 1;
        }
    }
    //console.log(SearchFilter);
    return SearchFilter;
    if (parseInt($(clickedPageNumber).attr("page-number")) == 0) { // jump to first page
        SearchFilter.PageNumber = 1;
    } else if (parseInt($(clickedPageNumber).attr("page-number")) == -1) { // jump to last page
        SearchFilter.PageNumber = Math.ceil(paging.TotalResult / SearchFilter.ItemPerPage);
    } else {
        SearchFilter.PageNumber = parseInt($(clickedPageNumber).attr("page-number"));
    }
    return SearchFilter;
}

function NewGuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16).toUpperCase();
    });
}

function getDayName(dateStr, locale) {
    var date = new Date(dateStr);
    locale = !locale ? "en" : locale;
    return date.toLocaleDateString(locale, { weekday: 'long' });
}

Date.prototype.addHours = function (h) {
    this.setTime(this.getTime() + (h * 60 * 60 * 1000));
    return this;
};

String.prototype.IsNullOrEmpty = function () {
    return String.IsNullOrEmpty(this);
};

String.IsNullOrEmpty = function (value) {
    return !value;
};

/// Cannot use prototype method cause null will hit error
String.EmptyStringIfNull = function (value) {
    return String.IsNullOrEmpty(value) ? "" : value;
};

function IsFileExist(urlToFile) {
    var xhr = new XMLHttpRequest();

    try {
        xhr.open('HEAD', urlToFile, false);
        xhr.send();
        if (xhr.status == "200") {
            return true;
        } else {
            return false;
        }
    } catch (e) {
        return false;
    }

}

function Trim(inputSelector) {
    var thisInputValue = $(inputSelector).val() ? $(inputSelector).val().trim() : ""
    return thisInputValue;
}

function pad(n, width, z) {
    z = z || '0';
    n = n + '';
    return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

/// Check If The Date Time Of Client Current TimeZone Is In DaylightSaving
Date.prototype.IsDst = function () {
    return this.getTimezoneOffset() < this.stdTimezoneOffset();
};

/// Get The Date Time Of Client Current TimeZone Offset For DaylightSaving
Date.prototype.stdTimezoneOffset = function () {
    var jan = new Date(this.getFullYear(), 0, 1);
    var jul = new Date(this.getFullYear(), 6, 1);
    return Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
};

Date.prototype.GetStringInTimeZone = function (timezone) {
    try {
        return this.toLocaleString("en-US", { timeZone: timezone });
    }
    catch (e) {
        console.log(timezone + " cannot be parsed");
        return this.toLocaleString();
    }
};

Date.prototype.LocalToUTCDate = function () {
    return new Date(Date.UTC(this.getFullYear(), this.getMonth(), this.getDate(), this.getHours(), this.getMinutes(), this.getSeconds()));
};

Date.prototype.UTCToLocalDate = function () {
    return new Date(this.getUTCFullYear(), this.getUTCMonth(), this.getUTCDate(), this.getUTCHours(), this.getUTCMinutes(), this.getUTCSeconds());
};

//Object.prototype.GetObjectKeys = function () {
//    return Object.keys(this);
//};

function GetMomentOfTimeZone(timezone, offset) {
    try {
        return moment.tz(timezone);
    }
    catch (e) {
        if (!offset)
            offset = 0;
        console.log(timezone + " cannot be parsed");
        var today = new Date();
        today.addHours(offset - getClientTimeZone());
        return moment(today.getTime());
    }
}

function ParseTimestampToMoment(timestamp, timezone, offset) {
    try {
        return moment.utc(timestamp * 1000).tz(timezone);
    }
    catch (e) {
        if (!offset)
            offset = 0;
        console.log(timezone + " cannot be parsed");
        var today = new Date(timestamp * 1000);
        today.addHours(offset - getClientTimeZone());
        return moment(today.getTime());
    }
}

function ParseMomentToDateTime(cMoment) {
    return new Date(cMoment.year(), cMoment.month(), cMoment.date(), cMoment.hour(), cMoment.minute(), cMoment.second(), cMoment.milliseconds());
}

function GetDateListBetween2Dates(startDate, endDate, currentFormat, format) {
    var dateArray = [];
    var currentDate = moment(startDate, currentFormat);
    var endDate = moment(endDate, currentFormat);
    while (currentDate <= endDate) {
        dateArray.push(moment(currentDate).format(format))
        currentDate = moment(currentDate).add(1, 'days');
    }
    return dateArray;
}

function CheckInvalidFileNameCharacter(data) {
    // frontend and backend checking using different variable
    // please edit backend checking too to add in invalid character
    var valid = true;
    var invalidContain = [
        '^', '*', '|', ':', '"',
        '<', '>', '?', '/', '\\',
        '`', '~', '!', '@', '#',
        '$', '%', '&', '(', ')',
        '+', '=', '[', ']', '{',
        '}', ';', '\''
    ];
    var invalidExact = [
        'com0', 'com1', 'com2', 'com3', 'com4',
        'com5', 'com6', 'com7', 'com8', 'com9',
        'lpt0', 'lpt1', 'lpt2', 'lpt3', 'lpt4',
        'lpt5', 'lpt6', 'lpt7', 'lpt8', 'lpt9',
        'con', 'nul', 'prn'
    ];

    invalidContain.forEach(function (invalidCharacter) {
        if (data.includes(invalidCharacter)) {
            valid = false;
        }
    });
    if (valid == true) {
        invalidExact.forEach(function (invalidName) {
            if (data == invalidName) {
                valid = false;
            }
        });
    }

    return valid;
}

function InitializeTouchSpin(id, minValue, maxValue, step, decimalPoints, prefix, postfix) {
    $(id).TouchSpin({
        min: minValue, //Minimum value. Default:0
        max: maxValue, //Maximum value. Default:100
        step: step, //Incremental/decremental step on up/down change. Default:1
        decimals: decimalPoints, //Number of decimal points. Default:0
        prefix: prefix, //Text before the input. Default:""
        postfix: postfix, //Text after the input. Default:""
        buttondown_class: 'btn btn-white',
        buttonup_class: 'btn btn-white',

    });
}