namespace RetailCamControlPanel
{
    using Helper;
    using Services.CompositeService;
    using Services.SingularService;
    using ViewModel;
    using System;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using Models;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using Telerik.ReportViewer;
    using System.Web;
    using System.Threading;
    using Telerik.Reporting.Charting;
    using System.Configuration;
    using System.Collections.Generic;

    /// <summary>
    /// Summary description for CompanyDailyReport.
    /// </summary>
    public partial class CompanyDailyReport : Report
    {
        private string retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];

        public CompanyDailyReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void CompanyDailyReport_NeedDataSource(object sender, EventArgs e)
        {
            #region ===== DEFAULT SETTINGS
            // FONT SETTINGS
            string font = Utility.Telerik_GetDefaultFontName();

            // COMPANY SETTINGS
            long companyId = 0;

            // DATE SETTINGS
            DateTime startd = new DateTime();
            #endregion

            #region ===== ADD SERVICE REFERENCES
            // SERVICES
            var ffCompositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var companyService = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
            var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
            var siteTagService = MvcApplication.container.GetInstance<SiteTagService>();
            var ffUserAccessService = MvcApplication.container.GetInstance<FFUserAccessService>();
            var ffBranchService = MvcApplication.container.GetInstance<FFBranchService>();
            #endregion

            // REQUIRED: TO CHECK WHETHER THE CLIENT SERVER HAS THE REQUIRED FONT OR NOT. IF NOT, RCCP WILL AUTO INSTALL
            ffCompositeService.checkIfArialUnicodeInstalled();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                #region ===== OBTAIN & PROCESS DATA FROM FRONT-END
                // OBTAINING DATA PASSED FROM FRONT-END
                var startDate = Report.Parameters["Date"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var dateFormat = 1;

                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegions = Report.Parameters["Region"].IsNull() || Report.Parameters["Region"].Value.ToString().Equals("") ?
                    ("[]").Deserialize<List<string>>()
                    : Report.Parameters["Region"].Value.ToString().Deserialize<List<string>>();
                var language = Report.Parameters["Language"].Value.ToString();
                var userRole = Report.Parameters["userRole"].Value.ToString();
                var isEmailScheduler = Report.Parameters["isEmailScheduler"].Value.ToString();
                var username = Report.Parameters["UserName"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                DateTime dt = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    dt = DateTime.ParseExact(startDate, "dd/MM/yyyy", culture);
                }
                else
                {
                    dt = DateTime.ParseExact(startDate, "MM/dd/yyyy", culture);
                    dateFormat = 2;

                }
                DayOfWeek dow = dt.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);
                var transactionCountSum = 0;

                List<BranchSummaryDailyReportViewModel> companyDailyRawData = new List<BranchSummaryDailyReportViewModel>();
                List<BranchSummaryHourlyReportViewModel> companyHourlyRawData = new List<BranchSummaryHourlyReportViewModel>();
                List<BranchSummaryHourlyReportViewModel> companyLastWeekHourlyRawData = new List<BranchSummaryHourlyReportViewModel>();
                List<FFBranchViewModel> selectedBranches = new List<FFBranchViewModel>();


                #endregion

                #region ===== INFO GATHERING
                // Get Required Information for RAW DATA PULLING, DATA AGGREGATION and other usage within the report
                // COMPANY SETTINGS
                var company = companyService.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                if (companyCode != "")
                    companyId = companyService.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                var branchId = 0;
                var maxDate = startDate;
                startd = dt;
                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                #endregion

                #region ===== PULL RAW DATA
                // Get Daily and Hour Raw Data
                if (selectedRegions.Count == 0)
                {
                    if (isEmailScheduler.Equals("True") || userRole.Equals("admin") || userRole.Equals("superadmin"))
                    {
                        long companyID = companyService.GetCompanyWhere(w => w.CompanyCode.Equals(company.CompanyCode)).ID;

                        selectedBranches = ffBranchService.GetBranches(w => w.CompanyId == companyID).Select(s => new FFBranchViewModel
                        {
                            ID = s.ID,
                            BranchName = s.BranchName,
                            BranchCode = s.BranchCode
                        }).ToList();

                        companyDailyRawData = ffBranchSummaryDailyReportService.GetBranchSummaryDailyReportWithSelectedBranch(selectedBranches, startd)
                        .Where(x => x.PatchStatus != "Predict")
                        .OrderBy(x => x.Date).ToList();

                        companyHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd, true);
                    }
                    else
                    {
                        List<long> selectedBranchesID = ffUserAccessService.GetThisUserGrantedList(username).Select(s => s.BranchId).ToList();

                        selectedBranches = ffBranchService.GetBranches(w => selectedBranchesID.Contains(w.ID)).Select(s => new FFBranchViewModel
                        {
                            ID = s.ID,
                            BranchName = s.BranchName,
                            BranchCode = s.BranchCode
                        }).ToList();

                        companyDailyRawData = ffBranchSummaryDailyReportService.GetBranchSummaryDailyReportWithSelectedBranch(selectedBranches, startd)
                        .Where(x => x.PatchStatus != "Predict")
                        .OrderBy(x => x.Date).ToList();

                        companyHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd, true);
                    }
                }
                else
                {
                    if (userRole.Equals("admin") || userRole.Equals("superadmin"))
                    {
                        selectedBranches = siteTagService.GetBranchesWithAllSelectedSiteTags(selectedRegions);

                        companyDailyRawData = ffBranchSummaryDailyReportService.GetBranchSummaryDailyReportWithSelectedBranch(selectedBranches, startd)
                            .Where(x => x.PatchStatus != "Predict")
                            .OrderBy(x => x.Date).ToList();

                        companyHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd, true);
                    }
                    else
                    {
                        List<long> branchIDsUserAccess = ffUserAccessService.GetThisUserGrantedList(username).Select(s => s.BranchId).ToList();

                        selectedBranches = siteTagService.GetBranchesWithAllSelectedSiteTags(selectedRegions).Where(w => branchIDsUserAccess.Contains(w.ID)).ToList();

                        companyDailyRawData = ffBranchSummaryDailyReportService.GetBranchSummaryDailyReportWithSelectedBranch(selectedBranches, startd)
                            .Where(x => x.PatchStatus != "Predict")
                            .OrderBy(x => x.Date).ToList();

                        companyHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd, true);
                    }
                }

                if (companyHourlyRawData != null && companyHourlyRawData.Count > 0)
                    companyHourlyRawData = companyHourlyRawData.OrderBy(o => o.ValueDateTime).ToList();

                List<long> branchIds = companyDailyRawData.Select(s => s.BranchId).Distinct().ToList();
                //      List<FFBranchSpecialOperatingHourViewModel> specialHourBranch = new List<FFBranchSpecialOperatingHourViewModel>();

                //For checking whether is day off or not
                var operatingHours = ffBranchOperatingHourService.GetCompanyBranchOperatingHourList(branchIds).Where(x => x.isDayOff == false && x.Day == (int)dow).ToList();

                //foreach (long branchID in branchIds)
                //{
                //    var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(branchID).FirstOrDefault(x => x.Date == startd);
                //    if (specialOperatingHour != null) {
                //        specialHourBranch.Add(specialOperatingHour);
                //    }
                //}

                //var specialOperatingHour = branchIds.Where(x => ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(x)
                //.FirstOrDefault(y => y.Date == startd) != null)
                //.Select(s => new FFBranchSpecialOperatingHour()
                //{
                //    BranchId = s,
                //    isDayOff = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(s).Where(y => y.Date == startd).Select(z=>z.isDayOff).FirstOrDefault(),
                //}).ToList();


                var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHourList(w => branchIds.Contains(w.BranchId) && w.Date == startd);


                var count = 0;
                var allBranchesIsDayOff = false;

                if (specialOperatingHour != null)
                {
                    foreach (var branch in specialOperatingHour)
                    {
                        if (branch.isDayOff == true)
                        {
                            count++;
                        }
                    }

                    if (count == branchIds.Count)
                    {
                        allBranchesIsDayOff = true;
                    }
                }

                if (companyDailyRawData.Count > 0)
                {
                    var branchSummaryDailyReportViewModel = companyDailyRawData.Where(x => x.PatchStatus != "Predict").OrderByDescending(o => o.Date).FirstOrDefault();
                    if (branchSummaryDailyReportViewModel != null && companyDailyRawData.Count > 0 && branchSummaryDailyReportViewModel.PatchStatus != "Predict")
                    {
                        maxDate = (dateFormat == 2)
                            ? companyDailyRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("MM'/'dd'/'yyyy")
                            : companyDailyRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("dd'/'MM'/'yyyy");

                        transactionCountSum = companyDailyRawData.Sum(s => s.TransactionCount);
                    }
                }

                //To control and show information about data availability on selected date
                //Check if the report is available to generate or not... 
                DateTime nowDateTime = DateTime.UtcNow;
                //Get all branches local time... 
                List<TimeZoneInfo> branchTimeZoneInfo = ffCompositeService.GetAllBranches(company.ID, true).Select(s => Utility.OlsonTimeZoneToTimeZoneInfo(s.Timezone)).ToList();
                List<DateTime> allCurrentLocalTime = new List<DateTime>();
                if (!branchTimeZoneInfo.Any(a => a == null))
                {
                    //Convert to a list on local DateTime of branches... 
                    allCurrentLocalTime = branchTimeZoneInfo.Select(s => TimeZoneInfo.ConvertTimeFromUtc(nowDateTime, s)).ToList();
                }

                //Check if is future day, today, or before today of all branches compared to the selected date (Assume selected date is UTC-ed and +6 hours). 
                int overTodayCount = 0, isTodayCount = 0, beforeTodayCount = 0;
                //+6 hours in startd to be compared (To tell user all data will be completely aggregate after 6AM of local branch time)
                DateTime availableTime = startd.AddHours(6);
                //Get the earliest and latest time among branches
                DateTime earliestTime = DateTime.MinValue;
                DateTime latestTime = DateTime.MinValue;
                foreach (var time in allCurrentLocalTime)
                {
                    if (earliestTime == DateTime.MinValue || DateTime.Compare(time, earliestTime) > 0)
                        earliestTime = time;
                    if (latestTime == DateTime.MinValue || DateTime.Compare(time, latestTime) < 0)
                        latestTime = time;
                    if (DateTime.Compare(time, availableTime) < 0)
                        overTodayCount++;
                    else if ((time - availableTime).TotalHours < 24)
                        isTodayCount++;
                    else if ((time - availableTime).TotalDays < 2)
                        beforeTodayCount++;
                }
                #endregion

                #region ===== REPORT (Error Checking, Data Aggregation, Text Binding, Graph Plotting)
                //Check if there is data or not, if yes, start aggregate/populate & generate report
                if ((maxDate != startDate || companyDailyRawData.Count == 0 || companyHourlyRawData.Count == 0 || operatingHours.Count == 0) && specialOperatingHour.Count == 0 || allBranchesIsDayOff == true && specialOperatingHour.Count > 0)  //|| (overTodayCount != 0 && isTodayCount == 0 && beforeTodayCount == 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    overviewPanel.Visible = false;
                    visitorCountsSectionPanel.Visible = false;
                    if (operatingHours.Count == 0 && !(overTodayCount != 0 && isTodayCount == 0 && beforeTodayCount == 0) || specialOperatingHour.Count > 0 && allBranchesIsDayOff == true)
                    {
                        errorBox.Value = "ERR101";
                    }
                    else if (overTodayCount != 0 && isTodayCount == 0 && beforeTodayCount == 0)
                    {
                        errorBox.Value = "ERR107";

                        var timeNeeded = (availableTime.AddDays(1) - earliestTime).TotalHours;

                        if (timeNeeded <= 0.5)
                            timeNeeded = 1;

                        valueErrorBox.Value = String.Format("{0:N0} {1}", timeNeeded, Helper.CompanyDailyReport.CompanyDailyReport_Hour_s);
                    }
                    else
                    {
                        errorBox.Value = "ERR102";
                    }
                    errorBox.Visible = true;
                    errorMessage.Visible = true;

                    errorMessage.Value = Helper.CompanyDailyReport.CompanyDailyReport_ReportIsNotAvailable;
                }
                else
                {
                    if (transactionCountSum == 0)
                    {
                        salesConversionOverview.Visible = false;
                        salesConversionTotal.Visible = false;
                        salesConversionTrendIcon.Visible = false;
                        salesConversionDiff.Visible = false;
                        graphSalesConversionOverview.Visible = false;
                        overviewPanel.Height = Unit.Cm(3.5);

                        notePanel.Location = new PointU(Unit.Cm(0D), Unit.Cm(5.2D));
                        visitorCountsSectionPanel.Location = new PointU(Unit.Cm(0D), Unit.Cm(6.2D));

                        transactionQuantity.Visible = false;
                        transactionQuantityHeader.Visible = false;
                        salesConversionHeader.Visible = false;
                        salesConversion.Visible = false;

                        valueInHeader.Size = new SizeU(Unit.Inch(1.05D), Unit.Inch(0.4D));
                        outsideTrafficHeader.Size = new SizeU(Unit.Inch(1.05D), Unit.Inch(0.4D));
                        turnInRateHeader.Size = new SizeU(Unit.Inch(1.05D), Unit.Inch(0.4D));
                        visitDurationHeader.Size = new SizeU(Unit.Inch(1.05D), Unit.Inch(0.4D));
                        returningRateHeader.Size = new SizeU(Unit.Inch(1.05D), Unit.Inch(0.4D));
                    }


                    reportTitle.Visible = true;
                    dayDate.Visible = true;
                    overviewPanel.Visible = true;
                    visitorCountsSectionPanel.Visible = true;
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    if (isTodayCount > 0 || overTodayCount > 0)
                    {
                        errorBox.Value = "ERR108";

                        var timeNeeded = (availableTime.AddDays(1) - earliestTime).TotalHours;

                        if (timeNeeded <= 0.5)
                            timeNeeded = 1;

                        valueErrorBox.Value = String.Format("{0:N0} {1}", timeNeeded, Helper.CompanyDailyReport.CompanyDailyReport_Hour_s);
                        valueErrorBox.Visible = true;
                        errorBox.Visible = true;
                    }

                    if (selectedRegions.Count == 0)
                    {
                        if (isEmailScheduler.Equals("True") || userRole.Equals("admin") || userRole.Equals("superadmin"))
                        {
                            companyLastWeekHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd.AddDays(-7), true);
                        }
                        else
                        {
                            companyLastWeekHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd.AddDays(-7), true);
                        }
                    }
                    else
                    {
                        if (userRole.Equals("admin") || userRole.Equals("superadmin"))
                        {
                            companyLastWeekHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd.AddDays(-7), true);
                        }
                        else
                        {
                            companyLastWeekHourlyRawData = ffBranchSummaryHourlyReportService.GetBranchHourlySelectedDateReportsBySelectedBranch(selectedBranches, startd.AddDays(-7), true);
                        }
                    }

                    // Obtain daily overall data
                    var companyDailyOverallData =
                        ffBranchSummaryDailyReportService.CalculateMatricData(companyDailyRawData, false);

                    // Obtain hourly data -  for graphTotalVisitorsOverview, graphTurnInRateOverview, graphSalesConversionOverview
                    var companyHourlyOperatingData =
                        ffBranchSummaryHourlyReportService.GetDataInOperatingHour(companyHourlyRawData, true);

                    // Obtain branch's stores' data - for Visitor Counts Section Table
                    var branchStatisticsRaw =
                        processDataForStoreTable(companyDailyRawData, startd);

                    // Report Header Language Settings
                    reportTitle.Value = companyName.ToUpper() + " " + Helper.CompanyDailyReport.CompanyDailyReport_DailyReport.ToUpper() + " ";

                    dayDate.Value = day + " " + startDate;

                    // Overview Table Language Settings
                    ValueInOverview.Value = Helper.CompanyDailyReport.CompanyDailyReport_TotalVisitors;
                    turnInRateOverview.Value = Helper.CompanyDailyReport.CompanyDailyReport_TurnInRate;
                    visitDurationOverview.Value = Helper.CompanyDailyReport.CompanyDailyReport_VisitDuration;
                    returningRateOverview.Value = Helper.CompanyDailyReport.CompanyDailyReport_ReturningRate;
                    salesConversionOverview.Value = Helper.CompanyDailyReport.CompanyDailyReport_SalesConversion;

                    // Visitor Counts Section Language Settings
                    visitorCountsSection.Value = Helper.CompanyDailyReport.CompanyDailyReport_VisitorCounts.ToUpper();
                    visitorCountsSection.ToolTip.Text = Helper.CompanyDailyReport.CompanyDailyReport_CompanyDailyReportVisitorCount;
                    note.Value = "* " + Helper.CompanyDailyReport.CompanyDailyReport_Note + ": " + Helper.CompanyDailyReport.CompanyDailyReport_CompareLastWeekDataNote;

                    // Visitor Counts Section Table Language Settings
                    sitesHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_Branches;
                    valueInHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_VisitorCounts;
                    outsideTrafficHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_OutsideTraffic;
                    turnInRateHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_TurnInRatepercent;
                    visitDurationHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_VisitDurationminutes;
                    returningRateHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_ReturningRate;
                    transactionQuantityHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_TransactionQuantity;
                    salesConversionHeader.Value = Helper.CompanyDailyReport.CompanyDailyReport_SalesConversion;

                    // Set table data source
                    overviewTable.DataSource = companyDailyOverallData;
                    storeTable.DataSource = branchStatisticsRaw;

                    // Plot graphs in overview table - graphValueInOverview, graphTurnInRateOverview, graphSalesConversionOverview
                    TelerikUtility.PlotAreaGraph_NoAxes(graphValueInOverview.ToString(), graphValueInOverview,
                        companyHourlyOperatingData, "=Fields.ValueDateTime", "=Fields.ValueIn");

                    TelerikUtility.PlotAreaGraph_NoAxes(graphTurnInRateOverview.ToString(), graphTurnInRateOverview,
                        companyHourlyOperatingData, "=Fields.ValueDateTime", "=Fields.TurnInRate");

                    TelerikUtility.PlotAreaGraph_NoAxes(graphSalesConversionOverview.ToString(), graphSalesConversionOverview,
                        companyHourlyOperatingData, "=Fields.ValueDateTime", "=Fields.SalesConversion");

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var thisWeekMaxValueIn = companyHourlyRawData.Max(s => s.ValueIn);
                    var thisWeekMinValueIn = companyHourlyRawData.Min(s => s.ValueIn);
                    var lastWeekMaxValueIn = companyLastWeekHourlyRawData.Min(s => s.ValueIn);
                    var lastWeekMinValueIn = companyLastWeekHourlyRawData.Min(s => s.ValueIn);
                    var maxValueIn = thisWeekMaxValueIn > lastWeekMaxValueIn ? thisWeekMaxValueIn : lastWeekMaxValueIn;
                    var minValueIn = thisWeekMinValueIn < lastWeekMinValueIn ? thisWeekMinValueIn : lastWeekMinValueIn;

                    var denominator = TelerikUtility.CheckValueDenominator(minValueIn, maxValueIn);
                    var FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    //            if (maxValueIn >= 3000000 || minValueIn >= 1000000)
                    //{
                    //	FormatString = "{0:## ##0M}";
                    //	denominator = 1000000;
                    //}

                    //else if (maxValueIn >= 3000 || minValueIn >= 1000)
                    //{
                    //	FormatString = "{0:## ##0k}";
                    //	denominator = 1000;
                    //}

                    // Plot Visitor Counts Section Graph
                    var companyHourlyTrendData = companyHourlyRawData.GroupBy(g => g.ValueDateTime)
                        .Select(s => new BranchSummaryHourlyReportViewModel
                        {
                            Hour = dateFormat == 2 ? s.Key.ToString("MM/dd HH:mm") : s.Key.ToString("dd/MM HH:mm"),
                            ValueInDouble = s.Sum(x => (double)x.ValueIn / denominator),
                        }).ToList();

                    var companyHourlyLastWeekTrendData = companyLastWeekHourlyRawData.GroupBy(g => g.ValueDateTime)
                        .Select(s => new BranchSummaryHourlyReportViewModel
                        {
                            Hour = dateFormat == 2 ? s.Key.AddDays(7).ToString("MM/dd HH:mm") : s.Key.AddDays(7).ToString("dd/MM HH:mm"),
                            ValueInDouble = s.Sum(x => (double)x.ValueIn / denominator),
                        }).ToList();

                    var graphDataSource = companyHourlyTrendData.Join(companyHourlyLastWeekTrendData,
                        t => t.Hour,
                        l => l.Hour,
                        (thisWeek, lastWeek) => new BranchSummaryHourlyReportViewModel
                        {
                            Hour = thisWeek.Hour.Contains("00:00") ? thisWeek.Hour : thisWeek.Hour.Split(' ')[1],
                            LastWeekValueInDouble = lastWeek.ValueInDouble,
                            ValueInDouble = thisWeek.ValueInDouble
                        }).ToList();

                    TelerikUtility.PlotBarLineGraph_1YAxisLabel(graphVisitorCountsSection.ToString(), graphVisitorCountsSection,
                        graphDataSource, "=Fields.Hour", Helper.CompanyDailyReport.CompanyDailyReport_Hour, Helper.CompanyDailyReport.CompanyDailyReport_NoofVisitor, "=Fields.ValueInDouble", Helper.CompanyDailyReport.CompanyDailyReport_ThisWeek, "=Fields.LastWeekValueInDouble", Helper.CompanyDailyReport.CompanyDailyReport_LastWeek, font, FormatString);

                    //PDF setting
                    storeTable.ColumnHeadersPrintOnEveryPage = true;

                    //Attach link to graph
                    /*
                    NavigateToUrlAction UrlAction1 = new NavigateToUrlAction();
                    string selectedMode;

                    if (selectedRegion != null && selectedRegion != "")
                    {
                        selectedMode = "region";
                        while (selectedRegion.IndexOf('&') != -1)
                        {
                            selectedRegion = selectedRegion.Replace("&", "||");
                        }
                    }
                    else
                    {
                        selectedMode = "company";
                    }

                    if (dateFormat == 2)
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "footfallcam/Analytics?start=" + dt.ToString("MM'/'dd'/'yyyy") + "," + dt.AddDays(-7).ToString("MM'/'dd'/'yyyy")
                            + "&end=" + dt.ToString("MM'/'dd'/'yyyy") + "," + dt.AddDays(-7).ToString("MM'/'dd'/'yyyy") + "&parameter=101&range=1&selectedMode=" + selectedMode + "&isGeneratePDF=false"
                            + "&branchid=" + selectedRegion;
                    }
                    else
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "footfallcam/Analytics?start=" + dt.ToString("dd'/'MM'/'yyyy") + "," + dt.AddDays(-7).ToString("dd'/'MM'/'yyyy")
                            + "&end=" + dt.ToString("dd'/'MM'/'yyyy") + "," + dt.AddDays(-7).ToString("dd'/'MM'/'yyyy") + "&parameter=101&range=1&selectedMode=" + selectedMode + "&isGeneratePDF=false"
                            + "&selectedregionid=" + selectedRegion;
                    }
                    graphVisitorCountsSection.Action = UrlAction1;
                    */
                }

            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
            #endregion
        }

        // Process data to produce a list of data to feed into Visitor Counts Section Table
        public List<BranchSummaryDailyReportViewModel> processDataForStoreTable(List<BranchSummaryDailyReportViewModel> companyDailyRawData, DateTime startDate)
        {
            var processedData = companyDailyRawData
                .Where(x => (x.PatchStatus != "Predict") && (x.ValueDateTime == startDate)).OrderBy(o => o.BranchName)
                .Select(
                s => new BranchSummaryDailyReportViewModel
                {
                    BranchName = s.BranchName,
                    ValueIn = s.ValueIn,
                    OutsideTraffic = s.OutsideTraffic,
                    TurnInRate = s.TurnInRate,
                    VisitDuration = s.AverageVisitDuration,
                    ReturningRate = ((s.WeeklyCustomer +
                    s.NewCustomer) > 0
                        ? Math.Round((double)(s.WeeklyCustomer) * 100 /
                                     (double)(s.WeeklyCustomer + s.NewCustomer), 2) : 0),
                    TransactionCount = s.TransactionCount,
                    SalesConversion = s.SalesConversion
                })
                .ToList();

            return processedData;
        }

        //public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup)
        //{
        //	// Set graph name
        //	reportGraphName.Name = graphName;

        //	// Set graph data source
        //	reportGraphName.DataSource = dataList;

        //	// Create the category group
        //	var categoryGroup = new GraphGroup();
        //	categoryGroup.Name = "categoryGroup";
        //	categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //	reportGraphName.CategoryGroups.Add(categoryGroup);

        //	// The SeriesGroups hierarchy defines the series at runtime
        //	var seriesGroup = new GraphGroup();
        //	seriesGroup.Name = "seriesGroup";
        //	reportGraphName.SeriesGroups.Add(seriesGroup);

        //	// Setup Graph X Axis with CategoryScale
        //	var graphAxisCategoryScale = new GraphAxis();
        //	graphAxisCategoryScale.Name = "X Axis";
        //	graphAxisCategoryScale.Scale = new CategoryScale();
        //	graphAxisCategoryScale.Style.Visible = false;
        //	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

        //	// Setup Graph Y Axis with Numerical Scale
        //	var graphAxisNumericalScale = new GraphAxis();
        //	graphAxisNumericalScale.Name = "Y Axis";
        //	graphAxisNumericalScale.Scale = new NumericalScale();
        //	graphAxisNumericalScale.Style.Visible = false;
        //	graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
        //	graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

        //	// The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //	cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
        //	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

        //	// The Graph Series area
        //	var areaGraph = new AreaSeries();
        //	areaGraph.CategoryGroup = categoryGroup;
        //	areaGraph.CoordinateSystem = cartesianCoordinateSystem;
        //	areaGraph.LegendItem.Style.Visible = false;
        //	areaGraph.SeriesGroup = seriesGroup;
        //	areaGraph.Y = yAxisGroup;
        //	reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //	reportGraphName.Series.Add(areaGraph);

        //	return reportGraphName;
        //}

        //public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup,
        //	string yAxisGroup, string yAxisGroup2, string font, string format)
        //{
        //	reportGraphName.Name = graphName;
        //	reportGraphName.Style.Font.Size = new Unit(11);
        //	reportGraphName.Style.Font.Bold = false;
        //	reportGraphName.Style.Font.Name = font;

        //	// Setup the DataSource
        //	reportGraphName.DataSource = dataList;

        //	// Create the category group
        //	var categoryGroup = new GraphGroup();
        //	categoryGroup.Name = "categoryGroup";
        //	categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //	reportGraphName.CategoryGroups.Add(categoryGroup);

        //	// The SeriesGroups hierarchy defines the series at runtime
        //	var seriesGroup = new GraphGroup();
        //	seriesGroup.Name = "seriesGroup";
        //	reportGraphName.SeriesGroups.Add(seriesGroup);

        //	// Setup Graph Axis with CategoryScale
        //	var graphAxisCategoryScale = new GraphAxis();
        //	graphAxisCategoryScale.Name = "X Axis";
        //	graphAxisCategoryScale.Scale = new CategoryScale();
        //	graphAxisCategoryScale.Title = Helper.CompanyDailyReport.CompanyDailyReport_Hour;
        //	graphAxisCategoryScale.Style.Font.Size = new Unit(10);
        //	graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
        //	graphAxisCategoryScale.Style.Font.Bold = false;
        //	graphAxisCategoryScale.Style.Font.Name = font;
        //	graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //	graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
        //	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //	graphAxisCategoryScale.Style.LineColor = Color.White;
        //	graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //	graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

        //	// Setup Graph Axis with Numerical Scale
        //	var graphAxisNumericalScale = new GraphAxis();
        //	graphAxisNumericalScale.Name = "Y Axis";
        //	graphAxisNumericalScale.Scale = new NumericalScale();
        //	graphAxisNumericalScale.Title = Helper.CompanyDailyReport.CompanyDailyReport_NoofVisitor;
        //	graphAxisNumericalScale.Style.Font.Name = font;
        //	graphAxisNumericalScale.TitleStyle.Font.Name = font;
        //	graphAxisNumericalScale.Style.Font.Bold = false;
        //	graphAxisNumericalScale.Style.Font.Style = FontStyle.Regular;
        //	graphAxisNumericalScale.Style.Font.Size = new Unit(10);
        //	graphAxisNumericalScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //	graphAxisNumericalScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //	graphAxisNumericalScale.Style.LineColor = Color.White;
        //	graphAxisNumericalScale.LabelFormat = format;

        //	// The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //	cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
        //	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //	cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //	cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //	cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //	cartesianCoordinateSystem.XAxis.LabelAngle = 270;

        //	// The Graph Series area
        //	var barSeries1 = new BarSeries();
        //	barSeries1.CategoryGroup = categoryGroup;
        //	barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //	barSeries1.LegendItem.Value = Helper.CompanyDailyReport.CompanyDailyReport_ThisWeek;
        //	barSeries1.SeriesGroup = seriesGroup;
        //	barSeries1.Y = yAxisGroup;
        //	reportGraphName.Series.Add(barSeries1);
        //	barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //	barSeries1.ToolTip.Text = TelerikUtility.FormatExpressionBuilder(yAxisGroup, Helper.CompanyDailyReport.CompanyDailyReport_ThisWeek + ": " + format);

        //	// The Line Series area
        //	var lineSeries1 = new LineSeries();
        //	lineSeries1.CategoryGroup = categoryGroup;
        //	lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //	lineSeries1.LegendItem.Value = Helper.CompanyDailyReport.CompanyDailyReport_LastWeek;
        //	lineSeries1.SeriesGroup = seriesGroup;
        //	lineSeries1.Y = yAxisGroup2;
        //	lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //	reportGraphName.Legend.Position = GraphItemPosition.TopRight;
        //	reportGraphName.Legend.Style.Font.Size = new Unit(10);
        //	lineSeries1.MarkerType = DataPointMarkerType.Circle;
        //	lineSeries1.MarkerSize = new Unit(14);
        //	lineSeries1.DataPointStyle.Visible = true;
        //	lineSeries1.DataPointStyle.BackgroundColor = Color.FromArgb(0, 0, 0, 0);
        //	lineSeries1.DataPointStyle.LineColor = Color.FromArgb(0, 0, 0, 0);
        //	reportGraphName.Series.Add(lineSeries1);
        //	lineSeries1.ColorPalette = new ColorPalette(Color.Black);
        //	lineSeries1.ToolTip.Text = TelerikUtility.FormatExpressionBuilder(yAxisGroup2, Helper.CompanyDailyReport.CompanyDailyReport_LastWeek + ": " + format);

        //	return reportGraphName;
        //}

        // Format input to no decimal place, display "-" if zero
        public static string FormatPlainInteger(int input)
        {
            string format = "{0:N0}";

            if (input == 0)
            {
                return string.Format("{0:0;-0;-\"\"}", input);
            }
            else
            {
                return string.Format(format, input);
            }
        }

        // Format input to 2 decimal place with "min", display "-" if zero
        public static string FormatMinutes(double input)
        {
            string format = "{0:N2}";

            if (input == 0)
            {
                return string.Format("{0:0;-0;-\"\"}", input);
            }
            else
            {
                string tempString = string.Format(format, input);
                return tempString + " " + Helper.CompanyDailyReport.CompanyDailyReport_Min;
            }
        }

        // Format input to 2 decimal place with "%", display "-" if zero
        public static string FormatDoublePercentage(double input)
        {
            if (input == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", input);
            }
            else
            {
                return Math.Round(input, 2) + "%";
            }
        }

        // Format input to 2 decimal place, display "-" if zero
        public static string FormatDouble(double input)
        {
            if (input == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", input);
            }
            else
            {
                return Math.Round(input, 2).ToString();
            }
        }

        // Display the arrow in overview table to show no difference, increasing or decreasing
        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

    }
}