using System.Collections.Generic;

namespace RetailCamControlPanel
{
    using Helper;
    using Models;
    using Services.CompositeService;
    using Services.SingularService;
    using System;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using ViewModel;
    using System.Web;
    //using Resources;
    using System.Threading;
    using System.Configuration;
    using System.Reflection;
    using Newtonsoft.Json;
    using System.IO;

    /*
     *  ===== TELERIK REPORT TEMPLATE PREREQUISITES ====================
     *  
     *  MODULES: 
     *  Copy and Paste the required module(s) within this template. 
     *  You can create your own module to cater specific needs. 
     *  *MODULE DIMENSION: 
     *  - Width     : 3.4 cm
     *  - Height    : 2.4 cm
     *  *GAP BETWEEN MODULES (Using Panel): 
     *  - Width     : 0.5 cm
     *  - Height    : 2.4 cm
     *  
     *  COLOR PATLETTE FOR EACH SECTION: 
     *  1. Pink #ef7cae         RGB: 239,124,174
     *  2. Orange #ff8000       RGB: 255,128,0
     *  3. Green #62bc69           RGB: 98,188,105
     *  4. Blue #60a5da            RGB: 96,165,218
     *  5. Brown #b0902f           RGB: 176,144,47
     *  
     *  PLEASE CONFIGURE THE INDIVIDUAL ELEMENTS' PROPERTIES IN DESIGNER
     *  (ESPECIALLY SETTING FONT NAME TO "Arial Unicode MS")
     *  
     *  ================================================================
    */
    public partial class CompanyMonthlyReport : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        public static List<BranchSummaryDailyReportViewModel> sevenDayTrendData;

        public CompanyMonthlyReport()
        {
            InitializeComponent();
        }

        private void CompanyMonthlyReport_NeedDataSource(object sender, EventArgs e)
        {
            #region  ===== VARIABLES
            //VARIABLES
            //DEFAULT FONT FOR TELERIK REPORT: "Arial Unicode MS"
            //PLEASE MODIFY THE FONT OF ALL ELEMENTS IN THE REPORT IN DESIGNER VIEW
            string font = Utility.Telerik_GetDefaultFontName();

            long companyId = 0;
            var min = 15;
            var max = 30;
            var branchId = 0;
            var twoYearsWorth = false;
            var dateFormat = 1;
            List<BranchSummaryDailyReportViewModel> rawData = new List<BranchSummaryDailyReportViewModel>();
            List<FFBranchViewModel> selectedBranches = new List<FFBranchViewModel>();

            #endregion


            #region ===== ADD SERVICE REFERENCES
            //==================================================================================================================
            /* ADD SERVICE REFERENCES TO USE COMPOSITE AND SINGULAR SERVICES
             *      - Add the required services to do RAW DATA PULLING & DATA AGGREGATION to call functions within the services      
             *      
             *      ** IMPORTANT: Consult appropriate person before modifying/adding new functions into these services. 
            */

            //EXAMPLE OF REFERENCING SERVICES (REMOVE THE UNNECESSARY REFERENCING, ONLY INCLUDE THE REQUIRED REFERENCING)
            var ffCompositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var companyService = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
            var ffBranchService = MvcApplication.container.GetInstance<FFBranchService>();
            var siteTagService = MvcApplication.container.GetInstance<SiteTagService>();
            var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
            var ffUserAccessService = MvcApplication.container.GetInstance<FFUserAccessService>();

            #endregion

            //REQUIRED: TO CHECK WHETHER THE CLIENT SERVER HAS THE REQUIRED FONT OR NOT. IF NOT, RCCP WILL AUTO INSTALL
            ffCompositeService.checkIfArialUnicodeInstalled();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Assign arguments from front-end to here (Name of the parameters is based on the configured 'Report Parameters')
                #region ===== OBTAIN & PROCESS DATA FROM FRONT-END
                // OBTAINING DATA PASSED FROM FRONT-END
                var startMonth = Report.Parameters["Month"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();

                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegions = Report.Parameters["Region"].IsNull() || Report.Parameters["Region"].Value.ToString().Equals("") ?
                    ("[]").Deserialize<List<string>>()
                    : Report.Parameters["Region"].Value.ToString().Deserialize<List<string>>();
                var language = Report.Parameters["Language"].Value.ToString();
                var userRole = Report.Parameters["userRole"].Value.ToString();
                var isEmailScheduler = Report.Parameters["isEmailScheduler"].Value.ToString();
                var username = Report.Parameters["UserName"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                DateTime thisYearStartDate = new DateTime();
                thisYearStartDate = DateTime.ParseExact(startMonth, "MMMM yyyy", culture);
                if (dateFormatHtml != "dateFirst")
                {
                    dateFormat = 2;
                }

                DayOfWeek dow = thisYearStartDate.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);

                var monthName = culture.DateTimeFormat.GetMonthName(thisYearStartDate.Month);

                #endregion

                #region ===== Info Gathering
                //Get Required Information for RAW DATA PULLING, DATA AGGREGATION and other usage within the report
                var cultureInfo = new System.Globalization.CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                var company = companyService.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                if (companyCode != "")
                    companyId = companyService.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                //Determine First Day of the Week based on Company Setting
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                DateTime thisYearEndDate = thisYearStartDate.AddMonths(1).AddDays(-1);
                DateTime lastYearMonthStartDate = thisYearStartDate.AddYears(-1);
                DateTime lastYearMonthEndDate = lastYearMonthStartDate.AddMonths(1).AddDays(-1);

                DateTime lastYearStartDate = lastYearMonthStartDate.AddMonths(-11);

                var financialStartEnd = Utility.GetFinancialWeekList2(thisYearStartDate, companySetting);

                string monthAbbreviatedName = culture.DateTimeFormat.GetAbbreviatedMonthName(thisYearStartDate.Month);
                string thisYearString = thisYearStartDate.ToString("yyyy");
                string lastYearString = lastYearMonthStartDate.ToString("yyyy");

                #endregion

                #region ===== PULL RAW DATA
                if (selectedRegions.Count == 0)
                {
                    if (isEmailScheduler.Equals("True") || userRole.Equals("admin") || userRole.Equals("superadmin"))
                    {
                        long companyID = companyService.GetCompanyWhere(w => w.CompanyCode.Equals(company.CompanyCode)).ID;

                        selectedBranches = ffBranchService.GetBranches(w => w.CompanyId == companyID).Select(s => new FFBranchViewModel
                        {
                            ID = s.ID,
                            BranchName = s.BranchName,
                            BranchCode = s.BranchCode
                        }).ToList();

                        rawData = ffBranchSummaryDailyReportService.GetBranchSummaryWeeklyReportWithSelectedBranch(selectedBranches, lastYearStartDate, thisYearEndDate)
                        .Where(x => x.PatchStatus != "Predict")
                        .OrderBy(x => x.Date).ToList();
                    }
                    else
                    {
                        List<long> selectedBranchID = ffUserAccessService.GetThisUserGrantedList(username).Select(s => s.BranchId).ToList();

                        selectedBranches = ffBranchService.GetBranches(w => selectedBranchID.Contains(w.ID)).Select(s => new FFBranchViewModel
                        {
                            ID = s.ID,
                            BranchName = s.BranchName,
                            BranchCode = s.BranchCode
                        }).ToList();

                        rawData = ffBranchSummaryDailyReportService.GetBranchSummaryWeeklyReportWithSelectedBranch(selectedBranches, lastYearStartDate, thisYearEndDate)
                        .Where(x => x.PatchStatus != "Predict")
                        .OrderBy(x => x.Date).ToList();
                    }

                }
                else
                {
                    if(isEmailScheduler.Equals("True") || userRole.Equals("admin") || userRole.Equals("superadmin"))
                    {
                        selectedBranches = siteTagService.GetBranchesWithAllSelectedSiteTags(selectedRegions);

                        rawData = ffBranchSummaryDailyReportService.GetBranchSummaryWeeklyReportWithSelectedBranch(selectedBranches, lastYearStartDate, thisYearEndDate)
                            .Where(x => x.PatchStatus != "Predict")
                            .OrderBy(x => x.Date).ToList();
                    }
                    else
                    {
                        List<long> branchIDsUserAccess = ffUserAccessService.GetThisUserGrantedList(username).Select(s => s.BranchId).ToList();

                        selectedBranches = siteTagService.GetBranchesWithAllSelectedSiteTags(selectedRegions).Where(w => branchIDsUserAccess.Contains(w.ID)).ToList();

                        rawData = ffBranchSummaryDailyReportService.GetBranchSummaryWeeklyReportWithSelectedBranch(selectedBranches, lastYearStartDate, thisYearEndDate)
                        .Where(x => x.PatchStatus != "Predict")
                        .OrderBy(x => x.Date).ToList();
                    }
                }

                var thisYearMonthDailyRawData = rawData.Where(w => w.ValueDateTime >= thisYearStartDate && w.ValueDateTime <= thisYearEndDate).ToList();
                var lastYearMonthDailyRawData = rawData.Where(w => w.ValueDateTime >= lastYearMonthStartDate && w.ValueDateTime <= lastYearMonthEndDate).ToList();

                #endregion

                #region ===== REPORT (Error Checking, Data Aggregation, Text Binding, Graph Plotting)
                // HANDLE ERROR REPORT e.g. IF DATA IS NOT AVAILABLE
                if (!(thisYearMonthDailyRawData.Count > 0 && thisYearMonthDailyRawData != null))
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    dashboardPanel.Visible = false;
                    section1Panel.Visible = false;
                    section2Panel.Visible = false;
                    errorMessage.Visible = true;
                    pageFooterSection1.Visible = false;

                    errorBox.Value = "ERR102";

                    errorBox.Visible = true;
                    errorMessage.Visible = true;

                    errorMessage.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_ReportIsNotAvailable;
                }
                else
                {
                    reportTitle.Visible = true;
                    dayDate.Visible = true;
                    dashboardPanel.Visible = true;
                    section1Panel.Visible = true;
                    section2Panel.Visible = true;
                    errorMessage.Visible = false;


                    //==================================================================================================================
                    /*
                     * DATA AGGREGATION
                     * Using Singular Services to perform DATA AGGREGATION
                     * Consult appropriate person before modifying/adding new functions
                    */

                    //Top Matric Data
                    var topMatricData = ffBranchSummaryDailyReportService.CalculateRetailMonthlyTopMatrics(thisYearMonthDailyRawData, lastYearMonthDailyRawData);
                    var highestStoreGraphData = thisYearMonthDailyRawData.Where(w => w.BranchId == topMatricData.BranchId).OrderBy(o => o.ValueDateTime);

                    //Last 12 Months Graph
                    var monthlyData = ffBranchSummaryDailyReportService.CalculateMonthlyTrend(branchDailyRawData: rawData, startDate: thisYearStartDate, firstDayOfWeek: firstDayOfWeek, fse: financialStartEnd, companySetting: companySetting, twoYearWorth: true);
                    var monthlyDataRearranged = ffBranchSummaryDailyReportService.Rearrange(monthlyData);

                    long monthlyMaxValue = monthlyDataRearranged.Max(m => m.ValueIn > m.LastValuein ? m.ValueIn : m.LastValuein);
                    long monthlyMinValue = monthlyDataRearranged.Min(m => m.ValueIn < m.LastValuein ? m.ValueIn : m.LastValuein);
                    long denominatorMonthly = TelerikUtility.CheckValueDenominator(monthlyMaxValue, monthlyMinValue);
                    string monthlyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorMonthly);

                    var mainGraphData = monthlyDataRearranged.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorMonthly,
                        LastValueinDouble = (double)s.LastValuein / denominatorMonthly,
                        Month = Utility.getLanguagePageName(s.Month.Substring(0, 3), language) + s.Month.Substring(3)
                    });


                    //Monthly Site Summary
                    var storeRankedData = thisYearMonthDailyRawData.GroupBy(g => g.BranchId).Select(s => new BranchSummaryDailyReportViewModel
                    {
                        BranchId = s.Key,
                        BranchName = s.First().BranchName,
                        ValueIn = s.Sum(su => su.ValueIn),
                        LastValuein = lastYearMonthDailyRawData.Count > 0 ? lastYearMonthDailyRawData.Where(w => w.BranchId == s.Key).Sum(sum => sum.ValueIn) : -1,
                        ValueInDiff = Math.Round(lastYearMonthDailyRawData.Where(w => w.BranchId == s.Key).Sum(sum => sum.ValueIn) > 0 ? (double)(s.Sum(su => su.ValueIn) - lastYearMonthDailyRawData.Where(w => w.BranchId == s.Key).Sum(sum => sum.ValueIn)) / lastYearMonthDailyRawData.Where(w => w.BranchId == s.Key).Sum(sum => sum.ValueIn) * 100 : 0, 2),
                        Rank = 0
                    }).OrderByDescending(o => o.ValueIn).ToList();

                    int rankNum = 1;

                    foreach (var item in storeRankedData)
                    {
                        item.Rank = rankNum;
                        rankNum++;
                    }

                    //==================================================================================================================
                    /*
                     * TEXT & DATA BINDING
                     *      ->  Use to bind required/acquired text/value into report elements. 
                     *      ->  Some value can be bind into elements.Value by writing an expression 
                     *          based on the assigned DataSource of an object e.g. a table or a graph
                    */

                    // TEXT BINDING
                    thisYearMonth_title.Value = $"{monthAbbreviatedName} {thisYearString}";
                    lastYearMonth_title.Value = $"{monthAbbreviatedName} {lastYearString}";

                    reportTitle.Value = $"{company.CompanyName.ToUpper()} {CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_MonthlyReport.ToUpper()} ({monthName.ToUpper()})";

                    totalChanges_title.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_ChangesPercentage;
                    highestVisitors_title.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_HighestVisitors;

                    last12Months_title.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_Last12Months.ToUpper();
                    monthlySiteSummary_title.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_MonthlySiteSummary.ToUpper();

                    //Monthly Details Text Binding
                    thisYearMonth_tabletext.Value = $"{monthAbbreviatedName} {thisYearString}";
                    lastYearMonth_tabletext.Value = $"{monthAbbreviatedName} {lastYearString}";

                    changePercentage_tabletext.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_ChangesPercentage;
                    siteName_tabletext.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_SiteName;
                    rank_tabletext.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_Rank;
                    totalVisitorCount_tabletext.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_TotalVisitorCount;


                    // OTHER TEXT BINDING USAGE
                    dayDate.Value = $"Report Period: {thisYearStartDate.ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy")} - {thisYearEndDate.ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy")}";

                    //BIND DATA TO TABLE
                    thisYearTable.DataSource = topMatricData;
                    lastYearTable.DataSource = topMatricData;
                    highestStoreTable.DataSource = topMatricData;
                    changesTable.DataSource = topMatricData;

                    //BIND DATA TO MONTHLY DETAILS CROSSTABS
                    monthlySiteSummary_table.DataSource = storeRankedData;

                    //==================================================================================================================
                    /*
                     * GRAPH PLOTTING
                    */

                    //Top Matric Data
                    TelerikUtility.PlotAreaGraph_NoAxes(thisYearMonth_areaGraph.ToString(), thisYearMonth_areaGraph, thisYearMonthDailyRawData, "=Fields.ValueDateTime", "=Fields.ValueIn");
                    TelerikUtility.PlotAreaGraph_NoAxes(lastYearMonth_areaGraph.ToString(), lastYearMonth_areaGraph, lastYearMonthDailyRawData, "=Fields.ValueDateTime", "=Fields.ValueIn");
                    TelerikUtility.PlotAreaGraph_NoAxes(highestVisitors_areaGraph.ToString(), highestVisitors_areaGraph, highestStoreGraphData, "=Fields.ValueDateTime", "=Fields.ValueIn");

                    //Monthly Trend
                    TelerikUtility.PlotBarLineGraph_1YAxisLabel(last12Months_barLineGraph.ToString(), last12Months_barLineGraph,
                        mainGraphData, "=Fields.Month", "Month",
                        CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_NoofVisitor, "=Fields.ValueInDouble", CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_Last12Months,
                        "=Fields.LastValueinDouble", CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_LastYearSameMonth,
                        font, monthlyValueFormat);
                }
                #endregion
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        //=====================================================================================================================
        /*
         *  GRAPH PLOTTING TEMPLATE
         *      -> Methods below are CUSTOM functions for the Graph Plotting
         *      -> GENERIC Functions can be found in Helper\TelerikUtility.cs
         *      -> Consult for usage/modification of the functions
         *      
         */
    }
}