namespace RetailCamControlPanel
{
    using RetailCamControlPanel.Enums;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using Helper;

    /// <summary>
    /// Summary description for CounterDailyReport.
    /// </summary>
    public partial class CounterDailyReport : Report
    {


        public CounterDailyReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void CounterDailyReport_GetData(object sender, EventArgs e)
        {

            #region DefaultSettings
            string font = Utility.Telerik_GetDefaultFontName();
            #endregion


            #region Services
            //services
            var compositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var cameraHourlyService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            #endregion 
            compositeService.checkIfArialUnicodeInstalled();
            //report feed
            var report = (Telerik.Reporting.Processing.Report)sender;


            try
            {
                //Start date
                var startDate = report.Parameters["Date"].Value.ToString();
                var dateFormatHtml = report.Parameters["dateFormat"].Value.ToString();
                var dateFormat = 1;

                var language = report.Parameters["Language"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                DateTime selectedDate = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    selectedDate = DateTime.ParseExact(startDate, "dd/MM/yyyy", culture);
                }
                else
                {
                    selectedDate = DateTime.ParseExact(startDate, "MM/dd/yyyy", culture);
                    dateFormat = 2;

                }
                DayOfWeek dow = selectedDate.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);

                var companyCode = report.Parameters["CompanyCode"].Value.ToString();
                var companyName = report.Parameters["CompanyName"].Value.ToString();
                var storeId = Convert.ToInt64(report.Parameters["BranchID"].Value) == 0 ? -1 : Convert.ToInt64(report.Parameters["BranchID"].Value);
                var store = storeId == -1 ? "All Counters" : report.Parameters["Stores"].Value.ToString();
                var tomorrow = selectedDate.AddDays(1);



                //get camera hourly data
                var camerahourlyRaw = storeId == -1 ? cameraHourlyService.GetMany(w => w.Camera.CompanyCode == companyCode && w.ValueDateTime >= selectedDate && w.ValueDateTime < tomorrow).ToList() : cameraHourlyService.GetMany(w => w.Camera.BranchId == storeId && w.ValueDateTime >= selectedDate && w.ValueDateTime < tomorrow).ToList();


                if (camerahourlyRaw.Count() == 0 || camerahourlyRaw == null)
                {
                    errorBox.Value = "ERR105";
                    CounterHourlyCrossTab.Visible = false;
                    shoppingMallOverviewSection.Visible = false;
                    sectionLine.Visible = false;
                    pageFooterSection1.Visible = false;
                    errorMessage.Value = LanguageOthers.Others_ReportIsNotAvailable;
                }
                else
                {
                    errorMessage.Visible = false;
                    errorBox.Visible = false;

                    //Bind UI
                    reportTitle.Value = (store == "")
                      ? companyName.ToUpper() + " " + CounterDailyReportViewer.CounterDailyReportViewer_DailyReport.ToUpper() + " "
                      : companyName.ToUpper() + " " + store.ToUpper() + " " + CounterDailyReportViewer.CounterDailyReportViewer_DailyReport.ToUpper() +
                        " ";
                    dayDate.Value = day + " " + startDate;

                    textBox6.Value = CounterDailyReportViewer.CounterDailyReportViewer_CameraName;
                    textBox1.Value = CounterDailyReportViewer.CounterDailyReportViewer_CompanySerial;
                    textBox7.Value = CounterDailyReportViewer.CounterDailyReportViewer_Total;
                    tooltipCounterDailyReport_txt.Value = CounterDailyReportViewer.CounterDailyReportViewer_Tooltip_MallCounterDailyReport;

                    #region Data Massage

                    var counterDataWithinOperatingHour = compositeService.FilterCameraHourlyOperatingHours(camerahourlyRaw, selectedDate, storeId,companyCode).Select(s => new FFCameraCountingValueHourViewModel
                    {
                        CameraName = s.Camera.CameraName,
                        CompanySerial = s.Camera.CompanySerial,
                        ValueDateTimeString = s.ValueDateTime.Hour + ":00",
                        ValueIn = s.ValueIn
                    });

                    #endregion

                    #region DataBinding

                    if (counterDataWithinOperatingHour.GroupBy(g => g.ValueDateTimeString).Count() > 13)
                    {
                        textBox2.Width = Unit.Cm(0.8);
                        textBox3.Width = Unit.Cm(0.8);
                    }
                    else
                    {
                        textBox2.Width = Unit.Cm(0.9);
                        textBox3.Width = Unit.Cm(0.9);
                    }
                    CounterHourlyCrossTab.DataSource = counterDataWithinOperatingHour;
                    #endregion

                    //    #region Data Binding
                    //    //top matric
                    //    overviewTable.DataSource = mallDailyData;
                    //    plotAreaGraph(graphTotalVisitor.ToString(), graphTotalVisitor, hourlyReportDataWithInOperatingHour, "=Fields.Hour", "=Fields.ValueIn");
                    //    peakHourValue.Value = peakHourData.Hour;
                    //    peakHourFootfall.Value = peakHourData.ValueIn.ToString();

                    //    //Today Hourly Footfall Trend
                    //    PlotBarLineGraphHourly(graphTodayHourlyFootfall.ToString(), graphTodayHourlyFootfall, hourlyReportDataWithInOperatingHour, "=Fields.Hour", "Hour", "=Fields.ValueIn", font: font);


                    //    //30 days Daily Footfall Trend
                    //    PlotBarLineGraphDaily(graphDailyFootfall.ToString(), graphDailyFootfall, dailyFootfallTrend, "=Fields.DateString", "Date", "=Fields.ValueIn", font: font);



                    //    //Today Hourly Corridor Footfall Counter
                    //    if (corridorData != null)
                    //    {
                    //        if(corridorData.GroupBy(g => g.Hour).Select(s => s.Key).Count() > 13)
                    //        {
                    //            textBox9.Width = Unit.Cm(0.8);
                    //            textBox7.Width = Unit.Cm(0.8);
                    //        }
                    //        else
                    //        {
                    //            textBox9.Width = Unit.Cm(1.0);
                    //            textBox7.Width = Unit.Cm(1.0);
                    //        }
                    //        crossTabHourlyFootfall.DataSource = corridorData;
                    //    }
                    //    #endregion
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, sender);
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        //public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup)
        //{
        //    //Data plotting - Traffic Profile Weekday
        //    reportGraphName.Name = graphName;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = dataList;

        //    //Create the category group
        //    var categoryGroup = new GraphGroup();
        //    categoryGroup.Name = "categoryGroup";
        //    categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(categoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var seriesGroup = new GraphGroup();
        //    seriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(seriesGroup);

        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Style.Visible = false;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale = new GraphAxis();
        //    graphAxisNumericalScale.Name = "Y Axis";
        //    graphAxisNumericalScale.Scale = new NumericalScale();
        //    graphAxisNumericalScale.Style.Visible = false;
        //    graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

        //    //The Graph Series area
        //    var areaGraph = new AreaSeries();
        //    areaGraph.CategoryGroup = categoryGroup;
        //    areaGraph.CoordinateSystem = cartesianCoordinateSystem;
        //    areaGraph.LegendItem.Style.Visible = false;
        //    areaGraph.SeriesGroup = seriesGroup;
        //    areaGraph.Y = yAxisGroup;
        //    reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    reportGraphName.Series.Add(areaGraph);

        //    return reportGraphName;
        //}

        public Graph PlotBarLineGraphHourly(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, /*string yAxisGroup2,*/ string font)
        {
            reportGraphName.Name = graphName;
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = graphDataSource;

            //Create the category group
            var SalesConversionSectionCategoryGroup = new GraphGroup();
            SalesConversionSectionCategoryGroup.Name = "categoryGroup";
            SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);

            //The SeriesGroups hierarchy defines the series at runtime
            var SalesConversionSectionSeriesGroup = new GraphGroup();
            SalesConversionSectionSeriesGroup.Name = "seriesGroup";
            reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            graphAxisCategoryScale.Scale = new CategoryScale();
            graphAxisCategoryScale.Title = xAxisName;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);
            graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;

            var graphAxisCategoryScale2 = new GraphAxis();
            graphAxisCategoryScale2.Name = "X Axis 2";
            graphAxisCategoryScale2.Scale = new CategoryScale();
            graphAxisCategoryScale2.Style.Visible = false;
            graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
            //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale5 = new GraphAxis();
            graphAxisNumericalScale5.Name = "Y Axis";
            graphAxisNumericalScale5.Scale = new NumericalScale();
            graphAxisNumericalScale5.Title = CounterDailyReportViewer.CounterDailyReportViewer_NoofVisitor;
            graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.Style.LineColor = Color.White;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);
            graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
            graphAxisNumericalScale5.Style.Font.Name = font;

            //Setup 2nd Graph Axis with Numerical Scale
            //var graphAxisNumericalScale6 = new GraphAxis();
            //graphAxisNumericalScale6.Name = "Y Axis 2";
            //graphAxisNumericalScale6.Scale = new NumericalScale();
            //graphAxisNumericalScale6.Title = CounterDailyReportViewer.CounterDailyReportViewer_SalesConversion + " (%)";
            //graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
            //graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
            //graphAxisNumericalScale6.Style.LineColor = Color.White;
            //graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);
            //graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            //graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
            //graphAxisNumericalScale6.Style.Font.Name = font;

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
            cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 0;

            //var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
            //cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
            //cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
            //cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            //cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

            //reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

            //The Graph Series area
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
            barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Value = CounterDailyReportViewer.CounterDailyReportViewer_NoofVisitor;
            barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
            barSeries1.Y = yAxisGroup;
            reportGraphName.Series.Add(barSeries1);
            reportGraphName.Legend.Position = GraphItemPosition.TopRight;
            barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
            barSeries1.ToolTip.Text = yAxisGroup;

            //The Line Series area
            //var lineSeries1 = new LineSeries();
            //lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
            //lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
            //lineSeries1.LegendItem.Value = CounterDailyReportViewer.CounterDailyReportViewer_SalesConversion + " (%)";
            //lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
            //lineSeries1.Y = yAxisGroup2;
            //lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
            //reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
            //reportGraphName.Series.Add(lineSeries1);
            //lineSeries1.ColorPalette = new ColorPalette(Color.Black);

            return reportGraphName;
        }


        public Graph PlotBarLineGraphDaily(string graphName, Graph reportGraphName, List<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, /*string yAxisGroup2,*/ string font)
        {
            reportGraphName.Name = graphName;
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = graphDataSource;

            //Create the category group
            var SalesConversionSectionCategoryGroup = new GraphGroup();
            SalesConversionSectionCategoryGroup.Name = "categoryGroup";
            SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);

            //The SeriesGroups hierarchy defines the series at runtime
            var SalesConversionSectionSeriesGroup = new GraphGroup();
            SalesConversionSectionSeriesGroup.Name = "seriesGroup";
            reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            graphAxisCategoryScale.Scale = new CategoryScale();
            graphAxisCategoryScale.Title = xAxisName;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);
            graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;

            var graphAxisCategoryScale2 = new GraphAxis();
            graphAxisCategoryScale2.Name = "X Axis 2";
            graphAxisCategoryScale2.Scale = new CategoryScale();
            graphAxisCategoryScale2.Style.Visible = false;
            graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
            //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale5 = new GraphAxis();
            graphAxisNumericalScale5.Name = "Y Axis";
            graphAxisNumericalScale5.Scale = new NumericalScale();
            graphAxisNumericalScale5.Title = CounterDailyReportViewer.CounterDailyReportViewer_NoofVisitor;
            graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.Style.LineColor = Color.White;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);
            graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
            graphAxisNumericalScale5.Style.Font.Name = font;

            //Setup 2nd Graph Axis with Numerical Scale
            //var graphAxisNumericalScale6 = new GraphAxis();
            //graphAxisNumericalScale6.Name = "Y Axis 2";
            //graphAxisNumericalScale6.Scale = new NumericalScale();
            //graphAxisNumericalScale6.Title = CounterDailyReportViewer.CounterDailyReportViewer_SalesConversion + " (%)";
            //graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
            //graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
            //graphAxisNumericalScale6.Style.LineColor = Color.White;
            //graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);
            //graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            //graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
            //graphAxisNumericalScale6.Style.Font.Name = font;

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
            cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 315;

            //var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
            //cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
            //cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
            //cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            //cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

            //reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

            //The Graph Series area
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
            barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Value = CounterDailyReportViewer.CounterDailyReportViewer_NoofVisitor;
            barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
            barSeries1.Y = yAxisGroup;
            reportGraphName.Series.Add(barSeries1);
            reportGraphName.Legend.Position = GraphItemPosition.TopRight;
            barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
            barSeries1.ToolTip.Text = yAxisGroup;

            //The Line Series area
            //var lineSeries1 = new LineSeries();
            //lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
            //lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
            //lineSeries1.LegendItem.Value = CounterDailyReportViewer.CounterDailyReportViewer_SalesConversion + " (%)";
            //lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
            //lineSeries1.Y = yAxisGroup2;
            //lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
            //reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
            //reportGraphName.Series.Add(lineSeries1);
            //lineSeries1.ColorPalette = new ColorPalette(Color.Black);

            return reportGraphName;
        }
    }
}