namespace RetailCamControlPanel
{
	using System.Globalization;
	using System.Web.Mvc;
	using RetailCamControlPanel.Enums;
	using RetailCamControlPanel.Models;
	//using RetailCamControlPanel.Resources;
	using Telerik.Reporting.Charting;
	using RetailCamControlPanel.Helper;
	using RetailCamControlPanel.Services.CompositeService;
	using RetailCamControlPanel.Services.SingularService;
	using RetailCamControlPanel.ViewModel;
	using System;
	using System.Collections.Generic;
	using System.Drawing;
	using System.Linq;
	using System.Web.UI.WebControls;
	using Telerik.Reporting;
	using Telerik.Reporting.Drawing;
	using System.Web;
	using System.IO;
    using System.Threading;

    /// <summary>
    /// Summary description for DataIntegrityReportVersion2
    /// </summary>
    public partial class DataIntegrityReport_v2 : Telerik.Reporting.Report
	{
		public DataIntegrityReport_v2()
		{
			InitializeComponent();
		}
		private static string RCCPPATH = HttpRuntime.AppDomainAppPath;

        [Obsolete]
        private void DataIntegrityReport_v2_NeedDataSource(object sender, EventArgs e)
		{
            #region Services Container
            var ffBranchSummaryDailyReportService = MvcApplication.container
				.GetInstance<FFBranchSummaryDailyReportService>();
			var ffBranchSummaryHourlyReportService = MvcApplication.container
				.GetInstance<FFBranchSummaryHourlyReportService>();
			var ffReportSummaryDailiesService = MvcApplication.container.GetInstance<FFReportSummaryDailyService>();
			var ffCameraHourlyValueServices = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
			var ffBranchService = MvcApplication.container.GetInstance<FFBranchService>();
			var siteTagService = MvcApplication.container.GetInstance<SiteTagService>();
			var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
			var companyServices = MvcApplication.container.GetInstance<CompanyService>();
			var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
			var ffCameraService = MvcApplication.container.GetInstance<FFCameraService>();
			var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
			var counterHealthCheckService = MvcApplication.container.GetInstance<CounterHealthCheckService>();
            var incidentLogService = MvcApplication.container.GetInstance<IncidentLogService>();
            #endregion
            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                #region Data obtaining - Company name and date for UI
                var dateHTML = Report.Parameters["Date"].Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var branchid = Report.Parameters["BranchID"].Value.ToString();
                var storeName = Report.Parameters["Stores"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                string CompanyCode = !String.IsNullOrEmpty(MyHelper.CompanyCode) ? MyHelper.CompanyCode : Report.Parameters["CompanyCode"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);
                var company = companyServices.GetCompany(CompanyCode);
                string font = Utility.Telerik_GetDefaultFontName();
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                var branchId = 0;
                if (branchid == "")
                    branchid = "0";
                var twoYearsWorth = false;
                List<long> camIds = new List<long>();
                string selectedRegionID = "";

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                DateTime startd = new DateTime();
                DateTime endd = new DateTime();

                if (dateFormatHtml == "dateFirst")
                {
                    endd = DateTime.ParseExact(dateHTML.ToString(), "dd/MM/yyyy", culture);
                }
                else
                {
                    endd = DateTime.ParseExact(dateHTML.ToString(), "MM/dd/yyyy", culture);
                }

                var maxDate = endd;
                startd = endd.AddDays(-70);

                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                //Data obtaining
                var branchDailyRawData = ffBranchSummaryDailyReportService.GetDataIntegrityData(Convert.ToInt64(branchid), maxDate);

                //Data obtaining - Checking if data exists
                if (branchDailyRawData.Count > 0)
                {
                    maxDate = branchDailyRawData.Max(s => Utility.ConvertToDateTime(s.Date));
                }

                DayOfWeek dow = maxDate.DayOfWeek;
                var day = dow.ToString();
                int dayOfWeek;
                switch (day)
                {
                    case "Sunday":
                        dayOfWeek = 0;
                        break;
                    case "Monday":
                        dayOfWeek = 1;
                        break;
                    case "Tuesday":
                        dayOfWeek = 2;
                        break;
                    case "Wednesday":
                        dayOfWeek = 3;
                        break;
                    case "Thursday":
                        dayOfWeek = 4;
                        break;
                    case "Friday":
                        dayOfWeek = 5;
                        break;
                    case "Saturday":
                        dayOfWeek = 6;
                        break;
                    default:
                        dayOfWeek = -1;
                        break;
                }

                day = culture.DateTimeFormat.GetDayName(dow);

                long startTimestamp = Utility.ConvertToTimestamp(maxDate.AddDays(-59));
                long endTimestamp = Utility.ConvertToTimestamp(maxDate);
                long halfTimestamp = Utility.ConvertToTimestamp(maxDate.AddDays(-13));

                //For branch hourly
                var branchHourlyRawData = ffcompositeServices.GetBranchHourlyReport(maxDate.AddDays(-6), maxDate,
                    selectedRegionID, Convert.ToInt64(branchid), firstDayOfWeek);

                //Filter branch hourly within operating hours
                var branchHourlyOperatingData = ffBranchSummaryHourlyReportService.GetDataWithinOperatingHour(branchHourlyRawData, false, true, Convert.ToInt64(branchid));


                //For counter daily
                List<FFCamera> ffCameraList = ffCameraService.GetAllCamerasByBranchId(Convert.ToInt64(branchid)).ToList();
                camIds = ffCameraList.OrderBy(s => s.ID).Select(s => s.ID).ToList();
                var camCompanySerial = ffCameraList.OrderBy(s => s.ID).Select(s => s.CompanySerial).ToList();
                var camSerial = ffCameraList.OrderBy(s => s.ID).Select(s => s.Serial).Distinct().ToList();
                var camName = ffCameraList.OrderBy(s => s.ID).Select(s => s.CameraName).ToList();
                var camFirmwareVersion = ffCameraList.OrderBy(s => s.ID).Select(s => s.CameraFirmwareVersion).ToList();
                


                #endregion

                string CounterLiveViewDirPath = RCCPPATH + "CounterLiveView\\";
                List<CounterLiveViewModel> LiveViewFileList = new List<CounterLiveViewModel>();
                if (Directory.Exists(@CounterLiveViewDirPath))
                {
                    DirectoryInfo CounterLiveViewDirInfo = new DirectoryInfo(RCCPPATH + "CounterLiveView\\");
                    FileInfo[] CounterLiveViewFileList = CounterLiveViewDirInfo.GetFiles("*", SearchOption.TopDirectoryOnly);
                    foreach (var liveViewFile in CounterLiveViewFileList)
                    {
                        CounterLiveViewModel tmpThisLiveViewFile = new CounterLiveViewModel();
                        tmpThisLiveViewFile.FileDateTime = liveViewFile.CreationTimeUtc;
                        tmpThisLiveViewFile.FileDateTimeString = liveViewFile.CreationTimeUtc.ToString("yyyy-MM-dd HH:mm");
                        tmpThisLiveViewFile.FileName = liveViewFile.Name;
                        tmpThisLiveViewFile.FullPath = "CounterLiveView/" + liveViewFile.Name;
                        LiveViewFileList.Add(tmpThisLiveViewFile);
                    }
                }

                var counterDailyRawData =
                    ffReportSummaryDailiesService.GetCountingLite(camIds, maxDate.AddDays(-119), maxDate);

                
                //counterRebootTable.DataSource = incidentLogCounterReboot;
                //networkFailureTable.DataSource = incidentLogCounterReboot;
                //highTemperatreTable.DataSource = highTemperatureCount;
                //tuningSettingUpdateTable.DataSource = incidentLogCounterReboot;
                //slowNetworkSpeedTable.DataSource = incidentLogCounterReboot;
                //lowStorageTable.DataSource = storageModuleCount;
                //For counter hourly

                var counterHourly = ffCameraHourlyValueServices
                    .GetCameraHourlyValues(camIds, maxDate.AddDays(-15), maxDate.AddDays(-1)).OrderBy(t => t.ValueDateTime)
                    .Select(t => new SummaryHourlyVM()
                    {
                        ValueDateTime = t.ValueDateTime,
                        ValueIn = t.ValueIn,
                        ValueOut = t.ValueOut,
                        CameraId = t.CameraId,
                        Day = t.Day,
                        BranchId = Convert.ToInt64(branchid),
                        isAlive = t.IsAlive
                    }).ToList();

                #region Operating Hour 
                //Filter counter hourly within operating hours
                //var counterHourlyOperatingData = ffBranchSummaryHourlyReportService.GetCounterDataWithinOperatingHour(counterHourly, false, true, Convert.ToInt64(branchid));

                //var longBranchId = Convert.ToInt64(branchid);
                ////Get Operating Hour for the branch during that day
                //var branchOperatingHour = ffBranchOperatingHourService.GetBranchOperatingHour(w => w.BranchId == longBranchId && w.Day == dayOfWeek && w.isDayOff == false);

                //string operatingHourStart;
                //string operatingHourEnd;
                //string operatingHour;
                //if (branchOperatingHour.Count() > 0)
                //{
                //    //var operatingHourStartHour = ;
                //    //var operatingHourStartMin = branchOperatingHour[0].StartTime.Minute;
                //    //var operatingHourEndHour = branchOperatingHour[0].EndTime.Hour;
                //    //var operatingHourEndMin = branchOperatingHour[0].EndTime.Minute;
                //    operatingHourStart = branchOperatingHour[0].StartTime.ToString("HH : mm");
                //    operatingHourEnd = branchOperatingHour[0].EndTime.ToString("HH : mm");
                //    operatingHour = operatingHourStart + " - " + operatingHourEnd;
                //}
                //else
                //{
                //    operatingHour = DataIntegrityReportViewer.DataIntegrityReportViewer_OffDay;
                //}

                #endregion 
                //Data display
                reportTitle.Value = storeName.ToUpper() + " " + CompanyDataIntegrityReport.DataIntegrityReportViewer_DataIntegrityReport.ToUpper();
                dayDate.Value = "Weekly Report " + maxDate.AddDays(-15).Date.ToString("dd/MM/yyyy") + "-" + maxDate.AddDays(-1).Date.ToString("dd/MM/yyyy");
                //operatingHourBox.Value = operatingHour;

                //Section Title Display
                //siteLevelSection.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_SiteLevel.ToUpper();
                //counterLevelSection.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_CounterLevel.ToUpper();
                //siteSummary14DaysTextbox.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_SiteSummaryForTheLast14Days;
                siteDetail14DaysTextbox.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_SiteDetailForTheLast14Days;
                siteHourly7DaysTextbox.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_SiteHourlyForTheLast7Days;
                

                #region Summary for Last 14 Days
                DateTime datetimeNow = DateTime.UtcNow;

                var getbranchDailyRawData = ffcompositeServices.GetBranchSummaryReport(datetimeNow.AddDays(-15), datetimeNow.AddDays(-1), "", Convert.ToInt64(branchid), false, false);
                var maxValueIn = getbranchDailyRawData.Max(s => s.ValueIn);
                var minValueIn = getbranchDailyRawData.Min(s => s.ValueIn);
                var maxValueOut = getbranchDailyRawData.Min(s => s.ValueOut);
                var minValueOut = getbranchDailyRawData.Min(s => s.ValueOut);
                var maxValue = maxValueIn > maxValueOut ? maxValueIn : maxValueOut;
                var minValue = minValueIn < minValueOut ? minValueIn : minValueOut;

                var denominator = TelerikUtility.CheckValueDenominator(minValue, maxValue);
                var FormatString = TelerikUtility.DenominatedStringFormat(denominator);
                
                var graphBranch14DaysDataSource = getbranchDailyRawData
                    .OrderBy(s => s.Date).Select(s => new BranchSummaryDailyReportViewModel()
                {
                    DateString = Utility.ConvertToDateTime(s.Date).ToString("ddd dd/MM"),
                    ValueDateTime = Utility.ConvertToDateTime(s.Date),
                    ValueInDouble = (double)s.ValueIn / denominator,
                    ValueOutDouble = (double)s.ValueOut / denominator,
                    Discrepancy = CheckValueInValueOut(s.ValueIn, s.ValueOut),
                    SalesConversion = s.SalesConversion
                    }).ToList();
                //var graphCounter14DaysIncident

                TelerikUtility.PlotLineGraph_2YAxisLabel(graphBranchDailySummary.ToString(), graphBranchDailySummary, graphBranch14DaysDataSource, "=Fields.DateString", "Date", "=Fields.ValueInDouble", DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor, "=Fields.SalesConversion", DataIntegrityReportViewer.DataIntegrityReportViewer_SalesConversion +" (%)", "=Fields.ValueOutDouble", DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut, DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn, font, FormatString);

                


                maxValueIn = branchHourlyOperatingData.Max(s => s.ValueIn);
                minValueIn = branchHourlyOperatingData.Min(s => s.ValueIn);
                maxValueOut = branchHourlyOperatingData.Min(s => s.ValueOut);
                minValueOut = branchHourlyOperatingData.Min(s => s.ValueOut);
                maxValue = maxValueIn > maxValueOut ? maxValueIn : maxValueOut;
                minValue = minValueIn < minValueOut ? minValueIn : minValueOut;

                denominator = TelerikUtility.CheckValueDenominator(minValue, maxValue);
                FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                //Graph branch hourly data display for 14 days
                var graphBranchHourlyDataSource = branchHourlyOperatingData.OrderBy(s => s.ValueDateTime).Select(s => new BranchSummaryHourlyReportViewModel()
                {
                    DateString = s.ValueDateTime.Date.ToString("ddd dd/MM"),
                    Hour = s.ValueDateTime.Date.ToString("dd/MM") + " " + s.ValueDateTime.Hour + ":00",
                    ValueDateTime = s.ValueDateTime,
                    ValueInDouble = (double)s.ValueIn / denominator,
                    ValueOutDouble = (double)s.ValueOut / denominator
                }).ToList();

                PlotHourlyLineGraphs(graphBranchHourly.ToString(), graphBranchHourly, graphBranchHourlyDataSource, "=Fields.ValueDateTime", "=Fields.ValueInDouble", "=Fields.ValueOutDouble", font, FormatString);

                //Table data display
                var tableDataSource = branchDailyRawData.Where(s => s.Date >= halfTimestamp && s.Date <= endTimestamp).Select(
                    s => new BranchSummaryDailyReportViewModel()
                    {
                        ValueIn = s.ValueIn,
                        ValueOut = s.ValueOut,
                        BranchId = s.BranchId,
                        DateString = Utility.ConvertToDateTime(s.Date).ToString("ddd dd/MM"),
                        SalesConversion = s.SalesConversion
                    });

                //branchSummaryTable.DataSource = tableDataSource.GroupBy(s => s.BranchId).Select(
                //    s => new BranchSummaryDailyReportViewModel()
                //    {
                //        ValueIn = tableDataSource.Sum(t => t.ValueIn),
                //        ValueOut = tableDataSource.Sum(t => t.ValueOut)
                //    });

                var data = tableDataSource.Select(
                    s => new BranchSummaryDailyReportViewModel()
                    {
                        DateString = s.DateString,
                        ValueIn = s.ValueIn,
                        ValueOut = s.ValueOut,
                        Discrepancy = CheckValueInValueOut(s.ValueIn, s.ValueOut),
                        SalesConversion = s.SalesConversion
                    });

                branchDetailTable.DataSource = data;

                var totalValueIn = data.GroupBy(g => g.ValueIn).Select(s => s.Sum(v => v.ValueIn)).ToList();
                var totalValueOut = data.GroupBy(g => g.ValueOut).Select(s => s.Sum(v => v.ValueOut)).ToList();

                //if (totalValueIn.Sum() > totalValueOut.Sum())
                //{
                //    overallAccuracy.Value = Math.Round((100 - ((double)totalValueOut.Sum() / (double)totalValueIn.Sum() * 100)), 2).ToString();
                //}
                //else if (totalValueIn.Sum() < totalValueOut.Sum())
                //{
                //    overallAccuracy.Value = Math.Round((100 - ((double)totalValueIn.Sum() / (double)totalValueOut.Sum() * 100)), 2).ToString();
                //}
                //else if (totalValueIn == totalValueOut)
                //{
                //    if (totalValueIn.Sum() == 0 && totalValueOut.Sum() == 0)
                //        overallAccuracy.Value = "-";
                //    else
                //        overallAccuracy.Value = "0";
                //}
                //else
                //    overallAccuracy.Value = "0";
                #endregion

                #region Incident Log
                //incident Log Data Source
                var incidentLogDataSource = incidentLogService.GetIncidentLogMany(w => camSerial.Contains(w.Serial));

                var incidentLogData = incidentLogDataSource
                    .Where(s => s.LogLevel != "INFO" & s.DateTime >= maxDate.AddDays(-15).Date & s.DateTime <= maxDate.AddDays(-1).Date);
                var counterRebootData = incidentLogData.Where(s => s.Category == "Counter Reboot");
                var highTemperatureData = incidentLogData.Where(s => s.Type == "High Temperature");
                var lowStorageData = incidentLogData.Where(s => s.Category == "Storage Module");
                var getCount = counterRebootData
                    .Select(s => new IncidentLogVM()
                    {
                        getCounterRebootCount = counterRebootData.Count(),
                        getHighTemperatureCount = highTemperatureData.Count(),
                        lowStorageCount = lowStorageData.Count()

                    }).FirstOrDefault();

                var incidentLog = incidentLogData
                    .Select(s => new IncidentLogVM()
                    {
                        Serial = s.Serial,
                        DateTime = s.DateTime,
                        DateTimeString = s.DateTime.ToString("ddd dd/MM/yyyy hh:mm:ss"),
                        LogLevel = s.LogLevel,
                        Category = s.Category,
                        Type = s.Type,
                        IssueLog = s.IssueLog
                    }).OrderByDescending(p=>p.DateTime)
                    .Take(50).ToList();

                counterRebootTable.DataSource = getCount;
                incidentLogTable.DataSource = incidentLog;
                #endregion


                var yLocation = 10.5;
                var yLocationHour = 12.5;
                var yLocationLiveViewPhotos = 16.5;
                var yTable = 16.7;
                var j = 1;
                #region Heartbeat and Power Log

                List<CounterHealthCheck> chclist = counterHealthCheckService.GetCounterHealthChecks(w => camSerial.Contains(w.Serial))
                    .ToList();
                var graphCounterHourlyIsAlive = counterHourly
                       .OrderBy(s => s.ValueDateTime)
                       .Where(s => camIds.Contains(s.CameraId))
                       .Select(s => new SummaryHourlyVM()
                       {
                           Hour = s.ValueDateTime.Hour + ":00",
                           ValueDateTimeString = s.ValueDateTime.ToString("ddd dd/MM"),
                           ValueDateTime = DateTime.ParseExact(s.ValueDateTime.ToString("dd/MM hh:mm"), "dd/MM hh:mm", null),
                           isAlive = s.isAlive
                       }).ToList();


                #endregion
                //Graph counter daily and hourly data display for 14 days
                for (int i = 0; i < camIds.Count; i++)
                {
                    //var textbox = new Telerik.Reporting.TextBox();
                    //        var textbox2 = new Telerik.Reporting.TextBox();
                    //var textbox3 = new Telerik.Reporting.TextBox();
                    //        var textbox4 = new Telerik.Reporting.TextBox();
                    //        var textbox5 = new Telerik.Reporting.TextBox();
                    //        var textbox6 = new Telerik.Reporting.TextBox();
                    //        var textbox7 = new Telerik.Reporting.TextBox();
                    //        var counterSerial = camSerial[i];



                    //        textbox.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.8), Telerik.Reporting.Drawing.Unit.Inch(0.22));
                    //        textbox.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0), Telerik.Reporting.Drawing.Unit.Inch(yLocation));
                    //        textbox.Style.Font.Name = font;
                    //        textbox.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
                    //        textbox.Style.Font.Bold = false;
                    //        textbox.Value = "  COUNTER0" + (i+1) + " (" + camCompanySerial[i] + " / " + camSerial[i] + ") v" + camFirmwareVersion[i];
                    //        textbox.Name = "textbox1-" + camIds[i];
                    //        textbox.Style.BackgroundColor = Color.DimGray;
                    //        textbox.Style.Color = Color.White;
                    //        textbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
                    //        this.detail.Items.Add(textbox);

                    //        textbox4.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(2), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //        textbox4.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0), Telerik.Reporting.Drawing.Unit.Inch(yLocation + 0.2));
                    //        textbox4.Style.Font.Name = font;
                    //        textbox4.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
                    //        textbox4.Style.Color = Color.Red;
                    //        textbox4.Style.Font.Bold = false;
                    //        textbox4.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoDataAvailableForThisPeriod;
                    //        textbox4.Name = "errorBox1";
                    //        textbox4.Visible = false;
                    //        this.detail.Items.Add(textbox4);

                    //        textbox2.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(2), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //        textbox2.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0), Telerik.Reporting.Drawing.Unit.Inch(yLocationHour));
                    //        textbox2.Style.Font.Name = font;
                    //        textbox2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(12);
                    //        textbox2.Style.Font.Bold = false;
                    //        textbox2.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_CounterHourlyForLast7Days;
                    //        textbox2.Name = "textbox2-" + camIds[i];
                    //        this.detail.Items.Add(textbox2);

                    //        textbox5.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(2), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //        textbox5.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yLocationHour + 0.2));
                    //        textbox5.Style.Font.Name = font;
                    //        textbox5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
                    //        textbox5.Style.Color = Color.Red;
                    //        textbox5.Style.Font.Bold = false;
                    //        textbox5.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoDataAvailableForThisPeriod;
                    //        textbox5.Name = "errorBox2";
                    //        textbox5.Visible = false;
                    //        this.detail.Items.Add(textbox5);

                    //        textbox6.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(5), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //        textbox6.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yLocationHour + 2.0));
                    //        textbox6.Style.Font.Name = font;
                    //        textbox6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(12);
                    //        textbox6.Style.Font.Bold = false;
                    //        textbox6.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_CounterPowerLogHourlyForLast7Days;
                    //        textbox6.Name = "textbox6-" + camIds[i];
                    //        this.detail.Items.Add(textbox6);

                    //        textbox7.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(2), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //        textbox7.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yLocationHour + 2.2));
                    //        textbox7.Style.Font.Name = font;
                    //        textbox7.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
                    //        textbox7.Style.Color = Color.Red;
                    //        textbox7.Style.Font.Bold = false;
                    //        textbox7.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoDataAvailableForThisPeriod;
                    //        textbox7.Name = "errorBox3";
                    //        textbox7.Visible = false;
                    //        this.detail.Items.Add(textbox7);

                    //textbox3.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(2), Telerik.Reporting.Drawing.Unit.Inch(0.2));
                    //textbox3.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yLocationLiveViewPhotos));
                    //textbox3.Style.Font.Name = font;
                    //textbox3.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(12);
                    //textbox3.Style.Font.Bold = false;
                    //textbox3.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_CounterLiveViewPhotos;
                    //textbox3.Name = "textbox3-" + camIds[i];

                    //        yLocation = yLocation + 0.2;
                    //        yLocationHour = yLocationHour + 0.2;
                    //        yLocationLiveViewPhotos = yLocationLiveViewPhotos + 0.2;
                    //        yTable = yTable + 0.2;

                    //        maxValueIn = counterDailyRawData.Max(s => s.ValueIn);
                    //        minValueIn = counterDailyRawData.Min(s => s.ValueIn);
                    //        maxValueOut = counterDailyRawData.Min(s => s.ValueOut);
                    //        minValueOut = counterDailyRawData.Min(s => s.ValueOut);
                    //        maxValue = maxValueIn > maxValueOut ? maxValueIn : maxValueOut;
                    //        minValue = minValueIn < minValueOut ? minValueIn : minValueOut;

                    //        denominator = TelerikUtility.CheckValueDenominator(minValue, maxValue);
                    //        FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    //        //var graphCounterDailyDataSource = counterDailyRawData.OrderBy(s => s.ValueDateTime)
                    //        //    .Where(s => s.CameraId == camIds[i]).Select(s => new SummaryDailyVM()
                    //        //    {
                    //        //    // Date = s.Date,
                    //        //        ValueDateTimeString = s.ValueDateTime.Date.ToString("ddd dd/MM"),
                    //        //        ValueDateTime = s.ValueDateTime,
                    //        //        ValueInDouble = (double)s.ValueIn / denominator,
                    //        //        ValueOutDouble = (double)s.ValueOut / denominator
                    //        //    }).ToList();

                    //        //if (graphCounterDailyDataSource.Count() > 0)
                    //        //{
                    //        //    PlotDailyLineGraphs2("daily" + camIds[i], graphCounterDailyDataSource,
                    //        //    "=Fields.ValueDateTime", "=Fields.ValueInDouble", "=Fields.ValueOutDouble", font, FormatString, yLocation);
                    //        //}
                    //        //else
                    //        //{
                    //        //    textbox4.Visible = true;
                    //        //}

                    //        //maxValueIn = counterHourlyOperatingData.Max(s => s.ValueIn);
                    //        //minValueIn = counterHourlyOperatingData.Min(s => s.ValueIn);
                    //        //maxValueOut = counterHourlyOperatingData.Min(s => s.ValueOut);
                    //        //minValueOut = counterHourlyOperatingData.Min(s => s.ValueOut);
                    //        //maxValue = maxValueIn > maxValueOut ? maxValueIn : maxValueOut;
                    //        //minValue = minValueIn < minValueOut ? minValueIn : minValueOut;

                    //        //denominator = TelerikUtility.CheckValueDenominator(minValue, maxValue);
                    //        //FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    //        //var graphCounterHourlyDataSource = counterHourlyOperatingData.OrderBy(s => s.ValueDateTime).Where(s => s.CameraId == camIds[i]).Select(s => new SummaryHourlyVM()
                    //        //{
                    //        //    ValueDateTime = s.ValueDateTime,
                    //        //    ValueInDouble = (double)s.ValueIn / denominator,
                    //        //    ValueOutDouble = (double)s.ValueOut / denominator,
                    //        //    ValueDateTimeString = s.ValueDateTime.Date.ToString("dd/MM") + " " + s.ValueDateTime.Hour + ":00",
                    //        //}).ToList();

                    //        //if (graphCounterHourlyDataSource.Count() > 0)
                    //        //{
                    //        //    PlotHourlyLineGraphs2("hourly" + camIds[i], graphCounterHourlyDataSource,
                    //        //    "=Fields.ValueDateTime", "=Fields.ValueInDouble", "=Fields.ValueOutDouble", font, FormatString, yLocationHour);
                    //        //}
                    //        //else
                    //        //{
                    //        //    textbox5.Visible = true;
                    //        //}
                    //        #region Power Log and Internet Connection for Last 14 Days
                    //var graphCounterHourlyIsAlive = counterHourly
                    //    .OrderBy(s => s.ValueDateTime)
                    //    .Where(s => s.CameraId == camIds[i])
                    //    .Select(s => new SummaryHourlyVM()
                    //    {
                    //        Hour = s.ValueDateTime.Hour + ":00",
                    //        ValueDateTimeString = s.ValueDateTime.ToString("ddd dd/MM"),
                    //        ValueDateTime = DateTime.ParseExact(s.ValueDateTime.ToString("dd/MM hh:mm"), "dd/MM hh:mm", null),
                    //        isAlive = s.isAlive
                    //    }).ToList();



                    //if (graphCounterHourlyIsAlive.Count() > 0)
                    //{
                    //    PlotHourlyLineRangeBarChart("Power Log Hourly" + camIds[i], graphCounterHourlyIsAlive,
                    //    "=Fields.Hour", "=Fields.ValueDateTimeString", "=Fields.isAlive", font, FormatString, yLocationHour + 2.0);
                    //}
                    //else
                    //{
                    //    textbox7.Visible = true;
                    //}

                    //        #endregion

                    //        #region LiveView 
                    //    var verifiedLiveViewPath = ffcompositeServices.GetVerifiedLiveViewPhoto(camIds[i]);
                    //if (LiveViewFileList.Count() > 0)
                    //{
                    //    var serial = camSerial[i];
                    //    var liveViewList = ffcompositeServices.GetYearlyLiveViewList(serial, LiveViewFileList);
                    //    if (liveViewList.Count() > 0)
                    //    {
                    //        this.detail.Items.Add(textbox3);
                    //        PlotTableForLiveView(liveViewList, yTable, verifiedLiveViewPath);
                    //        yLocation = yLocation + 8.2;
                    //        yLocationHour = yLocationHour + 8.2;
                    //        yLocationLiveViewPhotos = yLocationLiveViewPhotos + 8.2;
                    //        yTable = yTable + 8.2;
                    //    }
                    //    else
                    //    {
                    //        yLocation = yLocation + 6.2;
                    //        yLocationHour = yLocationHour + 6.2;
                    //        yLocationLiveViewPhotos = yLocationLiveViewPhotos + 6.2;
                    //        yTable = yTable + 6.2;
                    //    }
                    //}
                    //        #endregion
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }
        #region Telerik Reporting Tables and Graph
        public Telerik.Reporting.Table PlotTableForLiveView(List<YearlyCounterLiveView> liveViewList, double yTable, string verifiedLiveViewPath)
		{
			foreach (var x in liveViewList)
			{
				if (String.IsNullOrEmpty(x.LiveViewWithLinePath))
				{
					x.LiveViewWithLinePath = "Content/images/ErrorMsg_withline.jpg";
				}

				if (String.IsNullOrEmpty(x.LiveViewWithoutLinePath))
				{
					x.LiveViewWithoutLinePath = "Content/images/ErrorMsg_noline.jpg";
				}
			}

			if (String.IsNullOrEmpty(verifiedLiveViewPath))
			{
				verifiedLiveViewPath = HttpContext.Current.Server.MapPath("~/Content/images/ErrorMsg_noline.jpg");
			}
			else
			{
				if (!File.Exists(verifiedLiveViewPath))
				{
					verifiedLiveViewPath = HttpContext.Current.Server.MapPath("~/Content/images/ErrorMsg_noline.jpg");
				}
			}

			var monthlabel12 = liveViewList[0].monthString;
			var photoWithLinePath12 = liveViewList[0].LiveViewWithLinePath;
			var photoWithoutLinePath12 = liveViewList[0].LiveViewWithoutLinePath;
			var monthlabel11 = liveViewList[1].monthString;
			var photoWithLinePath11 = liveViewList[1].LiveViewWithLinePath;
			var photoWithoutLinePath11 = liveViewList[1].LiveViewWithoutLinePath;
			var monthlabel10 = liveViewList[2].monthString;
			var photoWithLinePath10 = liveViewList[2].LiveViewWithLinePath;
			var photoWithoutLinePath10 = liveViewList[2].LiveViewWithoutLinePath;
			var monthlabel9 = liveViewList[3].monthString;
			var photoWithLinePath9 = liveViewList[3].LiveViewWithLinePath;
			var photoWithoutLinePath9 = liveViewList[3].LiveViewWithoutLinePath;
			var monthlabel8 = liveViewList[4].monthString;
			var photoWithLinePath8 = liveViewList[4].LiveViewWithLinePath;
			var photoWithoutLinePath8 = liveViewList[4].LiveViewWithoutLinePath;
			var monthlabel7 = liveViewList[5].monthString;
			var photoWithLinePath7 = liveViewList[5].LiveViewWithLinePath;
			var photoWithoutLinePath7 = liveViewList[5].LiveViewWithoutLinePath;
			var monthlabel6 = liveViewList[6].monthString;
			var photoWithLinePath6 = liveViewList[6].LiveViewWithLinePath;
			var photoWithoutLinePath6 = liveViewList[6].LiveViewWithoutLinePath;
			var monthlabel5 = liveViewList[7].monthString;
			var photoWithLinePath5 = liveViewList[7].LiveViewWithLinePath;
			var photoWithoutLinePath5 = liveViewList[7].LiveViewWithoutLinePath;
			var monthlabel4 = liveViewList[8].monthString;
			var photoWithLinePath4 = liveViewList[8].LiveViewWithLinePath;
			var photoWithoutLinePath4 = liveViewList[8].LiveViewWithoutLinePath;
			var monthlabel3 = liveViewList[9].monthString;
			var photoWithLinePath3 = liveViewList[9].LiveViewWithLinePath;
			var photoWithoutLinePath3 = liveViewList[9].LiveViewWithoutLinePath;
			var monthlabel2 = liveViewList[10].monthString;
			var photoWithLinePath2 = liveViewList[10].LiveViewWithLinePath;
			var photoWithoutLinePath2 = liveViewList[10].LiveViewWithoutLinePath;
			var monthlabel1 = liveViewList[11].monthString;
			var photoWithLinePath1 = liveViewList[11].LiveViewWithLinePath;
			var photoWithoutLinePath1 = liveViewList[11].LiveViewWithoutLinePath;

			var table1 = new Telerik.Reporting.Table();
			table1.Name = "table1";
			table1.RowGroups.Clear();
			table1.ColumnGroups.Clear();
			table1.Body.Columns.Clear();
			table1.Body.Rows.Clear();

			TableGroup tableGroup1 = new TableGroup();
			TableGroup tableGroup2 = new TableGroup();
			TableGroup tableGroup3 = new TableGroup();
			TableGroup tableGroup4 = new TableGroup();
			TableGroup tableGroup5 = new TableGroup();
			TableGroup tableGroup6 = new TableGroup();
			TableGroup tableGroup7 = new TableGroup();
			TableGroup tableGroup8 = new TableGroup();
			TableGroup tableGroup9 = new TableGroup();
			TableGroup tableGroup10 = new TableGroup();
			TableGroup tableGroup11 = new TableGroup();
			TableGroup tableGroup12 = new TableGroup();
			TableGroup tableGroup13 = new TableGroup();
			TableGroup tableGroup14 = new TableGroup();
			TableGroup tableGroup15 = new TableGroup();
			TableGroup tableGroup16 = new TableGroup();
			TableGroup tableGroup17 = new TableGroup();
			TableGroup tableGroup18 = new TableGroup();
			TableGroup tableGroup19 = new TableGroup();
			TableGroup tableGroup20 = new TableGroup();
			TableGroup tableGroup21 = new TableGroup();
			TableGroup tableGroup22 = new TableGroup();
			TableGroup tableGroup23 = new TableGroup();
			TableGroup tableGroup24 = new TableGroup();
			TableGroup tableGroup25 = new TableGroup();
			TableGroup tableGroup26 = new TableGroup();
			TableGroup tableGroup27 = new TableGroup();

			var textBoxLive1 = new Telerik.Reporting.TextBox();
			var textBoxLive2 = new Telerik.Reporting.TextBox();
			var textBoxLive3 = new Telerik.Reporting.TextBox();
			var textBoxLive4 = new Telerik.Reporting.TextBox();
			var textBoxLive5 = new Telerik.Reporting.TextBox();
			var textBoxLive6 = new Telerik.Reporting.TextBox();
			var textBoxLive7 = new Telerik.Reporting.TextBox();
			var textBoxLive8 = new Telerik.Reporting.TextBox();
			var textBoxLive9 = new Telerik.Reporting.TextBox();
			var textBoxLive10 = new Telerik.Reporting.TextBox();
			var textBoxLive11 = new Telerik.Reporting.TextBox();
			var textBoxLive12 = new Telerik.Reporting.TextBox();
			var pictureBox1 = new PictureBox();
			var pictureBox2 = new PictureBox();
			var pictureBox3 = new PictureBox();
			var pictureBox4 = new PictureBox();
			var pictureBox5 = new PictureBox();
			var pictureBox6 = new PictureBox();
			var pictureBox7 = new PictureBox();
			var pictureBox8 = new PictureBox();
			var pictureBox9 = new PictureBox();
			var pictureBox10 = new PictureBox();
			var pictureBox11 = new PictureBox();
			var pictureBox12 = new PictureBox();
			var pictureBox13 = new PictureBox();
			var pictureBox14 = new PictureBox();
			var pictureBox15 = new PictureBox();
			var pictureBox16 = new PictureBox();
			var pictureBox17 = new PictureBox();
			var pictureBox18 = new PictureBox();
			var pictureBox19 = new PictureBox();
			var pictureBox20 = new PictureBox();
			var pictureBox21 = new PictureBox();
			var pictureBox22 = new PictureBox();
			var pictureBox23 = new PictureBox();
			var pictureBox24 = new PictureBox();

			//detail
			this.detail.Items.AddRange(new ReportItemBase[] {
			table1});

			//table1
			table1.Body.Columns.Add(new TableBodyColumn(Telerik.Reporting.Drawing.Unit.Pixel(340)));
			table1.Body.Columns.Add(new TableBodyColumn(Telerik.Reporting.Drawing.Unit.Pixel(165)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));
			table1.Body.Rows.Add(new TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(1.1700007915496826D)));

			table1.Body.SetCellContent(0, 0, pictureBox1, 1, 2);
			//table1.Body.SetCellContent(0, 1, pictureBox2);
			table1.Body.SetCellContent(1, 0, textBoxLive2, 1, 2);
			table1.Body.SetCellContent(2, 0, pictureBox3);
			table1.Body.SetCellContent(2, 1, pictureBox4);

			table1.Body.SetCellContent(3, 0, textBoxLive3, 1, 2);
			table1.Body.SetCellContent(4, 0, pictureBox5);
			table1.Body.SetCellContent(4, 1, pictureBox6);

			table1.Body.SetCellContent(5, 0, textBoxLive4, 1, 2);
			table1.Body.SetCellContent(6, 0, pictureBox7);
			table1.Body.SetCellContent(6, 1, pictureBox8);

			table1.Body.SetCellContent(7, 0, textBoxLive5, 1, 2);
			table1.Body.SetCellContent(8, 0, pictureBox9);
			table1.Body.SetCellContent(8, 1, pictureBox10);

			table1.Body.SetCellContent(9, 0, textBoxLive6, 1, 2);
			table1.Body.SetCellContent(10, 0, pictureBox11);
			table1.Body.SetCellContent(10, 1, pictureBox12);

			table1.Body.SetCellContent(11, 0, textBoxLive7, 1, 2);
			table1.Body.SetCellContent(12, 0, pictureBox13);
			table1.Body.SetCellContent(12, 1, pictureBox14);

			table1.Body.SetCellContent(13, 0, textBoxLive8, 1, 2);
			table1.Body.SetCellContent(14, 0, pictureBox15);
			table1.Body.SetCellContent(14, 1, pictureBox16);

			table1.Body.SetCellContent(15, 0, textBoxLive9, 1, 2);
			table1.Body.SetCellContent(16, 0, pictureBox17);
			table1.Body.SetCellContent(16, 1, pictureBox18);

			table1.Body.SetCellContent(17, 0, textBoxLive10, 1, 2);
			table1.Body.SetCellContent(18, 0, pictureBox19);
			table1.Body.SetCellContent(18, 1, pictureBox20);

			table1.Body.SetCellContent(19, 0, textBoxLive11, 1, 2);
			table1.Body.SetCellContent(20, 0, pictureBox21);
			table1.Body.SetCellContent(20, 1, pictureBox22);

			table1.Body.SetCellContent(21, 0, textBoxLive12, 1, 2);
			table1.Body.SetCellContent(22, 0, pictureBox23);
			table1.Body.SetCellContent(22, 1, pictureBox24);

			tableGroup2.Name = "Group2";
			tableGroup3.Name = "Group3";
			tableGroup1.ChildGroups.Add(tableGroup2);
			tableGroup1.ChildGroups.Add(tableGroup3);
			tableGroup1.Name = "Group1";
			tableGroup1.ReportItem = textBoxLive1;


			//tableGroup2.ChildGroups.Add(tableGroup5);
			//tableGroup2.ChildGroups.Add(tableGroup6);
			//tableGroup2.Name = "Group2";
			//tableGroup2.ReportItem = textBoxLive2;
			table1.ColumnGroups.Add(tableGroup1);
			//table1.ColumnGroups.Add(tableGroup2);

			table1.Items.AddRange(new ReportItemBase[] {
			pictureBox1,
			pictureBox2,
			pictureBox3,
			pictureBox4,
			pictureBox5,
			pictureBox6,
			pictureBox7,
			pictureBox8,
			pictureBox9,
			pictureBox10,
			pictureBox11,
			pictureBox12,
			pictureBox13,
			pictureBox14,
			pictureBox15,
			pictureBox16,
			pictureBox17,
			pictureBox18,
			pictureBox19,
			pictureBox20,
			pictureBox21,
			pictureBox22,
			pictureBox23,
			pictureBox24,
			textBoxLive1,
			textBoxLive2,
			textBoxLive3,
			textBoxLive4,
			textBoxLive5,
			textBoxLive6,
			textBoxLive7,
			textBoxLive8,
			textBoxLive9,
			textBoxLive10,
			textBoxLive11,
			textBoxLive12});

			table1.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.4), Telerik.Reporting.Drawing.Unit.Inch(yTable));
			table1.Name = "table1";
			tableGroup4.Name = "group4";
			tableGroup5.Name = "group5";
			tableGroup6.Name = "group6";
			tableGroup8.Name = "group8";
			tableGroup9.Name = "group9";
			tableGroup10.Name = "group10";
			tableGroup11.Name = "group11";
			tableGroup12.Name = "group12";
			tableGroup13.Name = "group13";
			tableGroup14.Name = "group14";
			tableGroup15.Name = "group15";
			tableGroup16.Name = "group16";
			tableGroup17.Name = "group17";
			tableGroup18.Name = "group18";
			tableGroup19.Name = "group19";
			tableGroup20.Name = "group20";
			tableGroup21.Name = "group21";
			tableGroup22.Name = "group22";
			tableGroup23.Name = "group23";
			tableGroup24.Name = "group24";
			tableGroup25.Name = "group25";
			tableGroup26.Name = "group26";
			tableGroup27.Name = "group27";
			tableGroup7.ChildGroups.Add(tableGroup4);
			tableGroup7.ChildGroups.Add(tableGroup5);
			tableGroup7.ChildGroups.Add(tableGroup6);
			tableGroup7.ChildGroups.Add(tableGroup8);
			tableGroup7.ChildGroups.Add(tableGroup9);
			tableGroup7.ChildGroups.Add(tableGroup10);
			tableGroup7.ChildGroups.Add(tableGroup11);
			tableGroup7.ChildGroups.Add(tableGroup12);
			tableGroup7.ChildGroups.Add(tableGroup13);
			tableGroup7.ChildGroups.Add(tableGroup14);
			tableGroup7.ChildGroups.Add(tableGroup15);
			tableGroup7.ChildGroups.Add(tableGroup16);
			tableGroup7.ChildGroups.Add(tableGroup17);
			tableGroup7.ChildGroups.Add(tableGroup18);
			tableGroup7.ChildGroups.Add(tableGroup19);
			tableGroup7.ChildGroups.Add(tableGroup20);
			tableGroup7.ChildGroups.Add(tableGroup21);
			tableGroup7.ChildGroups.Add(tableGroup22);
			tableGroup7.ChildGroups.Add(tableGroup23);
			tableGroup7.ChildGroups.Add(tableGroup24);
			tableGroup7.ChildGroups.Add(tableGroup25);
			tableGroup7.ChildGroups.Add(tableGroup26);
			tableGroup7.ChildGroups.Add(tableGroup27);
			tableGroup7.Groupings.Add(new Grouping(null));
			tableGroup7.Name = "detailTableGroup";
			table1.RowGroups.Add(tableGroup7);
			table1.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.3), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			table1.StyleName = "Normal.TableNormal";

			// textBox1
			textBoxLive1.Name = "textBox1";
			textBoxLive1.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive1.StyleName = "Normal.TableBody";
			textBoxLive1.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_LastVerifiedLiveView;
			textBoxLive1.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;

			// textBox2
			textBoxLive2.Name = "textBox2";
			textBoxLive2.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive2.StyleName = "Normal.TableBody";
			textBoxLive2.Value = monthlabel1;
			textBoxLive2.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive2.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;

			// textBox3
			textBoxLive3.Name = "textBox3";
			textBoxLive3.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive3.StyleName = "Normal.TableBody";
			textBoxLive3.Value = monthlabel2;
			textBoxLive3.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive3.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;

			// textBox4
			textBoxLive4.Name = "textBox4";
			textBoxLive4.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive4.StyleName = "Normal.TableBody";
			textBoxLive4.Value = monthlabel3;
			textBoxLive4.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive4.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;

			// textBox5
			textBoxLive5.Name = "textBox5";
			textBoxLive5.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive5.StyleName = "Normal.TableBody";
			textBoxLive5.Value = monthlabel4;
			textBoxLive5.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive5.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox6
			textBoxLive6.Name = "textBox6";
			textBoxLive6.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive6.StyleName = "Normal.TableBody";
			textBoxLive6.Value = monthlabel5;
			textBoxLive6.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive6.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox7
			textBoxLive7.Name = "textBox7";
			textBoxLive7.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive7.StyleName = "Normal.TableBody";
			textBoxLive7.Value = monthlabel6;
			textBoxLive7.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive7.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox8
			textBoxLive8.Name = "textBox8";
			textBoxLive8.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive8.StyleName = "Normal.TableBody";
			textBoxLive8.Value = monthlabel7;
			textBoxLive8.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive8.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox9
			textBoxLive9.Name = "textBox9";
			textBoxLive9.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive9.StyleName = "Normal.TableBody";
			textBoxLive9.Value = monthlabel8;
			textBoxLive9.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive9.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox10
			textBoxLive10.Name = "textBox10";
			textBoxLive10.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive10.StyleName = "Normal.TableBody";
			textBoxLive10.Value = monthlabel9;
			textBoxLive10.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive10.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox11
			textBoxLive11.Name = "textBox11";
			textBoxLive11.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive11.StyleName = "Normal.TableBody";
			textBoxLive11.Value = monthlabel10;
			textBoxLive11.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive11.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			// textBox12
			textBoxLive12.Name = "textBox12";
			textBoxLive12.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(0.2));
			textBoxLive12.StyleName = "Normal.TableBody";
			textBoxLive12.Value = monthlabel11;
			textBoxLive12.Style.Padding.Top = Telerik.Reporting.Drawing.Unit.Cm(0.5);
			textBoxLive12.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;

			//This region check if no live view, then hide section
			if (verifiedLiveViewPath.Contains("ErrorMsg_noline"))
			{
				textBoxLive1.Visible = false;
				pictureBox1.Visible = false;
			}

			if (photoWithoutLinePath1.Contains("ErrorMsg_noline") && photoWithLinePath1.Contains("ErrorMsg_withline"))
			{
				textBoxLive2.Visible = false;
				pictureBox3.Visible = false;
				pictureBox4.Visible = false;
			}

			if (photoWithoutLinePath2.Contains("ErrorMsg_noline") && photoWithLinePath2.Contains("ErrorMsg_withline"))
			{
				textBoxLive3.Visible = false;
				pictureBox5.Visible = false;
				pictureBox6.Visible = false;
			}

			if (photoWithoutLinePath3.Contains("ErrorMsg_noline") && photoWithLinePath3.Contains("ErrorMsg_withline"))
			{
				textBoxLive4.Visible = false;
				pictureBox7.Visible = false;
				pictureBox8.Visible = false;
			}

			if (photoWithoutLinePath4.Contains("ErrorMsg_noline") && photoWithLinePath4.Contains("ErrorMsg_withline"))
			{
				textBoxLive5.Visible = false;
				pictureBox9.Visible = false;
				pictureBox10.Visible = false;
			}

			if (photoWithoutLinePath5.Contains("ErrorMsg_noline") && photoWithLinePath5.Contains("ErrorMsg_withline"))
			{
				textBoxLive6.Visible = false;
				pictureBox11.Visible = false;
				pictureBox12.Visible = false;
			}

			if (photoWithoutLinePath6.Contains("ErrorMsg_noline") && photoWithLinePath6.Contains("ErrorMsg_withline"))
			{
				textBoxLive7.Visible = false;
				pictureBox13.Visible = false;
				pictureBox14.Visible = false;
			}

			if (photoWithoutLinePath7.Contains("ErrorMsg_noline") && photoWithLinePath7.Contains("ErrorMsg_withline"))
			{
				textBoxLive8.Visible = false;
				pictureBox15.Visible = false;
				pictureBox16.Visible = false;
			}

			if (photoWithoutLinePath8.Contains("ErrorMsg_noline") && photoWithLinePath8.Contains("ErrorMsg_withline"))
			{
				textBoxLive9.Visible = false;
				pictureBox17.Visible = false;
				pictureBox18.Visible = false;
			}

			if (photoWithoutLinePath9.Contains("ErrorMsg_noline") && photoWithLinePath9.Contains("ErrorMsg_withline"))
			{
				textBoxLive10.Visible = false;
				pictureBox19.Visible = false;
				pictureBox20.Visible = false;
			}

			if (photoWithoutLinePath10.Contains("ErrorMsg_noline") && photoWithLinePath10.Contains("ErrorMsg_withline"))
			{
				textBoxLive11.Visible = false;
				pictureBox21.Visible = false;
				pictureBox22.Visible = false;
			}

			if (photoWithoutLinePath11.Contains("ErrorMsg_noline") && photoWithLinePath11.Contains("ErrorMsg_withline"))
			{
				textBoxLive12.Visible = false;
				pictureBox23.Visible = false;
				pictureBox24.Visible = false;
			}

			// pictureBox1
			pictureBox1.Name = "pictureBox1";
			pictureBox1.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(510), Telerik.Reporting.Drawing.Unit.Inch(1.5));
			pictureBox1.StyleName = "Normal.TableBody";
			pictureBox1.Value = verifiedLiveViewPath;
			pictureBox1.Sizing = ImageSizeMode.Center;

			// pictureBox2
			//pictureBox2.Name = "pictureBox2";
			//pictureBox2.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(1), Telerik.Reporting.Drawing.Unit.Inch(1));
			//pictureBox2.StyleName = "Normal.TableBody";
			//pictureBox2.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath1);
			//pictureBox2.Sizing = ImageSizeMode.Stretch;

			// pictureBox3
			pictureBox3.Name = "pictureBox3";
			pictureBox3.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox3.StyleName = "Normal.TableBody";
			pictureBox3.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath1);
			pictureBox3.Sizing = ImageSizeMode.Stretch;

			// pictureBox4
			pictureBox4.Name = "pictureBox4";
			pictureBox4.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox4.StyleName = "Normal.TableBody";
			pictureBox4.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath1);
			pictureBox4.Sizing = ImageSizeMode.Normal;

			// pictureBox5
			pictureBox5.Name = "pictureBox5";
			pictureBox5.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox5.StyleName = "Normal.TableBody";
			pictureBox5.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath2);
			pictureBox5.Sizing = ImageSizeMode.Stretch;

			// pictureBox6
			pictureBox6.Name = "pictureBox6";
			pictureBox6.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox6.StyleName = "Normal.TableBody";
			pictureBox6.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath2);
			pictureBox6.Sizing = ImageSizeMode.Normal;

			// pictureBox7
			pictureBox7.Name = "pictureBox7";
			pictureBox7.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox7.StyleName = "Normal.TableBody";
			pictureBox7.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath3);
			pictureBox7.Sizing = ImageSizeMode.Stretch;

			// pictureBox8
			pictureBox8.Name = "pictureBox8";
			pictureBox8.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox8.StyleName = "Normal.TableBody";
			pictureBox8.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath3);
			pictureBox8.Sizing = ImageSizeMode.Normal;

			// pictureBox9
			pictureBox9.Name = "pictureBox9";
			pictureBox9.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox9.StyleName = "Normal.TableBody";
			pictureBox9.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath4);
			pictureBox9.Sizing = ImageSizeMode.Stretch;

			// pictureBox10
			pictureBox10.Name = "pictureBox10";
			pictureBox10.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox10.StyleName = "Normal.TableBody";
			pictureBox10.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath4);
			pictureBox10.Sizing = ImageSizeMode.Normal;

			// pictureBox11
			pictureBox11.Name = "pictureBox11";
			pictureBox11.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox11.StyleName = "Normal.TableBody";
			pictureBox11.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath5);
			pictureBox11.Sizing = ImageSizeMode.Stretch;

			// pictureBox12
			pictureBox12.Name = "pictureBox12";
			pictureBox12.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox12.StyleName = "Normal.TableBody";
			pictureBox12.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath5);
			pictureBox12.Sizing = ImageSizeMode.Normal;

			// pictureBox13
			pictureBox13.Name = "pictureBox13";
			pictureBox13.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox13.StyleName = "Normal.TableBody";
			pictureBox13.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath6);
			pictureBox13.Sizing = ImageSizeMode.Stretch;

			// pictureBox14
			pictureBox14.Name = "pictureBox14";
			pictureBox14.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox14.StyleName = "Normal.TableBody";
			pictureBox14.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath6);
			pictureBox14.Sizing = ImageSizeMode.Normal;

			// pictureBox15
			pictureBox15.Name = "pictureBox15";
			pictureBox15.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox15.StyleName = "Normal.TableBody";
			pictureBox15.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath7);
			pictureBox15.Sizing = ImageSizeMode.Stretch;

			// pictureBox16
			pictureBox16.Name = "pictureBox16";
			pictureBox16.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox16.StyleName = "Normal.TableBody";
			pictureBox16.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath7);
			pictureBox16.Sizing = ImageSizeMode.Normal;

			// pictureBox17
			pictureBox17.Name = "pictureBox17";
			pictureBox17.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox17.StyleName = "Normal.TableBody";
			pictureBox17.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath8);
			pictureBox17.Sizing = ImageSizeMode.Stretch;

			// pictureBox18
			pictureBox18.Name = "pictureBox18";
			pictureBox18.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox18.StyleName = "Normal.TableBody";
			pictureBox18.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath8);
			pictureBox18.Sizing = ImageSizeMode.Normal;

			// pictureBox19
			pictureBox19.Name = "pictureBox19";
			pictureBox19.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox19.StyleName = "Normal.TableBody";
			pictureBox19.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath9);
			pictureBox19.Sizing = ImageSizeMode.Stretch;

			// pictureBox20
			pictureBox20.Name = "pictureBox20";
			pictureBox20.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox20.StyleName = "Normal.TableBody";
			pictureBox20.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath9);
			pictureBox20.Sizing = ImageSizeMode.Normal;

			// pictureBox21
			pictureBox21.Name = "pictureBox21";
			pictureBox21.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox21.StyleName = "Normal.TableBody";
			pictureBox21.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath10);
			pictureBox21.Sizing = ImageSizeMode.Stretch;

			// pictureBox22
			pictureBox22.Name = "pictureBox22";
			pictureBox22.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox22.StyleName = "Normal.TableBody";
			pictureBox22.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath10);
			pictureBox22.Sizing = ImageSizeMode.Normal;

			// pictureBox23
			pictureBox23.Name = "pictureBox23";
			pictureBox23.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(340), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox23.StyleName = "Normal.TableBody";
			pictureBox23.Value = HttpContext.Current.Server.MapPath("~/" + photoWithoutLinePath11);
			pictureBox23.Sizing = ImageSizeMode.Stretch;

			// pictureBox24
			pictureBox24.Name = "pictureBox24";
			pictureBox24.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Pixel(165), Telerik.Reporting.Drawing.Unit.Inch(1.2));
			pictureBox24.StyleName = "Normal.TableBody";
			pictureBox24.Value = HttpContext.Current.Server.MapPath("~/" + photoWithLinePath11);
			pictureBox24.Sizing = ImageSizeMode.Normal;

			return table1;
		}

		public Graph PlotHourlyLineGraphs(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup,
			string yAxisGroup, string yAxisGroup2, string font, string format)
		{
			reportGraphName.Name = graphName;
			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var SalesConversionSectionCategoryGroup = new GraphGroup();
			SalesConversionSectionCategoryGroup.Name = "categoryGroup";
			SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var SalesConversionSectionSeriesGroup = new GraphGroup();
			SalesConversionSectionSeriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			var dateTimeScale = new DateTimeScale();
			dateTimeScale.LabelUnit = DateTimeScaleUnits.Hours;
			dateTimeScale.LabelStep = 4;

			graphAxisCategoryScale.Scale = dateTimeScale;
			graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
			graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.LabelFormat = "{0: dd/MM HH:mm}";
			//  graphAxisCategoryScale.Style.Visible = false;

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			graphAxisNumericalScale5.Scale = new NumericalScale();
			graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
			//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//Setup 2nd Graph Axis with Numerical Scale
			var graphAxisNumericalScale6 = new GraphAxis();
			graphAxisNumericalScale6.Name = "Y Axis 2";
			graphAxisNumericalScale6.Scale = new NumericalScale();
			graphAxisNumericalScale6.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale6.Style.Font.Name = font;
			graphAxisNumericalScale6.TitleStyle.Font.Name = font;
			graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.Style.LineColor = Color.White;
			graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;

			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			cartesianCoordinateSystem.XAxis.LabelAngle = 270;

			//The Graph Series area
			var lineSeries1 = new LineSeries();
			lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn;
			lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries1.Y = yAxisGroup;
			lineSeries1.X = categoryGraphGroup;
			lineSeries1.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Series.Add(lineSeries1);
			lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(63, 168, 202));
            lineSeries1.ToolTip.Text = yAxisGroup;

			//The Line Series area
			var lineSeries2 = new LineSeries();
			lineSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries2.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut;
			lineSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
            lineSeries2.Y = yAxisGroup2;
			lineSeries2.X = categoryGraphGroup;
			lineSeries2.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			reportGraphName.Series.Add(lineSeries2);
			lineSeries2.ColorPalette = new ColorPalette(Color.FromArgb(253, 131, 115));
            lineSeries2.ToolTip.Text = yAxisGroup2;

			return reportGraphName;
		}

		public Graph PlotHourlyLineGraphs2(string graphName, List<SummaryHourlyVM> dataList, string categoryGraphGroup,
			string yAxisGroup, string yAxisGroup2, string font, string format, double yPosition)
		{
			var reportGraphName = new Graph();
			reportGraphName.Name = graphName;
			reportGraphName.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.3), Telerik.Reporting.Drawing.Unit.Inch(1.8));
			reportGraphName.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yPosition));
			this.detail.Items.Add(reportGraphName);

			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var SalesConversionSectionCategoryGroup = new GraphGroup();
			SalesConversionSectionCategoryGroup.Name = "categoryGroup";
			SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var SalesConversionSectionSeriesGroup = new GraphGroup();
			SalesConversionSectionSeriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			var dateTimeScale = new DateTimeScale();
			dateTimeScale.LabelUnit = DateTimeScaleUnits.Hours;
			dateTimeScale.LabelStep = 4;

			graphAxisCategoryScale.Scale = dateTimeScale;
			graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
			graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.LabelFormat = "{0: dd/MM HH:mm}";
			//  graphAxisCategoryScale.Style.Visible = false;

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			graphAxisNumericalScale5.Scale = new NumericalScale();
			graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
			//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//Setup 2nd Graph Axis with Numerical Scale
			var graphAxisNumericalScale6 = new GraphAxis();
			graphAxisNumericalScale6.Name = "Y Axis 2";
			graphAxisNumericalScale6.Scale = new NumericalScale();
			graphAxisNumericalScale6.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale6.Style.Font.Name = font;
			graphAxisNumericalScale6.TitleStyle.Font.Name = font;
			graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.Style.LineColor = Color.White;
			graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;

			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			cartesianCoordinateSystem.XAxis.LabelAngle = 270;

			//The Graph Series area
			var lineSeries1 = new LineSeries();
			lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn;
			lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries1.Y = yAxisGroup;
			lineSeries1.X = categoryGraphGroup;
			lineSeries1.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Series.Add(lineSeries1);
			lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(63, 168, 202));
            lineSeries1.ToolTip.Text = yAxisGroup;

			//The Line Series area
			var lineSeries2 = new LineSeries();
			lineSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries2.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut;
			lineSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries2.Y = yAxisGroup2;
			lineSeries2.X = categoryGraphGroup;
			lineSeries2.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			reportGraphName.Series.Add(lineSeries2);
			lineSeries2.ColorPalette = new ColorPalette(Color.FromArgb(253, 131, 115));
            lineSeries2.ToolTip.Text = yAxisGroup2;

			return reportGraphName;
		}
       
        public Graph PlotHourlyLineGraphs3(string graphName, List<SummaryHourlyVM> dataList, string categoryGraphGroup,
			string yAxisGroup, string font, string format, double yPosition)
		{
			var reportGraphName = new Graph();
			reportGraphName.Name = graphName;
			reportGraphName.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.3), Telerik.Reporting.Drawing.Unit.Inch(1.8));
			reportGraphName.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yPosition));
			this.detail.Items.Add(reportGraphName);

			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var PowerLogSectionCategoryGroup = new GraphGroup();
			PowerLogSectionCategoryGroup.Name = "categoryGroup";
			PowerLogSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(PowerLogSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var PowerLogSectionSeriesGroup = new GraphGroup();
			PowerLogSectionSeriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(PowerLogSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			var dateTimeScale = new DateTimeScale();
			dateTimeScale.LabelUnit = DateTimeScaleUnits.Hours;
			dateTimeScale.LabelStep = 4;

			graphAxisCategoryScale.Scale = dateTimeScale;
			graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
			graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.LabelFormat = "{0: dd/MM HH:mm}";
			//  graphAxisCategoryScale.Style.Visible = false;

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			var numericScale = new NumericalScale();
			numericScale.Maximum = 1;
			numericScale.Minimum = 0;
			numericScale.LabelStep = 1.0;

			graphAxisNumericalScale5.Scale = numericScale;
			graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_OnlineStatus;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
			//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;

			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			cartesianCoordinateSystem.XAxis.LabelAngle = 270;

			//The Graph Series area
			var lineSeries1 = new AreaSeries();
			lineSeries1.CategoryGroup = PowerLogSectionCategoryGroup;
			lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_OnlineStatus;
			lineSeries1.SeriesGroup = PowerLogSectionSeriesGroup;
            lineSeries1.LineType = LineSeries.LineTypes.Stepped;
			lineSeries1.Y = yAxisGroup;
			lineSeries1.X = categoryGraphGroup;
			reportGraphName.Series.Add(lineSeries1);
			lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(225, 50, 205, 50));
            lineSeries1.AreaStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(0);
            lineSeries1.ToolTip.Text = yAxisGroup;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			return reportGraphName;
		}

        [Obsolete]
        public Graph PlotHourlyLineRangeBarChart(string graphName, List<SummaryHourlyVM> dataList, string categoryGraphGroup,
            string yAxisGroup, string isAlive, string font, string format, double yPosition)
        {
            var reportGraphName = new Graph();
            reportGraphName.Name = graphName;
            reportGraphName.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.3), Telerik.Reporting.Drawing.Unit.Inch(1.8));
            reportGraphName.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yPosition));
            this.detail.Items.Add(reportGraphName);

            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = dataList;

            //Create the category group
            var PowerLogSectionCategoryGroup = new GraphGroup();
            PowerLogSectionCategoryGroup.Name = "categoryGroup";
            PowerLogSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraphName.CategoryGroups.Add(PowerLogSectionCategoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var PowerLogSectionSeriesGroup = new GraphGroup();
            PowerLogSectionSeriesGroup.Name = "seriesGroup";
            reportGraphName.SeriesGroups.Add(PowerLogSectionSeriesGroup);

            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            var dateTimeScale = new DateTimeScale();
            dateTimeScale.LabelUnit = DateTimeScaleUnits.Hours;
            dateTimeScale.LabelStep = 1;

            graphAxisCategoryScale.Scale = dateTimeScale;
            graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Hour;
            graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.TitleStyle.Font.Name = font;
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //  graphAxisCategoryScale.Style.Visible = false;

            //Setup Graph Axis with Date Scale
            var graphAxisDateScale = new GraphAxis();
            graphAxisDateScale.Name = "Y Axis";
            var dateScale = new DateTimeScale();
            dateScale.LabelUnit = DateTimeScaleUnits.Days;
            dateScale.LabelStep = 1;

            graphAxisDateScale.Scale = dateScale;
            graphAxisDateScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
            graphAxisDateScale.Style.Font.Name = font;
            graphAxisDateScale.TitleStyle.Font.Name = font;
            graphAxisDateScale.Style.Font.Style = FontStyle.Regular;
            graphAxisDateScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            graphAxisDateScale.Style.LineColor = Color.White;
            graphAxisDateScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisDateScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisDateScale.LabelFormat = "{0: ddd dd/MM}";
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
            cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem.YAxis = graphAxisDateScale;
            cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
            cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;

            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //The Graph Series VBar Series
            var rangebarSeries = new RangeBarSeries();
            rangebarSeries.CategoryGroup = PowerLogSectionCategoryGroup;
            rangebarSeries.CoordinateSystem = cartesianCoordinateSystem;
            rangebarSeries.LegendItem.Value = isAlive;
            rangebarSeries.SeriesGroup = PowerLogSectionSeriesGroup;
            rangebarSeries.Y = yAxisGroup;
            rangebarSeries.X = categoryGraphGroup;
            rangebarSeries.Y0 = isAlive;
            reportGraphName.Series.Add(rangebarSeries);
            rangebarSeries.ColorPalette = new ColorPalette(Color.FromArgb(225, 50, 205, 50));
            rangebarSeries.ToolTip.Text = yAxisGroup;
            reportGraphName.Legend.Position = GraphItemPosition.TopRight;
            return reportGraphName;
        }
        public Graph PlotDailyLineGraphs(string graphName, Graph reportGraphName, List<BranchSummaryDailyReportViewModel> dataList, string categoryGraphGroup,
			string yAxisGroup, string yAxisGroup2, string yAxisGroup3, string font, string format)
		{
			reportGraphName.Name = graphName;
			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var SalesConversionSectionCategoryGroup = new GraphGroup();
			SalesConversionSectionCategoryGroup.Name = "categoryGroup";
			SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var SalesConversionSectionSeriesGroup = new GraphGroup();
			SalesConversionSectionSeriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			var dateTimeScale = new DateTimeScale();
			dateTimeScale.LabelUnit = DateTimeScaleUnits.Days;
			dateTimeScale.LabelStep = 1;

			graphAxisCategoryScale.Scale = dateTimeScale;
			graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
			graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.LabelFormat = "{0: ddd dd/MM}";

            ////Setup another Graph Axis X with CategoryScale (X AXIS 2)
            //var categoryGroup_X_Axis_2 = new GraphAxis();
            //categoryGroup_X_Axis_2.Name = "X Axis 2";
            //graphAxisCategoryScale.Scale = dateTimeScale;
            //categoryGroup_X_Axis_2.Style.Visible = false;
            //categoryGroup_X_Axis_2.MajorGridLineStyle.Visible = false;
            //categoryGroup_X_Axis_2.MinorGridLineStyle.Visible = false;

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			graphAxisNumericalScale5.Scale = new NumericalScale();
			graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //Setup Graph Axis with Numerical Scale in SalesConv
            var graphAxisNumericalScaleSalesConv = new GraphAxis();
            graphAxisNumericalScaleSalesConv.Name = "Y Axis 2";
            graphAxisNumericalScaleSalesConv.Scale = new NumericalScale();
            graphAxisNumericalScaleSalesConv.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_SalesConversion;
            graphAxisNumericalScaleSalesConv.Style.Font.Name = font;
            graphAxisNumericalScaleSalesConv.TitleStyle.Font.Name = font;
            graphAxisNumericalScaleSalesConv.Style.Font.Style = FontStyle.Regular;
            graphAxisNumericalScaleSalesConv.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            graphAxisNumericalScaleSalesConv.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScaleSalesConv.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScaleSalesConv.Style.LineColor = Color.White;
            graphAxisNumericalScaleSalesConv.LabelFormat = format;

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem1 = new CartesianCoordinateSystem();
            cartesianCoordinateSystem1.Name = "cartesianCoordinateSystemSalesConv";
            cartesianCoordinateSystem1.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem1.YAxis = graphAxisNumericalScaleSalesConv;
            cartesianCoordinateSystem1.XAxis.Style.Font.Name = font;
            cartesianCoordinateSystem1.YAxis.Style.Font.Name = font;
            cartesianCoordinateSystem1.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            cartesianCoordinateSystem1.YAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;

            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem1);
            
            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            cartesianCoordinateSystem.YAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;

            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			//cartesianCoordinateSystem.XAxis.LabelAngle = 270;


            //cartesianCoordinateSystem1.XAxis.LabelAngle = 270;

            //The Graph Series area
            var lineSeries1 = new LineSeries();
			lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn;
			lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries1.Y = yAxisGroup;
			lineSeries1.X = categoryGraphGroup;
            lineSeries1.MarkerType = DataPointMarkerType.Circle;
			lineSeries1.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Series.Add(lineSeries1);
			lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(63, 168, 202));
            lineSeries1.ToolTip.Text = yAxisGroup;

			//The Line Series area
			var lineSeries2 = new LineSeries();
			lineSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries2.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut;
			lineSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries2.Y = yAxisGroup2;
			lineSeries2.X = categoryGraphGroup;
            lineSeries2.MarkerType = DataPointMarkerType.Circle;
            lineSeries2.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			reportGraphName.Series.Add(lineSeries2);
			lineSeries2.ColorPalette = new ColorPalette(Color.FromArgb(253, 131, 115));
            lineSeries2.ToolTip.Text = yAxisGroup2;

            //sales conv.
            var lineSeries3 = new LineSeries();
            lineSeries3.CategoryGroup = SalesConversionSectionCategoryGroup;
            lineSeries3.CoordinateSystem = cartesianCoordinateSystem1;
            lineSeries3.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_SalesConversion;
            lineSeries3.SeriesGroup = SalesConversionSectionSeriesGroup;
            lineSeries3.Y = yAxisGroup3;
            lineSeries3.X = categoryGraphGroup;
            lineSeries3.MarkerType = DataPointMarkerType.Circle;
            lineSeries3.LineStyle.LineStyle = LineStyle.Solid;
            reportGraphName.Legend.Position = GraphItemPosition.TopRight;
            reportGraphName.Series.Add(lineSeries3);
            lineSeries3.ColorPalette = new ColorPalette(Color.FromArgb(51, 255, 51));
            lineSeries3.ToolTip.Text = yAxisGroup3;

            return reportGraphName;
		}
        public Graph PlotIncidentLogGraph(string graphName, Graph reportGraphName, List<IncidentLogVM> dataList, string categoryGraphGroup,
            string yAxisGroup, string yAxisGroup2, string yAxisGroup3, string font, string format)
        {
            reportGraphName.Name = graphName;
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = dataList;

            //Create the category group
            var SalesConversionSectionCategoryGroup = new GraphGroup();
            SalesConversionSectionCategoryGroup.Name = "categoryGroup";
            SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var SalesConversionSectionSeriesGroup = new GraphGroup();
            SalesConversionSectionSeriesGroup.Name = "seriesGroup";
            reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            var dateTimeScale = new DateTimeScale();
            dateTimeScale.LabelUnit = DateTimeScaleUnits.Days;
            dateTimeScale.LabelStep = 1;

            graphAxisCategoryScale.Scale = dateTimeScale;
            graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
            graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.TitleStyle.Font.Name = font;
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.LabelFormat = "{0: ddd dd/MM}";

            ////Setup another Graph Axis X with CategoryScale (X AXIS 2)
            //var categoryGroup_X_Axis_2 = new GraphAxis();
            //categoryGroup_X_Axis_2.Name = "X Axis 2";
            //graphAxisCategoryScale.Scale = dateTimeScale;
            //categoryGroup_X_Axis_2.Style.Visible = false;
            //categoryGroup_X_Axis_2.MajorGridLineStyle.Visible = false;
            //categoryGroup_X_Axis_2.MinorGridLineStyle.Visible = false;

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale5 = new GraphAxis();
            graphAxisNumericalScale5.Name = "Y Axis";
            graphAxisNumericalScale5.Scale = new NumericalScale();
            graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
            graphAxisNumericalScale5.Style.Font.Name = font;
            graphAxisNumericalScale5.TitleStyle.Font.Name = font;
            graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
            graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.Style.LineColor = Color.White;
            graphAxisNumericalScale5.LabelFormat = format;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //Setup Graph Axis with Numerical Scale in SalesConv
            var graphAxisNumericalScaleSalesConv = new GraphAxis();
            graphAxisNumericalScaleSalesConv.Name = "Y Axis 2";
            graphAxisNumericalScaleSalesConv.Scale = new NumericalScale();
            graphAxisNumericalScaleSalesConv.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_SalesConversion;
            graphAxisNumericalScaleSalesConv.Style.Font.Name = font;
            graphAxisNumericalScaleSalesConv.TitleStyle.Font.Name = font;
            graphAxisNumericalScaleSalesConv.Style.Font.Style = FontStyle.Regular;
            graphAxisNumericalScaleSalesConv.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            graphAxisNumericalScaleSalesConv.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScaleSalesConv.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScaleSalesConv.Style.LineColor = Color.White;
            graphAxisNumericalScaleSalesConv.LabelFormat = format;

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem1 = new CartesianCoordinateSystem();
            cartesianCoordinateSystem1.Name = "cartesianCoordinateSystemSalesConv";
            cartesianCoordinateSystem1.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem1.YAxis = graphAxisNumericalScaleSalesConv;
            cartesianCoordinateSystem1.XAxis.Style.Font.Name = font;
            cartesianCoordinateSystem1.YAxis.Style.Font.Name = font;
            cartesianCoordinateSystem1.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            cartesianCoordinateSystem1.YAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;

            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem1);

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
            cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
            cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
            cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            cartesianCoordinateSystem.YAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;

            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
            //cartesianCoordinateSystem.XAxis.LabelAngle = 270;


            //cartesianCoordinateSystem1.XAxis.LabelAngle = 270;

            //The Graph Series area
            var lineSeries1 = new LineSeries();
            lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
            lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn;
            lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
            lineSeries1.Y = yAxisGroup;
            lineSeries1.X = categoryGraphGroup;
            lineSeries1.MarkerType = DataPointMarkerType.Circle;
            lineSeries1.LineStyle.LineStyle = LineStyle.Solid;
            reportGraphName.Series.Add(lineSeries1);
            lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(63, 168, 202));
            lineSeries1.ToolTip.Text = yAxisGroup;

            //The Line Series area
            var lineSeries2 = new LineSeries();
            lineSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
            lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries2.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut;
            lineSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
            lineSeries2.Y = yAxisGroup2;
            lineSeries2.X = categoryGraphGroup;
            lineSeries2.MarkerType = DataPointMarkerType.Circle;
            lineSeries2.LineStyle.LineStyle = LineStyle.Solid;
            reportGraphName.Legend.Position = GraphItemPosition.TopRight;
            reportGraphName.Series.Add(lineSeries2);
            lineSeries2.ColorPalette = new ColorPalette(Color.FromArgb(253, 131, 115));
            lineSeries2.ToolTip.Text = yAxisGroup2;


            return reportGraphName;
        }
        public Graph PlotDailyLineGraphs2(string graphName, List<SummaryDailyVM> dataList, string categoryGraphGroup,
			string yAxisGroup, string yAxisGroup2, string font, string format, double yPosition)
		{
			var reportGraphName = new Graph();
			reportGraphName.Name = graphName;
			reportGraphName.Size = new SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.3), Telerik.Reporting.Drawing.Unit.Inch(1.8));
			reportGraphName.Location = new PointU(Telerik.Reporting.Drawing.Unit.Inch(0.1), Telerik.Reporting.Drawing.Unit.Inch(yPosition));
			this.detail.Items.Add(reportGraphName);

			// reportGraphName.Name = graphName;
			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var SalesConversionSectionCategoryGroup = new GraphGroup();
			SalesConversionSectionCategoryGroup.Name = "categoryGroup";
			SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var SalesConversionSectionSeriesGroup = new GraphGroup();
			SalesConversionSectionSeriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			var dateTimeScale = new DateTimeScale();
			dateTimeScale.LabelUnit = DateTimeScaleUnits.Days;
			dateTimeScale.LabelStep = 3;

			graphAxisCategoryScale.Scale = dateTimeScale;
			graphAxisCategoryScale.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_Date;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
			graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.LabelFormat = "{0: ddd dd/MM}";

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			graphAxisNumericalScale5.Scale = new NumericalScale();
			graphAxisNumericalScale5.Title = DataIntegrityReportViewer.DataIntegrityReportViewer_NoofVisitor;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
			//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;

			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			cartesianCoordinateSystem.XAxis.LabelAngle = 270;

			//The Graph Series area
			var lineSeries1 = new LineSeries();
			lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries1.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorIn;
			lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries1.Y = yAxisGroup;
			lineSeries1.X = categoryGraphGroup;
			lineSeries1.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Series.Add(lineSeries1);
			lineSeries1.ColorPalette = new ColorPalette(Color.FromArgb(63, 168, 202));
            lineSeries1.ToolTip.Text = yAxisGroup;

			//The Line Series area
			var lineSeries2 = new LineSeries();
			lineSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
			lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
			lineSeries2.LegendItem.Value = DataIntegrityReportViewer.DataIntegrityReportViewer_NoOfVisitorOut;
			lineSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
			lineSeries2.Y = yAxisGroup2;
			lineSeries2.X = categoryGraphGroup;
			lineSeries2.LineStyle.LineStyle = LineStyle.Solid;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			reportGraphName.Series.Add(lineSeries2);
			lineSeries2.ColorPalette = new ColorPalette(Color.FromArgb(253, 131, 115));
            lineSeries2.ToolTip.Text = yAxisGroup2;

			return reportGraphName;
		}
        #endregion
        public static double CheckValueInValueOut(int ValueIn, int ValueOut)
		{
			if (ValueIn > ValueOut)
			{
				return 100 - ((double)ValueOut / (double)ValueIn * 100);
			}
			else if (ValueIn < ValueOut)
			{
				return 100 - ((double)ValueIn / (double)ValueOut * 100);
			}
			else if (ValueIn == ValueOut)
			{
                if (ValueIn == 0 && ValueOut == 0)
                    return -1;
                else
                    return 0;
            }
			else
				return 0;
		}
	}
}