﻿using RetailCamControlPanel.ViewModel;
using System.Collections.Generic;

namespace RetailCamControlPanel
{
    using Helper;
    using Models;
    using Services.CompositeService;
    using Services.SingularService;
    using System;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using ViewModel;
    using System.Web;
    //using Resources;
    using System.Threading;
    using System.Configuration;
    using System.Reflection;
    using Newtonsoft.Json;
    using System.IO;

    /*
     *  ===== TELERIK REPORT TEMPLATE PREREQUISITES ====================
     *  
     *  MODULES: 
     *  Copy and Paste the required module(s) within this template. 
     *  You can create your own module to cater specific needs. 
     *  *MODULE DIMENSION: 
     *  - Width     : 3.4 cm
     *  - Height    : 2.4 cm
     *  *GAP BETWEEN MODULES (Using Panel): 
     *  - Width     : 0.5 cm
     *  - Height    : 2.4 cm
     *  
     *  COLOR PATLETTE FOR EACH SECTION: 
     *  1. Pink #ef7cae         RGB: 239,124,174
     *  2. Orange #ff8000       RGB: 255,128,0
     *  3. Green #62bc69           RGB: 98,188,105
     *  4. Blue #60a5da            RGB: 96,165,218
     *  5. Brown #b0902f           RGB: 176,144,47
     *  
     *  PLEASE CONFIGURE THE INDIVIDUAL ELEMENTS' PROPERTIES IN DESIGNER
     *  (ESPECIALLY SETTING FONT NAME TO "Arial Unicode MS")
     *  
     *  ================================================================
    */
    public partial class ExperienceCentreReport_v2 : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        public static List<BranchSummaryDailyReportViewModel> sevenDayTrendData;

        public ExperienceCentreReport_v2()
        {
            InitializeComponent();
        }

        private void ExperienceCentreReport_v2_NeedDataSource(object sender, EventArgs e)
        {
            #region  ===== VARIABLES
            //VARIABLES
            //DEFAULT FONT FOR TELERIK REPORT: "Arial Unicode MS"
            //PLEASE MODIFY THE FONT OF ALL ELEMENTS IN THE REPORT IN DESIGNER VIEW
            string font = Utility.Telerik_GetDefaultFontName();

            long companyId = 0;
            var dateFormat = 1;
            var dateFormatString = "dd/MM/yyyy";
            int reportDayCount = 0;

            #endregion


            #region ===== ADD SERVICE REFERENCES
            //==================================================================================================================
            /* ADD SERVICE REFERENCES TO USE COMPOSITE AND SINGULAR SERVICES
             *      - Add the required services to do RAW DATA PULLING & DATA AGGREGATION to call functions within the services      
             *      
             *      ** IMPORTANT: Consult appropriate person before modifying/adding new functions into these services. 
            */

            //EXAMPLE OF REFERENCING SERVICES (REMOVE THE UNNECESSARY REFERENCING, ONLY INCLUDE THE REQUIRED REFERENCING)
            var ffCompositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var companyService = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
            var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
            var ffAreaService = MvcApplication.container.GetInstance<AreaService>();
            var ffAreaDailyService = MvcApplication.container.GetInstance<AreaDailyService>();
            var ffBranchService = MvcApplication.container.GetInstance<FFBranchService>();
            var marketingTrackerReportService = MvcApplication.container.GetInstance<MarketingTrackerReportService>();
            var counterHealthCheckService = MvcApplication.container.GetInstance<CounterHealthCheckService>();
            var queueCountingService = MvcApplication.container.GetInstance<queueCountingService>();
            var ffCameraService = MvcApplication.container.GetInstance<FFCameraService>();
            var areaConfigService = MvcApplication.container.GetInstance<AreaConfigurationService>();
            var cameraLineService = MvcApplication.container.GetInstance<CameraLineSettingService>();
            var cameraHeatValues = MvcApplication.container.GetInstance<FFCameraHeatValueService>();
            var ffCameraHeatValues = MvcApplication.container.GetInstance<FFCameraHeatValueService>();

            #endregion

            //REQUIRED: TO CHECK WHETHER THE CLIENT SERVER HAS THE REQUIRED FONT OR NOT. IF NOT, RCCP WILL AUTO INSTALL
            ffCompositeService.checkIfArialUnicodeInstalled();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Assign arguments from front-end to here (Name of the parameters is based on the configured 'Report Parameters')
                #region ===== OBTAIN & PROCESS DATA FROM FRONT-END
                // OBTAINING DATA PASSED FROM FRONT-END
                var selectedStartDateHtml = Report.Parameters["StartDate"].Value.ToString();
                var selectedEndDateHtml = Report.Parameters["EndDate"].Value.ToString();
                var selectedStartDate2Html = Report.Parameters["StartDate2"].Value.ToString();
                var selectedEndDate2Html = Report.Parameters["EndDate2"].Value.ToString();
                var languageHtml = Report.Parameters["Language"].Value.ToString();
                var companyNameHtml = Report.Parameters["CompanyName"].Value.ToString();
                var companyCodeHtml = Report.Parameters["CompanyCode"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var userRoleHtml = Report.Parameters["userRole"].Value.ToString();
                var branchId = (long)Report.Parameters["BranchID"].Value;
                var branchName = Report.Parameters["BranchName"].Value.ToString();

                var culture = new System.Globalization.CultureInfo(languageHtml);

                if (dateFormatHtml != "dateFirst")
                {
                    dateFormat = 2;
                    dateFormatString = "MM/dd/yyyy";
                }
                DateTime selectedStartDate = new DateTime();
                DateTime selectedEndDate = new DateTime();
                selectedStartDate = DateTime.ParseExact(selectedStartDateHtml, dateFormatString, culture);
                selectedEndDate = DateTime.ParseExact(selectedEndDateHtml, dateFormatString, culture);

                DateTime selectedStartDate2 = new DateTime();
                DateTime selectedEndDate2 = new DateTime();
                selectedStartDate2 = DateTime.ParseExact(selectedStartDate2Html, dateFormatString, culture);
                selectedEndDate2 = DateTime.ParseExact(selectedEndDate2Html, dateFormatString, culture);
                reportDayCount = (int)(selectedEndDate - selectedStartDate).TotalDays;

                DayOfWeek dow = selectedStartDate.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);

                var monthName = culture.DateTimeFormat.GetMonthName(selectedStartDate.Month);

                #endregion

                #region ===== INFO GATHERING
                //Get Required Information for RAW DATA PULLING, DATA AGGREGATION and other usage within the report
                var cultureInfo = new System.Globalization.CultureInfo(languageHtml);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                var company = companyService.GetCompany(companyCodeHtml);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                if (companyCodeHtml != "")
                    companyId = companyService.GetCompany(companyCodeHtml).ID;
                else
                    companyId = companySetting.CompanyId;

                //Determine First Day of the Week based on Company Setting
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                //Date For comparing Report Date Period and Last Month
                DateTime lastMonthStartDate = selectedStartDate2;
                DateTime lastMonthEndDate = selectedEndDate2;
                //DateTime lastMonthStartDate = selectedStartDate.AddMonths(-1);
                //DateTime lastMonthEndDate = lastMonthStartDate.AddDays(reportDayCount);

                // For getting data for last 52 weeks (Campaign Module)
                DateTime campaignEndDate = selectedEndDate;
                while (campaignEndDate.AddDays(-6).DayOfWeek != firstDayOfWeek)
                {
                    campaignEndDate = campaignEndDate.AddDays(1);
                }
                DateTime reportStartDate = campaignEndDate.AddDays(-363);

                var financialYear52Weeks = new FinancialYearVM();
                var financialStartEnd52Weeks = new FinancialStartEnd();
                financialStartEnd52Weeks.FinancialStartDate = reportStartDate;
                financialStartEnd52Weeks.FinancialEndDate = campaignEndDate;
                //financialYear52Weeks.ThisYear = financialStartEnd52Weeks;
                financialYear52Weeks = Utility.GetFinancialWeekList2(selectedStartDate, companySetting);
                financialStartEnd52Weeks = financialYear52Weeks.ThisYear;

                var financialStartEnd = Utility.GetFinancialWeekList2(selectedStartDate, companySetting);

                string monthAbbreviatedName = culture.DateTimeFormat.GetAbbreviatedMonthName(selectedStartDate.Month);
                string thisYearString = selectedStartDate.ToString("yyyy");

                List<long> parentAreaQueueCountingsIds = new List<long>();

                //Get DataSetting
                //ParentAreaQueueCounting Check [Kelvin, 2019-01-08]
                FFDataSetting dataSetting_parentAreaQueueCountings = company.DataSettings.Where(w => w.Type.ID == 3).FirstOrDefault();
                if (dataSetting_parentAreaQueueCountings != null)
                {
                    string jsonStr = dataSetting_parentAreaQueueCountings.Attribute;
                    Type type = Type.GetType(dataSetting_parentAreaQueueCountings.Type.ToObjectType); //System.Collections.Generic.List`1[System.Int64]
                    parentAreaQueueCountingsIds = (List<long>)JsonConvert.DeserializeObject(jsonStr, type);
                }

                #endregion

                #region ===== PULL RAW DATA
                //Pull site level data for 2 years worth 12 months
                IEnumerable<BranchSummaryDailyReportViewModel> reportSiteDailyRawData = ffCompositeService.GetBranchSummaryReport(lastMonthStartDate, selectedEndDate, scReport: false, branchId: branchId, userRole: userRoleHtml);
                var currentSiteDailyData = reportSiteDailyRawData.Where(w => w.ValueDateTime >= selectedStartDate && w.ValueDateTime <= selectedEndDate).ToList();
                var lastMonthSiteDailyRawData = reportSiteDailyRawData.Where(w => w.ValueDateTime >= lastMonthStartDate && w.ValueDateTime <= lastMonthEndDate).ToList();

                //List of Area ID
                List<FFArea> allAreas = ffAreaService.GetMany(w => w.BranchId == branchId).ToList();
                List<long> childAreasIds = allAreas.Where(w => !w.ParentAreaId.IsNull()).Select(s => s.Id).ToList();
                List<long> parentAreaIds = allAreas.Where(w => w.ParentAreaId.IsNull() && allAreas.Any(a => a.ParentAreaId == w.ParentAreaId)).Select(s => s.Id).ToList();

                List<long> allAreasIds = allAreas.Select(s => s.Id).ToList();

                List<AreaConfigurationSetting> areaConfig = areaConfigService.GetMany(w => allAreasIds.Contains(w.AreaId)).ToList();

                //Get All Counter Information (Determine Queue Counting Or Not)
                IEnumerable<FFCamera> camList = ffCameraService.GetCameras(w => w.BranchId == branchId);
                List<string> camSerialLists = camList.Select(s => s.Serial).ToList();
                List<long> camIdLists = camList.Select(s => s.ID).ToList();
                List<AreaConfigurationSetting> areaConfigLists = areaConfigService.GetMany(w => w.Area.BranchId == branchId && w.IsDeleted == false).ToList();
                var camUsageTypeList1 = (from chclist in counterHealthCheckService.GetCounterHealthChecks(camSerialLists)
                                         join ffcamlist in camList on chclist.Serial equals ffcamlist.Serial
                                         select new { ffcamlist.ID, ffcamlist.Serial, chclist.UsageType }).ToList();

                var camUsageTypeList = (from chcffcamlist in camUsageTypeList1
                                        join acslist in areaConfigLists on chcffcamlist.ID equals acslist.CameraLineSetting.CameraId into tempacslist

                                        from empacslist in tempacslist.DefaultIfEmpty(new AreaConfigurationSetting())
                                        select new { CameraId = chcffcamlist.ID, chcffcamlist.Serial, chcffcamlist.UsageType, empacslist.AreaId }).Distinct().ToList();

                //SELECT DISTINCT area.IsDeleted, acss.IsDeleted, cam.ID, cam.CameraName, cam.Serial, hcs.UsageType, area.ID, area.ParentAreaId FROM CounterHealthChecks hcs
                //JOIN FFCameras cam ON cam.Serial = hcs.Serial
                //LEFT JOIN CameraLineSettings cls ON cls.CameraId = cam.Id
                //LEFT JOIN AreaConfigurationSettings acss ON cls.ID = acss.CameraLineId
                //LEFT JOIN FFAreas area ON area.Id = acss.AreaId
                //WHERE cam.BranchId = 6963

                //var chcList = counterHealthCheckService.GetCounterHealthChecks(w => camSerialLists.Contains(w.Serial)).ToList();
                //var rawFFCameraList = ffCameraService.GetCameras(w => w.BranchId == branchId).ToList();
                //List<long> ffCameraIdList = rawFFCameraList.Select(s => s.ID).ToList();
                //var ffCameraList = AutoMapper.Mapper.Map<List<FFCamera>, List<FFCameraViewModel>>(rawFFCameraList);
                //var cameraLineSettingList = rawFFCameraList.Select(s => s.ID).ToList();
                //var areaConfigSettingList = areaConfigService.GetMany(w => cameraLineSettingList.Contains(w.ID));
                //ffCameraList.ForEach(ffcamera =>
                //{
                //    var thisCounterChc = chcList.Find(f => f.Serial == ffcamera.Serial);
                //    ffcamera.UsageType = !thisCounterChc.IsNullOrEmpty() ? thisCounterChc.UsageType : ffcamera.UsageType;
                //});




                //GET QUEUE COUNTING DATA (TO BE MOVED TO FUNCTIONS) [Kelvin, 2019-08-16]
                List<DailyQueueCountingVMs> dailyQueueData = new List<DailyQueueCountingVMs>();
                List<QueueCountingVMs> queueRawData = new List<QueueCountingVMs>();
                if (camUsageTypeList.Any(a => a.UsageType.Contains("queue")))
                {
                    //Give 3 minutes margin of the date period for queue counting data
                    DateTime tempStartTime = selectedStartDate.AddMinutes(-3);
                    DateTime tempEndTime = selectedEndDate.AddMinutes(3);
                    List<long> queueCamIdList = camUsageTypeList.Where(ww => ww.UsageType.Contains("queue")).Select(ss => ss.CameraId).ToList();
                    queueRawData = queueCountingService.GetqueueCountingMany(w => queueCamIdList.Contains(w.cameraID) && w.DateTime >= tempStartTime && w.DateTime <= tempEndTime && w.serveTime > 0).Select(s => new QueueCountingVMs
                    {
                        CameraID = s.cameraID,
                        DateTime = Utility.RoundDateTime(s.DateTime).Date,
                        QueueDuration = s.queueTime,
                        ServeDuration = s.serveTime,
                        QueueEndTime = Utility.ConvertToDateTime(s.timestamp),
                        ServeEndTime = Utility.ConvertToDateTime(s.lastServeTime)
                    }).ToList();

                    //TO BE ABLE TO ADJUST ACCORDING TO THE Area Configuration Threshold
                    dailyQueueData = queueRawData.GroupBy(g => new { g.CameraID, g.DateTime.Year, g.DateTime.Month, g.DateTime.Day }).Select(s => new DailyQueueCountingVMs
                    {
                        CameraID = s.Key.CameraID,
                        DateTime = new DateTime(s.Key.Year, s.Key.Month, 1, 0, 0, 0),
                        QueueCount = s.Count(),
                        AverageQueueDuration = s.Average(a => a.QueueDuration),
                        AverageServeDuration = s.Average(a => a.ServeDuration),
                        LessIntervalQueueDurationCount = s.Where(w => w.QueueDuration < 30).Count(),
                        BetweenIntervalQueueDurationCount = s.Where(w => w.QueueDuration >= 30 && w.QueueDuration < 60).Count(),
                        OverIntervalQueueDurationCount = s.Where(w => w.QueueDuration >= 60).Count()
                    }).ToList();
                }

                // pull data from FFCHeatValue
                Dictionary<long, List<long>> areaCameraRelation = allAreas.Where(w => w.ParentAreaId == 148).ToDictionary(x => x.Id, x => x.AreaConfigurationSettings.Select(s => s.CameraLineSetting.CameraId).Distinct().ToList());

                List<long> cameraIds = areaCameraRelation.SelectMany(s => s.Value).Distinct().ToList();
                List<FFCameraHeatValue> ffCameraHeatValue = ffCameraHeatValues
                    .GetMany(w => cameraIds.Contains(w.CameraId) && w.ValueTimestamp >= lastMonthStartDate && w.ValueTimestamp <= selectedEndDate && w.PatchStatus == "Opened")
                    .GroupBy(x => new { x.ValueTimestamp, x.CameraId }, x => x).Select(x => new FFCameraHeatValue()
                    {
                        ValueTimestamp = x.Key.ValueTimestamp,
                        CameraId = x.Key.CameraId,
                        HeatMapStay = x.Sum(s => s.HeatMapStay)
                    }).ToList();

                //GET AREA DATA
                List<AreaDailyViewModel> areaDailyRawData = ffAreaDailyService.GetMany(w => childAreasIds.Contains(w.AreaId) && w.Date >= lastMonthStartDate && w.Date <= selectedEndDate).Select(s =>
                {
                    bool isQueueArea = camUsageTypeList.Any(a => a.UsageType.Contains("queue") && a.AreaId == s.AreaId);
                    var camTemp = camUsageTypeList.Where(ww => ww.UsageType.Contains("queue") && ww.AreaId == s.AreaId).Select(ss => ss.CameraId).ToList();
                    var queueDataTemp = queueRawData.Where(w => w.DateTime == s.Date && camTemp.Contains(w.CameraID)).ToList();

                    return new AreaDailyViewModel
                    {
                        ValueDateTime = s.Date,
                        ValueIn = isQueueArea ?
                                queueDataTemp.Count() :
                                    areaCameraRelation.Keys.Contains(s.AreaId) ?
                                    ffCameraHeatValue.Where(w => w.ValueTimestamp == s.Date && areaCameraRelation[s.AreaId].Contains(w.CameraId)).Sum(y => y.HeatMapStay) :
                                    s.ValueIn,
                        ValueOut = s.ValueOut,
                        LessIntervalWifiCount = isQueueArea ?
                                queueDataTemp.Where(w =>
                                    w.QueueDuration < s.MinDwellThreshold
                                    ).ToList()
                                .Count()
                                : s.LessIntervalWifiCount,
                        BetweenIntervalWifiCount = isQueueArea ?
                                queueDataTemp.Where(w =>
                                    w.QueueDuration >= s.MinDwellThreshold && w.QueueDuration <= s.MaxDwellThreshold
                                    ).ToList()
                                .Count()
                                : s.BetweenIntervalWifiCount,
                        OverIntervalWifiCount = isQueueArea ?
                                queueDataTemp.Where(w =>
                                    w.QueueDuration >= s.MaxDwellThreshold
                                    ).ToList()
                                .Count()
                                : s.OverIntervalMinWifiCount,
                        ReturningRate = (s.ReturningCustomer + s.NewCustomer) > 0 ? (double)s.ReturningCustomer / (s.ReturningCustomer + s.NewCustomer) * 100 : 0,
                        NewCustomerRate = (s.ReturningCustomer + s.NewCustomer) > 0 ? (double)s.NewCustomer / (s.ReturningCustomer + s.NewCustomer) * 100 : 0,
                        VisitDuration = s.AverageDwellTime,
                        AreaId = s.AreaId,
                        AreaName = s.Area.Name,
                        ParentAreaId = s.Area.ParentAreaId,
                        ParentAreaName = s.Area.ParentAreaId.IsNull() ? "" : allAreas.Where(w => w.Id == s.Area.ParentAreaId).FirstOrDefault().Name,
                        VisitorTarget = s.TargetVisitorCount,
                        MinDwellThreshold = s.MinDwellThreshold,
                        MaxDwellThreshold = s.MaxDwellThreshold
                    };
                }).ToList();



                var processedAreaDailyRawData = areaDailyRawData.Select(s => new AreaDailyViewModel
                {
                    ValueDateTime = s.ValueDateTime,
                    ValueIn = s.ValueIn,
                    ValueOut = s.ValueOut,
                    LessIntervalWifiCount = s.LessIntervalWifiCount,
                    BetweenIntervalWifiCount = s.BetweenIntervalWifiCount,
                    OverIntervalWifiCount = s.OverIntervalWifiCount,
                    LessIntervalWifiPercentage = (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) > 0 ? Math.Round((double)s.LessIntervalWifiCount / (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) * 100, 2) : 0,
                    BetweenIntervalWifiPercentage = (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) > 0 ? Math.Round((double)s.BetweenIntervalWifiCount / (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) * 100, 2) : 0,
                    OverIntervalMinWifiPercentage = (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) > 0 ?
                        100.0 - Math.Round((double)s.LessIntervalWifiCount / (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) * 100, 2) - Math.Round((double)s.BetweenIntervalWifiCount / (s.LessIntervalWifiCount + s.BetweenIntervalWifiCount + s.OverIntervalWifiCount) * 100, 2) : 0,
                    ReturningRate = s.ReturningRate,
                    NewCustomerRate = s.NewCustomerRate,
                    VisitDuration = s.VisitDuration,
                    AreaId = s.AreaId,
                    AreaName = s.AreaName,
                    ParentAreaId = s.ParentAreaId,
                    ParentAreaName = s.ParentAreaName,
                    VisitorTarget = s.VisitorTarget,
                    MinDwellThreshold = s.MinDwellThreshold,
                    MaxDwellThreshold = s.MaxDwellThreshold
                }).ToList();

                var thisMonthAreaRawData = processedAreaDailyRawData.Where(w => w.ValueDateTime >= selectedStartDate && w.ValueDateTime <= selectedEndDate).ToList();
                var lastMonthAreaRawData = processedAreaDailyRawData.Where(w => w.ValueDateTime >= lastMonthStartDate && w.ValueDateTime <= lastMonthEndDate).ToList();

                //var testing = processedAreaDailyRawData.Where(w => w.ParentAreaId == 89).ToList(); // && (w.LessIntervalWifiCount > 0 || w.BetweenIntervalWifiCount > 0 || w.OverIntervalWifiCount > 0)

                var weeklyBranchSummary52Weeks = ffBranchSummaryDailyReportService.CalculateWeeklyTrendPast52Weeks(currentSiteDailyData.ToList(), selectedStartDate, firstDayOfWeek, financialYear52Weeks);

                /////////////////////////////////////////////////////////////////////////
                var marketingTrackerReportVM = new MarketingTrackerReportViewModel();

                var allReport = marketingTrackerReportService.GetMany(w => w.companyID == companyId && w.IsDeleted != true && w.startDate >= selectedStartDate && w.endDate <= selectedEndDate && w.SiteList.FirstOrDefault().areaID == null).ToList();

                allReport.ForEach(x => x.SiteList = x.SiteList.Where(s => s.branchID == branchId && s.isDeleted != true).ToList());
                allReport = allReport.Where(w => w.SiteList != null).ToList();
                int markerColorCode = 1;

                List<MarketingTrackerDataViewModel> reportData = new List<MarketingTrackerDataViewModel>();
                foreach (var MTR in allReport)
                {
                    var dayCount = (MTR.endDate - MTR.startDate).TotalDays;
                    DateTime startDateToCompare = MTR.startDate.AddDays(0 - dayCount);
                    DateTime endDateToCompare = MTR.endDate.AddDays(dayCount);
                    var dailyRawDataToCompare = reportSiteDailyRawData.Where(w => w.ValueDateTime >= startDateToCompare && w.ValueDateTime <= endDateToCompare).ToList();

                    if (DateTime.Compare(financialStartEnd52Weeks.FinancialEndDate, endDateToCompare) <= 0)
                    {
                        reportData.Add(new MarketingTrackerDataViewModel
                        {
                            ID = MTR.ID,
                            Name = MTR.Name,
                            companyID = MTR.companyID,
                            creationDate = MTR.creationDate,
                            startDate = MTR.startDate,
                            endDate = MTR.endDate,
                            //weekNumberString = financialStartEnd52Weeks.FinancialStartDate <= MTR.startDate && financialStartEnd52Weeks.FinancialEndDate > MTR.startDate ? weeklyBranchSummary52Weeks.Where(w => w.Date == Utility.GetFirstDayOfWeekDate(MTR.startDate, firstDayOfWeek)).FirstOrDefault().Week.ToString() : "0",
                            isOngoing = DateTime.Compare(financialStartEnd52Weeks.FinancialEndDate, MTR.endDate) > 0 ? false : true,
                            weekStartDate = Utility.GetFirstDayOfWeekDate(MTR.startDate, firstDayOfWeek),
                            valueIn = DateTime.Compare(financialStartEnd52Weeks.FinancialEndDate, MTR.endDate) > 0 ? reportSiteDailyRawData.Where(w => w.ValueDateTime >= MTR.startDate && w.ValueDateTime <= MTR.endDate).Sum(s => s.ValueIn) : 0,
                            salesAmount = DateTime.Compare(financialStartEnd52Weeks.FinancialEndDate, MTR.endDate) > 0 ? reportSiteDailyRawData.Where(w => w.ValueDateTime >= MTR.startDate && w.ValueDateTime <= MTR.endDate).Sum(s => s.SalesAmount) : 0,
                            salesBy = 0,
                            salesConversion = DateTime.Compare(financialStartEnd52Weeks.FinancialEndDate, MTR.endDate) > 0 ? reportSiteDailyRawData.Where(w => w.ValueDateTime >= MTR.startDate && w.ValueDateTime <= MTR.endDate).Average(s => s.SalesConversion) : 0,
                            salesConversionBy = 0,
                            markerColorCode = markerColorCode,
                        });

                        if (markerColorCode == 19)
                        {
                            markerColorCode = 1;
                        }
                        else
                        {
                            markerColorCode += 1;
                        }
                    }
                    else
                    {
                        var duringCampaignRawData = reportSiteDailyRawData.Where(w => w.ValueDateTime >= MTR.startDate && w.ValueDateTime <= MTR.endDate).ToList();
                        var beforeCampaignRawData = dailyRawDataToCompare.Where(w => w.ValueDateTime >= startDateToCompare && w.ValueDateTime < MTR.startDate).ToList();
                        var afterCampaignRawData = dailyRawDataToCompare.Where(w => w.ValueDateTime > MTR.endDate && w.ValueDateTime <= endDateToCompare).ToList();

                        reportData.Add(new MarketingTrackerDataViewModel
                        {
                            ID = MTR.ID,
                            Name = MTR.Name,
                            companyID = MTR.companyID,
                            creationDate = MTR.creationDate,
                            startDate = MTR.startDate,
                            endDate = MTR.endDate,
                            //weekNumberString = financialStartEnd52Weeks.FinancialStartDate <= MTR.startDate && financialStartEnd52Weeks.FinancialEndDate > MTR.startDate ? weeklyBranchSummary52Weeks.Where(w => w.Date == Utility.GetFirstDayOfWeekDate(MTR.startDate, firstDayOfWeek)).FirstOrDefault().Week.ToString() : "0",
                            isOngoing = false,
                            weekStartDate = Utility.GetFirstDayOfWeekDate(MTR.startDate, firstDayOfWeek),
                            valueIn = duringCampaignRawData.Sum(s => s.ValueIn),
                            salesAmount = duringCampaignRawData.Sum(s => s.SalesAmount),
                            salesBy = beforeCampaignRawData.Sum(s => s.SalesAmount) != 0 && afterCampaignRawData.Sum(s => s.SalesAmount) != 0 ?
                            (afterCampaignRawData.Sum(s => s.SalesAmount) - beforeCampaignRawData.Sum(s => s.SalesAmount)) / beforeCampaignRawData.Sum(s => s.SalesAmount) : 0,
                            salesConversion = duringCampaignRawData.Average(s => s.SalesConversion),
                            salesConversionBy = beforeCampaignRawData.Sum(s => s.SalesConversion) != 0 && afterCampaignRawData.Sum(s => s.SalesConversion) != 0 ?
                            (afterCampaignRawData.Average(s => s.SalesConversion) - beforeCampaignRawData.Average(s => s.SalesConversion)) / beforeCampaignRawData.Average(s => s.SalesConversion) : 0,
                            markerColorCode = markerColorCode,
                        });

                        if (markerColorCode == 19)
                        {
                            markerColorCode = 1;
                        }
                        else
                        {
                            markerColorCode += 1;
                        }
                    }
                }

                // Combine weekly data with campaign data using left outer join method, then aggregate into required format
                var weeklyBranchSummary52WeeksWithCampaign = weeklyBranchSummary52Weeks.GroupJoin(
                    reportData,
                    weeklySummary => weeklySummary.Date,
                    tempReportData => tempReportData.weekStartDate,
                    (x, y) => new { weeklyBranchSummary52Weeks = x, reportData = y })
                    .SelectMany(
                    x => x.reportData.DefaultIfEmpty(),
                    (x, y) => new { weeklyBranchSummary52Weeks = x, reportData = y })
                    .Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueIn = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.ValueIn,
                        SalesConversion = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.SalesConversion,
                        VisitDuration = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.AverageVisitDuration,
                        WeekCount = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.Week,
                        Week = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.Week.ToString(),
                        WeekString = dateFormat == 1 ? s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.Date.ToString("dd/MM/yyyy") : s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.Date.ToString("MM/dd/yyyy"),
                        LessThan15mins = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.LessThan15mins,
                        Between15Till30mins = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.Between15Till30mins,
                        LargerThan30mins = s.weeklyBranchSummary52Weeks.weeklyBranchSummary52Weeks.LargerThan30mins,
                        CampaignName = s.reportData == null ? "" : s.reportData.Name,
                        CampaignDuration = s.reportData == null ? "" : dateFormat == 1 ? s.reportData.startDate.ToString("dd/MM/yyyy") + " - " + s.reportData.endDate.ToString("dd/MM/yyyy") : s.reportData.startDate.ToString("MM/dd/yyyy") + " - " + s.reportData.endDate.ToString("MM/dd/yyyy"),
                        CampaignValueIn = s.reportData == null ? 0 : s.reportData.valueIn,
                        CampaignSalesAmount = s.reportData == null ? 0 : Math.Round(s.reportData.salesAmount, 2),
                        CampaignSalesAmountDiff = s.reportData == null ? 0 : Math.Round(s.reportData.salesBy * 100, 2),
                        CampaignSalesConversion = s.reportData == null ? 0 : Math.Round(s.reportData.salesConversion, 2),
                        CampaignSalesConversionDiff = s.reportData == null ? 0 : Math.Round(s.reportData.salesConversionBy * 100, 2),
                        markerColorCode = s.reportData == null ? 0 : s.reportData.markerColorCode,
                    }).ToList();

                /////////////////////////////////////////////////////////////////////////
                #endregion

                #region ===== REPORT (Error Checking, Data Aggregation, Text Binding, Graph Plotting)
                areaCategory_panel.Visible = true;
                areaSummary_panel.Visible = true;
                areaCategoryAnalysis_panel.Visible = true;
                siteTrendAnalysis_panel.Visible = true;
                siteTrendAnalysis_table.Visible = false;
                if (!(currentSiteDailyData.Count > 0 && currentSiteDailyData != null))
                {
                    report_title.Visible = false;
                    report_date.Visible = false;
                    dashboard_panel.Visible = false;

                    errorBox.Value = "ERR102";
                    errorBox.Visible = true;
                    errorMessage.Visible = true;

                    errorMessage.Value = CompanyMonthlyReportViewer.CompanyMonthlyReportViewer_ReportIsNotAvailable;
                }
                else
                {
                    report_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ExperienceCentre
                        .ToUpper() + " - " + companyNameHtml.ToUpper() + " " + branchName.ToUpper();
                    //report_date.Value = "_Monthly Report 01 / 05 / 2019 - 31 / 05 / 2019";
                    report_date.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReportPeriod + ": " + selectedStartDate.ToString(dateFormatString) + " - " + selectedEndDate.ToString(dateFormatString);
                    compared_date.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ComparedPeriod + ": " + lastMonthStartDate.ToString(dateFormatString) + " - " + lastMonthEndDate.ToString(dateFormatString);

                    dashboard_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_OverallSiteSummary.ToUpper();
                    areaCategory_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory.ToUpper();
                    areaSummary_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_AreaSummary.ToUpper();
                    areaCategoryAnalysis_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategoryAnalysis.ToUpper();
                    siteTrendAnalysis_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_SiteTrendAnalysis.ToUpper();

                    dashboard_VC_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    dashboard_TIR_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_TurnInRate;
                    dashboard_RC_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer;
                    dashboard_NC_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NewCustomer;
                    dashboard_VD_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration;
                    dashboard_SC_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_SalesConversion;
                    dashboard_SV_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_SalesVolume;
                    dashboard_NoT_table_title.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NumberOfTransaction;

                    areaCategory_table_header1.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory + "	";
                    areaCategory_table_header2.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate + " (%)";
                    areaCategory_table_header3.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    areaCategory_table_header4.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer + " (%)";
                    areaCategory_table_header5.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration;

                    areaSummary_table1_header2.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate + " (%)";
                    areaSummary_table1_header3.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    areaSummary_table1_header4.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer + " (%)";
                    areaSummary_table1_header5.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration + " (%)";
                    areaSummary_table1_subheader1.Value = "< 15 " + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins;
                    areaSummary_table1_subheader2.Value = "15 - 30 " + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins;
                    areaSummary_table1_subheader3.Value = "> 30 " + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins;

                    areaCategoryAnalysis_VR_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate;
                    areaCategoryAnalysis_RC_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer;
                    areaCategoryAnalysis_NC_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NewCustomer;
                    areaCategoryAnalysis_VC_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    areaCategoryAnalysis_VD_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration;

                    siteTrendAnalysis_VC_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    siteTrendAnalysis_VD_subtitle.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration;

                    siteTrendAnalysis_table_header1.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_CampaignName + "	";
                    siteTrendAnalysis_table_header2.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_CampaignDuration;
                    siteTrendAnalysis_table_header3.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
                    siteTrendAnalysis_table_header4.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_Sales;
                    siteTrendAnalysis_table_header5.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_SalesConversion + " (%)";

                    //DATA FOR DASHBOARD
                    var dashboardData = CalculateDailyDashboardData_Private(currentSiteDailyData, lastMonthSiteDailyRawData);

                    dashboard_VC_table.DataSource = dashboardData;
                    dashboard_TIR_table.DataSource = dashboardData;
                    dashboard_RC_table.DataSource = dashboardData;
                    dashboard_NC_table.DataSource = dashboardData;
                    dashboard_VD_table.DataSource = dashboardData;
                    dashboard_SC_table.DataSource = dashboardData;
                    dashboard_SV_table.DataSource = dashboardData;
                    dashboard_NoT_table.DataSource = dashboardData;

                    //DATA FOR DASHBOARD GRAPHS
                    List<BranchSummaryDailyReportViewModel> dashboardGraphData = currentSiteDailyData.Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueDateTime = s.ValueDateTime,
                        ValueIn = s.ValueIn,
                        TurnInRate = s.TurnInRate,
                        ReturningRate = (s.WeeklyCustomer + s.NewCustomer) > 0 ? Math.Round(((double)s.WeeklyCustomer / (s.WeeklyCustomer + s.NewCustomer) * 100), 2) : 0,
                        NewCustomerRate = (s.WeeklyCustomer + s.NewCustomer) > 0 ? Math.Round(((double)s.NewCustomer / (s.WeeklyCustomer + s.NewCustomer) * 100), 2) : 0,
                        VisitDuration = s.AverageVisitDuration,
                        SalesConversion = s.SalesConversion,
                        SalesAmount = s.SalesAmount,
                        TransactionCount = s.TransactionCount
                    }).OrderBy(o => o.ValueDateTime).ToList();

                    //DATA FOR AREA SUMMARY
                    List<AreaDailyViewModel> areaSummaryDetailsData = CalculateAreaSummaryData_Private(thisMonthAreaRawData, lastMonthAreaRawData, dashboardData.ValueIn, dashboardData.LastValuein).ToList();
                    List<AreaDailyViewModel> areaCategoryDetailsData = CalculateAreaCategoryData_Private(thisMonthAreaRawData, lastMonthAreaRawData, dashboardData.ValueIn, dashboardData.LastValuein, parentAreaQueueCountingsIds).ToList();

                    var areaCategoryDwellThresholdList = thisMonthAreaRawData.GroupBy(g => g.ParentAreaId).Select(s =>
                    {
                        bool isMinDwellThreshold = thisMonthAreaRawData.Sum(ss => ss.MinDwellThreshold) > 0;
                        bool isMaxDwellThreshold = thisMonthAreaRawData.Sum(ss => ss.MaxDwellThreshold) > 0;

                        return new
                        {
                            ParentAreaId = s.Key,
                            MinDwellThreshold = (isMinDwellThreshold ? s.Where(w => w.ValueDateTime == thisMonthAreaRawData.Where(ww => ww.ParentAreaId == s.Key && ww.MinDwellThreshold > 0).Max(mm => mm.ValueDateTime)).FirstOrDefault().MinDwellThreshold : 0),
                            MaxDwellThreshold = (isMaxDwellThreshold ? s.Where(w => w.ValueDateTime == thisMonthAreaRawData.Where(ww => ww.ParentAreaId == s.Key && ww.MaxDwellThreshold > 0).Max(mm => mm.ValueDateTime)).FirstOrDefault().MaxDwellThreshold : 0)
                        };
                    }).ToList();

                    //DATA BINDING
                    if (areaCategoryDetailsData.Count() != 0)
                    {
                        areaCategory_table.DataSource = areaCategoryDetailsData;
                        areaCategory_panel.Visible = true;
                    }
                    else
                    {
                        areaCategory_panel.Visible = false;
                    }

                    //AREA SUMMARY TABLES (AreaId 89 : POS - Queue Counters Area)
                    if (areaSummaryDetailsData.Count() > 0)
                    {
                        double yLocation = 0.22D;
                        int appendCount = 2;
                        foreach (int areaId in parentAreaIds)
                        {
                            List<AreaDailyViewModel> data = areaSummaryDetailsData.Where(s => s.ParentAreaId == areaId).OrderBy(o => o.AreaName).ToList();
                            int firstInterval = areaCategoryDwellThresholdList.Where(s => s.ParentAreaId == areaId).FirstOrDefault().MinDwellThreshold;
                            int secondInterval = areaCategoryDwellThresholdList.Where(s => s.ParentAreaId == areaId).FirstOrDefault().MaxDwellThreshold;
                            areaSummary_panel.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
                                //!parentAreaQueueCountingsIds.Contains(areaId) ? AreaSummaryTable(data, appendCount, yLocation, firstInterval, secondInterval, false) : AreaSummaryTable(data, appendCount, yLocation, firstInterval, secondInterval, true)
                                AreaSummaryTable(data, appendCount, yLocation, firstInterval, secondInterval, parentAreaQueueCountingsIds.Contains(areaId))
                            });
                            yLocation += (0.74D + (0.02D * data.Count()));
                            appendCount++;
                        }
                        areaSummary_panel.Visible = true;
                        areaSummary_table1.Visible = false;
                    }
                    else
                    {
                        areaSummary_panel.Visible = false;
                    }

                    //DATA FOR SITE TREND ANALYSIS
                    // Site Trend Analysis
                    long weeklyMaxValue52Weeks = weeklyBranchSummary52WeeksWithCampaign.Max(s => s.ValueIn);
                    long weeklyMinValue52Weeks = weeklyBranchSummary52WeeksWithCampaign.Min(s => s.ValueIn);
                    long denominatorWeekly52Weeks = TelerikUtility.CheckValueDenominator(weeklyMaxValue52Weeks, weeklyMinValue52Weeks);
                    string weeklyValueFormat52Weeks = TelerikUtility.DenominatedStringFormat(denominatorWeekly52Weeks);
                    var graphWeeklyDataSource52Weeks = weeklyBranchSummary52WeeksWithCampaign.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekly52Weeks,
                            SalesConversion = s.SalesConversion,
                            Week = s.Week.ToString(),
                            WeekCount = s.WeekCount,
                            WeekString = s.WeekString,
                            CampaignName = s.CampaignName.Equals("") ? "" : "- " + s.CampaignName,
                            hasCampaign = s.CampaignName.Equals("") ? 0 : 1,
                            markerColorCode = s.markerColorCode,
                        }).ToList();

                    var graphWeeklyVisitDurationDataSource52Weeks = weeklyBranchSummary52WeeksWithCampaign.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            LessThan15mins = s.LessThan15mins,
                            Between15Till30mins = s.Between15Till30mins,
                            LargerThan30mins = s.LargerThan30mins,
                            VisitDuration = s.VisitDuration,
                            Week = s.Week.ToString(),
                            WeekCount = s.WeekCount,
                            WeekString = s.WeekString,
                            CampaignName = s.CampaignName.Equals("") ? "" : "- " + s.CampaignName,
                            hasCampaign = s.CampaignName.Equals("") ? 0 : 1,
                            markerColorCode = s.markerColorCode,
                        }).ToList();

                    //for (int i = 1; i < 53; i++)
                    //{
                    //    var find = graphWeeklyDataSource52Weeks.Find(f => f.WeekCount == i);
                    //    if (find == null)
                    //    {
                    //        graphWeeklyDataSource52Weeks.Add(new BranchSummaryDailyReportViewModel
                    //        {
                    //            ValueInDouble = 0,
                    //            SalesConversion = 0,
                    //            Week = i.ToString(),
                    //            WeekString = financialYear52Weeks.ThisYear.FinancialStartDate.AddDays((i - 1) * 7).ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy") + " - " + financialYear52Weeks.ThisYear.FinancialStartDate.AddDays(6 + (i - 1) * 7).ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy"),
                    //            WeekCount = i,
                    //            CampaignName = "",
                    //            hasCampaign = 0,
                    //            markerColorCode = 0,
                    //        });

                    //        graphWeeklyVisitDurationDataSource52Weeks.Add(new BranchSummaryDailyReportViewModel
                    //        {
                    //            LessThan15mins = 0,
                    //            Between15Till30mins = 0,
                    //            LargerThan30mins = 0,
                    //            VisitDuration = 0,
                    //            Week = i.ToString(),
                    //            WeekCount = i,
                    //            WeekString = financialYear52Weeks.ThisYear.FinancialStartDate.AddDays((i - 1) * 7).ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy") + " - " + financialYear52Weeks.ThisYear.FinancialStartDate.AddDays(6 + (i - 1) * 7).ToString(dateFormat == 1 ? "dd/MM/yyyy" : "MM/dd/yyyy"),
                    //            CampaignName = "",
                    //            hasCampaign = 0,
                    //            markerColorCode = 0,
                    //        });
                    //    }
                    //}

                    graphWeeklyDataSource52Weeks = graphWeeklyDataSource52Weeks.OrderBy(o => o.WeekCount).ToList();
                    graphWeeklyVisitDurationDataSource52Weeks = graphWeeklyVisitDurationDataSource52Weeks.OrderBy(o => o.WeekCount).ToList();

                    var siteTrendAnalysisTableDataSource = reportData.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            CampaignName = s.Name,
                            CampaignDuration = dateFormat == 1 ? s.startDate.ToString("dd/MM/yyyy") + " - " + s.endDate.ToString("dd/MM/yyyy") : s.startDate.ToString("MM/dd/yyyy") + " - " + s.endDate.ToString("MM/dd/yyyy"),
                            CampaignValueIn = s.valueIn,
                            CampaignSalesAmount = Math.Round(s.salesAmount, 2),
                            CampaignSalesAmountDiff = Math.Round(s.salesBy * 100, 2),
                            CampaignSalesConversion = Math.Round(s.salesConversion, 2),
                            CampaignSalesConversionDiff = Math.Round(s.salesConversionBy * 100, 2),
                            markerColorCode = s.markerColorCode,
                        });

                    //DASHBOARD GRAPHS
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_VC_table_graph.ToString(), dashboard_VC_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.ValueIn");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_TIR_table_graph.ToString(), dashboard_TIR_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.TurnInRate");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_RC_table_graph.ToString(), dashboard_RC_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.ReturningRate");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_NC_table_graph.ToString(), dashboard_NC_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.NewCustomerRate");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_VD_table_graph.ToString(), dashboard_VD_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.VisitDuration");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_SC_table_graph.ToString(), dashboard_SC_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.SalesConversion");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_SV_table_graph.ToString(), dashboard_SV_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.SalesAmount");
                    TelerikUtility.PlotAreaGraph_NoAxes(dashboard_NoT_table_graph.ToString(), dashboard_NoT_table_graph, dashboardGraphData, "=Fields.ValueDateTime", "=Fields.TransactionCount");

                    //AREA CATEGORY ANALYSIS GRAPHS
                    if (areaCategoryDetailsData.Sum(s => s.VisitorRate) == 0)
                    {
                        areaCategoryAnalysis_VR_graph.Visible = false;
                        areaCategoryAnalysis_VR_error.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NoVisitorRateData;
                        areaCategoryAnalysis_VR_error.Visible = true;
                    }
                    else
                    {
                        PlotVisitorRateStackedBarGraph(areaCategoryAnalysis_VR_graph.ToString(), areaCategoryAnalysis_VR_graph, areaCategoryDetailsData, "=Fields.ParentAreaName", Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory,
                            "=Fields.ReturningRate", "=Fields.NewCustomerRate", "=Fields.VisitorRate", Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate + " (%)", Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer, Helper.ExperienceCentreReport.ExperienceCentreReport_NewCustomer, Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate, font, "{0:## ##0.##}");
                    }

                    if (areaCategoryDetailsData.Sum(s => s.ReturningRate) == 0)
                    {
                        areaCategoryAnalysis_RC_graph.Visible = false;
                        areaCategoryAnalysis_RC_error.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NoReturningCustomerData;
                        areaCategoryAnalysis_RC_error.Visible = true;
                    }
                    else
                    {
                        TelerikUtility.PlotBarLineGraph_1YAxisLabel_CustomizableTooltip(areaCategoryAnalysis_RC_graph.ToString(), areaCategoryAnalysis_RC_graph, areaCategoryDetailsData, "=Fields.ParentAreaName", Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory, Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer + " (%)",
                        "=Fields.ReturningRate", Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer, "=Fields.AverageReturningRate", Helper.ExperienceCentreReport.ExperienceCentreReport_AvgReturningCustomer, font, "{0:## ##0.##}", xAxisLabelAngle: 0, graphItemPosition: GraphItemPosition.TopCenter, tooltipUnit: "%");
                    }

                    if (areaCategoryDetailsData.Sum(s => s.NewCustomerRate) == 0)
                    {
                        areaCategoryAnalysis_NC_graph.Visible = false;
                        areaCategoryAnalysis_NC_error.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NoNewCustomerData;
                        areaCategoryAnalysis_NC_error.Visible = true;
                    }
                    else
                    {
                        TelerikUtility.PlotBarLineGraph_1YAxisLabel_CustomizableTooltip(areaCategoryAnalysis_NC_graph.ToString(), areaCategoryAnalysis_NC_graph, areaCategoryDetailsData, "=Fields.ParentAreaName", Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory, Helper.ExperienceCentreReport.ExperienceCentreReport_NewCustomer + " (%)",
                        "=Fields.NewCustomerRate", Helper.ExperienceCentreReport.ExperienceCentreReport_NewCustomer, "=Fields.AverageNewCustomerRate", Helper.ExperienceCentreReport.ExperienceCentreReport_AvgNewCustomer, font, "{0:## ##0.##}", xAxisLabelAngle: 0, graphItemPosition: GraphItemPosition.TopCenter, tooltipUnit: "%");
                    }

                    if (areaCategoryDetailsData.Sum(s => s.ValueIn) == 0)
                    {
                        areaCategoryAnalysis_VC_graph.Visible = false;
                        areaCategoryAnalysis_VC_error.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NoVisitorCountData;
                        areaCategoryAnalysis_VC_error.Visible = true;
                    }
                    else
                    {
                        TelerikUtility.PlotBarLineGraph_1YAxisLabel_CustomizableTooltip(areaCategoryAnalysis_VC_graph.ToString(), areaCategoryAnalysis_VC_graph, areaCategoryDetailsData, "=Fields.ParentAreaName", Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory, Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount,
                            "=Fields.ValueIn", Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount, "=Fields.AverageValueIn", Helper.ExperienceCentreReport.ExperienceCentreReport_AvgVisitorCount, font, "{0:## ##0.##}", xAxisLabelAngle: 0, graphItemPosition: GraphItemPosition.TopCenter);
                    }

                    if (areaCategoryDetailsData.Sum(s => s.VisitDuration) == 0)
                    {
                        areaCategoryAnalysis_VD_graph.Visible = false;
                        areaCategoryAnalysis_VD_error.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_NoVisitDurationData;
                        areaCategoryAnalysis_VD_error.Visible = true;
                    }
                    else
                    {
                        TelerikUtility.PlotBarLineGraph_1YAxisLabel_CustomizableTooltip(areaCategoryAnalysis_VD_graph.ToString(), areaCategoryAnalysis_VD_graph, areaCategoryDetailsData, "=Fields.ParentAreaName", Helper.ExperienceCentreReport.ExperienceCentreReport_AreaCategory, Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration + " (" + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins + ")",
                            "=Fields.VisitDuration", Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration, "=Fields.AverageVisitDuration", Helper.ExperienceCentreReport.ExperienceCentreReport_AvgVisitDuration, font, "{0:## ##0.##}", xAxisLabelAngle: 0, graphItemPosition: GraphItemPosition.TopCenter, tooltipUnit: " " + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins);
                    }

                    // Site Trend Analysis
                    PlotLineLineGraph_Private(siteTrendAnalysis_VC_graph.ToString(), siteTrendAnalysis_VC_graph,
                        graphWeeklyDataSource52Weeks, "=Format('" + Helper.ExperienceCentreReport.ExperienceCentreReport_Week + " {0} \n({1})', Fields.Week, Fields.WeekString)", Helper.ExperienceCentreReport.ExperienceCentreReport_Week,
                        "=Fields.ValueInDouble", Helper.ExperienceCentreReport.ExperienceCentreReport_NoofVisitor,
                        "=Fields.SalesConversion", Helper.ExperienceCentreReport.ExperienceCentreReport_SalesConversion + " (%)",
                        font, weeklyValueFormat52Weeks);
                    TelerikUtility.PlotBarGraph_Default(graph1.ToString(), graph1,
                        graphWeeklyVisitDurationDataSource52Weeks, "=Format('" + Helper.ExperienceCentreReport.ExperienceCentreReport_Week + " {0} \n({1})', Fields.Week, Fields.WeekString)", Helper.ExperienceCentreReport.ExperienceCentreReport_Week,
                        "=Fields.VisitDuration", Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration + " (" + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins + ")", font, "{0:## ##0.##}");

                    siteTrendAnalysis_table.DataSource = siteTrendAnalysisTableDataSource;
                }

                #endregion
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        //TEMPORARY FUNCTION (TO BE PLACED INTO COMPOSITE FUNCTION)
        private BranchSummaryDailyReportViewModel CalculateDailyDashboardData_Private(List<BranchSummaryDailyReportViewModel> thisMonthRawData, List<BranchSummaryDailyReportViewModel> lastMonthRawData)
        {
            //Check if there is month data or not
            bool hasThisMonthData = thisMonthRawData.Count > 0;
            bool hasLastMonthData = lastMonthRawData.Count > 0;

            //This Month Data Total / Average Process
            int thisMonth_VC = hasThisMonthData ? thisMonthRawData.Sum(s => s.ValueIn) : 0;
            double thisMonth_TIR = Math.Round(thisMonthRawData.Average(a => a.TurnInRate), 2);
            double thisMonth_RC_percentage = thisMonthRawData.Sum(s => s.MonthlyCustomer + s.NewCustomer) > 0 ? Math.Round((double)thisMonthRawData.Sum(s => s.MonthlyCustomer) / thisMonthRawData.Sum(s => s.MonthlyCustomer + s.NewCustomer) * 100, 2) : 0;
            int thisMonth_RC_Count = (int)Math.Round(thisMonth_VC * (thisMonth_RC_percentage / 100), 0);
            double thisMonth_NC_percentage = 100.0 - thisMonth_RC_percentage;
            int thisMonth_NC_Count = thisMonth_VC - thisMonth_RC_Count;
            int thisMonth_NoT = thisMonthRawData.Sum(s => s.TransactionCount);
            double thisMonth_VD = Math.Round(thisMonthRawData.Average(a => a.AverageVisitDuration), 2);
            double thisMonth_SC = Math.Round((double)thisMonth_NoT / thisMonth_VC * 100, 2);
            double thisMonth_SV = Math.Round(thisMonthRawData.Sum(s => s.SalesAmount), 2);
            //AVERAGE
            //double thisMonth_SV_avg = thisMonthRawData.Average(s => s.SalesAmount);
            //double thisMonth_NoT_avg = thisMonthRawData.Average(s => s.TransactionCount);


            //Last Month Data Total / Average Process
            int lastMonth_VC = hasLastMonthData ? lastMonthRawData.Sum(s => s.ValueIn) : 0;
            double lastMonth_TIR = hasLastMonthData && lastMonthRawData.Sum(s => s.TurnInRate) > 0 ? Math.Round(lastMonthRawData.Average(s => s.TurnInRate), 2) : 0;
            double lastMonth_RC_percentage = hasLastMonthData && lastMonthRawData.Sum(s => s.MonthlyCustomer + s.NewCustomer) > 0 ? Math.Round((double)lastMonthRawData.Sum(s => s.MonthlyCustomer) / lastMonthRawData.Sum(s => s.MonthlyCustomer + s.NewCustomer) * 100, 2) : 0;
            double lastMonth_NC_percentage = hasLastMonthData ? 100.0 - lastMonth_RC_percentage : 0;
            int lastMonth_NoT = hasLastMonthData ? lastMonthRawData.Sum(s => s.TransactionCount) : 0;
            double lastMonth_VD = hasLastMonthData ? Math.Round(lastMonthRawData.Average(a => a.AverageVisitDuration), 2) : 0;
            double lastMonth_SC = hasLastMonthData ? Math.Round((double)lastMonth_NoT / lastMonth_VC * 100, 2) : 0;
            double lastMonth_SV = hasLastMonthData ? Math.Round(lastMonthRawData.Sum(s => s.SalesAmount), 2) : 0;
            //AVERAGE
            //double lastMonth_SV_avg = hasLastMonthData ? lastMonthRawData.Where(w => w.TransactionCount > 0).Count() > 0 ? lastMonthRawData.Where(w => w.TransactionCount > 0).Average(s => s.SalesAmount) : 0 : 0;
            //double lastMonth_NoT_avg = hasLastMonthData ? lastMonthRawData.Where(w => w.TransactionCount > 0).Count() > 0 ? lastMonthRawData.Where(w => w.TransactionCount > 0).Average(s => s.TransactionCount) : 0 : 0;

            BranchSummaryDailyReportViewModel result = new BranchSummaryDailyReportViewModel
            {
                ValueIn = thisMonth_VC,
                ValueInDiff = lastMonth_VC > 0 ? Math.Round((double)(thisMonth_VC - lastMonth_VC) / lastMonth_VC * 100, 2) : 0,
                TurnInRate = thisMonth_TIR,
                TurnInRateDiff = lastMonth_TIR > 0 ? Math.Round((thisMonth_TIR - lastMonth_TIR) / lastMonth_TIR * 100, 2) : 0,
                ReturningRate = thisMonth_RC_percentage,
                WeeklyCustomer = thisMonth_RC_Count,
                ReturningRateDiff = lastMonth_RC_percentage > 0 ? Math.Round((thisMonth_RC_percentage - lastMonth_RC_percentage) / lastMonth_RC_percentage * 100, 2) : 0,
                NewCustomerRate = thisMonth_NC_percentage,
                NewCustomer = thisMonth_NC_Count,
                NewCustomerDiff = lastMonth_RC_percentage > 0 ? Math.Round((thisMonth_NC_percentage - lastMonth_NC_percentage) / lastMonth_NC_percentage * 100, 2) : 0,
                VisitDuration = thisMonth_VD,
                VisitDurationDiff = lastMonth_VD > 0 ? Math.Round((thisMonth_VD - lastMonth_VD) / lastMonth_VD * 100, 2) : 0,
                SalesConversion = thisMonth_SC,
                SalesConversionDiff = lastMonth_SC > 0 ? Math.Round((thisMonth_SC - lastMonth_SC) / lastMonth_SC * 100, 2) : 0,
                SalesAmount = thisMonth_SV,
                SalesAmountDiff = lastMonth_SV > 0 ? Math.Round((thisMonth_SV - lastMonth_SV) / lastMonth_SV * 100, 2) : 0,
                TransactionCount = thisMonth_NoT,
                TransactionCountDiff = lastMonth_NoT > 0 ? Math.Round((double)(thisMonth_NoT - lastMonth_NoT) / lastMonth_NoT * 100, 2) : 0,
                LastValuein = lastMonth_VC,
            };

            return result;
        }

        private List<AreaDailyViewModel> CalculateAreaSummaryData_Private(IEnumerable<AreaDailyViewModel> thisMonthRawData, IEnumerable<AreaDailyViewModel> lastMonthRawData, int siteValueIn, int siteLastMonthValueIn)
        {
            bool hasThisMonthRawData = thisMonthRawData.Count() > 0 && !thisMonthRawData.IsNull();
            bool hasLastMonthRawData = lastMonthRawData.Count() > 0 && !lastMonthRawData.IsNull();

            var lastMonthAreaSummaryDetails = hasLastMonthRawData ? lastMonthRawData.GroupBy(g => g.AreaId).Select(s => new AreaDailyViewModel
            {
                AreaId = s.Key,
                AreaName = s.FirstOrDefault().AreaName,
                ParentAreaId = s.FirstOrDefault().ParentAreaId,
                ParentAreaName = s.FirstOrDefault().ParentAreaName,
                ValueIn = hasLastMonthRawData ? s.Sum(su => su.ValueIn) : 0,
                //AverageValueIn = hasLastMonthRawData ? s.Average(a => a.ValueIn) : 0,
                ValueOut = hasLastMonthRawData ? s.Sum(su => su.ValueOut) : 0,
                VisitorRate = hasLastMonthRawData ?
                    (s.Sum(su => su.ValueIn) > 0 ?
                        Math.Round((double)s.Sum(su => su.ValueIn) / lastMonthRawData.Where(w => w.ParentAreaId == s.FirstOrDefault().ParentAreaId).Sum(su => su.ValueIn) * 100, 2) : 0)
                    : 0,
                ReturningRate = hasLastMonthRawData ?
                        (s.Sum(a => a.ReturningRate) > 0 ?
                        Math.Round(s.Average(a => a.ReturningRate), 2) : 0)
                    : 0,
                LessIntervalWifiCount = hasLastMonthRawData ? s.Sum(sum => sum.LessIntervalWifiCount) : 0,
                BetweenIntervalWifiCount = hasLastMonthRawData ? s.Sum(sum => sum.BetweenIntervalWifiCount) : 0,
                OverIntervalWifiCount = hasLastMonthRawData ? s.Sum(sum => sum.OverIntervalWifiCount) : 0,
                LessIntervalWifiPercentage = hasLastMonthRawData ? ((s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ?
                    Math.Round((double)s.Sum(sum => sum.LessIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2)
                    : 0) : 0,
                BetweenIntervalWifiPercentage = hasLastMonthRawData ? ((s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ?
                    Math.Round((double)s.Sum(sum => sum.BetweenIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2)
                    : 0) : 0,
                OverIntervalMinWifiPercentage = hasLastMonthRawData ? ((s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ?
                    100.0 - Math.Round((double)s.Sum(sum => sum.LessIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2) - Math.Round((double)s.Sum(sum => sum.BetweenIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2)
                    : 0) : 0,
                VisitDuration = hasLastMonthRawData ? s.Average(su => su.VisitDuration) : 0,
                VisitorTarget = s.Where(w => w.ValueDateTime == s.Max(m => m.ValueDateTime)).LastOrDefault().VisitorTarget
            }).ToList() : null;

            var result = thisMonthRawData.GroupBy(g => g.AreaId).Select(s => new AreaDailyViewModel
            {
                AreaId = s.Key,
                AreaName = s.FirstOrDefault().AreaName,
                ParentAreaId = s.FirstOrDefault().ParentAreaId,
                ParentAreaName = s.FirstOrDefault().ParentAreaName,
                ValueIn = hasThisMonthRawData ? s.Sum(su => su.ValueIn) : 0,
                AverageValueIn = hasThisMonthRawData ? s.Average(a => a.ValueIn) : 0,
                ValueInDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.AreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ValueIn > 0 ?
                    Math.Round(((double)s.Sum(su => su.ValueIn) - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ValueIn) / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ValueIn * 100, 2)
                    : 0) : 0,
                ValueOut = hasThisMonthRawData ? s.Sum(su => su.ValueOut) : 0,
                VisitorRate = hasThisMonthRawData ?
                    thisMonthRawData.Where(w => w.ParentAreaId == s.FirstOrDefault().ParentAreaId).Sum(su => su.ValueIn) > 0 ? (
                        Math.Round((double)s.Sum(su => su.ValueIn) / thisMonthRawData.Where(w => w.ParentAreaId == s.FirstOrDefault().ParentAreaId).Sum(su => su.ValueIn) * 100, 2)) : 0
                    : 0,
                VisitorRateDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.AreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().VisitorRate > 0 ?
                    s.Sum(su => su.ValueIn) > 0 ?
                        Math.Round((((double)s.Sum(su => su.ValueIn) / thisMonthRawData.Where(w => w.ParentAreaId == s.FirstOrDefault().ParentAreaId).Sum(su => su.ValueIn) * 100) - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().VisitorRate) / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().VisitorRate * 100, 2)
                        : Math.Round((0 - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().VisitorRate) / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().VisitorRate * 100, 2)
                    : 0) : 0,
                ReturningRate = hasThisMonthRawData ? (s.Sum(a => a.ReturningRate) > 0 ?
                        Math.Round(s.Average(a => a.ReturningRate), 2)
                    : 0) : 0,
                ReturningRateDiff = lastMonthAreaSummaryDetails.Any(w => w.AreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate > 0 ?
                    (s.Sum(a => a.ReturningRate) > 0 ?
                        (s.Sum(su => su.ValueIn) > 0 ?
                            Math.Round((s.Average(a => a.ReturningRate) - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate) / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate * 100, 2)
                            : Math.Round((0 - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate) / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate * 100, 2))
                        : Math.Round(0 - lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate / lastMonthAreaSummaryDetails.Where(w => w.AreaId == s.Key).FirstOrDefault().ReturningRate * 100, 2))
                    : 0,
                LessIntervalWifiPercentage = (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ? Math.Round((double)s.Sum(sum => sum.LessIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2) : 0,
                BetweenIntervalWifiPercentage = (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ? Math.Round((double)s.Sum(sum => sum.BetweenIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2) : 0,
                OverIntervalMinWifiPercentage = (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) > 0 ?
                        100.0 - Math.Round((double)s.Sum(sum => sum.LessIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2) - Math.Round((double)s.Sum(sum => sum.BetweenIntervalWifiCount) / (s.Sum(sum => sum.LessIntervalWifiCount) + s.Sum(sum => sum.BetweenIntervalWifiCount) + s.Sum(sum => sum.OverIntervalWifiCount)) * 100, 2) : 0,
                VisitDuration = hasThisMonthRawData ? s.Average(su => su.VisitDuration) : 0,
                VisitorTarget = s.Where(w => w.ValueDateTime == s.Max(m => m.ValueDateTime)).LastOrDefault().VisitorTarget
            }).ToList();

            return result;
        }

        private List<AreaDailyViewModel> CalculateAreaCategoryData_Private(IEnumerable<AreaDailyViewModel> thisMonthRawData, IEnumerable<AreaDailyViewModel> lastMonthRawData, int siteValueIn, int siteLastMonthValueIn, List<long> parentAreaQueueCountingsIds)
        {
            double averageReturningRate, averageNewCustomerRate, averageValueIn, averageVisitDuration;

            bool hasThisMonthRawData = thisMonthRawData.Count() > 0 && !thisMonthRawData.IsNull();
            bool hasLastMonthRawData = lastMonthRawData.Count() > 0 && !lastMonthRawData.IsNull();

            //LAST MONTH SUPER AREA
            var lastMonthAreaSummaryDetails = hasLastMonthRawData ? lastMonthRawData.GroupBy(g => g.ParentAreaId).Select(s => new AreaDailyViewModel
            {
                AreaId = s.FirstOrDefault().AreaId,
                AreaName = s.FirstOrDefault().AreaName,
                ParentAreaId = s.Key,
                ParentAreaName = s.FirstOrDefault().ParentAreaName,
                ValueIn = hasLastMonthRawData ? s.Sum(su => su.ValueIn) : 0,
                //AverageValueIn = hasLastMonthRawData ? s.Average(a => a.ValueIn) : 0,
                ValueOut = hasLastMonthRawData ? s.Sum(su => su.ValueOut) : 0,
                VisitorRate = hasLastMonthRawData ? (s.Sum(su => su.ValueIn) >= siteLastMonthValueIn ?
                    100.0
                    : Math.Round((double)s.Sum(su => su.ValueIn) / siteLastMonthValueIn * 100, 2)) : 0,
                ReturningRate = hasLastMonthRawData ? (s.Sum(a => a.ReturningRate) > 0 ?
                    Math.Round(s.Average(a => a.ReturningRate), 2) : 0) : 0,
                LessIntervalWifiPercentage = hasLastMonthRawData ? s.Average(a => a.LessIntervalWifiPercentage) : 0,
                BetweenIntervalWifiPercentage = hasLastMonthRawData ? s.Average(a => a.BetweenIntervalWifiPercentage) : 0,
                OverIntervalMinWifiPercentage = hasLastMonthRawData ? s.Average(a => a.OverIntervalMinWifiPercentage) : 0,
                VisitDuration = hasLastMonthRawData ? s.Average(su => su.VisitDuration) : 0,
                NewCustomerRate = hasLastMonthRawData ? (s.Sum(a => a.NewCustomerRate) > 0 ?
                    Math.Round(100.0 - s.Average(a => a.ReturningRate), 2) : 0) : 0
            }) : null;

            //THIS MONTH SUPER AREA
            var result = thisMonthRawData.GroupBy(g => g.ParentAreaId).Select(s => new AreaDailyViewModel
            {
                AreaId = s.FirstOrDefault().AreaId,
                AreaName = s.FirstOrDefault().AreaName,
                ParentAreaId = s.Key,
                ParentAreaName = s.FirstOrDefault().ParentAreaName,
                ValueIn = hasThisMonthRawData ? s.Sum(su => su.ValueIn) : 0,
                AverageValueIn = hasThisMonthRawData ? s.Average(a => a.ValueIn) : 0,
                ValueInDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.ParentAreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ValueIn > 0 ?
                    Math.Round(((double)s.Sum(a => a.ValueIn) - lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ValueIn) / lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ValueIn * 100, 2)
                    : 0) : 0,
                ValueOut = hasThisMonthRawData ? s.Sum(su => su.ValueOut) : 0,
                VisitorRate = hasThisMonthRawData ? (s.Sum(su => su.ValueIn) >= siteValueIn ?
                    100.0
                    : Math.Round((double)s.Sum(su => su.ValueIn) / siteValueIn * 100, 2)) : 0,
                VisitorRateDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.ParentAreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitorRate > 0 ?
                    (s.Sum(su => su.ValueIn) >= siteValueIn ?
                        Math.Round((100.0 - lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitorRate) / lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitorRate * 100, 2)
                        : Math.Round((((double)s.Sum(su => su.ValueIn) / siteValueIn * 100) - lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitorRate) / lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitorRate * 100, 2))
                    : 0) : 0,
                ReturningRate = hasThisMonthRawData ? (s.Sum(a => a.ReturningRate) > 0 ?
                        Math.Round(s.Average(a => a.ReturningRate), 2) : 0) : 0,
                ReturningRateDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.ParentAreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ReturningRate > 0 ?
                    (s.Sum(a => a.ReturningRate) > 0 ?
                            Math.Round(
                                (s.Average(a => a.ReturningRate) - lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ReturningRate)
                                / lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().ReturningRate * 100
                            , 2)
                        : -100.0)
                    : 0) : 0,
                LessIntervalWifiPercentage = hasThisMonthRawData ? s.Average(a => a.LessIntervalWifiPercentage) : 0,
                BetweenIntervalWifiPercentage = hasThisMonthRawData ? s.Average(a => a.BetweenIntervalWifiPercentage) : 0,
                OverIntervalMinWifiPercentage = hasThisMonthRawData ? s.Average(a => a.OverIntervalMinWifiPercentage) : 0,
                VisitDuration = hasThisMonthRawData ? Math.Round(s.Average(su => su.VisitDuration), 2) : 0,
                VisitDurationDiff = hasThisMonthRawData ? (lastMonthAreaSummaryDetails.Any(w => w.ParentAreaId == s.Key) && lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitDuration > 0 ?
                    Math.Round((s.Average(su => su.VisitDuration) - lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitDuration) / lastMonthAreaSummaryDetails.Where(w => w.ParentAreaId == s.Key).FirstOrDefault().VisitDuration * 100, 2)
                    : 0) : 0,
                NewCustomerRate = hasThisMonthRawData ? (s.Sum(a => a.NewCustomerRate) > 0 ?
                        Math.Round(s.Average(a => a.NewCustomerRate), 2) : 0) : 0,
                MeasurementString = !parentAreaQueueCountingsIds.Contains((long)s.Key) ? Helper.ExperienceCentreReport.ExperienceCentreReport_Mins : Helper.ExperienceCentreReport.ExperienceCentreReport_Secs
            }).OrderBy(o => o.ParentAreaName).ToList();

            averageReturningRate = result.Count() != 0 ? result.Average(a => a.ReturningRate) : 0;
            averageNewCustomerRate = result.Count() != 0 ? result.Average(a => a.NewCustomerRate) : 0;
            averageValueIn = result.Count() != 0 ? result.Average(a => a.ValueIn) : 0;
            averageVisitDuration = result.Count() != 0 ? result.Average(a => a.VisitDuration) : 0;

            result = result.Select(s => new AreaDailyViewModel
            {
                AreaId = s.AreaId,
                AreaName = s.AreaName,
                ParentAreaId = s.ParentAreaId,
                ParentAreaName = s.ParentAreaName,
                ValueIn = s.ValueIn,
                ValueInDiff = s.ValueInDiff,
                ValueOut = s.ValueOut,
                VisitorRate = s.VisitorRate,
                VisitorRateDiff = s.VisitorRateDiff,
                ReturningRate = s.ReturningRate,
                ReturningRateDiff = s.ReturningRateDiff,
                LessIntervalWifiPercentage = s.LessIntervalWifiPercentage,
                BetweenIntervalWifiPercentage = s.BetweenIntervalWifiPercentage,
                OverIntervalMinWifiPercentage = s.OverIntervalMinWifiPercentage,
                VisitDuration = s.VisitDuration,
                VisitDurationDiff = s.VisitDurationDiff,
                NewCustomerRate = s.NewCustomerRate,
                AverageReturningRate = averageReturningRate,
                AverageNewCustomerRate = averageNewCustomerRate,
                AverageValueIn = averageValueIn,
                AverageVisitDuration = averageVisitDuration,
                MeasurementString = s.MeasurementString
            }).ToList();

            return result;
        }

        private Table AreaSummaryTable(List<AreaDailyViewModel> dataSource, int appendCount, double yPosition, int firstInterval, int secondInterval, bool isQueue)
        {
            string font = TelerikUtility.GetDefaultFontName();

            string lowerInterval_string = firstInterval >= 60 ? ((double)firstInterval / 60).ToString("0.#") : firstInterval.ToString();
            string upperInterval_string = firstInterval >= 60 ? ((double)secondInterval / 60).ToString("0.#") : secondInterval.ToString();

            string firstInterval_string = "< " + lowerInterval_string + " " + (firstInterval >= 60 ? Helper.ExperienceCentreReport.ExperienceCentreReport_Mins : Helper.ExperienceCentreReport.ExperienceCentreReport_Secs);
            string secondInterval_string = lowerInterval_string + " - " + upperInterval_string + " " + (firstInterval >= 60 ? Helper.ExperienceCentreReport.ExperienceCentreReport_Mins : Helper.ExperienceCentreReport.ExperienceCentreReport_Secs);
            string thirdInterval_string = "> " + upperInterval_string + " " + (firstInterval >= 60 ? Helper.ExperienceCentreReport.ExperienceCentreReport_Mins : Helper.ExperienceCentreReport.ExperienceCentreReport_Secs);

            #region Initialization
            //Table Groups
            TableGroup tableGroup_1 = new TableGroup();
            TableGroup tableGroup_2 = new TableGroup();
            TableGroup tableGroup_3 = new TableGroup();
            TableGroup tableGroup_4 = new TableGroup();
            TableGroup tableGroup_5 = new TableGroup();
            TableGroup tableGroup_6 = new TableGroup();
            TableGroup tableGroup_7 = new TableGroup();
            TableGroup tableGroup_8 = new TableGroup();
            TableGroup tableGroup_9 = new TableGroup();
            TableGroup tableGroup_10 = new TableGroup();
            TableGroup tableGroup_11 = new TableGroup();
            TableGroup tableGroup_12 = new TableGroup();
            TableGroup tableGroup_13 = new TableGroup();
            TableGroup tableGroup_14 = new TableGroup();
            TableGroup tableGroup_15 = new TableGroup();
            TableGroup tableGroup_16 = new TableGroup();
            TableGroup tableGroup_17 = new TableGroup();
            TableGroup tableGroup_18 = new TableGroup();
            TableGroup tableGroup_19 = new TableGroup();
            TableGroup tableGroup_20 = new TableGroup();
            TableGroup tableGroup_21 = new TableGroup();
            TableGroup tableGroup_22 = new TableGroup();
            TableGroup tableGroup_23 = new TableGroup();
            TableGroup tableGroup_24 = new TableGroup();
            TableGroup tableGroup_25 = new TableGroup();
            TableGroup tableGroup_26 = new TableGroup();
            TableGroup tableGroup_27 = new TableGroup();

            //Table Elements
            Table table = new Table();
            TextBox emptyHeader = new TextBox();
            TextBox locationHeader = new TextBox();
            TextBox header1 = new TextBox();
            TextBox header2 = new TextBox();
            TextBox header3 = new TextBox();
            TextBox header4 = new TextBox();
            TextBox header5 = new TextBox();
            TextBox header6 = new TextBox();
            TextBox header7 = new TextBox();
            TextBox subheader1 = new TextBox();
            TextBox subheader2 = new TextBox();
            TextBox subheader3 = new TextBox();
            TextBox content1 = new TextBox();
            TextBox content2 = new TextBox();
            PictureBox content3 = new PictureBox();
            TextBox content4 = new TextBox();
            TextBox content5 = new TextBox();
            PictureBox content6 = new PictureBox();
            TextBox content7 = new TextBox();
            TextBox content8 = new TextBox();
            PictureBox content9 = new PictureBox();
            TextBox content10 = new TextBox();
            TextBox content11 = new TextBox();
            TextBox content12 = new TextBox();
            TextBox content13 = new TextBox();
            TextBox content14 = new TextBox();
            TextBox content15 = new TextBox();


            //Formatting Rules
            FormattingRule formattingRule_1 = new FormattingRule();
            FormattingRule formattingRule_2 = new FormattingRule();
            FormattingRule formattingRule_3 = new FormattingRule();
            FormattingRule formattingRule_4 = new FormattingRule();
            FormattingRule formattingRule_5 = new FormattingRule();
            FormattingRule formattingRule_6 = new FormattingRule();
            FormattingRule formattingRule_7 = new FormattingRule();
            FormattingRule formattingRule_8 = new FormattingRule();
            FormattingRule formattingRule_9 = new FormattingRule();
            #endregion

            #region Elements Properties
            // 
            // areaSummary_table1_header1
            // 
            header1.Name = "areaSummary_table" + appendCount + "_header1";
            header1.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.2037593126296997D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header1.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header1.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header1.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header1.Style.BorderStyle.Left = Telerik.Reporting.Drawing.BorderType.Solid;
            header1.Style.Font.Name = "Arial Unicode MS";
            header1.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header1.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0.10000000149011612D);
            header1.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header1.Value = "=Fields.ParentAreaName";
            // 
            // areaSummary_table1_header2
            // 
            header2.Name = "areaSummary_table" + appendCount + "_header2";
            header2.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.0002367496490479D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header2.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header2.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header2.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header2.Style.Font.Name = "Arial Unicode MS";
            header2.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header2.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header2.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header2.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorRate + " (%)";
            // 
            // areaSummary_table1_header3
            // 
            header3.Name = "areaSummary_table" + appendCount + "_header3";
            header3.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.1450506448745728D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header3.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header3.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header3.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header3.Style.Font.Name = "Arial Unicode MS";
            header3.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header3.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header3.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header3.StyleName = "";
            header3.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCount;
            // 
            // areaSummary_table1_header6
            // 
            header6.Name = "areaSummary_table" + appendCount + "_header6";
            header6.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.4355617761611939D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header6.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header6.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header6.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header6.Style.Font.Name = "Arial Unicode MS";
            header6.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header6.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header6.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header6.StyleName = "";
            header6.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_VisitorCountTarget;
            // 
            // areaSummary_table1_header4
            // 
            header4.Name = "areaSummary_table" + appendCount + "_header4";
            header4.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.0000001192092896D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header4.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header4.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header4.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header4.Style.Font.Name = "Arial Unicode MS";
            header4.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header4.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header4.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header4.StyleName = "";
            header4.Value = Helper.ExperienceCentreReport.ExperienceCentreReport_ReturningCustomer + " (%)";
            // 
            // areaSummary_table1_header7
            // 
            header7.Name = "areaSummary_table" + appendCount + "_header7";
            header7.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.6469467878341675D), Telerik.Reporting.Drawing.Unit.Inch(0.24152788519859314D));
            header7.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header7.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header7.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header7.Style.Font.Name = "Arial Unicode MS";
            header7.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header7.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header7.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header7.StyleName = "";
            header7.Value = (isQueue ? Helper.ExperienceCentreReport.ExperienceCentreReport_AvgQueueDuration + " (" + Helper.ExperienceCentreReport.ExperienceCentreReport_Secs + ")" : Helper.ExperienceCentreReport.ExperienceCentreReport_AvgVisitDuration + " (" + Helper.ExperienceCentreReport.ExperienceCentreReport_Mins + ")");
            // 
            // areaSummary_table1_subheader1
            // 
            subheader1.Name = "areaSummary_table" + appendCount + "_subheader1";
            subheader1.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.45999997854232788D), Telerik.Reporting.Drawing.Unit.Inch(0.12000007182359695D));
            subheader1.Style.BackgroundColor = System.Drawing.Color.LightGray;
            subheader1.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            subheader1.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            subheader1.Style.Font.Name = "Arial Unicode MS";
            subheader1.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            subheader1.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            subheader1.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            subheader1.StyleName = "";
            subheader1.Value = firstInterval_string;
            // 
            // areaSummary_table1_subheader2
            // 
            subheader2.Name = "areaSummary_table" + appendCount + "_subheader2";
            subheader2.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.46000003814697266D), Telerik.Reporting.Drawing.Unit.Inch(0.12000007182359695D));
            subheader2.Style.BackgroundColor = System.Drawing.Color.LightGray;
            subheader2.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            subheader2.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            subheader2.Style.Font.Name = "Arial Unicode MS";
            subheader2.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            subheader2.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            subheader2.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            subheader2.StyleName = "";
            subheader2.Value = secondInterval_string;
            // 
            // areaSummary_table1_subheader3
            // 
            subheader3.Name = "areaSummary_table" + appendCount + "_subheader3";
            subheader3.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.45999997854232788D), Telerik.Reporting.Drawing.Unit.Inch(0.12000007182359695D));
            subheader3.Style.BackgroundColor = System.Drawing.Color.LightGray;
            subheader3.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            subheader3.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            subheader3.Style.Font.Name = "Arial Unicode MS";
            subheader3.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            subheader3.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            subheader3.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            subheader3.StyleName = "";
            subheader3.Value = thirdInterval_string;
            // 
            // areaSummary_table1_header5
            // 
            header5.Name = "areaSummary_table" + appendCount + "_header5";
            header5.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.3799999952316284D), Telerik.Reporting.Drawing.Unit.Inch(0.12152782082557678D));
            header5.Style.BackgroundColor = System.Drawing.Color.LightGray;
            header5.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            header5.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            header5.Style.Font.Name = "Arial Unicode MS";
            header5.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            header5.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            header5.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            header5.StyleName = "";
            header5.Value = (isQueue ? Helper.ExperienceCentreReport.ExperienceCentreReport_QueueDuration : Helper.ExperienceCentreReport.ExperienceCentreReport_VisitDuration) + " (%)";
            // 
            // areaSummary_table1_locationHeader
            // 
            locationHeader.Name = "areaSummary_table" + appendCount + "_locationHeader";
            locationHeader.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.9426345825195312D), Telerik.Reporting.Drawing.Unit.Inch(0.15138892829418182D));
            locationHeader.Style.BackgroundColor = System.Drawing.Color.Transparent;
            locationHeader.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            locationHeader.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.None;
            locationHeader.Style.Font.Bold = true;
            locationHeader.Style.Font.Name = "Arial Unicode MS";
            locationHeader.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(8D);
            locationHeader.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0D);
            locationHeader.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            locationHeader.StyleName = ""; locationHeader.Value = "=Fields.ParentAreaName + \" - \" + COUNT(Fields.ParentAreaName) + \" " + Helper.ExperienceCentreReport.ExperienceCentreReport_Location + "\"";
            // 
            // areaSummary_table1_emptyHeader
            // 
            emptyHeader.Name = "areaSummary_table" + appendCount + "_emptyHeader";
            emptyHeader.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.9426345825195312D), Telerik.Reporting.Drawing.Unit.Inch(0.10416661202907562D));
            emptyHeader.Style.BackgroundColor = System.Drawing.Color.Transparent;
            emptyHeader.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            emptyHeader.Style.Font.Bold = true;
            emptyHeader.Style.Font.Name = "Microsoft Sans Serif";
            emptyHeader.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(8D);
            emptyHeader.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            emptyHeader.StyleName = "";

            // 
            // areaSummary_table1
            // 
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(1.2037593126296997D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.40000009536743164D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.20023655891418457D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.40000003576278687D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.54500949382781982D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.20000001788139343D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.4000411331653595D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(1.4355632066726685D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.40000009536743164D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.20000001788139343D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.40000003576278687D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(1.6469475030899048D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.460000216960907D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.460000216960907D)));
            table.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Inch(0.460000216960907D)));
            table.Body.Rows.Add(new Telerik.Reporting.TableBodyRow(Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D)));
            table.Body.SetCellContent(0, 0, content1);
            table.Body.SetCellContent(0, 1, content2);
            table.Body.SetCellContent(0, 3, content4);
            table.Body.SetCellContent(0, 4, content5);
            table.Body.SetCellContent(0, 6, content7);
            table.Body.SetCellContent(0, 8, content8);
            table.Body.SetCellContent(0, 10, content10);
            table.Body.SetCellContent(0, 12, content11);
            table.Body.SetCellContent(0, 13, content12);
            table.Body.SetCellContent(0, 2, content3);
            table.Body.SetCellContent(0, 5, content6);
            table.Body.SetCellContent(0, 9, content9);
            table.Body.SetCellContent(0, 14, content13);
            table.Body.SetCellContent(0, 7, content14);
            table.Body.SetCellContent(0, 11, content15);
            tableGroup_3.Name = "group28";
            tableGroup_3.ReportItem = header1;
            tableGroup_5.Name = "group11";
            tableGroup_6.Name = "group12";
            tableGroup_7.Name = "group5";
            tableGroup_4.ChildGroups.Add(tableGroup_5);
            tableGroup_4.ChildGroups.Add(tableGroup_6);
            tableGroup_4.ChildGroups.Add(tableGroup_7);
            tableGroup_4.Name = "group29";
            tableGroup_4.ReportItem = header2;
            tableGroup_9.Name = "group13";
            tableGroup_10.Name = "group14";
            tableGroup_11.Name = "group10";
            tableGroup_8.ChildGroups.Add(tableGroup_9);
            tableGroup_8.ChildGroups.Add(tableGroup_10);
            tableGroup_8.ChildGroups.Add(tableGroup_11);
            tableGroup_8.Name = "group30";
            tableGroup_8.ReportItem = header3;
            tableGroup_13.Name = "group35";
            tableGroup_12.ChildGroups.Add(tableGroup_13);
            tableGroup_12.Name = "group34";
            tableGroup_12.ReportItem = header6;
            tableGroup_15.Name = "group20";
            tableGroup_16.Name = "group24";
            tableGroup_17.Name = "group26";
            tableGroup_14.ChildGroups.Add(tableGroup_15);
            tableGroup_14.ChildGroups.Add(tableGroup_16);
            tableGroup_14.ChildGroups.Add(tableGroup_17);
            tableGroup_14.Name = "group31";
            tableGroup_14.ReportItem = header4;
            tableGroup_19.Name = "group37";
            tableGroup_18.ChildGroups.Add(tableGroup_19);
            tableGroup_18.Name = "group36";
            tableGroup_18.ReportItem = header7;
            tableGroup_22.Name = "group9";
            tableGroup_21.ChildGroups.Add(tableGroup_22);
            tableGroup_21.Name = "group39";
            tableGroup_21.ReportItem = subheader1;
            tableGroup_24.Name = "group16";
            tableGroup_23.ChildGroups.Add(tableGroup_24);
            tableGroup_23.Name = "group40";
            tableGroup_23.ReportItem = subheader2;
            tableGroup_26.Name = "group21";
            tableGroup_25.ChildGroups.Add(tableGroup_26);
            tableGroup_25.Name = "group41";
            tableGroup_25.ReportItem = subheader3;
            tableGroup_20.ChildGroups.Add(tableGroup_21);
            tableGroup_20.ChildGroups.Add(tableGroup_23);
            tableGroup_20.ChildGroups.Add(tableGroup_25);
            tableGroup_20.Name = "group32";
            tableGroup_20.ReportItem = header5;
            tableGroup_2.ChildGroups.Add(tableGroup_3);
            tableGroup_2.ChildGroups.Add(tableGroup_4);
            tableGroup_2.ChildGroups.Add(tableGroup_8);
            tableGroup_2.ChildGroups.Add(tableGroup_12);
            tableGroup_2.ChildGroups.Add(tableGroup_14);
            tableGroup_2.ChildGroups.Add(tableGroup_18);
            tableGroup_2.ChildGroups.Add(tableGroup_20);
            tableGroup_2.Name = "group33";
            tableGroup_2.ReportItem = locationHeader;
            tableGroup_1.ChildGroups.Add(tableGroup_2);
            tableGroup_1.Name = "tableGroup3";
            tableGroup_1.ReportItem = emptyHeader;
            table.ColumnGroups.Add(tableGroup_1);
            table.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
                content1,
                content2,
                content3,
                content4,
                content5,
                content6,
                content7,
                content14,
                content8,
                content9,
                content10,
                content15,
                content11,
                content12,
                content13,
                emptyHeader,
                locationHeader,
                header1,
                header2,
                header3,
                header6,
                header4,
                header7,
                header5,
                subheader1,
                subheader2,
                subheader3});
            table.Location = new Telerik.Reporting.Drawing.PointU(Telerik.Reporting.Drawing.Unit.Inch(0.00027804903220385313D), Telerik.Reporting.Drawing.Unit.Inch(yPosition));
            table.Name = "areaSummary_table" + appendCount;
            tableGroup_27.Groupings.Add(new Telerik.Reporting.Grouping(null));
            tableGroup_27.Name = "detailTableGroup1";
            table.RowGroups.Add(tableGroup_27);
            table.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(6.942634105682373D), Telerik.Reporting.Drawing.Unit.Inch(0.737083375453949D));
            table.Style.Visible = true;
            // 
            // areaSummary_table1_content1
            // 
            content1.Name = "areaSummary_table" + appendCount + "_content1";
            content1.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(1.2037593126296997D), Telerik.Reporting.Drawing.Unit.Inch(0.23999996483325958D));
            content1.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content1.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content1.Style.Font.Name = "Arial Unicode MS";
            content1.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content1.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0.10000000149011612D);
            content1.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content1.Value = "=Fields.AreaName";
            // 
            // areaSummary_table1_content2
            // 
            content2.Format = "{0:#,##0.##}";
            content2.Name = "areaSummary_table" + appendCount + "_content2";
            content2.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.40000003576278687D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content2.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content2.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content2.Style.Font.Name = "Arial Unicode MS";
            content2.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content2.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content2.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content2.Value = "=Fields.VisitorRate";
            // 
            // areaSummary_table1_content4
            // 
            formattingRule_1.Filters.Add(new Telerik.Reporting.Filter("=Fields.VisitorRateDiff", Telerik.Reporting.FilterOperator.LessThan, "0"));
            formattingRule_1.Style.Color = System.Drawing.Color.Brown;
            formattingRule_2.Filters.Add(new Telerik.Reporting.Filter("=Fields.VisitorRateDiff", Telerik.Reporting.FilterOperator.Equal, "0"));
            formattingRule_3.Filters.Add(new Telerik.Reporting.Filter("=Fields.VIsitorRateDiff", Telerik.Reporting.FilterOperator.GreaterThan, "0"));
            formattingRule_3.Style.Color = System.Drawing.Color.SeaGreen;
            content4.ConditionalFormatting.AddRange(new Telerik.Reporting.Drawing.FormattingRule[] {
                formattingRule_1,
                formattingRule_2,
                formattingRule_3});
            content4.Format = "{0:# ##0.##}";
            content4.Name = "areaSummary_table" + appendCount + "_content4";
            content4.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.40000003576278687D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content4.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content4.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content4.Style.BorderStyle.Right = Telerik.Reporting.Drawing.BorderType.Solid;
            content4.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content4.Style.Font.Name = "Arial Unicode MS";
            content4.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content4.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0.05000000074505806D);
            content4.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content4.StyleName = "";
            content4.Value = "=IIF(Fields.VisitorRateDiff <> CDbl(0), Abs(Fields.VisitorRateDiff) + \"%\", \"-\")";
            // 
            // areaSummary_table1_content5
            // 
            content5.Format = "{0:N0}";
            content5.Name = "areaSummary_table" + appendCount + "_content5";
            content5.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.5450093150138855D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content5.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content5.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content5.Style.Font.Name = "Arial Unicode MS";
            content5.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content5.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content5.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content5.StyleName = "";
            content5.Value = "=Fields.ValueIn";
            // 
            // areaSummary_table1_content7
            // 
            formattingRule_4.Filters.Add(new Telerik.Reporting.Filter("=Fields.ValueInDiff", Telerik.Reporting.FilterOperator.LessThan, "0"));
            formattingRule_4.Style.Color = System.Drawing.Color.Brown;
            formattingRule_5.Filters.Add(new Telerik.Reporting.Filter("=Fields.ValueInDiff", Telerik.Reporting.FilterOperator.Equal, "0"));
            formattingRule_6.Filters.Add(new Telerik.Reporting.Filter("=Fields.ValueInDiff", Telerik.Reporting.FilterOperator.GreaterThan, "0"));
            formattingRule_6.Style.Color = System.Drawing.Color.SeaGreen;
            content7.ConditionalFormatting.AddRange(new Telerik.Reporting.Drawing.FormattingRule[] {
                formattingRule_4,
                formattingRule_5,
                formattingRule_6});
            content7.Format = "{0:# ##0.##}";
            content7.Name = "areaSummary_table" + appendCount + "_content7";
            content7.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.4000408947467804D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content7.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content7.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content7.Style.BorderStyle.Right = Telerik.Reporting.Drawing.BorderType.Solid;
            content7.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content7.Style.Font.Name = "Arial Unicode MS";
            content7.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content7.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0.05000000074505806D);
            content7.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content7.StyleName = "";
            content7.Value = "=IIF(Fields.ValueInDiff <> CDbl(0), Abs(Fields.ValueInDiff) + \"%\", \"-\")";
            // 
            // areaSummary_table1_content8
            // 
            content8.Format = "{0:#,##0.##}";
            content8.Name = "areaSummary_table" + appendCount + "_content8";
            content8.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.40000000596046448D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content8.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content8.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content8.Style.Font.Name = "Arial Unicode MS";
            content8.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content8.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content8.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content8.StyleName = "";
            content8.Value = "=Fields.ReturningRate";
            // 
            // areaSummary_table1_content10
            // 
            formattingRule_7.Filters.Add(new Telerik.Reporting.Filter("=Fields.ReturningRateDiff", Telerik.Reporting.FilterOperator.LessThan, "0"));
            formattingRule_7.Style.Color = System.Drawing.Color.Brown;
            formattingRule_8.Filters.Add(new Telerik.Reporting.Filter("=Fields.ReturningRateDiff", Telerik.Reporting.FilterOperator.Equal, "0"));
            formattingRule_9.Filters.Add(new Telerik.Reporting.Filter("=Fields.ReturningRateDiff", Telerik.Reporting.FilterOperator.GreaterThan, "0"));
            formattingRule_9.Style.Color = System.Drawing.Color.SeaGreen;
            content10.ConditionalFormatting.AddRange(new Telerik.Reporting.Drawing.FormattingRule[] {
                formattingRule_7,
                formattingRule_8,
                formattingRule_9});
            content10.Format = "{0:# ##0.##}";
            content10.Name = "areaSummary_table" + appendCount + "_content10";
            content10.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.40000003576278687D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content10.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content10.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content10.Style.BorderStyle.Right = Telerik.Reporting.Drawing.BorderType.Solid;
            content10.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content10.Style.Font.Name = "Arial Unicode MS";
            content10.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content10.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Inch(0.05000000074505806D);
            content10.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content10.StyleName = "";
            content10.Value = "=IIF(Fields.ReturningRateDiff <> CDbl(0), Abs(Fields.ReturningRateDiff) + \"%\", \"-\")";
            // 
            // areaSummary_table1_content11
            // 
            content11.Format = "{0:# ##0.##}";
            content11.Name = "areaSummary_table" + appendCount + "_content11";
            content11.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.45999997854232788D), Telerik.Reporting.Drawing.Unit.Inch(0.23999996483325958D));
            content11.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content11.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content11.Style.Font.Name = "Arial Unicode MS";
            content11.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content11.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content11.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content11.StyleName = "";
            content11.Value = "=Fields.LessIntervalWifiPercentage";
            // 
            // areaSummary_table1_content12
            // 
            content12.Format = "{0:# ##0.##}";
            content12.Name = "areaSummary_table" + appendCount + "_content12";
            content12.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.46000003814697266D), Telerik.Reporting.Drawing.Unit.Inch(0.23999996483325958D));
            content12.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content12.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content12.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content12.Style.BorderStyle.Left = Telerik.Reporting.Drawing.BorderType.Solid;
            content12.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content12.Style.Font.Name = "Arial Unicode MS";
            content12.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content12.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content12.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content12.StyleName = "";
            content12.Value = "=Fields.BetweenIntervalWifiPercentage";
            // 
            // areaSummary_table1_content3
            // 
            content3.Bindings.Add(new Telerik.Reporting.Binding("Value", "=RetailCamControlPanel.Helper.TelerikUtility.GetDiffImage(Fields.VisitorRateDiff)" +
            ""));
            content3.Name = "areaSummary_table" + appendCount + "_content3";
            content3.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.200236514210701D), Telerik.Reporting.Drawing.Unit.Inch(0.2399999350309372D));
            content3.Sizing = Telerik.Reporting.Drawing.ImageSizeMode.ScaleProportional;
            content3.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content3.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content3.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content3.Style.Font.Name = "Arial Unicode MS";
            content3.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content3.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Cm(0.05000000074505806D);
            content3.Style.Padding.Right = Telerik.Reporting.Drawing.Unit.Cm(0D);
            content3.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content3.StyleName = "";
            // 
            // areaSummary_table1_content6
            // 
            content6.Bindings.Add(new Telerik.Reporting.Binding("Value", "=RetailCamControlPanel.Helper.TelerikUtility.GetDiffImage(Fields.ValueInDiff)"));
            content6.Name = "areaSummary_table" + appendCount + "_content6";
            content6.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.20000000298023224D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content6.Sizing = Telerik.Reporting.Drawing.ImageSizeMode.ScaleProportional;
            content6.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content6.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content6.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content6.Style.Font.Name = "Arial Unicode MS";
            content6.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content6.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Cm(0.05000000074505806D);
            content6.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content6.StyleName = "";
            // 
            // areaSummary_table1_content9
            // 
            content9.Bindings.Add(new Telerik.Reporting.Binding("Value", "=RetailCamControlPanel.Helper.TelerikUtility.GetDiffImage(Fields.ReturningRateDif" +
            "f)"));
            content9.Name = "areaSummary_table" + appendCount + "_content9";
            content9.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.20000001788139343D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content9.Sizing = Telerik.Reporting.Drawing.ImageSizeMode.ScaleProportional;
            content9.Style.BackgroundImage.ImageData = null;
            content9.Style.BackgroundImage.MimeType = "";
            content9.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content9.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content9.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content9.Style.Font.Name = "Arial Unicode MS";
            content9.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content9.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Cm(0.05000000074505806D);
            content9.Style.Padding.Right = Telerik.Reporting.Drawing.Unit.Cm(0D);
            content9.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content9.StyleName = "";
            // 
            // areaSummary_table1_content13
            // 
            content13.Format = "{0:# ##0.##}";
            content13.Name = "areaSummary_table" + appendCount + "_content13";
            content13.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Inch(0.45999997854232788D), Telerik.Reporting.Drawing.Unit.Inch(0.23999996483325958D));
            content13.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content13.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content13.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content13.Style.BorderStyle.Left = Telerik.Reporting.Drawing.BorderType.Solid;
            content13.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content13.Style.Font.Name = "Arial Unicode MS";
            content13.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content13.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content13.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content13.StyleName = "";
            content13.Value = "=Fields.OverIntervalMinWifiPercentage";
            // 
            // areaSummary_table1_content14
            // 
            content14.Format = "{0:N0}";
            content14.Name = "areaSummary_table" + appendCount + "_content14";
            content14.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.4355617761611939D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content14.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content14.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content14.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content14.Style.BorderStyle.Right = Telerik.Reporting.Drawing.BorderType.Solid;
            content14.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content14.Style.Font.Name = "Arial Unicode MS";
            content14.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content14.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Cm(0D);
            content14.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content14.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content14.StyleName = "";
            content14.Value = "=IIF(Fields.VisitorTarget > 0, Fields.VisitorTarget, \"-\")";
            // 
            // areaSummary_table1_content15
            // 
            content15.Format = "{0:# ##0.##}";
            content15.Name = "areaSummary_table" + appendCount + "_content15";
            content15.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.6469467878341675D), Telerik.Reporting.Drawing.Unit.Inch(0.23999994993209839D));
            content15.Style.BorderColor.Default = System.Drawing.Color.DimGray;
            content15.Style.BorderStyle.Bottom = Telerik.Reporting.Drawing.BorderType.Solid;
            content15.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            content15.Style.BorderStyle.Right = Telerik.Reporting.Drawing.BorderType.Solid;
            content15.Style.BorderStyle.Top = Telerik.Reporting.Drawing.BorderType.Solid;
            content15.Style.Font.Name = "Arial Unicode MS";
            content15.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(6D);
            content15.Style.Padding.Left = Telerik.Reporting.Drawing.Unit.Cm(0D);
            content15.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            content15.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            content15.StyleName = "";
            content15.Value = "=Fields.VisitDuration";
            #endregion

            table.DataSource = dataSource;

            return table;
        }

        private Graph PlotLineLineGraph_Private(string graphName, Graph reportGraph,
            IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisName, string yAxisGroup2, string yAxisName2, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            //var categoryGroup = new GraphGroup();
            //categoryGroup.Name = "categoryGroup";
            //categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            //reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            //var seriesGroup = new GraphGroup();
            //seriesGroup.Name = "seriesGroup";
            //reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            // var categoryGroup_X_Axis_1 = new GraphAxis();
            // categoryGroup_X_Axis_1.Name = "X Axis";
            // categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_1.Title = xAxisName;
            // categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            // categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            // categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            // categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            // categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            // categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            //Setup another Graph Axis X with CategoryScale (X AXIS 2)
            // var categoryGroup_X_Axis_2 = new GraphAxis();
            // categoryGroup_X_Axis_2.Name = "X Axis 2";
            // categoryGroup_X_Axis_2.Scale = new CategoryScale();
            // categoryGroup_X_Axis_2.Style.Visible = false;
            // categoryGroup_X_Axis_2.MajorGridLineStyle.Visible = false;
            // categoryGroup_X_Axis_2.MinorGridLineStyle.Visible = false;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            // var numbericScale_Y_Axis_1 = new GraphAxis();
            // numbericScale_Y_Axis_1.Name = "Y Axis";
            // numbericScale_Y_Axis_1.Scale = new NumericalScale();
            numericalScale_Y_Axis_1.Title = yAxisName;
            // numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            // numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numericalScale_Y_Axis_1.LabelFormat = format;

            // Setup 2nd Graph Axis with Numerical Scale (Y AXIS 2)
            // var numbericScale_Y_Axis_2 = new GraphAxis();
            // numbericScale_Y_Axis_2.Name = "Y Axis 2";
            // numbericScale_Y_Axis_2.Scale = new NumericalScale();
            numericalScale_Y_Axis_2.Title = yAxisName2;
            // numbericScale_Y_Axis_2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            // numbericScale_Y_Axis_2.MajorGridLineStyle.Visible = false;
            // numbericScale_Y_Axis_2.MinorGridLineStyle.Visible = false;
            // numbericScale_Y_Axis_2.Style.LineColor = Color.White;
            // numbericScale_Y_Axis_2.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            // numbericScale_Y_Axis_2.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            // var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            // cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            // cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_1;
            // cartesianCoordinateSystem.YAxis = numbericScale_Y_Axis_1;
            // cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            // reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            // cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //2nd Data
            // var cartesianCoordinateSystem2 = new CartesianCoordinateSystem();
            // cartesianCoordinateSystem2.Name = "cartesianCoordinateSystem6";
            // cartesianCoordinateSystem2.XAxis = categoryGroup_X_Axis_1;
            // //cartesianCoordinateSystem2.XAxis.Style.Font.Name = font;
            // cartesianCoordinateSystem2.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            // cartesianCoordinateSystem2.YAxis = numbericScale_Y_Axis_2;

            //reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem2);

            //The Line Series area
            //1st Data
            //var lineSeries1 = new LineSeries();
            //lineSeries1.CategoryGroup = categoryGroup;
            //lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries1.LegendItem.Value = yAxisName;
            lineSeries1.ToolTip.Text = "=Format('" + Helper.ExperienceCentreReport.ExperienceCentreReport_Week + " {0} ({1}) {2}', Fields.Week, Fields.WeekString, Fields.CampaignName)";
            //lineSeries1.SeriesGroup = seriesGroup;
            //lineSeries1.Y = yAxisGroup;
            //reportGraph.Series.Add(lineSeries1);
            //lineSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);

            //The Line Series area
            //2nd Data
            // var lineSeries2 = new LineSeries();
            // lineSeries2.CategoryGroup = categoryGroup;
            // lineSeries2.CoordinateSystem = cartesianCoordinateSystem2;
            lineSeries2.LegendItem.Value = yAxisName2;
            // lineSeries2.SeriesGroup = seriesGroup;
            //lineSeries2.Y = yAxisGroup2;
            // lineSeries2.LineStyle.LineStyle = LineStyle.Dashed;
            // lineSeries1.MarkerType = DataPointMarkerType.Circle;
            // lineSeries1.MarkerSize = new Telerik.Reporting.Drawing.Unit(5);
            // lineSeries1.DataPointStyle.BackgroundColor = Color.AliceBlue;
            // lineSeries1.DataPointStyle.LineColor = Color.AliceBlue;
            // lineSeries1.DataPointStyle.Visible = true;
            // reportGraph.Series.Add(lineSeries2);
            // lineSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);

            //reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            //reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        private Graph PlotStackedBarGraph_Private(string graphName, Graph reportGraph,
            IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string yAxisGroup3, string yAxisName, string yValueName, string yValueName2, string yValueName3, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            //var categoryGroup = new GraphGroup();
            //categoryGroup.Name = "categoryGroup";
            //categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            //reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            //var seriesGroup = new GraphGroup();
            //seriesGroup.Name = "seriesGroup";
            //reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            //var categoryGroup_X_Axis_1 = new GraphAxis();
            //categoryGroup_X_Axis_1.Name = "X Axis";
            //categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_4.Title = xAxisName;
            //categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            //categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            //categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            //categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            //categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            //categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            //var numbericScale_Y_Axis_1 = new GraphAxis();
            //numbericScale_Y_Axis_1.Name = "Y Axis";
            //numbericScale_Y_Axis_1.Scale = new NumericalScale();
            numericalScale_Y_Axis_4.Title = yAxisName;
            //numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            //numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            //numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numericalScale_Y_Axis_4.LabelFormat = format;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            //var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            //cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            //cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_4;
            //cartesianCoordinateSystem.YAxis = numericalScale_Y_Axis_4;
            //cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            //reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            //cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //The Bar Series area
            //1st Data
            //var barSeries1 = new BarSeries();
            //barSeries1.CategoryGroup = categoryGroup;
            //barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Value = yValueName;
            //barSeries1.SeriesGroup = seriesGroup;
            //barSeries1.Y = yAxisGroup;
            //barSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);
            //barSeries1.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            //reportGraph.Series.Add(barSeries1);

            //The Bar Series area
            //2nd Data
            //var barSeries2 = new BarSeries();
            //barSeries2.CategoryGroup = categoryGroup;
            //barSeries2.CoordinateSystem = cartesianCoordinateSystem;
            barSeries2.LegendItem.Value = yValueName2;
            //barSeries2.SeriesGroup = seriesGroup;
            //barSeries2.Y = yAxisGroup2;
            //barSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);
            //barSeries2.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            //reportGraph.Series.Add(barSeries2);

            //The Bar Series area
            //3nd Data
            //var barSeries3 = new BarSeries();
            //barSeries3.CategoryGroup = categoryGroup;
            //barSeries3.CoordinateSystem = cartesianCoordinateSystem;
            barSeries3.LegendItem.Value = yValueName3;
            //barSeries3.SeriesGroup = seriesGroup;
            //barSeries3.Y = yAxisGroup3;
            //barSeries3.ColorPalette = new ColorPalette(Color.Red);
            //barSeries3.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            //reportGraph.Series.Add(barSeries3);

            lineSeries4.ToolTip.Text = "=Format('" + Helper.ExperienceCentreReport.ExperienceCentreReport_Week + " {0} ({1}) {2}', Fields.Week, Fields.WeekString, Fields.CampaignName)";

            //reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            //reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        public Graph PlotVisitorRateStackedBarGraph(string graphName, Graph reportGraph,
            IEnumerable<AreaDailyViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string yAxisGroup3, string yAxisName, string yValueName, string yValueName2, string yValueName3, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            var categoryGroup = new GraphGroup();
            categoryGroup.Name = "categoryGroup";
            categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup = new GraphGroup();
            seriesGroup.Name = "seriesGroup";
            reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            var categoryGroup_X_Axis_1 = new GraphAxis();
            categoryGroup_X_Axis_1.Name = "X Axis";
            categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_1.Title = xAxisName;
            categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            var numbericScale_Y_Axis_1 = new GraphAxis();
            numbericScale_Y_Axis_1.Name = "Y Axis";
            numbericScale_Y_Axis_1.Scale = new NumericalScale();
            numbericScale_Y_Axis_1.Title = yAxisName;
            numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numbericScale_Y_Axis_1.LabelFormat = format;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_1;
            cartesianCoordinateSystem.YAxis = numbericScale_Y_Axis_1;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 0;

            //The Bar Series area
            //1st Data
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = categoryGroup;
            barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Value = yValueName;
            barSeries1.SeriesGroup = seriesGroup;
            barSeries1.Y = yAxisGroup + "*(Fields.VisitorRate/100)";
            barSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);
            barSeries1.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            reportGraph.Series.Add(barSeries1);

            //The Bar Series area
            //2nd Data
            var barSeries2 = new BarSeries();
            barSeries2.CategoryGroup = categoryGroup;
            barSeries2.CoordinateSystem = cartesianCoordinateSystem;
            barSeries2.LegendItem.Value = yValueName2;
            barSeries2.SeriesGroup = seriesGroup;
            barSeries2.Y = yAxisGroup2 + "*(Fields.VisitorRate/100)";
            barSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);
            barSeries2.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            reportGraph.Series.Add(barSeries2);

            //The Bar Series area
            //2nd Data
            var barSeries3 = new BarSeries();
            barSeries3.CategoryGroup = categoryGroup;
            barSeries3.CoordinateSystem = cartesianCoordinateSystem;
            barSeries3.LegendItem.Value = yValueName3;
            barSeries3.LegendItem.Style.Visible = false;
            barSeries3.SeriesGroup = seriesGroup;
            barSeries3.Y = yAxisGroup3;
            barSeries3.ColorPalette = new ColorPalette(Color.FromArgb(0, Color.Black));
            barSeries3.ArrangeMode = GraphSeriesArrangeMode.Overlapped;
            //barSeries3.ToolTip.Title = "=Format('{0:## ##0.##}', Fields.ParentAreaName)";
            barSeries3.ToolTip.Text = Utility.Telerik_FormatExpression2Values(yAxisGroup3, yAxisGroup, yValueName3 + ": {0:## ##0.##}%", yValueName + ": {1:## ##0.##}%");
            reportGraph.Series.Add(barSeries3);

            reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }
        public static System.Drawing.Image GetMarkerPointerImage(int markerColorCode)
        {
            if (markerColorCode < 10)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/map_pointer/map_pointer-0" + markerColorCode.ToString() + ".png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/map_pointer/map-pointer-" + markerColorCode.ToString() + ".png"));
            }
        }

        public static string FormatPercentage(double doubleToCheck)
        {
            return Math.Abs(doubleToCheck).ToString() + "%";
        }

        public static string FormatDenominator_Private(double value)
        {
            int denominator = 1;
            if (value >= 30000000 && value >= 1000000)
                denominator = 1000000;
            else if (value >= 3000)
                denominator = 1000;
            else
                denominator = 1;

            var formatString = "{0:#,##0.##}";
            if (denominator == 1000000)
                formatString = "{0:##,##0.##M}";
            else if (denominator == 1000)
                formatString = "{0:##,##0.##k}";
            else
                formatString = "{0:##,##0.##}";

            return String.Format(formatString, Math.Round(value / denominator, 2));
        }

        public WeeklyDataViewModel CalculateWeeklyTrend(List<BranchSummaryDailyReportViewModel> branchDailyRawData,
            DateTime startd, DayOfWeek firstDayOfWeek, FinancialYearVM fse, bool twoYearWorth = false)
        {
            var vm = new WeeklyDataViewModel();
            DateTime thisYearCompanyFinancialWeekStart = fse.ThisYear.FinancialStartDate;
            DateTime thisYearCompanyFinancialWeekEnd = fse.ThisYear.FinancialEndDate;

            //Start/End Date adjustment
            DateTime thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStart;
            //Week 52/53 but not Week 1
            if (Utility.GetWeekCount(thisYearCompanyFinancialWeekStartDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) != 1)
            {
                thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStartDate.AddDays(7);
            }
            if (thisYearCompanyFinancialWeekStartDate.DayOfWeek != firstDayOfWeek)
            {
                int dateDOWTemp = (int)thisYearCompanyFinancialWeekStartDate.DayOfWeek;
                if (dateDOWTemp < (int)firstDayOfWeek)
                    dateDOWTemp += 7;

                int deductedDays = dateDOWTemp - (int)firstDayOfWeek;

                thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStartDate.AddDays(-(deductedDays));
            }

            DateTime thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEnd;
            //Week 1 but not Week 52/53
            if (Utility.GetWeekCount(thisYearCompanyFinancialWeekEndDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) == 1)
            {
                thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEndDate.AddDays(-7);
            }
            if (thisYearCompanyFinancialWeekEndDate.DayOfWeek != firstDayOfWeek)
            {
                int dateDOWTemp = (int)thisYearCompanyFinancialWeekEndDate.DayOfWeek;
                int firstDOWTemp = (int)firstDayOfWeek;
                if (dateDOWTemp >= firstDOWTemp)
                    firstDOWTemp += 7;

                int additionDays = firstDOWTemp - dateDOWTemp - 1;

                thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEndDate.AddDays(additionDays);
            }

            var startdYear = startd.Year;
            long thisYearTimestamp = Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekStartDate);
            var thisYearData = branchDailyRawData.Where(d => d.Date >= thisYearTimestamp);
            var thisYearByWeek = thisYearData
                .Where(w => w.Date >= Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekStartDate) &&
                            w.Date <= Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekEndDate))
                .GroupBy(d => Utility.GetWeekCount(Utility.ConvertToDateTime(d.Date), thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek));

            if (twoYearWorth)
            {
                DateTime lastYearCompanyFinancialWeekStart = fse.LastYear.FinancialStartDate;
                DateTime lastYearCompanyFinancialWeekEnd = fse.LastYear.FinancialEndDate;

                //Start/End Date adjustment
                DateTime lastYearCompanyFinancialWeekStartDate = lastYearCompanyFinancialWeekStart;
                //Week 52/53 but not Week 1
                if (Utility.GetWeekCount(lastYearCompanyFinancialWeekStartDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) != 1)
                {
                    lastYearCompanyFinancialWeekStartDate = lastYearCompanyFinancialWeekStartDate.AddDays(7);
                }
                if (lastYearCompanyFinancialWeekStartDate.DayOfWeek != firstDayOfWeek)
                {
                    int dateDOWTemp = (int)lastYearCompanyFinancialWeekStartDate.DayOfWeek;
                    if (dateDOWTemp < (int)firstDayOfWeek)
                        dateDOWTemp += 7;

                    int deducted = dateDOWTemp - (int)firstDayOfWeek;

                    lastYearCompanyFinancialWeekStartDate = lastYearCompanyFinancialWeekStartDate.AddDays(-(deducted));
                }

                DateTime lastYearCompanyFinancialWeekEndDate = lastYearCompanyFinancialWeekEnd;
                //Week 1 but not Week 52/53
                if (Utility.GetWeekCount(lastYearCompanyFinancialWeekEndDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) == 1)
                {
                    lastYearCompanyFinancialWeekEndDate = lastYearCompanyFinancialWeekEndDate.AddDays(-7);
                }
                if (lastYearCompanyFinancialWeekEndDate.DayOfWeek != firstDayOfWeek)
                {
                    int dateDOWTemp = (int)lastYearCompanyFinancialWeekEndDate.DayOfWeek;
                    int firstDOWTemp = (int)firstDayOfWeek;
                    if (dateDOWTemp >= firstDOWTemp)
                        firstDOWTemp += 7;

                    int additionDays = firstDOWTemp - dateDOWTemp - 1;

                    lastYearCompanyFinancialWeekEndDate = lastYearCompanyFinancialWeekEndDate.AddDays(additionDays);
                }

                long LastYearTimestamp = Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekStartDate);
                var lastYearData = branchDailyRawData.Where(d => d.Date >= LastYearTimestamp && d.Date < thisYearTimestamp);
                var lastYearByWeek = lastYearData
                    .Where(w => w.Date >= Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekStartDate) && w.Date <= Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekEndDate))
                    .GroupBy(d => Utility.GetWeekCount(Utility.ConvertToDateTime(d.Date), lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day, firstDayOfWeek));

                vm.LastYear = lastYearByWeek.Select(d => new WeeklyData()
                {
                    Timestamp = d.FirstOrDefault().Date,
                    Date = Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                    Week = Utility.GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                        lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day, firstDayOfWeek),
                    WeekString = Utility.ConvertToDateTime(d.FirstOrDefault().Date).Year + " " +
                        Utility.GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                                         lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day,
                                         firstDayOfWeek).ToString(),
                    OutsideTraffic = d.Sum(v => v.OutsideTraffic),
                    ValueIn = d.Sum(v => v.ValueIn),
                    ValueOut = d.Sum(v => v.ValueOut),
                    TurnInRate = d.Sum(v => v.ValueIn) == 0
                        ? 0
                        : d.Sum(v => v.OutsideTraffic) == 0
                            ? 100
                            : Math.Round(
                                (double)d.Sum(v => v.ValueIn) * 100 /
                                (d.Sum(v => v.ValueIn) + d.Sum(v => v.OutsideTraffic)), 2),

                    //visit duration
                    LessThan15mins = d.Sum(v => v.ValueIn) -
                                     (d.Sum(v => v.OutsideTraffic) > 0
                                         ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                            d.Sum(v => v.OverWifiCount)) > 0
                                             ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                                      (d.Sum(v => v.FifteenMinWifiCount) +
                                                       d.Sum(v => v.ThirteenMinWifiCount) +
                                                       d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                                             : 0
                                         : 0) - (d.Sum(v => v.OutsideTraffic) > 0
                                         ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                            d.Sum(v => v.OverWifiCount)) > 0
                                             ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                                      (d.Sum(v => v.FifteenMinWifiCount) +
                                                       d.Sum(v => v.ThirteenMinWifiCount) +
                                                       d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                                             : 0
                                         : 0),
                    Between15Till30mins = d.Sum(v => v.OutsideTraffic) > 0
                        ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                           d.Sum(v => v.OverWifiCount)) > 0
                            ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                     (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                      d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    LargerThan30mins = d.Sum(v => v.OutsideTraffic) > 0
                        ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                           d.Sum(v => v.OverWifiCount)) > 0
                            ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                     (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                      d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    SubTotal = d.Sum(v => v.ValueIn),

                    //returning customer
                    NewCustomer = d.Sum(v => v.OutsideTraffic) > 0
                        ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                            ? (int)(d.Sum(v => v.NewCustomer) * 1.0 /
                                     (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                      ) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    WeeklyCustomer = d.Sum(v => v.OutsideTraffic) > 0
                        ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                            ? (int)(d.Sum(v => v.WeeklyCustomer) * 1.0 /
                                     (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                      ) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,

                    //Sales
                    TransactionCount = d.Sum(v => v.TransactionCount),
                    SalesAmount = d.Sum(v => v.SalesAmount),
                    AverageAmount = d.Sum(v => v.AverageAmount),
                    SalesConversion = d.Sum(v => v.ValueIn) == 0
                        ? 0
                        : Math.Round((double)(d.Sum(v => v.TransactionCount) / (double)d.Sum(v => v.ValueIn) * 100),
                            2)

                }).OrderBy(o => o.Week).ToList();
            }

            vm.ThisYear = thisYearByWeek.Select(d => new WeeklyData()
            {
                Timestamp = d.FirstOrDefault().Date,
                Date = Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                Week = Utility.GetWeekCount(Utility.ConvertToDateTime(d.Last().Date),
                    thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek),
                WeekString = Utility.ConvertToDateTime(d.Last().Date).Year + " " + Utility
                                 .GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                                     thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day,
                                     firstDayOfWeek).ToString(),
                OutsideTraffic = d.Sum(v => v.OutsideTraffic),
                ValueIn = d.Sum(v => v.ValueIn),
                ValueOut = d.Sum(v => v.ValueOut),
                TurnInRate = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : d.Sum(v => v.OutsideTraffic) == 0
                        ? 100
                        : Math.Round(
                            (double)d.Sum(v => v.ValueIn) * 100 /
                            (double)(d.Sum(v => v.ValueIn) + d.Sum(v => v.OutsideTraffic)), 2),

                //visit duration
                LessThan15mins = d.Sum(v => v.ValueIn) -
                                 (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0) - (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0),
                Between15Till30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                LargerThan30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                SubTotal = d.Sum(v => v.ValueIn),

                //returning customer
                NewCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.NewCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                WeeklyCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.WeeklyCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,


                //Sales
                TransactionCount = d.Sum(v => v.TransactionCount),
                SalesAmount = d.Sum(v => v.SalesAmount),
                AverageAmount = d.Sum(v => v.AverageAmount),
                SalesConversion = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : Math.Round((double)(d.Sum(v => v.TransactionCount) / (double)d.Sum(v => v.ValueIn) * 100), 2)

            }).OrderBy(o => o.Week).ToList();

            return vm;

        }

        private List<WeeklyData> CalculateWeeklyTrend_Private(List<BranchSummaryDailyReportViewModel> branchDailyRawData,
            DateTime startd, DayOfWeek firstDayOfWeek, FinancialYearVM fse)
        {
            DateTime thisYearCompanyFinancialWeekStart = fse.ThisYear.FinancialStartDate;
            DateTime thisYearCompanyFinancialWeekEnd = fse.ThisYear.FinancialEndDate;

            //Start/End Date adjustment
            //DateTime thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStart;
            //Week 52/53 but not Week 1
            //if (Utility.GetWeekCount(thisYearCompanyFinancialWeekStartDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) != 1)
            //{
            //    thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStartDate.AddDays(7);
            //}
            //if (thisYearCompanyFinancialWeekStartDate.DayOfWeek != firstDayOfWeek)
            //{
            //    int dateDOWTemp = (int)thisYearCompanyFinancialWeekStartDate.DayOfWeek;
            //    if (dateDOWTemp < (int)firstDayOfWeek)
            //        dateDOWTemp += 7;

            //    int deductedDays = dateDOWTemp - (int)firstDayOfWeek;

            //    thisYearCompanyFinancialWeekStartDate = thisYearCompanyFinancialWeekStartDate.AddDays(-(deductedDays));
            //}

            //DateTime thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEnd;
            //Week 1 but not Week 52/53
            //if (Utility.GetWeekCount(thisYearCompanyFinancialWeekEndDate, thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek) == 1)
            //{
            //    thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEndDate.AddDays(-7);
            //}
            //if (thisYearCompanyFinancialWeekEndDate.DayOfWeek != firstDayOfWeek)
            //{
            //    int dateDOWTemp = (int)thisYearCompanyFinancialWeekEndDate.DayOfWeek;
            //    int firstDOWTemp = (int)firstDayOfWeek;
            //    if (dateDOWTemp >= firstDOWTemp)
            //        firstDOWTemp += 7;

            //    int additionDays = firstDOWTemp - dateDOWTemp - 1;

            //    thisYearCompanyFinancialWeekEndDate = thisYearCompanyFinancialWeekEndDate.AddDays(additionDays);
            //}

            //var startdYear = startd.Year;
            long thisYearTimestamp = Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekStart);
            var thisYearData = branchDailyRawData.Where(d => d.Date >= thisYearTimestamp);
            var thisYearByWeek = thisYearData
                .GroupBy(d => Utility.GetWeekCountFor52Weeks(Utility.ConvertToDateTime(d.Date), thisYearCompanyFinancialWeekStart));

            var weeklyTrend = thisYearByWeek.Select(d => new WeeklyData()
            {
                Timestamp = d.FirstOrDefault().Date,
                Date = Utility.GetWeekFirstDate(thisYearCompanyFinancialWeekStart,
                    Utility.GetWeekCountFor52Weeks(Utility.ConvertToDateTime(d.Last().Date),
                    thisYearCompanyFinancialWeekStart)), //Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                Week = Utility.GetWeekCountFor52Weeks(Utility.ConvertToDateTime(d.Last().Date),
                    thisYearCompanyFinancialWeekStart),
                WeekString = Utility.ConvertToDateTime(d.Last().Date).Year + " " + Utility
                                 .GetWeekCountFor52Weeks(Utility.ConvertToDateTime(d.FirstOrDefault().Date), thisYearCompanyFinancialWeekStart),
                OutsideTraffic = d.Sum(v => v.OutsideTraffic),
                ValueIn = d.Sum(v => v.ValueIn),
                ValueOut = d.Sum(v => v.ValueOut),
                TurnInRate = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : d.Sum(v => v.OutsideTraffic) == 0
                        ? 100
                        : Math.Round(
                            (double)d.Sum(v => v.ValueIn) * 100 /
                            (double)(d.Sum(v => v.ValueIn) + d.Sum(v => v.OutsideTraffic)), 2),

                //visit duration
                LessThan15mins = d.Sum(v => v.ValueIn) -
                                 (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0) - (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0),
                Between15Till30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                LargerThan30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                SubTotal = d.Sum(v => v.ValueIn),

                //returning customer
                NewCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.NewCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                WeeklyCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.WeeklyCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,


                //Sales
                TransactionCount = d.Sum(v => v.TransactionCount),
                SalesAmount = d.Sum(v => v.SalesAmount),
                AverageAmount = d.Sum(v => v.AverageAmount),
                SalesConversion = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : Math.Round((double)(d.Sum(v => v.TransactionCount) / (double)d.Sum(v => v.ValueIn) * 100), 2)

            }).OrderBy(o => o.Week).ToList();

            return weeklyTrend;
        }

        public WeeklyDataViewModel CalculateWeeklyTrendByBranch(List<BranchSummaryDailyReportViewModel> branchDailyRawData,
            DateTime startd, DayOfWeek firstDayOfWeek, FinancialYearVM fse, bool twoYearWorth = false)
        {
            var vm = new WeeklyDataViewModel();
            DateTime thisYearCompanyFinancialWeekStart = fse.ThisYear.FinancialStartDate;
            DateTime thisYearCompanyFinancialWeekEnd = fse.ThisYear.FinancialEndDate;
            var startdYear = startd.Year;
            long thisYearTimestamp = Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekStart);
            var thisYearData = branchDailyRawData.Where(d => d.Date >= thisYearTimestamp);
            var thisYearByWeek = thisYearData
                .Where(w => w.Date >= Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekStart) &&
                            w.Date <= Utility.ConvertToTimestamp(thisYearCompanyFinancialWeekEnd))
                .GroupBy(d => new
                {
                    BranchID = d.BranchId,
                    DateTime = Utility.GetWeekCount(Utility.ConvertToDateTime(d.Date),
                    thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek)
                });

            if (twoYearWorth)
            {
                DateTime lastYearCompanyFinancialWeekStart = fse.LastYear.FinancialStartDate;
                DateTime lastYearCompanyFinancialWeekEnd = fse.LastYear.FinancialEndDate;
                long LastYearTimestamp = Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekStart);
                var lastYearData =
                    branchDailyRawData.Where(d => d.Date >= LastYearTimestamp && d.Date < thisYearTimestamp);
                var lastYearByWeek = lastYearData
                    .Where(w => w.Date >= Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekStart) &&
                                w.Date <= Utility.ConvertToTimestamp(lastYearCompanyFinancialWeekEnd))
                    .GroupBy(d => new
                    {
                        BranchID = d.BranchId,
                        DateTime = Utility.GetWeekCount(Utility.ConvertToDateTime(d.Date),
                    lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day, firstDayOfWeek)
                    });

                vm.LastYear = lastYearByWeek.Select(d => new WeeklyData()
                {
                    BranchName = d.FirstOrDefault().BranchName,
                    BranchCode = d.FirstOrDefault().BranchCode,
                    BranchId = d.FirstOrDefault().BranchId,
                    Timestamp = d.FirstOrDefault().Date,
                    Date = Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                    Week = Utility.GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                        lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day, firstDayOfWeek),
                    WeekString = Utility.ConvertToDateTime(d.FirstOrDefault().Date).Year + " " + Utility
                                     .GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                                         lastYearCompanyFinancialWeekStart.Month, lastYearCompanyFinancialWeekStart.Day,
                                         firstDayOfWeek).ToString(),
                    OutsideTraffic = d.Sum(v => v.OutsideTraffic),
                    ValueIn = d.Sum(v => v.ValueIn),
                    ValueOut = d.Sum(v => v.ValueOut),
                    TurnInRate = d.Sum(v => v.ValueIn) == 0
                        ? 0
                        : d.Sum(v => v.OutsideTraffic) == 0
                            ? 100
                            : Math.Round(
                                (double)d.Sum(v => v.ValueIn) * 100 /
                                (d.Sum(v => v.ValueIn) + d.Sum(v => v.OutsideTraffic)), 2),

                    //visit duration
                    LessThan15mins = d.Sum(v => v.ValueIn) -
                                     (d.Sum(v => v.OutsideTraffic) > 0
                                         ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                            d.Sum(v => v.OverWifiCount)) > 0
                                             ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                                      (d.Sum(v => v.FifteenMinWifiCount) +
                                                       d.Sum(v => v.ThirteenMinWifiCount) +
                                                       d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                                             : 0
                                         : 0) - (d.Sum(v => v.OutsideTraffic) > 0
                                         ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                            d.Sum(v => v.OverWifiCount)) > 0
                                             ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                                      (d.Sum(v => v.FifteenMinWifiCount) +
                                                       d.Sum(v => v.ThirteenMinWifiCount) +
                                                       d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                                             : 0
                                         : 0),
                    Between15Till30mins = d.Sum(v => v.OutsideTraffic) > 0
                        ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                           d.Sum(v => v.OverWifiCount)) > 0
                            ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                     (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                      d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    LargerThan30mins = d.Sum(v => v.OutsideTraffic) > 0
                        ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                           d.Sum(v => v.OverWifiCount)) > 0
                            ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                     (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                      d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    SubTotal = d.Sum(v => v.ValueIn),

                    //returning customer
                    NewCustomer = d.Sum(v => v.OutsideTraffic) > 0
                        ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                            ? (int)(d.Sum(v => v.NewCustomer) * 1.0 /
                                     (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                      ) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,
                    WeeklyCustomer = d.Sum(v => v.OutsideTraffic) > 0
                        ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                            ? (int)(d.Sum(v => v.WeeklyCustomer) * 1.0 /
                                     (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                      ) * d.Sum(v => v.ValueIn))
                            : 0
                        : 0,

                    //Sales
                    TransactionCount = d.Sum(v => v.TransactionCount),
                    SalesAmount = d.Sum(v => v.SalesAmount),
                    AverageAmount = d.Sum(v => v.AverageAmount),
                    SalesConversion = d.Sum(v => v.ValueIn) == 0
                        ? 0
                        : Math.Round((double)(d.Sum(v => v.TransactionCount) / (double)d.Sum(v => v.ValueIn) * 100),
                            2)

                })
                .OrderBy(o => o.Week)
                .ThenBy(o => o.BranchId)
                .ToList();
            }

            vm.ThisYear = thisYearByWeek.Select(d => new WeeklyData()
            {
                BranchName = d.FirstOrDefault().BranchName,
                BranchCode = d.FirstOrDefault().BranchCode,
                BranchId = d.FirstOrDefault().BranchId,
                Timestamp = d.FirstOrDefault().Date,
                Date = Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                Week = Utility.GetWeekCount(Utility.ConvertToDateTime(d.Last().Date),
                    thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day, firstDayOfWeek),
                WeekString = Utility.ConvertToDateTime(d.Last().Date).Year + " " + Utility
                                 .GetWeekCount(Utility.ConvertToDateTime(d.FirstOrDefault().Date),
                                     thisYearCompanyFinancialWeekStart.Month, thisYearCompanyFinancialWeekStart.Day,
                                     firstDayOfWeek).ToString(),
                OutsideTraffic = d.Sum(v => v.OutsideTraffic),
                ValueIn = d.Sum(v => v.ValueIn),
                ValueOut = d.Sum(v => v.ValueOut),
                TurnInRate = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : d.Sum(v => v.OutsideTraffic) == 0
                        ? 100
                        : Math.Round(
                            (double)d.Sum(v => v.ValueIn) * 100 /
                            (double)(d.Sum(v => v.ValueIn) + d.Sum(v => v.OutsideTraffic)), 2),

                //visit duration
                LessThan15mins = d.Sum(v => v.ValueIn) -
                                 (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0) - (d.Sum(v => v.OutsideTraffic) > 0
                                     ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                        d.Sum(v => v.OverWifiCount)) > 0
                                         ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                                  (d.Sum(v => v.FifteenMinWifiCount) +
                                                   d.Sum(v => v.ThirteenMinWifiCount) + d.Sum(v => v.OverWifiCount)) *
                                                  d.Sum(v => v.ValueIn))
                                         : 0
                                     : 0),
                Between15Till30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.ThirteenMinWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                LargerThan30mins = d.Sum(v => v.OutsideTraffic) > 0
                    ? (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                       d.Sum(v => v.OverWifiCount)) > 0
                        ? (int)(d.Sum(v => v.OverWifiCount) * 1.0 /
                                 (d.Sum(v => v.FifteenMinWifiCount) + d.Sum(v => v.ThirteenMinWifiCount) +
                                  d.Sum(v => v.OverWifiCount)) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                SubTotal = d.Sum(v => v.ValueIn),

                //returning customer
                NewCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.NewCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,
                WeeklyCustomer = d.Sum(v => v.OutsideTraffic) > 0
                    ? d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer) > 0
                        ? (int)(d.Sum(v => v.WeeklyCustomer) * 1.0 /
                                 (d.Sum(v => v.NewCustomer) + d.Sum(v => v.WeeklyCustomer)
                                  ) * d.Sum(v => v.ValueIn))
                        : 0
                    : 0,


                //Sales
                TransactionCount = d.Sum(v => v.TransactionCount),
                SalesAmount = d.Sum(v => v.SalesAmount),
                AverageAmount = d.Sum(v => v.AverageAmount),
                SalesConversion = d.Sum(v => v.ValueIn) == 0
                    ? 0
                    : Math.Round((double)(d.Sum(v => v.TransactionCount) / (double)d.Sum(v => v.ValueIn) * 100), 2)

            })
            .OrderBy(o => o.Week)
            .ThenBy(o => o.BranchId)
            .ToList();

            return vm;

        }
    }
}