namespace RetailCamControlPanel
{
    using Newtonsoft.Json;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Charting;
    using Telerik.Reporting.Drawing;
    using Helper;
    using Telerik.Reporting.Expressions;

    /// <summary>
    /// Summary description for Report1.
    /// </summary>
    public partial class FirmwareUpgradeAnalysis : Telerik.Reporting.Report
    {
        public FirmwareUpgradeAnalysis()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void FirmwareUpgradeAnalysis_NeedDataSource(object sender, EventArgs e)
        {
            var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;
            var startDate = Report.Parameters["Date"].Value.ToString();
            //var cameraVersion = Report.Parameters["CameraVersion"].Value.ToString();
            //var reportShow = Report.Parameters["ReportShow"].Value;
            var currentIndex = Report.Parameters["CurrentIndex"].Value;
            var cameraIDs = Report.Parameters["CameraIDs"].Value;
            List<long> cameraIDList = new List<long>();
            //DateTime dt = Convert.ToDateTime(dateDay); //for testing date string
            DateTime dt = new DateTime();
            dt = DateTime.ParseExact(startDate, "dd/MM/yyyy", CultureInfo.InvariantCulture);

            //int numberOfReportShowing = Convert.ToInt32(reportShow);
            if (cameraIDs != null)
            {
                IEnumerable cameraIE = cameraIDs as IEnumerable;
                foreach (var item in cameraIE)
                {
                    long cameraID = (long)item;
                    cameraIDList.Add(cameraID);
                }
            }

            if (currentIndex != null)
            {
                int index = Convert.ToInt32(currentIndex);

                if (cameraIDList.Count >= (index + 10))
                {
                    cameraIDList = cameraIDList.GetRange(index, 10);
                }
                else if(cameraIDList.Count >= index)
                {
                    cameraIDList = cameraIDList.GetRange(index, cameraIDList.Count - index);
                }
            }

            //var firmwareUpgradeAnalysisReportData = ffcompositeServices.GetCameraFirmwareAnalyticsReport(dt, cameraVersion, numberOfReportShowing).ToList();
            var firmwareUpgradeAnalysisReportData = ffcompositeServices.GetCameraFirmwareAnalyticsReport(cameraIDList, dt).ToList();
            var firmwareUpgradeAnalysisGraphData = ffcompositeServices.GetCameraFirmwareAnalyticsGraph(cameraIDList, dt).ToList();
            //var filteredCounterSerial = firmwareUpgradeAnalysisReportData.Select(x => x.CounterSerial).ToList();
            //var firmwareUpgradeAnalysisGraphData = ffcompositeServices.GetCameraFirmwareAnalyticsGraph(dt, cameraVersion, filteredCounterSerial).ToList();

            //Data obtaining - Checking if data exists
            if (firmwareUpgradeAnalysisReportData.Count > 0)
            {
                errorBox.Visible = false;
				reportTitle.Value = LanguageTitle.Title_FirmwareUpgradeAnalysis;
                dayDate.Value = startDate;

                //Fill in table data source
                tableFirmwareUpgradeAnalysis.DataSource = firmwareUpgradeAnalysisReportData;


                //Plot Graph
                PlotBarLineGraph(graphFirmwareUpgradeAnalysis, firmwareUpgradeAnalysisGraphData);


            }
            else
            {
                lineMiddleDays.Visible = false;
                reportTitle.Visible = false;
                dayDate.Visible = false;
                graphFirmwareUpgradeAnalysis.Visible = false;
                tableFirmwareUpgradeAnalysis.Visible = false;
                errorBox.Value = FirmwareUpgradeAnalysisReportViewer.FirmwareUpgradeAnalysisReportViewer_NoDataYet;
            }

        }

        private void PlotBarLineGraph(Graph reportGraphName, IEnumerable<FirmwareUpgradeAnalysisGraphViewModel> graphFirmwareUpgradeAnalysis)
        {
            string font = "Calibri Light";
            Random rnd = new Random();

			reportGraphName.Name = FirmwareUpgradeAnalysisReportViewer.FirmwareUpgradeAnalysisReportViewer_Title;
			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = graphFirmwareUpgradeAnalysis;

            //Create the category group
            var DateSectionCategoryGroup = new GraphGroup();
            DateSectionCategoryGroup.Name = "categoryGroup";
            DateSectionCategoryGroup.Groupings.Add(new Grouping("=Fields.DateStr"));
            reportGraphName.CategoryGroups.Add(DateSectionCategoryGroup);

            // The SeriesGroups hierarchy defines the series at runtime
            var CounterSerialSectionSeriesGroup = new GraphGroup();
            CounterSerialSectionSeriesGroup.Name = "seriesGroup";
            CounterSerialSectionSeriesGroup.Groupings.Add(new Grouping("=Fields.CounterSerial"));
            //  SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(Series2));
            reportGraphName.SeriesGroups.Add(CounterSerialSectionSeriesGroup);

            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            graphAxisCategoryScale.Scale = new CategoryScale();
			graphAxisCategoryScale.Title = LanguageDateTime.DateTime_Date;
            graphAxisCategoryScale.LabelAngle = 270;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;



            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale5 = new GraphAxis();
            graphAxisNumericalScale5.Name = "Y Axis";
            graphAxisNumericalScale5.Scale = new NumericalScale();
            graphAxisNumericalScale5.Title = FirmwareUpgradeAnalysisReportViewer.FirmwareUpgradeAnalysisReportViewer_NoofVisitor;
            graphAxisNumericalScale5.Style.Font.Name = font;
            graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale5.Style.LineColor = Color.White;



            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
            cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
            // cartesianCoordinateSystem.YAxis.LabelFormat = "#0k";
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

            LineSeries lineSeries = new LineSeries();
            lineSeries.CategoryGroup = DateSectionCategoryGroup;
            lineSeries.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries.LegendItem.Value = "=Fields.BranchCounterName";
            lineSeries.SeriesGroup = CounterSerialSectionSeriesGroup;
            lineSeries.Y = "=Fields.VisitorTotal";
            lineSeries.LineStyle.LineStyle = LineStyle.Solid;
            lineSeries.ToolTip.Text = "=Fields.BranchCounterName";
            reportGraphName.Legend.Position = GraphItemPosition.BottomCenter;
            reportGraphName.Series.Add(lineSeries);
        }

    }
}