namespace RetailCamControlPanel
{
    using RetailCamControlPanel.Enums;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using Helper;
    using System.Threading;
    using System.Data.Entity;

    /// <summary>
    /// Summary description for MallDailyReport.
    /// </summary>
    public partial class MallDailyReport : Telerik.Reporting.Report
    {
        double locationY = 0;
        List<Crosstab> crossTabList = new List<Crosstab>();

        public MallDailyReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void MallDailyReport_NeedDataSource(object sender, EventArgs e)
        {

            #region DefaultSettings
            string font = Utility.Telerik_GetDefaultFontName();
            #endregion


            #region Services
            //services
            var compositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var branchService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var branchHourlyService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var cameraHourlyService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            var cameraService = MvcApplication.container.GetInstance<FFCameraService>();
            var corridorService = MvcApplication.container.GetInstance<FFCorridorService>();
            var areaService = MvcApplication.container.GetInstance<AreaService>();
            var areaConfigService = MvcApplication.container.GetInstance<AreaConfigurationService>();
            var cameraLineService = MvcApplication.container.GetInstance<CameraLineSettingService>();
            #endregion

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                compositeService.checkIfArialUnicodeInstalled();
                //Start date
                var startDate = Report.Parameters["Date"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();

                var language = Report.Parameters["Language"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                var dateFormat = 1;


                DateTime selectedDate = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    selectedDate = DateTime.ParseExact(startDate, "dd/MM/yyyy", culture);
                }
                else
                {
                    selectedDate = DateTime.ParseExact(startDate, "MM/dd/yyyy", culture);
                    dateFormat = 2;

                }
                DayOfWeek dow = selectedDate.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);


                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var store = Report.Parameters["Stores"].Value.ToString();
                var storeId = Convert.ToInt64(Report.Parameters["BranchID"].Value);
                var userRole = Report.Parameters["userRole"].Value.ToString();

                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                //get daily branch data
                var branchDailyRaw = compositeService.GetBranchSummaryReport(selectedDate.AddDays(-29), selectedDate, branchId: storeId, userRole: userRole);
                var todayData = branchDailyRaw.Where(w => w.ValueDateTime == selectedDate || w.ValueDateTime == selectedDate.AddDays(-7)).ToList();

                var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
                var operatingHours = ffBranchOperatingHourService.GetStoreOperatingHour(storeId).Where(x => x.isDayOff == false && x.Day == (int)dow).ToList();
                var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
                var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(Convert.ToInt64(Convert.ToDecimal(storeId))).FirstOrDefault(x => x.Date == selectedDate);

                titleDailyOverview_txt.Value = MallDailyReportViewer.MallDailyReportViewer_DailyOverview.ToUpper();
                titleHourlyTrend_txt.Value = MallDailyReportViewer.MallDailyReportViewer_HourlyTrend.ToUpper();
                titleLast30DaysTrend_txt.Value = MallDailyReportViewer.MallDailyReportViewer_Last30DaysTrend.ToUpper();
                titleHourlyDataPerAreaTag_txt.Value = MallDailyReportViewer.MallDailyReportViewer_HourlyDataPerAreaTag.ToUpper();
                hourlyTrafficPerZoneTitle.Value = MallDailyReportViewer.MallDailyReportViewer_HourlyTrafficPerZone.ToUpper();
                hourlyFootfallPerAreaTitle.Value = MallDailyReportViewer.MallDailyReportViewer_HourlyFootfallPerArea.ToUpper();
                totalVisitorsTitle.Value = MallDailyReportViewer.MallDailyReportViewer_TotalVisitors;
                visitorDurationTitle.Value = MallDailyReportViewer.MallDailyReportViewer_VisitDuration;
                returningCustomerTitle.Value = MallDailyReportViewer.MallDailyReportViewer_ReturningCustomer;
                peakHourTitle.Value = MallDailyReportViewer.MallDailyReportViewer_PeakHour;


                tooltipDailyOverview_txt.Value = MallDailyReportViewer.MallDailyReportViewer_Tooltips_MallDailyOverview;
                tooltipHourlyTrend_txt.Value = MallDailyReportViewer.MallDailyReportViewer_Tooltips_MallHourlyTrend;
                tooltipLast30DaysTrend_txt.Value = MallDailyReportViewer.MallDailyReportViewer_Tooltips_Last30DaysTrend;
                tooltipHourlyDataPerAreaTag_txt.Value = MallDailyReportViewer.MallDailyReportViewer_Tooltips_HourlyDataPerAreaTag;

                //DEFAULT VISIBLE
                hourlyFootfallPerAreaSectionPanel.Visible = false;
                hourlyTrafficPerZoneSectionPanel.Visible = false;

                if ((branchDailyRaw.Count == 0 || branchDailyRaw == null || todayData.Count == 0 || todayData == null || operatingHours.Count == 0) && specialOperatingHour == null || specialOperatingHour != null && specialOperatingHour.isDayOff == true)
                {

                    todaysHourlyFootfallTrendSectionPanel.Visible = false;
                    hourlyFootfallPerAreaSectionPanel.Visible = false;
                    hourlyFootfallPerCorridorSectionPanel.Visible = false;
                    shoppingMallOverviewSectionPanel.Visible = false;
                    dailyFootfallTrendSectionPanel.Visible = false;

                    if (operatingHours.Count == 0 && specialOperatingHour == null || specialOperatingHour != null && specialOperatingHour.isDayOff == true)
                    {
                        errorBox.Value = "ERR101";
                    }
                    else
                    {
                        errorBox.Value = "ERR105";
                    }

                    errorMessage.Visible = true;

                    errorMessage.Value = LanguageOthers.Others_ReportIsNotAvailable;

                }
                else
                {
                    errorMessage.Visible = false;
                    errorBox.Visible = false;

                    dailyFootfallTrendSectionPanel.Visible = true;
                    todaysHourlyFootfallTrendSectionPanel.Visible = true;
                    shoppingMallOverviewSectionPanel.Visible = true;
                    //Bind UI
                    reportTitle.Value = (store == "")
                      ? companyName.ToUpper() + " " + MallDailyReportViewer.MallDailyReportViewer_DailyReport.ToUpper() + " "
                      : store.ToUpper() + " " + MallDailyReportViewer.MallDailyReportViewer_DailyReport.ToUpper() +
                        " ";
                    dayDate.Value = day + " " + startDate;
                    //HardCode UI
                    //ToolTip.Location = new PointU(new Unit(2.20, UnitType.Inch), new Unit(0.71, UnitType.Inch));
                    //ToolTip2.Location = new PointU(new Unit(2.35, UnitType.Inch), new Unit(2.18, UnitType.Inch));
                    //ToolTip3.Location = new PointU(new Unit(2.8, UnitType.Inch), new Unit(4.77, UnitType.Inch));
                    //ToolTip4.Location = new PointU(new Unit(2.37, UnitType.Inch), new Unit(7.36, UnitType.Inch));
                    //ToolTip5.Location = new PointU(new Unit(1.79, UnitType.Inch), new Unit(8.54, UnitType.Inch));
                    //pictureBox2.Visible = false;

                    #region Pull Data
                    //get daily branch hourly data
                    var branchHourlyRaw = compositeService.GetBranchHourlyReport(selectedDate, null, branchId: storeId, scReport: false, userRole: userRole).Where(w => w.ValueDateTime.Date == selectedDate).ToList();

                    //get camerahourly data for corridor
                    var tmrDate = selectedDate.AddDays(1);
                    var cameraHourlyRaw = cameraHourlyService.GetCameraHourlyValues(w => w.ValueDateTime >= selectedDate && w.ValueDateTime < tmrDate && w.Camera.BranchId == storeId).ToList();


                    #endregion



                    #region Data Massage
                    //Top matric calculation of the day and diff
                    var mallDailyData = branchService.CalculateMatricData(todayData, false);

                    //Group hourly data into respective hour
                    var hourlyReportDataWithInOperatingHour = branchHourlyService.GetDataInOperatingHour(branchHourlyRaw);

                    //Get Highest Value Footfall Hour
                    var peakHourData = hourlyReportDataWithInOperatingHour.OrderByDescending(o => o.ValueIn).FirstOrDefault();

                    //Get 30 Daily Trend Footfall
                    var dailyFootfallTrend = branchService.CalculateDailyTrend(branchDailyRaw, selectedDate).ThisYear.Select(S => new BranchSummaryDailyReportViewModel
                    {
                        ValueIn = S.ValueIn,
                        DateString = S.DateTime.ToString("dd/MM") + " (" + S.DateTime.ToString("ddd") + ")"
                    }).ToList();

                    var filteredCameraHourlyOperatingHours = compositeService.FilterCameraHourlyOperatingHours(cameraHourlyRaw, selectedDate, storeId);

                    //Get Camera Hourly data within operating hours
                    var mallCameraHourlyWithinOperatingHours = filteredCameraHourlyOperatingHours.Where(w => w.Camera.FFCorridors.Count() != 0).ToList();
                    //Get Corridor for selected branch
                    var corridors = corridorService.GetMany(w => w.BranchId == storeId).OrderBy(o => o.Name).ToList();

                    List<CorridorCameraViewModel> corridorData = new List<CorridorCameraViewModel>();

                    //All counter Data based on corridor
                    foreach (var corridor in corridors)
                    {
                        var tempData = mallCameraHourlyWithinOperatingHours.Where(w => w.Camera.FFCorridors.Any(c => c.Id == corridor.Id) && w.Camera.BranchId == storeId).GroupBy(g => g.ValueDateTime).Select(s => new CorridorCameraViewModel
                        {
                            ValueDateTime = s.Key,
                            ValueIn = s.Sum(v => v.ValueIn),
                            ValueOut = s.Sum(v => v.ValueOut),
                            Hour = String.Format("{0:0#}:00", s.Key.Hour),
                            CorridorName = corridor.Name
                        });

                        corridorData.AddRange(tempData);

                    }

                    corridorData.OrderBy(o => o.CorridorName).ThenBy(x => x.ValueDateTime).ToList();

                    //AREA CONFIGURATION [KELVIN]
                    //List<AreaConfigurationHourlyReportViewModel> areaConfigData = new List<AreaConfigurationHourlyReportViewModel>();

                    //var areas = areaService.GetMany(w => w.BranchId == storeId && w.IsDeleted == false);

                    //var areaConfigList = areaConfigService.GetMany(w => w.Area.BranchId == storeId && w.IsDeleted == false).OrderBy(o => o.AreaId);

                    //var cameraLineList = cameraLineService.GetMany(w => w.Camera.BranchId == storeId && w.IsDeleted == false);

                    ////foreach (var area in areas)
                    ////{
                    ////    var tempData = mallCameraHourlyWithinOperatingHours
                    ////        .Join(
                    ////            cameraLineList,
                    ////            mchv => mchv.CameraId,
                    ////            cls => cls.CameraId,
                    ////            (mchv, cls) => new { HourlyValue = mchv, CameraListSet = cls })
                    ////        .Join(
                    ////            area.AreaConfigurationSettings,
                    ////            cs => cs.CameraListSet.ID,
                    ////            acs => acs.CameraLineId,
                    ////            (cs, acs) => new { cs.HourlyValue, cs.CameraListSet, AreaConfigSet = acs })
                    ////        .Select(c => new AreaConfigurationHourlyReportViewModel
                    ////        {
                    ////            ValueDateTime = c.HourlyValue.ValueDateTime,
                    ////            AreaId = c.AreaConfigSet.AreaId,
                    ////            AreaName = c.AreaConfigSet.Area.Name,
                    ////            CameraId = c.CameraListSet.CameraId,
                    ////            Hour = c.HourlyValue.ValueDateTime.Hour + ":00",
                    ////            ValueIn = c.HourlyValue.ValueIn,
                    ////            ValueOut = c.HourlyValue.ValueOut
                    ////        });


                    ////    areaConfigData.AddRange(tempData);
                    ////}

                    //foreach (var area in areas)
                    //{
                    //    var tempData = mallCameraHourlyWithinOperatingHours
                    //       .Join(
                    //           cameraLineList,
                    //           mchv => mchv.CameraId,
                    //           cls => cls.CameraId,
                    //           (mchv, cls) => new { HourlyValue = mchv, CameraListSet = cls })
                    //       .Join(
                    //           area.AreaConfigurationSettings,
                    //           cs => cs.CameraListSet.ID,
                    //           acs => acs.CameraLineId,
                    //           (cs, acs) => new { cs.HourlyValue, cs.CameraListSet, AreaConfigSet = acs })
                    //       .GroupBy(g => new { g.HourlyValue.ValueDateTime, g.AreaConfigSet.AreaId })
                    //       .Select(c => new AreaConfigurationHourlyReportViewModel
                    //       {
                    //           ValueDateTime = c.Key.ValueDateTime,
                    //           AreaId = c.Key.AreaId,
                    //           AreaName = c.FirstOrDefault().AreaConfigSet.Area.Name,
                    //           CameraId = c.FirstOrDefault().CameraListSet.CameraId,
                    //           Hour = String.Format("{0:0#}:00", c.Key.ValueDateTime.Hour),
                    //           ValueIn = c.Where(w => w.AreaConfigSet.IsInLine == true).Sum(v => v.HourlyValue.ValueIn),
                    //           ValueOut = c.Where(w => w.AreaConfigSet.IsInLine == false).Sum(v => v.HourlyValue.ValueOut)
                    //       });


                    //    areaConfigData.AddRange(tempData);
                    //}



                    #endregion

                    #region Data Binding
                    //top matric
                    overviewTable.DataSource = mallDailyData;
                    TelerikUtility.PlotAreaGraph_NoAxes(graphTotalVisitor.ToString(), graphTotalVisitor, hourlyReportDataWithInOperatingHour, "=Fields.Hour", "=Fields.ValueIn");
                    peakHourValue.Value = peakHourData != null ? peakHourData.Hour : "-";
                    peakHourFootfall.Value = peakHourData != null ? peakHourData.ValueIn.ToString("#,##0") : "-";
                    reportTitle.Style.Font.Name = font;
                    totalVisitorsTitle.Style.Font.Name = font;
                    visitorDurationTitle.Style.Font.Name = font;
                    returningCustomerTitle.Style.Font.Name = font;
                    peakHourTitle.Style.Font.Name = font;

                    var maxValueIn = hourlyReportDataWithInOperatingHour.Count != 0 ? hourlyReportDataWithInOperatingHour.Max(s => s.ValueIn) : 0;
                    var minValueIn = hourlyReportDataWithInOperatingHour.Count != 0 ? hourlyReportDataWithInOperatingHour.Min(s => s.ValueIn) : 0;

                    var denominator = TelerikUtility.CheckValueDenominator(minValueIn, maxValueIn);
                    var FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    var graphTodayHourlyFootfallDataSource = hourlyReportDataWithInOperatingHour.Select(S => new BranchSummaryHourlyReportViewModel
                    {
                        ValueInDouble = (double)S.ValueIn / denominator,
                        Hour = S.Hour
                    }).ToList();

                    //Today Hourly Footfall Trend
                    TelerikUtility.PlotBarGraph_Default(graphTodayHourlyFootfall.ToString(), graphTodayHourlyFootfall, graphTodayHourlyFootfallDataSource, "=Fields.Hour", MallDailyReportViewer.MallDailyReportViewer_Hour, "=Fields.ValueInDouble", MallDailyReportViewer.MallDailyReportViewer_NoofVisitor, font, FormatString, 0);

                    maxValueIn = dailyFootfallTrend.Max(s => s.ValueIn);
                    minValueIn = dailyFootfallTrend.Min(s => s.ValueIn);

                    denominator = TelerikUtility.CheckValueDenominator(minValueIn, maxValueIn);
                    FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    var graphDailyFootfallDataSource = dailyFootfallTrend.Select(S => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)S.ValueIn / denominator,
                        DateString = S.DateString
                    }).ToList();

                    //30 days Daily Footfall Trend
                    TelerikUtility.PlotBarGraph_Default(graphDailyFootfall.ToString(), graphDailyFootfall, graphDailyFootfallDataSource, "=Fields.DateString", MallDailyReportViewer.MallDailyReportViewer_Date, "=Fields.ValueInDouble", MallDailyReportViewer.MallDailyReportViewer_NoofVisitor, font, FormatString, 315);



                    //Today Hourly Corridor Footfall Counter
                    if (corridorData.Count() != 0)
                    {
                        //if(corridorData.GroupBy(g => g.Hour).Select(s => s.Key).Count() > 13)
                        //{
                        //    textBox9.Width = Unit.Cm(0.8);
                        //    textBox7.Width = Unit.Cm(0.8);
                        //}
                        //else
                        //{
                        //    textBox9.Width = Unit.Cm(1.0);
                        //    textBox7.Width = Unit.Cm(1.0);
                        //}
                        //crossTabHourlyFootfall.DataSource = corridorData;
                        int numOfCorridor = corridors.Count;
                        var corridorList = corridorData.OrderBy(x => x.CorridorName).Select(x => x.CorridorName).Distinct();
                        var operatingHourList = corridorData.OrderBy(x => x.Hour).Select(x => x.Hour).Distinct();
                        int numOfOperatingHour = operatingHourList.Count();
                        int appendCount = 1;

                        double yPosition = 2.5;

                        for (int i = 0; i < numOfOperatingHour; i = i + 8)
                        {
                            if (numOfOperatingHour - i >= 8)
                            {
                                var subOperatingHourList = operatingHourList.Skip(i).Take(8);
                                var subCorridorData = corridorData.Where(x => subOperatingHourList.Contains(x.Hour)).ToList();
                                if (appendCount != 1)
                                {
                                    yPosition += 1.25 + (0.4 * numOfCorridor);
                                }
                                crossTabList.Add(PlotCrossTab(subCorridorData, appendCount, yPosition));
                                appendCount++;

                            }
                            else
                            {
                                int leftNumber = numOfOperatingHour - i;
                                var subOperatingHourList = operatingHourList.Skip(i).Take(leftNumber);
                                var subCorridorData = corridorData.Where(x => subOperatingHourList.Contains(x.Hour)).ToList();
                                if (appendCount != 1)
                                {
                                    yPosition += 1.25 + (0.4 * numOfCorridor);
                                }
                                crossTabList.Add(PlotCrossTab(subCorridorData, appendCount, yPosition));
                            }
                        }
                        for (int i = 0; i < crossTabList.Count; i++)
                        {
                            hourlyFootfallPerCorridorSectionPanel.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
                            crossTabList[i]
                        });
                        }
                        hourlyFootfallPerCorridorSectionPanel.Visible = true;
                    }
                    else
                    {
                        hourlyFootfallPerCorridorSectionPanel.Visible = false;
                    }


                    //AREA CONFIGURATION [KELVIN]
                    //List<Crosstab> areaConfigCrossTabList = new List<Crosstab>();

                    //if (areaConfigData.Count() != 0)
                    //{
                    //    var areaList = areaConfigData.OrderBy(x => x.AreaId).Select(x => x.AreaName).Distinct();
                    //    var operatingHourList = areaConfigData.OrderBy(x => x.Hour).Select(x => x.Hour).Distinct();
                    //    int areaCount = areaList.Count();
                    //    int numOfOperatingHour = operatingHourList.Count();
                    //    int appendCount = 1;

                    //    double yPosition = 1.5;
                    //    for (int i = 0; i < numOfOperatingHour; i = i + 8)
                    //    {
                    //        if (numOfOperatingHour - i >= 8)
                    //        {
                    //            var subOperatingHourList = operatingHourList.Skip(i).Take(8);
                    //            var subAreaConfigData = areaConfigData.Where(x => subOperatingHourList.Contains(x.Hour)).ToList();
                    //            if (appendCount != 1)
                    //            {
                    //                yPosition += 1.5 + (0.4 * areaCount);
                    //            }
                    //            var newCrossTab = PlotCrossTabAreaConfig(subAreaConfigData, appendCount, yPosition);
                    //            areaConfigCrossTabList.Add(newCrossTab);
                    //            appendCount++;
                    //        }
                    //        else
                    //        {
                    //            int leftNumber = numOfOperatingHour - i;
                    //            var subOperatingHourList = operatingHourList.Skip(i).Take(leftNumber);
                    //            var subAreaConfigData = areaConfigData.Where(x => subOperatingHourList.Contains(x.Hour)).ToList();
                    //            if (appendCount != 1)
                    //            {
                    //                yPosition += 1.5 + (0.4 * areaCount);
                    //            }
                    //            var newCrossTab = PlotCrossTabAreaConfig(subAreaConfigData, appendCount, yPosition);
                    //            areaConfigCrossTabList.Add(newCrossTab);
                    //        }
                    //    }
                    //    for (int i = 0; i < areaConfigCrossTabList.Count; i++)
                    //    {
                    //        hourlyFootfallPerAreaSectionPanel.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
                    //        areaConfigCrossTabList[i]
                    //    });
                    //    }
                    //    hourlyFootfallPerAreaSectionPanel.Visible = true;
                    //}
                    //else
                    //{
                    //    hourlyFootfallPerAreaSectionPanel.Visible = false;
                    //}
                    #endregion
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        //public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup, string font)
        //{
        //    //Data plotting - Traffic Profile Weekday
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = dataList;

        //    //Create the category group
        //    var categoryGroup = new GraphGroup();
        //    categoryGroup.Name = "categoryGroup";
        //    categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(categoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var seriesGroup = new GraphGroup();
        //    seriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(seriesGroup);

        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Style.Visible = false;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale = new GraphAxis();
        //    graphAxisNumericalScale.Name = "Y Axis";
        //    graphAxisNumericalScale.Scale = new NumericalScale();
        //    graphAxisNumericalScale.Style.Visible = false;
        //    graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

        //    //The Graph Series area
        //    var areaGraph = new AreaSeries();
        //    areaGraph.CategoryGroup = categoryGroup;
        //    areaGraph.CoordinateSystem = cartesianCoordinateSystem;
        //    areaGraph.LegendItem.Style.Visible = false;
        //    areaGraph.SeriesGroup = seriesGroup;
        //    areaGraph.Y = yAxisGroup;
        //    reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    reportGraphName.Series.Add(areaGraph);

        //    return reportGraphName;
        //}

        //public Graph PlotBarLineGraphHourly(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup,/*string yAxisGroup2,*/ string font)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale(); graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
        //    //graphAxisCategoryScale2.Style.Font.Name = font;
        //    //graphAxisCategoryScale2.TitleStyle.Font.Name = font;
        //    //graphAxisCategoryScale2.Style.Visible = false;
        //    //graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    //graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.LabelFormat = "{0:N0}";
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.Scale = new NumericalScale();
        //    graphAxisNumericalScale5.Title = MallDailyReportViewer.MallDailyReportViewer_NoofVisitor;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    //graphAxisNumericalScale5.TitleStyle.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;
        //    //Setup 2nd Graph Axis with Numerical Scale
        //    //var graphAxisNumericalScale6 = new GraphAxis();
        //    //graphAxisNumericalScale6.Name = "Y Axis 2";
        //    //graphAxisNumericalScale6.Scale = new NumericalScale();
        //    //graphAxisNumericalScale6.Title = MallDailyReportViewer.MallDailyReportViewer_SalesConversion + " (%)";
        //    //graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    //graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    //graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    //graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    //graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    //// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    //graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    //graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
        //    //graphAxisNumericalScale6.Style.Font.Name = font;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    //cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    //cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 0;

        //    //var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    //cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    //cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    //cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    //cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    //reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = MallDailyReportViewer.MallDailyReportViewer_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    reportGraphName.Series.Add(barSeries1);
        //    reportGraphName.Legend.Style.Font.Name = font;
        //    reportGraphName.Legend.Position = GraphItemPosition.TopRight;
        //    barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, "{0:N0}");

        //    //The Line Series area
        //    //var lineSeries1 = new LineSeries();
        //    //lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    //lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    //lineSeries1.LegendItem.Value = MallDailyReportViewer.MallDailyReportViewer_SalesConversion + " (%)";
        //    //lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    //lineSeries1.Y = yAxisGroup2;
        //    //lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //    //reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    //reportGraphName.Series.Add(lineSeries1);
        //    //lineSeries1.ColorPalette = new ColorPalette(Color.Black);

        //    return reportGraphName;
        //}

        //public Graph PlotBarLineGraphDaily(string graphName, Graph reportGraphName, List<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, /*string yAxisGroup2,*/ string font)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
        //    graphAxisCategoryScale.TitleStyle.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale();
        //    graphAxisCategoryScale2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    //graphAxisCategoryScale2.Style.Font.Name = font;
        //    //graphAxisCategoryScale2.TitleStyle.Font.Name = font;
        //    //graphAxisCategoryScale2.Style.Visible = false;
        //    //graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    //graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.LabelFormat = "{0:N0}";
        //    graphAxisNumericalScale5.Scale = new NumericalScale();
        //    graphAxisNumericalScale5.Title = MallDailyReportViewer.MallDailyReportViewer_NoofVisitor;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    //graphAxisNumericalScale5.TitleStyle.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;
        //    //Setup 2nd Graph Axis with Numerical Scale
        //    //var graphAxisNumericalScale6 = new GraphAxis();
        //    //graphAxisNumericalScale6.Name = "Y Axis 2";
        //    //graphAxisNumericalScale6.Scale = new NumericalScale();
        //    //graphAxisNumericalScale6.Title = MallDailyReportViewer.MallDailyReportViewer_SalesConversion + " (%)";
        //    //graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    //graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    //graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    //graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    //graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    //// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    //graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    //graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
        //    //graphAxisNumericalScale6.Style.Font.Name = font;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    //cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    //cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 315;

        //    //var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    //cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    //cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    //cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    //cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    //reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = MallDailyReportViewer.MallDailyReportViewer_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    reportGraphName.Series.Add(barSeries1);
        //    reportGraphName.Legend.Style.Font.Name = font;
        //    reportGraphName.Legend.Position = GraphItemPosition.TopRight;
        //    barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, "{0:N0}");

        //    //The Line Series area
        //    //var lineSeries1 = new LineSeries();
        //    //lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    //lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    //lineSeries1.LegendItem.Value = MallDailyReportViewer.MallDailyReportViewer_SalesConversion + " (%)";
        //    //lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    //lineSeries1.Y = yAxisGroup2;
        //    //lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //    //reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    //reportGraphName.Series.Add(lineSeries1);
        //    //lineSeries1.ColorPalette = new ColorPalette(Color.Black);

        //    return reportGraphName;
        //}

        public Crosstab PlotCrossTab(List<CorridorCameraViewModel> source, int appendCount, double yPosition)
        {
            string font = Utility.Telerik_GetDefaultFontName();
            Crosstab ct = new Crosstab();

            //Table groups
            TableGroup tg1 = new TableGroup();
            TableGroup tg2 = new TableGroup();
            TableGroup tg3 = new TableGroup();
            TableGroup tg4 = new TableGroup();
            TableGroup tg5 = new TableGroup();
            TableGroup tg6 = new TableGroup();
            TableGroup tg7 = new TableGroup();

            Telerik.Reporting.TextBox valueInTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox valueOutTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox hourTitleTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox emptyTextBox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox hourlyTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox lineInTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox lineOutTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox corridorNameTextbox = new Telerik.Reporting.TextBox();

            // 
            // hourlyFootfallPerAreaCrossTab
            // 
            ct.Anchoring = ((Telerik.Reporting.AnchoringStyles)((Telerik.Reporting.AnchoringStyles.Top | Telerik.Reporting.AnchoringStyles.Left)));
            ct.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(0.84999996423721313D)));
            ct.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(0.84999996423721313D)));
            ct.Body.Rows.Add(new Telerik.Reporting.TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D)));
            ct.Body.SetCellContent(0, 0, valueInTextbox);
            ct.Body.SetCellContent(0, 1, valueOutTextbox);
            tg1.Name = "group1";
            tg2.ChildGroups.Add(tg1);
            tg2.Name = "group3";
            tg2.ReportItem = lineInTextbox;
            tg3.Name = "group2";
            tg4.ChildGroups.Add(tg3);
            tg4.Name = "group4";
            tg4.ReportItem = lineOutTextbox;
            tg5.ChildGroups.Add(tg2);
            tg5.ChildGroups.Add(tg4);
            tg5.Groupings.Add(new Telerik.Reporting.Grouping("= Fields.Hour"));
            tg5.Name = "Hour";
            tg5.ReportItem = hourlyTextbox;
            ct.ColumnGroups.Add(tg5);
            ct.ColumnHeadersPrintOnEveryPage = true;
            ct.Corner.SetCellContent(0, 0, hourTitleTextbox);
            ct.Corner.SetCellContent(1, 0, emptyTextBox);
            ct.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
            hourTitleTextbox,
            emptyTextBox,
            valueInTextbox,
            valueOutTextbox,
            hourlyTextbox,
            lineInTextbox,
            lineOutTextbox,
            corridorNameTextbox});
            ct.KeepTogether = true;
            ct.Location = new Telerik.Reporting.Drawing.PointU(Telerik.Reporting.Drawing.Unit.Cm(0.2D), Telerik.Reporting.Drawing.Unit.Cm(yPosition));
            ct.Name = "HourlyCorridorCrossTab" + appendCount.ToString();
            tg6.Name = "group";
            tg7.ChildGroups.Add(tg6);
            tg7.Groupings.Add(new Telerik.Reporting.Grouping("=Fields.CorridorName"));
            tg7.Name = "corridorName";
            tg7.ReportItem = corridorNameTextbox;
            tg7.Sortings.Add(new Telerik.Reporting.Sorting("=Fields.CorridorName", Telerik.Reporting.SortDirection.Asc));
            ct.RowGroups.Add(tg7);
            ct.RowHeadersPrintOnEveryPage = true;
            ct.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(3.9500000476837158D), Telerik.Reporting.Drawing.Unit.Cm(1.1999999284744263D));
            ct.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            ct.Style.Font.Name = "Arial Unicode MS";
            ct.Style.Visible = true;
            ct.StyleName = "Normal.TableNormal";
            // 
            // valueInTextbox
            // 
            valueInTextbox.Format = "{0:N0}";
            valueInTextbox.KeepTogether = true;
            valueInTextbox.Name = "valueInTextbox";
            valueInTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            valueInTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            valueInTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            valueInTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueInTextbox.Style.Font.Name = "Arial Unicode MS";
            valueInTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            valueInTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueInTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            valueInTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            valueInTextbox.StyleName = "Normal.TableBody";
            valueInTextbox.Value = "=Sum(Fields.ValueIn)";
            // 
            // valueOutTextbox
            // 
            valueOutTextbox.Format = "{0:N0}";
            valueOutTextbox.Name = "valueOutTextbox";
            valueOutTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            valueOutTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            valueOutTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            valueOutTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueOutTextbox.Style.Font.Name = "Arial Unicode MS";
            valueOutTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            valueOutTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueOutTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            valueOutTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            valueOutTextbox.StyleName = "Normal.TableBody";
            valueOutTextbox.Value = "=Sum(Fields.ValueOut)";
            // 
            // hourTitleTextbox
            // 
            hourTitleTextbox.Name = "hourTitleTextbox";
            hourTitleTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.25D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            hourTitleTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            hourTitleTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            hourTitleTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourTitleTextbox.Style.Font.Bold = true;
            hourTitleTextbox.Style.Font.Name = "Arial Unicode MS";
            hourTitleTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            hourTitleTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourTitleTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;
            hourTitleTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            hourTitleTextbox.StyleName = "Normal.TableGroup";
            hourTitleTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_Hour;
            // 
            // emptyTextBox
            // 
            emptyTextBox.Name = "emptyTextBox";
            emptyTextBox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.2500002384185791D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            emptyTextBox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            emptyTextBox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            emptyTextBox.Style.Font.Name = "Arial Unicode MS";
            emptyTextBox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            emptyTextBox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            emptyTextBox.StyleName = "";
            emptyTextBox.Value = "";
            // 
            // hourlyTextbox
            // 
            hourlyTextbox.Name = "hourlyTextbox";
            hourlyTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.8D), Telerik.Reporting.Drawing.Unit.Cm(0.39999997615814209D));
            hourlyTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            hourlyTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            hourlyTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourlyTextbox.Style.Font.Bold = true;
            hourlyTextbox.Style.Font.Name = "Arial Unicode MS";
            hourlyTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            hourlyTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourlyTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            hourlyTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            hourlyTextbox.StyleName = "Normal.TableGroup";
            hourlyTextbox.Value = "= Fields.Hour";
            // 
            // lineInTextbox
            // 
            lineInTextbox.Name = "lineInTextbox";
            lineInTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            lineInTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            lineInTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            lineInTextbox.Style.Font.Name = "Arial Unicode MS";
            lineInTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            lineInTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            lineInTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            lineInTextbox.StyleName = "";
			lineInTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_In;
            // 
            // lineOutTextbox
            // 
            lineOutTextbox.Name = "lineOutTextbox";
            lineOutTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            lineOutTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            lineOutTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            lineOutTextbox.Style.Font.Name = "Arial Unicode MS";
            lineOutTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            lineOutTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            lineOutTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            lineOutTextbox.StyleName = "";
            lineOutTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_Out;
			// 
			// corridorNameTextbox
			// 
			corridorNameTextbox.Name = "corridorNameTextbox";
            corridorNameTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.2500004768371582D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            corridorNameTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            corridorNameTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            corridorNameTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            corridorNameTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            corridorNameTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            corridorNameTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;
            corridorNameTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            corridorNameTextbox.TextWrap = false;
            corridorNameTextbox.StyleName = "";
            corridorNameTextbox.Value = "=Fields.CorridorName";

            ct.DataSource = source;
            return ct;
        }

        public Crosstab PlotCrossTabAreaConfig(List<AreaConfigurationHourlyReportViewModel> source, int appendCount, double yPosition)
        {
            string font = Utility.Telerik_GetDefaultFontName();
            Crosstab ct = new Crosstab();

            //Table groups
            TableGroup tg1 = new TableGroup();
            TableGroup tg2 = new TableGroup();
            TableGroup tg3 = new TableGroup();
            TableGroup tg4 = new TableGroup();
            TableGroup tg5 = new TableGroup();
            TableGroup tg6 = new TableGroup();
            TableGroup tg7 = new TableGroup();

            Telerik.Reporting.TextBox valueInTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox valueOutTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox hourTitleTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox emptyTextBox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox hourlyTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox lineInTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox lineOutTextbox = new Telerik.Reporting.TextBox();
            Telerik.Reporting.TextBox areaNameTextbox = new Telerik.Reporting.TextBox();

            // 
            // hourlyFootfallPerAreaCrossTab
            // 
            ct.Anchoring = ((Telerik.Reporting.AnchoringStyles)((Telerik.Reporting.AnchoringStyles.Top | Telerik.Reporting.AnchoringStyles.Left)));
            ct.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(0.84999996423721313D)));
            ct.Body.Columns.Add(new Telerik.Reporting.TableBodyColumn(Telerik.Reporting.Drawing.Unit.Cm(0.84999996423721313D)));
            ct.Body.Rows.Add(new Telerik.Reporting.TableBodyRow(Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D)));
            ct.Body.SetCellContent(0, 0, valueInTextbox);
            ct.Body.SetCellContent(0, 1, valueOutTextbox);
            tg1.Name = "group1";
            tg2.ChildGroups.Add(tg1);
            tg2.Name = "group3";
            tg2.ReportItem = lineInTextbox;
            tg3.Name = "group2";
            tg4.ChildGroups.Add(tg3);
            tg4.Name = "group4";
            tg4.ReportItem = lineOutTextbox;
            tg5.ChildGroups.Add(tg2);
            tg5.ChildGroups.Add(tg4);
            tg5.Groupings.Add(new Telerik.Reporting.Grouping("= Fields.Hour"));
            tg5.Name = "Hour";
            tg5.ReportItem = hourlyTextbox;
            ct.ColumnGroups.Add(tg5);
            ct.ColumnHeadersPrintOnEveryPage = true;
            ct.Corner.SetCellContent(0, 0, hourTitleTextbox);
            ct.Corner.SetCellContent(1, 0, emptyTextBox);
            ct.Items.AddRange(new Telerik.Reporting.ReportItemBase[] {
            hourTitleTextbox,
            emptyTextBox,
            valueInTextbox,
            valueOutTextbox,
            hourlyTextbox,
            lineInTextbox,
            lineOutTextbox,
            areaNameTextbox});
            ct.KeepTogether = true;
            ct.Location = new Telerik.Reporting.Drawing.PointU(Telerik.Reporting.Drawing.Unit.Cm(0.2D), Telerik.Reporting.Drawing.Unit.Cm(yPosition));
            ct.Name = "AreaConfigCrossTab" + appendCount.ToString();
            tg6.Name = "group";
            tg7.ChildGroups.Add(tg6);
            tg7.Groupings.Add(new Telerik.Reporting.Grouping("=Fields.AreaName"));
            tg7.Name = "areaName";
            tg7.ReportItem = areaNameTextbox;
            tg7.Sortings.Add(new Telerik.Reporting.Sorting("=Fields.AreaName", Telerik.Reporting.SortDirection.Asc));
            ct.RowGroups.Add(tg7);
            ct.RowHeadersPrintOnEveryPage = true;
            ct.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(3.9500000476837158D), Telerik.Reporting.Drawing.Unit.Cm(1.1999999284744263D));
            ct.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            ct.Style.Font.Name = "Arial Unicode MS";
            ct.Style.Visible = true;
            ct.StyleName = "Normal.TableNormal";
            // 
            // valueInTextbox
            // 
            valueInTextbox.Format = "{0:N0}";
            valueInTextbox.KeepTogether = true;
            valueInTextbox.Name = "valueInTextbox";
            valueInTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            valueInTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            valueInTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            valueInTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueInTextbox.Style.Font.Name = "Arial Unicode MS";
            valueInTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            valueInTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueInTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            valueInTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            valueInTextbox.StyleName = "Normal.TableBody";
            valueInTextbox.Value = "=Sum(Fields.ValueIn)";
            // 
            // valueOutTextbox
            // 
            valueOutTextbox.Format = "{0:N0}";
            valueOutTextbox.Name = "valueOutTextbox";
            valueOutTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            valueOutTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            valueOutTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            valueOutTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueOutTextbox.Style.Font.Name = "Arial Unicode MS";
            valueOutTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            valueOutTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            valueOutTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            valueOutTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            valueOutTextbox.StyleName = "Normal.TableBody";
            valueOutTextbox.Value = "=Sum(Fields.ValueOut)";
            // 
            // hourTitleTextbox
            // 
            hourTitleTextbox.Name = "hourTitleTextbox";
            hourTitleTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.25D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            hourTitleTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            hourTitleTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            hourTitleTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourTitleTextbox.Style.Font.Bold = true;
            hourTitleTextbox.Style.Font.Name = "Arial Unicode MS";
            hourTitleTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            hourTitleTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourTitleTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;
            hourTitleTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            hourTitleTextbox.StyleName = "Normal.TableGroup";
			hourTitleTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_Hour;
            // 
            // emptyTextBox
            // 
            emptyTextBox.Name = "emptyTextBox";
            emptyTextBox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.2500002384185791D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            emptyTextBox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            emptyTextBox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            emptyTextBox.Style.Font.Name = "Arial Unicode MS";
            emptyTextBox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            emptyTextBox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            emptyTextBox.StyleName = "";
            emptyTextBox.Value = "";
            // 
            // hourlyTextbox
            // 
            hourlyTextbox.Name = "hourlyTextbox";
            hourlyTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(1.8D), Telerik.Reporting.Drawing.Unit.Cm(0.39999997615814209D));
            hourlyTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            hourlyTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            hourlyTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourlyTextbox.Style.Font.Bold = true;
            hourlyTextbox.Style.Font.Name = "Arial Unicode MS";
            hourlyTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            hourlyTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            hourlyTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            hourlyTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            hourlyTextbox.StyleName = "Normal.TableGroup";
            hourlyTextbox.Value = "= Fields.Hour";
            // 
            // lineInTextbox
            // 
            lineInTextbox.Name = "lineInTextbox";
            lineInTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            lineInTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            lineInTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            lineInTextbox.Style.Font.Name = "Arial Unicode MS";
            lineInTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            lineInTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            lineInTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            lineInTextbox.StyleName = "";
            lineInTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_In.ToUpper();
            // 
            // lineOutTextbox
            // 
            lineOutTextbox.Name = "lineOutTextbox";
            lineOutTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(0.9D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            lineOutTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            lineOutTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            lineOutTextbox.Style.Font.Name = "Arial Unicode MS";
            lineOutTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            lineOutTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Center;
            lineOutTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            lineOutTextbox.StyleName = "";
            lineOutTextbox.Value = MallDailyReportViewer.MallDailyReportViewer_Out.ToUpper();
            // 
            // areaNameTextbox
            // 
            areaNameTextbox.Name = "areaNameTextbox";
            areaNameTextbox.Size = new Telerik.Reporting.Drawing.SizeU(Telerik.Reporting.Drawing.Unit.Cm(2.2500004768371582D), Telerik.Reporting.Drawing.Unit.Cm(0.40000000596046448D));
            areaNameTextbox.Style.BorderColor.Default = System.Drawing.Color.FromArgb(((int)(((byte)(120)))), ((int)(((byte)(124)))), ((int)(((byte)(130)))));
            areaNameTextbox.Style.BorderStyle.Default = Telerik.Reporting.Drawing.BorderType.Solid;
            areaNameTextbox.Style.Color = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            areaNameTextbox.Style.Font.Size = Telerik.Reporting.Drawing.Unit.Point(7D);
            areaNameTextbox.Style.LineColor = System.Drawing.Color.FromArgb(((int)(((byte)(73)))), ((int)(((byte)(75)))), ((int)(((byte)(75)))));
            areaNameTextbox.Style.TextAlign = Telerik.Reporting.Drawing.HorizontalAlign.Left;
            areaNameTextbox.Style.VerticalAlign = Telerik.Reporting.Drawing.VerticalAlign.Middle;
            areaNameTextbox.TextWrap = false;
            areaNameTextbox.StyleName = "";
            areaNameTextbox.Value = "=Fields.AreaName";

            ct.DataSource = source;
            return ct;
        }
    }
}