namespace RetailCamControlPanel
{
    //extern alias language;
    //using language1 = language::RetailCamControlPanel.Resources;
    using language1 = Language.Resources;
    using RetailCamControlPanel.Controllers;
    using RetailCamControlPanel.Enums;
    using RetailCamControlPanel.Helper;
    using RetailCamControlPanel.Models;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using System.Threading;

    /// <summary>
    /// Summary description for MallMonthlyReport.
    /// </summary>
    public partial class MallMonthlyReport : Telerik.Reporting.Report
    {
        public MallMonthlyReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }
        private void MallMonthlyReport_NeedDataSource(object sender, EventArgs e)
        {
            #region DefaultSettings
            string font = Utility.Telerik_GetDefaultFontName();
            #endregion


            #region Services
            //services
            var compositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var branchService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var branchHourlyService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var cameraHourlyService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            var cameraService = MvcApplication.container.GetInstance<FFCameraService>();
            var corridorService = MvcApplication.container.GetInstance<FFCorridorService>();
            var branchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var reportSummaryDailyService = MvcApplication.container.GetInstance<FFReportSummaryDailyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            var footfallCamController = MvcApplication.container.GetInstance<FootfallCamController>();
            #endregion
            
            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                compositeService.checkIfArialUnicodeInstalled();

                //Start date
                var month = Report.Parameters["Month"].Value.ToString();


                var language = Report.Parameters["Language"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                DateTime startDate = new DateTime();
                startDate = DateTime.ParseExact(month, "MMMM yyyy", culture);
                long startDateTimestamp = Utility.ConvertToTimestamp(startDate);
                long startDateLastYearTimestamp = Utility.ConvertToTimestamp(startDate.AddYears(-1));
                var daysInTheMonth = DateTime.DaysInMonth(startDate.Year, startDate.Month);
                DateTime endDate = new DateTime(startDate.Year, startDate.Month, daysInTheMonth);
                long endDateTimestamp = Utility.ConvertToTimestamp(endDate);
                long endDateLastYearTimestamp = Utility.ConvertToTimestamp(endDate.AddYears(-1));

                DateTime startDateLastMonth = new DateTime();
                startDateLastMonth = DateTime.ParseExact(month, "MMMM yyyy", culture).AddMonths(-1);
                var daysInLastMonth = DateTime.DaysInMonth(startDateLastMonth.Year, startDateLastMonth.Month);
                DateTime endDateLastMonth = new DateTime(startDateLastMonth.Year, startDateLastMonth.Month, daysInLastMonth);

                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var store = Report.Parameters["Stores"].Value.ToString();
                var storeId = Convert.ToInt64(Report.Parameters["BranchID"].Value);
                var userRole = Report.Parameters["userRole"].Value.ToString();

                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                DateTime thisYearEndDate = startDate.AddMonths(1).AddDays(-1);
                DateTime lastYearMonthStartDate = startDate.AddYears(-1);
                DateTime lastYearMonthEndDate = lastYearMonthStartDate.AddMonths(1).AddDays(-1);

                DateTime lastYearStartDate = lastYearMonthStartDate.AddMonths(-11);

                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.Company.CompanyCode == companyCode);
                var financialStartEnd = footfallCamController.GetFinancialWeekList(startDate, companySetting);

                //Determine First Day of the Week based on Company Setting
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                ////get daily branch data
                var rawData = compositeService.GetBranchSummaryReport(lastYearStartDate, thisYearEndDate, branchId: storeId, userRole: userRole);
                var branchDailyRaw = rawData.Where(w => w.ValueDateTime >= startDate && w.ValueDateTime <= endDate).ToList();
                var branchDailyRawLastMonth = rawData.Where(w => w.ValueDateTime >= startDateLastMonth && w.ValueDateTime <= endDateLastMonth).ToList();

                shoppingMallOverviewSection.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_MonthlyOverview.ToUpper();
                titleMonthlyTrend_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Last12Months.ToUpper();
                monthlyTrafficCountersSection.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_MonthlyTrafficCounters.ToUpper();
                monthlyTrafficCorridorsSection.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_MonthlyDataPerAreaTag.ToUpper();
                totalVisitorsTitle.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_TotalVisitors;
                visitorDurationTitle.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_VisitDuration;
                titleReturningCustomer_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_ReturningCustomer;
                titlePeakDay_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_PeakDate;
                counterTableHeader1.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Counter;
                counterTableHeader2.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_AreaTag;
                rankTableHeader1.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Rank;
                rankTableHeader2.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Rank;
                changesPTableHeader1.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_ChangesPercentage;
                changesPTableHeader2.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_ChangesPercentage;


                tooltipMonthlyOverview_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Tooltip_MonthlyOverview;
                tooltipLast12Months_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Tooltip_MonthlyTrend;
                tooltipMonthlyDataPerAreaTag_txt.Value = MallMonthlyReportViewer.MallMonthlyReportViewer_Tooltip_MonthlyDataPerAreaTag;


                panel2.Visible = false;
                if (branchDailyRaw.Count == 0 || branchDailyRaw == null)
                {
                    componentAppearance(false);
                    errorBox.Value = "ERR106";


                    errorMessage.Visible = true;
                    errorMessage.Value = LanguageOthers.Others_ReportIsNotAvailable;

                    shoppingMallOverviewSection.Visible = false;

                }
                else
                {

                    componentAppearance(true);
                    //Bind UI
                    reportTitle.Value = (store == "")
                      ? companyName.ToUpper() + " " + " " + LanguageTitle.Title_MonthlyReport.ToUpper() + " "
                      : store.ToUpper() + " " + LanguageTitle.Title_MonthlyReport.ToUpper() +
                        " ";
                    monthTb.Value = month;


                    //Get Corridor for selected branch
                    var corridorCameras = cameraService.GetAllCamerasByBranchId(storeId).Where(x => x.FFCorridors.Count >= 1).Select(x => new
                                          CorridorCameraViewModel
                    {
                        CameraId = x.ID,
                        CorridorList = x.FFCorridors.ToList()
                    }).ToList();
                    var isCorridor = corridorCameras.Count > 0 ? true : false;

                    //Get Entrance for selected branch
                    var entraceCameras = cameraService.GetAllCamerasByBranchId(storeId).ToList();
                    var isEntrace = entraceCameras.Count > 0 ? true : false;

                    //Combination of entrace and corridor camera
                    var allCameraIds = corridorCameras.Select(x => x.CameraId).Union(entraceCameras.Select(x => x.ID)).ToList();

                    //Get counting of camera
                    var reportSummaryDailies = reportSummaryDailyService.GetMany(x => allCameraIds.Contains(x.CameraId) && x.Date >= startDateTimestamp && x.Date <= endDateTimestamp).ToList();
                    var reportSummaryDailiesLastYear = reportSummaryDailyService.GetMany(x => allCameraIds.Contains(x.CameraId) && x.Date >= startDateLastYearTimestamp && x.Date <= endDateLastYearTimestamp).ToList();

                    #region Data Massage
                    //Entrance Ranking Data
                    var entraceRankingData = reportSummaryDailyService.GetEntraceOrCorridorRanking(reportSummaryDailies, reportSummaryDailiesLastYear, "entrance", entraceCameras, null);
                    //Corridor Ranking Data
                    var corridorRankingData = reportSummaryDailyService.GetEntraceOrCorridorRanking(reportSummaryDailies, reportSummaryDailiesLastYear, "corridor", null, corridorCameras);
                    //Top matric calculation of the month and diff
                    var topMatricData = branchSummaryDailyReportService.GetTopMatricMallMonthly(branchDailyRaw, branchDailyRawLastMonth, entraceRankingData, corridorRankingData);

                    //Last 12 Months Graph
                    var monthlyData = branchSummaryDailyReportService.CalculateMonthlyTrend(branchDailyRawData: rawData, startDate: startDate, firstDayOfWeek: firstDayOfWeek, fse: financialStartEnd, companySetting: companySetting, twoYearWorth: true);
                    var monthlyDataRearranged = branchSummaryDailyReportService.Rearrange(monthlyData);

                    long monthlyMaxValue = monthlyDataRearranged.Max(m => m.ValueIn > m.LastValuein ? m.ValueIn : m.LastValuein);
                    long monthlyMinValue = monthlyDataRearranged.Min(m => m.ValueIn < m.LastValuein ? m.ValueIn : m.LastValuein);
                    long denominatorMonthly = TelerikUtility.CheckValueDenominator(monthlyMaxValue, monthlyMinValue);
                    string monthlyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorMonthly);

                    var mainGraphData = monthlyDataRearranged.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorMonthly,
                        LastValueinDouble = (double)s.LastValuein / denominatorMonthly,
                        Month = Utility.getLanguagePageName(s.Month.Substring(0, 3), language) + s.Month.Substring(3)
                    });
                    #endregion

                    #region Data Binding
                    errorBox.Visible = false;
                    errorMessage.Visible = false;
                    overviewTable.DataSource = topMatricData;
                    TelerikUtility.PlotAreaGraph_NoAxes(graphTotalVisitor.ToString(), graphTotalVisitor, branchDailyRaw, "=Fields.Date", "=Fields.ValueIn");
                    tbCurrentMonthYear.Value = startDate.ToString("MMMM yyyy");
                    tbCurrentMonthYear2.Value = startDate.ToString("MMMM yyyy");
                    tbLastMonthYear.Value = startDate.AddYears(-1).ToString("MMMM yyyy");
                    tbLastMonthYear2.Value = startDate.AddYears(-1).ToString("MMMM yyyy");

                    //Monthly Trend
                    TelerikUtility.PlotBarLineGraph_1YAxisLabel(last12Months_barLineGraph.ToString(), last12Months_barLineGraph,
                        mainGraphData, "=Fields.Month", "Month",
                        MallMonthlyReportViewer.MallMonthlyReportViewer_NoofVisitor, "=Fields.ValueInDouble", MallMonthlyReportViewer.MallMonthlyReportViewer_Last12Months,
                        "=Fields.LastValueinDouble", MallMonthlyReportViewer.MallMonthlyReportViewer_LastYearSameMonth,
                        font, monthlyValueFormat);

                    if (isCorridor)
                    {
                        CorridorRankingTable.DataSource = corridorRankingData;
                        CorridorRankingTable.Visible = true;
                    }
                    else
                    {
                        monthlyTrafficCorridorsSection.Visible = false;
                        sectionLine3.Visible = false;
                        CorridorRankingTable.Visible = false;
                    }

                    //if (isEntrace)
                    //{
                    //    EntraceRankingTable.DataSource = entraceRankingData;
                    //    empty_txt.Value = entraceRankingData == null ? "" : entraceRankingData.Select(x => x.EntraceCorridorName).First();
                    //    returningCustomerValue_txt.Value = entraceRankingData == null ? "" : entraceRankingData.Select(x => x.EntraceCorridorCurrentValueIn).First().ToString("#,##0");
                    //    EntraceRankingTable.Visible = true;
                    //    busiestCounterTitle.Visible = true;
                    //    empty_txt.Visible = true;
                    //    returningCustomerValue_txt.Visible = true;
                    //}
                    //else
                    //{
                    //    EntraceRankingTable.Visible = false;
                    //    busiestCounterTitle.Visible = false;
                    //    empty_txt.Visible = false;
                    //    returningCustomerValue_txt.Visible = false;
                    //}
                    #endregion
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        public void componentAppearance(bool isDataAvailable)
        {
            shoppingMallOverviewSection.Visible = isDataAvailable;
            shoppingMallOverviewSection.KeepTogether = false;
            monthlyTrafficCountersSection.Visible = false;
            monthlyTrafficCountersSection.KeepTogether = false;
            monthlyTrafficCorridorsSection.Visible = isDataAvailable;
            monthlyTrafficCorridorsSection.KeepTogether = false;
            overviewTable.Visible = isDataAvailable;
            overviewTable.KeepTogether = false;
            CorridorRankingTable.Visible = isDataAvailable;
            CorridorRankingTable.KeepTogether = false;
            titlePeakDay_txt.Visible = isDataAvailable;
            titlePeakDay_txt.KeepTogether = false;        
            peakDayValue.Visible = isDataAvailable;
            peakDayValue.KeepTogether = false;
            peakDayDate_txt.Visible = isDataAvailable;
            peakDayDate_txt.KeepTogether = false;
            EntraceRankingTable.Visible = isDataAvailable;
            EntraceRankingTable.KeepTogether = false;
            titleReturningCustomer_txt.Visible = isDataAvailable;
            titleReturningCustomer_txt.KeepTogether = false;
            empty_txt.Visible = isDataAvailable;
            empty_txt.KeepTogether = false;
            returningCustomerValue_txt.Visible = isDataAvailable;
            returningCustomerValue_txt.KeepTogether = false;
            tbCurrentMonthYear.Visible = isDataAvailable;
            tbCurrentMonthYear.KeepTogether = false;
            tbCurrentMonthYear2.Visible = isDataAvailable;
            tbCurrentMonthYear2.KeepTogether = false;
            tbLastMonthYear.Visible = isDataAvailable;
            tbLastMonthYear.KeepTogether = false;
            tbLastMonthYear2.Visible = isDataAvailable;
            tbLastMonthYear2.KeepTogether = false;
            reportTitle.Visible = isDataAvailable;
            reportTitle.KeepTogether = false;
            monthTb.Visible = isDataAvailable;
            monthTb.KeepTogether = false;
            sectionLine.Visible = isDataAvailable;
            sectionLine2.Visible = isDataAvailable;
            sectionLine3.Visible = isDataAvailable;
            errorBox.Visible = !isDataAvailable;
            errorMessage.Visible = !isDataAvailable;
            titleMonthlyTrend_txt.Visible = isDataAvailable;

            titlePeakDay_txt.Visible = isDataAvailable;
            peakDayValue.Visible = isDataAvailable;
            peakDayDate_txt.Visible = isDataAvailable;
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0 && !Double.IsInfinity(salesConversion))
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        public static bool IsInfinity(double value)
        {
            if (Double.IsInfinity(value))
            {
                return true;
            }
            return false;
        }

        public static string FormatDouble(double input)
        {
            if (input == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", input);
            }
            else
            {
                return string.Format("{0:N2}",Math.Abs(Math.Round(input, 2)));
            }
        }

        public static string CheckNoData(int input)
        {
            if (input == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", input);
            }
            else
            {
                return string.Format("{0:N0}", input);
            }
        }
    }


}