namespace RetailCamControlPanel
{
    using RetailCamControlPanel.Enums;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using Helper;
    using RetailCamControlPanel.Models;
    using System.Threading;

    /// <summary>
    /// Summary description for MallWeeklyReport.
    /// </summary>
    public partial class MallWeeklyReport : Telerik.Reporting.Report
    {
        double locationY = 0;
        List<Crosstab> crossTabList = new List<Crosstab>();

        public MallWeeklyReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void MallWeeklyReport_NeedDataSource(object sender, EventArgs e)
        {
            #region DefaultSettings
            string font = Utility.Telerik_GetDefaultFontName();
            #endregion

            //VARIABLES
            //Company Settings
            long companyId = 0;

            //Date Settings
            DayOfWeek firstDayOfWeek = new DayOfWeek();
            string[] financialWeek = { "1", "1" };
            DateTime startd = new DateTime();
            DateTime endd = new DateTime();

            #region ===== ADD SERVICE REFERENCES
            //SERVICES
            var ffCompositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffCameraHourlyValueService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            var ffCameraService = MvcApplication.container.GetInstance<FFCameraService>();
            var ffCorridorService = MvcApplication.container.GetInstance<FFCorridorService>();
            var cameraHourlyService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            var companyService = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            #endregion
            
            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //REQUIRED: TO CHECK WHETHER THE CLIENT SERVER HAS THE REQUIRED FONT OR NOT. IF NOT, RCCP WILL AUTO INSTALL
                ffCompositeService.checkIfArialUnicodeInstalled();

                #region ===== OBTAIN & PROCESS DATA FROM FRONT-END

                //OBTAINING DATA PASSED FROM FRONT-END
                var startDateUI = Report.Parameters["Date"].Value.ToString();
                var endDateUI = Report.Parameters["endDate"].Value.ToString();
                var weekNumber = Report.Parameters["Week"].Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);
                var branchName = Report.Parameters["Stores"].Value.ToString();
                var branchId = Convert.ToInt64(Report.Parameters["BranchID"].Value);
                #endregion

                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;


                #region ===== INFO GATHERING
                //Get Required Information for RAW DATA PULLING, DATA AGGREGATION and other usage within the report
                //Company Settings
                var company = companyService.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);
                if (companyCode != "")
                    companyId = companyService.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                //Date Settings
                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                    financialWeek = new string[] { companySetting.FinancialWeekDate };
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                if (dateFormatHtml == "dateFirst")
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", culture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", culture);
                }
                else
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", culture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "MM/dd/yyyy", culture);
                }

                DateTime thisYearCompanyFinancialWeekStart = new DateTime(startd.Year, 1, 1);
                DateTime thisYearCompanyFinancialWeekEnd = new DateTime(startd.Year, 12, 31);

                DateTime lastYearCompanyFinancialWeekStart = new DateTime(startd.Year - 1, 1, 1);
                DateTime lastYearCompanyFinancialWeekEnd = new DateTime(startd.Year - 1, 12, 31);

                DateTime startDate = lastYearCompanyFinancialWeekStart;
                DateTime endDate = thisYearCompanyFinancialWeekEnd;
                DateTime reportEndDate = endd;

                var startdYear = startd.Year;

                var financialStartEnd = Utility.GetFinancialWeekList(startd, companySetting);
                startDate = financialStartEnd.LastYear.FinancialStartDate;
                DateTime lastYearEndDate = financialStartEnd.LastYear.FinancialEndDate;
                endDate = financialStartEnd.ThisYear.FinancialEndDate;

                string startdString = endd.AddDays(-30).ToString("yyyy-MM-dd", culture);
                string enddString = endd.ToString("yyyy-MM-dd", culture);

                var startdd = startd.AddDays(-7);
                var enddd = endd.AddDays(1).AddSeconds(-1);


                #endregion

                #region ===== PULL RAW DATA

                var dailyRawData = ffCompositeService.GetBranchSummaryReport(startDate, reportEndDate, branchId: branchId, scReport: false);

                //2 Weeks worth of data
                var camHourlyRawData = cameraHourlyService.GetCameraHourlyValues(w => w.ValueDateTime >= startdd && w.ValueDateTime <= enddd && w.Camera.BranchId == branchId).ToList();
                #endregion

                #region ===== REPORT (Error Checking, Data Aggregation, Text Binding, Graph Plotting)
                //Check if there is data or not, if yes, start aggregate/populate & generate report
                if (camHourlyRawData.Count == 0 || dailyRawData.Count == 0 || DateTime.Compare(startd, DateTime.Now) > 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    shoppingMallOverviewPanel.Visible = false;
                    weeklyFootfallTrendPanel.Visible = false;
                    dailyFootfallTrendPanel.Visible = false;
                    weeklyTrafficCorridorsPanel.Visible = false;
                    errorBox.Value = "ERR105";
                    errorBox.Visible = true;
                    errorMessage.Visible = true;
                    errorMessage.Value = LanguageOthers.Others_ReportIsNotAvailable;
                }
                else
                {
                    reportTitle.Visible = true;
                    dayDate.Visible = true;
                    shoppingMallOverviewPanel.Visible = true;
                    weeklyFootfallTrendPanel.Visible = true;
                    dailyFootfallTrendPanel.Visible = true;
                    weeklyTrafficCorridorsPanel.Visible = false;
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    var topMatricData = ffBranchSummaryDailyReportService.CalculateMatricData(dailyRawData, true, endd);
                    var topMatricGraph = ffBranchSummaryDailyReportService.GetTopMatricGraphTrend(dailyRawData, startd);

                    var bottomMatricDataWeeklyTrend = ffBranchSummaryDailyReportService.CalculateWeeklyTrend(dailyRawData, startd, firstDayOfWeek, financialStartEnd, true);
                    var bottomMatricDataWeeklyTrendRearrange = ffBranchSummaryDailyReportService.Rearrange(bottomMatricDataWeeklyTrend, startd, firstDayOfWeek);

                    var bottomMatricDataDailyTrend = ffBranchSummaryDailyReportService.CalculateDailyTrend(dailyRawData, endd, true);
                    var bottomMatricDataDailyTrendRearrange = ffBranchSummaryDailyReportService.Rearrange(bottomMatricDataDailyTrend, endd);
                    var dailyTrendData = bottomMatricDataDailyTrendRearrange.Skip(bottomMatricDataDailyTrendRearrange.Count - 7).ToList();

                    //Weekly Trend Denominator
                    long weeklyMax1 = bottomMatricDataWeeklyTrendRearrange.Max(s => s.ValueIn);
                    long weeklyMax2 = bottomMatricDataWeeklyTrendRearrange.Max(s => s.LastValuein);

                    long weeklyMin1 = bottomMatricDataWeeklyTrendRearrange.Min(s => s.ValueIn);
                    long weeklyMin2 = bottomMatricDataWeeklyTrendRearrange.Min(s => s.LastValuein);

                    long denominatorWeekly = TelerikUtility.CheckValueDenominator(weeklyMax1 >= weeklyMax2 ? weeklyMax1 : weeklyMax2, weeklyMin1 >= weeklyMin2 ? weeklyMin1 : weeklyMin2);
                    string weeklyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorWeekly);

                    //Daily Trend Denominator
                    long dailyMax1 = dailyTrendData.Max(s => s.ValueIn);
                    long dailyMax2 = dailyTrendData.Max(s => s.LastValuein);

                    long dailyMin1 = dailyTrendData.Min(s => s.ValueIn);
                    long dailyMin2 = dailyTrendData.Min(s => s.LastValuein);

                    long denominatorDaily = TelerikUtility.CheckValueDenominator(dailyMax1 >= dailyMax2 ? dailyMax1 : dailyMax2, dailyMin1 >= dailyMin2 ? dailyMin1 : dailyMin2);
                    string dailyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorDaily);

                    //Denominated Values for Weekly
                    var weeklyFootfallTrend = bottomMatricDataWeeklyTrendRearrange.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorWeekly,
                        LastValueinDouble = (double)s.LastValuein / denominatorWeekly,
                        Week = s.Week
                    });

                    //Denominated Values for Daily
                    var dailyFootfallTrend = dailyTrendData.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorDaily,
                        LastValueinDouble = (double)s.LastValuein / denominatorDaily,
                        DayOfWeek = s.DayOfWeek
                    });

                    //Corridors
                    var corridors = ffCorridorService.GetMany(w => w.BranchId == branchId).ToList();

                    List<CorridorCameraWeeklyViewModel> corridorData = new List<CorridorCameraWeeklyViewModel>();

                    var camHourlyRawDataLastWeek = camHourlyRawData.Where(w => w.ValueDateTime >= startdd && w.ValueDateTime < startd).ToList();
                    var camHourlyRawDataThisWeek = camHourlyRawData.Where(w => w.ValueDateTime >= startd).ToList();

                    //If have corridors
                    if (corridors.Count > 0)
                    {
                        weeklyTrafficCorridorsPanel.Visible = true;
                        foreach (var corridor in corridors)
                        {
                            var tempData = camHourlyRawDataLastWeek.Where(w => w.Camera.FFCorridors.Any(c => c.Id == corridor.Id) && w.Camera.BranchId == branchId)
                                .GroupBy(g => corridor.Id)
                                .Select(s => new CorridorCameraViewModel
                                {
                                    ValueIn = s.Sum(x => x.ValueIn),
                                    CorridorName = corridor.Name,
                                    CorridorId = corridor.Id
                                })
                                .ToList();

                            var tempData2 = camHourlyRawDataThisWeek.Where(w => w.Camera.FFCorridors.Any(c => c.Id == corridor.Id) && w.Camera.BranchId == branchId)
                                .GroupBy(g => corridor.Id)
                                .Select(s => new CorridorCameraViewModel
                                {
                                    ValueIn = s.Sum(x => x.ValueIn),
                                    CorridorName = corridor.Name,
                                    CorridorId = corridor.Id
                                }).ToList();

                            var combinedData = tempData.Join(tempData2, a => a.CorridorId, b => b.CorridorId, (a, b) => new { data1 = a, data2 = b })
                                .Select(s => new CorridorCameraWeeklyViewModel
                                {
                                    CorridorName = s.data1.CorridorName,
                                    CounterString = corridor.FFCameras.Where(w => w.BranchId == branchId).Select(s1 => s1.CameraName).Aggregate((i, j) => i + ", " + j),
                                    ValueInLastWeek = s.data1.ValueIn,
                                    ValueInThisWeek = s.data2.ValueIn,
                                    Changes = (s.data1.ValueIn == 0 ? 0 : ((double)(s.data2.ValueIn - s.data1.ValueIn) / s.data1.ValueIn) * 100),
                                    hasLastWeekData = (s.data1.ValueIn == 0 ? false : true)
                                }).ToList();

                            corridorData.AddRange(combinedData);
                        }

                        corridorData = corridorData.OrderByDescending(o => o.ValueInThisWeek).ToList();

                        for (int i = 0; i < corridorData.Count; i++)
                        {
                            corridorData[i].Rank = i + 1;
                        }
                    }
                    else
                    {
                        weeklyTrafficCorridorsPanel.Visible = false;
                    }

                    //DATA BINDING
                    dayDate.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + MallWeeklyReportViewer.MallWeeklyReportViewer_Week + " " + weekNumber + ")";
                    reportTitle.Value = branchName.ToUpper() + " " + MallWeeklyReportViewer.MallWeeklyReportViewer_WeeklyReport.ToUpper();
                    titleWeeklyOverview_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_WeeklyOverview.ToUpper();
                    titleWeeklyTrend_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_WeeklyTrend.ToUpper();
                    titleDailyTrend_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_DailyTrend.ToUpper();
                    titleWeeklyDataPerAreaTag_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_WeeklyDataPerAreaTag.ToUpper();
                    totalVisitorsTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_TotalVisitors;
                    visitorDurationTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_VisitDuration;
                    returningCustomerTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_ReturningCustomer;
                    peakDayTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_PeakDay;

                    tooltipWeeklyOverview_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Tooltip_WeeklyOverview;
                    tooltipWeeklyTrend_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Tooltip_WeeklyTrend;
                    tooltipDailyTrend_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Tooltip_DailyTrend;
                    tooltipWeeklyDataPerAreaTag_txt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Tooltip_WeeklyDataPerAreaTag;

                    headerAreaTag_tbtxt.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_AreaTag;
                    rankHeaderTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Rank;
                    thisWeekHeaderTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_ThisWeek;
                    lastWeekHeaderTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_LastWeek;
                    changesHeaderTitle.Value = MallWeeklyReportViewer.MallWeeklyReportViewer_Changes + " (%)";

                    overviewTable.DataSource = topMatricData;
                    TelerikUtility.PlotAreaGraph_NoAxes(graphTotalVisitor.ToString(), graphTotalVisitor, topMatricGraph, "=Fields.ValueDateTime", "=Fields.ValueIn");
                    BranchSummaryDailyReportViewModel peakDayData = topMatricGraph.Single(w => w.ValueIn == topMatricGraph.Max(m => m.ValueIn));
                    peakDayValue.Value = peakDayData.ValueDateTime.ToString("dddd");
                    peakDayFootfall.Value = String.Format("{0:#,##0}", peakDayData.ValueIn);

                    if (corridors.Count > 0)
                        tableWeeklyTrafficCorridors.DataSource = corridorData;

                    TelerikUtility.PlotBarLineGraph_1YAxisLabel(graphWeeklyFootfall.ToString(), graphWeeklyFootfall, weeklyFootfallTrend, "=Fields.Week", MallWeeklyReportViewer.MallWeeklyReportViewer_Week, MallWeeklyReportViewer.MallWeeklyReportViewer_NoofVisitor, "=Fields.ValueInDouble", MallWeeklyReportViewer.MallWeeklyReportViewer_ThisYear, "=Fields.LastValueinDouble", MallWeeklyReportViewer.MallWeeklyReportViewer_LastYear, font, weeklyValueFormat);
                    TelerikUtility.PlotBarLineGraph_1YAxisLabel(graphDailyFootfall.ToString(), graphDailyFootfall, dailyFootfallTrend, "=Fields.DayOfWeek", MallWeeklyReportViewer.MallWeeklyReportViewer_Day, MallWeeklyReportViewer.MallWeeklyReportViewer_NoofVisitor, "=Fields.ValueInDouble", MallWeeklyReportViewer.MallWeeklyReportViewer_ThisYear, "=Fields.LastValueinDouble", MallWeeklyReportViewer.MallWeeklyReportViewer_LastYear, font, dailyValueFormat, xAxisLabelAngle: 0);
                }
                #endregion
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }
        
    }
}