namespace RetailCamControlPanel
{
    using RetailCamControlPanel.Enums;
    //using RetailCamControlPanel.Resources;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using Helper;

    /// <summary>
    /// Summary description for MallDailyReport.
    /// </summary>
    public partial class PathTrackingReport : Telerik.Reporting.Report
    {
        double locationY = 0;
        List<Crosstab> crossTabList = new List<Crosstab>();

        public PathTrackingReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void PathTrackingReport_NeedDataSource(object sender, EventArgs e)
        {

            #region DefaultSettings
            string font = Utility.Telerik_GetDefaultFontName();
            #endregion


            #region Services
            //services
            var compositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var branchService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var branchHourlyService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var cameraHourlyService = MvcApplication.container.GetInstance<FFCameraHourlyValueService>();
            var cameraService = MvcApplication.container.GetInstance<FFCameraService>();
            var corridorService = MvcApplication.container.GetInstance<FFCorridorService>();
            var areaService = MvcApplication.container.GetInstance<AreaService>();
            var areaConfigService = MvcApplication.container.GetInstance<AreaConfigurationService>();
            var cameraLineService = MvcApplication.container.GetInstance<CameraLineSettingService>();
            #endregion

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                compositeService.checkIfArialUnicodeInstalled();

                //Start date
                var startDate = Report.Parameters["Date"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var dateFormat = 1;


                DateTime selectedDate = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    selectedDate = DateTime.ParseExact(startDate, "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    selectedDate = DateTime.ParseExact(startDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    dateFormat = 2;

                }
                DayOfWeek dow = selectedDate.DayOfWeek;
                var day = dow.ToString();
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                var store = Report.Parameters["Stores"].Value.ToString();
                var storeId = Convert.ToInt64(Report.Parameters["BranchID"].Value);
                var camId = Convert.ToInt64(Report.Parameters["CameraId"].Value);



                //get daily branch data


                pathTrackingReportTitle.Value = PathTrackingReportViewer.PathTrackingReportViewer_PathTrackingHourlyTitle.ToUpper();
                pathTrackingTableSection.Value = PathTrackingReportViewer.PathTrackingReportViewer_HourlyDetails.ToUpper();



                #region Pull Data
                //get daily branch hourly data
                //var branchHourlyRaw = compositeService.GetBranchHourlyReport(selectedDate, null, branchId: storeId);

                var tmrDate = selectedDate.AddDays(1);
                var cameraHourlyRaw = cameraHourlyService.GetCameraHourlyValues(w => w.ValueDateTime >= selectedDate && w.ValueDateTime < tmrDate && w.Camera.BranchId == storeId).OrderBy(o => o.ValueDateTime.Hour).ToList();
                #endregion


                if (cameraHourlyRaw.Count == 0)
                {
                    errorBox.Value = PathTrackingReportViewer.PathTrackingReportViewer_NoDataYet;
                    pathTrackingReportTitle.Visible = false;
                    panel1.Visible = false;
                    panel2.Visible = false;

                }
                else
                {
                    //Bind UI
                    reportTitle.Value = (store == "")
                      ? companyName.ToUpper() + " " + PathTrackingReportViewer.PathTrackingReportViewer_DailyReport.ToUpper() + " "
                      : store.ToUpper() + " " + PathTrackingReportViewer.PathTrackingReportViewer_DailyReport.ToUpper() +
                        " ";
                    dayDate.Value = day + " " + startDate;
                    //HardCode UI
                    //ToolTip.Location = new PointU(new Unit(2.20, UnitType.Inch), new Unit(0.71, UnitType.Inch));
                    //ToolTip2.Location = new PointU(new Unit(2.35, UnitType.Inch), new Unit(2.18, UnitType.Inch));
                    //ToolTip3.Location = new PointU(new Unit(2.8, UnitType.Inch), new Unit(4.77, UnitType.Inch));
                    //ToolTip4.Location = new PointU(new Unit(2.37, UnitType.Inch), new Unit(7.36, UnitType.Inch));
                    //ToolTip5.Location = new PointU(new Unit(1.79, UnitType.Inch), new Unit(8.54, UnitType.Inch));
                    //pictureBox2.Visible = false;


                    #region Data Massage
                    long maxValueIn = cameraHourlyRaw.Max(s => s.ValueIn);
                    long minValueIn = cameraHourlyRaw.Min(s => s.ValueIn);
                    long maxValueOut = cameraHourlyRaw.Max(s => s.ValueOut);
                    long minValueOut = cameraHourlyRaw.Min(s => s.ValueOut);

                    var maxValue = maxValueOut > maxValueIn ? maxValueOut : maxValueIn;
                    var minValue = minValueOut < minValueIn ? minValueOut : minValueIn;

                    long denominatorHourly = TelerikUtility.CheckValueDenominator(minValue, maxValue);
                    string hourlyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorHourly);

                    var tableData = cameraHourlyRaw.Where(w => w.CameraId == camId).Select(s => new BranchSummaryHourlyReportViewModel()
                    {
                        ValueIn = s.ValueIn,
                        ValueOut = s.ValueOut,
                        Hour = String.Format("{0:0#}:00", s.ValueDateTime.Hour)
                    }).ToList();

                    var filteredCameraHourlyOperatingHours = cameraHourlyRaw.Where(w => w.CameraId == camId).Select(s => new BranchSummaryHourlyReportViewModel()
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorHourly,
                        ValueOutDouble = (double)s.ValueOut / denominatorHourly,
                        Hour = String.Format("{0:0#}:00", s.ValueDateTime.Hour)
                    }).ToList();

                    #endregion

                    #region Data Binding
                    //top matric
                    reportTitle.Style.Font.Name = font;
                    hourlyDetailCrosstab.DataSource = tableData;

                    PlotLineLineGraph(hourlyTrendGraph.ToString(), hourlyTrendGraph, filteredCameraHourlyOperatingHours, "=Fields.Hour", PathTrackingReportViewer.PathTrackingReportViewer_Hour, "=Fields.ValueInDouble", LanguageOthers.Others_Path1, "=Fields.ValueOutDouble", LanguageOthers.Others_Path2, font, hourlyValueFormat);
                    #endregion
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        public Graph PlotLineLineGraph(string graphName, Graph reportGraph,
            IEnumerable<BranchSummaryHourlyReportViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisName, string yAxisGroup2, string yAxisName2, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            var categoryGroup = new GraphGroup();
            categoryGroup.Name = "categoryGroup";
            categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup = new GraphGroup();
            seriesGroup.Name = "seriesGroup";
            reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            var categoryGroup_X_Axis_1 = new GraphAxis();
            categoryGroup_X_Axis_1.Name = "X Axis";
            categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_1.Title = xAxisName;
            categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            var customNumericScale = new NumericalScale();
            customNumericScale.Minimum = -1d;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            var numbericScale_Y_Axis_1 = new GraphAxis();
            numbericScale_Y_Axis_1.Name = "Y Axis";
            numbericScale_Y_Axis_1.Scale = customNumericScale;
			numbericScale_Y_Axis_1.Title = LanguageOthers.Others_Count;
            numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numbericScale_Y_Axis_1.LabelFormat = format;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_1;
            cartesianCoordinateSystem.YAxis = numbericScale_Y_Axis_1;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //The Line Series area
            //1st Data
            var lineSeries1 = new LineSeries();
            lineSeries1.CategoryGroup = categoryGroup;
            lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries1.LegendItem.Value = yAxisName;
            lineSeries1.SeriesGroup = seriesGroup;
            lineSeries1.Y = yAxisGroup;
            reportGraph.Series.Add(lineSeries1);
            lineSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);

            //The Line Series area
            //2nd Data
            var lineSeries2 = new LineSeries();
            lineSeries2.CategoryGroup = categoryGroup;
            lineSeries2.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries2.LegendItem.Value = yAxisName2;
            lineSeries2.SeriesGroup = seriesGroup;
            lineSeries2.Y = yAxisGroup2;
            lineSeries2.LineStyle.LineStyle = LineStyle.Dashed;
            reportGraph.Series.Add(lineSeries2);
            lineSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);

            reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        public static long CheckValueDenominator(long minValue, long maxValue)
        {
            if (maxValue >= 30000000 || minValue >= 1000000)
                return 10000000;
            else if (maxValue >= 3000 || minValue >= 1000)
                return 1000;
            return 1;
        }

        public static string DenominatedStringFormat(long denominator)
        {
            if (denominator == 1000000)
                return "{0:## ##0M}";
            else if (denominator == 1000)
                return "{0:## ##0k}";
            return "{0:## ##0}";
        }
    }
}