using System.Globalization;
using System.Web.Mvc;
using RetailCamControlPanel.Enums;
using RetailCamControlPanel.Models;
//using RetailCamControlPanel.Resources;
using Telerik.Reporting.Charting;

namespace RetailCamControlPanel
{
	using RetailCamControlPanel.Helper;
	using RetailCamControlPanel.Services.CompositeService;
	using RetailCamControlPanel.Services.SingularService;
	using RetailCamControlPanel.ViewModel;
	using System;
	using System.Collections.Generic;
	using System.Drawing;
	using System.Linq;
	using System.Web.UI.WebControls;
	using Telerik.Reporting;
	using Telerik.Reporting.Drawing;

	/// <summary>
	/// Summary description for Report2.
	/// </summary>
	public partial class PredictiveAnalysisReport : Telerik.Reporting.Report
	{
		public PredictiveAnalysisReport()
		{
			InitializeComponent();
		}

		private void PredictiveAnalysis_NeedDataSource(object sender, EventArgs e)
		{
			var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
			var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
			var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
			var companyServices = MvcApplication.container.GetInstance<CompanyService>();
			var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
			// var branchSummaryDailyReportViewModel = MvcApplication.container.GetInstance<BranchSummaryDailyReportViewModel>();

			//Data obtaining - Company name and date for UI
			var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                var dateHTML = Report.Parameters["Date"].Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var BranchId = Report.Parameters["BranchID"].Value.ToString();
                var stores = Report.Parameters["Stores"].Value.ToString();
                var company = companyServices.GetCompany(MyHelper.CompanyCode);
                string font = Utility.Telerik_GetDefaultFontName();
                var selectedRegion = "";
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                var branchId = 0;
                var twoYearsWorth = false;

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                // DateTime startd = DateTime.ParseExact("04/06/2017", "dd/MM/yyyy", CultureInfo.InvariantCulture);
                //  DateTime endd = DateTime.ParseExact("10/06/2017", "dd/MM/yyyy", CultureInfo.InvariantCulture);

                DateTime startd = new DateTime();
                DateTime endd = new DateTime();

                if (dateFormatHtml == "dateFirst")
                {
                    endd = DateTime.ParseExact(dateHTML.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    endd = DateTime.ParseExact(dateHTML.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                }

                DayOfWeek dow = endd.DayOfWeek;
                var day = dow.ToString();
                var maxDate = endd;
                startd = endd.AddDays(-40);

                var financialStartEnd = GetFinancialWeekList(startd, companySetting);
                DateTime startDate;

                //determine to get years worth of data
                switch (twoYearsWorth)
                {
                    case true:
                        startDate = financialStartEnd.LastYear.FinancialStartDate;
                        break;
                    default:
                        startDate = financialStartEnd.ThisYear.FinancialStartDate;
                        break;
                }

                DateTime endDate = financialStartEnd.ThisYear.FinancialEndDate;

                //Data obtaining
                if (BranchId == null || String.IsNullOrEmpty(BranchId))
                {
                    showInsufficientData();
                    return;
                }
                var dailyRawData = ffBranchSummaryDailyReportService.GetPredictiveAnalyticsData(Convert.ToInt64(BranchId)).ToList();
                var sumPredictedAverage = dailyRawData.Sum(s => s.SalesTarget);

                //Data obtaining - Checking if data exists
                if (dailyRawData.Count == 0 || sumPredictedAverage == 0)
                {
                    showInsufficientData();
                    return;
                }
                else
                {
                    maxDate = dailyRawData.Max(s => Utility.ConvertToDateTime(s.Date));

                    long startTimestamp = Utility.ConvertToTimestamp(maxDate.AddDays(-27));
                    long endTimestamp = Utility.ConvertToTimestamp(maxDate);
                    long halfTimestamp = Utility.ConvertToTimestamp(maxDate.AddDays(-14));

                    errorBox.Visible = false;

                    //Report Header language settings
                    reportTitle.Value = stores.ToUpper() + " " + PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_PredictiveAnalysisReport.ToUpper() + " ";
                    dayDate.Value = day + " " + dateHTML;
                    last14Days.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Last14Days;
                    last14Days2.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Last14Days;
                    next14Days.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Next14Days;
                    next14Days2.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Next14Days;

                    dailyTrend.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_DailyTrend;

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var FormatStringDaily = "{0:##,##0}";
                    var denominatorDaily = 1;

                    //Data plotting - Daily Trend
                    var part1 = dailyRawData.AsReadOnly().Where(s => s.Date >= startTimestamp && s.Date <= halfTimestamp).Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorDaily,
                            DateString = Utility.ConvertToDateTime(s.Date).ToString("ddd dd/MM"),
                            SalesTarget = 0
                        });

                    var part2 = dailyRawData.AsReadOnly().Where(s => s.Date > halfTimestamp && s.Date <= endTimestamp).Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            DateString = Utility.ConvertToDateTime(s.Date).ToString("ddd dd/MM"),
                            SalesTarget = s.SalesTarget
                        });

                    var merged = part1.Union(part2);

                    PlotBarLineGraph(graphSalesConversionDaily.ToString(), graphSalesConversionDaily,
                        merged, "=Fields.DateString", PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Day, "=Fields.ValueInDouble", "=Fields.PredictedAverage", font, FormatStringDaily);

                    last14DaysTable.DataSource = part1.Select(s => new BranchSummaryDailyReportViewModel
                    {
                        DateString = s.DateString,
                        ValueInDouble = s.ValueInDouble
                    });

                    next14DaysTable.DataSource = part2.Select(s => new BranchSummaryDailyReportViewModel
                    {
                        DateString = s.DateString,
                        SalesTarget = s.SalesTarget
                    });

                    shape1.Location = new PointU(new Telerik.Reporting.Drawing.Unit(3.1, Telerik.Reporting.Drawing.UnitType.Inch), new Telerik.Reporting.Drawing.Unit(1.23, Telerik.Reporting.Drawing.UnitType.Inch));
                    last14Days.Location = new PointU(new Telerik.Reporting.Drawing.Unit(2, Telerik.Reporting.Drawing.UnitType.Inch), new Telerik.Reporting.Drawing.Unit(1.25, Telerik.Reporting.Drawing.UnitType.Inch));
                    next14Days.Location = new PointU(new Telerik.Reporting.Drawing.Unit(4.5, Telerik.Reporting.Drawing.UnitType.Inch), new Telerik.Reporting.Drawing.Unit(1.25, Telerik.Reporting.Drawing.UnitType.Inch));
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

		private void showInsufficientData()
		{
			reportTitle.Visible = false;
			dayDate.Visible = false;
			graphSalesConversionDaily.Visible = false;
			shape1.Visible = false;
			last14Days.Visible = false;
			last14DaysTable.Visible = false;
			next14Days.Visible = false;
			next14DaysTable.Visible = false;
			last14Days2.Visible = false;
			next14Days2.Visible = false;
			dailyTrend.Visible = false;
			errorBox.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_InsufficientDataMsg;
		}

		public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font, string format)
		{
			reportGraphName.Name = graphName;
			reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			reportGraphName.Style.Font.Bold = false;
			reportGraphName.Style.Font.Name = font;

			//Setup the SqlDataSource

			reportGraphName.DataSource = graphDataSource;

			//Create the category group
			var SalesConversionSectionCategoryGroup = new GraphGroup();
			SalesConversionSectionCategoryGroup.Name = "categoryGroup";
			SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var SalesConversionSectionSeriesGroup = new GraphGroup();
			SalesConversionSectionSeriesGroup.Name = "seriesGroup";
			//  SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(Series2));
			reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			graphAxisCategoryScale.Scale = new CategoryScale();
			graphAxisCategoryScale.Title = xAxisName;
			graphAxisCategoryScale.Style.Font.Name = font;
			graphAxisCategoryScale.TitleStyle.Font.Name = font;
			graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
			graphAxisCategoryScale.Style.LineColor = Color.White;
			graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			// graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

			var graphAxisCategoryScale2 = new GraphAxis();
			graphAxisCategoryScale2.Name = "X Axis 2";
			graphAxisCategoryScale2.Scale = new CategoryScale();
			graphAxisCategoryScale2.Style.Visible = false;
			graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
			//  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale5 = new GraphAxis();
			graphAxisNumericalScale5.Name = "Y Axis";
			graphAxisNumericalScale5.Scale = new NumericalScale();
			graphAxisNumericalScale5.Title = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_NoofVisitor;
			graphAxisNumericalScale5.Style.Font.Name = font;
			graphAxisNumericalScale5.TitleStyle.Font.Name = font;
			graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale5.Style.LineColor = Color.White;
			graphAxisNumericalScale5.LabelFormat = format;
			//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//Setup 2nd Graph Axis with Numerical Scale
			var graphAxisNumericalScale6 = new GraphAxis();
			graphAxisNumericalScale6.Name = "Y Axis 2";
			graphAxisNumericalScale6.Scale = new NumericalScale();
			graphAxisNumericalScale6.Title = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_SalesConversion;
			graphAxisNumericalScale6.Style.Font.Name = font;
			graphAxisNumericalScale6.TitleStyle.Font.Name = font;
			graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
			graphAxisNumericalScale6.Style.LineColor = Color.White;
			graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);

			//Setup 2nd Graph Axis with Numerical Scale
			var graphAxisNumericalScale7 = new GraphAxis();
			graphAxisNumericalScale7.Name = "Y Axis 3";
			graphAxisNumericalScale7.Scale = new NumericalScale();
			graphAxisNumericalScale7.Title = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_TransactionCount;
			graphAxisNumericalScale7.Style.Font.Name = font;
			graphAxisNumericalScale7.TitleStyle.Font.Name = font;
			graphAxisNumericalScale7.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
			graphAxisNumericalScale7.MajorGridLineStyle.Visible = false;
			graphAxisNumericalScale7.MinorGridLineStyle.Visible = false;
			graphAxisNumericalScale7.Style.LineColor = Color.White;
			graphAxisNumericalScale7.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
			graphAxisNumericalScale7.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;


			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
			cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
			// cartesianCoordinateSystem.YAxis.LabelFormat = "#0k";
			cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
			cartesianCoordinateSystem.XAxis.LabelAngle = 270;

			var cartesianCoordinateSystem7 = new CartesianCoordinateSystem();
			cartesianCoordinateSystem7.Name = "cartesianCoordinateSystem7";
			cartesianCoordinateSystem7.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem7.XAxis.Style.Font.Name = font;
			cartesianCoordinateSystem7.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
			cartesianCoordinateSystem7.YAxis = graphAxisNumericalScale5;

			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem7);

			//The Graph Series area
			var barSeries1 = new BarSeries();
			barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			barSeries1.CoordinateSystem = cartesianCoordinateSystem;
			barSeries1.LegendItem.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_NoofVisitor + " - " + PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Last14Days;
			barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			barSeries1.Y = yAxisGroup;
			reportGraphName.Series.Add(barSeries1);
			barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
			barSeries1.ToolTip.Text = yAxisGroup;

			//The Graph Series area
			var barSeries2 = new BarSeries();
			barSeries2.CategoryGroup = SalesConversionSectionCategoryGroup;
			barSeries2.CoordinateSystem = cartesianCoordinateSystem7;
			barSeries2.LegendItem.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_PredictedNoOfVisitor + " - " + PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_Next14Days;
			barSeries2.SeriesGroup = SalesConversionSectionSeriesGroup;
			barSeries2.Y = yAxisGroup2;
			reportGraphName.Legend.Position = GraphItemPosition.TopRight;
			reportGraphName.Series.Add(barSeries2);
			barSeries2.ColorPalette = new ColorPalette(new string[] { "0xC1,0xF7,0xE0" });

			////The Line Series area
			//var lineSeries1 = new LineSeries();
			//lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
			//lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
			//lineSeries1.LegendItem.Value = PredictiveAnalysisReportViewerView.PredictiveAnalysisReportViewerView_SalesConversion + " (%)";
			//lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
			//lineSeries1.Y = yAxisGroup3;
			//lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
			//reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
			//reportGraphName.Series.Add(lineSeries1);
			//lineSeries1.ColorPalette = new ColorPalette(Color.Black);

			return reportGraphName;
		}


		public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<DailyData> dataList, string categoryGraphGroup, string yAxisGroup)
		{
			//Data plotting - Traffic Profile Weekday
			reportGraphName.Name = graphName;

			//Setup the SqlDataSource
			reportGraphName.DataSource = dataList;

			//Create the category group
			var categoryGroup = new GraphGroup();
			categoryGroup.Name = "categoryGroup";
			categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
			reportGraphName.CategoryGroups.Add(categoryGroup);

			//The SeriesGroups hierarchy defines the series at runtime
			var seriesGroup = new GraphGroup();
			seriesGroup.Name = "seriesGroup";
			reportGraphName.SeriesGroups.Add(seriesGroup);

			//Setup Graph Axis with CategoryScale
			var graphAxisCategoryScale = new GraphAxis();
			graphAxisCategoryScale.Name = "X Axis";
			graphAxisCategoryScale.Scale = new CategoryScale();
			graphAxisCategoryScale.Style.Visible = false;
			graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
			graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

			//Setup Graph Axis with Numerical Scale
			var graphAxisNumericalScale = new GraphAxis();
			graphAxisNumericalScale.Name = "Y Axis";
			graphAxisNumericalScale.Scale = new NumericalScale();
			graphAxisNumericalScale.Style.Visible = false;
			graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
			graphAxisNumericalScale.MinorGridLineStyle.Visible = false;
			graphAxisNumericalScale.Style.BackgroundColor = Color.Blue;

			var barCount = reportGraphName.CategoryGroups.Count;
			var temp = categoryGraphGroup.Count();

			//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
			var cartesianCoordinateSystem = new CartesianCoordinateSystem();
			cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
			cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
			cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
			reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

			//The Graph Series area
			var areaGraph = new AreaSeries();
			areaGraph.CategoryGroup = categoryGroup;
			areaGraph.CoordinateSystem = cartesianCoordinateSystem;
			areaGraph.LegendItem.Style.Visible = false;
			areaGraph.SeriesGroup = seriesGroup;
			areaGraph.Y = yAxisGroup;
			reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
			reportGraphName.Series.Add(areaGraph);

			return reportGraphName;
		}


		public FinancialYearVM GetFinancialWeekList(DateTime passedDateTime, CompanySetting companySetting)
		{
			//temporary
			//passedDateTime = new DateTime(2013, 7, 18);

			var fvm = new FinancialYearVM();
			string[] financialWeek = { "1", "1" };
			DayOfWeek firstDayOfWeek = new DayOfWeek();
			if (companySetting.FinancialWeekDate != null)
				financialWeek = new string[] { companySetting.FinancialWeekDate };
			firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday" ? DayOfWeek.Sunday : companySetting.FirstDayOfWeek == "Saturday" ? DayOfWeek.Saturday : companySetting.FirstDayOfWeek == "Friday" ? DayOfWeek.Friday : DayOfWeek.Monday;

			DateTime startd = passedDateTime;
			DateTime thisYearCompanyFinancialWeekStart = new DateTime();
			DateTime thisYearCompanyFinancialWeekEnd = new DateTime();

			DateTime lastYearCompanyFinancialWeekStart = new DateTime();
			DateTime lastYearCompanyFinancialWeekEnd = new DateTime(1);

			//default financial date
			DateTime setCompanyFinancialStartDate = companySetting.DateFormat == "dateFirst" ?
				DateTime.ParseExact(companySetting.FinancialWeekDate, "dd/MM/yyyy", CultureInfo.InvariantCulture) :
				DateTime.ParseExact(companySetting.FinancialWeekDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
			DateTime setCompanyFinancialEndDate = Utility.GetFinancialYearEndDate(setCompanyFinancialStartDate, firstDayOfWeek);

			thisYearCompanyFinancialWeekStart = setCompanyFinancialEndDate.AddDays(1);
			thisYearCompanyFinancialWeekEnd = Utility.GetFinancialYearEndDate(thisYearCompanyFinancialWeekStart, firstDayOfWeek);

			lastYearCompanyFinancialWeekStart = setCompanyFinancialStartDate;
			lastYearCompanyFinancialWeekEnd = setCompanyFinancialEndDate;

			var tmpLastYear = new FinancialStartEnd();
			tmpLastYear.FinancialStartDate = lastYearCompanyFinancialWeekStart;
			tmpLastYear.FinancialEndDate = lastYearCompanyFinancialWeekEnd;

			var tmpThisYear = new FinancialStartEnd();
			tmpThisYear.FinancialStartDate = thisYearCompanyFinancialWeekStart;
			tmpThisYear.FinancialEndDate = thisYearCompanyFinancialWeekEnd;

			fvm.LastYear = tmpLastYear;
			fvm.ThisYear = tmpThisYear;
			//default financial date


			//do checking to see if passedDate is inside the range of this year financial period
			if (passedDateTime >= fvm.ThisYear.FinancialStartDate && passedDateTime <= fvm.ThisYear.FinancialEndDate)
			{

			}
			//if false
			else
			{
				//calculate the difference of the passedDate with fvm this year startDate
				//fiscal year smaller than default one
				Double differenceInYear = new Double();
				if (passedDateTime < thisYearCompanyFinancialWeekStart)
				{
					differenceInYear = (double)(Convert.ToDecimal((thisYearCompanyFinancialWeekStart - passedDateTime).TotalDays) / 365.25m);
					DateTime tmpLastStart = new DateTime();
					DateTime tmpLastEnd = new DateTime();
					DateTime tmpThisStart = thisYearCompanyFinancialWeekStart;
					DateTime tmpThisEnd = new DateTime();
					for (var i = 0.0; i < differenceInYear; i++)
					{
						tmpThisEnd = tmpThisStart.AddDays(-1);
						tmpThisStart = tmpThisEnd.AddMonths(-12).AddDays(1);

						var tmpDtDayOfWeek = (int)tmpThisStart.DayOfWeek == 0 ? 0 : (int)tmpThisStart.DayOfWeek;
						var tmpFirstDayOfWeek = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
						int dif = tmpFirstDayOfWeek - tmpDtDayOfWeek;

						tmpThisStart = tmpThisStart.AddDays(dif);
						if (dif < 0)
							dif = dif * -1;
						if (dif >= 4)
						{
							tmpThisStart = tmpThisStart.AddDays(-7);
						}
					}
					//tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);


					tmpLastEnd = tmpThisStart.AddDays(-1);
					tmpLastStart = tmpLastEnd.AddMonths(-12).AddDays(1);

					var tmpDtDayOfWeek2 = (int)tmpLastStart.DayOfWeek == 0 ? 0 : (int)tmpLastStart.DayOfWeek;
					var tmpFirstDayOfWeek2 = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
					int dif2 = tmpFirstDayOfWeek2 - tmpDtDayOfWeek2;

					tmpLastStart = tmpLastStart.AddDays(dif2);
					if (dif2 < 0)
						dif2 = dif2 * -1;
					if (dif2 >= 4)
					{
						tmpLastStart = tmpLastStart.AddDays(-7);
					}
					//int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
					//tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);

					//if ((int)firstDayOfWeek >= 4 && (int)firstDayOfWeek != 7)
					//{
					//    tmpLastStart = tmpLastStart.AddDays(-7);
					//}

					tmpLastYear.FinancialStartDate = tmpLastStart;
					tmpLastYear.FinancialEndDate = tmpLastEnd;

					tmpThisYear.FinancialStartDate = tmpThisStart;
					tmpThisYear.FinancialEndDate = tmpThisEnd;

					fvm.LastYear = tmpLastYear;
					fvm.ThisYear = tmpThisYear;

					return fvm;
				}

				//fiscal year greater than default one
				else if (passedDateTime > thisYearCompanyFinancialWeekEnd)
				{
					differenceInYear = (double)(Convert.ToDecimal((passedDateTime - thisYearCompanyFinancialWeekStart).TotalDays) / 365.25m);
					DateTime tmpLastStart = new DateTime();
					DateTime tmpLastEnd = new DateTime();
					DateTime tmpThisStart = thisYearCompanyFinancialWeekEnd.AddDays(1);
					DateTime tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
					for (var i = 0.0; i < differenceInYear - 1; i++)
					{
						if (i > 0)
						{
							tmpThisStart = tmpThisEnd.AddDays(1);
							tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
						}
					}

					tmpLastEnd = tmpThisStart.AddDays(-1);
					tmpLastStart = tmpLastEnd.AddMonths(-12);
					int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
					tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);
					if ((pushLastWeekStartToFirstDay * -1) >= 4)
					{
						tmpLastStart = tmpLastStart.AddDays(7);
					}


					tmpLastYear.FinancialStartDate = tmpLastStart;
					tmpLastYear.FinancialEndDate = tmpLastEnd;

					tmpThisYear.FinancialStartDate = tmpThisStart;
					tmpThisYear.FinancialEndDate = tmpThisEnd;

					fvm.LastYear = tmpLastYear;
					fvm.ThisYear = tmpThisYear;

					return fvm;
				}
			}





			return fvm;
		}

	}


}