namespace RetailCamControlPanel
{
	//extern alias language;
	//using language1 = language::RetailCamControlPanel.Resources;
	//using Resources;
	using Helper;
	using Services.CompositeService;
	using Services.SingularService;
	using ViewModel;
	using System;
	using System.Drawing;
	using System.Globalization;
	using System.Linq;
	using Models;
	using Telerik.Reporting;
	using Telerik.Reporting.Drawing;
	using Telerik.ReportViewer;
	using System.Web;
	using System.Threading;
	using Telerik.Reporting.Charting;
	using System.Configuration;
    using System.Collections.Generic;

	/// <summary>
	/// Summary description for Report2.
	/// </summary>
	public partial class SalesConversionDaily : Report
	{
		private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];

		public SalesConversionDaily()
		{
			InitializeComponent();
		}

		private void SalesConversionDaily_NeedDataSource(object sender, EventArgs e)
		{
			//Services
			var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
			var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
			var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
			var companyServices = MvcApplication.container.GetInstance<CompanyService>();
			var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Data obtaining
                //Data obtaining - Company name and date for UI
                var startDate = Report.Parameters["Date"].Value.ToString();
                //var date = startDate.Value.ToString();
                //  var dateDay = startDate.Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var dateFormat = 1;

                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegion = Report.Parameters["Region"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                var userRole = Report.Parameters["userRole"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                //DateTime startD = Convert.ToDateTime(startDate); //convert from string to DateTIme
                DateTime dt = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    dt = DateTime.ParseExact(startDate, "dd/MM/yyyy", culture);
                }
                else
                {
                    dt = DateTime.ParseExact(startDate, "MM/dd/yyyy", culture);
                    dateFormat = 2;

                }
                DayOfWeek dow = dt.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);


                var company = companyServices.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                var branchId = 0;
                var twoYearsWorth = false;
                var maxDate = startDate;
                //  var startd = new DateTime(2017, 6, 6);
                var startd = dt;
                string font = Utility.Telerik_GetDefaultFontName();
                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                // Obtain raw data
                var companyDailyRawData = ffcompositeServices.GetBranchSummaryReport(startd, null, selectedRegion, branchId, false, true, comCode: companyCode, userRole: userRole);
                var companyHourlyRawData = ffcompositeServices.GetBranchHourlyReport(startd, null, selectedRegion, comCode: companyCode, userRole: userRole).OrderBy(o => o.ValueDateTime).ToList();

                List<long> branchIds = companyDailyRawData.Select(s => s.BranchId).ToList();


                // get operating hours
                var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
                var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();

                var operatingHours = ffBranchOperatingHourService.GetCompanyBranchOperatingHourList(branchIds).Where(x => x.isDayOff == false && x.Day == (int)dow).ToList();
                //          List<FFBranchSpecialOperatingHourViewModel> specialHourBranch = new List<FFBranchSpecialOperatingHourViewModel>();

                //foreach (long branchID in branchIds)
                //{
                //    var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(branchID).FirstOrDefault(x => x.Date == startd);
                //    if (specialOperatingHour != null)
                //    {
                //        specialHourBranch.Add(specialOperatingHour);
                //    }
                //}

                //var specialOperatingHour = branchIds.Where(x => ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(x)
                //.FirstOrDefault(y => y.Date == startd) != null)
                //.Select(s => new FFBranchSpecialOperatingHour()
                //{
                //    BranchId = s,
                //    isDayOff = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(s).Where(y => y.Date == startd).Select(z => z.isDayOff).FirstOrDefault(),
                //}).ToList();

                var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHourList(w => branchIds.Contains(w.BranchId) && w.Date == startd);




                var count = 0;
                var allBranchesIsDayOff = false;

                if (specialOperatingHour != null)
                {
                    foreach (var branch in specialOperatingHour)
                    {
                        if (branch.isDayOff == true)
                        {
                            count++;
                        }
                    }

                    if (count == branchIds.Count)
                    {
                        allBranchesIsDayOff = true;
                    }
                }

                //Setting the language
                if (language == "zh-TW" || language == "zh")
                {
                    //To cater for PDF generation
                    font = Utility.Telerik_GetDefaultFontName();

                    //Report Header
                    reportTitle.Style.Font.Name = font;
                    dayDate.Style.Font.Name = font;

                    //Overview Table
                    outsideTrafficOverview.Style.Font.Name = font;
                    turnInRateOverview.Style.Font.Name = font;
                    salesConversionOverview.Style.Font.Name = font;
                    valueInOverview.Style.Font.Name = font;

                    //Section
                    salesConversionSection.Style.Font.Name = font;

                    //StoreTable
                    storeHeader.Style.Font.Name = font;
                    sitesHeader.Style.Font.Name = font;
                    visitorCountHeader.Style.Font.Name = font;
                    outsideTrafficHeader.Style.Font.Name = font;
                    turnInRateHeader.Style.Font.Name = font;
                    transactionQuantityHeader.Style.Font.Name = font;
                    AverageTransactionValueHeader.Style.Font.Name = font;
                    salesConversionHeader.Style.Font.Name = font;
                    rankingHeader.Style.Font.Name = font;

                    //To cater for appearance
                    salesConversionSection.Style.Font.Size = new Unit(30);
                    ToolTip.Location = new PointU(new Unit(1.74, UnitType.Inch), new Unit(2.12, UnitType.Inch));
                }

                //Data obtaining - top matric data 
                var transactionCountSum = 0;

                //Data obtaining - Checking if data exists
                var branchSummaryDailyReportViewModel = companyDailyRawData.Where(x => x.PatchStatus != "Predict").OrderByDescending(o => o.Date).FirstOrDefault();
                if (branchSummaryDailyReportViewModel != null && companyDailyRawData.Count > 0 && branchSummaryDailyReportViewModel.PatchStatus != "Predict")
                {
                    maxDate = (dateFormat == 2)
                        ? companyDailyRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("MM'/'dd'/'yyyy")
                        : companyDailyRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("dd'/'MM'/'yyyy");
                    transactionCountSum = companyDailyRawData.Sum(s => s.TransactionCount);
                }

                if (transactionCountSum == 0 || (maxDate != startDate || companyDailyRawData.Count == 0 || operatingHours.Count == 0) && specialOperatingHour.Count == 0 || allBranchesIsDayOff == true && specialOperatingHour.Count > 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    note.Visible = false;
                    ToolTip.Visible = false;
                    overviewTable.Visible = false;
                    salesConversionSection.Visible = false;
                    sectionLine.Visible = false;
                    storeTable.Visible = false;
                    if (operatingHours.Count == 0 && specialOperatingHour.Count == 0 || specialOperatingHour.Count > 0 && allBranchesIsDayOff == true)
                    {
                        errorBox.Value = "ERR101";
                    }
                    else
                    {
                        errorBox.Value = "ERR103";
                    }

                    errorMessage.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_ReportIsNotAvailable;
                }

                else
                {
                    var companyDailyOverallData =
                        ffBranchSummaryDailyReportService.CalculateMatricData(companyDailyRawData, false);

                    //Data obtaining - graphOutsideTrafficOverview, graphTurnInRateOverview, graphTotalVisiorsOverview, graphSalesConversionOverview (Today)
                    var companyHourlyOperatingData =
                        ffBranchSummaryHourlyReportService.GetDataInOperatingHour(companyHourlyRawData, true);

                    //Data obtaining - Sales Conversion Section Graph
                    var companyHourlyTrendData = companyHourlyRawData.GroupBy(g => g.ValueDateTime)
                        .Select(s => new BranchSummaryHourlyReportViewModel
                        {
                            Hour = dateFormat == 2 ? s.Key.ToString("MM/dd HH:mm") : s.Key.ToString("dd/MM HH:mm"),
                            ValueIn = s.Sum(x => x.ValueIn),
                            SalesConversion = s.Sum(g => g.TransactionCount) == 0 ? 0 :
                                        s.Sum(g => g.ValueIn) == 0 ? 0 :
                                            s.Sum(g => g.TransactionCount) / (s.Sum(g => g.ValueIn)) > 1 ? 100 :
                                                Math.Round((double)s.Sum(g => g.TransactionCount) * 100 / (double)(s.Sum(g => g.ValueIn)), 2),

                            OutsideTraffic = s.Sum(x => x.OutsideTraffic),
                            TurnInRate = s.Sum(x => x.ValueIn) == 0                 // ? 0 : [] ? 100 :
                                        || s.Sum(x => x.OutsideTraffic) == 0 ? 0 :
                                            Math.Round((double)s.Sum(x => x.ValueIn) * 100 / (double)(s.Sum(x => x.ValueIn) + s.Sum(x => x.OutsideTraffic)), 2),
                            TransactionCount = s.Sum(x => x.TransactionCount),
                            AverageAmount = s.Sum(x => x.SalesAmount) == 0 || s.Sum(x => x.TransactionCount) == 0 ? 0 : s.Sum(x => x.SalesAmount) / s.Sum(x => x.TransactionCount)
                        }).ToList();

                    //Data obtaining - Sales Conversion Section Table
                    var branchStatisticsRaw =
                        ffBranchSummaryDailyReportService.GetStoresRanking(companyDailyRawData, startd).OrderBy(o => o.Rank).ToList();

                    //Disable errorBox
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    //Report Header language settings
                    reportTitle.Value = (selectedRegion == "")
                        ? companyName.ToUpper() + " " + CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_DailyReport.ToUpper() + " "
                        : companyName.ToUpper() + " (" + selectedRegion.ToUpper() + ") " + CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_DailyReport.ToUpper() +
                          " ";
                    dayDate.Value = day + " " + startDate;

                    //Overview Table language settings
                    outsideTrafficOverview.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_OutsideTraffic;
                    turnInRateOverview.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_TurnInRate;
                    valueInOverview.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_TotalVisitors;
                    salesConversionOverview.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion;
                    OutsideTrafficTotal.Format = "{0:N2}";

                    //Section language settings
                    salesConversionSection.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion.ToUpper();
                    note.Value = "* " + CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_Note + ": " + CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_VarienceVersusSameDayLastWeek;

                    //Store Table language settings
                    storeHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_BranchCode;
                    sitesHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_BranchName;
                    visitorCountHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_VisitorCounts;
                    outsideTrafficHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_OutsideTraffic;
                    turnInRateHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_TotalSalesAmount;
                    transactionQuantityHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_TransactionQuantity;
                    AverageTransactionValueHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_AverageTransactionValue;
                    salesConversionHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion + " (%)";
                    rankingHeader.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_Rank;

                    //Data plotting
                    overviewTable.DataSource = companyDailyOverallData;
                    storeTable.DataSource = branchStatisticsRaw;

                    //Data plotting - graphOutsideTrafficOverview, graphTurnInRateOverview, graphTotalVisiorsOverview, graphSalesConversionOverview (Today)
                    TelerikUtility.PlotAreaGraph_NoAxes(graphOutsideTrafficOverview.ToString(), graphOutsideTrafficOverview,
                        companyHourlyOperatingData,
                        "=Fields.ValueDateTime", "=Fields.OutsideTraffic");

                    TelerikUtility.PlotAreaGraph_NoAxes(graphTurnInRateOverview.ToString(), graphTurnInRateOverview, companyHourlyOperatingData,
                        "=Fields.ValueDateTime", "=Fields.TurnInRate");

                    TelerikUtility.PlotAreaGraph_NoAxes(graphTotalVisitorsOverview.ToString(), graphTotalVisitorsOverview,
                        companyHourlyOperatingData,
                        "=Fields.ValueDateTime", "=Fields.ValueIn");

                    TelerikUtility.PlotAreaGraph_NoAxes(graphSalesConversionOverview.ToString(), graphSalesConversionOverview,
                        companyHourlyOperatingData,
                        "=Fields.ValueDateTime", "=Fields.SalesConversion");

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var maxValueIn = companyHourlyTrendData.Max(s => s.ValueIn);
                    var minValueIn = companyHourlyTrendData.Min(s => s.ValueIn);
                    var denominator = TelerikUtility.CheckValueDenominator(minValueIn, maxValueIn);
                    var FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    //            if (maxValueIn >= 3000000 || minValueIn >= 1000000)
                    //{
                    //	FormatString = "{0:## ##0M}";
                    //	denominator = 1000000;
                    //}

                    //else if (maxValueIn >= 3000 || minValueIn >= 1000)
                    //{
                    //	FormatString = "{0:## ##0k}";
                    //	denominator = 1000;
                    //}

                    // var FormatString = maxValueIn > 1000 ? "{0:## ##0k}" : "{0:## ##0}";

                    //Data plotting - Sales Conversion Section Graph
                    var graphDataSource = companyHourlyTrendData.AsReadOnly().Select(
                        s => new BranchSummaryHourlyReportViewModel
                        {
                            Hour = s.Hour.Contains("00:00") ? s.Hour : s.Hour.Split(' ')[1],
                            ValueInDouble = (double)s.ValueIn / denominator,
                            SalesConversion = s.SalesConversion
                        }).ToList();

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionSection.ToString(), graphSalesConversionSection, graphDataSource, "=Fields.Hour", "Hour", "=Fields.ValueInDouble", CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion, font, FormatString, "{0:0.##}");

                    //PDF setting
                    storeTable.ColumnHeadersPrintOnEveryPage = true;

                    //Attach link to graph
                    Telerik.Reporting.NavigateToUrlAction UrlAction1 = new Telerik.Reporting.NavigateToUrlAction();
                    if (dateFormat == 2)
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=1&selectedregionid=&parameter=101,311&start=" + dt.ToString("MM'/'dd'/'yyyy") + "&end=" + dt.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    else
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=1&selectedregionid=&parameter=101,311&start=" + dt.ToString("dd'/'MM'/'yyyy") + "&end=" + dt.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    graphSalesConversionSection.Action = UrlAction1;
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

		//public Graph plotAreaGraph(string graphName, Graph reportGraphName, System.Collections.Generic.List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup)
		//{
		//	//Data plotting - Traffic Profile Weekday
		//	reportGraphName.Name = graphName;

		//	//Setup the SqlDataSource
		//	reportGraphName.DataSource = dataList;

		//	//Create the category group
		//	var categoryGroup = new GraphGroup();
		//	categoryGroup.Name = "categoryGroup";
		//	categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
		//	reportGraphName.CategoryGroups.Add(categoryGroup);

		//	//The SeriesGroups hierarchy defines the series at runtime
		//	var seriesGroup = new GraphGroup();
		//	seriesGroup.Name = "seriesGroup";
		//	reportGraphName.SeriesGroups.Add(seriesGroup);

		//	//Setup Graph Axis with CategoryScale
		//	var graphAxisCategoryScale = new GraphAxis();
		//	graphAxisCategoryScale.Name = "X Axis";
		//	graphAxisCategoryScale.Scale = new CategoryScale();
		//	graphAxisCategoryScale.Style.Visible = false;
		//	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

		//	//Setup Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale = new GraphAxis();
		//	graphAxisNumericalScale.Name = "Y Axis";
		//	graphAxisNumericalScale.Scale = new NumericalScale();
		//	graphAxisNumericalScale.Style.Visible = false;
		//	graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

		//	//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
		//	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
		//	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
		//	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

		//	//The Graph Series area
		//	var areaGraph = new AreaSeries();
		//	areaGraph.CategoryGroup = categoryGroup;
		//	areaGraph.CoordinateSystem = cartesianCoordinateSystem;
		//	areaGraph.LegendItem.Style.Visible = false;
		//	areaGraph.SeriesGroup = seriesGroup;
		//	areaGraph.Y = yAxisGroup;
		//	reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
		//	reportGraphName.Series.Add(areaGraph);

		//	return reportGraphName;
		//}

		//public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, System.Collections.Generic.List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup,
		//	string yAxisGroup, string yAxisGroup2, string font, string format)
		//{
		//	reportGraphName.Name = graphName;
		//	reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
		//	reportGraphName.Style.Font.Bold = false;
		//	reportGraphName.Style.Font.Name = font;

		//	//Setup the SqlDataSource
		//	reportGraphName.DataSource = dataList;

		//	//Create the category group
		//	var SalesConversionSectionCategoryGroup = new GraphGroup();
		//	SalesConversionSectionCategoryGroup.Name = "categoryGroup";
		//	SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
		//	reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

		//	//The SeriesGroups hierarchy defines the series at runtime
		//	var SalesConversionSectionSeriesGroup = new GraphGroup();
		//	SalesConversionSectionSeriesGroup.Name = "seriesGroup";
		//	reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);

		//	//Setup Graph Axis with CategoryScale
		//	var graphAxisCategoryScale = new GraphAxis();
		//	graphAxisCategoryScale.Name = "X Axis";
		//	graphAxisCategoryScale.Scale = new CategoryScale();
		//	graphAxisCategoryScale.Title = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_Hour;
		//	graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
		//	graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
		//	graphAxisCategoryScale.Style.Font.Name = font;
		//	graphAxisCategoryScale.TitleStyle.Font.Name = font;
		//	graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
		//	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.Style.LineColor = Color.White;
		//	graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	// graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	var graphAxisCategoryScale2 = new GraphAxis();
		//	graphAxisCategoryScale2.Name = "X Axis 2";
		//	graphAxisCategoryScale2.Scale = new CategoryScale();
		//	graphAxisCategoryScale2.Style.Visible = false;
		//	graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
		//	//  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	//Setup Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale5 = new GraphAxis();
		//	graphAxisNumericalScale5.Name = "Y Axis";
		//	graphAxisNumericalScale5.Scale = new NumericalScale();
		//	graphAxisNumericalScale5.Title = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_NoofVisitor;
		//	graphAxisNumericalScale5.Style.Font.Name = font;
		//	graphAxisNumericalScale5.TitleStyle.Font.Name = font;
		//	graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
		//	graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
		//	graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale5.Style.LineColor = Color.White;
		//	graphAxisNumericalScale5.LabelFormat = format;
		//	//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	//Setup 2nd Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale6 = new GraphAxis();
		//	graphAxisNumericalScale6.Name = "Y Axis 2";
		//	graphAxisNumericalScale6.Scale = new NumericalScale();
		//	graphAxisNumericalScale6.Title = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion + " (%)";
		//	graphAxisNumericalScale6.Style.Font.Name = font;
		//	graphAxisNumericalScale6.TitleStyle.Font.Name = font;
		//	graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
		//	graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
		//	graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale6.Style.LineColor = Color.White;
		//	graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


		//	//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
		//	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
		//	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
		//	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
		//	cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
		//	cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
		//	cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
		//	cartesianCoordinateSystem.XAxis.LabelAngle = 270;

		//	var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
		//	cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
		//	cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
		//	cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
		//	cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

		//	//The Graph Series area
		//	var barSeries1 = new BarSeries();
		//	barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
		//	barSeries1.CoordinateSystem = cartesianCoordinateSystem;
		//	barSeries1.LegendItem.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_NoofVisitor;
		//	barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
		//	barSeries1.Y = yAxisGroup;
		//	reportGraphName.Series.Add(barSeries1);
		//	barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
		//	barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, format.Insert(9, ".##"));

		//	//The Line Series area
		//	var lineSeries1 = new LineSeries();
		//	lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
		//	lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
		//	lineSeries1.LegendItem.Value = CompanySalesConversionDailyReportViewer.CompanySalesConversionDailyReportViewer_SalesConversion + " (%)";
		//	lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
		//	lineSeries1.Y = yAxisGroup2;
		//	lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
		//	reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
		//	reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
		//	reportGraphName.Series.Add(lineSeries1);
		//	lineSeries1.ColorPalette = new ColorPalette(Color.Black);
		//	// lineSeries1.ToolTip.Text = yAxisGroup2;

		//	return reportGraphName;
		//}

		public static string CheckSalesConversionOverview(double salesConversion)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Math.Abs(Math.Round(salesConversion, 2)) + "%";
			}
		}

		public static string CheckSalesConversion(double salesConversion)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Math.Abs(Math.Round(salesConversion, 2)).ToString();
			}
		}

		public static string CheckRanking(double salesConversion, int Rank)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Rank.ToString();
			}
		}

		public static string CheckTransactionCount(int transactionCount)
		{
			string format = "{0:N0}";

			if (transactionCount == 0)
			{
				return string.Format("{0:0;-0;-\"\"}", transactionCount);
			}
			else
			{
				return string.Format(format, transactionCount);
			}
		}

		public static System.Drawing.Image GetDiffImage(double salesConversion)
		{
			if (salesConversion > 0)
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
			}
			else if (salesConversion < 0)
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
			}
			else
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
			}
		}
	}
}