using System.Collections.Generic;

namespace RetailCamControlPanel
{
	using Helper;
	using Models;
	using Services.CompositeService;
	using Services.SingularService;
	using System;
	using System.Drawing;
	using System.Globalization;
	using System.Linq;
	using Telerik.Reporting;
	using Telerik.Reporting.Drawing;
	using ViewModel;
	using System.Web;
	//using Resources;
	using System.Threading;
	using System.Configuration;
	using System.Reflection;

	/// <summary>
	/// Summary description for Report2.
	/// </summary>
	public partial class SalesConversionWeekly : Report
	{
		private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
		public static List<BranchSummaryDailyReportViewModel> sevenDayTrendData;

		public SalesConversionWeekly()
		{
			//
			// Required for telerik Reporting designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}
		private void SalesConversionWeekly_NeedDataSource(object sender, EventArgs e)
		{
			//Services 
			var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
			var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
			var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
			var companyServices = MvcApplication.container.GetInstance<CompanyService>();
			var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();
            // var branchSummaryDailyReportViewModel = MvcApplication.container.GetInstance<BranchSummaryDailyReportViewModel>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Data obtaining - Company name and date for UI
                var startDateUI = Report.Parameters["Date"].Value;
                var endDateUI = Report.Parameters["EndDate"].Value;
                var weekNumber = Report.Parameters["Week"].Value;
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegion = Report.Parameters["Region"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                var userRole = Report.Parameters["userRole"].Value.ToString();
                var company = companyServices.GetCompany(companyCode);
                string font = Utility.Telerik_GetDefaultFontName();
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                var branchId = 0;
                var twoYearsWorth = false;
                var dateFormat = 1;

                var cultureInfo = new System.Globalization.CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;

                ////Setting the language
                //if (language == "zh-TW" || language == "zh")
                //{
                //    //To cater for PDF generation
                //    font = Utility.Telerik_GetDefaultFontName();

                //    //Report Header
                //    reportTitle.Style.Font.Name = font;
                //    dayDate.Style.Font.Name = font;

                //    //Overview Table
                //    thisWeek.Style.Font.Name = font;
                //    lastWeek.Style.Font.Name = font;
                //    changes.Style.Font.Name = font;
                //    bestPerformDayBox.Style.Font.Name = font;
                //    outsideTraffic.Style.Font.Name = font;
                //    turnInRate.Style.Font.Name = font;
                //    visitorCount.Style.Font.Name = font;

                //    //Section
                //    leagueStatisticsSection.Style.Font.Name = font;
                //    salesConversionSection.Style.Font.Name = font;
                //    branchStatisticsSection.Style.Font.Name = font;
                //    monthlyTrend.Style.Font.Name = font;
                //    weeklyTrend.Style.Font.Name = font;
                //    dailyTrend.Style.Font.Name = font;
                //    visitorProfileTrend.Style.Font.Name = font;
                //    weekdays.Style.Font.Name = font;
                //    weekend.Style.Font.Name = font;

                //    //Table 
                //    top15storesTextBox.Style.Font.Name = font;
                //    storeCodeTop.Style.Font.Name = font;
                //    storeNameTop.Style.Font.Name = font;
                //    conversionTop.Style.Font.Name = font;
                //    changesTop.Style.Font.Name = font;

                //    bottom15storesTextBox.Style.Font.Name = font;
                //    storeCodeBottom.Style.Font.Name = font;
                //    storeNameBottom.Style.Font.Name = font;
                //    conversionBottom.Style.Font.Name = font;
                //    changesBottom.Style.Font.Name = font;

                //    week.Style.Font.Name = font;
                //    visitor.Style.Font.Name = font;
                //    transactionCountBox.Style.Font.Name = font;
                //    conversionBox.Style.Font.Name = font;

                //    storeCodeHeader.Style.Font.Name = font;
                //    siteHeader.Style.Font.Name = font;
                //    thisWeekHeader.Style.Font.Name = font;
                //    changesHeader.Style.Font.Name = font;
                //    turnInRateHeader.Style.Font.Name = font;
                //    changesTIRHeader.Style.Font.Name = font;
                //    sevenDayTrendHeader.Style.Font.Name = font;
                //    RankHeader.Style.Font.Name = font;
                //    GraphDataTextBox.Style.Font.Name = font;

                //    //To cater for appearance
                //    salesConversionSection.Style.Font.Size = new Unit(30);
                //    branchStatisticsSection.Style.Font.Size = new Unit(30);
                //    leagueStatisticsSection.Style.Font.Size = new Unit(30);

                //}

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                // DateTime startd = DateTime.ParseExact("04/06/2017", "dd/MM/yyyy", CultureInfo.InvariantCulture);
                //  DateTime endd = DateTime.ParseExact("10/06/2017", "dd/MM/yyyy", CultureInfo.InvariantCulture);

                DateTime startd = new DateTime();
                DateTime endd = new DateTime();

                if (dateFormatHtml == "dateFirst")
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    dateFormat = 2;
                }

                var maxDate = endd;

                long startTimestamp = Utility.ConvertToTimestamp(startd);
                long endTimestamp = Utility.ConvertToTimestamp(endd);

                var financialStartEnd = Utility.GetFinancialWeekList(startd, companySetting);
                DateTime startDate;

                //determine to get years worth of data
                switch (twoYearsWorth)
                {
                    case true:
                        startDate = financialStartEnd.LastYear.FinancialStartDate;
                        break;
                    default:
                        startDate = financialStartEnd.ThisYear.FinancialStartDate;
                        break;
                }

                DateTime endDate = financialStartEnd.ThisYear.FinancialEndDate;

                //Data obtaining

                var dailyRawData =
                    ffcompositeServices.GetBranchSummaryReport(startDate, endd, selectedRegion, branchId, true, comCode: companyCode, userRole: userRole);

                var hourlyRawData = ffcompositeServices.GetBranchHourlyReport(startd, endd, selectedRegion, branchId, firstDayOfWeek, comCode: companyCode, userRole: userRole);


                var transactionCountSum = hourlyRawData.Sum(s => s.TransactionCount);

                //Data obtaining - Checking if data exists
                var branchSummaryDailyReportViewModel = dailyRawData.OrderByDescending(o => o.Date).FirstOrDefault();
                if (hourlyRawData.Count > 0 && branchSummaryDailyReportViewModel != null && branchSummaryDailyReportViewModel.PatchStatus != "Predict")
                {
                    maxDate = dailyRawData.Max(s => Utility.ConvertToDateTime(s.Date));
                }

                if (maxDate < endd || hourlyRawData.Count == 0 || transactionCountSum == 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    note.Visible = false;
                    dashboardBestPerformDay_table.Visible = false;
                    leagueStatisticsSection.Visible = false;
                    top15storeTable.Visible = false;
                    bottom15storeTable.Visible = false;
                    shape1.Visible = false;
                    sectionLine.Visible = false;
                    salesConversionSection.Visible = false;
                    monthlyTrend.Visible = false;
                    weeklyTrend.Visible = false;
                    dailyTrend.Visible = false;
                    visitorProfileTrend.Visible = false;
                    weekdays.Visible = false;
                    weekend.Visible = false;
                    SalesConversionTable.Visible = false;
                    branchStatisticsSection.Visible = false;
                    BranchStatisticsTable.Visible = false;
                    shape9.Visible = false;
                    top15storesTextBox.Visible = false;
                    bottom15storesTextBox.Visible = false;
                    GraphDataTextBox.Visible = false;
                    panel4.Visible = false;
                    sectionLeagueStatistics_panel.Visible = false;
                    panel1.Visible = false;
                    errorBox.Value = "ERR103";
                    errorMessage.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ReportIsNotAvailable;
                }
                else
                {
                    //Data obtaining
                    var hourlyFilteredRawData =
                        ffBranchSummaryHourlyReportService.GetDataWithinOperatingHour(hourlyRawData, true, true);
                    //var visitorProfileRawData = ffcompositeServices
                    //    .GetBranchHourlyReport(startd, endd, selectedRegion, branchId, firstDayOfWeek)
                    //    .OrderBy(o => o.ValueDateTime).ToList();

                    //Data obtaining - Top Matric Data
                    var topMatricData = ffBranchSummaryDailyReportService.CalculateMatricData(dailyRawData, true, endd);
                    var topMatricGraph = ffBranchSummaryDailyReportService.GetTopMatricGraphTrend(dailyRawData, startd);

                    //Data obtaining - League Statistics
                    var leagueDataRawData =
                        ffBranchSummaryDailyReportService.CalculateLeagueStatistics(dailyRawData, startd);

                    IEnumerable<BranchSummaryDailyReportViewModel> leagueData = new List<BranchSummaryDailyReportViewModel>();
                    IEnumerable<BranchSummaryDailyReportViewModel> leagueData2 = new List<BranchSummaryDailyReportViewModel>();
                    
                    if (leagueDataRawData.Count >= 15)
                    {
                        leagueData = leagueDataRawData.OrderByDescending(o => o.SalesConversion).Select(
                            (s, index) => new BranchSummaryDailyReportViewModel
                            {
                                Rank = index + 1,
                                BranchCode = s.BranchCode,
                                BranchName = s.BranchName,
                                SalesConversion = s.SalesConversion,
                                SalesConversionDiff = s.SalesConversionDiff
                            }).Take(15);
                        top15storeTable.DataSource = leagueData;
                        if (leagueDataRawData.Count >= 30)
                        {
                            leagueData2 = leagueDataRawData.OrderBy(o => o.SalesConversion).Select(
                            (s, index) => new BranchSummaryDailyReportViewModel
                            {
                                Rank = index + 1,
                                BranchCode = s.BranchCode,
                                BranchName = s.BranchName,
                                SalesConversion = s.SalesConversion,
                                SalesConversionDiff = s.SalesConversionDiff
                            }).Take(15);
                            bottom15storeTable.DataSource = leagueData2;
                        }
                        else
                        {
                            bottom15_panel.Visible = false;
                        }
                    }
                    else
                    {
                        top15_panel.Visible = false;
                        sectionLeagueStatistics_panel.Visible = false;
                    }

                    

                    //Data obtaining - trend
                    var monthlyBranchSummary = ffBranchSummaryDailyReportService.CalculateMonthlyTrend(dailyRawData, startd,
                        firstDayOfWeek,
                        financialStartEnd, companySetting);
                    var weeklyBranchSummary =
                        ffBranchSummaryDailyReportService.CalculateWeeklyTrend(dailyRawData, startd, firstDayOfWeek,
                            financialStartEnd);
                    var dailyBranchSummary = ffBranchSummaryDailyReportService.CalculateDailyTrend(dailyRawData, endd);

                    var weekdayRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == false)
                        .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    var weekdayVisitorProfile =
                        ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekdayRawData, true, true);

                    var weekendRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == true)
                        .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    var weekendVisitorProfile =
                        ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekendRawData, true, true);

                    //Data obtaining - Branch Statistics
                    var branchStatisticsRaw =
                        ffBranchSummaryDailyReportService.GetStoresRanking(dailyRawData, startd, endd, true);

                    sevenDayTrendData = dailyRawData.Where(s => s.Date >= startTimestamp && s.Date <= endTimestamp).ToList();
                    //Disable error box
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    //Report Header language settings
                    reportTitle.Value = (selectedRegion == "") ? companyName.ToUpper() + " " + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_CompanySalesConversion.ToUpper() + " " : companyName.ToUpper() + " (" + selectedRegion.ToUpper() + ") " + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_CompanySalesConversion.ToUpper() + " ";
                    dayDate.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Week + " " + weekNumber + ")";

                    //Overview Table language settings
                    titleSalesConversion_txt.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion;
                    titleBestPerformDay_txt.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BestPerformDay;
                    titleTotalVisitor_txt.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TotalVisitors;

                    //Section language settings
                    leagueStatisticsSection.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_LeagueStatistics.ToUpper();
                    salesConversionSection.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion.ToUpper();
                    branchStatisticsSection.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchStatistics.ToUpper();
                    monthlyTrend.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_MonthlyTrend;
                    weeklyTrend.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_WeeklyTrend;
                    dailyTrend.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_DailyTrend;
                    visitorProfileTrend.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_VisitorProfile;
                    weekdays.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Weekdays;
                    weekend.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Weekends;
                    note.Value = "*" + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Note + ": " + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_VarienceVersusSameDayLastWeek;

                    //Tooltips
                    monthlyTrend.ToolTip.Text = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Monthlypercentofspendingvisitors;
                    weeklyTrend.ToolTip.Text = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_WeeklySpendingVisitors;
                    dailyTrend.ToolTip.Text = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_DailySpendingVisitors;
                    visitorProfileTrend.ToolTip.Text = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TrafficProfileTooltip;
                    salesConversionSection.ToolTip.Text = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversionFormula;


                    //Table language settings
                    top15storesTextBox.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Top15Stores;
                    storeCodeTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    storeNameTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    conversionTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)";
                    changesTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + " (%)";

                    bottom15storesTextBox.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Bottom15Stores;
                    storeCodeBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    storeNameBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    conversionBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)";
                    changesBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + " (%)";

                    week.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Week + " " + weekNumber;
                    visitor.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor;
                    transactionCountBox.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TransactionCount;
                    conversionBox.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Conversion + " (%)";

                    storeCodeHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    siteHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    thisWeekHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ThisWeek + " (%)";
                    changesHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + "(%)";
                    turnInRateHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TransactionCount;
                    changesTIRHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesAmount;
                    sevenDayTrendHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SevenDayTrend;
                    RankHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Rank;

                    //Data plotting - graphSalesConversionOverviewThisWeek, graphSalesConversionOverviewLastWeek, graphOutsideTrafficOverview, graphTurnInRateOverview, graphTotalVisitorsOverview, 
                    TelerikUtility.PlotAreaGraph_NoAxes(trendSalesConversion_graph.ToString(), trendSalesConversion_graph,
                        topMatricGraph,
                        "=Fields.ValueDateTime", "=Fields.SalesConversion");

                    TelerikUtility.PlotAreaGraph_NoAxes(trendTotalVisitors_graph.ToString(), trendTotalVisitors_graph, topMatricGraph,
                        "=Fields.ValueDateTime", "=Fields.ValueIn");

                    var objectDataSource5 = new Telerik.Reporting.ObjectDataSource();

                    // objectDataSource5.DataSource = topMatricData;

                    dashboardTotalVisitors_table.DataSource = topMatricData;
                    dashboardSalesConversion_table.DataSource = topMatricData;
                    dashboardBestPerformDay_table.DataSource = topMatricData;
                    dashboardBestPerformSite_table.DataSource = topMatricData;

                    SalesConversionTable.DataSource = dailyBranchSummary.ThisYear.AsReadOnly()
                        .Where(s => (s.Timestamp >= startTimestamp) && (s.Timestamp <= endTimestamp));

                    salesConversionSum.Value = topMatricData.SalesConversion.ToString() + '%';

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var maxValueInMonthly = monthlyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInMonthly = monthlyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorMonthly = TelerikUtility.CheckValueDenominator(minValueInMonthly, maxValueInMonthly);
                    var FormatStringMonthly = TelerikUtility.DenominatedStringFormat(denominatorMonthly);

                    //            if (maxValueInMonthly >= 3000000 || minValueInMonthly >= 1000000)
                    //{
                    //	FormatStringMonthly = "{0:## ##0M}";
                    //	denominatorMonthly = 1000000;
                    //}

                    //else if (maxValueInMonthly >= 3000 || minValueInMonthly >= 1000)
                    //{
                    //	FormatStringMonthly = "{0:## ##0k}";
                    //	denominatorMonthly = 1000;
                    //}

                    //Data plotting - Monthly Trend
                    var graphMonthlyDataSource = monthlyBranchSummary.ThisYear.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / (double)denominatorMonthly,
                            SalesConversion = s.SalesConversion,
                            Month = s.Month
                        });

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionMonthly.ToString(), graphSalesConversionMonthly,
                        graphMonthlyDataSource, "=Fields.Month", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Month, "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringMonthly, "{0:0.##}");

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var maxValueInWeekly = weeklyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInWeekly = weeklyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorWeekly = TelerikUtility.CheckValueDenominator(minValueInWeekly, maxValueInWeekly);
                    var FormatStringWeekly = TelerikUtility.DenominatedStringFormat(denominatorWeekly);

                    //            if (maxValueInWeekly >= 3000000 || minValueInWeekly >= 1000000)
                    //{
                    //	FormatStringWeekly = "{0:## ##0M}";
                    //	denominatorWeekly = 1000000;
                    //}

                    //else if (maxValueInWeekly >= 3000 || minValueInWeekly >= 1000)
                    //{
                    //	FormatStringWeekly = "{0:## ##0k}";
                    //	denominatorWeekly = 1000;
                    //}

                    //Data plotting -Weekly Trend
                    var graphWeeklyDataSource = weeklyBranchSummary.ThisYear.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekly,
                            SalesConversion = s.SalesConversion,
                            Week = s.Week.ToString()
                        });

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionWeekly.ToString(), graphSalesConversionWeekly,
                        graphWeeklyDataSource, "=Fields.Week", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Week, "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeekly, "{0:0.##}");

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var maxValueInDaily = dailyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInDaily = dailyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorDaily = TelerikUtility.CheckValueDenominator(minValueInDaily, maxValueInDaily);
                    var FormatStringDaily = TelerikUtility.DenominatedStringFormat(denominatorDaily);

                    //            if (maxValueInDaily >= 3000000 || minValueInDaily >= 1000000)
                    //{
                    //	FormatStringDaily = "{0:## ##0M}";
                    //	denominatorDaily = 1000000;
                    //}

                    //else if (maxValueInDaily >= 3000 || minValueInDaily >= 1000)
                    //{
                    //	FormatStringDaily = "{0:## ##0k}";
                    //	denominatorDaily = 1000;
                    //}

                    //Data plotting - Daily Trend
                    var graphDailyDataSource = dailyBranchSummary.ThisYear.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorDaily,
                            SalesConversion = s.SalesConversion,
                            DateString = s.Date
                        });

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionDaily.ToString(), graphSalesConversionDaily,
                        graphDailyDataSource, "=Fields.DateString", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Day, "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringDaily, "{0:0.##}");

                    //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                    var maxValueInWeekday = weekdayVisitorProfile.Max(s => s.ValueIn);
                    var minValueInWeekday = weekdayVisitorProfile.Min(s => s.ValueIn);
                    var denominatorWeekday = TelerikUtility.CheckValueDenominator(minValueInWeekday, maxValueInWeekday);
                    var FormatStringWeekday = TelerikUtility.DenominatedStringFormat(denominatorWeekday);

                    //            if (maxValueInWeekday >= 3000000 || minValueInWeekday >= 1000000)
                    //{
                    //	FormatStringWeekday = "{0:## ##0M}";
                    //	denominatorWeekday = 1000000;
                    //}

                    //else if (maxValueInWeekday >= 3000 || minValueInWeekday >= 1000)
                    //{
                    //	FormatStringWeekday = "{0:## ##0k}";
                    //	denominatorWeekday = 1000;
                    //}

                    //Data plotting - Traffic Profile Weekday

                    var graphWeekdayDataSource = weekdayVisitorProfile.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekday,
                            SalesConversion = s.SalesConversion,
                            Hour = s.Hour
                        });

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionWeekday.ToString(), graphSalesConversionWeekday,
                        graphWeekdayDataSource, "=Fields.Hour", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Hourly, "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeekday, "{0:0.##}");

                    if (weekendRawData.Count == 0)
                    {
                        GraphDataTextBox.Visible = true;
                        graphSalesConversionWeekend.Visible = false;
                    }
                    else
                    {
                        GraphDataTextBox.Visible = false;

                        //Check if value in exceed 4000, if yes, display as 'k' instead of '000', value exceed 4000000, display 'M' instead of '000000'
                        var maxValueInWeekend = weekendVisitorProfile.Max(s => s.ValueIn);
                        var minValueInWeekend = weekendVisitorProfile.Min(s => s.ValueIn);
                        var denominatorWeekend = TelerikUtility.CheckValueDenominator(minValueInWeekend, maxValueInWeekend);
                        var FormatStringWeekend = TelerikUtility.DenominatedStringFormat(denominatorWeekend);

                        //               if (maxValueInWeekend >= 3000000 || minValueInWeekend >= 1000000)
                        //{
                        //	FormatStringWeekend = "{0:## ##0M}";
                        //	denominatorWeekend = 1000000;
                        //}

                        //else if (maxValueInWeekend >= 3000 || minValueInWeekend >= 1000)
                        //{
                        //	FormatStringWeekend = "{0:## ##0k}";
                        //	denominatorWeekend = 1000;
                        //}

                        //Data plotting - Traffic Profile Weekend

                        var graphWeekendDataSource = weekendVisitorProfile.AsReadOnly().Select(
                            s => new BranchSummaryDailyReportViewModel
                            {
                                ValueInDouble = (double)s.ValueIn / denominatorWeekend,
                                SalesConversion = s.SalesConversion,
                                Hour = s.Hour
                            });

                        TelerikUtility.PlotBarLineGraph_2YAxisLabel(graphSalesConversionWeekend.ToString(), graphSalesConversionWeekend,
                            graphWeekendDataSource, "=Fields.Hour", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Hourly, "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeekend, "{0:0.##}");
                    }

                    BranchStatisticsTable.DataSource = branchStatisticsRaw.OrderBy(s => s.BranchName);

                    BranchStatisticsTable.ColumnHeadersPrintOnEveryPage = true;

                    TelerikUtility.PlotAreaGraph_NoAxes_HasDataSource(graphSevenDayTrend.ToString(), graphSevenDayTrend, "=Fields.Date", "=Fields.SalesConversion");


                    //Attach link to graph
                    Telerik.Reporting.NavigateToUrlAction UrlAction1 = new Telerik.Reporting.NavigateToUrlAction();
                    string financialWeekDate = companyServices.GetCompany(companyId).Setting.FinancialWeekDate;
                    DateTime firstDayOfThisYear = new DateTime(DateTime.Now.Year, Convert.ToInt32(financialWeekDate.Substring(3, 2)), Convert.ToInt32(financialWeekDate.Substring(0, 2)));
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&selectedregionid=&parameter=101,311&start=" + firstDayOfThisYear.ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    }
                    else
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&selectedregionid=&parameter=101,311&start=" + firstDayOfThisYear.ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    }
                    graphSalesConversionWeekly.Action = UrlAction1;

                    Telerik.Reporting.NavigateToUrlAction UrlAction2 = new Telerik.Reporting.NavigateToUrlAction();
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&selectedregionid=&parameter=101,311&start=" + endd.AddDays(-31).ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    }
                    else
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&selectedregionid=&parameter=101,311&start=" + endd.AddDays(-31).ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&selectedMode=company&isGeneratePDF=false";
                    }
                    graphSalesConversionDaily.Action = UrlAction2;
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }


		//public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryDailyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup)
		//{
		//	//Data plotting - Traffic Profile Weekday
		//	reportGraphName.Name = graphName;

		//	//Setup the SqlDataSource
		//	if (dataList != null)
		//	{
		//		reportGraphName.DataSource = dataList;
		//	}

		//	//Create the category group
		//	var categoryGroup = new GraphGroup();
		//	categoryGroup.Name = "categoryGroup";
		//	categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
		//	reportGraphName.CategoryGroups.Add(categoryGroup);

		//	//The SeriesGroups hierarchy defines the series at runtime
		//	var seriesGroup = new GraphGroup();
		//	seriesGroup.Name = "seriesGroup";
		//	reportGraphName.SeriesGroups.Add(seriesGroup);

		//	//Setup Graph Axis with CategoryScale
		//	var graphAxisCategoryScale = new GraphAxis();
		//	graphAxisCategoryScale.Name = "X Axis";
		//	graphAxisCategoryScale.Scale = new CategoryScale();
		//	graphAxisCategoryScale.Style.Visible = false;
		//	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

		//	//Setup Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale = new GraphAxis();
		//	graphAxisNumericalScale.Name = "Y Axis";
		//	graphAxisNumericalScale.Scale = new NumericalScale();
		//	graphAxisNumericalScale.Style.Visible = false;
		//	graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

		//	//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
		//	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
		//	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
		//	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

		//	//The Graph Series area
		//	var areaGraph = new AreaSeries();
		//	areaGraph.CategoryGroup = categoryGroup;
		//	areaGraph.CoordinateSystem = cartesianCoordinateSystem;
		//	areaGraph.LegendItem.Style.Visible = false;
		//	areaGraph.SeriesGroup = seriesGroup;
		//	areaGraph.Y = yAxisGroup;
		//	reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
		//	reportGraphName.Series.Add(areaGraph);

		//	return reportGraphName;
		//}

		//public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font, string format)
		//{
		//	reportGraphName.Name = graphName;
		//	reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
		//	reportGraphName.Style.Font.Bold = false;
		//	reportGraphName.Style.Font.Name = font;

		//	//Setup the SqlDataSource

		//	reportGraphName.DataSource = graphDataSource;

		//	//Create the category group
		//	var SalesConversionSectionCategoryGroup = new GraphGroup();
		//	SalesConversionSectionCategoryGroup.Name = "categoryGroup";
		//	SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
		//	reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

		//	//The SeriesGroups hierarchy defines the series at runtime
		//	var SalesConversionSectionSeriesGroup = new GraphGroup();
		//	SalesConversionSectionSeriesGroup.Name = "seriesGroup";
		//	reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


		//	//Setup Graph Axis with CategoryScale
		//	var graphAxisCategoryScale = new GraphAxis();
		//	graphAxisCategoryScale.Name = "X Axis";
		//	graphAxisCategoryScale.Scale = new CategoryScale();
		//	graphAxisCategoryScale.Title = xAxisName;
		//	graphAxisCategoryScale.Style.Font.Name = font;
		//	graphAxisCategoryScale.TitleStyle.Font.Name = font;
		//	graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
		//	graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
		//	graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale.Style.LineColor = Color.White;
		//	graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	// graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	var graphAxisCategoryScale2 = new GraphAxis();
		//	graphAxisCategoryScale2.Name = "X Axis 2";
		//	graphAxisCategoryScale2.Scale = new CategoryScale();
		//	graphAxisCategoryScale2.Style.Visible = false;
		//	graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
		//	graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
		//	//  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	//Setup Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale5 = new GraphAxis();
		//	graphAxisNumericalScale5.Name = "Y Axis";
		//	graphAxisNumericalScale5.Scale = new NumericalScale();
		//	graphAxisNumericalScale5.Title = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor;
		//	graphAxisNumericalScale5.Style.Font.Name = font;
		//	graphAxisNumericalScale5.TitleStyle.Font.Name = font;
		//	graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
		//	graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale5.Style.LineColor = Color.White;
		//	graphAxisNumericalScale5.LabelFormat = format;
		//	//  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

		//	//Setup 2nd Graph Axis with Numerical Scale
		//	var graphAxisNumericalScale6 = new GraphAxis();
		//	graphAxisNumericalScale6.Name = "Y Axis 2";
		//	graphAxisNumericalScale6.Scale = new NumericalScale();
		//	graphAxisNumericalScale6.Title = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion;
		//	graphAxisNumericalScale6.Style.Font.Name = font;
		//	graphAxisNumericalScale6.TitleStyle.Font.Name = font;
		//	graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
		//	graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
		//	graphAxisNumericalScale6.Style.LineColor = Color.White;
		//	graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
		//	// graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


		//	//The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
		//	var cartesianCoordinateSystem = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
		//	cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
		//	cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
		//	cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
		//	cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
		//	// cartesianCoordinateSystem.YAxis.LabelFormat = "#0k";
		//	cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
		//	cartesianCoordinateSystem.XAxis.LabelAngle = 270;

		//	var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
		//	cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
		//	cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
		//	cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
		//	cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
		//	cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

		//	reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

		//	//The Graph Series area
		//	var barSeries1 = new BarSeries();
		//	barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
		//	barSeries1.CoordinateSystem = cartesianCoordinateSystem;
		//	barSeries1.LegendItem.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor;
		//	barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
		//	barSeries1.Y = yAxisGroup;
		//	reportGraphName.Series.Add(barSeries1);
		//	barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
		//	barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, format.Insert(9, ".##"));


		//	//The Line Series area
		//	var lineSeries1 = new LineSeries();
		//	lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
		//	lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
		//	lineSeries1.LegendItem.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)";
		//	lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
		//	lineSeries1.Y = yAxisGroup2;
		//	lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
		//	reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
		//	reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
		//	reportGraphName.Series.Add(lineSeries1);
		//	lineSeries1.ColorPalette = new ColorPalette(Color.Black);

		//	return reportGraphName;
		//}


		public FinancialYearVM GetFinancialWeekList(DateTime passedDateTime, CompanySetting companySetting)
		{
			//temporary
			//passedDateTime = new DateTime(2013, 7, 18);

			var fvm = new FinancialYearVM();
			string[] financialWeek = { "1", "1" };
			DayOfWeek firstDayOfWeek = new DayOfWeek();
			if (companySetting.FinancialWeekDate != null)
				financialWeek = new string[] { companySetting.FinancialWeekDate };
			firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
				? DayOfWeek.Sunday
				: companySetting.FirstDayOfWeek == "Saturday"
					? DayOfWeek.Saturday
					: companySetting.FirstDayOfWeek == "Friday"
						? DayOfWeek.Friday
						: DayOfWeek.Monday;

			DateTime startd = passedDateTime;
			DateTime thisYearCompanyFinancialWeekStart = new DateTime();
			DateTime thisYearCompanyFinancialWeekEnd = new DateTime();

			DateTime lastYearCompanyFinancialWeekStart = new DateTime();
			DateTime lastYearCompanyFinancialWeekEnd = new DateTime(1);

			//default financial date
			DateTime setCompanyFinancialStartDate = companySetting.DateFormat == "dateFirst"
				? DateTime.ParseExact(companySetting.FinancialWeekDate, "dd/MM/yyyy", CultureInfo.InvariantCulture)
				: DateTime.ParseExact(companySetting.FinancialWeekDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
			DateTime setCompanyFinancialEndDate =
				Utility.GetFinancialYearEndDate(setCompanyFinancialStartDate, firstDayOfWeek);

			thisYearCompanyFinancialWeekStart = setCompanyFinancialEndDate.AddDays(1);
			thisYearCompanyFinancialWeekEnd =
				Utility.GetFinancialYearEndDate(thisYearCompanyFinancialWeekStart, firstDayOfWeek);

			lastYearCompanyFinancialWeekStart = setCompanyFinancialStartDate;
			lastYearCompanyFinancialWeekEnd = setCompanyFinancialEndDate;

			var tmpLastYear = new FinancialStartEnd();
			tmpLastYear.FinancialStartDate = lastYearCompanyFinancialWeekStart;
			tmpLastYear.FinancialEndDate = lastYearCompanyFinancialWeekEnd;

			var tmpThisYear = new FinancialStartEnd();
			tmpThisYear.FinancialStartDate = thisYearCompanyFinancialWeekStart;
			tmpThisYear.FinancialEndDate = thisYearCompanyFinancialWeekEnd;

			fvm.LastYear = tmpLastYear;
			fvm.ThisYear = tmpThisYear;
			//default financial date


			//do checking to see if passedDate is inside the range of this year financial period
			if (passedDateTime >= fvm.ThisYear.FinancialStartDate && passedDateTime <= fvm.ThisYear.FinancialEndDate)
			{

			}
			//if false
			else
			{
				//calculate the difference of the passedDate with fvm this year startDate
				//fiscal year smaller than default one
				Double differenceInYear = new Double();
				if (passedDateTime < thisYearCompanyFinancialWeekStart)
				{
					differenceInYear =
						(double)(Convert.ToDecimal((thisYearCompanyFinancialWeekStart - passedDateTime).TotalDays) /
								 365.25m);
					DateTime tmpLastStart = new DateTime();
					DateTime tmpLastEnd = new DateTime();
					DateTime tmpThisStart = thisYearCompanyFinancialWeekStart;
					DateTime tmpThisEnd = new DateTime();
					for (var i = 0.0; i < differenceInYear; i++)
					{
						tmpThisEnd = tmpThisStart.AddDays(-1);
						tmpThisStart = tmpThisEnd.AddMonths(-12).AddDays(1);

						var tmpDtDayOfWeek = (int)tmpThisStart.DayOfWeek == 0 ? 0 : (int)tmpThisStart.DayOfWeek;
						var tmpFirstDayOfWeek = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
						int dif = tmpFirstDayOfWeek - tmpDtDayOfWeek;

						tmpThisStart = tmpThisStart.AddDays(dif);
						if (dif < 0)
							dif = dif * -1;
						if (dif >= 4)
						{
							tmpThisStart = tmpThisStart.AddDays(-7);
						}
					}
					//tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);


					tmpLastEnd = tmpThisStart.AddDays(-1);
					tmpLastStart = tmpLastEnd.AddMonths(-12).AddDays(1);

					var tmpDtDayOfWeek2 = (int)tmpLastStart.DayOfWeek == 0 ? 0 : (int)tmpLastStart.DayOfWeek;
					var tmpFirstDayOfWeek2 = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
					int dif2 = tmpFirstDayOfWeek2 - tmpDtDayOfWeek2;

					tmpLastStart = tmpLastStart.AddDays(dif2);
					if (dif2 < 0)
						dif2 = dif2 * -1;
					if (dif2 >= 4)
					{
						tmpLastStart = tmpLastStart.AddDays(-7);
					}
					//int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
					//tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);

					//if ((int)firstDayOfWeek >= 4 && (int)firstDayOfWeek != 7)
					//{
					//    tmpLastStart = tmpLastStart.AddDays(-7);
					//}

					tmpLastYear.FinancialStartDate = tmpLastStart;
					tmpLastYear.FinancialEndDate = tmpLastEnd;

					tmpThisYear.FinancialStartDate = tmpThisStart;
					tmpThisYear.FinancialEndDate = tmpThisEnd;

					fvm.LastYear = tmpLastYear;
					fvm.ThisYear = tmpThisYear;

					return fvm;
				}

				//fiscal year greater than default one
				else if (passedDateTime > thisYearCompanyFinancialWeekEnd)
				{
					differenceInYear =
						(double)(Convert.ToDecimal((passedDateTime - thisYearCompanyFinancialWeekStart).TotalDays) /
								 365.25m);
					DateTime tmpLastStart = new DateTime();
					DateTime tmpLastEnd = new DateTime();
					DateTime tmpThisStart = thisYearCompanyFinancialWeekEnd.AddDays(1);
					DateTime tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
					for (var i = 0.0; i < differenceInYear - 1; i++)
					{
						if (i > 0)
						{
							tmpThisStart = tmpThisEnd.AddDays(1);
							tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
						}
					}

					tmpLastEnd = tmpThisStart.AddDays(-1);
					tmpLastStart = tmpLastEnd.AddMonths(-12);
					int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
					tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);
					if ((pushLastWeekStartToFirstDay * -1) >= 4)
					{
						tmpLastStart = tmpLastStart.AddDays(7);
					}


					tmpLastYear.FinancialStartDate = tmpLastStart;
					tmpLastYear.FinancialEndDate = tmpLastEnd;

					tmpThisYear.FinancialStartDate = tmpThisStart;
					tmpThisYear.FinancialEndDate = tmpThisEnd;

					fvm.LastYear = tmpLastYear;
					fvm.ThisYear = tmpThisYear;

					return fvm;
				}
			}
			return fvm;
		}

		public static string CheckDay(DateTime valueDateTime)
		{
			DayOfWeek dow = valueDateTime.DayOfWeek;
			return dow.ToString();
		}

		public static string CheckSalesConversionOverview(double salesConversion)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Math.Abs(Math.Round(salesConversion, 2)) + "%";
			}
		}

		public static string CheckSalesConversion(double salesConversion)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Math.Abs(Math.Round(salesConversion, 2)).ToString();
			}
		}

		public static string CheckTransactionCount(int transactionCount)
		{
			string format = "{0:N0}";

			if (transactionCount == 0)
			{
				return string.Format("{0:0;-0;-\"\"}", transactionCount);
			}
			else
			{
				return string.Format(format, transactionCount);
			}
		}

		public static string CheckBestPerformDay(double salesConversion, string bestPerformDay)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return bestPerformDay;
			}
		}

		public static string CheckRanking(double salesConversion, int Rank)
		{
			if (salesConversion == 0)
			{
				return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
			}
			else
			{
				return Rank.ToString();
			}
		}

		public static System.Drawing.Image GetDiffImage(double salesConversion)
		{
			if (salesConversion > 0)
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
			}
			else if (salesConversion < 0)
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
			}
			else
			{
				return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
			}
		}

		public static DataSource sevenDayTrend(string branchCode)
		{
			var objectDataSource1 = new Telerik.Reporting.ObjectDataSource();

			try
			{
				var result = sevenDayTrendData.Where(w => w.BranchCode == branchCode).Select(
					s => new BranchSummaryDailyReportViewModel
					{
						Date = s.Date,
						SalesConversion = s.SalesConversion,
						BranchCode = s.BranchCode
					});

				objectDataSource1.DataSource = result;

				return objectDataSource1;
			}
			catch
			{
				return objectDataSource1;
			}

		}
	}
}