namespace RetailCamControlPanel
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using RetailCamControlPanel.Helper;
    using Models;
    using System.Globalization;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web.Mvc;
    //using Resources;
    using System.Threading;
    using System.Web;
    using System.Configuration;

    /// <summary>
    /// Summary description for Report2.
    /// </summary>
    public partial class SiteSalesConversionDaily : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        public SiteSalesConversionDaily()
        {
            InitializeComponent();
        }

        private void SiteSalesConversionDaily_NeedDataSource(object sender, EventArgs e)
        {
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
            var companyServices = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                var startDate = Report.Parameters["Date"].Value.ToString();
                // var date = startDate.Value.ToString();
                // var dateDay = startDate.Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var dateFormat = 1;

                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var BranchId = Report.Parameters["BranchID"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                var stores = Report.Parameters["Stores"].Value.ToString();
                var userRole = Report.Parameters["userRole"].Value.ToString();
                var culture = new System.Globalization.CultureInfo(language);

                //DateTime dt = Convert.ToDateTime(dateDay); //for testing date string
                DateTime dt = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    dt = DateTime.ParseExact(startDate, "dd/MM/yyyy", culture);
                }
                else
                {
                    dt = DateTime.ParseExact(startDate, "MM/dd/yyyy", culture);
                    dateFormat = 2;
                }
                DayOfWeek dow = dt.DayOfWeek;
                var day = culture.DateTimeFormat.GetDayName(dow);

                //var branchId = 0;
                var twoYearsWorth = false;
                var maxDate = startDate;
                //  var startd = new DateTime(2017, 6, 6);
                var startd = dt;
                var tempmaxDate = startd;
                string font = Utility.Telerik_GetDefaultFontName();
                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                var company = companyServices.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                var ffBranchSpecialOperatingHourService = MvcApplication.container.GetInstance<FFBranchSpecialOperatingHourService>();
                var ffBranchOperatingHourService = MvcApplication.container.GetInstance<FFBranchOperatingHourService>();
                //check operatingtime
                var specialOperatingHour = ffBranchSpecialOperatingHourService.GetSiteSpecialOperatingHour(Convert.ToInt64(Convert.ToDecimal(BranchId))).FirstOrDefault(x => x.Date == startd);
                var operatingHours = ffBranchOperatingHourService.GetStoreOperatingHour(Convert.ToInt64(Convert.ToDecimal(BranchId))).Where(x => x.isDayOff == false && x.Day == (int)dow).ToList();


                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                string[] financialWeek = { "1", "1" };
                if (companySetting != null)
                {
                    min = companySetting.DwellTimeCategoriesMin != 0 ? companySetting.DwellTimeCategoriesMin : 15;
                    max = companySetting.DwellTimeCategoriesMax != 0 ? companySetting.DwellTimeCategoriesMax : 30;
                    if (companySetting.FinancialWeekDate != null)
                        financialWeek = new string[] { companySetting.FinancialWeekDate };
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday" ? DayOfWeek.Sunday : companySetting.FirstDayOfWeek == "Saturday" ? DayOfWeek.Saturday : DayOfWeek.Monday;
                }

                else
                {
                    firstDayOfWeek = DayOfWeek.Sunday;
                }

                //Setting the language
                if (language == "zh-TW" || language == "zh")
                {
                    //To cater for PDF generation
                    font = Utility.Telerik_GetDefaultFontName();

                    //Report Header
                    reportTitle.Style.Font.Name = font;
                    dayDate.Style.Font.Name = font;

                    //Overview Table
                    textBox100.Style.Font.Name = font;
                    textBox14.Style.Font.Name = font;
                    textBox12.Style.Font.Name = font;
                    textBox16.Style.Font.Name = font;

                    //Section
                    salesConversionSection.Style.Font.Name = font;

                    //To cater for appearance
                    salesConversionSection.Style.Font.Size = new Unit(30);
                    //ToolTip.Location= new PointU(new Unit(1.74, UnitType.Inch), new Unit(2.12, UnitType.Inch));
                }

                if (BranchId == "")
                    BranchId = "0";

                var dailyReportRawData = ffcompositeServices.GetBranchSummaryReport(startd, null, branchId: Convert.ToInt64(BranchId), userRole: userRole).OrderByDescending(o => o.Date).ToList();
                var transactionCountSum = 0;

                //Data obtaining - Checking if data exists
                var branchSummaryDailyReportViewModel = dailyReportRawData.OrderByDescending(o => o.Date).FirstOrDefault();
                if (branchSummaryDailyReportViewModel != null && (dailyReportRawData.Count > 0 && branchSummaryDailyReportViewModel.PatchStatus != "Predict"))
                {
                    maxDate = (dateFormat == 2)
                        ? dailyReportRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("MM'/'dd'/'yyyy")
                        : dailyReportRawData.Max(s => Utility.ConvertToDateTime(s.Date)).ToString("dd'/'MM'/'yyyy");
                    tempmaxDate = dailyReportRawData.Max(s => Utility.ConvertToDateTime(s.Date));
                    transactionCountSum = dailyReportRawData.Where(s => s.Date == Utility.ConvertToTimestamp(tempmaxDate)).Sum(s => s.TransactionCount);
                }

                if (transactionCountSum == 0 || (maxDate != startDate || dailyReportRawData.Count == 0 || operatingHours.Count == 0) && specialOperatingHour == null || specialOperatingHour != null && specialOperatingHour.isDayOff == true)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    note.Visible = false;
                    ToolTip.Visible = false;
                    overviewTable.Visible = false;
                    salesConversionSection.Visible = false;
                    sectionLine.Visible = false;
                    dailyTrend.Visible = false;
                    graph1.Visible = false;
                    storeTable.Visible = false;
                    //if (operatingHours.Count == 0 || specialOperatingHour != null && specialOperatingHour.isDayOff == true)
                    if (operatingHours.Count == 0 && specialOperatingHour == null || specialOperatingHour != null && specialOperatingHour.isDayOff == true)
                    {
                        errorBox.Value = "ERR101";
                    }
                    else
                    {
                        errorBox.Value = "ERR103";
                    }

                    errorMessage.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_ReportIsNotAvailable;
                }

                else
                {
                    //Disable errorBox
                    var hourlyReportRawData = ffcompositeServices.GetBranchHourlyReport(startd, null, branchId: Convert.ToInt64(BranchId), userRole: userRole).OrderBy(o => o.ValueDateTime).ToList();
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    reportTitle.Value = (stores == "")
                       ? SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversionDailyReport.ToUpper() + " "
                       : stores.ToUpper() + " " + SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversionDailyReport.ToUpper() +
                         " ";
                    dayDate.Value = day + " " + startDate;

                    //caculate diff in values for top matrices
                    var diffInValues = ffBranchSummaryDailyReportService.CalculateDiffOfTwoDates(dailyReportRawData);

                    //graph data for top matrices and table content
                    var hourlyReportDataWithInOperatingHour = ffBranchSummaryHourlyReportService.GetDataInOperatingHour(hourlyReportRawData);

                    //sales conversion graph
                    var salesConversionGraphData = ffBranchSummaryHourlyReportService.CalculateOverallTrend(hourlyReportRawData, false, startd);

                    //sales conversion table content
                    var salesConversionTableData = ffBranchSummaryHourlyReportService.CalculateOverallTrend(hourlyReportDataWithInOperatingHour, false, startd);

                    var topmatricData = ffBranchSummaryDailyReportService.CalculateMatricData(dailyReportRawData, false, null);

                    //Data plotting

                    overviewTable.DataSource = topmatricData;

                    TelerikUtility.PlotAreaGraph_NoAxes(graphOutsideTrafficOverview.ToString(), graphOutsideTrafficOverview, salesConversionTableData, "=Fields.Hour", "=Fields.OutsideTraffic");
                    TelerikUtility.PlotAreaGraph_NoAxes(graphTurnInRateOverview.ToString(), graphTurnInRateOverview, salesConversionTableData, "=Fields.Hour", "=Fields.TurnInRate");
                    TelerikUtility.PlotAreaGraph_NoAxes(graphTotalVisitorsOverview.ToString(), graphTotalVisitorsOverview, salesConversionTableData, "=Fields.Hour", "=Fields.ValueIn");
                    TelerikUtility.PlotAreaGraph_NoAxes(graphSalesConversionOverview.ToString(), graphSalesConversionOverview, salesConversionTableData, "=Fields.Hour", "=Fields.SalesConversion");

                    var maxValueIn = salesConversionGraphData.Max(s => s.ValueIn);
                    var minValueIn = salesConversionGraphData.Min(s => s.ValueIn);
                    var denominator = TelerikUtility.CheckValueDenominator(minValueIn, maxValueIn);
                    var FormatString = TelerikUtility.DenominatedStringFormat(denominator);

                    var graphDailyDataSource = salesConversionGraphData.AsReadOnly().Select(s => new BranchSummaryHourlyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominator,
                        SalesConversion = s.SalesConversion,
                        Hour = s.Hour,
                    });

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(graph1.ToString(), graph1,
                        graphDailyDataSource, "=Fields.Hour", SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_Hour, "=Fields.ValueInDouble", SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion + " (%)", font, FormatString, "{0:0.##}");

                    storeTable.DataSource = salesConversionTableData;

                    textBox100.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_OutsideTraffic;
                    textBox14.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_TurnInRate;
                    textBox16.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_TotalVisitors;
                    textBox12.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion;

                    //StoreTable
                    storeHeader.Style.Font.Name = font;
                    visitorCountHeader.Style.Font.Name = font;
                    turnInRateHeader.Style.Font.Name = font;
                    outsideTrafficHeader.Style.Font.Name = font;
                    transactionQuantityHeader.Style.Font.Name = font;
                    salesConversionHeader.Style.Font.Name = font;
                    dailyTrend.Style.Font.Name = font;
                    AverageTransactionValueHeader.Style.Font.Name = font;

                    //Store Table language settings
                    storeHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_Time;
                    visitorCountHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_VisitorCounts;
                    outsideTrafficHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_OutsideTraffic;
                    turnInRateHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_TurnInRate;
                    transactionQuantityHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_TransactionQuantity;
                    AverageTransactionValueHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_AverageTransactionValue;
                    salesConversionHeader.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion + " (%)";
                    dailyTrend.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_DailyTrend;

                    //Section
                    salesConversionSection.Style.Font.Name = font;

                    //Section language settings
                    salesConversionSection.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion.ToUpper();
                    note.Value = "* " + SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_Note + ": " + SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_VarienceVersusLastWeek;


                    //PDF setting
                    storeTable.ColumnHeadersPrintOnEveryPage = true;

                    //Attach link to graph
                    Telerik.Reporting.NavigateToUrlAction UrlAction1 = new Telerik.Reporting.NavigateToUrlAction();
                    if (dateFormat == 2)
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=1&parameter=101,311&start=" + dt.ToString("MM'/'dd'/'yyyy") + "&end=" + dt.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&branchId=" + BranchId + "&selectedMode=site&isGeneratePDF=false";
                    else
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=1&parameter=101,311&start=" + dt.ToString("dd'/'MM'/'yyyy") + "&end=" + dt.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&branchId=" + BranchId + "&selectedMode=site&isGeneratePDF=false";
                    graph1.Action = UrlAction1;
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        //public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> dataList, string categoryGraphGroup, string yAxisGroup)
        //{
        //    //Data plotting - Traffic Profile Weekday
        //    reportGraphName.Name = graphName;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = dataList;

        //    //Create the category group
        //    var categoryGroup = new GraphGroup();
        //    categoryGroup.Name = "categoryGroup";
        //    categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(categoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var seriesGroup = new GraphGroup();
        //    seriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(seriesGroup);

        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Style.Visible = false;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            
        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale = new GraphAxis();
        //    graphAxisNumericalScale.Name = "Y Axis";
        //    graphAxisNumericalScale.Scale = new NumericalScale();
        //    graphAxisNumericalScale.Style.Visible = false;
        //    graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

        //    //The Graph Series area
        //    var areaGraph = new AreaSeries();
        //    areaGraph.CategoryGroup = categoryGroup;
        //    areaGraph.CoordinateSystem = cartesianCoordinateSystem;
        //    areaGraph.LegendItem.Style.Visible = false;
        //    areaGraph.SeriesGroup = seriesGroup;
        //    areaGraph.Y = yAxisGroup;
        //    reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    reportGraphName.Series.Add(areaGraph);

        //    return reportGraphName;
        //}

        //public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, System.Collections.Generic.IEnumerable<BranchSummaryHourlyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisCategoryScale.Style.Font.Style = FontStyle.Regular;
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale();
        //    graphAxisCategoryScale2.Style.Visible = false;
        //    graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.LabelFormat = "{0:N0}";
        //    graphAxisNumericalScale5.Scale = new NumericalScale();
        //    graphAxisNumericalScale5.Title = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_NoofVisitor;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale5.Style.Font.Style = FontStyle.Regular;
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;

        //    //Setup 2nd Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale6 = new GraphAxis();
        //    graphAxisNumericalScale6.Name = "Y Axis 2";
        //    graphAxisNumericalScale6.Scale = new NumericalScale();
        //    graphAxisNumericalScale6.Title = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion + " (%)";
        //    graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    // graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);
        //    graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisNumericalScale6.Style.Font.Style = FontStyle.Regular;
        //    graphAxisNumericalScale6.Style.Font.Name = font;
        //    graphAxisNumericalScale6.TitleStyle.Font.Name = font;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 270;

        //    var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    reportGraphName.Series.Add(barSeries1);
        //    barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, "{0:N0}");

        //    //The Line Series area
        //    var lineSeries1 = new LineSeries();
        //    lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    lineSeries1.LegendItem.Value = SiteSalesConversionDailyReportViewer.SiteSalesConversionDailyReportViewer_SalesConversion + " (%)";
        //    lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    lineSeries1.Y = yAxisGroup2;
        //    lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //    reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
        //    reportGraphName.Series.Add(lineSeries1);
        //    lineSeries1.ColorPalette = new ColorPalette(Color.Black);

        //    return reportGraphName;
        //}

        public static string CheckSalesConversionOverview(double salesConversion)
        {
            if (salesConversion == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
            }
            else
            {
                return Math.Abs(Math.Round(salesConversion, 2)) + "%";
            }
        }

        //binding int
        public static string CheckOutsideTraffic(int OutsideTrafficTotal)
        {
            string format = "{0:N0}";

            if (OutsideTrafficTotal == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", OutsideTrafficTotal);
            }
            else
            {
                //return OutsideTrafficTotal.ToString();
                return string.Format(format, OutsideTrafficTotal);
            }
        }

        //binding string without %
        public static string CheckValueIn(double ValueInTotal)
        {
            if (ValueInTotal == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", ValueInTotal);
            }
            else
            {
                return Math.Abs(Math.Round(ValueInTotal, 2)).ToString();
            }
        }

        public static string CheckAverageTransactionValue (double AverageTransactionValue)
        {
            if (AverageTransactionValue == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", AverageTransactionValue);
            }
            else
            {
                return Math.Abs(Math.Round(AverageTransactionValue, 2)).ToString();
            }
        }

    }
}