using System.Web;

namespace RetailCamControlPanel
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using RetailCamControlPanel.Helper;
    using Models;
    using System.Globalization;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading;

    //using Resources;
    using System.Configuration;
    using System.Reflection;
    using System.Data.Entity;

    /// <summary>
    /// Summary description for Report3.
    /// </summary>
    public partial class SiteSalesConversionWeekly : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        public static BranchSummaryDailyReportViewModel leagueStatisticsRawData;

        public SiteSalesConversionWeekly()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void SiteSalesConversionWeekly_NeedDataSource(object sender, EventArgs e)
        {
            //services
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
            var companyServices = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Data obtaining - Company name and date for UI
                var startDateUI = Report.Parameters["Date"].Value;
                var endDateUI = Report.Parameters["endDate"].Value;
                var weekNumber = Report.Parameters["Week"].Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                dayDate.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week + " " + weekNumber + ")";
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var branchID = Report.Parameters["BranchID"].Value.ToString();
                var stores = Report.Parameters["Stores"].Value.ToString();
                reportTitle.Value = stores.ToUpper() + " " + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SiteSalesConversionWeeklyReport.ToUpper();
                var language = Report.Parameters["Language"].Value.ToString();
                string font = Utility.Telerik_GetDefaultFontName();
                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                var company = companyServices.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                string[] financialWeek = { "1", "1" };


                //Setting the language (Not required as it is using Arial Unicode MS) [Kelvin]
                //if (language == "zh-TW" || language == "zh")
                //{
                //    //To cater for PDF generation
                //    font = Utility.Telerik_GetDefaultFontName();

                //    //Report Header
                //    reportTitle.Style.Font.Name = font;
                //    dayDate.Style.Font.Name = font;

                //    //Overview Table
                //    ThisWeek.Style.Font.Name = font;
                //    LastWeek.Style.Font.Name = font;
                //    Changes.Style.Font.Name = font;
                //    BestPerformDay.Style.Font.Name = font;
                //    OutsideTraffic.Style.Font.Name = font;
                //    TurnInRate.Style.Font.Name = font;
                //    VisitorCount.Style.Font.Name = font;

                //    //LeagueStatistics
                //    LeagueStatistics.Style.Font.Name = font;

                //    //SalesConversion
                //    SalesConversionSection.Style.Font.Name = font;
                //    SCMonthlyTrend.Style.Font.Name = font;
                //    SCWeeklyTrend.Style.Font.Name = font;
                //    SCDailyTrend.Style.Font.Name = font;
                //    SCVisitorProfile.Style.Font.Name = font;
                //    SCWeekdays.Style.Font.Name = font;
                //    SCWeekends.Style.Font.Name = font;
                //    SCWeek.Style.Font.Name = font;
                //    SCNoofVisitor.Style.Font.Name = font;
                //    SCTransaction.Style.Font.Name = font;
                //    SCConversion.Style.Font.Name = font;

                //    //OutsideTraffic
                //    //titleOutsideTrafficSection_txt.Style.Font.Name = font;
                //    OTMonthlyTrend.Style.Font.Name = font;
                //    OTWeeklyTrend.Style.Font.Name = font;
                //    OTDailyTrend.Style.Font.Name = font;
                //    OTVisitorProfile.Style.Font.Name = font;
                //    OTWeekdays.Style.Font.Name = font;
                //    OTWeekends.Style.Font.Name = font;
                //    OTWeek.Style.Font.Name = font;
                //    OTOutsideTraffic.Style.Font.Name = font;
                //    OTNoofVisitor.Style.Font.Name = font;
                //    OTTurnInRate.Style.Font.Name = font;
                //    GraphDataTextBox.Style.Font.Name = font;
                //    graphDataTextBox2.Style.Font.Name = font;

                //    //To cater for appearance
                //    SalesConversionSection.Style.Font.Size = new Unit(30);
                //    LeagueStatistics.Style.Font.Size = new Unit(30);

                //}

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                //DateTime startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                //DateTime endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);

                DateTime startd = new DateTime();
                DateTime endd = new DateTime();

                string dateFirstStringFormat = "dd/MM/yyyy";
                string monthFirstStringFormat = "MM/dd/yyyy";

                void ParseDateTime(string format)
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }

                if (dateFormatHtml == "dateFirst")
                {
                    try
                    {
                        ParseDateTime(dateFirstStringFormat);
                        //startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                        //endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        ParseDateTime(monthFirstStringFormat);
                    }
                }
                else
                {
                    try
                    {
                        ParseDateTime(monthFirstStringFormat);
                    }
                    catch
                    {
                        ParseDateTime(dateFirstStringFormat);
                    }
                    //startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    //endd = DateTime.ParseExact(endDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    //dateFormat = 2;
                }

                var maxDate = endd;

                long startTimestamp = Utility.ConvertToTimestamp(startd);
                long endTimestamp = Utility.ConvertToTimestamp(endd);

                long lastWeekStartTimestamp = Utility.ConvertToTimestamp(startd.AddDays(-7));
                long lastWeekEndTimestamp = Utility.ConvertToTimestamp(endd.AddDays(-7));

                var financialStartEnd = Utility.GetFinancialWeekList(startd, companySetting);
                DateTime startDate;

                //determine to get years worth of data
                switch (false)
                {
                    case true:
                        startDate = financialStartEnd.LastYear.FinancialStartDate;
                        break;
                    default:
                        startDate = financialStartEnd.ThisYear.FinancialStartDate;
                        break;
                }

                DateTime endDate = financialStartEnd.ThisYear.FinancialEndDate;

                //Date for Series Graph
                var ePochDateStart = Utility.ConvertToTimestamp(startd);
                var ePochDateEnd = Utility.ConvertToTimestamp(endd);

                var selectedRegion = "";
                //  var branchId = 529;

                //Raw Data
                var branchDailyRawData = ffcompositeServices.GetBranchSummaryReport(startDate, endd, selectedRegion, Convert.ToInt64(branchID), true, true);

                var hourlyRawData = ffcompositeServices.GetBranchHourlyReport(startd, endd, selectedRegion, Convert.ToInt64(branchID), firstDayOfWeek);


                //Data obtaining - Checking if data exists
                var branchSummaryDailyReportViewModel = branchDailyRawData.OrderByDescending(o => o.Date).FirstOrDefault();
                if (hourlyRawData.Count > 0 && branchSummaryDailyReportViewModel != null && branchSummaryDailyReportViewModel.PatchStatus != "Predict")
                {
                    maxDate = hourlyRawData.Max(s => s.ValueDateTime).Date;
                }

                //DATA SETTING RULE CHECKING START [Kelvin, 2019-11-01]
                bool isExcludeDataIfPartial = false;
                if (company.DataSettings.Count() > 0)
                {
                    foreach (var setting in company.DataSettings)
                    {
                        //Is Exclude Data if Partial
                        if (setting.Type.ID == 2)
                        {
                            isExcludeDataIfPartial = Utility.ReadJson<bool>(setting.Attribute);
                        }
                    }
                }

                //DATA SETTING FILTERING
                if (isExcludeDataIfPartial)
                {
                    branchDailyRawData = branchDailyRawData.Where(w => w.AggregationStatus == 2).ToList();
                    List<DateTime> remainingDates = branchDailyRawData.Select(s => s.ValueDateTime).Distinct().ToList();
                    hourlyRawData = hourlyRawData.Where(w => remainingDates.Contains(w.ValueDateTime.Date)).ToList();

                    int coverageDays = branchDailyRawData.Where(w => w.ValueDateTime <= endd && w.ValueDateTime >= startd).Count();

                    dayDate.Value = dayDate.Value + "\n" + coverageDays + " Coverage Day" + (coverageDays > 1 ? "s" : "");

                }

                var transactionCountSum = hourlyRawData.Sum(s => s.TransactionCount);


                //END DATA SETTING RULE CHECKING

                //Default Element Visibility [Kelvin]
                sectionOutsideTraffic_panel.Visible = false;
                outsideTraffic2_panel.Visible = false;


                if (maxDate < endd || hourlyRawData.Count == 0 || transactionCountSum == 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    Note.Visible = false;
                    overviewTable.Visible = false;
                    LeagueStatistics.Visible = false;
                    WeeklyConversion.Visible = false;
                    ThisStore.Visible = false;
                    LSWeeklyConversionSolesConversion.Visible = false;
                    CoRank.Visible = false;
                    Company.Visible = false;
                    Range.Visible = false;
                    LSCompanySalesConversion.Visible = false;
                    Average.Visible = false;
                    Lowest.Visible = false;
                    Highest.Visible = false;
                    SalesConversionSection.Visible = false;
                    SCMonthlyTrend.Visible = false;
                    SCWeek.Visible = false;
                    SCNoofVisitor.Visible = false;
                    SCTransaction.Visible = false;
                    SCConversion.Visible = false;
                    SCTotal.Visible = false;
                    SCWeeklyTrend.Visible = false;
                    SCDailyTrend.Visible = false;
                    SCVisitorProfile.Visible = false;
                    SCWeekdays.Visible = false;
                    SCWeekends.Visible = false;
                    SalesConversionTable.Visible = false;
                    weekendsDataNotAvailable_txt.Visible = false;
                    sectionLine.Visible = false;
                    shape1.Visible = false;
                    WeeklyConversionTable.Visible = false;
                    CompanyTable.Visible = false;
                    shape2.Visible = false;
                    errorBox.Value = "ERR103";
                    errorMessage.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_ReportIsNotAvailable;

                }
                else
                {
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    var hourlyFilteredRawData =
                        ffBranchSummaryHourlyReportService.GetDataWithinOperatingHour(hourlyRawData, true, true);


                    //Monthly Trend
                    var monthlyBranchSummary = ffBranchSummaryDailyReportService.CalculateMonthlyTrend(branchDailyRawData, startd, firstDayOfWeek, financialStartEnd, companySetting);

                    //Weekly Trend
                    var weeklyBranchSummary = ffBranchSummaryDailyReportService.CalculateWeeklyTrend(branchDailyRawData, startd, firstDayOfWeek, financialStartEnd);

                    //Daily Trend
                    var dailyBranchSummary = ffBranchSummaryDailyReportService.CalculateDailyTrend(branchDailyRawData, endd);

                    var topMatricData = ffBranchSummaryDailyReportService.CalculateMatricData(branchDailyRawData, true, endd);

                    overviewTable.DataSource = topMatricData;

                    string formatGroup = "{0:N0}";



                    TotalNoOfVisitor.Value = topMatricData.ValueIn == 0 ? "-" : string.Format(formatGroup, topMatricData.ValueIn);
                    TotalTransactionCount.Value = topMatricData.TransactionCount == 0 ? "-" : string.Format(formatGroup, topMatricData.TransactionCount);
                    TotalSalesConversionValue.Value = topMatricData.SalesConversion == 0 ? "-" : topMatricData.SalesConversion.ToString();
                    TotalOutsideTraffic.Value = topMatricData.OutsideTraffic == 0 ? "-" : string.Format(formatGroup, topMatricData.OutsideTraffic);
                    TotalNoOfVisitor2.Value = topMatricData.ValueIn == 0 ? "-" : string.Format(formatGroup, topMatricData.ValueIn);
                    TotalTurnInRate.Value = topMatricData.TurnInRate == 0 ? "-" : topMatricData.TurnInRate.ToString();

                    var weekdayRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == false)
                        .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    var weekdayVisitorProfile =
                        ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekdayRawData, true, true);

                    var weekendRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == true)
                        .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    var weekendVisitorProfile =
                        ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekendRawData, true, true);

                    //League Statistics
                    var companyWideWeeklyBranchSummaryTrend = ffcompositeServices.GetBranchSummaryReport(startd, endd, leagueStatistic: true, comCode: companyCode).OrderByDescending(o => o.SalesConversion).ToList();
                    leagueStatisticsRawData = ffBranchSummaryDailyReportService.CalculateLeagueStatistics(companyWideWeeklyBranchSummaryTrend, startd, Convert.ToInt64(branchID));

                    SalesConversionTable.DataSource = dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= startTimestamp && w.Timestamp <= endTimestamp);
                    OutsideTrafficTable.DataSource = dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= startTimestamp && w.Timestamp <= endTimestamp);

                    List<WeeklyData> thisAndLastWeeklyData = new List<WeeklyData>();
                    thisAndLastWeeklyData = ffBranchSummaryDailyReportService.GetThisAndLastWeekData(weeklyBranchSummary, startd, endd);

                    List<List<DailyData>> thisAndLastWeekDailyData = new List<List<DailyData>>();
                    thisAndLastWeekDailyData.Add(dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= lastWeekStartTimestamp && w.Timestamp <= lastWeekEndTimestamp).ToList());//last week dailyData
                    thisAndLastWeekDailyData.Add(dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= startTimestamp && w.Timestamp <= endTimestamp).ToList());//this week dailyData

                    var weeklyDataDifferences = ffBranchSummaryDailyReportService.CalculateDifference(thisAndLastWeeklyData);


                    //Report Header language settings
                    reportTitle.Value = (selectedRegion == "") ? stores.ToUpper() + " " + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_StoreSalesConversionReport.ToUpper() + " " : stores.ToUpper() + " (" + selectedRegion.ToUpper() + ") " + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_StoreSalesConversionReport.ToUpper() + " ";
                    //dayDate.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week + " " + weekNumber + ")";

                    ThisWeek.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_ThisWeek;
                    LastWeek.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_LastWeek;
                    Changes.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Changes;
                    BestPerformDay.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_BestPerformDay;
                    OutsideTraffic.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic;
                    TurnInRate.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_TurnInRate;
                    VisitorCount.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_VisitorCount;

                    //Section language setting
                    LeagueStatistics.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_LeagueStatistics.ToUpper();
                    SalesConversionSection.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion.ToUpper();
                    SCMonthlyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_MonthlyTrend;
                    SCWeeklyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_WeeklyTrend;
                    SCDailyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_DailyTrend;
                    SCVisitorProfile.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_VisitorProfile;
                    SCWeekdays.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Weekdays;
                    SCWeekends.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Weekends;
                    //titleOutsideTrafficSection_txt.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic.ToUpper();
                    //OTMonthlyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_MonthlyTrend;
                    //OTWeeklyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_WeeklyTrend;
                    //OTDailyTrend.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_DailyTrend;
                    //OTVisitorProfile.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_VisitorProfile;
                    //OTWeekdays.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Weekdays;
                    //OTWeekends.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Weekends;
                    WeeklyConversion.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_WeeklyConversion;
                    Company.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Company;

                    Note.Value = "* " + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Note + ": " + SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_VarienceVersusLastWeek;

                    //Table language setting
                    ThisStore.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_ThisStore;
                    CoRank.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_CoRank;
                    Range.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Range;
                    Average.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Average;
                    Lowest.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Lowest;
                    Highest.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Highest;
                    SCWeek.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week + " " + weekNumber;
                    SCNoofVisitor.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
                    SCTransaction.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_TransactionCount;
                    SCConversion.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)";
                    SCTotal.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Total;
                    //OTWeek.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week;
                    //OTOutsideTraffic.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic;
                    //OTNoofVisitor.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
                    //OTTurnInRate.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_TurnInRate;
                    //OTTotal.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Total;

                    //WeeklyConversionTable.DataSource = leagueStatisticsRawData;
                    //CompanyTable.DataSource = leagueStatisticsRawData;
                    leagueStatisticsSalesConversion.Value = leagueStatisticsRawData.SalesConversion > 0 ? Math.Abs(Math.Round(leagueStatisticsRawData.SalesConversion, 2)) + "%" : "-";
                    companyRank.Value = leagueStatisticsRawData.Rank > 0 ? leagueStatisticsRawData.Rank + "/" + leagueStatisticsRawData.TotalNumberOfStores : "-/-";
                    AverageSalesConversion.Value = leagueStatisticsRawData.AverageSalesConversion > 0 ? Math.Abs(Math.Round(leagueStatisticsRawData.AverageSalesConversion, 2)) + "%" : "-";
                    LowestSalesConversion.Value = leagueStatisticsRawData.LowestSalesConversion > 0 ? Math.Abs(Math.Round(leagueStatisticsRawData.LowestSalesConversion, 2)) + "%" : "-";
                    HighestSalesConversionLeague.Value = leagueStatisticsRawData.HighestSalesConversion > 0 ? Math.Abs(Math.Round(leagueStatisticsRawData.HighestSalesConversion, 2)) + "%" : "-";
                    HighestSalesConversion.Value = leagueStatisticsRawData.HighestSalesConversion > 0 ? Math.Abs(Math.Round(leagueStatisticsRawData.HighestSalesConversion, 2)) + "%" : "-";
                    //  textBox19.Value = Math.Abs(Math.Round(thisAndLastWeeklyData[1].SalesConversion, 2)).ToString() + "%";
                    // textBox31.Value = Math.Abs(Math.Round(thisAndLastWeeklyData[1].TurnInRate, 2)).ToString() + "%";

                    //Tooltips Language
                    SCMonthlyTrend.ToolTip.Text = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Tooltip_MonthlyTrend;
                    SCWeeklyTrend.ToolTip.Text = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Tooltip_WeeklyTrend;
                    SCDailyTrend.ToolTip.Text = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Tooltip_DailyTrend;
                    SCVisitorProfile.ToolTip.Text = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Tooltip_VisitorProfile;

                    TelerikUtility.PlotAreaGraph_NoAxes(graph2.ToString(), graph2, thisAndLastWeekDailyData[1], "=Fields.Timestamp", "=Fields.SalesConversion");
                    TelerikUtility.PlotAreaGraph_NoAxes(graph11.ToString(), graph11, thisAndLastWeekDailyData[0], "=Fields.Timestamp", "=Fields.SalesConversion");
                    TelerikUtility.PlotAreaGraph_NoAxes(graph12.ToString(), graph12, thisAndLastWeekDailyData[1], "=Fields.Timestamp", "=Fields.OutsideTraffic");
                    TelerikUtility.PlotAreaGraph_NoAxes(graph13.ToString(), graph13, thisAndLastWeekDailyData[1], "=Fields.Timestamp", "=Fields.TurnInRate");
                    TelerikUtility.PlotAreaGraph_NoAxes(graph14.ToString(), graph14, thisAndLastWeekDailyData[1], "=Fields.Timestamp", "=Fields.ValueIn");

                    var maxValueInMonthlySalesConversion = monthlyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInMonthlySalesConversion = monthlyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorMonthlySalesConversion = TelerikUtility.CheckValueDenominator(minValueInMonthlySalesConversion, maxValueInMonthlySalesConversion);
                    var FormatStringMonthlySalesConversion = TelerikUtility.DenominatedStringFormat(denominatorMonthlySalesConversion);

                    //if (maxValueInMonthlySalesConversion >= 3000000 || minValueInMonthlySalesConversion >= 1000000)
                    //{
                    //    FormatStringMonthlySalesConversion = "{0:## ##0M}";
                    //    denominatorMonthlySalesConversion = 1000000;
                    //}

                    //else if (maxValueInMonthlySalesConversion >= 3000 || minValueInMonthlySalesConversion >= 1000)
                    //{
                    //    FormatStringMonthlySalesConversion = "{0:## ##0k}";
                    //    denominatorMonthlySalesConversion = 1000;
                    //}

                    var maxOutsideTrafficMonthly = monthlyBranchSummary.ThisYear.Max(s => s.OutsideTraffic);
                    var minOutsideTrafficMonthly = monthlyBranchSummary.ThisYear.Min(s => s.OutsideTraffic);
                    var denominatorMonthlyOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficMonthly, maxOutsideTrafficMonthly);
                    var FormatStringMonthlyOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorMonthlyOutsideTraffic);

                    //if (maxOutsideTrafficMonthly >= 3000000 || minOutsideTrafficMonthly >= 1000000)
                    //{
                    //    FormatStringMonthlyOutsideTraffic = "{0:## ##0M}";
                    //    denominatorMonthlyOutsideTraffic = 1000000;
                    //}

                    //else if (maxOutsideTrafficMonthly >= 3000 || minOutsideTrafficMonthly >= 1000)
                    //{
                    //    FormatStringMonthlyOutsideTraffic = "{0:## ##0k}";
                    //    denominatorMonthlyOutsideTraffic = 1000;
                    //}

                    var graphMonthlyDataSource = monthlyBranchSummary.ThisYear.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorMonthlySalesConversion,
                        SalesConversion = s.SalesConversion,
                        Month = s.Month,
                        OutsideTrafficDouble = (double)s.OutsideTraffic / denominatorMonthlyOutsideTraffic
                    });

                    var maxValueInWeeklySalesConversion = weeklyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInWeeklySalesConversion = weeklyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorWeeklySalesConversion = TelerikUtility.CheckValueDenominator(minValueInWeeklySalesConversion, maxValueInWeeklySalesConversion);
                    var FormatStringWeeklySalesConversion = TelerikUtility.DenominatedStringFormat(denominatorWeeklySalesConversion);

                    //if (maxValueInWeeklySalesConversion >= 3000000 || minValueInWeeklySalesConversion >= 1000000)
                    //{
                    //    FormatStringWeeklySalesConversion = "{0:## ##0M}";
                    //    denominatorWeeklySalesConversion = 1000000;
                    //}

                    //else if (maxValueInWeeklySalesConversion >= 3000 || minValueInWeeklySalesConversion >= 1000)
                    //{
                    //    FormatStringWeeklySalesConversion = "{0:## ##0k}";
                    //    denominatorWeeklySalesConversion = 1000;
                    //}

                    var maxOutsideTrafficWeekly = weeklyBranchSummary.ThisYear.Max(s => s.OutsideTraffic);
                    var minOutsideTrafficcWeekly = weeklyBranchSummary.ThisYear.Min(s => s.OutsideTraffic);
                    var denominatorWeeklyOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficcWeekly, maxOutsideTrafficWeekly);
                    var FormatStringcWeeklyOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorWeeklyOutsideTraffic);

                    //if (maxOutsideTrafficWeekly >= 3000000 || minOutsideTrafficcWeekly >= 1000000)
                    //{
                    //    FormatStringcWeeklyOutsideTraffic = "{0:## ##0M}";
                    //    denominatorWeeklyOutsideTraffic = 1000000;
                    //}

                    //else if (maxOutsideTrafficWeekly >= 3000 || minOutsideTrafficcWeekly >= 1000)
                    //{
                    //    FormatStringcWeeklyOutsideTraffic = "{0:## ##0k}";
                    //    denominatorWeeklyOutsideTraffic = 1000;
                    //}

                    var graphWeeklyDataSource = weeklyBranchSummary.ThisYear.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorWeeklySalesConversion,
                        SalesConversion = s.SalesConversion,
                        Week = s.Week.ToString(),
                        OutsideTrafficDouble = (double)s.OutsideTraffic / denominatorWeeklyOutsideTraffic

                    });

                    var maxValueInDailySalesConversion = dailyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    var minValueInDailySalesConversion = dailyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    var denominatorDailySalesConversion = TelerikUtility.CheckValueDenominator(minValueInDailySalesConversion, maxValueInDailySalesConversion);
                    var FormatStringDailySalesConversion = TelerikUtility.DenominatedStringFormat(denominatorDailySalesConversion);

                    //if (maxValueInDailySalesConversion >= 3000000 || minValueInDailySalesConversion >= 1000000)
                    //{
                    //    FormatStringDailySalesConversion = "{0:## ##0M}";
                    //    denominatorDailySalesConversion = 1000000;
                    //}

                    //else if (maxValueInDailySalesConversion >= 3000 || minValueInDailySalesConversion >= 1000)
                    //{
                    //    FormatStringDailySalesConversion = "{0:## ##0k}";
                    //    denominatorDailySalesConversion = 1000;
                    //}

                    var maxOutsideTrafficDaily = dailyBranchSummary.ThisYear.Max(s => s.OutsideTraffic);
                    var minOutsideTrafficDaily = dailyBranchSummary.ThisYear.Min(s => s.OutsideTraffic);
                    var denominatorDailyOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficDaily, maxOutsideTrafficDaily);
                    var FormatStringDailyOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorDailyOutsideTraffic);

                    //if (maxOutsideTrafficDaily >= 3000000 || minOutsideTrafficDaily >= 1000000)
                    //{
                    //    FormatStringDailyOutsideTraffic = "{0:## ##0M}";
                    //    denominatorDailyOutsideTraffic = 1000000;
                    //}

                    //else if (maxOutsideTrafficDaily >= 3000 || minOutsideTrafficDaily >= 1000)
                    //{
                    //    FormatStringDailyOutsideTraffic = "{0:## ##0k}";
                    //    denominatorDailyOutsideTraffic = 1000;
                    //}

                    var graphDailyDataSource = dailyBranchSummary.ThisYear.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorDailySalesConversion,
                        SalesConversion = s.SalesConversion,
                        DayOfWeek = s.Date,
                        OutsideTrafficDouble = (double)s.OutsideTraffic / denominatorDailyOutsideTraffic,

                    });

                    var maxValueInWeekdaySalesConversion = weekdayVisitorProfile.Max(s => s.ValueIn);
                    var minValueInWeekdaySalesConversion = weekdayVisitorProfile.Min(s => s.ValueIn);
                    var denominatorWeekdaySalesConversion = TelerikUtility.CheckValueDenominator(minValueInWeekdaySalesConversion, maxValueInWeekdaySalesConversion);
                    var FormatStringWeekdaySalesConversion = TelerikUtility.DenominatedStringFormat(denominatorWeekdaySalesConversion);

                    //if (maxValueInWeekdaySalesConversion >= 3000000 || minValueInWeekdaySalesConversion >= 1000000)
                    //{
                    //    FormatStringWeekdaySalesConversion = "{0:## ##0M}";
                    //    denominatorWeekdaySalesConversion = 1000000;
                    //}

                    //else if (maxValueInWeekdaySalesConversion >= 3000 || minValueInWeekdaySalesConversion >= 1000)
                    //{
                    //    FormatStringWeekdaySalesConversion = "{0:## ##0k}";
                    //    denominatorWeekdaySalesConversion = 1000;
                    //}

                    var maxOutsideTrafficWeekday = weekdayVisitorProfile.Max(s => s.OutsideTraffic);
                    var minOutsideTrafficWeekday = weekdayVisitorProfile.Min(s => s.OutsideTraffic);
                    var denominatorWeekdayOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficWeekday, maxOutsideTrafficWeekday);
                    var FormatStringWeekdayOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorWeekdayOutsideTraffic);

                    //if (maxOutsideTrafficWeekday >= 3000000 || minOutsideTrafficWeekday >= 1000000)
                    //{
                    //    FormatStringWeekdayOutsideTraffic = "{0:## ##0M}";
                    //    denominatorWeekdayOutsideTraffic = 1000000;
                    //}

                    //else if (maxOutsideTrafficWeekday >= 3000 || minOutsideTrafficWeekday >= 1000)
                    //{
                    //    FormatStringWeekdayOutsideTraffic = "{0:## ##0k}";
                    //    denominatorWeekdayOutsideTraffic = 1000;
                    //}


                    var graphWeekdayVisitorProfileDataSource = weekdayVisitorProfile.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                    {
                        ValueInDouble = (double)s.ValueIn / denominatorWeekdaySalesConversion,
                        SalesConversion = s.SalesConversion,
                        Hour = s.Hour,
                        OutsideTrafficDouble = (double)s.OutsideTraffic / denominatorWeekdayOutsideTraffic,

                    });

                    if (weekendRawData.Count == 0)
                    {
                        weekendTrendSalesConversion.Visible = false;
                        weekendTrendOutsideTraffic.Visible = false;
                        OTWeekendsDataNotAvailable_txt.Visible = true;
                        weekendsDataNotAvailable_txt.Visible = true;
                    }
                    else
                    {
                        OTWeekendsDataNotAvailable_txt.Visible = false;
                        weekendsDataNotAvailable_txt.Visible = false;

                        var maxValueInWeekendSalesConversion = weekendVisitorProfile.Max(s => s.ValueIn);
                        var minValueInWeekendSalesConversion = weekendVisitorProfile.Min(s => s.ValueIn);
                        var denominatorWeekendSalesConversion = TelerikUtility.CheckValueDenominator(minValueInWeekendSalesConversion, maxValueInWeekendSalesConversion);
                        var FormatStringWeekendSalesConversion = TelerikUtility.DenominatedStringFormat(denominatorWeekendSalesConversion);

                        //if (maxValueInWeekendSalesConversion >= 3000000 || minValueInWeekendSalesConversion >= 1000000)
                        //{
                        //    FormatStringWeekendSalesConversion = "{0:## ##0M}";
                        //    denominatorWeekendSalesConversion = 1000000;
                        //}

                        //else if (maxValueInWeekendSalesConversion >= 3000 || minValueInWeekendSalesConversion >= 1000)
                        //{
                        //    FormatStringWeekendSalesConversion = "{0:## ##0k}";
                        //    denominatorWeekendSalesConversion = 1000;
                        //}

                        var maxOutsideTrafficWeekend = weekendVisitorProfile.Max(s => s.OutsideTraffic);
                        var minOutsideTrafficWeekend = weekendVisitorProfile.Min(s => s.OutsideTraffic);
                        var denominatorWeekendOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficWeekend, maxOutsideTrafficWeekend);
                        var FormatStringWeekendOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorWeekendOutsideTraffic);

                        //if (maxOutsideTrafficWeekend >= 3000000 || minOutsideTrafficWeekend >= 1000000)
                        //{
                        //    FormatStringWeekendOutsideTraffic = "{0:## ##0M}";
                        //    denominatorWeekendOutsideTraffic = 1000000;
                        //}

                        //else if (maxOutsideTrafficWeekend >= 3000 || minOutsideTrafficWeekend >= 1000)
                        //{
                        //    FormatStringWeekendOutsideTraffic = "{0:## ##0k}";
                        //    denominatorWeekendOutsideTraffic = 1000;
                        //}

                        var graphWeekendVisitorProfileDataSource = weekendVisitorProfile.AsReadOnly().Select(s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekendSalesConversion,
                            SalesConversion = s.SalesConversion,
                            Hour = s.Hour,
                            OutsideTrafficDouble = (double)s.OutsideTraffic / denominatorWeekendOutsideTraffic,

                        });

                        TelerikUtility.PlotBarLineGraph_2YAxisLabel(weekendTrendSalesConversion.ToString(), weekendTrendSalesConversion,
                            graphWeekendVisitorProfileDataSource, "=Fields.Hour", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Hour, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeekendSalesConversion, "{0:0.##}");
                        TelerikUtility.PlotBarLineGraph_2YAxisLabel(weekendTrendOutsideTraffic.ToString(), weekendTrendOutsideTraffic,
                            graphWeekendVisitorProfileDataSource, "=Fields.Hour", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Hour, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.OutsideTrafficDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic, font, FormatStringWeekendSalesConversion, FormatStringWeekendOutsideTraffic);
                    }

                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(monthlyTrendSalesConversion.ToString(), monthlyTrendSalesConversion,
                         graphMonthlyDataSource, "=Fields.Month", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Month, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringMonthlySalesConversion, "{0:0.##}");
                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(weeklyTrendSalesConversion.ToString(), weeklyTrendSalesConversion,
                         graphWeeklyDataSource, "=Fields.Week", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeeklySalesConversion, "{0:0.##}");
                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(dailyTrendSalesConversion.ToString(), dailyTrendSalesConversion,
                         graphDailyDataSource, "=Fields.DayOfWeek", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Day, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringDailySalesConversion, "{0:0.##}");
                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(weekdayTrendSalesConversion.ToString(), weekdayTrendSalesConversion,
                         graphWeekdayVisitorProfileDataSource, "=Fields.Hour", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Hour, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.SalesConversion", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)", font, FormatStringWeekdaySalesConversion, "{0:0.##}");


                    //TelerikUtility.PlotBarLineGraph_2YAxisLabel(monthlyTrendOutsideTraffic.ToString(), monthlyTrendOutsideTraffic,
                    //     graphMonthlyDataSource, "=Fields.Month", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Month, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.OutsideTrafficDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic, font, FormatStringMonthlySalesConversion, FormatStringMonthlyOutsideTraffic);
                    //TelerikUtility.PlotBarLineGraph_2YAxisLabel(weeklyTrendOutsideTraffic.ToString(), weeklyTrendOutsideTraffic,
                    //    graphWeeklyDataSource, "=Fields.Week", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Week, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.OutsideTrafficDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic, font, FormatStringWeekdaySalesConversion, FormatStringcWeeklyOutsideTraffic);
                    //TelerikUtility.PlotBarLineGraph_2YAxisLabel(dailyTrendOutsideTraffic.ToString(), dailyTrendOutsideTraffic,
                    //    graphDailyDataSource, "=Fields.DayOfWeek", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Day, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.OutsideTrafficDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic, font, FormatStringDailySalesConversion, FormatStringDailyOutsideTraffic);
                    //TelerikUtility.PlotBarLineGraph_2YAxisLabel(weekdayTrendOutsideTraffic.ToString(), weekdayTrendOutsideTraffic,
                    //    graphWeekdayVisitorProfileDataSource, "=Fields.Hour", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_Hour, "=Fields.ValueInDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor, "=Fields.OutsideTrafficDouble", SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic, font, FormatStringWeekdaySalesConversion, FormatStringWeekdayOutsideTraffic);

                    //Attach link to graph
                    Telerik.Reporting.NavigateToUrlAction UrlAction1 = new Telerik.Reporting.NavigateToUrlAction();
                    string financialWeekDate = companyServices.GetCompany(companyId).Setting.FinancialWeekDate;
                    DateTime firstDayOfThisYear = new DateTime(DateTime.Now.Year, Convert.ToInt32(financialWeekDate.Substring(3, 2)), Convert.ToInt32(financialWeekDate.Substring(0, 2)));
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&parameter=101,311&start=" + firstDayOfThisYear.ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    else
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&parameter=101,311&start=" + firstDayOfThisYear.ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    weeklyTrendSalesConversion.Action = UrlAction1;

                    Telerik.Reporting.NavigateToUrlAction UrlAction2 = new Telerik.Reporting.NavigateToUrlAction();
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&parameter=101,311&start=" + endd.AddDays(-31).ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    else
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&parameter=101,311&start=" + endd.AddDays(-31).ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    dailyTrendSalesConversion.Action = UrlAction2;
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        //public Graph plotAreaGraph(string graphName, Graph reportGraphName, List<DailyData> dataList, string categoryGraphGroup, string yAxisGroup)
        //{
        //    //Data plotting - Traffic Profile Weekday
        //    reportGraphName.Name = graphName;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = dataList;

        //    //Create the category group
        //    var categoryGroup = new GraphGroup();
        //    categoryGroup.Name = "categoryGroup";
        //    categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(categoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var seriesGroup = new GraphGroup();
        //    seriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(seriesGroup);

        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Style.Visible = false;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale = new GraphAxis();
        //    graphAxisNumericalScale.Name = "Y Axis";
        //    graphAxisNumericalScale.Scale = new NumericalScale();
        //    graphAxisNumericalScale.Style.Visible = false;
        //    graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);

        //    //The Graph Series area
        //    var areaGraph = new AreaSeries();
        //    areaGraph.CategoryGroup = categoryGroup;
        //    areaGraph.CoordinateSystem = cartesianCoordinateSystem;
        //    areaGraph.LegendItem.Style.Visible = false;
        //    areaGraph.SeriesGroup = seriesGroup;
        //    areaGraph.Y = yAxisGroup;
        //    reportGraphName.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    reportGraphName.Series.Add(areaGraph);

        //    return reportGraphName;
        //}

        //public Graph PlotBarLineGraph(string graphName, Graph reportGraphName, IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font, string format)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisCategoryScale.Style.Font.Bold = false;
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale();
        //    graphAxisCategoryScale2.Style.Visible = false;
        //    graphAxisCategoryScale2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisCategoryScale2.Style.Font.Bold = false;
        //    graphAxisCategoryScale2.Style.Font.Name = font;
        //    graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.Scale = new NumericalScale();
        //    graphAxisNumericalScale5.Title = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale5.Style.Font.Bold = false;
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    graphAxisNumericalScale5.LabelFormat = format;
        //    //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup 2nd Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale6 = new GraphAxis();
        //    graphAxisNumericalScale6.Name = "Y Axis 2";
        //    graphAxisNumericalScale6.Scale = new NumericalScale();
        //    graphAxisNumericalScale6.Title = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)";
        //    graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale6.Style.Font.Bold = false;
        //    graphAxisNumericalScale6.Style.Font.Name = font;
        //    graphAxisNumericalScale6.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    // graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 270;

        //    var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    reportGraphName.Series.Add(barSeries1);
        //    barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });

        //    //The Line Series area
        //    var lineSeries1 = new LineSeries();
        //    lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    lineSeries1.LegendItem.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_SalesConversion + " (%)";
        //    lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    lineSeries1.Y = yAxisGroup2;
        //    lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //    reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
        //    reportGraphName.Series.Add(lineSeries1);
        //    lineSeries1.ColorPalette = new ColorPalette(Color.Black);

        //    return reportGraphName;
        //}

        //public Graph PlotBarLineGraph2(string graphName, Graph reportGraphName, IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font, string format1, string format2)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale();
        //    graphAxisCategoryScale2.Style.Visible = false;
        //    graphAxisCategoryScale2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisCategoryScale2.Style.Font.Name = font;
        //    graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.Scale = new NumericalScale();
        //    graphAxisNumericalScale5.Title = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale5.Style.Font.Bold = false;
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    graphAxisNumericalScale5.LabelFormat = format1;
        //    //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup 2nd Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale6 = new GraphAxis();
        //    graphAxisNumericalScale6.Name = "Y Axis 2";
        //    graphAxisNumericalScale6.Scale = new NumericalScale();
        //    graphAxisNumericalScale6.Title = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic;
        //    graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale6.Style.Font.Bold = false;
        //    graphAxisNumericalScale6.Style.Font.Name = font;
        //    graphAxisNumericalScale6.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.LabelFormat = format2;
        //    // graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 270;

        //    var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    reportGraphName.Series.Add(barSeries1);
        //    barSeries1.ColorPalette = new ColorPalette(new string[] { "0x88,0xd9,0xc9" });
        //    barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(yAxisGroup, format1.Insert(9, ".##"));    //{0:## ##0k} >> {0:## ##0.##k}

        //    //The Line Series area
        //    var lineSeries1 = new LineSeries();
        //    lineSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    lineSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    lineSeries1.LegendItem.Value = SiteSalesConversionWeeklyReportViewer.SiteSalesConversionWeeklyReportViewer_OutsideTraffic;
        //    lineSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    lineSeries1.Y = yAxisGroup2;
        //    lineSeries1.LineStyle.LineStyle = LineStyle.Dashed;
        //    reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
        //    reportGraphName.Series.Add(lineSeries1);
        //    lineSeries1.ColorPalette = new ColorPalette(Color.Black);

        //    return reportGraphName;
        //}

        public static string CheckSalesConversionOverview(double salesConversion)
        {
            string format = "{0:N0}";

            try
            {
                if (salesConversion != 0)
                {
                    return Math.Abs(Math.Round(salesConversion, 2)) + "%"; 
                }
                else
                {
                    return "-";
                }
            }
            catch
            {
                return "-";
            }
        }

        public static string CheckSalesConversion(double salesConversion)
        {
            string format = "{0:N0}";

            try
            {
                if (salesConversion == 0)
                {
                    return "-";
                }
                else
                {
                    return Math.Abs(Math.Round(salesConversion, 2)).ToString();
                }
            }
            catch
            {
                return "-";
            }
           
        }

        public static string CheckTransactionCount(int transactionCount)
        {
            string format = "{0:N0}";

            try
            {
                if (transactionCount == 0)
                {
                    return "-";
                }
                else
                {
                    return string.Format(format, transactionCount);
                }
            }
            catch
            {
                return "-";
            }
        }

        public static string CheckBestPerformDay(double salesConversion, string bestPerformDay)
        {
            if (salesConversion == 0)
            {
                return "-";
            }
            else
            {
                return bestPerformDay;
            }
        }

        public static string CheckRank(int rank)
        {
            string format = "{0:N0}";

            try
            {
                if (rank == 0)
                {
                    return "-" + "/" + leagueStatisticsRawData.TotalNumberOfStores;
                }
                else
                {
                    return string.Format(format, rank) + "/" + leagueStatisticsRawData.TotalNumberOfStores;
                }
            }
            catch
            {
                return "-" + "/" + "-";
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }
    }
}