using System.Web;

namespace RetailCamControlPanel
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using RetailCamControlPanel.ViewModel;
    using RetailCamControlPanel.Helper;
    using Models;
    using System.Globalization;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading;
    //using Resources;
    using System.Configuration;

    /// <summary>
    /// Summary description for Report3.
    /// </summary>
    public partial class SiteTimeOptimisationReport : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];


        public SiteTimeOptimisationReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void SiteTimeOptimisationReport_NeedDataSource(object sender, EventArgs e)
        {
            //services
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
            var companyServices = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            try
            {
                //Data obtaining - Company name and date for UI
                var startDateUI = Report.Parameters["Date"].Value;
                var endDateUI = Report.Parameters["endDate"].Value;
                var weekNumber = Report.Parameters["Week"].Value;
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var branchID = Report.Parameters["BranchID"].Value.ToString();
                var stores = Report.Parameters["Stores"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();
                string font = Utility.Telerik_GetDefaultFontName();
                var cultureInfo = new CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                var company = companyServices.GetCompany(companyCode);
                CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);

                long companyId = 0;
                if (companyCode != "")
                    companyId = companyServices.GetCompany(companyCode).ID;
                else
                    companyId = companySetting.CompanyId;

                DayOfWeek firstDayOfWeek = new DayOfWeek();
                var min = 15;
                var max = 30;
                string[] financialWeek = { "1", "1" };


                //Setting the language
                if (language == "zh-TW" || language == "zh")
                {
                    //To cater for PDF generation
                    font = Utility.Telerik_GetDefaultFontName();

                    //Report Header
                    reportTitle.Style.Font.Name = font;
                    dayDate.Style.Font.Name = font;


                    OTWeekdays.Style.Font.Name = font;
                    OTWeekends.Style.Font.Name = font;

                    graphDataTextBox2.Style.Font.Name = font;

                    dayHeader.Style.Font.Name = font;
                    openTimeHeader.Style.Font.Name = font;
                    closeTimeHeader.Style.Font.Name = font;
                    increasedHeader.Style.Font.Name = font;
                    savedHeader.Style.Font.Name = font;
                    extendedHeader.Style.Font.Name = font;
                    cCurrent.Style.Font.Name = font;
                    cSuggested.Style.Font.Name = font;
                    oCurrent.Style.Font.Name = font;
                    oSuggested.Style.Font.Name = font;

                    Day.Style.Font.Name = font;
                    openCurrent.Style.Font.Name = font;
                    openSuggested.Style.Font.Name = font;
                    closeCurrent.Style.Font.Name = font;
                    closeSuggested.Style.Font.Name = font;
                    hourExtended.Style.Font.Name = font;
                    expectedIncreased.Style.Font.Name = font;
                    expectedSaved.Style.Font.Name = font;
                }

                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                //DateTime startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                //DateTime endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);

                DateTime startd = new DateTime();
                DateTime endd = new DateTime();

                if (dateFormatHtml == "dateFirst")
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    //dateFormat = 2;
                }

                DateTime firstStartd = startd.AddDays(-28);
                var maxDate = endd;

                long startTimestamp = Utility.ConvertToTimestamp(startd);
                long endTimestamp = Utility.ConvertToTimestamp(endd);

                long lastWeekStartTimestamp = Utility.ConvertToTimestamp(startd.AddDays(-7));
                long lastWeekEndTimestamp = Utility.ConvertToTimestamp(endd.AddDays(-7));

                var financialStartEnd = GetFinancialWeekList(startd, companySetting);
                DateTime startDate;

                //determine to get years worth of data

                startDate = financialStartEnd.LastYear.FinancialStartDate;

                DateTime endDate = financialStartEnd.ThisYear.FinancialEndDate;


                //function to get the date of last year selected week
                var cal = CultureInfo.CurrentCulture.Calendar;
                var lastYearWeekNumber = Utility.GetWeekCount(startd, financialStartEnd.LastYear.FinancialStartDate.Month, financialStartEnd.LastYear.FinancialStartDate.Day, firstDayOfWeek);

                DateTime jan1 = new DateTime(startd.Year - 1, 1, 1);
                int daysOffset = DayOfWeek.Thursday - jan1.DayOfWeek;

                DateTime firstThursday = jan1.AddDays(daysOffset);
                int firstWeek = Utility.GetWeekCount(firstThursday, financialStartEnd.LastYear.FinancialStartDate.Month, financialStartEnd.LastYear.FinancialStartDate.Day, firstDayOfWeek);

                var weekNum = lastYearWeekNumber;
                if (firstWeek <= 1)
                {
                    weekNum -= 1;
                }
                var result = firstThursday.AddDays(weekNum * 7);
                var lastYearStart = result.AddDays(-3);
                var lastYearEnd = lastYearStart.AddDays(6);
                //the end of function to get the date of last year


                //--------------------------------------------------
                //get weekdays and weekends outside traffic data
                var pastFourWeeksData = new List<SummaryDailyVM>();
                var thisWeekHourlyData = new List<SummaryHourlyVM>();

                var thisYearWeekdayData = new List<SummaryHourlyVM>();
                var thisYearWeekendData = new List<SummaryHourlyVM>();


                var selectedRegion = "";
                //  var branchId = 529;

                //Raw Data
                var branchDailyRawData = ffcompositeServices.GetBranchSummaryReport(startDate, endDate, selectedRegion, Convert.ToInt64(branchID), true, true);

                var hourlyRawData = ffcompositeServices.GetBranchHourlyReport(startd, endd, selectedRegion, Convert.ToInt64(branchID), firstDayOfWeek);

                var transactionCountSum = hourlyRawData.Sum(s => s.TransactionCount);

                //Data obtaining - Checking if data exists
                var branchSummaryDailyReportViewModel = branchDailyRawData.OrderByDescending(o => o.Date).FirstOrDefault();
                if (hourlyRawData.Count > 0 && branchSummaryDailyReportViewModel != null && branchSummaryDailyReportViewModel.PatchStatus != "Predict")
                {
                    maxDate = hourlyRawData.Max(s => s.ValueDateTime).Date;
                }

                if (maxDate < endd || hourlyRawData.Count == 0)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    Note.Visible = false;

                    OTWeekdays.Visible = false;
                    OTWeekends.Visible = false;

                    weekdayTrendOutsideTraffic.Visible = false;
                    weekendTrendOutsideTraffic.Visible = false;

                    timeTable.Visible = false;

                    graphDataTextBox2.Visible = false;

                    errorBox.Value = "ERR104";


                    errorMessage.Visible = true;

                    errorMessage.Value = StoreHourReport.StoreHourReport_ReportIsNotAvailable;
                }
                else
                {
                    errorBox.Visible = false;
                    errorMessage.Visible = false;

                    dayDate.Value = StoreHourReport.StoreHourReport_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + StoreHourReport.StoreHourReport_Week + " " + weekNumber + ")";
                    reportTitle.Value = stores.ToUpper() + " " + StoreHourReport.StoreHourReport_StoreOpeningandClosingTimeAnalysis.ToUpper();
                    OTWeekdays.Value = StoreHourReport.StoreHourReport_Weekdays;
                    OTWeekends.Value = StoreHourReport.StoreHourReport_Weekends;

                    var hourlyFilteredRawData =
                        ffBranchSummaryHourlyReportService.GetDataWithinOperatingHour(hourlyRawData, true, true);

                    //Monthly Trend
                    var monthlyBranchSummary = ffBranchSummaryDailyReportService.CalculateMonthlyTrend(branchDailyRawData, startd, firstDayOfWeek, financialStartEnd, companySetting);

                    //Weekly Trend
                    var weeklyBranchSummary = ffBranchSummaryDailyReportService.CalculateWeeklyTrend(branchDailyRawData, startd, firstDayOfWeek, financialStartEnd);

                    //Daily Trend
                    var dailyBranchSummary = ffBranchSummaryDailyReportService.CalculateDailyTrend(branchDailyRawData, endd);

                    var topMatricData = ffBranchSummaryDailyReportService.CalculateMatricData(branchDailyRawData, true, endd);

                    //    var storeHourTableDataSeries = new StoreHourData();
                    var timeTableDataSource = dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= startTimestamp && w.Timestamp <= endTimestamp);

                    //timeTable.DataSource = timeTableDataSource;

                    var ffReportSummaryDailyService = MvcApplication.container.GetInstance<IFFReportSummaryDailyService>();

                    var ffCameraHourlyValueService = MvcApplication.container.GetInstance<IFFCameraHourlyValueService>();

                    var ffBranchOperatingHourService = MvcApplication.container.GetInstance<IFFBranchOperatingHourService>();

                    pastFourWeeksData = ffReportSummaryDailyService.GetStoreSummaryDaily(Convert.ToInt32(branchID), firstStartd, endd.AddDays(-7));
                    thisWeekHourlyData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), startd, endd, company, false, null);

                    thisYearWeekdayData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), firstStartd, endd.AddDays(-7), true, 0, companyCode);
                    thisYearWeekendData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), firstStartd, endd.AddDays(-7), false, 0, companyCode);


                    var thisYearWeekdayOHData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), firstStartd, endd.AddDays(-7), true, 1, companyCode);
                    var thisYearWeekendOHData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), firstStartd, endd.AddDays(-7), false, 1, companyCode);

                    var thisWeekdayHourlyOHFootfallData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), startd, endd, true, 1, companyCode);
                    var thisWeekendHourlyOHFootfallData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), startd, endd, false, 1, companyCode);

                    ////group data together for weekday and weekend 
                    var groupWeekdaysHourlyData = ffCameraHourlyValueService.GroupWeekdaysHourlyData(thisYearWeekdayData);
                    var groupWeekEndHourlyData = ffCameraHourlyValueService.GroupWeekEndHourlyData(thisYearWeekendData);

                    var groupWeekdaysHourlyOHData = ffCameraHourlyValueService.GroupWeekdaysHourlyData(thisYearWeekdayOHData);
                    var groupWeekEndHourlyOHData = ffCameraHourlyValueService.GroupWeekEndHourlyData(thisYearWeekendOHData);

                    //get last year this week data
                    var lastYearData = ffCameraHourlyValueService.GetStoreSummaryHourly(Convert.ToInt32(branchID), lastYearStart, lastYearEnd, company, false, null);

                    //get operating hour from monday to sunday
                    var storeOperatingHourList = ffBranchOperatingHourService.GetStoreOperatingHour(Convert.ToInt32(branchID));

                    //------------------------------------------
                    //create the list of hour for highchart x-axis in operating hours (weekdays graph & weekends graph)
                    var TrafficOperatingHourList = new List<string>();
                    int storeOpeningHour = thisYearWeekdayOHData.Count() != 0 ? thisYearWeekdayOHData.Min(v => v.ValueDateTime.Hour) : 0;
                    int storeClosingHour = thisYearWeekdayOHData.Count() != 0 ? thisYearWeekdayOHData.Max(v => v.ValueDateTime.Hour) : 0;
                    int tmpStoreOpeningHour = 0;
                    int tmpStoreClosingHour = 23;

                    for (DateTime i = startd; i < startd.AddDays(1); i = i.AddHours(1))
                    {
                        //for weedays and weekends in operating hour graph
                        if (i.Hour >= tmpStoreOpeningHour && i.Hour <= tmpStoreClosingHour)
                        {
                            TrafficOperatingHourList.Add(i.ToString("H:00"));
                        }
                    }



                    bool calcTableData = groupWeekdaysHourlyOHData.ThisYear.Count() != 0 && groupWeekEndHourlyOHData.ThisYear.Count() != 0 && pastFourWeeksData.Count != 0;


                    timeTable.DataSource = getTableDate(thisWeekendHourlyOHFootfallData, groupWeekEndHourlyData, thisWeekdayHourlyOHFootfallData, lastYearData, groupWeekdaysHourlyData, language, firstDayOfWeek, thisWeekHourlyData, storeOperatingHourList, calcTableData, startd, endd, storeOpeningHour);


                    //timeTable.DataSource = timeTableDataSource.Select(d =>
                    //{
                    //    d.DayOfWeek = d.DayOfWeek.Substring(0, 3);
                    //    return d;
                    //});

                    var weekdayRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == false)
                        .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    var weekdayVisitorProfile =
                        ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekdayRawData, true, true);

                    //          var weekendRawData = hourlyFilteredRawData.Where(w => w.IsWeekend == true)
                    //              .OrderBy(o => o.ValueDateTime.Hour).ToList();
                    //          var weekendVisitorProfile =
                    //              ffBranchSummaryHourlyReportService.CalculateVisitorTrend(weekendRawData, true, true);

                    var weekendData = getGraphData(startd, groupWeekEndHourlyOHData, groupWeekEndHourlyData);
                    var weekdayData = getGraphData(startd, groupWeekdaysHourlyOHData, groupWeekdaysHourlyData);


                    List<WeeklyData> thisAndLastWeeklyData = new List<WeeklyData>();
                    thisAndLastWeeklyData = ffBranchSummaryDailyReportService.GetThisAndLastWeekData(weeklyBranchSummary, startd, endd);

                    List<List<DailyData>> thisAndLastWeekDailyData = new List<List<DailyData>>();
                    thisAndLastWeekDailyData.Add(dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= lastWeekStartTimestamp && w.Timestamp <= lastWeekEndTimestamp).ToList());//last week dailyData
                    thisAndLastWeekDailyData.Add(dailyBranchSummary.ThisYear.Where(w => w.Timestamp >= startTimestamp && w.Timestamp <= endTimestamp).ToList());//this week dailyData

                    var weeklyDataDifferences = ffBranchSummaryDailyReportService.CalculateDifference(thisAndLastWeeklyData);


                    //Report Header language settings
                    reportTitle.Value = (selectedRegion == "")
                        ? stores.ToUpper() + " " + StoreHourReport.StoreHourReport_StoreOpeningandClosingTimeAnalysis.ToUpper() + " "
                        : stores.ToUpper() + " (" + selectedRegion.ToUpper() + ") " + StoreHourReport.StoreHourReport_StoreOpeningandClosingTimeAnalysis.ToUpper() + " ";
                    dayDate.Value = StoreHourReport.StoreHourReport_ReportPeriod + ": " + startDateUI + " - " + endDateUI + " (" + StoreHourReport.StoreHourReport_Week + " " + weekNumber + ")";


                    Note.Value = "* " + StoreHourReport.StoreHourReport_SuggestedTimeBasedOnBigDataAnalysis;

                    //table header language
                    dayHeader.Value = StoreHourReport.StoreHourReport_Day;
                    openTimeHeader.Value = StoreHourReport.StoreHourReport_OpeningTime;
                    closeTimeHeader.Value = StoreHourReport.StoreHourReport_ClosingTime;
                    increasedHeader.Value = StoreHourReport.StoreHourReport_ExpectedIncreaseInFootfall;
                    savedHeader.Value = StoreHourReport.StoreHourReport_ExpectedSavedLabourHour;
                    extendedHeader.Value = StoreHourReport.StoreHourReport_HourExtended;
                    cCurrent.Value = StoreHourReport.StoreHourReport_Current;
                    cSuggested.Value = StoreHourReport.StoreHourReport_Suggested;
                    oCurrent.Value = StoreHourReport.StoreHourReport_Current;
                    oSuggested.Value = StoreHourReport.StoreHourReport_Suggested;


                    var maxValueInWeekdaySalesConversion = weekdayData.SeriesT[0].data.Max();
                    var minValueInWeekdaySalesConversion = weekdayData.SeriesT[0].data.Min();
                    var denominatorWeekdaySalesConversion = TelerikUtility.CheckValueDenominator(minValueInWeekdaySalesConversion, maxValueInWeekdaySalesConversion);
                    var FormatStringWeekdaySalesConversion = TelerikUtility.DenominatedStringFormat(denominatorWeekdaySalesConversion);

                    //if (maxValueInWeekdaySalesConversion >= 3000000 || minValueInWeekdaySalesConversion >= 1000000)
                    //{
                    //    FormatStringWeekdaySalesConversion = "{0:## ##0M}";
                    //    denominatorWeekdaySalesConversion = 1000000;
                    //}

                    //else if (maxValueInWeekdaySalesConversion >= 3000 || minValueInWeekdaySalesConversion >= 1000)
                    //{
                    //    FormatStringWeekdaySalesConversion = "{0:## ##0k}";
                    //    denominatorWeekdaySalesConversion = 1000;
                    //}

                    var maxOutsideTrafficWeekday = weekdayData.SeriesT[1].data.Max();
                    var minOutsideTrafficWeekday = weekdayData.SeriesT[1].data.Min();
                    var denominatorWeekdayOutsideTraffic = TelerikUtility.CheckValueDenominator(minOutsideTrafficWeekday, maxOutsideTrafficWeekday);
                    var FormatStringWeekdayOutsideTraffic = TelerikUtility.DenominatedStringFormat(denominatorWeekdayOutsideTraffic);

                    //if (maxOutsideTrafficWeekday >= 3000000 || minOutsideTrafficWeekday >= 1000000)
                    //{
                    //    FormatStringWeekdayOutsideTraffic = "{0:## ##0M}";
                    //    denominatorWeekdayOutsideTraffic = 1000000;
                    //}

                    //else if (maxOutsideTrafficWeekday >= 3000 || minOutsideTrafficWeekday >= 1000)
                    //{
                    //    FormatStringWeekdayOutsideTraffic = "{0:## ##0k}";
                    //    denominatorWeekdayOutsideTraffic = 1000;
                    //}

                    List<BranchSummaryHourlyReportViewModel> weekdayDataSource = new List<BranchSummaryHourlyReportViewModel>();

                    for (int x = 0; x < weekdayData.categories.Count; x++)
                    {
                        weekdayDataSource.Add(
                           new BranchSummaryHourlyReportViewModel
                           {
                               Hour = weekdayData.categories[x],
                               ValueInDouble = (double)weekdayData.SeriesT[0].data[x] / (double)denominatorWeekdaySalesConversion,
                               OutsideTrafficDouble = (double)weekdayData.SeriesT[1].data[x] / (double)denominatorWeekdayOutsideTraffic,
                               ValueIn = weekdayData.SeriesT[0].data[x],
                               OutsideTraffic = weekdayData.SeriesT[1].data[x],
                           }
                        );
                    }

                    if (weekendData.valueIn == null && weekendData.outsideTraffic == null)
                    {
                        weekendTrendOutsideTraffic.Visible = false;
                        graphDataTextBox2.Visible = true;
                    }
                    else
                    {
                        graphDataTextBox2.Visible = false;

                        var maxValueInWeekendSalesConversion = weekendData.SeriesT[0].data.Max();
                        var minValueInWeekendSalesConversion = weekendData.SeriesT[0].data.Min();
                        var FormatStringWeekendSalesConversion = "{0:## ##0}";
                        var denominatorWeekendSalesConversion = 1;

                        if (maxValueInWeekendSalesConversion >= 3000000 || minValueInWeekendSalesConversion >= 1000000)
                        {
                            FormatStringWeekendSalesConversion = "{0:## ##0M}";
                            denominatorWeekendSalesConversion = 1000000;
                        }

                        else if (maxValueInWeekendSalesConversion >= 3000 || minValueInWeekendSalesConversion >= 1000)
                        {
                            FormatStringWeekendSalesConversion = "{0:## ##0k}";
                            denominatorWeekendSalesConversion = 1000;
                        }


                        var maxOutsideTrafficWeekend = weekendData.SeriesT[1].data.Max();
                        var minOutsideTrafficWeekend = weekendData.SeriesT[1].data.Min();
                        var FormatStringWeekendOutsideTraffic = "{0:## ##0}";
                        var denominatorWeekendOutsideTraffic = 1;

                        if (maxOutsideTrafficWeekend >= 3000000 || minOutsideTrafficWeekend >= 1000000)
                        {
                            FormatStringWeekendOutsideTraffic = "{0:## ##0M}";
                            denominatorWeekendOutsideTraffic = 1000000;
                        }

                        else if (maxOutsideTrafficWeekend >= 3000 || minOutsideTrafficWeekend >= 1000)
                        {
                            FormatStringWeekendOutsideTraffic = "{0:## ##0k}";
                            denominatorWeekendOutsideTraffic = 1000;
                        }

                        List<BranchSummaryHourlyReportViewModel> weekendDataSource = new List<BranchSummaryHourlyReportViewModel>();



                        for (int x = 0; x < weekendData.categories.Count; x++)
                        {
                            weekendDataSource.Add(
                               new BranchSummaryHourlyReportViewModel
                               {
                                   Hour = weekendData.categories[x],
                                   ValueInDouble = (double)weekendData.SeriesT[0].data[x] / (double)denominatorWeekendSalesConversion,
                                   SalesConversion = (double)weekendData.SeriesT[1].data[x] / (double)denominatorWeekendOutsideTraffic,
                                   ValueIn = weekendData.SeriesT[0].data[x],
                                   OutsideTraffic = weekendData.SeriesT[1].data[x],
                               }
                            );
                        }
                        TelerikUtility.PlotBarAreaGraph_2YAxisLabel(weekendTrendOutsideTraffic.ToString(), weekendTrendOutsideTraffic,
                                weekendDataSource, "=Fields.Hour", StoreHourReport.StoreHourReport_Hour, "=Fields.ValueInDouble", StoreHourReport.StoreHourReport_NoofVisitor, "=Fields.OutsideTrafficDouble", StoreHourReport.StoreHourReport_OutsideTraffic, font, FormatStringWeekendSalesConversion, FormatStringWeekendOutsideTraffic);

                    }

                    TelerikUtility.PlotBarAreaGraph_2YAxisLabel(weekdayTrendOutsideTraffic.ToString(), weekdayTrendOutsideTraffic,
                            weekdayDataSource, "=Fields.Hour", StoreHourReport.StoreHourReport_Hour, "=Fields.ValueInDouble", StoreHourReport.StoreHourReport_NoofVisitor, "=Fields.OutsideTrafficDouble", StoreHourReport.StoreHourReport_OutsideTraffic, font, FormatStringWeekdaySalesConversion, FormatStringWeekdayOutsideTraffic);

                    //Attach link to graph
                    Telerik.Reporting.NavigateToUrlAction UrlAction1 = new Telerik.Reporting.NavigateToUrlAction();
                    string financialWeekDate = companyServices.GetCompany(companyId).Setting.FinancialWeekDate;
                    DateTime firstDayOfThisYear = new DateTime(DateTime.Now.Year, Convert.ToInt32(financialWeekDate.Substring(3, 2)), Convert.ToInt32(financialWeekDate.Substring(0, 2)));
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&parameter=101,311&start=" + firstDayOfThisYear.ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    else
                    {
                        UrlAction1.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=3&parameter=101,311&start=" + firstDayOfThisYear.ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }


                    Telerik.Reporting.NavigateToUrlAction UrlAction2 = new Telerik.Reporting.NavigateToUrlAction();
                    if (dateFormatHtml == "dateFirst")
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&parameter=101,311&start=" + endd.AddDays(-31).ToString("dd'/'MM'/'yyyy") + "&end=" + endd.ToString("dd'/'MM'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                    else
                    {
                        UrlAction2.Url = retailCamControlPanelURL + "FootfallCam/Analytics?range=2&parameter=101,311&start=" + endd.AddDays(-31).ToString("MM'/'dd'/'yyyy") + "&end=" + endd.ToString("MM'/'dd'/'yyyy") + "&companyid=" + companyId + "&branchId=" + branchID + "&selectedMode=site&isGeneratePDF=false"; ;
                    }
                }
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }
        
        public ChartViewModel getGraphData(DateTime startd,HourlyDataViewModel groupWeekEndHourlyOHData, HourlyDataViewModel groupWeekEndHourlyData) {

            //create the list of hour for highchart x-axis in operating hours (weekdays graph & weekends graph)
            var TrafficOperatingHourList = new List<string>();
            int tmpStoreOpeningHour = 0;
            int tmpStoreClosingHour = 23;

            for (DateTime i = startd; i < startd.AddDays(1); i = i.AddHours(1))
            {
                //for weedays and weekends in operating hour graph
                if (i.Hour >= tmpStoreOpeningHour && i.Hour <= tmpStoreClosingHour)
                {
                    TrafficOperatingHourList.Add(i.ToString("H:00"));
                }
            }

            var thisWeekWeekendFFOperatingHourProfile = new SeriesVM<int>();
            thisWeekWeekendFFOperatingHourProfile.name = "Weekend Footfall In Operating Hour Profile";

            var thisWeekWeekendOTOperatingHourProfile = new SeriesVM<int>();
            thisWeekWeekendOTOperatingHourProfile.name = "Weekend Outside Traffic In Operating Hour Profile";

            //for store opening and closing time weekends report
            if (groupWeekEndHourlyOHData.ThisYear.Count() != 0)
            {
                var weekendsOperatingHourData = groupWeekEndHourlyData.ThisYear.GroupBy(g => g.Date.Hour).Select(s => new
                {
                    valueIn = s.Average(v => v.ValueIn),
                    outsideTraffic = s.Average(v => v.OutsideTraffic),
                });
                thisWeekWeekendFFOperatingHourProfile.data = new List<int>();
                thisWeekWeekendOTOperatingHourProfile.data = new List<int>();
                thisWeekWeekendFFOperatingHourProfile.isDayOff = true;

                foreach (var dataPulled in weekendsOperatingHourData)
                {
                    thisWeekWeekendFFOperatingHourProfile.data.Add((int)dataPulled.valueIn);
                    thisWeekWeekendOTOperatingHourProfile.data.Add((int)dataPulled.outsideTraffic);
                    if ((int)dataPulled.outsideTraffic != 0)
                    {
                        thisWeekWeekendFFOperatingHourProfile.isDayOff = false;
                    }
                }
            }
            var weekendsOTOHChart = new ChartViewModel()
            {
                SeriesT = new List<SeriesVM<int>> { thisWeekWeekendFFOperatingHourProfile, thisWeekWeekendOTOperatingHourProfile },
                categories = TrafficOperatingHourList,
                valueIn = thisWeekWeekendFFOperatingHourProfile.data,
                outsideTraffic = thisWeekWeekendOTOperatingHourProfile.data,
            };

            return weekendsOTOHChart;
        }



		public List<StoreHourData> getTableDate(List<SummaryHourlyVM> thisWeekendHourlyOHFootfallData, HourlyDataViewModel groupWeekEndHourlyData, List<SummaryHourlyVM> thisWeekdayHourlyOHFootfallData, List<SummaryHourlyVM> lastYearData, HourlyDataViewModel groupWeekdaysHourlyData, String language, DayOfWeek firstDayOfWeek, List<SummaryHourlyVM> thisWeekHourlyData, List<FFBranchOperatingHourViewModel> storeOperatingHourList, bool calcTableData, DateTime startd, DateTime endd, int storeOpeningHour)
		{

			var storeOperatingHourSeries = new SeriesVM<StoreHourData>();
			storeOperatingHourSeries.branchCode = new List<string>();
			storeOperatingHourSeries.data = new List<StoreHourData>();

			if (calcTableData)
			{
				//get the average of outside traffic in every hour in everyday from past 4 weeks and last year this week
				for (DateTime d = startd; d <= endd; d = d.AddDays(1))// for 7 days
				{
					var storeHourTableDataSeries = new StoreHourData();
					storeHourTableDataSeries.operatingHours = new FFBranchOperatingHourViewModel();
					storeHourTableDataSeries.outsideTraffic = new List<double>();
					storeHourTableDataSeries.avgOutsideTraffic = new List<double>();
					storeHourTableDataSeries.averageOutsideTraffic = 0;
					storeHourTableDataSeries.averageTurnInRate = 0;
					storeHourTableDataSeries.totalFootfallCount = 0;
					storeHourTableDataSeries.isCounterOn = true;

					storeHourTableDataSeries.reportDay = Utility.getLanguagePageName((d.ToString("ddd", CultureInfo.InvariantCulture)), language);
					storeHourTableDataSeries.operatingHours = storeOperatingHourList.Find(f => f.Day == (int)d.DayOfWeek);

					var TIRtvalue = thisWeekHourlyData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek);
					storeHourTableDataSeries.averageTurnInRate = TIRtvalue.Any() ? TIRtvalue.Average(v => v.TurnInRate) : 0;

					var hourlyOTData = thisWeekHourlyData.Where(g => g.ValueDateTime.Date == d.Date).ToList();

					//check whether if counter online during non operating hour
					for (int a = 0; a < hourlyOTData.Count; a++)
					{
						if (hourlyOTData[a].OutsideTraffic != 0)
						{
							storeHourTableDataSeries.outsideTraffic.Add(hourlyOTData[a].OutsideTraffic);

						}
					}

					foreach (var data in hourlyOTData)
					{
						storeHourTableDataSeries.outsideTraffic.Add(storeHourTableDataSeries.isCounterOn ? data.OutsideTraffic : 0);
					}

					DayOfWeek firstDayOfWeekEnd = new DayOfWeek();
					DayOfWeek secondDayOfWeekEnd = new DayOfWeek();
					if (firstDayOfWeek == DayOfWeek.Monday)
					{
						firstDayOfWeekEnd = DayOfWeek.Saturday;
						secondDayOfWeekEnd = DayOfWeek.Sunday;
					}
					else if (firstDayOfWeek == DayOfWeek.Tuesday)
					{
						firstDayOfWeekEnd = DayOfWeek.Sunday;
						secondDayOfWeekEnd = DayOfWeek.Monday;
					}
					else if (firstDayOfWeek == DayOfWeek.Wednesday)
					{
						firstDayOfWeekEnd = DayOfWeek.Monday;
						secondDayOfWeekEnd = DayOfWeek.Tuesday;
					}
					else if (firstDayOfWeek == DayOfWeek.Thursday)
					{
						firstDayOfWeekEnd = DayOfWeek.Tuesday;
						secondDayOfWeekEnd = DayOfWeek.Wednesday;
					}
					else if (firstDayOfWeek == DayOfWeek.Friday)
					{
						firstDayOfWeekEnd = DayOfWeek.Wednesday;
						secondDayOfWeekEnd = DayOfWeek.Thursday;
					}
					else if (firstDayOfWeek == DayOfWeek.Saturday)
					{
						firstDayOfWeekEnd = DayOfWeek.Thursday;
						secondDayOfWeekEnd = DayOfWeek.Friday;
					}
					else if (firstDayOfWeek == DayOfWeek.Sunday)
					{
						firstDayOfWeekEnd = DayOfWeek.Friday;
						secondDayOfWeekEnd = DayOfWeek.Saturday;
					}
					if (d.DayOfWeek != firstDayOfWeekEnd && d.DayOfWeek != secondDayOfWeekEnd) //for weekdays
					{
						for (int j = 0; j < 24; j++) //for 24 hours
						{
							var tvalue = groupWeekdaysHourlyData.ThisYear.Where(v => v.Date.DayOfWeek == d.DayOfWeek && v.Date.Hour == j);
							var lvalue = lastYearData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek && v.ValueDateTime.Hour == j);
							double averagePastFourWeeks = 0;
							double totalAverage = 0;
							averagePastFourWeeks = tvalue.Any() ? tvalue.Average(v => v.OutsideTraffic) : 0;
							totalAverage = (averagePastFourWeeks + (lvalue.Any() ? lvalue.Average(v => v.OutsideTraffic) : 0)) / 2;

							storeHourTableDataSeries.avgOutsideTraffic.Add(totalAverage);
							storeHourTableDataSeries.averageOutsideTraffic += totalAverage;

							var totalFF = thisWeekdayHourlyOHFootfallData.Where(v => v.ValueDateTime.Date == d.Date);
							storeHourTableDataSeries.totalFootfallCount = totalFF.Any() ? totalFF.Sum(v => v.ValueIn) : 0;

						} // end 24 hours loop
					}
					else //for weekends
					{
						for (int j = 0; j < 24; j++) //for 24 hours
						{
							var tvalue = groupWeekEndHourlyData.ThisYear.Where(v => v.Date.DayOfWeek == d.DayOfWeek && v.Date.Hour == j);
							var lvalue = lastYearData.Where(v => v.ValueDateTime.DayOfWeek == d.DayOfWeek && v.ValueDateTime.Hour == j);
							double averagePastFourWeeks = 0;
							double totalAverage = 0;
							averagePastFourWeeks = tvalue.Any() ? tvalue.Average(v => v.OutsideTraffic) : 0;
							totalAverage = (averagePastFourWeeks + (lvalue.Any() ? lvalue.Average(v => v.OutsideTraffic) : 0)) / 2;

							storeHourTableDataSeries.avgOutsideTraffic.Add(totalAverage);
							storeHourTableDataSeries.averageOutsideTraffic += totalAverage;

							var totalFF = thisWeekendHourlyOHFootfallData.Where(v => v.ValueDateTime.Date == d.Date);
							storeHourTableDataSeries.totalFootfallCount = totalFF.Any() ? totalFF.Sum(v => v.ValueIn) : 0;

						} // end 24 hours loop
					}



					storeHourTableDataSeries.averageOutsideTraffic = storeHourTableDataSeries.averageOutsideTraffic / 24;
					storeOperatingHourSeries.data.Add(storeHourTableDataSeries);
				}

				//calculate the suggested opening and closing time, extended hour, expected increase in footfall and expected saved labour hour
				for (int i = 0; i < storeOperatingHourSeries.data.Count(); i++)
				{

					var storeDataInDay = storeOperatingHourSeries.data[i];
					var avgOutsideTrafficInHour = storeDataInDay.avgOutsideTraffic;
					var outsideTrafficInHour = storeDataInDay.outsideTraffic;
					bool isOff = storeDataInDay.operatingHours.isDayOff;
					storeDataInDay.extendedHour = 0;
					double totalOTInExtendedHour = 0;
					if (!isOff && storeDataInDay.isCounterOn)
					{
						double openClosevalue = storeDataInDay.averageOutsideTraffic;
						var actualOpenTime = storeDataInDay.operatingHours.StartTime;
						var actualCloseTime = storeDataInDay.operatingHours.EndTime;

						var actualOpenMinute = storeDataInDay.operatingHours.StartTime.Minute == 0 ? "00" : storeDataInDay.operatingHours.StartTime.Minute.ToString();
						var actualCloseMinute = storeDataInDay.operatingHours.EndTime.Minute == 0 ? "00" : storeDataInDay.operatingHours.EndTime.Minute.ToString();
						storeDataInDay.currentOpening = actualOpenTime.Hour > 12 ? actualOpenTime.Hour - 12 + ":" + actualOpenMinute + "pm" : actualOpenTime.Hour + ":" + actualOpenMinute + "am";
						storeDataInDay.currentOpening = actualOpenTime.Hour == 0 ? "12:" + actualOpenMinute + "am" : actualOpenTime.Hour == 12 ? "12:" + actualOpenMinute + "pm" : storeDataInDay.currentOpening;
						storeDataInDay.currentClosing = actualCloseTime.Hour > 12 ? actualCloseTime.Hour - 12 + ":" + actualCloseMinute + "pm" : actualCloseTime.Hour + ":" + actualCloseMinute + "am";
						storeDataInDay.currentClosing = actualCloseTime.Hour == 0 ? "12:" + actualCloseMinute + "am" : actualCloseTime.Hour == 12 ? "12:" + actualCloseMinute + "pm" : storeDataInDay.currentClosing;
						var openTime = 0;
						var closeTime = 0;
						double currentExtendedHour = 0;
						for (int a = 0; a < 24; a++) //check from 0000H
						{
							if (storeDataInDay.suggestedOpening == null && avgOutsideTrafficInHour[a] >= openClosevalue && avgOutsideTrafficInHour[a] != 0)
							{
								currentExtendedHour = 0;
								openTime = a;
								if (openTime == actualOpenTime.Hour && actualOpenTime.Minute == 0)
								{
									storeDataInDay.suggestedOpening = openTime > 12 ? openTime - 12 + ":00pm" + " (" + StoreHourReport.StoreHourReport_Remain + ")" : openTime + ":00am" + " (" + StoreHourReport.StoreHourReport_Remain + ")";
									storeDataInDay.suggestedOpening = a == 0 ? "12:00am (" + StoreHourReport.StoreHourReport_Remain + ")" : a == 12 ? "12:00pm (" + StoreHourReport.StoreHourReport_Remain + ")" : storeDataInDay.suggestedOpening;
								}
								else
								{
									storeDataInDay.suggestedOpening = openTime > 12 ? openTime - 12 + ":00pm" : openTime + ":00am";
									storeDataInDay.suggestedOpening = a == 0 ? "12:00am" : a == 12 ? "12:00pm" : storeDataInDay.suggestedOpening;
									double openTimeMinutesInHour = actualOpenTime.Minute > 0 ? Convert.ToDouble(actualOpenTime.Minute) / 60 : 0; //if actual opening time not in an exact hour format
									currentExtendedHour = (Convert.ToDouble(actualOpenTime.Hour) + openTimeMinutesInHour) - Convert.ToDouble(openTime);
									storeDataInDay.extendedHour += currentExtendedHour;
									double extraOutsideTraffic = openTimeMinutesInHour * outsideTrafficInHour[actualOpenTime.Hour];
									totalOTInExtendedHour = currentExtendedHour > 0 ? (outsideTrafficInHour[openTime] + extraOutsideTraffic) : totalOTInExtendedHour;
								}
							}
							else if (storeDataInDay.suggestedOpening != null && currentExtendedHour > 0 && a < actualOpenTime.Hour)
							{
								totalOTInExtendedHour += outsideTrafficInHour[a];
							}
							else if (storeDataInDay.suggestedOpening != null)
							{
								break;
							}

						}
						for (int b = 23; b >= 0; b--) //check from 2300H
						{
							if (storeDataInDay.suggestedClosing == null && avgOutsideTrafficInHour[b] >= openClosevalue && avgOutsideTrafficInHour[b] != 0)
							{
								currentExtendedHour = 0;
								closeTime = b + 1;
								if (closeTime == actualCloseTime.Hour && actualCloseTime.Minute == 0)
								{
									storeDataInDay.suggestedClosing = closeTime > 12 ? closeTime - 12 + ":00pm" + " (" + StoreHourReport.StoreHourReport_Remain + ")" : closeTime + ":00am" + " (" + StoreHourReport.StoreHourReport_Remain + ")";
									storeDataInDay.suggestedClosing = b + 1 == 24 ? "12:00am (" + StoreHourReport.StoreHourReport_Remain + ")" : b + 1 == 12 ? "12:00pm (" + StoreHourReport.StoreHourReport_Remain + ")" : storeDataInDay.suggestedClosing;
								}
								else
								{
									var checkDiffer = closeTime - actualCloseTime.Hour;
									checkDiffer = checkDiffer < 0 ? checkDiffer * -1 : checkDiffer;
									if (checkDiffer >= 5)
									{
										continue;
									}
									else
									{
										storeDataInDay.suggestedClosing = closeTime > 12 ? closeTime == 0 ? "12:00am" : closeTime - 12 + ":00pm" : closeTime + ":00am";
										double closeTimeMinutesInHour = actualCloseTime.Minute > 0 ? Convert.ToDouble(actualCloseTime.Minute) / 60 : 0; //if actual closing time not in an exact hour format
										currentExtendedHour = Convert.ToDouble(closeTime) - (Convert.ToDouble(actualCloseTime.Hour) + closeTimeMinutesInHour);
										storeDataInDay.extendedHour += currentExtendedHour;
										double extraOutsideTraffic = closeTimeMinutesInHour * outsideTrafficInHour[actualCloseTime.Hour];
										totalOTInExtendedHour = currentExtendedHour > 0 ? closeTime != 24 ? totalOTInExtendedHour + outsideTrafficInHour[closeTime] + extraOutsideTraffic : totalOTInExtendedHour + extraOutsideTraffic : totalOTInExtendedHour;
									}
								}
							}
							else if (storeDataInDay.suggestedClosing != null && currentExtendedHour > 0 && b > actualCloseTime.Hour)
							{
								totalOTInExtendedHour += outsideTrafficInHour[b];
							}
							else if (storeDataInDay.suggestedClosing != null)
							{
								break;
							}
						}

						if (storeDataInDay.extendedHour > 0)
						{
							var footfallInExtendedHour = totalOTInExtendedHour * storeDataInDay.averageTurnInRate / 100;
							storeDataInDay.expectedIncreaseInFF = storeDataInDay.totalFootfallCount != 0 ? Math.Round((footfallInExtendedHour / storeDataInDay.totalFootfallCount * 100), 2) : 0;
							storeDataInDay.expectedSavedLabourHour = 0;
						}
						else if (storeDataInDay.extendedHour < 0)
						{
							storeDataInDay.expectedIncreaseInFF = 0;
							storeDataInDay.expectedSavedLabourHour = storeDataInDay.extendedHour * -1;
						}
						else
						{
							storeDataInDay.expectedIncreaseInFF = 0;
							storeDataInDay.expectedSavedLabourHour = 0;
						}

					}
					else if (isOff)
					{
						storeDataInDay.currentOpening = StoreHourReport.StoreHourReport_OffDay;
						storeDataInDay.currentClosing = StoreHourReport.StoreHourReport_OffDay;
						storeDataInDay.suggestedOpening = StoreHourReport.StoreHourReport_OffDay;
						storeDataInDay.suggestedClosing = StoreHourReport.StoreHourReport_OffDay;
						storeDataInDay.extendedHour = 0;
						storeDataInDay.expectedIncreaseInFF = 0;
						storeDataInDay.expectedSavedLabourHour = 0;
					}
					else
					{
						storeDataInDay.currentOpening = "-";
						storeDataInDay.currentClosing = "-";
						storeDataInDay.suggestedOpening = "-";
						storeDataInDay.suggestedClosing = "-";
						storeDataInDay.extendedHour = 0;
						storeDataInDay.expectedIncreaseInFF = 0;
						storeDataInDay.expectedSavedLabourHour = 0;
					}
				}



			}

			return storeOperatingHourSeries.data;
		}


        public FinancialYearVM GetFinancialWeekList(DateTime passedDateTime, CompanySetting companySetting)
        {
            //temporary
            //passedDateTime = new DateTime(2013, 7, 18);

            var fvm = new FinancialYearVM();
            string[] financialWeek = { "1", "1" };
            DayOfWeek firstDayOfWeek = new DayOfWeek();
            if (companySetting.FinancialWeekDate != null)
                financialWeek = new string[] { companySetting.FinancialWeekDate };
            firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday" ? DayOfWeek.Sunday : companySetting.FirstDayOfWeek == "Saturday" ? DayOfWeek.Saturday : companySetting.FirstDayOfWeek == "Friday" ? DayOfWeek.Friday : DayOfWeek.Monday;

            DateTime startd = passedDateTime;
            DateTime thisYearCompanyFinancialWeekStart = new DateTime();
            DateTime thisYearCompanyFinancialWeekEnd = new DateTime();

            DateTime lastYearCompanyFinancialWeekStart = new DateTime();
            DateTime lastYearCompanyFinancialWeekEnd = new DateTime(1);

            //default financial date
            DateTime setCompanyFinancialStartDate = companySetting.DateFormat == "dateFirst" ?
                DateTime.ParseExact(companySetting.FinancialWeekDate, "dd/MM/yyyy", CultureInfo.InvariantCulture) :
                DateTime.ParseExact(companySetting.FinancialWeekDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
            DateTime setCompanyFinancialEndDate = Utility.GetFinancialYearEndDate(setCompanyFinancialStartDate, firstDayOfWeek);

            thisYearCompanyFinancialWeekStart = setCompanyFinancialEndDate.AddDays(1);
            thisYearCompanyFinancialWeekEnd = Utility.GetFinancialYearEndDate(thisYearCompanyFinancialWeekStart, firstDayOfWeek);

            lastYearCompanyFinancialWeekStart = setCompanyFinancialStartDate;
            lastYearCompanyFinancialWeekEnd = setCompanyFinancialEndDate;

            var tmpLastYear = new FinancialStartEnd();
            tmpLastYear.FinancialStartDate = lastYearCompanyFinancialWeekStart;
            tmpLastYear.FinancialEndDate = lastYearCompanyFinancialWeekEnd;

            var tmpThisYear = new FinancialStartEnd();
            tmpThisYear.FinancialStartDate = thisYearCompanyFinancialWeekStart;
            tmpThisYear.FinancialEndDate = thisYearCompanyFinancialWeekEnd;

            fvm.LastYear = tmpLastYear;
            fvm.ThisYear = tmpThisYear;
            //default financial date


            //do checking to see if passedDate is inside the range of this year financial period
            if (passedDateTime >= fvm.ThisYear.FinancialStartDate && passedDateTime <= fvm.ThisYear.FinancialEndDate)
            {

            }
            //if false
            else
            {
                //calculate the difference of the passedDate with fvm this year startDate
                //fiscal year smaller than default one
                Double differenceInYear = new Double();
                if (passedDateTime < thisYearCompanyFinancialWeekStart)
                {
                    differenceInYear = (double)(Convert.ToDecimal((thisYearCompanyFinancialWeekStart - passedDateTime).TotalDays) / 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekStart;
                    DateTime tmpThisEnd = new DateTime();
                    for (var i = 0.0; i < differenceInYear; i++)
                    {
                        tmpThisEnd = tmpThisStart.AddDays(-1);
                        tmpThisStart = tmpThisEnd.AddMonths(-12).AddDays(1);

                        var tmpDtDayOfWeek = (int)tmpThisStart.DayOfWeek == 0 ? 0 : (int)tmpThisStart.DayOfWeek;
                        var tmpFirstDayOfWeek = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                        int dif = tmpFirstDayOfWeek - tmpDtDayOfWeek;

                        tmpThisStart = tmpThisStart.AddDays(dif);
                        if (dif < 0)
                            dif = dif * -1;
                        if (dif >= 4)
                        {
                            tmpThisStart = tmpThisStart.AddDays(-7);
                        }
                    }
                    //tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);


                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12).AddDays(1);

                    var tmpDtDayOfWeek2 = (int)tmpLastStart.DayOfWeek == 0 ? 0 : (int)tmpLastStart.DayOfWeek;
                    var tmpFirstDayOfWeek2 = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                    int dif2 = tmpFirstDayOfWeek2 - tmpDtDayOfWeek2;

                    tmpLastStart = tmpLastStart.AddDays(dif2);
                    if (dif2 < 0)
                        dif2 = dif2 * -1;
                    if (dif2 >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(-7);
                    }
                    //int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    //tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);

                    //if ((int)firstDayOfWeek >= 4 && (int)firstDayOfWeek != 7)
                    //{
                    //    tmpLastStart = tmpLastStart.AddDays(-7);
                    //}

                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }

                //fiscal year greater than default one
                else if (passedDateTime > thisYearCompanyFinancialWeekEnd)
                {
                    differenceInYear = (double)(Convert.ToDecimal((passedDateTime - thisYearCompanyFinancialWeekStart).TotalDays) / 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekEnd.AddDays(1);
                    DateTime tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                    for (var i = 0.0; i < differenceInYear - 1; i++)
                    {
                        if (i > 0)
                        {
                            tmpThisStart = tmpThisEnd.AddDays(1);
                            tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                        }
                    }

                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12);
                    int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);
                    if ((pushLastWeekStartToFirstDay * -1) >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(7);
                    }


                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }
            }

            return fvm;
        }
        

        //public Graph PlotBarAreaGraph(string graphName, Graph reportGraphName, List<BranchSummaryHourlyReportViewModel> graphDataSource,string y1Data,string y2Data, string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string font, string format, string formatStringWeekendOutsideTraffic)
        //{
        //    reportGraphName.Name = graphName;
        //    reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    reportGraphName.Style.Font.Bold = false;
        //    reportGraphName.Style.Font.Name = font;

        //    //Setup the SqlDataSource
        //    reportGraphName.DataSource = graphDataSource;

        //    //Create the category group
        //    var SalesConversionSectionCategoryGroup = new GraphGroup();
        //    SalesConversionSectionCategoryGroup.Name = "categoryGroup";
        //    SalesConversionSectionCategoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
        //    reportGraphName.CategoryGroups.Add(SalesConversionSectionCategoryGroup);

        //    //The SeriesGroups hierarchy defines the series at runtime
        //    var SalesConversionSectionSeriesGroup = new GraphGroup();
        //    SalesConversionSectionSeriesGroup.Name = "seriesGroup";
        //    reportGraphName.SeriesGroups.Add(SalesConversionSectionSeriesGroup);


        //    //Setup Graph Axis with CategoryScale
        //    var graphAxisCategoryScale = new GraphAxis();
        //    graphAxisCategoryScale.Name = "X Axis";
        //    graphAxisCategoryScale.Scale = new CategoryScale();
        //    graphAxisCategoryScale.Title = xAxisName;
        //    graphAxisCategoryScale.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
        //    graphAxisCategoryScale.Style.Font.Bold = false;
        //    graphAxisCategoryScale.Style.Font.Name = font;
        //    graphAxisCategoryScale.TitleStyle.Font.Name = font;
        //    graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale.Style.LineColor = Color.White;
        //    graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
        //    // graphAxisCategoryScale.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    var graphAxisCategoryScale2 = new GraphAxis();
        //    graphAxisCategoryScale2.Name = "X Axis 2";
        //    graphAxisCategoryScale2.Scale = new CategoryScale();
        //    graphAxisCategoryScale2.Style.Visible = false;
        //    graphAxisCategoryScale2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
        //    graphAxisCategoryScale2.Style.Font.Bold = false;
        //    graphAxisCategoryScale2.Style.Font.Name = font;
        //    graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
        //    graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
        //    //  graphAxisCategoryScale2.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    NumericalScale ns = new NumericalScale();
        //    ns.Minimum = 0;
        //    //     ns.MinorStep = 1;
        //    NumericalScale ns1 = new NumericalScale();
        //    ns1.Minimum = 0;

        //    if(graphDataSource.Select(x => x.ValueIn).Max()<6)
        //        ns1.LabelStep = 1;

        //    if (graphDataSource.Select(x => x.OutsideTraffic).Max() < 6)
        //        ns.LabelStep = 1;

        //    //Setup Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale5 = new GraphAxis();
        //    graphAxisNumericalScale5.Name = "Y Axis";
        //    graphAxisNumericalScale5.Scale = ns1;
        //    graphAxisNumericalScale5.Title = StoreHourReport.StoreHourReport_NoofVisitor;
        //    graphAxisNumericalScale5.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale5.Style.Font.Bold = false;
        //    graphAxisNumericalScale5.Style.Font.Name = font;
        //    graphAxisNumericalScale5.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale5.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale5.Style.LineColor = Color.White;
        //    graphAxisNumericalScale5.LabelFormat = format;
        //    //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

        //    //Setup 2nd Graph Axis with Numerical Scale
        //    var graphAxisNumericalScale6 = new GraphAxis();
        //    graphAxisNumericalScale6.Name = "Y Axis 2";
        //    graphAxisNumericalScale6.Scale = ns;
        //    graphAxisNumericalScale6.Title = StoreHourReport.StoreHourReport_OutsideTraffic;
        //    graphAxisNumericalScale6.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
        //    graphAxisNumericalScale6.Style.Font.Bold = false;
        //    graphAxisNumericalScale6.Style.Font.Name = font;
        //    graphAxisNumericalScale6.TitleStyle.Font.Name = font;
        //    graphAxisNumericalScale6.MajorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.MinorGridLineStyle.Visible = false;
        //    graphAxisNumericalScale6.Style.LineColor = Color.White;
        //    graphAxisNumericalScale6.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
        //    graphAxisNumericalScale6.LabelFormat = formatStringWeekendOutsideTraffic;
        //    // graphAxisNumericalScale6.Style.Color = Color.FromArgb(1, 73, 75, 75);


        //    //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
        //    var cartesianCoordinateSystem = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem.Name = "cartesianCoordinateSystem5";
        //    cartesianCoordinateSystem.XAxis = graphAxisCategoryScale;
        //    cartesianCoordinateSystem.YAxis = graphAxisNumericalScale5;
        //    cartesianCoordinateSystem.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.YAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem);
        //    cartesianCoordinateSystem.XAxis.LabelAngle = 270;

        //    var cartesianCoordinateSystem6 = new CartesianCoordinateSystem();
        //    cartesianCoordinateSystem6.Name = "cartesianCoordinateSystem6";
        //    cartesianCoordinateSystem6.XAxis = graphAxisCategoryScale2;
        //    cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
        //    cartesianCoordinateSystem6.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
        //    cartesianCoordinateSystem6.YAxis = graphAxisNumericalScale6;

        //    reportGraphName.CoordinateSystems.Add(cartesianCoordinateSystem6);

        //    //The Graph Series area
        //    var barSeries1 = new BarSeries();
        //    barSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    barSeries1.CoordinateSystem = cartesianCoordinateSystem;
        //    barSeries1.LegendItem.Value = StoreHourReport.StoreHourReport_NoofVisitor;
        //    barSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    barSeries1.Y = yAxisGroup;
        //    barSeries1.ColorPalette = new ColorPalette( Color.FromArgb(18, 179, 148));//new ColorPalette(Color.Teal);
        //    barSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(y1Data, StoreHourReport.StoreHourReport_NoofVisitor + ": {0:N0}");

        //    //The Line Series area
        //    var areaSeries1 = new AreaSeries();
        //    areaSeries1.CategoryGroup = SalesConversionSectionCategoryGroup;
        //    areaSeries1.CoordinateSystem = cartesianCoordinateSystem6;
        //    areaSeries1.LegendItem.Value = StoreHourReport.StoreHourReport_OutsideTraffic;
        //    areaSeries1.LegendItem.MarkStyle.BackgroundColor = Color.FromArgb(91, 166, 214);  //(new ColorPalette(new string[] { "0x88,0xd9,0xc9" })).Colors.FirstOrDefault();
        //    areaSeries1.LegendItem.Style.Visible = true;
        //    areaSeries1.SeriesGroup = SalesConversionSectionSeriesGroup;
        //    areaSeries1.Y = yAxisGroup2;
        //    areaSeries1.AreaStyle.LineStyle = LineStyle.Solid;
        //    areaSeries1.AreaStyle.LineColor = Color.FromArgb(91, 166, 214);
        //    areaSeries1.AreaStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(1);
        //    areaSeries1.LineType = LineSeries.LineTypes.Smooth;
        //    areaSeries1.MarkerType = DataPointMarkerType.Circle;
        //    areaSeries1.MarkerSize = new Telerik.Reporting.Drawing.Unit(10);
        //    areaSeries1.DataPointStyle.BackgroundColor = Color.FromArgb(0, Color.Black);
        //    areaSeries1.DataPointStyle.LineColor = Color.FromArgb(0, Color.Black);
        //    areaSeries1.DataPointStyle.Visible = true;
        //    areaSeries1.ColorPalette = new ColorPalette(new string[] { "0x60,0x88,0xd9,0xc9" });
        //    areaSeries1.ToolTip.Text = Utility.Telerik_FormatExpression(y2Data, StoreHourReport.StoreHourReport_OutsideTraffic + ": {0:N0}");

        //    reportGraphName.Legend.Position = GraphItemPosition.TopCenter;
        //    reportGraphName.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);
        //    reportGraphName.Series.Add(areaSeries1);
        //    reportGraphName.Series.Add(barSeries1);

        //    return reportGraphName;
        //}

        
        public static string CheckExtendedHours(double hours)
        {
            string format = "{0:0.00}";

            try
            {
                if (hours > 0)
                {
                    return "+" + string.Format(format, hours) + "h"; 
                }
                else if (hours < 0)
                {
                    return "-" + string.Format(format, Math.Abs(hours)) + "h";
                }
                else
                {
                    return "-";
                }
            }
            catch
            {
                return "-";
            }
        }

        public static string CheckExpectedIncrease(double expectedIncrease)
        {
            string format = "{0:0.00}";

            try
            {
                if (expectedIncrease != 0)
                {
                    return string.Format(format, expectedIncrease) + "%";
                }
                else
                {
                    return " -";
                }
            }
            catch
            {
                return " -";
            }

        }

        public static string CheckExpectedSaved(double expectedSaved)
        {
            string format = "{0:0.00}";

            try
            {
                if (expectedSaved > 0)
                {
                    return "+" + string.Format(format, Math.Abs(expectedSaved)) + "h";
                }
                else if (expectedSaved < 0)
                {
                    return "-" + string.Format(format, Math.Abs(expectedSaved)) + "h";
                }
                else
                {
                    return "N/A";
                }
            }
            catch
            {
                return "N/A";
            }
        }
        

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }
    }
}