namespace RetailCamControlPanel
{
    using RetailCamControlPanel.Services.CompositeService;
    using RetailCamControlPanel.Services.SingularService;
    using System;
    using System.Linq;
    using System.ComponentModel;
    using System.Drawing;
    using System.Globalization;
    using System.Windows.Forms;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using RetailCamControlPanel.ViewModel;
    //using RetailCamControlPanel.Resources;
    using System.Collections.Generic;
    using RetailCamControlPanel.Helper;
    /// <summary>
    /// Summary description for StoreCrossShopReport.
    /// </summary>
    public partial class StoreCrossShopReport : Telerik.Reporting.Report
    {
        public StoreCrossShopReport()
        {
            //
            // Required for telerik Reporting designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        private void StoreCrossShopReport_NeedDataSource(object sender, EventArgs e)
        {
            #region DefaultSettings
            string font = "Arial Unicode MS";
            #endregion


            #region Services
            //services
            var compositeService = MvcApplication.container.GetInstance<FFCompositeService>();
            var branchService = MvcApplication.container.GetInstance<FFBranchService>();
            var companyService = MvcApplication.container.GetInstance<CompanyService>();
            var branchCrossShopService = MvcApplication.container.GetInstance<FFBranchCrossShopService>();
            var branchDailyService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            #endregion 
            compositeService.checkIfArialUnicodeInstalled();
            //report feed
            var report = (Telerik.Reporting.Processing.Report)sender;

            //Start date
            var startDate = report.Parameters["Date"].Value.ToString();
            var dateFormatHtml = report.Parameters["dateFormat"].Value.ToString();
            var dateFormat = 1;


            DateTime selectedDate = new DateTime();
            if (dateFormatHtml == "dateFirst")
            {
                selectedDate = DateTime.ParseExact(startDate, "dd/MM/yyyy", CultureInfo.InvariantCulture);
            }
            else
            {
                selectedDate = DateTime.ParseExact(startDate, "MM/dd/yyyy", CultureInfo.InvariantCulture); dateFormat = 2;

            }
            DayOfWeek dow = selectedDate.DayOfWeek;
            var day = dow.ToString();
            var companyCode = report.Parameters["CompanyCode"].Value.ToString();
            var companyName = report.Parameters["CompanyName"].Value.ToString();
            var language = report.Parameters["Language"].Value.ToString();
            var store = report.Parameters["Stores"].Value.ToString();
            var storeId = Convert.ToInt64(report.Parameters["BranchID"].Value);

            //pull daily raw data
            var whichCompany = companyService.GetCompanyWhere(x => x.CompanyCode == companyCode).ID;
            var allBranches = branchService.GetBranches(x => x.CompanyId == whichCompany).ToList();
            var currentBranchName = allBranches.Where(x => x.ID == storeId).Select(x => x.BranchName).FirstOrDefault();
            var allCrossShopValues = branchCrossShopService.GetBranchCrossShopWithSelectedBranch(storeId, selectedDate).ToList();
            var top5branchCrossShopValueFromOtherBranch = allCrossShopValues.Join(allBranches, cs => cs.FromBranch, ffb => ffb.ID, (cs, ffb) => new FFBranchCrossShopViewModel
            {
                Id = cs.Id,
                FromBranch = cs.FromBranch,
                ToBranch = cs.ToBranch,
                ValueDateTime = cs.ValueDateTime,
                WifiCount = cs.WifiCount,
                FromBranchName = ffb.BranchName,
                ToBranchName = currentBranchName
            }
            ).Where(x => x.ValueDateTime == selectedDate).OrderByDescending(x => x.WifiCount).Take(5).ToList();

            var allWifiCount = allCrossShopValues.Sum(x => x.WifiCount);
            var branchCrossShopSummaryFromCurrentBranch = branchDailyService.GetBranchSummaryDailyReportWithSelectedBranch(storeId, selectedDate).
                                                          Where(x => x.ValueDateTime == selectedDate).ToList();


            if (top5branchCrossShopValueFromOtherBranch.Count == 0 || top5branchCrossShopValueFromOtherBranch == null || branchCrossShopSummaryFromCurrentBranch.Count == 0 || branchCrossShopSummaryFromCurrentBranch == null)
            {
                displayReportComponent(false);
                errorBox.Value = StoreCrossShopReportViewer.StoreCrossShopReportViewer_NoDataYet;
            }
            else if(branchCrossShopSummaryFromCurrentBranch.FirstOrDefault().ValueIn == 0)
            {
                displayReportComponent(false);
                errorBox.Value = StoreCrossShopReportViewer.StoreCrossShopReportViewer_NoDataYet;
            }
            else
            {
                displayReportComponent(true);
                //Bind UI
                reportTitle.Value = (store == "")
                  ? StoreCrossShopReportViewer.StoreCrossShopReportViewer_CrossShopper.ToUpper() + " " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Report.ToUpper()
                  : store.ToUpper() + " " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_CrossShopper.ToUpper() +
                    " " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Report.ToUpper();
                dayDate.Value = day + " " + startDate;

                TypeOfCrossShopperSection.Value = StoreCrossShopReportViewer.StoreCrossShopReportViewer_TypeOfCrossShoppers.ToUpper();
                Top5CrossShopperSitesSection.Value = StoreCrossShopReportViewer.StoreCrossShopReportViewer_Top5.ToUpper() + " " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_CrossShopper.ToUpper() + " " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Report.ToUpper();

                var crossShop = branchCrossShopSummaryFromCurrentBranch.FirstOrDefault();
                var noCrossShopTotal = crossShop.MonthlyCustomer;
                var crossShopTotal = crossShop.CrossOneCustomer + crossShop.CrossTwoCustomer + crossShop.CrossThreeCustomer + crossShop.CrossMoreCustomer;
                var num = (crossShopTotal * 1.0) / (noCrossShopTotal + crossShopTotal);
                var crossShopPercentage = Math.Round((num * 100), 2);
                tbCrossShoppingTotal.Value = (crossShopPercentage + "%").ToString();
                var crossOneShop = crossShop.CrossOneCustomer;
                var crossTwoShop = crossShop.CrossTwoCustomer;
                var crossThreeShop = crossShop.CrossThreeCustomer;
                var crossMoreShop = crossShop.CrossMoreCustomer;
                List<Object> typeOfCrossShopper = new List<Object>();
                if (crossOneShop >= 0)
                    typeOfCrossShopper.Add(new { CrossShopperType = "1 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Site,
                                                 CrossShopperPercentage = Math.Round((crossOneShop * 1.0 / crossShopTotal) * 100, 2),
                                                 CrossShopLabel = "1 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Site + " : " + Math.Round((crossOneShop * 1.0 / crossShopTotal) * 100, 2).ToString() + " %"});
                if (crossTwoShop >= 0)
                    typeOfCrossShopper.Add(new { CrossShopperType = "2 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches,
                                                 CrossShopperPercentage = Math.Round((crossTwoShop * 1.0 / crossShopTotal) * 100, 2),
                                                 CrossShopLabel = "2 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches + " : " + Math.Round((crossTwoShop * 1.0 / crossShopTotal) * 100, 2).ToString() + " %"});
                if (crossThreeShop >= 0)
                    typeOfCrossShopper.Add(new { CrossShopperType = "3 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches,
                                                 CrossShopperPercentage = Math.Round((crossThreeShop * 1.0 / crossShopTotal) * 100, 2),
                                                 CrossShopLabel = "3 " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches + " : " + Math.Round((crossThreeShop * 1.0 / crossShopTotal) * 100, 2).ToString() + " %"});
                if (crossMoreShop >= 0)
                    typeOfCrossShopper.Add(new { CrossShopperType = "4> " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches,
                                                 CrossShopperPercentage = Math.Round((crossMoreShop * 1.0 / crossShopTotal) * 100, 2),
                                                 CrossShopLabel = "4> " + StoreCrossShopReportViewer.StoreCrossShopReportViewer_Branches + " : " + Math.Round((crossMoreShop * 1.0 / crossShopTotal) * 100, 2).ToString() + " %"});
                tableTypeOfCrossShoppers.DataSource = typeOfCrossShopper;
                double totalCrossShopPercentage = 0.0;
                List<Object> top5CrossShopperSites = new List<Object>();
                for (int i = 0; i < top5branchCrossShopValueFromOtherBranch.Count; i++)
                {
                    //var numOfWifiCount = Math.Floor((top5branchCrossShopValueFromOtherBranch[i].WifiCount * 1.0 / allWifiCount) * crossShop.ValueIn);
                    //if (numOfWifiCount == 0)
                    //    break;
                    //top5CrossShopperSites.Add(new { Rank = i+1, Site = top5branchCrossShopValueFromOtherBranch[i].FromBranchName, CrossShopper = numOfWifiCount});
                    var siteShopPercentage = Math.Round((top5branchCrossShopValueFromOtherBranch[i].WifiCount * 1.0 / allWifiCount) * 100, 2);
                    top5CrossShopperSites.Add(new { Rank = i + 1, Site = top5branchCrossShopValueFromOtherBranch[i].FromBranchName,
                                                    CrossShopper = siteShopPercentage,
                                                    CrossShopperLabel = top5branchCrossShopValueFromOtherBranch[i].FromBranchName + " : " + siteShopPercentage + " %"});
                    totalCrossShopPercentage = totalCrossShopPercentage + siteShopPercentage;
                }
                tableTop5CrossShopperSites.DataSource = top5CrossShopperSites;
                PlotPieGraph("PieChartTypeOfCrossShopper", this.graphTypeCrossShopper, typeOfCrossShopper, "=Fields.CrossShopperType", "=Fields.CrossShopperPercentage", "=Fields.CrossShopperPercentage", font, "=Fields.CrossShopLabel", "{0}");

                List<Object> pieChartTop5Sites = new List<Object>();
                foreach (var item in top5CrossShopperSites)
                {
                    pieChartTop5Sites.Add(item);
                }
                if (pieChartTop5Sites.Count > 0)// add others
                {
                    var otherCrossShopPercentage = 100 - totalCrossShopPercentage;
					pieChartTop5Sites.Add(new
					{
						Rank = 6,
						Site = "Others",
						CrossShopper = otherCrossShopPercentage,
						CrossShopperLabel = LanguageOthers.Others_Others + " : " + otherCrossShopPercentage + " %"
					});
                }

                PlotPieGraph("PieChartTop5CrossShopperSites", this.graphTop5CrossShopperSites, pieChartTop5Sites, "=Fields.Site", "=Fields.CrossShopper", "=Fields.CrossShopper", font, "=Fields.CrossShopperLabel", "{0}");
            }
        }

        private void displayReportComponent(bool isDataAvailable)
        {
            errorBox.Visible = !isDataAvailable;
            TypeOfCrossShopperSection.Visible = isDataAvailable;
            Top5CrossShopperSitesSection.Visible = isDataAvailable;
            sectionLine.Visible = isDataAvailable;
            sectionLine2.Visible = isDataAvailable;
            graphTypeCrossShopper.Visible = isDataAvailable;
            tableTypeOfCrossShoppers.Visible = isDataAvailable;
            tableTop5CrossShopperSites.Visible = isDataAvailable;
            graphTop5CrossShopperSites.Visible = isDataAvailable;
            reportTitle.Visible = isDataAvailable;
            dayDate.Visible = isDataAvailable;
        }

        public Graph PlotPieGraph(string graphName, Graph reportGraphName, List<Object> graphDataSource, string graphGroup, string graphSorting, string xAxisGroup, string font,string dataPointLabel, string dataPointLabelFormat)
        {
            reportGraphName.Name = graphName;
            reportGraphName.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(11);
            reportGraphName.Style.Font.Bold = false;
            reportGraphName.Style.Font.Name = font;

            //Setup the SqlDataSource
            reportGraphName.DataSource = graphDataSource;

            //Create the category group
            var categoryGroup1 = new GraphGroup();
            categoryGroup1.Name = "categoryGroup";
            reportGraphName.CategoryGroups.Add(categoryGroup1);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup1 = new GraphGroup();
            seriesGroup1.Name = "seriesGroup";
            seriesGroup1.Groupings.Add(new Grouping(graphGroup));
            seriesGroup1.Sortings.Add(new Sorting(graphSorting));
            reportGraphName.SeriesGroups.Add(seriesGroup1);


            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "X Axis";
            graphAxisCategoryScale.Scale = new CategoryScale();
            graphAxisCategoryScale.Scale.SpacingSlotCount = 0;
            graphAxisCategoryScale.Style.Font.Bold = false;
            graphAxisCategoryScale.Style.Font.Name = font;
            graphAxisCategoryScale.Style.Visible = false;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            //graphAxisCategoryScale.Style.LineColor = Color.White;
            graphAxisCategoryScale.LabelPlacement = GraphAxisLabelPlacement.NextToAxis;
            graphAxisCategoryScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.Cross;
            graphAxisCategoryScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisCategoryScale.MultiLevelCategoryLabels = true;
            graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.Centered;
            //graphAxisCategoryScale.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale = new GraphAxis();
            graphAxisNumericalScale.Name = "Y Axis";
            graphAxisNumericalScale.Scale = new NumericalScale();
            graphAxisNumericalScale.Scale.SpacingSlotCount = 1;
            graphAxisNumericalScale.Style.Font.Bold = false;
            graphAxisNumericalScale.Style.Visible = false;
            graphAxisNumericalScale.Style.Font.Name = font;
            graphAxisNumericalScale.LabelPlacement = GraphAxisLabelPlacement.NextToAxis;
            graphAxisNumericalScale.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.Cross;
            graphAxisNumericalScale.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            graphAxisNumericalScale.MultiLevelCategoryLabels = true;
            graphAxisNumericalScale.TitlePlacement = GraphAxisTitlePlacement.Centered;
            //graphAxisNumericalScale.Style.LineColor = Color.White;
            //  graphAxisNumericalScale5.Style.Color = Color.FromArgb(1, 73, 75, 75);

            var polarCoordinateSystem = new PolarCoordinateSystem();
            polarCoordinateSystem.Name = "polarCoordinateSystem";
            polarCoordinateSystem.RadialAxis = graphAxisCategoryScale;
            polarCoordinateSystem.AngularAxis = graphAxisNumericalScale;
            polarCoordinateSystem.AngularAxisLabelOrientation = AngularAxisLabelOrientation.Fixed;
            polarCoordinateSystem.AngularAxisSweepAngle = 360.0;
            //polarCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraphName.CoordinateSystems.Add(polarCoordinateSystem);
            //polarCoordinateSystem.XAxis.LabelAngle = 270;

            //The Graph Series area
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = categoryGroup1;
            barSeries1.CoordinateSystem = polarCoordinateSystem;
            barSeries1.SeriesGroup = seriesGroup1;
            barSeries1.X = xAxisGroup;
            barSeries1.ArrangeMode = GraphSeriesArrangeMode.Stacked100;
            barSeries1.DataPointLabel = dataPointLabel;
            barSeries1.DataPointLabelFormat = dataPointLabelFormat;
            barSeries1.DataPointLabelAlignment = BarDataPointLabelAlignment.OutsideColumn;
            barSeries1.DataPointLabelOffset = new Telerik.Reporting.Drawing.Unit(10, UnitType.Pixel);
            barSeries1.DataPointLabelConnectorStyle.Visible = true;
            reportGraphName.Legend.Style.Visible = false;
            reportGraphName.Series.Add(barSeries1);
            //reportGraphName.Legend.Position = GraphItemPosition.TopCenter;

            return reportGraphName;
        }

    }
}