using System.Collections.Generic;

namespace RetailCamControlPanel
{
    using Helper;
    using Models;
    using Services.CompositeService;
    using Services.SingularService;
    using System;
    using System.Drawing;
    using System.Globalization;
    using System.Linq;
    using Telerik.Reporting;
    using Telerik.Reporting.Drawing;
    using ViewModel;
    using System.Web;
    //using Resources;
    using System.Threading;
    using System.Configuration;
    using System.Reflection;
    using Newtonsoft.Json;
    using System.IO;

    /*
     *  ===== TELERIK REPORT TEMPLATE PREREQUISITES ====================
     *  
     *  MODULES: 
     *  Copy and Paste the required module(s) within this template. 
     *  You can create your own module to cater specific needs. 
     *  *MODULE DIMENSION: 
     *  - Width     : 3.4 cm
     *  - Height    : 2.4 cm
     *  *GAP BETWEEN MODULES (Using Panel): 
     *  - Width     : 0.5 cm
     *  - Height    : 2.4 cm
     *  
     *  COLOR PATLETTE FOR EACH SECTION: 
     *  1. Pink #ef7cae         RGB: 239,124,174
     *  2. Orange #ff8000       RGB: 255,128,0
     *  3. Green #62bc69           RGB: 98,188,105
     *  4. Blue #60a5da            RGB: 96,165,218
     *  5. Brown #b0902f           RGB: 176,144,47
     *  
     *  PLEASE CONFIGURE THE INDIVIDUAL ELEMENTS' PROPERTIES IN DESIGNER
     *  (ESPECIALLY SETTING FONT NAME TO "Arial Unicode MS")
     *  
     *  ================================================================
    */
    public partial class TelerikReportTemplate : Telerik.Reporting.Report
    {
        private String retailCamControlPanelURL = ConfigurationManager.AppSettings["RetailCamControlPanelURL"];
        public static List<BranchSummaryDailyReportViewModel> sevenDayTrendData;

        public TelerikReportTemplate()
        {
            InitializeComponent();
        }

        private void TelerikReportTemplate_NeedDataSource(object sender, EventArgs e)
        {
            #region  ===== VARIABLES
            //VARIABLES
            //DEFAULT FONT FOR TELERIK REPORT: "Arial Unicode MS"
            //PLEASE MODIFY THE FONT OF ALL ELEMENTS IN THE REPORT IN DESIGNER VIEW
            string font = Utility.Telerik_GetDefaultFontName();

            long companyId = 0;
            var min = 15;
            var max = 30;
            var branchId = 0;
            var twoYearsWorth = false;
            var dateFormat = 1;

            #endregion


            #region ===== ADD SERVICE REFERENCES
            //==================================================================================================================
            /* ADD SERVICE REFERENCES TO USE COMPOSITE AND SINGULAR SERVICES
             *      - Add the required services to do RAW DATA PULLING & DATA AGGREGATION to call functions within the services      
             *      
             *      ** IMPORTANT: Consult appropriate person before modifying/adding new functions into these services. 
            */

            //EXAMPLE OF REFERENCING SERVICES (REMOVE THE UNNECESSARY REFERENCING, ONLY INCLUDE THE REQUIRED REFERENCING)
            var ffBranchSummaryHourlyReportService = MvcApplication.container.GetInstance<FFBranchSummaryHourlyReportService>();
            var ffBranchSummaryDailyReportService = MvcApplication.container.GetInstance<FFBranchSummaryDailyReportService>();
            var ffcompositeServices = MvcApplication.container.GetInstance<FFCompositeService>();
            var companyServices = MvcApplication.container.GetInstance<CompanyService>();
            var companySettingService = MvcApplication.container.GetInstance<CompanySettingService>();

 //EXAMPLE OF CALLING FUNCTIONS FROM THE SERVICES (Get Company Settings)
            //var company = companyServices.GetCompany(MyHelper.CompanyCode);
            var company = companyServices.GetCompany("Bonmarche");
            CompanySetting companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == company.ID);
            #endregion

            //REQUIRED: TO CHECK WHETHER THE CLIENT SERVER HAS THE REQUIRED FONT OR NOT. IF NOT, RCCP WILL AUTO INSTALL
            ffcompositeServices.checkIfArialUnicodeInstalled();

            var Report = (Telerik.Reporting.Processing.Report)sender;

            //EXAMPLE OF CALLING FUNCTIONS FROM THE SERVICES (Get Company Settings)
            //var company = companyServices.GetCompany(MyHelper.CompanyCode);
            companyId = companyServices.GetCompany(MyHelper.CompanyCode).ID;
            companySetting = companySettingService.GetCompanySetting(w => w.CompanyId == companyId);
            try
            {

                #region ===== OBTAIN DATA FROM FRONT-END 

                //==================================================================================================================
                /*
                 * OBTAIN DATA FROM FRONT-END (DATA PASSING)
                 *  1. Setting Report Parameters:- 
                 *      -> Right click on the report designer view, select 'Report Parameters... '
                 *      -> Modify parameters based on the requirements
                 *  2. Pass arguments from front-end into report:- 
                 *      -> Please check Views\FootfallCam\NewReportTemplate.cshtml to see the code snippet... 
                */

                //Assign arguments from front-end to here (Name of the parameters is based on the configured 'Report Parameters')
                var reportTitleParam = Report.Parameters["reportTitleParam"].Value;

                var m1Title = Report.Parameters["m1Title"].Value;
                var m2Title = Report.Parameters["m2Title"].Value;
                var m3Title = Report.Parameters["m3Title"].Value;
                var m4Title = Report.Parameters["m4Title"].Value;
                var m5Title = Report.Parameters["m5Title"].Value;
                var m6Title = Report.Parameters["m6Title"].Value;
                var m7Title = Report.Parameters["m7Title"].Value;
                var m8Title = Report.Parameters["m8Title"].Value;

                var m1MValue = Report.Parameters["m1MValue"].Value;
                var m7MValue = Report.Parameters["m7MValue"].Value;

                var m7SubValue = Report.Parameters["m7SubValue"].Value;

                var startDateUI = Report.Parameters["Date"].Value;
                var endDateUI = Report.Parameters["EndDate"].Value;
                var weekNumber = Report.Parameters["Week"].Value;
                var companyCode = Report.Parameters["CompanyCode"].Value.ToString();
                var companyName = Report.Parameters["CompanyName"].Value.ToString();
                var selectedRegion = Report.Parameters["Region"].Value.ToString();
                var dateFormatHtml = Report.Parameters["dateFormat"].Value.ToString();
                var language = Report.Parameters["Language"].Value.ToString();

                bool isError = (bool)Report.Parameters["isError"].Value;

                #endregion

                #region ===== Info Gathering
                //Get Required Information for RAW DATA PULLING, DATA AGGREGATION and other usage within the report
                var cultureInfo = new System.Globalization.CultureInfo(language);
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                //Determine First Day of the Week based on Company Setting
                DayOfWeek firstDayOfWeek = new DayOfWeek();
                if (companySetting != null)
                {
                    firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                        ? DayOfWeek.Sunday
                        : companySetting.FirstDayOfWeek == "Saturday"
                            ? DayOfWeek.Saturday
                            : DayOfWeek.Monday;
                }
                else
                {
                    firstDayOfWeek = DayOfWeek.Monday;
                }

                //Determine Date & Date Format based on Company Setting
                DateTime startd = new DateTime();
                DateTime endd = new DateTime();
                if (dateFormatHtml == "dateFirst")
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "dd/MM/yyyy", CultureInfo.InvariantCulture);
                }
                else
                {
                    startd = DateTime.ParseExact(startDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    endd = DateTime.ParseExact(endDateUI.ToString(), "MM/dd/yyyy", CultureInfo.InvariantCulture);
                    dateFormat = 2;
                }

                long startTimestamp = Utility.ConvertToTimestamp(startd);
                long endTimestamp = Utility.ConvertToTimestamp(endd);

                //Determine to get Years worth of data
                var financialStartEnd = GetFinancialWeekList(startd, companySetting);
                DateTime startDate = twoYearsWorth ? financialStartEnd.LastYear.FinancialStartDate : financialStartEnd.ThisYear.FinancialStartDate;
                DateTime endDate = financialStartEnd.ThisYear.FinancialEndDate;

                // Determine to get last 52 weeks worth of data for Site Trend Analysis
                DateTime startDate52Weeks = getFirstDayOf52Weeks(firstDayOfWeek);
                var financialYear52Weeks = new FinancialYearVM();
                var financialStartEnd52Weeks = new FinancialStartEnd();
                financialStartEnd52Weeks.FinancialStartDate = startDate52Weeks;
                financialStartEnd52Weeks.FinancialEndDate = startDate52Weeks.AddDays(371);
                financialYear52Weeks.ThisYear = financialStartEnd52Weeks;

                #endregion

                #region ===== PULL RAW DATA
                //==================================================================================================================
                /*
                 * RAW DATA PULLING
                 * Using Composite Services to pull RAW DATA from DB
                 * Consult appropriate person before modifying/adding new functions
                 * (THIS EXAMPLE IS USING DUMMY DATA AS THE INITIAL RAW DATA, CONSIDER WHERE TO PULL THE APPROPRIATE RAW DATA IN YOUR OWN SCENARIO)
                */
                string RCCPPATH = HttpRuntime.AppDomainAppPath;

                //Daily Raw Data (Dummy)
                string drdFilePath = RCCPPATH + "DummyData\\dailyRawData.json";
                Utility.ConvertFileContentToObjects<BranchSummaryDailyReportViewModel> Mapper = new Utility.ConvertFileContentToObjects<BranchSummaryDailyReportViewModel>();
                //var dailyRawData = File.Exists(drdFilePath) ? Mapper.MapContentToObjects(drdFilePath) : null;

                var dailyRawData = ffcompositeServices.GetBranchSummaryReport(startDate52Weeks, startDate52Weeks.AddDays(371), "", Convert.ToInt64("522"), true, true);

                sevenDayTrendData = dailyRawData.Where(s => s.Date >= startTimestamp && s.Date <= endTimestamp).ToList();
                
                //Hourly Raw Data (Dummy)
                string hrdFilePath = RCCPPATH + "DummyData\\hourlyRawData.json";
                Utility.ConvertFileContentToObjects<BranchSummaryDailyReportViewModel> Mapper2 = new Utility.ConvertFileContentToObjects<BranchSummaryDailyReportViewModel>();
                var hourlyRawData = File.Exists(hrdFilePath) ? Mapper2.MapContentToObjects(hrdFilePath) : null;

                #endregion

                #region ===== REPORT (Error Checking, Data Aggregation, Text Binding, Graph Plotting)
                // HANDLE ERROR REPORT e.g. IF DATA IS NOT AVAILABLE
                if (isError || dailyRawData == null)
                {
                    reportTitle.Visible = false;
                    dayDate.Visible = false;
                    panel2.Visible = false;
                    panel1.Visible = false;
                    panel9.Visible = false;
                    panel10.Visible = false;
                    panel11.Visible = false;
                    panel12.Visible = false;
                    errorBox.Visible = true;
                    errorBox.Value = dailyRawData == null ? "Error! Dummy Data not found! " : "Error Detected by Toggle... Error message can be written here... ";
                }
                else
                {
                    reportTitle.Visible = true;
                    dayDate.Visible = true;
                    panel2.Visible = true;
                    panel1.Visible = true;
                    panel9.Visible = true;
                    panel10.Visible = true;
                    panel11.Visible = true;
                    panel12.Visible = true;
                    errorBox.Visible = false;

                    //==================================================================================================================
                    /*
                     * DATA AGGREGATION
                     * Using Singular Services to perform DATA AGGREGATION
                     * Consult appropriate person before modifying/adding new functions
                    */

                    //Top Matric Data
                    var topMatricData = ffBranchSummaryDailyReportService.CalculateMatricData(dailyRawData, true, endd);
                    var topMatricGraph = ffBranchSummaryDailyReportService.GetTopMatricGraphTrend(dailyRawData, startd);

                    //League Statistics
                    var leagueDataRawData =
                        ffBranchSummaryDailyReportService.CalculateLeagueStatistics(dailyRawData, startd);
                    var leagueData = leagueDataRawData.OrderByDescending(o => o.SalesConversion).Select(
                        (s, index) => new BranchSummaryDailyReportViewModel
                        {
                            Rank = index + 1,
                            BranchCode = s.BranchCode,
                            BranchName = s.BranchName,
                            SalesConversion = s.SalesConversion,
                            SalesConversionDiff = s.SalesConversionDiff
                        }).Take(15);

                    var leagueData2 = leagueDataRawData.OrderBy(o => o.SalesConversion).Select(
                        (s, index) => new BranchSummaryDailyReportViewModel
                        {
                            Rank = index + 1,
                            BranchCode = s.BranchCode,
                            BranchName = s.BranchName,
                            SalesConversion = s.SalesConversion,
                            SalesConversionDiff = s.SalesConversionDiff
                        }).Take(15);

                    //Trend
                    var monthlyBranchSummary =
                        ffBranchSummaryDailyReportService.CalculateMonthlyTrend(dailyRawData, startd, firstDayOfWeek, financialStartEnd, companySetting);
                    var weeklyBranchSummary =
                        ffBranchSummaryDailyReportService.CalculateWeeklyTrend(dailyRawData, startd, firstDayOfWeek, financialStartEnd);
                    var dailyBranchSummary = ffBranchSummaryDailyReportService.CalculateDailyTrend(dailyRawData, endd);

                    //Weekly Trend
                    long weeklyMaxValue = weeklyBranchSummary.ThisYear.Max(s => s.ValueIn);
                    long weeklyMinValue = weeklyBranchSummary.ThisYear.Min(s => s.ValueIn);
                    long denominatorWeekly = TelerikUtility.CheckValueDenominator(weeklyMaxValue, weeklyMinValue);
                    string weeklyValueFormat = TelerikUtility.DenominatedStringFormat(denominatorWeekly);
                    var graphWeeklyDataSource = weeklyBranchSummary.ThisYear.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekly,
                            SalesConversion = s.SalesConversion,
                            Week = s.Week.ToString()
                        });

                    // Site Trend Analysis
                    var weeklyBranchSummary52Weeks =
                        ffBranchSummaryDailyReportService.CalculateWeeklyTrendPast52Weeks(dailyRawData, startDate52Weeks, firstDayOfWeek, financialYear52Weeks);

                    long weeklyMaxValue52Weeks = weeklyBranchSummary52Weeks.Max(s => s.ValueIn);
                    long weeklyMinValue51Weeks = weeklyBranchSummary52Weeks.Min(s => s.ValueIn);
                    long denominatorWeekly52Weeks = TelerikUtility.CheckValueDenominator(weeklyMaxValue52Weeks, weeklyMinValue51Weeks);
                    string weeklyValueFormat52Weeks = TelerikUtility.DenominatedStringFormat(denominatorWeekly52Weeks);
                    var graphWeeklyDataSource52Weeks = weeklyBranchSummary52Weeks.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            ValueInDouble = (double)s.ValueIn / denominatorWeekly52Weeks,
                            SalesConversion = s.SalesConversion,
                            Week = s.Week.ToString(),
                            // = s.WeekString
                        });

                    var graphWeeklyVisitDurationDataSource52Weeks = weeklyBranchSummary52Weeks.AsReadOnly().Select(
                        s => new BranchSummaryDailyReportViewModel
                        {
                            LessThan15mins = s.LessThan15mins,
                            Between15Till30mins = s.Between15Till30mins,
                            LargerThan30mins = s.LargerThan30mins,
                            Week = s.Week.ToString()
                        });

                    //Branch Statistics
                    var branchStatisticsRaw =
                        ffBranchSummaryDailyReportService.GetStoresRanking(dailyRawData, startd, endd, true);

                    //==================================================================================================================
                    /*
                     * TEXT & DATA BINDING
                     *      ->  Use to bind required/acquired text/value into report elements. 
                     *      ->  Some value can be bind into elements.Value by writing an expression 
                     *          based on the assigned DataSource of an object e.g. a table or a graph
                    */

                    // TEXT BINDING FROM ACQUIRED ARGUMENTS INTO REPORT ELEMENTS
                    module1Title.Value = m1Title.ToString() == "" ? "No Title" : m1Title.ToString();
                    module2Title.Value = m2Title.ToString() == "" ? "No Title" : m2Title.ToString();
                    module3Title.Value = m3Title.ToString() == "" ? "No Title" : m3Title.ToString();
                    module4Title.Value = m4Title.ToString() == "" ? "No Title" : m4Title.ToString();
                    module5Title.Value = m5Title.ToString() == "" ? "No Title" : m5Title.ToString();
                    module6Title.Value = m6Title.ToString() == "" ? "No Title" : m6Title.ToString();
                    module7Title.Value = m7Title.ToString() == "" ? "No Title" : m7Title.ToString();
                    module8Title.Value = m8Title.ToString() == "" ? "No Title" : m8Title.ToString();

                    module1MainValue.Value = m1MValue.ToString() == "" ? "-" : m1MValue.ToString();
                    module7MainValue.Value = m7MValue.ToString() == "" ? "-" : m7MValue.ToString();

                    module7SubValue.Value = m7SubValue.ToString() == "" ? "-" : CheckSalesConversionOverview(Double.Parse(m7SubValue.ToString()));

                    // TEXT BINDING FROM LanguageHelper (Consult for usage of LanguageHelper & Language.resx)
                    reportTitle.Value = reportTitleParam.ToString() == "" ? TelerikReportTemplateViewer.TelerikReportTemplate_MainTitle : reportTitleParam.ToString();
                    section1Title.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_LeagueStatistics.ToUpper();
                    section1Subtitle.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Top15Stores;
                    section1Subtitle2.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Bottom15Stores;
                    section2Title.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion.ToUpper();
                    section3Title.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchStatistics.ToUpper();
                    section3Subtitle.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchStatistics;

                    //Top 15 Stores Table Header Language
                    storeCodeTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    storeNameTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    conversionTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)";
                    changesTop.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + " (%)";
                    //Bottom 15 Stores Table Header Language
                    storeCodeBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    storeNameBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    conversionBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + " (%)";
                    changesBottom.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + " (%)";

                    //Branch Statistics Table Header Language
                    storeCodeHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchCode;
                    siteHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_BranchName;
                    thisWeekHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ThisWeek + " (%)";
                    changesHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + "(%)";
                    turnInRateHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TurnInRate + "(%)";
                    changesTIRHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ChangesfromLastWeek + " (" + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_TurnInRate + ") (%)";
                    sevenDayTrendHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SevenDayTrend;
                    RankHeader.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Rank;

                    // TEXT BINDING HARD-CODED (NOT RECOMMENDED)
                    section4Title.Value = "SECTION 4 TITLE";
                    section5Title.Value = "SECTION 5 TITLE";
                    section2Subtitle.Value = "Sales Conversion Weekly Trend Graph (PlotBarLineGraph)";
                    section2Subtitle2.Value = "Sales Conversion Weekly Trend Graph (PlotBarGraph)";
                    section2Subtitle3.Value = "Sales Conversion Weekly Trend Graph (PlotLineLIneGraph)";
                    section4Subtitle.Value = "Section 4 Subtitle";
                    section5Subtitle.Value = "Section 5 Subtitle";

                    // OTHER TEXT BINDING USAGE
                    dayDate.Value = CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_ReportPeriod
                        + ": " + startDateUI + " - " + endDateUI
                        + " (" + CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_Week + " " + weekNumber + ")";

                    //SET UP/DOWN ARROW BASED ON SALES CONVERSION DIFFERENCE (Coded)
                    // You can also set the expression within the Designer. See the picturebox.Value for reference
                    module7PicBox.Value = GetDiffImage(Double.Parse(m7SubValue.ToString()));

                    //BIND DATA TO TABLE
                    //Overview Tables
                    //To apply the data from DataSource to table cell, enter the appropriate expression in each required cells' Value property in Designer View
                    //E.g. [=Fields.ValueIn] where the variables are available based on the ViewModel
                    //Apply with function is possible. e.g. [= CheckTransactionCount(Fields.ValueIn)] in module8MainValue.Value
                    module1Table.DataSource = topMatricData;
                    module2Table.DataSource = topMatricData;
                    module3Table.DataSource = topMatricData;
                    module4Table.DataSource = topMatricData;
                    module5Table.DataSource = topMatricData;
                    module6Table.DataSource = topMatricData;
                    module7Table.DataSource = topMatricData;
                    module8Table.DataSource = topMatricData;

                    //League Statistics
                    top15storeTable.DataSource = leagueData;
                    bottom15storeTable.DataSource = leagueData2;


                    //Branch Statistics
                    BranchStatisticsTable.DataSource = branchStatisticsRaw.OrderBy(s => s.BranchName);
                    bulletGraphTable.DataSource = branchStatisticsRaw.OrderByDescending(s => s.ValueIn).Take(10);
                    bulletGraphTable.ColumnHeadersPrintOnEveryPage = true;
                    BranchStatisticsTable.ColumnHeadersPrintOnEveryPage = true;

                    //==================================================================================================================
                    /*
                     * GRAPH PLOTTING
                     * Plot appropriate graph based on requirements & the data populated from above
                     * Generic Graph Plotting can be found below this function
                     * You can create your own graph plotting function to cater specific scenarios
                    */

                    //Top Matric Data
                    TelerikUtility.PlotAreaGraph_NoAxes(module3Graph.ToString(), module3Graph, topMatricGraph, "=Fields.ValueDateTime", "=Fields.SalesConversion");
                    TelerikUtility.PlotAreaGraph_NoAxes(module6Graph.ToString(), module6Graph, topMatricGraph, "=Fields.LastWeekValueDateTime", "=Fields.LastWeekSalesConversion");
                    TelerikUtility.PlotAreaGraph_NoAxes(module8Graph.ToString(), module8Graph, topMatricGraph, "=Fields.ValueDateTime", "=Fields.ValueIn");
                    TelerikUtility.PlotAreaGraph_NoAxes(module4Graph.ToString(), module4Graph, topMatricGraph, "=Fields.ValueDateTime", "=Fields.OutsideTraffic");

                    //Weekly Trend
                    TelerikUtility.PlotBarLineGraph_2YAxisLabel(salesConversionWeeklyTrendGraph.ToString(), salesConversionWeeklyTrendGraph,
                        graphWeeklyDataSource, "=Fields.Week", "Week",
                        "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor,
                        "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion,
                        font, weeklyValueFormat, "{0:## ##0.##}%");
                    TelerikUtility.PlotBarGraph_Default(salesConversionWeeklyTrendGraph2.ToString(), salesConversionWeeklyTrendGraph2,
                        graphWeeklyDataSource, "=Fields.Week", "Week",
                        "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor,
                        font, weeklyValueFormat);
                    PlotLineLineGraph(salesConversionWeeklyTrendGraph3.ToString(), salesConversionWeeklyTrendGraph3,
                        graphWeeklyDataSource, "=Fields.Week", "Week",
                        "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor,
                        "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + "(%)",
                        font, weeklyValueFormat);

                    // Site Trend Analysis
                    PlotLineLineGraph(siteTrendAnalysisVisitorCountGraph.ToString(), siteTrendAnalysisVisitorCountGraph,
                        graphWeeklyDataSource52Weeks, "=Fields.Week", "Week",
                        "=Fields.ValueInDouble", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_NoofVisitor,
                        "=Fields.SalesConversion", CompanySalesConversionWeeklyReportViewer.CompanySalesConversionWeeklyReportViewer_SalesConversion + "(%)",
                        font, weeklyValueFormat52Weeks);
                    PlotStackedBarGraph(siteTrendAnalysisVisitDurationGraph.ToString(), siteTrendAnalysisVisitDurationGraph,
                        graphWeeklyVisitDurationDataSource52Weeks, "=Fields.Week", "Week",
                        "=Fields.LargerThan30mins", "=Fields.Between15Till30mins", "=Fields.LessThan15mins", "Visit Duration", "> 60 mins", "15 - 30 mins", "< 15 mins", font, "{0:## ##0}");

                    //Branch Statistics
                    TelerikUtility.PlotAreaGraph_NoAxes_HasDataSource(graphSevenDayTrend.ToString(), graphSevenDayTrend, "=Fields.Date", "=Fields.SalesConversion");

                    plotBulletGraph3Values(bulletGraph.ToString(), bulletGraph, null, "=Fields.Count", "=Fields.value1", "=Fields.value2", "=Fields.value3");
                }
                #endregion
            }
            catch (Exception ex)
            {
                ex.WriteExceptionLog("TelerikReport-" + this.GetType().Name, MyHelper.UserName, Report.Parameters);
            }
        }

        //=====================================================================================================================
        /*
         *  GRAPH PLOTTING TEMPLATE
         *      -> Methods below are CUSTOM functions for the Graph Plotting
         *      -> GENERIC Functions can be found in Helper\TelerikUtility.cs
         *      -> Consult for usage/modification of the functions
         *      
         */

        public Graph PlotLineLineGraph(string graphName, Graph reportGraph,
            IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisName, string yAxisGroup2, string yAxisName2, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            var categoryGroup = new GraphGroup();
            categoryGroup.Name = "categoryGroup";
            categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup = new GraphGroup();
            seriesGroup.Name = "seriesGroup";
            reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            var categoryGroup_X_Axis_1 = new GraphAxis();
            categoryGroup_X_Axis_1.Name = "X Axis";
            categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_1.Title = xAxisName;
            categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            //Setup another Graph Axis X with CategoryScale (X AXIS 2)
            var categoryGroup_X_Axis_2 = new GraphAxis();
            categoryGroup_X_Axis_2.Name = "X Axis 2";
            categoryGroup_X_Axis_2.Scale = new CategoryScale();
            categoryGroup_X_Axis_2.Style.Visible = false;
            categoryGroup_X_Axis_2.MajorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_2.MinorGridLineStyle.Visible = false;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            var numbericScale_Y_Axis_1 = new GraphAxis();
            numbericScale_Y_Axis_1.Name = "Y Axis";
            numbericScale_Y_Axis_1.Scale = new NumericalScale();
            numbericScale_Y_Axis_1.Title = yAxisName;
            numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numbericScale_Y_Axis_1.LabelFormat = format;

            //Setup 2nd Graph Axis with Numerical Scale (Y AXIS 2)
            var numbericScale_Y_Axis_2 = new GraphAxis();
            numbericScale_Y_Axis_2.Name = "Y Axis 2";
            numbericScale_Y_Axis_2.Scale = new NumericalScale();
            numbericScale_Y_Axis_2.Title = yAxisName2;
            numbericScale_Y_Axis_2.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            numbericScale_Y_Axis_2.MajorGridLineStyle.Visible = false;
            numbericScale_Y_Axis_2.MinorGridLineStyle.Visible = false;
            numbericScale_Y_Axis_2.Style.LineColor = Color.White;
            numbericScale_Y_Axis_2.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_2.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_1;
            cartesianCoordinateSystem.YAxis = numbericScale_Y_Axis_1;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //2nd Data
            var cartesianCoordinateSystem2 = new CartesianCoordinateSystem();
            cartesianCoordinateSystem2.Name = "cartesianCoordinateSystem6";
            cartesianCoordinateSystem2.XAxis = categoryGroup_X_Axis_2;
            //cartesianCoordinateSystem6.XAxis.Style.Font.Name = font;
            cartesianCoordinateSystem2.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMaximum;
            cartesianCoordinateSystem2.YAxis = numbericScale_Y_Axis_2;

            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem2);

            //The Line Series area
            //1st Data
            var lineSeries1 = new LineSeries();
            lineSeries1.CategoryGroup = categoryGroup;
            lineSeries1.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries1.LegendItem.Value = yAxisName;
            lineSeries1.SeriesGroup = seriesGroup;
            lineSeries1.Y = yAxisGroup;
            reportGraph.Series.Add(lineSeries1);
            lineSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);

            //The Line Series area
            //2nd Data
            var lineSeries2 = new LineSeries();
            lineSeries2.CategoryGroup = categoryGroup;
            lineSeries2.CoordinateSystem = cartesianCoordinateSystem2;
            lineSeries2.LegendItem.Value = yAxisName2;
            lineSeries2.SeriesGroup = seriesGroup;
            lineSeries2.Y = yAxisGroup2;
            lineSeries2.LineStyle.LineStyle = LineStyle.Dashed;
            lineSeries1.MarkerType = DataPointMarkerType.Circle;
            lineSeries1.MarkerSize = new Telerik.Reporting.Drawing.Unit(5);
            lineSeries1.DataPointStyle.BackgroundColor = Color.AliceBlue;
            lineSeries1.DataPointStyle.LineColor = Color.AliceBlue;
            lineSeries1.DataPointStyle.Visible = true;
            reportGraph.Series.Add(lineSeries2);
            lineSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);

            reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        public Graph PlotStackedBarGraph(string graphName, Graph reportGraph,
            IEnumerable<BranchSummaryDailyReportViewModel> graphDataSource,
            string categoryGraphGroup, string xAxisName, string yAxisGroup, string yAxisGroup2, string yAxisGroup3, string yAxisName, string yValueName, string yValueName2, string yValueName3, string font, string format)
        {
            reportGraph.Name = graphName;
            reportGraph.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(10);
            reportGraph.Style.Font.Bold = false;
            reportGraph.Style.Font.Name = font;

            //Bind Data to DataSource
            reportGraph.DataSource = graphDataSource;

            //Create the category group
            var categoryGroup = new GraphGroup();
            categoryGroup.Name = "categoryGroup";
            categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup = new GraphGroup();
            seriesGroup.Name = "seriesGroup";
            reportGraph.SeriesGroups.Add(seriesGroup);


            //Setup Graph Axis X with CategoryScale (X AXIS)
            var categoryGroup_X_Axis_1 = new GraphAxis();
            categoryGroup_X_Axis_1.Name = "X Axis";
            categoryGroup_X_Axis_1.Scale = new CategoryScale();
            categoryGroup_X_Axis_1.Title = xAxisName;
            categoryGroup_X_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);     //Custom Font Size for specific element of the graph
            categoryGroup_X_Axis_1.TitlePlacement = GraphAxisTitlePlacement.AtMaximum;
            categoryGroup_X_Axis_1.MajorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.MinorGridLineStyle.Visible = false;
            categoryGroup_X_Axis_1.Style.LineColor = Color.White;
            categoryGroup_X_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            categoryGroup_X_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;

            //Setup Graph Axis with Numerical Scale (Y AXIS)
            var numbericScale_Y_Axis_1 = new GraphAxis();
            numbericScale_Y_Axis_1.Name = "Y Axis";
            numbericScale_Y_Axis_1.Scale = new NumericalScale();
            numbericScale_Y_Axis_1.Title = yAxisName;
            numbericScale_Y_Axis_1.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(9);
            numbericScale_Y_Axis_1.MajorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.MinorTickMarkDisplayType = GraphAxisTickMarkDisplayType.None;
            numbericScale_Y_Axis_1.Style.LineColor = Color.White;
            numbericScale_Y_Axis_1.LabelFormat = format;


            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            //1st Data
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystem";
            cartesianCoordinateSystem.XAxis = categoryGroup_X_Axis_1;
            cartesianCoordinateSystem.YAxis = numbericScale_Y_Axis_1;
            cartesianCoordinateSystem.XAxis.Scale.CrossAxisPosition = GraphScaleCrossAxisPosition.AtMinimum;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);
            cartesianCoordinateSystem.XAxis.LabelAngle = 270;

            //The Bar Series area
            //1st Data
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = categoryGroup;
            barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Value = yValueName;
            barSeries1.SeriesGroup = seriesGroup;
            barSeries1.Y = yAxisGroup;
            barSeries1.ColorPalette = new ColorPalette(Color.DarkGreen);
            barSeries1.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            reportGraph.Series.Add(barSeries1);

            //The Bar Series area
            //2nd Data
            var barSeries2 = new BarSeries();
            barSeries2.CategoryGroup = categoryGroup;
            barSeries2.CoordinateSystem = cartesianCoordinateSystem;
            barSeries2.LegendItem.Value = yValueName2;
            barSeries2.SeriesGroup = seriesGroup;
            barSeries2.Y = yAxisGroup2;
            barSeries2.ColorPalette = new ColorPalette(Color.DarkBlue);
            barSeries2.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            reportGraph.Series.Add(barSeries2);

            //The Bar Series area
            //3nd Data
            var barSeries3 = new BarSeries();
            barSeries3.CategoryGroup = categoryGroup;
            barSeries3.CoordinateSystem = cartesianCoordinateSystem;
            barSeries3.LegendItem.Value = yValueName3;
            barSeries3.SeriesGroup = seriesGroup;
            barSeries3.Y = yAxisGroup3;
            barSeries3.ColorPalette = new ColorPalette(Color.Red);
            barSeries3.ArrangeMode = GraphSeriesArrangeMode.Stacked;
            reportGraph.Series.Add(barSeries3);

            reportGraph.Legend.Position = GraphItemPosition.TopCenter;
            reportGraph.Legend.Style.Font.Size = new Telerik.Reporting.Drawing.Unit(8);

            return reportGraph;
        }

        public Graph plotBulletGraph3Values(string graphName, Graph reportGraph, List<BranchSummaryDailyReportViewModel> graphDataSource, string categoryGraphGroup, string yAxisGroup, string yAxisGroup2, string yAxisGroup3)
        {
            //Data plotting - Traffic Profile Weekday
            reportGraph.Name = graphName;

            //Setup the SqlDataSource
            if (graphDataSource != null)
            {
                reportGraph.DataSource = graphDataSource;
            }

            //Create the category group
            var categoryGroup = new GraphGroup();
            categoryGroup.Name = "categoryGroup";
            categoryGroup.Groupings.Add(new Grouping(categoryGraphGroup));
            reportGraph.CategoryGroups.Add(categoryGroup);

            //The SeriesGroups hierarchy defines the series at runtime
            var seriesGroup = new GraphGroup();
            seriesGroup.Name = "seriesGroup";
            reportGraph.SeriesGroups.Add(seriesGroup);

            //Setup Graph Axis with CategoryScale
            var graphAxisCategoryScale = new GraphAxis();
            graphAxisCategoryScale.Name = "Y Axis";
            graphAxisCategoryScale.Scale = new CategoryScale();
            graphAxisCategoryScale.Style.Visible = false;
            graphAxisCategoryScale.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale.Scale.SpacingSlotCount = 5;

            var graphAxisCategoryScale2 = new GraphAxis();
            graphAxisCategoryScale2.Name = "Y Axis 2";
            graphAxisCategoryScale2.Scale = new CategoryScale();
            graphAxisCategoryScale2.Style.Visible = false;
            graphAxisCategoryScale2.MajorGridLineStyle.Visible = false;
            graphAxisCategoryScale2.MinorGridLineStyle.Visible = false;
            graphAxisCategoryScale2.Scale.SpacingSlotCount = 0;

            var customNumericalScale = new NumericalScale();
            customNumericalScale.Minimum = 0;

            //Setup Graph Axis with Numerical Scale
            var graphAxisNumericalScale = new GraphAxis();
            graphAxisNumericalScale.Name = "X Axis";
            graphAxisNumericalScale.Scale = customNumericalScale;
            graphAxisNumericalScale.Style.Visible = false;
            graphAxisNumericalScale.MajorGridLineStyle.Visible = false;
            graphAxisNumericalScale.MinorGridLineStyle.Visible = false;

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem = new CartesianCoordinateSystem();
            cartesianCoordinateSystem.Name = "cartesianCoordinateSystemOverview";
            cartesianCoordinateSystem.XAxis = graphAxisNumericalScale;
            cartesianCoordinateSystem.YAxis = graphAxisCategoryScale;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem);

            //The Graph item uses a two-dimensional coordinate system that uniquely identfies the position of each data point
            var cartesianCoordinateSystem2 = new CartesianCoordinateSystem();
            cartesianCoordinateSystem2.Name = "cartesianCoordinateSystemOverview";
            cartesianCoordinateSystem2.XAxis = graphAxisNumericalScale;
            cartesianCoordinateSystem2.YAxis = graphAxisCategoryScale2;
            reportGraph.CoordinateSystems.Add(cartesianCoordinateSystem2);


            //The Graph Series area
            var barSeries1 = new BarSeries();
            barSeries1.CategoryGroup = categoryGroup;
            barSeries1.ArrangeMode = GraphSeriesArrangeMode.Overlapped;
            barSeries1.DataPointStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(0);
            barSeries1.DataPointStyle.Visible = true;
            barSeries1.CoordinateSystem = cartesianCoordinateSystem;
            barSeries1.LegendItem.Style.Visible = false;
            barSeries1.SeriesGroup = seriesGroup;
            barSeries1.X = yAxisGroup;
            reportGraph.Series.Add(barSeries1);
            barSeries1.ColorPalette = new ColorPalette(new string[] { "0x00,0x00,0x00" });

            //The Graph Series area
            var barSeries2 = new BarSeries();
            barSeries2.CategoryGroup = categoryGroup;
            barSeries2.ArrangeMode = GraphSeriesArrangeMode.Overlapped;
            barSeries2.CoordinateSystem = cartesianCoordinateSystem2;
            barSeries2.DataPointStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(0);
            barSeries2.LegendItem.Style.Visible = false;
            barSeries2.SeriesGroup = seriesGroup;
            barSeries2.X = yAxisGroup2;
            reportGraph.Series.Add(barSeries2);
            barSeries2.ColorPalette = new ColorPalette(new string[] { "0x5A,0x88,0xd9,0xc9" });

            //The Graph Series area
            var lineSeries3 = new LineSeries();
            lineSeries3.CategoryGroup = categoryGroup;
            //lineSeries3.DataPointStyle.Visible = true;
            //lineSeries3.DataPointStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(1);
            lineSeries3.ArrangeMode = GraphSeriesArrangeMode.Overlapped;
            //lineSeries3.MarkerType = DataPointMarkerType.Circle;
            //lineSeries3.MarkerSize = new Telerik.Reporting.Drawing.Unit(15);
            //lineSeries3.DataPointStyle.Visible = true;
            lineSeries3.LineType = LineSeries.LineTypes.Stepped;
            lineSeries3.LineStyle.LineWidth = new Telerik.Reporting.Drawing.Unit(1);
            lineSeries3.CoordinateSystem = cartesianCoordinateSystem;
            lineSeries3.LegendItem.Style.Visible = false;
            lineSeries3.SeriesGroup = seriesGroup;
            lineSeries3.X = yAxisGroup3;
            reportGraph.Series.Add(lineSeries3);
            lineSeries3.ColorPalette = new ColorPalette(new string[] { "0x00,0x00,0x00" });

            return reportGraph;
        }


        public FinancialYearVM GetFinancialWeekList(DateTime passedDateTime, CompanySetting companySetting)
        {
            //temporary
            //passedDateTime = new DateTime(2013, 7, 18);

            var fvm = new FinancialYearVM();
            string[] financialWeek = { "1", "1" };
            DayOfWeek firstDayOfWeek = new DayOfWeek();
            if (companySetting.FinancialWeekDate != null)
                financialWeek = new string[] { companySetting.FinancialWeekDate };
            firstDayOfWeek = companySetting.FirstDayOfWeek == "Sunday"
                ? DayOfWeek.Sunday
                : companySetting.FirstDayOfWeek == "Saturday"
                    ? DayOfWeek.Saturday
                    : companySetting.FirstDayOfWeek == "Friday"
                        ? DayOfWeek.Friday
                        : DayOfWeek.Monday;

            DateTime startd = passedDateTime;
            DateTime thisYearCompanyFinancialWeekStart = new DateTime();
            DateTime thisYearCompanyFinancialWeekEnd = new DateTime();

            DateTime lastYearCompanyFinancialWeekStart = new DateTime();
            DateTime lastYearCompanyFinancialWeekEnd = new DateTime(1);

            //default financial date
            DateTime setCompanyFinancialStartDate = companySetting.DateFormat == "dateFirst"
                ? DateTime.ParseExact(companySetting.FinancialWeekDate, "dd/MM/yyyy", CultureInfo.InvariantCulture)
                : DateTime.ParseExact(companySetting.FinancialWeekDate, "MM/dd/yyyy", CultureInfo.InvariantCulture);
            DateTime setCompanyFinancialEndDate =
                Utility.GetFinancialYearEndDate(setCompanyFinancialStartDate, firstDayOfWeek);

            thisYearCompanyFinancialWeekStart = setCompanyFinancialEndDate.AddDays(1);
            thisYearCompanyFinancialWeekEnd =
                Utility.GetFinancialYearEndDate(thisYearCompanyFinancialWeekStart, firstDayOfWeek);

            lastYearCompanyFinancialWeekStart = setCompanyFinancialStartDate;
            lastYearCompanyFinancialWeekEnd = setCompanyFinancialEndDate;

            var tmpLastYear = new FinancialStartEnd();
            tmpLastYear.FinancialStartDate = lastYearCompanyFinancialWeekStart;
            tmpLastYear.FinancialEndDate = lastYearCompanyFinancialWeekEnd;

            var tmpThisYear = new FinancialStartEnd();
            tmpThisYear.FinancialStartDate = thisYearCompanyFinancialWeekStart;
            tmpThisYear.FinancialEndDate = thisYearCompanyFinancialWeekEnd;

            fvm.LastYear = tmpLastYear;
            fvm.ThisYear = tmpThisYear;
            //default financial date


            //do checking to see if passedDate is inside the range of this year financial period
            if (passedDateTime >= fvm.ThisYear.FinancialStartDate && passedDateTime <= fvm.ThisYear.FinancialEndDate)
            {

            }
            //if false
            else
            {
                //calculate the difference of the passedDate with fvm this year startDate
                //fiscal year smaller than default one
                Double differenceInYear = new Double();
                if (passedDateTime < thisYearCompanyFinancialWeekStart)
                {
                    differenceInYear =
                        (double)(Convert.ToDecimal((thisYearCompanyFinancialWeekStart - passedDateTime).TotalDays) /
                                 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekStart;
                    DateTime tmpThisEnd = new DateTime();
                    for (var i = 0.0; i < differenceInYear; i++)
                    {
                        tmpThisEnd = tmpThisStart.AddDays(-1);
                        tmpThisStart = tmpThisEnd.AddMonths(-12).AddDays(1);

                        var tmpDtDayOfWeek = (int)tmpThisStart.DayOfWeek == 0 ? 0 : (int)tmpThisStart.DayOfWeek;
                        var tmpFirstDayOfWeek = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                        int dif = tmpFirstDayOfWeek - tmpDtDayOfWeek;

                        tmpThisStart = tmpThisStart.AddDays(dif);
                        if (dif < 0)
                            dif = dif * -1;
                        if (dif >= 4)
                        {
                            tmpThisStart = tmpThisStart.AddDays(-7);
                        }
                    }
                    //tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);


                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12).AddDays(1);

                    var tmpDtDayOfWeek2 = (int)tmpLastStart.DayOfWeek == 0 ? 0 : (int)tmpLastStart.DayOfWeek;
                    var tmpFirstDayOfWeek2 = firstDayOfWeek == DayOfWeek.Sunday ? 7 : (int)firstDayOfWeek;
                    int dif2 = tmpFirstDayOfWeek2 - tmpDtDayOfWeek2;

                    tmpLastStart = tmpLastStart.AddDays(dif2);
                    if (dif2 < 0)
                        dif2 = dif2 * -1;
                    if (dif2 >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(-7);
                    }
                    //int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    //tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);

                    //if ((int)firstDayOfWeek >= 4 && (int)firstDayOfWeek != 7)
                    //{
                    //    tmpLastStart = tmpLastStart.AddDays(-7);
                    //}

                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }

                //fiscal year greater than default one
                else if (passedDateTime > thisYearCompanyFinancialWeekEnd)
                {
                    differenceInYear =
                        (double)(Convert.ToDecimal((passedDateTime - thisYearCompanyFinancialWeekStart).TotalDays) /
                                 365.25m);
                    DateTime tmpLastStart = new DateTime();
                    DateTime tmpLastEnd = new DateTime();
                    DateTime tmpThisStart = thisYearCompanyFinancialWeekEnd.AddDays(1);
                    DateTime tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                    for (var i = 0.0; i < differenceInYear - 1; i++)
                    {
                        if (i > 0)
                        {
                            tmpThisStart = tmpThisEnd.AddDays(1);
                            tmpThisEnd = Utility.GetFinancialYearEndDate(tmpThisStart, firstDayOfWeek);
                        }
                    }

                    tmpLastEnd = tmpThisStart.AddDays(-1);
                    tmpLastStart = tmpLastEnd.AddMonths(-12);
                    int pushLastWeekStartToFirstDay = (int)firstDayOfWeek - (int)tmpLastStart.DayOfWeek;
                    tmpLastStart = tmpLastStart.AddDays(pushLastWeekStartToFirstDay);
                    if ((pushLastWeekStartToFirstDay * -1) >= 4)
                    {
                        tmpLastStart = tmpLastStart.AddDays(7);
                    }


                    tmpLastYear.FinancialStartDate = tmpLastStart;
                    tmpLastYear.FinancialEndDate = tmpLastEnd;

                    tmpThisYear.FinancialStartDate = tmpThisStart;
                    tmpThisYear.FinancialEndDate = tmpThisEnd;

                    fvm.LastYear = tmpLastYear;
                    fvm.ThisYear = tmpThisYear;

                    return fvm;
                }
            }
            return fvm;
        }

        public static string CheckDay(DateTime valueDateTime)
        {
            DayOfWeek dow = valueDateTime.DayOfWeek;
            return dow.ToString();
        }

        public static string CheckSalesConversionOverview(double salesConversion)
        {
            if (salesConversion == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
            }
            else
            {
                return Math.Abs(Math.Round(salesConversion, 2)) + "%";
            }
        }

        public static string CheckSalesConversion(double salesConversion)
        {
            if (salesConversion == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
            }
            else
            {
                return Math.Abs(Math.Round(salesConversion, 2)).ToString();
            }
        }

        public static string CheckTransactionCount(int transactionCount)
        {
            string format = "{0:N0}";

            if (transactionCount == 0)
            {
                return string.Format("{0:0;-0;-\"\"}", transactionCount);
            }
            else
            {
                return string.Format(format, transactionCount);
            }
        }

        public static string CheckBestPerformDay(double salesConversion, string bestPerformDay)
        {
            if (salesConversion == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
            }
            else
            {
                return bestPerformDay;
            }
        }

        public static string CheckRanking(double salesConversion, int Rank)
        {
            if (salesConversion == 0)
            {
                return string.Format("{0:0.00;-0;-\"\"}", salesConversion);
            }
            else
            {
                return Rank.ToString();
            }
        }

        public static System.Drawing.Image GetDiffImage(double salesConversion)
        {
            if (salesConversion > 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-green.png"));
            }
            else if (salesConversion < 0)
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/arrow-red.png"));
            }
            else
            {
                return System.Drawing.Image.FromFile(HttpContext.Current.Server.MapPath("~/Content/Images/WhiteArrow.jpg"));
            }
        }

        public static DataSource sevenDayTrend(string branchCode)
        {
            var objectDataSource1 = new Telerik.Reporting.ObjectDataSource();

            try
            {
                var result = sevenDayTrendData.Where(w => w.BranchCode == branchCode).Select(
                    s => new BranchSummaryDailyReportViewModel
                    {
                        Date = s.Date,
                        SalesConversion = s.SalesConversion,
                        BranchCode = s.BranchCode
                    });

                objectDataSource1.DataSource = result;

                return objectDataSource1;
            }
            catch
            {
                return objectDataSource1;
            }

        }

        public static DataSource bulletGraphDataSource(string branchCode)
        {
            var objectDataSource1 = new Telerik.Reporting.ObjectDataSource();

            try
            {
                var data = sevenDayTrendData.Where(w => w.BranchCode == branchCode).Select(
                    s => new BranchSummaryDailyReportViewModel
                    {
                        Date = s.Date,
                        ValueIn = s.ValueIn,
                        ValueOut = s.ValueOut,
                        SalesTarget = s.SalesTarget,
                        BranchCode = s.BranchCode
                    });

                var result = new BulletGraphViewModel
                {
                    Count = 1,
                    value1 = data.Sum(s => s.ValueIn),
                    value2 = data.Sum(s => s.ValueOut),
                    value3 = data.Sum(s => s.SalesTarget)
                };
                objectDataSource1.DataSource = result;
                return objectDataSource1;
            }
            catch
            {
                return objectDataSource1;
            }
        }

        public static long SumData(string branchCode, int mode)
        {
            var data = sevenDayTrendData.Where(w => w.BranchCode == branchCode).Select(
                    s => new BranchSummaryDailyReportViewModel
                    {
                        Date = s.Date,
                        ValueIn = s.ValueIn,
                        ValueOut = s.ValueOut,
                        SalesTarget = s.SalesTarget,
                        BranchCode = s.BranchCode
                    });
            switch (mode)
            {
                case 1:
                    return data.Sum(s => s.ValueIn);
                case 2:
                    return data.Sum(s => s.ValueOut);
                case 3:
                    return data.Sum(s => s.SalesTarget);
            }
            return 0;
        }

        public static long CheckValueDenominator(long minValue, long maxValue)
        {
            if (maxValue >= 30000000 || minValue >= 1000000)
                return 10000000;
            else if (maxValue >= 3000 || minValue >= 1000)
                return 1000;
            return 1;
        }

        public DateTime getFirstDayOf52Weeks(DayOfWeek firstDayOfWeek)
        {
            DateTime startDate;
            DateTime lastWeekDate = DateTime.Today.AddDays(-7);
            DayOfWeek lastWeekDayOfWeek = lastWeekDate.DayOfWeek;

            while(lastWeekDayOfWeek != firstDayOfWeek)
            {
                lastWeekDate = lastWeekDate.AddDays(-1);
                lastWeekDayOfWeek = lastWeekDate.DayOfWeek;
            }

            startDate = lastWeekDate.AddDays(-364);

            return startDate;
        }
    }
}


public class BulletGraphViewModel
{
    public int Count { get; set; }
    public long value1 { get; set; }
    public long value2 { get; set; }
    public long value3 { get; set; }
}