/*eslint-disable block-scoped-var, no-redeclare, no-control-regex, no-prototype-builtins*/
"use strict";

// Note: This file was manually edited to use "string" instead of "Long" for
// types that can potentially hold large integer values (> 2^53).

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.google = (function() {

  /**
   * Namespace google.
   * @exports google
   * @namespace
   */
  var google = {};

  google.firestore = (function() {

    /**
     * Namespace firestore.
     * @memberof google
     * @namespace
     */
    var firestore = {};

    firestore.v1beta1 = (function() {

      /**
       * Namespace v1beta1.
       * @memberof google.firestore
       * @namespace
       */
      var v1beta1 = {};

      v1beta1.Firestore = (function() {

        /**
         * Constructs a new Firestore service.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Firestore
         * @extends $protobuf.rpc.Service
         * @constructor
         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
         */
        function Firestore(rpcImpl, requestDelimited, responseDelimited) {
          $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
        }

        (Firestore.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Firestore;

        /**
         * Creates new Firestore service using the specified rpc implementation.
         * @function create
         * @memberof google.firestore.v1beta1.Firestore
         * @static
         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
         * @returns {Firestore} RPC service. Useful where requests and/or responses are streamed.
         */
        Firestore.create = function create(rpcImpl, requestDelimited, responseDelimited) {
          return new this(rpcImpl, requestDelimited, responseDelimited);
        };

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#getDocument}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef GetDocumentCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.Document} [response] Document
         */

        /**
         * Calls GetDocument.
         * @function getDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IGetDocumentRequest} request GetDocumentRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.GetDocumentCallback} callback Node-style callback called with the error, if any, and Document
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.getDocument = function getDocument(request, callback) {
          return this.rpcCall(getDocument, $root.google.firestore.v1beta1.GetDocumentRequest, $root.google.firestore.v1beta1.Document, request, callback);
        };

        /**
         * Calls GetDocument.
         * @function getDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IGetDocumentRequest} request GetDocumentRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.Document>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#listDocuments}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef ListDocumentsCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.ListDocumentsResponse} [response] ListDocumentsResponse
         */

        /**
         * Calls ListDocuments.
         * @function listDocuments
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListDocumentsRequest} request ListDocumentsRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.ListDocumentsCallback} callback Node-style callback called with the error, if any, and ListDocumentsResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.listDocuments = function listDocuments(request, callback) {
          return this.rpcCall(listDocuments, $root.google.firestore.v1beta1.ListDocumentsRequest, $root.google.firestore.v1beta1.ListDocumentsResponse, request, callback);
        };

        /**
         * Calls ListDocuments.
         * @function listDocuments
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListDocumentsRequest} request ListDocumentsRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.ListDocumentsResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#createDocument}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef CreateDocumentCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.Document} [response] Document
         */

        /**
         * Calls CreateDocument.
         * @function createDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.ICreateDocumentRequest} request CreateDocumentRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.CreateDocumentCallback} callback Node-style callback called with the error, if any, and Document
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.createDocument = function createDocument(request, callback) {
          return this.rpcCall(createDocument, $root.google.firestore.v1beta1.CreateDocumentRequest, $root.google.firestore.v1beta1.Document, request, callback);
        };

        /**
         * Calls CreateDocument.
         * @function createDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.ICreateDocumentRequest} request CreateDocumentRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.Document>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#updateDocument}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef UpdateDocumentCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.Document} [response] Document
         */

        /**
         * Calls UpdateDocument.
         * @function updateDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest} request UpdateDocumentRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.UpdateDocumentCallback} callback Node-style callback called with the error, if any, and Document
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.updateDocument = function updateDocument(request, callback) {
          return this.rpcCall(updateDocument, $root.google.firestore.v1beta1.UpdateDocumentRequest, $root.google.firestore.v1beta1.Document, request, callback);
        };

        /**
         * Calls UpdateDocument.
         * @function updateDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest} request UpdateDocumentRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.Document>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#deleteDocument}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef DeleteDocumentCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.protobuf.Empty} [response] Empty
         */

        /**
         * Calls DeleteDocument.
         * @function deleteDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest} request DeleteDocumentRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.DeleteDocumentCallback} callback Node-style callback called with the error, if any, and Empty
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.deleteDocument = function deleteDocument(request, callback) {
          return this.rpcCall(deleteDocument, $root.google.firestore.v1beta1.DeleteDocumentRequest, $root.google.protobuf.Empty, request, callback);
        };

        /**
         * Calls DeleteDocument.
         * @function deleteDocument
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest} request DeleteDocumentRequest message or plain object
         * @returns {Promise<google.protobuf.Empty>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#batchGetDocuments}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef BatchGetDocumentsCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.BatchGetDocumentsResponse} [response] BatchGetDocumentsResponse
         */

        /**
         * Calls BatchGetDocuments.
         * @function batchGetDocuments
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest} request BatchGetDocumentsRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.BatchGetDocumentsCallback} callback Node-style callback called with the error, if any, and BatchGetDocumentsResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.batchGetDocuments = function batchGetDocuments(request, callback) {
          return this.rpcCall(batchGetDocuments, $root.google.firestore.v1beta1.BatchGetDocumentsRequest, $root.google.firestore.v1beta1.BatchGetDocumentsResponse, request, callback);
        };

        /**
         * Calls BatchGetDocuments.
         * @function batchGetDocuments
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest} request BatchGetDocumentsRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.BatchGetDocumentsResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#beginTransaction}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef BeginTransactionCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.BeginTransactionResponse} [response] BeginTransactionResponse
         */

        /**
         * Calls BeginTransaction.
         * @function beginTransaction
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IBeginTransactionRequest} request BeginTransactionRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.BeginTransactionCallback} callback Node-style callback called with the error, if any, and BeginTransactionResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.beginTransaction = function beginTransaction(request, callback) {
          return this.rpcCall(beginTransaction, $root.google.firestore.v1beta1.BeginTransactionRequest, $root.google.firestore.v1beta1.BeginTransactionResponse, request, callback);
        };

        /**
         * Calls BeginTransaction.
         * @function beginTransaction
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IBeginTransactionRequest} request BeginTransactionRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.BeginTransactionResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#commit}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef CommitCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.CommitResponse} [response] CommitResponse
         */

        /**
         * Calls Commit.
         * @function commit
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.ICommitRequest} request CommitRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.CommitCallback} callback Node-style callback called with the error, if any, and CommitResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.commit = function commit(request, callback) {
          return this.rpcCall(commit, $root.google.firestore.v1beta1.CommitRequest, $root.google.firestore.v1beta1.CommitResponse, request, callback);
        };

        /**
         * Calls Commit.
         * @function commit
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.ICommitRequest} request CommitRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.CommitResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#rollback}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef RollbackCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.protobuf.Empty} [response] Empty
         */

        /**
         * Calls Rollback.
         * @function rollback
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IRollbackRequest} request RollbackRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.RollbackCallback} callback Node-style callback called with the error, if any, and Empty
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.rollback = function rollback(request, callback) {
          return this.rpcCall(rollback, $root.google.firestore.v1beta1.RollbackRequest, $root.google.protobuf.Empty, request, callback);
        };

        /**
         * Calls Rollback.
         * @function rollback
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IRollbackRequest} request RollbackRequest message or plain object
         * @returns {Promise<google.protobuf.Empty>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#runQuery}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef RunQueryCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.RunQueryResponse} [response] RunQueryResponse
         */

        /**
         * Calls RunQuery.
         * @function runQuery
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IRunQueryRequest} request RunQueryRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.RunQueryCallback} callback Node-style callback called with the error, if any, and RunQueryResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.runQuery = function runQuery(request, callback) {
          return this.rpcCall(runQuery, $root.google.firestore.v1beta1.RunQueryRequest, $root.google.firestore.v1beta1.RunQueryResponse, request, callback);
        };

        /**
         * Calls RunQuery.
         * @function runQuery
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IRunQueryRequest} request RunQueryRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.RunQueryResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#write}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef WriteCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.WriteResponse} [response] WriteResponse
         */

        /**
         * Calls Write.
         * @function write
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IWriteRequest} request WriteRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.WriteCallback} callback Node-style callback called with the error, if any, and WriteResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.write = function write(request, callback) {
          return this.rpcCall(write, $root.google.firestore.v1beta1.WriteRequest, $root.google.firestore.v1beta1.WriteResponse, request, callback);
        };

        /**
         * Calls Write.
         * @function write
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IWriteRequest} request WriteRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.WriteResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#listen}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef ListenCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.ListenResponse} [response] ListenResponse
         */

        /**
         * Calls Listen.
         * @function listen
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListenRequest} request ListenRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.ListenCallback} callback Node-style callback called with the error, if any, and ListenResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.listen = function listen(request, callback) {
          return this.rpcCall(listen, $root.google.firestore.v1beta1.ListenRequest, $root.google.firestore.v1beta1.ListenResponse, request, callback);
        };

        /**
         * Calls Listen.
         * @function listen
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListenRequest} request ListenRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.ListenResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link google.firestore.v1beta1.Firestore#listCollectionIds}.
         * @memberof google.firestore.v1beta1.Firestore
         * @typedef ListCollectionIdsCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {google.firestore.v1beta1.ListCollectionIdsResponse} [response] ListCollectionIdsResponse
         */

        /**
         * Calls ListCollectionIds.
         * @function listCollectionIds
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest} request ListCollectionIdsRequest message or plain object
         * @param {google.firestore.v1beta1.Firestore.ListCollectionIdsCallback} callback Node-style callback called with the error, if any, and ListCollectionIdsResponse
         * @returns {undefined}
         * @variation 1
         */
        Firestore.prototype.listCollectionIds = function listCollectionIds(request, callback) {
          return this.rpcCall(listCollectionIds, $root.google.firestore.v1beta1.ListCollectionIdsRequest, $root.google.firestore.v1beta1.ListCollectionIdsResponse, request, callback);
        };

        /**
         * Calls ListCollectionIds.
         * @function listCollectionIds
         * @memberof google.firestore.v1beta1.Firestore
         * @instance
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest} request ListCollectionIdsRequest message or plain object
         * @returns {Promise<google.firestore.v1beta1.ListCollectionIdsResponse>} Promise
         * @variation 2
         */

        return Firestore;
      })();

      v1beta1.GetDocumentRequest = (function() {

        /**
         * Properties of a GetDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @interface IGetDocumentRequest
         * @property {string|null} [name] GetDocumentRequest name
         * @property {google.firestore.v1beta1.IDocumentMask|null} [mask] GetDocumentRequest mask
         * @property {Uint8Array|null} [transaction] GetDocumentRequest transaction
         * @property {google.protobuf.ITimestamp|null} [readTime] GetDocumentRequest readTime
         */

        /**
         * Constructs a new GetDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a GetDocumentRequest.
         * @implements IGetDocumentRequest
         * @constructor
         * @param {google.firestore.v1beta1.IGetDocumentRequest=} [properties] Properties to set
         */
        function GetDocumentRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * GetDocumentRequest name.
         * @member {string} name
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         */
        GetDocumentRequest.prototype.name = "";

        /**
         * GetDocumentRequest mask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} mask
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         */
        GetDocumentRequest.prototype.mask = null;

        /**
         * GetDocumentRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         */
        GetDocumentRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * GetDocumentRequest readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         */
        GetDocumentRequest.prototype.readTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * GetDocumentRequest consistencySelector.
         * @member {"transaction"|"readTime"|undefined} consistencySelector
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         */
        Object.defineProperty(GetDocumentRequest.prototype, "consistencySelector", {
          get: $util.oneOfGetter($oneOfFields = ["transaction", "readTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new GetDocumentRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IGetDocumentRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.GetDocumentRequest} GetDocumentRequest instance
         */
        GetDocumentRequest.create = function create(properties) {
          return new GetDocumentRequest(properties);
        };

        /**
         * Encodes the specified GetDocumentRequest message. Does not implicitly {@link google.firestore.v1beta1.GetDocumentRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IGetDocumentRequest} message GetDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GetDocumentRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.name != null && message.hasOwnProperty("name"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
          if (message.mask != null && message.hasOwnProperty("mask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.mask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.transaction);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified GetDocumentRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.GetDocumentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IGetDocumentRequest} message GetDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GetDocumentRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GetDocumentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.GetDocumentRequest} GetDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GetDocumentRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.GetDocumentRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.name = reader.string();
                break;
              case 2:
                message.mask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 3:
                message.transaction = reader.bytes();
                break;
              case 5:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a GetDocumentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.GetDocumentRequest} GetDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GetDocumentRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GetDocumentRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GetDocumentRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.name != null && message.hasOwnProperty("name"))
            if (!$util.isString(message.name))
              return "name: string expected";
          if (message.mask != null && message.hasOwnProperty("mask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.mask);
            if (error)
              return "mask." + error;
          }
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            properties.consistencySelector = 1;
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.readTime);
              if (error)
                return "readTime." + error;
            }
          }
          return null;
        };

        /**
         * Creates a GetDocumentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.GetDocumentRequest} GetDocumentRequest
         */
        GetDocumentRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.GetDocumentRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.GetDocumentRequest();
          if (object.name != null)
            message.name = String(object.name);
          if (object.mask != null) {
            if (typeof object.mask !== "object")
              throw TypeError(".google.firestore.v1beta1.GetDocumentRequest.mask: object expected");
            message.mask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.mask);
          }
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.GetDocumentRequest.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a GetDocumentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.GetDocumentRequest} message GetDocumentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GetDocumentRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.name = "";
            object.mask = null;
          }
          if (message.name != null && message.hasOwnProperty("name"))
            object.name = message.name;
          if (message.mask != null && message.hasOwnProperty("mask"))
            object.mask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.mask, options);
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
            if (options.oneofs)
              object.consistencySelector = "transaction";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
            if (options.oneofs)
              object.consistencySelector = "readTime";
          }
          return object;
        };

        /**
         * Converts this GetDocumentRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.GetDocumentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GetDocumentRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GetDocumentRequest;
      })();

      v1beta1.ListDocumentsRequest = (function() {

        /**
         * Properties of a ListDocumentsRequest.
         * @memberof google.firestore.v1beta1
         * @interface IListDocumentsRequest
         * @property {string|null} [parent] ListDocumentsRequest parent
         * @property {string|null} [collectionId] ListDocumentsRequest collectionId
         * @property {number|null} [pageSize] ListDocumentsRequest pageSize
         * @property {string|null} [pageToken] ListDocumentsRequest pageToken
         * @property {string|null} [orderBy] ListDocumentsRequest orderBy
         * @property {google.firestore.v1beta1.IDocumentMask|null} [mask] ListDocumentsRequest mask
         * @property {Uint8Array|null} [transaction] ListDocumentsRequest transaction
         * @property {google.protobuf.ITimestamp|null} [readTime] ListDocumentsRequest readTime
         * @property {boolean|null} [showMissing] ListDocumentsRequest showMissing
         */

        /**
         * Constructs a new ListDocumentsRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListDocumentsRequest.
         * @implements IListDocumentsRequest
         * @constructor
         * @param {google.firestore.v1beta1.IListDocumentsRequest=} [properties] Properties to set
         */
        function ListDocumentsRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListDocumentsRequest parent.
         * @member {string} parent
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.parent = "";

        /**
         * ListDocumentsRequest collectionId.
         * @member {string} collectionId
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.collectionId = "";

        /**
         * ListDocumentsRequest pageSize.
         * @member {number} pageSize
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.pageSize = 0;

        /**
         * ListDocumentsRequest pageToken.
         * @member {string} pageToken
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.pageToken = "";

        /**
         * ListDocumentsRequest orderBy.
         * @member {string} orderBy
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.orderBy = "";

        /**
         * ListDocumentsRequest mask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} mask
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.mask = null;

        /**
         * ListDocumentsRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * ListDocumentsRequest readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.readTime = null;

        /**
         * ListDocumentsRequest showMissing.
         * @member {boolean} showMissing
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        ListDocumentsRequest.prototype.showMissing = false;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ListDocumentsRequest consistencySelector.
         * @member {"transaction"|"readTime"|undefined} consistencySelector
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         */
        Object.defineProperty(ListDocumentsRequest.prototype, "consistencySelector", {
          get: $util.oneOfGetter($oneOfFields = ["transaction", "readTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ListDocumentsRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListDocumentsRequest} ListDocumentsRequest instance
         */
        ListDocumentsRequest.create = function create(properties) {
          return new ListDocumentsRequest(properties);
        };

        /**
         * Encodes the specified ListDocumentsRequest message. Does not implicitly {@link google.firestore.v1beta1.ListDocumentsRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsRequest} message ListDocumentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListDocumentsRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.parent != null && message.hasOwnProperty("parent"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.collectionId);
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            writer.uint32(/* id 4, wireType 2 =*/34).string(message.pageToken);
          if (message.orderBy != null && message.hasOwnProperty("orderBy"))
            writer.uint32(/* id 6, wireType 2 =*/50).string(message.orderBy);
          if (message.mask != null && message.hasOwnProperty("mask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.mask, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.transaction);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
          if (message.showMissing != null && message.hasOwnProperty("showMissing"))
            writer.uint32(/* id 12, wireType 0 =*/96).bool(message.showMissing);
          return writer;
        };

        /**
         * Encodes the specified ListDocumentsRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListDocumentsRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsRequest} message ListDocumentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListDocumentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListDocumentsRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListDocumentsRequest} ListDocumentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListDocumentsRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListDocumentsRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.parent = reader.string();
                break;
              case 2:
                message.collectionId = reader.string();
                break;
              case 3:
                message.pageSize = reader.int32();
                break;
              case 4:
                message.pageToken = reader.string();
                break;
              case 6:
                message.orderBy = reader.string();
                break;
              case 7:
                message.mask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 8:
                message.transaction = reader.bytes();
                break;
              case 10:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 12:
                message.showMissing = reader.bool();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListDocumentsRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListDocumentsRequest} ListDocumentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListDocumentsRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListDocumentsRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListDocumentsRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.parent != null && message.hasOwnProperty("parent"))
            if (!$util.isString(message.parent))
              return "parent: string expected";
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            if (!$util.isString(message.collectionId))
              return "collectionId: string expected";
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            if (!$util.isInteger(message.pageSize))
              return "pageSize: integer expected";
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            if (!$util.isString(message.pageToken))
              return "pageToken: string expected";
          if (message.orderBy != null && message.hasOwnProperty("orderBy"))
            if (!$util.isString(message.orderBy))
              return "orderBy: string expected";
          if (message.mask != null && message.hasOwnProperty("mask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.mask);
            if (error)
              return "mask." + error;
          }
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            properties.consistencySelector = 1;
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.readTime);
              if (error)
                return "readTime." + error;
            }
          }
          if (message.showMissing != null && message.hasOwnProperty("showMissing"))
            if (typeof message.showMissing !== "boolean")
              return "showMissing: boolean expected";
          return null;
        };

        /**
         * Creates a ListDocumentsRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListDocumentsRequest} ListDocumentsRequest
         */
        ListDocumentsRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListDocumentsRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.ListDocumentsRequest();
          if (object.parent != null)
            message.parent = String(object.parent);
          if (object.collectionId != null)
            message.collectionId = String(object.collectionId);
          if (object.pageSize != null)
            message.pageSize = object.pageSize | 0;
          if (object.pageToken != null)
            message.pageToken = String(object.pageToken);
          if (object.orderBy != null)
            message.orderBy = String(object.orderBy);
          if (object.mask != null) {
            if (typeof object.mask !== "object")
              throw TypeError(".google.firestore.v1beta1.ListDocumentsRequest.mask: object expected");
            message.mask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.mask);
          }
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.ListDocumentsRequest.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          if (object.showMissing != null)
            message.showMissing = Boolean(object.showMissing);
          return message;
        };

        /**
         * Creates a plain object from a ListDocumentsRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.ListDocumentsRequest} message ListDocumentsRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListDocumentsRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.parent = "";
            object.collectionId = "";
            object.pageSize = 0;
            object.pageToken = "";
            object.orderBy = "";
            object.mask = null;
            object.showMissing = false;
          }
          if (message.parent != null && message.hasOwnProperty("parent"))
            object.parent = message.parent;
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            object.collectionId = message.collectionId;
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            object.pageSize = message.pageSize;
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            object.pageToken = message.pageToken;
          if (message.orderBy != null && message.hasOwnProperty("orderBy"))
            object.orderBy = message.orderBy;
          if (message.mask != null && message.hasOwnProperty("mask"))
            object.mask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.mask, options);
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
            if (options.oneofs)
              object.consistencySelector = "transaction";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
            if (options.oneofs)
              object.consistencySelector = "readTime";
          }
          if (message.showMissing != null && message.hasOwnProperty("showMissing"))
            object.showMissing = message.showMissing;
          return object;
        };

        /**
         * Converts this ListDocumentsRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListDocumentsRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListDocumentsRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListDocumentsRequest;
      })();

      v1beta1.ListDocumentsResponse = (function() {

        /**
         * Properties of a ListDocumentsResponse.
         * @memberof google.firestore.v1beta1
         * @interface IListDocumentsResponse
         * @property {Array.<google.firestore.v1beta1.IDocument>|null} [documents] ListDocumentsResponse documents
         * @property {string|null} [nextPageToken] ListDocumentsResponse nextPageToken
         */

        /**
         * Constructs a new ListDocumentsResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListDocumentsResponse.
         * @implements IListDocumentsResponse
         * @constructor
         * @param {google.firestore.v1beta1.IListDocumentsResponse=} [properties] Properties to set
         */
        function ListDocumentsResponse(properties) {
          this.documents = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListDocumentsResponse documents.
         * @member {Array.<google.firestore.v1beta1.IDocument>} documents
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @instance
         */
        ListDocumentsResponse.prototype.documents = $util.emptyArray;

        /**
         * ListDocumentsResponse nextPageToken.
         * @member {string} nextPageToken
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @instance
         */
        ListDocumentsResponse.prototype.nextPageToken = "";

        /**
         * Creates a new ListDocumentsResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListDocumentsResponse} ListDocumentsResponse instance
         */
        ListDocumentsResponse.create = function create(properties) {
          return new ListDocumentsResponse(properties);
        };

        /**
         * Encodes the specified ListDocumentsResponse message. Does not implicitly {@link google.firestore.v1beta1.ListDocumentsResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsResponse} message ListDocumentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListDocumentsResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.documents != null && message.documents.length)
            for (var i = 0; i < message.documents.length; ++i)
              $root.google.firestore.v1beta1.Document.encode(message.documents[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
          return writer;
        };

        /**
         * Encodes the specified ListDocumentsResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListDocumentsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IListDocumentsResponse} message ListDocumentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListDocumentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListDocumentsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListDocumentsResponse} ListDocumentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListDocumentsResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListDocumentsResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.documents && message.documents.length))
                  message.documents = [];
                message.documents.push($root.google.firestore.v1beta1.Document.decode(reader, reader.uint32()));
                break;
              case 2:
                message.nextPageToken = reader.string();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListDocumentsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListDocumentsResponse} ListDocumentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListDocumentsResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListDocumentsResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListDocumentsResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.documents != null && message.hasOwnProperty("documents")) {
            if (!Array.isArray(message.documents))
              return "documents: array expected";
            for (var i = 0; i < message.documents.length; ++i) {
              var error = $root.google.firestore.v1beta1.Document.verify(message.documents[i]);
              if (error)
                return "documents." + error;
            }
          }
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            if (!$util.isString(message.nextPageToken))
              return "nextPageToken: string expected";
          return null;
        };

        /**
         * Creates a ListDocumentsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListDocumentsResponse} ListDocumentsResponse
         */
        ListDocumentsResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListDocumentsResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.ListDocumentsResponse();
          if (object.documents) {
            if (!Array.isArray(object.documents))
              throw TypeError(".google.firestore.v1beta1.ListDocumentsResponse.documents: array expected");
            message.documents = [];
            for (var i = 0; i < object.documents.length; ++i) {
              if (typeof object.documents[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.ListDocumentsResponse.documents: object expected");
              message.documents[i] = $root.google.firestore.v1beta1.Document.fromObject(object.documents[i]);
            }
          }
          if (object.nextPageToken != null)
            message.nextPageToken = String(object.nextPageToken);
          return message;
        };

        /**
         * Creates a plain object from a ListDocumentsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.ListDocumentsResponse} message ListDocumentsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListDocumentsResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.documents = [];
          if (options.defaults)
            object.nextPageToken = "";
          if (message.documents && message.documents.length) {
            object.documents = [];
            for (var j = 0; j < message.documents.length; ++j)
              object.documents[j] = $root.google.firestore.v1beta1.Document.toObject(message.documents[j], options);
          }
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            object.nextPageToken = message.nextPageToken;
          return object;
        };

        /**
         * Converts this ListDocumentsResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListDocumentsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListDocumentsResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListDocumentsResponse;
      })();

      v1beta1.CreateDocumentRequest = (function() {

        /**
         * Properties of a CreateDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @interface ICreateDocumentRequest
         * @property {string|null} [parent] CreateDocumentRequest parent
         * @property {string|null} [collectionId] CreateDocumentRequest collectionId
         * @property {string|null} [documentId] CreateDocumentRequest documentId
         * @property {google.firestore.v1beta1.IDocument|null} [document] CreateDocumentRequest document
         * @property {google.firestore.v1beta1.IDocumentMask|null} [mask] CreateDocumentRequest mask
         */

        /**
         * Constructs a new CreateDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a CreateDocumentRequest.
         * @implements ICreateDocumentRequest
         * @constructor
         * @param {google.firestore.v1beta1.ICreateDocumentRequest=} [properties] Properties to set
         */
        function CreateDocumentRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * CreateDocumentRequest parent.
         * @member {string} parent
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         */
        CreateDocumentRequest.prototype.parent = "";

        /**
         * CreateDocumentRequest collectionId.
         * @member {string} collectionId
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         */
        CreateDocumentRequest.prototype.collectionId = "";

        /**
         * CreateDocumentRequest documentId.
         * @member {string} documentId
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         */
        CreateDocumentRequest.prototype.documentId = "";

        /**
         * CreateDocumentRequest document.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} document
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         */
        CreateDocumentRequest.prototype.document = null;

        /**
         * CreateDocumentRequest mask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} mask
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         */
        CreateDocumentRequest.prototype.mask = null;

        /**
         * Creates a new CreateDocumentRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.ICreateDocumentRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.CreateDocumentRequest} CreateDocumentRequest instance
         */
        CreateDocumentRequest.create = function create(properties) {
          return new CreateDocumentRequest(properties);
        };

        /**
         * Encodes the specified CreateDocumentRequest message. Does not implicitly {@link google.firestore.v1beta1.CreateDocumentRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.ICreateDocumentRequest} message CreateDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreateDocumentRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.parent != null && message.hasOwnProperty("parent"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.collectionId);
          if (message.documentId != null && message.hasOwnProperty("documentId"))
            writer.uint32(/* id 3, wireType 2 =*/26).string(message.documentId);
          if (message.document != null && message.hasOwnProperty("document"))
            $root.google.firestore.v1beta1.Document.encode(message.document, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          if (message.mask != null && message.hasOwnProperty("mask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.mask, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified CreateDocumentRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.CreateDocumentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.ICreateDocumentRequest} message CreateDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreateDocumentRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CreateDocumentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.CreateDocumentRequest} CreateDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreateDocumentRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.CreateDocumentRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.parent = reader.string();
                break;
              case 2:
                message.collectionId = reader.string();
                break;
              case 3:
                message.documentId = reader.string();
                break;
              case 4:
                message.document = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 5:
                message.mask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a CreateDocumentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.CreateDocumentRequest} CreateDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreateDocumentRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CreateDocumentRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CreateDocumentRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.parent != null && message.hasOwnProperty("parent"))
            if (!$util.isString(message.parent))
              return "parent: string expected";
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            if (!$util.isString(message.collectionId))
              return "collectionId: string expected";
          if (message.documentId != null && message.hasOwnProperty("documentId"))
            if (!$util.isString(message.documentId))
              return "documentId: string expected";
          if (message.document != null && message.hasOwnProperty("document")) {
            var error = $root.google.firestore.v1beta1.Document.verify(message.document);
            if (error)
              return "document." + error;
          }
          if (message.mask != null && message.hasOwnProperty("mask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.mask);
            if (error)
              return "mask." + error;
          }
          return null;
        };

        /**
         * Creates a CreateDocumentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.CreateDocumentRequest} CreateDocumentRequest
         */
        CreateDocumentRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.CreateDocumentRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.CreateDocumentRequest();
          if (object.parent != null)
            message.parent = String(object.parent);
          if (object.collectionId != null)
            message.collectionId = String(object.collectionId);
          if (object.documentId != null)
            message.documentId = String(object.documentId);
          if (object.document != null) {
            if (typeof object.document !== "object")
              throw TypeError(".google.firestore.v1beta1.CreateDocumentRequest.document: object expected");
            message.document = $root.google.firestore.v1beta1.Document.fromObject(object.document);
          }
          if (object.mask != null) {
            if (typeof object.mask !== "object")
              throw TypeError(".google.firestore.v1beta1.CreateDocumentRequest.mask: object expected");
            message.mask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.mask);
          }
          return message;
        };

        /**
         * Creates a plain object from a CreateDocumentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.CreateDocumentRequest} message CreateDocumentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CreateDocumentRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.parent = "";
            object.collectionId = "";
            object.documentId = "";
            object.document = null;
            object.mask = null;
          }
          if (message.parent != null && message.hasOwnProperty("parent"))
            object.parent = message.parent;
          if (message.collectionId != null && message.hasOwnProperty("collectionId"))
            object.collectionId = message.collectionId;
          if (message.documentId != null && message.hasOwnProperty("documentId"))
            object.documentId = message.documentId;
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = $root.google.firestore.v1beta1.Document.toObject(message.document, options);
          if (message.mask != null && message.hasOwnProperty("mask"))
            object.mask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.mask, options);
          return object;
        };

        /**
         * Converts this CreateDocumentRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.CreateDocumentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CreateDocumentRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CreateDocumentRequest;
      })();

      v1beta1.UpdateDocumentRequest = (function() {

        /**
         * Properties of an UpdateDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @interface IUpdateDocumentRequest
         * @property {google.firestore.v1beta1.IDocument|null} [document] UpdateDocumentRequest document
         * @property {google.firestore.v1beta1.IDocumentMask|null} [updateMask] UpdateDocumentRequest updateMask
         * @property {google.firestore.v1beta1.IDocumentMask|null} [mask] UpdateDocumentRequest mask
         * @property {google.firestore.v1beta1.IPrecondition|null} [currentDocument] UpdateDocumentRequest currentDocument
         */

        /**
         * Constructs a new UpdateDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents an UpdateDocumentRequest.
         * @implements IUpdateDocumentRequest
         * @constructor
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest=} [properties] Properties to set
         */
        function UpdateDocumentRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * UpdateDocumentRequest document.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} document
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @instance
         */
        UpdateDocumentRequest.prototype.document = null;

        /**
         * UpdateDocumentRequest updateMask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} updateMask
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @instance
         */
        UpdateDocumentRequest.prototype.updateMask = null;

        /**
         * UpdateDocumentRequest mask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} mask
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @instance
         */
        UpdateDocumentRequest.prototype.mask = null;

        /**
         * UpdateDocumentRequest currentDocument.
         * @member {google.firestore.v1beta1.IPrecondition|null|undefined} currentDocument
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @instance
         */
        UpdateDocumentRequest.prototype.currentDocument = null;

        /**
         * Creates a new UpdateDocumentRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.UpdateDocumentRequest} UpdateDocumentRequest instance
         */
        UpdateDocumentRequest.create = function create(properties) {
          return new UpdateDocumentRequest(properties);
        };

        /**
         * Encodes the specified UpdateDocumentRequest message. Does not implicitly {@link google.firestore.v1beta1.UpdateDocumentRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest} message UpdateDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateDocumentRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            $root.google.firestore.v1beta1.Document.encode(message.document, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.updateMask != null && message.hasOwnProperty("updateMask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.mask != null && message.hasOwnProperty("mask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.mask, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            $root.google.firestore.v1beta1.Precondition.encode(message.currentDocument, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified UpdateDocumentRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.UpdateDocumentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IUpdateDocumentRequest} message UpdateDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateDocumentRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UpdateDocumentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.UpdateDocumentRequest} UpdateDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateDocumentRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.UpdateDocumentRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.document = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 2:
                message.updateMask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 3:
                message.mask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 4:
                message.currentDocument = $root.google.firestore.v1beta1.Precondition.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes an UpdateDocumentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.UpdateDocumentRequest} UpdateDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateDocumentRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UpdateDocumentRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UpdateDocumentRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.document != null && message.hasOwnProperty("document")) {
            var error = $root.google.firestore.v1beta1.Document.verify(message.document);
            if (error)
              return "document." + error;
          }
          if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.updateMask);
            if (error)
              return "updateMask." + error;
          }
          if (message.mask != null && message.hasOwnProperty("mask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.mask);
            if (error)
              return "mask." + error;
          }
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument")) {
            var error = $root.google.firestore.v1beta1.Precondition.verify(message.currentDocument);
            if (error)
              return "currentDocument." + error;
          }
          return null;
        };

        /**
         * Creates an UpdateDocumentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.UpdateDocumentRequest} UpdateDocumentRequest
         */
        UpdateDocumentRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.UpdateDocumentRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.UpdateDocumentRequest();
          if (object.document != null) {
            if (typeof object.document !== "object")
              throw TypeError(".google.firestore.v1beta1.UpdateDocumentRequest.document: object expected");
            message.document = $root.google.firestore.v1beta1.Document.fromObject(object.document);
          }
          if (object.updateMask != null) {
            if (typeof object.updateMask !== "object")
              throw TypeError(".google.firestore.v1beta1.UpdateDocumentRequest.updateMask: object expected");
            message.updateMask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.updateMask);
          }
          if (object.mask != null) {
            if (typeof object.mask !== "object")
              throw TypeError(".google.firestore.v1beta1.UpdateDocumentRequest.mask: object expected");
            message.mask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.mask);
          }
          if (object.currentDocument != null) {
            if (typeof object.currentDocument !== "object")
              throw TypeError(".google.firestore.v1beta1.UpdateDocumentRequest.currentDocument: object expected");
            message.currentDocument = $root.google.firestore.v1beta1.Precondition.fromObject(object.currentDocument);
          }
          return message;
        };

        /**
         * Creates a plain object from an UpdateDocumentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.UpdateDocumentRequest} message UpdateDocumentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UpdateDocumentRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.document = null;
            object.updateMask = null;
            object.mask = null;
            object.currentDocument = null;
          }
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = $root.google.firestore.v1beta1.Document.toObject(message.document, options);
          if (message.updateMask != null && message.hasOwnProperty("updateMask"))
            object.updateMask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.updateMask, options);
          if (message.mask != null && message.hasOwnProperty("mask"))
            object.mask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.mask, options);
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            object.currentDocument = $root.google.firestore.v1beta1.Precondition.toObject(message.currentDocument, options);
          return object;
        };

        /**
         * Converts this UpdateDocumentRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.UpdateDocumentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UpdateDocumentRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UpdateDocumentRequest;
      })();

      v1beta1.DeleteDocumentRequest = (function() {

        /**
         * Properties of a DeleteDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @interface IDeleteDocumentRequest
         * @property {string|null} [name] DeleteDocumentRequest name
         * @property {google.firestore.v1beta1.IPrecondition|null} [currentDocument] DeleteDocumentRequest currentDocument
         */

        /**
         * Constructs a new DeleteDocumentRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DeleteDocumentRequest.
         * @implements IDeleteDocumentRequest
         * @constructor
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest=} [properties] Properties to set
         */
        function DeleteDocumentRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeleteDocumentRequest name.
         * @member {string} name
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @instance
         */
        DeleteDocumentRequest.prototype.name = "";

        /**
         * DeleteDocumentRequest currentDocument.
         * @member {google.firestore.v1beta1.IPrecondition|null|undefined} currentDocument
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @instance
         */
        DeleteDocumentRequest.prototype.currentDocument = null;

        /**
         * Creates a new DeleteDocumentRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DeleteDocumentRequest} DeleteDocumentRequest instance
         */
        DeleteDocumentRequest.create = function create(properties) {
          return new DeleteDocumentRequest(properties);
        };

        /**
         * Encodes the specified DeleteDocumentRequest message. Does not implicitly {@link google.firestore.v1beta1.DeleteDocumentRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest} message DeleteDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteDocumentRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.name != null && message.hasOwnProperty("name"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            $root.google.firestore.v1beta1.Precondition.encode(message.currentDocument, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified DeleteDocumentRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DeleteDocumentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.IDeleteDocumentRequest} message DeleteDocumentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteDocumentRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeleteDocumentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DeleteDocumentRequest} DeleteDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteDocumentRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DeleteDocumentRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.name = reader.string();
                break;
              case 2:
                message.currentDocument = $root.google.firestore.v1beta1.Precondition.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DeleteDocumentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DeleteDocumentRequest} DeleteDocumentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteDocumentRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeleteDocumentRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeleteDocumentRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.name != null && message.hasOwnProperty("name"))
            if (!$util.isString(message.name))
              return "name: string expected";
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument")) {
            var error = $root.google.firestore.v1beta1.Precondition.verify(message.currentDocument);
            if (error)
              return "currentDocument." + error;
          }
          return null;
        };

        /**
         * Creates a DeleteDocumentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DeleteDocumentRequest} DeleteDocumentRequest
         */
        DeleteDocumentRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DeleteDocumentRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.DeleteDocumentRequest();
          if (object.name != null)
            message.name = String(object.name);
          if (object.currentDocument != null) {
            if (typeof object.currentDocument !== "object")
              throw TypeError(".google.firestore.v1beta1.DeleteDocumentRequest.currentDocument: object expected");
            message.currentDocument = $root.google.firestore.v1beta1.Precondition.fromObject(object.currentDocument);
          }
          return message;
        };

        /**
         * Creates a plain object from a DeleteDocumentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @static
         * @param {google.firestore.v1beta1.DeleteDocumentRequest} message DeleteDocumentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeleteDocumentRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.name = "";
            object.currentDocument = null;
          }
          if (message.name != null && message.hasOwnProperty("name"))
            object.name = message.name;
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            object.currentDocument = $root.google.firestore.v1beta1.Precondition.toObject(message.currentDocument, options);
          return object;
        };

        /**
         * Converts this DeleteDocumentRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DeleteDocumentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeleteDocumentRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeleteDocumentRequest;
      })();

      v1beta1.BatchGetDocumentsRequest = (function() {

        /**
         * Properties of a BatchGetDocumentsRequest.
         * @memberof google.firestore.v1beta1
         * @interface IBatchGetDocumentsRequest
         * @property {string|null} [database] BatchGetDocumentsRequest database
         * @property {Array.<string>|null} [documents] BatchGetDocumentsRequest documents
         * @property {google.firestore.v1beta1.IDocumentMask|null} [mask] BatchGetDocumentsRequest mask
         * @property {Uint8Array|null} [transaction] BatchGetDocumentsRequest transaction
         * @property {google.firestore.v1beta1.ITransactionOptions|null} [newTransaction] BatchGetDocumentsRequest newTransaction
         * @property {google.protobuf.ITimestamp|null} [readTime] BatchGetDocumentsRequest readTime
         */

        /**
         * Constructs a new BatchGetDocumentsRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a BatchGetDocumentsRequest.
         * @implements IBatchGetDocumentsRequest
         * @constructor
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest=} [properties] Properties to set
         */
        function BatchGetDocumentsRequest(properties) {
          this.documents = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * BatchGetDocumentsRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.database = "";

        /**
         * BatchGetDocumentsRequest documents.
         * @member {Array.<string>} documents
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.documents = $util.emptyArray;

        /**
         * BatchGetDocumentsRequest mask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} mask
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.mask = null;

        /**
         * BatchGetDocumentsRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * BatchGetDocumentsRequest newTransaction.
         * @member {google.firestore.v1beta1.ITransactionOptions|null|undefined} newTransaction
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.newTransaction = null;

        /**
         * BatchGetDocumentsRequest readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        BatchGetDocumentsRequest.prototype.readTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * BatchGetDocumentsRequest consistencySelector.
         * @member {"transaction"|"newTransaction"|"readTime"|undefined} consistencySelector
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         */
        Object.defineProperty(BatchGetDocumentsRequest.prototype, "consistencySelector", {
          get: $util.oneOfGetter($oneOfFields = ["transaction", "newTransaction", "readTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BatchGetDocumentsRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.BatchGetDocumentsRequest} BatchGetDocumentsRequest instance
         */
        BatchGetDocumentsRequest.create = function create(properties) {
          return new BatchGetDocumentsRequest(properties);
        };

        /**
         * Encodes the specified BatchGetDocumentsRequest message. Does not implicitly {@link google.firestore.v1beta1.BatchGetDocumentsRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest} message BatchGetDocumentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BatchGetDocumentsRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.documents != null && message.documents.length)
            for (var i = 0; i < message.documents.length; ++i)
              writer.uint32(/* id 2, wireType 2 =*/18).string(message.documents[i]);
          if (message.mask != null && message.hasOwnProperty("mask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.mask, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.transaction);
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction"))
            $root.google.firestore.v1beta1.TransactionOptions.encode(message.newTransaction, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified BatchGetDocumentsRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.BatchGetDocumentsRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsRequest} message BatchGetDocumentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BatchGetDocumentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BatchGetDocumentsRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.BatchGetDocumentsRequest} BatchGetDocumentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BatchGetDocumentsRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.BatchGetDocumentsRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                if (!(message.documents && message.documents.length))
                  message.documents = [];
                message.documents.push(reader.string());
                break;
              case 3:
                message.mask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 4:
                message.transaction = reader.bytes();
                break;
              case 5:
                message.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.decode(reader, reader.uint32());
                break;
              case 7:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a BatchGetDocumentsRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.BatchGetDocumentsRequest} BatchGetDocumentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BatchGetDocumentsRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BatchGetDocumentsRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BatchGetDocumentsRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.documents != null && message.hasOwnProperty("documents")) {
            if (!Array.isArray(message.documents))
              return "documents: array expected";
            for (var i = 0; i < message.documents.length; ++i)
              if (!$util.isString(message.documents[i]))
                return "documents: string[] expected";
          }
          if (message.mask != null && message.hasOwnProperty("mask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.mask);
            if (error)
              return "mask." + error;
          }
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            properties.consistencySelector = 1;
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          }
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.firestore.v1beta1.TransactionOptions.verify(message.newTransaction);
              if (error)
                return "newTransaction." + error;
            }
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.readTime);
              if (error)
                return "readTime." + error;
            }
          }
          return null;
        };

        /**
         * Creates a BatchGetDocumentsRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.BatchGetDocumentsRequest} BatchGetDocumentsRequest
         */
        BatchGetDocumentsRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.BatchGetDocumentsRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.BatchGetDocumentsRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.documents) {
            if (!Array.isArray(object.documents))
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsRequest.documents: array expected");
            message.documents = [];
            for (var i = 0; i < object.documents.length; ++i)
              message.documents[i] = String(object.documents[i]);
          }
          if (object.mask != null) {
            if (typeof object.mask !== "object")
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsRequest.mask: object expected");
            message.mask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.mask);
          }
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.newTransaction != null) {
            if (typeof object.newTransaction !== "object")
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsRequest.newTransaction: object expected");
            message.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.fromObject(object.newTransaction);
          }
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsRequest.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a BatchGetDocumentsRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @static
         * @param {google.firestore.v1beta1.BatchGetDocumentsRequest} message BatchGetDocumentsRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BatchGetDocumentsRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.documents = [];
          if (options.defaults) {
            object.database = "";
            object.mask = null;
          }
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.documents && message.documents.length) {
            object.documents = [];
            for (var j = 0; j < message.documents.length; ++j)
              object.documents[j] = message.documents[j];
          }
          if (message.mask != null && message.hasOwnProperty("mask"))
            object.mask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.mask, options);
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
            if (options.oneofs)
              object.consistencySelector = "transaction";
          }
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction")) {
            object.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.toObject(message.newTransaction, options);
            if (options.oneofs)
              object.consistencySelector = "newTransaction";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
            if (options.oneofs)
              object.consistencySelector = "readTime";
          }
          return object;
        };

        /**
         * Converts this BatchGetDocumentsRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.BatchGetDocumentsRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BatchGetDocumentsRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BatchGetDocumentsRequest;
      })();

      v1beta1.BatchGetDocumentsResponse = (function() {

        /**
         * Properties of a BatchGetDocumentsResponse.
         * @memberof google.firestore.v1beta1
         * @interface IBatchGetDocumentsResponse
         * @property {google.firestore.v1beta1.IDocument|null} [found] BatchGetDocumentsResponse found
         * @property {string|null} [missing] BatchGetDocumentsResponse missing
         * @property {Uint8Array|null} [transaction] BatchGetDocumentsResponse transaction
         * @property {google.protobuf.ITimestamp|null} [readTime] BatchGetDocumentsResponse readTime
         */

        /**
         * Constructs a new BatchGetDocumentsResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a BatchGetDocumentsResponse.
         * @implements IBatchGetDocumentsResponse
         * @constructor
         * @param {google.firestore.v1beta1.IBatchGetDocumentsResponse=} [properties] Properties to set
         */
        function BatchGetDocumentsResponse(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * BatchGetDocumentsResponse found.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} found
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         */
        BatchGetDocumentsResponse.prototype.found = null;

        /**
         * BatchGetDocumentsResponse missing.
         * @member {string} missing
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         */
        BatchGetDocumentsResponse.prototype.missing = "";

        /**
         * BatchGetDocumentsResponse transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         */
        BatchGetDocumentsResponse.prototype.transaction = $util.newBuffer([]);

        /**
         * BatchGetDocumentsResponse readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         */
        BatchGetDocumentsResponse.prototype.readTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * BatchGetDocumentsResponse result.
         * @member {"found"|"missing"|undefined} result
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         */
        Object.defineProperty(BatchGetDocumentsResponse.prototype, "result", {
          get: $util.oneOfGetter($oneOfFields = ["found", "missing"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BatchGetDocumentsResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.BatchGetDocumentsResponse} BatchGetDocumentsResponse instance
         */
        BatchGetDocumentsResponse.create = function create(properties) {
          return new BatchGetDocumentsResponse(properties);
        };

        /**
         * Encodes the specified BatchGetDocumentsResponse message. Does not implicitly {@link google.firestore.v1beta1.BatchGetDocumentsResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsResponse} message BatchGetDocumentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BatchGetDocumentsResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.found != null && message.hasOwnProperty("found"))
            $root.google.firestore.v1beta1.Document.encode(message.found, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.missing != null && message.hasOwnProperty("missing"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.missing);
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.transaction);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified BatchGetDocumentsResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.BatchGetDocumentsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.IBatchGetDocumentsResponse} message BatchGetDocumentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BatchGetDocumentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BatchGetDocumentsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.BatchGetDocumentsResponse} BatchGetDocumentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BatchGetDocumentsResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.BatchGetDocumentsResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.found = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 2:
                message.missing = reader.string();
                break;
              case 3:
                message.transaction = reader.bytes();
                break;
              case 4:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a BatchGetDocumentsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.BatchGetDocumentsResponse} BatchGetDocumentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BatchGetDocumentsResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BatchGetDocumentsResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BatchGetDocumentsResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.found != null && message.hasOwnProperty("found")) {
            properties.result = 1;
            {
              var error = $root.google.firestore.v1beta1.Document.verify(message.found);
              if (error)
                return "found." + error;
            }
          }
          if (message.missing != null && message.hasOwnProperty("missing")) {
            if (properties.result === 1)
              return "result: multiple values";
            properties.result = 1;
            if (!$util.isString(message.missing))
              return "missing: string expected";
          }
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.readTime);
            if (error)
              return "readTime." + error;
          }
          return null;
        };

        /**
         * Creates a BatchGetDocumentsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.BatchGetDocumentsResponse} BatchGetDocumentsResponse
         */
        BatchGetDocumentsResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.BatchGetDocumentsResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.BatchGetDocumentsResponse();
          if (object.found != null) {
            if (typeof object.found !== "object")
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsResponse.found: object expected");
            message.found = $root.google.firestore.v1beta1.Document.fromObject(object.found);
          }
          if (object.missing != null)
            message.missing = String(object.missing);
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.BatchGetDocumentsResponse.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a BatchGetDocumentsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @static
         * @param {google.firestore.v1beta1.BatchGetDocumentsResponse} message BatchGetDocumentsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BatchGetDocumentsResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.transaction = options.bytes === String ? "" : [];
            object.readTime = null;
          }
          if (message.found != null && message.hasOwnProperty("found")) {
            object.found = $root.google.firestore.v1beta1.Document.toObject(message.found, options);
            if (options.oneofs)
              object.result = "found";
          }
          if (message.missing != null && message.hasOwnProperty("missing")) {
            object.missing = message.missing;
            if (options.oneofs)
              object.result = "missing";
          }
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
          return object;
        };

        /**
         * Converts this BatchGetDocumentsResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.BatchGetDocumentsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BatchGetDocumentsResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BatchGetDocumentsResponse;
      })();

      v1beta1.BeginTransactionRequest = (function() {

        /**
         * Properties of a BeginTransactionRequest.
         * @memberof google.firestore.v1beta1
         * @interface IBeginTransactionRequest
         * @property {string|null} [database] BeginTransactionRequest database
         * @property {google.firestore.v1beta1.ITransactionOptions|null} [options] BeginTransactionRequest options
         */

        /**
         * Constructs a new BeginTransactionRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a BeginTransactionRequest.
         * @implements IBeginTransactionRequest
         * @constructor
         * @param {google.firestore.v1beta1.IBeginTransactionRequest=} [properties] Properties to set
         */
        function BeginTransactionRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * BeginTransactionRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @instance
         */
        BeginTransactionRequest.prototype.database = "";

        /**
         * BeginTransactionRequest options.
         * @member {google.firestore.v1beta1.ITransactionOptions|null|undefined} options
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @instance
         */
        BeginTransactionRequest.prototype.options = null;

        /**
         * Creates a new BeginTransactionRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.BeginTransactionRequest} BeginTransactionRequest instance
         */
        BeginTransactionRequest.create = function create(properties) {
          return new BeginTransactionRequest(properties);
        };

        /**
         * Encodes the specified BeginTransactionRequest message. Does not implicitly {@link google.firestore.v1beta1.BeginTransactionRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionRequest} message BeginTransactionRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BeginTransactionRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.options != null && message.hasOwnProperty("options"))
            $root.google.firestore.v1beta1.TransactionOptions.encode(message.options, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified BeginTransactionRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.BeginTransactionRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionRequest} message BeginTransactionRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BeginTransactionRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BeginTransactionRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.BeginTransactionRequest} BeginTransactionRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BeginTransactionRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.BeginTransactionRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                message.options = $root.google.firestore.v1beta1.TransactionOptions.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a BeginTransactionRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.BeginTransactionRequest} BeginTransactionRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BeginTransactionRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BeginTransactionRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BeginTransactionRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.options != null && message.hasOwnProperty("options")) {
            var error = $root.google.firestore.v1beta1.TransactionOptions.verify(message.options);
            if (error)
              return "options." + error;
          }
          return null;
        };

        /**
         * Creates a BeginTransactionRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.BeginTransactionRequest} BeginTransactionRequest
         */
        BeginTransactionRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.BeginTransactionRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.BeginTransactionRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.options != null) {
            if (typeof object.options !== "object")
              throw TypeError(".google.firestore.v1beta1.BeginTransactionRequest.options: object expected");
            message.options = $root.google.firestore.v1beta1.TransactionOptions.fromObject(object.options);
          }
          return message;
        };

        /**
         * Creates a plain object from a BeginTransactionRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @static
         * @param {google.firestore.v1beta1.BeginTransactionRequest} message BeginTransactionRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BeginTransactionRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.database = "";
            object.options = null;
          }
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.options != null && message.hasOwnProperty("options"))
            object.options = $root.google.firestore.v1beta1.TransactionOptions.toObject(message.options, options);
          return object;
        };

        /**
         * Converts this BeginTransactionRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.BeginTransactionRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BeginTransactionRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BeginTransactionRequest;
      })();

      v1beta1.BeginTransactionResponse = (function() {

        /**
         * Properties of a BeginTransactionResponse.
         * @memberof google.firestore.v1beta1
         * @interface IBeginTransactionResponse
         * @property {Uint8Array|null} [transaction] BeginTransactionResponse transaction
         */

        /**
         * Constructs a new BeginTransactionResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a BeginTransactionResponse.
         * @implements IBeginTransactionResponse
         * @constructor
         * @param {google.firestore.v1beta1.IBeginTransactionResponse=} [properties] Properties to set
         */
        function BeginTransactionResponse(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * BeginTransactionResponse transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @instance
         */
        BeginTransactionResponse.prototype.transaction = $util.newBuffer([]);

        /**
         * Creates a new BeginTransactionResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.BeginTransactionResponse} BeginTransactionResponse instance
         */
        BeginTransactionResponse.create = function create(properties) {
          return new BeginTransactionResponse(properties);
        };

        /**
         * Encodes the specified BeginTransactionResponse message. Does not implicitly {@link google.firestore.v1beta1.BeginTransactionResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionResponse} message BeginTransactionResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BeginTransactionResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.transaction);
          return writer;
        };

        /**
         * Encodes the specified BeginTransactionResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.BeginTransactionResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {google.firestore.v1beta1.IBeginTransactionResponse} message BeginTransactionResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BeginTransactionResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BeginTransactionResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.BeginTransactionResponse} BeginTransactionResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BeginTransactionResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.BeginTransactionResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.transaction = reader.bytes();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a BeginTransactionResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.BeginTransactionResponse} BeginTransactionResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BeginTransactionResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BeginTransactionResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BeginTransactionResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          return null;
        };

        /**
         * Creates a BeginTransactionResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.BeginTransactionResponse} BeginTransactionResponse
         */
        BeginTransactionResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.BeginTransactionResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.BeginTransactionResponse();
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          return message;
        };

        /**
         * Creates a plain object from a BeginTransactionResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @static
         * @param {google.firestore.v1beta1.BeginTransactionResponse} message BeginTransactionResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BeginTransactionResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults)
            object.transaction = options.bytes === String ? "" : [];
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
          return object;
        };

        /**
         * Converts this BeginTransactionResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.BeginTransactionResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BeginTransactionResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BeginTransactionResponse;
      })();

      v1beta1.CommitRequest = (function() {

        /**
         * Properties of a CommitRequest.
         * @memberof google.firestore.v1beta1
         * @interface ICommitRequest
         * @property {string|null} [database] CommitRequest database
         * @property {Array.<google.firestore.v1beta1.IWrite>|null} [writes] CommitRequest writes
         * @property {Uint8Array|null} [transaction] CommitRequest transaction
         */

        /**
         * Constructs a new CommitRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a CommitRequest.
         * @implements ICommitRequest
         * @constructor
         * @param {google.firestore.v1beta1.ICommitRequest=} [properties] Properties to set
         */
        function CommitRequest(properties) {
          this.writes = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * CommitRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.CommitRequest
         * @instance
         */
        CommitRequest.prototype.database = "";

        /**
         * CommitRequest writes.
         * @member {Array.<google.firestore.v1beta1.IWrite>} writes
         * @memberof google.firestore.v1beta1.CommitRequest
         * @instance
         */
        CommitRequest.prototype.writes = $util.emptyArray;

        /**
         * CommitRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.CommitRequest
         * @instance
         */
        CommitRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * Creates a new CommitRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {google.firestore.v1beta1.ICommitRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.CommitRequest} CommitRequest instance
         */
        CommitRequest.create = function create(properties) {
          return new CommitRequest(properties);
        };

        /**
         * Encodes the specified CommitRequest message. Does not implicitly {@link google.firestore.v1beta1.CommitRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {google.firestore.v1beta1.ICommitRequest} message CommitRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CommitRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.writes != null && message.writes.length)
            for (var i = 0; i < message.writes.length; ++i)
              $root.google.firestore.v1beta1.Write.encode(message.writes[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.transaction);
          return writer;
        };

        /**
         * Encodes the specified CommitRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.CommitRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {google.firestore.v1beta1.ICommitRequest} message CommitRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CommitRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CommitRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.CommitRequest} CommitRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CommitRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.CommitRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                if (!(message.writes && message.writes.length))
                  message.writes = [];
                message.writes.push($root.google.firestore.v1beta1.Write.decode(reader, reader.uint32()));
                break;
              case 3:
                message.transaction = reader.bytes();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a CommitRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.CommitRequest} CommitRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CommitRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CommitRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CommitRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.writes != null && message.hasOwnProperty("writes")) {
            if (!Array.isArray(message.writes))
              return "writes: array expected";
            for (var i = 0; i < message.writes.length; ++i) {
              var error = $root.google.firestore.v1beta1.Write.verify(message.writes[i]);
              if (error)
                return "writes." + error;
            }
          }
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          return null;
        };

        /**
         * Creates a CommitRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.CommitRequest} CommitRequest
         */
        CommitRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.CommitRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.CommitRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.writes) {
            if (!Array.isArray(object.writes))
              throw TypeError(".google.firestore.v1beta1.CommitRequest.writes: array expected");
            message.writes = [];
            for (var i = 0; i < object.writes.length; ++i) {
              if (typeof object.writes[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.CommitRequest.writes: object expected");
              message.writes[i] = $root.google.firestore.v1beta1.Write.fromObject(object.writes[i]);
            }
          }
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          return message;
        };

        /**
         * Creates a plain object from a CommitRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.CommitRequest
         * @static
         * @param {google.firestore.v1beta1.CommitRequest} message CommitRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CommitRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.writes = [];
          if (options.defaults) {
            object.database = "";
            object.transaction = options.bytes === String ? "" : [];
          }
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.writes && message.writes.length) {
            object.writes = [];
            for (var j = 0; j < message.writes.length; ++j)
              object.writes[j] = $root.google.firestore.v1beta1.Write.toObject(message.writes[j], options);
          }
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
          return object;
        };

        /**
         * Converts this CommitRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.CommitRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CommitRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CommitRequest;
      })();

      v1beta1.CommitResponse = (function() {

        /**
         * Properties of a CommitResponse.
         * @memberof google.firestore.v1beta1
         * @interface ICommitResponse
         * @property {Array.<google.firestore.v1beta1.IWriteResult>|null} [writeResults] CommitResponse writeResults
         * @property {google.protobuf.ITimestamp|null} [commitTime] CommitResponse commitTime
         */

        /**
         * Constructs a new CommitResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a CommitResponse.
         * @implements ICommitResponse
         * @constructor
         * @param {google.firestore.v1beta1.ICommitResponse=} [properties] Properties to set
         */
        function CommitResponse(properties) {
          this.writeResults = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * CommitResponse writeResults.
         * @member {Array.<google.firestore.v1beta1.IWriteResult>} writeResults
         * @memberof google.firestore.v1beta1.CommitResponse
         * @instance
         */
        CommitResponse.prototype.writeResults = $util.emptyArray;

        /**
         * CommitResponse commitTime.
         * @member {google.protobuf.ITimestamp|null|undefined} commitTime
         * @memberof google.firestore.v1beta1.CommitResponse
         * @instance
         */
        CommitResponse.prototype.commitTime = null;

        /**
         * Creates a new CommitResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {google.firestore.v1beta1.ICommitResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.CommitResponse} CommitResponse instance
         */
        CommitResponse.create = function create(properties) {
          return new CommitResponse(properties);
        };

        /**
         * Encodes the specified CommitResponse message. Does not implicitly {@link google.firestore.v1beta1.CommitResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {google.firestore.v1beta1.ICommitResponse} message CommitResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CommitResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.writeResults != null && message.writeResults.length)
            for (var i = 0; i < message.writeResults.length; ++i)
              $root.google.firestore.v1beta1.WriteResult.encode(message.writeResults[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.commitTime != null && message.hasOwnProperty("commitTime"))
            $root.google.protobuf.Timestamp.encode(message.commitTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified CommitResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.CommitResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {google.firestore.v1beta1.ICommitResponse} message CommitResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CommitResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CommitResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.CommitResponse} CommitResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CommitResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.CommitResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.writeResults && message.writeResults.length))
                  message.writeResults = [];
                message.writeResults.push($root.google.firestore.v1beta1.WriteResult.decode(reader, reader.uint32()));
                break;
              case 2:
                message.commitTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a CommitResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.CommitResponse} CommitResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CommitResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CommitResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CommitResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.writeResults != null && message.hasOwnProperty("writeResults")) {
            if (!Array.isArray(message.writeResults))
              return "writeResults: array expected";
            for (var i = 0; i < message.writeResults.length; ++i) {
              var error = $root.google.firestore.v1beta1.WriteResult.verify(message.writeResults[i]);
              if (error)
                return "writeResults." + error;
            }
          }
          if (message.commitTime != null && message.hasOwnProperty("commitTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.commitTime);
            if (error)
              return "commitTime." + error;
          }
          return null;
        };

        /**
         * Creates a CommitResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.CommitResponse} CommitResponse
         */
        CommitResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.CommitResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.CommitResponse();
          if (object.writeResults) {
            if (!Array.isArray(object.writeResults))
              throw TypeError(".google.firestore.v1beta1.CommitResponse.writeResults: array expected");
            message.writeResults = [];
            for (var i = 0; i < object.writeResults.length; ++i) {
              if (typeof object.writeResults[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.CommitResponse.writeResults: object expected");
              message.writeResults[i] = $root.google.firestore.v1beta1.WriteResult.fromObject(object.writeResults[i]);
            }
          }
          if (object.commitTime != null) {
            if (typeof object.commitTime !== "object")
              throw TypeError(".google.firestore.v1beta1.CommitResponse.commitTime: object expected");
            message.commitTime = $root.google.protobuf.Timestamp.fromObject(object.commitTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a CommitResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.CommitResponse
         * @static
         * @param {google.firestore.v1beta1.CommitResponse} message CommitResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CommitResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.writeResults = [];
          if (options.defaults)
            object.commitTime = null;
          if (message.writeResults && message.writeResults.length) {
            object.writeResults = [];
            for (var j = 0; j < message.writeResults.length; ++j)
              object.writeResults[j] = $root.google.firestore.v1beta1.WriteResult.toObject(message.writeResults[j], options);
          }
          if (message.commitTime != null && message.hasOwnProperty("commitTime"))
            object.commitTime = $root.google.protobuf.Timestamp.toObject(message.commitTime, options);
          return object;
        };

        /**
         * Converts this CommitResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.CommitResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CommitResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CommitResponse;
      })();

      v1beta1.RollbackRequest = (function() {

        /**
         * Properties of a RollbackRequest.
         * @memberof google.firestore.v1beta1
         * @interface IRollbackRequest
         * @property {string|null} [database] RollbackRequest database
         * @property {Uint8Array|null} [transaction] RollbackRequest transaction
         */

        /**
         * Constructs a new RollbackRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a RollbackRequest.
         * @implements IRollbackRequest
         * @constructor
         * @param {google.firestore.v1beta1.IRollbackRequest=} [properties] Properties to set
         */
        function RollbackRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * RollbackRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @instance
         */
        RollbackRequest.prototype.database = "";

        /**
         * RollbackRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @instance
         */
        RollbackRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * Creates a new RollbackRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {google.firestore.v1beta1.IRollbackRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.RollbackRequest} RollbackRequest instance
         */
        RollbackRequest.create = function create(properties) {
          return new RollbackRequest(properties);
        };

        /**
         * Encodes the specified RollbackRequest message. Does not implicitly {@link google.firestore.v1beta1.RollbackRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {google.firestore.v1beta1.IRollbackRequest} message RollbackRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RollbackRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.transaction);
          return writer;
        };

        /**
         * Encodes the specified RollbackRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.RollbackRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {google.firestore.v1beta1.IRollbackRequest} message RollbackRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RollbackRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RollbackRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.RollbackRequest} RollbackRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RollbackRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.RollbackRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                message.transaction = reader.bytes();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a RollbackRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.RollbackRequest} RollbackRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RollbackRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RollbackRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RollbackRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          return null;
        };

        /**
         * Creates a RollbackRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.RollbackRequest} RollbackRequest
         */
        RollbackRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.RollbackRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.RollbackRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          return message;
        };

        /**
         * Creates a plain object from a RollbackRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @static
         * @param {google.firestore.v1beta1.RollbackRequest} message RollbackRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RollbackRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.database = "";
            object.transaction = options.bytes === String ? "" : [];
          }
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
          return object;
        };

        /**
         * Converts this RollbackRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.RollbackRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RollbackRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RollbackRequest;
      })();

      v1beta1.RunQueryRequest = (function() {

        /**
         * Properties of a RunQueryRequest.
         * @memberof google.firestore.v1beta1
         * @interface IRunQueryRequest
         * @property {string|null} [parent] RunQueryRequest parent
         * @property {google.firestore.v1beta1.IStructuredQuery|null} [structuredQuery] RunQueryRequest structuredQuery
         * @property {Uint8Array|null} [transaction] RunQueryRequest transaction
         * @property {google.firestore.v1beta1.ITransactionOptions|null} [newTransaction] RunQueryRequest newTransaction
         * @property {google.protobuf.ITimestamp|null} [readTime] RunQueryRequest readTime
         */

        /**
         * Constructs a new RunQueryRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a RunQueryRequest.
         * @implements IRunQueryRequest
         * @constructor
         * @param {google.firestore.v1beta1.IRunQueryRequest=} [properties] Properties to set
         */
        function RunQueryRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * RunQueryRequest parent.
         * @member {string} parent
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        RunQueryRequest.prototype.parent = "";

        /**
         * RunQueryRequest structuredQuery.
         * @member {google.firestore.v1beta1.IStructuredQuery|null|undefined} structuredQuery
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        RunQueryRequest.prototype.structuredQuery = null;

        /**
         * RunQueryRequest transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        RunQueryRequest.prototype.transaction = $util.newBuffer([]);

        /**
         * RunQueryRequest newTransaction.
         * @member {google.firestore.v1beta1.ITransactionOptions|null|undefined} newTransaction
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        RunQueryRequest.prototype.newTransaction = null;

        /**
         * RunQueryRequest readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        RunQueryRequest.prototype.readTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * RunQueryRequest queryType.
         * @member {"structuredQuery"|undefined} queryType
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        Object.defineProperty(RunQueryRequest.prototype, "queryType", {
          get: $util.oneOfGetter($oneOfFields = ["structuredQuery"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * RunQueryRequest consistencySelector.
         * @member {"transaction"|"newTransaction"|"readTime"|undefined} consistencySelector
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         */
        Object.defineProperty(RunQueryRequest.prototype, "consistencySelector", {
          get: $util.oneOfGetter($oneOfFields = ["transaction", "newTransaction", "readTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new RunQueryRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {google.firestore.v1beta1.IRunQueryRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.RunQueryRequest} RunQueryRequest instance
         */
        RunQueryRequest.create = function create(properties) {
          return new RunQueryRequest(properties);
        };

        /**
         * Encodes the specified RunQueryRequest message. Does not implicitly {@link google.firestore.v1beta1.RunQueryRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {google.firestore.v1beta1.IRunQueryRequest} message RunQueryRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RunQueryRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.parent != null && message.hasOwnProperty("parent"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
          if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery"))
            $root.google.firestore.v1beta1.StructuredQuery.encode(message.structuredQuery, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.transaction);
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction"))
            $root.google.firestore.v1beta1.TransactionOptions.encode(message.newTransaction, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified RunQueryRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.RunQueryRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {google.firestore.v1beta1.IRunQueryRequest} message RunQueryRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RunQueryRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RunQueryRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.RunQueryRequest} RunQueryRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RunQueryRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.RunQueryRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.parent = reader.string();
                break;
              case 2:
                message.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.decode(reader, reader.uint32());
                break;
              case 5:
                message.transaction = reader.bytes();
                break;
              case 6:
                message.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.decode(reader, reader.uint32());
                break;
              case 7:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a RunQueryRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.RunQueryRequest} RunQueryRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RunQueryRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RunQueryRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RunQueryRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.parent != null && message.hasOwnProperty("parent"))
            if (!$util.isString(message.parent))
              return "parent: string expected";
          if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery")) {
            properties.queryType = 1;
            {
              var error = $root.google.firestore.v1beta1.StructuredQuery.verify(message.structuredQuery);
              if (error)
                return "structuredQuery." + error;
            }
          }
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            properties.consistencySelector = 1;
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          }
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.firestore.v1beta1.TransactionOptions.verify(message.newTransaction);
              if (error)
                return "newTransaction." + error;
            }
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            if (properties.consistencySelector === 1)
              return "consistencySelector: multiple values";
            properties.consistencySelector = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.readTime);
              if (error)
                return "readTime." + error;
            }
          }
          return null;
        };

        /**
         * Creates a RunQueryRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.RunQueryRequest} RunQueryRequest
         */
        RunQueryRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.RunQueryRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.RunQueryRequest();
          if (object.parent != null)
            message.parent = String(object.parent);
          if (object.structuredQuery != null) {
            if (typeof object.structuredQuery !== "object")
              throw TypeError(".google.firestore.v1beta1.RunQueryRequest.structuredQuery: object expected");
            message.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.fromObject(object.structuredQuery);
          }
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.newTransaction != null) {
            if (typeof object.newTransaction !== "object")
              throw TypeError(".google.firestore.v1beta1.RunQueryRequest.newTransaction: object expected");
            message.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.fromObject(object.newTransaction);
          }
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.RunQueryRequest.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a RunQueryRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @static
         * @param {google.firestore.v1beta1.RunQueryRequest} message RunQueryRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RunQueryRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults)
            object.parent = "";
          if (message.parent != null && message.hasOwnProperty("parent"))
            object.parent = message.parent;
          if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery")) {
            object.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.toObject(message.structuredQuery, options);
            if (options.oneofs)
              object.queryType = "structuredQuery";
          }
          if (message.transaction != null && message.hasOwnProperty("transaction")) {
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
            if (options.oneofs)
              object.consistencySelector = "transaction";
          }
          if (message.newTransaction != null && message.hasOwnProperty("newTransaction")) {
            object.newTransaction = $root.google.firestore.v1beta1.TransactionOptions.toObject(message.newTransaction, options);
            if (options.oneofs)
              object.consistencySelector = "newTransaction";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
            if (options.oneofs)
              object.consistencySelector = "readTime";
          }
          return object;
        };

        /**
         * Converts this RunQueryRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.RunQueryRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RunQueryRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RunQueryRequest;
      })();

      v1beta1.RunQueryResponse = (function() {

        /**
         * Properties of a RunQueryResponse.
         * @memberof google.firestore.v1beta1
         * @interface IRunQueryResponse
         * @property {Uint8Array|null} [transaction] RunQueryResponse transaction
         * @property {google.firestore.v1beta1.IDocument|null} [document] RunQueryResponse document
         * @property {google.protobuf.ITimestamp|null} [readTime] RunQueryResponse readTime
         * @property {number|null} [skippedResults] RunQueryResponse skippedResults
         */

        /**
         * Constructs a new RunQueryResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a RunQueryResponse.
         * @implements IRunQueryResponse
         * @constructor
         * @param {google.firestore.v1beta1.IRunQueryResponse=} [properties] Properties to set
         */
        function RunQueryResponse(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * RunQueryResponse transaction.
         * @member {Uint8Array} transaction
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @instance
         */
        RunQueryResponse.prototype.transaction = $util.newBuffer([]);

        /**
         * RunQueryResponse document.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} document
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @instance
         */
        RunQueryResponse.prototype.document = null;

        /**
         * RunQueryResponse readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @instance
         */
        RunQueryResponse.prototype.readTime = null;

        /**
         * RunQueryResponse skippedResults.
         * @member {number} skippedResults
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @instance
         */
        RunQueryResponse.prototype.skippedResults = 0;

        /**
         * Creates a new RunQueryResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {google.firestore.v1beta1.IRunQueryResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.RunQueryResponse} RunQueryResponse instance
         */
        RunQueryResponse.create = function create(properties) {
          return new RunQueryResponse(properties);
        };

        /**
         * Encodes the specified RunQueryResponse message. Does not implicitly {@link google.firestore.v1beta1.RunQueryResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {google.firestore.v1beta1.IRunQueryResponse} message RunQueryResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RunQueryResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            $root.google.firestore.v1beta1.Document.encode(message.document, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.transaction);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.skippedResults != null && message.hasOwnProperty("skippedResults"))
            writer.uint32(/* id 4, wireType 0 =*/32).int32(message.skippedResults);
          return writer;
        };

        /**
         * Encodes the specified RunQueryResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.RunQueryResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {google.firestore.v1beta1.IRunQueryResponse} message RunQueryResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RunQueryResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RunQueryResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.RunQueryResponse} RunQueryResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RunQueryResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.RunQueryResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 2:
                message.transaction = reader.bytes();
                break;
              case 1:
                message.document = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 3:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 4:
                message.skippedResults = reader.int32();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a RunQueryResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.RunQueryResponse} RunQueryResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RunQueryResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RunQueryResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RunQueryResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            if (!(message.transaction && typeof message.transaction.length === "number" || $util.isString(message.transaction)))
              return "transaction: buffer expected";
          if (message.document != null && message.hasOwnProperty("document")) {
            var error = $root.google.firestore.v1beta1.Document.verify(message.document);
            if (error)
              return "document." + error;
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.readTime);
            if (error)
              return "readTime." + error;
          }
          if (message.skippedResults != null && message.hasOwnProperty("skippedResults"))
            if (!$util.isInteger(message.skippedResults))
              return "skippedResults: integer expected";
          return null;
        };

        /**
         * Creates a RunQueryResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.RunQueryResponse} RunQueryResponse
         */
        RunQueryResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.RunQueryResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.RunQueryResponse();
          if (object.transaction != null)
            if (typeof object.transaction === "string")
              $util.base64.decode(object.transaction, message.transaction = $util.newBuffer($util.base64.length(object.transaction)), 0);
            else if (object.transaction.length)
              message.transaction = object.transaction;
          if (object.document != null) {
            if (typeof object.document !== "object")
              throw TypeError(".google.firestore.v1beta1.RunQueryResponse.document: object expected");
            message.document = $root.google.firestore.v1beta1.Document.fromObject(object.document);
          }
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.RunQueryResponse.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          if (object.skippedResults != null)
            message.skippedResults = object.skippedResults | 0;
          return message;
        };

        /**
         * Creates a plain object from a RunQueryResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @static
         * @param {google.firestore.v1beta1.RunQueryResponse} message RunQueryResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RunQueryResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.document = null;
            object.transaction = options.bytes === String ? "" : [];
            object.readTime = null;
            object.skippedResults = 0;
          }
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = $root.google.firestore.v1beta1.Document.toObject(message.document, options);
          if (message.transaction != null && message.hasOwnProperty("transaction"))
            object.transaction = options.bytes === String ? $util.base64.encode(message.transaction, 0, message.transaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.transaction) : message.transaction;
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
          if (message.skippedResults != null && message.hasOwnProperty("skippedResults"))
            object.skippedResults = message.skippedResults;
          return object;
        };

        /**
         * Converts this RunQueryResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.RunQueryResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RunQueryResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RunQueryResponse;
      })();

      v1beta1.WriteRequest = (function() {

        /**
         * Properties of a WriteRequest.
         * @memberof google.firestore.v1beta1
         * @interface IWriteRequest
         * @property {string|null} [database] WriteRequest database
         * @property {string|null} [streamId] WriteRequest streamId
         * @property {Array.<google.firestore.v1beta1.IWrite>|null} [writes] WriteRequest writes
         * @property {Uint8Array|null} [streamToken] WriteRequest streamToken
         * @property {Object.<string,string>|null} [labels] WriteRequest labels
         */

        /**
         * Constructs a new WriteRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a WriteRequest.
         * @implements IWriteRequest
         * @constructor
         * @param {google.firestore.v1beta1.IWriteRequest=} [properties] Properties to set
         */
        function WriteRequest(properties) {
          this.writes = [];
          this.labels = {};
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * WriteRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         */
        WriteRequest.prototype.database = "";

        /**
         * WriteRequest streamId.
         * @member {string} streamId
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         */
        WriteRequest.prototype.streamId = "";

        /**
         * WriteRequest writes.
         * @member {Array.<google.firestore.v1beta1.IWrite>} writes
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         */
        WriteRequest.prototype.writes = $util.emptyArray;

        /**
         * WriteRequest streamToken.
         * @member {Uint8Array} streamToken
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         */
        WriteRequest.prototype.streamToken = $util.newBuffer([]);

        /**
         * WriteRequest labels.
         * @member {Object.<string,string>} labels
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         */
        WriteRequest.prototype.labels = $util.emptyObject;

        /**
         * Creates a new WriteRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {google.firestore.v1beta1.IWriteRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.WriteRequest} WriteRequest instance
         */
        WriteRequest.create = function create(properties) {
          return new WriteRequest(properties);
        };

        /**
         * Encodes the specified WriteRequest message. Does not implicitly {@link google.firestore.v1beta1.WriteRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {google.firestore.v1beta1.IWriteRequest} message WriteRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.streamId);
          if (message.writes != null && message.writes.length)
            for (var i = 0; i < message.writes.length; ++i)
              $root.google.firestore.v1beta1.Write.encode(message.writes[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.streamToken);
          if (message.labels != null && message.hasOwnProperty("labels"))
            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
              writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
          return writer;
        };

        /**
         * Encodes the specified WriteRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.WriteRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {google.firestore.v1beta1.IWriteRequest} message WriteRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WriteRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.WriteRequest} WriteRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.WriteRequest(), key;
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                message.streamId = reader.string();
                break;
              case 3:
                if (!(message.writes && message.writes.length))
                  message.writes = [];
                message.writes.push($root.google.firestore.v1beta1.Write.decode(reader, reader.uint32()));
                break;
              case 4:
                message.streamToken = reader.bytes();
                break;
              case 5:
                reader.skip().pos++;
                if (message.labels === $util.emptyObject)
                  message.labels = {};
                key = reader.string();
                reader.pos++;
                message.labels[key] = reader.string();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a WriteRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.WriteRequest} WriteRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WriteRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WriteRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            if (!$util.isString(message.streamId))
              return "streamId: string expected";
          if (message.writes != null && message.hasOwnProperty("writes")) {
            if (!Array.isArray(message.writes))
              return "writes: array expected";
            for (var i = 0; i < message.writes.length; ++i) {
              var error = $root.google.firestore.v1beta1.Write.verify(message.writes[i]);
              if (error)
                return "writes." + error;
            }
          }
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            if (!(message.streamToken && typeof message.streamToken.length === "number" || $util.isString(message.streamToken)))
              return "streamToken: buffer expected";
          if (message.labels != null && message.hasOwnProperty("labels")) {
            if (!$util.isObject(message.labels))
              return "labels: object expected";
            var key = Object.keys(message.labels);
            for (var i = 0; i < key.length; ++i)
              if (!$util.isString(message.labels[key[i]]))
                return "labels: string{k:string} expected";
          }
          return null;
        };

        /**
         * Creates a WriteRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.WriteRequest} WriteRequest
         */
        WriteRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.WriteRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.WriteRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.streamId != null)
            message.streamId = String(object.streamId);
          if (object.writes) {
            if (!Array.isArray(object.writes))
              throw TypeError(".google.firestore.v1beta1.WriteRequest.writes: array expected");
            message.writes = [];
            for (var i = 0; i < object.writes.length; ++i) {
              if (typeof object.writes[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.WriteRequest.writes: object expected");
              message.writes[i] = $root.google.firestore.v1beta1.Write.fromObject(object.writes[i]);
            }
          }
          if (object.streamToken != null)
            if (typeof object.streamToken === "string")
              $util.base64.decode(object.streamToken, message.streamToken = $util.newBuffer($util.base64.length(object.streamToken)), 0);
            else if (object.streamToken.length)
              message.streamToken = object.streamToken;
          if (object.labels) {
            if (typeof object.labels !== "object")
              throw TypeError(".google.firestore.v1beta1.WriteRequest.labels: object expected");
            message.labels = {};
            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
              message.labels[keys[i]] = String(object.labels[keys[i]]);
          }
          return message;
        };

        /**
         * Creates a plain object from a WriteRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.WriteRequest
         * @static
         * @param {google.firestore.v1beta1.WriteRequest} message WriteRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WriteRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.writes = [];
          if (options.objects || options.defaults)
            object.labels = {};
          if (options.defaults) {
            object.database = "";
            object.streamId = "";
            object.streamToken = options.bytes === String ? "" : [];
          }
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            object.streamId = message.streamId;
          if (message.writes && message.writes.length) {
            object.writes = [];
            for (var j = 0; j < message.writes.length; ++j)
              object.writes[j] = $root.google.firestore.v1beta1.Write.toObject(message.writes[j], options);
          }
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            object.streamToken = options.bytes === String ? $util.base64.encode(message.streamToken, 0, message.streamToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.streamToken) : message.streamToken;
          var keys2;
          if (message.labels && (keys2 = Object.keys(message.labels)).length) {
            object.labels = {};
            for (var j = 0; j < keys2.length; ++j)
              object.labels[keys2[j]] = message.labels[keys2[j]];
          }
          return object;
        };

        /**
         * Converts this WriteRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.WriteRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WriteRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WriteRequest;
      })();

      v1beta1.WriteResponse = (function() {

        /**
         * Properties of a WriteResponse.
         * @memberof google.firestore.v1beta1
         * @interface IWriteResponse
         * @property {string|null} [streamId] WriteResponse streamId
         * @property {Uint8Array|null} [streamToken] WriteResponse streamToken
         * @property {Array.<google.firestore.v1beta1.IWriteResult>|null} [writeResults] WriteResponse writeResults
         * @property {google.protobuf.ITimestamp|null} [commitTime] WriteResponse commitTime
         */

        /**
         * Constructs a new WriteResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a WriteResponse.
         * @implements IWriteResponse
         * @constructor
         * @param {google.firestore.v1beta1.IWriteResponse=} [properties] Properties to set
         */
        function WriteResponse(properties) {
          this.writeResults = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * WriteResponse streamId.
         * @member {string} streamId
         * @memberof google.firestore.v1beta1.WriteResponse
         * @instance
         */
        WriteResponse.prototype.streamId = "";

        /**
         * WriteResponse streamToken.
         * @member {Uint8Array} streamToken
         * @memberof google.firestore.v1beta1.WriteResponse
         * @instance
         */
        WriteResponse.prototype.streamToken = $util.newBuffer([]);

        /**
         * WriteResponse writeResults.
         * @member {Array.<google.firestore.v1beta1.IWriteResult>} writeResults
         * @memberof google.firestore.v1beta1.WriteResponse
         * @instance
         */
        WriteResponse.prototype.writeResults = $util.emptyArray;

        /**
         * WriteResponse commitTime.
         * @member {google.protobuf.ITimestamp|null|undefined} commitTime
         * @memberof google.firestore.v1beta1.WriteResponse
         * @instance
         */
        WriteResponse.prototype.commitTime = null;

        /**
         * Creates a new WriteResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {google.firestore.v1beta1.IWriteResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.WriteResponse} WriteResponse instance
         */
        WriteResponse.create = function create(properties) {
          return new WriteResponse(properties);
        };

        /**
         * Encodes the specified WriteResponse message. Does not implicitly {@link google.firestore.v1beta1.WriteResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {google.firestore.v1beta1.IWriteResponse} message WriteResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.streamId);
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.streamToken);
          if (message.writeResults != null && message.writeResults.length)
            for (var i = 0; i < message.writeResults.length; ++i)
              $root.google.firestore.v1beta1.WriteResult.encode(message.writeResults[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.commitTime != null && message.hasOwnProperty("commitTime"))
            $root.google.protobuf.Timestamp.encode(message.commitTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified WriteResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.WriteResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {google.firestore.v1beta1.IWriteResponse} message WriteResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WriteResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.WriteResponse} WriteResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.WriteResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.streamId = reader.string();
                break;
              case 2:
                message.streamToken = reader.bytes();
                break;
              case 3:
                if (!(message.writeResults && message.writeResults.length))
                  message.writeResults = [];
                message.writeResults.push($root.google.firestore.v1beta1.WriteResult.decode(reader, reader.uint32()));
                break;
              case 4:
                message.commitTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a WriteResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.WriteResponse} WriteResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WriteResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WriteResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            if (!$util.isString(message.streamId))
              return "streamId: string expected";
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            if (!(message.streamToken && typeof message.streamToken.length === "number" || $util.isString(message.streamToken)))
              return "streamToken: buffer expected";
          if (message.writeResults != null && message.hasOwnProperty("writeResults")) {
            if (!Array.isArray(message.writeResults))
              return "writeResults: array expected";
            for (var i = 0; i < message.writeResults.length; ++i) {
              var error = $root.google.firestore.v1beta1.WriteResult.verify(message.writeResults[i]);
              if (error)
                return "writeResults." + error;
            }
          }
          if (message.commitTime != null && message.hasOwnProperty("commitTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.commitTime);
            if (error)
              return "commitTime." + error;
          }
          return null;
        };

        /**
         * Creates a WriteResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.WriteResponse} WriteResponse
         */
        WriteResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.WriteResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.WriteResponse();
          if (object.streamId != null)
            message.streamId = String(object.streamId);
          if (object.streamToken != null)
            if (typeof object.streamToken === "string")
              $util.base64.decode(object.streamToken, message.streamToken = $util.newBuffer($util.base64.length(object.streamToken)), 0);
            else if (object.streamToken.length)
              message.streamToken = object.streamToken;
          if (object.writeResults) {
            if (!Array.isArray(object.writeResults))
              throw TypeError(".google.firestore.v1beta1.WriteResponse.writeResults: array expected");
            message.writeResults = [];
            for (var i = 0; i < object.writeResults.length; ++i) {
              if (typeof object.writeResults[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.WriteResponse.writeResults: object expected");
              message.writeResults[i] = $root.google.firestore.v1beta1.WriteResult.fromObject(object.writeResults[i]);
            }
          }
          if (object.commitTime != null) {
            if (typeof object.commitTime !== "object")
              throw TypeError(".google.firestore.v1beta1.WriteResponse.commitTime: object expected");
            message.commitTime = $root.google.protobuf.Timestamp.fromObject(object.commitTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a WriteResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.WriteResponse
         * @static
         * @param {google.firestore.v1beta1.WriteResponse} message WriteResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WriteResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.writeResults = [];
          if (options.defaults) {
            object.streamId = "";
            object.streamToken = options.bytes === String ? "" : [];
            object.commitTime = null;
          }
          if (message.streamId != null && message.hasOwnProperty("streamId"))
            object.streamId = message.streamId;
          if (message.streamToken != null && message.hasOwnProperty("streamToken"))
            object.streamToken = options.bytes === String ? $util.base64.encode(message.streamToken, 0, message.streamToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.streamToken) : message.streamToken;
          if (message.writeResults && message.writeResults.length) {
            object.writeResults = [];
            for (var j = 0; j < message.writeResults.length; ++j)
              object.writeResults[j] = $root.google.firestore.v1beta1.WriteResult.toObject(message.writeResults[j], options);
          }
          if (message.commitTime != null && message.hasOwnProperty("commitTime"))
            object.commitTime = $root.google.protobuf.Timestamp.toObject(message.commitTime, options);
          return object;
        };

        /**
         * Converts this WriteResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.WriteResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WriteResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WriteResponse;
      })();

      v1beta1.ListenRequest = (function() {

        /**
         * Properties of a ListenRequest.
         * @memberof google.firestore.v1beta1
         * @interface IListenRequest
         * @property {string|null} [database] ListenRequest database
         * @property {google.firestore.v1beta1.ITarget|null} [addTarget] ListenRequest addTarget
         * @property {number|null} [removeTarget] ListenRequest removeTarget
         * @property {Object.<string,string>|null} [labels] ListenRequest labels
         */

        /**
         * Constructs a new ListenRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListenRequest.
         * @implements IListenRequest
         * @constructor
         * @param {google.firestore.v1beta1.IListenRequest=} [properties] Properties to set
         */
        function ListenRequest(properties) {
          this.labels = {};
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListenRequest database.
         * @member {string} database
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         */
        ListenRequest.prototype.database = "";

        /**
         * ListenRequest addTarget.
         * @member {google.firestore.v1beta1.ITarget|null|undefined} addTarget
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         */
        ListenRequest.prototype.addTarget = null;

        /**
         * ListenRequest removeTarget.
         * @member {number} removeTarget
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         */
        ListenRequest.prototype.removeTarget = 0;

        /**
         * ListenRequest labels.
         * @member {Object.<string,string>} labels
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         */
        ListenRequest.prototype.labels = $util.emptyObject;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ListenRequest targetChange.
         * @member {"addTarget"|"removeTarget"|undefined} targetChange
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         */
        Object.defineProperty(ListenRequest.prototype, "targetChange", {
          get: $util.oneOfGetter($oneOfFields = ["addTarget", "removeTarget"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ListenRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {google.firestore.v1beta1.IListenRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListenRequest} ListenRequest instance
         */
        ListenRequest.create = function create(properties) {
          return new ListenRequest(properties);
        };

        /**
         * Encodes the specified ListenRequest message. Does not implicitly {@link google.firestore.v1beta1.ListenRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {google.firestore.v1beta1.IListenRequest} message ListenRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListenRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.database != null && message.hasOwnProperty("database"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.database);
          if (message.addTarget != null && message.hasOwnProperty("addTarget"))
            $root.google.firestore.v1beta1.Target.encode(message.addTarget, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.removeTarget != null && message.hasOwnProperty("removeTarget"))
            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.removeTarget);
          if (message.labels != null && message.hasOwnProperty("labels"))
            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
              writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
          return writer;
        };

        /**
         * Encodes the specified ListenRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListenRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {google.firestore.v1beta1.IListenRequest} message ListenRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListenRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListenRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListenRequest} ListenRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListenRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListenRequest(), key;
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.database = reader.string();
                break;
              case 2:
                message.addTarget = $root.google.firestore.v1beta1.Target.decode(reader, reader.uint32());
                break;
              case 3:
                message.removeTarget = reader.int32();
                break;
              case 4:
                reader.skip().pos++;
                if (message.labels === $util.emptyObject)
                  message.labels = {};
                key = reader.string();
                reader.pos++;
                message.labels[key] = reader.string();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListenRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListenRequest} ListenRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListenRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListenRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListenRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.database != null && message.hasOwnProperty("database"))
            if (!$util.isString(message.database))
              return "database: string expected";
          if (message.addTarget != null && message.hasOwnProperty("addTarget")) {
            properties.targetChange = 1;
            {
              var error = $root.google.firestore.v1beta1.Target.verify(message.addTarget);
              if (error)
                return "addTarget." + error;
            }
          }
          if (message.removeTarget != null && message.hasOwnProperty("removeTarget")) {
            if (properties.targetChange === 1)
              return "targetChange: multiple values";
            properties.targetChange = 1;
            if (!$util.isInteger(message.removeTarget))
              return "removeTarget: integer expected";
          }
          if (message.labels != null && message.hasOwnProperty("labels")) {
            if (!$util.isObject(message.labels))
              return "labels: object expected";
            var key = Object.keys(message.labels);
            for (var i = 0; i < key.length; ++i)
              if (!$util.isString(message.labels[key[i]]))
                return "labels: string{k:string} expected";
          }
          return null;
        };

        /**
         * Creates a ListenRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListenRequest} ListenRequest
         */
        ListenRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListenRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.ListenRequest();
          if (object.database != null)
            message.database = String(object.database);
          if (object.addTarget != null) {
            if (typeof object.addTarget !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenRequest.addTarget: object expected");
            message.addTarget = $root.google.firestore.v1beta1.Target.fromObject(object.addTarget);
          }
          if (object.removeTarget != null)
            message.removeTarget = object.removeTarget | 0;
          if (object.labels) {
            if (typeof object.labels !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenRequest.labels: object expected");
            message.labels = {};
            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
              message.labels[keys[i]] = String(object.labels[keys[i]]);
          }
          return message;
        };

        /**
         * Creates a plain object from a ListenRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListenRequest
         * @static
         * @param {google.firestore.v1beta1.ListenRequest} message ListenRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListenRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.objects || options.defaults)
            object.labels = {};
          if (options.defaults)
            object.database = "";
          if (message.database != null && message.hasOwnProperty("database"))
            object.database = message.database;
          if (message.addTarget != null && message.hasOwnProperty("addTarget")) {
            object.addTarget = $root.google.firestore.v1beta1.Target.toObject(message.addTarget, options);
            if (options.oneofs)
              object.targetChange = "addTarget";
          }
          if (message.removeTarget != null && message.hasOwnProperty("removeTarget")) {
            object.removeTarget = message.removeTarget;
            if (options.oneofs)
              object.targetChange = "removeTarget";
          }
          var keys2;
          if (message.labels && (keys2 = Object.keys(message.labels)).length) {
            object.labels = {};
            for (var j = 0; j < keys2.length; ++j)
              object.labels[keys2[j]] = message.labels[keys2[j]];
          }
          return object;
        };

        /**
         * Converts this ListenRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListenRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListenRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListenRequest;
      })();

      v1beta1.ListenResponse = (function() {

        /**
         * Properties of a ListenResponse.
         * @memberof google.firestore.v1beta1
         * @interface IListenResponse
         * @property {google.firestore.v1beta1.ITargetChange|null} [targetChange] ListenResponse targetChange
         * @property {google.firestore.v1beta1.IDocumentChange|null} [documentChange] ListenResponse documentChange
         * @property {google.firestore.v1beta1.IDocumentDelete|null} [documentDelete] ListenResponse documentDelete
         * @property {google.firestore.v1beta1.IDocumentRemove|null} [documentRemove] ListenResponse documentRemove
         * @property {google.firestore.v1beta1.IExistenceFilter|null} [filter] ListenResponse filter
         */

        /**
         * Constructs a new ListenResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListenResponse.
         * @implements IListenResponse
         * @constructor
         * @param {google.firestore.v1beta1.IListenResponse=} [properties] Properties to set
         */
        function ListenResponse(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListenResponse targetChange.
         * @member {google.firestore.v1beta1.ITargetChange|null|undefined} targetChange
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        ListenResponse.prototype.targetChange = null;

        /**
         * ListenResponse documentChange.
         * @member {google.firestore.v1beta1.IDocumentChange|null|undefined} documentChange
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        ListenResponse.prototype.documentChange = null;

        /**
         * ListenResponse documentDelete.
         * @member {google.firestore.v1beta1.IDocumentDelete|null|undefined} documentDelete
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        ListenResponse.prototype.documentDelete = null;

        /**
         * ListenResponse documentRemove.
         * @member {google.firestore.v1beta1.IDocumentRemove|null|undefined} documentRemove
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        ListenResponse.prototype.documentRemove = null;

        /**
         * ListenResponse filter.
         * @member {google.firestore.v1beta1.IExistenceFilter|null|undefined} filter
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        ListenResponse.prototype.filter = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ListenResponse responseType.
         * @member {"targetChange"|"documentChange"|"documentDelete"|"documentRemove"|"filter"|undefined} responseType
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         */
        Object.defineProperty(ListenResponse.prototype, "responseType", {
          get: $util.oneOfGetter($oneOfFields = ["targetChange", "documentChange", "documentDelete", "documentRemove", "filter"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ListenResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {google.firestore.v1beta1.IListenResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListenResponse} ListenResponse instance
         */
        ListenResponse.create = function create(properties) {
          return new ListenResponse(properties);
        };

        /**
         * Encodes the specified ListenResponse message. Does not implicitly {@link google.firestore.v1beta1.ListenResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {google.firestore.v1beta1.IListenResponse} message ListenResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListenResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.targetChange != null && message.hasOwnProperty("targetChange"))
            $root.google.firestore.v1beta1.TargetChange.encode(message.targetChange, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.documentChange != null && message.hasOwnProperty("documentChange"))
            $root.google.firestore.v1beta1.DocumentChange.encode(message.documentChange, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.documentDelete != null && message.hasOwnProperty("documentDelete"))
            $root.google.firestore.v1beta1.DocumentDelete.encode(message.documentDelete, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          if (message.filter != null && message.hasOwnProperty("filter"))
            $root.google.firestore.v1beta1.ExistenceFilter.encode(message.filter, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
          if (message.documentRemove != null && message.hasOwnProperty("documentRemove"))
            $root.google.firestore.v1beta1.DocumentRemove.encode(message.documentRemove, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified ListenResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListenResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {google.firestore.v1beta1.IListenResponse} message ListenResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListenResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListenResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListenResponse} ListenResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListenResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListenResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 2:
                message.targetChange = $root.google.firestore.v1beta1.TargetChange.decode(reader, reader.uint32());
                break;
              case 3:
                message.documentChange = $root.google.firestore.v1beta1.DocumentChange.decode(reader, reader.uint32());
                break;
              case 4:
                message.documentDelete = $root.google.firestore.v1beta1.DocumentDelete.decode(reader, reader.uint32());
                break;
              case 6:
                message.documentRemove = $root.google.firestore.v1beta1.DocumentRemove.decode(reader, reader.uint32());
                break;
              case 5:
                message.filter = $root.google.firestore.v1beta1.ExistenceFilter.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListenResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListenResponse} ListenResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListenResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListenResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListenResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.targetChange != null && message.hasOwnProperty("targetChange")) {
            properties.responseType = 1;
            {
              var error = $root.google.firestore.v1beta1.TargetChange.verify(message.targetChange);
              if (error)
                return "targetChange." + error;
            }
          }
          if (message.documentChange != null && message.hasOwnProperty("documentChange")) {
            if (properties.responseType === 1)
              return "responseType: multiple values";
            properties.responseType = 1;
            {
              var error = $root.google.firestore.v1beta1.DocumentChange.verify(message.documentChange);
              if (error)
                return "documentChange." + error;
            }
          }
          if (message.documentDelete != null && message.hasOwnProperty("documentDelete")) {
            if (properties.responseType === 1)
              return "responseType: multiple values";
            properties.responseType = 1;
            {
              var error = $root.google.firestore.v1beta1.DocumentDelete.verify(message.documentDelete);
              if (error)
                return "documentDelete." + error;
            }
          }
          if (message.documentRemove != null && message.hasOwnProperty("documentRemove")) {
            if (properties.responseType === 1)
              return "responseType: multiple values";
            properties.responseType = 1;
            {
              var error = $root.google.firestore.v1beta1.DocumentRemove.verify(message.documentRemove);
              if (error)
                return "documentRemove." + error;
            }
          }
          if (message.filter != null && message.hasOwnProperty("filter")) {
            if (properties.responseType === 1)
              return "responseType: multiple values";
            properties.responseType = 1;
            {
              var error = $root.google.firestore.v1beta1.ExistenceFilter.verify(message.filter);
              if (error)
                return "filter." + error;
            }
          }
          return null;
        };

        /**
         * Creates a ListenResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListenResponse} ListenResponse
         */
        ListenResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListenResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.ListenResponse();
          if (object.targetChange != null) {
            if (typeof object.targetChange !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenResponse.targetChange: object expected");
            message.targetChange = $root.google.firestore.v1beta1.TargetChange.fromObject(object.targetChange);
          }
          if (object.documentChange != null) {
            if (typeof object.documentChange !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenResponse.documentChange: object expected");
            message.documentChange = $root.google.firestore.v1beta1.DocumentChange.fromObject(object.documentChange);
          }
          if (object.documentDelete != null) {
            if (typeof object.documentDelete !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenResponse.documentDelete: object expected");
            message.documentDelete = $root.google.firestore.v1beta1.DocumentDelete.fromObject(object.documentDelete);
          }
          if (object.documentRemove != null) {
            if (typeof object.documentRemove !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenResponse.documentRemove: object expected");
            message.documentRemove = $root.google.firestore.v1beta1.DocumentRemove.fromObject(object.documentRemove);
          }
          if (object.filter != null) {
            if (typeof object.filter !== "object")
              throw TypeError(".google.firestore.v1beta1.ListenResponse.filter: object expected");
            message.filter = $root.google.firestore.v1beta1.ExistenceFilter.fromObject(object.filter);
          }
          return message;
        };

        /**
         * Creates a plain object from a ListenResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListenResponse
         * @static
         * @param {google.firestore.v1beta1.ListenResponse} message ListenResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListenResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (message.targetChange != null && message.hasOwnProperty("targetChange")) {
            object.targetChange = $root.google.firestore.v1beta1.TargetChange.toObject(message.targetChange, options);
            if (options.oneofs)
              object.responseType = "targetChange";
          }
          if (message.documentChange != null && message.hasOwnProperty("documentChange")) {
            object.documentChange = $root.google.firestore.v1beta1.DocumentChange.toObject(message.documentChange, options);
            if (options.oneofs)
              object.responseType = "documentChange";
          }
          if (message.documentDelete != null && message.hasOwnProperty("documentDelete")) {
            object.documentDelete = $root.google.firestore.v1beta1.DocumentDelete.toObject(message.documentDelete, options);
            if (options.oneofs)
              object.responseType = "documentDelete";
          }
          if (message.filter != null && message.hasOwnProperty("filter")) {
            object.filter = $root.google.firestore.v1beta1.ExistenceFilter.toObject(message.filter, options);
            if (options.oneofs)
              object.responseType = "filter";
          }
          if (message.documentRemove != null && message.hasOwnProperty("documentRemove")) {
            object.documentRemove = $root.google.firestore.v1beta1.DocumentRemove.toObject(message.documentRemove, options);
            if (options.oneofs)
              object.responseType = "documentRemove";
          }
          return object;
        };

        /**
         * Converts this ListenResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListenResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListenResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListenResponse;
      })();

      v1beta1.Target = (function() {

        /**
         * Properties of a Target.
         * @memberof google.firestore.v1beta1
         * @interface ITarget
         * @property {google.firestore.v1beta1.Target.IQueryTarget|null} [query] Target query
         * @property {google.firestore.v1beta1.Target.IDocumentsTarget|null} [documents] Target documents
         * @property {Uint8Array|null} [resumeToken] Target resumeToken
         * @property {google.protobuf.ITimestamp|null} [readTime] Target readTime
         * @property {number|null} [targetId] Target targetId
         * @property {boolean|null} [once] Target once
         */

        /**
         * Constructs a new Target.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Target.
         * @implements ITarget
         * @constructor
         * @param {google.firestore.v1beta1.ITarget=} [properties] Properties to set
         */
        function Target(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Target query.
         * @member {google.firestore.v1beta1.Target.IQueryTarget|null|undefined} query
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.query = null;

        /**
         * Target documents.
         * @member {google.firestore.v1beta1.Target.IDocumentsTarget|null|undefined} documents
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.documents = null;

        /**
         * Target resumeToken.
         * @member {Uint8Array} resumeToken
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.resumeToken = $util.newBuffer([]);

        /**
         * Target readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.readTime = null;

        /**
         * Target targetId.
         * @member {number} targetId
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.targetId = 0;

        /**
         * Target once.
         * @member {boolean} once
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Target.prototype.once = false;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * Target targetType.
         * @member {"query"|"documents"|undefined} targetType
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Object.defineProperty(Target.prototype, "targetType", {
          get: $util.oneOfGetter($oneOfFields = ["query", "documents"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Target resumeType.
         * @member {"resumeToken"|"readTime"|undefined} resumeType
         * @memberof google.firestore.v1beta1.Target
         * @instance
         */
        Object.defineProperty(Target.prototype, "resumeType", {
          get: $util.oneOfGetter($oneOfFields = ["resumeToken", "readTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Target instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {google.firestore.v1beta1.ITarget=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Target} Target instance
         */
        Target.create = function create(properties) {
          return new Target(properties);
        };

        /**
         * Encodes the specified Target message. Does not implicitly {@link google.firestore.v1beta1.Target.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {google.firestore.v1beta1.ITarget} message Target message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Target.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.query != null && message.hasOwnProperty("query"))
            $root.google.firestore.v1beta1.Target.QueryTarget.encode(message.query, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.documents != null && message.hasOwnProperty("documents"))
            $root.google.firestore.v1beta1.Target.DocumentsTarget.encode(message.documents, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken"))
            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.resumeToken);
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.targetId);
          if (message.once != null && message.hasOwnProperty("once"))
            writer.uint32(/* id 6, wireType 0 =*/48).bool(message.once);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified Target message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Target.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {google.firestore.v1beta1.ITarget} message Target message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Target.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Target message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Target} Target
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Target.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Target();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 2:
                message.query = $root.google.firestore.v1beta1.Target.QueryTarget.decode(reader, reader.uint32());
                break;
              case 3:
                message.documents = $root.google.firestore.v1beta1.Target.DocumentsTarget.decode(reader, reader.uint32());
                break;
              case 4:
                message.resumeToken = reader.bytes();
                break;
              case 11:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 5:
                message.targetId = reader.int32();
                break;
              case 6:
                message.once = reader.bool();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Target message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Target} Target
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Target.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Target message.
         * @function verify
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Target.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.query != null && message.hasOwnProperty("query")) {
            properties.targetType = 1;
            {
              var error = $root.google.firestore.v1beta1.Target.QueryTarget.verify(message.query);
              if (error)
                return "query." + error;
            }
          }
          if (message.documents != null && message.hasOwnProperty("documents")) {
            if (properties.targetType === 1)
              return "targetType: multiple values";
            properties.targetType = 1;
            {
              var error = $root.google.firestore.v1beta1.Target.DocumentsTarget.verify(message.documents);
              if (error)
                return "documents." + error;
            }
          }
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken")) {
            properties.resumeType = 1;
            if (!(message.resumeToken && typeof message.resumeToken.length === "number" || $util.isString(message.resumeToken)))
              return "resumeToken: buffer expected";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            if (properties.resumeType === 1)
              return "resumeType: multiple values";
            properties.resumeType = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.readTime);
              if (error)
                return "readTime." + error;
            }
          }
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            if (!$util.isInteger(message.targetId))
              return "targetId: integer expected";
          if (message.once != null && message.hasOwnProperty("once"))
            if (typeof message.once !== "boolean")
              return "once: boolean expected";
          return null;
        };

        /**
         * Creates a Target message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Target} Target
         */
        Target.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Target)
            return object;
          var message = new $root.google.firestore.v1beta1.Target();
          if (object.query != null) {
            if (typeof object.query !== "object")
              throw TypeError(".google.firestore.v1beta1.Target.query: object expected");
            message.query = $root.google.firestore.v1beta1.Target.QueryTarget.fromObject(object.query);
          }
          if (object.documents != null) {
            if (typeof object.documents !== "object")
              throw TypeError(".google.firestore.v1beta1.Target.documents: object expected");
            message.documents = $root.google.firestore.v1beta1.Target.DocumentsTarget.fromObject(object.documents);
          }
          if (object.resumeToken != null)
            if (typeof object.resumeToken === "string")
              $util.base64.decode(object.resumeToken, message.resumeToken = $util.newBuffer($util.base64.length(object.resumeToken)), 0);
            else if (object.resumeToken.length)
              message.resumeToken = object.resumeToken;
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.Target.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          if (object.targetId != null)
            message.targetId = object.targetId | 0;
          if (object.once != null)
            message.once = Boolean(object.once);
          return message;
        };

        /**
         * Creates a plain object from a Target message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Target
         * @static
         * @param {google.firestore.v1beta1.Target} message Target
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Target.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.targetId = 0;
            object.once = false;
          }
          if (message.query != null && message.hasOwnProperty("query")) {
            object.query = $root.google.firestore.v1beta1.Target.QueryTarget.toObject(message.query, options);
            if (options.oneofs)
              object.targetType = "query";
          }
          if (message.documents != null && message.hasOwnProperty("documents")) {
            object.documents = $root.google.firestore.v1beta1.Target.DocumentsTarget.toObject(message.documents, options);
            if (options.oneofs)
              object.targetType = "documents";
          }
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken")) {
            object.resumeToken = options.bytes === String ? $util.base64.encode(message.resumeToken, 0, message.resumeToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.resumeToken) : message.resumeToken;
            if (options.oneofs)
              object.resumeType = "resumeToken";
          }
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            object.targetId = message.targetId;
          if (message.once != null && message.hasOwnProperty("once"))
            object.once = message.once;
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
            if (options.oneofs)
              object.resumeType = "readTime";
          }
          return object;
        };

        /**
         * Converts this Target to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Target
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Target.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Target.DocumentsTarget = (function() {

          /**
           * Properties of a DocumentsTarget.
           * @memberof google.firestore.v1beta1.Target
           * @interface IDocumentsTarget
           * @property {Array.<string>|null} [documents] DocumentsTarget documents
           */

          /**
           * Constructs a new DocumentsTarget.
           * @memberof google.firestore.v1beta1.Target
           * @classdesc Represents a DocumentsTarget.
           * @implements IDocumentsTarget
           * @constructor
           * @param {google.firestore.v1beta1.Target.IDocumentsTarget=} [properties] Properties to set
           */
          function DocumentsTarget(properties) {
            this.documents = [];
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * DocumentsTarget documents.
           * @member {Array.<string>} documents
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @instance
           */
          DocumentsTarget.prototype.documents = $util.emptyArray;

          /**
           * Creates a new DocumentsTarget instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IDocumentsTarget=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.Target.DocumentsTarget} DocumentsTarget instance
           */
          DocumentsTarget.create = function create(properties) {
            return new DocumentsTarget(properties);
          };

          /**
           * Encodes the specified DocumentsTarget message. Does not implicitly {@link google.firestore.v1beta1.Target.DocumentsTarget.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IDocumentsTarget} message DocumentsTarget message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          DocumentsTarget.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.documents != null && message.documents.length)
              for (var i = 0; i < message.documents.length; ++i)
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.documents[i]);
            return writer;
          };

          /**
           * Encodes the specified DocumentsTarget message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Target.DocumentsTarget.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IDocumentsTarget} message DocumentsTarget message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          DocumentsTarget.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a DocumentsTarget message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.Target.DocumentsTarget} DocumentsTarget
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          DocumentsTarget.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Target.DocumentsTarget();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 2:
                  if (!(message.documents && message.documents.length))
                    message.documents = [];
                  message.documents.push(reader.string());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a DocumentsTarget message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.Target.DocumentsTarget} DocumentsTarget
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          DocumentsTarget.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a DocumentsTarget message.
           * @function verify
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          DocumentsTarget.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.documents != null && message.hasOwnProperty("documents")) {
              if (!Array.isArray(message.documents))
                return "documents: array expected";
              for (var i = 0; i < message.documents.length; ++i)
                if (!$util.isString(message.documents[i]))
                  return "documents: string[] expected";
            }
            return null;
          };

          /**
           * Creates a DocumentsTarget message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.Target.DocumentsTarget} DocumentsTarget
           */
          DocumentsTarget.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.Target.DocumentsTarget)
              return object;
            var message = new $root.google.firestore.v1beta1.Target.DocumentsTarget();
            if (object.documents) {
              if (!Array.isArray(object.documents))
                throw TypeError(".google.firestore.v1beta1.Target.DocumentsTarget.documents: array expected");
              message.documents = [];
              for (var i = 0; i < object.documents.length; ++i)
                message.documents[i] = String(object.documents[i]);
            }
            return message;
          };

          /**
           * Creates a plain object from a DocumentsTarget message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @static
           * @param {google.firestore.v1beta1.Target.DocumentsTarget} message DocumentsTarget
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          DocumentsTarget.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.arrays || options.defaults)
              object.documents = [];
            if (message.documents && message.documents.length) {
              object.documents = [];
              for (var j = 0; j < message.documents.length; ++j)
                object.documents[j] = message.documents[j];
            }
            return object;
          };

          /**
           * Converts this DocumentsTarget to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.Target.DocumentsTarget
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          DocumentsTarget.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return DocumentsTarget;
        })();

        Target.QueryTarget = (function() {

          /**
           * Properties of a QueryTarget.
           * @memberof google.firestore.v1beta1.Target
           * @interface IQueryTarget
           * @property {string|null} [parent] QueryTarget parent
           * @property {google.firestore.v1beta1.IStructuredQuery|null} [structuredQuery] QueryTarget structuredQuery
           */

          /**
           * Constructs a new QueryTarget.
           * @memberof google.firestore.v1beta1.Target
           * @classdesc Represents a QueryTarget.
           * @implements IQueryTarget
           * @constructor
           * @param {google.firestore.v1beta1.Target.IQueryTarget=} [properties] Properties to set
           */
          function QueryTarget(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * QueryTarget parent.
           * @member {string} parent
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @instance
           */
          QueryTarget.prototype.parent = "";

          /**
           * QueryTarget structuredQuery.
           * @member {google.firestore.v1beta1.IStructuredQuery|null|undefined} structuredQuery
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @instance
           */
          QueryTarget.prototype.structuredQuery = null;

          // OneOf field names bound to virtual getters and setters
          var $oneOfFields;

          /**
           * QueryTarget queryType.
           * @member {"structuredQuery"|undefined} queryType
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @instance
           */
          Object.defineProperty(QueryTarget.prototype, "queryType", {
            get: $util.oneOfGetter($oneOfFields = ["structuredQuery"]),
            set: $util.oneOfSetter($oneOfFields)
          });

          /**
           * Creates a new QueryTarget instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IQueryTarget=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.Target.QueryTarget} QueryTarget instance
           */
          QueryTarget.create = function create(properties) {
            return new QueryTarget(properties);
          };

          /**
           * Encodes the specified QueryTarget message. Does not implicitly {@link google.firestore.v1beta1.Target.QueryTarget.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IQueryTarget} message QueryTarget message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          QueryTarget.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.parent != null && message.hasOwnProperty("parent"))
              writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
            if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery"))
              $root.google.firestore.v1beta1.StructuredQuery.encode(message.structuredQuery, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified QueryTarget message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Target.QueryTarget.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {google.firestore.v1beta1.Target.IQueryTarget} message QueryTarget message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          QueryTarget.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a QueryTarget message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.Target.QueryTarget} QueryTarget
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          QueryTarget.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Target.QueryTarget();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.parent = reader.string();
                  break;
                case 2:
                  message.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a QueryTarget message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.Target.QueryTarget} QueryTarget
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          QueryTarget.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a QueryTarget message.
           * @function verify
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          QueryTarget.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            var properties = {};
            if (message.parent != null && message.hasOwnProperty("parent"))
              if (!$util.isString(message.parent))
                return "parent: string expected";
            if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery")) {
              properties.queryType = 1;
              {
                var error = $root.google.firestore.v1beta1.StructuredQuery.verify(message.structuredQuery);
                if (error)
                  return "structuredQuery." + error;
              }
            }
            return null;
          };

          /**
           * Creates a QueryTarget message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.Target.QueryTarget} QueryTarget
           */
          QueryTarget.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.Target.QueryTarget)
              return object;
            var message = new $root.google.firestore.v1beta1.Target.QueryTarget();
            if (object.parent != null)
              message.parent = String(object.parent);
            if (object.structuredQuery != null) {
              if (typeof object.structuredQuery !== "object")
                throw TypeError(".google.firestore.v1beta1.Target.QueryTarget.structuredQuery: object expected");
              message.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.fromObject(object.structuredQuery);
            }
            return message;
          };

          /**
           * Creates a plain object from a QueryTarget message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @static
           * @param {google.firestore.v1beta1.Target.QueryTarget} message QueryTarget
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          QueryTarget.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults)
              object.parent = "";
            if (message.parent != null && message.hasOwnProperty("parent"))
              object.parent = message.parent;
            if (message.structuredQuery != null && message.hasOwnProperty("structuredQuery")) {
              object.structuredQuery = $root.google.firestore.v1beta1.StructuredQuery.toObject(message.structuredQuery, options);
              if (options.oneofs)
                object.queryType = "structuredQuery";
            }
            return object;
          };

          /**
           * Converts this QueryTarget to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.Target.QueryTarget
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          QueryTarget.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return QueryTarget;
        })();

        return Target;
      })();

      v1beta1.TargetChange = (function() {

        /**
         * Properties of a TargetChange.
         * @memberof google.firestore.v1beta1
         * @interface ITargetChange
         * @property {google.firestore.v1beta1.TargetChange.TargetChangeType|null} [targetChangeType] TargetChange targetChangeType
         * @property {Array.<number>|null} [targetIds] TargetChange targetIds
         * @property {google.rpc.IStatus|null} [cause] TargetChange cause
         * @property {Uint8Array|null} [resumeToken] TargetChange resumeToken
         * @property {google.protobuf.ITimestamp|null} [readTime] TargetChange readTime
         */

        /**
         * Constructs a new TargetChange.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a TargetChange.
         * @implements ITargetChange
         * @constructor
         * @param {google.firestore.v1beta1.ITargetChange=} [properties] Properties to set
         */
        function TargetChange(properties) {
          this.targetIds = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * TargetChange targetChangeType.
         * @member {google.firestore.v1beta1.TargetChange.TargetChangeType} targetChangeType
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         */
        TargetChange.prototype.targetChangeType = 0;

        /**
         * TargetChange targetIds.
         * @member {Array.<number>} targetIds
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         */
        TargetChange.prototype.targetIds = $util.emptyArray;

        /**
         * TargetChange cause.
         * @member {google.rpc.IStatus|null|undefined} cause
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         */
        TargetChange.prototype.cause = null;

        /**
         * TargetChange resumeToken.
         * @member {Uint8Array} resumeToken
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         */
        TargetChange.prototype.resumeToken = $util.newBuffer([]);

        /**
         * TargetChange readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         */
        TargetChange.prototype.readTime = null;

        /**
         * Creates a new TargetChange instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {google.firestore.v1beta1.ITargetChange=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.TargetChange} TargetChange instance
         */
        TargetChange.create = function create(properties) {
          return new TargetChange(properties);
        };

        /**
         * Encodes the specified TargetChange message. Does not implicitly {@link google.firestore.v1beta1.TargetChange.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {google.firestore.v1beta1.ITargetChange} message TargetChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TargetChange.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.targetChangeType != null && message.hasOwnProperty("targetChangeType"))
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.targetChangeType);
          if (message.targetIds != null && message.targetIds.length) {
            writer.uint32(/* id 2, wireType 2 =*/18).fork();
            for (var i = 0; i < message.targetIds.length; ++i)
              writer.int32(message.targetIds[i]);
            writer.ldelim();
          }
          if (message.cause != null && message.hasOwnProperty("cause"))
            $root.google.rpc.Status.encode(message.cause, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken"))
            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.resumeToken);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified TargetChange message, length delimited. Does not implicitly {@link google.firestore.v1beta1.TargetChange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {google.firestore.v1beta1.ITargetChange} message TargetChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TargetChange.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TargetChange message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.TargetChange} TargetChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TargetChange.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.TargetChange();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.targetChangeType = reader.int32();
                break;
              case 2:
                if (!(message.targetIds && message.targetIds.length))
                  message.targetIds = [];
                if ((tag & 7) === 2) {
                  var end2 = reader.uint32() + reader.pos;
                  while (reader.pos < end2)
                    message.targetIds.push(reader.int32());
                } else
                  message.targetIds.push(reader.int32());
                break;
              case 3:
                message.cause = $root.google.rpc.Status.decode(reader, reader.uint32());
                break;
              case 4:
                message.resumeToken = reader.bytes();
                break;
              case 6:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a TargetChange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.TargetChange} TargetChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TargetChange.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TargetChange message.
         * @function verify
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TargetChange.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.targetChangeType != null && message.hasOwnProperty("targetChangeType"))
            switch (message.targetChangeType) {
              default:
                return "targetChangeType: enum value expected";
              case 0:
              case 1:
              case 2:
              case 3:
              case 4:
                break;
            }
          if (message.targetIds != null && message.hasOwnProperty("targetIds")) {
            if (!Array.isArray(message.targetIds))
              return "targetIds: array expected";
            for (var i = 0; i < message.targetIds.length; ++i)
              if (!$util.isInteger(message.targetIds[i]))
                return "targetIds: integer[] expected";
          }
          if (message.cause != null && message.hasOwnProperty("cause")) {
            var error = $root.google.rpc.Status.verify(message.cause);
            if (error)
              return "cause." + error;
          }
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken"))
            if (!(message.resumeToken && typeof message.resumeToken.length === "number" || $util.isString(message.resumeToken)))
              return "resumeToken: buffer expected";
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.readTime);
            if (error)
              return "readTime." + error;
          }
          return null;
        };

        /**
         * Creates a TargetChange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.TargetChange} TargetChange
         */
        TargetChange.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.TargetChange)
            return object;
          var message = new $root.google.firestore.v1beta1.TargetChange();
          switch (object.targetChangeType) {
            case "NO_CHANGE":
            case 0:
              message.targetChangeType = 0;
              break;
            case "ADD":
            case 1:
              message.targetChangeType = 1;
              break;
            case "REMOVE":
            case 2:
              message.targetChangeType = 2;
              break;
            case "CURRENT":
            case 3:
              message.targetChangeType = 3;
              break;
            case "RESET":
            case 4:
              message.targetChangeType = 4;
              break;
          }
          if (object.targetIds) {
            if (!Array.isArray(object.targetIds))
              throw TypeError(".google.firestore.v1beta1.TargetChange.targetIds: array expected");
            message.targetIds = [];
            for (var i = 0; i < object.targetIds.length; ++i)
              message.targetIds[i] = object.targetIds[i] | 0;
          }
          if (object.cause != null) {
            if (typeof object.cause !== "object")
              throw TypeError(".google.firestore.v1beta1.TargetChange.cause: object expected");
            message.cause = $root.google.rpc.Status.fromObject(object.cause);
          }
          if (object.resumeToken != null)
            if (typeof object.resumeToken === "string")
              $util.base64.decode(object.resumeToken, message.resumeToken = $util.newBuffer($util.base64.length(object.resumeToken)), 0);
            else if (object.resumeToken.length)
              message.resumeToken = object.resumeToken;
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.TargetChange.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a TargetChange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.TargetChange
         * @static
         * @param {google.firestore.v1beta1.TargetChange} message TargetChange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TargetChange.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.targetIds = [];
          if (options.defaults) {
            object.targetChangeType = options.enums === String ? "NO_CHANGE" : 0;
            object.cause = null;
            object.resumeToken = options.bytes === String ? "" : [];
            object.readTime = null;
          }
          if (message.targetChangeType != null && message.hasOwnProperty("targetChangeType"))
            object.targetChangeType = options.enums === String ? $root.google.firestore.v1beta1.TargetChange.TargetChangeType[message.targetChangeType] : message.targetChangeType;
          if (message.targetIds && message.targetIds.length) {
            object.targetIds = [];
            for (var j = 0; j < message.targetIds.length; ++j)
              object.targetIds[j] = message.targetIds[j];
          }
          if (message.cause != null && message.hasOwnProperty("cause"))
            object.cause = $root.google.rpc.Status.toObject(message.cause, options);
          if (message.resumeToken != null && message.hasOwnProperty("resumeToken"))
            object.resumeToken = options.bytes === String ? $util.base64.encode(message.resumeToken, 0, message.resumeToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.resumeToken) : message.resumeToken;
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
          return object;
        };

        /**
         * Converts this TargetChange to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.TargetChange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TargetChange.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * TargetChangeType enum.
         * @name google.firestore.v1beta1.TargetChange.TargetChangeType
         * @enum {string}
         * @property {number} NO_CHANGE=0 NO_CHANGE value
         * @property {number} ADD=1 ADD value
         * @property {number} REMOVE=2 REMOVE value
         * @property {number} CURRENT=3 CURRENT value
         * @property {number} RESET=4 RESET value
         */
        TargetChange.TargetChangeType = (function() {
          var valuesById = {}, values = Object.create(valuesById);
          values[valuesById[0] = "NO_CHANGE"] = 0;
          values[valuesById[1] = "ADD"] = 1;
          values[valuesById[2] = "REMOVE"] = 2;
          values[valuesById[3] = "CURRENT"] = 3;
          values[valuesById[4] = "RESET"] = 4;
          return values;
        })();

        return TargetChange;
      })();

      v1beta1.ListCollectionIdsRequest = (function() {

        /**
         * Properties of a ListCollectionIdsRequest.
         * @memberof google.firestore.v1beta1
         * @interface IListCollectionIdsRequest
         * @property {string|null} [parent] ListCollectionIdsRequest parent
         * @property {number|null} [pageSize] ListCollectionIdsRequest pageSize
         * @property {string|null} [pageToken] ListCollectionIdsRequest pageToken
         */

        /**
         * Constructs a new ListCollectionIdsRequest.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListCollectionIdsRequest.
         * @implements IListCollectionIdsRequest
         * @constructor
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest=} [properties] Properties to set
         */
        function ListCollectionIdsRequest(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListCollectionIdsRequest parent.
         * @member {string} parent
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @instance
         */
        ListCollectionIdsRequest.prototype.parent = "";

        /**
         * ListCollectionIdsRequest pageSize.
         * @member {number} pageSize
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @instance
         */
        ListCollectionIdsRequest.prototype.pageSize = 0;

        /**
         * ListCollectionIdsRequest pageToken.
         * @member {string} pageToken
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @instance
         */
        ListCollectionIdsRequest.prototype.pageToken = "";

        /**
         * Creates a new ListCollectionIdsRequest instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListCollectionIdsRequest} ListCollectionIdsRequest instance
         */
        ListCollectionIdsRequest.create = function create(properties) {
          return new ListCollectionIdsRequest(properties);
        };

        /**
         * Encodes the specified ListCollectionIdsRequest message. Does not implicitly {@link google.firestore.v1beta1.ListCollectionIdsRequest.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest} message ListCollectionIdsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListCollectionIdsRequest.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.parent != null && message.hasOwnProperty("parent"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
          return writer;
        };

        /**
         * Encodes the specified ListCollectionIdsRequest message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListCollectionIdsRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsRequest} message ListCollectionIdsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListCollectionIdsRequest.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListCollectionIdsRequest message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListCollectionIdsRequest} ListCollectionIdsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListCollectionIdsRequest.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListCollectionIdsRequest();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.parent = reader.string();
                break;
              case 2:
                message.pageSize = reader.int32();
                break;
              case 3:
                message.pageToken = reader.string();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListCollectionIdsRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListCollectionIdsRequest} ListCollectionIdsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListCollectionIdsRequest.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListCollectionIdsRequest message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListCollectionIdsRequest.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.parent != null && message.hasOwnProperty("parent"))
            if (!$util.isString(message.parent))
              return "parent: string expected";
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            if (!$util.isInteger(message.pageSize))
              return "pageSize: integer expected";
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            if (!$util.isString(message.pageToken))
              return "pageToken: string expected";
          return null;
        };

        /**
         * Creates a ListCollectionIdsRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListCollectionIdsRequest} ListCollectionIdsRequest
         */
        ListCollectionIdsRequest.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListCollectionIdsRequest)
            return object;
          var message = new $root.google.firestore.v1beta1.ListCollectionIdsRequest();
          if (object.parent != null)
            message.parent = String(object.parent);
          if (object.pageSize != null)
            message.pageSize = object.pageSize | 0;
          if (object.pageToken != null)
            message.pageToken = String(object.pageToken);
          return message;
        };

        /**
         * Creates a plain object from a ListCollectionIdsRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @static
         * @param {google.firestore.v1beta1.ListCollectionIdsRequest} message ListCollectionIdsRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListCollectionIdsRequest.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.parent = "";
            object.pageSize = 0;
            object.pageToken = "";
          }
          if (message.parent != null && message.hasOwnProperty("parent"))
            object.parent = message.parent;
          if (message.pageSize != null && message.hasOwnProperty("pageSize"))
            object.pageSize = message.pageSize;
          if (message.pageToken != null && message.hasOwnProperty("pageToken"))
            object.pageToken = message.pageToken;
          return object;
        };

        /**
         * Converts this ListCollectionIdsRequest to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListCollectionIdsRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListCollectionIdsRequest.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListCollectionIdsRequest;
      })();

      v1beta1.ListCollectionIdsResponse = (function() {

        /**
         * Properties of a ListCollectionIdsResponse.
         * @memberof google.firestore.v1beta1
         * @interface IListCollectionIdsResponse
         * @property {Array.<string>|null} [collectionIds] ListCollectionIdsResponse collectionIds
         * @property {string|null} [nextPageToken] ListCollectionIdsResponse nextPageToken
         */

        /**
         * Constructs a new ListCollectionIdsResponse.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a ListCollectionIdsResponse.
         * @implements IListCollectionIdsResponse
         * @constructor
         * @param {google.firestore.v1beta1.IListCollectionIdsResponse=} [properties] Properties to set
         */
        function ListCollectionIdsResponse(properties) {
          this.collectionIds = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListCollectionIdsResponse collectionIds.
         * @member {Array.<string>} collectionIds
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @instance
         */
        ListCollectionIdsResponse.prototype.collectionIds = $util.emptyArray;

        /**
         * ListCollectionIdsResponse nextPageToken.
         * @member {string} nextPageToken
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @instance
         */
        ListCollectionIdsResponse.prototype.nextPageToken = "";

        /**
         * Creates a new ListCollectionIdsResponse instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsResponse=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ListCollectionIdsResponse} ListCollectionIdsResponse instance
         */
        ListCollectionIdsResponse.create = function create(properties) {
          return new ListCollectionIdsResponse(properties);
        };

        /**
         * Encodes the specified ListCollectionIdsResponse message. Does not implicitly {@link google.firestore.v1beta1.ListCollectionIdsResponse.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsResponse} message ListCollectionIdsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListCollectionIdsResponse.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.collectionIds != null && message.collectionIds.length)
            for (var i = 0; i < message.collectionIds.length; ++i)
              writer.uint32(/* id 1, wireType 2 =*/10).string(message.collectionIds[i]);
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
          return writer;
        };

        /**
         * Encodes the specified ListCollectionIdsResponse message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ListCollectionIdsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {google.firestore.v1beta1.IListCollectionIdsResponse} message ListCollectionIdsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListCollectionIdsResponse.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListCollectionIdsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ListCollectionIdsResponse} ListCollectionIdsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListCollectionIdsResponse.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ListCollectionIdsResponse();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.collectionIds && message.collectionIds.length))
                  message.collectionIds = [];
                message.collectionIds.push(reader.string());
                break;
              case 2:
                message.nextPageToken = reader.string();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ListCollectionIdsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ListCollectionIdsResponse} ListCollectionIdsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListCollectionIdsResponse.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListCollectionIdsResponse message.
         * @function verify
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListCollectionIdsResponse.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.collectionIds != null && message.hasOwnProperty("collectionIds")) {
            if (!Array.isArray(message.collectionIds))
              return "collectionIds: array expected";
            for (var i = 0; i < message.collectionIds.length; ++i)
              if (!$util.isString(message.collectionIds[i]))
                return "collectionIds: string[] expected";
          }
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            if (!$util.isString(message.nextPageToken))
              return "nextPageToken: string expected";
          return null;
        };

        /**
         * Creates a ListCollectionIdsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ListCollectionIdsResponse} ListCollectionIdsResponse
         */
        ListCollectionIdsResponse.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ListCollectionIdsResponse)
            return object;
          var message = new $root.google.firestore.v1beta1.ListCollectionIdsResponse();
          if (object.collectionIds) {
            if (!Array.isArray(object.collectionIds))
              throw TypeError(".google.firestore.v1beta1.ListCollectionIdsResponse.collectionIds: array expected");
            message.collectionIds = [];
            for (var i = 0; i < object.collectionIds.length; ++i)
              message.collectionIds[i] = String(object.collectionIds[i]);
          }
          if (object.nextPageToken != null)
            message.nextPageToken = String(object.nextPageToken);
          return message;
        };

        /**
         * Creates a plain object from a ListCollectionIdsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @static
         * @param {google.firestore.v1beta1.ListCollectionIdsResponse} message ListCollectionIdsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListCollectionIdsResponse.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.collectionIds = [];
          if (options.defaults)
            object.nextPageToken = "";
          if (message.collectionIds && message.collectionIds.length) {
            object.collectionIds = [];
            for (var j = 0; j < message.collectionIds.length; ++j)
              object.collectionIds[j] = message.collectionIds[j];
          }
          if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
            object.nextPageToken = message.nextPageToken;
          return object;
        };

        /**
         * Converts this ListCollectionIdsResponse to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ListCollectionIdsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListCollectionIdsResponse.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ListCollectionIdsResponse;
      })();

      v1beta1.DocumentMask = (function() {

        /**
         * Properties of a DocumentMask.
         * @memberof google.firestore.v1beta1
         * @interface IDocumentMask
         * @property {Array.<string>|null} [fieldPaths] DocumentMask fieldPaths
         */

        /**
         * Constructs a new DocumentMask.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DocumentMask.
         * @implements IDocumentMask
         * @constructor
         * @param {google.firestore.v1beta1.IDocumentMask=} [properties] Properties to set
         */
        function DocumentMask(properties) {
          this.fieldPaths = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentMask fieldPaths.
         * @member {Array.<string>} fieldPaths
         * @memberof google.firestore.v1beta1.DocumentMask
         * @instance
         */
        DocumentMask.prototype.fieldPaths = $util.emptyArray;

        /**
         * Creates a new DocumentMask instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {google.firestore.v1beta1.IDocumentMask=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DocumentMask} DocumentMask instance
         */
        DocumentMask.create = function create(properties) {
          return new DocumentMask(properties);
        };

        /**
         * Encodes the specified DocumentMask message. Does not implicitly {@link google.firestore.v1beta1.DocumentMask.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {google.firestore.v1beta1.IDocumentMask} message DocumentMask message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMask.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.fieldPaths != null && message.fieldPaths.length)
            for (var i = 0; i < message.fieldPaths.length; ++i)
              writer.uint32(/* id 1, wireType 2 =*/10).string(message.fieldPaths[i]);
          return writer;
        };

        /**
         * Encodes the specified DocumentMask message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentMask.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {google.firestore.v1beta1.IDocumentMask} message DocumentMask message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMask.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentMask message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DocumentMask} DocumentMask
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMask.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentMask();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.fieldPaths && message.fieldPaths.length))
                  message.fieldPaths = [];
                message.fieldPaths.push(reader.string());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DocumentMask message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DocumentMask} DocumentMask
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMask.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentMask message.
         * @function verify
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentMask.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.fieldPaths != null && message.hasOwnProperty("fieldPaths")) {
            if (!Array.isArray(message.fieldPaths))
              return "fieldPaths: array expected";
            for (var i = 0; i < message.fieldPaths.length; ++i)
              if (!$util.isString(message.fieldPaths[i]))
                return "fieldPaths: string[] expected";
          }
          return null;
        };

        /**
         * Creates a DocumentMask message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DocumentMask} DocumentMask
         */
        DocumentMask.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DocumentMask)
            return object;
          var message = new $root.google.firestore.v1beta1.DocumentMask();
          if (object.fieldPaths) {
            if (!Array.isArray(object.fieldPaths))
              throw TypeError(".google.firestore.v1beta1.DocumentMask.fieldPaths: array expected");
            message.fieldPaths = [];
            for (var i = 0; i < object.fieldPaths.length; ++i)
              message.fieldPaths[i] = String(object.fieldPaths[i]);
          }
          return message;
        };

        /**
         * Creates a plain object from a DocumentMask message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DocumentMask
         * @static
         * @param {google.firestore.v1beta1.DocumentMask} message DocumentMask
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentMask.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.fieldPaths = [];
          if (message.fieldPaths && message.fieldPaths.length) {
            object.fieldPaths = [];
            for (var j = 0; j < message.fieldPaths.length; ++j)
              object.fieldPaths[j] = message.fieldPaths[j];
          }
          return object;
        };

        /**
         * Converts this DocumentMask to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DocumentMask
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentMask.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentMask;
      })();

      v1beta1.Precondition = (function() {

        /**
         * Properties of a Precondition.
         * @memberof google.firestore.v1beta1
         * @interface IPrecondition
         * @property {boolean|null} [exists] Precondition exists
         * @property {google.protobuf.ITimestamp|null} [updateTime] Precondition updateTime
         */

        /**
         * Constructs a new Precondition.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Precondition.
         * @implements IPrecondition
         * @constructor
         * @param {google.firestore.v1beta1.IPrecondition=} [properties] Properties to set
         */
        function Precondition(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Precondition exists.
         * @member {boolean} exists
         * @memberof google.firestore.v1beta1.Precondition
         * @instance
         */
        Precondition.prototype.exists = false;

        /**
         * Precondition updateTime.
         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
         * @memberof google.firestore.v1beta1.Precondition
         * @instance
         */
        Precondition.prototype.updateTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * Precondition conditionType.
         * @member {"exists"|"updateTime"|undefined} conditionType
         * @memberof google.firestore.v1beta1.Precondition
         * @instance
         */
        Object.defineProperty(Precondition.prototype, "conditionType", {
          get: $util.oneOfGetter($oneOfFields = ["exists", "updateTime"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Precondition instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {google.firestore.v1beta1.IPrecondition=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Precondition} Precondition instance
         */
        Precondition.create = function create(properties) {
          return new Precondition(properties);
        };

        /**
         * Encodes the specified Precondition message. Does not implicitly {@link google.firestore.v1beta1.Precondition.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {google.firestore.v1beta1.IPrecondition} message Precondition message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Precondition.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.exists != null && message.hasOwnProperty("exists"))
            writer.uint32(/* id 1, wireType 0 =*/8).bool(message.exists);
          if (message.updateTime != null && message.hasOwnProperty("updateTime"))
            $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified Precondition message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Precondition.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {google.firestore.v1beta1.IPrecondition} message Precondition message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Precondition.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Precondition message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Precondition} Precondition
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Precondition.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Precondition();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.exists = reader.bool();
                break;
              case 2:
                message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Precondition message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Precondition} Precondition
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Precondition.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Precondition message.
         * @function verify
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Precondition.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.exists != null && message.hasOwnProperty("exists")) {
            properties.conditionType = 1;
            if (typeof message.exists !== "boolean")
              return "exists: boolean expected";
          }
          if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
            if (properties.conditionType === 1)
              return "conditionType: multiple values";
            properties.conditionType = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
              if (error)
                return "updateTime." + error;
            }
          }
          return null;
        };

        /**
         * Creates a Precondition message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Precondition} Precondition
         */
        Precondition.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Precondition)
            return object;
          var message = new $root.google.firestore.v1beta1.Precondition();
          if (object.exists != null)
            message.exists = Boolean(object.exists);
          if (object.updateTime != null) {
            if (typeof object.updateTime !== "object")
              throw TypeError(".google.firestore.v1beta1.Precondition.updateTime: object expected");
            message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a Precondition message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Precondition
         * @static
         * @param {google.firestore.v1beta1.Precondition} message Precondition
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Precondition.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (message.exists != null && message.hasOwnProperty("exists")) {
            object.exists = message.exists;
            if (options.oneofs)
              object.conditionType = "exists";
          }
          if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
            object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
            if (options.oneofs)
              object.conditionType = "updateTime";
          }
          return object;
        };

        /**
         * Converts this Precondition to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Precondition
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Precondition.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Precondition;
      })();

      v1beta1.TransactionOptions = (function() {

        /**
         * Properties of a TransactionOptions.
         * @memberof google.firestore.v1beta1
         * @interface ITransactionOptions
         * @property {google.firestore.v1beta1.TransactionOptions.IReadOnly|null} [readOnly] TransactionOptions readOnly
         * @property {google.firestore.v1beta1.TransactionOptions.IReadWrite|null} [readWrite] TransactionOptions readWrite
         */

        /**
         * Constructs a new TransactionOptions.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a TransactionOptions.
         * @implements ITransactionOptions
         * @constructor
         * @param {google.firestore.v1beta1.ITransactionOptions=} [properties] Properties to set
         */
        function TransactionOptions(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * TransactionOptions readOnly.
         * @member {google.firestore.v1beta1.TransactionOptions.IReadOnly|null|undefined} readOnly
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @instance
         */
        TransactionOptions.prototype.readOnly = null;

        /**
         * TransactionOptions readWrite.
         * @member {google.firestore.v1beta1.TransactionOptions.IReadWrite|null|undefined} readWrite
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @instance
         */
        TransactionOptions.prototype.readWrite = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * TransactionOptions mode.
         * @member {"readOnly"|"readWrite"|undefined} mode
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @instance
         */
        Object.defineProperty(TransactionOptions.prototype, "mode", {
          get: $util.oneOfGetter($oneOfFields = ["readOnly", "readWrite"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new TransactionOptions instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {google.firestore.v1beta1.ITransactionOptions=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.TransactionOptions} TransactionOptions instance
         */
        TransactionOptions.create = function create(properties) {
          return new TransactionOptions(properties);
        };

        /**
         * Encodes the specified TransactionOptions message. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {google.firestore.v1beta1.ITransactionOptions} message TransactionOptions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TransactionOptions.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.readOnly != null && message.hasOwnProperty("readOnly"))
            $root.google.firestore.v1beta1.TransactionOptions.ReadOnly.encode(message.readOnly, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.readWrite != null && message.hasOwnProperty("readWrite"))
            $root.google.firestore.v1beta1.TransactionOptions.ReadWrite.encode(message.readWrite, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified TransactionOptions message, length delimited. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {google.firestore.v1beta1.ITransactionOptions} message TransactionOptions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TransactionOptions.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TransactionOptions message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.TransactionOptions} TransactionOptions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TransactionOptions.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.TransactionOptions();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 2:
                message.readOnly = $root.google.firestore.v1beta1.TransactionOptions.ReadOnly.decode(reader, reader.uint32());
                break;
              case 3:
                message.readWrite = $root.google.firestore.v1beta1.TransactionOptions.ReadWrite.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a TransactionOptions message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.TransactionOptions} TransactionOptions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TransactionOptions.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TransactionOptions message.
         * @function verify
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TransactionOptions.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.readOnly != null && message.hasOwnProperty("readOnly")) {
            properties.mode = 1;
            {
              var error = $root.google.firestore.v1beta1.TransactionOptions.ReadOnly.verify(message.readOnly);
              if (error)
                return "readOnly." + error;
            }
          }
          if (message.readWrite != null && message.hasOwnProperty("readWrite")) {
            if (properties.mode === 1)
              return "mode: multiple values";
            properties.mode = 1;
            {
              var error = $root.google.firestore.v1beta1.TransactionOptions.ReadWrite.verify(message.readWrite);
              if (error)
                return "readWrite." + error;
            }
          }
          return null;
        };

        /**
         * Creates a TransactionOptions message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.TransactionOptions} TransactionOptions
         */
        TransactionOptions.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.TransactionOptions)
            return object;
          var message = new $root.google.firestore.v1beta1.TransactionOptions();
          if (object.readOnly != null) {
            if (typeof object.readOnly !== "object")
              throw TypeError(".google.firestore.v1beta1.TransactionOptions.readOnly: object expected");
            message.readOnly = $root.google.firestore.v1beta1.TransactionOptions.ReadOnly.fromObject(object.readOnly);
          }
          if (object.readWrite != null) {
            if (typeof object.readWrite !== "object")
              throw TypeError(".google.firestore.v1beta1.TransactionOptions.readWrite: object expected");
            message.readWrite = $root.google.firestore.v1beta1.TransactionOptions.ReadWrite.fromObject(object.readWrite);
          }
          return message;
        };

        /**
         * Creates a plain object from a TransactionOptions message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @static
         * @param {google.firestore.v1beta1.TransactionOptions} message TransactionOptions
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TransactionOptions.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (message.readOnly != null && message.hasOwnProperty("readOnly")) {
            object.readOnly = $root.google.firestore.v1beta1.TransactionOptions.ReadOnly.toObject(message.readOnly, options);
            if (options.oneofs)
              object.mode = "readOnly";
          }
          if (message.readWrite != null && message.hasOwnProperty("readWrite")) {
            object.readWrite = $root.google.firestore.v1beta1.TransactionOptions.ReadWrite.toObject(message.readWrite, options);
            if (options.oneofs)
              object.mode = "readWrite";
          }
          return object;
        };

        /**
         * Converts this TransactionOptions to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.TransactionOptions
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TransactionOptions.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        TransactionOptions.ReadWrite = (function() {

          /**
           * Properties of a ReadWrite.
           * @memberof google.firestore.v1beta1.TransactionOptions
           * @interface IReadWrite
           * @property {Uint8Array|null} [retryTransaction] ReadWrite retryTransaction
           */

          /**
           * Constructs a new ReadWrite.
           * @memberof google.firestore.v1beta1.TransactionOptions
           * @classdesc Represents a ReadWrite.
           * @implements IReadWrite
           * @constructor
           * @param {google.firestore.v1beta1.TransactionOptions.IReadWrite=} [properties] Properties to set
           */
          function ReadWrite(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * ReadWrite retryTransaction.
           * @member {Uint8Array} retryTransaction
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @instance
           */
          ReadWrite.prototype.retryTransaction = $util.newBuffer([]);

          /**
           * Creates a new ReadWrite instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadWrite=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadWrite} ReadWrite instance
           */
          ReadWrite.create = function create(properties) {
            return new ReadWrite(properties);
          };

          /**
           * Encodes the specified ReadWrite message. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.ReadWrite.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadWrite} message ReadWrite message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          ReadWrite.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.retryTransaction != null && message.hasOwnProperty("retryTransaction"))
              writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.retryTransaction);
            return writer;
          };

          /**
           * Encodes the specified ReadWrite message, length delimited. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.ReadWrite.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadWrite} message ReadWrite message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          ReadWrite.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a ReadWrite message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadWrite} ReadWrite
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          ReadWrite.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.TransactionOptions.ReadWrite();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.retryTransaction = reader.bytes();
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a ReadWrite message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadWrite} ReadWrite
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          ReadWrite.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a ReadWrite message.
           * @function verify
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          ReadWrite.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.retryTransaction != null && message.hasOwnProperty("retryTransaction"))
              if (!(message.retryTransaction && typeof message.retryTransaction.length === "number" || $util.isString(message.retryTransaction)))
                return "retryTransaction: buffer expected";
            return null;
          };

          /**
           * Creates a ReadWrite message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadWrite} ReadWrite
           */
          ReadWrite.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.TransactionOptions.ReadWrite)
              return object;
            var message = new $root.google.firestore.v1beta1.TransactionOptions.ReadWrite();
            if (object.retryTransaction != null)
              if (typeof object.retryTransaction === "string")
                $util.base64.decode(object.retryTransaction, message.retryTransaction = $util.newBuffer($util.base64.length(object.retryTransaction)), 0);
              else if (object.retryTransaction.length)
                message.retryTransaction = object.retryTransaction;
            return message;
          };

          /**
           * Creates a plain object from a ReadWrite message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.ReadWrite} message ReadWrite
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          ReadWrite.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults)
              object.retryTransaction = options.bytes === String ? "" : [];
            if (message.retryTransaction != null && message.hasOwnProperty("retryTransaction"))
              object.retryTransaction = options.bytes === String ? $util.base64.encode(message.retryTransaction, 0, message.retryTransaction.length) : options.bytes === Array ? Array.prototype.slice.call(message.retryTransaction) : message.retryTransaction;
            return object;
          };

          /**
           * Converts this ReadWrite to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadWrite
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          ReadWrite.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return ReadWrite;
        })();

        TransactionOptions.ReadOnly = (function() {

          /**
           * Properties of a ReadOnly.
           * @memberof google.firestore.v1beta1.TransactionOptions
           * @interface IReadOnly
           * @property {google.protobuf.ITimestamp|null} [readTime] ReadOnly readTime
           */

          /**
           * Constructs a new ReadOnly.
           * @memberof google.firestore.v1beta1.TransactionOptions
           * @classdesc Represents a ReadOnly.
           * @implements IReadOnly
           * @constructor
           * @param {google.firestore.v1beta1.TransactionOptions.IReadOnly=} [properties] Properties to set
           */
          function ReadOnly(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * ReadOnly readTime.
           * @member {google.protobuf.ITimestamp|null|undefined} readTime
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @instance
           */
          ReadOnly.prototype.readTime = null;

          // OneOf field names bound to virtual getters and setters
          var $oneOfFields;

          /**
           * ReadOnly consistencySelector.
           * @member {"readTime"|undefined} consistencySelector
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @instance
           */
          Object.defineProperty(ReadOnly.prototype, "consistencySelector", {
            get: $util.oneOfGetter($oneOfFields = ["readTime"]),
            set: $util.oneOfSetter($oneOfFields)
          });

          /**
           * Creates a new ReadOnly instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadOnly=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadOnly} ReadOnly instance
           */
          ReadOnly.create = function create(properties) {
            return new ReadOnly(properties);
          };

          /**
           * Encodes the specified ReadOnly message. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.ReadOnly.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadOnly} message ReadOnly message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          ReadOnly.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.readTime != null && message.hasOwnProperty("readTime"))
              $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified ReadOnly message, length delimited. Does not implicitly {@link google.firestore.v1beta1.TransactionOptions.ReadOnly.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.IReadOnly} message ReadOnly message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          ReadOnly.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a ReadOnly message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadOnly} ReadOnly
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          ReadOnly.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.TransactionOptions.ReadOnly();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 2:
                  message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a ReadOnly message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadOnly} ReadOnly
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          ReadOnly.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a ReadOnly message.
           * @function verify
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          ReadOnly.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            var properties = {};
            if (message.readTime != null && message.hasOwnProperty("readTime")) {
              properties.consistencySelector = 1;
              {
                var error = $root.google.protobuf.Timestamp.verify(message.readTime);
                if (error)
                  return "readTime." + error;
              }
            }
            return null;
          };

          /**
           * Creates a ReadOnly message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.TransactionOptions.ReadOnly} ReadOnly
           */
          ReadOnly.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.TransactionOptions.ReadOnly)
              return object;
            var message = new $root.google.firestore.v1beta1.TransactionOptions.ReadOnly();
            if (object.readTime != null) {
              if (typeof object.readTime !== "object")
                throw TypeError(".google.firestore.v1beta1.TransactionOptions.ReadOnly.readTime: object expected");
              message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
            }
            return message;
          };

          /**
           * Creates a plain object from a ReadOnly message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @static
           * @param {google.firestore.v1beta1.TransactionOptions.ReadOnly} message ReadOnly
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          ReadOnly.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (message.readTime != null && message.hasOwnProperty("readTime")) {
              object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
              if (options.oneofs)
                object.consistencySelector = "readTime";
            }
            return object;
          };

          /**
           * Converts this ReadOnly to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.TransactionOptions.ReadOnly
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          ReadOnly.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return ReadOnly;
        })();

        return TransactionOptions;
      })();

      v1beta1.Document = (function() {

        /**
         * Properties of a Document.
         * @memberof google.firestore.v1beta1
         * @interface IDocument
         * @property {string|null} [name] Document name
         * @property {Object.<string,google.firestore.v1beta1.IValue>|null} [fields] Document fields
         * @property {google.protobuf.ITimestamp|null} [createTime] Document createTime
         * @property {google.protobuf.ITimestamp|null} [updateTime] Document updateTime
         */

        /**
         * Constructs a new Document.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Document.
         * @implements IDocument
         * @constructor
         * @param {google.firestore.v1beta1.IDocument=} [properties] Properties to set
         */
        function Document(properties) {
          this.fields = {};
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Document name.
         * @member {string} name
         * @memberof google.firestore.v1beta1.Document
         * @instance
         */
        Document.prototype.name = "";

        /**
         * Document fields.
         * @member {Object.<string,google.firestore.v1beta1.IValue>} fields
         * @memberof google.firestore.v1beta1.Document
         * @instance
         */
        Document.prototype.fields = $util.emptyObject;

        /**
         * Document createTime.
         * @member {google.protobuf.ITimestamp|null|undefined} createTime
         * @memberof google.firestore.v1beta1.Document
         * @instance
         */
        Document.prototype.createTime = null;

        /**
         * Document updateTime.
         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
         * @memberof google.firestore.v1beta1.Document
         * @instance
         */
        Document.prototype.updateTime = null;

        /**
         * Creates a new Document instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {google.firestore.v1beta1.IDocument=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Document} Document instance
         */
        Document.create = function create(properties) {
          return new Document(properties);
        };

        /**
         * Encodes the specified Document message. Does not implicitly {@link google.firestore.v1beta1.Document.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {google.firestore.v1beta1.IDocument} message Document message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Document.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.name != null && message.hasOwnProperty("name"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
          if (message.fields != null && message.hasOwnProperty("fields"))
            for (var keys = Object.keys(message.fields), i = 0; i < keys.length; ++i) {
              writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
              $root.google.firestore.v1beta1.Value.encode(message.fields[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
            }
          if (message.createTime != null && message.hasOwnProperty("createTime"))
            $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.updateTime != null && message.hasOwnProperty("updateTime"))
            $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified Document message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Document.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {google.firestore.v1beta1.IDocument} message Document message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Document.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Document message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Document} Document
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Document.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Document(), key;
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.name = reader.string();
                break;
              case 2:
                reader.skip().pos++;
                if (message.fields === $util.emptyObject)
                  message.fields = {};
                key = reader.string();
                reader.pos++;
                message.fields[key] = $root.google.firestore.v1beta1.Value.decode(reader, reader.uint32());
                break;
              case 3:
                message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 4:
                message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Document message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Document} Document
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Document.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Document message.
         * @function verify
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Document.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.name != null && message.hasOwnProperty("name"))
            if (!$util.isString(message.name))
              return "name: string expected";
          if (message.fields != null && message.hasOwnProperty("fields")) {
            if (!$util.isObject(message.fields))
              return "fields: object expected";
            var key = Object.keys(message.fields);
            for (var i = 0; i < key.length; ++i) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.fields[key[i]]);
              if (error)
                return "fields." + error;
            }
          }
          if (message.createTime != null && message.hasOwnProperty("createTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.createTime);
            if (error)
              return "createTime." + error;
          }
          if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
            if (error)
              return "updateTime." + error;
          }
          return null;
        };

        /**
         * Creates a Document message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Document} Document
         */
        Document.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Document)
            return object;
          var message = new $root.google.firestore.v1beta1.Document();
          if (object.name != null)
            message.name = String(object.name);
          if (object.fields) {
            if (typeof object.fields !== "object")
              throw TypeError(".google.firestore.v1beta1.Document.fields: object expected");
            message.fields = {};
            for (var keys = Object.keys(object.fields), i = 0; i < keys.length; ++i) {
              if (typeof object.fields[keys[i]] !== "object")
                throw TypeError(".google.firestore.v1beta1.Document.fields: object expected");
              message.fields[keys[i]] = $root.google.firestore.v1beta1.Value.fromObject(object.fields[keys[i]]);
            }
          }
          if (object.createTime != null) {
            if (typeof object.createTime !== "object")
              throw TypeError(".google.firestore.v1beta1.Document.createTime: object expected");
            message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
          }
          if (object.updateTime != null) {
            if (typeof object.updateTime !== "object")
              throw TypeError(".google.firestore.v1beta1.Document.updateTime: object expected");
            message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a Document message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Document
         * @static
         * @param {google.firestore.v1beta1.Document} message Document
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Document.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.objects || options.defaults)
            object.fields = {};
          if (options.defaults) {
            object.name = "";
            object.createTime = null;
            object.updateTime = null;
          }
          if (message.name != null && message.hasOwnProperty("name"))
            object.name = message.name;
          var keys2;
          if (message.fields && (keys2 = Object.keys(message.fields)).length) {
            object.fields = {};
            for (var j = 0; j < keys2.length; ++j)
              object.fields[keys2[j]] = $root.google.firestore.v1beta1.Value.toObject(message.fields[keys2[j]], options);
          }
          if (message.createTime != null && message.hasOwnProperty("createTime"))
            object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
          if (message.updateTime != null && message.hasOwnProperty("updateTime"))
            object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
          return object;
        };

        /**
         * Converts this Document to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Document
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Document.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Document;
      })();

      v1beta1.Value = (function() {

        /**
         * Properties of a Value.
         * @memberof google.firestore.v1beta1
         * @interface IValue
         * @property {google.protobuf.NullValue|null} [nullValue] Value nullValue
         * @property {boolean|null} [booleanValue] Value booleanValue
         * @property {number|string|null} [integerValue] Value integerValue
         * @property {number|null} [doubleValue] Value doubleValue
         * @property {google.protobuf.ITimestamp|null} [timestampValue] Value timestampValue
         * @property {string|null} [stringValue] Value stringValue
         * @property {Uint8Array|null} [bytesValue] Value bytesValue
         * @property {string|null} [referenceValue] Value referenceValue
         * @property {google.type.ILatLng|null} [geoPointValue] Value geoPointValue
         * @property {google.firestore.v1beta1.IArrayValue|null} [arrayValue] Value arrayValue
         * @property {google.firestore.v1beta1.IMapValue|null} [mapValue] Value mapValue
         */

        /**
         * Constructs a new Value.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Value.
         * @implements IValue
         * @constructor
         * @param {google.firestore.v1beta1.IValue=} [properties] Properties to set
         */
        function Value(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Value nullValue.
         * @member {google.protobuf.NullValue} nullValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.nullValue = 0;

        /**
         * Value booleanValue.
         * @member {boolean} booleanValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.booleanValue = false;

        /**
         * Value integerValue.
         * @member {number|string} integerValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.integerValue = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Value doubleValue.
         * @member {number} doubleValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.doubleValue = 0;

        /**
         * Value timestampValue.
         * @member {google.protobuf.ITimestamp|null|undefined} timestampValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.timestampValue = null;

        /**
         * Value stringValue.
         * @member {string} stringValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.stringValue = "";

        /**
         * Value bytesValue.
         * @member {Uint8Array} bytesValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.bytesValue = $util.newBuffer([]);

        /**
         * Value referenceValue.
         * @member {string} referenceValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.referenceValue = "";

        /**
         * Value geoPointValue.
         * @member {google.type.ILatLng|null|undefined} geoPointValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.geoPointValue = null;

        /**
         * Value arrayValue.
         * @member {google.firestore.v1beta1.IArrayValue|null|undefined} arrayValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.arrayValue = null;

        /**
         * Value mapValue.
         * @member {google.firestore.v1beta1.IMapValue|null|undefined} mapValue
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Value.prototype.mapValue = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * Value valueType.
         * @member {"nullValue"|"booleanValue"|"integerValue"|"doubleValue"|"timestampValue"|"stringValue"|"bytesValue"|"referenceValue"|"geoPointValue"|"arrayValue"|"mapValue"|undefined} valueType
         * @memberof google.firestore.v1beta1.Value
         * @instance
         */
        Object.defineProperty(Value.prototype, "valueType", {
          get: $util.oneOfGetter($oneOfFields = ["nullValue", "booleanValue", "integerValue", "doubleValue", "timestampValue", "stringValue", "bytesValue", "referenceValue", "geoPointValue", "arrayValue", "mapValue"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Value instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {google.firestore.v1beta1.IValue=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Value} Value instance
         */
        Value.create = function create(properties) {
          return new Value(properties);
        };

        /**
         * Encodes the specified Value message. Does not implicitly {@link google.firestore.v1beta1.Value.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {google.firestore.v1beta1.IValue} message Value message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Value.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.booleanValue != null && message.hasOwnProperty("booleanValue"))
            writer.uint32(/* id 1, wireType 0 =*/8).bool(message.booleanValue);
          if (message.integerValue != null && message.hasOwnProperty("integerValue"))
            writer.uint32(/* id 2, wireType 0 =*/16).int64(message.integerValue);
          if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
            writer.uint32(/* id 3, wireType 1 =*/25).double(message.doubleValue);
          if (message.referenceValue != null && message.hasOwnProperty("referenceValue"))
            writer.uint32(/* id 5, wireType 2 =*/42).string(message.referenceValue);
          if (message.mapValue != null && message.hasOwnProperty("mapValue"))
            $root.google.firestore.v1beta1.MapValue.encode(message.mapValue, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
          if (message.geoPointValue != null && message.hasOwnProperty("geoPointValue"))
            $root.google.type.LatLng.encode(message.geoPointValue, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
          if (message.arrayValue != null && message.hasOwnProperty("arrayValue"))
            $root.google.firestore.v1beta1.ArrayValue.encode(message.arrayValue, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
          if (message.timestampValue != null && message.hasOwnProperty("timestampValue"))
            $root.google.protobuf.Timestamp.encode(message.timestampValue, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
          if (message.nullValue != null && message.hasOwnProperty("nullValue"))
            writer.uint32(/* id 11, wireType 0 =*/88).int32(message.nullValue);
          if (message.stringValue != null && message.hasOwnProperty("stringValue"))
            writer.uint32(/* id 17, wireType 2 =*/138).string(message.stringValue);
          if (message.bytesValue != null && message.hasOwnProperty("bytesValue"))
            writer.uint32(/* id 18, wireType 2 =*/146).bytes(message.bytesValue);
          return writer;
        };

        /**
         * Encodes the specified Value message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Value.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {google.firestore.v1beta1.IValue} message Value message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Value.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Value message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Value} Value
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Value.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Value();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 11:
                message.nullValue = reader.int32();
                break;
              case 1:
                message.booleanValue = reader.bool();
                break;
              case 2:
                message.integerValue = reader.int64();
                break;
              case 3:
                message.doubleValue = reader.double();
                break;
              case 10:
                message.timestampValue = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 17:
                message.stringValue = reader.string();
                break;
              case 18:
                message.bytesValue = reader.bytes();
                break;
              case 5:
                message.referenceValue = reader.string();
                break;
              case 8:
                message.geoPointValue = $root.google.type.LatLng.decode(reader, reader.uint32());
                break;
              case 9:
                message.arrayValue = $root.google.firestore.v1beta1.ArrayValue.decode(reader, reader.uint32());
                break;
              case 6:
                message.mapValue = $root.google.firestore.v1beta1.MapValue.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Value message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Value} Value
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Value.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Value message.
         * @function verify
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Value.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.nullValue != null && message.hasOwnProperty("nullValue")) {
            properties.valueType = 1;
            switch (message.nullValue) {
              default:
                return "nullValue: enum value expected";
              case 0:
                break;
            }
          }
          if (message.booleanValue != null && message.hasOwnProperty("booleanValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (typeof message.booleanValue !== "boolean")
              return "booleanValue: boolean expected";
          }
          if (message.integerValue != null && message.hasOwnProperty("integerValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (!$util.isInteger(message.integerValue) && !(message.integerValue && $util.isInteger(message.integerValue.low) && $util.isInteger(message.integerValue.high)))
              return "integerValue: integer|Long expected";
          }
          if (message.doubleValue != null && message.hasOwnProperty("doubleValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (typeof message.doubleValue !== "number")
              return "doubleValue: number expected";
          }
          if (message.timestampValue != null && message.hasOwnProperty("timestampValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            {
              var error = $root.google.protobuf.Timestamp.verify(message.timestampValue);
              if (error)
                return "timestampValue." + error;
            }
          }
          if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (!$util.isString(message.stringValue))
              return "stringValue: string expected";
          }
          if (message.bytesValue != null && message.hasOwnProperty("bytesValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (!(message.bytesValue && typeof message.bytesValue.length === "number" || $util.isString(message.bytesValue)))
              return "bytesValue: buffer expected";
          }
          if (message.referenceValue != null && message.hasOwnProperty("referenceValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            if (!$util.isString(message.referenceValue))
              return "referenceValue: string expected";
          }
          if (message.geoPointValue != null && message.hasOwnProperty("geoPointValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            {
              var error = $root.google.type.LatLng.verify(message.geoPointValue);
              if (error)
                return "geoPointValue." + error;
            }
          }
          if (message.arrayValue != null && message.hasOwnProperty("arrayValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            {
              var error = $root.google.firestore.v1beta1.ArrayValue.verify(message.arrayValue);
              if (error)
                return "arrayValue." + error;
            }
          }
          if (message.mapValue != null && message.hasOwnProperty("mapValue")) {
            if (properties.valueType === 1)
              return "valueType: multiple values";
            properties.valueType = 1;
            {
              var error = $root.google.firestore.v1beta1.MapValue.verify(message.mapValue);
              if (error)
                return "mapValue." + error;
            }
          }
          return null;
        };

        /**
         * Creates a Value message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Value} Value
         */
        Value.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Value)
            return object;
          var message = new $root.google.firestore.v1beta1.Value();
          switch (object.nullValue) {
            case "NULL_VALUE":
            case 0:
              message.nullValue = 0;
              break;
          }
          if (object.booleanValue != null)
            message.booleanValue = Boolean(object.booleanValue);
          if (object.integerValue != null)
            if ($util.Long)
              (message.integerValue = $util.Long.fromValue(object.integerValue)).unsigned = false;
            else if (typeof object.integerValue === "string")
              message.integerValue = parseInt(object.integerValue, 10);
            else if (typeof object.integerValue === "number")
              message.integerValue = object.integerValue;
            else if (typeof object.integerValue === "object")
              message.integerValue = new $util.LongBits(object.integerValue.low >>> 0, object.integerValue.high >>> 0).toNumber();
          if (object.doubleValue != null)
            message.doubleValue = Number(object.doubleValue);
          if (object.timestampValue != null) {
            if (typeof object.timestampValue !== "object")
              throw TypeError(".google.firestore.v1beta1.Value.timestampValue: object expected");
            message.timestampValue = $root.google.protobuf.Timestamp.fromObject(object.timestampValue);
          }
          if (object.stringValue != null)
            message.stringValue = String(object.stringValue);
          if (object.bytesValue != null)
            if (typeof object.bytesValue === "string")
              $util.base64.decode(object.bytesValue, message.bytesValue = $util.newBuffer($util.base64.length(object.bytesValue)), 0);
            else if (object.bytesValue.length)
              message.bytesValue = object.bytesValue;
          if (object.referenceValue != null)
            message.referenceValue = String(object.referenceValue);
          if (object.geoPointValue != null) {
            if (typeof object.geoPointValue !== "object")
              throw TypeError(".google.firestore.v1beta1.Value.geoPointValue: object expected");
            message.geoPointValue = $root.google.type.LatLng.fromObject(object.geoPointValue);
          }
          if (object.arrayValue != null) {
            if (typeof object.arrayValue !== "object")
              throw TypeError(".google.firestore.v1beta1.Value.arrayValue: object expected");
            message.arrayValue = $root.google.firestore.v1beta1.ArrayValue.fromObject(object.arrayValue);
          }
          if (object.mapValue != null) {
            if (typeof object.mapValue !== "object")
              throw TypeError(".google.firestore.v1beta1.Value.mapValue: object expected");
            message.mapValue = $root.google.firestore.v1beta1.MapValue.fromObject(object.mapValue);
          }
          return message;
        };

        /**
         * Creates a plain object from a Value message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Value
         * @static
         * @param {google.firestore.v1beta1.Value} message Value
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Value.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (message.booleanValue != null && message.hasOwnProperty("booleanValue")) {
            object.booleanValue = message.booleanValue;
            if (options.oneofs)
              object.valueType = "booleanValue";
          }
          if (message.integerValue != null && message.hasOwnProperty("integerValue")) {
            if (typeof message.integerValue === "number")
              object.integerValue = options.longs === String ? String(message.integerValue) : message.integerValue;
            else
              object.integerValue = options.longs === String ? $util.Long.prototype.toString.call(message.integerValue) : options.longs === Number ? new $util.LongBits(message.integerValue.low >>> 0, message.integerValue.high >>> 0).toNumber() : message.integerValue;
            if (options.oneofs)
              object.valueType = "integerValue";
          }
          if (message.doubleValue != null && message.hasOwnProperty("doubleValue")) {
            object.doubleValue = options.json && !isFinite(message.doubleValue) ? String(message.doubleValue) : message.doubleValue;
            if (options.oneofs)
              object.valueType = "doubleValue";
          }
          if (message.referenceValue != null && message.hasOwnProperty("referenceValue")) {
            object.referenceValue = message.referenceValue;
            if (options.oneofs)
              object.valueType = "referenceValue";
          }
          if (message.mapValue != null && message.hasOwnProperty("mapValue")) {
            object.mapValue = $root.google.firestore.v1beta1.MapValue.toObject(message.mapValue, options);
            if (options.oneofs)
              object.valueType = "mapValue";
          }
          if (message.geoPointValue != null && message.hasOwnProperty("geoPointValue")) {
            object.geoPointValue = $root.google.type.LatLng.toObject(message.geoPointValue, options);
            if (options.oneofs)
              object.valueType = "geoPointValue";
          }
          if (message.arrayValue != null && message.hasOwnProperty("arrayValue")) {
            object.arrayValue = $root.google.firestore.v1beta1.ArrayValue.toObject(message.arrayValue, options);
            if (options.oneofs)
              object.valueType = "arrayValue";
          }
          if (message.timestampValue != null && message.hasOwnProperty("timestampValue")) {
            object.timestampValue = $root.google.protobuf.Timestamp.toObject(message.timestampValue, options);
            if (options.oneofs)
              object.valueType = "timestampValue";
          }
          if (message.nullValue != null && message.hasOwnProperty("nullValue")) {
            object.nullValue = options.enums === String ? $root.google.protobuf.NullValue[message.nullValue] : message.nullValue;
            if (options.oneofs)
              object.valueType = "nullValue";
          }
          if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
            object.stringValue = message.stringValue;
            if (options.oneofs)
              object.valueType = "stringValue";
          }
          if (message.bytesValue != null && message.hasOwnProperty("bytesValue")) {
            object.bytesValue = options.bytes === String ? $util.base64.encode(message.bytesValue, 0, message.bytesValue.length) : options.bytes === Array ? Array.prototype.slice.call(message.bytesValue) : message.bytesValue;
            if (options.oneofs)
              object.valueType = "bytesValue";
          }
          return object;
        };

        /**
         * Converts this Value to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Value
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Value.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Value;
      })();

      v1beta1.ArrayValue = (function() {

        /**
         * Properties of an ArrayValue.
         * @memberof google.firestore.v1beta1
         * @interface IArrayValue
         * @property {Array.<google.firestore.v1beta1.IValue>|null} [values] ArrayValue values
         */

        /**
         * Constructs a new ArrayValue.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents an ArrayValue.
         * @implements IArrayValue
         * @constructor
         * @param {google.firestore.v1beta1.IArrayValue=} [properties] Properties to set
         */
        function ArrayValue(properties) {
          this.values = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ArrayValue values.
         * @member {Array.<google.firestore.v1beta1.IValue>} values
         * @memberof google.firestore.v1beta1.ArrayValue
         * @instance
         */
        ArrayValue.prototype.values = $util.emptyArray;

        /**
         * Creates a new ArrayValue instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {google.firestore.v1beta1.IArrayValue=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ArrayValue} ArrayValue instance
         */
        ArrayValue.create = function create(properties) {
          return new ArrayValue(properties);
        };

        /**
         * Encodes the specified ArrayValue message. Does not implicitly {@link google.firestore.v1beta1.ArrayValue.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {google.firestore.v1beta1.IArrayValue} message ArrayValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArrayValue.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.values != null && message.values.length)
            for (var i = 0; i < message.values.length; ++i)
              $root.google.firestore.v1beta1.Value.encode(message.values[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified ArrayValue message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ArrayValue.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {google.firestore.v1beta1.IArrayValue} message ArrayValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArrayValue.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ArrayValue message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ArrayValue} ArrayValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArrayValue.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ArrayValue();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.values && message.values.length))
                  message.values = [];
                message.values.push($root.google.firestore.v1beta1.Value.decode(reader, reader.uint32()));
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes an ArrayValue message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ArrayValue} ArrayValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArrayValue.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ArrayValue message.
         * @function verify
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ArrayValue.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.values != null && message.hasOwnProperty("values")) {
            if (!Array.isArray(message.values))
              return "values: array expected";
            for (var i = 0; i < message.values.length; ++i) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.values[i]);
              if (error)
                return "values." + error;
            }
          }
          return null;
        };

        /**
         * Creates an ArrayValue message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ArrayValue} ArrayValue
         */
        ArrayValue.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ArrayValue)
            return object;
          var message = new $root.google.firestore.v1beta1.ArrayValue();
          if (object.values) {
            if (!Array.isArray(object.values))
              throw TypeError(".google.firestore.v1beta1.ArrayValue.values: array expected");
            message.values = [];
            for (var i = 0; i < object.values.length; ++i) {
              if (typeof object.values[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.ArrayValue.values: object expected");
              message.values[i] = $root.google.firestore.v1beta1.Value.fromObject(object.values[i]);
            }
          }
          return message;
        };

        /**
         * Creates a plain object from an ArrayValue message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ArrayValue
         * @static
         * @param {google.firestore.v1beta1.ArrayValue} message ArrayValue
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ArrayValue.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.values = [];
          if (message.values && message.values.length) {
            object.values = [];
            for (var j = 0; j < message.values.length; ++j)
              object.values[j] = $root.google.firestore.v1beta1.Value.toObject(message.values[j], options);
          }
          return object;
        };

        /**
         * Converts this ArrayValue to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ArrayValue
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ArrayValue.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ArrayValue;
      })();

      v1beta1.MapValue = (function() {

        /**
         * Properties of a MapValue.
         * @memberof google.firestore.v1beta1
         * @interface IMapValue
         * @property {Object.<string,google.firestore.v1beta1.IValue>|null} [fields] MapValue fields
         */

        /**
         * Constructs a new MapValue.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a MapValue.
         * @implements IMapValue
         * @constructor
         * @param {google.firestore.v1beta1.IMapValue=} [properties] Properties to set
         */
        function MapValue(properties) {
          this.fields = {};
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * MapValue fields.
         * @member {Object.<string,google.firestore.v1beta1.IValue>} fields
         * @memberof google.firestore.v1beta1.MapValue
         * @instance
         */
        MapValue.prototype.fields = $util.emptyObject;

        /**
         * Creates a new MapValue instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {google.firestore.v1beta1.IMapValue=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.MapValue} MapValue instance
         */
        MapValue.create = function create(properties) {
          return new MapValue(properties);
        };

        /**
         * Encodes the specified MapValue message. Does not implicitly {@link google.firestore.v1beta1.MapValue.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {google.firestore.v1beta1.IMapValue} message MapValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MapValue.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.fields != null && message.hasOwnProperty("fields"))
            for (var keys = Object.keys(message.fields), i = 0; i < keys.length; ++i) {
              writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
              $root.google.firestore.v1beta1.Value.encode(message.fields[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
            }
          return writer;
        };

        /**
         * Encodes the specified MapValue message, length delimited. Does not implicitly {@link google.firestore.v1beta1.MapValue.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {google.firestore.v1beta1.IMapValue} message MapValue message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MapValue.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MapValue message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.MapValue} MapValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MapValue.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.MapValue(), key;
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                reader.skip().pos++;
                if (message.fields === $util.emptyObject)
                  message.fields = {};
                key = reader.string();
                reader.pos++;
                message.fields[key] = $root.google.firestore.v1beta1.Value.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a MapValue message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.MapValue} MapValue
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MapValue.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MapValue message.
         * @function verify
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MapValue.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.fields != null && message.hasOwnProperty("fields")) {
            if (!$util.isObject(message.fields))
              return "fields: object expected";
            var key = Object.keys(message.fields);
            for (var i = 0; i < key.length; ++i) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.fields[key[i]]);
              if (error)
                return "fields." + error;
            }
          }
          return null;
        };

        /**
         * Creates a MapValue message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.MapValue} MapValue
         */
        MapValue.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.MapValue)
            return object;
          var message = new $root.google.firestore.v1beta1.MapValue();
          if (object.fields) {
            if (typeof object.fields !== "object")
              throw TypeError(".google.firestore.v1beta1.MapValue.fields: object expected");
            message.fields = {};
            for (var keys = Object.keys(object.fields), i = 0; i < keys.length; ++i) {
              if (typeof object.fields[keys[i]] !== "object")
                throw TypeError(".google.firestore.v1beta1.MapValue.fields: object expected");
              message.fields[keys[i]] = $root.google.firestore.v1beta1.Value.fromObject(object.fields[keys[i]]);
            }
          }
          return message;
        };

        /**
         * Creates a plain object from a MapValue message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.MapValue
         * @static
         * @param {google.firestore.v1beta1.MapValue} message MapValue
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MapValue.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.objects || options.defaults)
            object.fields = {};
          var keys2;
          if (message.fields && (keys2 = Object.keys(message.fields)).length) {
            object.fields = {};
            for (var j = 0; j < keys2.length; ++j)
              object.fields[keys2[j]] = $root.google.firestore.v1beta1.Value.toObject(message.fields[keys2[j]], options);
          }
          return object;
        };

        /**
         * Converts this MapValue to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.MapValue
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MapValue.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MapValue;
      })();

      v1beta1.StructuredQuery = (function() {

        /**
         * Properties of a StructuredQuery.
         * @memberof google.firestore.v1beta1
         * @interface IStructuredQuery
         * @property {google.firestore.v1beta1.StructuredQuery.IProjection|null} [select] StructuredQuery select
         * @property {Array.<google.firestore.v1beta1.StructuredQuery.ICollectionSelector>|null} [from] StructuredQuery from
         * @property {google.firestore.v1beta1.StructuredQuery.IFilter|null} [where] StructuredQuery where
         * @property {Array.<google.firestore.v1beta1.StructuredQuery.IOrder>|null} [orderBy] StructuredQuery orderBy
         * @property {google.firestore.v1beta1.ICursor|null} [startAt] StructuredQuery startAt
         * @property {google.firestore.v1beta1.ICursor|null} [endAt] StructuredQuery endAt
         * @property {number|null} [offset] StructuredQuery offset
         * @property {google.protobuf.IInt32Value|null} [limit] StructuredQuery limit
         */

        /**
         * Constructs a new StructuredQuery.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a StructuredQuery.
         * @implements IStructuredQuery
         * @constructor
         * @param {google.firestore.v1beta1.IStructuredQuery=} [properties] Properties to set
         */
        function StructuredQuery(properties) {
          this.from = [];
          this.orderBy = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * StructuredQuery select.
         * @member {google.firestore.v1beta1.StructuredQuery.IProjection|null|undefined} select
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.select = null;

        /**
         * StructuredQuery from.
         * @member {Array.<google.firestore.v1beta1.StructuredQuery.ICollectionSelector>} from
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.from = $util.emptyArray;

        /**
         * StructuredQuery where.
         * @member {google.firestore.v1beta1.StructuredQuery.IFilter|null|undefined} where
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.where = null;

        /**
         * StructuredQuery orderBy.
         * @member {Array.<google.firestore.v1beta1.StructuredQuery.IOrder>} orderBy
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.orderBy = $util.emptyArray;

        /**
         * StructuredQuery startAt.
         * @member {google.firestore.v1beta1.ICursor|null|undefined} startAt
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.startAt = null;

        /**
         * StructuredQuery endAt.
         * @member {google.firestore.v1beta1.ICursor|null|undefined} endAt
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.endAt = null;

        /**
         * StructuredQuery offset.
         * @member {number} offset
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.offset = 0;

        /**
         * StructuredQuery limit.
         * @member {google.protobuf.IInt32Value|null|undefined} limit
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         */
        StructuredQuery.prototype.limit = null;

        /**
         * Creates a new StructuredQuery instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {google.firestore.v1beta1.IStructuredQuery=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.StructuredQuery} StructuredQuery instance
         */
        StructuredQuery.create = function create(properties) {
          return new StructuredQuery(properties);
        };

        /**
         * Encodes the specified StructuredQuery message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {google.firestore.v1beta1.IStructuredQuery} message StructuredQuery message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StructuredQuery.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.select != null && message.hasOwnProperty("select"))
            $root.google.firestore.v1beta1.StructuredQuery.Projection.encode(message.select, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.from != null && message.from.length)
            for (var i = 0; i < message.from.length; ++i)
              $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector.encode(message.from[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          if (message.where != null && message.hasOwnProperty("where"))
            $root.google.firestore.v1beta1.StructuredQuery.Filter.encode(message.where, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.orderBy != null && message.orderBy.length)
            for (var i = 0; i < message.orderBy.length; ++i)
              $root.google.firestore.v1beta1.StructuredQuery.Order.encode(message.orderBy[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          if (message.limit != null && message.hasOwnProperty("limit"))
            $root.google.protobuf.Int32Value.encode(message.limit, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
          if (message.offset != null && message.hasOwnProperty("offset"))
            writer.uint32(/* id 6, wireType 0 =*/48).int32(message.offset);
          if (message.startAt != null && message.hasOwnProperty("startAt"))
            $root.google.firestore.v1beta1.Cursor.encode(message.startAt, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
          if (message.endAt != null && message.hasOwnProperty("endAt"))
            $root.google.firestore.v1beta1.Cursor.encode(message.endAt, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified StructuredQuery message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {google.firestore.v1beta1.IStructuredQuery} message StructuredQuery message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StructuredQuery.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a StructuredQuery message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.StructuredQuery} StructuredQuery
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StructuredQuery.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.select = $root.google.firestore.v1beta1.StructuredQuery.Projection.decode(reader, reader.uint32());
                break;
              case 2:
                if (!(message.from && message.from.length))
                  message.from = [];
                message.from.push($root.google.firestore.v1beta1.StructuredQuery.CollectionSelector.decode(reader, reader.uint32()));
                break;
              case 3:
                message.where = $root.google.firestore.v1beta1.StructuredQuery.Filter.decode(reader, reader.uint32());
                break;
              case 4:
                if (!(message.orderBy && message.orderBy.length))
                  message.orderBy = [];
                message.orderBy.push($root.google.firestore.v1beta1.StructuredQuery.Order.decode(reader, reader.uint32()));
                break;
              case 7:
                message.startAt = $root.google.firestore.v1beta1.Cursor.decode(reader, reader.uint32());
                break;
              case 8:
                message.endAt = $root.google.firestore.v1beta1.Cursor.decode(reader, reader.uint32());
                break;
              case 6:
                message.offset = reader.int32();
                break;
              case 5:
                message.limit = $root.google.protobuf.Int32Value.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a StructuredQuery message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.StructuredQuery} StructuredQuery
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StructuredQuery.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a StructuredQuery message.
         * @function verify
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        StructuredQuery.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.select != null && message.hasOwnProperty("select")) {
            var error = $root.google.firestore.v1beta1.StructuredQuery.Projection.verify(message.select);
            if (error)
              return "select." + error;
          }
          if (message.from != null && message.hasOwnProperty("from")) {
            if (!Array.isArray(message.from))
              return "from: array expected";
            for (var i = 0; i < message.from.length; ++i) {
              var error = $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector.verify(message.from[i]);
              if (error)
                return "from." + error;
            }
          }
          if (message.where != null && message.hasOwnProperty("where")) {
            var error = $root.google.firestore.v1beta1.StructuredQuery.Filter.verify(message.where);
            if (error)
              return "where." + error;
          }
          if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
            if (!Array.isArray(message.orderBy))
              return "orderBy: array expected";
            for (var i = 0; i < message.orderBy.length; ++i) {
              var error = $root.google.firestore.v1beta1.StructuredQuery.Order.verify(message.orderBy[i]);
              if (error)
                return "orderBy." + error;
            }
          }
          if (message.startAt != null && message.hasOwnProperty("startAt")) {
            var error = $root.google.firestore.v1beta1.Cursor.verify(message.startAt);
            if (error)
              return "startAt." + error;
          }
          if (message.endAt != null && message.hasOwnProperty("endAt")) {
            var error = $root.google.firestore.v1beta1.Cursor.verify(message.endAt);
            if (error)
              return "endAt." + error;
          }
          if (message.offset != null && message.hasOwnProperty("offset"))
            if (!$util.isInteger(message.offset))
              return "offset: integer expected";
          if (message.limit != null && message.hasOwnProperty("limit")) {
            var error = $root.google.protobuf.Int32Value.verify(message.limit);
            if (error)
              return "limit." + error;
          }
          return null;
        };

        /**
         * Creates a StructuredQuery message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.StructuredQuery} StructuredQuery
         */
        StructuredQuery.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.StructuredQuery)
            return object;
          var message = new $root.google.firestore.v1beta1.StructuredQuery();
          if (object.select != null) {
            if (typeof object.select !== "object")
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.select: object expected");
            message.select = $root.google.firestore.v1beta1.StructuredQuery.Projection.fromObject(object.select);
          }
          if (object.from) {
            if (!Array.isArray(object.from))
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.from: array expected");
            message.from = [];
            for (var i = 0; i < object.from.length; ++i) {
              if (typeof object.from[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.from: object expected");
              message.from[i] = $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector.fromObject(object.from[i]);
            }
          }
          if (object.where != null) {
            if (typeof object.where !== "object")
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.where: object expected");
            message.where = $root.google.firestore.v1beta1.StructuredQuery.Filter.fromObject(object.where);
          }
          if (object.orderBy) {
            if (!Array.isArray(object.orderBy))
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.orderBy: array expected");
            message.orderBy = [];
            for (var i = 0; i < object.orderBy.length; ++i) {
              if (typeof object.orderBy[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.orderBy: object expected");
              message.orderBy[i] = $root.google.firestore.v1beta1.StructuredQuery.Order.fromObject(object.orderBy[i]);
            }
          }
          if (object.startAt != null) {
            if (typeof object.startAt !== "object")
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.startAt: object expected");
            message.startAt = $root.google.firestore.v1beta1.Cursor.fromObject(object.startAt);
          }
          if (object.endAt != null) {
            if (typeof object.endAt !== "object")
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.endAt: object expected");
            message.endAt = $root.google.firestore.v1beta1.Cursor.fromObject(object.endAt);
          }
          if (object.offset != null)
            message.offset = object.offset | 0;
          if (object.limit != null) {
            if (typeof object.limit !== "object")
              throw TypeError(".google.firestore.v1beta1.StructuredQuery.limit: object expected");
            message.limit = $root.google.protobuf.Int32Value.fromObject(object.limit);
          }
          return message;
        };

        /**
         * Creates a plain object from a StructuredQuery message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @static
         * @param {google.firestore.v1beta1.StructuredQuery} message StructuredQuery
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        StructuredQuery.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults) {
            object.from = [];
            object.orderBy = [];
          }
          if (options.defaults) {
            object.select = null;
            object.where = null;
            object.limit = null;
            object.offset = 0;
            object.startAt = null;
            object.endAt = null;
          }
          if (message.select != null && message.hasOwnProperty("select"))
            object.select = $root.google.firestore.v1beta1.StructuredQuery.Projection.toObject(message.select, options);
          if (message.from && message.from.length) {
            object.from = [];
            for (var j = 0; j < message.from.length; ++j)
              object.from[j] = $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector.toObject(message.from[j], options);
          }
          if (message.where != null && message.hasOwnProperty("where"))
            object.where = $root.google.firestore.v1beta1.StructuredQuery.Filter.toObject(message.where, options);
          if (message.orderBy && message.orderBy.length) {
            object.orderBy = [];
            for (var j = 0; j < message.orderBy.length; ++j)
              object.orderBy[j] = $root.google.firestore.v1beta1.StructuredQuery.Order.toObject(message.orderBy[j], options);
          }
          if (message.limit != null && message.hasOwnProperty("limit"))
            object.limit = $root.google.protobuf.Int32Value.toObject(message.limit, options);
          if (message.offset != null && message.hasOwnProperty("offset"))
            object.offset = message.offset;
          if (message.startAt != null && message.hasOwnProperty("startAt"))
            object.startAt = $root.google.firestore.v1beta1.Cursor.toObject(message.startAt, options);
          if (message.endAt != null && message.hasOwnProperty("endAt"))
            object.endAt = $root.google.firestore.v1beta1.Cursor.toObject(message.endAt, options);
          return object;
        };

        /**
         * Converts this StructuredQuery to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.StructuredQuery
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        StructuredQuery.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        StructuredQuery.CollectionSelector = (function() {

          /**
           * Properties of a CollectionSelector.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface ICollectionSelector
           * @property {string|null} [collectionId] CollectionSelector collectionId
           * @property {boolean|null} [allDescendants] CollectionSelector allDescendants
           */

          /**
           * Constructs a new CollectionSelector.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a CollectionSelector.
           * @implements ICollectionSelector
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.ICollectionSelector=} [properties] Properties to set
           */
          function CollectionSelector(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * CollectionSelector collectionId.
           * @member {string} collectionId
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @instance
           */
          CollectionSelector.prototype.collectionId = "";

          /**
           * CollectionSelector allDescendants.
           * @member {boolean} allDescendants
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @instance
           */
          CollectionSelector.prototype.allDescendants = false;

          /**
           * Creates a new CollectionSelector instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICollectionSelector=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.CollectionSelector} CollectionSelector instance
           */
          CollectionSelector.create = function create(properties) {
            return new CollectionSelector(properties);
          };

          /**
           * Encodes the specified CollectionSelector message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.CollectionSelector.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICollectionSelector} message CollectionSelector message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          CollectionSelector.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.collectionId != null && message.hasOwnProperty("collectionId"))
              writer.uint32(/* id 2, wireType 2 =*/18).string(message.collectionId);
            if (message.allDescendants != null && message.hasOwnProperty("allDescendants"))
              writer.uint32(/* id 3, wireType 0 =*/24).bool(message.allDescendants);
            return writer;
          };

          /**
           * Encodes the specified CollectionSelector message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.CollectionSelector.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICollectionSelector} message CollectionSelector message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          CollectionSelector.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a CollectionSelector message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.CollectionSelector} CollectionSelector
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          CollectionSelector.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 2:
                  message.collectionId = reader.string();
                  break;
                case 3:
                  message.allDescendants = reader.bool();
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a CollectionSelector message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.CollectionSelector} CollectionSelector
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          CollectionSelector.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a CollectionSelector message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          CollectionSelector.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.collectionId != null && message.hasOwnProperty("collectionId"))
              if (!$util.isString(message.collectionId))
                return "collectionId: string expected";
            if (message.allDescendants != null && message.hasOwnProperty("allDescendants"))
              if (typeof message.allDescendants !== "boolean")
                return "allDescendants: boolean expected";
            return null;
          };

          /**
           * Creates a CollectionSelector message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.CollectionSelector} CollectionSelector
           */
          CollectionSelector.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.CollectionSelector();
            if (object.collectionId != null)
              message.collectionId = String(object.collectionId);
            if (object.allDescendants != null)
              message.allDescendants = Boolean(object.allDescendants);
            return message;
          };

          /**
           * Creates a plain object from a CollectionSelector message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.CollectionSelector} message CollectionSelector
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          CollectionSelector.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults) {
              object.collectionId = "";
              object.allDescendants = false;
            }
            if (message.collectionId != null && message.hasOwnProperty("collectionId"))
              object.collectionId = message.collectionId;
            if (message.allDescendants != null && message.hasOwnProperty("allDescendants"))
              object.allDescendants = message.allDescendants;
            return object;
          };

          /**
           * Converts this CollectionSelector to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.CollectionSelector
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          CollectionSelector.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return CollectionSelector;
        })();

        StructuredQuery.Filter = (function() {

          /**
           * Properties of a Filter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IFilter
           * @property {google.firestore.v1beta1.StructuredQuery.ICompositeFilter|null} [compositeFilter] Filter compositeFilter
           * @property {google.firestore.v1beta1.StructuredQuery.IFieldFilter|null} [fieldFilter] Filter fieldFilter
           * @property {google.firestore.v1beta1.StructuredQuery.IUnaryFilter|null} [unaryFilter] Filter unaryFilter
           */

          /**
           * Constructs a new Filter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a Filter.
           * @implements IFilter
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IFilter=} [properties] Properties to set
           */
          function Filter(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * Filter compositeFilter.
           * @member {google.firestore.v1beta1.StructuredQuery.ICompositeFilter|null|undefined} compositeFilter
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @instance
           */
          Filter.prototype.compositeFilter = null;

          /**
           * Filter fieldFilter.
           * @member {google.firestore.v1beta1.StructuredQuery.IFieldFilter|null|undefined} fieldFilter
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @instance
           */
          Filter.prototype.fieldFilter = null;

          /**
           * Filter unaryFilter.
           * @member {google.firestore.v1beta1.StructuredQuery.IUnaryFilter|null|undefined} unaryFilter
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @instance
           */
          Filter.prototype.unaryFilter = null;

          // OneOf field names bound to virtual getters and setters
          var $oneOfFields;

          /**
           * Filter filterType.
           * @member {"compositeFilter"|"fieldFilter"|"unaryFilter"|undefined} filterType
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @instance
           */
          Object.defineProperty(Filter.prototype, "filterType", {
            get: $util.oneOfGetter($oneOfFields = ["compositeFilter", "fieldFilter", "unaryFilter"]),
            set: $util.oneOfSetter($oneOfFields)
          });

          /**
           * Creates a new Filter instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFilter=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.Filter} Filter instance
           */
          Filter.create = function create(properties) {
            return new Filter(properties);
          };

          /**
           * Encodes the specified Filter message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Filter.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFilter} message Filter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Filter.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.compositeFilter != null && message.hasOwnProperty("compositeFilter"))
              $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.encode(message.compositeFilter, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.fieldFilter != null && message.hasOwnProperty("fieldFilter"))
              $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.encode(message.fieldFilter, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.unaryFilter != null && message.hasOwnProperty("unaryFilter"))
              $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.encode(message.unaryFilter, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified Filter message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Filter.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFilter} message Filter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Filter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a Filter message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.Filter} Filter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Filter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.Filter();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.compositeFilter = $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.decode(reader, reader.uint32());
                  break;
                case 2:
                  message.fieldFilter = $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.decode(reader, reader.uint32());
                  break;
                case 3:
                  message.unaryFilter = $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a Filter message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.Filter} Filter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Filter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a Filter message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          Filter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            var properties = {};
            if (message.compositeFilter != null && message.hasOwnProperty("compositeFilter")) {
              properties.filterType = 1;
              {
                var error = $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.verify(message.compositeFilter);
                if (error)
                  return "compositeFilter." + error;
              }
            }
            if (message.fieldFilter != null && message.hasOwnProperty("fieldFilter")) {
              if (properties.filterType === 1)
                return "filterType: multiple values";
              properties.filterType = 1;
              {
                var error = $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.verify(message.fieldFilter);
                if (error)
                  return "fieldFilter." + error;
              }
            }
            if (message.unaryFilter != null && message.hasOwnProperty("unaryFilter")) {
              if (properties.filterType === 1)
                return "filterType: multiple values";
              properties.filterType = 1;
              {
                var error = $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.verify(message.unaryFilter);
                if (error)
                  return "unaryFilter." + error;
              }
            }
            return null;
          };

          /**
           * Creates a Filter message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.Filter} Filter
           */
          Filter.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.Filter)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.Filter();
            if (object.compositeFilter != null) {
              if (typeof object.compositeFilter !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.Filter.compositeFilter: object expected");
              message.compositeFilter = $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.fromObject(object.compositeFilter);
            }
            if (object.fieldFilter != null) {
              if (typeof object.fieldFilter !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.Filter.fieldFilter: object expected");
              message.fieldFilter = $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.fromObject(object.fieldFilter);
            }
            if (object.unaryFilter != null) {
              if (typeof object.unaryFilter !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.Filter.unaryFilter: object expected");
              message.unaryFilter = $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.fromObject(object.unaryFilter);
            }
            return message;
          };

          /**
           * Creates a plain object from a Filter message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.Filter} message Filter
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          Filter.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (message.compositeFilter != null && message.hasOwnProperty("compositeFilter")) {
              object.compositeFilter = $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.toObject(message.compositeFilter, options);
              if (options.oneofs)
                object.filterType = "compositeFilter";
            }
            if (message.fieldFilter != null && message.hasOwnProperty("fieldFilter")) {
              object.fieldFilter = $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.toObject(message.fieldFilter, options);
              if (options.oneofs)
                object.filterType = "fieldFilter";
            }
            if (message.unaryFilter != null && message.hasOwnProperty("unaryFilter")) {
              object.unaryFilter = $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.toObject(message.unaryFilter, options);
              if (options.oneofs)
                object.filterType = "unaryFilter";
            }
            return object;
          };

          /**
           * Converts this Filter to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.Filter
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          Filter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return Filter;
        })();

        StructuredQuery.CompositeFilter = (function() {

          /**
           * Properties of a CompositeFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface ICompositeFilter
           * @property {google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator|null} [op] CompositeFilter op
           * @property {Array.<google.firestore.v1beta1.StructuredQuery.IFilter>|null} [filters] CompositeFilter filters
           */

          /**
           * Constructs a new CompositeFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a CompositeFilter.
           * @implements ICompositeFilter
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.ICompositeFilter=} [properties] Properties to set
           */
          function CompositeFilter(properties) {
            this.filters = [];
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * CompositeFilter op.
           * @member {google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator} op
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @instance
           */
          CompositeFilter.prototype.op = 0;

          /**
           * CompositeFilter filters.
           * @member {Array.<google.firestore.v1beta1.StructuredQuery.IFilter>} filters
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @instance
           */
          CompositeFilter.prototype.filters = $util.emptyArray;

          /**
           * Creates a new CompositeFilter instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICompositeFilter=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.CompositeFilter} CompositeFilter instance
           */
          CompositeFilter.create = function create(properties) {
            return new CompositeFilter(properties);
          };

          /**
           * Encodes the specified CompositeFilter message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.CompositeFilter.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICompositeFilter} message CompositeFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          CompositeFilter.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.op != null && message.hasOwnProperty("op"))
              writer.uint32(/* id 1, wireType 0 =*/8).int32(message.op);
            if (message.filters != null && message.filters.length)
              for (var i = 0; i < message.filters.length; ++i)
                $root.google.firestore.v1beta1.StructuredQuery.Filter.encode(message.filters[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified CompositeFilter message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.CompositeFilter.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.ICompositeFilter} message CompositeFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          CompositeFilter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a CompositeFilter message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.CompositeFilter} CompositeFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          CompositeFilter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.op = reader.int32();
                  break;
                case 2:
                  if (!(message.filters && message.filters.length))
                    message.filters = [];
                  message.filters.push($root.google.firestore.v1beta1.StructuredQuery.Filter.decode(reader, reader.uint32()));
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a CompositeFilter message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.CompositeFilter} CompositeFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          CompositeFilter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a CompositeFilter message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          CompositeFilter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.op != null && message.hasOwnProperty("op"))
              switch (message.op) {
                default:
                  return "op: enum value expected";
                case 0:
                case 1:
                  break;
              }
            if (message.filters != null && message.hasOwnProperty("filters")) {
              if (!Array.isArray(message.filters))
                return "filters: array expected";
              for (var i = 0; i < message.filters.length; ++i) {
                var error = $root.google.firestore.v1beta1.StructuredQuery.Filter.verify(message.filters[i]);
                if (error)
                  return "filters." + error;
              }
            }
            return null;
          };

          /**
           * Creates a CompositeFilter message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.CompositeFilter} CompositeFilter
           */
          CompositeFilter.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter();
            switch (object.op) {
              case "OPERATOR_UNSPECIFIED":
              case 0:
                message.op = 0;
                break;
              case "AND":
              case 1:
                message.op = 1;
                break;
            }
            if (object.filters) {
              if (!Array.isArray(object.filters))
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.CompositeFilter.filters: array expected");
              message.filters = [];
              for (var i = 0; i < object.filters.length; ++i) {
                if (typeof object.filters[i] !== "object")
                  throw TypeError(".google.firestore.v1beta1.StructuredQuery.CompositeFilter.filters: object expected");
                message.filters[i] = $root.google.firestore.v1beta1.StructuredQuery.Filter.fromObject(object.filters[i]);
              }
            }
            return message;
          };

          /**
           * Creates a plain object from a CompositeFilter message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.CompositeFilter} message CompositeFilter
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          CompositeFilter.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.arrays || options.defaults)
              object.filters = [];
            if (options.defaults)
              object.op = options.enums === String ? "OPERATOR_UNSPECIFIED" : 0;
            if (message.op != null && message.hasOwnProperty("op"))
              object.op = options.enums === String ? $root.google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator[message.op] : message.op;
            if (message.filters && message.filters.length) {
              object.filters = [];
              for (var j = 0; j < message.filters.length; ++j)
                object.filters[j] = $root.google.firestore.v1beta1.StructuredQuery.Filter.toObject(message.filters[j], options);
            }
            return object;
          };

          /**
           * Converts this CompositeFilter to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.CompositeFilter
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          CompositeFilter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          /**
           * Operator enum.
           * @name google.firestore.v1beta1.StructuredQuery.CompositeFilter.Operator
           * @enum {string}
           * @property {number} OPERATOR_UNSPECIFIED=0 OPERATOR_UNSPECIFIED value
           * @property {number} AND=1 AND value
           */
          CompositeFilter.Operator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OPERATOR_UNSPECIFIED"] = 0;
            values[valuesById[1] = "AND"] = 1;
            return values;
          })();

          return CompositeFilter;
        })();

        StructuredQuery.FieldFilter = (function() {

          /**
           * Properties of a FieldFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IFieldFilter
           * @property {google.firestore.v1beta1.StructuredQuery.IFieldReference|null} [field] FieldFilter field
           * @property {google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator|null} [op] FieldFilter op
           * @property {google.firestore.v1beta1.IValue|null} [value] FieldFilter value
           */

          /**
           * Constructs a new FieldFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a FieldFilter.
           * @implements IFieldFilter
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldFilter=} [properties] Properties to set
           */
          function FieldFilter(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * FieldFilter field.
           * @member {google.firestore.v1beta1.StructuredQuery.IFieldReference|null|undefined} field
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @instance
           */
          FieldFilter.prototype.field = null;

          /**
           * FieldFilter op.
           * @member {google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator} op
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @instance
           */
          FieldFilter.prototype.op = 0;

          /**
           * FieldFilter value.
           * @member {google.firestore.v1beta1.IValue|null|undefined} value
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @instance
           */
          FieldFilter.prototype.value = null;

          /**
           * Creates a new FieldFilter instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldFilter=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldFilter} FieldFilter instance
           */
          FieldFilter.create = function create(properties) {
            return new FieldFilter(properties);
          };

          /**
           * Encodes the specified FieldFilter message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.FieldFilter.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldFilter} message FieldFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldFilter.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.field != null && message.hasOwnProperty("field"))
              $root.google.firestore.v1beta1.StructuredQuery.FieldReference.encode(message.field, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.op != null && message.hasOwnProperty("op"))
              writer.uint32(/* id 2, wireType 0 =*/16).int32(message.op);
            if (message.value != null && message.hasOwnProperty("value"))
              $root.google.firestore.v1beta1.Value.encode(message.value, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified FieldFilter message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.FieldFilter.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldFilter} message FieldFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldFilter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a FieldFilter message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldFilter} FieldFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldFilter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.FieldFilter();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.decode(reader, reader.uint32());
                  break;
                case 2:
                  message.op = reader.int32();
                  break;
                case 3:
                  message.value = $root.google.firestore.v1beta1.Value.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a FieldFilter message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldFilter} FieldFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldFilter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a FieldFilter message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          FieldFilter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.field != null && message.hasOwnProperty("field")) {
              var error = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.verify(message.field);
              if (error)
                return "field." + error;
            }
            if (message.op != null && message.hasOwnProperty("op"))
              switch (message.op) {
                default:
                  return "op: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 7:
                  break;
              }
            if (message.value != null && message.hasOwnProperty("value")) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.value);
              if (error)
                return "value." + error;
            }
            return null;
          };

          /**
           * Creates a FieldFilter message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldFilter} FieldFilter
           */
          FieldFilter.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.FieldFilter)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.FieldFilter();
            if (object.field != null) {
              if (typeof object.field !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.FieldFilter.field: object expected");
              message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.fromObject(object.field);
            }
            switch (object.op) {
              case "OPERATOR_UNSPECIFIED":
              case 0:
                message.op = 0;
                break;
              case "LESS_THAN":
              case 1:
                message.op = 1;
                break;
              case "LESS_THAN_OR_EQUAL":
              case 2:
                message.op = 2;
                break;
              case "GREATER_THAN":
              case 3:
                message.op = 3;
                break;
              case "GREATER_THAN_OR_EQUAL":
              case 4:
                message.op = 4;
                break;
              case "EQUAL":
              case 5:
                message.op = 5;
                break;
              case "ARRAY_CONTAINS":
              case 7:
                message.op = 7;
                break;
            }
            if (object.value != null) {
              if (typeof object.value !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.FieldFilter.value: object expected");
              message.value = $root.google.firestore.v1beta1.Value.fromObject(object.value);
            }
            return message;
          };

          /**
           * Creates a plain object from a FieldFilter message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.FieldFilter} message FieldFilter
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          FieldFilter.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults) {
              object.field = null;
              object.op = options.enums === String ? "OPERATOR_UNSPECIFIED" : 0;
              object.value = null;
            }
            if (message.field != null && message.hasOwnProperty("field"))
              object.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.toObject(message.field, options);
            if (message.op != null && message.hasOwnProperty("op"))
              object.op = options.enums === String ? $root.google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator[message.op] : message.op;
            if (message.value != null && message.hasOwnProperty("value"))
              object.value = $root.google.firestore.v1beta1.Value.toObject(message.value, options);
            return object;
          };

          /**
           * Converts this FieldFilter to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldFilter
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          FieldFilter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          /**
           * Operator enum.
           * @name google.firestore.v1beta1.StructuredQuery.FieldFilter.Operator
           * @enum {string}
           * @property {number} OPERATOR_UNSPECIFIED=0 OPERATOR_UNSPECIFIED value
           * @property {number} LESS_THAN=1 LESS_THAN value
           * @property {number} LESS_THAN_OR_EQUAL=2 LESS_THAN_OR_EQUAL value
           * @property {number} GREATER_THAN=3 GREATER_THAN value
           * @property {number} GREATER_THAN_OR_EQUAL=4 GREATER_THAN_OR_EQUAL value
           * @property {number} EQUAL=5 EQUAL value
           * @property {number} ARRAY_CONTAINS=7 ARRAY_CONTAINS value
           */
          FieldFilter.Operator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OPERATOR_UNSPECIFIED"] = 0;
            values[valuesById[1] = "LESS_THAN"] = 1;
            values[valuesById[2] = "LESS_THAN_OR_EQUAL"] = 2;
            values[valuesById[3] = "GREATER_THAN"] = 3;
            values[valuesById[4] = "GREATER_THAN_OR_EQUAL"] = 4;
            values[valuesById[5] = "EQUAL"] = 5;
            values[valuesById[7] = "ARRAY_CONTAINS"] = 7;
            return values;
          })();

          return FieldFilter;
        })();

        StructuredQuery.UnaryFilter = (function() {

          /**
           * Properties of an UnaryFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IUnaryFilter
           * @property {google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator|null} [op] UnaryFilter op
           * @property {google.firestore.v1beta1.StructuredQuery.IFieldReference|null} [field] UnaryFilter field
           */

          /**
           * Constructs a new UnaryFilter.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents an UnaryFilter.
           * @implements IUnaryFilter
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IUnaryFilter=} [properties] Properties to set
           */
          function UnaryFilter(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * UnaryFilter op.
           * @member {google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator} op
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @instance
           */
          UnaryFilter.prototype.op = 0;

          /**
           * UnaryFilter field.
           * @member {google.firestore.v1beta1.StructuredQuery.IFieldReference|null|undefined} field
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @instance
           */
          UnaryFilter.prototype.field = null;

          // OneOf field names bound to virtual getters and setters
          var $oneOfFields;

          /**
           * UnaryFilter operandType.
           * @member {"field"|undefined} operandType
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @instance
           */
          Object.defineProperty(UnaryFilter.prototype, "operandType", {
            get: $util.oneOfGetter($oneOfFields = ["field"]),
            set: $util.oneOfSetter($oneOfFields)
          });

          /**
           * Creates a new UnaryFilter instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IUnaryFilter=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.UnaryFilter} UnaryFilter instance
           */
          UnaryFilter.create = function create(properties) {
            return new UnaryFilter(properties);
          };

          /**
           * Encodes the specified UnaryFilter message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.UnaryFilter.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IUnaryFilter} message UnaryFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          UnaryFilter.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.op != null && message.hasOwnProperty("op"))
              writer.uint32(/* id 1, wireType 0 =*/8).int32(message.op);
            if (message.field != null && message.hasOwnProperty("field"))
              $root.google.firestore.v1beta1.StructuredQuery.FieldReference.encode(message.field, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified UnaryFilter message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.UnaryFilter.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IUnaryFilter} message UnaryFilter message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          UnaryFilter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes an UnaryFilter message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.UnaryFilter} UnaryFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          UnaryFilter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.op = reader.int32();
                  break;
                case 2:
                  message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes an UnaryFilter message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.UnaryFilter} UnaryFilter
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          UnaryFilter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies an UnaryFilter message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          UnaryFilter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            var properties = {};
            if (message.op != null && message.hasOwnProperty("op"))
              switch (message.op) {
                default:
                  return "op: enum value expected";
                case 0:
                case 2:
                case 3:
                  break;
              }
            if (message.field != null && message.hasOwnProperty("field")) {
              properties.operandType = 1;
              {
                var error = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.verify(message.field);
                if (error)
                  return "field." + error;
              }
            }
            return null;
          };

          /**
           * Creates an UnaryFilter message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.UnaryFilter} UnaryFilter
           */
          UnaryFilter.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter();
            switch (object.op) {
              case "OPERATOR_UNSPECIFIED":
              case 0:
                message.op = 0;
                break;
              case "IS_NAN":
              case 2:
                message.op = 2;
                break;
              case "IS_NULL":
              case 3:
                message.op = 3;
                break;
            }
            if (object.field != null) {
              if (typeof object.field !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.UnaryFilter.field: object expected");
              message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.fromObject(object.field);
            }
            return message;
          };

          /**
           * Creates a plain object from an UnaryFilter message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.UnaryFilter} message UnaryFilter
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          UnaryFilter.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults)
              object.op = options.enums === String ? "OPERATOR_UNSPECIFIED" : 0;
            if (message.op != null && message.hasOwnProperty("op"))
              object.op = options.enums === String ? $root.google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator[message.op] : message.op;
            if (message.field != null && message.hasOwnProperty("field")) {
              object.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.toObject(message.field, options);
              if (options.oneofs)
                object.operandType = "field";
            }
            return object;
          };

          /**
           * Converts this UnaryFilter to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.UnaryFilter
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          UnaryFilter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          /**
           * Operator enum.
           * @name google.firestore.v1beta1.StructuredQuery.UnaryFilter.Operator
           * @enum {string}
           * @property {number} OPERATOR_UNSPECIFIED=0 OPERATOR_UNSPECIFIED value
           * @property {number} IS_NAN=2 IS_NAN value
           * @property {number} IS_NULL=3 IS_NULL value
           */
          UnaryFilter.Operator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OPERATOR_UNSPECIFIED"] = 0;
            values[valuesById[2] = "IS_NAN"] = 2;
            values[valuesById[3] = "IS_NULL"] = 3;
            return values;
          })();

          return UnaryFilter;
        })();

        StructuredQuery.Order = (function() {

          /**
           * Properties of an Order.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IOrder
           * @property {google.firestore.v1beta1.StructuredQuery.IFieldReference|null} [field] Order field
           * @property {google.firestore.v1beta1.StructuredQuery.Direction|null} [direction] Order direction
           */

          /**
           * Constructs a new Order.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents an Order.
           * @implements IOrder
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IOrder=} [properties] Properties to set
           */
          function Order(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * Order field.
           * @member {google.firestore.v1beta1.StructuredQuery.IFieldReference|null|undefined} field
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @instance
           */
          Order.prototype.field = null;

          /**
           * Order direction.
           * @member {google.firestore.v1beta1.StructuredQuery.Direction} direction
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @instance
           */
          Order.prototype.direction = 0;

          /**
           * Creates a new Order instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IOrder=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.Order} Order instance
           */
          Order.create = function create(properties) {
            return new Order(properties);
          };

          /**
           * Encodes the specified Order message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Order.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IOrder} message Order message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Order.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.field != null && message.hasOwnProperty("field"))
              $root.google.firestore.v1beta1.StructuredQuery.FieldReference.encode(message.field, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.direction != null && message.hasOwnProperty("direction"))
              writer.uint32(/* id 2, wireType 0 =*/16).int32(message.direction);
            return writer;
          };

          /**
           * Encodes the specified Order message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Order.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IOrder} message Order message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Order.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes an Order message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.Order} Order
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Order.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.Order();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.decode(reader, reader.uint32());
                  break;
                case 2:
                  message.direction = reader.int32();
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes an Order message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.Order} Order
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Order.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies an Order message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          Order.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.field != null && message.hasOwnProperty("field")) {
              var error = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.verify(message.field);
              if (error)
                return "field." + error;
            }
            if (message.direction != null && message.hasOwnProperty("direction"))
              switch (message.direction) {
                default:
                  return "direction: enum value expected";
                case 0:
                case 1:
                case 2:
                  break;
              }
            return null;
          };

          /**
           * Creates an Order message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.Order} Order
           */
          Order.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.Order)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.Order();
            if (object.field != null) {
              if (typeof object.field !== "object")
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.Order.field: object expected");
              message.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.fromObject(object.field);
            }
            switch (object.direction) {
              case "DIRECTION_UNSPECIFIED":
              case 0:
                message.direction = 0;
                break;
              case "ASCENDING":
              case 1:
                message.direction = 1;
                break;
              case "DESCENDING":
              case 2:
                message.direction = 2;
                break;
            }
            return message;
          };

          /**
           * Creates a plain object from an Order message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.Order} message Order
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          Order.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults) {
              object.field = null;
              object.direction = options.enums === String ? "DIRECTION_UNSPECIFIED" : 0;
            }
            if (message.field != null && message.hasOwnProperty("field"))
              object.field = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.toObject(message.field, options);
            if (message.direction != null && message.hasOwnProperty("direction"))
              object.direction = options.enums === String ? $root.google.firestore.v1beta1.StructuredQuery.Direction[message.direction] : message.direction;
            return object;
          };

          /**
           * Converts this Order to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.Order
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          Order.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return Order;
        })();

        StructuredQuery.FieldReference = (function() {

          /**
           * Properties of a FieldReference.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IFieldReference
           * @property {string|null} [fieldPath] FieldReference fieldPath
           */

          /**
           * Constructs a new FieldReference.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a FieldReference.
           * @implements IFieldReference
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldReference=} [properties] Properties to set
           */
          function FieldReference(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * FieldReference fieldPath.
           * @member {string} fieldPath
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @instance
           */
          FieldReference.prototype.fieldPath = "";

          /**
           * Creates a new FieldReference instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldReference=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldReference} FieldReference instance
           */
          FieldReference.create = function create(properties) {
            return new FieldReference(properties);
          };

          /**
           * Encodes the specified FieldReference message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.FieldReference.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldReference} message FieldReference message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldReference.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              writer.uint32(/* id 2, wireType 2 =*/18).string(message.fieldPath);
            return writer;
          };

          /**
           * Encodes the specified FieldReference message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.FieldReference.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IFieldReference} message FieldReference message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldReference.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a FieldReference message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldReference} FieldReference
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldReference.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.FieldReference();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 2:
                  message.fieldPath = reader.string();
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a FieldReference message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldReference} FieldReference
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldReference.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a FieldReference message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          FieldReference.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              if (!$util.isString(message.fieldPath))
                return "fieldPath: string expected";
            return null;
          };

          /**
           * Creates a FieldReference message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.FieldReference} FieldReference
           */
          FieldReference.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.FieldReference)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.FieldReference();
            if (object.fieldPath != null)
              message.fieldPath = String(object.fieldPath);
            return message;
          };

          /**
           * Creates a plain object from a FieldReference message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.FieldReference} message FieldReference
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          FieldReference.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults)
              object.fieldPath = "";
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              object.fieldPath = message.fieldPath;
            return object;
          };

          /**
           * Converts this FieldReference to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.FieldReference
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          FieldReference.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return FieldReference;
        })();

        StructuredQuery.Projection = (function() {

          /**
           * Properties of a Projection.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @interface IProjection
           * @property {Array.<google.firestore.v1beta1.StructuredQuery.IFieldReference>|null} [fields] Projection fields
           */

          /**
           * Constructs a new Projection.
           * @memberof google.firestore.v1beta1.StructuredQuery
           * @classdesc Represents a Projection.
           * @implements IProjection
           * @constructor
           * @param {google.firestore.v1beta1.StructuredQuery.IProjection=} [properties] Properties to set
           */
          function Projection(properties) {
            this.fields = [];
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * Projection fields.
           * @member {Array.<google.firestore.v1beta1.StructuredQuery.IFieldReference>} fields
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @instance
           */
          Projection.prototype.fields = $util.emptyArray;

          /**
           * Creates a new Projection instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IProjection=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.StructuredQuery.Projection} Projection instance
           */
          Projection.create = function create(properties) {
            return new Projection(properties);
          };

          /**
           * Encodes the specified Projection message. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Projection.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IProjection} message Projection message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Projection.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.fields != null && message.fields.length)
              for (var i = 0; i < message.fields.length; ++i)
                $root.google.firestore.v1beta1.StructuredQuery.FieldReference.encode(message.fields[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified Projection message, length delimited. Does not implicitly {@link google.firestore.v1beta1.StructuredQuery.Projection.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.IProjection} message Projection message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          Projection.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a Projection message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.StructuredQuery.Projection} Projection
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Projection.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.StructuredQuery.Projection();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 2:
                  if (!(message.fields && message.fields.length))
                    message.fields = [];
                  message.fields.push($root.google.firestore.v1beta1.StructuredQuery.FieldReference.decode(reader, reader.uint32()));
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a Projection message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.StructuredQuery.Projection} Projection
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          Projection.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a Projection message.
           * @function verify
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          Projection.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            if (message.fields != null && message.hasOwnProperty("fields")) {
              if (!Array.isArray(message.fields))
                return "fields: array expected";
              for (var i = 0; i < message.fields.length; ++i) {
                var error = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.verify(message.fields[i]);
                if (error)
                  return "fields." + error;
              }
            }
            return null;
          };

          /**
           * Creates a Projection message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.StructuredQuery.Projection} Projection
           */
          Projection.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.StructuredQuery.Projection)
              return object;
            var message = new $root.google.firestore.v1beta1.StructuredQuery.Projection();
            if (object.fields) {
              if (!Array.isArray(object.fields))
                throw TypeError(".google.firestore.v1beta1.StructuredQuery.Projection.fields: array expected");
              message.fields = [];
              for (var i = 0; i < object.fields.length; ++i) {
                if (typeof object.fields[i] !== "object")
                  throw TypeError(".google.firestore.v1beta1.StructuredQuery.Projection.fields: object expected");
                message.fields[i] = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.fromObject(object.fields[i]);
              }
            }
            return message;
          };

          /**
           * Creates a plain object from a Projection message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @static
           * @param {google.firestore.v1beta1.StructuredQuery.Projection} message Projection
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          Projection.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.arrays || options.defaults)
              object.fields = [];
            if (message.fields && message.fields.length) {
              object.fields = [];
              for (var j = 0; j < message.fields.length; ++j)
                object.fields[j] = $root.google.firestore.v1beta1.StructuredQuery.FieldReference.toObject(message.fields[j], options);
            }
            return object;
          };

          /**
           * Converts this Projection to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.StructuredQuery.Projection
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          Projection.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          return Projection;
        })();

        /**
         * Direction enum.
         * @name google.firestore.v1beta1.StructuredQuery.Direction
         * @enum {string}
         * @property {number} DIRECTION_UNSPECIFIED=0 DIRECTION_UNSPECIFIED value
         * @property {number} ASCENDING=1 ASCENDING value
         * @property {number} DESCENDING=2 DESCENDING value
         */
        StructuredQuery.Direction = (function() {
          var valuesById = {}, values = Object.create(valuesById);
          values[valuesById[0] = "DIRECTION_UNSPECIFIED"] = 0;
          values[valuesById[1] = "ASCENDING"] = 1;
          values[valuesById[2] = "DESCENDING"] = 2;
          return values;
        })();

        return StructuredQuery;
      })();

      v1beta1.Cursor = (function() {

        /**
         * Properties of a Cursor.
         * @memberof google.firestore.v1beta1
         * @interface ICursor
         * @property {Array.<google.firestore.v1beta1.IValue>|null} [values] Cursor values
         * @property {boolean|null} [before] Cursor before
         */

        /**
         * Constructs a new Cursor.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Cursor.
         * @implements ICursor
         * @constructor
         * @param {google.firestore.v1beta1.ICursor=} [properties] Properties to set
         */
        function Cursor(properties) {
          this.values = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Cursor values.
         * @member {Array.<google.firestore.v1beta1.IValue>} values
         * @memberof google.firestore.v1beta1.Cursor
         * @instance
         */
        Cursor.prototype.values = $util.emptyArray;

        /**
         * Cursor before.
         * @member {boolean} before
         * @memberof google.firestore.v1beta1.Cursor
         * @instance
         */
        Cursor.prototype.before = false;

        /**
         * Creates a new Cursor instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {google.firestore.v1beta1.ICursor=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Cursor} Cursor instance
         */
        Cursor.create = function create(properties) {
          return new Cursor(properties);
        };

        /**
         * Encodes the specified Cursor message. Does not implicitly {@link google.firestore.v1beta1.Cursor.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {google.firestore.v1beta1.ICursor} message Cursor message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Cursor.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.values != null && message.values.length)
            for (var i = 0; i < message.values.length; ++i)
              $root.google.firestore.v1beta1.Value.encode(message.values[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.before != null && message.hasOwnProperty("before"))
            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.before);
          return writer;
        };

        /**
         * Encodes the specified Cursor message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Cursor.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {google.firestore.v1beta1.ICursor} message Cursor message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Cursor.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Cursor message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Cursor} Cursor
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Cursor.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Cursor();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                if (!(message.values && message.values.length))
                  message.values = [];
                message.values.push($root.google.firestore.v1beta1.Value.decode(reader, reader.uint32()));
                break;
              case 2:
                message.before = reader.bool();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Cursor message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Cursor} Cursor
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Cursor.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Cursor message.
         * @function verify
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Cursor.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.values != null && message.hasOwnProperty("values")) {
            if (!Array.isArray(message.values))
              return "values: array expected";
            for (var i = 0; i < message.values.length; ++i) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.values[i]);
              if (error)
                return "values." + error;
            }
          }
          if (message.before != null && message.hasOwnProperty("before"))
            if (typeof message.before !== "boolean")
              return "before: boolean expected";
          return null;
        };

        /**
         * Creates a Cursor message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Cursor} Cursor
         */
        Cursor.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Cursor)
            return object;
          var message = new $root.google.firestore.v1beta1.Cursor();
          if (object.values) {
            if (!Array.isArray(object.values))
              throw TypeError(".google.firestore.v1beta1.Cursor.values: array expected");
            message.values = [];
            for (var i = 0; i < object.values.length; ++i) {
              if (typeof object.values[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.Cursor.values: object expected");
              message.values[i] = $root.google.firestore.v1beta1.Value.fromObject(object.values[i]);
            }
          }
          if (object.before != null)
            message.before = Boolean(object.before);
          return message;
        };

        /**
         * Creates a plain object from a Cursor message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Cursor
         * @static
         * @param {google.firestore.v1beta1.Cursor} message Cursor
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Cursor.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.values = [];
          if (options.defaults)
            object.before = false;
          if (message.values && message.values.length) {
            object.values = [];
            for (var j = 0; j < message.values.length; ++j)
              object.values[j] = $root.google.firestore.v1beta1.Value.toObject(message.values[j], options);
          }
          if (message.before != null && message.hasOwnProperty("before"))
            object.before = message.before;
          return object;
        };

        /**
         * Converts this Cursor to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Cursor
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Cursor.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Cursor;
      })();

      v1beta1.Write = (function() {

        /**
         * Properties of a Write.
         * @memberof google.firestore.v1beta1
         * @interface IWrite
         * @property {google.firestore.v1beta1.IDocument|null} [update] Write update
         * @property {string|null} ["delete"] Write delete
         * @property {google.firestore.v1beta1.IDocumentTransform|null} [transform] Write transform
         * @property {google.firestore.v1beta1.IDocumentMask|null} [updateMask] Write updateMask
         * @property {google.firestore.v1beta1.IPrecondition|null} [currentDocument] Write currentDocument
         */

        /**
         * Constructs a new Write.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a Write.
         * @implements IWrite
         * @constructor
         * @param {google.firestore.v1beta1.IWrite=} [properties] Properties to set
         */
        function Write(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * Write update.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} update
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Write.prototype.update = null;

        /**
         * Write delete.
         * @member {string} delete
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Write.prototype["delete"] = "";

        /**
         * Write transform.
         * @member {google.firestore.v1beta1.IDocumentTransform|null|undefined} transform
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Write.prototype.transform = null;

        /**
         * Write updateMask.
         * @member {google.firestore.v1beta1.IDocumentMask|null|undefined} updateMask
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Write.prototype.updateMask = null;

        /**
         * Write currentDocument.
         * @member {google.firestore.v1beta1.IPrecondition|null|undefined} currentDocument
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Write.prototype.currentDocument = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * Write operation.
         * @member {"update"|"delete"|"transform"|undefined} operation
         * @memberof google.firestore.v1beta1.Write
         * @instance
         */
        Object.defineProperty(Write.prototype, "operation", {
          get: $util.oneOfGetter($oneOfFields = ["update", "delete", "transform"]),
          set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Write instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {google.firestore.v1beta1.IWrite=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.Write} Write instance
         */
        Write.create = function create(properties) {
          return new Write(properties);
        };

        /**
         * Encodes the specified Write message. Does not implicitly {@link google.firestore.v1beta1.Write.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {google.firestore.v1beta1.IWrite} message Write message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Write.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.update != null && message.hasOwnProperty("update"))
            $root.google.firestore.v1beta1.Document.encode(message.update, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message["delete"] != null && message.hasOwnProperty("delete"))
            writer.uint32(/* id 2, wireType 2 =*/18).string(message["delete"]);
          if (message.updateMask != null && message.hasOwnProperty("updateMask"))
            $root.google.firestore.v1beta1.DocumentMask.encode(message.updateMask, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            $root.google.firestore.v1beta1.Precondition.encode(message.currentDocument, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          if (message.transform != null && message.hasOwnProperty("transform"))
            $root.google.firestore.v1beta1.DocumentTransform.encode(message.transform, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified Write message, length delimited. Does not implicitly {@link google.firestore.v1beta1.Write.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {google.firestore.v1beta1.IWrite} message Write message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Write.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Write message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.Write} Write
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Write.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.Write();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.update = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 2:
                message["delete"] = reader.string();
                break;
              case 6:
                message.transform = $root.google.firestore.v1beta1.DocumentTransform.decode(reader, reader.uint32());
                break;
              case 3:
                message.updateMask = $root.google.firestore.v1beta1.DocumentMask.decode(reader, reader.uint32());
                break;
              case 4:
                message.currentDocument = $root.google.firestore.v1beta1.Precondition.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a Write message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.Write} Write
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Write.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Write message.
         * @function verify
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Write.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          var properties = {};
          if (message.update != null && message.hasOwnProperty("update")) {
            properties.operation = 1;
            {
              var error = $root.google.firestore.v1beta1.Document.verify(message.update);
              if (error)
                return "update." + error;
            }
          }
          if (message["delete"] != null && message.hasOwnProperty("delete")) {
            if (properties.operation === 1)
              return "operation: multiple values";
            properties.operation = 1;
            if (!$util.isString(message["delete"]))
              return "delete: string expected";
          }
          if (message.transform != null && message.hasOwnProperty("transform")) {
            if (properties.operation === 1)
              return "operation: multiple values";
            properties.operation = 1;
            {
              var error = $root.google.firestore.v1beta1.DocumentTransform.verify(message.transform);
              if (error)
                return "transform." + error;
            }
          }
          if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
            var error = $root.google.firestore.v1beta1.DocumentMask.verify(message.updateMask);
            if (error)
              return "updateMask." + error;
          }
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument")) {
            var error = $root.google.firestore.v1beta1.Precondition.verify(message.currentDocument);
            if (error)
              return "currentDocument." + error;
          }
          return null;
        };

        /**
         * Creates a Write message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.Write} Write
         */
        Write.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.Write)
            return object;
          var message = new $root.google.firestore.v1beta1.Write();
          if (object.update != null) {
            if (typeof object.update !== "object")
              throw TypeError(".google.firestore.v1beta1.Write.update: object expected");
            message.update = $root.google.firestore.v1beta1.Document.fromObject(object.update);
          }
          if (object["delete"] != null)
            message["delete"] = String(object["delete"]);
          if (object.transform != null) {
            if (typeof object.transform !== "object")
              throw TypeError(".google.firestore.v1beta1.Write.transform: object expected");
            message.transform = $root.google.firestore.v1beta1.DocumentTransform.fromObject(object.transform);
          }
          if (object.updateMask != null) {
            if (typeof object.updateMask !== "object")
              throw TypeError(".google.firestore.v1beta1.Write.updateMask: object expected");
            message.updateMask = $root.google.firestore.v1beta1.DocumentMask.fromObject(object.updateMask);
          }
          if (object.currentDocument != null) {
            if (typeof object.currentDocument !== "object")
              throw TypeError(".google.firestore.v1beta1.Write.currentDocument: object expected");
            message.currentDocument = $root.google.firestore.v1beta1.Precondition.fromObject(object.currentDocument);
          }
          return message;
        };

        /**
         * Creates a plain object from a Write message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.Write
         * @static
         * @param {google.firestore.v1beta1.Write} message Write
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Write.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.updateMask = null;
            object.currentDocument = null;
          }
          if (message.update != null && message.hasOwnProperty("update")) {
            object.update = $root.google.firestore.v1beta1.Document.toObject(message.update, options);
            if (options.oneofs)
              object.operation = "update";
          }
          if (message["delete"] != null && message.hasOwnProperty("delete")) {
            object["delete"] = message["delete"];
            if (options.oneofs)
              object.operation = "delete";
          }
          if (message.updateMask != null && message.hasOwnProperty("updateMask"))
            object.updateMask = $root.google.firestore.v1beta1.DocumentMask.toObject(message.updateMask, options);
          if (message.currentDocument != null && message.hasOwnProperty("currentDocument"))
            object.currentDocument = $root.google.firestore.v1beta1.Precondition.toObject(message.currentDocument, options);
          if (message.transform != null && message.hasOwnProperty("transform")) {
            object.transform = $root.google.firestore.v1beta1.DocumentTransform.toObject(message.transform, options);
            if (options.oneofs)
              object.operation = "transform";
          }
          return object;
        };

        /**
         * Converts this Write to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.Write
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Write.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Write;
      })();

      v1beta1.DocumentTransform = (function() {

        /**
         * Properties of a DocumentTransform.
         * @memberof google.firestore.v1beta1
         * @interface IDocumentTransform
         * @property {string|null} [document] DocumentTransform document
         * @property {Array.<google.firestore.v1beta1.DocumentTransform.IFieldTransform>|null} [fieldTransforms] DocumentTransform fieldTransforms
         */

        /**
         * Constructs a new DocumentTransform.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DocumentTransform.
         * @implements IDocumentTransform
         * @constructor
         * @param {google.firestore.v1beta1.IDocumentTransform=} [properties] Properties to set
         */
        function DocumentTransform(properties) {
          this.fieldTransforms = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentTransform document.
         * @member {string} document
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @instance
         */
        DocumentTransform.prototype.document = "";

        /**
         * DocumentTransform fieldTransforms.
         * @member {Array.<google.firestore.v1beta1.DocumentTransform.IFieldTransform>} fieldTransforms
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @instance
         */
        DocumentTransform.prototype.fieldTransforms = $util.emptyArray;

        /**
         * Creates a new DocumentTransform instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {google.firestore.v1beta1.IDocumentTransform=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DocumentTransform} DocumentTransform instance
         */
        DocumentTransform.create = function create(properties) {
          return new DocumentTransform(properties);
        };

        /**
         * Encodes the specified DocumentTransform message. Does not implicitly {@link google.firestore.v1beta1.DocumentTransform.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {google.firestore.v1beta1.IDocumentTransform} message DocumentTransform message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentTransform.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.document);
          if (message.fieldTransforms != null && message.fieldTransforms.length)
            for (var i = 0; i < message.fieldTransforms.length; ++i)
              $root.google.firestore.v1beta1.DocumentTransform.FieldTransform.encode(message.fieldTransforms[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified DocumentTransform message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentTransform.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {google.firestore.v1beta1.IDocumentTransform} message DocumentTransform message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentTransform.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentTransform message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DocumentTransform} DocumentTransform
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentTransform.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentTransform();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.document = reader.string();
                break;
              case 2:
                if (!(message.fieldTransforms && message.fieldTransforms.length))
                  message.fieldTransforms = [];
                message.fieldTransforms.push($root.google.firestore.v1beta1.DocumentTransform.FieldTransform.decode(reader, reader.uint32()));
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DocumentTransform message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DocumentTransform} DocumentTransform
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentTransform.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentTransform message.
         * @function verify
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentTransform.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.document != null && message.hasOwnProperty("document"))
            if (!$util.isString(message.document))
              return "document: string expected";
          if (message.fieldTransforms != null && message.hasOwnProperty("fieldTransforms")) {
            if (!Array.isArray(message.fieldTransforms))
              return "fieldTransforms: array expected";
            for (var i = 0; i < message.fieldTransforms.length; ++i) {
              var error = $root.google.firestore.v1beta1.DocumentTransform.FieldTransform.verify(message.fieldTransforms[i]);
              if (error)
                return "fieldTransforms." + error;
            }
          }
          return null;
        };

        /**
         * Creates a DocumentTransform message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DocumentTransform} DocumentTransform
         */
        DocumentTransform.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DocumentTransform)
            return object;
          var message = new $root.google.firestore.v1beta1.DocumentTransform();
          if (object.document != null)
            message.document = String(object.document);
          if (object.fieldTransforms) {
            if (!Array.isArray(object.fieldTransforms))
              throw TypeError(".google.firestore.v1beta1.DocumentTransform.fieldTransforms: array expected");
            message.fieldTransforms = [];
            for (var i = 0; i < object.fieldTransforms.length; ++i) {
              if (typeof object.fieldTransforms[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.DocumentTransform.fieldTransforms: object expected");
              message.fieldTransforms[i] = $root.google.firestore.v1beta1.DocumentTransform.FieldTransform.fromObject(object.fieldTransforms[i]);
            }
          }
          return message;
        };

        /**
         * Creates a plain object from a DocumentTransform message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @static
         * @param {google.firestore.v1beta1.DocumentTransform} message DocumentTransform
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentTransform.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.fieldTransforms = [];
          if (options.defaults)
            object.document = "";
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = message.document;
          if (message.fieldTransforms && message.fieldTransforms.length) {
            object.fieldTransforms = [];
            for (var j = 0; j < message.fieldTransforms.length; ++j)
              object.fieldTransforms[j] = $root.google.firestore.v1beta1.DocumentTransform.FieldTransform.toObject(message.fieldTransforms[j], options);
          }
          return object;
        };

        /**
         * Converts this DocumentTransform to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DocumentTransform
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentTransform.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DocumentTransform.FieldTransform = (function() {

          /**
           * Properties of a FieldTransform.
           * @memberof google.firestore.v1beta1.DocumentTransform
           * @interface IFieldTransform
           * @property {string|null} [fieldPath] FieldTransform fieldPath
           * @property {google.firestore.v1beta1.DocumentTransform.FieldTransform.ServerValue|null} [setToServerValue] FieldTransform setToServerValue
           * @property {google.firestore.v1beta1.IArrayValue|null} [appendMissingElements] FieldTransform appendMissingElements
           * @property {google.firestore.v1beta1.IArrayValue|null} [removeAllFromArray] FieldTransform removeAllFromArray
           */

          /**
           * Constructs a new FieldTransform.
           * @memberof google.firestore.v1beta1.DocumentTransform
           * @classdesc Represents a FieldTransform.
           * @implements IFieldTransform
           * @constructor
           * @param {google.firestore.v1beta1.DocumentTransform.IFieldTransform=} [properties] Properties to set
           */
          function FieldTransform(properties) {
            if (properties)
              for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                if (properties[keys[i]] != null)
                  this[keys[i]] = properties[keys[i]];
          }

          /**
           * FieldTransform fieldPath.
           * @member {string} fieldPath
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           */
          FieldTransform.prototype.fieldPath = "";

          /**
           * FieldTransform setToServerValue.
           * @member {google.firestore.v1beta1.DocumentTransform.FieldTransform.ServerValue} setToServerValue
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           */
          FieldTransform.prototype.setToServerValue = 0;

          /**
           * FieldTransform appendMissingElements.
           * @member {google.firestore.v1beta1.IArrayValue|null|undefined} appendMissingElements
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           */
          FieldTransform.prototype.appendMissingElements = null;

          /**
           * FieldTransform removeAllFromArray.
           * @member {google.firestore.v1beta1.IArrayValue|null|undefined} removeAllFromArray
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           */
          FieldTransform.prototype.removeAllFromArray = null;

          // OneOf field names bound to virtual getters and setters
          var $oneOfFields;

          /**
           * FieldTransform transformType.
           * @member {"setToServerValue"|"appendMissingElements"|"removeAllFromArray"|undefined} transformType
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           */
          Object.defineProperty(FieldTransform.prototype, "transformType", {
            get: $util.oneOfGetter($oneOfFields = ["setToServerValue", "appendMissingElements", "removeAllFromArray"]),
            set: $util.oneOfSetter($oneOfFields)
          });

          /**
           * Creates a new FieldTransform instance using the specified properties.
           * @function create
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {google.firestore.v1beta1.DocumentTransform.IFieldTransform=} [properties] Properties to set
           * @returns {google.firestore.v1beta1.DocumentTransform.FieldTransform} FieldTransform instance
           */
          FieldTransform.create = function create(properties) {
            return new FieldTransform(properties);
          };

          /**
           * Encodes the specified FieldTransform message. Does not implicitly {@link google.firestore.v1beta1.DocumentTransform.FieldTransform.verify|verify} messages.
           * @function encode
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {google.firestore.v1beta1.DocumentTransform.IFieldTransform} message FieldTransform message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldTransform.encode = function encode(message, writer) {
            if (!writer)
              writer = $Writer.create();
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              writer.uint32(/* id 1, wireType 2 =*/10).string(message.fieldPath);
            if (message.setToServerValue != null && message.hasOwnProperty("setToServerValue"))
              writer.uint32(/* id 2, wireType 0 =*/16).int32(message.setToServerValue);
            if (message.appendMissingElements != null && message.hasOwnProperty("appendMissingElements"))
              $root.google.firestore.v1beta1.ArrayValue.encode(message.appendMissingElements, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.removeAllFromArray != null && message.hasOwnProperty("removeAllFromArray"))
              $root.google.firestore.v1beta1.ArrayValue.encode(message.removeAllFromArray, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            return writer;
          };

          /**
           * Encodes the specified FieldTransform message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentTransform.FieldTransform.verify|verify} messages.
           * @function encodeDelimited
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {google.firestore.v1beta1.DocumentTransform.IFieldTransform} message FieldTransform message or plain object to encode
           * @param {$protobuf.Writer} [writer] Writer to encode to
           * @returns {$protobuf.Writer} Writer
           */
          FieldTransform.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
          };

          /**
           * Decodes a FieldTransform message from the specified reader or buffer.
           * @function decode
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @param {number} [length] Message length if known beforehand
           * @returns {google.firestore.v1beta1.DocumentTransform.FieldTransform} FieldTransform
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldTransform.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
              reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentTransform.FieldTransform();
            while (reader.pos < end) {
              var tag = reader.uint32();
              switch (tag >>> 3) {
                case 1:
                  message.fieldPath = reader.string();
                  break;
                case 2:
                  message.setToServerValue = reader.int32();
                  break;
                case 6:
                  message.appendMissingElements = $root.google.firestore.v1beta1.ArrayValue.decode(reader, reader.uint32());
                  break;
                case 7:
                  message.removeAllFromArray = $root.google.firestore.v1beta1.ArrayValue.decode(reader, reader.uint32());
                  break;
                default:
                  reader.skipType(tag & 7);
                  break;
              }
            }
            return message;
          };

          /**
           * Decodes a FieldTransform message from the specified reader or buffer, length delimited.
           * @function decodeDelimited
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
           * @returns {google.firestore.v1beta1.DocumentTransform.FieldTransform} FieldTransform
           * @throws {Error} If the payload is not a reader or valid buffer
           * @throws {$protobuf.util.ProtocolError} If required fields are missing
           */
          FieldTransform.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
              reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
          };

          /**
           * Verifies a FieldTransform message.
           * @function verify
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {Object.<string,*>} message Plain object to verify
           * @returns {string|null} `null` if valid, otherwise the reason why it is not
           */
          FieldTransform.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
              return "object expected";
            var properties = {};
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              if (!$util.isString(message.fieldPath))
                return "fieldPath: string expected";
            if (message.setToServerValue != null && message.hasOwnProperty("setToServerValue")) {
              properties.transformType = 1;
              switch (message.setToServerValue) {
                default:
                  return "setToServerValue: enum value expected";
                case 0:
                case 1:
                  break;
              }
            }
            if (message.appendMissingElements != null && message.hasOwnProperty("appendMissingElements")) {
              if (properties.transformType === 1)
                return "transformType: multiple values";
              properties.transformType = 1;
              {
                var error = $root.google.firestore.v1beta1.ArrayValue.verify(message.appendMissingElements);
                if (error)
                  return "appendMissingElements." + error;
              }
            }
            if (message.removeAllFromArray != null && message.hasOwnProperty("removeAllFromArray")) {
              if (properties.transformType === 1)
                return "transformType: multiple values";
              properties.transformType = 1;
              {
                var error = $root.google.firestore.v1beta1.ArrayValue.verify(message.removeAllFromArray);
                if (error)
                  return "removeAllFromArray." + error;
              }
            }
            return null;
          };

          /**
           * Creates a FieldTransform message from a plain object. Also converts values to their respective internal types.
           * @function fromObject
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {Object.<string,*>} object Plain object
           * @returns {google.firestore.v1beta1.DocumentTransform.FieldTransform} FieldTransform
           */
          FieldTransform.fromObject = function fromObject(object) {
            if (object instanceof $root.google.firestore.v1beta1.DocumentTransform.FieldTransform)
              return object;
            var message = new $root.google.firestore.v1beta1.DocumentTransform.FieldTransform();
            if (object.fieldPath != null)
              message.fieldPath = String(object.fieldPath);
            switch (object.setToServerValue) {
              case "SERVER_VALUE_UNSPECIFIED":
              case 0:
                message.setToServerValue = 0;
                break;
              case "REQUEST_TIME":
              case 1:
                message.setToServerValue = 1;
                break;
            }
            if (object.appendMissingElements != null) {
              if (typeof object.appendMissingElements !== "object")
                throw TypeError(".google.firestore.v1beta1.DocumentTransform.FieldTransform.appendMissingElements: object expected");
              message.appendMissingElements = $root.google.firestore.v1beta1.ArrayValue.fromObject(object.appendMissingElements);
            }
            if (object.removeAllFromArray != null) {
              if (typeof object.removeAllFromArray !== "object")
                throw TypeError(".google.firestore.v1beta1.DocumentTransform.FieldTransform.removeAllFromArray: object expected");
              message.removeAllFromArray = $root.google.firestore.v1beta1.ArrayValue.fromObject(object.removeAllFromArray);
            }
            return message;
          };

          /**
           * Creates a plain object from a FieldTransform message. Also converts values to other types if specified.
           * @function toObject
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @static
           * @param {google.firestore.v1beta1.DocumentTransform.FieldTransform} message FieldTransform
           * @param {$protobuf.IConversionOptions} [options] Conversion options
           * @returns {Object.<string,*>} Plain object
           */
          FieldTransform.toObject = function toObject(message, options) {
            if (!options)
              options = {};
            var object = {};
            if (options.defaults)
              object.fieldPath = "";
            if (message.fieldPath != null && message.hasOwnProperty("fieldPath"))
              object.fieldPath = message.fieldPath;
            if (message.setToServerValue != null && message.hasOwnProperty("setToServerValue")) {
              object.setToServerValue = options.enums === String ? $root.google.firestore.v1beta1.DocumentTransform.FieldTransform.ServerValue[message.setToServerValue] : message.setToServerValue;
              if (options.oneofs)
                object.transformType = "setToServerValue";
            }
            if (message.appendMissingElements != null && message.hasOwnProperty("appendMissingElements")) {
              object.appendMissingElements = $root.google.firestore.v1beta1.ArrayValue.toObject(message.appendMissingElements, options);
              if (options.oneofs)
                object.transformType = "appendMissingElements";
            }
            if (message.removeAllFromArray != null && message.hasOwnProperty("removeAllFromArray")) {
              object.removeAllFromArray = $root.google.firestore.v1beta1.ArrayValue.toObject(message.removeAllFromArray, options);
              if (options.oneofs)
                object.transformType = "removeAllFromArray";
            }
            return object;
          };

          /**
           * Converts this FieldTransform to JSON.
           * @function toJSON
           * @memberof google.firestore.v1beta1.DocumentTransform.FieldTransform
           * @instance
           * @returns {Object.<string,*>} JSON object
           */
          FieldTransform.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
          };

          /**
           * ServerValue enum.
           * @name google.firestore.v1beta1.DocumentTransform.FieldTransform.ServerValue
           * @enum {string}
           * @property {number} SERVER_VALUE_UNSPECIFIED=0 SERVER_VALUE_UNSPECIFIED value
           * @property {number} REQUEST_TIME=1 REQUEST_TIME value
           */
          FieldTransform.ServerValue = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SERVER_VALUE_UNSPECIFIED"] = 0;
            values[valuesById[1] = "REQUEST_TIME"] = 1;
            return values;
          })();

          return FieldTransform;
        })();

        return DocumentTransform;
      })();

      v1beta1.WriteResult = (function() {

        /**
         * Properties of a WriteResult.
         * @memberof google.firestore.v1beta1
         * @interface IWriteResult
         * @property {google.protobuf.ITimestamp|null} [updateTime] WriteResult updateTime
         * @property {Array.<google.firestore.v1beta1.IValue>|null} [transformResults] WriteResult transformResults
         */

        /**
         * Constructs a new WriteResult.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a WriteResult.
         * @implements IWriteResult
         * @constructor
         * @param {google.firestore.v1beta1.IWriteResult=} [properties] Properties to set
         */
        function WriteResult(properties) {
          this.transformResults = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * WriteResult updateTime.
         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
         * @memberof google.firestore.v1beta1.WriteResult
         * @instance
         */
        WriteResult.prototype.updateTime = null;

        /**
         * WriteResult transformResults.
         * @member {Array.<google.firestore.v1beta1.IValue>} transformResults
         * @memberof google.firestore.v1beta1.WriteResult
         * @instance
         */
        WriteResult.prototype.transformResults = $util.emptyArray;

        /**
         * Creates a new WriteResult instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {google.firestore.v1beta1.IWriteResult=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.WriteResult} WriteResult instance
         */
        WriteResult.create = function create(properties) {
          return new WriteResult(properties);
        };

        /**
         * Encodes the specified WriteResult message. Does not implicitly {@link google.firestore.v1beta1.WriteResult.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {google.firestore.v1beta1.IWriteResult} message WriteResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteResult.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.updateTime != null && message.hasOwnProperty("updateTime"))
            $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.transformResults != null && message.transformResults.length)
            for (var i = 0; i < message.transformResults.length; ++i)
              $root.google.firestore.v1beta1.Value.encode(message.transformResults[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified WriteResult message, length delimited. Does not implicitly {@link google.firestore.v1beta1.WriteResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {google.firestore.v1beta1.IWriteResult} message WriteResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WriteResult.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WriteResult message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.WriteResult} WriteResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteResult.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.WriteResult();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              case 2:
                if (!(message.transformResults && message.transformResults.length))
                  message.transformResults = [];
                message.transformResults.push($root.google.firestore.v1beta1.Value.decode(reader, reader.uint32()));
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a WriteResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.WriteResult} WriteResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WriteResult.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WriteResult message.
         * @function verify
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WriteResult.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
            if (error)
              return "updateTime." + error;
          }
          if (message.transformResults != null && message.hasOwnProperty("transformResults")) {
            if (!Array.isArray(message.transformResults))
              return "transformResults: array expected";
            for (var i = 0; i < message.transformResults.length; ++i) {
              var error = $root.google.firestore.v1beta1.Value.verify(message.transformResults[i]);
              if (error)
                return "transformResults." + error;
            }
          }
          return null;
        };

        /**
         * Creates a WriteResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.WriteResult} WriteResult
         */
        WriteResult.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.WriteResult)
            return object;
          var message = new $root.google.firestore.v1beta1.WriteResult();
          if (object.updateTime != null) {
            if (typeof object.updateTime !== "object")
              throw TypeError(".google.firestore.v1beta1.WriteResult.updateTime: object expected");
            message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
          }
          if (object.transformResults) {
            if (!Array.isArray(object.transformResults))
              throw TypeError(".google.firestore.v1beta1.WriteResult.transformResults: array expected");
            message.transformResults = [];
            for (var i = 0; i < object.transformResults.length; ++i) {
              if (typeof object.transformResults[i] !== "object")
                throw TypeError(".google.firestore.v1beta1.WriteResult.transformResults: object expected");
              message.transformResults[i] = $root.google.firestore.v1beta1.Value.fromObject(object.transformResults[i]);
            }
          }
          return message;
        };

        /**
         * Creates a plain object from a WriteResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.WriteResult
         * @static
         * @param {google.firestore.v1beta1.WriteResult} message WriteResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WriteResult.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.transformResults = [];
          if (options.defaults)
            object.updateTime = null;
          if (message.updateTime != null && message.hasOwnProperty("updateTime"))
            object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
          if (message.transformResults && message.transformResults.length) {
            object.transformResults = [];
            for (var j = 0; j < message.transformResults.length; ++j)
              object.transformResults[j] = $root.google.firestore.v1beta1.Value.toObject(message.transformResults[j], options);
          }
          return object;
        };

        /**
         * Converts this WriteResult to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.WriteResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WriteResult.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WriteResult;
      })();

      v1beta1.DocumentChange = (function() {

        /**
         * Properties of a DocumentChange.
         * @memberof google.firestore.v1beta1
         * @interface IDocumentChange
         * @property {google.firestore.v1beta1.IDocument|null} [document] DocumentChange document
         * @property {Array.<number>|null} [targetIds] DocumentChange targetIds
         * @property {Array.<number>|null} [removedTargetIds] DocumentChange removedTargetIds
         */

        /**
         * Constructs a new DocumentChange.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DocumentChange.
         * @implements IDocumentChange
         * @constructor
         * @param {google.firestore.v1beta1.IDocumentChange=} [properties] Properties to set
         */
        function DocumentChange(properties) {
          this.targetIds = [];
          this.removedTargetIds = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentChange document.
         * @member {google.firestore.v1beta1.IDocument|null|undefined} document
         * @memberof google.firestore.v1beta1.DocumentChange
         * @instance
         */
        DocumentChange.prototype.document = null;

        /**
         * DocumentChange targetIds.
         * @member {Array.<number>} targetIds
         * @memberof google.firestore.v1beta1.DocumentChange
         * @instance
         */
        DocumentChange.prototype.targetIds = $util.emptyArray;

        /**
         * DocumentChange removedTargetIds.
         * @member {Array.<number>} removedTargetIds
         * @memberof google.firestore.v1beta1.DocumentChange
         * @instance
         */
        DocumentChange.prototype.removedTargetIds = $util.emptyArray;

        /**
         * Creates a new DocumentChange instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {google.firestore.v1beta1.IDocumentChange=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DocumentChange} DocumentChange instance
         */
        DocumentChange.create = function create(properties) {
          return new DocumentChange(properties);
        };

        /**
         * Encodes the specified DocumentChange message. Does not implicitly {@link google.firestore.v1beta1.DocumentChange.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {google.firestore.v1beta1.IDocumentChange} message DocumentChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentChange.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            $root.google.firestore.v1beta1.Document.encode(message.document, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
          if (message.targetIds != null && message.targetIds.length) {
            writer.uint32(/* id 5, wireType 2 =*/42).fork();
            for (var i = 0; i < message.targetIds.length; ++i)
              writer.int32(message.targetIds[i]);
            writer.ldelim();
          }
          if (message.removedTargetIds != null && message.removedTargetIds.length) {
            writer.uint32(/* id 6, wireType 2 =*/50).fork();
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              writer.int32(message.removedTargetIds[i]);
            writer.ldelim();
          }
          return writer;
        };

        /**
         * Encodes the specified DocumentChange message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentChange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {google.firestore.v1beta1.IDocumentChange} message DocumentChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentChange.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentChange message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DocumentChange} DocumentChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentChange.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentChange();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.document = $root.google.firestore.v1beta1.Document.decode(reader, reader.uint32());
                break;
              case 5:
                if (!(message.targetIds && message.targetIds.length))
                  message.targetIds = [];
                if ((tag & 7) === 2) {
                  var end2 = reader.uint32() + reader.pos;
                  while (reader.pos < end2)
                    message.targetIds.push(reader.int32());
                } else
                  message.targetIds.push(reader.int32());
                break;
              case 6:
                if (!(message.removedTargetIds && message.removedTargetIds.length))
                  message.removedTargetIds = [];
                if ((tag & 7) === 2) {
                  var end2 = reader.uint32() + reader.pos;
                  while (reader.pos < end2)
                    message.removedTargetIds.push(reader.int32());
                } else
                  message.removedTargetIds.push(reader.int32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DocumentChange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DocumentChange} DocumentChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentChange.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentChange message.
         * @function verify
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentChange.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.document != null && message.hasOwnProperty("document")) {
            var error = $root.google.firestore.v1beta1.Document.verify(message.document);
            if (error)
              return "document." + error;
          }
          if (message.targetIds != null && message.hasOwnProperty("targetIds")) {
            if (!Array.isArray(message.targetIds))
              return "targetIds: array expected";
            for (var i = 0; i < message.targetIds.length; ++i)
              if (!$util.isInteger(message.targetIds[i]))
                return "targetIds: integer[] expected";
          }
          if (message.removedTargetIds != null && message.hasOwnProperty("removedTargetIds")) {
            if (!Array.isArray(message.removedTargetIds))
              return "removedTargetIds: array expected";
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              if (!$util.isInteger(message.removedTargetIds[i]))
                return "removedTargetIds: integer[] expected";
          }
          return null;
        };

        /**
         * Creates a DocumentChange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DocumentChange} DocumentChange
         */
        DocumentChange.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DocumentChange)
            return object;
          var message = new $root.google.firestore.v1beta1.DocumentChange();
          if (object.document != null) {
            if (typeof object.document !== "object")
              throw TypeError(".google.firestore.v1beta1.DocumentChange.document: object expected");
            message.document = $root.google.firestore.v1beta1.Document.fromObject(object.document);
          }
          if (object.targetIds) {
            if (!Array.isArray(object.targetIds))
              throw TypeError(".google.firestore.v1beta1.DocumentChange.targetIds: array expected");
            message.targetIds = [];
            for (var i = 0; i < object.targetIds.length; ++i)
              message.targetIds[i] = object.targetIds[i] | 0;
          }
          if (object.removedTargetIds) {
            if (!Array.isArray(object.removedTargetIds))
              throw TypeError(".google.firestore.v1beta1.DocumentChange.removedTargetIds: array expected");
            message.removedTargetIds = [];
            for (var i = 0; i < object.removedTargetIds.length; ++i)
              message.removedTargetIds[i] = object.removedTargetIds[i] | 0;
          }
          return message;
        };

        /**
         * Creates a plain object from a DocumentChange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DocumentChange
         * @static
         * @param {google.firestore.v1beta1.DocumentChange} message DocumentChange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentChange.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults) {
            object.targetIds = [];
            object.removedTargetIds = [];
          }
          if (options.defaults)
            object.document = null;
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = $root.google.firestore.v1beta1.Document.toObject(message.document, options);
          if (message.targetIds && message.targetIds.length) {
            object.targetIds = [];
            for (var j = 0; j < message.targetIds.length; ++j)
              object.targetIds[j] = message.targetIds[j];
          }
          if (message.removedTargetIds && message.removedTargetIds.length) {
            object.removedTargetIds = [];
            for (var j = 0; j < message.removedTargetIds.length; ++j)
              object.removedTargetIds[j] = message.removedTargetIds[j];
          }
          return object;
        };

        /**
         * Converts this DocumentChange to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DocumentChange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentChange.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentChange;
      })();

      v1beta1.DocumentDelete = (function() {

        /**
         * Properties of a DocumentDelete.
         * @memberof google.firestore.v1beta1
         * @interface IDocumentDelete
         * @property {string|null} [document] DocumentDelete document
         * @property {Array.<number>|null} [removedTargetIds] DocumentDelete removedTargetIds
         * @property {google.protobuf.ITimestamp|null} [readTime] DocumentDelete readTime
         */

        /**
         * Constructs a new DocumentDelete.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DocumentDelete.
         * @implements IDocumentDelete
         * @constructor
         * @param {google.firestore.v1beta1.IDocumentDelete=} [properties] Properties to set
         */
        function DocumentDelete(properties) {
          this.removedTargetIds = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentDelete document.
         * @member {string} document
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @instance
         */
        DocumentDelete.prototype.document = "";

        /**
         * DocumentDelete removedTargetIds.
         * @member {Array.<number>} removedTargetIds
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @instance
         */
        DocumentDelete.prototype.removedTargetIds = $util.emptyArray;

        /**
         * DocumentDelete readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @instance
         */
        DocumentDelete.prototype.readTime = null;

        /**
         * Creates a new DocumentDelete instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {google.firestore.v1beta1.IDocumentDelete=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DocumentDelete} DocumentDelete instance
         */
        DocumentDelete.create = function create(properties) {
          return new DocumentDelete(properties);
        };

        /**
         * Encodes the specified DocumentDelete message. Does not implicitly {@link google.firestore.v1beta1.DocumentDelete.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {google.firestore.v1beta1.IDocumentDelete} message DocumentDelete message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentDelete.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.document);
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          if (message.removedTargetIds != null && message.removedTargetIds.length) {
            writer.uint32(/* id 6, wireType 2 =*/50).fork();
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              writer.int32(message.removedTargetIds[i]);
            writer.ldelim();
          }
          return writer;
        };

        /**
         * Encodes the specified DocumentDelete message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentDelete.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {google.firestore.v1beta1.IDocumentDelete} message DocumentDelete message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentDelete.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentDelete message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DocumentDelete} DocumentDelete
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentDelete.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentDelete();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.document = reader.string();
                break;
              case 6:
                if (!(message.removedTargetIds && message.removedTargetIds.length))
                  message.removedTargetIds = [];
                if ((tag & 7) === 2) {
                  var end2 = reader.uint32() + reader.pos;
                  while (reader.pos < end2)
                    message.removedTargetIds.push(reader.int32());
                } else
                  message.removedTargetIds.push(reader.int32());
                break;
              case 4:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DocumentDelete message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DocumentDelete} DocumentDelete
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentDelete.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentDelete message.
         * @function verify
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentDelete.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.document != null && message.hasOwnProperty("document"))
            if (!$util.isString(message.document))
              return "document: string expected";
          if (message.removedTargetIds != null && message.hasOwnProperty("removedTargetIds")) {
            if (!Array.isArray(message.removedTargetIds))
              return "removedTargetIds: array expected";
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              if (!$util.isInteger(message.removedTargetIds[i]))
                return "removedTargetIds: integer[] expected";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.readTime);
            if (error)
              return "readTime." + error;
          }
          return null;
        };

        /**
         * Creates a DocumentDelete message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DocumentDelete} DocumentDelete
         */
        DocumentDelete.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DocumentDelete)
            return object;
          var message = new $root.google.firestore.v1beta1.DocumentDelete();
          if (object.document != null)
            message.document = String(object.document);
          if (object.removedTargetIds) {
            if (!Array.isArray(object.removedTargetIds))
              throw TypeError(".google.firestore.v1beta1.DocumentDelete.removedTargetIds: array expected");
            message.removedTargetIds = [];
            for (var i = 0; i < object.removedTargetIds.length; ++i)
              message.removedTargetIds[i] = object.removedTargetIds[i] | 0;
          }
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.DocumentDelete.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a DocumentDelete message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @static
         * @param {google.firestore.v1beta1.DocumentDelete} message DocumentDelete
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentDelete.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.removedTargetIds = [];
          if (options.defaults) {
            object.document = "";
            object.readTime = null;
          }
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = message.document;
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
          if (message.removedTargetIds && message.removedTargetIds.length) {
            object.removedTargetIds = [];
            for (var j = 0; j < message.removedTargetIds.length; ++j)
              object.removedTargetIds[j] = message.removedTargetIds[j];
          }
          return object;
        };

        /**
         * Converts this DocumentDelete to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DocumentDelete
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentDelete.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentDelete;
      })();

      v1beta1.DocumentRemove = (function() {

        /**
         * Properties of a DocumentRemove.
         * @memberof google.firestore.v1beta1
         * @interface IDocumentRemove
         * @property {string|null} [document] DocumentRemove document
         * @property {Array.<number>|null} [removedTargetIds] DocumentRemove removedTargetIds
         * @property {google.protobuf.ITimestamp|null} [readTime] DocumentRemove readTime
         */

        /**
         * Constructs a new DocumentRemove.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents a DocumentRemove.
         * @implements IDocumentRemove
         * @constructor
         * @param {google.firestore.v1beta1.IDocumentRemove=} [properties] Properties to set
         */
        function DocumentRemove(properties) {
          this.removedTargetIds = [];
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentRemove document.
         * @member {string} document
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @instance
         */
        DocumentRemove.prototype.document = "";

        /**
         * DocumentRemove removedTargetIds.
         * @member {Array.<number>} removedTargetIds
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @instance
         */
        DocumentRemove.prototype.removedTargetIds = $util.emptyArray;

        /**
         * DocumentRemove readTime.
         * @member {google.protobuf.ITimestamp|null|undefined} readTime
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @instance
         */
        DocumentRemove.prototype.readTime = null;

        /**
         * Creates a new DocumentRemove instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {google.firestore.v1beta1.IDocumentRemove=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.DocumentRemove} DocumentRemove instance
         */
        DocumentRemove.create = function create(properties) {
          return new DocumentRemove(properties);
        };

        /**
         * Encodes the specified DocumentRemove message. Does not implicitly {@link google.firestore.v1beta1.DocumentRemove.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {google.firestore.v1beta1.IDocumentRemove} message DocumentRemove message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentRemove.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.document != null && message.hasOwnProperty("document"))
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.document);
          if (message.removedTargetIds != null && message.removedTargetIds.length) {
            writer.uint32(/* id 2, wireType 2 =*/18).fork();
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              writer.int32(message.removedTargetIds[i]);
            writer.ldelim();
          }
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            $root.google.protobuf.Timestamp.encode(message.readTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
          return writer;
        };

        /**
         * Encodes the specified DocumentRemove message, length delimited. Does not implicitly {@link google.firestore.v1beta1.DocumentRemove.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {google.firestore.v1beta1.IDocumentRemove} message DocumentRemove message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentRemove.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentRemove message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.DocumentRemove} DocumentRemove
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentRemove.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.DocumentRemove();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.document = reader.string();
                break;
              case 2:
                if (!(message.removedTargetIds && message.removedTargetIds.length))
                  message.removedTargetIds = [];
                if ((tag & 7) === 2) {
                  var end2 = reader.uint32() + reader.pos;
                  while (reader.pos < end2)
                    message.removedTargetIds.push(reader.int32());
                } else
                  message.removedTargetIds.push(reader.int32());
                break;
              case 4:
                message.readTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a DocumentRemove message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.DocumentRemove} DocumentRemove
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentRemove.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentRemove message.
         * @function verify
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentRemove.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.document != null && message.hasOwnProperty("document"))
            if (!$util.isString(message.document))
              return "document: string expected";
          if (message.removedTargetIds != null && message.hasOwnProperty("removedTargetIds")) {
            if (!Array.isArray(message.removedTargetIds))
              return "removedTargetIds: array expected";
            for (var i = 0; i < message.removedTargetIds.length; ++i)
              if (!$util.isInteger(message.removedTargetIds[i]))
                return "removedTargetIds: integer[] expected";
          }
          if (message.readTime != null && message.hasOwnProperty("readTime")) {
            var error = $root.google.protobuf.Timestamp.verify(message.readTime);
            if (error)
              return "readTime." + error;
          }
          return null;
        };

        /**
         * Creates a DocumentRemove message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.DocumentRemove} DocumentRemove
         */
        DocumentRemove.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.DocumentRemove)
            return object;
          var message = new $root.google.firestore.v1beta1.DocumentRemove();
          if (object.document != null)
            message.document = String(object.document);
          if (object.removedTargetIds) {
            if (!Array.isArray(object.removedTargetIds))
              throw TypeError(".google.firestore.v1beta1.DocumentRemove.removedTargetIds: array expected");
            message.removedTargetIds = [];
            for (var i = 0; i < object.removedTargetIds.length; ++i)
              message.removedTargetIds[i] = object.removedTargetIds[i] | 0;
          }
          if (object.readTime != null) {
            if (typeof object.readTime !== "object")
              throw TypeError(".google.firestore.v1beta1.DocumentRemove.readTime: object expected");
            message.readTime = $root.google.protobuf.Timestamp.fromObject(object.readTime);
          }
          return message;
        };

        /**
         * Creates a plain object from a DocumentRemove message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @static
         * @param {google.firestore.v1beta1.DocumentRemove} message DocumentRemove
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentRemove.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.arrays || options.defaults)
            object.removedTargetIds = [];
          if (options.defaults) {
            object.document = "";
            object.readTime = null;
          }
          if (message.document != null && message.hasOwnProperty("document"))
            object.document = message.document;
          if (message.removedTargetIds && message.removedTargetIds.length) {
            object.removedTargetIds = [];
            for (var j = 0; j < message.removedTargetIds.length; ++j)
              object.removedTargetIds[j] = message.removedTargetIds[j];
          }
          if (message.readTime != null && message.hasOwnProperty("readTime"))
            object.readTime = $root.google.protobuf.Timestamp.toObject(message.readTime, options);
          return object;
        };

        /**
         * Converts this DocumentRemove to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.DocumentRemove
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentRemove.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentRemove;
      })();

      v1beta1.ExistenceFilter = (function() {

        /**
         * Properties of an ExistenceFilter.
         * @memberof google.firestore.v1beta1
         * @interface IExistenceFilter
         * @property {number|null} [targetId] ExistenceFilter targetId
         * @property {number|null} [count] ExistenceFilter count
         */

        /**
         * Constructs a new ExistenceFilter.
         * @memberof google.firestore.v1beta1
         * @classdesc Represents an ExistenceFilter.
         * @implements IExistenceFilter
         * @constructor
         * @param {google.firestore.v1beta1.IExistenceFilter=} [properties] Properties to set
         */
        function ExistenceFilter(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExistenceFilter targetId.
         * @member {number} targetId
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @instance
         */
        ExistenceFilter.prototype.targetId = 0;

        /**
         * ExistenceFilter count.
         * @member {number} count
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @instance
         */
        ExistenceFilter.prototype.count = 0;

        /**
         * Creates a new ExistenceFilter instance using the specified properties.
         * @function create
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {google.firestore.v1beta1.IExistenceFilter=} [properties] Properties to set
         * @returns {google.firestore.v1beta1.ExistenceFilter} ExistenceFilter instance
         */
        ExistenceFilter.create = function create(properties) {
          return new ExistenceFilter(properties);
        };

        /**
         * Encodes the specified ExistenceFilter message. Does not implicitly {@link google.firestore.v1beta1.ExistenceFilter.verify|verify} messages.
         * @function encode
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {google.firestore.v1beta1.IExistenceFilter} message ExistenceFilter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExistenceFilter.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.targetId);
          if (message.count != null && message.hasOwnProperty("count"))
            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.count);
          return writer;
        };

        /**
         * Encodes the specified ExistenceFilter message, length delimited. Does not implicitly {@link google.firestore.v1beta1.ExistenceFilter.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {google.firestore.v1beta1.IExistenceFilter} message ExistenceFilter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExistenceFilter.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExistenceFilter message from the specified reader or buffer.
         * @function decode
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.firestore.v1beta1.ExistenceFilter} ExistenceFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExistenceFilter.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.firestore.v1beta1.ExistenceFilter();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.targetId = reader.int32();
                break;
              case 2:
                message.count = reader.int32();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes an ExistenceFilter message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.firestore.v1beta1.ExistenceFilter} ExistenceFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExistenceFilter.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExistenceFilter message.
         * @function verify
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExistenceFilter.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            if (!$util.isInteger(message.targetId))
              return "targetId: integer expected";
          if (message.count != null && message.hasOwnProperty("count"))
            if (!$util.isInteger(message.count))
              return "count: integer expected";
          return null;
        };

        /**
         * Creates an ExistenceFilter message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.firestore.v1beta1.ExistenceFilter} ExistenceFilter
         */
        ExistenceFilter.fromObject = function fromObject(object) {
          if (object instanceof $root.google.firestore.v1beta1.ExistenceFilter)
            return object;
          var message = new $root.google.firestore.v1beta1.ExistenceFilter();
          if (object.targetId != null)
            message.targetId = object.targetId | 0;
          if (object.count != null)
            message.count = object.count | 0;
          return message;
        };

        /**
         * Creates a plain object from an ExistenceFilter message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @static
         * @param {google.firestore.v1beta1.ExistenceFilter} message ExistenceFilter
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExistenceFilter.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.targetId = 0;
            object.count = 0;
          }
          if (message.targetId != null && message.hasOwnProperty("targetId"))
            object.targetId = message.targetId;
          if (message.count != null && message.hasOwnProperty("count"))
            object.count = message.count;
          return object;
        };

        /**
         * Converts this ExistenceFilter to JSON.
         * @function toJSON
         * @memberof google.firestore.v1beta1.ExistenceFilter
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExistenceFilter.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExistenceFilter;
      })();

      return v1beta1;
    })();

    return firestore;
  })();

  google.api = (function() {

    /**
     * Namespace api.
     * @memberof google
     * @namespace
     */
    var api = {};

    api.Http = (function() {

      /**
       * Properties of a Http.
       * @memberof google.api
       * @interface IHttp
       * @property {Array.<google.api.IHttpRule>|null} [rules] Http rules
       */

      /**
       * Constructs a new Http.
       * @memberof google.api
       * @classdesc Represents a Http.
       * @implements IHttp
       * @constructor
       * @param {google.api.IHttp=} [properties] Properties to set
       */
      function Http(properties) {
        this.rules = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * Http rules.
       * @member {Array.<google.api.IHttpRule>} rules
       * @memberof google.api.Http
       * @instance
       */
      Http.prototype.rules = $util.emptyArray;

      /**
       * Creates a new Http instance using the specified properties.
       * @function create
       * @memberof google.api.Http
       * @static
       * @param {google.api.IHttp=} [properties] Properties to set
       * @returns {google.api.Http} Http instance
       */
      Http.create = function create(properties) {
        return new Http(properties);
      };

      /**
       * Encodes the specified Http message. Does not implicitly {@link google.api.Http.verify|verify} messages.
       * @function encode
       * @memberof google.api.Http
       * @static
       * @param {google.api.IHttp} message Http message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      Http.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.rules != null && message.rules.length)
          for (var i = 0; i < message.rules.length; ++i)
            $root.google.api.HttpRule.encode(message.rules[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified Http message, length delimited. Does not implicitly {@link google.api.Http.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.api.Http
       * @static
       * @param {google.api.IHttp} message Http message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      Http.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a Http message from the specified reader or buffer.
       * @function decode
       * @memberof google.api.Http
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.api.Http} Http
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      Http.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.Http();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              if (!(message.rules && message.rules.length))
                message.rules = [];
              message.rules.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a Http message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.api.Http
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.api.Http} Http
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      Http.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a Http message.
       * @function verify
       * @memberof google.api.Http
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      Http.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.rules != null && message.hasOwnProperty("rules")) {
          if (!Array.isArray(message.rules))
            return "rules: array expected";
          for (var i = 0; i < message.rules.length; ++i) {
            var error = $root.google.api.HttpRule.verify(message.rules[i]);
            if (error)
              return "rules." + error;
          }
        }
        return null;
      };

      /**
       * Creates a Http message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.api.Http
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.api.Http} Http
       */
      Http.fromObject = function fromObject(object) {
        if (object instanceof $root.google.api.Http)
          return object;
        var message = new $root.google.api.Http();
        if (object.rules) {
          if (!Array.isArray(object.rules))
            throw TypeError(".google.api.Http.rules: array expected");
          message.rules = [];
          for (var i = 0; i < object.rules.length; ++i) {
            if (typeof object.rules[i] !== "object")
              throw TypeError(".google.api.Http.rules: object expected");
            message.rules[i] = $root.google.api.HttpRule.fromObject(object.rules[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a Http message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.api.Http
       * @static
       * @param {google.api.Http} message Http
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      Http.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.rules = [];
        if (message.rules && message.rules.length) {
          object.rules = [];
          for (var j = 0; j < message.rules.length; ++j)
            object.rules[j] = $root.google.api.HttpRule.toObject(message.rules[j], options);
        }
        return object;
      };

      /**
       * Converts this Http to JSON.
       * @function toJSON
       * @memberof google.api.Http
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      Http.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return Http;
    })();

    api.HttpRule = (function() {

      /**
       * Properties of a HttpRule.
       * @memberof google.api
       * @interface IHttpRule
       * @property {string|null} [get] HttpRule get
       * @property {string|null} [put] HttpRule put
       * @property {string|null} [post] HttpRule post
       * @property {string|null} ["delete"] HttpRule delete
       * @property {string|null} [patch] HttpRule patch
       * @property {google.api.ICustomHttpPattern|null} [custom] HttpRule custom
       * @property {string|null} [selector] HttpRule selector
       * @property {string|null} [body] HttpRule body
       * @property {Array.<google.api.IHttpRule>|null} [additionalBindings] HttpRule additionalBindings
       */

      /**
       * Constructs a new HttpRule.
       * @memberof google.api
       * @classdesc Represents a HttpRule.
       * @implements IHttpRule
       * @constructor
       * @param {google.api.IHttpRule=} [properties] Properties to set
       */
      function HttpRule(properties) {
        this.additionalBindings = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * HttpRule get.
       * @member {string} get
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.get = "";

      /**
       * HttpRule put.
       * @member {string} put
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.put = "";

      /**
       * HttpRule post.
       * @member {string} post
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.post = "";

      /**
       * HttpRule delete.
       * @member {string} delete
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype["delete"] = "";

      /**
       * HttpRule patch.
       * @member {string} patch
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.patch = "";

      /**
       * HttpRule custom.
       * @member {google.api.ICustomHttpPattern|null|undefined} custom
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.custom = null;

      /**
       * HttpRule selector.
       * @member {string} selector
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.selector = "";

      /**
       * HttpRule body.
       * @member {string} body
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.body = "";

      /**
       * HttpRule additionalBindings.
       * @member {Array.<google.api.IHttpRule>} additionalBindings
       * @memberof google.api.HttpRule
       * @instance
       */
      HttpRule.prototype.additionalBindings = $util.emptyArray;

      // OneOf field names bound to virtual getters and setters
      var $oneOfFields;

      /**
       * HttpRule pattern.
       * @member {"get"|"put"|"post"|"delete"|"patch"|"custom"|undefined} pattern
       * @memberof google.api.HttpRule
       * @instance
       */
      Object.defineProperty(HttpRule.prototype, "pattern", {
        get: $util.oneOfGetter($oneOfFields = ["get", "put", "post", "delete", "patch", "custom"]),
        set: $util.oneOfSetter($oneOfFields)
      });

      /**
       * Creates a new HttpRule instance using the specified properties.
       * @function create
       * @memberof google.api.HttpRule
       * @static
       * @param {google.api.IHttpRule=} [properties] Properties to set
       * @returns {google.api.HttpRule} HttpRule instance
       */
      HttpRule.create = function create(properties) {
        return new HttpRule(properties);
      };

      /**
       * Encodes the specified HttpRule message. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
       * @function encode
       * @memberof google.api.HttpRule
       * @static
       * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      HttpRule.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.selector != null && message.hasOwnProperty("selector"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.selector);
        if (message.get != null && message.hasOwnProperty("get"))
          writer.uint32(/* id 2, wireType 2 =*/18).string(message.get);
        if (message.put != null && message.hasOwnProperty("put"))
          writer.uint32(/* id 3, wireType 2 =*/26).string(message.put);
        if (message.post != null && message.hasOwnProperty("post"))
          writer.uint32(/* id 4, wireType 2 =*/34).string(message.post);
        if (message["delete"] != null && message.hasOwnProperty("delete"))
          writer.uint32(/* id 5, wireType 2 =*/42).string(message["delete"]);
        if (message.patch != null && message.hasOwnProperty("patch"))
          writer.uint32(/* id 6, wireType 2 =*/50).string(message.patch);
        if (message.body != null && message.hasOwnProperty("body"))
          writer.uint32(/* id 7, wireType 2 =*/58).string(message.body);
        if (message.custom != null && message.hasOwnProperty("custom"))
          $root.google.api.CustomHttpPattern.encode(message.custom, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
        if (message.additionalBindings != null && message.additionalBindings.length)
          for (var i = 0; i < message.additionalBindings.length; ++i)
            $root.google.api.HttpRule.encode(message.additionalBindings[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified HttpRule message, length delimited. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.api.HttpRule
       * @static
       * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      HttpRule.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a HttpRule message from the specified reader or buffer.
       * @function decode
       * @memberof google.api.HttpRule
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.api.HttpRule} HttpRule
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      HttpRule.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.HttpRule();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 2:
              message.get = reader.string();
              break;
            case 3:
              message.put = reader.string();
              break;
            case 4:
              message.post = reader.string();
              break;
            case 5:
              message["delete"] = reader.string();
              break;
            case 6:
              message.patch = reader.string();
              break;
            case 8:
              message.custom = $root.google.api.CustomHttpPattern.decode(reader, reader.uint32());
              break;
            case 1:
              message.selector = reader.string();
              break;
            case 7:
              message.body = reader.string();
              break;
            case 11:
              if (!(message.additionalBindings && message.additionalBindings.length))
                message.additionalBindings = [];
              message.additionalBindings.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a HttpRule message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.api.HttpRule
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.api.HttpRule} HttpRule
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      HttpRule.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a HttpRule message.
       * @function verify
       * @memberof google.api.HttpRule
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      HttpRule.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        var properties = {};
        if (message.get != null && message.hasOwnProperty("get")) {
          properties.pattern = 1;
          if (!$util.isString(message.get))
            return "get: string expected";
        }
        if (message.put != null && message.hasOwnProperty("put")) {
          if (properties.pattern === 1)
            return "pattern: multiple values";
          properties.pattern = 1;
          if (!$util.isString(message.put))
            return "put: string expected";
        }
        if (message.post != null && message.hasOwnProperty("post")) {
          if (properties.pattern === 1)
            return "pattern: multiple values";
          properties.pattern = 1;
          if (!$util.isString(message.post))
            return "post: string expected";
        }
        if (message["delete"] != null && message.hasOwnProperty("delete")) {
          if (properties.pattern === 1)
            return "pattern: multiple values";
          properties.pattern = 1;
          if (!$util.isString(message["delete"]))
            return "delete: string expected";
        }
        if (message.patch != null && message.hasOwnProperty("patch")) {
          if (properties.pattern === 1)
            return "pattern: multiple values";
          properties.pattern = 1;
          if (!$util.isString(message.patch))
            return "patch: string expected";
        }
        if (message.custom != null && message.hasOwnProperty("custom")) {
          if (properties.pattern === 1)
            return "pattern: multiple values";
          properties.pattern = 1;
          {
            var error = $root.google.api.CustomHttpPattern.verify(message.custom);
            if (error)
              return "custom." + error;
          }
        }
        if (message.selector != null && message.hasOwnProperty("selector"))
          if (!$util.isString(message.selector))
            return "selector: string expected";
        if (message.body != null && message.hasOwnProperty("body"))
          if (!$util.isString(message.body))
            return "body: string expected";
        if (message.additionalBindings != null && message.hasOwnProperty("additionalBindings")) {
          if (!Array.isArray(message.additionalBindings))
            return "additionalBindings: array expected";
          for (var i = 0; i < message.additionalBindings.length; ++i) {
            var error = $root.google.api.HttpRule.verify(message.additionalBindings[i]);
            if (error)
              return "additionalBindings." + error;
          }
        }
        return null;
      };

      /**
       * Creates a HttpRule message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.api.HttpRule
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.api.HttpRule} HttpRule
       */
      HttpRule.fromObject = function fromObject(object) {
        if (object instanceof $root.google.api.HttpRule)
          return object;
        var message = new $root.google.api.HttpRule();
        if (object.get != null)
          message.get = String(object.get);
        if (object.put != null)
          message.put = String(object.put);
        if (object.post != null)
          message.post = String(object.post);
        if (object["delete"] != null)
          message["delete"] = String(object["delete"]);
        if (object.patch != null)
          message.patch = String(object.patch);
        if (object.custom != null) {
          if (typeof object.custom !== "object")
            throw TypeError(".google.api.HttpRule.custom: object expected");
          message.custom = $root.google.api.CustomHttpPattern.fromObject(object.custom);
        }
        if (object.selector != null)
          message.selector = String(object.selector);
        if (object.body != null)
          message.body = String(object.body);
        if (object.additionalBindings) {
          if (!Array.isArray(object.additionalBindings))
            throw TypeError(".google.api.HttpRule.additionalBindings: array expected");
          message.additionalBindings = [];
          for (var i = 0; i < object.additionalBindings.length; ++i) {
            if (typeof object.additionalBindings[i] !== "object")
              throw TypeError(".google.api.HttpRule.additionalBindings: object expected");
            message.additionalBindings[i] = $root.google.api.HttpRule.fromObject(object.additionalBindings[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a HttpRule message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.api.HttpRule
       * @static
       * @param {google.api.HttpRule} message HttpRule
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      HttpRule.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.additionalBindings = [];
        if (options.defaults) {
          object.selector = "";
          object.body = "";
        }
        if (message.selector != null && message.hasOwnProperty("selector"))
          object.selector = message.selector;
        if (message.get != null && message.hasOwnProperty("get")) {
          object.get = message.get;
          if (options.oneofs)
            object.pattern = "get";
        }
        if (message.put != null && message.hasOwnProperty("put")) {
          object.put = message.put;
          if (options.oneofs)
            object.pattern = "put";
        }
        if (message.post != null && message.hasOwnProperty("post")) {
          object.post = message.post;
          if (options.oneofs)
            object.pattern = "post";
        }
        if (message["delete"] != null && message.hasOwnProperty("delete")) {
          object["delete"] = message["delete"];
          if (options.oneofs)
            object.pattern = "delete";
        }
        if (message.patch != null && message.hasOwnProperty("patch")) {
          object.patch = message.patch;
          if (options.oneofs)
            object.pattern = "patch";
        }
        if (message.body != null && message.hasOwnProperty("body"))
          object.body = message.body;
        if (message.custom != null && message.hasOwnProperty("custom")) {
          object.custom = $root.google.api.CustomHttpPattern.toObject(message.custom, options);
          if (options.oneofs)
            object.pattern = "custom";
        }
        if (message.additionalBindings && message.additionalBindings.length) {
          object.additionalBindings = [];
          for (var j = 0; j < message.additionalBindings.length; ++j)
            object.additionalBindings[j] = $root.google.api.HttpRule.toObject(message.additionalBindings[j], options);
        }
        return object;
      };

      /**
       * Converts this HttpRule to JSON.
       * @function toJSON
       * @memberof google.api.HttpRule
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      HttpRule.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return HttpRule;
    })();

    api.CustomHttpPattern = (function() {

      /**
       * Properties of a CustomHttpPattern.
       * @memberof google.api
       * @interface ICustomHttpPattern
       * @property {string|null} [kind] CustomHttpPattern kind
       * @property {string|null} [path] CustomHttpPattern path
       */

      /**
       * Constructs a new CustomHttpPattern.
       * @memberof google.api
       * @classdesc Represents a CustomHttpPattern.
       * @implements ICustomHttpPattern
       * @constructor
       * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
       */
      function CustomHttpPattern(properties) {
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * CustomHttpPattern kind.
       * @member {string} kind
       * @memberof google.api.CustomHttpPattern
       * @instance
       */
      CustomHttpPattern.prototype.kind = "";

      /**
       * CustomHttpPattern path.
       * @member {string} path
       * @memberof google.api.CustomHttpPattern
       * @instance
       */
      CustomHttpPattern.prototype.path = "";

      /**
       * Creates a new CustomHttpPattern instance using the specified properties.
       * @function create
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
       * @returns {google.api.CustomHttpPattern} CustomHttpPattern instance
       */
      CustomHttpPattern.create = function create(properties) {
        return new CustomHttpPattern(properties);
      };

      /**
       * Encodes the specified CustomHttpPattern message. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
       * @function encode
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      CustomHttpPattern.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.kind != null && message.hasOwnProperty("kind"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.kind);
        if (message.path != null && message.hasOwnProperty("path"))
          writer.uint32(/* id 2, wireType 2 =*/18).string(message.path);
        return writer;
      };

      /**
       * Encodes the specified CustomHttpPattern message, length delimited. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      CustomHttpPattern.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a CustomHttpPattern message from the specified reader or buffer.
       * @function decode
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.api.CustomHttpPattern} CustomHttpPattern
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      CustomHttpPattern.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.CustomHttpPattern();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.kind = reader.string();
              break;
            case 2:
              message.path = reader.string();
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a CustomHttpPattern message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.api.CustomHttpPattern} CustomHttpPattern
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      CustomHttpPattern.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a CustomHttpPattern message.
       * @function verify
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      CustomHttpPattern.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.kind != null && message.hasOwnProperty("kind"))
          if (!$util.isString(message.kind))
            return "kind: string expected";
        if (message.path != null && message.hasOwnProperty("path"))
          if (!$util.isString(message.path))
            return "path: string expected";
        return null;
      };

      /**
       * Creates a CustomHttpPattern message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.api.CustomHttpPattern} CustomHttpPattern
       */
      CustomHttpPattern.fromObject = function fromObject(object) {
        if (object instanceof $root.google.api.CustomHttpPattern)
          return object;
        var message = new $root.google.api.CustomHttpPattern();
        if (object.kind != null)
          message.kind = String(object.kind);
        if (object.path != null)
          message.path = String(object.path);
        return message;
      };

      /**
       * Creates a plain object from a CustomHttpPattern message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.api.CustomHttpPattern
       * @static
       * @param {google.api.CustomHttpPattern} message CustomHttpPattern
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      CustomHttpPattern.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.defaults) {
          object.kind = "";
          object.path = "";
        }
        if (message.kind != null && message.hasOwnProperty("kind"))
          object.kind = message.kind;
        if (message.path != null && message.hasOwnProperty("path"))
          object.path = message.path;
        return object;
      };

      /**
       * Converts this CustomHttpPattern to JSON.
       * @function toJSON
       * @memberof google.api.CustomHttpPattern
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      CustomHttpPattern.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return CustomHttpPattern;
    })();

    return api;
  })();

  google.protobuf = (function() {

    /**
     * Namespace protobuf.
     * @memberof google
     * @namespace
     */
    var protobuf = {};

    protobuf.FileDescriptorSet = (function() {

      /**
       * Properties of a FileDescriptorSet.
       * @memberof google.protobuf
       * @interface IFileDescriptorSet
       * @property {Array.<google.protobuf.IFileDescriptorProto>|null} [file] FileDescriptorSet file
       */

      /**
       * Constructs a new FileDescriptorSet.
       * @memberof google.protobuf
       * @classdesc Represents a FileDescriptorSet.
       * @implements IFileDescriptorSet
       * @constructor
       * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
       */
      function FileDescriptorSet(properties) {
        this.file = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * FileDescriptorSet file.
       * @member {Array.<google.protobuf.IFileDescriptorProto>} file
       * @memberof google.protobuf.FileDescriptorSet
       * @instance
       */
      FileDescriptorSet.prototype.file = $util.emptyArray;

      /**
       * Creates a new FileDescriptorSet instance using the specified properties.
       * @function create
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
       * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet instance
       */
      FileDescriptorSet.create = function create(properties) {
        return new FileDescriptorSet(properties);
      };

      /**
       * Encodes the specified FileDescriptorSet message. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileDescriptorSet.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.file != null && message.file.length)
          for (var i = 0; i < message.file.length; ++i)
            $root.google.protobuf.FileDescriptorProto.encode(message.file[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified FileDescriptorSet message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileDescriptorSet.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a FileDescriptorSet message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileDescriptorSet.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorSet();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              if (!(message.file && message.file.length))
                message.file = [];
              message.file.push($root.google.protobuf.FileDescriptorProto.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a FileDescriptorSet message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileDescriptorSet.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a FileDescriptorSet message.
       * @function verify
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      FileDescriptorSet.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.file != null && message.hasOwnProperty("file")) {
          if (!Array.isArray(message.file))
            return "file: array expected";
          for (var i = 0; i < message.file.length; ++i) {
            var error = $root.google.protobuf.FileDescriptorProto.verify(message.file[i]);
            if (error)
              return "file." + error;
          }
        }
        return null;
      };

      /**
       * Creates a FileDescriptorSet message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
       */
      FileDescriptorSet.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.FileDescriptorSet)
          return object;
        var message = new $root.google.protobuf.FileDescriptorSet();
        if (object.file) {
          if (!Array.isArray(object.file))
            throw TypeError(".google.protobuf.FileDescriptorSet.file: array expected");
          message.file = [];
          for (var i = 0; i < object.file.length; ++i) {
            if (typeof object.file[i] !== "object")
              throw TypeError(".google.protobuf.FileDescriptorSet.file: object expected");
            message.file[i] = $root.google.protobuf.FileDescriptorProto.fromObject(object.file[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a FileDescriptorSet message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.FileDescriptorSet
       * @static
       * @param {google.protobuf.FileDescriptorSet} message FileDescriptorSet
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      FileDescriptorSet.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.file = [];
        if (message.file && message.file.length) {
          object.file = [];
          for (var j = 0; j < message.file.length; ++j)
            object.file[j] = $root.google.protobuf.FileDescriptorProto.toObject(message.file[j], options);
        }
        return object;
      };

      /**
       * Converts this FileDescriptorSet to JSON.
       * @function toJSON
       * @memberof google.protobuf.FileDescriptorSet
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      FileDescriptorSet.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return FileDescriptorSet;
    })();

    protobuf.FileDescriptorProto = (function() {

      /**
       * Properties of a FileDescriptorProto.
       * @memberof google.protobuf
       * @interface IFileDescriptorProto
       * @property {string|null} [name] FileDescriptorProto name
       * @property {string|null} ["package"] FileDescriptorProto package
       * @property {Array.<string>|null} [dependency] FileDescriptorProto dependency
       * @property {Array.<number>|null} [publicDependency] FileDescriptorProto publicDependency
       * @property {Array.<number>|null} [weakDependency] FileDescriptorProto weakDependency
       * @property {Array.<google.protobuf.IDescriptorProto>|null} [messageType] FileDescriptorProto messageType
       * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] FileDescriptorProto enumType
       * @property {Array.<google.protobuf.IServiceDescriptorProto>|null} [service] FileDescriptorProto service
       * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] FileDescriptorProto extension
       * @property {google.protobuf.IFileOptions|null} [options] FileDescriptorProto options
       * @property {google.protobuf.ISourceCodeInfo|null} [sourceCodeInfo] FileDescriptorProto sourceCodeInfo
       * @property {string|null} [syntax] FileDescriptorProto syntax
       */

      /**
       * Constructs a new FileDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents a FileDescriptorProto.
       * @implements IFileDescriptorProto
       * @constructor
       * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
       */
      function FileDescriptorProto(properties) {
        this.dependency = [];
        this.publicDependency = [];
        this.weakDependency = [];
        this.messageType = [];
        this.enumType = [];
        this.service = [];
        this.extension = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * FileDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.name = "";

      /**
       * FileDescriptorProto package.
       * @member {string} package
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype["package"] = "";

      /**
       * FileDescriptorProto dependency.
       * @member {Array.<string>} dependency
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.dependency = $util.emptyArray;

      /**
       * FileDescriptorProto publicDependency.
       * @member {Array.<number>} publicDependency
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.publicDependency = $util.emptyArray;

      /**
       * FileDescriptorProto weakDependency.
       * @member {Array.<number>} weakDependency
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.weakDependency = $util.emptyArray;

      /**
       * FileDescriptorProto messageType.
       * @member {Array.<google.protobuf.IDescriptorProto>} messageType
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.messageType = $util.emptyArray;

      /**
       * FileDescriptorProto enumType.
       * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.enumType = $util.emptyArray;

      /**
       * FileDescriptorProto service.
       * @member {Array.<google.protobuf.IServiceDescriptorProto>} service
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.service = $util.emptyArray;

      /**
       * FileDescriptorProto extension.
       * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.extension = $util.emptyArray;

      /**
       * FileDescriptorProto options.
       * @member {google.protobuf.IFileOptions|null|undefined} options
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.options = null;

      /**
       * FileDescriptorProto sourceCodeInfo.
       * @member {google.protobuf.ISourceCodeInfo|null|undefined} sourceCodeInfo
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.sourceCodeInfo = null;

      /**
       * FileDescriptorProto syntax.
       * @member {string} syntax
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       */
      FileDescriptorProto.prototype.syntax = "";

      /**
       * Creates a new FileDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto instance
       */
      FileDescriptorProto.create = function create(properties) {
        return new FileDescriptorProto(properties);
      };

      /**
       * Encodes the specified FileDescriptorProto message. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message["package"] != null && message.hasOwnProperty("package"))
          writer.uint32(/* id 2, wireType 2 =*/18).string(message["package"]);
        if (message.dependency != null && message.dependency.length)
          for (var i = 0; i < message.dependency.length; ++i)
            writer.uint32(/* id 3, wireType 2 =*/26).string(message.dependency[i]);
        if (message.messageType != null && message.messageType.length)
          for (var i = 0; i < message.messageType.length; ++i)
            $root.google.protobuf.DescriptorProto.encode(message.messageType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
        if (message.enumType != null && message.enumType.length)
          for (var i = 0; i < message.enumType.length; ++i)
            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
        if (message.service != null && message.service.length)
          for (var i = 0; i < message.service.length; ++i)
            $root.google.protobuf.ServiceDescriptorProto.encode(message.service[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
        if (message.extension != null && message.extension.length)
          for (var i = 0; i < message.extension.length; ++i)
            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.FileOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
        if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo"))
          $root.google.protobuf.SourceCodeInfo.encode(message.sourceCodeInfo, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
        if (message.publicDependency != null && message.publicDependency.length)
          for (var i = 0; i < message.publicDependency.length; ++i)
            writer.uint32(/* id 10, wireType 0 =*/80).int32(message.publicDependency[i]);
        if (message.weakDependency != null && message.weakDependency.length)
          for (var i = 0; i < message.weakDependency.length; ++i)
            writer.uint32(/* id 11, wireType 0 =*/88).int32(message.weakDependency[i]);
        if (message.syntax != null && message.hasOwnProperty("syntax"))
          writer.uint32(/* id 12, wireType 2 =*/98).string(message.syntax);
        return writer;
      };

      /**
       * Encodes the specified FileDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a FileDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              message["package"] = reader.string();
              break;
            case 3:
              if (!(message.dependency && message.dependency.length))
                message.dependency = [];
              message.dependency.push(reader.string());
              break;
            case 10:
              if (!(message.publicDependency && message.publicDependency.length))
                message.publicDependency = [];
              if ((tag & 7) === 2) {
                var end2 = reader.uint32() + reader.pos;
                while (reader.pos < end2)
                  message.publicDependency.push(reader.int32());
              } else
                message.publicDependency.push(reader.int32());
              break;
            case 11:
              if (!(message.weakDependency && message.weakDependency.length))
                message.weakDependency = [];
              if ((tag & 7) === 2) {
                var end2 = reader.uint32() + reader.pos;
                while (reader.pos < end2)
                  message.weakDependency.push(reader.int32());
              } else
                message.weakDependency.push(reader.int32());
              break;
            case 4:
              if (!(message.messageType && message.messageType.length))
                message.messageType = [];
              message.messageType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
              break;
            case 5:
              if (!(message.enumType && message.enumType.length))
                message.enumType = [];
              message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 6:
              if (!(message.service && message.service.length))
                message.service = [];
              message.service.push($root.google.protobuf.ServiceDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 7:
              if (!(message.extension && message.extension.length))
                message.extension = [];
              message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 8:
              message.options = $root.google.protobuf.FileOptions.decode(reader, reader.uint32());
              break;
            case 9:
              message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.decode(reader, reader.uint32());
              break;
            case 12:
              message.syntax = reader.string();
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a FileDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a FileDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      FileDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message["package"] != null && message.hasOwnProperty("package"))
          if (!$util.isString(message["package"]))
            return "package: string expected";
        if (message.dependency != null && message.hasOwnProperty("dependency")) {
          if (!Array.isArray(message.dependency))
            return "dependency: array expected";
          for (var i = 0; i < message.dependency.length; ++i)
            if (!$util.isString(message.dependency[i]))
              return "dependency: string[] expected";
        }
        if (message.publicDependency != null && message.hasOwnProperty("publicDependency")) {
          if (!Array.isArray(message.publicDependency))
            return "publicDependency: array expected";
          for (var i = 0; i < message.publicDependency.length; ++i)
            if (!$util.isInteger(message.publicDependency[i]))
              return "publicDependency: integer[] expected";
        }
        if (message.weakDependency != null && message.hasOwnProperty("weakDependency")) {
          if (!Array.isArray(message.weakDependency))
            return "weakDependency: array expected";
          for (var i = 0; i < message.weakDependency.length; ++i)
            if (!$util.isInteger(message.weakDependency[i]))
              return "weakDependency: integer[] expected";
        }
        if (message.messageType != null && message.hasOwnProperty("messageType")) {
          if (!Array.isArray(message.messageType))
            return "messageType: array expected";
          for (var i = 0; i < message.messageType.length; ++i) {
            var error = $root.google.protobuf.DescriptorProto.verify(message.messageType[i]);
            if (error)
              return "messageType." + error;
          }
        }
        if (message.enumType != null && message.hasOwnProperty("enumType")) {
          if (!Array.isArray(message.enumType))
            return "enumType: array expected";
          for (var i = 0; i < message.enumType.length; ++i) {
            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
            if (error)
              return "enumType." + error;
          }
        }
        if (message.service != null && message.hasOwnProperty("service")) {
          if (!Array.isArray(message.service))
            return "service: array expected";
          for (var i = 0; i < message.service.length; ++i) {
            var error = $root.google.protobuf.ServiceDescriptorProto.verify(message.service[i]);
            if (error)
              return "service." + error;
          }
        }
        if (message.extension != null && message.hasOwnProperty("extension")) {
          if (!Array.isArray(message.extension))
            return "extension: array expected";
          for (var i = 0; i < message.extension.length; ++i) {
            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
            if (error)
              return "extension." + error;
          }
        }
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.FileOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo")) {
          var error = $root.google.protobuf.SourceCodeInfo.verify(message.sourceCodeInfo);
          if (error)
            return "sourceCodeInfo." + error;
        }
        if (message.syntax != null && message.hasOwnProperty("syntax"))
          if (!$util.isString(message.syntax))
            return "syntax: string expected";
        return null;
      };

      /**
       * Creates a FileDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
       */
      FileDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.FileDescriptorProto)
          return object;
        var message = new $root.google.protobuf.FileDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object["package"] != null)
          message["package"] = String(object["package"]);
        if (object.dependency) {
          if (!Array.isArray(object.dependency))
            throw TypeError(".google.protobuf.FileDescriptorProto.dependency: array expected");
          message.dependency = [];
          for (var i = 0; i < object.dependency.length; ++i)
            message.dependency[i] = String(object.dependency[i]);
        }
        if (object.publicDependency) {
          if (!Array.isArray(object.publicDependency))
            throw TypeError(".google.protobuf.FileDescriptorProto.publicDependency: array expected");
          message.publicDependency = [];
          for (var i = 0; i < object.publicDependency.length; ++i)
            message.publicDependency[i] = object.publicDependency[i] | 0;
        }
        if (object.weakDependency) {
          if (!Array.isArray(object.weakDependency))
            throw TypeError(".google.protobuf.FileDescriptorProto.weakDependency: array expected");
          message.weakDependency = [];
          for (var i = 0; i < object.weakDependency.length; ++i)
            message.weakDependency[i] = object.weakDependency[i] | 0;
        }
        if (object.messageType) {
          if (!Array.isArray(object.messageType))
            throw TypeError(".google.protobuf.FileDescriptorProto.messageType: array expected");
          message.messageType = [];
          for (var i = 0; i < object.messageType.length; ++i) {
            if (typeof object.messageType[i] !== "object")
              throw TypeError(".google.protobuf.FileDescriptorProto.messageType: object expected");
            message.messageType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.messageType[i]);
          }
        }
        if (object.enumType) {
          if (!Array.isArray(object.enumType))
            throw TypeError(".google.protobuf.FileDescriptorProto.enumType: array expected");
          message.enumType = [];
          for (var i = 0; i < object.enumType.length; ++i) {
            if (typeof object.enumType[i] !== "object")
              throw TypeError(".google.protobuf.FileDescriptorProto.enumType: object expected");
            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
          }
        }
        if (object.service) {
          if (!Array.isArray(object.service))
            throw TypeError(".google.protobuf.FileDescriptorProto.service: array expected");
          message.service = [];
          for (var i = 0; i < object.service.length; ++i) {
            if (typeof object.service[i] !== "object")
              throw TypeError(".google.protobuf.FileDescriptorProto.service: object expected");
            message.service[i] = $root.google.protobuf.ServiceDescriptorProto.fromObject(object.service[i]);
          }
        }
        if (object.extension) {
          if (!Array.isArray(object.extension))
            throw TypeError(".google.protobuf.FileDescriptorProto.extension: array expected");
          message.extension = [];
          for (var i = 0; i < object.extension.length; ++i) {
            if (typeof object.extension[i] !== "object")
              throw TypeError(".google.protobuf.FileDescriptorProto.extension: object expected");
            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
          }
        }
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.FileDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.FileOptions.fromObject(object.options);
        }
        if (object.sourceCodeInfo != null) {
          if (typeof object.sourceCodeInfo !== "object")
            throw TypeError(".google.protobuf.FileDescriptorProto.sourceCodeInfo: object expected");
          message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.fromObject(object.sourceCodeInfo);
        }
        if (object.syntax != null)
          message.syntax = String(object.syntax);
        return message;
      };

      /**
       * Creates a plain object from a FileDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.FileDescriptorProto
       * @static
       * @param {google.protobuf.FileDescriptorProto} message FileDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      FileDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults) {
          object.dependency = [];
          object.messageType = [];
          object.enumType = [];
          object.service = [];
          object.extension = [];
          object.publicDependency = [];
          object.weakDependency = [];
        }
        if (options.defaults) {
          object.name = "";
          object["package"] = "";
          object.options = null;
          object.sourceCodeInfo = null;
          object.syntax = "";
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message["package"] != null && message.hasOwnProperty("package"))
          object["package"] = message["package"];
        if (message.dependency && message.dependency.length) {
          object.dependency = [];
          for (var j = 0; j < message.dependency.length; ++j)
            object.dependency[j] = message.dependency[j];
        }
        if (message.messageType && message.messageType.length) {
          object.messageType = [];
          for (var j = 0; j < message.messageType.length; ++j)
            object.messageType[j] = $root.google.protobuf.DescriptorProto.toObject(message.messageType[j], options);
        }
        if (message.enumType && message.enumType.length) {
          object.enumType = [];
          for (var j = 0; j < message.enumType.length; ++j)
            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
        }
        if (message.service && message.service.length) {
          object.service = [];
          for (var j = 0; j < message.service.length; ++j)
            object.service[j] = $root.google.protobuf.ServiceDescriptorProto.toObject(message.service[j], options);
        }
        if (message.extension && message.extension.length) {
          object.extension = [];
          for (var j = 0; j < message.extension.length; ++j)
            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
        }
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.FileOptions.toObject(message.options, options);
        if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo"))
          object.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.toObject(message.sourceCodeInfo, options);
        if (message.publicDependency && message.publicDependency.length) {
          object.publicDependency = [];
          for (var j = 0; j < message.publicDependency.length; ++j)
            object.publicDependency[j] = message.publicDependency[j];
        }
        if (message.weakDependency && message.weakDependency.length) {
          object.weakDependency = [];
          for (var j = 0; j < message.weakDependency.length; ++j)
            object.weakDependency[j] = message.weakDependency[j];
        }
        if (message.syntax != null && message.hasOwnProperty("syntax"))
          object.syntax = message.syntax;
        return object;
      };

      /**
       * Converts this FileDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.FileDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      FileDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return FileDescriptorProto;
    })();

    protobuf.DescriptorProto = (function() {

      /**
       * Properties of a DescriptorProto.
       * @memberof google.protobuf
       * @interface IDescriptorProto
       * @property {string|null} [name] DescriptorProto name
       * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [field] DescriptorProto field
       * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] DescriptorProto extension
       * @property {Array.<google.protobuf.IDescriptorProto>|null} [nestedType] DescriptorProto nestedType
       * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] DescriptorProto enumType
       * @property {Array.<google.protobuf.DescriptorProto.IExtensionRange>|null} [extensionRange] DescriptorProto extensionRange
       * @property {Array.<google.protobuf.IOneofDescriptorProto>|null} [oneofDecl] DescriptorProto oneofDecl
       * @property {google.protobuf.IMessageOptions|null} [options] DescriptorProto options
       * @property {Array.<google.protobuf.DescriptorProto.IReservedRange>|null} [reservedRange] DescriptorProto reservedRange
       * @property {Array.<string>|null} [reservedName] DescriptorProto reservedName
       */

      /**
       * Constructs a new DescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents a DescriptorProto.
       * @implements IDescriptorProto
       * @constructor
       * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
       */
      function DescriptorProto(properties) {
        this.field = [];
        this.extension = [];
        this.nestedType = [];
        this.enumType = [];
        this.extensionRange = [];
        this.oneofDecl = [];
        this.reservedRange = [];
        this.reservedName = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * DescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.name = "";

      /**
       * DescriptorProto field.
       * @member {Array.<google.protobuf.IFieldDescriptorProto>} field
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.field = $util.emptyArray;

      /**
       * DescriptorProto extension.
       * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.extension = $util.emptyArray;

      /**
       * DescriptorProto nestedType.
       * @member {Array.<google.protobuf.IDescriptorProto>} nestedType
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.nestedType = $util.emptyArray;

      /**
       * DescriptorProto enumType.
       * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.enumType = $util.emptyArray;

      /**
       * DescriptorProto extensionRange.
       * @member {Array.<google.protobuf.DescriptorProto.IExtensionRange>} extensionRange
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.extensionRange = $util.emptyArray;

      /**
       * DescriptorProto oneofDecl.
       * @member {Array.<google.protobuf.IOneofDescriptorProto>} oneofDecl
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.oneofDecl = $util.emptyArray;

      /**
       * DescriptorProto options.
       * @member {google.protobuf.IMessageOptions|null|undefined} options
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.options = null;

      /**
       * DescriptorProto reservedRange.
       * @member {Array.<google.protobuf.DescriptorProto.IReservedRange>} reservedRange
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.reservedRange = $util.emptyArray;

      /**
       * DescriptorProto reservedName.
       * @member {Array.<string>} reservedName
       * @memberof google.protobuf.DescriptorProto
       * @instance
       */
      DescriptorProto.prototype.reservedName = $util.emptyArray;

      /**
       * Creates a new DescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.DescriptorProto} DescriptorProto instance
       */
      DescriptorProto.create = function create(properties) {
        return new DescriptorProto(properties);
      };

      /**
       * Encodes the specified DescriptorProto message. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      DescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.field != null && message.field.length)
          for (var i = 0; i < message.field.length; ++i)
            $root.google.protobuf.FieldDescriptorProto.encode(message.field[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
        if (message.nestedType != null && message.nestedType.length)
          for (var i = 0; i < message.nestedType.length; ++i)
            $root.google.protobuf.DescriptorProto.encode(message.nestedType[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
        if (message.enumType != null && message.enumType.length)
          for (var i = 0; i < message.enumType.length; ++i)
            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
        if (message.extensionRange != null && message.extensionRange.length)
          for (var i = 0; i < message.extensionRange.length; ++i)
            $root.google.protobuf.DescriptorProto.ExtensionRange.encode(message.extensionRange[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
        if (message.extension != null && message.extension.length)
          for (var i = 0; i < message.extension.length; ++i)
            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.MessageOptions.encode(message.options, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
        if (message.oneofDecl != null && message.oneofDecl.length)
          for (var i = 0; i < message.oneofDecl.length; ++i)
            $root.google.protobuf.OneofDescriptorProto.encode(message.oneofDecl[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
        if (message.reservedRange != null && message.reservedRange.length)
          for (var i = 0; i < message.reservedRange.length; ++i)
            $root.google.protobuf.DescriptorProto.ReservedRange.encode(message.reservedRange[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
        if (message.reservedName != null && message.reservedName.length)
          for (var i = 0; i < message.reservedName.length; ++i)
            writer.uint32(/* id 10, wireType 2 =*/82).string(message.reservedName[i]);
        return writer;
      };

      /**
       * Encodes the specified DescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      DescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a DescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.DescriptorProto} DescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      DescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              if (!(message.field && message.field.length))
                message.field = [];
              message.field.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 6:
              if (!(message.extension && message.extension.length))
                message.extension = [];
              message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 3:
              if (!(message.nestedType && message.nestedType.length))
                message.nestedType = [];
              message.nestedType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
              break;
            case 4:
              if (!(message.enumType && message.enumType.length))
                message.enumType = [];
              message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 5:
              if (!(message.extensionRange && message.extensionRange.length))
                message.extensionRange = [];
              message.extensionRange.push($root.google.protobuf.DescriptorProto.ExtensionRange.decode(reader, reader.uint32()));
              break;
            case 8:
              if (!(message.oneofDecl && message.oneofDecl.length))
                message.oneofDecl = [];
              message.oneofDecl.push($root.google.protobuf.OneofDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 7:
              message.options = $root.google.protobuf.MessageOptions.decode(reader, reader.uint32());
              break;
            case 9:
              if (!(message.reservedRange && message.reservedRange.length))
                message.reservedRange = [];
              message.reservedRange.push($root.google.protobuf.DescriptorProto.ReservedRange.decode(reader, reader.uint32()));
              break;
            case 10:
              if (!(message.reservedName && message.reservedName.length))
                message.reservedName = [];
              message.reservedName.push(reader.string());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a DescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.DescriptorProto} DescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      DescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a DescriptorProto message.
       * @function verify
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      DescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.field != null && message.hasOwnProperty("field")) {
          if (!Array.isArray(message.field))
            return "field: array expected";
          for (var i = 0; i < message.field.length; ++i) {
            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.field[i]);
            if (error)
              return "field." + error;
          }
        }
        if (message.extension != null && message.hasOwnProperty("extension")) {
          if (!Array.isArray(message.extension))
            return "extension: array expected";
          for (var i = 0; i < message.extension.length; ++i) {
            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
            if (error)
              return "extension." + error;
          }
        }
        if (message.nestedType != null && message.hasOwnProperty("nestedType")) {
          if (!Array.isArray(message.nestedType))
            return "nestedType: array expected";
          for (var i = 0; i < message.nestedType.length; ++i) {
            var error = $root.google.protobuf.DescriptorProto.verify(message.nestedType[i]);
            if (error)
              return "nestedType." + error;
          }
        }
        if (message.enumType != null && message.hasOwnProperty("enumType")) {
          if (!Array.isArray(message.enumType))
            return "enumType: array expected";
          for (var i = 0; i < message.enumType.length; ++i) {
            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
            if (error)
              return "enumType." + error;
          }
        }
        if (message.extensionRange != null && message.hasOwnProperty("extensionRange")) {
          if (!Array.isArray(message.extensionRange))
            return "extensionRange: array expected";
          for (var i = 0; i < message.extensionRange.length; ++i) {
            var error = $root.google.protobuf.DescriptorProto.ExtensionRange.verify(message.extensionRange[i]);
            if (error)
              return "extensionRange." + error;
          }
        }
        if (message.oneofDecl != null && message.hasOwnProperty("oneofDecl")) {
          if (!Array.isArray(message.oneofDecl))
            return "oneofDecl: array expected";
          for (var i = 0; i < message.oneofDecl.length; ++i) {
            var error = $root.google.protobuf.OneofDescriptorProto.verify(message.oneofDecl[i]);
            if (error)
              return "oneofDecl." + error;
          }
        }
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.MessageOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        if (message.reservedRange != null && message.hasOwnProperty("reservedRange")) {
          if (!Array.isArray(message.reservedRange))
            return "reservedRange: array expected";
          for (var i = 0; i < message.reservedRange.length; ++i) {
            var error = $root.google.protobuf.DescriptorProto.ReservedRange.verify(message.reservedRange[i]);
            if (error)
              return "reservedRange." + error;
          }
        }
        if (message.reservedName != null && message.hasOwnProperty("reservedName")) {
          if (!Array.isArray(message.reservedName))
            return "reservedName: array expected";
          for (var i = 0; i < message.reservedName.length; ++i)
            if (!$util.isString(message.reservedName[i]))
              return "reservedName: string[] expected";
        }
        return null;
      };

      /**
       * Creates a DescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.DescriptorProto} DescriptorProto
       */
      DescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.DescriptorProto)
          return object;
        var message = new $root.google.protobuf.DescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.field) {
          if (!Array.isArray(object.field))
            throw TypeError(".google.protobuf.DescriptorProto.field: array expected");
          message.field = [];
          for (var i = 0; i < object.field.length; ++i) {
            if (typeof object.field[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.field: object expected");
            message.field[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.field[i]);
          }
        }
        if (object.extension) {
          if (!Array.isArray(object.extension))
            throw TypeError(".google.protobuf.DescriptorProto.extension: array expected");
          message.extension = [];
          for (var i = 0; i < object.extension.length; ++i) {
            if (typeof object.extension[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.extension: object expected");
            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
          }
        }
        if (object.nestedType) {
          if (!Array.isArray(object.nestedType))
            throw TypeError(".google.protobuf.DescriptorProto.nestedType: array expected");
          message.nestedType = [];
          for (var i = 0; i < object.nestedType.length; ++i) {
            if (typeof object.nestedType[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.nestedType: object expected");
            message.nestedType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.nestedType[i]);
          }
        }
        if (object.enumType) {
          if (!Array.isArray(object.enumType))
            throw TypeError(".google.protobuf.DescriptorProto.enumType: array expected");
          message.enumType = [];
          for (var i = 0; i < object.enumType.length; ++i) {
            if (typeof object.enumType[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.enumType: object expected");
            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
          }
        }
        if (object.extensionRange) {
          if (!Array.isArray(object.extensionRange))
            throw TypeError(".google.protobuf.DescriptorProto.extensionRange: array expected");
          message.extensionRange = [];
          for (var i = 0; i < object.extensionRange.length; ++i) {
            if (typeof object.extensionRange[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.extensionRange: object expected");
            message.extensionRange[i] = $root.google.protobuf.DescriptorProto.ExtensionRange.fromObject(object.extensionRange[i]);
          }
        }
        if (object.oneofDecl) {
          if (!Array.isArray(object.oneofDecl))
            throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: array expected");
          message.oneofDecl = [];
          for (var i = 0; i < object.oneofDecl.length; ++i) {
            if (typeof object.oneofDecl[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: object expected");
            message.oneofDecl[i] = $root.google.protobuf.OneofDescriptorProto.fromObject(object.oneofDecl[i]);
          }
        }
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.DescriptorProto.options: object expected");
          message.options = $root.google.protobuf.MessageOptions.fromObject(object.options);
        }
        if (object.reservedRange) {
          if (!Array.isArray(object.reservedRange))
            throw TypeError(".google.protobuf.DescriptorProto.reservedRange: array expected");
          message.reservedRange = [];
          for (var i = 0; i < object.reservedRange.length; ++i) {
            if (typeof object.reservedRange[i] !== "object")
              throw TypeError(".google.protobuf.DescriptorProto.reservedRange: object expected");
            message.reservedRange[i] = $root.google.protobuf.DescriptorProto.ReservedRange.fromObject(object.reservedRange[i]);
          }
        }
        if (object.reservedName) {
          if (!Array.isArray(object.reservedName))
            throw TypeError(".google.protobuf.DescriptorProto.reservedName: array expected");
          message.reservedName = [];
          for (var i = 0; i < object.reservedName.length; ++i)
            message.reservedName[i] = String(object.reservedName[i]);
        }
        return message;
      };

      /**
       * Creates a plain object from a DescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.DescriptorProto
       * @static
       * @param {google.protobuf.DescriptorProto} message DescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      DescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults) {
          object.field = [];
          object.nestedType = [];
          object.enumType = [];
          object.extensionRange = [];
          object.extension = [];
          object.oneofDecl = [];
          object.reservedRange = [];
          object.reservedName = [];
        }
        if (options.defaults) {
          object.name = "";
          object.options = null;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.field && message.field.length) {
          object.field = [];
          for (var j = 0; j < message.field.length; ++j)
            object.field[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.field[j], options);
        }
        if (message.nestedType && message.nestedType.length) {
          object.nestedType = [];
          for (var j = 0; j < message.nestedType.length; ++j)
            object.nestedType[j] = $root.google.protobuf.DescriptorProto.toObject(message.nestedType[j], options);
        }
        if (message.enumType && message.enumType.length) {
          object.enumType = [];
          for (var j = 0; j < message.enumType.length; ++j)
            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
        }
        if (message.extensionRange && message.extensionRange.length) {
          object.extensionRange = [];
          for (var j = 0; j < message.extensionRange.length; ++j)
            object.extensionRange[j] = $root.google.protobuf.DescriptorProto.ExtensionRange.toObject(message.extensionRange[j], options);
        }
        if (message.extension && message.extension.length) {
          object.extension = [];
          for (var j = 0; j < message.extension.length; ++j)
            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
        }
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.MessageOptions.toObject(message.options, options);
        if (message.oneofDecl && message.oneofDecl.length) {
          object.oneofDecl = [];
          for (var j = 0; j < message.oneofDecl.length; ++j)
            object.oneofDecl[j] = $root.google.protobuf.OneofDescriptorProto.toObject(message.oneofDecl[j], options);
        }
        if (message.reservedRange && message.reservedRange.length) {
          object.reservedRange = [];
          for (var j = 0; j < message.reservedRange.length; ++j)
            object.reservedRange[j] = $root.google.protobuf.DescriptorProto.ReservedRange.toObject(message.reservedRange[j], options);
        }
        if (message.reservedName && message.reservedName.length) {
          object.reservedName = [];
          for (var j = 0; j < message.reservedName.length; ++j)
            object.reservedName[j] = message.reservedName[j];
        }
        return object;
      };

      /**
       * Converts this DescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.DescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      DescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      DescriptorProto.ExtensionRange = (function() {

        /**
         * Properties of an ExtensionRange.
         * @memberof google.protobuf.DescriptorProto
         * @interface IExtensionRange
         * @property {number|null} [start] ExtensionRange start
         * @property {number|null} [end] ExtensionRange end
         */

        /**
         * Constructs a new ExtensionRange.
         * @memberof google.protobuf.DescriptorProto
         * @classdesc Represents an ExtensionRange.
         * @implements IExtensionRange
         * @constructor
         * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
         */
        function ExtensionRange(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExtensionRange start.
         * @member {number} start
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @instance
         */
        ExtensionRange.prototype.start = 0;

        /**
         * ExtensionRange end.
         * @member {number} end
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @instance
         */
        ExtensionRange.prototype.end = 0;

        /**
         * Creates a new ExtensionRange instance using the specified properties.
         * @function create
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
         * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange instance
         */
        ExtensionRange.create = function create(properties) {
          return new ExtensionRange(properties);
        };

        /**
         * Encodes the specified ExtensionRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
         * @function encode
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtensionRange.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.start != null && message.hasOwnProperty("start"))
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
          if (message.end != null && message.hasOwnProperty("end"))
            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
          return writer;
        };

        /**
         * Encodes the specified ExtensionRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtensionRange.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExtensionRange message from the specified reader or buffer.
         * @function decode
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtensionRange.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.start = reader.int32();
                break;
              case 2:
                message.end = reader.int32();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes an ExtensionRange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtensionRange.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExtensionRange message.
         * @function verify
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExtensionRange.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.start != null && message.hasOwnProperty("start"))
            if (!$util.isInteger(message.start))
              return "start: integer expected";
          if (message.end != null && message.hasOwnProperty("end"))
            if (!$util.isInteger(message.end))
              return "end: integer expected";
          return null;
        };

        /**
         * Creates an ExtensionRange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
         */
        ExtensionRange.fromObject = function fromObject(object) {
          if (object instanceof $root.google.protobuf.DescriptorProto.ExtensionRange)
            return object;
          var message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
          if (object.start != null)
            message.start = object.start | 0;
          if (object.end != null)
            message.end = object.end | 0;
          return message;
        };

        /**
         * Creates a plain object from an ExtensionRange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @static
         * @param {google.protobuf.DescriptorProto.ExtensionRange} message ExtensionRange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExtensionRange.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.start = 0;
            object.end = 0;
          }
          if (message.start != null && message.hasOwnProperty("start"))
            object.start = message.start;
          if (message.end != null && message.hasOwnProperty("end"))
            object.end = message.end;
          return object;
        };

        /**
         * Converts this ExtensionRange to JSON.
         * @function toJSON
         * @memberof google.protobuf.DescriptorProto.ExtensionRange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExtensionRange.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExtensionRange;
      })();

      DescriptorProto.ReservedRange = (function() {

        /**
         * Properties of a ReservedRange.
         * @memberof google.protobuf.DescriptorProto
         * @interface IReservedRange
         * @property {number|null} [start] ReservedRange start
         * @property {number|null} [end] ReservedRange end
         */

        /**
         * Constructs a new ReservedRange.
         * @memberof google.protobuf.DescriptorProto
         * @classdesc Represents a ReservedRange.
         * @implements IReservedRange
         * @constructor
         * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
         */
        function ReservedRange(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * ReservedRange start.
         * @member {number} start
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @instance
         */
        ReservedRange.prototype.start = 0;

        /**
         * ReservedRange end.
         * @member {number} end
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @instance
         */
        ReservedRange.prototype.end = 0;

        /**
         * Creates a new ReservedRange instance using the specified properties.
         * @function create
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
         * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange instance
         */
        ReservedRange.create = function create(properties) {
          return new ReservedRange(properties);
        };

        /**
         * Encodes the specified ReservedRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
         * @function encode
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReservedRange.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          if (message.start != null && message.hasOwnProperty("start"))
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
          if (message.end != null && message.hasOwnProperty("end"))
            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
          return writer;
        };

        /**
         * Encodes the specified ReservedRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReservedRange.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ReservedRange message from the specified reader or buffer.
         * @function decode
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReservedRange.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ReservedRange();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.start = reader.int32();
                break;
              case 2:
                message.end = reader.int32();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          return message;
        };

        /**
         * Decodes a ReservedRange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReservedRange.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ReservedRange message.
         * @function verify
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ReservedRange.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (message.start != null && message.hasOwnProperty("start"))
            if (!$util.isInteger(message.start))
              return "start: integer expected";
          if (message.end != null && message.hasOwnProperty("end"))
            if (!$util.isInteger(message.end))
              return "end: integer expected";
          return null;
        };

        /**
         * Creates a ReservedRange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
         */
        ReservedRange.fromObject = function fromObject(object) {
          if (object instanceof $root.google.protobuf.DescriptorProto.ReservedRange)
            return object;
          var message = new $root.google.protobuf.DescriptorProto.ReservedRange();
          if (object.start != null)
            message.start = object.start | 0;
          if (object.end != null)
            message.end = object.end | 0;
          return message;
        };

        /**
         * Creates a plain object from a ReservedRange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @static
         * @param {google.protobuf.DescriptorProto.ReservedRange} message ReservedRange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ReservedRange.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.start = 0;
            object.end = 0;
          }
          if (message.start != null && message.hasOwnProperty("start"))
            object.start = message.start;
          if (message.end != null && message.hasOwnProperty("end"))
            object.end = message.end;
          return object;
        };

        /**
         * Converts this ReservedRange to JSON.
         * @function toJSON
         * @memberof google.protobuf.DescriptorProto.ReservedRange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ReservedRange.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ReservedRange;
      })();

      return DescriptorProto;
    })();

    protobuf.FieldDescriptorProto = (function() {

      /**
       * Properties of a FieldDescriptorProto.
       * @memberof google.protobuf
       * @interface IFieldDescriptorProto
       * @property {string|null} [name] FieldDescriptorProto name
       * @property {number|null} [number] FieldDescriptorProto number
       * @property {google.protobuf.FieldDescriptorProto.Label|null} [label] FieldDescriptorProto label
       * @property {google.protobuf.FieldDescriptorProto.Type|null} [type] FieldDescriptorProto type
       * @property {string|null} [typeName] FieldDescriptorProto typeName
       * @property {string|null} [extendee] FieldDescriptorProto extendee
       * @property {string|null} [defaultValue] FieldDescriptorProto defaultValue
       * @property {number|null} [oneofIndex] FieldDescriptorProto oneofIndex
       * @property {string|null} [jsonName] FieldDescriptorProto jsonName
       * @property {google.protobuf.IFieldOptions|null} [options] FieldDescriptorProto options
       */

      /**
       * Constructs a new FieldDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents a FieldDescriptorProto.
       * @implements IFieldDescriptorProto
       * @constructor
       * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
       */
      function FieldDescriptorProto(properties) {
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * FieldDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.name = "";

      /**
       * FieldDescriptorProto number.
       * @member {number} number
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.number = 0;

      /**
       * FieldDescriptorProto label.
       * @member {google.protobuf.FieldDescriptorProto.Label} label
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.label = 1;

      /**
       * FieldDescriptorProto type.
       * @member {google.protobuf.FieldDescriptorProto.Type} type
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.type = 1;

      /**
       * FieldDescriptorProto typeName.
       * @member {string} typeName
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.typeName = "";

      /**
       * FieldDescriptorProto extendee.
       * @member {string} extendee
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.extendee = "";

      /**
       * FieldDescriptorProto defaultValue.
       * @member {string} defaultValue
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.defaultValue = "";

      /**
       * FieldDescriptorProto oneofIndex.
       * @member {number} oneofIndex
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.oneofIndex = 0;

      /**
       * FieldDescriptorProto jsonName.
       * @member {string} jsonName
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.jsonName = "";

      /**
       * FieldDescriptorProto options.
       * @member {google.protobuf.IFieldOptions|null|undefined} options
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       */
      FieldDescriptorProto.prototype.options = null;

      /**
       * Creates a new FieldDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto instance
       */
      FieldDescriptorProto.create = function create(properties) {
        return new FieldDescriptorProto(properties);
      };

      /**
       * Encodes the specified FieldDescriptorProto message. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FieldDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.extendee != null && message.hasOwnProperty("extendee"))
          writer.uint32(/* id 2, wireType 2 =*/18).string(message.extendee);
        if (message.number != null && message.hasOwnProperty("number"))
          writer.uint32(/* id 3, wireType 0 =*/24).int32(message.number);
        if (message.label != null && message.hasOwnProperty("label"))
          writer.uint32(/* id 4, wireType 0 =*/32).int32(message.label);
        if (message.type != null && message.hasOwnProperty("type"))
          writer.uint32(/* id 5, wireType 0 =*/40).int32(message.type);
        if (message.typeName != null && message.hasOwnProperty("typeName"))
          writer.uint32(/* id 6, wireType 2 =*/50).string(message.typeName);
        if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
          writer.uint32(/* id 7, wireType 2 =*/58).string(message.defaultValue);
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.FieldOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
        if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
          writer.uint32(/* id 9, wireType 0 =*/72).int32(message.oneofIndex);
        if (message.jsonName != null && message.hasOwnProperty("jsonName"))
          writer.uint32(/* id 10, wireType 2 =*/82).string(message.jsonName);
        return writer;
      };

      /**
       * Encodes the specified FieldDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FieldDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a FieldDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FieldDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 3:
              message.number = reader.int32();
              break;
            case 4:
              message.label = reader.int32();
              break;
            case 5:
              message.type = reader.int32();
              break;
            case 6:
              message.typeName = reader.string();
              break;
            case 2:
              message.extendee = reader.string();
              break;
            case 7:
              message.defaultValue = reader.string();
              break;
            case 9:
              message.oneofIndex = reader.int32();
              break;
            case 10:
              message.jsonName = reader.string();
              break;
            case 8:
              message.options = $root.google.protobuf.FieldOptions.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a FieldDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FieldDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a FieldDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      FieldDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.number != null && message.hasOwnProperty("number"))
          if (!$util.isInteger(message.number))
            return "number: integer expected";
        if (message.label != null && message.hasOwnProperty("label"))
          switch (message.label) {
            default:
              return "label: enum value expected";
            case 1:
            case 2:
            case 3:
              break;
          }
        if (message.type != null && message.hasOwnProperty("type"))
          switch (message.type) {
            default:
              return "type: enum value expected";
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 15:
            case 16:
            case 17:
            case 18:
              break;
          }
        if (message.typeName != null && message.hasOwnProperty("typeName"))
          if (!$util.isString(message.typeName))
            return "typeName: string expected";
        if (message.extendee != null && message.hasOwnProperty("extendee"))
          if (!$util.isString(message.extendee))
            return "extendee: string expected";
        if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
          if (!$util.isString(message.defaultValue))
            return "defaultValue: string expected";
        if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
          if (!$util.isInteger(message.oneofIndex))
            return "oneofIndex: integer expected";
        if (message.jsonName != null && message.hasOwnProperty("jsonName"))
          if (!$util.isString(message.jsonName))
            return "jsonName: string expected";
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.FieldOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        return null;
      };

      /**
       * Creates a FieldDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
       */
      FieldDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.FieldDescriptorProto)
          return object;
        var message = new $root.google.protobuf.FieldDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.number != null)
          message.number = object.number | 0;
        switch (object.label) {
          case "LABEL_OPTIONAL":
          case 1:
            message.label = 1;
            break;
          case "LABEL_REQUIRED":
          case 2:
            message.label = 2;
            break;
          case "LABEL_REPEATED":
          case 3:
            message.label = 3;
            break;
        }
        switch (object.type) {
          case "TYPE_DOUBLE":
          case 1:
            message.type = 1;
            break;
          case "TYPE_FLOAT":
          case 2:
            message.type = 2;
            break;
          case "TYPE_INT64":
          case 3:
            message.type = 3;
            break;
          case "TYPE_UINT64":
          case 4:
            message.type = 4;
            break;
          case "TYPE_INT32":
          case 5:
            message.type = 5;
            break;
          case "TYPE_FIXED64":
          case 6:
            message.type = 6;
            break;
          case "TYPE_FIXED32":
          case 7:
            message.type = 7;
            break;
          case "TYPE_BOOL":
          case 8:
            message.type = 8;
            break;
          case "TYPE_STRING":
          case 9:
            message.type = 9;
            break;
          case "TYPE_GROUP":
          case 10:
            message.type = 10;
            break;
          case "TYPE_MESSAGE":
          case 11:
            message.type = 11;
            break;
          case "TYPE_BYTES":
          case 12:
            message.type = 12;
            break;
          case "TYPE_UINT32":
          case 13:
            message.type = 13;
            break;
          case "TYPE_ENUM":
          case 14:
            message.type = 14;
            break;
          case "TYPE_SFIXED32":
          case 15:
            message.type = 15;
            break;
          case "TYPE_SFIXED64":
          case 16:
            message.type = 16;
            break;
          case "TYPE_SINT32":
          case 17:
            message.type = 17;
            break;
          case "TYPE_SINT64":
          case 18:
            message.type = 18;
            break;
        }
        if (object.typeName != null)
          message.typeName = String(object.typeName);
        if (object.extendee != null)
          message.extendee = String(object.extendee);
        if (object.defaultValue != null)
          message.defaultValue = String(object.defaultValue);
        if (object.oneofIndex != null)
          message.oneofIndex = object.oneofIndex | 0;
        if (object.jsonName != null)
          message.jsonName = String(object.jsonName);
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.FieldDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.FieldOptions.fromObject(object.options);
        }
        return message;
      };

      /**
       * Creates a plain object from a FieldDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.FieldDescriptorProto
       * @static
       * @param {google.protobuf.FieldDescriptorProto} message FieldDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      FieldDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.defaults) {
          object.name = "";
          object.extendee = "";
          object.number = 0;
          object.label = options.enums === String ? "LABEL_OPTIONAL" : 1;
          object.type = options.enums === String ? "TYPE_DOUBLE" : 1;
          object.typeName = "";
          object.defaultValue = "";
          object.options = null;
          object.oneofIndex = 0;
          object.jsonName = "";
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.extendee != null && message.hasOwnProperty("extendee"))
          object.extendee = message.extendee;
        if (message.number != null && message.hasOwnProperty("number"))
          object.number = message.number;
        if (message.label != null && message.hasOwnProperty("label"))
          object.label = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Label[message.label] : message.label;
        if (message.type != null && message.hasOwnProperty("type"))
          object.type = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Type[message.type] : message.type;
        if (message.typeName != null && message.hasOwnProperty("typeName"))
          object.typeName = message.typeName;
        if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
          object.defaultValue = message.defaultValue;
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.FieldOptions.toObject(message.options, options);
        if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
          object.oneofIndex = message.oneofIndex;
        if (message.jsonName != null && message.hasOwnProperty("jsonName"))
          object.jsonName = message.jsonName;
        return object;
      };

      /**
       * Converts this FieldDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.FieldDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      FieldDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      /**
       * Type enum.
       * @name google.protobuf.FieldDescriptorProto.Type
       * @enum {string}
       * @property {number} TYPE_DOUBLE=1 TYPE_DOUBLE value
       * @property {number} TYPE_FLOAT=2 TYPE_FLOAT value
       * @property {number} TYPE_INT64=3 TYPE_INT64 value
       * @property {number} TYPE_UINT64=4 TYPE_UINT64 value
       * @property {number} TYPE_INT32=5 TYPE_INT32 value
       * @property {number} TYPE_FIXED64=6 TYPE_FIXED64 value
       * @property {number} TYPE_FIXED32=7 TYPE_FIXED32 value
       * @property {number} TYPE_BOOL=8 TYPE_BOOL value
       * @property {number} TYPE_STRING=9 TYPE_STRING value
       * @property {number} TYPE_GROUP=10 TYPE_GROUP value
       * @property {number} TYPE_MESSAGE=11 TYPE_MESSAGE value
       * @property {number} TYPE_BYTES=12 TYPE_BYTES value
       * @property {number} TYPE_UINT32=13 TYPE_UINT32 value
       * @property {number} TYPE_ENUM=14 TYPE_ENUM value
       * @property {number} TYPE_SFIXED32=15 TYPE_SFIXED32 value
       * @property {number} TYPE_SFIXED64=16 TYPE_SFIXED64 value
       * @property {number} TYPE_SINT32=17 TYPE_SINT32 value
       * @property {number} TYPE_SINT64=18 TYPE_SINT64 value
       */
      FieldDescriptorProto.Type = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "TYPE_DOUBLE"] = 1;
        values[valuesById[2] = "TYPE_FLOAT"] = 2;
        values[valuesById[3] = "TYPE_INT64"] = 3;
        values[valuesById[4] = "TYPE_UINT64"] = 4;
        values[valuesById[5] = "TYPE_INT32"] = 5;
        values[valuesById[6] = "TYPE_FIXED64"] = 6;
        values[valuesById[7] = "TYPE_FIXED32"] = 7;
        values[valuesById[8] = "TYPE_BOOL"] = 8;
        values[valuesById[9] = "TYPE_STRING"] = 9;
        values[valuesById[10] = "TYPE_GROUP"] = 10;
        values[valuesById[11] = "TYPE_MESSAGE"] = 11;
        values[valuesById[12] = "TYPE_BYTES"] = 12;
        values[valuesById[13] = "TYPE_UINT32"] = 13;
        values[valuesById[14] = "TYPE_ENUM"] = 14;
        values[valuesById[15] = "TYPE_SFIXED32"] = 15;
        values[valuesById[16] = "TYPE_SFIXED64"] = 16;
        values[valuesById[17] = "TYPE_SINT32"] = 17;
        values[valuesById[18] = "TYPE_SINT64"] = 18;
        return values;
      })();

      /**
       * Label enum.
       * @name google.protobuf.FieldDescriptorProto.Label
       * @enum {string}
       * @property {number} LABEL_OPTIONAL=1 LABEL_OPTIONAL value
       * @property {number} LABEL_REQUIRED=2 LABEL_REQUIRED value
       * @property {number} LABEL_REPEATED=3 LABEL_REPEATED value
       */
      FieldDescriptorProto.Label = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "LABEL_OPTIONAL"] = 1;
        values[valuesById[2] = "LABEL_REQUIRED"] = 2;
        values[valuesById[3] = "LABEL_REPEATED"] = 3;
        return values;
      })();

      return FieldDescriptorProto;
    })();

    protobuf.OneofDescriptorProto = (function() {

      /**
       * Properties of an OneofDescriptorProto.
       * @memberof google.protobuf
       * @interface IOneofDescriptorProto
       * @property {string|null} [name] OneofDescriptorProto name
       * @property {google.protobuf.IOneofOptions|null} [options] OneofDescriptorProto options
       */

      /**
       * Constructs a new OneofDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents an OneofDescriptorProto.
       * @implements IOneofDescriptorProto
       * @constructor
       * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
       */
      function OneofDescriptorProto(properties) {
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * OneofDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.OneofDescriptorProto
       * @instance
       */
      OneofDescriptorProto.prototype.name = "";

      /**
       * OneofDescriptorProto options.
       * @member {google.protobuf.IOneofOptions|null|undefined} options
       * @memberof google.protobuf.OneofDescriptorProto
       * @instance
       */
      OneofDescriptorProto.prototype.options = null;

      /**
       * Creates a new OneofDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto instance
       */
      OneofDescriptorProto.create = function create(properties) {
        return new OneofDescriptorProto(properties);
      };

      /**
       * Encodes the specified OneofDescriptorProto message. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      OneofDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.OneofOptions.encode(message.options, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified OneofDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      OneofDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an OneofDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      OneofDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              message.options = $root.google.protobuf.OneofOptions.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an OneofDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      OneofDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an OneofDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      OneofDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.OneofOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        return null;
      };

      /**
       * Creates an OneofDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
       */
      OneofDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.OneofDescriptorProto)
          return object;
        var message = new $root.google.protobuf.OneofDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.OneofDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.OneofOptions.fromObject(object.options);
        }
        return message;
      };

      /**
       * Creates a plain object from an OneofDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.OneofDescriptorProto
       * @static
       * @param {google.protobuf.OneofDescriptorProto} message OneofDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      OneofDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.defaults) {
          object.name = "";
          object.options = null;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.OneofOptions.toObject(message.options, options);
        return object;
      };

      /**
       * Converts this OneofDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.OneofDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      OneofDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return OneofDescriptorProto;
    })();

    protobuf.EnumDescriptorProto = (function() {

      /**
       * Properties of an EnumDescriptorProto.
       * @memberof google.protobuf
       * @interface IEnumDescriptorProto
       * @property {string|null} [name] EnumDescriptorProto name
       * @property {Array.<google.protobuf.IEnumValueDescriptorProto>|null} [value] EnumDescriptorProto value
       * @property {google.protobuf.IEnumOptions|null} [options] EnumDescriptorProto options
       */

      /**
       * Constructs a new EnumDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents an EnumDescriptorProto.
       * @implements IEnumDescriptorProto
       * @constructor
       * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
       */
      function EnumDescriptorProto(properties) {
        this.value = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * EnumDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.EnumDescriptorProto
       * @instance
       */
      EnumDescriptorProto.prototype.name = "";

      /**
       * EnumDescriptorProto value.
       * @member {Array.<google.protobuf.IEnumValueDescriptorProto>} value
       * @memberof google.protobuf.EnumDescriptorProto
       * @instance
       */
      EnumDescriptorProto.prototype.value = $util.emptyArray;

      /**
       * EnumDescriptorProto options.
       * @member {google.protobuf.IEnumOptions|null|undefined} options
       * @memberof google.protobuf.EnumDescriptorProto
       * @instance
       */
      EnumDescriptorProto.prototype.options = null;

      /**
       * Creates a new EnumDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto instance
       */
      EnumDescriptorProto.create = function create(properties) {
        return new EnumDescriptorProto(properties);
      };

      /**
       * Encodes the specified EnumDescriptorProto message. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.value != null && message.value.length)
          for (var i = 0; i < message.value.length; ++i)
            $root.google.protobuf.EnumValueDescriptorProto.encode(message.value[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.EnumOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified EnumDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an EnumDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              if (!(message.value && message.value.length))
                message.value = [];
              message.value.push($root.google.protobuf.EnumValueDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 3:
              message.options = $root.google.protobuf.EnumOptions.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an EnumDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an EnumDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      EnumDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.value != null && message.hasOwnProperty("value")) {
          if (!Array.isArray(message.value))
            return "value: array expected";
          for (var i = 0; i < message.value.length; ++i) {
            var error = $root.google.protobuf.EnumValueDescriptorProto.verify(message.value[i]);
            if (error)
              return "value." + error;
          }
        }
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.EnumOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        return null;
      };

      /**
       * Creates an EnumDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
       */
      EnumDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.EnumDescriptorProto)
          return object;
        var message = new $root.google.protobuf.EnumDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.value) {
          if (!Array.isArray(object.value))
            throw TypeError(".google.protobuf.EnumDescriptorProto.value: array expected");
          message.value = [];
          for (var i = 0; i < object.value.length; ++i) {
            if (typeof object.value[i] !== "object")
              throw TypeError(".google.protobuf.EnumDescriptorProto.value: object expected");
            message.value[i] = $root.google.protobuf.EnumValueDescriptorProto.fromObject(object.value[i]);
          }
        }
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.EnumDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.EnumOptions.fromObject(object.options);
        }
        return message;
      };

      /**
       * Creates a plain object from an EnumDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.EnumDescriptorProto
       * @static
       * @param {google.protobuf.EnumDescriptorProto} message EnumDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      EnumDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.value = [];
        if (options.defaults) {
          object.name = "";
          object.options = null;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.value && message.value.length) {
          object.value = [];
          for (var j = 0; j < message.value.length; ++j)
            object.value[j] = $root.google.protobuf.EnumValueDescriptorProto.toObject(message.value[j], options);
        }
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.EnumOptions.toObject(message.options, options);
        return object;
      };

      /**
       * Converts this EnumDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.EnumDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      EnumDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return EnumDescriptorProto;
    })();

    protobuf.EnumValueDescriptorProto = (function() {

      /**
       * Properties of an EnumValueDescriptorProto.
       * @memberof google.protobuf
       * @interface IEnumValueDescriptorProto
       * @property {string|null} [name] EnumValueDescriptorProto name
       * @property {number|null} [number] EnumValueDescriptorProto number
       * @property {google.protobuf.IEnumValueOptions|null} [options] EnumValueDescriptorProto options
       */

      /**
       * Constructs a new EnumValueDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents an EnumValueDescriptorProto.
       * @implements IEnumValueDescriptorProto
       * @constructor
       * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
       */
      function EnumValueDescriptorProto(properties) {
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * EnumValueDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @instance
       */
      EnumValueDescriptorProto.prototype.name = "";

      /**
       * EnumValueDescriptorProto number.
       * @member {number} number
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @instance
       */
      EnumValueDescriptorProto.prototype.number = 0;

      /**
       * EnumValueDescriptorProto options.
       * @member {google.protobuf.IEnumValueOptions|null|undefined} options
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @instance
       */
      EnumValueDescriptorProto.prototype.options = null;

      /**
       * Creates a new EnumValueDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto instance
       */
      EnumValueDescriptorProto.create = function create(properties) {
        return new EnumValueDescriptorProto(properties);
      };

      /**
       * Encodes the specified EnumValueDescriptorProto message. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumValueDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.number != null && message.hasOwnProperty("number"))
          writer.uint32(/* id 2, wireType 0 =*/16).int32(message.number);
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.EnumValueOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified EnumValueDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumValueDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an EnumValueDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumValueDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              message.number = reader.int32();
              break;
            case 3:
              message.options = $root.google.protobuf.EnumValueOptions.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an EnumValueDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumValueDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an EnumValueDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      EnumValueDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.number != null && message.hasOwnProperty("number"))
          if (!$util.isInteger(message.number))
            return "number: integer expected";
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.EnumValueOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        return null;
      };

      /**
       * Creates an EnumValueDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
       */
      EnumValueDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.EnumValueDescriptorProto)
          return object;
        var message = new $root.google.protobuf.EnumValueDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.number != null)
          message.number = object.number | 0;
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.EnumValueDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.EnumValueOptions.fromObject(object.options);
        }
        return message;
      };

      /**
       * Creates a plain object from an EnumValueDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @static
       * @param {google.protobuf.EnumValueDescriptorProto} message EnumValueDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      EnumValueDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.defaults) {
          object.name = "";
          object.number = 0;
          object.options = null;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.number != null && message.hasOwnProperty("number"))
          object.number = message.number;
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.EnumValueOptions.toObject(message.options, options);
        return object;
      };

      /**
       * Converts this EnumValueDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.EnumValueDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      EnumValueDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return EnumValueDescriptorProto;
    })();

    protobuf.ServiceDescriptorProto = (function() {

      /**
       * Properties of a ServiceDescriptorProto.
       * @memberof google.protobuf
       * @interface IServiceDescriptorProto
       * @property {string|null} [name] ServiceDescriptorProto name
       * @property {Array.<google.protobuf.IMethodDescriptorProto>|null} [method] ServiceDescriptorProto method
       * @property {google.protobuf.IServiceOptions|null} [options] ServiceDescriptorProto options
       */

      /**
       * Constructs a new ServiceDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents a ServiceDescriptorProto.
       * @implements IServiceDescriptorProto
       * @constructor
       * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
       */
      function ServiceDescriptorProto(properties) {
        this.method = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * ServiceDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.ServiceDescriptorProto
       * @instance
       */
      ServiceDescriptorProto.prototype.name = "";

      /**
       * ServiceDescriptorProto method.
       * @member {Array.<google.protobuf.IMethodDescriptorProto>} method
       * @memberof google.protobuf.ServiceDescriptorProto
       * @instance
       */
      ServiceDescriptorProto.prototype.method = $util.emptyArray;

      /**
       * ServiceDescriptorProto options.
       * @member {google.protobuf.IServiceOptions|null|undefined} options
       * @memberof google.protobuf.ServiceDescriptorProto
       * @instance
       */
      ServiceDescriptorProto.prototype.options = null;

      /**
       * Creates a new ServiceDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto instance
       */
      ServiceDescriptorProto.create = function create(properties) {
        return new ServiceDescriptorProto(properties);
      };

      /**
       * Encodes the specified ServiceDescriptorProto message. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      ServiceDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.method != null && message.method.length)
          for (var i = 0; i < message.method.length; ++i)
            $root.google.protobuf.MethodDescriptorProto.encode(message.method[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.ServiceOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified ServiceDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      ServiceDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a ServiceDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      ServiceDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              if (!(message.method && message.method.length))
                message.method = [];
              message.method.push($root.google.protobuf.MethodDescriptorProto.decode(reader, reader.uint32()));
              break;
            case 3:
              message.options = $root.google.protobuf.ServiceOptions.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a ServiceDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      ServiceDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a ServiceDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      ServiceDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.method != null && message.hasOwnProperty("method")) {
          if (!Array.isArray(message.method))
            return "method: array expected";
          for (var i = 0; i < message.method.length; ++i) {
            var error = $root.google.protobuf.MethodDescriptorProto.verify(message.method[i]);
            if (error)
              return "method." + error;
          }
        }
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.ServiceOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        return null;
      };

      /**
       * Creates a ServiceDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
       */
      ServiceDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.ServiceDescriptorProto)
          return object;
        var message = new $root.google.protobuf.ServiceDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.method) {
          if (!Array.isArray(object.method))
            throw TypeError(".google.protobuf.ServiceDescriptorProto.method: array expected");
          message.method = [];
          for (var i = 0; i < object.method.length; ++i) {
            if (typeof object.method[i] !== "object")
              throw TypeError(".google.protobuf.ServiceDescriptorProto.method: object expected");
            message.method[i] = $root.google.protobuf.MethodDescriptorProto.fromObject(object.method[i]);
          }
        }
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.ServiceDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.ServiceOptions.fromObject(object.options);
        }
        return message;
      };

      /**
       * Creates a plain object from a ServiceDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.ServiceDescriptorProto
       * @static
       * @param {google.protobuf.ServiceDescriptorProto} message ServiceDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      ServiceDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.method = [];
        if (options.defaults) {
          object.name = "";
          object.options = null;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.method && message.method.length) {
          object.method = [];
          for (var j = 0; j < message.method.length; ++j)
            object.method[j] = $root.google.protobuf.MethodDescriptorProto.toObject(message.method[j], options);
        }
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.ServiceOptions.toObject(message.options, options);
        return object;
      };

      /**
       * Converts this ServiceDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.ServiceDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      ServiceDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return ServiceDescriptorProto;
    })();

    protobuf.MethodDescriptorProto = (function() {

      /**
       * Properties of a MethodDescriptorProto.
       * @memberof google.protobuf
       * @interface IMethodDescriptorProto
       * @property {string|null} [name] MethodDescriptorProto name
       * @property {string|null} [inputType] MethodDescriptorProto inputType
       * @property {string|null} [outputType] MethodDescriptorProto outputType
       * @property {google.protobuf.IMethodOptions|null} [options] MethodDescriptorProto options
       * @property {boolean|null} [clientStreaming] MethodDescriptorProto clientStreaming
       * @property {boolean|null} [serverStreaming] MethodDescriptorProto serverStreaming
       */

      /**
       * Constructs a new MethodDescriptorProto.
       * @memberof google.protobuf
       * @classdesc Represents a MethodDescriptorProto.
       * @implements IMethodDescriptorProto
       * @constructor
       * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
       */
      function MethodDescriptorProto(properties) {
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * MethodDescriptorProto name.
       * @member {string} name
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.name = "";

      /**
       * MethodDescriptorProto inputType.
       * @member {string} inputType
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.inputType = "";

      /**
       * MethodDescriptorProto outputType.
       * @member {string} outputType
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.outputType = "";

      /**
       * MethodDescriptorProto options.
       * @member {google.protobuf.IMethodOptions|null|undefined} options
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.options = null;

      /**
       * MethodDescriptorProto clientStreaming.
       * @member {boolean} clientStreaming
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.clientStreaming = false;

      /**
       * MethodDescriptorProto serverStreaming.
       * @member {boolean} serverStreaming
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       */
      MethodDescriptorProto.prototype.serverStreaming = false;

      /**
       * Creates a new MethodDescriptorProto instance using the specified properties.
       * @function create
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
       * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto instance
       */
      MethodDescriptorProto.create = function create(properties) {
        return new MethodDescriptorProto(properties);
      };

      /**
       * Encodes the specified MethodDescriptorProto message. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MethodDescriptorProto.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.hasOwnProperty("name"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
        if (message.inputType != null && message.hasOwnProperty("inputType"))
          writer.uint32(/* id 2, wireType 2 =*/18).string(message.inputType);
        if (message.outputType != null && message.hasOwnProperty("outputType"))
          writer.uint32(/* id 3, wireType 2 =*/26).string(message.outputType);
        if (message.options != null && message.hasOwnProperty("options"))
          $root.google.protobuf.MethodOptions.encode(message.options, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
        if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
          writer.uint32(/* id 5, wireType 0 =*/40).bool(message.clientStreaming);
        if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
          writer.uint32(/* id 6, wireType 0 =*/48).bool(message.serverStreaming);
        return writer;
      };

      /**
       * Encodes the specified MethodDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MethodDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a MethodDescriptorProto message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MethodDescriptorProto.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MethodDescriptorProto();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.name = reader.string();
              break;
            case 2:
              message.inputType = reader.string();
              break;
            case 3:
              message.outputType = reader.string();
              break;
            case 4:
              message.options = $root.google.protobuf.MethodOptions.decode(reader, reader.uint32());
              break;
            case 5:
              message.clientStreaming = reader.bool();
              break;
            case 6:
              message.serverStreaming = reader.bool();
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a MethodDescriptorProto message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MethodDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a MethodDescriptorProto message.
       * @function verify
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      MethodDescriptorProto.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name"))
          if (!$util.isString(message.name))
            return "name: string expected";
        if (message.inputType != null && message.hasOwnProperty("inputType"))
          if (!$util.isString(message.inputType))
            return "inputType: string expected";
        if (message.outputType != null && message.hasOwnProperty("outputType"))
          if (!$util.isString(message.outputType))
            return "outputType: string expected";
        if (message.options != null && message.hasOwnProperty("options")) {
          var error = $root.google.protobuf.MethodOptions.verify(message.options);
          if (error)
            return "options." + error;
        }
        if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
          if (typeof message.clientStreaming !== "boolean")
            return "clientStreaming: boolean expected";
        if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
          if (typeof message.serverStreaming !== "boolean")
            return "serverStreaming: boolean expected";
        return null;
      };

      /**
       * Creates a MethodDescriptorProto message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
       */
      MethodDescriptorProto.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.MethodDescriptorProto)
          return object;
        var message = new $root.google.protobuf.MethodDescriptorProto();
        if (object.name != null)
          message.name = String(object.name);
        if (object.inputType != null)
          message.inputType = String(object.inputType);
        if (object.outputType != null)
          message.outputType = String(object.outputType);
        if (object.options != null) {
          if (typeof object.options !== "object")
            throw TypeError(".google.protobuf.MethodDescriptorProto.options: object expected");
          message.options = $root.google.protobuf.MethodOptions.fromObject(object.options);
        }
        if (object.clientStreaming != null)
          message.clientStreaming = Boolean(object.clientStreaming);
        if (object.serverStreaming != null)
          message.serverStreaming = Boolean(object.serverStreaming);
        return message;
      };

      /**
       * Creates a plain object from a MethodDescriptorProto message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.MethodDescriptorProto
       * @static
       * @param {google.protobuf.MethodDescriptorProto} message MethodDescriptorProto
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      MethodDescriptorProto.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.defaults) {
          object.name = "";
          object.inputType = "";
          object.outputType = "";
          object.options = null;
          object.clientStreaming = false;
          object.serverStreaming = false;
        }
        if (message.name != null && message.hasOwnProperty("name"))
          object.name = message.name;
        if (message.inputType != null && message.hasOwnProperty("inputType"))
          object.inputType = message.inputType;
        if (message.outputType != null && message.hasOwnProperty("outputType"))
          object.outputType = message.outputType;
        if (message.options != null && message.hasOwnProperty("options"))
          object.options = $root.google.protobuf.MethodOptions.toObject(message.options, options);
        if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
          object.clientStreaming = message.clientStreaming;
        if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
          object.serverStreaming = message.serverStreaming;
        return object;
      };

      /**
       * Converts this MethodDescriptorProto to JSON.
       * @function toJSON
       * @memberof google.protobuf.MethodDescriptorProto
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      MethodDescriptorProto.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return MethodDescriptorProto;
    })();

    protobuf.FileOptions = (function() {

      /**
       * Properties of a FileOptions.
       * @memberof google.protobuf
       * @interface IFileOptions
       * @property {string|null} [javaPackage] FileOptions javaPackage
       * @property {string|null} [javaOuterClassname] FileOptions javaOuterClassname
       * @property {boolean|null} [javaMultipleFiles] FileOptions javaMultipleFiles
       * @property {boolean|null} [javaGenerateEqualsAndHash] FileOptions javaGenerateEqualsAndHash
       * @property {boolean|null} [javaStringCheckUtf8] FileOptions javaStringCheckUtf8
       * @property {google.protobuf.FileOptions.OptimizeMode|null} [optimizeFor] FileOptions optimizeFor
       * @property {string|null} [goPackage] FileOptions goPackage
       * @property {boolean|null} [ccGenericServices] FileOptions ccGenericServices
       * @property {boolean|null} [javaGenericServices] FileOptions javaGenericServices
       * @property {boolean|null} [pyGenericServices] FileOptions pyGenericServices
       * @property {boolean|null} [deprecated] FileOptions deprecated
       * @property {boolean|null} [ccEnableArenas] FileOptions ccEnableArenas
       * @property {string|null} [objcClassPrefix] FileOptions objcClassPrefix
       * @property {string|null} [csharpNamespace] FileOptions csharpNamespace
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FileOptions uninterpretedOption
       */

      /**
       * Constructs a new FileOptions.
       * @memberof google.protobuf
       * @classdesc Represents a FileOptions.
       * @implements IFileOptions
       * @constructor
       * @param {google.protobuf.IFileOptions=} [properties] Properties to set
       */
      function FileOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * FileOptions javaPackage.
       * @member {string} javaPackage
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaPackage = "";

      /**
       * FileOptions javaOuterClassname.
       * @member {string} javaOuterClassname
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaOuterClassname = "";

      /**
       * FileOptions javaMultipleFiles.
       * @member {boolean} javaMultipleFiles
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaMultipleFiles = false;

      /**
       * FileOptions javaGenerateEqualsAndHash.
       * @member {boolean} javaGenerateEqualsAndHash
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaGenerateEqualsAndHash = false;

      /**
       * FileOptions javaStringCheckUtf8.
       * @member {boolean} javaStringCheckUtf8
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaStringCheckUtf8 = false;

      /**
       * FileOptions optimizeFor.
       * @member {google.protobuf.FileOptions.OptimizeMode} optimizeFor
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.optimizeFor = 1;

      /**
       * FileOptions goPackage.
       * @member {string} goPackage
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.goPackage = "";

      /**
       * FileOptions ccGenericServices.
       * @member {boolean} ccGenericServices
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.ccGenericServices = false;

      /**
       * FileOptions javaGenericServices.
       * @member {boolean} javaGenericServices
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.javaGenericServices = false;

      /**
       * FileOptions pyGenericServices.
       * @member {boolean} pyGenericServices
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.pyGenericServices = false;

      /**
       * FileOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.deprecated = false;

      /**
       * FileOptions ccEnableArenas.
       * @member {boolean} ccEnableArenas
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.ccEnableArenas = false;

      /**
       * FileOptions objcClassPrefix.
       * @member {string} objcClassPrefix
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.objcClassPrefix = "";

      /**
       * FileOptions csharpNamespace.
       * @member {string} csharpNamespace
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.csharpNamespace = "";

      /**
       * FileOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.FileOptions
       * @instance
       */
      FileOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new FileOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {google.protobuf.IFileOptions=} [properties] Properties to set
       * @returns {google.protobuf.FileOptions} FileOptions instance
       */
      FileOptions.create = function create(properties) {
        return new FileOptions(properties);
      };

      /**
       * Encodes the specified FileOptions message. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.javaPackage);
        if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
          writer.uint32(/* id 8, wireType 2 =*/66).string(message.javaOuterClassname);
        if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
          writer.uint32(/* id 9, wireType 0 =*/72).int32(message.optimizeFor);
        if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
          writer.uint32(/* id 10, wireType 0 =*/80).bool(message.javaMultipleFiles);
        if (message.goPackage != null && message.hasOwnProperty("goPackage"))
          writer.uint32(/* id 11, wireType 2 =*/90).string(message.goPackage);
        if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
          writer.uint32(/* id 16, wireType 0 =*/128).bool(message.ccGenericServices);
        if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
          writer.uint32(/* id 17, wireType 0 =*/136).bool(message.javaGenericServices);
        if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
          writer.uint32(/* id 18, wireType 0 =*/144).bool(message.pyGenericServices);
        if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
          writer.uint32(/* id 20, wireType 0 =*/160).bool(message.javaGenerateEqualsAndHash);
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 23, wireType 0 =*/184).bool(message.deprecated);
        if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
          writer.uint32(/* id 27, wireType 0 =*/216).bool(message.javaStringCheckUtf8);
        if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
          writer.uint32(/* id 31, wireType 0 =*/248).bool(message.ccEnableArenas);
        if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
          writer.uint32(/* id 36, wireType 2 =*/290).string(message.objcClassPrefix);
        if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
          writer.uint32(/* id 37, wireType 2 =*/298).string(message.csharpNamespace);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified FileOptions message, length delimited. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FileOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a FileOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.FileOptions} FileOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.javaPackage = reader.string();
              break;
            case 8:
              message.javaOuterClassname = reader.string();
              break;
            case 10:
              message.javaMultipleFiles = reader.bool();
              break;
            case 20:
              message.javaGenerateEqualsAndHash = reader.bool();
              break;
            case 27:
              message.javaStringCheckUtf8 = reader.bool();
              break;
            case 9:
              message.optimizeFor = reader.int32();
              break;
            case 11:
              message.goPackage = reader.string();
              break;
            case 16:
              message.ccGenericServices = reader.bool();
              break;
            case 17:
              message.javaGenericServices = reader.bool();
              break;
            case 18:
              message.pyGenericServices = reader.bool();
              break;
            case 23:
              message.deprecated = reader.bool();
              break;
            case 31:
              message.ccEnableArenas = reader.bool();
              break;
            case 36:
              message.objcClassPrefix = reader.string();
              break;
            case 37:
              message.csharpNamespace = reader.string();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a FileOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.FileOptions} FileOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FileOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a FileOptions message.
       * @function verify
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      FileOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
          if (!$util.isString(message.javaPackage))
            return "javaPackage: string expected";
        if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
          if (!$util.isString(message.javaOuterClassname))
            return "javaOuterClassname: string expected";
        if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
          if (typeof message.javaMultipleFiles !== "boolean")
            return "javaMultipleFiles: boolean expected";
        if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
          if (typeof message.javaGenerateEqualsAndHash !== "boolean")
            return "javaGenerateEqualsAndHash: boolean expected";
        if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
          if (typeof message.javaStringCheckUtf8 !== "boolean")
            return "javaStringCheckUtf8: boolean expected";
        if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
          switch (message.optimizeFor) {
            default:
              return "optimizeFor: enum value expected";
            case 1:
            case 2:
            case 3:
              break;
          }
        if (message.goPackage != null && message.hasOwnProperty("goPackage"))
          if (!$util.isString(message.goPackage))
            return "goPackage: string expected";
        if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
          if (typeof message.ccGenericServices !== "boolean")
            return "ccGenericServices: boolean expected";
        if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
          if (typeof message.javaGenericServices !== "boolean")
            return "javaGenericServices: boolean expected";
        if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
          if (typeof message.pyGenericServices !== "boolean")
            return "pyGenericServices: boolean expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
          if (typeof message.ccEnableArenas !== "boolean")
            return "ccEnableArenas: boolean expected";
        if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
          if (!$util.isString(message.objcClassPrefix))
            return "objcClassPrefix: string expected";
        if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
          if (!$util.isString(message.csharpNamespace))
            return "csharpNamespace: string expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates a FileOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.FileOptions} FileOptions
       */
      FileOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.FileOptions)
          return object;
        var message = new $root.google.protobuf.FileOptions();
        if (object.javaPackage != null)
          message.javaPackage = String(object.javaPackage);
        if (object.javaOuterClassname != null)
          message.javaOuterClassname = String(object.javaOuterClassname);
        if (object.javaMultipleFiles != null)
          message.javaMultipleFiles = Boolean(object.javaMultipleFiles);
        if (object.javaGenerateEqualsAndHash != null)
          message.javaGenerateEqualsAndHash = Boolean(object.javaGenerateEqualsAndHash);
        if (object.javaStringCheckUtf8 != null)
          message.javaStringCheckUtf8 = Boolean(object.javaStringCheckUtf8);
        switch (object.optimizeFor) {
          case "SPEED":
          case 1:
            message.optimizeFor = 1;
            break;
          case "CODE_SIZE":
          case 2:
            message.optimizeFor = 2;
            break;
          case "LITE_RUNTIME":
          case 3:
            message.optimizeFor = 3;
            break;
        }
        if (object.goPackage != null)
          message.goPackage = String(object.goPackage);
        if (object.ccGenericServices != null)
          message.ccGenericServices = Boolean(object.ccGenericServices);
        if (object.javaGenericServices != null)
          message.javaGenericServices = Boolean(object.javaGenericServices);
        if (object.pyGenericServices != null)
          message.pyGenericServices = Boolean(object.pyGenericServices);
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.ccEnableArenas != null)
          message.ccEnableArenas = Boolean(object.ccEnableArenas);
        if (object.objcClassPrefix != null)
          message.objcClassPrefix = String(object.objcClassPrefix);
        if (object.csharpNamespace != null)
          message.csharpNamespace = String(object.csharpNamespace);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a FileOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.FileOptions
       * @static
       * @param {google.protobuf.FileOptions} message FileOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      FileOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults) {
          object.javaPackage = "";
          object.javaOuterClassname = "";
          object.optimizeFor = options.enums === String ? "SPEED" : 1;
          object.javaMultipleFiles = false;
          object.goPackage = "";
          object.ccGenericServices = false;
          object.javaGenericServices = false;
          object.pyGenericServices = false;
          object.javaGenerateEqualsAndHash = false;
          object.deprecated = false;
          object.javaStringCheckUtf8 = false;
          object.ccEnableArenas = false;
          object.objcClassPrefix = "";
          object.csharpNamespace = "";
        }
        if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
          object.javaPackage = message.javaPackage;
        if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
          object.javaOuterClassname = message.javaOuterClassname;
        if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
          object.optimizeFor = options.enums === String ? $root.google.protobuf.FileOptions.OptimizeMode[message.optimizeFor] : message.optimizeFor;
        if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
          object.javaMultipleFiles = message.javaMultipleFiles;
        if (message.goPackage != null && message.hasOwnProperty("goPackage"))
          object.goPackage = message.goPackage;
        if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
          object.ccGenericServices = message.ccGenericServices;
        if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
          object.javaGenericServices = message.javaGenericServices;
        if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
          object.pyGenericServices = message.pyGenericServices;
        if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
          object.javaGenerateEqualsAndHash = message.javaGenerateEqualsAndHash;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
          object.javaStringCheckUtf8 = message.javaStringCheckUtf8;
        if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
          object.ccEnableArenas = message.ccEnableArenas;
        if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
          object.objcClassPrefix = message.objcClassPrefix;
        if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
          object.csharpNamespace = message.csharpNamespace;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this FileOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.FileOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      FileOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      /**
       * OptimizeMode enum.
       * @name google.protobuf.FileOptions.OptimizeMode
       * @enum {string}
       * @property {number} SPEED=1 SPEED value
       * @property {number} CODE_SIZE=2 CODE_SIZE value
       * @property {number} LITE_RUNTIME=3 LITE_RUNTIME value
       */
      FileOptions.OptimizeMode = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "SPEED"] = 1;
        values[valuesById[2] = "CODE_SIZE"] = 2;
        values[valuesById[3] = "LITE_RUNTIME"] = 3;
        return values;
      })();

      return FileOptions;
    })();

    protobuf.MessageOptions = (function() {

      /**
       * Properties of a MessageOptions.
       * @memberof google.protobuf
       * @interface IMessageOptions
       * @property {boolean|null} [messageSetWireFormat] MessageOptions messageSetWireFormat
       * @property {boolean|null} [noStandardDescriptorAccessor] MessageOptions noStandardDescriptorAccessor
       * @property {boolean|null} [deprecated] MessageOptions deprecated
       * @property {boolean|null} [mapEntry] MessageOptions mapEntry
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MessageOptions uninterpretedOption
       */

      /**
       * Constructs a new MessageOptions.
       * @memberof google.protobuf
       * @classdesc Represents a MessageOptions.
       * @implements IMessageOptions
       * @constructor
       * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
       */
      function MessageOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * MessageOptions messageSetWireFormat.
       * @member {boolean} messageSetWireFormat
       * @memberof google.protobuf.MessageOptions
       * @instance
       */
      MessageOptions.prototype.messageSetWireFormat = false;

      /**
       * MessageOptions noStandardDescriptorAccessor.
       * @member {boolean} noStandardDescriptorAccessor
       * @memberof google.protobuf.MessageOptions
       * @instance
       */
      MessageOptions.prototype.noStandardDescriptorAccessor = false;

      /**
       * MessageOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.MessageOptions
       * @instance
       */
      MessageOptions.prototype.deprecated = false;

      /**
       * MessageOptions mapEntry.
       * @member {boolean} mapEntry
       * @memberof google.protobuf.MessageOptions
       * @instance
       */
      MessageOptions.prototype.mapEntry = false;

      /**
       * MessageOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.MessageOptions
       * @instance
       */
      MessageOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new MessageOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
       * @returns {google.protobuf.MessageOptions} MessageOptions instance
       */
      MessageOptions.create = function create(properties) {
        return new MessageOptions(properties);
      };

      /**
       * Encodes the specified MessageOptions message. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MessageOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
          writer.uint32(/* id 1, wireType 0 =*/8).bool(message.messageSetWireFormat);
        if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
          writer.uint32(/* id 2, wireType 0 =*/16).bool(message.noStandardDescriptorAccessor);
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
        if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
          writer.uint32(/* id 7, wireType 0 =*/56).bool(message.mapEntry);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified MessageOptions message, length delimited. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MessageOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a MessageOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.MessageOptions} MessageOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MessageOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MessageOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.messageSetWireFormat = reader.bool();
              break;
            case 2:
              message.noStandardDescriptorAccessor = reader.bool();
              break;
            case 3:
              message.deprecated = reader.bool();
              break;
            case 7:
              message.mapEntry = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a MessageOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.MessageOptions} MessageOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MessageOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a MessageOptions message.
       * @function verify
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      MessageOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
          if (typeof message.messageSetWireFormat !== "boolean")
            return "messageSetWireFormat: boolean expected";
        if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
          if (typeof message.noStandardDescriptorAccessor !== "boolean")
            return "noStandardDescriptorAccessor: boolean expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
          if (typeof message.mapEntry !== "boolean")
            return "mapEntry: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates a MessageOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.MessageOptions} MessageOptions
       */
      MessageOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.MessageOptions)
          return object;
        var message = new $root.google.protobuf.MessageOptions();
        if (object.messageSetWireFormat != null)
          message.messageSetWireFormat = Boolean(object.messageSetWireFormat);
        if (object.noStandardDescriptorAccessor != null)
          message.noStandardDescriptorAccessor = Boolean(object.noStandardDescriptorAccessor);
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.mapEntry != null)
          message.mapEntry = Boolean(object.mapEntry);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a MessageOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.MessageOptions
       * @static
       * @param {google.protobuf.MessageOptions} message MessageOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      MessageOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults) {
          object.messageSetWireFormat = false;
          object.noStandardDescriptorAccessor = false;
          object.deprecated = false;
          object.mapEntry = false;
        }
        if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
          object.messageSetWireFormat = message.messageSetWireFormat;
        if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
          object.noStandardDescriptorAccessor = message.noStandardDescriptorAccessor;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
          object.mapEntry = message.mapEntry;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this MessageOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.MessageOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      MessageOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return MessageOptions;
    })();

    protobuf.FieldOptions = (function() {

      /**
       * Properties of a FieldOptions.
       * @memberof google.protobuf
       * @interface IFieldOptions
       * @property {google.protobuf.FieldOptions.CType|null} [ctype] FieldOptions ctype
       * @property {boolean|null} [packed] FieldOptions packed
       * @property {google.protobuf.FieldOptions.JSType|null} [jstype] FieldOptions jstype
       * @property {boolean|null} [lazy] FieldOptions lazy
       * @property {boolean|null} [deprecated] FieldOptions deprecated
       * @property {boolean|null} [weak] FieldOptions weak
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FieldOptions uninterpretedOption
       */

      /**
       * Constructs a new FieldOptions.
       * @memberof google.protobuf
       * @classdesc Represents a FieldOptions.
       * @implements IFieldOptions
       * @constructor
       * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
       */
      function FieldOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * FieldOptions ctype.
       * @member {google.protobuf.FieldOptions.CType} ctype
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.ctype = 0;

      /**
       * FieldOptions packed.
       * @member {boolean} packed
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.packed = false;

      /**
       * FieldOptions jstype.
       * @member {google.protobuf.FieldOptions.JSType} jstype
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.jstype = 0;

      /**
       * FieldOptions lazy.
       * @member {boolean} lazy
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.lazy = false;

      /**
       * FieldOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.deprecated = false;

      /**
       * FieldOptions weak.
       * @member {boolean} weak
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.weak = false;

      /**
       * FieldOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.FieldOptions
       * @instance
       */
      FieldOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new FieldOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
       * @returns {google.protobuf.FieldOptions} FieldOptions instance
       */
      FieldOptions.create = function create(properties) {
        return new FieldOptions(properties);
      };

      /**
       * Encodes the specified FieldOptions message. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FieldOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.ctype != null && message.hasOwnProperty("ctype"))
          writer.uint32(/* id 1, wireType 0 =*/8).int32(message.ctype);
        if (message.packed != null && message.hasOwnProperty("packed"))
          writer.uint32(/* id 2, wireType 0 =*/16).bool(message.packed);
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
        if (message.lazy != null && message.hasOwnProperty("lazy"))
          writer.uint32(/* id 5, wireType 0 =*/40).bool(message.lazy);
        if (message.jstype != null && message.hasOwnProperty("jstype"))
          writer.uint32(/* id 6, wireType 0 =*/48).int32(message.jstype);
        if (message.weak != null && message.hasOwnProperty("weak"))
          writer.uint32(/* id 10, wireType 0 =*/80).bool(message.weak);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified FieldOptions message, length delimited. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      FieldOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a FieldOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.FieldOptions} FieldOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FieldOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.ctype = reader.int32();
              break;
            case 2:
              message.packed = reader.bool();
              break;
            case 6:
              message.jstype = reader.int32();
              break;
            case 5:
              message.lazy = reader.bool();
              break;
            case 3:
              message.deprecated = reader.bool();
              break;
            case 10:
              message.weak = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a FieldOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.FieldOptions} FieldOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      FieldOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a FieldOptions message.
       * @function verify
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      FieldOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.ctype != null && message.hasOwnProperty("ctype"))
          switch (message.ctype) {
            default:
              return "ctype: enum value expected";
            case 0:
            case 1:
            case 2:
              break;
          }
        if (message.packed != null && message.hasOwnProperty("packed"))
          if (typeof message.packed !== "boolean")
            return "packed: boolean expected";
        if (message.jstype != null && message.hasOwnProperty("jstype"))
          switch (message.jstype) {
            default:
              return "jstype: enum value expected";
            case 0:
            case 1:
            case 2:
              break;
          }
        if (message.lazy != null && message.hasOwnProperty("lazy"))
          if (typeof message.lazy !== "boolean")
            return "lazy: boolean expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.weak != null && message.hasOwnProperty("weak"))
          if (typeof message.weak !== "boolean")
            return "weak: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates a FieldOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.FieldOptions} FieldOptions
       */
      FieldOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.FieldOptions)
          return object;
        var message = new $root.google.protobuf.FieldOptions();
        switch (object.ctype) {
          case "STRING":
          case 0:
            message.ctype = 0;
            break;
          case "CORD":
          case 1:
            message.ctype = 1;
            break;
          case "STRING_PIECE":
          case 2:
            message.ctype = 2;
            break;
        }
        if (object.packed != null)
          message.packed = Boolean(object.packed);
        switch (object.jstype) {
          case "JS_NORMAL":
          case 0:
            message.jstype = 0;
            break;
          case "JS_STRING":
          case 1:
            message.jstype = 1;
            break;
          case "JS_NUMBER":
          case 2:
            message.jstype = 2;
            break;
        }
        if (object.lazy != null)
          message.lazy = Boolean(object.lazy);
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.weak != null)
          message.weak = Boolean(object.weak);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a FieldOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.FieldOptions
       * @static
       * @param {google.protobuf.FieldOptions} message FieldOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      FieldOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults) {
          object.ctype = options.enums === String ? "STRING" : 0;
          object.packed = false;
          object.deprecated = false;
          object.lazy = false;
          object.jstype = options.enums === String ? "JS_NORMAL" : 0;
          object.weak = false;
        }
        if (message.ctype != null && message.hasOwnProperty("ctype"))
          object.ctype = options.enums === String ? $root.google.protobuf.FieldOptions.CType[message.ctype] : message.ctype;
        if (message.packed != null && message.hasOwnProperty("packed"))
          object.packed = message.packed;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.lazy != null && message.hasOwnProperty("lazy"))
          object.lazy = message.lazy;
        if (message.jstype != null && message.hasOwnProperty("jstype"))
          object.jstype = options.enums === String ? $root.google.protobuf.FieldOptions.JSType[message.jstype] : message.jstype;
        if (message.weak != null && message.hasOwnProperty("weak"))
          object.weak = message.weak;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this FieldOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.FieldOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      FieldOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      /**
       * CType enum.
       * @name google.protobuf.FieldOptions.CType
       * @enum {string}
       * @property {number} STRING=0 STRING value
       * @property {number} CORD=1 CORD value
       * @property {number} STRING_PIECE=2 STRING_PIECE value
       */
      FieldOptions.CType = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "STRING"] = 0;
        values[valuesById[1] = "CORD"] = 1;
        values[valuesById[2] = "STRING_PIECE"] = 2;
        return values;
      })();

      /**
       * JSType enum.
       * @name google.protobuf.FieldOptions.JSType
       * @enum {string}
       * @property {number} JS_NORMAL=0 JS_NORMAL value
       * @property {number} JS_STRING=1 JS_STRING value
       * @property {number} JS_NUMBER=2 JS_NUMBER value
       */
      FieldOptions.JSType = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "JS_NORMAL"] = 0;
        values[valuesById[1] = "JS_STRING"] = 1;
        values[valuesById[2] = "JS_NUMBER"] = 2;
        return values;
      })();

      return FieldOptions;
    })();

    protobuf.OneofOptions = (function() {

      /**
       * Properties of an OneofOptions.
       * @memberof google.protobuf
       * @interface IOneofOptions
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] OneofOptions uninterpretedOption
       */

      /**
       * Constructs a new OneofOptions.
       * @memberof google.protobuf
       * @classdesc Represents an OneofOptions.
       * @implements IOneofOptions
       * @constructor
       * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
       */
      function OneofOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * OneofOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.OneofOptions
       * @instance
       */
      OneofOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new OneofOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
       * @returns {google.protobuf.OneofOptions} OneofOptions instance
       */
      OneofOptions.create = function create(properties) {
        return new OneofOptions(properties);
      };

      /**
       * Encodes the specified OneofOptions message. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      OneofOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified OneofOptions message, length delimited. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      OneofOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an OneofOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.OneofOptions} OneofOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      OneofOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an OneofOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.OneofOptions} OneofOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      OneofOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an OneofOptions message.
       * @function verify
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      OneofOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates an OneofOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.OneofOptions} OneofOptions
       */
      OneofOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.OneofOptions)
          return object;
        var message = new $root.google.protobuf.OneofOptions();
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from an OneofOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.OneofOptions
       * @static
       * @param {google.protobuf.OneofOptions} message OneofOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      OneofOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this OneofOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.OneofOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      OneofOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return OneofOptions;
    })();

    protobuf.EnumOptions = (function() {

      /**
       * Properties of an EnumOptions.
       * @memberof google.protobuf
       * @interface IEnumOptions
       * @property {boolean|null} [allowAlias] EnumOptions allowAlias
       * @property {boolean|null} [deprecated] EnumOptions deprecated
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumOptions uninterpretedOption
       */

      /**
       * Constructs a new EnumOptions.
       * @memberof google.protobuf
       * @classdesc Represents an EnumOptions.
       * @implements IEnumOptions
       * @constructor
       * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
       */
      function EnumOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * EnumOptions allowAlias.
       * @member {boolean} allowAlias
       * @memberof google.protobuf.EnumOptions
       * @instance
       */
      EnumOptions.prototype.allowAlias = false;

      /**
       * EnumOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.EnumOptions
       * @instance
       */
      EnumOptions.prototype.deprecated = false;

      /**
       * EnumOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.EnumOptions
       * @instance
       */
      EnumOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new EnumOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
       * @returns {google.protobuf.EnumOptions} EnumOptions instance
       */
      EnumOptions.create = function create(properties) {
        return new EnumOptions(properties);
      };

      /**
       * Encodes the specified EnumOptions message. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
          writer.uint32(/* id 2, wireType 0 =*/16).bool(message.allowAlias);
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified EnumOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an EnumOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.EnumOptions} EnumOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 2:
              message.allowAlias = reader.bool();
              break;
            case 3:
              message.deprecated = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an EnumOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.EnumOptions} EnumOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an EnumOptions message.
       * @function verify
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      EnumOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
          if (typeof message.allowAlias !== "boolean")
            return "allowAlias: boolean expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates an EnumOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.EnumOptions} EnumOptions
       */
      EnumOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.EnumOptions)
          return object;
        var message = new $root.google.protobuf.EnumOptions();
        if (object.allowAlias != null)
          message.allowAlias = Boolean(object.allowAlias);
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from an EnumOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.EnumOptions
       * @static
       * @param {google.protobuf.EnumOptions} message EnumOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      EnumOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults) {
          object.allowAlias = false;
          object.deprecated = false;
        }
        if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
          object.allowAlias = message.allowAlias;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this EnumOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.EnumOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      EnumOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return EnumOptions;
    })();

    protobuf.EnumValueOptions = (function() {

      /**
       * Properties of an EnumValueOptions.
       * @memberof google.protobuf
       * @interface IEnumValueOptions
       * @property {boolean|null} [deprecated] EnumValueOptions deprecated
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumValueOptions uninterpretedOption
       */

      /**
       * Constructs a new EnumValueOptions.
       * @memberof google.protobuf
       * @classdesc Represents an EnumValueOptions.
       * @implements IEnumValueOptions
       * @constructor
       * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
       */
      function EnumValueOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * EnumValueOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.EnumValueOptions
       * @instance
       */
      EnumValueOptions.prototype.deprecated = false;

      /**
       * EnumValueOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.EnumValueOptions
       * @instance
       */
      EnumValueOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new EnumValueOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
       * @returns {google.protobuf.EnumValueOptions} EnumValueOptions instance
       */
      EnumValueOptions.create = function create(properties) {
        return new EnumValueOptions(properties);
      };

      /**
       * Encodes the specified EnumValueOptions message. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumValueOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 1, wireType 0 =*/8).bool(message.deprecated);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified EnumValueOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      EnumValueOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an EnumValueOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumValueOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 1:
              message.deprecated = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an EnumValueOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      EnumValueOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an EnumValueOptions message.
       * @function verify
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      EnumValueOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates an EnumValueOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
       */
      EnumValueOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.EnumValueOptions)
          return object;
        var message = new $root.google.protobuf.EnumValueOptions();
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from an EnumValueOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.EnumValueOptions
       * @static
       * @param {google.protobuf.EnumValueOptions} message EnumValueOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      EnumValueOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults)
          object.deprecated = false;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this EnumValueOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.EnumValueOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      EnumValueOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return EnumValueOptions;
    })();

    protobuf.ServiceOptions = (function() {

      /**
       * Properties of a ServiceOptions.
       * @memberof google.protobuf
       * @interface IServiceOptions
       * @property {boolean|null} [deprecated] ServiceOptions deprecated
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] ServiceOptions uninterpretedOption
       */

      /**
       * Constructs a new ServiceOptions.
       * @memberof google.protobuf
       * @classdesc Represents a ServiceOptions.
       * @implements IServiceOptions
       * @constructor
       * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
       */
      function ServiceOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * ServiceOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.ServiceOptions
       * @instance
       */
      ServiceOptions.prototype.deprecated = false;

      /**
       * ServiceOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.ServiceOptions
       * @instance
       */
      ServiceOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * Creates a new ServiceOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
       * @returns {google.protobuf.ServiceOptions} ServiceOptions instance
       */
      ServiceOptions.create = function create(properties) {
        return new ServiceOptions(properties);
      };

      /**
       * Encodes the specified ServiceOptions message. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      ServiceOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 33, wireType 0 =*/264).bool(message.deprecated);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified ServiceOptions message, length delimited. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      ServiceOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a ServiceOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.ServiceOptions} ServiceOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      ServiceOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 33:
              message.deprecated = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a ServiceOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.ServiceOptions} ServiceOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      ServiceOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a ServiceOptions message.
       * @function verify
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      ServiceOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        return null;
      };

      /**
       * Creates a ServiceOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.ServiceOptions} ServiceOptions
       */
      ServiceOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.ServiceOptions)
          return object;
        var message = new $root.google.protobuf.ServiceOptions();
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        return message;
      };

      /**
       * Creates a plain object from a ServiceOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.ServiceOptions
       * @static
       * @param {google.protobuf.ServiceOptions} message ServiceOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      ServiceOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults)
          object.deprecated = false;
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        return object;
      };

      /**
       * Converts this ServiceOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.ServiceOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      ServiceOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return ServiceOptions;
    })();

    protobuf.MethodOptions = (function() {

      /**
       * Properties of a MethodOptions.
       * @memberof google.protobuf
       * @interface IMethodOptions
       * @property {boolean|null} [deprecated] MethodOptions deprecated
       * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MethodOptions uninterpretedOption
       * @property {google.api.IHttpRule|null} [".google.api.http"] MethodOptions .google.api.http
       */

      /**
       * Constructs a new MethodOptions.
       * @memberof google.protobuf
       * @classdesc Represents a MethodOptions.
       * @implements IMethodOptions
       * @constructor
       * @param {google.protobuf.IMethodOptions=} [properties] Properties to set
       */
      function MethodOptions(properties) {
        this.uninterpretedOption = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * MethodOptions deprecated.
       * @member {boolean} deprecated
       * @memberof google.protobuf.MethodOptions
       * @instance
       */
      MethodOptions.prototype.deprecated = false;

      /**
       * MethodOptions uninterpretedOption.
       * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
       * @memberof google.protobuf.MethodOptions
       * @instance
       */
      MethodOptions.prototype.uninterpretedOption = $util.emptyArray;

      /**
       * MethodOptions .google.api.http.
       * @member {google.api.IHttpRule|null|undefined} .google.api.http
       * @memberof google.protobuf.MethodOptions
       * @instance
       */
      MethodOptions.prototype[".google.api.http"] = null;

      /**
       * Creates a new MethodOptions instance using the specified properties.
       * @function create
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {google.protobuf.IMethodOptions=} [properties] Properties to set
       * @returns {google.protobuf.MethodOptions} MethodOptions instance
       */
      MethodOptions.create = function create(properties) {
        return new MethodOptions(properties);
      };

      /**
       * Encodes the specified MethodOptions message. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {google.protobuf.IMethodOptions} message MethodOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MethodOptions.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          writer.uint32(/* id 33, wireType 0 =*/264).bool(message.deprecated);
        if (message.uninterpretedOption != null && message.uninterpretedOption.length)
          for (var i = 0; i < message.uninterpretedOption.length; ++i)
            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
        if (message[".google.api.http"] != null && message.hasOwnProperty(".google.api.http"))
          $root.google.api.HttpRule.encode(message[".google.api.http"], writer.uint32(/* id 72295728, wireType 2 =*/578365826).fork()).ldelim();
        return writer;
      };

      /**
       * Encodes the specified MethodOptions message, length delimited. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {google.protobuf.IMethodOptions} message MethodOptions message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      MethodOptions.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes a MethodOptions message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.MethodOptions} MethodOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MethodOptions.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MethodOptions();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 33:
              message.deprecated = reader.bool();
              break;
            case 999:
              if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                message.uninterpretedOption = [];
              message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
              break;
            case 72295728:
              message[".google.api.http"] = $root.google.api.HttpRule.decode(reader, reader.uint32());
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes a MethodOptions message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.MethodOptions} MethodOptions
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      MethodOptions.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies a MethodOptions message.
       * @function verify
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      MethodOptions.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          if (typeof message.deprecated !== "boolean")
            return "deprecated: boolean expected";
        if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
          if (!Array.isArray(message.uninterpretedOption))
            return "uninterpretedOption: array expected";
          for (var i = 0; i < message.uninterpretedOption.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
            if (error)
              return "uninterpretedOption." + error;
          }
        }
        if (message[".google.api.http"] != null && message.hasOwnProperty(".google.api.http")) {
          var error = $root.google.api.HttpRule.verify(message[".google.api.http"]);
          if (error)
            return ".google.api.http." + error;
        }
        return null;
      };

      /**
       * Creates a MethodOptions message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.MethodOptions} MethodOptions
       */
      MethodOptions.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.MethodOptions)
          return object;
        var message = new $root.google.protobuf.MethodOptions();
        if (object.deprecated != null)
          message.deprecated = Boolean(object.deprecated);
        if (object.uninterpretedOption) {
          if (!Array.isArray(object.uninterpretedOption))
            throw TypeError(".google.protobuf.MethodOptions.uninterpretedOption: array expected");
          message.uninterpretedOption = [];
          for (var i = 0; i < object.uninterpretedOption.length; ++i) {
            if (typeof object.uninterpretedOption[i] !== "object")
              throw TypeError(".google.protobuf.MethodOptions.uninterpretedOption: object expected");
            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
          }
        }
        if (object[".google.api.http"] != null) {
          if (typeof object[".google.api.http"] !== "object")
            throw TypeError(".google.protobuf.MethodOptions..google.api.http: object expected");
          message[".google.api.http"] = $root.google.api.HttpRule.fromObject(object[".google.api.http"]);
        }
        return message;
      };

      /**
       * Creates a plain object from a MethodOptions message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.MethodOptions
       * @static
       * @param {google.protobuf.MethodOptions} message MethodOptions
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      MethodOptions.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.uninterpretedOption = [];
        if (options.defaults) {
          object.deprecated = false;
          object[".google.api.http"] = null;
        }
        if (message.deprecated != null && message.hasOwnProperty("deprecated"))
          object.deprecated = message.deprecated;
        if (message.uninterpretedOption && message.uninterpretedOption.length) {
          object.uninterpretedOption = [];
          for (var j = 0; j < message.uninterpretedOption.length; ++j)
            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
        }
        if (message[".google.api.http"] != null && message.hasOwnProperty(".google.api.http"))
          object[".google.api.http"] = $root.google.api.HttpRule.toObject(message[".google.api.http"], options);
        return object;
      };

      /**
       * Converts this MethodOptions to JSON.
       * @function toJSON
       * @memberof google.protobuf.MethodOptions
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      MethodOptions.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      return MethodOptions;
    })();

    protobuf.UninterpretedOption = (function() {

      /**
       * Properties of an UninterpretedOption.
       * @memberof google.protobuf
       * @interface IUninterpretedOption
       * @property {Array.<google.protobuf.UninterpretedOption.INamePart>|null} [name] UninterpretedOption name
       * @property {string|null} [identifierValue] UninterpretedOption identifierValue
       * @property {number|string|null} [positiveIntValue] UninterpretedOption positiveIntValue
       * @property {number|string|null} [negativeIntValue] UninterpretedOption negativeIntValue
       * @property {number|null} [doubleValue] UninterpretedOption doubleValue
       * @property {Uint8Array|null} [stringValue] UninterpretedOption stringValue
       * @property {string|null} [aggregateValue] UninterpretedOption aggregateValue
       */

      /**
       * Constructs a new UninterpretedOption.
       * @memberof google.protobuf
       * @classdesc Represents an UninterpretedOption.
       * @implements IUninterpretedOption
       * @constructor
       * @param {google.protobuf.IUninterpretedOption=} [properties] Properties to set
       */
      function UninterpretedOption(properties) {
        this.name = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * UninterpretedOption name.
       * @member {Array.<google.protobuf.UninterpretedOption.INamePart>} name
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.name = $util.emptyArray;

      /**
       * UninterpretedOption identifierValue.
       * @member {string} identifierValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.identifierValue = "";

      /**
       * UninterpretedOption positiveIntValue.
       * @member {number|string} positiveIntValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.positiveIntValue = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

      /**
       * UninterpretedOption negativeIntValue.
       * @member {number|string} negativeIntValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.negativeIntValue = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

      /**
       * UninterpretedOption doubleValue.
       * @member {number} doubleValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.doubleValue = 0;

      /**
       * UninterpretedOption stringValue.
       * @member {Uint8Array} stringValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.stringValue = $util.newBuffer([]);

      /**
       * UninterpretedOption aggregateValue.
       * @member {string} aggregateValue
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       */
      UninterpretedOption.prototype.aggregateValue = "";

      /**
       * Creates a new UninterpretedOption instance using the specified properties.
       * @function create
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {google.protobuf.IUninterpretedOption=} [properties] Properties to set
       * @returns {google.protobuf.UninterpretedOption} UninterpretedOption instance
       */
      UninterpretedOption.create = function create(properties) {
        return new UninterpretedOption(properties);
      };

      /**
       * Encodes the specified UninterpretedOption message. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {google.protobuf.IUninterpretedOption} message UninterpretedOption message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      UninterpretedOption.encode = function encode(message, writer) {
        if (!writer)
          writer = $Writer.create();
        if (message.name != null && message.name.length)
          for (var i = 0; i < message.name.length; ++i)
            $root.google.protobuf.UninterpretedOption.NamePart.encode(message.name[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
        if (message.identifierValue != null && message.hasOwnProperty("identifierValue"))
          writer.uint32(/* id 3, wireType 2 =*/26).string(message.identifierValue);
        if (message.positiveIntValue != null && message.hasOwnProperty("positiveIntValue"))
          writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.positiveIntValue);
        if (message.negativeIntValue != null && message.hasOwnProperty("negativeIntValue"))
          writer.uint32(/* id 5, wireType 0 =*/40).int64(message.negativeIntValue);
        if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
          writer.uint32(/* id 6, wireType 1 =*/49).double(message.doubleValue);
        if (message.stringValue != null && message.hasOwnProperty("stringValue"))
          writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.stringValue);
        if (message.aggregateValue != null && message.hasOwnProperty("aggregateValue"))
          writer.uint32(/* id 8, wireType 2 =*/66).string(message.aggregateValue);
        return writer;
      };

      /**
       * Encodes the specified UninterpretedOption message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
       * @function encodeDelimited
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {google.protobuf.IUninterpretedOption} message UninterpretedOption message or plain object to encode
       * @param {$protobuf.Writer} [writer] Writer to encode to
       * @returns {$protobuf.Writer} Writer
       */
      UninterpretedOption.encodeDelimited = function encodeDelimited(message, writer) {
        return this.encode(message, writer).ldelim();
      };

      /**
       * Decodes an UninterpretedOption message from the specified reader or buffer.
       * @function decode
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @param {number} [length] Message length if known beforehand
       * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      UninterpretedOption.decode = function decode(reader, length) {
        if (!(reader instanceof $Reader))
          reader = $Reader.create(reader);
        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.UninterpretedOption();
        while (reader.pos < end) {
          var tag = reader.uint32();
          switch (tag >>> 3) {
            case 2:
              if (!(message.name && message.name.length))
                message.name = [];
              message.name.push($root.google.protobuf.UninterpretedOption.NamePart.decode(reader, reader.uint32()));
              break;
            case 3:
              message.identifierValue = reader.string();
              break;
            case 4:
              message.positiveIntValue = reader.uint64();
              break;
            case 5:
              message.negativeIntValue = reader.int64();
              break;
            case 6:
              message.doubleValue = reader.double();
              break;
            case 7:
              message.stringValue = reader.bytes();
              break;
            case 8:
              message.aggregateValue = reader.string();
              break;
            default:
              reader.skipType(tag & 7);
              break;
          }
        }
        return message;
      };

      /**
       * Decodes an UninterpretedOption message from the specified reader or buffer, length delimited.
       * @function decodeDelimited
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
       * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
       * @throws {Error} If the payload is not a reader or valid buffer
       * @throws {$protobuf.util.ProtocolError} If required fields are missing
       */
      UninterpretedOption.decodeDelimited = function decodeDelimited(reader) {
        if (!(reader instanceof $Reader))
          reader = new $Reader(reader);
        return this.decode(reader, reader.uint32());
      };

      /**
       * Verifies an UninterpretedOption message.
       * @function verify
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {Object.<string,*>} message Plain object to verify
       * @returns {string|null} `null` if valid, otherwise the reason why it is not
       */
      UninterpretedOption.verify = function verify(message) {
        if (typeof message !== "object" || message === null)
          return "object expected";
        if (message.name != null && message.hasOwnProperty("name")) {
          if (!Array.isArray(message.name))
            return "name: array expected";
          for (var i = 0; i < message.name.length; ++i) {
            var error = $root.google.protobuf.UninterpretedOption.NamePart.verify(message.name[i]);
            if (error)
              return "name." + error;
          }
        }
        if (message.identifierValue != null && message.hasOwnProperty("identifierValue"))
          if (!$util.isString(message.identifierValue))
            return "identifierValue: string expected";
        if (message.positiveIntValue != null && message.hasOwnProperty("positiveIntValue"))
          if (!$util.isInteger(message.positiveIntValue) && !(message.positiveIntValue && $util.isInteger(message.positiveIntValue.low) && $util.isInteger(message.positiveIntValue.high)))
            return "positiveIntValue: integer|Long expected";
        if (message.negativeIntValue != null && message.hasOwnProperty("negativeIntValue"))
          if (!$util.isInteger(message.negativeIntValue) && !(message.negativeIntValue && $util.isInteger(message.negativeIntValue.low) && $util.isInteger(message.negativeIntValue.high)))
            return "negativeIntValue: integer|Long expected";
        if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
          if (typeof message.doubleValue !== "number")
            return "doubleValue: number expected";
        if (message.stringValue != null && message.hasOwnProperty("stringValue"))
          if (!(message.stringValue && typeof message.stringValue.length === "number" || $util.isString(message.stringValue)))
            return "stringValue: buffer expected";
        if (message.aggregateValue != null && message.hasOwnProperty("aggregateValue"))
          if (!$util.isString(message.aggregateValue))
            return "aggregateValue: string expected";
        return null;
      };

      /**
       * Creates an UninterpretedOption message from a plain object. Also converts values to their respective internal types.
       * @function fromObject
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {Object.<string,*>} object Plain object
       * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
       */
      UninterpretedOption.fromObject = function fromObject(object) {
        if (object instanceof $root.google.protobuf.UninterpretedOption)
          return object;
        var message = new $root.google.protobuf.UninterpretedOption();
        if (object.name) {
          if (!Array.isArray(object.name))
            throw TypeError(".google.protobuf.UninterpretedOption.name: array expected");
          message.name = [];
          for (var i = 0; i < object.name.length; ++i) {
            if (typeof object.name[i] !== "object")
              throw TypeError(".google.protobuf.UninterpretedOption.name: object expected");
            message.name[i] = $root.google.protobuf.UninterpretedOption.NamePart.fromObject(object.name[i]);
          }
        }
        if (object.identifierValue != null)
          message.identifierValue = String(object.identifierValue);
        if (object.positiveIntValue != null)
          if ($util.Long)
            (message.positiveIntValue = $util.Long.fromValue(object.positiveIntValue)).unsigned = true;
          else if (typeof object.positiveIntValue === "string")
            message.positiveIntValue = parseInt(object.positiveIntValue, 10);
          else if (typeof object.positiveIntValue === "number")
            message.positiveIntValue = object.positiveIntValue;
          else if (typeof object.positiveIntValue === "object")
            message.positiveIntValue = new $util.LongBits(object.positiveIntValue.low >>> 0, object.positiveIntValue.high >>> 0).toNumber(true);
        if (object.negativeIntValue != null)
          if ($util.Long)
            (message.negativeIntValue = $util.Long.fromValue(object.negativeIntValue)).unsigned = false;
          else if (typeof object.negativeIntValue === "string")
            message.negativeIntValue = parseInt(object.negativeIntValue, 10);
          else if (typeof object.negativeIntValue === "number")
            message.negativeIntValue = object.negativeIntValue;
          else if (typeof object.negativeIntValue === "object")
            message.negativeIntValue = new $util.LongBits(object.negativeIntValue.low >>> 0, object.negativeIntValue.high >>> 0).toNumber();
        if (object.doubleValue != null)
          message.doubleValue = Number(object.doubleValue);
        if (object.stringValue != null)
          if (typeof object.stringValue === "string")
            $util.base64.decode(object.stringValue, message.stringValue = $util.newBuffer($util.base64.length(object.stringValue)), 0);
          else if (object.stringValue.length)
            message.stringValue = object.stringValue;
        if (object.aggregateValue != null)
          message.aggregateValue = String(object.aggregateValue);
        return message;
      };

      /**
       * Creates a plain object from an UninterpretedOption message. Also converts values to other types if specified.
       * @function toObject
       * @memberof google.protobuf.UninterpretedOption
       * @static
       * @param {google.protobuf.UninterpretedOption} message UninterpretedOption
       * @param {$protobuf.IConversionOptions} [options] Conversion options
       * @returns {Object.<string,*>} Plain object
       */
      UninterpretedOption.toObject = function toObject(message, options) {
        if (!options)
          options = {};
        var object = {};
        if (options.arrays || options.defaults)
          object.name = [];
        if (options.defaults) {
          object.identifierValue = "";
          if ($util.Long) {
            var long = new $util.Long(0, 0, true);
            object.positiveIntValue = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
          } else
            object.positiveIntValue = options.longs === String ? "0" : 0;
          if ($util.Long) {
            var long = new $util.Long(0, 0, false);
            object.negativeIntValue = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
          } else
            object.negativeIntValue = options.longs === String ? "0" : 0;
          object.doubleValue = 0;
          object.stringValue = options.bytes === String ? "" : [];
          object.aggregateValue = "";
        }
        if (message.name && message.name.length) {
          object.name = [];
          for (var j = 0; j < message.name.length; ++j)
            object.name[j] = $root.google.protobuf.UninterpretedOption.NamePart.toObject(message.name[j], options);
        }
        if (message.identifierValue != null && message.hasOwnProperty("identifierValue"))
          object.identifierValue = message.identifierValue;
        if (message.positiveIntValue != null && message.hasOwnProperty("positiveIntValue"))
          if (typeof message.positiveIntValue === "number")
            object.positiveIntValue = options.longs === String ? String(message.positiveIntValue) : message.positiveIntValue;
          else
            object.positiveIntValue = options.longs === String ? $util.Long.prototype.toString.call(message.positiveIntValue) : options.longs === Number ? new $util.LongBits(message.positiveIntValue.low >>> 0, message.positiveIntValue.high >>> 0).toNumber(true) : message.positiveIntValue;
        if (message.negativeIntValue != null && message.hasOwnProperty("negativeIntValue"))
          if (typeof message.negativeIntValue === "number")
            object.negativeIntValue = options.longs === String ? String(message.negativeIntValue) : message.negativeIntValue;
          else
            object.negativeIntValue = options.longs === String ? $util.Long.prototype.toString.call(message.negativeIntValue) : options.longs === Number ? new $util.LongBits(message.negativeIntValue.low >>> 0, message.negativeIntValue.high >>> 0).toNumber() : message.negativeIntValue;
        if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
          object.doubleValue = options.json && !isFinite(message.doubleValue) ? String(message.doubleValue) : message.doubleValue;
        if (message.stringValue != null && message.hasOwnProperty("stringValue"))
          object.stringValue = options.bytes === String ? $util.base64.encode(message.stringValue, 0, message.stringValue.length) : options.bytes === Array ? Array.prototype.slice.call(message.stringValue) : message.stringValue;
        if (message.aggregateValue != null && message.hasOwnProperty("aggregateValue"))
          object.aggregateValue = message.aggregateValue;
        return object;
      };

      /**
       * Converts this UninterpretedOption to JSON.
       * @function toJSON
       * @memberof google.protobuf.UninterpretedOption
       * @instance
       * @returns {Object.<string,*>} JSON object
       */
      UninterpretedOption.prototype.toJSON = function toJSON() {
        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
      };

      UninterpretedOption.NamePart = (function() {

        /**
         * Properties of a NamePart.
         * @memberof google.protobuf.UninterpretedOption
         * @interface INamePart
         * @property {string} namePart NamePart namePart
         * @property {boolean} isExtension NamePart isExtension
         */

        /**
         * Constructs a new NamePart.
         * @memberof google.protobuf.UninterpretedOption
         * @classdesc Represents a NamePart.
         * @implements INamePart
         * @constructor
         * @param {google.protobuf.UninterpretedOption.INamePart=} [properties] Properties to set
         */
        function NamePart(properties) {
          if (properties)
            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
              if (properties[keys[i]] != null)
                this[keys[i]] = properties[keys[i]];
        }

        /**
         * NamePart namePart.
         * @member {string} namePart
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @instance
         */
        NamePart.prototype.namePart = "";

        /**
         * NamePart isExtension.
         * @member {boolean} isExtension
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @instance
         */
        NamePart.prototype.isExtension = false;

        /**
         * Creates a new NamePart instance using the specified properties.
         * @function create
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {google.protobuf.UninterpretedOption.INamePart=} [properties] Properties to set
         * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart instance
         */
        NamePart.create = function create(properties) {
          return new NamePart(properties);
        };

        /**
         * Encodes the specified NamePart message. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
         * @function encode
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {google.protobuf.UninterpretedOption.INamePart} message NamePart message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NamePart.encode = function encode(message, writer) {
          if (!writer)
            writer = $Writer.create();
          writer.uint32(/* id 1, wireType 2 =*/10).string(message.namePart);
          writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isExtension);
          return writer;
        };

        /**
         * Encodes the specified NamePart message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
         * @function encodeDelimited
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {google.protobuf.UninterpretedOption.INamePart} message NamePart message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NamePart.encodeDelimited = function encodeDelimited(message, writer) {
          return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a NamePart message from the specified reader or buffer.
         * @function decode
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NamePart.decode = function decode(reader, length) {
          if (!(reader instanceof $Reader))
            reader = $Reader.create(reader);
          var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.UninterpretedOption.NamePart();
          while (reader.pos < end) {
            var tag = reader.uint32();
            switch (tag >>> 3) {
              case 1:
                message.namePart = reader.string();
                break;
              case 2:
                message.isExtension = reader.bool();
                break;
              default:
                reader.skipType(tag & 7);
                break;
            }
          }
          if (!message.hasOwnProperty("namePart"))
            throw $util.ProtocolError("missing required 'namePart'", { instance: message });
          if (!message.hasOwnProperty("isExtension"))
            throw $util.ProtocolError("missing required 'isExtension'", { instance: message });
          return message;
        };

        /**
         * Decodes a NamePart message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NamePart.decodeDelimited = function decodeDelimited(reader) {
          if (!(reader instanceof $Reader))
            reader = new $Reader(reader);
          return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a NamePart message.
         * @function verify
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        NamePart.verify = function verify(message) {
          if (typeof message !== "object" || message === null)
            return "object expected";
          if (!$util.isString(message.namePart))
            return "namePart: string expected";
          if (typeof message.isExtension !== "boolean")
            return "isExtension: boolean expected";
          return null;
        };

        /**
         * Creates a NamePart message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
         */
        NamePart.fromObject = function fromObject(object) {
          if (object instanceof $root.google.protobuf.UninterpretedOption.NamePart)
            return object;
          var message = new $root.google.protobuf.UninterpretedOption.NamePart();
          if (object.namePart != null)
            message.namePart = String(object.namePart);
          if (object.isExtension != null)
            message.isExtension = Boolean(object.isExtension);
          return message;
        };

        /**
         * Creates a plain object from a NamePart message. Also converts values to other types if specified.
         * @function toObject
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @static
         * @param {google.protobuf.UninterpretedOption.NamePart} message NamePart
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        NamePart.toObject = function toObject(message, options) {
          if (!options)
            options = {};
          var object = {};
          if (options.defaults) {
            object.namePart = "";
            object.isExtension = false;
          }
          if (message.namePart != null && message.hasOwnProperty("namePart"))
            object.namePart = message.namePart;
          if (message.isExtension != null && message.hasOwnProperty("isExtension"))
            object.isExtension = message.isExtension;
          return object;
        };

        /**
         * Converts this NamePart to JSON.
         * @function toJSON
         * @memberof google.protobuf.UninterpretedOption.NamePart
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        NamePart.prototype.toJSON = function toJSON() {
          return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return NamePart;
      })();

      return UninterpretedOption;
    })();

    protobuf.SourceCodeInfo = (function() {

      /**
       * Properties of a SourceCodeInfo.
       * @memberof google.protobuf
       * @interface ISourceCodeInfo
       * @property {Array.<google.protobuf.SourceCodeInfo.ILocation>|null} [location] SourceCodeInfo location
       */

      /**
       * Constructs a new SourceCodeInfo.
       * @memberof google.protobuf
       * @classdesc Represents a SourceCodeInfo.
       * @implements ISourceCodeInfo
       * @constructor
       * @param {google.protobuf.ISourceCodeInfo=} [properties] Properties to set
       */
      function SourceCodeInfo(properties) {
        this.location = [];
        if (properties)
          for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
            if (properties[keys[i]] != null)
              this[keys[i]] = properties[keys[i]];
      }

      /**
       * SourceCodeInfo location.
       * @member {Array.<google.protobuf.SourceCodeInfo.ILocation>} location
       * @memberof google.protobuf.SourceCodeInfo
       * @instance
       */
      SourceCodeInfo.prototype.location = $util.emptyArray;

      /**
       * Creates a new SourceCodeInfo instance using the specified properties.
       * @function create
       * @memberof google.protobuf.SourceCodeInfo
       * @static
       * @param {google.protobuf.ISourceCodeInfo=} [properties] Properties to set
       * @returns {google.protobuf.SourceCodeInfo} SourceCodeInfo instance
       */
      SourceCodeInfo.create = function create(properties) {
        return new SourceCodeInfo(properties);
      };

      /**
       * Encodes the specified SourceCodeInfo message. Does not implicitly {@link google.protobuf.SourceCodeInfo.verify|verify} messages.
       * @function encode
       * @memberof google.protobuf.SourceCodeInfo
       * @static
       * @param {google.protobuf.ISourceCodeInfo} message Sourc