/**
 * Modules in this bundle
 * @license
 *
 * empower:
 *   license: MIT (http://opensource.org/licenses/MIT)
 *   author: Takuto Wada <takuto.wada@gmail.com>
 *   contributors: James Talmage
 *   homepage: https://github.com/power-assert-js/empower
 *   version: 1.3.1
 *
 * call-signature:
 *   license: MIT (http://opensource.org/licenses/MIT)
 *   author: James Talmage <james@talmage.io>
 *   homepage: https://github.com/jamestalmage/call-signature#readme
 *   version: 0.0.2
 *
 * core-js:
 *   license: MIT (http://opensource.org/licenses/MIT)
 *   homepage: https://github.com/zloirock/core-js#readme
 *   version: 2.5.7
 *
 * empower-core:
 *   license: MIT (http://opensource.org/licenses/MIT)
 *   author: Takuto Wada <takuto.wada@gmail.com>
 *   contributors: James Talmage
 *   homepage: https://github.com/twada/power-assert-runtime
 *   version: 1.2.0
 *
 * This header is generated by licensify (https://github.com/twada/licensify)
 */
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.empower = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw (a.code="MODULE_NOT_FOUND", a)}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(_dereq_,module,exports){
/**
 * empower - Power Assert feature enhancer for assert function/object.
 *
 * https://github.com/power-assert-js/empower
 *
 * Copyright (c) 2013-2018 Takuto Wada
 * Licensed under the MIT license.
 *   https://github.com/power-assert-js/empower/blob/master/MIT-LICENSE.txt
 */
var empowerCore = _dereq_('empower-core');
var defaultOptions = _dereq_('./lib/default-options');
var capturable = _dereq_('./lib/capturable');
var assign = _dereq_('core-js/library/fn/object/assign');
var define = _dereq_('./lib/define-properties');

/**
 * Enhance Power Assert feature to assert function/object.
 * @param assert target assert function or object to enhance
 * @param formatter power assert format function
 * @param options enhancement options
 * @return enhanced assert function/object
 */
function empower (assert, formatter, options) {
    var config = assign(defaultOptions(), options);
    var eagerEvaluation = !(config.modifyMessageOnRethrow || config.saveContextOnRethrow);
    // see: https://github.com/power-assert-js/empower/pull/26
    var shouldRecreateAssertionError = (function isStackUnchanged () {
        if (typeof assert !== 'function') {
            return false;
        }
        if (typeof assert.AssertionError !== 'function') {
            return false;
        }
        var ae = new assert.AssertionError({
            actual: 123,
            expected: 456,
            operator: '==='
        });
        ae.message = '[REPLACED MESSAGE]';
        return !(/REPLACED MESSAGE/.test(ae.stack)) && /123 === 456/.test(ae.stack);
    })();

    var empowerCoreConfig = assign(config, {
        modifyMessageBeforeAssert: function (beforeAssertEvent) {
            var message = beforeAssertEvent.originalMessage;
            if (!eagerEvaluation) {
                return message;
            }
            return buildPowerAssertText(formatter, message, beforeAssertEvent.powerAssertContext);
        },
        onError: function onError (errorEvent) {
            var e = errorEvent.error;
            if (!/^AssertionError/.test(e.name)) {
                throw e;
            }
            if (!errorEvent.powerAssertContext) {
                throw e;
            }
            var poweredMessage;
            if (config.modifyMessageOnRethrow || config.saveContextOnRethrow) {
                poweredMessage = buildPowerAssertText(formatter, errorEvent.originalMessage, errorEvent.powerAssertContext);
                if (shouldRecreateAssertionError) {
                    e = new assert.AssertionError({
                        message: poweredMessage,
                        actual: e.actual,
                        expected: e.expected,
                        operator: e.operator,
                        stackStartFunction: e.stackStartFunction || onError
                    });
                    e.generatedMessage = false;
                }
            }
            if (config.modifyMessageOnRethrow && !shouldRecreateAssertionError) {
                e.message = poweredMessage;
                e.generatedMessage = false;
            }
            if (config.saveContextOnRethrow) {
                e.powerAssertContext = errorEvent.powerAssertContext;
            }
            throw e;
        }
    });
    var enhancedAssert = empowerCore(assert, empowerCoreConfig);
    define(enhancedAssert, capturable());
    return enhancedAssert;
}

function buildPowerAssertText (formatter, message, context) {
    // console.log(message);
    var powerAssertText = formatter(context);
    return message ? message + ' ' + powerAssertText : powerAssertText;
};

empower.defaultOptions = defaultOptions;
module.exports = empower;

},{"./lib/capturable":2,"./lib/default-options":3,"./lib/define-properties":4,"core-js/library/fn/object/assign":10,"empower-core":67}],2:[function(_dereq_,module,exports){
'use strict';

module.exports = function capturable () {
    var events = [];

    function _capt (value, espath) {
        events.push({value: value, espath: espath});
        return value;
    }

    function _expr (value, args) {
        var captured = events;
        events = [];
        var source = {
            content: args.content,
            filepath: args.filepath,
            line: args.line
        };
        if (args.generator) {
            source.generator = true;
        }
        if (args.async) {
            source.async = true;
        }
        return {
            powerAssertContext: {
                value: value,
                events: captured
            },
            source: source
        };
    }

    return {
        _capt: _capt,
        _expr: _expr
    };
};

},{}],3:[function(_dereq_,module,exports){
'use strict';

var empowerCore = _dereq_('empower-core');
var assign = _dereq_('core-js/library/fn/object/assign');

module.exports = function defaultOptions () {
    return assign(empowerCore.defaultOptions(), {
        modifyMessageOnRethrow: false,
        saveContextOnRethrow: false
    });
};

},{"core-js/library/fn/object/assign":10,"empower-core":67}],4:[function(_dereq_,module,exports){
'use strict';

var defineProperty = _dereq_('core-js/library/fn/object/define-property');
var forEach = _dereq_('core-js/library/fn/array/for-each');
var keys = _dereq_('core-js/library/fn/object/keys');

module.exports = function defineProperties (obj, map) {
    forEach(keys(map), function (name) {
        defineProperty(obj, name, {
            configurable: true,
            enumerable: false,
            value: map[name],
            writable: true
        });
    });
};

},{"core-js/library/fn/array/for-each":7,"core-js/library/fn/object/define-property":12,"core-js/library/fn/object/keys":13}],5:[function(_dereq_,module,exports){
'use strict';
module.exports.parse = parse;
module.exports.generate = generate;

// TODO(jamestalmage): Allow full range of identifier characters instead of just ASCII
//
// This will likely require a build step
//
// SPEC: http://www.ecma-international.org/ecma-262/5.1/#sec-7.6
//
// TOOLING:
//    https://github.com/mathiasbynens/regenerate
//    https://www.npmjs.com/package/regjsgen

var regex = /^\s*(?:([A-Za-z$_][A-Za-z0-9$_]*)\s*\.)?\s*([A-Za-z$_][A-Za-z0-9$_]*)\s*\(\s*((?:[A-Za-z$_][A-Za-z0-9$_]*)|(?:\[\s*[A-Za-z$_][A-Za-z0-9$_]*\s*]))?((?:\s*,\s*(?:(?:[A-Za-z$_][A-Za-z0-9$_]*)|(?:\[\s*[A-Za-z$_][A-Za-z0-9$_]*\s*])))+)?\s*\)\s*$/;

function parse(str) {
	var match = regex.exec(str);
	if (!match) {
		return null;
	}

	var callee;
	if (match[1]) {
		callee = {
			type: 'MemberExpression',
			object: match[1],
			member: match[2]
		};
	} else {
		callee = {
			type: 'Identifier',
			name: match[2]
		};
	}

	var args = match[4] || '';
	args = args.split(',');
	if (match[3]) {
		args[0] = match[3];
	}
	var trimmed = [];
	args.forEach(function (str) {
		var optional = false;
		str = str.replace(/\s+/g, '');
		if (!str.length) {
			return;
		}
		if (str.charAt(0) === '[' && str.charAt(str.length - 1) === ']') {
			optional = true;
			str = str.substring(1, str.length - 1);
		}
		trimmed.push({
			name: str,
			optional: optional
		});
	});

	return {
		callee: callee,
		args: trimmed
	};
}

function generate(parsed) {
	var callee;
	if (parsed.callee.type === 'MemberExpression') {
		callee = [
			parsed.callee.object,
			'.',
			parsed.callee.member
		];
	} else {
		callee = [parsed.callee.name];
	}
	return callee.concat([
		'(',
		parsed.args.map(function (arg) {
			return arg.optional ? '[' + arg.name + ']' : arg.name;
		}).join(', '),
		')'
	]).join('');
}

},{}],6:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.array.filter');
module.exports = _dereq_('../../modules/_core').Array.filter;

},{"../../modules/_core":21,"../../modules/es6.array.filter":59}],7:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.array.for-each');
module.exports = _dereq_('../../modules/_core').Array.forEach;

},{"../../modules/_core":21,"../../modules/es6.array.for-each":60}],8:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.array.map');
module.exports = _dereq_('../../modules/_core').Array.map;

},{"../../modules/_core":21,"../../modules/es6.array.map":61}],9:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.array.some');
module.exports = _dereq_('../../modules/_core').Array.some;

},{"../../modules/_core":21,"../../modules/es6.array.some":62}],10:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.object.assign');
module.exports = _dereq_('../../modules/_core').Object.assign;

},{"../../modules/_core":21,"../../modules/es6.object.assign":63}],11:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.object.create');
var $Object = _dereq_('../../modules/_core').Object;
module.exports = function create(P, D) {
  return $Object.create(P, D);
};

},{"../../modules/_core":21,"../../modules/es6.object.create":64}],12:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.object.define-property');
var $Object = _dereq_('../../modules/_core').Object;
module.exports = function defineProperty(it, key, desc) {
  return $Object.defineProperty(it, key, desc);
};

},{"../../modules/_core":21,"../../modules/es6.object.define-property":65}],13:[function(_dereq_,module,exports){
_dereq_('../../modules/es6.object.keys');
module.exports = _dereq_('../../modules/_core').Object.keys;

},{"../../modules/_core":21,"../../modules/es6.object.keys":66}],14:[function(_dereq_,module,exports){
module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};

},{}],15:[function(_dereq_,module,exports){
var isObject = _dereq_('./_is-object');
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};

},{"./_is-object":36}],16:[function(_dereq_,module,exports){
// false -> Array#indexOf
// true  -> Array#includes
var toIObject = _dereq_('./_to-iobject');
var toLength = _dereq_('./_to-length');
var toAbsoluteIndex = _dereq_('./_to-absolute-index');
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

},{"./_to-absolute-index":51,"./_to-iobject":53,"./_to-length":54}],17:[function(_dereq_,module,exports){
// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex
var ctx = _dereq_('./_ctx');
var IObject = _dereq_('./_iobject');
var toObject = _dereq_('./_to-object');
var toLength = _dereq_('./_to-length');
var asc = _dereq_('./_array-species-create');
module.exports = function (TYPE, $create) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  var create = $create || asc;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IObject(O);
    var f = ctx(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var val, res;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      val = self[index];
      res = f(val, index, O);
      if (TYPE) {
        if (IS_MAP) result[index] = res;   // map
        else if (res) switch (TYPE) {
          case 3: return true;             // some
          case 5: return val;              // find
          case 6: return index;            // findIndex
          case 2: result.push(val);        // filter
        } else if (IS_EVERY) return false; // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
  };
};

},{"./_array-species-create":19,"./_ctx":22,"./_iobject":34,"./_to-length":54,"./_to-object":55}],18:[function(_dereq_,module,exports){
var isObject = _dereq_('./_is-object');
var isArray = _dereq_('./_is-array');
var SPECIES = _dereq_('./_wks')('species');

module.exports = function (original) {
  var C;
  if (isArray(original)) {
    C = original.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? Array : C;
};

},{"./_is-array":35,"./_is-object":36,"./_wks":58}],19:[function(_dereq_,module,exports){
// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
var speciesConstructor = _dereq_('./_array-species-constructor');

module.exports = function (original, length) {
  return new (speciesConstructor(original))(length);
};

},{"./_array-species-constructor":18}],20:[function(_dereq_,module,exports){
var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};

},{}],21:[function(_dereq_,module,exports){
var core = module.exports = { version: '2.5.7' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef

},{}],22:[function(_dereq_,module,exports){
// optional / simple context binding
var aFunction = _dereq_('./_a-function');
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

},{"./_a-function":14}],23:[function(_dereq_,module,exports){
// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};

},{}],24:[function(_dereq_,module,exports){
// Thank's IE8 for his funny defineProperty
module.exports = !_dereq_('./_fails')(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});

},{"./_fails":28}],25:[function(_dereq_,module,exports){
var isObject = _dereq_('./_is-object');
var document = _dereq_('./_global').document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};

},{"./_global":29,"./_is-object":36}],26:[function(_dereq_,module,exports){
// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');

},{}],27:[function(_dereq_,module,exports){
var global = _dereq_('./_global');
var core = _dereq_('./_core');
var ctx = _dereq_('./_ctx');
var hide = _dereq_('./_hide');
var has = _dereq_('./_has');
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;

},{"./_core":21,"./_ctx":22,"./_global":29,"./_has":30,"./_hide":31}],28:[function(_dereq_,module,exports){
module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};

},{}],29:[function(_dereq_,module,exports){
// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef

},{}],30:[function(_dereq_,module,exports){
var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};

},{}],31:[function(_dereq_,module,exports){
var dP = _dereq_('./_object-dp');
var createDesc = _dereq_('./_property-desc');
module.exports = _dereq_('./_descriptors') ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

},{"./_descriptors":24,"./_object-dp":40,"./_property-desc":47}],32:[function(_dereq_,module,exports){
var document = _dereq_('./_global').document;
module.exports = document && document.documentElement;

},{"./_global":29}],33:[function(_dereq_,module,exports){
module.exports = !_dereq_('./_descriptors') && !_dereq_('./_fails')(function () {
  return Object.defineProperty(_dereq_('./_dom-create')('div'), 'a', { get: function () { return 7; } }).a != 7;
});

},{"./_descriptors":24,"./_dom-create":25,"./_fails":28}],34:[function(_dereq_,module,exports){
// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = _dereq_('./_cof');
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};

},{"./_cof":20}],35:[function(_dereq_,module,exports){
// 7.2.2 IsArray(argument)
var cof = _dereq_('./_cof');
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};

},{"./_cof":20}],36:[function(_dereq_,module,exports){
module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

},{}],37:[function(_dereq_,module,exports){
module.exports = true;

},{}],38:[function(_dereq_,module,exports){
'use strict';
// 19.1.2.1 Object.assign(target, source, ...)
var getKeys = _dereq_('./_object-keys');
var gOPS = _dereq_('./_object-gops');
var pIE = _dereq_('./_object-pie');
var toObject = _dereq_('./_to-object');
var IObject = _dereq_('./_iobject');
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || _dereq_('./_fails')(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];
  } return T;
} : $assign;

},{"./_fails":28,"./_iobject":34,"./_object-gops":42,"./_object-keys":44,"./_object-pie":45,"./_to-object":55}],39:[function(_dereq_,module,exports){
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = _dereq_('./_an-object');
var dPs = _dereq_('./_object-dps');
var enumBugKeys = _dereq_('./_enum-bug-keys');
var IE_PROTO = _dereq_('./_shared-key')('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = _dereq_('./_dom-create')('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  _dereq_('./_html').appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};

},{"./_an-object":15,"./_dom-create":25,"./_enum-bug-keys":26,"./_html":32,"./_object-dps":41,"./_shared-key":48}],40:[function(_dereq_,module,exports){
var anObject = _dereq_('./_an-object');
var IE8_DOM_DEFINE = _dereq_('./_ie8-dom-define');
var toPrimitive = _dereq_('./_to-primitive');
var dP = Object.defineProperty;

exports.f = _dereq_('./_descriptors') ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

},{"./_an-object":15,"./_descriptors":24,"./_ie8-dom-define":33,"./_to-primitive":56}],41:[function(_dereq_,module,exports){
var dP = _dereq_('./_object-dp');
var anObject = _dereq_('./_an-object');
var getKeys = _dereq_('./_object-keys');

module.exports = _dereq_('./_descriptors') ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};

},{"./_an-object":15,"./_descriptors":24,"./_object-dp":40,"./_object-keys":44}],42:[function(_dereq_,module,exports){
exports.f = Object.getOwnPropertySymbols;

},{}],43:[function(_dereq_,module,exports){
var has = _dereq_('./_has');
var toIObject = _dereq_('./_to-iobject');
var arrayIndexOf = _dereq_('./_array-includes')(false);
var IE_PROTO = _dereq_('./_shared-key')('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};

},{"./_array-includes":16,"./_has":30,"./_shared-key":48,"./_to-iobject":53}],44:[function(_dereq_,module,exports){
// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = _dereq_('./_object-keys-internal');
var enumBugKeys = _dereq_('./_enum-bug-keys');

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};

},{"./_enum-bug-keys":26,"./_object-keys-internal":43}],45:[function(_dereq_,module,exports){
exports.f = {}.propertyIsEnumerable;

},{}],46:[function(_dereq_,module,exports){
// most Object methods by ES6 should accept primitives
var $export = _dereq_('./_export');
var core = _dereq_('./_core');
var fails = _dereq_('./_fails');
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};

},{"./_core":21,"./_export":27,"./_fails":28}],47:[function(_dereq_,module,exports){
module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

},{}],48:[function(_dereq_,module,exports){
var shared = _dereq_('./_shared')('keys');
var uid = _dereq_('./_uid');
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};

},{"./_shared":49,"./_uid":57}],49:[function(_dereq_,module,exports){
var core = _dereq_('./_core');
var global = _dereq_('./_global');
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: _dereq_('./_library') ? 'pure' : 'global',
  copyright: '© 2018 Denis Pushkarev (zloirock.ru)'
});

},{"./_core":21,"./_global":29,"./_library":37}],50:[function(_dereq_,module,exports){
'use strict';
var fails = _dereq_('./_fails');

module.exports = function (method, arg) {
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call
    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
  });
};

},{"./_fails":28}],51:[function(_dereq_,module,exports){
var toInteger = _dereq_('./_to-integer');
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};

},{"./_to-integer":52}],52:[function(_dereq_,module,exports){
// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};

},{}],53:[function(_dereq_,module,exports){
// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = _dereq_('./_iobject');
var defined = _dereq_('./_defined');
module.exports = function (it) {
  return IObject(defined(it));
};

},{"./_defined":23,"./_iobject":34}],54:[function(_dereq_,module,exports){
// 7.1.15 ToLength
var toInteger = _dereq_('./_to-integer');
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};

},{"./_to-integer":52}],55:[function(_dereq_,module,exports){
// 7.1.13 ToObject(argument)
var defined = _dereq_('./_defined');
module.exports = function (it) {
  return Object(defined(it));
};

},{"./_defined":23}],56:[function(_dereq_,module,exports){
// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = _dereq_('./_is-object');
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};

},{"./_is-object":36}],57:[function(_dereq_,module,exports){
var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};

},{}],58:[function(_dereq_,module,exports){
var store = _dereq_('./_shared')('wks');
var uid = _dereq_('./_uid');
var Symbol = _dereq_('./_global').Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;

},{"./_global":29,"./_shared":49,"./_uid":57}],59:[function(_dereq_,module,exports){
'use strict';
var $export = _dereq_('./_export');
var $filter = _dereq_('./_array-methods')(2);

$export($export.P + $export.F * !_dereq_('./_strict-method')([].filter, true), 'Array', {
  // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments[1]);
  }
});

},{"./_array-methods":17,"./_export":27,"./_strict-method":50}],60:[function(_dereq_,module,exports){
'use strict';
var $export = _dereq_('./_export');
var $forEach = _dereq_('./_array-methods')(0);
var STRICT = _dereq_('./_strict-method')([].forEach, true);

$export($export.P + $export.F * !STRICT, 'Array', {
  // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])
  forEach: function forEach(callbackfn /* , thisArg */) {
    return $forEach(this, callbackfn, arguments[1]);
  }
});

},{"./_array-methods":17,"./_export":27,"./_strict-method":50}],61:[function(_dereq_,module,exports){
'use strict';
var $export = _dereq_('./_export');
var $map = _dereq_('./_array-methods')(1);

$export($export.P + $export.F * !_dereq_('./_strict-method')([].map, true), 'Array', {
  // 22.1.3.15 / 15.4.4.19 Array.prototype.map(callbackfn [, thisArg])
  map: function map(callbackfn /* , thisArg */) {
    return $map(this, callbackfn, arguments[1]);
  }
});

},{"./_array-methods":17,"./_export":27,"./_strict-method":50}],62:[function(_dereq_,module,exports){
'use strict';
var $export = _dereq_('./_export');
var $some = _dereq_('./_array-methods')(3);

$export($export.P + $export.F * !_dereq_('./_strict-method')([].some, true), 'Array', {
  // 22.1.3.23 / 15.4.4.17 Array.prototype.some(callbackfn [, thisArg])
  some: function some(callbackfn /* , thisArg */) {
    return $some(this, callbackfn, arguments[1]);
  }
});

},{"./_array-methods":17,"./_export":27,"./_strict-method":50}],63:[function(_dereq_,module,exports){
// 19.1.3.1 Object.assign(target, source)
var $export = _dereq_('./_export');

$export($export.S + $export.F, 'Object', { assign: _dereq_('./_object-assign') });

},{"./_export":27,"./_object-assign":38}],64:[function(_dereq_,module,exports){
var $export = _dereq_('./_export');
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: _dereq_('./_object-create') });

},{"./_export":27,"./_object-create":39}],65:[function(_dereq_,module,exports){
var $export = _dereq_('./_export');
// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
$export($export.S + $export.F * !_dereq_('./_descriptors'), 'Object', { defineProperty: _dereq_('./_object-dp').f });

},{"./_descriptors":24,"./_export":27,"./_object-dp":40}],66:[function(_dereq_,module,exports){
// 19.1.2.14 Object.keys(O)
var toObject = _dereq_('./_to-object');
var $keys = _dereq_('./_object-keys');

_dereq_('./_object-sap')('keys', function () {
  return function keys(it) {
    return $keys(toObject(it));
  };
});

},{"./_object-keys":44,"./_object-sap":46,"./_to-object":55}],67:[function(_dereq_,module,exports){
/**
 * empower-core - Power Assert feature enhancer for assert function/object.
 *
 * https://github.com/twada/power-assert-runtime/packages/empower-core
 *
 * Copyright (c) 2013-2018 Takuto Wada
 * Licensed under the MIT license.
 *   https://github.com/twada/power-assert-runtime/blob/master/LICENSE
 */
var create = _dereq_('core-js/library/fn/object/create');
var assign = _dereq_('core-js/library/fn/object/assign');
var defaultOptions = _dereq_('./lib/default-options');
var Decorator = _dereq_('./lib/decorator');
var define = _dereq_('./lib/define-properties');
var slice = Array.prototype.slice;

/**
 * Enhance Power Assert feature to assert function/object.
 * @param assert target assert function or object to enhance
 * @param options enhancement options
 * @return enhanced assert function/object
 */
function empowerCore (assert, options) {
    var typeOfAssert = (typeof assert);
    var enhancedAssert;
    if ((typeOfAssert !== 'object' && typeOfAssert !== 'function') || assert === null) {
        throw new TypeError('empower-core argument should be a function or object.');
    }
    if (isEmpowered(assert)) {
        return assert;
    }
    switch (typeOfAssert) {
    case 'function':
        enhancedAssert = empowerAssertFunction(assert, options);
        break;
    case 'object':
        enhancedAssert = empowerAssertObject(assert, options);
        break;
    default:
        throw new Error('Cannot be here');
    }
    define(enhancedAssert, { _empowered: true });
    return enhancedAssert;
}

function empowerAssertObject (assertObject, options) {
    var config = assign(defaultOptions(), options);
    var target = config.destructive ? assertObject : create(assertObject);
    var decorator = new Decorator(target, config);
    return assign(target, decorator.enhancement());
}

function empowerAssertFunction (assertFunction, options) {
    var config = assign(defaultOptions(), options);
    if (config.destructive) {
        throw new Error('cannot use destructive:true to function.');
    }
    var decorator = new Decorator(assertFunction, config);
    var enhancement = decorator.enhancement();
    var powerAssert;
    if (typeof enhancement === 'function') {
        powerAssert = function powerAssert () {
            return enhancement.apply(null, slice.apply(arguments));
        };
    } else {
        powerAssert = function powerAssert () {
            return assertFunction.apply(null, slice.apply(arguments));
        };
    }
    assign(powerAssert, assertFunction);
    return assign(powerAssert, enhancement);
}

function isEmpowered (assertObjectOrFunction) {
    return assertObjectOrFunction._empowered;
}

empowerCore.defaultOptions = defaultOptions;
module.exports = empowerCore;

},{"./lib/decorator":69,"./lib/default-options":70,"./lib/define-properties":71,"core-js/library/fn/object/assign":10,"core-js/library/fn/object/create":11}],68:[function(_dereq_,module,exports){
'use strict';

var some = _dereq_('core-js/library/fn/array/some');
var map = _dereq_('core-js/library/fn/array/map');

function decorate (callSpec, decorator) {
    var numArgsToCapture = callSpec.numArgsToCapture;

    return function decoratedAssert () {
        var context, message, hasMessage = false;

        // see: https://github.com/twada/empower-core/pull/8#issue-127859465
        // see: https://github.com/petkaantonov/bluebird/wiki/Optimization-killers#32-leaking-arguments
        var args = new Array(arguments.length);
        for(var i = 0; i < args.length; ++i) {
            args[i] = arguments[i];
        }

        if (numArgsToCapture === (args.length - 1)) {
            message = args.pop();
            hasMessage = true;
        }

        var invocation = {
            thisObj: this,
            values: args,
            message: message,
            hasMessage: hasMessage
        };

        if (some(args, isCaptured)) {
            invocation.values = map(args.slice(0, numArgsToCapture), function (arg) {
                if (isNotCaptured(arg)) {
                    return arg;
                }
                if (!context) {
                    context = {
                        source: arg.source,
                        args: []
                    };
                }
                context.args.push({
                    value: arg.powerAssertContext.value,
                    events: arg.powerAssertContext.events
                });
                return arg.powerAssertContext.value;
            });

            return decorator.concreteAssert(callSpec, invocation, context);
        } else {
            return decorator.concreteAssert(callSpec, invocation);
        }
    };
}

function isNotCaptured (value) {
    return !isCaptured(value);
}

function isCaptured (value) {
    return (typeof value === 'object') &&
        (value !== null) &&
        (typeof value.powerAssertContext !== 'undefined');
}

module.exports = decorate;

},{"core-js/library/fn/array/map":8,"core-js/library/fn/array/some":9}],69:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_('core-js/library/fn/array/for-each');
var filter = _dereq_('core-js/library/fn/array/filter');
var map = _dereq_('core-js/library/fn/array/map');
var signature = _dereq_('call-signature');
var decorate = _dereq_('./decorate');
var keys = _dereq_('core-js/library/fn/object/keys');


function Decorator (receiver, config) {
    this.receiver = receiver;
    this.config = config;
    this.onError = config.onError;
    this.onSuccess = config.onSuccess;
    this.signatures = map(config.patterns, parse);
    this.wrapOnlySignatures = map(config.wrapOnlyPatterns, parse);
}

Decorator.prototype.enhancement = function () {
    var that = this;
    var container = this.container();
    var wrappedMethods = [];

    function attach(matcherSpec, enhanced) {
        var matcher = matcherSpec.parsed;
        var methodName = detectMethodName(matcher.callee);
        if (typeof that.receiver[methodName] !== 'function' || wrappedMethods.indexOf(methodName) !== -1) {
            return;
        }
        var callSpec = {
            thisObj: that.receiver,
            func: that.receiver[methodName],
            numArgsToCapture: numberOfArgumentsToCapture(matcherSpec),
            matcherSpec: matcherSpec,
            enhanced: enhanced
        };
        container[methodName] = callSpec.enhancedFunc = decorate(callSpec, that);
        wrappedMethods.push(methodName);
    }

    forEach(filter(this.signatures, methodCall), function (matcher) {
        attach(matcher, true);
    });

    forEach(filter(this.wrapOnlySignatures, methodCall), function (matcher) {
        attach(matcher, false);
    });

    return container;
};

Decorator.prototype.container = function () {
    var basement = {};
    if (typeof this.receiver === 'function') {
        var candidates = filter(this.signatures, functionCall);
        var enhanced = true;
        if (candidates.length === 0) {
            enhanced = false;
            candidates = filter(this.wrapOnlySignatures, functionCall);
        }
        if (candidates.length === 1) {
            var callSpec = {
                thisObj: null,
                func: this.receiver,
                numArgsToCapture: numberOfArgumentsToCapture(candidates[0]),
                matcherSpec: candidates[0],
                enhanced: enhanced
            };
            basement = callSpec.enhancedFunc = decorate(callSpec, this);
        }
    }
    return basement;
};

Decorator.prototype.concreteAssert = function (callSpec, invocation, context) {
    var func = callSpec.func;
    var thisObj = this.config.bindReceiver ? callSpec.thisObj : invocation.thisObj;
    var enhanced = callSpec.enhanced;
    var args = invocation.values;
    var message = invocation.message;
    var matcherSpec = callSpec.matcherSpec;

    if (context && typeof this.config.modifyMessageBeforeAssert === 'function') {
        message = this.config.modifyMessageBeforeAssert({originalMessage: message, powerAssertContext: context});
    }
    args = args.concat(message);

    var data = {
        thisObj: invocation.thisObj,
        assertionFunction: callSpec.enhancedFunc,
        originalMessage: message,
        defaultMessage: matcherSpec.defaultMessage,
        matcherSpec: matcherSpec,
        enhanced: enhanced,
        args: args
    };

    if (context) {
        data.powerAssertContext = context;
    }

    return this._callFunc(func, thisObj, args, data);
};

// see: https://github.com/twada/empower-core/pull/8#issuecomment-173480982
Decorator.prototype._callFunc = function (func, thisObj, args, data) {
    var ret;
    try {
        ret = func.apply(thisObj, args);
    } catch (e) {
        data.assertionThrew = true;
        data.error = e;
        return this.onError.call(thisObj, data);
    }
    data.assertionThrew = false;
    data.returnValue = ret;
    return this.onSuccess.call(thisObj, data);
};

function numberOfArgumentsToCapture (matcherSpec) {
    var matcher = matcherSpec.parsed;
    var len = matcher.args.length;
    var lastArg;
    if (0 < len) {
        lastArg = matcher.args[len - 1];
        if (lastArg.name === 'message' && lastArg.optional) {
            len -= 1;
        }
    }
    return len;
}


function detectMethodName (callee) {
    if (callee.type === 'MemberExpression') {
        return callee.member;
    }
    return null;
}


function functionCall (matcherSpec) {
    return matcherSpec.parsed.callee.type === 'Identifier';
}


function methodCall (matcherSpec) {
    return matcherSpec.parsed.callee.type === 'MemberExpression';
}

function parse(matcherSpec) {
    if (typeof matcherSpec === 'string') {
        matcherSpec = {pattern: matcherSpec};
    }
    var ret = {};
    forEach(keys(matcherSpec), function (key) {
        ret[key] = matcherSpec[key];
    });
    ret.parsed = signature.parse(matcherSpec.pattern);
    return ret;
}


module.exports = Decorator;

},{"./decorate":68,"call-signature":5,"core-js/library/fn/array/filter":6,"core-js/library/fn/array/for-each":7,"core-js/library/fn/array/map":8,"core-js/library/fn/object/keys":13}],70:[function(_dereq_,module,exports){
'use strict';

module.exports = function defaultOptions () {
    return {
        destructive: false,
        bindReceiver: true,
        onError: onError,
        onSuccess: onSuccess,
        patterns: [
            'assert(value, [message])',
            'assert.ok(value, [message])',
            'assert.equal(actual, expected, [message])',
            'assert.notEqual(actual, expected, [message])',
            'assert.strictEqual(actual, expected, [message])',
            'assert.notStrictEqual(actual, expected, [message])',
            'assert.deepEqual(actual, expected, [message])',
            'assert.notDeepEqual(actual, expected, [message])',
            'assert.deepStrictEqual(actual, expected, [message])',
            'assert.notDeepStrictEqual(actual, expected, [message])'
        ],
        wrapOnlyPatterns: []
    };
};

function onError (errorEvent) {
    var e = errorEvent.error;
    if (errorEvent.powerAssertContext && /^AssertionError/.test(e.name)) {
        e.powerAssertContext = errorEvent.powerAssertContext;
    }
    throw e;
}

function onSuccess(successEvent) {
    return successEvent.returnValue;
}

},{}],71:[function(_dereq_,module,exports){
arguments[4][4][0].apply(exports,arguments)
},{"core-js/library/fn/array/for-each":7,"core-js/library/fn/object/define-property":12,"core-js/library/fn/object/keys":13,"dup":4}]},{},[1])(1)
});
