'use strict'

const mssql = require('./')
// const wtf = require('wtfnode')

const sqlConfig = {
  password: 'Upper_l0wercase',
  database: 'di_production',
  // connectionTimeout: undefined,
  // requestTimeout: 30000,
  stream: false,
  options: {
    encrypt: true,
    readOnlyIntent: true
  },
  port: 1433,
  user: 'sa',
  server: 'localhost',
  pool: {
    acquireTimeoutMillis: 1000,
    propagateCreateError: true,
  },
}

let errorCount = 0

let pool

let reconnectTimer

let startTime

function createPool() {
  return new mssql.ConnectionPool(sqlConfig)
}

const poolRequest = createPool()

function connect () {
  console.log('trying to connect to server')
  // const poolRequest = createPool()
  mssql.on('error', () => {
    console.log('error event fired')
  })
  return mssql.connect(sqlConfig).then((connection) => {
    // setTimeout(connection.close.bind(connection), 2000)
    console.log('connection established')
    console.log(connection)
    connection.on('error', (e) => {
      errorCount++
      // clearInterval(interval)
      pool = null
      // console.log('connection error', e)
      if (connection.connected || connection.connecting) {
        console.log('Connection errored, trying to close connection', errorCount, e)
        connection.close((e) => {
          console.log(new Date() - startTime)
          console.log('connection closed')
          if (e) {
            errorCount++
            // console.log('connection close error', errorCount)
          } else {
            // if (reconnectTimer) {
            //   clearTimeout(reconnectTimer)
            // }
            // reconnectTimer = setTimeout(reconnect, 1500)
          }
        })
      }
    })
    pool = connection
  }).catch((e) => {
    errorCount++
    console.log('failed to establish connection', errorCount, e)
    console.log(e.toString())
    // clearInterval(interval)
    throw e
  })
}

function reconnect () {
  console.log('reconnect called')
  connect()
}

function getTime () {
  console.log('getTime called')
  if (!pool) {
    console.log('no connection is ready')
    return
  }
  console.log('attempting query')
  startTime = new Date()
  pool.query('SELECT GETUTCDATE()').then((result) => {
    console.log(result)
    setTimeout(getTime, 2000)
    // console.log('closing')
    // pool.close(() => {
    //   console.log('closed')
    // })
  }).catch((e) => {
    errorCount++
    console.log('error performing query', errorCount, e)
    // wtf.dump()
    // clearInterval(interval)
  })
}

let interval

connect().then(() => {
  getTime()
  // interval = setInterval(getTime, 5000)
}).catch(() => {

})

// setTimeout(poolRequest.close.bind(poolRequest), 15000)
