var SCWorker = require('socketcluster/scworker');
var TelegramWorker = require('./workers/TelegramNotification-worker');
var LiveOccWorker = require('./workers/LiveOccupancy-worker');
var NotifyScadaRemoteWorker = require('./workers/NotifyScadaRemote-worker');
var LiveQueueCountingWorker = require('./workers/LiveQueueCounting-worker');
var WashroomFacilitiesWorker = require('./workers/WashroomFacilities-worker');
var SmartBin = require('./workers/SmartBin-worker');
//var Precount = require('./workers/PreCount-worker');
var mongoUtil = require('./resource/Connection');
var cluster = require('cluster');
var once = true;

class Worker extends SCWorker {
	
    run() {
        console.log('   >> Default Worker extends SCWorker PID:', process.pid);
		var scServer = this.scServer;

        /*
          In here we handle our incoming realtime connections and listen for events.
        */
        scServer.on('connection', function (socket) {
            console.log(socket.id + " joined");
            mongoUtil.connectToServer( function( err, client ) {
                if (err) console.log(err);
                // start the rest of your app here
                TelegramWorker.attach(scServer, socket);
				LiveOccWorker.attach(scServer, socket);
				LiveQueueCountingWorker.attach(scServer, socket);
                WashroomFacilitiesWorker.attach(scServer, socket);
                SmartBin.attach(scServer, socket);
				// if (cluster.isMaster) {

					// Precount.attach(scServer);
				// }
              } );
            
            
            //NotifyScadaRemoteWorker.attach(scServer, socket);


            // disconnect
            socket.on('disconnect', function (data) {
                console.log(socket.id + " exited");
            });
        });

    }
}

new Worker();