module.exports.attach = function (scServer, socket) {

    //Mongo connection
    const MongoClient = require('mongodb').MongoClient;
    const assert = require('assert');

    // Connection URL
    const url = require('.././resource/selectedconfig').url;
    // Database Name
    const dbName = 'footfallcounter';
    const mongoTable = require('.././resource/config').mongoTable;

    // Debug
    const debug = 0;
    const Utility = require('.././helpers/Utility');

    //#region occupancy function
    //insert occupancy  document
    const insertDriveThruData = async function (db, doc, callback) {
        // Get the documents collection
        const collection = db.collection(mongoTable.driveThrough);
        // Insert some documents
        await collection.insertMany(doc, function (err, result) {
            assert.equal(err, null);
            callback(result);
        });
    };

    socket.on('driveThruData', function (drivethruData) {
        MongoClient.connect(url, { useNewUrlParser: true }, function (err, client) {
            assert.equal(err, null);

            const db = client.db(dbName);
            if(drivethruData[0][0].dataID !=0){
                alldataid = [];
                drivethruData[0].forEach(function (obj) {
                    alldataid.push(obj.dataID);
                });
                db.collection(mongoTable.driveThrough).aggregate([{
                    $match: {
                        serial: drivethruData[0][0].serial,
                        dataID: {
                            $in: alldataid
                        }
                    }
                }],
                function (err, cursor) {
                    assert.equal(err, null);
                    cursor.toArray(function (err, result) {
                        result = result.map(function(item){
                          return item['dataID'];
                        });
                        serial = drivethruData[0][0].serial;
                        filteredData = drivethruData[0].filter(x => !result.includes(x.dataID) && x.dataID != 0);
                        filteredData = filteredData.filter(Utility.onlyUnique);

                        topublish = [];
                        if(filteredData.length > 0){
                            insertDriveThruData(db, filteredData, function () {
                              client.close();
                          });
                        }
                        socket.emit('driveThruData', drivethruData)
                    });
                });
            }
        });
    });
};
