module.exports.attach = function (scServer, socket) {

    //Mongo connection
    const assert = require('assert');
    const mongoUtil = require('.././resource/Connection');

    // Connection URL
    const url = require('.././resource/selectedconfig').url;
    const mongoTable = require('.././resource/config').mongoTable;

    // Debug
    const debug = 0;
    const Utility = require('.././helpers/Utility');
	const fs = require('fs');

    //RabbitMQ Variables
    const localhost = 'http://127.0.0.1'
    const rmqport = require('.././resource/config').rabbitMQ.port;
    const rmqPath = 'queueRabbitMQ'
    const rmqURL = localhost + ":" + rmqport + "/"+ rmqPath

    var rp = require('request-promise');
    var headersOpt = {
        "content-type": "application/json",
    };

    //#region occupancy function
    //insert occupancy  document
    const insertOccupancy = function (db, doc, callback) {
        // Get the documents collection
        const liveCountingCollection = db.collection(mongoTable.liveCounting);
        const notification = db.collection(mongoTable.notification);

        var totalIn = 0;
        var totalOut = 0;

        // Prevent Insert Duplicate serial and dataID
        let dataUpdate = doc.map(data => {
            totalIn += data.inValue;
            totalOut += data.outValue;
            return ({
                updateOne: {
                    filter: { serial: data.serial, dataID: data.dataID },
                    update: { $set: data },
                    upsert: true
                }
            });
        });

        liveCountingCollection.bulkWrite(dataUpdate, function (err, result) {
            notification.findOneAndUpdate(
                {
                    $and: [
                        { serial: doc[0].serial },
                        { threshold: { $gt: 0 } }
                    ]
                },
                { $inc: { currentCount: totalIn } }
            );
            Utility.Log("Write Success, Total In = " + totalIn + ", " + totalOut, debug);
            callback(result);
        });

        // Insert some documents
        // liveCountingCollection.insertMany(doc, function (err, result) {
        //     assert.equal(err, null);
        //     //update notification if exist
        //     var total = doc.reduce(function (prev, cur) {
        //         return prev + cur.inValue;
        //     }, 0);
        //     notification.findOneAndUpdate(
        //         {
        //             $and: [
        //                 { serial: doc[0].serial },
        //                 { threshold: { $gt: 0 } }
        //             ]
        //         },
        //         { $inc: { currentCount: total } }
        //     )
        //     callback(result);
        // });
    };

    //get occupancy document
    const getOccupancy = function (db, data, callback) {
        const collection = db.collection(mongoTable.liveCounting);
        collection.aggregate([
            {
                "$match": {
                    "serial": {
                        "$in": data.counters
                    },
                }
            },
            {
                "$group": {
                    "_id": {
                        "Serial": "$serial",
                        "dataID": { "$ifNull": ["$dataID", "$_id"] }
                    },
                    "inValue": {
                        "$max": "$inValue"
                    },
                    "outValue": {
                        "$max": "$outValue"
                    },
                    "timestamp": {
                        "$max": "$timestamp"
                    }
                }
            },
            {
                "$project": {
                    "Serial": "$_id.Serial",
                    "ValueDateTime": {
                        "$multiply": ['$timestamp', 1000]
                    },
                    "InValue": "$inValue",
                    "OutValue": "$outValue"
                }
            },
            {
                "$match": {
                    "$or": data.operatingHourCondition
                }
            },
            {
                "$group": {
                    "_id": {
                        "serial": "$Serial"
                    },
                    "SUM(InValue)": {
                        "$sum": "$InValue"
                    },
                    "SUM(OutValue)": {
                        "$sum": "$OutValue"
                    }
                }
            },
            {
                "$project": {
                    "_id": 0,
                    "InValue": "$SUM(InValue)",
                    "OutValue": "$SUM(OutValue)",
                    "Serial": "$_id.serial"
                }
            }
        ],
            function (err, cursor) {
                assert.equal(err, null);
                cursor.toArray(function (err, result) {
                    callback(result);
                });
            }
        );
    };
    //#endregion

    function toUpperCaseRabbitMQ(obj) {
        var key, upKey;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                upKey = key.charAt(0).toUpperCase() + key.slice(1)
                if (upKey !== key) {
                    obj[upKey] = obj[key];
                    delete(obj[key]);
                }
            }
        }
        return obj;
    }

    const queueRabbitMQ = async function (topic, dataList) {
        dataList.forEach(data => {
            data = toUpperCaseRabbitMQ(data);
            queueData = {};
            queueData["Topic"] = topic
            queueData["Data"] = data
            
            let request = {
                method:'post',
                url:rmqURL,
                form: JSON.stringify(queueData),
                headers: headersOpt,
                json: true,
            };

            try {
                sendBackhaul(request, 0);
            }
            catch(err) {
                console.log(err.message);
            }
        });
    };

    async function sendBackhaul(request, tries){
        try{
            rp(request)
            .then(function (res) {
                Utility.Log(tries + " Attempt at Pulsar: " + res, debug);
            })
            .catch(function (res) {
                tries = tries + 1;
                if(tries<3){
                    sendBackhaul(request, tries);
                } else {
                    Utility.Log("Tried 3 times -- failed to send.", debug);
                }
            });
        }
        catch(err){
            console.log(err.message);
        }
    }

    const resetThreshold = function (db, data) {
        const collection = db.collection(mongoTable.washroomResetTrigger);
        collection.insertOne(data, function (err, result) {
            assert.equal(err, null);
            Utility.Log("1 document inserted")
        });
    };

    //#region Counter Event
    socket.on('liveData', function (liveData) {
        let serial = liveData[0][0].serial;
        if (liveData[0][0].dataID != 0) {
            var db = mongoUtil.getDb();
            alldataid = [];
            liveData[0].forEach(function (obj) {
                alldataid.push(obj.dataID);
                obj.create_at = new Date();
            });
            db.collection(mongoTable.liveCounting).aggregate([{
                $match: {
                    serial: serial,
                    dataID: {
                        $in: alldataid
                    }
                }
            }],
                function (err, cursor) {
                    let existingData = [];
                    cursor.toArray(function (err, result) {
                        if (result) {
                            existingData = result.map(function (item) {
                                return item['dataID'] + "-" + item['timestamp'];
                            });
                        }

                        filteredData = liveData[0].filter(x => !existingData.includes(x.dataID + "-" + x.timestamp) && x.dataID != 0);
                        filteredData = filteredData.filter(Utility.onlyUnique);

                        topublish = [];
                        insertOccupancy(db, liveData[0], function () {
                        });
                        if (filteredData.length > 0) {
                            topublish = filteredData;
							/*if(liveData[1].name == "MakroNederland_57"){
								Utility.Log(liveData[1].name + ": Counter " + serial, 1);
								Utility.Log(topublish, 1);
							}*/
							scServer.exchange.publish(liveData[1].name, topublish);
							scServer.exchange.publish('Test', topublish);
                            try {
                                //Try not to Pulsar first
								//queueRabbitMQ("ffc-liveoccupancydata", topublish);
                            }
                            catch(err) {
                                console.log(err.message);
                            }
                            
                        }
                        else {
                            topublish.push({
                                dataID: 0,
                                inValue: 0,
                                outValue: 0,
                                serial: serial
                            });
							scServer.exchange.publish(liveData[1].name, topublish);
                        }
                        socket.emit('liveDataSuccess', liveData[2])
                    });
                }
            );
        }
        else {
            scServer.exchange.publish(
                liveData[1].name,
                [{
                    dataID: 0,
                    inValue: 0,
                    outValue: 0,
                    serial: serial
                }]
            );
        }
    });
    //#endregion End of Counter Event

    //#region Browser Event

    socket.on('getRecords', function (data) {
        var db = mongoUtil.getDb();
        getOccupancy(db, data, function (result) {
            socket.emit('showRecords', result);
            Utility.Log("Get Records for " + data.counters + " On Date : " + data.date, debug);
        });

    });

    socket.on('getResetButton', function (data) {
        var db = mongoUtil.getDb();
        Utility.Log("Connected server");
        Utility.Log(data)
        resetThreshold(db, data, function () {
        });
    });
};
