module.exports.attach = function (scServer, socket) {

    //Mongo connection
    // const MongoClient = require('mongodb').MongoClient;
    const mongoUtil = require('.././resource/Connection');
    const assert = require('assert');

    // Connection URL
    const url = require('.././resource/selectedconfig').url;
    const mongoTable = require('.././resource/config').mongoTable;

    // Debug
    const debug = 1;
    const Utility = require('.././helpers/Utility');

    let sessionList = [];

    //RabbitMQ Variables
    const localhost = 'http://127.0.0.1'
    const rmqport = require('.././resource/config').rabbitMQ.port;
    const rmqPath = 'queueRabbitMQ'
    const rmqURL = localhost + ":" + rmqport + "/"+ rmqPath;

    var rp = require('request-promise');
    var headersOpt = {
        "content-type": "application/json",
    };

    //#region occupancy function
    //insert occupancy  document
    const insertQueueCountingData = async function (db, doc, callback) {
        // Get the documents collection
        let dataUpdate = doc.map(data =>{
            return({
                updateOne:{
                    filter:{ serial: data.serial, dataID: data.dataID},
                    update: { $set: data},
                    upsert: true
                }
            });
        });
        const collection = db.collection(mongoTable.queueServe);
        await collection.bulkWrite(dataUpdate, function (err, result) {
            assert.equal(err, null);
            callback(result)
        });
    };
    const insertQueueLength = async function (db, doc, callback) {
        // Get the documents collection
        const collection = db.collection(mongoTable.queueLength);
        // Insert some documents
        await collection.insertMany(doc, function (err, result) {
            assert.equal(err, null);
            callback(result);
        });
    };

    function toUpperCaseRabbitMQ(obj) {
        var key, upKey;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                upKey = key.charAt(0).toUpperCase() + key.slice(1)
                if (upKey !== key) {
                    obj[upKey] = obj[key];
                    delete(obj[key]);
                }
            }
        }
        return obj;
    }

    const queueRabbitMQ = async function (topic, dataList) {
        dataList.forEach(data => {
            data = toUpperCaseRabbitMQ(data);
            queueData = {};
            queueData["Topic"] = topic
            queueData["Data"] = data
            
            let request = {
                method:'post',
                url:rmqURL,
                form: JSON.stringify(queueData),
                headers: headersOpt,
                json: true,
            };

            try {
                sendBackhaul(request, 0);
            }
            catch(err) {
                console.log(err.message);
            }
        });
    };

    async function sendBackhaul(request, tries){
        try{
            rp(request)
            .then(function (res) {
                console.log(tries + " Attempt at Pulsar: " + res);
            })
            .catch(function (res) {
                tries = tries + 1;
                if(tries<3){
                    sendBackhaul(request, tries);
                } else {
                    console.log("Tried 3 times -- failed to send.")
                }
            });
        }
        catch(err){
            console.log(err.message);
        }
    }

    //QUEUELENGTH
    socket.on('queueLengthData', function (queueLengthData) {
        if (queueLengthData.length != 0) {
            if (queueLengthData[0][0].datetime != 0) {
                var db = mongoUtil.getDb();
                alldatetime = [];
                queueLengthData[0].forEach(function (obj) {
                    alldatetime.push(obj.datetime);
                });
                db.collection(mongoTable.queueLength).aggregate([{
                    $match: {
                        serial: queueLengthData[0][0].serial,
                        datetime: {
                            $in: alldatetime
                        }
                    }
                }],
                    function (err, cursor) {
                        assert.equal(err, null);
                        cursor.toArray(function (err, result) {
                            result = result.map(function (item) {
                                return item['datetime'];
                            });
                            serial = queueLengthData[0][0].serial;

                            filteredData = queueLengthData[0].filter(x => !result.includes(x.datetime));
                            filteredData = filteredData.filter(Utility.onlyUnique);

                            topublish = [];
                            if (filteredData.length > 0) {
                                insertQueueLength(db, filteredData, function () {
                                });
                                try {
                                    //queueRabbitMQ("ffc-livequeuelength", filteredData);
                                }
                                catch(err) {
                                    console.log(err.message);
                                }
                            }
                            socket.emit('queueLengthDataSuccess', 'OK')
                        });
                    });
            }
        }
    });

    //QUEUESERVE
    socket.on('queueServeData', function (queueCountingData) {
        if (queueCountingData.length != 0) {
            if (queueCountingData[0].dataID != 0) {
                var db = mongoUtil.getDb();
                alldataid = [];
                queueCountingData[0].forEach(function (obj) {
                    alldataid.push(obj.dataID);
                });
                db.collection(mongoTable.queueServe).aggregate([{
                    $match: {
                        serial: queueCountingData[0][0].serial,
                        dataID: {
                            $in: alldataid
                        }
                    }
                }],
                    function (err, cursor) {
                        assert.equal(err, null);
                        cursor.toArray(function (err, result) {
                            result = result.map(function (item) {
                                return item['dataID'];
                            });
                            serial = queueCountingData[0].serial;
                            filteredData = queueCountingData[0].filter(x => !result.includes(x.dataID) && x.dataID != 0);
                            filteredData = filteredData.filter(Utility.onlyUnique);

                            topublish = [];
                            if (filteredData.length > 0) {
                                insertQueueCountingData(db, filteredData, function () {
                                });
                                try {
                                    //queueRabbitMQ("ffc-livequeueserve", filteredData);
                                }
                                catch(err) {
                                    console.log(err.message);
                                }
                            }
                            socket.emit('queueServeDataSuccess', queueCountingData[1])
                        });
                    });
            }
        }
    });
};
