const sql = require('mssql');
// mongo db
const MongoClient = require('mongodb').MongoClient;
const assert = require('assert');
// mssql
const sqlconfig = require('.././resource/config')['mssql'];
const mongoTable = require('.././resource/config').mongoTable;
// Connection URL
var selectedConfig = require('.././resource/selectedconfig');
// scada remote
var scadaRemoteList = require('.././resource/config')['scadaRemote'];

// Debug
const debug = 0;
const Utility = require('.././helpers/Utility');

// url for mongo
const url = selectedConfig.url;
// ffc cloud server
const ffcurl = selectedConfig.ffcurl;
const isSecure = selectedConfig.isSecure;
// scada remote server
const SRurl = scadaRemoteList.url;
const channel = scadaRemoteList.channel;

var httpvalue = require('http');
// trigger
const dbName = 'footfallcounter';
var isFirstTime = true;

module.exports.attach = function (scServer, socket) {
    socket.on('NotifyScadaRemote', function (data) {
        // to get the global variables for current data
        if (isFirstTime) {
            isFirstTime = false;
            setInterval(triggerScadaRemote, 10000);
        }
        ScadaRemoteAPI(data);
    });
};

function secondsToDhms(seconds) {
    seconds = Number(seconds);
    var d = Math.floor(seconds / (3600 * 24));
    var h = Math.floor(seconds % (3600 * 24) / 3600);
    var m = Math.floor(seconds % 3600 / 60);
    var s = Math.floor(seconds % 60);

    var dDisplay = d > 0 ? d + (d == 1 ? " day, " : " days, ") : "";
    var hDisplay = h > 0 ? h + (h == 1 ? " hour, " : " hours, ") : "";
    var mDisplay = m > 0 ? m + (m == 1 ? " minute, " : " minutes, ") : "";
    var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
    return dDisplay + hDisplay + mDisplay + sDisplay;
}

//insert temp Variable while it is online
const insertTempVariable = function (db, doc, callback) {
    const collection = db.collection(mongoTable.scadaRemoteBranchThreshold);
    collection.insertOne(doc, function (err, res) {
        assert.equal(err, null);

    });
};

//triggerScadaRemote every min
const triggerScadaRemotefunc = function (db, callback) {
    const collection = db.collection(mongoTable.scadaRemoteBranchThreshold);
    var todayDate = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate());
    var tmrDate = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate() + 1);

    collection.aggregate([
        {
            "$match": {
                "datetime": {
                    $lt: tmrDate,
                    $gte: todayDate
                }
            }
        },
        {
            "$group": {
                "_id": {
                    "name": "$name"
                },
                "InValue": {
                    "$sum": "$InValue"
                },
                "OutValue": {
                    "$sum": "$OutValue"
                }
            }
        },
    ],
        function (err, cursor) {
            assert.equal(err, null);
            cursor.toArray(function (err, result) {
                callback(result);
            });
        }
    );
};

function triggerScadaRemote() {
    MongoClient.connect(url, { useNewUrlParser: true }, function (err, client) {
        assert.equal(null, err);
        const db = client.db(dbName);
        triggerScadaRemotefunc(db, function (result) {
            client.close();
            if (result != []) {
                result.forEach(element => {
                    // only for tvb server's branches
                    if (element['_id']['name'] == channel) {
                        httpvalue.get(SRurl + '/api/action/NotifyScadaRemote?valueIn=' + element['InValue'] + '&valueOut=' + element['OutValue'], (resp) => {
                            // A chunk of data has been recieved.
                            // The whole response has been received. Print out the result.
                            resp.on('end', () => {

                            });

                        }).on("error", (err) => {
                            console.log("Error: " + err.message);
                        });
                    }
                });
            }
        });
    });
}

function ScadaRemoteAPI(data) {
    element = {};
    element['InValue'] = Number(data['InValue']);
    element['OutValue'] = Number(data['OutValue']);
    element['serial'] = data['serial'];
    element['name'] = data['name'];
    element['datetime'] = new Date();
    MongoClient.connect(url, { useNewUrlParser: true }, function (err, client) {
        assert.equal(null, err);

        const db = client.db(dbName);
        insertTempVariable(db, element, function () {
            client.close();
        });
    });
}
