var isFirst = true;
module.exports.attach = function (scServer, socket) {
    const mongoTable = require('.././resource/config').mongoTable;
    const mongoUtil = require('.././resource/Connection');
	console.log('do not run here more than once');
	const Utility = require('.././helpers/Utility');
	
    const assert = require('assert');
    var cron = require('node-cron');
    var request = require('request');
    var moment = require('moment');
    var moment = require('moment-timezone');
    var _ = require('lodash');
    const fs = require('fs');
    var {PythonShell} = require( 'python-shell');
    var listSerial;
    var counterSerial = [];
    var TotalInputList = [];
    var totalList = [];
    var db = mongoUtil.getDb();

    const insertOccupancyTest = function (db, doc, callback) {
        // Get the documents collection
        const collection = db.collection(mongoTable.liveCounting);
        // Insert some documents
        collection.insertMany(doc, function (err, result) {
            assert.equal(err, null);
            callback(result);
        });
    };

    function processOffset(offsetList)
    {
        offsetList.forEach(function (obj) {
            var tobeInsertList = [];
            var tobeInsert = {};
            let serialList = listSerial.find(({ BranchID }) => BranchID === obj.branchid);
            if (obj.offset < 0)
            {
                tobeInsert.outValue = obj.offset * -1 ;
                tobeInsert.inValue = 0;
            }
            if (obj.offset > 0)
            {
                tobeInsert.inValue = obj.offset;
                tobeInsert.outValue = 0;
            }
            tobeInsert.serial = serialList.Serial;
            let timestamp = parseInt((moment().utc().valueOf() / 1000 ));
            // current timestamp for counter datetime
            tobeInsert.timestamp = timestamp;
			tobeInsert.dataID = timestamp;
            tobeInsert.create_at = new Date();
            tobeInsert.channel = obj.channel;
            tobeInsertList.push(tobeInsert);
            // only insert when occupancy is not 0
            Utility.Log('processed data... to be insert occupancy and update live ');
            Utility.Log(tobeInsertList);
            if (obj.offset != 0)
            {
                Utility.Log('did i inserted?');
                insertOccupancyTest(db, tobeInsertList, function () {
                });
                topublish = [];
                topublish.push({
                    dataID: -1,
                    inValue: tobeInsert.inValue,
                    outValue: tobeInsert.outValue,
                    serial: tobeInsert.serial,
					timestamp: timestamp
                });
                scServer.exchange.publish(obj.channel, topublish);
            }
        });
    }

    const insertPreCountOffset = function (db, doc, callback) {
        // Get the documents collection
        const collection = db.collection(mongoTable.precount);
        // // Insert some documents
        // await collection.insertMany(doc, function (err, result) {
        //     assert.equal(err, null);
        //     callback(result);
        // });
        Utility.Log('db link');
        Utility.Log(doc);
        let dataUpdate = doc.map(data => {
            // reset the offset to 0 after next day
            return ({
                updateOne: {
                    filter: { branchid: data.branchid},
                    update: { $set: data },
                    upsert: true
                }
            });
        });

        collection.bulkWrite(dataUpdate, function (err, result) {
            callback(result);
        });
    };

    const getPreviousOffset = function (db, callback) {
        // get 5 min ago's offset
        const collection = db.collection(mongoTable.precount);
        collection.aggregate(
            [
            ],
            function (err, cursor) {
                assert.equal(err, null);
                cursor.toArray(function (err, result) {
                    callback(result);
                });
            }
        );
    };
    const getCounterSerial = function (db, callback) {
        var d = new Date();
        d.setMinutes(d.getMinutes() - 30);
        const collection = db.collection(mongoTable.liveCounting);
        collection.aggregate(
            [
                { 
                    "$match": 
                    { 
                        "create_at" : 
                        {
                            "$gte": d
                        } 
                    } 
                },
                { 
                    "$group": 
                    {
                        "_id": 
                        {
                            "serial": "$serial"
                        }
                    }
                },
                {
                    "$project": 
                    {
                        "serial": 1
                    }
                }  
            ],
            function (err, cursor) {
                try {
					assert.equal(err, null);
					cursor.toArray(function (err, result) {
						callback(result);
					});
				}
				catch(err) {
					console.log(err.message);
				}
            }
        );
    };

    const retrieveHourlyDataByBranch = function (db, listSerial, callback) {
        // current timestamp 
		var a = new Date();
		// temporary fix!!!!
		a.setHours(a.getHours());

        var currenttimestamp = Math.floor((a).getTime()/1000);
        // 3 hours ago
        // too heavy at the moment, so use a light one, last 10 min
        //var threeHouragotimestamp = Math.floor(((new Date).getTime() / 1000) - 10800);
        var d = new Date();
        d.setHours(6,0,0,0);
        var threeHouragotimestamp = Math.floor(((d).getTime() / 1000));
        Utility.Log(threeHouragotimestamp);
        //var threeHouragotimestamp = Math.floor(((new Date).getTime() / 1000) - 5000);
        const collection = db.collection(mongoTable.liveCounting);
        collection.aggregate(
            [
                { 
                    "$match":
                    { 
                        "serial": 
                        {
                            "$in": listSerial
                        },
                        "timestamp": 
                        {
                            '$lte': currenttimestamp,
                            '$gte': threeHouragotimestamp
                        },
						"dataID":
						{
							'$lte': 1588071732
						}
                    }
                },
                {
                    "$project": {
                        "time": {
                            $toDate: {
                                "$multiply": ['$timestamp', 1000]
                            } },
                        "inValue": "$inValue",
                        "outValue": "$outValue"
                    }
                },
                {
                    '$group': {
                        "_id": {
                            "$add": [
                                { "$subtract": [
                                    { "$subtract": [ "$time", new Date(0) ] },
                                    { "$mod": [ 
                                        { "$subtract": [ "$time", new Date(0) ] },
                                        1000 * 60 * 1
                                    ]}
                                ] },
                                new Date(0)
                            ]
                        },
                        'totalIN': { '$sum': '$inValue' },
                        'totalOUT': { '$sum': '$outValue' }
                    }
                },
                {
                    "$project": {
                        'occupancy' : { '$subtract' : [ '$totalIN', '$totalOUT' ] },
                    }
                },

                {
                    '$sort': {
                         '_id': 1
                    }
                },
                {
                    '$group': {
                        '_id': 0,
                        'time': { '$push': '$_id' },
                        'occupancy': { '$push': '$occupancy' },
                    }
                },
                {
                    '$unwind': {
                        'path' : '$time',
                        'includeArrayIndex' : 'index'
                    }
                },
                {
                    '$project': {
                        '_id': 0,
                        // 'time': { '$dateToString': { 'format': '%Y-%m-%d %H:%M', 'date': '$time' }  },
                        'time': { '$dateToString': { 'format': '%Y-%m-%d %H:%M', 'date': '$time' }  },
                        'occupancy': { '$arrayElemAt': [ '$occupancy', '$index' ] },
                        'runningTotaloccupancy': { '$sum': { '$slice': [ '$occupancy', { '$add': [ '$index', 1 ] } ] } }
                    }
                },
            ],
            function (err, cursor) {
                assert.equal(err, null);
                cursor.toArray(function (err, result) {
                    Utility.Log(result);
                    const log2 = fs.createWriteStream('../../aaaaaaa.json', { flags: 'w' });

                    // on new log entry ->
                    log2.write(JSON.stringify(result));
                    callback(result);
                });
            }
        );
    };

    function GetOperatingStartEndTime(thisOperatingHour) {
        // temporary for makro
        let StartDateTime =  moment().tz("Europe/Amsterdam");
        let startTime = moment.utc(thisOperatingHour.StartTimestamp * 1000);
        StartDateTime.hour(startTime.hour());
        StartDateTime.minute(startTime.minute());
        StartDateTime.second(startTime.second());
        StartDateTime.milliseconds(0);
        // temporary for makro
        let EndDateTime = moment().tz("Europe/Amsterdam");
        let endTime = moment.utc(thisOperatingHour.EndTimestamp * 1000);
        EndDateTime.hour(endTime.hour());
        EndDateTime.minute(endTime.minute());
        EndDateTime.second(endTime.second());
        EndDateTime.milliseconds(0);
        if (EndDateTime < StartDateTime) {
            EndDateTime.add(1, 'd');
        }

        var data = {
            StartDateTime: StartDateTime,
            EndDateTime: EndDateTime
        };

        return data;
    }

    function callbackfor() 
    { 
        Utility.Log('all done');
        Utility.Log(TotalInputList);
        const log = fs.createWriteStream('../../input.json', { flags: 'w' });
		log.write(JSON.stringify(TotalInputList));
		Utility.Log('wait for 5 sec');
		setTimeout(function() {
// on new log entry ->
        var options = {
            mode: 'text',
            pythonPath: "C:\\Python27\\python.exe",
            pythonOptions: ['-u'],
            scriptPath: "C:\\Projects\\ScServer\\NodeCluster\\occupancy-precount\\",
            args: ["C:\\Projects\\ScServer\\input.json", "C:\\Projects\\ScServer\\output.json", "C:\\Projects\\ScServer\\response.txt"]
            };
            
            PythonShell.run('realtime_count.py', options, function (err, results) {
            if (err) 
                throw err;
            // Results is an array consisting of messages collected during execution
            Utility.Log('results: %j', results);
            });
            Utility.Log('Welcome to My Console,');
            setTimeout(function() {
            fs.readFile('C:\\Projects\\ScServer\\output.json', "utf8",  (err, data) => {
                if (err) throw err;
                Utility.Log('writing output...');
                var offsetList = JSON.parse(data);
                var newOffsetList = JSON.parse(data);
                offsetList.forEach(function (obj) {
                    // 5 minute ago start time
                    obj.create_at = new Date();
                    let channellist = listSerial.find(({ BranchID }) => BranchID === obj.branchid);
                    obj.channel = channellist.CompanyCode + "_" + channellist.BranchCode
                    Utility.Log(obj.channel);
                });
                newOffsetList.forEach(function (obj) {
                    // 5 minute ago start time
                    obj.create_at = new Date();
                    let channellist = listSerial.find(({ BranchID }) => BranchID === obj.branchid);
                    obj.channel = channellist.CompanyCode + "_" + channellist.BranchCode
                    Utility.Log(obj.channel);
                });
                // offset found, insert first before do anytihng
                getPreviousOffset(db, function (result) {
                    Utility.Log('to confirm result got result');
                    Utility.Log(result);
                    if(typeof result === 'undefined' || result === null || typeof result === undefined || Object.keys(result).length === 0)
                    {
                        // means offset is nothing, and offset is first time
                        // directly process the list
                        Utility.Log('offsetlist is empty');
                        processOffset(offsetList);
                    }
                    else
                    {
                        offsetList.forEach(function (obj) {
                            // 5 minute ago start time
                            // find previous data if any
                            Utility.Log('offsetlist is having lists');
                            let serialList = result.find(({ branchid }) => branchid === obj.branchid);
                            if(typeof serialList === 'undefined' || serialList === null || typeof serialList === undefined)
                            {
                                // means offset is not found in this branchid
                            }
                            else
                            {
                                // offset exist
                                if (serialList.offset != 0)
                                {
                                    Utility.Log('offsetlist !=0');
                                    Utility.Log('my newest offset list')
                                    Utility.Log(obj.offset);
                                    // logic here
                                    // whatever exist in new offset, the formula is new offset - old offset
                                    obj.offset = obj.offset - serialList.offset
                                    Utility.Log('my changed offset list')
                                    Utility.Log(obj.offset);
                                }
                            }

                        });
                        processOffset(offsetList);
                    }
                    insertPreCountOffset(db, newOffsetList, function () {
                        Utility.Log('success');
                        // now retrieve the offset we have previously 
                        // logic
                        // Retrieve previous offset
                        // based on the previous offset calculate difference
                    });
                    });
            });
            }, 20000);
			}, 5000);
            Utility.Log('finished.. waiting 8 sec...');
    }

	var executeFirstTimeonly = (function() {
		var executed = false;
		return function() {
			if (!executed) {
				executed = true;
				// do something
			}
		};
	})();

	var once = function() {
		if(once.done) return;
		Utility.Log('Doing this once!');
        once.done = true;
        



        Utility.Log('did i ran here?');
        cron.schedule('*/5 * * * *', () => {
			
		


        // offset found, insert first before do anytihng
        getPreviousOffset(db, function (result) {
            Utility.Log('to check isist next day already');
            Utility.Log(result);
            if(typeof result === 'undefined' || result === null || typeof result === undefined || Object.keys(result).length === 0)
            {
                // means offset empty, donothing
            }
            else
            {
                var isDateDifferent = false;
                var tobeinsertList = [];
                result.forEach(function (obj) {
                    var d = new Date();
                    if (d.getDate() != obj.create_at.getDate())
                    {
                        isDateDifferent = true;
                        Utility.Log('why different??? ');
                        Utility.Log(d.getDate());
                        Utility.Log(obj.create_at.getDate());
                        obj.offset = 0;
                        obj.create_at = new Date();
                        tobeinsertList.push(obj);
                    }
                });
                if (isDateDifferent)
                {
                    insertPreCountOffset(db, tobeinsertList, function () {
                        Utility.Log('success updated');
                        // now retrieve the offset we have previously 
                        // logic
                        // Retrieve previous offset
                        // based on the previous offset calculate difference
                    });
                }
            }
            });
            // 1) to be insert the func here

            //  2) Aggregate MongoDB to get counterSerial within last 15 min active 
            getCounterSerial(db, function (result) {
                result.forEach(function (obj) {
                    counterSerial.push(obj['_id']);
                });
                var options = {
                    'method': 'POST',
                    'url': 'http://portal.footfallcam.com/api/action/GetCounterBranchDetails',
                    'headers': {
                      'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(counterSerial)
                  
                  };
                  // 3) request call with the serial to get branch data
                  request(options, function (error, response) { 
                    if (error) throw new Error(error);
                    // Utility.Log(response.body);
                    var listBranchandOH = JSON.parse(response.body);
                    listSerial = listBranchandOH['CounterList'];
                    var branchOHList = listBranchandOH['OperatingHourList'];
                    var makroList = [19453
                        ,19454
                        ,19455
                        ,19456
                        ,19457
                        ,19458
                        ,19459
                        ,19460
                        ,19461
                        ,19462
                        ,19463
                        ,19464
                        ,19465
                        ,19466
                        ,19467
                        ,19468
                        ,19469];
                   // var makroList = [18815];
                        TotalInputList = [];
                        var itemsProcessed = 0;
                        makroList.forEach(function (obj, index, array) {
                            let serialList = listSerial.filter(({ BranchID }) => BranchID === obj).map(function(obj){ return obj.Serial; });
                            retrieveHourlyDataByBranch(db, serialList, function (result) {
                                Utility.Log('steps1');
                                totalList = [];
                                Utility.Log(result);
                                result.forEach(function (obj3) {
                                    Utility.Log('steps2');
                                    let OperatingHourList = branchOHList.find(({ BranchId }) => BranchId === obj);
                                    if(typeof OperatingHourList === 'undefined' || OperatingHourList === null || typeof OperatingHourList === undefined)
                                    {
                                        // donotthing
                                    }
                                    else
                                    {
                                        // convert time to timestamp 
                                        var a = new Date(obj3.time);
                                        // temporary fix!!!!
                                        a.setHours(a.getHours() + 2 );
                                        Utility.Log(JSON.stringify(a));
                                        let timestamp = a.getTime() / 1000;
                                        Utility.Log(timestamp);
                                        OperatingHourList['OperatingHours'].forEach(function (obj2) 
                                        {
                                            var d = new Date();
                                            var n = d.getDay();
                                            if (obj2.Day === n) 
                                            {
                                                var currOpHour =  GetOperatingStartEndTime(obj2);
                                                if (timestamp >= (currOpHour.StartDateTime.valueOf() / 1000 ) && timestamp <= (currOpHour.EndDateTime.valueOf() / 1000)) {
        
                                                    //Utility.log('values are within timezone');
                                                    let list = {};
                                                    list.timestamp = timestamp;
                                                    list.occupancy = obj3.runningTotaloccupancy;
                                                    totalList.push(list);
                                                }
                                                else
                                                {
                                                    Utility.Log('i in here');
                                                }
                                            }
                                        })
                                    }
                                });
                                if(typeof totalList === 'undefined' || totalList === null || typeof totalList === undefined || totalList == [] || totalList == '[]' || Object.keys(totalList).length === 0)
                                {
                                    // donotthing
                                }
                                else{
                                // finish get totalList, is time to push to real list
                                    let branchfilterList = {};
                                    branchfilterList.branchid = obj;
                                    branchfilterList.historicalOccupancy = totalList;
                                    TotalInputList.push(branchfilterList);
                                    Utility.Log(branchfilterList);
                                    Utility.Log('inserted Total');
                                    Utility.Log('steps3');
                                }
                                itemsProcessed++;
                                if(itemsProcessed === array.length) {
                                  callbackfor();
                                }
                            });
                        });
                    // // 4) Get all 3 hours branch data with branchid 
                    // retrieveHourlyDataByBranch(db, listSerial, function (result) {

                    //     // 5) Reorganize the data into Raven needed format and save into input.json
                    //     Utility.Log('finish run');
                    //     Utility.Log('my final list');
                    //     Utility.Log(totalList);
                    // const log2 = fs.createWriteStream('../totalList.json', { flags: 'w' });
                    // // on new log entry ->
                    // log2.write(JSON.stringify(totalList) + "\r\n");
                    // let grouped1 = _.groupBy(totalList, (dm) => dm.BranchID);
                    // let a = Object.keys(grouped1).map((BranchID) => {
                    //     let groupItems = grouped1[BranchID];
                    //     let a = groupItems.map((dm) => _.pick(dm, "timestamp", "inValue", "outValue"));
                    //     // converet every timestamp into minute based
                    //     a.forEach(function (obj) {
                    //         let a = new Date(obj.timestamp * 1000);
                    //         a.setSeconds(0,0);
                    //         obj.timestamp = a.getTime() / 1000;
                    //     });
                    //     let b = _.map(_.groupBy(a, 'timestamp'), (o,idx) => { 
                    //         let a = parseInt(_.sumBy(o,'inValue'));
                    //         let b = parseInt(_.sumBy(o, "outValue"));
                    //         let c = a - b;
                    //         return { 
                    //             timestamp: parseInt(idx), 
                    //             occupancy: c
                    //          }})
                    //     return {
                    //         branchid: parseInt(BranchID),
                    //         historicalOccupancy: b
                    //     };
                    // });
                        
                    // });
                });  
            });

         
















		
			
			
			
			
			
			
            Utility.Log('running a task every 5 minute');

   
            
        });
	};

    if (isFirst){
		once();
        isFirst = false;
    }
};
