module.exports.attach = function (scServer, socket) {

    //Mongo connection
    // const MongoClient = require('mongodb').MongoClient;
    const assert = require('assert');
    const mongoUtil = require('.././resource/Connection');

    // Connection URL
    const url = require('.././resource/selectedconfig').url;//development or production
    const mongoTable = require('.././resource/config').mongoTable;

    // Debug
    const debug = 0;
    const Utility = require('.././helpers/Utility');

    let sessionList = [];

    //#region occupancy function
    //insert occupancy  document

    const insertSmartBinData = async function (db, binData) {
        // Get the documents collection
        const collection = await db.collection(mongoTable.dustbin);
        // Insert some documents

        collection.findOneAndUpdate(
            //match by sensorID, or counterserial? both seem OK but maybe sensorID can change
            {
                sensorID: binData.sensorID,
                counterSerial: binData.counterSerial,
                dataID: binData.dataID
            },
            {
                $set: {
                    counterSerial: binData.counterSerial,
                    sensorID: binData.sensorID,
                    dbm: binData.dbm,
                    localTimestamp: binData.localTimestamp,
                    tagDateTime: binData.tagDateTime,
                    timestamp: binData.timestamp,
                    tofData: binData.tofData,
                    tagVoltage: binData.tagVoltage
                }
            }, // replacement, replaces only the field "hi"
            { upsert: true }, // options
            function (err, object) {
								assert.equal(err, null);
            }
        );

    };

    socket.on('SmartBin', function (binData) {
        var db = mongoUtil.getDb();

        insertSmartBinData(db, binData, function () { });
    });
};
