const sql = require('mssql');
// mongo db
//const MongoClient = require('mongodb').MongoClient;
const assert = require('assert');
const mongoUtil = require('.././resource/Connection');
// mssql
const sqlconfig = require('.././resource/config')['mssql'];
const mongoTable = require('.././resource/config').mongoTable;
// Connection URL
var selectedConfig = require('.././resource/config')['production'];
// Debug
const debug = 0;
const Utility = require('.././helpers/Utility');

// url for mongo
const url = selectedConfig.url;
// ffc cloud server
const ffcurl = selectedConfig.ffcurl;
const isSecure = selectedConfig.isSecure;
var httpvalue = null;
if (isSecure) {
    // using https
    httpvalue = require('https');
}
else {
    // using http
    httpvalue = require('http');
}

module.exports.attach = function (scServer, socket) {
    socket.on('TelegramAPI', function (data) {
        connectMSSQL(data['serial'], function (err, mongoData) {
            if (!err) {
                if (mongoData === undefined || mongoData.length == 0) {
                    console.log(data);
                }
                else {
                    retrieveTempVariable(data, mongoData);
                }
            } else {
                Utility.Log(err, debug);
            }
            sql.close();
        });
        //retrieveTempVariable(data);
    });
};

function connectMSSQL(serial, callBack) {
    const pool = new sql.ConnectionPool(sqlconfig);
    const request = new sql.Request(pool);
    try {
        pool.connect(function () {
            // to query the mssql to get threshold
            request.query(
                "select NT.Threshold, NT.Id from ffcameras AS ffc " +
                "right outer join NotificationTriggersFFCameras as NTFFC " +
                "on NTFFC.FFCamera_ID = ffc.ID " +
                "right outer join NotificationTriggers as NT " +
                "on NT.id = NTFFC.NotificationTrigger_Id " +
                "where NT.type = 'Threshold' and ffc.serial = '" + serial + "';"
                , function (err, res) {
                    if (err) {
                        callBack(err);
                    }
                    else {
                        callBack(false, res.recordset);
                    }
                });
        });
    } catch (error) {
        console.log(error);
        callBack(error);
    }
}

function retrieveTempVariable(data, mongoData) {
    var db = mongoUtil.getDb();
    const collection = db.collection(mongoTable.telegramThreshold);
    // const connection = dbConnection.collection('TempTelegramVariableThreshold');
    mongoData.forEach(output => collection.findOne({ serial: data['serial'], triggerID: output['Id'] }, function (err, result) {
        if (result != null) {
            var newData = Number(result['data']) + Number(data['data']);
            if (newData < (result['threshold'])) {
                var myquery = { serial: data['serial'], triggerID: output['Id'] };
                var newvalues = { $set: { data: newData } };
                collection.updateOne(myquery, newvalues, function (err, res) {
                    if (err) {
                        throw err;
                    }
                    else {
                        //console.log(res)
                        Utility.Log("Data updated", debug);
                    }
                })
            }
            else {
                Utility.Log("Send API", debug);
                // current date
                var currentDate = new Date();
                // previous saved date
                var previousDate = new Date(result['datetime']);
                var delta = Math.abs(currentDate - previousDate) / 1000;
                var convertedString = secondsToDhms(delta);
                httpvalue.get(ffcurl + '/api/action/TriggerTelegramThreshold?serial=' + data['serial'] + '&scTriggerID=' + output['Id'] + '&stringDateTime=' + convertedString, (resp) => {
                    // A chunk of data has been recieved.
                    resp.on('data', (chunk) => {
                        Utility.Log("Success", debug);
                        var myquery = { serial: data['serial'], triggerID: output['Id'] };
                        Utility.Log(newData, debug);
                        Utility.Log(result['threshold'], debug);
                        var newvalues = { $set: { data: (newData - (result['threshold'])), datetime: new Date() } };
                        collection.updateOne(myquery, newvalues, function (err, res) {
                            if (err) {
                                throw err;
                            }
                            else {
                                //console.log(res)
                                Utility.Log("Data Reset", debug)
                            }
                        });

                    });
                    // The whole response has been received. Print out the result.
                    resp.on('end', () => {
                        //   console.log(JSON.parse(data).explanation);
                    });

                }).on("error", (err) => {
                    // console.log("Error: " + err.message);
                });
            }
        }
        else {
            var myobj = { serial: data['serial'], triggerID: output['Id'], data: data['data'], datetime: new Date(), threshold: output['Threshold'] };
            Utility.Log(myobj, debug);
            collection.insertOne(myobj, function (err, res) {
                if (err) throw err;
                Utility.Log("New document inserted", debug);
            });
        }
    }))
};

function secondsToDhms(seconds) {
    seconds = Number(seconds);
    var d = Math.floor(seconds / (3600 * 24));
    var h = Math.floor(seconds % (3600 * 24) / 3600);
    var m = Math.floor(seconds % 3600 / 60);
    var s = Math.floor(seconds % 60);

    var dDisplay = d > 0 ? d + (d == 1 ? " day, " : " days, ") : "";
    var hDisplay = h > 0 ? h + (h == 1 ? " hour, " : " hours, ") : "";
    var mDisplay = m > 0 ? m + (m == 1 ? " minute, " : " minutes, ") : "";
    var sDisplay = s > 0 ? s + (s == 1 ? " second" : " seconds") : "";
    return dDisplay + hDisplay + mDisplay + sDisplay;
}
