const sql = require('mssql');
// mongo db
// const MongoClient = require('mongodb').MongoClient;
const mongoUtil = require('.././resource/Connection');
const assert = require('assert');
// mssql
const sqlconfig = require('.././resource/config')['mssql'];
// Connection URL
const configURL = require('.././resource/selectedconfig');//development or production
// var productList = require('.././resource/config')[configURL];
// url for mongo
const url =configURL.url;
// ffc cloud server
const ffcurl = configURL.ffcurl;
const isSecure = configURL.isSecure;
var httpvalue = null;
if (isSecure)
{
    // using https
    httpvalue = require('https');
}
else
{
    // using http
    httpvalue = require('http');
}
// trigger
const dbName = 'footfallcounter';
var macData = [];
var isFirstTime = true;

module.exports.attach = function (scServer, socket) {
    socket.on('retrieveWRFsetting', function (serial) {
        // we retrieve the hard coded data first, should call MSSQL DB to retrieve data

        connectMSSQL(serial, function (err, data) {
            if(!err){
                if (data === undefined || data.length == 0) {
                    // array empty or does not exist
                    // do nothing
                }
                else
                {
                    console.log(data);
                    socket.emit('WRFsettings-' + serial, data);
                }
            }else{
                console.log(err);
            }
            sql.close();
        });
        data = '{"mac_address": ["e0:33:8e:4d:69:33", "fc:2a:9c:5c:bd:dc", "30:a1:fa:98:60:75", "6c:c7:ec:fd:52:91"], "probes": 3, "time_range": 15, "signal": -65}';
    });

    socket.on('triggerWF', function (data) {
        // trigger the send API
        let triggeredDate = new Date(data['datetime']).toString();
        let triggeredMac = data['mac'];
        let triggeredcountData = data['countdata'].toString();
        let triggeredID = data['triggerID'].toString();
        let url = ffcurl + '/api/action/TriggerWF?serial=' + data['serial'] + '&stringDateTime=' + triggeredDate + '&macAddress=' + triggeredMac + '&visitorCount=' + triggeredcountData + '&triggerId=' + triggeredID;
        httpvalue.get(url, (resp) => {
            // A chunk of data has been recieved.
            resp.on('data', (chunk) => {
                console.log('Threshold reset.');
            });
            // The whole response has been received. Print out the result.
            resp.on('end', () => {
            //   console.log(JSON.parse(data).explanation); a
            });

          }).on("error", (err) => {
            // console.log("Error: " + err.message);
          });
    });
};

function connectMSSQL(serial, callBack) {
    const pool = new sql.ConnectionPool(sqlconfig);
    const request = new sql.Request(pool);
    try {
        pool.connect(function () {
            // to query the mssql to get threshold
            request.query(
                "select NT.id, NS.Value from ffcameras AS ffc " +
                "right outer join NotificationTriggersFFCameras as NTFFC " +
                "on NTFFC.FFCamera_ID = ffc.ID " +
                "right outer join NotificationTriggers as NT " +
                "on NT.id = NTFFC.NotificationTrigger_Id " +
                "right outer join NotificationSettings as NS " +
                "on NS.id = NT.NotificationSettingsId " +
                "where ffc.serial = '" + serial +  "' and NT.IsActive = 1 and NT.type = 'Mac';"
            , function (err, res) {
                if(err){
                    console.log('retrieving sql data eror...' + serial);
                    callBack(err);
                }
                else{
                    callBack(false,res.recordset);
                }
            });
        });
    } catch (error) {
        console.log(error);
        callBack(error);
    }
}