# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._data_factory_management_client_enums import *


class AccessPolicyResponse(msrest.serialization.Model):
    """Get Data Plane read only token response definition.

    :param policy: The user access policy.
    :type policy: ~azure.mgmt.datafactory.models.UserAccessPolicy
    :param access_token: Data Plane read only access token.
    :type access_token: str
    :param data_plane_url: Data Plane service base URL.
    :type data_plane_url: str
    """

    _attribute_map = {
        'policy': {'key': 'policy', 'type': 'UserAccessPolicy'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'data_plane_url': {'key': 'dataPlaneUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy: Optional["UserAccessPolicy"] = None,
        access_token: Optional[str] = None,
        data_plane_url: Optional[str] = None,
        **kwargs
    ):
        super(AccessPolicyResponse, self).__init__(**kwargs)
        self.policy = policy
        self.access_token = access_token
        self.data_plane_url = data_plane_url


class Activity(msrest.serialization.Model):
    """A pipeline activity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AppendVariableActivity, ControlActivity, ExecutePipelineActivity, ExecutionActivity, FilterActivity, ForEachActivity, IfConditionActivity, SetVariableActivity, SwitchActivity, UntilActivity, ValidationActivity, WaitActivity, WebHookActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    _subtype_map = {
        'type': {'AppendVariable': 'AppendVariableActivity', 'Container': 'ControlActivity', 'ExecutePipeline': 'ExecutePipelineActivity', 'Execution': 'ExecutionActivity', 'Filter': 'FilterActivity', 'ForEach': 'ForEachActivity', 'IfCondition': 'IfConditionActivity', 'SetVariable': 'SetVariableActivity', 'Switch': 'SwitchActivity', 'Until': 'UntilActivity', 'Validation': 'ValidationActivity', 'Wait': 'WaitActivity', 'WebHook': 'WebHookActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(Activity, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type = 'Activity'  # type: str
        self.description = description
        self.depends_on = depends_on
        self.user_properties = user_properties


class ActivityDependency(msrest.serialization.Model):
    """Activity dependency information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param activity: Required. Activity name.
    :type activity: str
    :param dependency_conditions: Required. Match-Condition for the dependency.
    :type dependency_conditions: list[str or ~azure.mgmt.datafactory.models.DependencyCondition]
    """

    _validation = {
        'activity': {'required': True},
        'dependency_conditions': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'activity': {'key': 'activity', 'type': 'str'},
        'dependency_conditions': {'key': 'dependencyConditions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        activity: str,
        dependency_conditions: List[Union[str, "DependencyCondition"]],
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ActivityDependency, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.activity = activity
        self.dependency_conditions = dependency_conditions


class ActivityPolicy(msrest.serialization.Model):
    """Execution policy for an activity.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
     Type: string (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: object
    :param retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with
     resultType integer), minimum: 0.
    :type retry: object
    :param retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default
     is 30 sec.
    :type retry_interval_in_seconds: int
    :param secure_input: When set to true, Input from activity is considered as secure and will not
     be logged to monitoring.
    :type secure_input: bool
    :param secure_output: When set to true, Output from activity is considered as secure and will
     not be logged to monitoring.
    :type secure_output: bool
    """

    _validation = {
        'retry_interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'timeout': {'key': 'timeout', 'type': 'object'},
        'retry': {'key': 'retry', 'type': 'object'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'int'},
        'secure_input': {'key': 'secureInput', 'type': 'bool'},
        'secure_output': {'key': 'secureOutput', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        timeout: Optional[object] = None,
        retry: Optional[object] = None,
        retry_interval_in_seconds: Optional[int] = None,
        secure_input: Optional[bool] = None,
        secure_output: Optional[bool] = None,
        **kwargs
    ):
        super(ActivityPolicy, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.timeout = timeout
        self.retry = retry
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.secure_input = secure_input
        self.secure_output = secure_output


class ActivityRun(msrest.serialization.Model):
    """Information about an activity run in a pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar pipeline_name: The name of the pipeline.
    :vartype pipeline_name: str
    :ivar pipeline_run_id: The id of the pipeline run.
    :vartype pipeline_run_id: str
    :ivar activity_name: The name of the activity.
    :vartype activity_name: str
    :ivar activity_type: The type of the activity.
    :vartype activity_type: str
    :ivar activity_run_id: The id of the activity run.
    :vartype activity_run_id: str
    :ivar linked_service_name: The name of the compute linked service.
    :vartype linked_service_name: str
    :ivar status: The status of the activity run.
    :vartype status: str
    :ivar activity_run_start: The start time of the activity run in 'ISO 8601' format.
    :vartype activity_run_start: ~datetime.datetime
    :ivar activity_run_end: The end time of the activity run in 'ISO 8601' format.
    :vartype activity_run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of the activity run.
    :vartype duration_in_ms: int
    :ivar input: The input for the activity.
    :vartype input: object
    :ivar output: The output for the activity.
    :vartype output: object
    :ivar error: The error if any from the activity run.
    :vartype error: object
    """

    _validation = {
        'pipeline_name': {'readonly': True},
        'pipeline_run_id': {'readonly': True},
        'activity_name': {'readonly': True},
        'activity_type': {'readonly': True},
        'activity_run_id': {'readonly': True},
        'linked_service_name': {'readonly': True},
        'status': {'readonly': True},
        'activity_run_start': {'readonly': True},
        'activity_run_end': {'readonly': True},
        'duration_in_ms': {'readonly': True},
        'input': {'readonly': True},
        'output': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'pipeline_name': {'key': 'pipelineName', 'type': 'str'},
        'pipeline_run_id': {'key': 'pipelineRunId', 'type': 'str'},
        'activity_name': {'key': 'activityName', 'type': 'str'},
        'activity_type': {'key': 'activityType', 'type': 'str'},
        'activity_run_id': {'key': 'activityRunId', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'activity_run_start': {'key': 'activityRunStart', 'type': 'iso-8601'},
        'activity_run_end': {'key': 'activityRunEnd', 'type': 'iso-8601'},
        'duration_in_ms': {'key': 'durationInMs', 'type': 'int'},
        'input': {'key': 'input', 'type': 'object'},
        'output': {'key': 'output', 'type': 'object'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ActivityRun, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.pipeline_name = None
        self.pipeline_run_id = None
        self.activity_name = None
        self.activity_type = None
        self.activity_run_id = None
        self.linked_service_name = None
        self.status = None
        self.activity_run_start = None
        self.activity_run_end = None
        self.duration_in_ms = None
        self.input = None
        self.output = None
        self.error = None


class ActivityRunsQueryResponse(msrest.serialization.Model):
    """A list activity runs.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of activity runs.
    :type value: list[~azure.mgmt.datafactory.models.ActivityRun]
    :param continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :type continuation_token: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActivityRun]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ActivityRun"],
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(ActivityRunsQueryResponse, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class AddDataFlowToDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for starting data flow debug session.

    :param job_version: The ID of data flow debug job version.
    :type job_version: str
    """

    _attribute_map = {
        'job_version': {'key': 'jobVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_version: Optional[str] = None,
        **kwargs
    ):
        super(AddDataFlowToDebugSessionResponse, self).__init__(**kwargs)
        self.job_version = job_version


class AdditionalColumns(msrest.serialization.Model):
    """Specify the column name and value of additional columns.

    :param name: Additional column name. Type: string (or Expression with resultType string).
    :type name: object
    :param value: Additional column value. Type: string (or Expression with resultType string).
    :type value: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'object'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[object] = None,
        value: Optional[object] = None,
        **kwargs
    ):
        super(AdditionalColumns, self).__init__(**kwargs)
        self.name = name
        self.value = value


class LinkedService(msrest.serialization.Model):
    """The Azure Data Factory nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSLinkedService, AmazonRedshiftLinkedService, AmazonS3LinkedService, AmazonS3CompatibleLinkedService, AzureBatchLinkedService, AzureBlobFSLinkedService, AzureBlobStorageLinkedService, AzureDataExplorerLinkedService, AzureDataLakeAnalyticsLinkedService, AzureDataLakeStoreLinkedService, AzureDatabricksLinkedService, AzureDatabricksDeltaLakeLinkedService, AzureFileStorageLinkedService, AzureFunctionLinkedService, AzureKeyVaultLinkedService, AzureMLLinkedService, AzureMLServiceLinkedService, AzureMariaDBLinkedService, AzureMySqlLinkedService, AzurePostgreSqlLinkedService, AzureSearchLinkedService, AzureSqlDWLinkedService, AzureSqlDatabaseLinkedService, AzureSqlMILinkedService, AzureStorageLinkedService, AzureTableStorageLinkedService, CassandraLinkedService, CommonDataServiceForAppsLinkedService, ConcurLinkedService, CosmosDbLinkedService, CosmosDbMongoDbApiLinkedService, CouchbaseLinkedService, CustomDataSourceLinkedService, Db2LinkedService, DrillLinkedService, DynamicsLinkedService, DynamicsAXLinkedService, DynamicsCrmLinkedService, EloquaLinkedService, FileServerLinkedService, FtpServerLinkedService, GoogleAdWordsLinkedService, GoogleBigQueryLinkedService, GoogleCloudStorageLinkedService, GreenplumLinkedService, HBaseLinkedService, HDInsightLinkedService, HDInsightOnDemandLinkedService, HdfsLinkedService, HiveLinkedService, HttpLinkedService, HubspotLinkedService, ImpalaLinkedService, InformixLinkedService, JiraLinkedService, MagentoLinkedService, MariaDBLinkedService, MarketoLinkedService, MicrosoftAccessLinkedService, MongoDbLinkedService, MongoDbAtlasLinkedService, MongoDbV2LinkedService, MySqlLinkedService, NetezzaLinkedService, ODataLinkedService, OdbcLinkedService, Office365LinkedService, OracleLinkedService, OracleCloudStorageLinkedService, OracleServiceCloudLinkedService, PaypalLinkedService, PhoenixLinkedService, PostgreSqlLinkedService, PrestoLinkedService, QuickBooksLinkedService, ResponsysLinkedService, RestServiceLinkedService, SalesforceLinkedService, SalesforceMarketingCloudLinkedService, SalesforceServiceCloudLinkedService, SapBWLinkedService, SapCloudForCustomerLinkedService, SapEccLinkedService, SapHanaLinkedService, SapOpenHubLinkedService, SapTableLinkedService, ServiceNowLinkedService, SftpServerLinkedService, SharePointOnlineListLinkedService, ShopifyLinkedService, SnowflakeLinkedService, SparkLinkedService, SqlServerLinkedService, SquareLinkedService, SybaseLinkedService, TeradataLinkedService, VerticaLinkedService, WebLinkedService, XeroLinkedService, ZohoLinkedService.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'AmazonMWS': 'AmazonMWSLinkedService', 'AmazonRedshift': 'AmazonRedshiftLinkedService', 'AmazonS3': 'AmazonS3LinkedService', 'AmazonS3Compatible': 'AmazonS3CompatibleLinkedService', 'AzureBatch': 'AzureBatchLinkedService', 'AzureBlobFS': 'AzureBlobFSLinkedService', 'AzureBlobStorage': 'AzureBlobStorageLinkedService', 'AzureDataExplorer': 'AzureDataExplorerLinkedService', 'AzureDataLakeAnalytics': 'AzureDataLakeAnalyticsLinkedService', 'AzureDataLakeStore': 'AzureDataLakeStoreLinkedService', 'AzureDatabricks': 'AzureDatabricksLinkedService', 'AzureDatabricksDeltaLake': 'AzureDatabricksDeltaLakeLinkedService', 'AzureFileStorage': 'AzureFileStorageLinkedService', 'AzureFunction': 'AzureFunctionLinkedService', 'AzureKeyVault': 'AzureKeyVaultLinkedService', 'AzureML': 'AzureMLLinkedService', 'AzureMLService': 'AzureMLServiceLinkedService', 'AzureMariaDB': 'AzureMariaDBLinkedService', 'AzureMySql': 'AzureMySqlLinkedService', 'AzurePostgreSql': 'AzurePostgreSqlLinkedService', 'AzureSearch': 'AzureSearchLinkedService', 'AzureSqlDW': 'AzureSqlDWLinkedService', 'AzureSqlDatabase': 'AzureSqlDatabaseLinkedService', 'AzureSqlMI': 'AzureSqlMILinkedService', 'AzureStorage': 'AzureStorageLinkedService', 'AzureTableStorage': 'AzureTableStorageLinkedService', 'Cassandra': 'CassandraLinkedService', 'CommonDataServiceForApps': 'CommonDataServiceForAppsLinkedService', 'Concur': 'ConcurLinkedService', 'CosmosDb': 'CosmosDbLinkedService', 'CosmosDbMongoDbApi': 'CosmosDbMongoDbApiLinkedService', 'Couchbase': 'CouchbaseLinkedService', 'CustomDataSource': 'CustomDataSourceLinkedService', 'Db2': 'Db2LinkedService', 'Drill': 'DrillLinkedService', 'Dynamics': 'DynamicsLinkedService', 'DynamicsAX': 'DynamicsAXLinkedService', 'DynamicsCrm': 'DynamicsCrmLinkedService', 'Eloqua': 'EloquaLinkedService', 'FileServer': 'FileServerLinkedService', 'FtpServer': 'FtpServerLinkedService', 'GoogleAdWords': 'GoogleAdWordsLinkedService', 'GoogleBigQuery': 'GoogleBigQueryLinkedService', 'GoogleCloudStorage': 'GoogleCloudStorageLinkedService', 'Greenplum': 'GreenplumLinkedService', 'HBase': 'HBaseLinkedService', 'HDInsight': 'HDInsightLinkedService', 'HDInsightOnDemand': 'HDInsightOnDemandLinkedService', 'Hdfs': 'HdfsLinkedService', 'Hive': 'HiveLinkedService', 'HttpServer': 'HttpLinkedService', 'Hubspot': 'HubspotLinkedService', 'Impala': 'ImpalaLinkedService', 'Informix': 'InformixLinkedService', 'Jira': 'JiraLinkedService', 'Magento': 'MagentoLinkedService', 'MariaDB': 'MariaDBLinkedService', 'Marketo': 'MarketoLinkedService', 'MicrosoftAccess': 'MicrosoftAccessLinkedService', 'MongoDb': 'MongoDbLinkedService', 'MongoDbAtlas': 'MongoDbAtlasLinkedService', 'MongoDbV2': 'MongoDbV2LinkedService', 'MySql': 'MySqlLinkedService', 'Netezza': 'NetezzaLinkedService', 'OData': 'ODataLinkedService', 'Odbc': 'OdbcLinkedService', 'Office365': 'Office365LinkedService', 'Oracle': 'OracleLinkedService', 'OracleCloudStorage': 'OracleCloudStorageLinkedService', 'OracleServiceCloud': 'OracleServiceCloudLinkedService', 'Paypal': 'PaypalLinkedService', 'Phoenix': 'PhoenixLinkedService', 'PostgreSql': 'PostgreSqlLinkedService', 'Presto': 'PrestoLinkedService', 'QuickBooks': 'QuickBooksLinkedService', 'Responsys': 'ResponsysLinkedService', 'RestService': 'RestServiceLinkedService', 'Salesforce': 'SalesforceLinkedService', 'SalesforceMarketingCloud': 'SalesforceMarketingCloudLinkedService', 'SalesforceServiceCloud': 'SalesforceServiceCloudLinkedService', 'SapBW': 'SapBWLinkedService', 'SapCloudForCustomer': 'SapCloudForCustomerLinkedService', 'SapEcc': 'SapEccLinkedService', 'SapHana': 'SapHanaLinkedService', 'SapOpenHub': 'SapOpenHubLinkedService', 'SapTable': 'SapTableLinkedService', 'ServiceNow': 'ServiceNowLinkedService', 'Sftp': 'SftpServerLinkedService', 'SharePointOnlineList': 'SharePointOnlineListLinkedService', 'Shopify': 'ShopifyLinkedService', 'Snowflake': 'SnowflakeLinkedService', 'Spark': 'SparkLinkedService', 'SqlServer': 'SqlServerLinkedService', 'Square': 'SquareLinkedService', 'Sybase': 'SybaseLinkedService', 'Teradata': 'TeradataLinkedService', 'Vertica': 'VerticaLinkedService', 'Web': 'WebLinkedService', 'Xero': 'XeroLinkedService', 'Zoho': 'ZohoLinkedService'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(LinkedService, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'LinkedService'  # type: str
        self.connect_via = connect_via
        self.description = description
        self.parameters = parameters
        self.annotations = annotations


class AmazonMWSLinkedService(LinkedService):
    """Amazon Marketplace Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Amazon MWS server, (i.e.
     mws.amazonservices.com).
    :type endpoint: object
    :param marketplace_id: Required. The Amazon Marketplace ID you want to retrieve data from. To
     retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e.
     A2EUQ1WTGCTBG2).
    :type marketplace_id: object
    :param seller_id: Required. The Amazon seller ID.
    :type seller_id: object
    :param mws_auth_token: The Amazon MWS authentication token.
    :type mws_auth_token: ~azure.mgmt.datafactory.models.SecretBase
    :param access_key_id: Required. The access key id used to access data.
    :type access_key_id: object
    :param secret_key: The secret key used to access data.
    :type secret_key: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'marketplace_id': {'required': True},
        'seller_id': {'required': True},
        'access_key_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'marketplace_id': {'key': 'typeProperties.marketplaceID', 'type': 'object'},
        'seller_id': {'key': 'typeProperties.sellerID', 'type': 'object'},
        'mws_auth_token': {'key': 'typeProperties.mwsAuthToken', 'type': 'SecretBase'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_key': {'key': 'typeProperties.secretKey', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        marketplace_id: object,
        seller_id: object,
        access_key_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        mws_auth_token: Optional["SecretBase"] = None,
        secret_key: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonMWSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonMWS'  # type: str
        self.endpoint = endpoint
        self.marketplace_id = marketplace_id
        self.seller_id = seller_id
        self.mws_auth_token = mws_auth_token
        self.access_key_id = access_key_id
        self.secret_key = secret_key
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class Dataset(msrest.serialization.Model):
    """The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSObjectDataset, AmazonRedshiftTableDataset, AmazonS3Dataset, AvroDataset, AzureBlobDataset, AzureBlobFSDataset, AzureDataExplorerTableDataset, AzureDataLakeStoreDataset, AzureDatabricksDeltaLakeDataset, AzureMariaDBTableDataset, AzureMySqlTableDataset, AzurePostgreSqlTableDataset, AzureSearchIndexDataset, AzureSqlDWTableDataset, AzureSqlMITableDataset, AzureSqlTableDataset, AzureTableDataset, BinaryDataset, CassandraTableDataset, CommonDataServiceForAppsEntityDataset, ConcurObjectDataset, CosmosDbMongoDbApiCollectionDataset, CosmosDbSqlApiCollectionDataset, CouchbaseTableDataset, CustomDataset, Db2TableDataset, DelimitedTextDataset, DocumentDbCollectionDataset, DrillTableDataset, DynamicsAXResourceDataset, DynamicsCrmEntityDataset, DynamicsEntityDataset, EloquaObjectDataset, ExcelDataset, FileShareDataset, GoogleAdWordsObjectDataset, GoogleBigQueryObjectDataset, GreenplumTableDataset, HBaseObjectDataset, HiveObjectDataset, HttpDataset, HubspotObjectDataset, ImpalaObjectDataset, InformixTableDataset, JiraObjectDataset, JsonDataset, MagentoObjectDataset, MariaDBTableDataset, MarketoObjectDataset, MicrosoftAccessTableDataset, MongoDbAtlasCollectionDataset, MongoDbCollectionDataset, MongoDbV2CollectionDataset, MySqlTableDataset, NetezzaTableDataset, ODataResourceDataset, OdbcTableDataset, Office365Dataset, OracleServiceCloudObjectDataset, OracleTableDataset, OrcDataset, ParquetDataset, PaypalObjectDataset, PhoenixObjectDataset, PostgreSqlTableDataset, PrestoObjectDataset, QuickBooksObjectDataset, RelationalTableDataset, ResponsysObjectDataset, RestResourceDataset, SalesforceMarketingCloudObjectDataset, SalesforceObjectDataset, SalesforceServiceCloudObjectDataset, SapBwCubeDataset, SapCloudForCustomerResourceDataset, SapEccResourceDataset, SapHanaTableDataset, SapOpenHubTableDataset, SapTableResourceDataset, ServiceNowObjectDataset, SharePointOnlineListResourceDataset, ShopifyObjectDataset, SnowflakeDataset, SparkObjectDataset, SqlServerTableDataset, SquareObjectDataset, SybaseTableDataset, TeradataTableDataset, VerticaTableDataset, WebTableDataset, XeroObjectDataset, XmlDataset, ZohoObjectDataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
    }

    _subtype_map = {
        'type': {'AmazonMWSObject': 'AmazonMWSObjectDataset', 'AmazonRedshiftTable': 'AmazonRedshiftTableDataset', 'AmazonS3Object': 'AmazonS3Dataset', 'Avro': 'AvroDataset', 'AzureBlob': 'AzureBlobDataset', 'AzureBlobFSFile': 'AzureBlobFSDataset', 'AzureDataExplorerTable': 'AzureDataExplorerTableDataset', 'AzureDataLakeStoreFile': 'AzureDataLakeStoreDataset', 'AzureDatabricksDeltaLakeDataset': 'AzureDatabricksDeltaLakeDataset', 'AzureMariaDBTable': 'AzureMariaDBTableDataset', 'AzureMySqlTable': 'AzureMySqlTableDataset', 'AzurePostgreSqlTable': 'AzurePostgreSqlTableDataset', 'AzureSearchIndex': 'AzureSearchIndexDataset', 'AzureSqlDWTable': 'AzureSqlDWTableDataset', 'AzureSqlMITable': 'AzureSqlMITableDataset', 'AzureSqlTable': 'AzureSqlTableDataset', 'AzureTable': 'AzureTableDataset', 'Binary': 'BinaryDataset', 'CassandraTable': 'CassandraTableDataset', 'CommonDataServiceForAppsEntity': 'CommonDataServiceForAppsEntityDataset', 'ConcurObject': 'ConcurObjectDataset', 'CosmosDbMongoDbApiCollection': 'CosmosDbMongoDbApiCollectionDataset', 'CosmosDbSqlApiCollection': 'CosmosDbSqlApiCollectionDataset', 'CouchbaseTable': 'CouchbaseTableDataset', 'CustomDataset': 'CustomDataset', 'Db2Table': 'Db2TableDataset', 'DelimitedText': 'DelimitedTextDataset', 'DocumentDbCollection': 'DocumentDbCollectionDataset', 'DrillTable': 'DrillTableDataset', 'DynamicsAXResource': 'DynamicsAXResourceDataset', 'DynamicsCrmEntity': 'DynamicsCrmEntityDataset', 'DynamicsEntity': 'DynamicsEntityDataset', 'EloquaObject': 'EloquaObjectDataset', 'Excel': 'ExcelDataset', 'FileShare': 'FileShareDataset', 'GoogleAdWordsObject': 'GoogleAdWordsObjectDataset', 'GoogleBigQueryObject': 'GoogleBigQueryObjectDataset', 'GreenplumTable': 'GreenplumTableDataset', 'HBaseObject': 'HBaseObjectDataset', 'HiveObject': 'HiveObjectDataset', 'HttpFile': 'HttpDataset', 'HubspotObject': 'HubspotObjectDataset', 'ImpalaObject': 'ImpalaObjectDataset', 'InformixTable': 'InformixTableDataset', 'JiraObject': 'JiraObjectDataset', 'Json': 'JsonDataset', 'MagentoObject': 'MagentoObjectDataset', 'MariaDBTable': 'MariaDBTableDataset', 'MarketoObject': 'MarketoObjectDataset', 'MicrosoftAccessTable': 'MicrosoftAccessTableDataset', 'MongoDbAtlasCollection': 'MongoDbAtlasCollectionDataset', 'MongoDbCollection': 'MongoDbCollectionDataset', 'MongoDbV2Collection': 'MongoDbV2CollectionDataset', 'MySqlTable': 'MySqlTableDataset', 'NetezzaTable': 'NetezzaTableDataset', 'ODataResource': 'ODataResourceDataset', 'OdbcTable': 'OdbcTableDataset', 'Office365Table': 'Office365Dataset', 'OracleServiceCloudObject': 'OracleServiceCloudObjectDataset', 'OracleTable': 'OracleTableDataset', 'Orc': 'OrcDataset', 'Parquet': 'ParquetDataset', 'PaypalObject': 'PaypalObjectDataset', 'PhoenixObject': 'PhoenixObjectDataset', 'PostgreSqlTable': 'PostgreSqlTableDataset', 'PrestoObject': 'PrestoObjectDataset', 'QuickBooksObject': 'QuickBooksObjectDataset', 'RelationalTable': 'RelationalTableDataset', 'ResponsysObject': 'ResponsysObjectDataset', 'RestResource': 'RestResourceDataset', 'SalesforceMarketingCloudObject': 'SalesforceMarketingCloudObjectDataset', 'SalesforceObject': 'SalesforceObjectDataset', 'SalesforceServiceCloudObject': 'SalesforceServiceCloudObjectDataset', 'SapBwCube': 'SapBwCubeDataset', 'SapCloudForCustomerResource': 'SapCloudForCustomerResourceDataset', 'SapEccResource': 'SapEccResourceDataset', 'SapHanaTable': 'SapHanaTableDataset', 'SapOpenHubTable': 'SapOpenHubTableDataset', 'SapTableResource': 'SapTableResourceDataset', 'ServiceNowObject': 'ServiceNowObjectDataset', 'SharePointOnlineListResource': 'SharePointOnlineListResourceDataset', 'ShopifyObject': 'ShopifyObjectDataset', 'SnowflakeTable': 'SnowflakeDataset', 'SparkObject': 'SparkObjectDataset', 'SqlServerTable': 'SqlServerTableDataset', 'SquareObject': 'SquareObjectDataset', 'SybaseTable': 'SybaseTableDataset', 'TeradataTable': 'TeradataTableDataset', 'VerticaTable': 'VerticaTableDataset', 'WebTable': 'WebTableDataset', 'XeroObject': 'XeroObjectDataset', 'Xml': 'XmlDataset', 'ZohoObject': 'ZohoObjectDataset'}
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(Dataset, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'Dataset'  # type: str
        self.description = description
        self.structure = structure
        self.schema = schema
        self.linked_service_name = linked_service_name
        self.parameters = parameters
        self.annotations = annotations
        self.folder = folder


class AmazonMWSObjectDataset(Dataset):
    """Amazon Marketplace Web Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(AmazonMWSObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonMWSObject'  # type: str
        self.table_name = table_name


class CopySource(msrest.serialization.Model):
    """A copy activity source.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSource, AzureBlobFSSource, AzureDataExplorerSource, AzureDataLakeStoreSource, AzureDatabricksDeltaLakeSource, BinarySource, BlobSource, CommonDataServiceForAppsSource, CosmosDbMongoDbApiSource, CosmosDbSqlApiSource, DelimitedTextSource, DocumentDbCollectionSource, DynamicsCrmSource, DynamicsSource, ExcelSource, FileSystemSource, HdfsSource, HttpSource, JsonSource, MicrosoftAccessSource, MongoDbAtlasSource, MongoDbSource, MongoDbV2Source, ODataSource, Office365Source, OracleSource, OrcSource, ParquetSource, RelationalSource, RestSource, SalesforceServiceCloudSource, SharePointOnlineListSource, SnowflakeSource, TabularSource, WebSource, XmlSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroSource': 'AvroSource', 'AzureBlobFSSource': 'AzureBlobFSSource', 'AzureDataExplorerSource': 'AzureDataExplorerSource', 'AzureDataLakeStoreSource': 'AzureDataLakeStoreSource', 'AzureDatabricksDeltaLakeSource': 'AzureDatabricksDeltaLakeSource', 'BinarySource': 'BinarySource', 'BlobSource': 'BlobSource', 'CommonDataServiceForAppsSource': 'CommonDataServiceForAppsSource', 'CosmosDbMongoDbApiSource': 'CosmosDbMongoDbApiSource', 'CosmosDbSqlApiSource': 'CosmosDbSqlApiSource', 'DelimitedTextSource': 'DelimitedTextSource', 'DocumentDbCollectionSource': 'DocumentDbCollectionSource', 'DynamicsCrmSource': 'DynamicsCrmSource', 'DynamicsSource': 'DynamicsSource', 'ExcelSource': 'ExcelSource', 'FileSystemSource': 'FileSystemSource', 'HdfsSource': 'HdfsSource', 'HttpSource': 'HttpSource', 'JsonSource': 'JsonSource', 'MicrosoftAccessSource': 'MicrosoftAccessSource', 'MongoDbAtlasSource': 'MongoDbAtlasSource', 'MongoDbSource': 'MongoDbSource', 'MongoDbV2Source': 'MongoDbV2Source', 'ODataSource': 'ODataSource', 'Office365Source': 'Office365Source', 'OracleSource': 'OracleSource', 'OrcSource': 'OrcSource', 'ParquetSource': 'ParquetSource', 'RelationalSource': 'RelationalSource', 'RestSource': 'RestSource', 'SalesforceServiceCloudSource': 'SalesforceServiceCloudSource', 'SharePointOnlineListSource': 'SharePointOnlineListSource', 'SnowflakeSource': 'SnowflakeSource', 'TabularSource': 'TabularSource', 'WebSource': 'WebSource', 'XmlSource': 'XmlSource'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(CopySource, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopySource'  # type: str
        self.source_retry_count = source_retry_count
        self.source_retry_wait = source_retry_wait
        self.max_concurrent_connections = max_concurrent_connections


class TabularSource(CopySource):
    """Copy activity sources of tabular type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSSource, AmazonRedshiftSource, AzureMariaDBSource, AzureMySqlSource, AzurePostgreSqlSource, AzureSqlSource, AzureTableSource, CassandraSource, ConcurSource, CouchbaseSource, Db2Source, DrillSource, DynamicsAXSource, EloquaSource, GoogleAdWordsSource, GoogleBigQuerySource, GreenplumSource, HBaseSource, HiveSource, HubspotSource, ImpalaSource, InformixSource, JiraSource, MagentoSource, MariaDBSource, MarketoSource, MySqlSource, NetezzaSource, OdbcSource, OracleServiceCloudSource, PaypalSource, PhoenixSource, PostgreSqlSource, PrestoSource, QuickBooksSource, ResponsysSource, SalesforceMarketingCloudSource, SalesforceSource, SapBwSource, SapCloudForCustomerSource, SapEccSource, SapHanaSource, SapOpenHubSource, SapTableSource, ServiceNowSource, ShopifySource, SparkSource, SqlDWSource, SqlMISource, SqlServerSource, SqlSource, SquareSource, SybaseSource, TeradataSource, VerticaSource, XeroSource, ZohoSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    _subtype_map = {
        'type': {'AmazonMWSSource': 'AmazonMWSSource', 'AmazonRedshiftSource': 'AmazonRedshiftSource', 'AzureMariaDBSource': 'AzureMariaDBSource', 'AzureMySqlSource': 'AzureMySqlSource', 'AzurePostgreSqlSource': 'AzurePostgreSqlSource', 'AzureSqlSource': 'AzureSqlSource', 'AzureTableSource': 'AzureTableSource', 'CassandraSource': 'CassandraSource', 'ConcurSource': 'ConcurSource', 'CouchbaseSource': 'CouchbaseSource', 'Db2Source': 'Db2Source', 'DrillSource': 'DrillSource', 'DynamicsAXSource': 'DynamicsAXSource', 'EloquaSource': 'EloquaSource', 'GoogleAdWordsSource': 'GoogleAdWordsSource', 'GoogleBigQuerySource': 'GoogleBigQuerySource', 'GreenplumSource': 'GreenplumSource', 'HBaseSource': 'HBaseSource', 'HiveSource': 'HiveSource', 'HubspotSource': 'HubspotSource', 'ImpalaSource': 'ImpalaSource', 'InformixSource': 'InformixSource', 'JiraSource': 'JiraSource', 'MagentoSource': 'MagentoSource', 'MariaDBSource': 'MariaDBSource', 'MarketoSource': 'MarketoSource', 'MySqlSource': 'MySqlSource', 'NetezzaSource': 'NetezzaSource', 'OdbcSource': 'OdbcSource', 'OracleServiceCloudSource': 'OracleServiceCloudSource', 'PaypalSource': 'PaypalSource', 'PhoenixSource': 'PhoenixSource', 'PostgreSqlSource': 'PostgreSqlSource', 'PrestoSource': 'PrestoSource', 'QuickBooksSource': 'QuickBooksSource', 'ResponsysSource': 'ResponsysSource', 'SalesforceMarketingCloudSource': 'SalesforceMarketingCloudSource', 'SalesforceSource': 'SalesforceSource', 'SapBwSource': 'SapBwSource', 'SapCloudForCustomerSource': 'SapCloudForCustomerSource', 'SapEccSource': 'SapEccSource', 'SapHanaSource': 'SapHanaSource', 'SapOpenHubSource': 'SapOpenHubSource', 'SapTableSource': 'SapTableSource', 'ServiceNowSource': 'ServiceNowSource', 'ShopifySource': 'ShopifySource', 'SparkSource': 'SparkSource', 'SqlDWSource': 'SqlDWSource', 'SqlMISource': 'SqlMISource', 'SqlServerSource': 'SqlServerSource', 'SqlSource': 'SqlSource', 'SquareSource': 'SquareSource', 'SybaseSource': 'SybaseSource', 'TeradataSource': 'TeradataSource', 'VerticaSource': 'VerticaSource', 'XeroSource': 'XeroSource', 'ZohoSource': 'ZohoSource'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(TabularSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'TabularSource'  # type: str
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AmazonMWSSource(TabularSource):
    """A copy activity Amazon Marketplace Web Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(AmazonMWSSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AmazonMWSSource'  # type: str
        self.query = query


class AmazonRedshiftLinkedService(LinkedService):
    """Linked service for Amazon Redshift.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. The name of the Amazon Redshift server. Type: string (or Expression
     with resultType string).
    :type server: object
    :param username: The username of the Amazon Redshift source. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: The password of the Amazon Redshift source.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param database: Required. The database name of the Amazon Redshift source. Type: string (or
     Expression with resultType string).
    :type database: object
    :param port: The TCP port number that the Amazon Redshift server uses to listen for client
     connections. The default value is 5439. Type: integer (or Expression with resultType integer).
    :type port: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        port: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonRedshiftLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonRedshift'  # type: str
        self.server = server
        self.username = username
        self.password = password
        self.database = database
        self.port = port
        self.encrypted_credential = encrypted_credential


class AmazonRedshiftSource(TabularSource):
    """A copy activity source for Amazon Redshift Source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    :param redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when
     copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be
     unloaded into S3 first and then copied into the targeted sink from the interim S3.
    :type redshift_unload_settings: ~azure.mgmt.datafactory.models.RedshiftUnloadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
        'redshift_unload_settings': {'key': 'redshiftUnloadSettings', 'type': 'RedshiftUnloadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        redshift_unload_settings: Optional["RedshiftUnloadSettings"] = None,
        **kwargs
    ):
        super(AmazonRedshiftSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AmazonRedshiftSource'  # type: str
        self.query = query
        self.redshift_unload_settings = redshift_unload_settings


class AmazonRedshiftTableDataset(Dataset):
    """The Amazon Redshift table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The Amazon Redshift table name. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(AmazonRedshiftTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonRedshiftTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AmazonS3CompatibleLinkedService(LinkedService):
    """Linked service for Amazon S3 Compatible.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Amazon S3 Compatible Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Amazon S3 Compatible Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Amazon S3 Compatible
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: object
    :param force_path_style: If true, use S3 path-style access instead of virtual hosted-style
     access. Default value is false. Type: boolean (or Expression with resultType boolean).
    :type force_path_style: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'force_path_style': {'key': 'typeProperties.forcePathStyle', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key_id: Optional[object] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[object] = None,
        force_path_style: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonS3Compatible'  # type: str
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.force_path_style = force_path_style
        self.encrypted_credential = encrypted_credential


class DatasetLocation(msrest.serialization.Model):
    """Dataset location.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3CompatibleLocation, AmazonS3Location, AzureBlobFSLocation, AzureBlobStorageLocation, AzureDataLakeStoreLocation, AzureFileStorageLocation, FileServerLocation, FtpServerLocation, GoogleCloudStorageLocation, HdfsLocation, HttpServerLocation, OracleCloudStorageLocation, SftpLocation.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3CompatibleLocation': 'AmazonS3CompatibleLocation', 'AmazonS3Location': 'AmazonS3Location', 'AzureBlobFSLocation': 'AzureBlobFSLocation', 'AzureBlobStorageLocation': 'AzureBlobStorageLocation', 'AzureDataLakeStoreLocation': 'AzureDataLakeStoreLocation', 'AzureFileStorageLocation': 'AzureFileStorageLocation', 'FileServerLocation': 'FileServerLocation', 'FtpServerLocation': 'FtpServerLocation', 'GoogleCloudStorageLocation': 'GoogleCloudStorageLocation', 'HdfsLocation': 'HdfsLocation', 'HttpServerLocation': 'HttpServerLocation', 'OracleCloudStorageLocation': 'OracleCloudStorageLocation', 'SftpLocation': 'SftpLocation'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(DatasetLocation, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetLocation'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name


class AmazonS3CompatibleLocation(DatasetLocation):
    """The location of Amazon S3 Compatible dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression
     with resultType string).
    :type bucket_name: object
    :param version: Specify the version of Amazon S3 Compatible. Type: string (or Expression with
     resultType string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        bucket_name: Optional[object] = None,
        version: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AmazonS3CompatibleLocation'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class StoreReadSettings(msrest.serialization.Model):
    """Connector read setting.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3CompatibleReadSettings, AmazonS3ReadSettings, AzureBlobFSReadSettings, AzureBlobStorageReadSettings, AzureDataLakeStoreReadSettings, AzureFileStorageReadSettings, FileServerReadSettings, FtpReadSettings, GoogleCloudStorageReadSettings, HdfsReadSettings, HttpReadSettings, OracleCloudStorageReadSettings, SftpReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3CompatibleReadSettings': 'AmazonS3CompatibleReadSettings', 'AmazonS3ReadSettings': 'AmazonS3ReadSettings', 'AzureBlobFSReadSettings': 'AzureBlobFSReadSettings', 'AzureBlobStorageReadSettings': 'AzureBlobStorageReadSettings', 'AzureDataLakeStoreReadSettings': 'AzureDataLakeStoreReadSettings', 'AzureFileStorageReadSettings': 'AzureFileStorageReadSettings', 'FileServerReadSettings': 'FileServerReadSettings', 'FtpReadSettings': 'FtpReadSettings', 'GoogleCloudStorageReadSettings': 'GoogleCloudStorageReadSettings', 'HdfsReadSettings': 'HdfsReadSettings', 'HttpReadSettings': 'HttpReadSettings', 'OracleCloudStorageReadSettings': 'OracleCloudStorageReadSettings', 'SftpReadSettings': 'SftpReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(StoreReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'StoreReadSettings'  # type: str
        self.max_concurrent_connections = max_concurrent_connections


class AmazonS3CompatibleReadSettings(StoreReadSettings):
    """Amazon S3 Compatible read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Amazon S3 Compatible wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Amazon S3 Compatible wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the S3 Compatible object name. Type: string (or Expression
     with resultType string).
    :type prefix: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        prefix: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3CompatibleReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AmazonS3CompatibleReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AmazonS3Dataset(Dataset):
    """A single Amazon Simple Storage Service (S3) object or a set of S3 objects.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param bucket_name: Required. The name of the Amazon S3 bucket. Type: string (or Expression
     with resultType string).
    :type bucket_name: object
    :param key: The key of the Amazon S3 object. Type: string (or Expression with resultType
     string).
    :type key: object
    :param prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :type prefix: object
    :param version: The version for the S3 object. Type: string (or Expression with resultType
     string).
    :type version: object
    :param modified_datetime_start: The start of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_end: object
    :param format: The format of files.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the Amazon S3 object.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'bucket_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'bucket_name': {'key': 'typeProperties.bucketName', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'object'},
        'prefix': {'key': 'typeProperties.prefix', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        bucket_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        key: Optional[object] = None,
        prefix: Optional[object] = None,
        version: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AmazonS3Dataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AmazonS3Object'  # type: str
        self.bucket_name = bucket_name
        self.key = key
        self.prefix = prefix
        self.version = version
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AmazonS3LinkedService(LinkedService):
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param authentication_type: The authentication type of S3. Allowed value: AccessKey (default)
     or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param access_key_id: The access key identifier of the Amazon S3 Identity and Access Management
     (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Amazon S3 Identity and Access Management
     (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the S3 Connector. This is
     an optional property; change it only if you want to try a different service endpoint or want to
     switch between https and http. Type: string (or Expression with resultType string).
    :type service_url: object
    :param session_token: The session token for the S3 temporary security credential.
    :type session_token: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'session_token': {'key': 'typeProperties.sessionToken', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        access_key_id: Optional[object] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[object] = None,
        session_token: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AmazonS3'  # type: str
        self.authentication_type = authentication_type
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.session_token = session_token
        self.encrypted_credential = encrypted_credential


class AmazonS3Location(DatasetLocation):
    """The location of amazon S3 dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of amazon S3. Type: string (or Expression with
     resultType string).
    :type bucket_name: object
    :param version: Specify the version of amazon S3. Type: string (or Expression with resultType
     string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        bucket_name: Optional[object] = None,
        version: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3Location, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AmazonS3Location'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class AmazonS3ReadSettings(StoreReadSettings):
    """Amazon S3 read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: AmazonS3 wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: AmazonS3 wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :type prefix: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        prefix: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3ReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AmazonS3ReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AppendVariableActivity(Activity):
    """Append value for a Variable of type Array.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param variable_name: Name of the variable whose value needs to be appended to.
    :type variable_name: str
    :param value: Value to be appended. Could be a static value or Expression.
    :type value: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'value': {'key': 'typeProperties.value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        variable_name: Optional[str] = None,
        value: Optional[object] = None,
        **kwargs
    ):
        super(AppendVariableActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'AppendVariable'  # type: str
        self.variable_name = variable_name
        self.value = value


class AvroDataset(Dataset):
    """Avro dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the avro storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param avro_compression_codec:  Possible values include: "none", "deflate", "snappy", "xz",
     "bzip2".
    :type avro_compression_codec: str or ~azure.mgmt.datafactory.models.AvroCompressionCodec
    :param avro_compression_level:
    :type avro_compression_level: int
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'avro_compression_level': {'maximum': 9, 'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'avro_compression_codec': {'key': 'typeProperties.avroCompressionCodec', 'type': 'str'},
        'avro_compression_level': {'key': 'typeProperties.avroCompressionLevel', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        avro_compression_codec: Optional[Union[str, "AvroCompressionCodec"]] = None,
        avro_compression_level: Optional[int] = None,
        **kwargs
    ):
        super(AvroDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Avro'  # type: str
        self.location = location
        self.avro_compression_codec = avro_compression_codec
        self.avro_compression_level = avro_compression_level


class DatasetStorageFormat(msrest.serialization.Model):
    """The format definition of a storage.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroFormat, JsonFormat, OrcFormat, ParquetFormat, TextFormat.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroFormat': 'AvroFormat', 'JsonFormat': 'JsonFormat', 'OrcFormat': 'OrcFormat', 'ParquetFormat': 'ParquetFormat', 'TextFormat': 'TextFormat'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        serializer: Optional[object] = None,
        deserializer: Optional[object] = None,
        **kwargs
    ):
        super(DatasetStorageFormat, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetStorageFormat'  # type: str
        self.serializer = serializer
        self.deserializer = deserializer


class AvroFormat(DatasetStorageFormat):
    """The data stored in Avro format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        serializer: Optional[object] = None,
        deserializer: Optional[object] = None,
        **kwargs
    ):
        super(AvroFormat, self).__init__(additional_properties=additional_properties, serializer=serializer, deserializer=deserializer, **kwargs)
        self.type = 'AvroFormat'  # type: str


class CopySink(msrest.serialization.Model):
    """A copy activity sink.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSink, AzureBlobFSSink, AzureDataExplorerSink, AzureDataLakeStoreSink, AzureDatabricksDeltaLakeSink, AzureMySqlSink, AzurePostgreSqlSink, AzureQueueSink, AzureSearchIndexSink, AzureSqlSink, AzureTableSink, BinarySink, BlobSink, CommonDataServiceForAppsSink, CosmosDbMongoDbApiSink, CosmosDbSqlApiSink, DelimitedTextSink, DocumentDbCollectionSink, DynamicsCrmSink, DynamicsSink, FileSystemSink, InformixSink, JsonSink, MicrosoftAccessSink, OdbcSink, OracleSink, OrcSink, ParquetSink, RestSink, SalesforceServiceCloudSink, SalesforceSink, SapCloudForCustomerSink, SnowflakeSink, SqlDWSink, SqlMISink, SqlServerSink, SqlSink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroSink': 'AvroSink', 'AzureBlobFSSink': 'AzureBlobFSSink', 'AzureDataExplorerSink': 'AzureDataExplorerSink', 'AzureDataLakeStoreSink': 'AzureDataLakeStoreSink', 'AzureDatabricksDeltaLakeSink': 'AzureDatabricksDeltaLakeSink', 'AzureMySqlSink': 'AzureMySqlSink', 'AzurePostgreSqlSink': 'AzurePostgreSqlSink', 'AzureQueueSink': 'AzureQueueSink', 'AzureSearchIndexSink': 'AzureSearchIndexSink', 'AzureSqlSink': 'AzureSqlSink', 'AzureTableSink': 'AzureTableSink', 'BinarySink': 'BinarySink', 'BlobSink': 'BlobSink', 'CommonDataServiceForAppsSink': 'CommonDataServiceForAppsSink', 'CosmosDbMongoDbApiSink': 'CosmosDbMongoDbApiSink', 'CosmosDbSqlApiSink': 'CosmosDbSqlApiSink', 'DelimitedTextSink': 'DelimitedTextSink', 'DocumentDbCollectionSink': 'DocumentDbCollectionSink', 'DynamicsCrmSink': 'DynamicsCrmSink', 'DynamicsSink': 'DynamicsSink', 'FileSystemSink': 'FileSystemSink', 'InformixSink': 'InformixSink', 'JsonSink': 'JsonSink', 'MicrosoftAccessSink': 'MicrosoftAccessSink', 'OdbcSink': 'OdbcSink', 'OracleSink': 'OracleSink', 'OrcSink': 'OrcSink', 'ParquetSink': 'ParquetSink', 'RestSink': 'RestSink', 'SalesforceServiceCloudSink': 'SalesforceServiceCloudSink', 'SalesforceSink': 'SalesforceSink', 'SapCloudForCustomerSink': 'SapCloudForCustomerSink', 'SnowflakeSink': 'SnowflakeSink', 'SqlDWSink': 'SqlDWSink', 'SqlMISink': 'SqlMISink', 'SqlServerSink': 'SqlServerSink', 'SqlSink': 'SqlSink'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(CopySink, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopySink'  # type: str
        self.write_batch_size = write_batch_size
        self.write_batch_timeout = write_batch_timeout
        self.sink_retry_count = sink_retry_count
        self.sink_retry_wait = sink_retry_wait
        self.max_concurrent_connections = max_concurrent_connections


class AvroSink(CopySink):
    """A copy activity Avro sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    :param format_settings: Avro format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.AvroWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'AvroWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        format_settings: Optional["AvroWriteSettings"] = None,
        **kwargs
    ):
        super(AvroSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AvroSink'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class AvroSource(CopySource):
    """A copy activity Avro source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(AvroSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AvroSource'  # type: str
        self.store_settings = store_settings
        self.additional_columns = additional_columns


class FormatWriteSettings(msrest.serialization.Model):
    """Format write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroWriteSettings, DelimitedTextWriteSettings, JsonWriteSettings, OrcWriteSettings, ParquetWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AvroWriteSettings': 'AvroWriteSettings', 'DelimitedTextWriteSettings': 'DelimitedTextWriteSettings', 'JsonWriteSettings': 'JsonWriteSettings', 'OrcWriteSettings': 'OrcWriteSettings', 'ParquetWriteSettings': 'ParquetWriteSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(FormatWriteSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'FormatWriteSettings'  # type: str


class AvroWriteSettings(FormatWriteSettings):
    """Avro write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param record_name: Top level record name in write result, which is required in AVRO spec.
    :type record_name: str
    :param record_namespace: Record namespace in the write result.
    :type record_namespace: str
    :param max_rows_per_file: Limit the written file's row count to be smaller than or equal to the
     specified count. Type: integer (or Expression with resultType integer).
    :type max_rows_per_file: object
    :param file_name_prefix: Specifies the file name pattern
     :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
     based store without partitionOptions. Type: string (or Expression with resultType string).
    :type file_name_prefix: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'record_name': {'key': 'recordName', 'type': 'str'},
        'record_namespace': {'key': 'recordNamespace', 'type': 'str'},
        'max_rows_per_file': {'key': 'maxRowsPerFile', 'type': 'object'},
        'file_name_prefix': {'key': 'fileNamePrefix', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        record_name: Optional[str] = None,
        record_namespace: Optional[str] = None,
        max_rows_per_file: Optional[object] = None,
        file_name_prefix: Optional[object] = None,
        **kwargs
    ):
        super(AvroWriteSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AvroWriteSettings'  # type: str
        self.record_name = record_name
        self.record_namespace = record_namespace
        self.max_rows_per_file = max_rows_per_file
        self.file_name_prefix = file_name_prefix


class CustomSetupBase(msrest.serialization.Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzPowerShellSetup, CmdkeySetup, ComponentSetup, EnvironmentVariableSetup.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzPowerShellSetup': 'AzPowerShellSetup', 'CmdkeySetup': 'CmdkeySetup', 'ComponentSetup': 'ComponentSetup', 'EnvironmentVariableSetup': 'EnvironmentVariableSetup'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomSetupBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzPowerShellSetup(CustomSetupBase):
    """The express custom setup of installing Azure PowerShell.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param version: Required. The required version of Azure PowerShell to install.
    :type version: str
    """

    _validation = {
        'type': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'typeProperties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: str,
        **kwargs
    ):
        super(AzPowerShellSetup, self).__init__(**kwargs)
        self.type = 'AzPowerShellSetup'  # type: str
        self.version = version


class AzureBatchLinkedService(LinkedService):
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Batch account name. Type: string (or Expression with
     resultType string).
    :type account_name: object
    :param access_key: The Azure Batch account access key.
    :type access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param batch_uri: Required. The Azure Batch URI. Type: string (or Expression with resultType
     string).
    :type batch_uri: object
    :param pool_name: Required. The Azure Batch pool name. Type: string (or Expression with
     resultType string).
    :type pool_name: object
    :param linked_service_name: Required. The Azure Storage linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'batch_uri': {'required': True},
        'pool_name': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'access_key': {'key': 'typeProperties.accessKey', 'type': 'SecretBase'},
        'batch_uri': {'key': 'typeProperties.batchUri', 'type': 'object'},
        'pool_name': {'key': 'typeProperties.poolName', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        account_name: object,
        batch_uri: object,
        pool_name: object,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureBatchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBatch'  # type: str
        self.account_name = account_name
        self.access_key = access_key
        self.batch_uri = batch_uri
        self.pool_name = pool_name
        self.linked_service_name = linked_service_name
        self.encrypted_credential = encrypted_credential


class AzureBlobDataset(Dataset):
    """The Azure Blob storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the Azure Blob storage. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param table_root_location: The root of blob path. Type: string (or Expression with resultType
     string).
    :type table_root_location: object
    :param file_name: The name of the Azure Blob. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param modified_datetime_start: The start of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_end: object
    :param format: The format of the Azure Blob storage.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the blob storage.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'table_root_location': {'key': 'typeProperties.tableRootLocation', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[object] = None,
        table_root_location: Optional[object] = None,
        file_name: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureBlobDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureBlob'  # type: str
        self.folder_path = folder_path
        self.table_root_location = table_root_location
        self.file_name = file_name
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AzureBlobFSDataset(Dataset):
    """The Azure Data Lake Storage Gen2 storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the Azure Data Lake Storage Gen2 storage. Type: string (or
     Expression with resultType string).
    :type folder_path: object
    :param file_name: The name of the Azure Data Lake Storage Gen2. Type: string (or Expression
     with resultType string).
    :type file_name: object
    :param format: The format of the Azure Data Lake Storage Gen2 storage.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the blob storage.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureBlobFSDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureBlobFSFile'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureBlobFSLinkedService(LinkedService):
    """Azure Data Lake Storage Gen2 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type url: object
    :param account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type account_key: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        account_key: Optional[object] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBlobFS'  # type: str
        self.url = url
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential


class AzureBlobFSLocation(DatasetLocation):
    """The location of azure blobFS dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param file_system: Specify the fileSystem of azure blobFS. Type: string (or Expression with
     resultType string).
    :type file_system: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'file_system': {'key': 'fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        file_system: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureBlobFSLocation'  # type: str
        self.file_system = file_system


class AzureBlobFSReadSettings(StoreReadSettings):
    """Azure blobFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure blobFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure blobFS wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureBlobFSReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobFSSink(CopySink):
    """A copy activity Azure Data Lake Storage Gen2 sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureBlobFSSink'  # type: str
        self.copy_behavior = copy_behavior


class AzureBlobFSSource(CopySource):
    """A copy activity Azure BlobFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: object
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        treat_empty_as_null: Optional[object] = None,
        skip_header_line_count: Optional[object] = None,
        recursive: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureBlobFSSource'  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class StoreWriteSettings(msrest.serialization.Model):
    """Connector write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobFSWriteSettings, AzureBlobStorageWriteSettings, AzureDataLakeStoreWriteSettings, AzureFileStorageWriteSettings, FileServerWriteSettings, SftpWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AzureBlobFSWriteSettings': 'AzureBlobFSWriteSettings', 'AzureBlobStorageWriteSettings': 'AzureBlobStorageWriteSettings', 'AzureDataLakeStoreWriteSettings': 'AzureDataLakeStoreWriteSettings', 'AzureFileStorageWriteSettings': 'AzureFileStorageWriteSettings', 'FileServerWriteSettings': 'FileServerWriteSettings', 'SftpWriteSettings': 'SftpWriteSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(StoreWriteSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'StoreWriteSettings'  # type: str
        self.max_concurrent_connections = max_concurrent_connections
        self.copy_behavior = copy_behavior


class AzureBlobFSWriteSettings(StoreWriteSettings):
    """Azure blobFS write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        block_size_in_mb: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureBlobFSWriteSettings'  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureBlobStorageLinkedService(LinkedService):
    """The azure blob storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri,
     serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     connectionString, serviceEndpoint property. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
     mutually exclusive with connectionString, sasUri property.
    :type service_endpoint: str
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param account_kind: Specify the kind of your storage account. Allowed values are: Storage
     (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type:
     string (or Expression with resultType string).
    :type account_kind: str
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'service_endpoint': {'key': 'typeProperties.serviceEndpoint', 'type': 'str'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'account_kind': {'key': 'typeProperties.accountKind', 'type': 'str'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        service_endpoint: Optional[str] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        account_kind: Optional[str] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureBlobStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureBlobStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.service_endpoint = service_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_kind = account_kind
        self.encrypted_credential = encrypted_credential


class AzureBlobStorageLocation(DatasetLocation):
    """The location of azure blob dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param container: Specify the container of azure blob. Type: string (or Expression with
     resultType string).
    :type container: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'container': {'key': 'container', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        container: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureBlobStorageLocation'  # type: str
        self.container = container


class AzureBlobStorageReadSettings(StoreReadSettings):
    """Azure blob read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure blob wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure blob wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the Azure Blob name. Type: string (or Expression with
     resultType string).
    :type prefix: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        prefix: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureBlobStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobStorageWriteSettings(StoreWriteSettings):
    """Azure blob write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        block_size_in_mb: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobStorageWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureBlobStorageWriteSettings'  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureDatabricksDeltaLakeDataset(Dataset):
    """Azure Databricks Delta Lake dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table: The name of delta table. Type: string (or Expression with resultType string).
    :type table: object
    :param database: The database name of delta table. Type: string (or Expression with resultType
     string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table: Optional[object] = None,
        database: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeDataset'  # type: str
        self.table = table
        self.database = database


class ExportSettings(msrest.serialization.Model):
    """Export command settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDatabricksDeltaLakeExportCommand, SnowflakeExportCopyCommand.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The export setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureDatabricksDeltaLakeExportCommand': 'AzureDatabricksDeltaLakeExportCommand', 'SnowflakeExportCopyCommand': 'SnowflakeExportCopyCommand'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ExportSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'ExportSettings'  # type: str


class AzureDatabricksDeltaLakeExportCommand(ExportSettings):
    """Azure Databricks Delta Lake export command settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The export setting type.Constant filled by server.
    :type type: str
    :param date_format: Specify the date format for the csv in Azure Databricks Delta Lake Copy.
     Type: string (or Expression with resultType string).
    :type date_format: object
    :param timestamp_format: Specify the timestamp format for the csv in Azure Databricks Delta
     Lake Copy. Type: string (or Expression with resultType string).
    :type timestamp_format: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'object'},
        'timestamp_format': {'key': 'timestampFormat', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        date_format: Optional[object] = None,
        timestamp_format: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeExportCommand, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeExportCommand'  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class ImportSettings(msrest.serialization.Model):
    """Import command settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDatabricksDeltaLakeImportCommand, SnowflakeImportCopyCommand.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The import setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureDatabricksDeltaLakeImportCommand': 'AzureDatabricksDeltaLakeImportCommand', 'SnowflakeImportCopyCommand': 'SnowflakeImportCopyCommand'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ImportSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'ImportSettings'  # type: str


class AzureDatabricksDeltaLakeImportCommand(ImportSettings):
    """Azure Databricks Delta Lake import command settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The import setting type.Constant filled by server.
    :type type: str
    :param date_format: Specify the date format for csv in Azure Databricks Delta Lake Copy. Type:
     string (or Expression with resultType string).
    :type date_format: object
    :param timestamp_format: Specify the timestamp format for csv in Azure Databricks Delta Lake
     Copy. Type: string (or Expression with resultType string).
    :type timestamp_format: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'object'},
        'timestamp_format': {'key': 'timestampFormat', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        date_format: Optional[object] = None,
        timestamp_format: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeImportCommand, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeImportCommand'  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class AzureDatabricksDeltaLakeLinkedService(LinkedService):
    """Azure Databricks Delta Lake linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: object
    :param access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type access_token: ~azure.mgmt.datafactory.models.SecretBase
    :param cluster_id: The id of an existing interactive cluster that will be used for all runs of
     this job. Type: string (or Expression with resultType string).
    :type cluster_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'cluster_id': {'key': 'typeProperties.clusterId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        domain: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_token: Optional["SecretBase"] = None,
        cluster_id: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDatabricksDeltaLake'  # type: str
        self.domain = domain
        self.access_token = access_token
        self.cluster_id = cluster_id
        self.encrypted_credential = encrypted_credential


class AzureDatabricksDeltaLakeSink(CopySink):
    """A copy activity Azure Databricks Delta Lake sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: object
    :param import_settings: Azure Databricks Delta Lake import settings.
    :type import_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeImportCommand
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
        'import_settings': {'key': 'importSettings', 'type': 'AzureDatabricksDeltaLakeImportCommand'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        pre_copy_script: Optional[object] = None,
        import_settings: Optional["AzureDatabricksDeltaLakeImportCommand"] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeSink'  # type: str
        self.pre_copy_script = pre_copy_script
        self.import_settings = import_settings


class AzureDatabricksDeltaLakeSource(CopySource):
    """A copy activity Azure Databricks Delta Lake source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Azure Databricks Delta Lake Sql query. Type: string (or Expression with
     resultType string).
    :type query: object
    :param export_settings: Azure Databricks Delta Lake export settings.
    :type export_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeExportCommand
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'export_settings': {'key': 'exportSettings', 'type': 'AzureDatabricksDeltaLakeExportCommand'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        export_settings: Optional["AzureDatabricksDeltaLakeExportCommand"] = None,
        **kwargs
    ):
        super(AzureDatabricksDeltaLakeSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDatabricksDeltaLakeSource'  # type: str
        self.query = query
        self.export_settings = export_settings


class AzureDatabricksLinkedService(LinkedService):
    """Azure Databricks linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: object
    :param access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
     with resultType string).
    :type access_token: ~azure.mgmt.datafactory.models.SecretBase
    :param authentication: Required to specify MSI, if using Workspace resource id for databricks
     REST API. Type: string (or Expression with resultType string).
    :type authentication: object
    :param workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
     Expression with resultType string).
    :type workspace_resource_id: object
    :param existing_cluster_id: The id of an existing interactive cluster that will be used for all
     runs of this activity. Type: string (or Expression with resultType string).
    :type existing_cluster_id: object
    :param instance_pool_id: The id of an existing instance pool that will be used for all runs of
     this activity. Type: string (or Expression with resultType string).
    :type instance_pool_id: object
    :param new_cluster_version: If not using an existing interactive cluster, this specifies the
     Spark version of a new job cluster or instance pool nodes created for each run of this
     activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
     string).
    :type new_cluster_version: object
    :param new_cluster_num_of_worker: If not using an existing interactive cluster, this specifies
     the number of worker nodes to use for the new job cluster or instance pool. For new job
     clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-
     scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can
     only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
     specified. Type: string (or Expression with resultType string).
    :type new_cluster_num_of_worker: object
    :param new_cluster_node_type: The node type of the new job cluster. This property is required
     if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
     specified, this property is ignored. Type: string (or Expression with resultType string).
    :type new_cluster_node_type: object
    :param new_cluster_spark_conf: A set of optional, user-specified Spark configuration key-value
     pairs.
    :type new_cluster_spark_conf: dict[str, object]
    :param new_cluster_spark_env_vars: A set of optional, user-specified Spark environment
     variables key-value pairs.
    :type new_cluster_spark_env_vars: dict[str, object]
    :param new_cluster_custom_tags: Additional tags for cluster resources. This property is ignored
     in instance pool configurations.
    :type new_cluster_custom_tags: dict[str, object]
    :param new_cluster_log_destination: Specify a location to deliver Spark driver, worker, and
     event logs. Type: string (or Expression with resultType string).
    :type new_cluster_log_destination: object
    :param new_cluster_driver_node_type: The driver node type for the new job cluster. This
     property is ignored in instance pool configurations. Type: string (or Expression with
     resultType string).
    :type new_cluster_driver_node_type: object
    :param new_cluster_init_scripts: User-defined initialization scripts for the new cluster. Type:
     array of strings (or Expression with resultType array of strings).
    :type new_cluster_init_scripts: object
    :param new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
     property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
     disks are always enabled). Type: boolean (or Expression with resultType boolean).
    :type new_cluster_enable_elastic_disk: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param policy_id: The policy id for limiting the ability to configure clusters based on a user
     defined set of rules. Type: string (or Expression with resultType string).
    :type policy_id: object
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'authentication': {'key': 'typeProperties.authentication', 'type': 'object'},
        'workspace_resource_id': {'key': 'typeProperties.workspaceResourceId', 'type': 'object'},
        'existing_cluster_id': {'key': 'typeProperties.existingClusterId', 'type': 'object'},
        'instance_pool_id': {'key': 'typeProperties.instancePoolId', 'type': 'object'},
        'new_cluster_version': {'key': 'typeProperties.newClusterVersion', 'type': 'object'},
        'new_cluster_num_of_worker': {'key': 'typeProperties.newClusterNumOfWorker', 'type': 'object'},
        'new_cluster_node_type': {'key': 'typeProperties.newClusterNodeType', 'type': 'object'},
        'new_cluster_spark_conf': {'key': 'typeProperties.newClusterSparkConf', 'type': '{object}'},
        'new_cluster_spark_env_vars': {'key': 'typeProperties.newClusterSparkEnvVars', 'type': '{object}'},
        'new_cluster_custom_tags': {'key': 'typeProperties.newClusterCustomTags', 'type': '{object}'},
        'new_cluster_log_destination': {'key': 'typeProperties.newClusterLogDestination', 'type': 'object'},
        'new_cluster_driver_node_type': {'key': 'typeProperties.newClusterDriverNodeType', 'type': 'object'},
        'new_cluster_init_scripts': {'key': 'typeProperties.newClusterInitScripts', 'type': 'object'},
        'new_cluster_enable_elastic_disk': {'key': 'typeProperties.newClusterEnableElasticDisk', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'policy_id': {'key': 'typeProperties.policyId', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        domain: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_token: Optional["SecretBase"] = None,
        authentication: Optional[object] = None,
        workspace_resource_id: Optional[object] = None,
        existing_cluster_id: Optional[object] = None,
        instance_pool_id: Optional[object] = None,
        new_cluster_version: Optional[object] = None,
        new_cluster_num_of_worker: Optional[object] = None,
        new_cluster_node_type: Optional[object] = None,
        new_cluster_spark_conf: Optional[Dict[str, object]] = None,
        new_cluster_spark_env_vars: Optional[Dict[str, object]] = None,
        new_cluster_custom_tags: Optional[Dict[str, object]] = None,
        new_cluster_log_destination: Optional[object] = None,
        new_cluster_driver_node_type: Optional[object] = None,
        new_cluster_init_scripts: Optional[object] = None,
        new_cluster_enable_elastic_disk: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        policy_id: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDatabricks'  # type: str
        self.domain = domain
        self.access_token = access_token
        self.authentication = authentication
        self.workspace_resource_id = workspace_resource_id
        self.existing_cluster_id = existing_cluster_id
        self.instance_pool_id = instance_pool_id
        self.new_cluster_version = new_cluster_version
        self.new_cluster_num_of_worker = new_cluster_num_of_worker
        self.new_cluster_node_type = new_cluster_node_type
        self.new_cluster_spark_conf = new_cluster_spark_conf
        self.new_cluster_spark_env_vars = new_cluster_spark_env_vars
        self.new_cluster_custom_tags = new_cluster_custom_tags
        self.new_cluster_log_destination = new_cluster_log_destination
        self.new_cluster_driver_node_type = new_cluster_driver_node_type
        self.new_cluster_init_scripts = new_cluster_init_scripts
        self.new_cluster_enable_elastic_disk = new_cluster_enable_elastic_disk
        self.encrypted_credential = encrypted_credential
        self.policy_id = policy_id


class ExecutionActivity(Activity):
    """Base class for all execution activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDataExplorerCommandActivity, AzureFunctionActivity, AzureMLBatchExecutionActivity, AzureMLExecutePipelineActivity, AzureMLUpdateResourceActivity, CopyActivity, CustomActivity, DataLakeAnalyticsUSQLActivity, DatabricksNotebookActivity, DatabricksSparkJarActivity, DatabricksSparkPythonActivity, DeleteActivity, ExecuteDataFlowActivity, ExecuteSSISPackageActivity, GetMetadataActivity, HDInsightHiveActivity, HDInsightMapReduceActivity, HDInsightPigActivity, HDInsightSparkActivity, HDInsightStreamingActivity, LookupActivity, SqlServerStoredProcedureActivity, WebActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
    }

    _subtype_map = {
        'type': {'AzureDataExplorerCommand': 'AzureDataExplorerCommandActivity', 'AzureFunctionActivity': 'AzureFunctionActivity', 'AzureMLBatchExecution': 'AzureMLBatchExecutionActivity', 'AzureMLExecutePipeline': 'AzureMLExecutePipelineActivity', 'AzureMLUpdateResource': 'AzureMLUpdateResourceActivity', 'Copy': 'CopyActivity', 'Custom': 'CustomActivity', 'DataLakeAnalyticsU-SQL': 'DataLakeAnalyticsUSQLActivity', 'DatabricksNotebook': 'DatabricksNotebookActivity', 'DatabricksSparkJar': 'DatabricksSparkJarActivity', 'DatabricksSparkPython': 'DatabricksSparkPythonActivity', 'Delete': 'DeleteActivity', 'ExecuteDataFlow': 'ExecuteDataFlowActivity', 'ExecuteSSISPackage': 'ExecuteSSISPackageActivity', 'GetMetadata': 'GetMetadataActivity', 'HDInsightHive': 'HDInsightHiveActivity', 'HDInsightMapReduce': 'HDInsightMapReduceActivity', 'HDInsightPig': 'HDInsightPigActivity', 'HDInsightSpark': 'HDInsightSparkActivity', 'HDInsightStreaming': 'HDInsightStreamingActivity', 'Lookup': 'LookupActivity', 'SqlServerStoredProcedure': 'SqlServerStoredProcedureActivity', 'WebActivity': 'WebActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(ExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Execution'  # type: str
        self.linked_service_name = linked_service_name
        self.policy = policy


class AzureDataExplorerCommandActivity(ExecutionActivity):
    """Azure Data Explorer command activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param command: Required. A control command, according to the Azure Data Explorer command
     syntax. Type: string (or Expression with resultType string).
    :type command: object
    :param command_timeout: Control command timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
    :type command_timeout: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'command_timeout': {'key': 'typeProperties.commandTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        command_timeout: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerCommandActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureDataExplorerCommand'  # type: str
        self.command = command
        self.command_timeout = command_timeout


class AzureDataExplorerLinkedService(LinkedService):
    """Azure Data Explorer (Kusto) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of Azure Data Explorer (the engine's endpoint). URL
     will be in the format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net.
     Type: string (or Expression with resultType string).
    :type endpoint: object
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     Data Explorer. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Kusto.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: object
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataExplorer'  # type: str
        self.endpoint = endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.database = database
        self.tenant = tenant


class AzureDataExplorerSink(CopySink):
    """A copy activity Azure Data Explorer sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param ingestion_mapping_name: A name of a pre-created csv mapping that was defined on the
     target Kusto table. Type: string.
    :type ingestion_mapping_name: object
    :param ingestion_mapping_as_json: An explicit column mapping description provided in a json
     format. Type: string.
    :type ingestion_mapping_as_json: object
    :param flush_immediately: If set to true, any aggregation will be skipped. Default is false.
     Type: boolean.
    :type flush_immediately: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'ingestion_mapping_name': {'key': 'ingestionMappingName', 'type': 'object'},
        'ingestion_mapping_as_json': {'key': 'ingestionMappingAsJson', 'type': 'object'},
        'flush_immediately': {'key': 'flushImmediately', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        ingestion_mapping_name: Optional[object] = None,
        ingestion_mapping_as_json: Optional[object] = None,
        flush_immediately: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDataExplorerSink'  # type: str
        self.ingestion_mapping_name = ingestion_mapping_name
        self.ingestion_mapping_as_json = ingestion_mapping_as_json
        self.flush_immediately = flush_immediately


class AzureDataExplorerSource(CopySource):
    """A copy activity Azure Data Explorer (Kusto) source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Required. Database query. Should be a Kusto Query Language (KQL) query. Type:
     string (or Expression with resultType string).
    :type query: object
    :param no_truncation: The name of the Boolean option that controls whether truncation is
     applied to result-sets that go beyond a certain row-count limit.
    :type no_truncation: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'no_truncation': {'key': 'noTruncation', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        query: object,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        no_truncation: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(AzureDataExplorerSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDataExplorerSource'  # type: str
        self.query = query
        self.no_truncation = no_truncation
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AzureDataExplorerTableDataset(Dataset):
    """The Azure Data Explorer (Kusto) dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table: The table name of the Azure Data Explorer database. Type: string (or Expression
     with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDataExplorerTable'  # type: str
        self.table = table


class AzureDataLakeAnalyticsLinkedService(LinkedService):
    """Azure Data Lake Analytics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Data Lake Analytics account name. Type: string (or
     Expression with resultType string).
    :type account_name: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Analytics account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Analytics account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: object
    :param subscription_id: Data Lake Analytics account subscription ID (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Analytics account resource group name (if different from
     Data Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with
     resultType string).
    :type data_lake_analytics_uri: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'data_lake_analytics_uri': {'key': 'typeProperties.dataLakeAnalyticsUri', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        account_name: object,
        tenant: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        subscription_id: Optional[object] = None,
        resource_group_name: Optional[object] = None,
        data_lake_analytics_uri: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeAnalyticsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataLakeAnalytics'  # type: str
        self.account_name = account_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.data_lake_analytics_uri = data_lake_analytics_uri
        self.encrypted_credential = encrypted_credential


class AzureDataLakeStoreDataset(Dataset):
    """Azure Data Lake Store dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or
     Expression with resultType string).
    :type folder_path: object
    :param file_name: The name of the file in the Azure Data Lake Store. Type: string (or
     Expression with resultType string).
    :type file_name: object
    :param format: The format of the Data Lake Store.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the item(s) in the Azure Data Lake
     Store.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureDataLakeStoreFile'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureDataLakeStoreLinkedService(LinkedService):
    """Azure Data Lake Store linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param data_lake_store_uri: Required. Data Lake Store service URI. Type: string (or Expression
     with resultType string).
    :type data_lake_store_uri: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Store account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Store account.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param account_name: Data Lake Store account name. Type: string (or Expression with resultType
     string).
    :type account_name: object
    :param subscription_id: Data Lake Store account subscription ID (if different from Data Factory
     account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Store account resource group name (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'data_lake_store_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'data_lake_store_uri': {'key': 'typeProperties.dataLakeStoreUri', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        data_lake_store_uri: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        account_name: Optional[object] = None,
        subscription_id: Optional[object] = None,
        resource_group_name: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureDataLakeStore'  # type: str
        self.data_lake_store_uri = data_lake_store_uri
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_name = account_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.encrypted_credential = encrypted_credential


class AzureDataLakeStoreLocation(DatasetLocation):
    """The location of azure data lake store dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureDataLakeStoreLocation'  # type: str


class AzureDataLakeStoreReadSettings(StoreReadSettings):
    """Azure data lake store read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: ADLS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: ADLS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param list_after: Lists files after the value (exclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :type list_after: object
    :param list_before: Lists files before the value (inclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :type list_before: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'list_after': {'key': 'listAfter', 'type': 'object'},
        'list_before': {'key': 'listBefore', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        file_list_path: Optional[object] = None,
        list_after: Optional[object] = None,
        list_before: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDataLakeStoreReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.list_after = list_after
        self.list_before = list_before
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureDataLakeStoreSink(CopySink):
    """A copy activity Azure Data Lake Store sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param enable_adls_single_file_parallel: Single File Parallel.
    :type enable_adls_single_file_parallel: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'enable_adls_single_file_parallel': {'key': 'enableAdlsSingleFileParallel', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        enable_adls_single_file_parallel: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDataLakeStoreSink'  # type: str
        self.copy_behavior = copy_behavior
        self.enable_adls_single_file_parallel = enable_adls_single_file_parallel


class AzureDataLakeStoreSource(CopySource):
    """A copy activity Azure Data Lake source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureDataLakeStoreSource'  # type: str
        self.recursive = recursive


class AzureDataLakeStoreWriteSettings(StoreWriteSettings):
    """Azure data lake store write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param expiry_date_time: Specifies the expiry time of the written files. The time is applied to
     the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: integer
     (or Expression with resultType integer).
    :type expiry_date_time: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'expiry_date_time': {'key': 'expiryDateTime', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        expiry_date_time: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureDataLakeStoreWriteSettings'  # type: str
        self.expiry_date_time = expiry_date_time


class AzureFileStorageLinkedService(LinkedService):
    """Azure File Storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Host name of the server. Type: string (or Expression with resultType string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure File resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param file_share: The azure file share name. It is required when auth with
     accountKey/sasToken. Type: string (or Expression with resultType string).
    :type file_share: object
    :param snapshot: The azure file share snapshot version. Type: string (or Expression with
     resultType string).
    :type snapshot: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'file_share': {'key': 'typeProperties.fileShare', 'type': 'object'},
        'snapshot': {'key': 'typeProperties.snapshot', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host: Optional[object] = None,
        user_id: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        file_share: Optional[object] = None,
        snapshot: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureFileStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureFileStorage'  # type: str
        self.host = host
        self.user_id = user_id
        self.password = password
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.file_share = file_share
        self.snapshot = snapshot
        self.encrypted_credential = encrypted_credential


class AzureFileStorageLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(AzureFileStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'AzureFileStorageLocation'  # type: str


class AzureFileStorageReadSettings(StoreReadSettings):
    """Azure File Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure File Storage wildcardFolderPath. Type: string (or Expression
     with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure File Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the Azure File name starting from root path. Type: string
     (or Expression with resultType string).
    :type prefix: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        prefix: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(AzureFileStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureFileStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureFileStorageWriteSettings(StoreWriteSettings):
    """Azure File Storage write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(AzureFileStorageWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, copy_behavior=copy_behavior, **kwargs)
        self.type = 'AzureFileStorageWriteSettings'  # type: str


class AzureFunctionActivity(ExecutionActivity):
    """Azure Function activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param method: Required. Rest API method for target endpoint. Possible values include: "GET",
     "POST", "PUT", "DELETE", "OPTIONS", "HEAD", "TRACE".
    :type method: str or ~azure.mgmt.datafactory.models.AzureFunctionActivityMethod
    :param function_name: Required. Name of the Function that the Azure Function Activity will
     call. Type: string (or Expression with resultType string).
    :type function_name: object
    :param headers: Represents the headers that will be sent to the request. For example, to set
     the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
     "application/json" }. Type: string (or Expression with resultType string).
    :type headers: object
    :param body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
     method, not allowed for GET method Type: string (or Expression with resultType string).
    :type body: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'method': {'required': True},
        'function_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'method': {'key': 'typeProperties.method', 'type': 'str'},
        'function_name': {'key': 'typeProperties.functionName', 'type': 'object'},
        'headers': {'key': 'typeProperties.headers', 'type': 'object'},
        'body': {'key': 'typeProperties.body', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        method: Union[str, "AzureFunctionActivityMethod"],
        function_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        headers: Optional[object] = None,
        body: Optional[object] = None,
        **kwargs
    ):
        super(AzureFunctionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureFunctionActivity'  # type: str
        self.method = method
        self.function_name = function_name
        self.headers = headers
        self.body = body


class AzureFunctionLinkedService(LinkedService):
    """Azure Function linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param function_app_url: Required. The endpoint of the Azure Function App. URL will be in the
     format https://:code:`<accountName>`.azurewebsites.net.
    :type function_app_url: object
    :param function_key: Function or Host key for Azure Function App.
    :type function_key: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'function_app_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'function_app_url': {'key': 'typeProperties.functionAppUrl', 'type': 'object'},
        'function_key': {'key': 'typeProperties.functionKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        function_app_url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        function_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureFunctionLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureFunction'  # type: str
        self.function_app_url = function_app_url
        self.function_key = function_key
        self.encrypted_credential = encrypted_credential


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param base_url: Required. The base URL of the Azure Key Vault. e.g.
     https://myakv.vault.azure.net Type: string (or Expression with resultType string).
    :type base_url: object
    """

    _validation = {
        'type': {'required': True},
        'base_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'base_url': {'key': 'typeProperties.baseUrl', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        base_url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(AzureKeyVaultLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureKeyVault'  # type: str
        self.base_url = base_url


class SecretBase(msrest.serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureKeyVaultSecretReference, SecureString.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureKeyVaultSecret': 'AzureKeyVaultSecretReference', 'SecureString': 'SecureString'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param store: Required. The Azure Key Vault linked service reference.
    :type store: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param secret_name: Required. The name of the secret in Azure Key Vault. Type: string (or
     Expression with resultType string).
    :type secret_name: object
    :param secret_version: The version of the secret in Azure Key Vault. The default value is the
     latest version of the secret. Type: string (or Expression with resultType string).
    :type secret_version: object
    """

    _validation = {
        'type': {'required': True},
        'store': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        store: "LinkedServiceReference",
        secret_name: object,
        secret_version: Optional[object] = None,
        **kwargs
    ):
        super(AzureKeyVaultSecretReference, self).__init__(**kwargs)
        self.type = 'AzureKeyVaultSecret'  # type: str
        self.store = store
        self.secret_name = secret_name
        self.secret_version = secret_version


class AzureMariaDBLinkedService(LinkedService):
    """Azure Database for MariaDB linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMariaDBLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMariaDB'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class AzureMariaDBSource(TabularSource):
    """A copy activity Azure MariaDB source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(AzureMariaDBSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureMariaDBSource'  # type: str
        self.query = query


class AzureMariaDBTableDataset(Dataset):
    """Azure Database for MariaDB dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(AzureMariaDBTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureMariaDBTable'  # type: str
        self.table_name = table_name


class AzureMLBatchExecutionActivity(ExecutionActivity):
    """Azure ML Batch Execution activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service
     endpoint. Keys must match the names of web service parameters defined in the published Azure ML
     web service. Values will be passed in the GlobalParameters property of the Azure ML batch
     execution request.
    :type global_parameters: dict[str, object]
    :param web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
     information will be passed in the WebServiceOutputs property of the Azure ML batch execution
     request.
    :type web_service_outputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    :param web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This
     information will be passed in the WebServiceInputs property of the Azure ML batch execution
     request.
    :type web_service_inputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'global_parameters': {'key': 'typeProperties.globalParameters', 'type': '{object}'},
        'web_service_outputs': {'key': 'typeProperties.webServiceOutputs', 'type': '{AzureMLWebServiceFile}'},
        'web_service_inputs': {'key': 'typeProperties.webServiceInputs', 'type': '{AzureMLWebServiceFile}'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        global_parameters: Optional[Dict[str, object]] = None,
        web_service_outputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        web_service_inputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        **kwargs
    ):
        super(AzureMLBatchExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLBatchExecution'  # type: str
        self.global_parameters = global_parameters
        self.web_service_outputs = web_service_outputs
        self.web_service_inputs = web_service_inputs


class AzureMLExecutePipelineActivity(ExecutionActivity):
    """Azure ML Execute Pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param ml_pipeline_id: ID of the published Azure ML pipeline. Type: string (or Expression with
     resultType string).
    :type ml_pipeline_id: object
    :param ml_pipeline_endpoint_id: ID of the published Azure ML pipeline endpoint. Type: string
     (or Expression with resultType string).
    :type ml_pipeline_endpoint_id: object
    :param version: Version of the published Azure ML pipeline endpoint. Type: string (or
     Expression with resultType string).
    :type version: object
    :param experiment_name: Run history experiment name of the pipeline run. This information will
     be passed in the ExperimentName property of the published pipeline execution request. Type:
     string (or Expression with resultType string).
    :type experiment_name: object
    :param ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML pipeline
     endpoint. Keys must match the names of pipeline parameters defined in the published pipeline.
     Values will be passed in the ParameterAssignments property of the published pipeline execution
     request. Type: object with key value pairs (or Expression with resultType object).
    :type ml_pipeline_parameters: object
    :param data_path_assignments: Dictionary used for changing data path assignments without
     retraining. Values will be passed in the dataPathAssignments property of the published pipeline
     execution request. Type: object with key value pairs (or Expression with resultType object).
    :type data_path_assignments: object
    :param ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will be
     passed in the ParentRunId property of the published pipeline execution request. Type: string
     (or Expression with resultType string).
    :type ml_parent_run_id: object
    :param continue_on_step_failure: Whether to continue execution of other steps in the
     PipelineRun if a step fails. This information will be passed in the continueOnStepFailure
     property of the published pipeline execution request. Type: boolean (or Expression with
     resultType boolean).
    :type continue_on_step_failure: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'ml_pipeline_id': {'key': 'typeProperties.mlPipelineId', 'type': 'object'},
        'ml_pipeline_endpoint_id': {'key': 'typeProperties.mlPipelineEndpointId', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'experiment_name': {'key': 'typeProperties.experimentName', 'type': 'object'},
        'ml_pipeline_parameters': {'key': 'typeProperties.mlPipelineParameters', 'type': 'object'},
        'data_path_assignments': {'key': 'typeProperties.dataPathAssignments', 'type': 'object'},
        'ml_parent_run_id': {'key': 'typeProperties.mlParentRunId', 'type': 'object'},
        'continue_on_step_failure': {'key': 'typeProperties.continueOnStepFailure', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        ml_pipeline_id: Optional[object] = None,
        ml_pipeline_endpoint_id: Optional[object] = None,
        version: Optional[object] = None,
        experiment_name: Optional[object] = None,
        ml_pipeline_parameters: Optional[object] = None,
        data_path_assignments: Optional[object] = None,
        ml_parent_run_id: Optional[object] = None,
        continue_on_step_failure: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLExecutePipeline'  # type: str
        self.ml_pipeline_id = ml_pipeline_id
        self.ml_pipeline_endpoint_id = ml_pipeline_endpoint_id
        self.version = version
        self.experiment_name = experiment_name
        self.ml_pipeline_parameters = ml_pipeline_parameters
        self.data_path_assignments = data_path_assignments
        self.ml_parent_run_id = ml_parent_run_id
        self.continue_on_step_failure = continue_on_step_failure


class AzureMLLinkedService(LinkedService):
    """Azure ML Studio Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param ml_endpoint: Required. The Batch Execution REST URL for an Azure ML Studio Web Service
     endpoint. Type: string (or Expression with resultType string).
    :type ml_endpoint: object
    :param api_key: Required. The API key for accessing the Azure ML model endpoint.
    :type api_key: ~azure.mgmt.datafactory.models.SecretBase
    :param update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web
     Service endpoint. Type: string (or Expression with resultType string).
    :type update_resource_endpoint: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
     with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'ml_endpoint': {'required': True},
        'api_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'ml_endpoint': {'key': 'typeProperties.mlEndpoint', 'type': 'object'},
        'api_key': {'key': 'typeProperties.apiKey', 'type': 'SecretBase'},
        'update_resource_endpoint': {'key': 'typeProperties.updateResourceEndpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        ml_endpoint: object,
        api_key: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        update_resource_endpoint: Optional[object] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureML'  # type: str
        self.ml_endpoint = ml_endpoint
        self.api_key = api_key
        self.update_resource_endpoint = update_resource_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLServiceLinkedService(LinkedService):
    """Azure ML Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param subscription_id: Required. Azure ML Service workspace subscription ID. Type: string (or
     Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Required. Azure ML Service workspace resource group name. Type:
     string (or Expression with resultType string).
    :type resource_group_name: object
    :param ml_workspace_name: Required. Azure ML Service workspace name. Type: string (or
     Expression with resultType string).
    :type ml_workspace_name: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
     string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'ml_workspace_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'ml_workspace_name': {'key': 'typeProperties.mlWorkspaceName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        subscription_id: object,
        resource_group_name: object,
        ml_workspace_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLServiceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMLService'  # type: str
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.ml_workspace_name = ml_workspace_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLUpdateResourceActivity(ExecutionActivity):
    """Azure ML Update Resource management activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param trained_model_name: Required. Name of the Trained Model module in the Web Service
     experiment to be updated. Type: string (or Expression with resultType string).
    :type trained_model_name: object
    :param trained_model_linked_service_name: Required. Name of Azure Storage linked service
     holding the .ilearner file that will be uploaded by the update operation.
    :type trained_model_linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param trained_model_file_path: Required. The relative file path in trainedModelLinkedService
     to represent the .ilearner file that will be uploaded by the update operation.  Type: string
     (or Expression with resultType string).
    :type trained_model_file_path: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'trained_model_name': {'required': True},
        'trained_model_linked_service_name': {'required': True},
        'trained_model_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'trained_model_name': {'key': 'typeProperties.trainedModelName', 'type': 'object'},
        'trained_model_linked_service_name': {'key': 'typeProperties.trainedModelLinkedServiceName', 'type': 'LinkedServiceReference'},
        'trained_model_file_path': {'key': 'typeProperties.trainedModelFilePath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        trained_model_name: object,
        trained_model_linked_service_name: "LinkedServiceReference",
        trained_model_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(AzureMLUpdateResourceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'AzureMLUpdateResource'  # type: str
        self.trained_model_name = trained_model_name
        self.trained_model_linked_service_name = trained_model_linked_service_name
        self.trained_model_file_path = trained_model_file_path


class AzureMLWebServiceFile(msrest.serialization.Model):
    """Azure ML WebService Input/Output file.

    All required parameters must be populated in order to send to Azure.

    :param file_path: Required. The relative file path, including container name, in the Azure Blob
     Storage specified by the LinkedService. Type: string (or Expression with resultType string).
    :type file_path: object
    :param linked_service_name: Required. Reference to an Azure Storage LinkedService, where Azure
     ML WebService Input/Output file located.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'file_path': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'file_path': {'key': 'filePath', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        file_path: object,
        linked_service_name: "LinkedServiceReference",
        **kwargs
    ):
        super(AzureMLWebServiceFile, self).__init__(**kwargs)
        self.file_path = file_path
        self.linked_service_name = linked_service_name


class AzureMySqlLinkedService(LinkedService):
    """Azure MySQL database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureMySql'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzureMySqlSink(CopySink):
    """A copy activity Azure MySql sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        pre_copy_script: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureMySqlSink'  # type: str
        self.pre_copy_script = pre_copy_script


class AzureMySqlSource(TabularSource):
    """A copy activity Azure MySQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureMySqlSource'  # type: str
        self.query = query


class AzureMySqlTableDataset(Dataset):
    """The Azure MySQL database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The Azure MySQL database table name. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param table: The name of Azure MySQL database table. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureMySqlTable'  # type: str
        self.table_name = table_name
        self.table = table


class AzurePostgreSqlLinkedService(LinkedService):
    """Azure PostgreSQL linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzurePostgreSql'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzurePostgreSqlSink(CopySink):
    """A copy activity Azure PostgreSQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        pre_copy_script: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzurePostgreSqlSink'  # type: str
        self.pre_copy_script = pre_copy_script


class AzurePostgreSqlSource(TabularSource):
    """A copy activity Azure PostgreSQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzurePostgreSqlSource'  # type: str
        self.query = query


class AzurePostgreSqlTableDataset(Dataset):
    """Azure PostgreSQL dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name of the Azure PostgreSQL database which includes both schema
     and table. Type: string (or Expression with resultType string).
    :type table_name: object
    :param table: The table name of the Azure PostgreSQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzurePostgreSqlTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AzureQueueSink(CopySink):
    """A copy activity Azure Queue sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(AzureQueueSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureQueueSink'  # type: str


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param index_name: Required. The name of the Azure Search Index. Type: string (or Expression
     with resultType string).
    :type index_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'index_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'index_name': {'key': 'typeProperties.indexName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        index_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureSearchIndexDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSearchIndex'  # type: str
        self.index_name = index_name


class AzureSearchIndexSink(CopySink):
    """A copy activity Azure Search Index sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Specify the write behavior when upserting documents into Azure Search
     Index. Possible values include: "Merge", "Upload".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.AzureSearchIndexWriteBehaviorType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        write_behavior: Optional[Union[str, "AzureSearchIndexWriteBehaviorType"]] = None,
        **kwargs
    ):
        super(AzureSearchIndexSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureSearchIndexSink'  # type: str
        self.write_behavior = write_behavior


class AzureSearchLinkedService(LinkedService):
    """Linked service for Windows Azure Search Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. URL for Azure Search service. Type: string (or Expression with resultType
     string).
    :type url: object
    :param key: Admin Key for Azure Search service.
    :type key: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSearchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSearch'  # type: str
        self.url = url
        self.key = key
        self.encrypted_credential = encrypted_credential


class AzureSqlDatabaseLinkedService(LinkedService):
    """Microsoft Azure SQL Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Database. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Database.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlDatabase'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential


class AzureSqlDWLinkedService(LinkedService):
    """Azure SQL Data Warehouse linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDWLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlDW'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential


class AzureSqlDWTableDataset(Dataset):
    """The Azure SQL Data Warehouse dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDWTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlDWTable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlMILinkedService(LinkedService):
    """Azure SQL Managed Instance linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Managed Instance. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Managed Instance.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlMILinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureSqlMI'  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential


class AzureSqlMITableDataset(Dataset):
    """The Azure SQL Managed Instance dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Managed Instance. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
     Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlMITableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlMITable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlSink(CopySink):
    """A copy activity Azure SQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param sql_writer_stored_procedure_name: SQL writer stored procedure name. Type: string (or
     Expression with resultType string).
    :type sql_writer_stored_procedure_name: object
    :param sql_writer_table_type: SQL writer table type. Type: string (or Expression with
     resultType string).
    :type sql_writer_table_type: object
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: object
    :param stored_procedure_parameters: SQL stored procedure parameters.
    :type stored_procedure_parameters: dict[str,
     ~azure.mgmt.datafactory.models.StoredProcedureParameter]
    :param stored_procedure_table_type_parameter_name: The stored procedure parameter name of the
     table type. Type: string (or Expression with resultType string).
    :type stored_procedure_table_type_parameter_name: object
    :param table_option: The option to handle sink table, such as autoCreate. For now only
     'autoCreate' value is supported. Type: string (or Expression with resultType string).
    :type table_option: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'sql_writer_stored_procedure_name': {'key': 'sqlWriterStoredProcedureName', 'type': 'object'},
        'sql_writer_table_type': {'key': 'sqlWriterTableType', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'stored_procedure_table_type_parameter_name': {'key': 'storedProcedureTableTypeParameterName', 'type': 'object'},
        'table_option': {'key': 'tableOption', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        sql_writer_stored_procedure_name: Optional[object] = None,
        sql_writer_table_type: Optional[object] = None,
        pre_copy_script: Optional[object] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        stored_procedure_table_type_parameter_name: Optional[object] = None,
        table_option: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureSqlSink'  # type: str
        self.sql_writer_stored_procedure_name = sql_writer_stored_procedure_name
        self.sql_writer_table_type = sql_writer_table_type
        self.pre_copy_script = pre_copy_script
        self.stored_procedure_parameters = stored_procedure_parameters
        self.stored_procedure_table_type_parameter_name = stored_procedure_table_type_parameter_name
        self.table_option = table_option


class AzureSqlSource(TabularSource):
    """A copy activity Azure SQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :type sql_reader_query: object
    :param sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
     source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
     with resultType string).
    :type sql_reader_stored_procedure_name: object
    :param stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict[str,
     ~azure.mgmt.datafactory.models.StoredProcedureParameter]
    :param produce_additional_types: Which additional types to produce.
    :type produce_additional_types: object
    :param partition_option: The partition mechanism that will be used for Sql read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :type partition_option: object
    :param partition_settings: The settings that will be leveraged for Sql source partitioning.
    :type partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'sql_reader_query': {'key': 'sqlReaderQuery', 'type': 'object'},
        'sql_reader_stored_procedure_name': {'key': 'sqlReaderStoredProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'produce_additional_types': {'key': 'produceAdditionalTypes', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'object'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'SqlPartitionSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        sql_reader_query: Optional[object] = None,
        sql_reader_stored_procedure_name: Optional[object] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        produce_additional_types: Optional[object] = None,
        partition_option: Optional[object] = None,
        partition_settings: Optional["SqlPartitionSettings"] = None,
        **kwargs
    ):
        super(AzureSqlSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureSqlSource'  # type: str
        self.sql_reader_query = sql_reader_query
        self.sql_reader_stored_procedure_name = sql_reader_stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.produce_additional_types = produce_additional_types
        self.partition_option = partition_option
        self.partition_settings = partition_settings


class AzureSqlTableDataset(Dataset):
    """The Azure SQL Server database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureSqlTable'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureStorageLinkedService(LinkedService):
    """The storage account linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class AzureTableDataset(Dataset):
    """The Azure Table storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: Required. The table name of the Azure Table storage. Type: string (or
     Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        table_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'AzureTable'  # type: str
        self.table_name = table_name


class AzureTableSink(CopySink):
    """A copy activity Azure Table sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param azure_table_default_partition_key_value: Azure Table default partition key value. Type:
     string (or Expression with resultType string).
    :type azure_table_default_partition_key_value: object
    :param azure_table_partition_key_name: Azure Table partition key name. Type: string (or
     Expression with resultType string).
    :type azure_table_partition_key_name: object
    :param azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with
     resultType string).
    :type azure_table_row_key_name: object
    :param azure_table_insert_type: Azure Table insert type. Type: string (or Expression with
     resultType string).
    :type azure_table_insert_type: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'azure_table_default_partition_key_value': {'key': 'azureTableDefaultPartitionKeyValue', 'type': 'object'},
        'azure_table_partition_key_name': {'key': 'azureTablePartitionKeyName', 'type': 'object'},
        'azure_table_row_key_name': {'key': 'azureTableRowKeyName', 'type': 'object'},
        'azure_table_insert_type': {'key': 'azureTableInsertType', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        azure_table_default_partition_key_value: Optional[object] = None,
        azure_table_partition_key_name: Optional[object] = None,
        azure_table_row_key_name: Optional[object] = None,
        azure_table_insert_type: Optional[object] = None,
        **kwargs
    ):
        super(AzureTableSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'AzureTableSink'  # type: str
        self.azure_table_default_partition_key_value = azure_table_default_partition_key_value
        self.azure_table_partition_key_name = azure_table_partition_key_name
        self.azure_table_row_key_name = azure_table_row_key_name
        self.azure_table_insert_type = azure_table_insert_type


class AzureTableSource(TabularSource):
    """A copy activity Azure Table source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param azure_table_source_query: Azure Table source query. Type: string (or Expression with
     resultType string).
    :type azure_table_source_query: object
    :param azure_table_source_ignore_table_not_found: Azure Table source ignore table not found.
     Type: boolean (or Expression with resultType boolean).
    :type azure_table_source_ignore_table_not_found: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'azure_table_source_query': {'key': 'azureTableSourceQuery', 'type': 'object'},
        'azure_table_source_ignore_table_not_found': {'key': 'azureTableSourceIgnoreTableNotFound', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        azure_table_source_query: Optional[object] = None,
        azure_table_source_ignore_table_not_found: Optional[object] = None,
        **kwargs
    ):
        super(AzureTableSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'AzureTableSource'  # type: str
        self.azure_table_source_query = azure_table_source_query
        self.azure_table_source_ignore_table_not_found = azure_table_source_ignore_table_not_found


class AzureTableStorageLinkedService(LinkedService):
    """The azure table storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureTableStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'AzureTableStorage'  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class BinaryDataset(Dataset):
    """Binary dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the Binary storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param compression: The data compression method used for the binary dataset.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(BinaryDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Binary'  # type: str
        self.location = location
        self.compression = compression


class FormatReadSettings(msrest.serialization.Model):
    """Format read settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BinaryReadSettings, DelimitedTextReadSettings, JsonReadSettings, XmlReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BinaryReadSettings': 'BinaryReadSettings', 'DelimitedTextReadSettings': 'DelimitedTextReadSettings', 'JsonReadSettings': 'JsonReadSettings', 'XmlReadSettings': 'XmlReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(FormatReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'FormatReadSettings'  # type: str


class BinaryReadSettings(FormatReadSettings):
    """Binary read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param compression_properties: Compression settings.
    :type compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'compression_properties': {'key': 'compressionProperties', 'type': 'CompressionReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        compression_properties: Optional["CompressionReadSettings"] = None,
        **kwargs
    ):
        super(BinaryReadSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'BinaryReadSettings'  # type: str
        self.compression_properties = compression_properties


class BinarySink(CopySink):
    """A copy activity Binary sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        **kwargs
    ):
        super(BinarySink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'BinarySink'  # type: str
        self.store_settings = store_settings


class BinarySource(CopySource):
    """A copy activity Binary source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: Binary format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.BinaryReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'BinaryReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["BinaryReadSettings"] = None,
        **kwargs
    ):
        super(BinarySource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'BinarySource'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class Trigger(msrest.serialization.Model):
    """Azure data factory nested object which contains information about creating pipeline run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ChainingTrigger, MultiplePipelineTrigger, RerunTumblingWindowTrigger, TumblingWindowTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'ChainingTrigger': 'ChainingTrigger', 'MultiplePipelineTrigger': 'MultiplePipelineTrigger', 'RerunTumblingWindowTrigger': 'RerunTumblingWindowTrigger', 'TumblingWindowTrigger': 'TumblingWindowTrigger'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'Trigger'  # type: str
        self.description = description
        self.runtime_state = None
        self.annotations = annotations


class MultiplePipelineTrigger(Trigger):
    """Base class for all triggers that support one to many model for trigger to pipeline.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BlobEventsTrigger, BlobTrigger, CustomEventsTrigger, ScheduleTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
    }

    _subtype_map = {
        'type': {'BlobEventsTrigger': 'BlobEventsTrigger', 'BlobTrigger': 'BlobTrigger', 'CustomEventsTrigger': 'CustomEventsTrigger', 'ScheduleTrigger': 'ScheduleTrigger'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        **kwargs
    ):
        super(MultiplePipelineTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type = 'MultiplePipelineTrigger'  # type: str
        self.pipelines = pipelines


class BlobEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a Blob event occurs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param blob_path_begins_with: The blob path must begin with the pattern provided for trigger to
     fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the
     december folder under the records container. At least one of these must be provided:
     blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_begins_with: str
    :param blob_path_ends_with: The blob path must end with the pattern provided for trigger to
     fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a
     december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_ends_with: str
    :param ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
    :type ignore_empty_blobs: bool
    :param events: Required. The type of events that cause this trigger to fire.
    :type events: list[str or ~azure.mgmt.datafactory.models.BlobEventTypesEnum]
    :param scope: Required. The ARM resource ID of the Storage Account.
    :type scope: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'events': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'blob_path_begins_with': {'key': 'typeProperties.blobPathBeginsWith', 'type': 'str'},
        'blob_path_ends_with': {'key': 'typeProperties.blobPathEndsWith', 'type': 'str'},
        'ignore_empty_blobs': {'key': 'typeProperties.ignoreEmptyBlobs', 'type': 'bool'},
        'events': {'key': 'typeProperties.events', 'type': '[str]'},
        'scope': {'key': 'typeProperties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        events: List[Union[str, "BlobEventTypesEnum"]],
        scope: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        blob_path_begins_with: Optional[str] = None,
        blob_path_ends_with: Optional[str] = None,
        ignore_empty_blobs: Optional[bool] = None,
        **kwargs
    ):
        super(BlobEventsTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'BlobEventsTrigger'  # type: str
        self.blob_path_begins_with = blob_path_begins_with
        self.blob_path_ends_with = blob_path_ends_with
        self.ignore_empty_blobs = ignore_empty_blobs
        self.events = events
        self.scope = scope


class BlobSink(CopySink):
    """A copy activity Azure Blob sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression
     with resultType boolean).
    :type blob_writer_overwrite_files: object
    :param blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression
     with resultType string).
    :type blob_writer_date_time_format: object
    :param blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with
     resultType boolean).
    :type blob_writer_add_header: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'blob_writer_overwrite_files': {'key': 'blobWriterOverwriteFiles', 'type': 'object'},
        'blob_writer_date_time_format': {'key': 'blobWriterDateTimeFormat', 'type': 'object'},
        'blob_writer_add_header': {'key': 'blobWriterAddHeader', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        blob_writer_overwrite_files: Optional[object] = None,
        blob_writer_date_time_format: Optional[object] = None,
        blob_writer_add_header: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(BlobSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'BlobSink'  # type: str
        self.blob_writer_overwrite_files = blob_writer_overwrite_files
        self.blob_writer_date_time_format = blob_writer_date_time_format
        self.blob_writer_add_header = blob_writer_add_header
        self.copy_behavior = copy_behavior


class BlobSource(CopySource):
    """A copy activity Azure Blob source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: object
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        treat_empty_as_null: Optional[object] = None,
        skip_header_line_count: Optional[object] = None,
        recursive: Optional[object] = None,
        **kwargs
    ):
        super(BlobSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'BlobSource'  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class BlobTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time the selected Blob container changes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param folder_path: Required. The path of the container/folder that will trigger the pipeline.
    :type folder_path: str
    :param max_concurrency: Required. The max number of parallel files to handle when it is
     triggered.
    :type max_concurrency: int
    :param linked_service: Required. The Azure Storage linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'folder_path': {'required': True},
        'max_concurrency': {'required': True},
        'linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'str'},
        'max_concurrency': {'key': 'typeProperties.maxConcurrency', 'type': 'int'},
        'linked_service': {'key': 'typeProperties.linkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        folder_path: str,
        max_concurrency: int,
        linked_service: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        **kwargs
    ):
        super(BlobTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'BlobTrigger'  # type: str
        self.folder_path = folder_path
        self.max_concurrency = max_concurrency
        self.linked_service = linked_service


class CassandraLinkedService(LinkedService):
    """Linked service for Cassandra data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name for connection. Type: string (or Expression with resultType
     string).
    :type host: object
    :param authentication_type: AuthenticationType to be used for connection. Type: string (or
     Expression with resultType string).
    :type authentication_type: object
    :param port: The port for the connection. Type: integer (or Expression with resultType
     integer).
    :type port: object
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        port: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CassandraLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Cassandra'  # type: str
        self.host = host
        self.authentication_type = authentication_type
        self.port = port
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class CassandraSource(TabularSource):
    """A copy activity source for a Cassandra database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: Database query. Should be a SQL-92 query expression or Cassandra Query Language
     (CQL) command. Type: string (or Expression with resultType string).
    :type query: object
    :param consistency_level: The consistency level specifies how many Cassandra servers must
     respond to a read request before returning data to the client application. Cassandra checks the
     specified number of Cassandra servers for data to satisfy the read request. Must be one of
     cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
     Possible values include: "ALL", "EACH_QUORUM", "QUORUM", "LOCAL_QUORUM", "ONE", "TWO", "THREE",
     "LOCAL_ONE", "SERIAL", "LOCAL_SERIAL".
    :type consistency_level: str or
     ~azure.mgmt.datafactory.models.CassandraSourceReadConsistencyLevels
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
        'consistency_level': {'key': 'consistencyLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        consistency_level: Optional[Union[str, "CassandraSourceReadConsistencyLevels"]] = None,
        **kwargs
    ):
        super(CassandraSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'CassandraSource'  # type: str
        self.query = query
        self.consistency_level = consistency_level


class CassandraTableDataset(Dataset):
    """The Cassandra database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type keyspace: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'keyspace': {'key': 'typeProperties.keyspace', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        keyspace: Optional[object] = None,
        **kwargs
    ):
        super(CassandraTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CassandraTable'  # type: str
        self.table_name = table_name
        self.keyspace = keyspace


class ChainingTrigger(Trigger):
    """Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipeline: Required. Pipeline for which runs are created when all upstream pipelines
     complete successfully.
    :type pipeline: ~azure.mgmt.datafactory.models.TriggerPipelineReference
    :param depends_on: Required. Upstream Pipelines.
    :type depends_on: list[~azure.mgmt.datafactory.models.PipelineReference]
    :param run_dimension: Required. Run Dimension property that needs to be emitted by upstream
     pipelines.
    :type run_dimension: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'pipeline': {'required': True},
        'depends_on': {'required': True},
        'run_dimension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipeline': {'key': 'pipeline', 'type': 'TriggerPipelineReference'},
        'depends_on': {'key': 'typeProperties.dependsOn', 'type': '[PipelineReference]'},
        'run_dimension': {'key': 'typeProperties.runDimension', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pipeline: "TriggerPipelineReference",
        depends_on: List["PipelineReference"],
        run_dimension: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(ChainingTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type = 'ChainingTrigger'  # type: str
        self.pipeline = pipeline
        self.depends_on = depends_on
        self.run_dimension = run_dimension


class CloudError(msrest.serialization.Model):
    """The object that defines the structure of an Azure Data Factory error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.mgmt.datafactory.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["CloudError"]] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CmdkeySetup(CustomSetupBase):
    """The custom setup of running cmdkey commands.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param target_name: Required. The server name of data source access.
    :type target_name: object
    :param user_name: Required. The user name of data source access.
    :type user_name: object
    :param password: Required. The password of data source access.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'target_name': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'target_name': {'key': 'typeProperties.targetName', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        target_name: object,
        user_name: object,
        password: "SecretBase",
        **kwargs
    ):
        super(CmdkeySetup, self).__init__(**kwargs)
        self.type = 'CmdkeySetup'  # type: str
        self.target_name = target_name
        self.user_name = user_name
        self.password = password


class CMKIdentityDefinition(msrest.serialization.Model):
    """Managed Identity used for CMK.

    :param user_assigned_identity: The resource id of the user assigned identity to authenticate to
     customer's key vault.
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        super(CMKIdentityDefinition, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class CommonDataServiceForAppsEntityDataset(Dataset):
    """The Common Data Service for Apps entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CommonDataServiceForAppsEntity'  # type: str
        self.entity_name = entity_name


class CommonDataServiceForAppsLinkedService(LinkedService):
    """Common Data Service for Apps linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Common Data Service for Apps
     instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common
     Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType
     string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.mgmt.datafactory.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Common Data Service for Apps server. The
     property is required for on-prem and not allowed for online. Type: string (or Expression with
     resultType string).
    :type host_name: object
    :param port: The port of on-premises Common Data Service for Apps server. The property is
     required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
     with resultType integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Common Data Service for Apps server. The property
     is required for on-line and not allowed for on-prem. Type: string (or Expression with
     resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Common Data Service for Apps instance.
     The property is required for on-prem and required for online when there are more than one
     Common Data Service for Apps instances associated with the user. Type: string (or Expression
     with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Common Data Service
     for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.DynamicsAuthenticationType
    :param username: User name to access the Common Data Service for Apps instance. Type: string
     (or Expression with resultType string).
    :type username: object
    :param password: Password to access the Common Data Service for Apps instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[object] = None,
        port: Optional[object] = None,
        service_uri: Optional[object] = None,
        organization_name: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CommonDataServiceForApps'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class CommonDataServiceForAppsSink(CopySink):
    """A copy activity Common Data Service for Apps sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        ignore_null_values: Optional[object] = None,
        alternate_key_name: Optional[object] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CommonDataServiceForAppsSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class CommonDataServiceForAppsSource(CopySource):
    """A copy activity Common Data Service for Apps source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Common Data
     Service for Apps (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CommonDataServiceForAppsSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class ComponentSetup(CustomSetupBase):
    """The custom setup of installing 3rd party components.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param component_name: Required. The name of the 3rd party component.
    :type component_name: str
    :param license_key: The license key to activate the component.
    :type license_key: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'component_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'component_name': {'key': 'typeProperties.componentName', 'type': 'str'},
        'license_key': {'key': 'typeProperties.licenseKey', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        component_name: str,
        license_key: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(ComponentSetup, self).__init__(**kwargs)
        self.type = 'ComponentSetup'  # type: str
        self.component_name = component_name
        self.license_key = license_key


class CompressionReadSettings(msrest.serialization.Model):
    """Compression read settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TarGZipReadSettings, TarReadSettings, ZipDeflateReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The Compression setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'TarGZipReadSettings': 'TarGZipReadSettings', 'TarReadSettings': 'TarReadSettings', 'ZipDeflateReadSettings': 'ZipDeflateReadSettings'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(CompressionReadSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CompressionReadSettings'  # type: str


class ConcurLinkedService(LinkedService):
    """Concur Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_properties: Properties used to connect to Concur. It is mutually exclusive
     with any other properties in the linked service. Type: object.
    :type connection_properties: object
    :param client_id: Required. Application client_id supplied by Concur App Management.
    :type client_id: object
    :param username: Required. The user name that you use to access Concur Service.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_properties': {'key': 'typeProperties.connectionProperties', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_id: object,
        username: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_properties: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ConcurLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Concur'  # type: str
        self.connection_properties = connection_properties
        self.client_id = client_id
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ConcurObjectDataset(Dataset):
    """Concur Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(ConcurObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'ConcurObject'  # type: str
        self.table_name = table_name


class ConcurSource(TabularSource):
    """A copy activity Concur Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(ConcurSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'ConcurSource'  # type: str
        self.query = query


class ConnectionStateProperties(msrest.serialization.Model):
    """The connection state of a managed private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar actions_required: The actions required on the managed private endpoint.
    :vartype actions_required: str
    :ivar description: The managed private endpoint description.
    :vartype description: str
    :ivar status: The approval status.
    :vartype status: str
    """

    _validation = {
        'actions_required': {'readonly': True},
        'description': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionStateProperties, self).__init__(**kwargs)
        self.actions_required = None
        self.description = None
        self.status = None


class ControlActivity(Activity):
    """Base class for all control activities like IfCondition, ForEach , Until.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(ControlActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Container'  # type: str


class CopyActivity(ExecutionActivity):
    """Copy activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param inputs: List of inputs for the activity.
    :type inputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :param outputs: List of outputs for the activity.
    :type outputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :param source: Required. Copy activity source.
    :type source: ~azure.mgmt.datafactory.models.CopySource
    :param sink: Required. Copy activity sink.
    :type sink: ~azure.mgmt.datafactory.models.CopySink
    :param translator: Copy activity translator. If not specified, tabular translator is used.
    :type translator: object
    :param enable_staging: Specifies whether to copy data via an interim staging. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type enable_staging: object
    :param staging_settings: Specifies interim staging settings when EnableStaging is true.
    :type staging_settings: ~azure.mgmt.datafactory.models.StagingSettings
    :param parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
     avoid overloading the data store. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type parallel_copies: object
    :param data_integration_units: Maximum number of data integration units that can be used to
     perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
    :type data_integration_units: object
    :param enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false.
     Type: boolean (or Expression with resultType boolean).
    :type enable_skip_incompatible_row: object
    :param redirect_incompatible_row_settings: Redirect incompatible row settings when
     EnableSkipIncompatibleRow is true.
    :type redirect_incompatible_row_settings:
     ~azure.mgmt.datafactory.models.RedirectIncompatibleRowSettings
    :param log_storage_settings: (Deprecated. Please use LogSettings) Log storage settings customer
     need to provide when enabling session log.
    :type log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
    :param log_settings: Log settings customer needs provide when enabling log.
    :type log_settings: ~azure.mgmt.datafactory.models.LogSettings
    :param preserve_rules: Preserve Rules.
    :type preserve_rules: list[object]
    :param preserve: Preserve rules.
    :type preserve: list[object]
    :param validate_data_consistency: Whether to enable Data Consistency validation. Type: boolean
     (or Expression with resultType boolean).
    :type validate_data_consistency: object
    :param skip_error_file: Specify the fault tolerance for data consistency.
    :type skip_error_file: ~azure.mgmt.datafactory.models.SkipErrorFile
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'sink': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'inputs': {'key': 'inputs', 'type': '[DatasetReference]'},
        'outputs': {'key': 'outputs', 'type': '[DatasetReference]'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'sink': {'key': 'typeProperties.sink', 'type': 'CopySink'},
        'translator': {'key': 'typeProperties.translator', 'type': 'object'},
        'enable_staging': {'key': 'typeProperties.enableStaging', 'type': 'object'},
        'staging_settings': {'key': 'typeProperties.stagingSettings', 'type': 'StagingSettings'},
        'parallel_copies': {'key': 'typeProperties.parallelCopies', 'type': 'object'},
        'data_integration_units': {'key': 'typeProperties.dataIntegrationUnits', 'type': 'object'},
        'enable_skip_incompatible_row': {'key': 'typeProperties.enableSkipIncompatibleRow', 'type': 'object'},
        'redirect_incompatible_row_settings': {'key': 'typeProperties.redirectIncompatibleRowSettings', 'type': 'RedirectIncompatibleRowSettings'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'log_settings': {'key': 'typeProperties.logSettings', 'type': 'LogSettings'},
        'preserve_rules': {'key': 'typeProperties.preserveRules', 'type': '[object]'},
        'preserve': {'key': 'typeProperties.preserve', 'type': '[object]'},
        'validate_data_consistency': {'key': 'typeProperties.validateDataConsistency', 'type': 'object'},
        'skip_error_file': {'key': 'typeProperties.skipErrorFile', 'type': 'SkipErrorFile'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: "CopySource",
        sink: "CopySink",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        inputs: Optional[List["DatasetReference"]] = None,
        outputs: Optional[List["DatasetReference"]] = None,
        translator: Optional[object] = None,
        enable_staging: Optional[object] = None,
        staging_settings: Optional["StagingSettings"] = None,
        parallel_copies: Optional[object] = None,
        data_integration_units: Optional[object] = None,
        enable_skip_incompatible_row: Optional[object] = None,
        redirect_incompatible_row_settings: Optional["RedirectIncompatibleRowSettings"] = None,
        log_storage_settings: Optional["LogStorageSettings"] = None,
        log_settings: Optional["LogSettings"] = None,
        preserve_rules: Optional[List[object]] = None,
        preserve: Optional[List[object]] = None,
        validate_data_consistency: Optional[object] = None,
        skip_error_file: Optional["SkipErrorFile"] = None,
        **kwargs
    ):
        super(CopyActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Copy'  # type: str
        self.inputs = inputs
        self.outputs = outputs
        self.source = source
        self.sink = sink
        self.translator = translator
        self.enable_staging = enable_staging
        self.staging_settings = staging_settings
        self.parallel_copies = parallel_copies
        self.data_integration_units = data_integration_units
        self.enable_skip_incompatible_row = enable_skip_incompatible_row
        self.redirect_incompatible_row_settings = redirect_incompatible_row_settings
        self.log_storage_settings = log_storage_settings
        self.log_settings = log_settings
        self.preserve_rules = preserve_rules
        self.preserve = preserve
        self.validate_data_consistency = validate_data_consistency
        self.skip_error_file = skip_error_file


class CopyActivityLogSettings(msrest.serialization.Model):
    """Settings for copy activity log.

    :param log_level: Gets or sets the log level, support: Info, Warning. Type: string (or
     Expression with resultType string).
    :type log_level: object
    :param enable_reliable_logging: Specifies whether to enable reliable logging. Type: boolean (or
     Expression with resultType boolean).
    :type enable_reliable_logging: object
    """

    _attribute_map = {
        'log_level': {'key': 'logLevel', 'type': 'object'},
        'enable_reliable_logging': {'key': 'enableReliableLogging', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        log_level: Optional[object] = None,
        enable_reliable_logging: Optional[object] = None,
        **kwargs
    ):
        super(CopyActivityLogSettings, self).__init__(**kwargs)
        self.log_level = log_level
        self.enable_reliable_logging = enable_reliable_logging


class CopyTranslator(msrest.serialization.Model):
    """A copy activity translator.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TabularTranslator.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy translator type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'TabularTranslator': 'TabularTranslator'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(CopyTranslator, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'CopyTranslator'  # type: str


class CosmosDbLinkedService(LinkedService):
    """Microsoft Azure Cosmos Database (CosmosDB) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or
     Expression with resultType string).
    :type account_endpoint: object
    :param database: The name of the database. Type: string (or Expression with resultType string).
    :type database: object
    :param account_key: The account key of the Azure CosmosDB account. Type: SecureString or
     AzureKeyVaultSecretReference.
    :type account_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.CosmosDbServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :type azure_cloud_type: object
    :param connection_mode: The connection mode used to access CosmosDB account. Type: string (or
     Expression with resultType string). Possible values include: "Gateway", "Direct".
    :type connection_mode: str or ~azure.mgmt.datafactory.models.CosmosDbConnectionMode
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_endpoint': {'key': 'typeProperties.accountEndpoint', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'azure_cloud_type': {'key': 'typeProperties.azureCloudType', 'type': 'object'},
        'connection_mode': {'key': 'typeProperties.connectionMode', 'type': 'str'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_endpoint: Optional[object] = None,
        database: Optional[object] = None,
        account_key: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "CosmosDbServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        azure_cloud_type: Optional[object] = None,
        connection_mode: Optional[Union[str, "CosmosDbConnectionMode"]] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CosmosDbLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CosmosDb'  # type: str
        self.connection_string = connection_string
        self.account_endpoint = account_endpoint
        self.database = database
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.connection_mode = connection_mode
        self.encrypted_credential = encrypted_credential


class CosmosDbMongoDbApiCollectionDataset(Dataset):
    """The CosmosDB (MongoDB API) database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection: Required. The collection name of the CosmosDB (MongoDB API) database. Type:
     string (or Expression with resultType string).
    :type collection: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CosmosDbMongoDbApiCollection'  # type: str
        self.collection = collection


class CosmosDbMongoDbApiLinkedService(LinkedService):
    """Linked service for CosmosDB (MongoDB API) data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The CosmosDB (MongoDB API) connection string. Type: string,
     SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param database: Required. The name of the CosmosDB (MongoDB API) database that you want to
     access. Type: string (or Expression with resultType string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CosmosDbMongoDbApi'  # type: str
        self.connection_string = connection_string
        self.database = database


class CosmosDbMongoDbApiSink(CopySink):
    """A copy activity sink for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Specifies whether the document with same key to be overwritten (upsert)
     rather than throw exception (insert). The default value is "insert". Type: string (or
     Expression with resultType string). Type: string (or Expression with resultType string).
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        write_behavior: Optional[object] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CosmosDbMongoDbApiSink'  # type: str
        self.write_behavior = write_behavior


class CosmosDbMongoDbApiSource(CopySource):
    """A copy activity source for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param filter: Specifies selection filter using query operators. To return all documents in a
     collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
     with resultType string).
    :type filter: object
    :param cursor_methods: Cursor methods for Mongodb query.
    :type cursor_methods: ~azure.mgmt.datafactory.models.MongoDbCursorMethodsProperties
    :param batch_size: Specifies the number of documents to return in each batch of the response
     from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
     application. This property's main purpose is to avoid hit the limitation of response size.
     Type: integer (or Expression with resultType integer).
    :type batch_size: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'filter': {'key': 'filter', 'type': 'object'},
        'cursor_methods': {'key': 'cursorMethods', 'type': 'MongoDbCursorMethodsProperties'},
        'batch_size': {'key': 'batchSize', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        filter: Optional[object] = None,
        cursor_methods: Optional["MongoDbCursorMethodsProperties"] = None,
        batch_size: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CosmosDbMongoDbApiSource'  # type: str
        self.filter = filter
        self.cursor_methods = cursor_methods
        self.batch_size = batch_size
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class CosmosDbSqlApiCollectionDataset(Dataset):
    """Microsoft Azure CosmosDB (SQL API) Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection_name: Required. CosmosDB (SQL API) collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CosmosDbSqlApiCollection'  # type: str
        self.collection_name = collection_name


class CosmosDbSqlApiSink(CopySink):
    """A copy activity Azure CosmosDB (SQL API) Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        write_behavior: Optional[object] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CosmosDbSqlApiSink'  # type: str
        self.write_behavior = write_behavior


class CosmosDbSqlApiSource(CopySource):
    """A copy activity Azure CosmosDB (SQL API) Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: SQL API query. Type: string (or Expression with resultType string).
    :type query: object
    :param page_size: Page size of the result. Type: integer (or Expression with resultType
     integer).
    :type page_size: object
    :param preferred_regions: Preferred regions. Type: array of strings (or Expression with
     resultType array of strings).
    :type preferred_regions: object
    :param detect_datetime: Whether detect primitive values as datetime values. Type: boolean (or
     Expression with resultType boolean).
    :type detect_datetime: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'page_size': {'key': 'pageSize', 'type': 'object'},
        'preferred_regions': {'key': 'preferredRegions', 'type': 'object'},
        'detect_datetime': {'key': 'detectDatetime', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        page_size: Optional[object] = None,
        preferred_regions: Optional[object] = None,
        detect_datetime: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'CosmosDbSqlApiSource'  # type: str
        self.query = query
        self.page_size = page_size
        self.preferred_regions = preferred_regions
        self.detect_datetime = detect_datetime
        self.additional_columns = additional_columns


class CouchbaseLinkedService(LinkedService):
    """Couchbase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param cred_string: The Azure key vault secret reference of credString in connection string.
    :type cred_string: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'cred_string': {'key': 'typeProperties.credString', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        cred_string: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CouchbaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Couchbase'  # type: str
        self.connection_string = connection_string
        self.cred_string = cred_string
        self.encrypted_credential = encrypted_credential


class CouchbaseSource(TabularSource):
    """A copy activity Couchbase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(CouchbaseSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'CouchbaseSource'  # type: str
        self.query = query


class CouchbaseTableDataset(Dataset):
    """Couchbase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(CouchbaseTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CouchbaseTable'  # type: str
        self.table_name = table_name


class CreateDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for creating data flow debug session.

    :param compute_type: Compute type of the cluster. The value will be overwritten by the same
     setting in integration runtime if provided.
    :type compute_type: str
    :param core_count: Core count of the cluster. The value will be overwritten by the same setting
     in integration runtime if provided.
    :type core_count: int
    :param time_to_live: Time to live setting of the cluster in minutes.
    :type time_to_live: int
    :param integration_runtime: Set to use integration runtime setting for data flow debug session.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeDebugResource
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'time_to_live': {'key': 'timeToLive', 'type': 'int'},
        'integration_runtime': {'key': 'integrationRuntime', 'type': 'IntegrationRuntimeDebugResource'},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        time_to_live: Optional[int] = None,
        integration_runtime: Optional["IntegrationRuntimeDebugResource"] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count
        self.time_to_live = time_to_live
        self.integration_runtime = integration_runtime


class CreateDataFlowDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for creating data flow debug session.

    :param status: The state of the debug session.
    :type status: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionResponse, self).__init__(**kwargs)
        self.status = status
        self.session_id = session_id


class CreateLinkedIntegrationRuntimeRequest(msrest.serialization.Model):
    """The linked integration runtime information.

    :param name: The name of the linked integration runtime.
    :type name: str
    :param subscription_id: The ID of the subscription that the linked integration runtime belongs
     to.
    :type subscription_id: str
    :param data_factory_name: The name of the data factory that the linked integration runtime
     belongs to.
    :type data_factory_name: str
    :param data_factory_location: The location of the data factory that the linked integration
     runtime belongs to.
    :type data_factory_location: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'data_factory_location': {'key': 'dataFactoryLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        subscription_id: Optional[str] = None,
        data_factory_name: Optional[str] = None,
        data_factory_location: Optional[str] = None,
        **kwargs
    ):
        super(CreateLinkedIntegrationRuntimeRequest, self).__init__(**kwargs)
        self.name = name
        self.subscription_id = subscription_id
        self.data_factory_name = data_factory_name
        self.data_factory_location = data_factory_location


class CreateRunResponse(msrest.serialization.Model):
    """Response body with a run identifier.

    All required parameters must be populated in order to send to Azure.

    :param run_id: Required. Identifier of a run.
    :type run_id: str
    """

    _validation = {
        'run_id': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: str,
        **kwargs
    ):
        super(CreateRunResponse, self).__init__(**kwargs)
        self.run_id = run_id


class CustomActivity(ExecutionActivity):
    """Custom activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param command: Required. Command for custom activity Type: string (or Expression with
     resultType string).
    :type command: object
    :param resource_linked_service: Resource linked service reference.
    :type resource_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param folder_path: Folder path for resource files Type: string (or Expression with resultType
     string).
    :type folder_path: object
    :param reference_objects: Reference objects.
    :type reference_objects: ~azure.mgmt.datafactory.models.CustomActivityReferenceObject
    :param extended_properties: User defined property bag. There is no restriction on the keys or
     values that can be used. The user specified custom activity has the full responsibility to
     consume and interpret the content defined.
    :type extended_properties: dict[str, object]
    :param retention_time_in_days: The retention time for the files submitted for custom activity.
     Type: double (or Expression with resultType double).
    :type retention_time_in_days: object
    :param auto_user_specification: Elevation level and scope for the user, default is nonadmin
     task. Type: string (or Expression with resultType double).
    :type auto_user_specification: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'resource_linked_service': {'key': 'typeProperties.resourceLinkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'reference_objects': {'key': 'typeProperties.referenceObjects', 'type': 'CustomActivityReferenceObject'},
        'extended_properties': {'key': 'typeProperties.extendedProperties', 'type': '{object}'},
        'retention_time_in_days': {'key': 'typeProperties.retentionTimeInDays', 'type': 'object'},
        'auto_user_specification': {'key': 'typeProperties.autoUserSpecification', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        resource_linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[object] = None,
        reference_objects: Optional["CustomActivityReferenceObject"] = None,
        extended_properties: Optional[Dict[str, object]] = None,
        retention_time_in_days: Optional[object] = None,
        auto_user_specification: Optional[object] = None,
        **kwargs
    ):
        super(CustomActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Custom'  # type: str
        self.command = command
        self.resource_linked_service = resource_linked_service
        self.folder_path = folder_path
        self.reference_objects = reference_objects
        self.extended_properties = extended_properties
        self.retention_time_in_days = retention_time_in_days
        self.auto_user_specification = auto_user_specification


class CustomActivityReferenceObject(msrest.serialization.Model):
    """Reference objects for custom activity.

    :param linked_services: Linked service references.
    :type linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param datasets: Dataset references.
    :type datasets: list[~azure.mgmt.datafactory.models.DatasetReference]
    """

    _attribute_map = {
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceReference]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
    }

    def __init__(
        self,
        *,
        linked_services: Optional[List["LinkedServiceReference"]] = None,
        datasets: Optional[List["DatasetReference"]] = None,
        **kwargs
    ):
        super(CustomActivityReferenceObject, self).__init__(**kwargs)
        self.linked_services = linked_services
        self.datasets = datasets


class CustomDataset(Dataset):
    """The custom dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param type_properties: Custom dataset properties.
    :type type_properties: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        type_properties: Optional[object] = None,
        **kwargs
    ):
        super(CustomDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'CustomDataset'  # type: str
        self.type_properties = type_properties


class CustomDataSourceLinkedService(LinkedService):
    """Custom linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param type_properties: Required. Custom linked service properties.
    :type type_properties: object
    """

    _validation = {
        'type': {'required': True},
        'type_properties': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type_properties: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(CustomDataSourceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'CustomDataSource'  # type: str
        self.type_properties = type_properties


class CustomEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a custom event is received.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param subject_begins_with: The event subject must begin with the pattern provided for trigger
     to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :type subject_begins_with: str
    :param subject_ends_with: The event subject must end with the pattern provided for trigger to
     fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :type subject_ends_with: str
    :param events: Required. The list of event types that cause this trigger to fire.
    :type events: list[object]
    :param scope: Required. The ARM resource ID of the Azure Event Grid Topic.
    :type scope: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'events': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'subject_begins_with': {'key': 'typeProperties.subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'typeProperties.subjectEndsWith', 'type': 'str'},
        'events': {'key': 'typeProperties.events', 'type': '[object]'},
        'scope': {'key': 'typeProperties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        events: List[object],
        scope: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        **kwargs
    ):
        super(CustomEventsTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, pipelines=pipelines, **kwargs)
        self.type = 'CustomEventsTrigger'  # type: str
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.events = events
        self.scope = scope


class DatabricksNotebookActivity(ExecutionActivity):
    """DatabricksNotebook activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param notebook_path: Required. The absolute path of the notebook to be run in the Databricks
     Workspace. This path must begin with a slash. Type: string (or Expression with resultType
     string).
    :type notebook_path: object
    :param base_parameters: Base parameters to be used for each run of this job.If the notebook
     takes a parameter that is not specified, the default value from the notebook will be used.
    :type base_parameters: dict[str, object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'notebook_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'notebook_path': {'key': 'typeProperties.notebookPath', 'type': 'object'},
        'base_parameters': {'key': 'typeProperties.baseParameters', 'type': '{object}'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        notebook_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        base_parameters: Optional[Dict[str, object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksNotebookActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksNotebook'  # type: str
        self.notebook_path = notebook_path
        self.base_parameters = base_parameters
        self.libraries = libraries


class DatabricksSparkJarActivity(ExecutionActivity):
    """DatabricksSparkJar activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param main_class_name: Required. The full name of the class containing the main method to be
     executed. This class must be contained in a JAR provided as a library. Type: string (or
     Expression with resultType string).
    :type main_class_name: object
    :param parameters: Parameters that will be passed to the main method.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'main_class_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'main_class_name': {'key': 'typeProperties.mainClassName', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        main_class_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksSparkJarActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksSparkJar'  # type: str
        self.main_class_name = main_class_name
        self.parameters = parameters
        self.libraries = libraries


class DatabricksSparkPythonActivity(ExecutionActivity):
    """DatabricksSparkPython activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param python_file: Required. The URI of the Python file to be executed. DBFS paths are
     supported. Type: string (or Expression with resultType string).
    :type python_file: object
    :param parameters: Command line parameters that will be passed to the Python file.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'python_file': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'python_file': {'key': 'typeProperties.pythonFile', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        python_file: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksSparkPythonActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DatabricksSparkPython'  # type: str
        self.python_file = python_file
        self.parameters = parameters
        self.libraries = libraries


class DataFlow(msrest.serialization.Model):
    """Azure Data Factory nested object which contains a flow with data movements and transformations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingDataFlow.

    :param type: Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[object]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.mgmt.datafactory.models.DataFlowFolder
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
    }

    _subtype_map = {
        'type': {'MappingDataFlow': 'MappingDataFlow'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DataFlowFolder"] = None,
        **kwargs
    ):
        super(DataFlow, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.description = description
        self.annotations = annotations
        self.folder = folder


class DataFlowDebugCommandPayload(msrest.serialization.Model):
    """Structure of command payload.

    All required parameters must be populated in order to send to Azure.

    :param stream_name: Required. The stream name which is used for preview.
    :type stream_name: str
    :param row_limits: Row limits for preview response.
    :type row_limits: int
    :param columns: Array of column names.
    :type columns: list[str]
    :param expression: The expression which is used for preview.
    :type expression: str
    """

    _validation = {
        'stream_name': {'required': True},
    }

    _attribute_map = {
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
        'columns': {'key': 'columns', 'type': '[str]'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        stream_name: str,
        row_limits: Optional[int] = None,
        columns: Optional[List[str]] = None,
        expression: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandPayload, self).__init__(**kwargs)
        self.stream_name = stream_name
        self.row_limits = row_limits
        self.columns = columns
        self.expression = expression


class DataFlowDebugCommandRequest(msrest.serialization.Model):
    """Request body structure for data flow debug command.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param command: The command type. Possible values include: "executePreviewQuery",
     "executeStatisticsQuery", "executeExpressionQuery".
    :type command: str or ~azure.mgmt.datafactory.models.DataFlowDebugCommandType
    :param command_payload: The command payload object.
    :type command_payload: ~azure.mgmt.datafactory.models.DataFlowDebugCommandPayload
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'command_payload': {'key': 'commandPayload', 'type': 'DataFlowDebugCommandPayload'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        command: Optional[Union[str, "DataFlowDebugCommandType"]] = None,
        command_payload: Optional["DataFlowDebugCommandPayload"] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.command = command
        self.command_payload = command_payload


class DataFlowDebugCommandResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandResponse, self).__init__(**kwargs)
        self.status = status
        self.data = data


class DataFlowDebugPackage(msrest.serialization.Model):
    """Request body structure for starting data flow debug session.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow: Data flow instance.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowDebugResource
    :param datasets: List of datasets.
    :type datasets: list[~azure.mgmt.datafactory.models.DatasetDebugResource]
    :param linked_services: List of linked services.
    :type linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceDebugResource]
    :param staging: Staging info for debug session.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param debug_settings: Data flow debug settings.
    :type debug_settings: ~azure.mgmt.datafactory.models.DataFlowDebugPackageDebugSettings
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowDebugResource'},
        'datasets': {'key': 'datasets', 'type': '[DatasetDebugResource]'},
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceDebugResource]'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'debug_settings': {'key': 'debugSettings', 'type': 'DataFlowDebugPackageDebugSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        session_id: Optional[str] = None,
        data_flow: Optional["DataFlowDebugResource"] = None,
        datasets: Optional[List["DatasetDebugResource"]] = None,
        linked_services: Optional[List["LinkedServiceDebugResource"]] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        debug_settings: Optional["DataFlowDebugPackageDebugSettings"] = None,
        **kwargs
    ):
        super(DataFlowDebugPackage, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.session_id = session_id
        self.data_flow = data_flow
        self.datasets = datasets
        self.linked_services = linked_services
        self.staging = staging
        self.debug_settings = debug_settings


class DataFlowDebugPackageDebugSettings(msrest.serialization.Model):
    """Data flow debug settings.

    :param source_settings: Source setting for data flow debug.
    :type source_settings: list[~azure.mgmt.datafactory.models.DataFlowSourceSetting]
    :param parameters: Data flow parameters.
    :type parameters: dict[str, object]
    :param dataset_parameters: Parameters for dataset.
    :type dataset_parameters: object
    """

    _attribute_map = {
        'source_settings': {'key': 'sourceSettings', 'type': '[DataFlowSourceSetting]'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        source_settings: Optional[List["DataFlowSourceSetting"]] = None,
        parameters: Optional[Dict[str, object]] = None,
        dataset_parameters: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowDebugPackageDebugSettings, self).__init__(**kwargs)
        self.source_settings = source_settings
        self.parameters = parameters
        self.dataset_parameters = dataset_parameters


class SubResourceDebugResource(msrest.serialization.Model):
    """Azure Data Factory nested debug resource.

    :param name: The resource name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubResourceDebugResource, self).__init__(**kwargs)
        self.name = name


class DataFlowDebugResource(SubResourceDebugResource):
    """Data flow debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DataFlowDebugSessionInfo(msrest.serialization.Model):
    """Data flow debug session info.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param compute_type: Compute type of the cluster.
    :type compute_type: str
    :param core_count: Core count of the cluster.
    :type core_count: int
    :param node_count: Node count of the cluster. (deprecated property).
    :type node_count: int
    :param integration_runtime_name: Attached integration runtime name of data flow debug session.
    :type integration_runtime_name: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param start_time: Start time of data flow debug session.
    :type start_time: str
    :param time_to_live_in_minutes: Compute type of the cluster.
    :type time_to_live_in_minutes: int
    :param last_activity_time: Last activity time of data flow debug session.
    :type last_activity_time: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'integration_runtime_name': {'key': 'integrationRuntimeName', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_to_live_in_minutes': {'key': 'timeToLiveInMinutes', 'type': 'int'},
        'last_activity_time': {'key': 'lastActivityTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        data_flow_name: Optional[str] = None,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        node_count: Optional[int] = None,
        integration_runtime_name: Optional[str] = None,
        session_id: Optional[str] = None,
        start_time: Optional[str] = None,
        time_to_live_in_minutes: Optional[int] = None,
        last_activity_time: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugSessionInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.data_flow_name = data_flow_name
        self.compute_type = compute_type
        self.core_count = core_count
        self.node_count = node_count
        self.integration_runtime_name = integration_runtime_name
        self.session_id = session_id
        self.start_time = start_time
        self.time_to_live_in_minutes = time_to_live_in_minutes
        self.last_activity_time = last_activity_time


class DataFlowFolder(msrest.serialization.Model):
    """The folder that this data flow is in. If not specified, Data flow will appear at the root level.

    :param name: The name of the folder that this data flow is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowFolder, self).__init__(**kwargs)
        self.name = name


class DataFlowListResponse(msrest.serialization.Model):
    """A list of data flow resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of data flows.
    :type value: list[~azure.mgmt.datafactory.models.DataFlowResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataFlowResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataFlowResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataFlowReference(msrest.serialization.Model):
    """Data flow reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar type: Required. Data flow reference type. Default value: "DataFlowReference".
    :vartype type: str
    :param reference_name: Required. Reference data flow name.
    :type reference_name: str
    :param dataset_parameters: Reference data flow parameters from dataset.
    :type dataset_parameters: object
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    type = "DataFlowReference"

    def __init__(
        self,
        *,
        reference_name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        dataset_parameters: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowReference, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.reference_name = reference_name
        self.dataset_parameters = dataset_parameters


class SubResource(msrest.serialization.Model):
    """Azure Data Factory nested resource, which belongs to a factory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class DataFlowResource(SubResource):
    """Data flow resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        **kwargs
    ):
        super(DataFlowResource, self).__init__(**kwargs)
        self.properties = properties


class Transformation(msrest.serialization.Model):
    """A data flow transformation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Transformation, self).__init__(**kwargs)
        self.name = name
        self.description = description


class DataFlowSink(Transformation):
    """Transformation for data flow sink.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param linked_service: Linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param schema_linked_service: Schema linked service reference.
    :type schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'schema_linked_service': {'key': 'schemaLinkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        linked_service: Optional["LinkedServiceReference"] = None,
        schema_linked_service: Optional["LinkedServiceReference"] = None,
        **kwargs
    ):
        super(DataFlowSink, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset
        self.linked_service = linked_service
        self.schema_linked_service = schema_linked_service


class DataFlowSource(Transformation):
    """Transformation for data flow source.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param linked_service: Linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param schema_linked_service: Schema linked service reference.
    :type schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'schema_linked_service': {'key': 'schemaLinkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        linked_service: Optional["LinkedServiceReference"] = None,
        schema_linked_service: Optional["LinkedServiceReference"] = None,
        **kwargs
    ):
        super(DataFlowSource, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset
        self.linked_service = linked_service
        self.schema_linked_service = schema_linked_service


class DataFlowSourceSetting(msrest.serialization.Model):
    """Definition of data flow source setting for debug.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param source_name: The data flow source name.
    :type source_name: str
    :param row_limit: Defines the row limit of data flow source in debug.
    :type row_limit: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'row_limit': {'key': 'rowLimit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_name: Optional[str] = None,
        row_limit: Optional[int] = None,
        **kwargs
    ):
        super(DataFlowSourceSetting, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.source_name = source_name
        self.row_limit = row_limit


class DataFlowStagingInfo(msrest.serialization.Model):
    """Staging info for execute data flow activity.

    :param linked_service: Staging linked service reference.
    :type linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param folder_path: Folder path for staging blob. Type: string (or Expression with resultType
     string).
    :type folder_path: object
    """

    _attribute_map = {
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowStagingInfo, self).__init__(**kwargs)
        self.linked_service = linked_service
        self.folder_path = folder_path


class DataLakeAnalyticsUSQLActivity(ExecutionActivity):
    """Data Lake Analytics U-SQL activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param script_path: Required. Case-sensitive path to folder that contains the U-SQL script.
     Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Required. Script linked service reference.
    :type script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
     Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
    :type degree_of_parallelism: object
    :param priority: Determines which jobs out of all that are queued should be selected to run
     first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
     Expression with resultType integer), minimum: 1.
    :type priority: object
    :param parameters: Parameters for U-SQL job request.
    :type parameters: dict[str, object]
    :param runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression
     with resultType string).
    :type runtime_version: object
    :param compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic,
     Full and SingleBox. Type: string (or Expression with resultType string).
    :type compilation_mode: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'script_path': {'required': True},
        'script_linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'degree_of_parallelism': {'key': 'typeProperties.degreeOfParallelism', 'type': 'object'},
        'priority': {'key': 'typeProperties.priority', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'runtime_version': {'key': 'typeProperties.runtimeVersion', 'type': 'object'},
        'compilation_mode': {'key': 'typeProperties.compilationMode', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        script_path: object,
        script_linked_service: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        degree_of_parallelism: Optional[object] = None,
        priority: Optional[object] = None,
        parameters: Optional[Dict[str, object]] = None,
        runtime_version: Optional[object] = None,
        compilation_mode: Optional[object] = None,
        **kwargs
    ):
        super(DataLakeAnalyticsUSQLActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'DataLakeAnalyticsU-SQL'  # type: str
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.degree_of_parallelism = degree_of_parallelism
        self.priority = priority
        self.parameters = parameters
        self.runtime_version = runtime_version
        self.compilation_mode = compilation_mode


class DatasetCompression(msrest.serialization.Model):
    """The compression method used on a dataset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DatasetBZip2Compression, DatasetDeflateCompression, DatasetGZipCompression, DatasetTarCompression, DatasetTarGZipCompression, DatasetZipDeflateCompression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BZip2': 'DatasetBZip2Compression', 'Deflate': 'DatasetDeflateCompression', 'GZip': 'DatasetGZipCompression', 'Tar': 'DatasetTarCompression', 'TarGZip': 'DatasetTarGZipCompression', 'ZipDeflate': 'DatasetZipDeflateCompression'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetCompression, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'DatasetCompression'  # type: str


class DatasetBZip2Compression(DatasetCompression):
    """The BZip2 compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetBZip2Compression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'BZip2'  # type: str


class DatasetDataElement(msrest.serialization.Model):
    """Columns that define the structure of the dataset.

    :param name: Name of the column. Type: string (or Expression with resultType string).
    :type name: object
    :param type: Type of the column. Type: string (or Expression with resultType string).
    :type type: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[object] = None,
        type: Optional[object] = None,
        **kwargs
    ):
        super(DatasetDataElement, self).__init__(**kwargs)
        self.name = name
        self.type = type


class DatasetDebugResource(SubResourceDebugResource):
    """Dataset debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.mgmt.datafactory.models.Dataset
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DatasetDeflateCompression(DatasetCompression):
    """The Deflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The Deflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.mgmt.datafactory.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'Deflate'  # type: str
        self.level = level


class DatasetFolder(msrest.serialization.Model):
    """The folder that this Dataset is in. If not specified, Dataset will appear at the root level.

    :param name: The name of the folder that this Dataset is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetFolder, self).__init__(**kwargs)
        self.name = name


class DatasetGZipCompression(DatasetCompression):
    """The GZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The GZip compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.mgmt.datafactory.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetGZipCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'GZip'  # type: str
        self.level = level


class DatasetListResponse(msrest.serialization.Model):
    """A list of dataset resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of datasets.
    :type value: list[~azure.mgmt.datafactory.models.DatasetResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DatasetResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DatasetListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatasetReference(msrest.serialization.Model):
    """Dataset reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Dataset reference type. Default value: "DatasetReference".
    :vartype type: str
    :param reference_name: Required. Reference dataset name.
    :type reference_name: str
    :param parameters: Arguments for dataset.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    type = "DatasetReference"

    def __init__(
        self,
        *,
        reference_name: str,
        parameters: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.parameters = parameters


class DatasetResource(SubResource):
    """Dataset resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.mgmt.datafactory.models.Dataset
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        **kwargs
    ):
        super(DatasetResource, self).__init__(**kwargs)
        self.properties = properties


class DatasetSchemaDataElement(msrest.serialization.Model):
    """Columns that define the physical type schema of the dataset.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Name of the schema column. Type: string (or Expression with resultType string).
    :type name: object
    :param type: Type of the schema column. Type: string (or Expression with resultType string).
    :type type: object
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        name: Optional[object] = None,
        type: Optional[object] = None,
        **kwargs
    ):
        super(DatasetSchemaDataElement, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type = type


class DatasetTarCompression(DatasetCompression):
    """The Tar archive method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetTarCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'Tar'  # type: str


class DatasetTarGZipCompression(DatasetCompression):
    """The TarGZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The TarGZip compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.mgmt.datafactory.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetTarGZipCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'TarGZip'  # type: str
        self.level = level


class DatasetZipDeflateCompression(DatasetCompression):
    """The ZipDeflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The ZipDeflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.mgmt.datafactory.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetZipDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'ZipDeflate'  # type: str
        self.level = level


class Db2LinkedService(LinkedService):
    """Linked service for DB2 data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with server,
     database, authenticationType, userName, packageCollection and certificateCommonName property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param server: Server name for connection. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type server: object
    :param database: Database name for connection. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type database: object
    :param authentication_type: AuthenticationType to be used for connection. It is mutually
     exclusive with connectionString property. Possible values include: "Basic".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.Db2AuthenticationType
    :param username: Username for authentication. It is mutually exclusive with connectionString
     property. Type: string (or Expression with resultType string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param package_collection: Under where packages are created when querying database. It is
     mutually exclusive with connectionString property. Type: string (or Expression with resultType
     string).
    :type package_collection: object
    :param certificate_common_name: Certificate Common Name when TLS is enabled. It is mutually
     exclusive with connectionString property. Type: string (or Expression with resultType string).
    :type certificate_common_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. It is mutually exclusive with
     connectionString property. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'package_collection': {'key': 'typeProperties.packageCollection', 'type': 'object'},
        'certificate_common_name': {'key': 'typeProperties.certificateCommonName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        server: Optional[object] = None,
        database: Optional[object] = None,
        authentication_type: Optional[Union[str, "Db2AuthenticationType"]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        package_collection: Optional[object] = None,
        certificate_common_name: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(Db2LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Db2'  # type: str
        self.connection_string = connection_string
        self.server = server
        self.database = database
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.package_collection = package_collection
        self.certificate_common_name = certificate_common_name
        self.encrypted_credential = encrypted_credential


class Db2Source(TabularSource):
    """A copy activity source for Db2 databases.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(Db2Source, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'Db2Source'  # type: str
        self.query = query


class Db2TableDataset(Dataset):
    """The Db2 table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The Db2 schema name. Type: string (or Expression with
     resultType string).
    :type schema_type_properties_schema: object
    :param table: The Db2 table name. Type: string (or Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(Db2TableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Db2Table'  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class DeleteActivity(ExecutionActivity):
    """Delete activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param recursive: If true, files or sub-folders under current folder path will be deleted
     recursively. Default is false. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param max_concurrent_connections: The max concurrent connections to connect data source at the
     same time.
    :type max_concurrent_connections: int
    :param enable_logging: Whether to record detailed logs of delete-activity execution. Default
     value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_logging: object
    :param log_storage_settings: Log storage settings customer need to provide when enableLogging
     is true.
    :type log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
    :param dataset: Required. Delete activity dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param store_settings: Delete activity store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'max_concurrent_connections': {'minimum': 1},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'recursive': {'key': 'typeProperties.recursive', 'type': 'object'},
        'max_concurrent_connections': {'key': 'typeProperties.maxConcurrentConnections', 'type': 'int'},
        'enable_logging': {'key': 'typeProperties.enableLogging', 'type': 'object'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'store_settings': {'key': 'typeProperties.storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        recursive: Optional[object] = None,
        max_concurrent_connections: Optional[int] = None,
        enable_logging: Optional[object] = None,
        log_storage_settings: Optional["LogStorageSettings"] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        **kwargs
    ):
        super(DeleteActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'Delete'  # type: str
        self.recursive = recursive
        self.max_concurrent_connections = max_concurrent_connections
        self.enable_logging = enable_logging
        self.log_storage_settings = log_storage_settings
        self.dataset = dataset
        self.store_settings = store_settings


class DeleteDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for deleting data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(DeleteDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.session_id = session_id


class DelimitedTextDataset(Dataset):
    """Delimited text dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the delimited text storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param column_delimiter: The column delimiter. Type: string (or Expression with resultType
     string).
    :type column_delimiter: object
    :param row_delimiter: The row delimiter. Type: string (or Expression with resultType string).
    :type row_delimiter: object
    :param encoding_name: The code page name of the preferred encoding. If miss, the default value
     is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in
     the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: object
    :param compression_codec:  Possible values include: "none", "gzip", "snappy", "lzo", "bzip2",
     "deflate", "zipDeflate", "lz4", "tar", "tarGZip".
    :type compression_codec: str or ~azure.mgmt.datafactory.models.CompressionCodec
    :param compression_level: The data compression method used for DelimitedText. Possible values
     include: "Optimal", "Fastest".
    :type compression_level: str or ~azure.mgmt.datafactory.models.DatasetCompressionLevel
    :param quote_char: The quote character. Type: string (or Expression with resultType string).
    :type quote_char: object
    :param escape_char: The escape character. Type: string (or Expression with resultType string).
    :type escape_char: object
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: object
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'column_delimiter': {'key': 'typeProperties.columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'typeProperties.rowDelimiter', 'type': 'object'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'str'},
        'compression_level': {'key': 'typeProperties.compressionLevel', 'type': 'str'},
        'quote_char': {'key': 'typeProperties.quoteChar', 'type': 'object'},
        'escape_char': {'key': 'typeProperties.escapeChar', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        column_delimiter: Optional[object] = None,
        row_delimiter: Optional[object] = None,
        encoding_name: Optional[object] = None,
        compression_codec: Optional[Union[str, "CompressionCodec"]] = None,
        compression_level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        quote_char: Optional[object] = None,
        escape_char: Optional[object] = None,
        first_row_as_header: Optional[object] = None,
        null_value: Optional[object] = None,
        **kwargs
    ):
        super(DelimitedTextDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DelimitedText'  # type: str
        self.location = location
        self.column_delimiter = column_delimiter
        self.row_delimiter = row_delimiter
        self.encoding_name = encoding_name
        self.compression_codec = compression_codec
        self.compression_level = compression_level
        self.quote_char = quote_char
        self.escape_char = escape_char
        self.first_row_as_header = first_row_as_header
        self.null_value = null_value


class DelimitedTextReadSettings(FormatReadSettings):
    """Delimited text read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param skip_line_count: Indicates the number of non-empty rows to skip when reading data from
     input files. Type: integer (or Expression with resultType integer).
    :type skip_line_count: object
    :param compression_properties: Compression settings.
    :type compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'skip_line_count': {'key': 'skipLineCount', 'type': 'object'},
        'compression_properties': {'key': 'compressionProperties', 'type': 'CompressionReadSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        skip_line_count: Optional[object] = None,
        compression_properties: Optional["CompressionReadSettings"] = None,
        **kwargs
    ):
        super(DelimitedTextReadSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'DelimitedTextReadSettings'  # type: str
        self.skip_line_count = skip_line_count
        self.compression_properties = compression_properties


class DelimitedTextSink(CopySink):
    """A copy activity DelimitedText sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.DelimitedTextWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextWriteSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreWriteSettings"] = None,
        format_settings: Optional["DelimitedTextWriteSettings"] = None,
        **kwargs
    ):
        super(DelimitedTextSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DelimitedTextSink'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class DelimitedTextSource(CopySource):
    """A copy activity DelimitedText source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.DelimitedTextReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["DelimitedTextReadSettings"] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(DelimitedTextSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DelimitedTextSource'  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings
        self.additional_columns = additional_columns


class DelimitedTextWriteSettings(FormatWriteSettings):
    """Delimited text write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param quote_all_text: Indicates whether string values should always be enclosed with quotes.
     Type: boolean (or Expression with resultType boolean).
    :type quote_all_text: object
    :param file_extension: Required. The file extension used to create the files. Type: string (or
     Expression with resultType string).
    :type file_extension: object
    :param max_rows_per_file: Limit the written file's row count to be smaller than or equal to the
     specified count. Type: integer (or Expression with resultType integer).
    :type max_rows_per_file: object
    :param file_name_prefix: Specifies the file name pattern
     :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
     based store without partitionOptions. Type: string (or Expression with resultType string).
    :type file_name_prefix: object
    """

    _validation = {
        'type': {'required': True},
        'file_extension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'quote_all_text': {'key': 'quoteAllText', 'type': 'object'},
        'file_extension': {'key': 'fileExtension', 'type': 'object'},
        'max_rows_per_file': {'key': 'maxRowsPerFile', 'type': 'object'},
        'file_name_prefix': {'key': 'fileNamePrefix', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        file_extension: object,
        additional_properties: Optional[Dict[str, object]] = None,
        quote_all_text: Optional[object] = None,
        max_rows_per_file: Optional[object] = None,
        file_name_prefix: Optional[object] = None,
        **kwargs
    ):
        super(DelimitedTextWriteSettings, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'DelimitedTextWriteSettings'  # type: str
        self.quote_all_text = quote_all_text
        self.file_extension = file_extension
        self.max_rows_per_file = max_rows_per_file
        self.file_name_prefix = file_name_prefix


class DependencyReference(msrest.serialization.Model):
    """Referenced dependency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SelfDependencyTumblingWindowTriggerReference, TriggerDependencyReference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of dependency reference.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SelfDependencyTumblingWindowTriggerReference': 'SelfDependencyTumblingWindowTriggerReference', 'TriggerDependencyReference': 'TriggerDependencyReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DependencyReference, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class DistcpSettings(msrest.serialization.Model):
    """Distcp settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_manager_endpoint: Required. Specifies the Yarn ResourceManager endpoint. Type:
     string (or Expression with resultType string).
    :type resource_manager_endpoint: object
    :param temp_script_path: Required. Specifies an existing folder path which will be used to
     store temp Distcp command script. The script file is generated by ADF and will be removed after
     Copy job finished. Type: string (or Expression with resultType string).
    :type temp_script_path: object
    :param distcp_options: Specifies the Distcp options. Type: string (or Expression with
     resultType string).
    :type distcp_options: object
    """

    _validation = {
        'resource_manager_endpoint': {'required': True},
        'temp_script_path': {'required': True},
    }

    _attribute_map = {
        'resource_manager_endpoint': {'key': 'resourceManagerEndpoint', 'type': 'object'},
        'temp_script_path': {'key': 'tempScriptPath', 'type': 'object'},
        'distcp_options': {'key': 'distcpOptions', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        resource_manager_endpoint: object,
        temp_script_path: object,
        distcp_options: Optional[object] = None,
        **kwargs
    ):
        super(DistcpSettings, self).__init__(**kwargs)
        self.resource_manager_endpoint = resource_manager_endpoint
        self.temp_script_path = temp_script_path
        self.distcp_options = distcp_options


class DocumentDbCollectionDataset(Dataset):
    """Microsoft Azure Document Database Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param collection_name: Required. Document Database collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DocumentDbCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DocumentDbCollection'  # type: str
        self.collection_name = collection_name


class DocumentDbCollectionSink(CopySink):
    """A copy activity Document Database Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param nesting_separator: Nested properties separator. Default is . (dot). Type: string (or
     Expression with resultType string).
    :type nesting_separator: object
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        nesting_separator: Optional[object] = None,
        write_behavior: Optional[object] = None,
        **kwargs
    ):
        super(DocumentDbCollectionSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DocumentDbCollectionSink'  # type: str
        self.nesting_separator = nesting_separator
        self.write_behavior = write_behavior


class DocumentDbCollectionSource(CopySource):
    """A copy activity Document Database Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Documents query. Type: string (or Expression with resultType string).
    :type query: object
    :param nesting_separator: Nested properties separator. Type: string (or Expression with
     resultType string).
    :type nesting_separator: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        nesting_separator: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(DocumentDbCollectionSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DocumentDbCollectionSource'  # type: str
        self.query = query
        self.nesting_separator = nesting_separator
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class DrillLinkedService(LinkedService):
    """Drill server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DrillLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Drill'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class DrillSource(TabularSource):
    """A copy activity Drill server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(DrillSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'DrillSource'  # type: str
        self.query = query


class DrillTableDataset(Dataset):
    """Drill server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Drill. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Drill. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(DrillTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DrillTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class DWCopyCommandDefaultValue(msrest.serialization.Model):
    """Default value.

    :param column_name: Column name. Type: object (or Expression with resultType string).
    :type column_name: object
    :param default_value: The default value of the column. Type: object (or Expression with
     resultType string).
    :type default_value: object
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'object'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        column_name: Optional[object] = None,
        default_value: Optional[object] = None,
        **kwargs
    ):
        super(DWCopyCommandDefaultValue, self).__init__(**kwargs)
        self.column_name = column_name
        self.default_value = default_value


class DWCopyCommandSettings(msrest.serialization.Model):
    """DW Copy Command settings.

    :param default_values: Specifies the default values for each target column in SQL DW. The
     default values in the property overwrite the DEFAULT constraint set in the DB, and identity
     column cannot have a default value. Type: array of objects (or Expression with resultType array
     of objects).
    :type default_values: list[~azure.mgmt.datafactory.models.DWCopyCommandDefaultValue]
    :param additional_options: Additional options directly passed to SQL DW in Copy Command. Type:
     key value pairs (value should be string type) (or Expression with resultType object). Example:
     "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }.
    :type additional_options: dict[str, str]
    """

    _attribute_map = {
        'default_values': {'key': 'defaultValues', 'type': '[DWCopyCommandDefaultValue]'},
        'additional_options': {'key': 'additionalOptions', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        default_values: Optional[List["DWCopyCommandDefaultValue"]] = None,
        additional_options: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DWCopyCommandSettings, self).__init__(**kwargs)
        self.default_values = default_values
        self.additional_options = additional_options


class DynamicsAXLinkedService(LinkedService):
    """Dynamics AX linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData
     endpoint.
    :type url: object
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. Specify the application's key. Mark this field as a
     SecureString to store it securely in Data Factory, or reference a secret stored in Azure Key
     Vault. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: Required. Specify the tenant information (domain name or tenant ID) under which
     your application resides. Retrieve it by hovering the mouse in the top-right corner of the
     Azure portal. Type: string (or Expression with resultType string).
    :type tenant: object
    :param aad_resource_id: Required. Specify the resource you are requesting authorization. Type:
     string (or Expression with resultType string).
    :type aad_resource_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'tenant': {'required': True},
        'aad_resource_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        service_principal_id: object,
        service_principal_key: "SecretBase",
        tenant: object,
        aad_resource_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsAXLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'DynamicsAX'  # type: str
        self.url = url
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.aad_resource_id = aad_resource_id
        self.encrypted_credential = encrypted_credential


class DynamicsAXResourceDataset(Dataset):
    """The path of the Dynamics AX OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param path: Required. The path of the Dynamics AX OData entity. Type: string (or Expression
     with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DynamicsAXResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsAXResource'  # type: str
        self.path = path


class DynamicsAXSource(TabularSource):
    """A copy activity Dynamics AX source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    :param http_request_timeout: The timeout (TimeSpan) to get an HTTP response. It is the timeout
     to get a response, not the timeout to read response data. Default value: 00:05:00. Type: string
     (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type http_request_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
        'http_request_timeout': {'key': 'httpRequestTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        http_request_timeout: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsAXSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'DynamicsAXSource'  # type: str
        self.query = query
        self.http_request_timeout = http_request_timeout


class DynamicsCrmEntityDataset(Dataset):
    """The Dynamics CRM entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsCrmEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsCrmEntity'  # type: str
        self.entity_name = entity_name


class DynamicsCrmLinkedService(LinkedService):
    """Dynamics CRM linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics CRM instance. 'Online'
     for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type:
     string (or Expression with resultType string). Possible values include: "Online",
     "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.mgmt.datafactory.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics CRM server. The property is
     required for on-prem and not allowed for online. Type: string (or Expression with resultType
     string).
    :type host_name: object
    :param port: The port of on-premises Dynamics CRM server. The property is required for on-prem
     and not allowed for online. Default is 443. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Dynamics CRM server. The property is required for
     on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Dynamics CRM instance. The property is
     required for on-prem and required for online when there are more than one Dynamics CRM
     instances associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Dynamics CRM
     server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario,
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics CRM instance. Type: string (or Expression
     with resultType string).
    :type username: object
    :param password: Password to access the Dynamics CRM instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[object] = None,
        port: Optional[object] = None,
        service_uri: Optional[object] = None,
        organization_name: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsCrmLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'DynamicsCrm'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class DynamicsCrmSink(CopySink):
    """A copy activity Dynamics CRM sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        ignore_null_values: Optional[object] = None,
        alternate_key_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsCrmSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DynamicsCrmSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class DynamicsCrmSource(CopySource):
    """A copy activity Dynamics CRM source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(DynamicsCrmSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DynamicsCrmSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class DynamicsEntityDataset(Dataset):
    """The Dynamics entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'DynamicsEntity'  # type: str
        self.entity_name = entity_name


class DynamicsLinkedService(LinkedService):
    """Dynamics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics instance. 'Online' for
     Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or
     Expression with resultType string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.mgmt.datafactory.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics server. The property is required
     for on-prem and not allowed for online. Type: string (or Expression with resultType string).
    :type host_name: object
    :param port: The port of on-premises Dynamics server. The property is required for on-prem and
     not allowed for online. Default is 443. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Dynamics server. The property is required for on-
     line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Dynamics instance. The property is
     required for on-prem and required for online when there are more than one Dynamics instances
     associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Dynamics server.
     'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal'
     for Server-To-Server authentication in online scenario. Type: string (or Expression with
     resultType string). Possible values include: "Office365", "Ifd", "AADServicePrincipal".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics instance. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: Password to access the Dynamics instance.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[object] = None,
        port: Optional[object] = None,
        service_uri: Optional[object] = None,
        organization_name: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Dynamics'  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class DynamicsSink(CopySink):
    """A copy activity Dynamics sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        ignore_null_values: Optional[object] = None,
        alternate_key_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DynamicsSink'  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class DynamicsSource(CopySource):
    """A copy activity Dynamics source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(DynamicsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'DynamicsSource'  # type: str
        self.query = query
        self.additional_columns = additional_columns


class EloquaLinkedService(LinkedService):
    """Eloqua server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Eloqua server. (i.e. eloqua.example.com).
    :type endpoint: object
    :param username: Required. The site name and user name of your Eloqua account in the form:
     sitename/username. (i.e. Eloqua/Alice).
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        username: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(EloquaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Eloqua'  # type: str
        self.endpoint = endpoint
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class EloquaObjectDataset(Dataset):
    """Eloqua server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(EloquaObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'EloquaObject'  # type: str
        self.table_name = table_name


class EloquaSource(TabularSource):
    """A copy activity Eloqua server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(EloquaSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'EloquaSource'  # type: str
        self.query = query


class EncryptionConfiguration(msrest.serialization.Model):
    """Definition of CMK for the factory.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of the key in Azure Key Vault to use as Customer Managed
     Key.
    :type key_name: str
    :param vault_base_url: Required. The url of the Azure Key Vault used for CMK.
    :type vault_base_url: str
    :param key_version: The version of the key used for CMK. If not provided, latest version will
     be used.
    :type key_version: str
    :param identity: User assigned identity to use to authenticate to customer's key vault. If not
     provided Managed Service Identity will be used.
    :type identity: ~azure.mgmt.datafactory.models.CMKIdentityDefinition
    """

    _validation = {
        'key_name': {'required': True},
        'vault_base_url': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'vault_base_url': {'key': 'vaultBaseUrl', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'CMKIdentityDefinition'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        vault_base_url: str,
        key_version: Optional[str] = None,
        identity: Optional["CMKIdentityDefinition"] = None,
        **kwargs
    ):
        super(EncryptionConfiguration, self).__init__(**kwargs)
        self.key_name = key_name
        self.vault_base_url = vault_base_url
        self.key_version = key_version
        self.identity = identity


class EntityReference(msrest.serialization.Model):
    """The entity reference.

    :param type: The type of this referenced entity. Possible values include:
     "IntegrationRuntimeReference", "LinkedServiceReference".
    :type type: str or ~azure.mgmt.datafactory.models.IntegrationRuntimeEntityReferenceType
    :param reference_name: The name of this referenced entity.
    :type reference_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IntegrationRuntimeEntityReferenceType"]] = None,
        reference_name: Optional[str] = None,
        **kwargs
    ):
        super(EntityReference, self).__init__(**kwargs)
        self.type = type
        self.reference_name = reference_name


class EnvironmentVariableSetup(CustomSetupBase):
    """The custom setup of setting environment variable.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param variable_name: Required. The name of the environment variable.
    :type variable_name: str
    :param variable_value: Required. The value of the environment variable.
    :type variable_value: str
    """

    _validation = {
        'type': {'required': True},
        'variable_name': {'required': True},
        'variable_value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'variable_value': {'key': 'typeProperties.variableValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        variable_name: str,
        variable_value: str,
        **kwargs
    ):
        super(EnvironmentVariableSetup, self).__init__(**kwargs)
        self.type = 'EnvironmentVariableSetup'  # type: str
        self.variable_name = variable_name
        self.variable_value = variable_value


class ExcelDataset(Dataset):
    """Excel dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param location: The location of the excel storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param sheet_name: The sheet of excel file. Type: string (or Expression with resultType
     string).
    :type sheet_name: object
    :param range: The partial data of one sheet. Type: string (or Expression with resultType
     string).
    :type range: object
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: object
    :param compression: The data compression method used for the json dataset.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'sheet_name': {'key': 'typeProperties.sheetName', 'type': 'object'},
        'range': {'key': 'typeProperties.range', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        sheet_name: Optional[object] = None,
        range: Optional[object] = None,
        first_row_as_header: Optional[object] = None,
        compression: Optional["DatasetCompression"] = None,
        null_value: Optional[object] = None,
        **kwargs
    ):
        super(ExcelDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'Excel'  # type: str
        self.location = location
        self.sheet_name = sheet_name
        self.range = range
        self.first_row_as_header = first_row_as_header
        self.compression = compression
        self.null_value = null_value


class ExcelSource(CopySource):
    """A copy activity excel source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Excel store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(ExcelSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'ExcelSource'  # type: str
        self.store_settings = store_settings
        self.additional_columns = additional_columns


class ExecuteDataFlowActivity(ExecutionActivity):
    """Execute data flow activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.mgmt.datafactory.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.mgmt.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute
    :param trace_level: Trace level setting used for data flow monitoring output. Supported values
     are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string).
    :type trace_level: object
    :param continue_on_error: Continue on error setting used for data flow execution. Enables
     processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean).
    :type continue_on_error: object
    :param run_concurrently: Concurrent run setting used for data flow execution. Allows sinks with
     the same save order to be processed concurrently. Type: boolean (or Expression with resultType
     boolean).
    :type run_concurrently: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'data_flow': {'key': 'typeProperties.dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'typeProperties.staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'typeProperties.integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'typeProperties.compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
        'trace_level': {'key': 'typeProperties.traceLevel', 'type': 'object'},
        'continue_on_error': {'key': 'typeProperties.continueOnError', 'type': 'object'},
        'run_concurrently': {'key': 'typeProperties.runConcurrently', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_flow: "DataFlowReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        trace_level: Optional[object] = None,
        continue_on_error: Optional[object] = None,
        run_concurrently: Optional[object] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'ExecuteDataFlow'  # type: str
        self.data_flow = data_flow
        self.staging = staging
        self.integration_runtime = integration_runtime
        self.compute = compute
        self.trace_level = trace_level
        self.continue_on_error = continue_on_error
        self.run_concurrently = run_concurrently


class ExecuteDataFlowActivityTypePropertiesCompute(msrest.serialization.Model):
    """Compute properties for data flow activity.

    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression
     with resultType string).
    :type compute_type: object
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer).
    :type core_count: object
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'object'},
        'core_count': {'key': 'coreCount', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[object] = None,
        core_count: Optional[object] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivityTypePropertiesCompute, self).__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count


class ExecutePipelineActivity(Activity):
    """Execute pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param pipeline: Required. Pipeline reference.
    :type pipeline: ~azure.mgmt.datafactory.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, object]
    :param wait_on_completion: Defines whether activity execution will wait for the dependent
     pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        pipeline: "PipelineReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        parameters: Optional[Dict[str, object]] = None,
        wait_on_completion: Optional[bool] = None,
        **kwargs
    ):
        super(ExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'ExecutePipeline'  # type: str
        self.pipeline = pipeline
        self.parameters = parameters
        self.wait_on_completion = wait_on_completion


class ExecuteSSISPackageActivity(ExecutionActivity):
    """Execute SSIS package activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param package_location: Required. SSIS package location.
    :type package_location: ~azure.mgmt.datafactory.models.SSISPackageLocation
    :param runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or
     "x64". Type: string (or Expression with resultType string).
    :type runtime: object
    :param logging_level: The logging level of SSIS package execution. Type: string (or Expression
     with resultType string).
    :type logging_level: object
    :param environment_path: The environment path to execute the SSIS package. Type: string (or
     Expression with resultType string).
    :type environment_path: object
    :param execution_credential: The package execution credential.
    :type execution_credential: ~azure.mgmt.datafactory.models.SSISExecutionCredential
    :param connect_via: Required. The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param project_parameters: The project level parameters to execute the SSIS package.
    :type project_parameters: dict[str, ~azure.mgmt.datafactory.models.SSISExecutionParameter]
    :param package_parameters: The package level parameters to execute the SSIS package.
    :type package_parameters: dict[str, ~azure.mgmt.datafactory.models.SSISExecutionParameter]
    :param project_connection_managers: The project level connection managers to execute the SSIS
     package.
    :type project_connection_managers: dict[str, object]
    :param package_connection_managers: The package level connection managers to execute the SSIS
     package.
    :type package_connection_managers: dict[str, object]
    :param property_overrides: The property overrides to execute the SSIS package.
    :type property_overrides: dict[str, ~azure.mgmt.datafactory.models.SSISPropertyOverride]
    :param log_location: SSIS package execution log location.
    :type log_location: ~azure.mgmt.datafactory.models.SSISLogLocation
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'package_location': {'required': True},
        'connect_via': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'package_location': {'key': 'typeProperties.packageLocation', 'type': 'SSISPackageLocation'},
        'runtime': {'key': 'typeProperties.runtime', 'type': 'object'},
        'logging_level': {'key': 'typeProperties.loggingLevel', 'type': 'object'},
        'environment_path': {'key': 'typeProperties.environmentPath', 'type': 'object'},
        'execution_credential': {'key': 'typeProperties.executionCredential', 'type': 'SSISExecutionCredential'},
        'connect_via': {'key': 'typeProperties.connectVia', 'type': 'IntegrationRuntimeReference'},
        'project_parameters': {'key': 'typeProperties.projectParameters', 'type': '{SSISExecutionParameter}'},
        'package_parameters': {'key': 'typeProperties.packageParameters', 'type': '{SSISExecutionParameter}'},
        'project_connection_managers': {'key': 'typeProperties.projectConnectionManagers', 'type': '{object}'},
        'package_connection_managers': {'key': 'typeProperties.packageConnectionManagers', 'type': '{object}'},
        'property_overrides': {'key': 'typeProperties.propertyOverrides', 'type': '{SSISPropertyOverride}'},
        'log_location': {'key': 'typeProperties.logLocation', 'type': 'SSISLogLocation'},
    }

    def __init__(
        self,
        *,
        name: str,
        package_location: "SSISPackageLocation",
        connect_via: "IntegrationRuntimeReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        runtime: Optional[object] = None,
        logging_level: Optional[object] = None,
        environment_path: Optional[object] = None,
        execution_credential: Optional["SSISExecutionCredential"] = None,
        project_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        package_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        project_connection_managers: Optional[Dict[str, object]] = None,
        package_connection_managers: Optional[Dict[str, object]] = None,
        property_overrides: Optional[Dict[str, "SSISPropertyOverride"]] = None,
        log_location: Optional["SSISLogLocation"] = None,
        **kwargs
    ):
        super(ExecuteSSISPackageActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'ExecuteSSISPackage'  # type: str
        self.package_location = package_location
        self.runtime = runtime
        self.logging_level = logging_level
        self.environment_path = environment_path
        self.execution_credential = execution_credential
        self.connect_via = connect_via
        self.project_parameters = project_parameters
        self.package_parameters = package_parameters
        self.project_connection_managers = project_connection_managers
        self.package_connection_managers = package_connection_managers
        self.property_overrides = property_overrides
        self.log_location = log_location


class ExposureControlBatchRequest(msrest.serialization.Model):
    """A list of exposure control features.

    All required parameters must be populated in order to send to Azure.

    :param exposure_control_requests: Required. List of exposure control features.
    :type exposure_control_requests: list[~azure.mgmt.datafactory.models.ExposureControlRequest]
    """

    _validation = {
        'exposure_control_requests': {'required': True},
    }

    _attribute_map = {
        'exposure_control_requests': {'key': 'exposureControlRequests', 'type': '[ExposureControlRequest]'},
    }

    def __init__(
        self,
        *,
        exposure_control_requests: List["ExposureControlRequest"],
        **kwargs
    ):
        super(ExposureControlBatchRequest, self).__init__(**kwargs)
        self.exposure_control_requests = exposure_control_requests


class ExposureControlBatchResponse(msrest.serialization.Model):
    """A list of exposure control feature values.

    All required parameters must be populated in order to send to Azure.

    :param exposure_control_responses: Required. List of exposure control feature values.
    :type exposure_control_responses: list[~azure.mgmt.datafactory.models.ExposureControlResponse]
    """

    _validation = {
        'exposure_control_responses': {'required': True},
    }

    _attribute_map = {
        'exposure_control_responses': {'key': 'exposureControlResponses', 'type': '[ExposureControlResponse]'},
    }

    def __init__(
        self,
        *,
        exposure_control_responses: List["ExposureControlResponse"],
        **kwargs
    ):
        super(ExposureControlBatchResponse, self).__init__(**kwargs)
        self.exposure_control_responses = exposure_control_responses


class ExposureControlRequest(msrest.serialization.Model):
    """The exposure control request.

    :param feature_name: The feature name.
    :type feature_name: str
    :param feature_type: The feature type.
    :type feature_type: str
    """

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        feature_name: Optional[str] = None,
        feature_type: Optional[str] = None,
        **kwargs
    ):
        super(ExposureControlRequest, self).__init__(**kwargs)
        self.feature_name = feature_name
        self.feature_type = feature_type


class ExposureControlResponse(msrest.serialization.Model):
    """The exposure control response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The feature name.
    :vartype feature_name: str
    :ivar value: The feature value.
    :vartype value: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExposureControlResponse, self).__init__(**kwargs)
        self.feature_name = None
        self.value = None


class Expression(msrest.serialization.Model):
    """Azure Data Factory expression definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Expression type. Default value: "Expression".
    :vartype type: str
    :param value: Required. Expression value.
    :type value: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    type = "Expression"

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(Expression, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Azure Data Factory top-level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar e_tag: Etag identifies change in the resource.
    :vartype e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'e_tag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = None


class Factory(Resource):
    """Factory resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar e_tag: Etag identifies change in the resource.
    :vartype e_tag: str
    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param identity: Managed service identity of the factory.
    :type identity: ~azure.mgmt.datafactory.models.FactoryIdentity
    :ivar provisioning_state: Factory provisioning state, example Succeeded.
    :vartype provisioning_state: str
    :ivar create_time: Time the factory was created in ISO8601 format.
    :vartype create_time: ~datetime.datetime
    :ivar version: Version of the factory.
    :vartype version: str
    :param repo_configuration: Git repo information of the factory.
    :type repo_configuration: ~azure.mgmt.datafactory.models.FactoryRepoConfiguration
    :param global_parameters: List of parameters for factory.
    :type global_parameters: dict[str, ~azure.mgmt.datafactory.models.GlobalParameterSpecification]
    :param encryption: Properties to enable Customer Managed Key for the factory.
    :type encryption: ~azure.mgmt.datafactory.models.EncryptionConfiguration
    :param public_network_access: Whether or not public network access is allowed for the data
     factory. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.datafactory.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'e_tag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'create_time': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'additional_properties': {'key': '', 'type': '{object}'},
        'identity': {'key': 'identity', 'type': 'FactoryIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'repo_configuration': {'key': 'properties.repoConfiguration', 'type': 'FactoryRepoConfiguration'},
        'global_parameters': {'key': 'properties.globalParameters', 'type': '{GlobalParameterSpecification}'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionConfiguration'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        additional_properties: Optional[Dict[str, object]] = None,
        identity: Optional["FactoryIdentity"] = None,
        repo_configuration: Optional["FactoryRepoConfiguration"] = None,
        global_parameters: Optional[Dict[str, "GlobalParameterSpecification"]] = None,
        encryption: Optional["EncryptionConfiguration"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(Factory, self).__init__(location=location, tags=tags, **kwargs)
        self.additional_properties = additional_properties
        self.identity = identity
        self.provisioning_state = None
        self.create_time = None
        self.version = None
        self.repo_configuration = repo_configuration
        self.global_parameters = global_parameters
        self.encryption = encryption
        self.public_network_access = public_network_access


class FactoryRepoConfiguration(msrest.serialization.Model):
    """Factory's git repo information.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FactoryGitHubConfiguration, FactoryVSTSConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'FactoryGitHubConfiguration': 'FactoryGitHubConfiguration', 'FactoryVSTSConfiguration': 'FactoryVSTSConfiguration'}
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        last_commit_id: Optional[str] = None,
        **kwargs
    ):
        super(FactoryRepoConfiguration, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.account_name = account_name
        self.repository_name = repository_name
        self.collaboration_branch = collaboration_branch
        self.root_folder = root_folder
        self.last_commit_id = last_commit_id


class FactoryGitHubConfiguration(FactoryRepoConfiguration):
    """Factory's GitHub repo information.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    :param host_name: GitHub Enterprise host name. For example: https://github.mydomain.com.
    :type host_name: str
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        last_commit_id: Optional[str] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        super(FactoryGitHubConfiguration, self).__init__(account_name=account_name, repository_name=repository_name, collaboration_branch=collaboration_branch, root_folder=root_folder, last_commit_id=last_commit_id, **kwargs)
        self.type = 'FactoryGitHubConfiguration'  # type: str
        self.host_name = host_name


class FactoryIdentity(msrest.serialization.Model):
    """Identity properties of the factory resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :type type: str or ~azure.mgmt.datafactory.models.FactoryIdentityType
    :ivar principal_id: The principal id of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The client tenant id of the identity.
    :vartype tenant_id: str
    :param user_assigned_identities: List of user assigned identities for the factory.
    :type user_assigned_identities: dict[str, object]
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "FactoryIdentityType"],
        user_assigned_identities: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(FactoryIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class FactoryListResponse(msrest.serialization.Model):
    """A list of factory resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of factories.
    :type value: list[~azure.mgmt.datafactory.models.Factory]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Factory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Factory"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FactoryListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FactoryRepoUpdate(msrest.serialization.Model):
    """Factory's git repo information.

    :param factory_resource_id: The factory resource id.
    :type factory_resource_id: str
    :param repo_configuration: Git repo information of the factory.
    :type repo_configuration: ~azure.mgmt.datafactory.models.FactoryRepoConfiguration
    """

    _attribute_map = {
        'factory_resource_id': {'key': 'factoryResourceId', 'type': 'str'},
        'repo_configuration': {'key': 'repoConfiguration', 'type': 'FactoryRepoConfiguration'},
    }

    def __init__(
        self,
        *,
        factory_resource_id: Optional[str] = None,
        repo_configuration: Optional["FactoryRepoConfiguration"] = None,
        **kwargs
    ):
        super(FactoryRepoUpdate, self).__init__(**kwargs)
        self.factory_resource_id = factory_resource_id
        self.repo_configuration = repo_configuration


class FactoryUpdateParameters(msrest.serialization.Model):
    """Parameters for updating a factory resource.

    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity of the factory.
    :type identity: ~azure.mgmt.datafactory.models.FactoryIdentity
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'FactoryIdentity'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["FactoryIdentity"] = None,
        **kwargs
    ):
        super(FactoryUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class FactoryVSTSConfiguration(FactoryRepoConfiguration):
    """Factory's VSTS repo information.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of repo configuration.Constant filled by server.
    :type type: str
    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    :param project_name: Required. VSTS project name.
    :type project_name: str
    :param tenant_id: VSTS tenant id.
    :type tenant_id: str
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
        'project_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        repository_name: str,
        collaboration_branch: str,
        root_folder: str,
        project_name: str,
        last_commit_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(FactoryVSTSConfiguration, self).__init__(account_name=account_name, repository_name=repository_name, collaboration_branch=collaboration_branch, root_folder=root_folder, last_commit_id=last_commit_id, **kwargs)
        self.type = 'FactoryVSTSConfiguration'  # type: str
        self.project_name = project_name
        self.tenant_id = tenant_id


class FileServerLinkedService(LinkedService):
    """File system linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_id: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(FileServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'FileServer'  # type: str
        self.host = host
        self.user_id = user_id
        self.password = password
        self.encrypted_credential = encrypted_credential


class FileServerLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(FileServerLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'FileServerLocation'  # type: str


class FileServerReadSettings(StoreReadSettings):
    """File server read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: FileServer wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: FileServer wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    :param file_filter: Specify a filter to be used to select a subset of files in the folderPath
     rather than all files. Type: string (or Expression with resultType string).
    :type file_filter: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
        'file_filter': {'key': 'fileFilter', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        file_filter: Optional[object] = None,
        **kwargs
    ):
        super(FileServerReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'FileServerReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.file_filter = file_filter


class FileServerWriteSettings(StoreWriteSettings):
    """File server write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(FileServerWriteSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, copy_behavior=copy_behavior, **kwargs)
        self.type = 'FileServerWriteSettings'  # type: str


class FileShareDataset(Dataset):
    """An on-premises file system dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param folder_path: The path of the on-premises file system. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: The name of the on-premises file system. Type: string (or Expression with
     resultType string).
    :type file_name: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    :param format: The format of the files.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param file_filter: Specify a filter to be used to select a subset of files in the folderPath
     rather than all files. Type: string (or Expression with resultType string).
    :type file_filter: object
    :param compression: The data compression method used for the file system.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'modified_datetime_start': {'key': 'typeProperties.modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'typeProperties.modifiedDatetimeEnd', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'file_filter': {'key': 'typeProperties.fileFilter', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        file_filter: Optional[object] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(FileShareDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'FileShare'  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.file_filter = file_filter
        self.compression = compression


class FileSystemSink(CopySink):
    """A copy activity file system sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        copy_behavior: Optional[object] = None,
        **kwargs
    ):
        super(FileSystemSink, self).__init__(additional_properties=additional_properties, write_batch_size=write_batch_size, write_batch_timeout=write_batch_timeout, sink_retry_count=sink_retry_count, sink_retry_wait=sink_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'FileSystemSink'  # type: str
        self.copy_behavior = copy_behavior


class FileSystemSource(CopySource):
    """A copy activity file system source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        **kwargs
    ):
        super(FileSystemSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'FileSystemSource'  # type: str
        self.recursive = recursive
        self.additional_columns = additional_columns


class FilterActivity(Activity):
    """Filter and return results from input array based on the conditions.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param items: Required. Input array on which filter should be applied.
    :type items: ~azure.mgmt.datafactory.models.Expression
    :param condition: Required. Condition to be used for filtering the input.
    :type condition: ~azure.mgmt.datafactory.models.Expression
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'items': {'required': True},
        'condition': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'condition': {'key': 'typeProperties.condition', 'type': 'Expression'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        condition: "Expression",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(FilterActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'Filter'  # type: str
        self.items = items
        self.condition = condition


class ForEachActivity(Activity):
    """This activity is used for iterating over a collection and execute given activities.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param is_sequential: Should the loop be executed in sequence or in parallel (max 50).
    :type is_sequential: bool
    :param batch_count: Batch count to be used for controlling the number of parallel execution
     (when isSequential is set to false).
    :type batch_count: int
    :param items: Required. Collection to iterate.
    :type items: ~azure.mgmt.datafactory.models.Expression
    :param activities: Required. List of activities to execute .
    :type activities: list[~azure.mgmt.datafactory.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'batch_count': {'maximum': 50},
        'items': {'required': True},
        'activities': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'is_sequential': {'key': 'typeProperties.isSequential', 'type': 'bool'},
        'batch_count': {'key': 'typeProperties.batchCount', 'type': 'int'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'activities': {'key': 'typeProperties.activities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        activities: List["Activity"],
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        is_sequential: Optional[bool] = None,
        batch_count: Optional[int] = None,
        **kwargs
    ):
        super(ForEachActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type = 'ForEach'  # type: str
        self.is_sequential = is_sequential
        self.batch_count = batch_count
        self.items = items
        self.activities = activities


class FtpReadSettings(StoreReadSettings):
    """Ftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Ftp wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Ftp wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param use_binary_transfer: Specify whether to use binary transfer mode for FTP stores.
    :type use_binary_transfer: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'use_binary_transfer': {'key': 'useBinaryTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        file_list_path: Optional[object] = None,
        use_binary_transfer: Optional[bool] = None,
        **kwargs
    ):
        super(FtpReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'FtpReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.file_list_path = file_list_path
        self.use_binary_transfer = use_binary_transfer


class FtpServerLinkedService(LinkedService):
    """A FTP server Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the FTP server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param port: The TCP port number that the FTP server uses to listen for client connections.
     Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param authentication_type: The authentication type to be used to connect to the FTP server.
     Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.FtpAuthenticationType
    :param user_name: Username to logon the FTP server. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: Password to logon the FTP server.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: object
    :param enable_server_certificate_validation: If true, validate the FTP server SSL certificate
     when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        authentication_type: Optional[Union[str, "FtpAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        enable_server_certificate_validation: Optional[object] = None,
        **kwargs
    ):
        super(FtpServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'FtpServer'  # type: str
        self.host = host
        self.port = port
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.enable_ssl = enable_ssl
        self.enable_server_certificate_validation = enable_server_certificate_validation


class FtpServerLocation(DatasetLocation):
    """The location of ftp server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(FtpServerLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'FtpServerLocation'  # type: str


class GetDataFactoryOperationStatusResponse(msrest.serialization.Model):
    """Response body structure for get data factory operation status.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param status: Status of the operation.
    :type status: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(GetDataFactoryOperationStatusResponse, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.status = status


class GetMetadataActivity(ExecutionActivity):
    """Activity to get metadata of dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param dataset: Required. GetMetadata activity dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :param field_list: Fields of metadata to get from dataset.
    :type field_list: list[object]
    :param store_settings: GetMetadata activity store settings.
    :type store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :param format_settings: GetMetadata activity format settings.
    :type format_settings: ~azure.mgmt.datafactory.models.FormatReadSettings
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'field_list': {'key': 'typeProperties.fieldList', 'type': '[object]'},
        'store_settings': {'key': 'typeProperties.storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'typeProperties.formatSettings', 'type': 'FormatReadSettings'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        field_list: Optional[List[object]] = None,
        store_settings: Optional["StoreReadSettings"] = None,
        format_settings: Optional["FormatReadSettings"] = None,
        **kwargs
    ):
        super(GetMetadataActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'GetMetadata'  # type: str
        self.dataset = dataset
        self.field_list = field_list
        self.store_settings = store_settings
        self.format_settings = format_settings


class GetSsisObjectMetadataRequest(msrest.serialization.Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metadata_path: Optional[str] = None,
        **kwargs
    ):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = metadata_path


class GitHubAccessTokenRequest(msrest.serialization.Model):
    """Get GitHub access token request definition.

    All required parameters must be populated in order to send to Azure.

    :param git_hub_access_code: Required. GitHub access code.
    :type git_hub_access_code: str
    :param git_hub_client_id: GitHub application client ID.
    :type git_hub_client_id: str
    :param git_hub_access_token_base_url: Required. GitHub access token base URL.
    :type git_hub_access_token_base_url: str
    """

    _validation = {
        'git_hub_access_code': {'required': True},
        'git_hub_access_token_base_url': {'required': True},
    }

    _attribute_map = {
        'git_hub_access_code': {'key': 'gitHubAccessCode', 'type': 'str'},
        'git_hub_client_id': {'key': 'gitHubClientId', 'type': 'str'},
        'git_hub_access_token_base_url': {'key': 'gitHubAccessTokenBaseUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        git_hub_access_code: str,
        git_hub_access_token_base_url: str,
        git_hub_client_id: Optional[str] = None,
        **kwargs
    ):
        super(GitHubAccessTokenRequest, self).__init__(**kwargs)
        self.git_hub_access_code = git_hub_access_code
        self.git_hub_client_id = git_hub_client_id
        self.git_hub_access_token_base_url = git_hub_access_token_base_url


class GitHubAccessTokenResponse(msrest.serialization.Model):
    """Get GitHub access token response definition.

    :param git_hub_access_token: GitHub access token.
    :type git_hub_access_token: str
    """

    _attribute_map = {
        'git_hub_access_token': {'key': 'gitHubAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        git_hub_access_token: Optional[str] = None,
        **kwargs
    ):
        super(GitHubAccessTokenResponse, self).__init__(**kwargs)
        self.git_hub_access_token = git_hub_access_token


class GlobalParameterSpecification(msrest.serialization.Model):
    """Definition of a single parameter for an entity.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Global Parameter type. Possible values include: "Object", "String",
     "Int", "Float", "Bool", "Array".
    :type type: str or ~azure.mgmt.datafactory.models.GlobalParameterType
    :param value: Required. Value of parameter.
    :type value: object
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "GlobalParameterType"],
        value: object,
        **kwargs
    ):
        super(GlobalParameterSpecification, self).__init__(**kwargs)
        self.type = type
        self.value = value


class GoogleAdWordsLinkedService(LinkedService):
    """Google AdWords service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_customer_id: Required. The Client customer ID of the AdWords account that you
     want to fetch report data for.
    :type client_customer_id: object
    :param developer_token: Required. The developer token associated with the manager account that
     you use to grant access to the AdWords API.
    :type developer_token: ~azure.mgmt.datafactory.models.SecretBase
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.mgmt.datafactory.models.GoogleAdWordsAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to AdWords
     for UserAuthentication.
    :type refresh_token: ~azure.mgmt.datafactory.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.mgmt.datafactory.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_customer_id': {'required': True},
        'developer_token': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_customer_id': {'key': 'typeProperties.clientCustomerID', 'type': 'object'},
        'developer_token': {'key': 'typeProperties.developerToken', 'type': 'SecretBase'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_customer_id: object,
        developer_token: "SecretBase",
        authentication_type: Union[str, "GoogleAdWordsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[object] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[object] = None,
        key_file_path: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleAdWordsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleAdWords'  # type: str
        self.client_customer_id = client_customer_id
        self.developer_token = developer_token
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleAdWordsObjectDataset(Dataset):
    """Google AdWords service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(GoogleAdWordsObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GoogleAdWordsObject'  # type: str
        self.table_name = table_name


class GoogleAdWordsSource(TabularSource):
    """A copy activity Google AdWords service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(GoogleAdWordsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GoogleAdWordsSource'  # type: str
        self.query = query


class GoogleBigQueryLinkedService(LinkedService):
    """Google BigQuery service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param project: Required. The default BigQuery project to query against.
    :type project: object
    :param additional_projects: A comma-separated list of public BigQuery projects to access.
    :type additional_projects: object
    :param request_google_drive_scope: Whether to request access to Google Drive. Allowing Google
     Drive access enables support for federated tables that combine BigQuery data with data from
     Google Drive. The default value is false.
    :type request_google_drive_scope: object
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.mgmt.datafactory.models.GoogleBigQueryAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to BigQuery
     for UserAuthentication.
    :type refresh_token: ~azure.mgmt.datafactory.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.mgmt.datafactory.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'project': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'project': {'key': 'typeProperties.project', 'type': 'object'},
        'additional_projects': {'key': 'typeProperties.additionalProjects', 'type': 'object'},
        'request_google_drive_scope': {'key': 'typeProperties.requestGoogleDriveScope', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        project: object,
        authentication_type: Union[str, "GoogleBigQueryAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        additional_projects: Optional[object] = None,
        request_google_drive_scope: Optional[object] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[object] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[object] = None,
        key_file_path: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleBigQueryLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleBigQuery'  # type: str
        self.project = project
        self.additional_projects = additional_projects
        self.request_google_drive_scope = request_google_drive_scope
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleBigQueryObjectDataset(Dataset):
    """Google BigQuery service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using database + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type table: object
    :param dataset: The database name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type dataset: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        dataset: Optional[object] = None,
        **kwargs
    ):
        super(GoogleBigQueryObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GoogleBigQueryObject'  # type: str
        self.table_name = table_name
        self.table = table
        self.dataset = dataset


class GoogleBigQuerySource(TabularSource):
    """A copy activity Google BigQuery service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(GoogleBigQuerySource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GoogleBigQuerySource'  # type: str
        self.query = query


class GoogleCloudStorageLinkedService(LinkedService):
    """Linked service for Google Cloud Storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Google Cloud Storage Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Google Cloud Storage Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Google Cloud Storage
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key_id: Optional[object] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleCloudStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'GoogleCloudStorage'  # type: str
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.encrypted_credential = encrypted_credential


class GoogleCloudStorageLocation(DatasetLocation):
    """The location of Google Cloud Storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of Google Cloud Storage. Type: string (or Expression
     with resultType string).
    :type bucket_name: object
    :param version: Specify the version of Google Cloud Storage. Type: string (or Expression with
     resultType string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        bucket_name: Optional[object] = None,
        version: Optional[object] = None,
        **kwargs
    ):
        super(GoogleCloudStorageLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'GoogleCloudStorageLocation'  # type: str
        self.bucket_name = bucket_name
        self.version = version


class GoogleCloudStorageReadSettings(StoreReadSettings):
    """Google Cloud Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Google Cloud Storage wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Google Cloud Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the Google Cloud Storage object name. Type: string (or
     Expression with resultType string).
    :type prefix: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        prefix: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        delete_files_after_completion: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        **kwargs
    ):
        super(GoogleCloudStorageReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'GoogleCloudStorageReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class GreenplumLinkedService(LinkedService):
    """Greenplum Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GreenplumLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Greenplum'  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class GreenplumSource(TabularSource):
    """A copy activity Greenplum Database source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(GreenplumSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'GreenplumSource'  # type: str
        self.query = query


class GreenplumTableDataset(Dataset):
    """Greenplum Database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of Greenplum. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of Greenplum. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(GreenplumTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'GreenplumTable'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class HBaseLinkedService(LinkedService):
    """HBase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the HBase server. (i.e. 192.168.222.160).
    :type host: object
    :param port: The TCP port that the HBase instance uses to listen for client connections. The
     default value is 9090.
    :type port: object
    :param http_path: The partial URL corresponding to the HBase server. (i.e.
     /gateway/sandbox/hbase/version).
    :type http_path: object
    :param authentication_type: Required. The authentication mechanism to use to connect to the
     HBase server. Possible values include: "Anonymous", "Basic".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.HBaseAuthenticationType
    :param username: The user name used to connect to the HBase instance.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "HBaseAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        http_path: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(HBaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'HBase'  # type: str
        self.host = host
        self.port = port
        self.http_path = http_path
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class HBaseObjectDataset(Dataset):
    """HBase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(HBaseObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'HBaseObject'  # type: str
        self.table_name = table_name


class HBaseSource(TabularSource):
    """A copy activity HBase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(HBaseSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'HBaseSource'  # type: str
        self.query = query


class HdfsLinkedService(LinkedService):
    """Hadoop Distributed File System (HDFS) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of the HDFS service endpoint, e.g.
     http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
    :type url: object
    :param authentication_type: Type of authentication used to connect to the HDFS. Possible values
     are: Anonymous and Windows. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param user_name: User name for Windows authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Windows authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(HdfsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Hdfs'  # type: str
        self.url = url
        self.authentication_type = authentication_type
        self.encrypted_credential = encrypted_credential
        self.user_name = user_name
        self.password = password


class HdfsLocation(DatasetLocation):
    """The location of HDFS.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(HdfsLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'HdfsLocation'  # type: str


class HdfsReadSettings(StoreReadSettings):
    """HDFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: HDFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: HDFS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :type file_list_path: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.mgmt.datafactory.models.DistcpSettings
    :param delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :type delete_files_after_completion: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'file_list_path': {'key': 'fileListPath', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
        'delete_files_after_completion': {'key': 'deleteFilesAfterCompletion', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        wildcard_folder_path: Optional[object] = None,
        wildcard_file_name: Optional[object] = None,
        file_list_path: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        modified_datetime_start: Optional[object] = None,
        modified_datetime_end: Optional[object] = None,
        distcp_settings: Optional["DistcpSettings"] = None,
        delete_files_after_completion: Optional[object] = None,
        **kwargs
    ):
        super(HdfsReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'HdfsReadSettings'  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.distcp_settings = distcp_settings
        self.delete_files_after_completion = delete_files_after_completion


class HdfsSource(CopySource):
    """A copy activity HDFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.mgmt.datafactory.models.DistcpSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        recursive: Optional[object] = None,
        distcp_settings: Optional["DistcpSettings"] = None,
        **kwargs
    ):
        super(HdfsSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'HdfsSource'  # type: str
        self.recursive = recursive
        self.distcp_settings = distcp_settings


class HDInsightHiveActivity(ExecutionActivity):
    """HDInsight Hive activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Hive job request.
    :type defines: dict[str, object]
    :param variables: User specified arguments under hivevar namespace.
    :type variables: list[object]
    :param query_timeout: Query timeout value (in minutes).  Effective when the HDInsight cluster
     is with ESP (Enterprise Security Package).
    :type query_timeout: int
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
        'variables': {'key': 'typeProperties.variables', 'type': '[object]'},
        'query_timeout': {'key': 'typeProperties.queryTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        script_path: Optional[object] = None,
        script_linked_service: Optional["LinkedServiceReference"] = None,
        defines: Optional[Dict[str, object]] = None,
        variables: Optional[List[object]] = None,
        query_timeout: Optional[int] = None,
        **kwargs
    ):
        super(HDInsightHiveActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightHive'  # type: str
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.defines = defines
        self.variables = variables
        self.query_timeout = query_timeout


class HDInsightLinkedService(LinkedService):
    """HDInsight linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_uri: Required. HDInsight cluster URI. Type: string (or Expression with
     resultType string).
    :type cluster_uri: object
    :param user_name: HDInsight cluster user name. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: HDInsight cluster password.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param linked_service_name: The Azure Storage linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param hcatalog_linked_service_name: A reference to the Azure SQL linked service that points to
     the HCatalog database.
    :type hcatalog_linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param is_esp_enabled: Specify if the HDInsight is created with ESP (Enterprise Security
     Package). Type: Boolean.
    :type is_esp_enabled: object
    :param file_system: Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2.
     Type: string (or Expression with resultType string).
    :type file_system: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_uri': {'key': 'typeProperties.clusterUri', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'is_esp_enabled': {'key': 'typeProperties.isEspEnabled', 'type': 'object'},
        'file_system': {'key': 'typeProperties.fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        cluster_uri: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        hcatalog_linked_service_name: Optional["LinkedServiceReference"] = None,
        encrypted_credential: Optional[object] = None,
        is_esp_enabled: Optional[object] = None,
        file_system: Optional[object] = None,
        **kwargs
    ):
        super(HDInsightLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'HDInsight'  # type: str
        self.cluster_uri = cluster_uri
        self.user_name = user_name
        self.password = password
        self.linked_service_name = linked_service_name
        self.hcatalog_linked_service_name = hcatalog_linked_service_name
        self.encrypted_credential = encrypted_credential
        self.is_esp_enabled = is_esp_enabled
        self.file_system = file_system


class HDInsightMapReduceActivity(ExecutionActivity):
    """HDInsight MapReduce activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param class_name: Required. Class name. Type: string (or Expression with resultType string).
    :type class_name: object
    :param jar_file_path: Required. Jar path. Type: string (or Expression with resultType string).
    :type jar_file_path: object
    :param jar_linked_service: Jar linked service reference.
    :type jar_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param jar_libs: Jar libs.
    :type jar_libs: list[object]
    :param defines: Allows user to specify defines for the MapReduce job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'class_name': {'required': True},
        'jar_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'class_name': {'key': 'typeProperties.className', 'type': 'object'},
        'jar_file_path': {'key': 'typeProperties.jarFilePath', 'type': 'object'},
        'jar_linked_service': {'key': 'typeProperties.jarLinkedService', 'type': 'LinkedServiceReference'},
        'jar_libs': {'key': 'typeProperties.jarLibs', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        class_name: object,
        jar_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        jar_linked_service: Optional["LinkedServiceReference"] = None,
        jar_libs: Optional[List[object]] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightMapReduceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightMapReduce'  # type: str
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.class_name = class_name
        self.jar_file_path = jar_file_path
        self.jar_linked_service = jar_linked_service
        self.jar_libs = jar_libs
        self.defines = defines


class HDInsightOnDemandLinkedService(LinkedService):
    """HDInsight ondemand linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_size: Required. Number of worker/data nodes in the cluster. Suggestion value: 4.
     Type: string (or Expression with resultType string).
    :type cluster_size: object
    :param time_to_live: Required. The allowed idle time for the on-demand HDInsight cluster.
     Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity
     run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string
     (or Expression with resultType string).
    :type time_to_live: object
    :param version: Required. Version of the HDInsight cluster.  Type: string (or Expression with
     resultType string).
    :type version: object
    :param linked_service_name: Required. Azure Storage linked service to be used by the on-demand
     cluster for storing and processing data.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param host_subscription_id: Required. The customer’s subscription to host the cluster. Type:
     string (or Expression with resultType string).
    :type host_subscription_id: object
    :param service_principal_id: The service principal id for the hostSubscriptionId. Type: string
     (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key for the service principal id.
    :type service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :param tenant: Required. The Tenant id/name to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param cluster_resource_group: Required. The resource group where the cluster belongs. Type:
     string (or Expression with resultType string).
    :type cluster_resource_group: object
    :param cluster_name_prefix: The prefix of cluster name, postfix will be distinct with
     timestamp. Type: string (or Expression with resultType string).
    :type cluster_name_prefix: object
    :param cluster_user_name: The username to access the cluster. Type: string (or Expression with
     resultType string).
    :type cluster_user_name: object
    :param cluster_password: The password to access the cluster.
    :type cluster_password: ~azure.mgmt.datafactory.models.SecretBase
    :param cluster_ssh_user_name: The username to SSH remotely connect to cluster’s node (for
     Linux). Type: string (or Expression with resultType string).
    :type cluster_ssh_user_name: object
    :param cluster_ssh_password: The password to SSH remotely connect cluster’s node (for Linux).
    :type cluster_ssh_password: ~azure.mgmt.datafactory.models.SecretBase
    :param additional_linked_service_names: Specifies additional storage accounts for the HDInsight
     linked service so that the Data Factory service can register them on your behalf.
    :type additional_linked_service_names:
     list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param hcatalog_linked_service_name: The name of Azure SQL linked service that point to the
     HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database
     as the metastore.
    :type hcatalog_linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param cluster_type: The cluster type. Type: string (or Expression with resultType string).
    :type cluster_type: object
    :param spark_version: The version of spark if the cluster type is 'spark'. Type: string (or
     Expression with resultType string).
    :type spark_version: object
    :param core_configuration: Specifies the core configuration parameters (as in core-site.xml)
     for the HDInsight cluster to be created.
    :type core_configuration: object
    :param h_base_configuration: Specifies the HBase configuration parameters (hbase-site.xml) for
     the HDInsight cluster.
    :type h_base_configuration: object
    :param hdfs_configuration: Specifies the HDFS configuration parameters (hdfs-site.xml) for the
     HDInsight cluster.
    :type hdfs_configuration: object
    :param hive_configuration: Specifies the hive configuration parameters (hive-site.xml) for the
     HDInsight cluster.
    :type hive_configuration: object
    :param map_reduce_configuration: Specifies the MapReduce configuration parameters (mapred-
     site.xml) for the HDInsight cluster.
    :type map_reduce_configuration: object
    :param oozie_configuration: Specifies the Oozie configuration parameters (oozie-site.xml) for
     the HDInsight cluster.
    :type oozie_configuration: object
    :param storm_configuration: Specifies the Storm configuration parameters (storm-site.xml) for
     the HDInsight cluster.
    :type storm_configuration: object
    :param yarn_configuration: Specifies the Yarn configuration parameters (yarn-site.xml) for the
     HDInsight cluster.
    :type yarn_configuration: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param head_node_size: Specifies the size of the head node for the HDInsight cluster.
    :type head_node_size: object
    :param data_node_size: Specifies the size of the data node for the HDInsight cluster.
    :type data_node_size: object
    :param zookeeper_node_size: Specifies the size of the Zoo Keeper node for the HDInsight
     cluster.
    :type zookeeper_node_size: object
    :param script_actions: Custom script actions to run on HDI ondemand cluster once it's up.
     Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-
     cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-
     us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
    :type script_actions: list[~azure.mgmt.datafactory.models.ScriptAction]
    :param virtual_network_id: The ARM resource ID for the vNet to which the cluster should be
     joined after creation. Type: string (or Expression with resultType string).
    :type virtual_network_id: object
    :param subnet_name: The ARM resource ID for the subnet in the vNet. If virtualNetworkId was
     specified, then this property is required. Type: string (or Expression with resultType string).
    :type subnet_name: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_size': {'required': True},
        'time_to_live': {'required': True},
        'version': {'required': True},
        'linked_service_name': {'required': True},
        'host_subscription_id': {'required': True},
        'tenant': {'required': True},
        'cluster_resource_group': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_size': {'key': 'typeProperties.clusterSize', 'type': 'object'},
        'time_to_live': {'key': 'typeProperties.timeToLive', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'host_subscription_id': {'key': 'typeProperties.hostSubscriptionId', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'cluster_resource_group': {'key': 'typeProperties.clusterResourceGroup', 'type': 'object'},
        'cluster_name_prefix': {'key': 'typeProperties.clusterNamePrefix', 'type': 'object'},
        'cluster_user_name': {'key': 'typeProperties.clusterUserName', 'type': 'object'},
        'cluster_password': {'key': 'typeProperties.clusterPassword', 'type': 'SecretBase'},
        'cluster_ssh_user_name': {'key': 'typeProperties.clusterSshUserName', 'type': 'object'},
        'cluster_ssh_password': {'key': 'typeProperties.clusterSshPassword', 'type': 'SecretBase'},
        'additional_linked_service_names': {'key': 'typeProperties.additionalLinkedServiceNames', 'type': '[LinkedServiceReference]'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'cluster_type': {'key': 'typeProperties.clusterType', 'type': 'object'},
        'spark_version': {'key': 'typeProperties.sparkVersion', 'type': 'object'},
        'core_configuration': {'key': 'typeProperties.coreConfiguration', 'type': 'object'},
        'h_base_configuration': {'key': 'typeProperties.hBaseConfiguration', 'type': 'object'},
        'hdfs_configuration': {'key': 'typeProperties.hdfsConfiguration', 'type': 'object'},
        'hive_configuration': {'key': 'typeProperties.hiveConfiguration', 'type': 'object'},
        'map_reduce_configuration': {'key': 'typeProperties.mapReduceConfiguration', 'type': 'object'},
        'oozie_configuration': {'key': 'typeProperties.oozieConfiguration', 'type': 'object'},
        'storm_configuration': {'key': 'typeProperties.stormConfiguration', 'type': 'object'},
        'yarn_configuration': {'key': 'typeProperties.yarnConfiguration', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'head_node_size': {'key': 'typeProperties.headNodeSize', 'type': 'object'},
        'data_node_size': {'key': 'typeProperties.dataNodeSize', 'type': 'object'},
        'zookeeper_node_size': {'key': 'typeProperties.zookeeperNodeSize', 'type': 'object'},
        'script_actions': {'key': 'typeProperties.scriptActions', 'type': '[ScriptAction]'},
        'virtual_network_id': {'key': 'typeProperties.virtualNetworkId', 'type': 'object'},
        'subnet_name': {'key': 'typeProperties.subnetName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        cluster_size: object,
        time_to_live: object,
        version: object,
        linked_service_name: "LinkedServiceReference",
        host_subscription_id: object,
        tenant: object,
        cluster_resource_group: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        cluster_name_prefix: Optional[object] = None,
        cluster_user_name: Optional[object] = None,
        cluster_password: Optional["SecretBase"] = None,
        cluster_ssh_user_name: Optional[object] = None,
        cluster_ssh_password: Optional["SecretBase"] = None,
        additional_linked_service_names: Optional[List["LinkedServiceReference"]] = None,
        hcatalog_linked_service_name: Optional["LinkedServiceReference"] = None,
        cluster_type: Optional[object] = None,
        spark_version: Optional[object] = None,
        core_configuration: Optional[object] = None,
        h_base_configuration: Optional[object] = None,
        hdfs_configuration: Optional[object] = None,
        hive_configuration: Optional[object] = None,
        map_reduce_configuration: Optional[object] = None,
        oozie_configuration: Optional[object] = None,
        storm_configuration: Optional[object] = None,
        yarn_configuration: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        head_node_size: Optional[object] = None,
        data_node_size: Optional[object] = None,
        zookeeper_node_size: Optional[object] = None,
        script_actions: Optional[List["ScriptAction"]] = None,
        virtual_network_id: Optional[object] = None,
        subnet_name: Optional[object] = None,
        **kwargs
    ):
        super(HDInsightOnDemandLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'HDInsightOnDemand'  # type: str
        self.cluster_size = cluster_size
        self.time_to_live = time_to_live
        self.version = version
        self.linked_service_name = linked_service_name
        self.host_subscription_id = host_subscription_id
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.cluster_resource_group = cluster_resource_group
        self.cluster_name_prefix = cluster_name_prefix
        self.cluster_user_name = cluster_user_name
        self.cluster_password = cluster_password
        self.cluster_ssh_user_name = cluster_ssh_user_name
        self.cluster_ssh_password = cluster_ssh_password
        self.additional_linked_service_names = additional_linked_service_names
        self.hcatalog_linked_service_name = hcatalog_linked_service_name
        self.cluster_type = cluster_type
        self.spark_version = spark_version
        self.core_configuration = core_configuration
        self.h_base_configuration = h_base_configuration
        self.hdfs_configuration = hdfs_configuration
        self.hive_configuration = hive_configuration
        self.map_reduce_configuration = map_reduce_configuration
        self.oozie_configuration = oozie_configuration
        self.storm_configuration = storm_configuration
        self.yarn_configuration = yarn_configuration
        self.encrypted_credential = encrypted_credential
        self.head_node_size = head_node_size
        self.data_node_size = data_node_size
        self.zookeeper_node_size = zookeeper_node_size
        self.script_actions = script_actions
        self.virtual_network_id = virtual_network_id
        self.subnet_name = subnet_name


class HDInsightPigActivity(ExecutionActivity):
    """HDInsight Pig activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity. Type: array (or Expression
     with resultType array).
    :type arguments: object
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Pig job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': 'object'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[object] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        script_path: Optional[object] = None,
        script_linked_service: Optional["LinkedServiceReference"] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightPigActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightPig'  # type: str
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.defines = defines


class HDInsightSparkActivity(ExecutionActivity):
    """HDInsight Spark activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param root_path: Required. The root path in 'sparkJobLinkedService' for all the job’s files.
     Type: string (or Expression with resultType string).
    :type root_path: object
    :param entry_file_path: Required. The relative path to the root folder of the code/package to
     be executed. Type: string (or Expression with resultType string).
    :type entry_file_path: object
    :param arguments: The user-specified arguments to HDInsightSparkActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param spark_job_linked_service: The storage linked service for uploading the entry file and
     dependencies, and for receiving logs.
    :type spark_job_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param class_name: The application's Java/Spark main class.
    :type class_name: str
    :param proxy_user: The user to impersonate that will execute the job. Type: string (or
     Expression with resultType string).
    :type proxy_user: object
    :param spark_config: Spark configuration property.
    :type spark_config: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'root_path': {'required': True},
        'entry_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'root_path': {'key': 'typeProperties.rootPath', 'type': 'object'},
        'entry_file_path': {'key': 'typeProperties.entryFilePath', 'type': 'object'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'spark_job_linked_service': {'key': 'typeProperties.sparkJobLinkedService', 'type': 'LinkedServiceReference'},
        'class_name': {'key': 'typeProperties.className', 'type': 'str'},
        'proxy_user': {'key': 'typeProperties.proxyUser', 'type': 'object'},
        'spark_config': {'key': 'typeProperties.sparkConfig', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        root_path: object,
        entry_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        spark_job_linked_service: Optional["LinkedServiceReference"] = None,
        class_name: Optional[str] = None,
        proxy_user: Optional[object] = None,
        spark_config: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightSparkActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightSpark'  # type: str
        self.root_path = root_path
        self.entry_file_path = entry_file_path
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.spark_job_linked_service = spark_job_linked_service
        self.class_name = class_name
        self.proxy_user = proxy_user
        self.spark_config = spark_config


class HDInsightStreamingActivity(ExecutionActivity):
    """HDInsight streaming activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.mgmt.datafactory.models.HDInsightActivityDebugInfoOption
    :param mapper: Required. Mapper executable name. Type: string (or Expression with resultType
     string).
    :type mapper: object
    :param reducer: Required. Reducer executable name. Type: string (or Expression with resultType
     string).
    :type reducer: object
    :param input: Required. Input blob path. Type: string (or Expression with resultType string).
    :type input: object
    :param output: Required. Output blob path. Type: string (or Expression with resultType string).
    :type output: object
    :param file_paths: Required. Paths to streaming job files. Can be directories.
    :type file_paths: list[object]
    :param file_linked_service: Linked service reference where the files are located.
    :type file_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param combiner: Combiner executable name. Type: string (or Expression with resultType string).
    :type combiner: object
    :param command_environment: Command line environment values.
    :type command_environment: list[object]
    :param defines: Allows user to specify defines for streaming job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'mapper': {'required': True},
        'reducer': {'required': True},
        'input': {'required': True},
        'output': {'required': True},
        'file_paths': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'mapper': {'key': 'typeProperties.mapper', 'type': 'object'},
        'reducer': {'key': 'typeProperties.reducer', 'type': 'object'},
        'input': {'key': 'typeProperties.input', 'type': 'object'},
        'output': {'key': 'typeProperties.output', 'type': 'object'},
        'file_paths': {'key': 'typeProperties.filePaths', 'type': '[object]'},
        'file_linked_service': {'key': 'typeProperties.fileLinkedService', 'type': 'LinkedServiceReference'},
        'combiner': {'key': 'typeProperties.combiner', 'type': 'object'},
        'command_environment': {'key': 'typeProperties.commandEnvironment', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        mapper: object,
        reducer: object,
        input: object,
        output: object,
        file_paths: List[object],
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        file_linked_service: Optional["LinkedServiceReference"] = None,
        combiner: Optional[object] = None,
        command_environment: Optional[List[object]] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightStreamingActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type = 'HDInsightStreaming'  # type: str
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.mapper = mapper
        self.reducer = reducer
        self.input = input
        self.output = output
        self.file_paths = file_paths
        self.file_linked_service = file_linked_service
        self.combiner = combiner
        self.command_environment = command_environment
        self.defines = defines


class HiveLinkedService(LinkedService):
    """Hive Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. IP address or host name of the Hive server, separated by ';' for
     multiple hosts (only when serviceDiscoveryMode is enable).
    :type host: object
    :param port: The TCP port that the Hive server uses to listen for client connections.
    :type port: object
    :param server_type: The type of Hive server. Possible values include: "HiveServer1",
     "HiveServer2", "HiveThriftServer".
    :type server_type: str or ~azure.mgmt.datafactory.models.HiveServerType
    :param thrift_transport_protocol: The transport protocol to use in the Thrift layer. Possible
     values include: "Binary", "SASL", "HTTP ".
    :type thrift_transport_protocol: str or
     ~azure.mgmt.datafactory.models.HiveThriftTransportProtocol
    :param authentication_type: Required. The authentication method used to access the Hive server.
     Possible values include: "Anonymous", "Username", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.HiveAuthenticationType
    :param service_discovery_mode: true to indicate using the ZooKeeper service, false not.
    :type service_discovery_mode: object
    :param zoo_keeper_name_space: The namespace on ZooKeeper under which Hive Server 2 nodes are
     added.
    :type zoo_keeper_name_space: object
    :param use_native_query: Specifies whether the driver uses native HiveQL queries,or converts
     them into an equivalent form in HiveQL.
    :type use_native_query: object
    :param username: The user name that you use to access Hive Server.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the Username
     field.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param http_path: The partial URL corresponding to the Hive server.
    :type http_path: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'server_type': {'key': 'typeProperties.serverType', 'type': 'str'},
        'thrift_transport_protocol': {'key': 'typeProperties.thriftTransportProtocol', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'service_discovery_mode': {'key': 'typeProperties.serviceDiscoveryMode', 'type': 'object'},
        'zoo_keeper_name_space': {'key': 'typeProperties.zooKeeperNameSpace', 'type': 'object'},
        'use_native_query': {'key': 'typeProperties.useNativeQuery', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "HiveAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        server_type: Optional[Union[str, "HiveServerType"]] = None,
        thrift_transport_protocol: Optional[Union[str, "HiveThriftTransportProtocol"]] = None,
        service_discovery_mode: Optional[object] = None,
        zoo_keeper_name_space: Optional[object] = None,
        use_native_query: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        http_path: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(HiveLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'Hive'  # type: str
        self.host = host
        self.port = port
        self.server_type = server_type
        self.thrift_transport_protocol = thrift_transport_protocol
        self.authentication_type = authentication_type
        self.service_discovery_mode = service_discovery_mode
        self.zoo_keeper_name_space = zoo_keeper_name_space
        self.use_native_query = use_native_query
        self.username = username
        self.password = password
        self.http_path = http_path
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class HiveObjectDataset(Dataset):
    """Hive Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Hive. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Hive. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(HiveObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'HiveObject'  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class HiveSource(TabularSource):
    """A copy activity Hive Server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects (or Expression with resultType array of objects).
    :type additional_columns: list[~azure.mgmt.datafactory.models.AdditionalColumns]
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'additional_columns': {'key': 'additionalColumns', 'type': '[AdditionalColumns]'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        query_timeout: Optional[object] = None,
        additional_columns: Optional[List["AdditionalColumns"]] = None,
        query: Optional[object] = None,
        **kwargs
    ):
        super(HiveSource, self).__init__(additional_properties=additional_properties, source_retry_count=source_retry_count, source_retry_wait=source_retry_wait, max_concurrent_connections=max_concurrent_connections, query_timeout=query_timeout, additional_columns=additional_columns, **kwargs)
        self.type = 'HiveSource'  # type: str
        self.query = query


class HttpDataset(Dataset):
    """A file in an HTTP web server.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param relative_url: The relative URL based on the URL in the HttpLinkedService refers to an
     HTTP file Type: string (or Expression with resultType string).
    :type relative_url: object
    :param request_method: The HTTP method for the HTTP request. Type: string (or Expression with
     resultType string).
    :type request_method: object
    :param request_body: The body for the HTTP request. Type: string (or Expression with resultType
     string).
    :type request_body: object
    :param additional_headers: The headers for the HTTP Request. e.g. request-header-
     name-1:request-header-value-1
     ...
     request-header-name-n:request-header-value-n Type: string (or Expression with resultType
     string).
    :type additional_headers: object
    :param format: The format of files.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used on files.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'relative_url': {'key': 'typeProperties.relativeUrl', 'type': 'object'},
        'request_method': {'key': 'typeProperties.requestMethod', 'type': 'object'},
        'request_body': {'key': 'typeProperties.requestBody', 'type': 'object'},
        'additional_headers': {'key': 'typeProperties.additionalHeaders', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        relative_url: Optional[object] = None,
        request_method: Optional[object] = None,
        request_body: Optional[object] = None,
        additional_headers: Optional[object] = None,
        format: Optional["DatasetStorageFormat"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(HttpDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type = 'HttpFile'  # type: str
        self.relative_url = relative_url
        self.request_method = request_method
        self.request_body = request_body
        self.additional_headers = additional_headers
        self.format = format
        self.compression = compression


class HttpLinkedService(LinkedService):
    """Linked service for an HTTP source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The base URL of the HTTP endpoint, e.g. http://www.microsoft.com. Type:
     string (or Expression with resultType string).
    :type url: object
    :param authentication_type: The authentication type to be used to connect to the HTTP server.
     Possible values include: "Basic", "Anonymous", "Digest", "Windows", "ClientCertificate".
    :type authentication_type: str or ~azure.mgmt.datafactory.models.HttpAuthenticationType
    :param user_name: User name for Basic, Digest, or Windows authentication. Type: string (or
     Expression with resultType string).
    :type user_name: object
    :param password: Password for Basic, Digest, Windows, or ClientCertificate with
     EmbeddedCertData authentication.
    :type password: ~azure.mgmt.datafactory.models.SecretBase
    :param auth_headers: The additional HTTP headers in the request to RESTful API used for
     authorization. Type: object (or Expression with resultType object).
    :type auth_headers: object
    :param embedded_cert_data: Base64 encoded certificate data for ClientCertificate
     authentication. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type embedded_cert_data: object
    :param cert_thumbprint: Thumbprint of certificate for ClientCertificate authentication. Only
     valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type cert_thumbprint: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_server_certificate_validation: If true, validate the HTTPS server SSL
     certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'auth_headers': {'key': 'typeProperties.authHeaders', 'type': 'object'},
        'embedded_cert_data': {'key': 'typeProperties.embeddedCertData', 'type': 'object'},
        'cert_thumbprint': {'key': 'typeProperties.certThumbprint', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[Union[str, "HttpAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        auth_headers: Optional[object] = None,
        embedded_cert_data: Optional[object] = None,
        cert_thumbprint: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        enable_server_certificate_validation: Optional[object] = None,
        **kwargs
    ):
        super(HttpLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type = 'HttpServer'  # type: str
        self.url = url
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.auth_headers = auth_headers
        self.embedded_cert_data = embedded_cert_data
        self.cert_thumbprint = cert_thumbprint
        self.encrypted_credential = encrypted_credential
        self.enable_server_certificate_validation = enable_server_certificate_validation


class HttpReadSettings(StoreReadSettings):
    """Sftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param request_method: The HTTP method used to call the RESTful API. The default is GET. Type:
     string (or Expression with resultType string).
    :type request_method: object
    :param request_body: The HTTP request body to the RESTful API if requestMethod is POST. Type:
     string (or Expression with resultType string).
    :type request_body: object
    :param additional_headers: The additional HTTP headers in the request to the RESTful API. Type:
     string (or Expression with resultType string).
    :type additional_headers: object
    :param request_timeout: Specifies the timeout for a HTTP client to get HTTP response from HTTP
     server.
    :type request_timeout: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :type partition_root_path: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'request_method': {'key': 'requestMethod', 'type': 'object'},
        'request_body': {'key': 'requestBody', 'type': 'object'},
        'additional_headers': {'key': 'additionalHeaders', 'type': 'object'},
        'request_timeout': {'key': 'requestTimeout', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'partition_root_path': {'key': 'partitionRootPath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        max_concurrent_connections: Optional[object] = None,
        request_method: Optional[object] = None,
        request_body: Optional[object] = None,
        additional_headers: Optional[object] = None,
        request_timeout: Optional[object] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[object] = None,
        **kwargs
    ):
        super(HttpReadSettings, self).__init__(additional_properties=additional_properties, max_concurrent_connections=max_concurrent_connections, **kwargs)
        self.type = 'HttpReadSettings'  # type: str
        self.request_method = request_method
        self.request_body = request_body
        self.additional_headers = additional_headers
        self.request_timeout = request_timeout
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path


class HttpServerLocation(DatasetLocation):
    """The location of http server.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param relative_url: Specify the relativeUrl of http server. Type: string (or Expression with
     resultType string).
    :type relative_url: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'relative_url': {'key': 'relativeUrl', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        relative_url: Optional[object] = None,
        **kwargs
    ):
        super(HttpServerLocation, self).__init__(additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs)
        self.type = 'HttpServerLocation'  # type: str
        self.relative_url = relative_url


class HttpSource(CopySource):
    """A copy activity source for an HTTP file.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param http_request_timeout: Specifies the timeout for a HTTP client to get HTTP response from
     HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string
     (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type http_request_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type'