# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import importlib
import sys


if sys.version_info < (3, 7):
    raise ImportError("This module requires Python 3.7 or later.")


_lazy_type_to_package_map = {
    # Message types
    "AdAssetPolicySummary": "google.ads.googleads.v7.common.types.asset_policy",
    "AddressInfo": "google.ads.googleads.v7.common.types.criteria",
    "AdImageAsset": "google.ads.googleads.v7.common.types.ad_asset",
    "AdMediaBundleAsset": "google.ads.googleads.v7.common.types.ad_asset",
    "AdScheduleInfo": "google.ads.googleads.v7.common.types.criteria",
    "AdTextAsset": "google.ads.googleads.v7.common.types.ad_asset",
    "AdVideoAsset": "google.ads.googleads.v7.common.types.ad_asset",
    "AffiliateLocationFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "AgeRangeInfo": "google.ads.googleads.v7.common.types.criteria",
    "AppAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "AppEngagementAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "AppFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "AppPaymentModelInfo": "google.ads.googleads.v7.common.types.criteria",
    "BasicUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "BidModifierSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "BidModifierSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "BookOnGoogleAsset": "google.ads.googleads.v7.common.types.asset_types",
    "BudgetCampaignAssociationStatus": "google.ads.googleads.v7.common.types.segments",
    "BudgetSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "BudgetSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "BusinessNameFilter": "google.ads.googleads.v7.common.types.feed_item_set_filter_type_infos",
    "CallFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "CallOnlyAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "CalloutAsset": "google.ads.googleads.v7.common.types.asset_types",
    "CalloutFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "CarrierInfo": "google.ads.googleads.v7.common.types.criteria",
    "ClickLocation": "google.ads.googleads.v7.common.types.click_location",
    "CombinedAudienceInfo": "google.ads.googleads.v7.common.types.criteria",
    "CombinedRuleUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "Commission": "google.ads.googleads.v7.common.types.bidding",
    "ConceptGroup": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "ContentLabelInfo": "google.ads.googleads.v7.common.types.criteria",
    "CpcBidSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "CpcBidSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "CpvBidSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "CpvBidSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "CriterionCategoryAvailability": "google.ads.googleads.v7.common.types.criterion_category_availability",
    "CriterionCategoryChannelAvailability": "google.ads.googleads.v7.common.types.criterion_category_availability",
    "CriterionCategoryLocaleAvailability": "google.ads.googleads.v7.common.types.criterion_category_availability",
    "CrmBasedUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "CustomAffinityInfo": "google.ads.googleads.v7.common.types.criteria",
    "CustomAudienceInfo": "google.ads.googleads.v7.common.types.criteria",
    "CustomerMatchUserListMetadata": "google.ads.googleads.v7.common.types.offline_user_data",
    "CustomIntentInfo": "google.ads.googleads.v7.common.types.criteria",
    "CustomParameter": "google.ads.googleads.v7.common.types.custom_parameter",
    "DateRange": "google.ads.googleads.v7.common.types.dates",
    "DateSpecificRuleUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "DeviceInfo": "google.ads.googleads.v7.common.types.criteria",
    "DisplayCallToAction": "google.ads.googleads.v7.common.types.ad_type_infos",
    "DisplayUploadAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "DynamicAffiliateLocationSetFilter": "google.ads.googleads.v7.common.types.feed_item_set_filter_type_infos",
    "DynamicLocationSetFilter": "google.ads.googleads.v7.common.types.feed_item_set_filter_type_infos",
    "EnhancedCpc": "google.ads.googleads.v7.common.types.bidding",
    "ExpandedDynamicSearchAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ExpandedTextAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ExplorerAutoOptimizerSetting": "google.ads.googleads.v7.common.types.explorer_auto_optimizer_setting",
    "ExpressionRuleUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "FinalAppUrl": "google.ads.googleads.v7.common.types.final_app_url",
    "FrequencyCapEntry": "google.ads.googleads.v7.common.types.frequency_cap",
    "FrequencyCapKey": "google.ads.googleads.v7.common.types.frequency_cap",
    "GenderInfo": "google.ads.googleads.v7.common.types.criteria",
    "GeoPointInfo": "google.ads.googleads.v7.common.types.criteria",
    "GmailAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "GmailTeaser": "google.ads.googleads.v7.common.types.ad_type_infos",
    "HistoricalMetricsOptions": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "HotelAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "HotelAdvanceBookingWindowInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelCalloutFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "HotelCheckInDateRangeInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelCheckInDayInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelCityInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelClassInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelCountryRegionInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelDateSelectionTypeInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelIdInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelLengthOfStayInfo": "google.ads.googleads.v7.common.types.criteria",
    "HotelStateInfo": "google.ads.googleads.v7.common.types.criteria",
    "ImageAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ImageAsset": "google.ads.googleads.v7.common.types.asset_types",
    "ImageDimension": "google.ads.googleads.v7.common.types.asset_types",
    "ImageFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "IncomeRangeInfo": "google.ads.googleads.v7.common.types.criteria",
    "InteractionTypeInfo": "google.ads.googleads.v7.common.types.criteria",
    "IpBlockInfo": "google.ads.googleads.v7.common.types.criteria",
    "Keyword": "google.ads.googleads.v7.common.types.segments",
    "KeywordAnnotations": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "KeywordConcept": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "KeywordInfo": "google.ads.googleads.v7.common.types.criteria",
    "KeywordPlanAggregateMetricResults": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "KeywordPlanAggregateMetrics": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "KeywordPlanDeviceSearches": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "KeywordPlanHistoricalMetrics": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "LanguageInfo": "google.ads.googleads.v7.common.types.criteria",
    "LeadFormAsset": "google.ads.googleads.v7.common.types.asset_types",
    "LeadFormDeliveryMethod": "google.ads.googleads.v7.common.types.asset_types",
    "LeadFormField": "google.ads.googleads.v7.common.types.asset_types",
    "LeadFormSingleChoiceAnswers": "google.ads.googleads.v7.common.types.asset_types",
    "LegacyAppInstallAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "LegacyResponsiveDisplayAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ListingDimensionInfo": "google.ads.googleads.v7.common.types.criteria",
    "ListingGroupInfo": "google.ads.googleads.v7.common.types.criteria",
    "ListingScopeInfo": "google.ads.googleads.v7.common.types.criteria",
    "LocalAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "LocationFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "LocationGroupInfo": "google.ads.googleads.v7.common.types.criteria",
    "LocationInfo": "google.ads.googleads.v7.common.types.criteria",
    "LogicalUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "LogicalUserListOperandInfo": "google.ads.googleads.v7.common.types.user_lists",
    "ManualCpc": "google.ads.googleads.v7.common.types.bidding",
    "ManualCpm": "google.ads.googleads.v7.common.types.bidding",
    "ManualCpv": "google.ads.googleads.v7.common.types.bidding",
    "MatchingFunction": "google.ads.googleads.v7.common.types.matching_function",
    "MaximizeConversions": "google.ads.googleads.v7.common.types.bidding",
    "MaximizeConversionValue": "google.ads.googleads.v7.common.types.bidding",
    "MediaBundleAsset": "google.ads.googleads.v7.common.types.asset_types",
    "Metrics": "google.ads.googleads.v7.common.types.metrics",
    "MobileAppCategoryInfo": "google.ads.googleads.v7.common.types.criteria",
    "MobileApplicationInfo": "google.ads.googleads.v7.common.types.criteria",
    "MobileDeviceInfo": "google.ads.googleads.v7.common.types.criteria",
    "Money": "google.ads.googleads.v7.common.types.feed_common",
    "MonthlySearchVolume": "google.ads.googleads.v7.common.types.keyword_plan_common",
    "OfflineUserAddressInfo": "google.ads.googleads.v7.common.types.offline_user_data",
    "Operand": "google.ads.googleads.v7.common.types.matching_function",
    "OperatingSystemVersionInfo": "google.ads.googleads.v7.common.types.criteria",
    "ParentalStatusInfo": "google.ads.googleads.v7.common.types.criteria",
    "PercentCpc": "google.ads.googleads.v7.common.types.bidding",
    "PercentCpcBidSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "PercentCpcBidSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "PlacementInfo": "google.ads.googleads.v7.common.types.criteria",
    "PolicyTopicConstraint": "google.ads.googleads.v7.common.types.policy",
    "PolicyTopicEntry": "google.ads.googleads.v7.common.types.policy",
    "PolicyTopicEvidence": "google.ads.googleads.v7.common.types.policy",
    "PolicyValidationParameter": "google.ads.googleads.v7.common.types.policy",
    "PolicyViolationKey": "google.ads.googleads.v7.common.types.policy",
    "PreferredContentInfo": "google.ads.googleads.v7.common.types.criteria",
    "PriceFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "PriceOffer": "google.ads.googleads.v7.common.types.extensions",
    "ProductBiddingCategoryInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductBrandInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductChannelExclusivityInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductChannelInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductConditionInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductCustomAttributeInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductImage": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ProductItemIdInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductTypeInfo": "google.ads.googleads.v7.common.types.criteria",
    "ProductVideo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "PromotionAsset": "google.ads.googleads.v7.common.types.asset_types",
    "PromotionFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "ProximityInfo": "google.ads.googleads.v7.common.types.criteria",
    "RealTimeBiddingSetting": "google.ads.googleads.v7.common.types.real_time_bidding_setting",
    "ResponsiveDisplayAdControlSpec": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ResponsiveDisplayAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ResponsiveSearchAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "RuleBasedUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "Segments": "google.ads.googleads.v7.common.types.segments",
    "ShoppingComparisonListingAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ShoppingProductAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "ShoppingSmartAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "SimilarUserListInfo": "google.ads.googleads.v7.common.types.user_lists",
    "SitelinkAsset": "google.ads.googleads.v7.common.types.asset_types",
    "SitelinkFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "StoreAttribute": "google.ads.googleads.v7.common.types.offline_user_data",
    "StoreSalesMetadata": "google.ads.googleads.v7.common.types.offline_user_data",
    "StoreSalesThirdPartyMetadata": "google.ads.googleads.v7.common.types.offline_user_data",
    "StructuredSnippetAsset": "google.ads.googleads.v7.common.types.asset_types",
    "StructuredSnippetFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "TagSnippet": "google.ads.googleads.v7.common.types.tag_snippet",
    "TargetCpa": "google.ads.googleads.v7.common.types.bidding",
    "TargetCpaSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "TargetCpaSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "TargetCpm": "google.ads.googleads.v7.common.types.bidding",
    "TargetImpressionShare": "google.ads.googleads.v7.common.types.bidding",
    "TargetImpressionShareSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "TargetImpressionShareSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "TargetingSetting": "google.ads.googleads.v7.common.types.targeting_setting",
    "TargetRestriction": "google.ads.googleads.v7.common.types.targeting_setting",
    "TargetRestrictionOperation": "google.ads.googleads.v7.common.types.targeting_setting",
    "TargetRoas": "google.ads.googleads.v7.common.types.bidding",
    "TargetRoasSimulationPoint": "google.ads.googleads.v7.common.types.simulation",
    "TargetRoasSimulationPointList": "google.ads.googleads.v7.common.types.simulation",
    "TargetSpend": "google.ads.googleads.v7.common.types.bidding",
    "TextAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "TextAsset": "google.ads.googleads.v7.common.types.asset_types",
    "TextLabel": "google.ads.googleads.v7.common.types.text_label",
    "TextMessageFeedItem": "google.ads.googleads.v7.common.types.extensions",
    "TopicInfo": "google.ads.googleads.v7.common.types.criteria",
    "TransactionAttribute": "google.ads.googleads.v7.common.types.offline_user_data",
    "UnknownListingDimensionInfo": "google.ads.googleads.v7.common.types.criteria",
    "UrlCollection": "google.ads.googleads.v7.common.types.url_collection",
    "UserAttribute": "google.ads.googleads.v7.common.types.offline_user_data",
    "UserData": "google.ads.googleads.v7.common.types.offline_user_data",
    "UserIdentifier": "google.ads.googleads.v7.common.types.offline_user_data",
    "UserInterestInfo": "google.ads.googleads.v7.common.types.criteria",
    "UserListActionInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListDateRuleItemInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListInfo": "google.ads.googleads.v7.common.types.criteria",
    "UserListLogicalRuleInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListNumberRuleItemInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListRuleInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListRuleItemGroupInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListRuleItemInfo": "google.ads.googleads.v7.common.types.user_lists",
    "UserListStringRuleItemInfo": "google.ads.googleads.v7.common.types.user_lists",
    "Value": "google.ads.googleads.v7.common.types.value",
    "VideoAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoBumperInStreamAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoNonSkippableInStreamAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoOutstreamAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoResponsiveAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoTrueViewDiscoveryAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "VideoTrueViewInStreamAdInfo": "google.ads.googleads.v7.common.types.ad_type_infos",
    "WebhookDelivery": "google.ads.googleads.v7.common.types.asset_types",
    "WebpageConditionInfo": "google.ads.googleads.v7.common.types.criteria",
    "WebpageInfo": "google.ads.googleads.v7.common.types.criteria",
    "WebpageSampleInfo": "google.ads.googleads.v7.common.types.criteria",
    "YearMonth": "google.ads.googleads.v7.common.types.dates",
    "YearMonthRange": "google.ads.googleads.v7.common.types.dates",
    "YouTubeChannelInfo": "google.ads.googleads.v7.common.types.criteria",
    "YoutubeVideoAsset": "google.ads.googleads.v7.common.types.asset_types",
    "YouTubeVideoInfo": "google.ads.googleads.v7.common.types.criteria",
    "AccessInvitationStatusEnum": "google.ads.googleads.v7.enums.types.access_invitation_status",
    "AccessReasonEnum": "google.ads.googleads.v7.enums.types.access_reason",
    "AccessRoleEnum": "google.ads.googleads.v7.enums.types.access_role",
    "AccountBudgetProposalStatusEnum": "google.ads.googleads.v7.enums.types.account_budget_proposal_status",
    "AccountBudgetProposalTypeEnum": "google.ads.googleads.v7.enums.types.account_budget_proposal_type",
    "AccountBudgetStatusEnum": "google.ads.googleads.v7.enums.types.account_budget_status",
    "AccountLinkStatusEnum": "google.ads.googleads.v7.enums.types.account_link_status",
    "AdCustomizerPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.ad_customizer_placeholder_field",
    "AdDestinationTypeEnum": "google.ads.googleads.v7.enums.types.ad_destination_type",
    "AdGroupAdRotationModeEnum": "google.ads.googleads.v7.enums.types.ad_group_ad_rotation_mode",
    "AdGroupAdStatusEnum": "google.ads.googleads.v7.enums.types.ad_group_ad_status",
    "AdGroupCriterionApprovalStatusEnum": "google.ads.googleads.v7.enums.types.ad_group_criterion_approval_status",
    "AdGroupCriterionStatusEnum": "google.ads.googleads.v7.enums.types.ad_group_criterion_status",
    "AdGroupStatusEnum": "google.ads.googleads.v7.enums.types.ad_group_status",
    "AdGroupTypeEnum": "google.ads.googleads.v7.enums.types.ad_group_type",
    "AdNetworkTypeEnum": "google.ads.googleads.v7.enums.types.ad_network_type",
    "AdServingOptimizationStatusEnum": "google.ads.googleads.v7.enums.types.ad_serving_optimization_status",
    "AdStrengthEnum": "google.ads.googleads.v7.enums.types.ad_strength",
    "AdTypeEnum": "google.ads.googleads.v7.enums.types.ad_type",
    "AdvertisingChannelSubTypeEnum": "google.ads.googleads.v7.enums.types.advertising_channel_sub_type",
    "AdvertisingChannelTypeEnum": "google.ads.googleads.v7.enums.types.advertising_channel_type",
    "AffiliateLocationFeedRelationshipTypeEnum": "google.ads.googleads.v7.enums.types.affiliate_location_feed_relationship_type",
    "AffiliateLocationPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.affiliate_location_placeholder_field",
    "AgeRangeTypeEnum": "google.ads.googleads.v7.enums.types.age_range_type",
    "AppCampaignAppStoreEnum": "google.ads.googleads.v7.enums.types.app_campaign_app_store",
    "AppCampaignBiddingStrategyGoalTypeEnum": "google.ads.googleads.v7.enums.types.app_campaign_bidding_strategy_goal_type",
    "AppPaymentModelTypeEnum": "google.ads.googleads.v7.enums.types.app_payment_model_type",
    "AppPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.app_placeholder_field",
    "AppStoreEnum": "google.ads.googleads.v7.enums.types.app_store",
    "AppUrlOperatingSystemTypeEnum": "google.ads.googleads.v7.enums.types.app_url_operating_system_type",
    "AssetFieldTypeEnum": "google.ads.googleads.v7.enums.types.asset_field_type",
    "AssetLinkStatusEnum": "google.ads.googleads.v7.enums.types.asset_link_status",
    "AssetPerformanceLabelEnum": "google.ads.googleads.v7.enums.types.asset_performance_label",
    "AssetTypeEnum": "google.ads.googleads.v7.enums.types.asset_type",
    "AttributionModelEnum": "google.ads.googleads.v7.enums.types.attribution_model",
    "BatchJobStatusEnum": "google.ads.googleads.v7.enums.types.batch_job_status",
    "BiddingSourceEnum": "google.ads.googleads.v7.enums.types.bidding_source",
    "BiddingStrategyStatusEnum": "google.ads.googleads.v7.enums.types.bidding_strategy_status",
    "BiddingStrategyTypeEnum": "google.ads.googleads.v7.enums.types.bidding_strategy_type",
    "BidModifierSourceEnum": "google.ads.googleads.v7.enums.types.bid_modifier_source",
    "BillingSetupStatusEnum": "google.ads.googleads.v7.enums.types.billing_setup_status",
    "BrandSafetySuitabilityEnum": "google.ads.googleads.v7.enums.types.brand_safety_suitability",
    "BudgetCampaignAssociationStatusEnum": "google.ads.googleads.v7.enums.types.budget_campaign_association_status",
    "BudgetDeliveryMethodEnum": "google.ads.googleads.v7.enums.types.budget_delivery_method",
    "BudgetPeriodEnum": "google.ads.googleads.v7.enums.types.budget_period",
    "BudgetStatusEnum": "google.ads.googleads.v7.enums.types.budget_status",
    "BudgetTypeEnum": "google.ads.googleads.v7.enums.types.budget_type",
    "CallConversionReportingStateEnum": "google.ads.googleads.v7.enums.types.call_conversion_reporting_state",
    "CalloutPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.callout_placeholder_field",
    "CallPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.call_placeholder_field",
    "CallTrackingDisplayLocationEnum": "google.ads.googleads.v7.enums.types.call_tracking_display_location",
    "CallTypeEnum": "google.ads.googleads.v7.enums.types.call_type",
    "CampaignCriterionStatusEnum": "google.ads.googleads.v7.enums.types.campaign_criterion_status",
    "CampaignDraftStatusEnum": "google.ads.googleads.v7.enums.types.campaign_draft_status",
    "CampaignExperimentStatusEnum": "google.ads.googleads.v7.enums.types.campaign_experiment_status",
    "CampaignExperimentTrafficSplitTypeEnum": "google.ads.googleads.v7.enums.types.campaign_experiment_traffic_split_type",
    "CampaignExperimentTypeEnum": "google.ads.googleads.v7.enums.types.campaign_experiment_type",
    "CampaignServingStatusEnum": "google.ads.googleads.v7.enums.types.campaign_serving_status",
    "CampaignSharedSetStatusEnum": "google.ads.googleads.v7.enums.types.campaign_shared_set_status",
    "CampaignStatusEnum": "google.ads.googleads.v7.enums.types.campaign_status",
    "ChangeClientTypeEnum": "google.ads.googleads.v7.enums.types.change_client_type",
    "ChangeEventResourceTypeEnum": "google.ads.googleads.v7.enums.types.change_event_resource_type",
    "ChangeStatusOperationEnum": "google.ads.googleads.v7.enums.types.change_status_operation",
    "ChangeStatusResourceTypeEnum": "google.ads.googleads.v7.enums.types.change_status_resource_type",
    "ClickTypeEnum": "google.ads.googleads.v7.enums.types.click_type",
    "CombinedAudienceStatusEnum": "google.ads.googleads.v7.enums.types.combined_audience_status",
    "ContentLabelTypeEnum": "google.ads.googleads.v7.enums.types.content_label_type",
    "ConversionActionCategoryEnum": "google.ads.googleads.v7.enums.types.conversion_action_category",
    "ConversionActionCountingTypeEnum": "google.ads.googleads.v7.enums.types.conversion_action_counting_type",
    "ConversionActionStatusEnum": "google.ads.googleads.v7.enums.types.conversion_action_status",
    "ConversionActionTypeEnum": "google.ads.googleads.v7.enums.types.conversion_action_type",
    "ConversionAdjustmentTypeEnum": "google.ads.googleads.v7.enums.types.conversion_adjustment_type",
    "ConversionAttributionEventTypeEnum": "google.ads.googleads.v7.enums.types.conversion_attribution_event_type",
    "ConversionCustomVariableStatusEnum": "google.ads.googleads.v7.enums.types.conversion_custom_variable_status",
    "ConversionLagBucketEnum": "google.ads.googleads.v7.enums.types.conversion_lag_bucket",
    "ConversionOrAdjustmentLagBucketEnum": "google.ads.googleads.v7.enums.types.conversion_or_adjustment_lag_bucket",
    "CriterionCategoryChannelAvailabilityModeEnum": "google.ads.googleads.v7.enums.types.criterion_category_channel_availability_mode",
    "CriterionCategoryLocaleAvailabilityModeEnum": "google.ads.googleads.v7.enums.types.criterion_category_locale_availability_mode",
    "CriterionSystemServingStatusEnum": "google.ads.googleads.v7.enums.types.criterion_system_serving_status",
    "CriterionTypeEnum": "google.ads.googleads.v7.enums.types.criterion_type",
    "CustomAudienceMemberTypeEnum": "google.ads.googleads.v7.enums.types.custom_audience_member_type",
    "CustomAudienceStatusEnum": "google.ads.googleads.v7.enums.types.custom_audience_status",
    "CustomAudienceTypeEnum": "google.ads.googleads.v7.enums.types.custom_audience_type",
    "CustomerMatchUploadKeyTypeEnum": "google.ads.googleads.v7.enums.types.customer_match_upload_key_type",
    "CustomerPayPerConversionEligibilityFailureReasonEnum": "google.ads.googleads.v7.enums.types.customer_pay_per_conversion_eligibility_failure_reason",
    "CustomInterestMemberTypeEnum": "google.ads.googleads.v7.enums.types.custom_interest_member_type",
    "CustomInterestStatusEnum": "google.ads.googleads.v7.enums.types.custom_interest_status",
    "CustomInterestTypeEnum": "google.ads.googleads.v7.enums.types.custom_interest_type",
    "CustomPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.custom_placeholder_field",
    "DataDrivenModelStatusEnum": "google.ads.googleads.v7.enums.types.data_driven_model_status",
    "DayOfWeekEnum": "google.ads.googleads.v7.enums.types.day_of_week",
    "DeviceEnum": "google.ads.googleads.v7.enums.types.device",
    "DisplayAdFormatSettingEnum": "google.ads.googleads.v7.enums.types.display_ad_format_setting",
    "DisplayUploadProductTypeEnum": "google.ads.googleads.v7.enums.types.display_upload_product_type",
    "DistanceBucketEnum": "google.ads.googleads.v7.enums.types.distance_bucket",
    "DsaPageFeedCriterionFieldEnum": "google.ads.googleads.v7.enums.types.dsa_page_feed_criterion_field",
    "EducationPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.education_placeholder_field",
    "ExtensionSettingDeviceEnum": "google.ads.googleads.v7.enums.types.extension_setting_device",
    "ExtensionTypeEnum": "google.ads.googleads.v7.enums.types.extension_type",
    "ExternalConversionSourceEnum": "google.ads.googleads.v7.enums.types.external_conversion_source",
    "FeedAttributeTypeEnum": "google.ads.googleads.v7.enums.types.feed_attribute_type",
    "FeedItemQualityApprovalStatusEnum": "google.ads.googleads.v7.enums.types.feed_item_quality_approval_status",
    "FeedItemQualityDisapprovalReasonEnum": "google.ads.googleads.v7.enums.types.feed_item_quality_disapproval_reason",
    "FeedItemSetStatusEnum": "google.ads.googleads.v7.enums.types.feed_item_set_status",
    "FeedItemSetStringFilterTypeEnum": "google.ads.googleads.v7.enums.types.feed_item_set_string_filter_type",
    "FeedItemStatusEnum": "google.ads.googleads.v7.enums.types.feed_item_status",
    "FeedItemTargetDeviceEnum": "google.ads.googleads.v7.enums.types.feed_item_target_device",
    "FeedItemTargetStatusEnum": "google.ads.googleads.v7.enums.types.feed_item_target_status",
    "FeedItemTargetTypeEnum": "google.ads.googleads.v7.enums.types.feed_item_target_type",
    "FeedItemValidationStatusEnum": "google.ads.googleads.v7.enums.types.feed_item_validation_status",
    "FeedLinkStatusEnum": "google.ads.googleads.v7.enums.types.feed_link_status",
    "FeedMappingCriterionTypeEnum": "google.ads.googleads.v7.enums.types.feed_mapping_criterion_type",
    "FeedMappingStatusEnum": "google.ads.googleads.v7.enums.types.feed_mapping_status",
    "FeedOriginEnum": "google.ads.googleads.v7.enums.types.feed_origin",
    "FeedStatusEnum": "google.ads.googleads.v7.enums.types.feed_status",
    "FlightPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.flight_placeholder_field",
    "FrequencyCapEventTypeEnum": "google.ads.googleads.v7.enums.types.frequency_cap_event_type",
    "FrequencyCapLevelEnum": "google.ads.googleads.v7.enums.types.frequency_cap_level",
    "FrequencyCapTimeUnitEnum": "google.ads.googleads.v7.enums.types.frequency_cap_time_unit",
    "GenderTypeEnum": "google.ads.googleads.v7.enums.types.gender_type",
    "GeoTargetConstantStatusEnum": "google.ads.googleads.v7.enums.types.geo_target_constant_status",
    "GeoTargetingRestrictionEnum": "google.ads.googleads.v7.enums.types.geo_targeting_restriction",
    "GeoTargetingTypeEnum": "google.ads.googleads.v7.enums.types.geo_targeting_type",
    "GoogleAdsFieldCategoryEnum": "google.ads.googleads.v7.enums.types.google_ads_field_category",
    "GoogleAdsFieldDataTypeEnum": "google.ads.googleads.v7.enums.types.google_ads_field_data_type",
    "GoogleVoiceCallStatusEnum": "google.ads.googleads.v7.enums.types.google_voice_call_status",
    "HotelDateSelectionTypeEnum": "google.ads.googleads.v7.enums.types.hotel_date_selection_type",
    "HotelPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.hotel_placeholder_field",
    "HotelPriceBucketEnum": "google.ads.googleads.v7.enums.types.hotel_price_bucket",
    "HotelRateTypeEnum": "google.ads.googleads.v7.enums.types.hotel_rate_type",
    "ImagePlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.image_placeholder_field",
    "IncomeRangeTypeEnum": "google.ads.googleads.v7.enums.types.income_range_type",
    "InteractionEventTypeEnum": "google.ads.googleads.v7.enums.types.interaction_event_type",
    "InteractionTypeEnum": "google.ads.googleads.v7.enums.types.interaction_type",
    "InvoiceTypeEnum": "google.ads.googleads.v7.enums.types.invoice_type",
    "JobPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.job_placeholder_field",
    "KeywordMatchTypeEnum": "google.ads.googleads.v7.enums.types.keyword_match_type",
    "KeywordPlanAggregateMetricTypeEnum": "google.ads.googleads.v7.enums.types.keyword_plan_aggregate_metric_type",
    "KeywordPlanCompetitionLevelEnum": "google.ads.googleads.v7.enums.types.keyword_plan_competition_level",
    "KeywordPlanConceptGroupTypeEnum": "google.ads.googleads.v7.enums.types.keyword_plan_concept_group_type",
    "KeywordPlanForecastIntervalEnum": "google.ads.googleads.v7.enums.types.keyword_plan_forecast_interval",
    "KeywordPlanKeywordAnnotationEnum": "google.ads.googleads.v7.enums.types.keyword_plan_keyword_annotation",
    "KeywordPlanNetworkEnum": "google.ads.googleads.v7.enums.types.keyword_plan_network",
    "LabelStatusEnum": "google.ads.googleads.v7.enums.types.label_status",
    "LeadFormCallToActionTypeEnum": "google.ads.googleads.v7.enums.types.lead_form_call_to_action_type",
    "LeadFormDesiredIntentEnum": "google.ads.googleads.v7.enums.types.lead_form_desired_intent",
    "LeadFormFieldUserInputTypeEnum": "google.ads.googleads.v7.enums.types.lead_form_field_user_input_type",
    "LeadFormPostSubmitCallToActionTypeEnum": "google.ads.googleads.v7.enums.types.lead_form_post_submit_call_to_action_type",
    "LegacyAppInstallAdAppStoreEnum": "google.ads.googleads.v7.enums.types.legacy_app_install_ad_app_store",
    "LinkedAccountTypeEnum": "google.ads.googleads.v7.enums.types.linked_account_type",
    "ListingGroupTypeEnum": "google.ads.googleads.v7.enums.types.listing_group_type",
    "LocalPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.local_placeholder_field",
    "LocationExtensionTargetingCriterionFieldEnum": "google.ads.googleads.v7.enums.types.location_extension_targeting_criterion_field",
    "LocationGroupRadiusUnitsEnum": "google.ads.googleads.v7.enums.types.location_group_radius_units",
    "LocationPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.location_placeholder_field",
    "LocationSourceTypeEnum": "google.ads.googleads.v7.enums.types.location_source_type",
    "ManagerLinkStatusEnum": "google.ads.googleads.v7.enums.types.manager_link_status",
    "MatchingFunctionContextTypeEnum": "google.ads.googleads.v7.enums.types.matching_function_context_type",
    "MatchingFunctionOperatorEnum": "google.ads.googleads.v7.enums.types.matching_function_operator",
    "MediaTypeEnum": "google.ads.googleads.v7.enums.types.media_type",
    "MerchantCenterLinkStatusEnum": "google.ads.googleads.v7.enums.types.merchant_center_link_status",
    "MessagePlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.message_placeholder_field",
    "MimeTypeEnum": "google.ads.googleads.v7.enums.types.mime_type",
    "MinuteOfHourEnum": "google.ads.googleads.v7.enums.types.minute_of_hour",
    "MobileAppVendorEnum": "google.ads.googleads.v7.enums.types.mobile_app_vendor",
    "MobileDeviceTypeEnum": "google.ads.googleads.v7.enums.types.mobile_device_type",
    "MonthOfYearEnum": "google.ads.googleads.v7.enums.types.month_of_year",
    "NegativeGeoTargetTypeEnum": "google.ads.googleads.v7.enums.types.negative_geo_target_type",
    "OfflineUserDataJobFailureReasonEnum": "google.ads.googleads.v7.enums.types.offline_user_data_job_failure_reason",
    "OfflineUserDataJobStatusEnum": "google.ads.googleads.v7.enums.types.offline_user_data_job_status",
    "OfflineUserDataJobTypeEnum": "google.ads.googleads.v7.enums.types.offline_user_data_job_type",
    "OperatingSystemVersionOperatorTypeEnum": "google.ads.googleads.v7.enums.types.operating_system_version_operator_type",
    "OptimizationGoalTypeEnum": "google.ads.googleads.v7.enums.types.optimization_goal_type",
    "ParentalStatusTypeEnum": "google.ads.googleads.v7.enums.types.parental_status_type",
    "PaymentModeEnum": "google.ads.googleads.v7.enums.types.payment_mode",
    "PlaceholderTypeEnum": "google.ads.googleads.v7.enums.types.placeholder_type",
    "PlacementTypeEnum": "google.ads.googleads.v7.enums.types.placement_type",
    "PolicyApprovalStatusEnum": "google.ads.googleads.v7.enums.types.policy_approval_status",
    "PolicyReviewStatusEnum": "google.ads.googleads.v7.enums.types.policy_review_status",
    "PolicyTopicEntryTypeEnum": "google.ads.googleads.v7.enums.types.policy_topic_entry_type",
    "PolicyTopicEvidenceDestinationMismatchUrlTypeEnum": "google.ads.googleads.v7.enums.types.policy_topic_evidence_destination_mismatch_url_type",
    "PolicyTopicEvidenceDestinationNotWorkingDeviceEnum": "google.ads.googleads.v7.enums.types.policy_topic_evidence_destination_not_working_device",
    "PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum": "google.ads.googleads.v7.enums.types.policy_topic_evidence_destination_not_working_dns_error_type",
    "PositiveGeoTargetTypeEnum": "google.ads.googleads.v7.enums.types.positive_geo_target_type",
    "PreferredContentTypeEnum": "google.ads.googleads.v7.enums.types.preferred_content_type",
    "PriceExtensionPriceQualifierEnum": "google.ads.googleads.v7.enums.types.price_extension_price_qualifier",
    "PriceExtensionPriceUnitEnum": "google.ads.googleads.v7.enums.types.price_extension_price_unit",
    "PriceExtensionTypeEnum": "google.ads.googleads.v7.enums.types.price_extension_type",
    "PricePlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.price_placeholder_field",
    "ProductBiddingCategoryLevelEnum": "google.ads.googleads.v7.enums.types.product_bidding_category_level",
    "ProductBiddingCategoryStatusEnum": "google.ads.googleads.v7.enums.types.product_bidding_category_status",
    "ProductChannelEnum": "google.ads.googleads.v7.enums.types.product_channel",
    "ProductChannelExclusivityEnum": "google.ads.googleads.v7.enums.types.product_channel_exclusivity",
    "ProductConditionEnum": "google.ads.googleads.v7.enums.types.product_condition",
    "ProductCustomAttributeIndexEnum": "google.ads.googleads.v7.enums.types.product_custom_attribute_index",
    "ProductTypeLevelEnum": "google.ads.googleads.v7.enums.types.product_type_level",
    "PromotionExtensionDiscountModifierEnum": "google.ads.googleads.v7.enums.types.promotion_extension_discount_modifier",
    "PromotionExtensionOccasionEnum": "google.ads.googleads.v7.enums.types.promotion_extension_occasion",
    "PromotionPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.promotion_placeholder_field",
    "ProximityRadiusUnitsEnum": "google.ads.googleads.v7.enums.types.proximity_radius_units",
    "QualityScoreBucketEnum": "google.ads.googleads.v7.enums.types.quality_score_bucket",
    "ReachPlanAdLengthEnum": "google.ads.googleads.v7.enums.types.reach_plan_ad_length",
    "ReachPlanAgeRangeEnum": "google.ads.googleads.v7.enums.types.reach_plan_age_range",
    "ReachPlanNetworkEnum": "google.ads.googleads.v7.enums.types.reach_plan_network",
    "RealEstatePlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.real_estate_placeholder_field",
    "RecommendationTypeEnum": "google.ads.googleads.v7.enums.types.recommendation_type",
    "ResourceChangeOperationEnum": "google.ads.googleads.v7.enums.types.resource_change_operation",
    "ResourceLimitTypeEnum": "google.ads.googleads.v7.enums.types.resource_limit_type",
    "ResponseContentTypeEnum": "google.ads.googleads.v7.enums.types.response_content_type",
    "SearchEngineResultsPageTypeEnum": "google.ads.googleads.v7.enums.types.search_engine_results_page_type",
    "SearchTermMatchTypeEnum": "google.ads.googleads.v7.enums.types.search_term_match_type",
    "SearchTermTargetingStatusEnum": "google.ads.googleads.v7.enums.types.search_term_targeting_status",
    "ServedAssetFieldTypeEnum": "google.ads.googleads.v7.enums.types.served_asset_field_type",
    "SharedSetStatusEnum": "google.ads.googleads.v7.enums.types.shared_set_status",
    "SharedSetTypeEnum": "google.ads.googleads.v7.enums.types.shared_set_type",
    "SimulationModificationMethodEnum": "google.ads.googleads.v7.enums.types.simulation_modification_method",
    "SimulationTypeEnum": "google.ads.googleads.v7.enums.types.simulation_type",
    "SitelinkPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.sitelink_placeholder_field",
    "SlotEnum": "google.ads.googleads.v7.enums.types.slot",
    "SpendingLimitTypeEnum": "google.ads.googleads.v7.enums.types.spending_limit_type",
    "StructuredSnippetPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.structured_snippet_placeholder_field",
    "SummaryRowSettingEnum": "google.ads.googleads.v7.enums.types.summary_row_setting",
    "SystemManagedResourceSourceEnum": "google.ads.googleads.v7.enums.types.system_managed_entity_source",
    "TargetCpaOptInRecommendationGoalEnum": "google.ads.googleads.v7.enums.types.target_cpa_opt_in_recommendation_goal",
    "TargetImpressionShareLocationEnum": "google.ads.googleads.v7.enums.types.target_impression_share_location",
    "TargetingDimensionEnum": "google.ads.googleads.v7.enums.types.targeting_dimension",
    "TimeTypeEnum": "google.ads.googleads.v7.enums.types.time_type",
    "TrackingCodePageFormatEnum": "google.ads.googleads.v7.enums.types.tracking_code_page_format",
    "TrackingCodeTypeEnum": "google.ads.googleads.v7.enums.types.tracking_code_type",
    "TravelPlaceholderFieldEnum": "google.ads.googleads.v7.enums.types.travel_placeholder_field",
    "UserIdentifierSourceEnum": "google.ads.googleads.v7.enums.types.user_identifier_source",
    "UserInterestTaxonomyTypeEnum": "google.ads.googleads.v7.enums.types.user_interest_taxonomy_type",
    "UserListAccessStatusEnum": "google.ads.googleads.v7.enums.types.user_list_access_status",
    "UserListClosingReasonEnum": "google.ads.googleads.v7.enums.types.user_list_closing_reason",
    "UserListCombinedRuleOperatorEnum": "google.ads.googleads.v7.enums.types.user_list_combined_rule_operator",
    "UserListCrmDataSourceTypeEnum": "google.ads.googleads.v7.enums.types.user_list_crm_data_source_type",
    "UserListDateRuleItemOperatorEnum": "google.ads.googleads.v7.enums.types.user_list_date_rule_item_operator",
    "UserListLogicalRuleOperatorEnum": "google.ads.googleads.v7.enums.types.user_list_logical_rule_operator",
    "UserListMembershipStatusEnum": "google.ads.googleads.v7.enums.types.user_list_membership_status",
    "UserListNumberRuleItemOperatorEnum": "google.ads.googleads.v7.enums.types.user_list_number_rule_item_operator",
    "UserListPrepopulationStatusEnum": "google.ads.googleads.v7.enums.types.user_list_prepopulation_status",
    "UserListRuleTypeEnum": "google.ads.googleads.v7.enums.types.user_list_rule_type",
    "UserListSizeRangeEnum": "google.ads.googleads.v7.enums.types.user_list_size_range",
    "UserListStringRuleItemOperatorEnum": "google.ads.googleads.v7.enums.types.user_list_string_rule_item_operator",
    "UserListTypeEnum": "google.ads.googleads.v7.enums.types.user_list_type",
    "VanityPharmaDisplayUrlModeEnum": "google.ads.googleads.v7.enums.types.vanity_pharma_display_url_mode",
    "VanityPharmaTextEnum": "google.ads.googleads.v7.enums.types.vanity_pharma_text",
    "WebpageConditionOperandEnum": "google.ads.googleads.v7.enums.types.webpage_condition_operand",
    "WebpageConditionOperatorEnum": "google.ads.googleads.v7.enums.types.webpage_condition_operator",
    "AccessInvitationErrorEnum": "google.ads.googleads.v7.errors.types.access_invitation_error",
    "AccountBudgetProposalErrorEnum": "google.ads.googleads.v7.errors.types.account_budget_proposal_error",
    "AccountLinkErrorEnum": "google.ads.googleads.v7.errors.types.account_link_error",
    "AdCustomizerErrorEnum": "google.ads.googleads.v7.errors.types.ad_customizer_error",
    "AdErrorEnum": "google.ads.googleads.v7.errors.types.ad_error",
    "AdGroupAdErrorEnum": "google.ads.googleads.v7.errors.types.ad_group_ad_error",
    "AdGroupBidModifierErrorEnum": "google.ads.googleads.v7.errors.types.ad_group_bid_modifier_error",
    "AdGroupCriterionErrorEnum": "google.ads.googleads.v7.errors.types.ad_group_criterion_error",
    "AdGroupErrorEnum": "google.ads.googleads.v7.errors.types.ad_group_error",
    "AdGroupFeedErrorEnum": "google.ads.googleads.v7.errors.types.ad_group_feed_error",
    "AdParameterErrorEnum": "google.ads.googleads.v7.errors.types.ad_parameter_error",
    "AdSharingErrorEnum": "google.ads.googleads.v7.errors.types.ad_sharing_error",
    "AdxErrorEnum": "google.ads.googleads.v7.errors.types.adx_error",
    "AssetErrorEnum": "google.ads.googleads.v7.errors.types.asset_error",
    "AssetLinkErrorEnum": "google.ads.googleads.v7.errors.types.asset_link_error",
    "AuthenticationErrorEnum": "google.ads.googleads.v7.errors.types.authentication_error",
    "AuthorizationErrorEnum": "google.ads.googleads.v7.errors.types.authorization_error",
    "BatchJobErrorEnum": "google.ads.googleads.v7.errors.types.batch_job_error",
    "BiddingErrorEnum": "google.ads.googleads.v7.errors.types.bidding_error",
    "BiddingStrategyErrorEnum": "google.ads.googleads.v7.errors.types.bidding_strategy_error",
    "BillingSetupErrorEnum": "google.ads.googleads.v7.errors.types.billing_setup_error",
    "CampaignBudgetErrorEnum": "google.ads.googleads.v7.errors.types.campaign_budget_error",
    "CampaignCriterionErrorEnum": "google.ads.googleads.v7.errors.types.campaign_criterion_error",
    "CampaignDraftErrorEnum": "google.ads.googleads.v7.errors.types.campaign_draft_error",
    "CampaignErrorEnum": "google.ads.googleads.v7.errors.types.campaign_error",
    "CampaignExperimentErrorEnum": "google.ads.googleads.v7.errors.types.campaign_experiment_error",
    "CampaignFeedErrorEnum": "google.ads.googleads.v7.errors.types.campaign_feed_error",
    "CampaignSharedSetErrorEnum": "google.ads.googleads.v7.errors.types.campaign_shared_set_error",
    "ChangeEventErrorEnum": "google.ads.googleads.v7.errors.types.change_event_error",
    "ChangeStatusErrorEnum": "google.ads.googleads.v7.errors.types.change_status_error",
    "CollectionSizeErrorEnum": "google.ads.googleads.v7.errors.types.collection_size_error",
    "ContextErrorEnum": "google.ads.googleads.v7.errors.types.context_error",
    "ConversionActionErrorEnum": "google.ads.googleads.v7.errors.types.conversion_action_error",
    "ConversionAdjustmentUploadErrorEnum": "google.ads.googleads.v7.errors.types.conversion_adjustment_upload_error",
    "ConversionCustomVariableErrorEnum": "google.ads.googleads.v7.errors.types.conversion_custom_variable_error",
    "ConversionUploadErrorEnum": "google.ads.googleads.v7.errors.types.conversion_upload_error",
    "CountryCodeErrorEnum": "google.ads.googleads.v7.errors.types.country_code_error",
    "CriterionErrorEnum": "google.ads.googleads.v7.errors.types.criterion_error",
    "CurrencyCodeErrorEnum": "google.ads.googleads.v7.errors.types.currency_code_error",
    "CustomAudienceErrorEnum": "google.ads.googleads.v7.errors.types.custom_audience_error",
    "CustomerClientLinkErrorEnum": "google.ads.googleads.v7.errors.types.customer_client_link_error",
    "CustomerErrorEnum": "google.ads.googleads.v7.errors.types.customer_error",
    "CustomerFeedErrorEnum": "google.ads.googleads.v7.errors.types.customer_feed_error",
    "CustomerManagerLinkErrorEnum": "google.ads.googleads.v7.errors.types.customer_manager_link_error",
    "CustomerUserAccessErrorEnum": "google.ads.googleads.v7.errors.types.customer_user_access_error",
    "CustomInterestErrorEnum": "google.ads.googleads.v7.errors.types.custom_interest_error",
    "DatabaseErrorEnum": "google.ads.googleads.v7.errors.types.database_error",
    "DateErrorEnum": "google.ads.googleads.v7.errors.types.date_error",
    "DateRangeErrorEnum": "google.ads.googleads.v7.errors.types.date_range_error",
    "DistinctErrorEnum": "google.ads.googleads.v7.errors.types.distinct_error",
    "EnumErrorEnum": "google.ads.googleads.v7.errors.types.enum_error",
    "ErrorCode": "google.ads.googleads.v7.errors.types.errors",
    "ErrorDetails": "google.ads.googleads.v7.errors.types.errors",
    "ErrorLocation": "google.ads.googleads.v7.errors.types.errors",
    "ExtensionFeedItemErrorEnum": "google.ads.googleads.v7.errors.types.extension_feed_item_error",
    "ExtensionSettingErrorEnum": "google.ads.googleads.v7.errors.types.extension_setting_error",
    "FeedAttributeReferenceErrorEnum": "google.ads.googleads.v7.errors.types.feed_attribute_reference_error",
    "FeedErrorEnum": "google.ads.googleads.v7.errors.types.feed_error",
    "FeedItemErrorEnum": "google.ads.googleads.v7.errors.types.feed_item_error",
    "FeedItemSetErrorEnum": "google.ads.googleads.v7.errors.types.feed_item_set_error",
    "FeedItemSetLinkErrorEnum": "google.ads.googleads.v7.errors.types.feed_item_set_link_error",
    "FeedItemTargetErrorEnum": "google.ads.googleads.v7.errors.types.feed_item_target_error",
    "FeedItemValidationErrorEnum": "google.ads.googleads.v7.errors.types.feed_item_validation_error",
    "FeedMappingErrorEnum": "google.ads.googleads.v7.errors.types.feed_mapping_error",
    "FieldErrorEnum": "google.ads.googleads.v7.errors.types.field_error",
    "FieldMaskErrorEnum": "google.ads.googleads.v7.errors.types.field_mask_error",
    "FunctionErrorEnum": "google.ads.googleads.v7.errors.types.function_error",
    "FunctionParsingErrorEnum": "google.ads.googleads.v7.errors.types.function_parsing_error",
    "GeoTargetConstantSuggestionErrorEnum": "google.ads.googleads.v7.errors.types.geo_target_constant_suggestion_error",
    "GoogleAdsError": "google.ads.googleads.v7.errors.types.errors",
    "GoogleAdsFailure": "google.ads.googleads.v7.errors.types.errors",
    "HeaderErrorEnum": "google.ads.googleads.v7.errors.types.header_error",
    "IdErrorEnum": "google.ads.googleads.v7.errors.types.id_error",
    "ImageErrorEnum": "google.ads.googleads.v7.errors.types.image_error",
    "InternalErrorEnum": "google.ads.googleads.v7.errors.types.internal_error",
    "InvoiceErrorEnum": "google.ads.googleads.v7.errors.types.invoice_error",
    "KeywordPlanAdGroupErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_ad_group_error",
    "KeywordPlanAdGroupKeywordErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_ad_group_keyword_error",
    "KeywordPlanCampaignErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_campaign_error",
    "KeywordPlanCampaignKeywordErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_campaign_keyword_error",
    "KeywordPlanErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_error",
    "KeywordPlanIdeaErrorEnum": "google.ads.googleads.v7.errors.types.keyword_plan_idea_error",
    "LabelErrorEnum": "google.ads.googleads.v7.errors.types.label_error",
    "LanguageCodeErrorEnum": "google.ads.googleads.v7.errors.types.language_code_error",
    "ListOperationErrorEnum": "google.ads.googleads.v7.errors.types.list_operation_error",
    "ManagerLinkErrorEnum": "google.ads.googleads.v7.errors.types.manager_link_error",
    "MediaBundleErrorEnum": "google.ads.googleads.v7.errors.types.media_bundle_error",
    "MediaFileErrorEnum": "google.ads.googleads.v7.errors.types.media_file_error",
    "MediaUploadErrorEnum": "google.ads.googleads.v7.errors.types.media_upload_error",
    "MultiplierErrorEnum": "google.ads.googleads.v7.errors.types.multiplier_error",
    "MutateErrorEnum": "google.ads.googleads.v7.errors.types.mutate_error",
    "NewResourceCreationErrorEnum": "google.ads.googleads.v7.errors.types.new_resource_creation_error",
    "NotAllowlistedErrorEnum": "google.ads.googleads.v7.errors.types.not_allowlisted_error",
    "NotEmptyErrorEnum": "google.ads.googleads.v7.errors.types.not_empty_error",
    "NullErrorEnum": "google.ads.googleads.v7.errors.types.null_error",
    "OfflineUserDataJobErrorEnum": "google.ads.googleads.v7.errors.types.offline_user_data_job_error",
    "OperationAccessDeniedErrorEnum": "google.ads.googleads.v7.errors.types.operation_access_denied_error",
    "OperatorErrorEnum": "google.ads.googleads.v7.errors.types.operator_error",
    "PartialFailureErrorEnum": "google.ads.googleads.v7.errors.types.partial_failure_error",
    "PaymentsAccountErrorEnum": "google.ads.googleads.v7.errors.types.payments_account_error",
    "PolicyFindingDetails": "google.ads.googleads.v7.errors.types.errors",
    "PolicyFindingErrorEnum": "google.ads.googleads.v7.errors.types.policy_finding_error",
    "PolicyValidationParameterErrorEnum": "google.ads.googleads.v7.errors.types.policy_validation_parameter_error",
    "PolicyViolationDetails": "google.ads.googleads.v7.errors.types.errors",
    "PolicyViolationErrorEnum": "google.ads.googleads.v7.errors.types.policy_violation_error",
    "QueryErrorEnum": "google.ads.googleads.v7.errors.types.query_error",
    "QuotaErrorDetails": "google.ads.googleads.v7.errors.types.errors",
    "QuotaErrorEnum": "google.ads.googleads.v7.errors.types.quota_error",
    "RangeErrorEnum": "google.ads.googleads.v7.errors.types.range_error",
    "ReachPlanErrorEnum": "google.ads.googleads.v7.errors.types.reach_plan_error",
    "RecommendationErrorEnum": "google.ads.googleads.v7.errors.types.recommendation_error",
    "RegionCodeErrorEnum": "google.ads.googleads.v7.errors.types.region_code_error",
    "RequestErrorEnum": "google.ads.googleads.v7.errors.types.request_error",
    "ResourceAccessDeniedErrorEnum": "google.ads.googleads.v7.errors.types.resource_access_denied_error",
    "ResourceCountDetails": "google.ads.googleads.v7.errors.types.errors",
    "ResourceCountLimitExceededErrorEnum": "google.ads.googleads.v7.errors.types.resource_count_limit_exceeded_error",
    "SettingErrorEnum": "google.ads.googleads.v7.errors.types.setting_error",
    "SharedCriterionErrorEnum": "google.ads.googleads.v7.errors.types.shared_criterion_error",
    "SharedSetErrorEnum": "google.ads.googleads.v7.errors.types.shared_set_error",
    "SizeLimitErrorEnum": "google.ads.googleads.v7.errors.types.size_limit_error",
    "StringFormatErrorEnum": "google.ads.googleads.v7.errors.types.string_format_error",
    "StringLengthErrorEnum": "google.ads.googleads.v7.errors.types.string_length_error",
    "ThirdPartyAppAnalyticsLinkErrorEnum": "google.ads.googleads.v7.errors.types.third_party_app_analytics_link_error",
    "TimeZoneErrorEnum": "google.ads.googleads.v7.errors.types.time_zone_error",
    "UrlFieldErrorEnum": "google.ads.googleads.v7.errors.types.url_field_error",
    "UserDataErrorEnum": "google.ads.googleads.v7.errors.types.user_data_error",
    "UserListErrorEnum": "google.ads.googleads.v7.errors.types.user_list_error",
    "YoutubeVideoRegistrationErrorEnum": "google.ads.googleads.v7.errors.types.youtube_video_registration_error",
    "AccountBudget": "google.ads.googleads.v7.resources.types.account_budget",
    "AccountBudgetProposal": "google.ads.googleads.v7.resources.types.account_budget_proposal",
    "AccountLink": "google.ads.googleads.v7.resources.types.account_link",
    "Ad": "google.ads.googleads.v7.resources.types.ad",
    "AdGroup": "google.ads.googleads.v7.resources.types.ad_group",
    "AdGroupAd": "google.ads.googleads.v7.resources.types.ad_group_ad",
    "AdGroupAdAssetPolicySummary": "google.ads.googleads.v7.resources.types.ad_group_ad_asset_view",
    "AdGroupAdAssetView": "google.ads.googleads.v7.resources.types.ad_group_ad_asset_view",
    "AdGroupAdLabel": "google.ads.googleads.v7.resources.types.ad_group_ad_label",
    "AdGroupAdPolicySummary": "google.ads.googleads.v7.resources.types.ad_group_ad",
    "AdGroupAsset": "google.ads.googleads.v7.resources.types.ad_group_asset",
    "AdGroupAudienceView": "google.ads.googleads.v7.resources.types.ad_group_audience_view",
    "AdGroupBidModifier": "google.ads.googleads.v7.resources.types.ad_group_bid_modifier",
    "AdGroupCriterion": "google.ads.googleads.v7.resources.types.ad_group_criterion",
    "AdGroupCriterionLabel": "google.ads.googleads.v7.resources.types.ad_group_criterion_label",
    "AdGroupCriterionSimulation": "google.ads.googleads.v7.resources.types.ad_group_criterion_simulation",
    "AdGroupExtensionSetting": "google.ads.googleads.v7.resources.types.ad_group_extension_setting",
    "AdGroupFeed": "google.ads.googleads.v7.resources.types.ad_group_feed",
    "AdGroupLabel": "google.ads.googleads.v7.resources.types.ad_group_label",
    "AdGroupSimulation": "google.ads.googleads.v7.resources.types.ad_group_simulation",
    "AdParameter": "google.ads.googleads.v7.resources.types.ad_parameter",
    "AdScheduleView": "google.ads.googleads.v7.resources.types.ad_schedule_view",
    "AgeRangeView": "google.ads.googleads.v7.resources.types.age_range_view",
    "Asset": "google.ads.googleads.v7.resources.types.asset",
    "AssetPolicySummary": "google.ads.googleads.v7.resources.types.asset",
    "AttributeFieldMapping": "google.ads.googleads.v7.resources.types.feed_mapping",
    "BatchJob": "google.ads.googleads.v7.resources.types.batch_job",
    "BiddingStrategy": "google.ads.googleads.v7.resources.types.bidding_strategy",
    "BiddingStrategySimulation": "google.ads.googleads.v7.resources.types.bidding_strategy_simulation",
    "BillingSetup": "google.ads.googleads.v7.resources.types.billing_setup",
    "CallReportingSetting": "google.ads.googleads.v7.resources.types.customer",
    "CallView": "google.ads.googleads.v7.resources.types.call_view",
    "Campaign": "google.ads.googleads.v7.resources.types.campaign",
    "CampaignAsset": "google.ads.googleads.v7.resources.types.campaign_asset",
    "CampaignAudienceView": "google.ads.googleads.v7.resources.types.campaign_audience_view",
    "CampaignBidModifier": "google.ads.googleads.v7.resources.types.campaign_bid_modifier",
    "CampaignBudget": "google.ads.googleads.v7.resources.types.campaign_budget",
    "CampaignCriterion": "google.ads.googleads.v7.resources.types.campaign_criterion",
    "CampaignCriterionSimulation": "google.ads.googleads.v7.resources.types.campaign_criterion_simulation",
    "CampaignDraft": "google.ads.googleads.v7.resources.types.campaign_draft",
    "CampaignExperiment": "google.ads.googleads.v7.resources.types.campaign_experiment",
    "CampaignExtensionSetting": "google.ads.googleads.v7.resources.types.campaign_extension_setting",
    "CampaignFeed": "google.ads.googleads.v7.resources.types.campaign_feed",
    "CampaignLabel": "google.ads.googleads.v7.resources.types.campaign_label",
    "CampaignSharedSet": "google.ads.googleads.v7.resources.types.campaign_shared_set",
    "CampaignSimulation": "google.ads.googleads.v7.resources.types.campaign_simulation",
    "CarrierConstant": "google.ads.googleads.v7.resources.types.carrier_constant",
    "ChangeEvent": "google.ads.googleads.v7.resources.types.change_event",
    "ChangeStatus": "google.ads.googleads.v7.resources.types.change_status",
    "ClickView": "google.ads.googleads.v7.resources.types.click_view",
    "CombinedAudience": "google.ads.googleads.v7.resources.types.combined_audience",
    "ConversionAction": "google.ads.googleads.v7.resources.types.conversion_action",
    "ConversionCustomVariable": "google.ads.googleads.v7.resources.types.conversion_custom_variable",
    "ConversionTrackingSetting": "google.ads.googleads.v7.resources.types.customer",
    "CurrencyConstant": "google.ads.googleads.v7.resources.types.currency_constant",
    "CustomAudience": "google.ads.googleads.v7.resources.types.custom_audience",
    "CustomAudienceMember": "google.ads.googleads.v7.resources.types.custom_audience",
    "Customer": "google.ads.googleads.v7.resources.types.customer",
    "CustomerAsset": "google.ads.googleads.v7.resources.types.customer_asset",
    "CustomerClient": "google.ads.googleads.v7.resources.types.customer_client",
    "CustomerClientLink": "google.ads.googleads.v7.resources.types.customer_client_link",
    "CustomerExtensionSetting": "google.ads.googleads.v7.resources.types.customer_extension_setting",
    "CustomerFeed": "google.ads.googleads.v7.resources.types.customer_feed",
    "CustomerLabel": "google.ads.googleads.v7.resources.types.customer_label",
    "CustomerManagerLink": "google.ads.googleads.v7.resources.types.customer_manager_link",
    "CustomerNegativeCriterion": "google.ads.googleads.v7.resources.types.customer_negative_criterion",
    "CustomerUserAccess": "google.ads.googleads.v7.resources.types.customer_user_access",
    "CustomerUserAccessInvitation": "google.ads.googleads.v7.resources.types.customer_user_access_invitation",
    "CustomInterest": "google.ads.googleads.v7.resources.types.custom_interest",
    "CustomInterestMember": "google.ads.googleads.v7.resources.types.custom_interest",
    "DataPartnerLinkIdentifier": "google.ads.googleads.v7.resources.types.account_link",
    "DetailPlacementView": "google.ads.googleads.v7.resources.types.detail_placement_view",
    "DisplayKeywordView": "google.ads.googleads.v7.resources.types.display_keyword_view",
    "DistanceView": "google.ads.googleads.v7.resources.types.distance_view",
    "DomainCategory": "google.ads.googleads.v7.resources.types.domain_category",
    "DynamicSearchAdsSearchTermView": "google.ads.googleads.v7.resources.types.dynamic_search_ads_search_term_view",
    "ExpandedLandingPageView": "google.ads.googleads.v7.resources.types.expanded_landing_page_view",
    "ExtensionFeedItem": "google.ads.googleads.v7.resources.types.extension_feed_item",
    "Feed": "google.ads.googleads.v7.resources.types.feed",
    "FeedAttribute": "google.ads.googleads.v7.resources.types.feed",
    "FeedAttributeOperation": "google.ads.googleads.v7.resources.types.feed",
    "FeedItem": "google.ads.googleads.v7.resources.types.feed_item",
    "FeedItemAttributeValue": "google.ads.googleads.v7.resources.types.feed_item",
    "FeedItemPlaceholderPolicyInfo": "google.ads.googleads.v7.resources.types.feed_item",
    "FeedItemSet": "google.ads.googleads.v7.resources.types.feed_item_set",
    "FeedItemSetLink": "google.ads.googleads.v7.resources.types.feed_item_set_link",
    "FeedItemTarget": "google.ads.googleads.v7.resources.types.feed_item_target",
    "FeedItemValidationError": "google.ads.googleads.v7.resources.types.feed_item",
    "FeedMapping": "google.ads.googleads.v7.resources.types.feed_mapping",
    "FeedPlaceholderView": "google.ads.googleads.v7.resources.types.feed_placeholder_view",
    "GenderView": "google.ads.googleads.v7.resources.types.gender_view",
    "GeographicView": "google.ads.googleads.v7.resources.types.geographic_view",
    "GeoTargetConstant": "google.ads.googleads.v7.resources.types.geo_target_constant",
    "GoogleAdsField": "google.ads.googleads.v7.resources.types.google_ads_field",
    "GoogleAdsLinkIdentifier": "google.ads.googleads.v7.resources.types.account_link",
    "GroupPlacementView": "google.ads.googleads.v7.resources.types.group_placement_view",
    "HotelGroupView": "google.ads.googleads.v7.resources.types.hotel_group_view",
    "HotelPerformanceView": "google.ads.googleads.v7.resources.types.hotel_performance_view",
    "IncomeRangeView": "google.ads.googleads.v7.resources.types.income_range_view",
    "Invoice": "google.ads.googleads.v7.resources.types.invoice",
    "KeywordPlan": "google.ads.googleads.v7.resources.types.keyword_plan",
    "KeywordPlanAdGroup": "google.ads.googleads.v7.resources.types.keyword_plan_ad_group",
    "KeywordPlanAdGroupKeyword": "google.ads.googleads.v7.resources.types.keyword_plan_ad_group_keyword",
    "KeywordPlanCampaign": "google.ads.googleads.v7.resources.types.keyword_plan_campaign",
    "KeywordPlanCampaignKeyword": "google.ads.googleads.v7.resources.types.keyword_plan_campaign_keyword",
    "KeywordPlanForecastPeriod": "google.ads.googleads.v7.resources.types.keyword_plan",
    "KeywordPlanGeoTarget": "google.ads.googleads.v7.resources.types.keyword_plan_campaign",
    "KeywordView": "google.ads.googleads.v7.resources.types.keyword_view",
    "Label": "google.ads.googleads.v7.resources.types.label",
    "LandingPageView": "google.ads.googleads.v7.resources.types.landing_page_view",
    "LanguageConstant": "google.ads.googleads.v7.resources.types.language_constant",
    "LifeEvent": "google.ads.googleads.v7.resources.types.life_event",
    "LocationView": "google.ads.googleads.v7.resources.types.location_view",
    "ManagedPlacementView": "google.ads.googleads.v7.resources.types.managed_placement_view",
    "MediaAudio": "google.ads.googleads.v7.resources.types.media_file",
    "MediaBundle": "google.ads.googleads.v7.resources.types.media_file",
    "MediaFile": "google.ads.googleads.v7.resources.types.media_file",
    "MediaImage": "google.ads.googleads.v7.resources.types.media_file",
    "MediaVideo": "google.ads.googleads.v7.resources.types.media_file",
    "MerchantCenterLink": "google.ads.googleads.v7.resources.types.merchant_center_link",
    "MobileAppCategoryConstant": "google.ads.googleads.v7.resources.types.mobile_app_category_constant",
    "MobileDeviceConstant": "google.ads.googleads.v7.resources.types.mobile_device_constant",
    "OfflineUserDataJob": "google.ads.googleads.v7.resources.types.offline_user_data_job",
    "OperatingSystemVersionConstant": "google.ads.googleads.v7.resources.types.operating_system_version_constant",
    "PaidOrganicSearchTermView": "google.ads.googleads.v7.resources.types.paid_organic_search_term_view",
    "ParentalStatusView": "google.ads.googleads.v7.resources.types.parental_status_view",
    "PaymentsAccount": "google.ads.googleads.v7.resources.types.payments_account",
    "ProductBiddingCategoryConstant": "google.ads.googleads.v7.resources.types.product_bidding_category_constant",
    "ProductGroupView": "google.ads.googleads.v7.resources.types.product_group_view",
    "Recommendation": "google.ads.googleads.v7.resources.types.recommendation",
    "RemarketingAction": "google.ads.googleads.v7.resources.types.remarketing_action",
    "RemarketingSetting": "google.ads.googleads.v7.resources.types.customer",
    "SearchTermView": "google.ads.googleads.v7.resources.types.search_term_view",
    "SharedCriterion": "google.ads.googleads.v7.resources.types.shared_criterion",
    "SharedSet": "google.ads.googleads.v7.resources.types.shared_set",
    "ShoppingPerformanceView": "google.ads.googleads.v7.resources.types.shopping_performance_view",
    "ThirdPartyAppAnalyticsLink": "google.ads.googleads.v7.resources.types.third_party_app_analytics_link",
    "ThirdPartyAppAnalyticsLinkIdentifier": "google.ads.googleads.v7.resources.types.account_link",
    "TopicConstant": "google.ads.googleads.v7.resources.types.topic_constant",
    "TopicView": "google.ads.googleads.v7.resources.types.topic_view",
    "UserInterest": "google.ads.googleads.v7.resources.types.user_interest",
    "UserList": "google.ads.googleads.v7.resources.types.user_list",
    "UserLocationView": "google.ads.googleads.v7.resources.types.user_location_view",
    "Video": "google.ads.googleads.v7.resources.types.video",
    "WebpageView": "google.ads.googleads.v7.resources.types.webpage_view",
    "AccountBudgetProposalOperation": "google.ads.googleads.v7.services.types.account_budget_proposal_service",
    "AccountLinkOperation": "google.ads.googleads.v7.services.types.account_link_service",
    "AddBatchJobOperationsRequest": "google.ads.googleads.v7.services.types.batch_job_service",
    "AddBatchJobOperationsResponse": "google.ads.googleads.v7.services.types.batch_job_service",
    "AddOfflineUserDataJobOperationsRequest": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "AddOfflineUserDataJobOperationsResponse": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "AdGroupAdLabelOperation": "google.ads.googleads.v7.services.types.ad_group_ad_label_service",
    "AdGroupAdOperation": "google.ads.googleads.v7.services.types.ad_group_ad_service",
    "AdGroupAssetOperation": "google.ads.googleads.v7.services.types.ad_group_asset_service",
    "AdGroupBidModifierOperation": "google.ads.googleads.v7.services.types.ad_group_bid_modifier_service",
    "AdGroupCriterionLabelOperation": "google.ads.googleads.v7.services.types.ad_group_criterion_label_service",
    "AdGroupCriterionOperation": "google.ads.googleads.v7.services.types.ad_group_criterion_service",
    "AdGroupExtensionSettingOperation": "google.ads.googleads.v7.services.types.ad_group_extension_setting_service",
    "AdGroupFeedOperation": "google.ads.googleads.v7.services.types.ad_group_feed_service",
    "AdGroupLabelOperation": "google.ads.googleads.v7.services.types.ad_group_label_service",
    "AdGroupOperation": "google.ads.googleads.v7.services.types.ad_group_service",
    "AdOperation": "google.ads.googleads.v7.services.types.ad_service",
    "AdParameterOperation": "google.ads.googleads.v7.services.types.ad_parameter_service",
    "ApplyRecommendationOperation": "google.ads.googleads.v7.services.types.recommendation_service",
    "ApplyRecommendationRequest": "google.ads.googleads.v7.services.types.recommendation_service",
    "ApplyRecommendationResponse": "google.ads.googleads.v7.services.types.recommendation_service",
    "ApplyRecommendationResult": "google.ads.googleads.v7.services.types.recommendation_service",
    "AssetOperation": "google.ads.googleads.v7.services.types.asset_service",
    "BatchJobOperation": "google.ads.googleads.v7.services.types.batch_job_service",
    "BatchJobResult": "google.ads.googleads.v7.services.types.batch_job_service",
    "BiddingStrategyOperation": "google.ads.googleads.v7.services.types.bidding_strategy_service",
    "BillingSetupOperation": "google.ads.googleads.v7.services.types.billing_setup_service",
    "CallConversion": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "CallConversionResult": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "CampaignAssetOperation": "google.ads.googleads.v7.services.types.campaign_asset_service",
    "CampaignBidModifierOperation": "google.ads.googleads.v7.services.types.campaign_bid_modifier_service",
    "CampaignBudgetOperation": "google.ads.googleads.v7.services.types.campaign_budget_service",
    "CampaignCriterionOperation": "google.ads.googleads.v7.services.types.campaign_criterion_service",
    "CampaignDraftOperation": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "CampaignDuration": "google.ads.googleads.v7.services.types.reach_plan_service",
    "CampaignExperimentOperation": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "CampaignExtensionSettingOperation": "google.ads.googleads.v7.services.types.campaign_extension_setting_service",
    "CampaignFeedOperation": "google.ads.googleads.v7.services.types.campaign_feed_service",
    "CampaignLabelOperation": "google.ads.googleads.v7.services.types.campaign_label_service",
    "CampaignOperation": "google.ads.googleads.v7.services.types.campaign_service",
    "CampaignSharedSetOperation": "google.ads.googleads.v7.services.types.campaign_shared_set_service",
    "ClickConversion": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "ClickConversionResult": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "ConversionActionOperation": "google.ads.googleads.v7.services.types.conversion_action_service",
    "ConversionAdjustment": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "ConversionAdjustmentResult": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "ConversionCustomVariableOperation": "google.ads.googleads.v7.services.types.conversion_custom_variable_service",
    "CreateAccountLinkRequest": "google.ads.googleads.v7.services.types.account_link_service",
    "CreateAccountLinkResponse": "google.ads.googleads.v7.services.types.account_link_service",
    "CreateCampaignExperimentMetadata": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "CreateCampaignExperimentRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "CreateCustomerClientRequest": "google.ads.googleads.v7.services.types.customer_service",
    "CreateCustomerClientResponse": "google.ads.googleads.v7.services.types.customer_service",
    "CreateOfflineUserDataJobRequest": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "CreateOfflineUserDataJobResponse": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "CustomAudienceOperation": "google.ads.googleads.v7.services.types.custom_audience_service",
    "CustomerAssetOperation": "google.ads.googleads.v7.services.types.customer_asset_service",
    "CustomerClientLinkOperation": "google.ads.googleads.v7.services.types.customer_client_link_service",
    "CustomerExtensionSettingOperation": "google.ads.googleads.v7.services.types.customer_extension_setting_service",
    "CustomerFeedOperation": "google.ads.googleads.v7.services.types.customer_feed_service",
    "CustomerLabelOperation": "google.ads.googleads.v7.services.types.customer_label_service",
    "CustomerManagerLinkOperation": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "CustomerNegativeCriterionOperation": "google.ads.googleads.v7.services.types.customer_negative_criterion_service",
    "CustomerOperation": "google.ads.googleads.v7.services.types.customer_service",
    "CustomerUserAccessInvitationOperation": "google.ads.googleads.v7.services.types.customer_user_access_invitation_service",
    "CustomerUserAccessOperation": "google.ads.googleads.v7.services.types.customer_user_access_service",
    "CustomInterestOperation": "google.ads.googleads.v7.services.types.custom_interest_service",
    "CustomVariable": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "DismissRecommendationRequest": "google.ads.googleads.v7.services.types.recommendation_service",
    "DismissRecommendationResponse": "google.ads.googleads.v7.services.types.recommendation_service",
    "EndCampaignExperimentRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "ExtensionFeedItemOperation": "google.ads.googleads.v7.services.types.extension_feed_item_service",
    "ExternalAttributionData": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "FeedItemOperation": "google.ads.googleads.v7.services.types.feed_item_service",
    "FeedItemSetLinkOperation": "google.ads.googleads.v7.services.types.feed_item_set_link_service",
    "FeedItemSetOperation": "google.ads.googleads.v7.services.types.feed_item_set_service",
    "FeedItemTargetOperation": "google.ads.googleads.v7.services.types.feed_item_target_service",
    "FeedMappingOperation": "google.ads.googleads.v7.services.types.feed_mapping_service",
    "FeedOperation": "google.ads.googleads.v7.services.types.feed_service",
    "Forecast": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ForecastMetrics": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "FrequencyCap": "google.ads.googleads.v7.services.types.reach_plan_service",
    "GclidDateTimePair": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "GenerateForecastCurveRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateForecastCurveResponse": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateForecastMetricsRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateForecastMetricsResponse": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesResponse": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsResponse": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GenerateKeywordIdeaResponse": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeaResult": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeasRequest": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "GenerateProductMixIdeasRequest": "google.ads.googleads.v7.services.types.reach_plan_service",
    "GenerateProductMixIdeasResponse": "google.ads.googleads.v7.services.types.reach_plan_service",
    "GenerateReachForecastRequest": "google.ads.googleads.v7.services.types.reach_plan_service",
    "GenerateReachForecastResponse": "google.ads.googleads.v7.services.types.reach_plan_service",
    "GeoTargetConstantSuggestion": "google.ads.googleads.v7.services.types.geo_target_constant_service",
    "GetAccountBudgetProposalRequest": "google.ads.googleads.v7.services.types.account_budget_proposal_service",
    "GetAccountBudgetRequest": "google.ads.googleads.v7.services.types.account_budget_service",
    "GetAccountLinkRequest": "google.ads.googleads.v7.services.types.account_link_service",
    "GetAdGroupAdAssetViewRequest": "google.ads.googleads.v7.services.types.ad_group_ad_asset_view_service",
    "GetAdGroupAdLabelRequest": "google.ads.googleads.v7.services.types.ad_group_ad_label_service",
    "GetAdGroupAdRequest": "google.ads.googleads.v7.services.types.ad_group_ad_service",
    "GetAdGroupAssetRequest": "google.ads.googleads.v7.services.types.ad_group_asset_service",
    "GetAdGroupAudienceViewRequest": "google.ads.googleads.v7.services.types.ad_group_audience_view_service",
    "GetAdGroupBidModifierRequest": "google.ads.googleads.v7.services.types.ad_group_bid_modifier_service",
    "GetAdGroupCriterionLabelRequest": "google.ads.googleads.v7.services.types.ad_group_criterion_label_service",
    "GetAdGroupCriterionRequest": "google.ads.googleads.v7.services.types.ad_group_criterion_service",
    "GetAdGroupCriterionSimulationRequest": "google.ads.googleads.v7.services.types.ad_group_criterion_simulation_service",
    "GetAdGroupExtensionSettingRequest": "google.ads.googleads.v7.services.types.ad_group_extension_setting_service",
    "GetAdGroupFeedRequest": "google.ads.googleads.v7.services.types.ad_group_feed_service",
    "GetAdGroupLabelRequest": "google.ads.googleads.v7.services.types.ad_group_label_service",
    "GetAdGroupRequest": "google.ads.googleads.v7.services.types.ad_group_service",
    "GetAdGroupSimulationRequest": "google.ads.googleads.v7.services.types.ad_group_simulation_service",
    "GetAdParameterRequest": "google.ads.googleads.v7.services.types.ad_parameter_service",
    "GetAdRequest": "google.ads.googleads.v7.services.types.ad_service",
    "GetAdScheduleViewRequest": "google.ads.googleads.v7.services.types.ad_schedule_view_service",
    "GetAgeRangeViewRequest": "google.ads.googleads.v7.services.types.age_range_view_service",
    "GetAssetRequest": "google.ads.googleads.v7.services.types.asset_service",
    "GetBatchJobRequest": "google.ads.googleads.v7.services.types.batch_job_service",
    "GetBiddingStrategyRequest": "google.ads.googleads.v7.services.types.bidding_strategy_service",
    "GetBiddingStrategySimulationRequest": "google.ads.googleads.v7.services.types.bidding_strategy_simulation_service",
    "GetBillingSetupRequest": "google.ads.googleads.v7.services.types.billing_setup_service",
    "GetCampaignAssetRequest": "google.ads.googleads.v7.services.types.campaign_asset_service",
    "GetCampaignAudienceViewRequest": "google.ads.googleads.v7.services.types.campaign_audience_view_service",
    "GetCampaignBidModifierRequest": "google.ads.googleads.v7.services.types.campaign_bid_modifier_service",
    "GetCampaignBudgetRequest": "google.ads.googleads.v7.services.types.campaign_budget_service",
    "GetCampaignCriterionRequest": "google.ads.googleads.v7.services.types.campaign_criterion_service",
    "GetCampaignCriterionSimulationRequest": "google.ads.googleads.v7.services.types.campaign_criterion_simulation_service",
    "GetCampaignDraftRequest": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "GetCampaignExperimentRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "GetCampaignExtensionSettingRequest": "google.ads.googleads.v7.services.types.campaign_extension_setting_service",
    "GetCampaignFeedRequest": "google.ads.googleads.v7.services.types.campaign_feed_service",
    "GetCampaignLabelRequest": "google.ads.googleads.v7.services.types.campaign_label_service",
    "GetCampaignRequest": "google.ads.googleads.v7.services.types.campaign_service",
    "GetCampaignSharedSetRequest": "google.ads.googleads.v7.services.types.campaign_shared_set_service",
    "GetCampaignSimulationRequest": "google.ads.googleads.v7.services.types.campaign_simulation_service",
    "GetCarrierConstantRequest": "google.ads.googleads.v7.services.types.carrier_constant_service",
    "GetChangeStatusRequest": "google.ads.googleads.v7.services.types.change_status_service",
    "GetClickViewRequest": "google.ads.googleads.v7.services.types.click_view_service",
    "GetCombinedAudienceRequest": "google.ads.googleads.v7.services.types.combined_audience_service",
    "GetConversionActionRequest": "google.ads.googleads.v7.services.types.conversion_action_service",
    "GetConversionCustomVariableRequest": "google.ads.googleads.v7.services.types.conversion_custom_variable_service",
    "GetCurrencyConstantRequest": "google.ads.googleads.v7.services.types.currency_constant_service",
    "GetCustomAudienceRequest": "google.ads.googleads.v7.services.types.custom_audience_service",
    "GetCustomerAssetRequest": "google.ads.googleads.v7.services.types.customer_asset_service",
    "GetCustomerClientLinkRequest": "google.ads.googleads.v7.services.types.customer_client_link_service",
    "GetCustomerClientRequest": "google.ads.googleads.v7.services.types.customer_client_service",
    "GetCustomerExtensionSettingRequest": "google.ads.googleads.v7.services.types.customer_extension_setting_service",
    "GetCustomerFeedRequest": "google.ads.googleads.v7.services.types.customer_feed_service",
    "GetCustomerLabelRequest": "google.ads.googleads.v7.services.types.customer_label_service",
    "GetCustomerManagerLinkRequest": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "GetCustomerNegativeCriterionRequest": "google.ads.googleads.v7.services.types.customer_negative_criterion_service",
    "GetCustomerRequest": "google.ads.googleads.v7.services.types.customer_service",
    "GetCustomerUserAccessInvitationRequest": "google.ads.googleads.v7.services.types.customer_user_access_invitation_service",
    "GetCustomerUserAccessRequest": "google.ads.googleads.v7.services.types.customer_user_access_service",
    "GetCustomInterestRequest": "google.ads.googleads.v7.services.types.custom_interest_service",
    "GetDetailPlacementViewRequest": "google.ads.googleads.v7.services.types.detail_placement_view_service",
    "GetDisplayKeywordViewRequest": "google.ads.googleads.v7.services.types.display_keyword_view_service",
    "GetDistanceViewRequest": "google.ads.googleads.v7.services.types.distance_view_service",
    "GetDomainCategoryRequest": "google.ads.googleads.v7.services.types.domain_category_service",
    "GetDynamicSearchAdsSearchTermViewRequest": "google.ads.googleads.v7.services.types.dynamic_search_ads_search_term_view_service",
    "GetExpandedLandingPageViewRequest": "google.ads.googleads.v7.services.types.expanded_landing_page_view_service",
    "GetExtensionFeedItemRequest": "google.ads.googleads.v7.services.types.extension_feed_item_service",
    "GetFeedItemRequest": "google.ads.googleads.v7.services.types.feed_item_service",
    "GetFeedItemSetLinkRequest": "google.ads.googleads.v7.services.types.feed_item_set_link_service",
    "GetFeedItemSetRequest": "google.ads.googleads.v7.services.types.feed_item_set_service",
    "GetFeedItemTargetRequest": "google.ads.googleads.v7.services.types.feed_item_target_service",
    "GetFeedMappingRequest": "google.ads.googleads.v7.services.types.feed_mapping_service",
    "GetFeedPlaceholderViewRequest": "google.ads.googleads.v7.services.types.feed_placeholder_view_service",
    "GetFeedRequest": "google.ads.googleads.v7.services.types.feed_service",
    "GetGenderViewRequest": "google.ads.googleads.v7.services.types.gender_view_service",
    "GetGeographicViewRequest": "google.ads.googleads.v7.services.types.geographic_view_service",
    "GetGeoTargetConstantRequest": "google.ads.googleads.v7.services.types.geo_target_constant_service",
    "GetGoogleAdsFieldRequest": "google.ads.googleads.v7.services.types.google_ads_field_service",
    "GetGroupPlacementViewRequest": "google.ads.googleads.v7.services.types.group_placement_view_service",
    "GetHotelGroupViewRequest": "google.ads.googleads.v7.services.types.hotel_group_view_service",
    "GetHotelPerformanceViewRequest": "google.ads.googleads.v7.services.types.hotel_performance_view_service",
    "GetIncomeRangeViewRequest": "google.ads.googleads.v7.services.types.income_range_view_service",
    "GetKeywordPlanAdGroupKeywordRequest": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_keyword_service",
    "GetKeywordPlanAdGroupRequest": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_service",
    "GetKeywordPlanCampaignKeywordRequest": "google.ads.googleads.v7.services.types.keyword_plan_campaign_keyword_service",
    "GetKeywordPlanCampaignRequest": "google.ads.googleads.v7.services.types.keyword_plan_campaign_service",
    "GetKeywordPlanRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "GetKeywordViewRequest": "google.ads.googleads.v7.services.types.keyword_view_service",
    "GetLabelRequest": "google.ads.googleads.v7.services.types.label_service",
    "GetLandingPageViewRequest": "google.ads.googleads.v7.services.types.landing_page_view_service",
    "GetLanguageConstantRequest": "google.ads.googleads.v7.services.types.language_constant_service",
    "GetLifeEventRequest": "google.ads.googleads.v7.services.types.life_event_service",
    "GetLocationViewRequest": "google.ads.googleads.v7.services.types.location_view_service",
    "GetManagedPlacementViewRequest": "google.ads.googleads.v7.services.types.managed_placement_view_service",
    "GetMediaFileRequest": "google.ads.googleads.v7.services.types.media_file_service",
    "GetMerchantCenterLinkRequest": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "GetMobileAppCategoryConstantRequest": "google.ads.googleads.v7.services.types.mobile_app_category_constant_service",
    "GetMobileDeviceConstantRequest": "google.ads.googleads.v7.services.types.mobile_device_constant_service",
    "GetOfflineUserDataJobRequest": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "GetOperatingSystemVersionConstantRequest": "google.ads.googleads.v7.services.types.operating_system_version_constant_service",
    "GetPaidOrganicSearchTermViewRequest": "google.ads.googleads.v7.services.types.paid_organic_search_term_view_service",
    "GetParentalStatusViewRequest": "google.ads.googleads.v7.services.types.parental_status_view_service",
    "GetProductBiddingCategoryConstantRequest": "google.ads.googleads.v7.services.types.product_bidding_category_constant_service",
    "GetProductGroupViewRequest": "google.ads.googleads.v7.services.types.product_group_view_service",
    "GetRecommendationRequest": "google.ads.googleads.v7.services.types.recommendation_service",
    "GetRemarketingActionRequest": "google.ads.googleads.v7.services.types.remarketing_action_service",
    "GetSearchTermViewRequest": "google.ads.googleads.v7.services.types.search_term_view_service",
    "GetSharedCriterionRequest": "google.ads.googleads.v7.services.types.shared_criterion_service",
    "GetSharedSetRequest": "google.ads.googleads.v7.services.types.shared_set_service",
    "GetShoppingPerformanceViewRequest": "google.ads.googleads.v7.services.types.shopping_performance_view_service",
    "GetThirdPartyAppAnalyticsLinkRequest": "google.ads.googleads.v7.services.types.third_party_app_analytics_link_service",
    "GetTopicConstantRequest": "google.ads.googleads.v7.services.types.topic_constant_service",
    "GetTopicViewRequest": "google.ads.googleads.v7.services.types.topic_view_service",
    "GetUserInterestRequest": "google.ads.googleads.v7.services.types.user_interest_service",
    "GetUserListRequest": "google.ads.googleads.v7.services.types.user_list_service",
    "GetUserLocationViewRequest": "google.ads.googleads.v7.services.types.user_location_view_service",
    "GetVideoRequest": "google.ads.googleads.v7.services.types.video_service",
    "GetWebpageViewRequest": "google.ads.googleads.v7.services.types.webpage_view_service",
    "GoogleAdsRow": "google.ads.googleads.v7.services.types.google_ads_service",
    "GraduateCampaignExperimentRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "GraduateCampaignExperimentResponse": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "KeywordAndUrlSeed": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "KeywordPlanAdGroupForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanAdGroupKeywordOperation": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupOperation": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_service",
    "KeywordPlanCampaignForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanCampaignForecastCurve": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanCampaignKeywordOperation": "google.ads.googleads.v7.services.types.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignOperation": "google.ads.googleads.v7.services.types.keyword_plan_campaign_service",
    "KeywordPlanKeywordForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanKeywordHistoricalMetrics": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecastCurve": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanOperation": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanWeeklyForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordPlanWeeklyTimeSeriesForecast": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "KeywordSeed": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "LabelOperation": "google.ads.googleads.v7.services.types.label_service",
    "ListAccessibleCustomersRequest": "google.ads.googleads.v7.services.types.customer_service",
    "ListAccessibleCustomersResponse": "google.ads.googleads.v7.services.types.customer_service",
    "ListBatchJobResultsRequest": "google.ads.googleads.v7.services.types.batch_job_service",
    "ListBatchJobResultsResponse": "google.ads.googleads.v7.services.types.batch_job_service",
    "ListCampaignDraftAsyncErrorsRequest": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "ListCampaignDraftAsyncErrorsResponse": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "ListCampaignExperimentAsyncErrorsRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "ListCampaignExperimentAsyncErrorsResponse": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "ListInvoicesRequest": "google.ads.googleads.v7.services.types.invoice_service",
    "ListInvoicesResponse": "google.ads.googleads.v7.services.types.invoice_service",
    "ListMerchantCenterLinksRequest": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "ListMerchantCenterLinksResponse": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "ListPaymentsAccountsRequest": "google.ads.googleads.v7.services.types.payments_account_service",
    "ListPaymentsAccountsResponse": "google.ads.googleads.v7.services.types.payments_account_service",
    "ListPlannableLocationsRequest": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ListPlannableLocationsResponse": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ListPlannableProductsRequest": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ListPlannableProductsResponse": "google.ads.googleads.v7.services.types.reach_plan_service",
    "MediaFileOperation": "google.ads.googleads.v7.services.types.media_file_service",
    "MerchantCenterLinkOperation": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "MoveManagerLinkRequest": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "MoveManagerLinkResponse": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "MutateAccountBudgetProposalRequest": "google.ads.googleads.v7.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResponse": "google.ads.googleads.v7.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResult": "google.ads.googleads.v7.services.types.account_budget_proposal_service",
    "MutateAccountLinkRequest": "google.ads.googleads.v7.services.types.account_link_service",
    "MutateAccountLinkResponse": "google.ads.googleads.v7.services.types.account_link_service",
    "MutateAccountLinkResult": "google.ads.googleads.v7.services.types.account_link_service",
    "MutateAdGroupAdLabelResult": "google.ads.googleads.v7.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsRequest": "google.ads.googleads.v7.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsResponse": "google.ads.googleads.v7.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdResult": "google.ads.googleads.v7.services.types.ad_group_ad_service",
    "MutateAdGroupAdsRequest": "google.ads.googleads.v7.services.types.ad_group_ad_service",
    "MutateAdGroupAdsResponse": "google.ads.googleads.v7.services.types.ad_group_ad_service",
    "MutateAdGroupAssetResult": "google.ads.googleads.v7.services.types.ad_group_asset_service",
    "MutateAdGroupAssetsRequest": "google.ads.googleads.v7.services.types.ad_group_asset_service",
    "MutateAdGroupAssetsResponse": "google.ads.googleads.v7.services.types.ad_group_asset_service",
    "MutateAdGroupBidModifierResult": "google.ads.googleads.v7.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersRequest": "google.ads.googleads.v7.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersResponse": "google.ads.googleads.v7.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupCriteriaRequest": "google.ads.googleads.v7.services.types.ad_group_criterion_service",
    "MutateAdGroupCriteriaResponse": "google.ads.googleads.v7.services.types.ad_group_criterion_service",
    "MutateAdGroupCriterionLabelResult": "google.ads.googleads.v7.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsRequest": "google.ads.googleads.v7.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsResponse": "google.ads.googleads.v7.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionResult": "google.ads.googleads.v7.services.types.ad_group_criterion_service",
    "MutateAdGroupExtensionSettingResult": "google.ads.googleads.v7.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsRequest": "google.ads.googleads.v7.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsResponse": "google.ads.googleads.v7.services.types.ad_group_extension_setting_service",
    "MutateAdGroupFeedResult": "google.ads.googleads.v7.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsRequest": "google.ads.googleads.v7.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsResponse": "google.ads.googleads.v7.services.types.ad_group_feed_service",
    "MutateAdGroupLabelResult": "google.ads.googleads.v7.services.types.ad_group_label_service",
    "MutateAdGroupLabelsRequest": "google.ads.googleads.v7.services.types.ad_group_label_service",
    "MutateAdGroupLabelsResponse": "google.ads.googleads.v7.services.types.ad_group_label_service",
    "MutateAdGroupResult": "google.ads.googleads.v7.services.types.ad_group_service",
    "MutateAdGroupsRequest": "google.ads.googleads.v7.services.types.ad_group_service",
    "MutateAdGroupsResponse": "google.ads.googleads.v7.services.types.ad_group_service",
    "MutateAdParameterResult": "google.ads.googleads.v7.services.types.ad_parameter_service",
    "MutateAdParametersRequest": "google.ads.googleads.v7.services.types.ad_parameter_service",
    "MutateAdParametersResponse": "google.ads.googleads.v7.services.types.ad_parameter_service",
    "MutateAdResult": "google.ads.googleads.v7.services.types.ad_service",
    "MutateAdsRequest": "google.ads.googleads.v7.services.types.ad_service",
    "MutateAdsResponse": "google.ads.googleads.v7.services.types.ad_service",
    "MutateAssetResult": "google.ads.googleads.v7.services.types.asset_service",
    "MutateAssetsRequest": "google.ads.googleads.v7.services.types.asset_service",
    "MutateAssetsResponse": "google.ads.googleads.v7.services.types.asset_service",
    "MutateBatchJobRequest": "google.ads.googleads.v7.services.types.batch_job_service",
    "MutateBatchJobResponse": "google.ads.googleads.v7.services.types.batch_job_service",
    "MutateBatchJobResult": "google.ads.googleads.v7.services.types.batch_job_service",
    "MutateBiddingStrategiesRequest": "google.ads.googleads.v7.services.types.bidding_strategy_service",
    "MutateBiddingStrategiesResponse": "google.ads.googleads.v7.services.types.bidding_strategy_service",
    "MutateBiddingStrategyResult": "google.ads.googleads.v7.services.types.bidding_strategy_service",
    "MutateBillingSetupRequest": "google.ads.googleads.v7.services.types.billing_setup_service",
    "MutateBillingSetupResponse": "google.ads.googleads.v7.services.types.billing_setup_service",
    "MutateBillingSetupResult": "google.ads.googleads.v7.services.types.billing_setup_service",
    "MutateCampaignAssetResult": "google.ads.googleads.v7.services.types.campaign_asset_service",
    "MutateCampaignAssetsRequest": "google.ads.googleads.v7.services.types.campaign_asset_service",
    "MutateCampaignAssetsResponse": "google.ads.googleads.v7.services.types.campaign_asset_service",
    "MutateCampaignBidModifierResult": "google.ads.googleads.v7.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersRequest": "google.ads.googleads.v7.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersResponse": "google.ads.googleads.v7.services.types.campaign_bid_modifier_service",
    "MutateCampaignBudgetResult": "google.ads.googleads.v7.services.types.campaign_budget_service",
    "MutateCampaignBudgetsRequest": "google.ads.googleads.v7.services.types.campaign_budget_service",
    "MutateCampaignBudgetsResponse": "google.ads.googleads.v7.services.types.campaign_budget_service",
    "MutateCampaignCriteriaRequest": "google.ads.googleads.v7.services.types.campaign_criterion_service",
    "MutateCampaignCriteriaResponse": "google.ads.googleads.v7.services.types.campaign_criterion_service",
    "MutateCampaignCriterionResult": "google.ads.googleads.v7.services.types.campaign_criterion_service",
    "MutateCampaignDraftResult": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "MutateCampaignDraftsRequest": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "MutateCampaignDraftsResponse": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "MutateCampaignExperimentResult": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "MutateCampaignExperimentsRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "MutateCampaignExperimentsResponse": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "MutateCampaignExtensionSettingResult": "google.ads.googleads.v7.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsRequest": "google.ads.googleads.v7.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsResponse": "google.ads.googleads.v7.services.types.campaign_extension_setting_service",
    "MutateCampaignFeedResult": "google.ads.googleads.v7.services.types.campaign_feed_service",
    "MutateCampaignFeedsRequest": "google.ads.googleads.v7.services.types.campaign_feed_service",
    "MutateCampaignFeedsResponse": "google.ads.googleads.v7.services.types.campaign_feed_service",
    "MutateCampaignLabelResult": "google.ads.googleads.v7.services.types.campaign_label_service",
    "MutateCampaignLabelsRequest": "google.ads.googleads.v7.services.types.campaign_label_service",
    "MutateCampaignLabelsResponse": "google.ads.googleads.v7.services.types.campaign_label_service",
    "MutateCampaignResult": "google.ads.googleads.v7.services.types.campaign_service",
    "MutateCampaignSharedSetResult": "google.ads.googleads.v7.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsRequest": "google.ads.googleads.v7.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsResponse": "google.ads.googleads.v7.services.types.campaign_shared_set_service",
    "MutateCampaignsRequest": "google.ads.googleads.v7.services.types.campaign_service",
    "MutateCampaignsResponse": "google.ads.googleads.v7.services.types.campaign_service",
    "MutateConversionActionResult": "google.ads.googleads.v7.services.types.conversion_action_service",
    "MutateConversionActionsRequest": "google.ads.googleads.v7.services.types.conversion_action_service",
    "MutateConversionActionsResponse": "google.ads.googleads.v7.services.types.conversion_action_service",
    "MutateConversionCustomVariableResult": "google.ads.googleads.v7.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesRequest": "google.ads.googleads.v7.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesResponse": "google.ads.googleads.v7.services.types.conversion_custom_variable_service",
    "MutateCustomAudienceResult": "google.ads.googleads.v7.services.types.custom_audience_service",
    "MutateCustomAudiencesRequest": "google.ads.googleads.v7.services.types.custom_audience_service",
    "MutateCustomAudiencesResponse": "google.ads.googleads.v7.services.types.custom_audience_service",
    "MutateCustomerAssetResult": "google.ads.googleads.v7.services.types.customer_asset_service",
    "MutateCustomerAssetsRequest": "google.ads.googleads.v7.services.types.customer_asset_service",
    "MutateCustomerAssetsResponse": "google.ads.googleads.v7.services.types.customer_asset_service",
    "MutateCustomerClientLinkRequest": "google.ads.googleads.v7.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResponse": "google.ads.googleads.v7.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResult": "google.ads.googleads.v7.services.types.customer_client_link_service",
    "MutateCustomerExtensionSettingResult": "google.ads.googleads.v7.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsRequest": "google.ads.googleads.v7.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsResponse": "google.ads.googleads.v7.services.types.customer_extension_setting_service",
    "MutateCustomerFeedResult": "google.ads.googleads.v7.services.types.customer_feed_service",
    "MutateCustomerFeedsRequest": "google.ads.googleads.v7.services.types.customer_feed_service",
    "MutateCustomerFeedsResponse": "google.ads.googleads.v7.services.types.customer_feed_service",
    "MutateCustomerLabelResult": "google.ads.googleads.v7.services.types.customer_label_service",
    "MutateCustomerLabelsRequest": "google.ads.googleads.v7.services.types.customer_label_service",
    "MutateCustomerLabelsResponse": "google.ads.googleads.v7.services.types.customer_label_service",
    "MutateCustomerManagerLinkRequest": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResponse": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResult": "google.ads.googleads.v7.services.types.customer_manager_link_service",
    "MutateCustomerNegativeCriteriaRequest": "google.ads.googleads.v7.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResponse": "google.ads.googleads.v7.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResult": "google.ads.googleads.v7.services.types.customer_negative_criterion_service",
    "MutateCustomerRequest": "google.ads.googleads.v7.services.types.customer_service",
    "MutateCustomerResponse": "google.ads.googleads.v7.services.types.customer_service",
    "MutateCustomerResult": "google.ads.googleads.v7.services.types.customer_service",
    "MutateCustomerUserAccessInvitationRequest": "google.ads.googleads.v7.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResponse": "google.ads.googleads.v7.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResult": "google.ads.googleads.v7.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessRequest": "google.ads.googleads.v7.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResponse": "google.ads.googleads.v7.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResult": "google.ads.googleads.v7.services.types.customer_user_access_service",
    "MutateCustomInterestResult": "google.ads.googleads.v7.services.types.custom_interest_service",
    "MutateCustomInterestsRequest": "google.ads.googleads.v7.services.types.custom_interest_service",
    "MutateCustomInterestsResponse": "google.ads.googleads.v7.services.types.custom_interest_service",
    "MutateExtensionFeedItemResult": "google.ads.googleads.v7.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsRequest": "google.ads.googleads.v7.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsResponse": "google.ads.googleads.v7.services.types.extension_feed_item_service",
    "MutateFeedItemResult": "google.ads.googleads.v7.services.types.feed_item_service",
    "MutateFeedItemSetLinkResult": "google.ads.googleads.v7.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksRequest": "google.ads.googleads.v7.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksResponse": "google.ads.googleads.v7.services.types.feed_item_set_link_service",
    "MutateFeedItemSetResult": "google.ads.googleads.v7.services.types.feed_item_set_service",
    "MutateFeedItemSetsRequest": "google.ads.googleads.v7.services.types.feed_item_set_service",
    "MutateFeedItemSetsResponse": "google.ads.googleads.v7.services.types.feed_item_set_service",
    "MutateFeedItemsRequest": "google.ads.googleads.v7.services.types.feed_item_service",
    "MutateFeedItemsResponse": "google.ads.googleads.v7.services.types.feed_item_service",
    "MutateFeedItemTargetResult": "google.ads.googleads.v7.services.types.feed_item_target_service",
    "MutateFeedItemTargetsRequest": "google.ads.googleads.v7.services.types.feed_item_target_service",
    "MutateFeedItemTargetsResponse": "google.ads.googleads.v7.services.types.feed_item_target_service",
    "MutateFeedMappingResult": "google.ads.googleads.v7.services.types.feed_mapping_service",
    "MutateFeedMappingsRequest": "google.ads.googleads.v7.services.types.feed_mapping_service",
    "MutateFeedMappingsResponse": "google.ads.googleads.v7.services.types.feed_mapping_service",
    "MutateFeedResult": "google.ads.googleads.v7.services.types.feed_service",
    "MutateFeedsRequest": "google.ads.googleads.v7.services.types.feed_service",
    "MutateFeedsResponse": "google.ads.googleads.v7.services.types.feed_service",
    "MutateGoogleAdsRequest": "google.ads.googleads.v7.services.types.google_ads_service",
    "MutateGoogleAdsResponse": "google.ads.googleads.v7.services.types.google_ads_service",
    "MutateKeywordPlanAdGroupKeywordResult": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsRequest": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsResponse": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupResult": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsRequest": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsResponse": "google.ads.googleads.v7.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanCampaignKeywordResult": "google.ads.googleads.v7.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsRequest": "google.ads.googleads.v7.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsResponse": "google.ads.googleads.v7.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignResult": "google.ads.googleads.v7.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsRequest": "google.ads.googleads.v7.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsResponse": "google.ads.googleads.v7.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlansRequest": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "MutateKeywordPlansResponse": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "MutateKeywordPlansResult": "google.ads.googleads.v7.services.types.keyword_plan_service",
    "MutateLabelResult": "google.ads.googleads.v7.services.types.label_service",
    "MutateLabelsRequest": "google.ads.googleads.v7.services.types.label_service",
    "MutateLabelsResponse": "google.ads.googleads.v7.services.types.label_service",
    "MutateMediaFileResult": "google.ads.googleads.v7.services.types.media_file_service",
    "MutateMediaFilesRequest": "google.ads.googleads.v7.services.types.media_file_service",
    "MutateMediaFilesResponse": "google.ads.googleads.v7.services.types.media_file_service",
    "MutateMerchantCenterLinkRequest": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResponse": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResult": "google.ads.googleads.v7.services.types.merchant_center_link_service",
    "MutateOperation": "google.ads.googleads.v7.services.types.google_ads_service",
    "MutateOperationResponse": "google.ads.googleads.v7.services.types.google_ads_service",
    "MutateRemarketingActionResult": "google.ads.googleads.v7.services.types.remarketing_action_service",
    "MutateRemarketingActionsRequest": "google.ads.googleads.v7.services.types.remarketing_action_service",
    "MutateRemarketingActionsResponse": "google.ads.googleads.v7.services.types.remarketing_action_service",
    "MutateSharedCriteriaRequest": "google.ads.googleads.v7.services.types.shared_criterion_service",
    "MutateSharedCriteriaResponse": "google.ads.googleads.v7.services.types.shared_criterion_service",
    "MutateSharedCriterionResult": "google.ads.googleads.v7.services.types.shared_criterion_service",
    "MutateSharedSetResult": "google.ads.googleads.v7.services.types.shared_set_service",
    "MutateSharedSetsRequest": "google.ads.googleads.v7.services.types.shared_set_service",
    "MutateSharedSetsResponse": "google.ads.googleads.v7.services.types.shared_set_service",
    "MutateUserListResult": "google.ads.googleads.v7.services.types.user_list_service",
    "MutateUserListsRequest": "google.ads.googleads.v7.services.types.user_list_service",
    "MutateUserListsResponse": "google.ads.googleads.v7.services.types.user_list_service",
    "OfflineUserDataJobOperation": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "OnTargetAudienceMetrics": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PlannableLocation": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PlannableTargeting": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PlannedProduct": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PlannedProductForecast": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PlannedProductReachForecast": "google.ads.googleads.v7.services.types.reach_plan_service",
    "Preferences": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ProductAllocation": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ProductMetadata": "google.ads.googleads.v7.services.types.reach_plan_service",
    "PromoteCampaignDraftRequest": "google.ads.googleads.v7.services.types.campaign_draft_service",
    "PromoteCampaignExperimentRequest": "google.ads.googleads.v7.services.types.campaign_experiment_service",
    "ReachCurve": "google.ads.googleads.v7.services.types.reach_plan_service",
    "ReachForecast": "google.ads.googleads.v7.services.types.reach_plan_service",
    "RegenerateShareableLinkIdRequest": "google.ads.googleads.v7.services.types.third_party_app_analytics_link_service",
    "RegenerateShareableLinkIdResponse": "google.ads.googleads.v7.services.types.third_party_app_analytics_link_service",
    "RemarketingActionOperation": "google.ads.googleads.v7.services.types.remarketing_action_service",
    "RestatementValue": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "RunBatchJobRequest": "google.ads.googleads.v7.services.types.batch_job_service",
    "RunOfflineUserDataJobRequest": "google.ads.googleads.v7.services.types.offline_user_data_job_service",
    "SearchGoogleAdsFieldsRequest": "google.ads.googleads.v7.services.types.google_ads_field_service",
    "SearchGoogleAdsFieldsResponse": "google.ads.googleads.v7.services.types.google_ads_field_service",
    "SearchGoogleAdsRequest": "google.ads.googleads.v7.services.types.google_ads_service",
    "SearchGoogleAdsResponse": "google.ads.googleads.v7.services.types.google_ads_service",
    "SearchGoogleAdsStreamRequest": "google.ads.googleads.v7.services.types.google_ads_service",
    "SearchGoogleAdsStreamResponse": "google.ads.googleads.v7.services.types.google_ads_service",
    "SharedCriterionOperation": "google.ads.googleads.v7.services.types.shared_criterion_service",
    "SharedSetOperation": "google.ads.googleads.v7.services.types.shared_set_service",
    "SiteSeed": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "SuggestGeoTargetConstantsRequest": "google.ads.googleads.v7.services.types.geo_target_constant_service",
    "SuggestGeoTargetConstantsResponse": "google.ads.googleads.v7.services.types.geo_target_constant_service",
    "Targeting": "google.ads.googleads.v7.services.types.reach_plan_service",
    "UploadCallConversionsRequest": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "UploadCallConversionsResponse": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "UploadClickConversionsRequest": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "UploadClickConversionsResponse": "google.ads.googleads.v7.services.types.conversion_upload_service",
    "UploadConversionAdjustmentsRequest": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "UploadConversionAdjustmentsResponse": "google.ads.googleads.v7.services.types.conversion_adjustment_upload_service",
    "UploadUserDataRequest": "google.ads.googleads.v7.services.types.user_data_service",
    "UploadUserDataResponse": "google.ads.googleads.v7.services.types.user_data_service",
    "UrlSeed": "google.ads.googleads.v7.services.types.keyword_plan_idea_service",
    "UserDataOperation": "google.ads.googleads.v7.services.types.user_data_service",
    "UserListOperation": "google.ads.googleads.v7.services.types.user_list_service",
    # Enum types
    # Client classes and transports
    "AccountBudgetProposalServiceClient": "google.ads.googleads.v7.services.services.account_budget_proposal_service",
    "AccountBudgetProposalServiceTransport": "google.ads.googleads.v7.services.services.account_budget_proposal_service.transports",
    "AccountBudgetProposalServiceGrpcTransport": "google.ads.googleads.v7.services.services.account_budget_proposal_service.transports",
    "AccountBudgetServiceClient": "google.ads.googleads.v7.services.services.account_budget_service",
    "AccountBudgetServiceTransport": "google.ads.googleads.v7.services.services.account_budget_service.transports",
    "AccountBudgetServiceGrpcTransport": "google.ads.googleads.v7.services.services.account_budget_service.transports",
    "AccountLinkServiceClient": "google.ads.googleads.v7.services.services.account_link_service",
    "AccountLinkServiceTransport": "google.ads.googleads.v7.services.services.account_link_service.transports",
    "AccountLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.account_link_service.transports",
    "AdGroupAdAssetViewServiceClient": "google.ads.googleads.v7.services.services.ad_group_ad_asset_view_service",
    "AdGroupAdAssetViewServiceTransport": "google.ads.googleads.v7.services.services.ad_group_ad_asset_view_service.transports",
    "AdGroupAdAssetViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_ad_asset_view_service.transports",
    "AdGroupAdLabelServiceClient": "google.ads.googleads.v7.services.services.ad_group_ad_label_service",
    "AdGroupAdLabelServiceTransport": "google.ads.googleads.v7.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdLabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdServiceClient": "google.ads.googleads.v7.services.services.ad_group_ad_service",
    "AdGroupAdServiceTransport": "google.ads.googleads.v7.services.services.ad_group_ad_service.transports",
    "AdGroupAdServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_ad_service.transports",
    "AdGroupAssetServiceClient": "google.ads.googleads.v7.services.services.ad_group_asset_service",
    "AdGroupAssetServiceTransport": "google.ads.googleads.v7.services.services.ad_group_asset_service.transports",
    "AdGroupAssetServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_asset_service.transports",
    "AdGroupAudienceViewServiceClient": "google.ads.googleads.v7.services.services.ad_group_audience_view_service",
    "AdGroupAudienceViewServiceTransport": "google.ads.googleads.v7.services.services.ad_group_audience_view_service.transports",
    "AdGroupAudienceViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_audience_view_service.transports",
    "AdGroupBidModifierServiceClient": "google.ads.googleads.v7.services.services.ad_group_bid_modifier_service",
    "AdGroupBidModifierServiceTransport": "google.ads.googleads.v7.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupBidModifierServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupCriterionLabelServiceClient": "google.ads.googleads.v7.services.services.ad_group_criterion_label_service",
    "AdGroupCriterionLabelServiceTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionLabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionServiceClient": "google.ads.googleads.v7.services.services.ad_group_criterion_service",
    "AdGroupCriterionServiceTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_service.transports",
    "AdGroupCriterionServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_service.transports",
    "AdGroupCriterionSimulationServiceClient": "google.ads.googleads.v7.services.services.ad_group_criterion_simulation_service",
    "AdGroupCriterionSimulationServiceTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_simulation_service.transports",
    "AdGroupCriterionSimulationServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_criterion_simulation_service.transports",
    "AdGroupExtensionSettingServiceClient": "google.ads.googleads.v7.services.services.ad_group_extension_setting_service",
    "AdGroupExtensionSettingServiceTransport": "google.ads.googleads.v7.services.services.ad_group_extension_setting_service.transports",
    "AdGroupExtensionSettingServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_extension_setting_service.transports",
    "AdGroupFeedServiceClient": "google.ads.googleads.v7.services.services.ad_group_feed_service",
    "AdGroupFeedServiceTransport": "google.ads.googleads.v7.services.services.ad_group_feed_service.transports",
    "AdGroupFeedServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_feed_service.transports",
    "AdGroupLabelServiceClient": "google.ads.googleads.v7.services.services.ad_group_label_service",
    "AdGroupLabelServiceTransport": "google.ads.googleads.v7.services.services.ad_group_label_service.transports",
    "AdGroupLabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_label_service.transports",
    "AdGroupServiceClient": "google.ads.googleads.v7.services.services.ad_group_service",
    "AdGroupServiceTransport": "google.ads.googleads.v7.services.services.ad_group_service.transports",
    "AdGroupServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_service.transports",
    "AdGroupSimulationServiceClient": "google.ads.googleads.v7.services.services.ad_group_simulation_service",
    "AdGroupSimulationServiceTransport": "google.ads.googleads.v7.services.services.ad_group_simulation_service.transports",
    "AdGroupSimulationServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_group_simulation_service.transports",
    "AdParameterServiceClient": "google.ads.googleads.v7.services.services.ad_parameter_service",
    "AdParameterServiceTransport": "google.ads.googleads.v7.services.services.ad_parameter_service.transports",
    "AdParameterServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_parameter_service.transports",
    "AdScheduleViewServiceClient": "google.ads.googleads.v7.services.services.ad_schedule_view_service",
    "AdScheduleViewServiceTransport": "google.ads.googleads.v7.services.services.ad_schedule_view_service.transports",
    "AdScheduleViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_schedule_view_service.transports",
    "AdServiceClient": "google.ads.googleads.v7.services.services.ad_service",
    "AdServiceTransport": "google.ads.googleads.v7.services.services.ad_service.transports",
    "AdServiceGrpcTransport": "google.ads.googleads.v7.services.services.ad_service.transports",
    "AgeRangeViewServiceClient": "google.ads.googleads.v7.services.services.age_range_view_service",
    "AgeRangeViewServiceTransport": "google.ads.googleads.v7.services.services.age_range_view_service.transports",
    "AgeRangeViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.age_range_view_service.transports",
    "AssetServiceClient": "google.ads.googleads.v7.services.services.asset_service",
    "AssetServiceTransport": "google.ads.googleads.v7.services.services.asset_service.transports",
    "AssetServiceGrpcTransport": "google.ads.googleads.v7.services.services.asset_service.transports",
    "BatchJobServiceClient": "google.ads.googleads.v7.services.services.batch_job_service",
    "BatchJobServiceTransport": "google.ads.googleads.v7.services.services.batch_job_service.transports",
    "BatchJobServiceGrpcTransport": "google.ads.googleads.v7.services.services.batch_job_service.transports",
    "BiddingStrategyServiceClient": "google.ads.googleads.v7.services.services.bidding_strategy_service",
    "BiddingStrategyServiceTransport": "google.ads.googleads.v7.services.services.bidding_strategy_service.transports",
    "BiddingStrategyServiceGrpcTransport": "google.ads.googleads.v7.services.services.bidding_strategy_service.transports",
    "BiddingStrategySimulationServiceClient": "google.ads.googleads.v7.services.services.bidding_strategy_simulation_service",
    "BiddingStrategySimulationServiceTransport": "google.ads.googleads.v7.services.services.bidding_strategy_simulation_service.transports",
    "BiddingStrategySimulationServiceGrpcTransport": "google.ads.googleads.v7.services.services.bidding_strategy_simulation_service.transports",
    "BillingSetupServiceClient": "google.ads.googleads.v7.services.services.billing_setup_service",
    "BillingSetupServiceTransport": "google.ads.googleads.v7.services.services.billing_setup_service.transports",
    "BillingSetupServiceGrpcTransport": "google.ads.googleads.v7.services.services.billing_setup_service.transports",
    "CampaignAssetServiceClient": "google.ads.googleads.v7.services.services.campaign_asset_service",
    "CampaignAssetServiceTransport": "google.ads.googleads.v7.services.services.campaign_asset_service.transports",
    "CampaignAssetServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_asset_service.transports",
    "CampaignAudienceViewServiceClient": "google.ads.googleads.v7.services.services.campaign_audience_view_service",
    "CampaignAudienceViewServiceTransport": "google.ads.googleads.v7.services.services.campaign_audience_view_service.transports",
    "CampaignAudienceViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_audience_view_service.transports",
    "CampaignBidModifierServiceClient": "google.ads.googleads.v7.services.services.campaign_bid_modifier_service",
    "CampaignBidModifierServiceTransport": "google.ads.googleads.v7.services.services.campaign_bid_modifier_service.transports",
    "CampaignBidModifierServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_bid_modifier_service.transports",
    "CampaignBudgetServiceClient": "google.ads.googleads.v7.services.services.campaign_budget_service",
    "CampaignBudgetServiceTransport": "google.ads.googleads.v7.services.services.campaign_budget_service.transports",
    "CampaignBudgetServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_budget_service.transports",
    "CampaignCriterionServiceClient": "google.ads.googleads.v7.services.services.campaign_criterion_service",
    "CampaignCriterionServiceTransport": "google.ads.googleads.v7.services.services.campaign_criterion_service.transports",
    "CampaignCriterionServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_criterion_service.transports",
    "CampaignCriterionSimulationServiceClient": "google.ads.googleads.v7.services.services.campaign_criterion_simulation_service",
    "CampaignCriterionSimulationServiceTransport": "google.ads.googleads.v7.services.services.campaign_criterion_simulation_service.transports",
    "CampaignCriterionSimulationServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_criterion_simulation_service.transports",
    "CampaignDraftServiceClient": "google.ads.googleads.v7.services.services.campaign_draft_service",
    "CampaignDraftServiceTransport": "google.ads.googleads.v7.services.services.campaign_draft_service.transports",
    "CampaignDraftServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_draft_service.transports",
    "CampaignExperimentServiceClient": "google.ads.googleads.v7.services.services.campaign_experiment_service",
    "CampaignExperimentServiceTransport": "google.ads.googleads.v7.services.services.campaign_experiment_service.transports",
    "CampaignExperimentServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_experiment_service.transports",
    "CampaignExtensionSettingServiceClient": "google.ads.googleads.v7.services.services.campaign_extension_setting_service",
    "CampaignExtensionSettingServiceTransport": "google.ads.googleads.v7.services.services.campaign_extension_setting_service.transports",
    "CampaignExtensionSettingServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_extension_setting_service.transports",
    "CampaignFeedServiceClient": "google.ads.googleads.v7.services.services.campaign_feed_service",
    "CampaignFeedServiceTransport": "google.ads.googleads.v7.services.services.campaign_feed_service.transports",
    "CampaignFeedServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_feed_service.transports",
    "CampaignLabelServiceClient": "google.ads.googleads.v7.services.services.campaign_label_service",
    "CampaignLabelServiceTransport": "google.ads.googleads.v7.services.services.campaign_label_service.transports",
    "CampaignLabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_label_service.transports",
    "CampaignServiceClient": "google.ads.googleads.v7.services.services.campaign_service",
    "CampaignServiceTransport": "google.ads.googleads.v7.services.services.campaign_service.transports",
    "CampaignServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_service.transports",
    "CampaignSharedSetServiceClient": "google.ads.googleads.v7.services.services.campaign_shared_set_service",
    "CampaignSharedSetServiceTransport": "google.ads.googleads.v7.services.services.campaign_shared_set_service.transports",
    "CampaignSharedSetServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_shared_set_service.transports",
    "CampaignSimulationServiceClient": "google.ads.googleads.v7.services.services.campaign_simulation_service",
    "CampaignSimulationServiceTransport": "google.ads.googleads.v7.services.services.campaign_simulation_service.transports",
    "CampaignSimulationServiceGrpcTransport": "google.ads.googleads.v7.services.services.campaign_simulation_service.transports",
    "CarrierConstantServiceClient": "google.ads.googleads.v7.services.services.carrier_constant_service",
    "CarrierConstantServiceTransport": "google.ads.googleads.v7.services.services.carrier_constant_service.transports",
    "CarrierConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.carrier_constant_service.transports",
    "ChangeStatusServiceClient": "google.ads.googleads.v7.services.services.change_status_service",
    "ChangeStatusServiceTransport": "google.ads.googleads.v7.services.services.change_status_service.transports",
    "ChangeStatusServiceGrpcTransport": "google.ads.googleads.v7.services.services.change_status_service.transports",
    "ClickViewServiceClient": "google.ads.googleads.v7.services.services.click_view_service",
    "ClickViewServiceTransport": "google.ads.googleads.v7.services.services.click_view_service.transports",
    "ClickViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.click_view_service.transports",
    "CombinedAudienceServiceClient": "google.ads.googleads.v7.services.services.combined_audience_service",
    "CombinedAudienceServiceTransport": "google.ads.googleads.v7.services.services.combined_audience_service.transports",
    "CombinedAudienceServiceGrpcTransport": "google.ads.googleads.v7.services.services.combined_audience_service.transports",
    "ConversionActionServiceClient": "google.ads.googleads.v7.services.services.conversion_action_service",
    "ConversionActionServiceTransport": "google.ads.googleads.v7.services.services.conversion_action_service.transports",
    "ConversionActionServiceGrpcTransport": "google.ads.googleads.v7.services.services.conversion_action_service.transports",
    "ConversionAdjustmentUploadServiceClient": "google.ads.googleads.v7.services.services.conversion_adjustment_upload_service",
    "ConversionAdjustmentUploadServiceTransport": "google.ads.googleads.v7.services.services.conversion_adjustment_upload_service.transports",
    "ConversionAdjustmentUploadServiceGrpcTransport": "google.ads.googleads.v7.services.services.conversion_adjustment_upload_service.transports",
    "ConversionCustomVariableServiceClient": "google.ads.googleads.v7.services.services.conversion_custom_variable_service",
    "ConversionCustomVariableServiceTransport": "google.ads.googleads.v7.services.services.conversion_custom_variable_service.transports",
    "ConversionCustomVariableServiceGrpcTransport": "google.ads.googleads.v7.services.services.conversion_custom_variable_service.transports",
    "ConversionUploadServiceClient": "google.ads.googleads.v7.services.services.conversion_upload_service",
    "ConversionUploadServiceTransport": "google.ads.googleads.v7.services.services.conversion_upload_service.transports",
    "ConversionUploadServiceGrpcTransport": "google.ads.googleads.v7.services.services.conversion_upload_service.transports",
    "CurrencyConstantServiceClient": "google.ads.googleads.v7.services.services.currency_constant_service",
    "CurrencyConstantServiceTransport": "google.ads.googleads.v7.services.services.currency_constant_service.transports",
    "CurrencyConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.currency_constant_service.transports",
    "CustomAudienceServiceClient": "google.ads.googleads.v7.services.services.custom_audience_service",
    "CustomAudienceServiceTransport": "google.ads.googleads.v7.services.services.custom_audience_service.transports",
    "CustomAudienceServiceGrpcTransport": "google.ads.googleads.v7.services.services.custom_audience_service.transports",
    "CustomerAssetServiceClient": "google.ads.googleads.v7.services.services.customer_asset_service",
    "CustomerAssetServiceTransport": "google.ads.googleads.v7.services.services.customer_asset_service.transports",
    "CustomerAssetServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_asset_service.transports",
    "CustomerClientLinkServiceClient": "google.ads.googleads.v7.services.services.customer_client_link_service",
    "CustomerClientLinkServiceTransport": "google.ads.googleads.v7.services.services.customer_client_link_service.transports",
    "CustomerClientLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_client_link_service.transports",
    "CustomerClientServiceClient": "google.ads.googleads.v7.services.services.customer_client_service",
    "CustomerClientServiceTransport": "google.ads.googleads.v7.services.services.customer_client_service.transports",
    "CustomerClientServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_client_service.transports",
    "CustomerExtensionSettingServiceClient": "google.ads.googleads.v7.services.services.customer_extension_setting_service",
    "CustomerExtensionSettingServiceTransport": "google.ads.googleads.v7.services.services.customer_extension_setting_service.transports",
    "CustomerExtensionSettingServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_extension_setting_service.transports",
    "CustomerFeedServiceClient": "google.ads.googleads.v7.services.services.customer_feed_service",
    "CustomerFeedServiceTransport": "google.ads.googleads.v7.services.services.customer_feed_service.transports",
    "CustomerFeedServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_feed_service.transports",
    "CustomerLabelServiceClient": "google.ads.googleads.v7.services.services.customer_label_service",
    "CustomerLabelServiceTransport": "google.ads.googleads.v7.services.services.customer_label_service.transports",
    "CustomerLabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_label_service.transports",
    "CustomerManagerLinkServiceClient": "google.ads.googleads.v7.services.services.customer_manager_link_service",
    "CustomerManagerLinkServiceTransport": "google.ads.googleads.v7.services.services.customer_manager_link_service.transports",
    "CustomerManagerLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_manager_link_service.transports",
    "CustomerNegativeCriterionServiceClient": "google.ads.googleads.v7.services.services.customer_negative_criterion_service",
    "CustomerNegativeCriterionServiceTransport": "google.ads.googleads.v7.services.services.customer_negative_criterion_service.transports",
    "CustomerNegativeCriterionServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_negative_criterion_service.transports",
    "CustomerServiceClient": "google.ads.googleads.v7.services.services.customer_service",
    "CustomerServiceTransport": "google.ads.googleads.v7.services.services.customer_service.transports",
    "CustomerServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_service.transports",
    "CustomerUserAccessInvitationServiceClient": "google.ads.googleads.v7.services.services.customer_user_access_invitation_service",
    "CustomerUserAccessInvitationServiceTransport": "google.ads.googleads.v7.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessInvitationServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessServiceClient": "google.ads.googleads.v7.services.services.customer_user_access_service",
    "CustomerUserAccessServiceTransport": "google.ads.googleads.v7.services.services.customer_user_access_service.transports",
    "CustomerUserAccessServiceGrpcTransport": "google.ads.googleads.v7.services.services.customer_user_access_service.transports",
    "CustomInterestServiceClient": "google.ads.googleads.v7.services.services.custom_interest_service",
    "CustomInterestServiceTransport": "google.ads.googleads.v7.services.services.custom_interest_service.transports",
    "CustomInterestServiceGrpcTransport": "google.ads.googleads.v7.services.services.custom_interest_service.transports",
    "DetailPlacementViewServiceClient": "google.ads.googleads.v7.services.services.detail_placement_view_service",
    "DetailPlacementViewServiceTransport": "google.ads.googleads.v7.services.services.detail_placement_view_service.transports",
    "DetailPlacementViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.detail_placement_view_service.transports",
    "DisplayKeywordViewServiceClient": "google.ads.googleads.v7.services.services.display_keyword_view_service",
    "DisplayKeywordViewServiceTransport": "google.ads.googleads.v7.services.services.display_keyword_view_service.transports",
    "DisplayKeywordViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.display_keyword_view_service.transports",
    "DistanceViewServiceClient": "google.ads.googleads.v7.services.services.distance_view_service",
    "DistanceViewServiceTransport": "google.ads.googleads.v7.services.services.distance_view_service.transports",
    "DistanceViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.distance_view_service.transports",
    "DomainCategoryServiceClient": "google.ads.googleads.v7.services.services.domain_category_service",
    "DomainCategoryServiceTransport": "google.ads.googleads.v7.services.services.domain_category_service.transports",
    "DomainCategoryServiceGrpcTransport": "google.ads.googleads.v7.services.services.domain_category_service.transports",
    "DynamicSearchAdsSearchTermViewServiceClient": "google.ads.googleads.v7.services.services.dynamic_search_ads_search_term_view_service",
    "DynamicSearchAdsSearchTermViewServiceTransport": "google.ads.googleads.v7.services.services.dynamic_search_ads_search_term_view_service.transports",
    "DynamicSearchAdsSearchTermViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.dynamic_search_ads_search_term_view_service.transports",
    "ExpandedLandingPageViewServiceClient": "google.ads.googleads.v7.services.services.expanded_landing_page_view_service",
    "ExpandedLandingPageViewServiceTransport": "google.ads.googleads.v7.services.services.expanded_landing_page_view_service.transports",
    "ExpandedLandingPageViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.expanded_landing_page_view_service.transports",
    "ExtensionFeedItemServiceClient": "google.ads.googleads.v7.services.services.extension_feed_item_service",
    "ExtensionFeedItemServiceTransport": "google.ads.googleads.v7.services.services.extension_feed_item_service.transports",
    "ExtensionFeedItemServiceGrpcTransport": "google.ads.googleads.v7.services.services.extension_feed_item_service.transports",
    "FeedItemServiceClient": "google.ads.googleads.v7.services.services.feed_item_service",
    "FeedItemServiceTransport": "google.ads.googleads.v7.services.services.feed_item_service.transports",
    "FeedItemServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_item_service.transports",
    "FeedItemSetLinkServiceClient": "google.ads.googleads.v7.services.services.feed_item_set_link_service",
    "FeedItemSetLinkServiceTransport": "google.ads.googleads.v7.services.services.feed_item_set_link_service.transports",
    "FeedItemSetLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_item_set_link_service.transports",
    "FeedItemSetServiceClient": "google.ads.googleads.v7.services.services.feed_item_set_service",
    "FeedItemSetServiceTransport": "google.ads.googleads.v7.services.services.feed_item_set_service.transports",
    "FeedItemSetServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_item_set_service.transports",
    "FeedItemTargetServiceClient": "google.ads.googleads.v7.services.services.feed_item_target_service",
    "FeedItemTargetServiceTransport": "google.ads.googleads.v7.services.services.feed_item_target_service.transports",
    "FeedItemTargetServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_item_target_service.transports",
    "FeedMappingServiceClient": "google.ads.googleads.v7.services.services.feed_mapping_service",
    "FeedMappingServiceTransport": "google.ads.googleads.v7.services.services.feed_mapping_service.transports",
    "FeedMappingServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_mapping_service.transports",
    "FeedPlaceholderViewServiceClient": "google.ads.googleads.v7.services.services.feed_placeholder_view_service",
    "FeedPlaceholderViewServiceTransport": "google.ads.googleads.v7.services.services.feed_placeholder_view_service.transports",
    "FeedPlaceholderViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_placeholder_view_service.transports",
    "FeedServiceClient": "google.ads.googleads.v7.services.services.feed_service",
    "FeedServiceTransport": "google.ads.googleads.v7.services.services.feed_service.transports",
    "FeedServiceGrpcTransport": "google.ads.googleads.v7.services.services.feed_service.transports",
    "GenderViewServiceClient": "google.ads.googleads.v7.services.services.gender_view_service",
    "GenderViewServiceTransport": "google.ads.googleads.v7.services.services.gender_view_service.transports",
    "GenderViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.gender_view_service.transports",
    "GeographicViewServiceClient": "google.ads.googleads.v7.services.services.geographic_view_service",
    "GeographicViewServiceTransport": "google.ads.googleads.v7.services.services.geographic_view_service.transports",
    "GeographicViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.geographic_view_service.transports",
    "GeoTargetConstantServiceClient": "google.ads.googleads.v7.services.services.geo_target_constant_service",
    "GeoTargetConstantServiceTransport": "google.ads.googleads.v7.services.services.geo_target_constant_service.transports",
    "GeoTargetConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.geo_target_constant_service.transports",
    "GoogleAdsFieldServiceClient": "google.ads.googleads.v7.services.services.google_ads_field_service",
    "GoogleAdsFieldServiceTransport": "google.ads.googleads.v7.services.services.google_ads_field_service.transports",
    "GoogleAdsFieldServiceGrpcTransport": "google.ads.googleads.v7.services.services.google_ads_field_service.transports",
    "GoogleAdsServiceClient": "google.ads.googleads.v7.services.services.google_ads_service",
    "GoogleAdsServiceTransport": "google.ads.googleads.v7.services.services.google_ads_service.transports",
    "GoogleAdsServiceGrpcTransport": "google.ads.googleads.v7.services.services.google_ads_service.transports",
    "GroupPlacementViewServiceClient": "google.ads.googleads.v7.services.services.group_placement_view_service",
    "GroupPlacementViewServiceTransport": "google.ads.googleads.v7.services.services.group_placement_view_service.transports",
    "GroupPlacementViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.group_placement_view_service.transports",
    "HotelGroupViewServiceClient": "google.ads.googleads.v7.services.services.hotel_group_view_service",
    "HotelGroupViewServiceTransport": "google.ads.googleads.v7.services.services.hotel_group_view_service.transports",
    "HotelGroupViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.hotel_group_view_service.transports",
    "HotelPerformanceViewServiceClient": "google.ads.googleads.v7.services.services.hotel_performance_view_service",
    "HotelPerformanceViewServiceTransport": "google.ads.googleads.v7.services.services.hotel_performance_view_service.transports",
    "HotelPerformanceViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.hotel_performance_view_service.transports",
    "IncomeRangeViewServiceClient": "google.ads.googleads.v7.services.services.income_range_view_service",
    "IncomeRangeViewServiceTransport": "google.ads.googleads.v7.services.services.income_range_view_service.transports",
    "IncomeRangeViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.income_range_view_service.transports",
    "InvoiceServiceClient": "google.ads.googleads.v7.services.services.invoice_service",
    "InvoiceServiceTransport": "google.ads.googleads.v7.services.services.invoice_service.transports",
    "InvoiceServiceGrpcTransport": "google.ads.googleads.v7.services.services.invoice_service.transports",
    "KeywordPlanAdGroupKeywordServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupKeywordServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupKeywordServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_service",
    "KeywordPlanAdGroupServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanAdGroupServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanCampaignKeywordServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignKeywordServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignKeywordServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_campaign_service",
    "KeywordPlanCampaignServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanCampaignServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanIdeaServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_idea_service",
    "KeywordPlanIdeaServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanIdeaServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanServiceClient": "google.ads.googleads.v7.services.services.keyword_plan_service",
    "KeywordPlanServiceTransport": "google.ads.googleads.v7.services.services.keyword_plan_service.transports",
    "KeywordPlanServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_plan_service.transports",
    "KeywordViewServiceClient": "google.ads.googleads.v7.services.services.keyword_view_service",
    "KeywordViewServiceTransport": "google.ads.googleads.v7.services.services.keyword_view_service.transports",
    "KeywordViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.keyword_view_service.transports",
    "LabelServiceClient": "google.ads.googleads.v7.services.services.label_service",
    "LabelServiceTransport": "google.ads.googleads.v7.services.services.label_service.transports",
    "LabelServiceGrpcTransport": "google.ads.googleads.v7.services.services.label_service.transports",
    "LandingPageViewServiceClient": "google.ads.googleads.v7.services.services.landing_page_view_service",
    "LandingPageViewServiceTransport": "google.ads.googleads.v7.services.services.landing_page_view_service.transports",
    "LandingPageViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.landing_page_view_service.transports",
    "LanguageConstantServiceClient": "google.ads.googleads.v7.services.services.language_constant_service",
    "LanguageConstantServiceTransport": "google.ads.googleads.v7.services.services.language_constant_service.transports",
    "LanguageConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.language_constant_service.transports",
    "LifeEventServiceClient": "google.ads.googleads.v7.services.services.life_event_service",
    "LifeEventServiceTransport": "google.ads.googleads.v7.services.services.life_event_service.transports",
    "LifeEventServiceGrpcTransport": "google.ads.googleads.v7.services.services.life_event_service.transports",
    "LocationViewServiceClient": "google.ads.googleads.v7.services.services.location_view_service",
    "LocationViewServiceTransport": "google.ads.googleads.v7.services.services.location_view_service.transports",
    "LocationViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.location_view_service.transports",
    "ManagedPlacementViewServiceClient": "google.ads.googleads.v7.services.services.managed_placement_view_service",
    "ManagedPlacementViewServiceTransport": "google.ads.googleads.v7.services.services.managed_placement_view_service.transports",
    "ManagedPlacementViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.managed_placement_view_service.transports",
    "MediaFileServiceClient": "google.ads.googleads.v7.services.services.media_file_service",
    "MediaFileServiceTransport": "google.ads.googleads.v7.services.services.media_file_service.transports",
    "MediaFileServiceGrpcTransport": "google.ads.googleads.v7.services.services.media_file_service.transports",
    "MerchantCenterLinkServiceClient": "google.ads.googleads.v7.services.services.merchant_center_link_service",
    "MerchantCenterLinkServiceTransport": "google.ads.googleads.v7.services.services.merchant_center_link_service.transports",
    "MerchantCenterLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.merchant_center_link_service.transports",
    "MobileAppCategoryConstantServiceClient": "google.ads.googleads.v7.services.services.mobile_app_category_constant_service",
    "MobileAppCategoryConstantServiceTransport": "google.ads.googleads.v7.services.services.mobile_app_category_constant_service.transports",
    "MobileAppCategoryConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.mobile_app_category_constant_service.transports",
    "MobileDeviceConstantServiceClient": "google.ads.googleads.v7.services.services.mobile_device_constant_service",
    "MobileDeviceConstantServiceTransport": "google.ads.googleads.v7.services.services.mobile_device_constant_service.transports",
    "MobileDeviceConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.mobile_device_constant_service.transports",
    "OfflineUserDataJobServiceClient": "google.ads.googleads.v7.services.services.offline_user_data_job_service",
    "OfflineUserDataJobServiceTransport": "google.ads.googleads.v7.services.services.offline_user_data_job_service.transports",
    "OfflineUserDataJobServiceGrpcTransport": "google.ads.googleads.v7.services.services.offline_user_data_job_service.transports",
    "OperatingSystemVersionConstantServiceClient": "google.ads.googleads.v7.services.services.operating_system_version_constant_service",
    "OperatingSystemVersionConstantServiceTransport": "google.ads.googleads.v7.services.services.operating_system_version_constant_service.transports",
    "OperatingSystemVersionConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.operating_system_version_constant_service.transports",
    "PaidOrganicSearchTermViewServiceClient": "google.ads.googleads.v7.services.services.paid_organic_search_term_view_service",
    "PaidOrganicSearchTermViewServiceTransport": "google.ads.googleads.v7.services.services.paid_organic_search_term_view_service.transports",
    "PaidOrganicSearchTermViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.paid_organic_search_term_view_service.transports",
    "ParentalStatusViewServiceClient": "google.ads.googleads.v7.services.services.parental_status_view_service",
    "ParentalStatusViewServiceTransport": "google.ads.googleads.v7.services.services.parental_status_view_service.transports",
    "ParentalStatusViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.parental_status_view_service.transports",
    "PaymentsAccountServiceClient": "google.ads.googleads.v7.services.services.payments_account_service",
    "PaymentsAccountServiceTransport": "google.ads.googleads.v7.services.services.payments_account_service.transports",
    "PaymentsAccountServiceGrpcTransport": "google.ads.googleads.v7.services.services.payments_account_service.transports",
    "ProductBiddingCategoryConstantServiceClient": "google.ads.googleads.v7.services.services.product_bidding_category_constant_service",
    "ProductBiddingCategoryConstantServiceTransport": "google.ads.googleads.v7.services.services.product_bidding_category_constant_service.transports",
    "ProductBiddingCategoryConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.product_bidding_category_constant_service.transports",
    "ProductGroupViewServiceClient": "google.ads.googleads.v7.services.services.product_group_view_service",
    "ProductGroupViewServiceTransport": "google.ads.googleads.v7.services.services.product_group_view_service.transports",
    "ProductGroupViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.product_group_view_service.transports",
    "ReachPlanServiceClient": "google.ads.googleads.v7.services.services.reach_plan_service",
    "ReachPlanServiceTransport": "google.ads.googleads.v7.services.services.reach_plan_service.transports",
    "ReachPlanServiceGrpcTransport": "google.ads.googleads.v7.services.services.reach_plan_service.transports",
    "RecommendationServiceClient": "google.ads.googleads.v7.services.services.recommendation_service",
    "RecommendationServiceTransport": "google.ads.googleads.v7.services.services.recommendation_service.transports",
    "RecommendationServiceGrpcTransport": "google.ads.googleads.v7.services.services.recommendation_service.transports",
    "RemarketingActionServiceClient": "google.ads.googleads.v7.services.services.remarketing_action_service",
    "RemarketingActionServiceTransport": "google.ads.googleads.v7.services.services.remarketing_action_service.transports",
    "RemarketingActionServiceGrpcTransport": "google.ads.googleads.v7.services.services.remarketing_action_service.transports",
    "SearchTermViewServiceClient": "google.ads.googleads.v7.services.services.search_term_view_service",
    "SearchTermViewServiceTransport": "google.ads.googleads.v7.services.services.search_term_view_service.transports",
    "SearchTermViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.search_term_view_service.transports",
    "SharedCriterionServiceClient": "google.ads.googleads.v7.services.services.shared_criterion_service",
    "SharedCriterionServiceTransport": "google.ads.googleads.v7.services.services.shared_criterion_service.transports",
    "SharedCriterionServiceGrpcTransport": "google.ads.googleads.v7.services.services.shared_criterion_service.transports",
    "SharedSetServiceClient": "google.ads.googleads.v7.services.services.shared_set_service",
    "SharedSetServiceTransport": "google.ads.googleads.v7.services.services.shared_set_service.transports",
    "SharedSetServiceGrpcTransport": "google.ads.googleads.v7.services.services.shared_set_service.transports",
    "ShoppingPerformanceViewServiceClient": "google.ads.googleads.v7.services.services.shopping_performance_view_service",
    "ShoppingPerformanceViewServiceTransport": "google.ads.googleads.v7.services.services.shopping_performance_view_service.transports",
    "ShoppingPerformanceViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.shopping_performance_view_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceClient": "google.ads.googleads.v7.services.services.third_party_app_analytics_link_service",
    "ThirdPartyAppAnalyticsLinkServiceTransport": "google.ads.googleads.v7.services.services.third_party_app_analytics_link_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceGrpcTransport": "google.ads.googleads.v7.services.services.third_party_app_analytics_link_service.transports",
    "TopicConstantServiceClient": "google.ads.googleads.v7.services.services.topic_constant_service",
    "TopicConstantServiceTransport": "google.ads.googleads.v7.services.services.topic_constant_service.transports",
    "TopicConstantServiceGrpcTransport": "google.ads.googleads.v7.services.services.topic_constant_service.transports",
    "TopicViewServiceClient": "google.ads.googleads.v7.services.services.topic_view_service",
    "TopicViewServiceTransport": "google.ads.googleads.v7.services.services.topic_view_service.transports",
    "TopicViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.topic_view_service.transports",
    "UserDataServiceClient": "google.ads.googleads.v7.services.services.user_data_service",
    "UserDataServiceTransport": "google.ads.googleads.v7.services.services.user_data_service.transports",
    "UserDataServiceGrpcTransport": "google.ads.googleads.v7.services.services.user_data_service.transports",
    "UserInterestServiceClient": "google.ads.googleads.v7.services.services.user_interest_service",
    "UserInterestServiceTransport": "google.ads.googleads.v7.services.services.user_interest_service.transports",
    "UserInterestServiceGrpcTransport": "google.ads.googleads.v7.services.services.user_interest_service.transports",
    "UserListServiceClient": "google.ads.googleads.v7.services.services.user_list_service",
    "UserListServiceTransport": "google.ads.googleads.v7.services.services.user_list_service.transports",
    "UserListServiceGrpcTransport": "google.ads.googleads.v7.services.services.user_list_service.transports",
    "UserLocationViewServiceClient": "google.ads.googleads.v7.services.services.user_location_view_service",
    "UserLocationViewServiceTransport": "google.ads.googleads.v7.services.services.user_location_view_service.transports",
    "UserLocationViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.user_location_view_service.transports",
    "VideoServiceClient": "google.ads.googleads.v7.services.services.video_service",
    "VideoServiceTransport": "google.ads.googleads.v7.services.services.video_service.transports",
    "VideoServiceGrpcTransport": "google.ads.googleads.v7.services.services.video_service.transports",
    "WebpageViewServiceClient": "google.ads.googleads.v7.services.services.webpage_view_service",
    "WebpageViewServiceTransport": "google.ads.googleads.v7.services.services.webpage_view_service.transports",
    "WebpageViewServiceGrpcTransport": "google.ads.googleads.v7.services.services.webpage_view_service.transports",
}


# Background on how this behaves: https://www.python.org/dev/peps/pep-0562/
def __getattr__(name):  # Requires Python >= 3.7
    if name == "__all__":
        all_names = globals()["__all__"] = sorted(_lazy_type_to_package_map)
        return all_names
    elif name in _lazy_type_to_package_map:
        module = importlib.import_module(f"{_lazy_type_to_package_map[name]}")
        klass = getattr(module, name)
        globals()[name] = klass
        return klass
    else:
        raise AttributeError(f"unknown type {name!r}.")


def __dir__():
    return globals().get("__all__") or __getattr__("__all__")
